﻿var B01 = "#0e6eb8";
var Gr02 = "#67727e";
var Gr03 = "#97a1ae";
var Gr05 = "#c7ced7";

var RADIX_DECIMAL_NUMBER = 10;

var I_FUNC_SETDT = 6;
var I_FUNC_INPRG = 28;
var I_FUNC_GTLST = 29;
var I_FUNC_STSRC = 30;
var I_FUNC_RELVI = 31;

var REQ_FUNC_GET_DATA = 1;
var REQ_FUNC_DTL_PROC_RUNIN = 21;
var REQ_FUNC_DTL_PROC_BURNBACK = 22;
var REQ_FUNC_DTL_PROC_WSTK_RESET = 23;
var REQ_FUNC_DTL_PROC_ON_THE_FLY = 24;
var REQ_FUNC_DTL_PROC_S2T_ST = 25;
var REQ_FUNC_DTL_PROC_S2T_ED = 26;
var REQ_FUNQ_DTL_SEQ_AS_PRE_TIME = 27;
var REQ_FUNQ_DTL_SEQ_GAS_PURGE = 28;
var REQ_FUNQ_DTL_SEQ_GAS_PREFLOW = 29;
var REQ_FUNQ_DTL_SEQ_AE_PRE_TIME = 30;
var REQ_FUNQ_DTL_SEQ_GAS_POSTFLOW = 31;
var REQ_FUNQ_DTL_SEQ_STRIKE_WFS = 32;
var REQ_FUNQ_DTL_SEQ_RAMP_ENABLE = 33;
var REQ_FUNQ_DTL_SEQ_WEAVE_SYNCH = 34;
var REQ_FUNQ_DTL_AMON_METHOD = 35;
var REQ_FUNQ_DTL_AMON_JDGMNT_CNDTN = 36;
var REQ_FUNQ_DTL_AMON_WLD_WRN = 37;
var REQ_FUNQ_DTL_AMON_WLD_STP = 38;
var REQ_FUNQ_DTL_AMON_CRTR_WRN = 39;
var REQ_FUNQ_DTL_AMON_CRTR_STP = 40;
var REQ_FUNQ_DTL_EQSETUP_SFI = 41;
var REQ_FUNQ_DTL_EQSETUP_SP = 42;
var REQ_FUNQ_DTL_EQSETUP_OTHER = 43;
var REQ_FUNC_DTL_PROC_TCRT = 44;
var REQ_FUNC_DTL_PROC_WPSTART = 45;
var REQ_FUNC_DTL_PROC_WPHEAT = 46;
var REQ_FUNC_DTL_PROC_ARCHET = 47;
var REQ_FUNC_DTL_PROC_TCRTST = 48;
var REQ_FUNC_DTL_PROC_TCRTMD = 49;


var XHR_READY_STATE_COMPLETE = 4;
var XHR_STATUS_OK = 200;
var XHR_STATUS_REDIRECT = 300;
var XHR_STATUS_NOT_MODIFIED = 304;

var PS_LINCOLN = 1;
var PS_FRONIUS_TPSI = 2;
var PS_FANUC = 3;
var PS_DAIHEN = 4;
var PS_GP_STD = 5;
var PS_GP_DGCS = 6;
var PS_SFR = 7;

var INTERNAL_MODE = 1;
var SPECIAL_TWO_STEP = 2;
var JOB_MODE = 3;

var I_TEST_MD_NO = 999;

var REAL_VAL_ERR_DIGIT = 3;

var INTEGER_MIN = -2147483648;
var INTEGER_MAX = 2147483646;

var KEY_CODE_ENTER = 13;

var WELD_PROCESS_TAB = 2;
var SEQUENCE_TAB = 3;
var ARC_MONITOR_TAB = 4;
var SCALING_TAB = 5;

var TREE_OFFSET = 1;
var TREE_WEAVE = 2;
var TREE_TRACK = 3;

var HELP_STTS_NONE = 0;
var HELP_STTS_DISP = 1;
var HELP_STTS_COMP = 2;
var HELP_STTS_EXIT = 3;

var WELD_SIGNAL_VOLTAGE = 1;
var WELD_SIGNAL_WIRE_SPEED = 2;
var WELD_SIGNAL_CURRENT = 3;
var WELD_SIGNAL_VOLTAGE_CONTROL = 7;
var WELD_SIGNAL_WAVE_CONTROL = 8;
var WELD_SIGNAL_EN_RATIO = 11;
var WELD_SIGNAL_JOB_NUMBER = 12;

var WS_VOLTS_L = 11;
var WS_VOLTS_R = 12;
var WS_WFS_L = 13;
var WS_WFS_R = 14;
var WS_AMPS_L = 15;
var WS_AMPS_R = 16;
var WS_PKAMPSL = 17;
var WS_PKAMPSR = 18;
var WS_FREQ_L = 19;
var WS_FREQ_R = 20;
var WS_PULSE_L = 21;
var WS_PULSE_R = 22;
var WS_PLS_FRQ = 23;
var WS_PLS_DTY = 24;

var HEATWAVE_OPTN_NOT_EXIST = 0;
var HTWV_NONE = 1;
var HTWV_STEP_WEAVING = 2;
var HTWV_RAMP_WEAVING = 3;
var HTWV_PULSE = 4;

var R551_OPT_FLG = 2;

var METHOD_DIFF_PERCENT = 1;

var HELP_WLD_SCHDL = 2;
var HELP_WLD_CMMND1 = 5;
var HELP_WLD_CMMND2 = 6;
var HELP_WLD_CMMND3 = 7;
var HELP_WLD_CMMND4 = 8;
var HELP_WLD_CMMND5 = 9;
var HELP_WLD_CMMND6 = 10;
var HELP_TRVL_SPD = 11;
var HELP_DLY_TM = 12;
var HELP_RMP_MD = 13;
var HELP_HTWV = 14;
var HELP_OFFSTS = 15;
var HELP_X = 17;
var HELP_Y = 18;
var HELP_Z = 19;
var HELP_WRK_ANGLE = 20;
var HELP_TRVL_ANGLE = 21;
var HELP_WV = 22;
var HELP_WVPTTRN = 24;
var HELP_FRQNCY = 25;
var HELP_AMPLTD = 26;
var HELP_RGHT_DWLL = 27;
var HELP_LFT_DWLL = 28;
var HELP_L_PTTRN_ANGL = 29;
var HELP_ELVTN = 30;
var HELP_AZMTH = 31;
var HELP_CNTR_RS = 32;
var HELP_RDS = 33;
var HELP_TRCK = 34;
var HELP_THRT = 37;
var HELP_THR = 38;
var HELP_LTRL_BS = 39;
var HELP_VRTCL_BS = 40;
var HELP_RNN_SCHDL = 57;
var HELP_RNN_TM = 65;
var HELP_BB_SCHDL = 66;
var HELP_BB_TM = 74;
var HELP_WR_SCHDL = 75;
var HELP_WR_TIMES = 77;
var HELP_WR_TM = 84;
var HELP_OTF_SCHDL = 85;
var HELP_OTF_SPD = 92;
var HELP_ARC_MNTR = 93;
var HELP_MNTRNG_MTHD = 96;
var HELP_MNTRNG_DLY_TM = 97;
var HELP_CRTRFLL_MNTR = 98;
var HELP_WRN_STP_TM = 100;
var HELP_WRN_STP_CNT = 101;
var HELP_WLDNG_WRN = 103;
var HELP_WLDNG_STP = 104;
var HELP_CRTR_WRN = 105;
var HELP_CRTR_STP = 106;
var HELP_SCLNG = 107;
var HELP_SCLNG_STUP = 109;
var HELP_CMMND = 110;
var HELP_MSRD = 111;
var HELP_HW_ONOFF = 112;
var HELP_GAS_PGTM = 113;
var HELP_GAS_PFTM = 114;
var HELP_GAS_PTFTM = 115;
var HELP_AS_PTM = 116;
var HELP_AE_PTM = 117;
var HELP_WF_SPD = 118;
var HELP_RMP_ONOFF = 119;
var HELP_RPM_BFFR = 121;
var HELP_ADJST_DLY_TM = 122;
var HELP_GAIN = 124;
var HELP_DD_BND = 125;
var HELP_MXMM_OFFST = 126;
var HELP_MXMM_PR_CYCL = 127;
var HELP_TRCKNG_STRT_CYCL = 128;
var HELP_SMPL_STRT_CYCL = 129;
var HELP_NMBR_OF_SMPL_CYCLS = 130;
var HELP_SMPLNG_TM = 131;
var HELP_OFFST_FRM = 132;
var HELP_TOUCH_RTCT = 260;
var HELP_TOUCH_RTCT_MODE = 261;
var HELP_WPSTART = 262;
var HELP_WPSTART_AMPS = 263;
var HELP_WIREHEAT = 265;
var HELP_WIREHEAT_AMPS = 266;
var HELP_WIREHEAT_TIME = 267;
var HELP_WIREHEAT_WFS = 268;
var HELP_ACHEAT = 270;
var HELP_ACHEAT_AMPS = 271;
var HELP_ACHEAT_TIME = 272;
var HELP_ACHEAT_WFS = 273;

var set_load_mode = 1;
var set_weldsched_mode = 2;
var set_offset_mode = 3;
var set_weaving_mode = 4;
var set_tracking_mode = 5;
var mod_weld_sch_mode = 6;

var comment_sp = "&nbsp;&nbsp;&nbsp;";

var request_func_num;
var request_func_detail_num;
var touch_op_status = 1;
var dict_status;
var select_back;
var select_mode;

function focus_elements(txt_obj) {
  txt_obj.select();
}

function only_numeric(txt_obj) {
  var str = txt_obj.value;
  if(str.match(/[^0-9-.]+/)){
    txt_obj.value = str.replace(/[^0-9.]+/g,"");
  }
}

function open_dropdown(translucent_screen_id, dropdown_list_id) {
  var dropdown_list = document.getElementById(dropdown_list_id);
  document.getElementById(translucent_screen_id).style.display = "block";
  dropdown_list.style.display = "block";
  dropdown_list.focus();
}

function close_dropdown(translucent_screen_id, dropdown_list_id, dropdown_box_id) {
  document.getElementById(dropdown_list_id).style.display = "none";
  document.getElementById(translucent_screen_id).style.display = "none";
  document.getElementById(dropdown_box_id).focus();
}

function is_integer(input_value) {
  if (input_value.search(/^[-]?[0-9]+$/) == 0) {
    return true;
  } else {
    return false;
  }
}

function get_cmd_display_value(weld_signal) {
  var display_value = "";
  switch (parseInt(weld_signal, RADIX_DECIMAL_NUMBER)) {
    case WELD_SIGNAL_VOLTAGE:
    case WELD_SIGNAL_WIRE_SPEED:
    case WELD_SIGNAL_CURRENT:
    case WELD_SIGNAL_VOLTAGE_CONTROL:
    case WELD_SIGNAL_WAVE_CONTROL:
    case WELD_SIGNAL_EN_RATIO:
    case WELD_SIGNAL_JOB_NUMBER:
      display_value = "inline";
      break;
    default:
      display_value = "none";
      break;
  }
  return display_value;
}

function run_set_data() {
  if (func_name != null) {
    if (func_param1 == '') {
      func_name();
    } else if (func_param2 == '') {
      func_name(func_param1);
    } else if (func_param3 == '') {
      func_name(func_param1, func_param2);
    } else if (func_param4 == '') {
      func_name(func_param1, func_param2, func_param3);
    } else {
      func_name(func_param1, func_param2, func_param3, func_param4);
    }
    tmp_value = focus_element_obj.value;
  }
}

function set_weld_data() {
  run_set_data();
  func_name = null;
  func_param1 = '';
  func_param2 = '';
  func_param3 = '';
  func_param4 = '';
}

function display_help(help_number) {
  window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=27&s_help_num=" + help_number;
}

function get_node_value(tag_name) {
  return (node_data[0].getElementsByTagName(tag_name)[0].firstChild.nodeValue);
}

function check_numerical_value(input_value) {
  var result_value = true;
  if (isFinite(input_value) == false) {
    result_value = false;
  }
  return result_value;
}

function set_elem(txt_obj, set_fanc_name, set_fanc_param1, set_fanc_param2, set_fanc_param3, set_fanc_param4) {
  document.getElementById("message_box").innerHTML = "";
  tmp_value = txt_obj.value;
  focus_element_obj = txt_obj;
  focus_elements(txt_obj);

  func_name = set_fanc_name;
  func_param1 = set_fanc_param1;
  func_param2 = set_fanc_param2;
  func_param3 = set_fanc_param3;
  func_param4 = set_fanc_param4;
}

function set_elem_drpdwn(txt_obj) {
  var err_message = document.getElementById("message_box");
  if (dropdown_message == "") {
    err_message.innerHTML = "";
  } else {
    err_message.innerHTML = dropdown_message;
  }
  dropdown_message = "";
  focus_elements(txt_obj);
}

function request_karel(func_mode, func_detail) {
  request_func_num = func_mode;
  request_func_detail_num = func_detail;
  prg_req.onreadystatechange = chk_ready_st_chg_karel;
  prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=" + func_mode + "&s_func_det=" + func_detail, true);
  prg_req.send();
}

function set_val_items(kl_var_name, id_name, sch_flg, min_val, max_val, digit_num, set_datano) {
  var current_val = document.getElementById(id_name).value;
  if (current_val < parseFloat(min_val)) {
    current_val = min_val;
  } else if (current_val > parseFloat(max_val)) {
    current_val = max_val;
  }
  document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);

  if (sch_flg == 1) {
    set_sch_data(kl_var_name, id_name, treeSelectNum);
  } else {
    set_aw_data(kl_var_name, id_name, treeSelectNum, set_datano);
  }
}

function set_process_select_mode() {
  var mode_elem = document.getElementById("process_select_mode_val");
  var err_message = document.getElementById("message_box");
  if ( (mode_elem.value < 0) || (mode_elem.value > 65535) || (check_numerical_value(mode_elem.value) == false)) {
    err_message.innerHTML = get_prct_dict_text(331) + " (0,65535)";
    mode_elem.value = tmp_value;
  } else {
    err_message.innerHTML = "";
    window.location.href = "/KARELCMD/AWPRWRT?s_sel_tab=0&s_scrn_int=" + mode_elem.value;
  }
}

function set_val_offset(setOffVal) {
  var i_min_offset_direction = -99.9;
  var i_max_offset_direction = 99.9;
  var i_min_angle = -180;
  var i_max_angle = 180;

  switch (setOffVal) {
    case 1:
      validate_check("txt_offset_x", i_min_offset_direction, i_max_offset_direction);
      set_val_items('s_ofst_x[' + offset_num + ']', 'txt_offset_x', 0, i_min_offset_direction, i_max_offset_direction, 1, setOffVal);
      break;
    case 2:
      validate_check("txt_offset_y", i_min_offset_direction, i_max_offset_direction);
      set_val_items('s_ofst_y[' + offset_num + ']', 'txt_offset_y', 0, i_min_offset_direction, i_max_offset_direction, 1, setOffVal);
      break;
    case 3:
      validate_check("txt_offset_z", i_min_offset_direction, i_max_offset_direction);
      set_val_items('s_ofst_z[' + offset_num + ']', 'txt_offset_z', 0, i_min_offset_direction, i_max_offset_direction, 1, setOffVal);
      break;
    case 4:
      validate_check("txt_work_angle", i_min_angle, i_max_angle);
      set_val_items('s_ofst_wa[' + offset_num + ']', 'txt_work_angle', 0, i_min_angle, i_max_angle, 1, setOffVal);
      break;
    case 5:
      validate_check("txt_travel_angle", i_min_angle, i_max_angle);
      set_val_items('s_ofst_ta[' + offset_num + ']', 'txt_travel_angle', 0, i_min_angle, i_max_angle, 1, setOffVal);
      break;
    default:
      break;
  }
}

function get_offset_rght_scrn() {
  var offset_tbl ="";
  offset_tbl += "<table id=\"offset_table\" align=\"center\">";
  offset_tbl += "<tr>";
  offset_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(60) + "</td>";
  offset_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  offset_tbl += "<input id=\"select_offset_mode\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(3)\">";
  offset_tbl += "</td>";
  offset_tbl += "</tr>";
  offset_tbl += "<tr>";
  offset_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(61) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_X + ")\"></span></td>";
  offset_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_offset_x";
  offset_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_offset, 1, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  offset_tbl += "<td class=\"item_base unit_table\">mm</td>";
  offset_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  offset_tbl += "</tr>";
  offset_tbl += "<tr>";
  offset_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(62) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_Y + ")\"></span></td>";
  offset_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_offset_y";
  offset_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_offset, 2, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  offset_tbl += "<td class=\"item_base unit_table\">mm</td>";
  offset_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  offset_tbl += "</tr>";
  offset_tbl += "<tr>";
  offset_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(63) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_Z + ")\"></span></td>";
  offset_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_offset_z";
  offset_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_offset, 3, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  offset_tbl += "<td class=\"item_base unit_table\">mm</td>";
  offset_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  offset_tbl += "</tr>";
  offset_tbl += "<tr>";
  offset_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(131) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_WRK_ANGLE + ")\"></span></td>";
  offset_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_work_angle";
  offset_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_offset, 4, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  offset_tbl += "<td class=\"item_base unit_table\">deg</td>";
  offset_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  offset_tbl += "</tr>";
  offset_tbl += "<tr>";
  offset_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(132) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_TRVL_ANGLE + ")\"></span></td>";
  offset_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_travel_angle";
  offset_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_offset, 5, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  offset_tbl += "<td class=\"item_base unit_table\">deg</td>";
  offset_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  offset_tbl += "</tr>";
  offset_tbl += "</table>";

  return offset_tbl;
}

function set_offset_area(xml_doc_data) {
  var offset_area = document.getElementById("right_screen");
  offset_area.innerHTML = "";
  offset_area.innerHTML = get_offset_rght_scrn();

  var i_offset_mode = document.getElementById("select_offset_mode");
  node_data = xml_doc_data.getElementsByTagName("weldSchedules")[0].getElementsByTagName("offset");
  var i_get_offset_mode = get_node_value("offsetMode" + offset_num);
  if (i_get_offset_mode == 1) {
    i_offset_mode.value = get_prct_dict_text(149);
  } else if (i_get_offset_mode == 2) {
    i_offset_mode.value = get_prct_dict_text(150);
  } else if (i_get_offset_mode == 3) {
    i_offset_mode.value = get_prct_dict_text(151);
  }
  document.getElementById("txt_offset_x").value = get_node_value("offsetX" + offset_num);
  document.getElementById("txt_offset_y").value = get_node_value("offsetY" + offset_num);
  document.getElementById("txt_offset_z").value = get_node_value("offsetZ" + offset_num);
  document.getElementById("txt_work_angle").value = get_node_value("workAngle" + offset_num);
  document.getElementById("txt_travel_angle").value = get_node_value("travelAngle" + offset_num);
}

function set_val_weaving(setWeaveVal) {
  var i_min_offset_direction = -99.9;
  var i_max_offset_direction = 99.9;
  var i_min_dwell = 0;
  var i_max_dwell = 32.767;
  var i_min_l_angle = 0;
  var i_max_l_angle = 360;
  var i_min_elevation = -90;
  var i_max_elevation = 90;
  var i_min_center_rise = -25;
  var i_max_center_rise = 25;
  var i_min_radius = 0;
  var i_max_radius = 25;

  switch (setWeaveVal) {
    case 1:
      validate_check("txt_weave_frequency", i_min_offset_direction, i_max_offset_direction);
      set_val_items('s_wv_freq[' + weaving_num + ']', 'txt_weave_frequency', 0, i_min_offset_direction, i_max_offset_direction, 1, setWeaveVal);
      break;
    case 2:
      validate_check("txt_weave_amplitude", i_min_offset_direction, i_max_offset_direction);
      set_val_items('s_amplitude[' + weaving_num + ']', 'txt_weave_amplitude', 0, i_min_offset_direction, i_max_offset_direction, 1, setWeaveVal);
      break;
    case 3:
      validate_check("txt_weave_right_dwell", i_min_dwell, i_max_dwell);
      set_val_items('s_right_d[' + weaving_num + ']', 'txt_weave_right_dwell', 0, i_min_dwell, i_max_dwell, 3, setWeaveVal);
      break;
    case 4:
      validate_check("txt_weave_left_dwell", i_min_dwell, i_max_dwell);
      set_val_items('s_left_d[' + weaving_num + ']', 'txt_weave_left_dwell', 0, i_min_dwell, i_max_dwell, 3, setWeaveVal);
      break;
    case 5:
      validate_check("txt_weave_l_pattern_angle", i_min_l_angle, i_max_l_angle);
      set_val_items('s_l_angle[' + weaving_num + ']', 'txt_weave_l_pattern_angle', 0, i_min_l_angle, i_max_l_angle, 1, setWeaveVal);
      break;
    case 6:
      validate_check("txt_weave_elevation", i_min_elevation, i_max_elevation);
      set_val_items('s_elevation[' + weaving_num + ']', 'txt_weave_elevation', 0, i_min_elevation, i_max_elevation, 0, setWeaveVal);
      break;
    case 7:
      validate_check("txt_weave_azimuth", i_min_elevation, i_max_elevation);
      set_val_items('s_azimuth[' + weaving_num + ']', 'txt_weave_azimuth', 0, i_min_elevation, i_max_elevation, 0, setWeaveVal);
      break;
    case 8:
      validate_check("txt_weave_center_rise", i_min_center_rise, i_max_center_rise);
      set_val_items('s_c_rise[' + weaving_num + ']', 'txt_weave_center_rise', 0, i_min_center_rise, i_max_center_rise, 1, setWeaveVal);
      break;
    case 9:
      validate_check("txt_weave_radius", i_min_radius, i_max_radius);
      set_val_items('s_radius[' + weaving_num + ']', 'txt_weave_radius', 0, i_min_radius, i_max_radius, 1, setWeaveVal);
      break;
    default:
      break;
  }
}

function get_weaving_rght_scrn() {
  var weav_tbl ="";
  weav_tbl += "<table id=\"weaving_table\" align=\"center\">";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(43) + "</td>";
  weav_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  weav_tbl += "<input id=\"select_weaving\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(4)\">";
  weav_tbl += "</td>";
  weav_tbl += "<tbody id=\"weaving_enable_screen\">";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(133) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_WVPTTRN + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  weav_tbl += "<input id=\"select_weave_pattern\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(5)\">";
  weav_tbl += "</td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(134) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_FRQNCY + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_frequency";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 1, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">Hz</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(135) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_AMPLTD + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_amplitude";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 2, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">mm</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(136) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_RGHT_DWLL + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_right_dwell";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 3, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">sec</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(137) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_LFT_DWLL + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_left_dwell";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 4, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">sec</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(138) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_L_PTTRN_ANGL + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_l_pattern_angle";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 5, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">deg</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(139) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_ELVTN + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_elevation";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 6, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">deg</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(140) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_AZMTH + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_azimuth";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 7, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">deg</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(141) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_CNTR_RS + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_center_rise";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 8, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">mm</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "<tr>";
  weav_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(142) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_RDS + ")\"></span></td>";
  weav_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_weave_radius";
  weav_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weaving, 9, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  weav_tbl += "<td class=\"item_base unit_table\">mm</td>";
  weav_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  weav_tbl += "</tr>";
  weav_tbl += "</tbody>";
  weav_tbl += "</table>";
  return weav_tbl;
}

function set_weaving_area(xml_doc_data) {
  var weaving_area = document.getElementById("right_screen");
  weaving_area.innerHTML = "";
  weaving_area.innerHTML = get_weaving_rght_scrn();

  var i_weaving = document.getElementById("select_weaving");
  var disp_weaving = document.getElementById("weaving_enable_screen");
  node_data = xml_doc_data.getElementsByTagName("weldSchedules")[0].getElementsByTagName("weaving");
  var i_get_weaving_mode = get_node_value("weavingMode" + weaving_num);
  if (i_get_weaving_mode == 0) {
    i_weaving.value = get_prct_dict_text(58);
    disp_weaving.style.visibility = "visible";
  } else {
    i_weaving.value = get_prct_dict_text(59);
    disp_weaving.style.visibility = "hidden";
  }

  var i_get_weave_pattern = get_node_value("weavingPattern" + weaving_num);
  var i_weaving_pattern = document.getElementById("select_weave_pattern");
  if (i_get_weave_pattern == 1) {
    i_weaving_pattern.value = get_prct_dict_text(152);
  } else if (i_get_weave_pattern == 2) {
    i_weaving_pattern.value = get_prct_dict_text(153);
  } else if (i_get_weave_pattern == 3) {
    i_weaving_pattern.value = get_prct_dict_text(154);
  } else if (i_get_weave_pattern == 4) {
    i_weaving_pattern.value = get_prct_dict_text(155);
  } else if (i_get_weave_pattern == 5) {
    i_weaving_pattern.value = get_prct_dict_text(156);
  } else if (i_get_weave_pattern == 6) {
    i_weaving_pattern.value = get_prct_dict_text(157);
  }

  document.getElementById("txt_weave_frequency").value = get_node_value("frequency" + weaving_num);
  document.getElementById("txt_weave_amplitude").value = get_node_value("amplitude" + weaving_num);
  document.getElementById("txt_weave_right_dwell").value = get_node_value("rightDwell" + weaving_num);
  document.getElementById("txt_weave_left_dwell").value = get_node_value("leftDwell" + weaving_num);
  document.getElementById("txt_weave_l_pattern_angle").value = get_node_value("lAngle" + weaving_num);
  document.getElementById("txt_weave_elevation").value = parseInt(get_node_value("elevation" + weaving_num), 10);
  document.getElementById("txt_weave_azimuth").value = parseInt(get_node_value("azimuth" + weaving_num), 10);
  document.getElementById("txt_weave_center_rise").value = get_node_value("centerRise" + weaving_num);
  document.getElementById("txt_weave_radius").value = get_node_value("radius" + weaving_num);
}

function get_tracking_rght_scrn() {
  var track_tbl ="";
  track_tbl += "<table id=\"tracking_table\" align=\"center\" class=\"r_wscreen\">";
  track_tbl += "<tr>";
  track_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(143) + "</td>";
  track_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  track_tbl += "<input id=\"select_tracking_mode\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(6)\">";
  track_tbl += "</td>";
  track_tbl += "</tr>";
  track_tbl += "<tr>";
  track_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(144) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_THRT + ")\"></span></td>";
  track_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  track_tbl += "<input id=\"select_torch_type\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(7)\">";
  track_tbl += "</td>";
  track_tbl += "</tr>";
  track_tbl += "<tr>";
  track_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(145) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_THR + ")\"></span></td>";
  track_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_torch_height_ref";
  track_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_tracking, 1, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  track_tbl += "<td class=\"item_base unit_table\">Amps</td>";
  track_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  track_tbl += "</tr>";
  track_tbl += "<tr>";
  track_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(146) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_LTRL_BS + ")\"></span></td>";
  track_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_lateral_bias_r";
  track_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_tracking, 2, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  track_tbl += "<td class=\"item_base unit_table\">%</td>";
  track_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  track_tbl += "</tr>";
  track_tbl += "<tr>";
  track_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(147) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_VRTCL_BS + ")\"></span></td>";
  track_tbl += "<td class=\"item_base txtbox_table\"><input id=\"txt_lateral_bias_u";
  track_tbl +=  "\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_tracking, 3, '', '', '')\" onKeyup=\"only_numeric(this)\"></td>";
  track_tbl += "<td class=\"item_base unit_table\">%</td>";
  track_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\";></td>";
  track_tbl += "</tr>";
  track_tbl += "</table>";
  return track_tbl;
}

function set_val_tracking(setTrackVal) {
  var i_min_torch_height = 0;
  var i_max_torch_height = 9999.9;
  var i_min_bias = -99.9;
  var i_max_bias = 99.9;

  switch (setTrackVal) {
    case 1:
      validate_check("txt_torch_height_ref", i_min_torch_height, i_max_torch_height);
      set_val_items('s_torch_hr[' + tracking_num + ']' , 'txt_torch_height_ref', 0, i_min_torch_height, i_max_torch_height, 1, setTrackVal);
      break;
    case 2:
      validate_check("txt_lateral_bias_r", i_min_bias, i_max_bias);
      set_val_items('s_l_bias[' + tracking_num + ']' , 'txt_lateral_bias_r', 0, i_min_bias, i_max_bias, 1, setTrackVal);
      break;
    case 3:
      validate_check("txt_lateral_bias_u", i_min_bias, i_max_bias);
      set_val_items('s_v_bias[' + tracking_num + ']' , 'txt_lateral_bias_u', 0, i_min_bias, i_max_bias, 1, setTrackVal);
      break;
    default:
      break;
  }
}

function set_tracking_area(xml_doc_data) {
  var weaving_area = document.getElementById("right_screen");
  weaving_area.innerHTML = "";
  weaving_area.innerHTML = get_tracking_rght_scrn();

  var i_tracking_mode = document.getElementById("select_tracking_mode");
  var i_torch_type = document.getElementById("select_torch_type");

  node_data = xml_doc_data.getElementsByTagName("weldSchedules")[0].getElementsByTagName("tracking");
  var i_get_tracking = get_node_value("trackingMode" + tracking_num);
  if (i_get_tracking == 1) {
    i_tracking_mode.value = get_prct_dict_text(158);
  } else if (i_get_tracking == 2) {
    i_tracking_mode.value = get_prct_dict_text(159);
  } else if (i_get_tracking == 3) {
    i_tracking_mode.value = get_prct_dict_text(160);
  }

  var i_get_torchtype = get_node_value("torchHeightType" + tracking_num);
  if (i_get_torchtype == 0) {
    i_torch_type.value = get_prct_dict_text(161);
  } else {
    i_torch_type.value = get_prct_dict_text(162);
  }

  document.getElementById("txt_torch_height_ref").value = get_node_value("torchHeightRef" + tracking_num);
  document.getElementById("txt_lateral_bias_r").value = get_node_value("lateralBias" + tracking_num);
  document.getElementById("txt_lateral_bias_u").value = get_node_value("verticalBias" + tracking_num);
}

function chkReadyStateChgXML() {
  if (xml_req.readyState == 4) {
    if ( ( (200 <= xml_req.status) && (xml_req.status < 300) ) || (xml_req.status == 304) ) {
      var right_scrn = document.getElementById("right_screen");
      right_scrn.scrollTop = 0;
      switch (set_mode) {
        case set_weldsched_mode:
          right_scrn.innerHTML = "";
          right_scrn.innerHTML = get_weld_sch_rght_scrn();
          set_weld_sch_scrn_items_val(xml_req.responseXML, selected_sch_num);
          node_data = xml_req.responseXML.getElementsByTagName("awdata")[0].getElementsByTagName("helpValues");
          help_stts = parseInt(get_node_value("s_help_stts"), RADIX_DECIMAL_NUMBER);
          xml_req.abort();
          switch (help_stts) {
            case HELP_STTS_NONE:
              var s_hlp_tm_dsp = 0;
              if (document.getElementById("treemenu" + treeSelectNum).style.display == "none") {
                s_hlp_tm_dsp = 0;
              } else {
                s_hlp_tm_dsp = 1;
              }
              window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_sch_tr=" + selected_sch_num + "&s_hlp_tm_dsp=" + s_hlp_tm_dsp + "&s_hlp_tm_typ=0";
              break;
            case HELP_STTS_EXIT:
              window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_help_num=0&s_help_stts=0";
              help_stts = HELP_STTS_NONE;
              break;
            default:
              window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_help_stts=" + HELP_STTS_COMP;
              help_stts = HELP_STTS_COMP;
              break;
          }
          break;
        case set_offset_mode:
          set_offset_area(xml_req.responseXML);
          xml_req.abort();
          if (help_stts >= HELP_STTS_DISP) {
            set_help_status_afterproc();
          }
          break;
        case set_weaving_mode:
          set_weaving_area(xml_req.responseXML);
          xml_req.abort();
          if (help_stts >= HELP_STTS_DISP) {
            set_help_status_afterproc();
          }
          break;
        case set_tracking_mode:
          set_tracking_area(xml_req.responseXML);
          xml_req.abort();
          if (help_stts >= HELP_STTS_DISP) {
            set_help_status_afterproc();
          }
          break;
        default:
          xml_req.abort();
          break;
      }
    }
  }
}

function getXmlData() {
  xml_req.onreadystatechange = chkReadyStateChgXML;
  xml_req.open("GET", "/TD/AWPRRESP.XML?" + Math.random(), true);
  xml_req.send();
}

function chkReadyStateChgOfst() {
  if (prg_req.readyState == 4) {
    if ( ( (200 <= prg_req.status) && (prg_req.status < 300) ) || (prg_req.status == 304)) {
      prg_req.abort();
      set_mode = set_offset_mode;
      getXmlData();
    } else {
      prg_req.abort();
    }
  }
}

function getOfstData(weld_number) {
  prg_req.onreadystatechange = chkReadyStateChgOfst;
  if (help_stts == HELP_STTS_NONE) {
    prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=3&s_ws_number=" + weld_number + "&s_hlp_tm_typ=" + TREE_OFFSET, true);
  } else {
    prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=3&s_ws_number=" + weld_number, true);
  }
  prg_req.send();
}

function showOffset(weldNum) {
  getOfstData(weldNum);
  offset_num = weldNum;
  open_tab_no = 2;

  for (var i = 1; i <= weldNum; i++){
    offset_no = document.getElementById("offset_item" + i);
    if (weldNum == i) {
      offset_no.style.backgroundColor = B01;
      document.getElementById("weaving_item" + i).style.backgroundColor = Gr02;
      document.getElementById("tracking_item" + i).style.backgroundColor = Gr02;
    } else {
      offset_no.style.backgroundColor = Gr02;
    }
  }
}

function chkReadyStateChgWeave() {
  if (prg_req.readyState == 4) {
    if ( ( (200 <= prg_req.status) && (prg_req.status < 300) ) || (prg_req.status == 304) ) {
      prg_req.abort();
      set_mode = set_weaving_mode;
      getXmlData();
    } else {
      prg_req.abort();
    }
  }
}

function getWeavingData(weave_number) {
  prg_req.onreadystatechange = chkReadyStateChgWeave;
  if (help_stts == HELP_STTS_NONE) {
    prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=4&s_ws_number=" + weave_number + "&s_hlp_tm_typ=" + TREE_WEAVE, true);
  } else {
    prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=4&s_ws_number=" + weave_number, true);
  }
  prg_req.send();
}

function showWeaving(weaveNum) {
  getWeavingData(weaveNum);
  weaving_num = weaveNum;
  open_tab_no = 3;

  for (var i = 1; i <= weaveNum; i++) {
    weaving_no = document.getElementById("weaving_item" + i);

    if (weaveNum == i) {
      document.getElementById("offset_item" + i).style.backgroundColor = Gr02;
      weaving_no.style.backgroundColor = B01;
      document.getElementById("tracking_item" + i).style.backgroundColor = Gr02;
    } else {
      weaving_no.style.backgroundColor = Gr02;
    }
  }
}

function chkReadyStateChgTracking() {
  if (prg_req.readyState == 4) {
    if ( ( (200 <= prg_req.status) && (prg_req.status < 300) ) || (prg_req.status == 304) ) {
      prg_req.abort();
      set_mode = set_tracking_mode;
      getXmlData();
    } else {
      prg_req.abort();
    }
  }
}

function getTrackingData(traking_number) {
  prg_req.onreadystatechange = chkReadyStateChgTracking;
  if (help_stts == HELP_STTS_NONE) {
    prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=5&s_ws_number=" + traking_number + "&s_hlp_tm_typ=" + TREE_TRACK, true);
  } else {
    prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=5&s_ws_number=" + traking_number, true);
  }
  prg_req.send();
}

function showTracking(trackingNum) {
  getTrackingData(trackingNum);
  tracking_num = trackingNum;
  open_tab_no = 4;

  for (var i = 1; i <= trackingNum; i++){
    tracking_no = document.getElementById("tracking_item" + i);

    if (trackingNum == i) {
      tracking_no.style.backgroundColor = B01;
      document.getElementById("offset_item" + i).style.backgroundColor = Gr02;
      document.getElementById("weaving_item" + i).style.backgroundColor = Gr02;
    } else {
      tracking_no.style.backgroundColor = Gr02;
    }
  }
}

function up_button_change() {
  var img = new Image();
  img.src = "btn_up.png";
  i_click_up.src = img.src;
  i_click_up = "";
}

function down_button_change() {
  var img = new Image();
  img.src = "btn_down.png";
  i_click_up.src = img.src;
  i_click_up = "";
}

function check_button_status() {
  if (i_click_up != "") {
    clearTimeout(click_up_id);
    if (is_up_button == true) {
      up_button_change();
    } else {
      down_button_change();
    }
  }
}

function set_dwn_button(button_id) {
  var img = new Image();
  img.src = "btn_seld.png";
  i_click_up = document.getElementById(button_id);
  i_click_up.src = img.src;
  is_up_button = false;
  click_up_id = setTimeout(down_button_change, 150);
}

function set_up_button(button_id) {
  var img = new Image();
  img.src = "btn_selu.png";
  i_click_up = document.getElementById(button_id);
  i_click_up.src = img.src;
  is_up_button = true;
  click_up_id = setTimeout(up_button_change, 150);
}

function set_value(sliderRange, newValue, valueObj, minValue, maxValue, sliderInsideId, numDigits) {
  var setVal = newValue;
  if (valueObj.value == "") {
    setVal = tmp_value;
  } else {
    if (sliderRange < 0) {
      sliderRange = 0;
      setVal = minValue;
    }
    else if (sliderRange > 100) {
      sliderRange = 100;
      setVal = maxValue;
    }
  }

  document.getElementById(sliderInsideId).style.width = Math.round(sliderRange) + "%";
  valueObj.value = parseFloat(setVal).toFixed(numDigits);
}

function tch_up_btn(valueId, increaseVal, minValue, maxValue, sliderInsideId, numDigits) {
  var valueObj = document.getElementById(valueId);
  var newValue = parseFloat(valueObj.value) + parseFloat(increaseVal);
  var sliderPercent = ((newValue - minValue) / (maxValue - minValue)) * 100;
  set_value(sliderPercent, newValue, valueObj, minValue, maxValue, sliderInsideId, numDigits);
}

function tch_dwn_btn(valueId, decreaseVal, minValue, maxValue, sliderInsideId, numDigits) {
  var valueObj = document.getElementById(valueId);
  var newValue = valueObj.value - decreaseVal;
  var sliderPercent = ((newValue - minValue) / (maxValue - minValue)) * 100;
  set_value(sliderPercent, newValue, valueObj, minValue, maxValue, sliderInsideId, numDigits);
}

function tch_dwn_weldsched(setWsTglVal) {
  check_button_status();
  set_dwn_button("btn_down" + setWsTglVal);

  switch (setWsTglVal) {
    case 1:
      tch_dwn_btn("txt_amps", 5, i_min_amps, i_max_amps, 'slg_inws_amps', voltage_cmd_format);
      set_sch_data('s_ws_volts[' + treeSelectNum + ']', 'txt_amps', treeSelectNum, setWsTglVal);
      break;
    case 2:
      tch_dwn_btn("txt_volts", 0.5, i_min_volts, i_max_volts, 'slg_inws_volts', wfs_cmd_format);
      set_sch_data('s_ws_wv_ctrl[' + treeSelectNum + ']', 'txt_volts', treeSelectNum, setWsTglVal);
      break;
    case 3:
      tch_dwn_btn("txt_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inws_wavecon', current_cmd_format);
      set_aw_data('s_ws_amps[' + treeSelectNum + ']', 'txt_wavecontrol', treeSelectNum, setWsTglVal);
      break;
    case 4:
      tch_dwn_btn("txt_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inws_pkamps', pk_curr_cmd_format);
      set_aw_data('s_ws_pkamps[' + treeSelectNum + ']', 'txt_pkamps', treeSelectNum, setWsTglVal);
      break;
    case 5:
      tch_dwn_btn("txt_freq", 0.5, i_min_freq, i_max_freq, 'slg_inws_freq', freq_cmd_format);
      set_aw_data('s_ws_freq[' + treeSelectNum + ']', 'txt_freq', treeSelectNum, setWsTglVal);
      break;
    case 6:
      tch_dwn_btn("txt_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inws_pulse', pulse_cmd_format);
      set_aw_data('s_ws_pulse[' + treeSelectNum + ']', 'txt_pulse', treeSelectNum, setWsTglVal);
      break;
    default:
      break;
  }
}

function tch_up_weldsched(setWsTglVal) {
  check_button_status();
  set_up_button("btn_up" + setWsTglVal);

  switch (setWsTglVal) {
    case 1:
      tch_up_btn("txt_amps", 5, i_min_amps, i_max_amps, 'slg_inws_amps', voltage_cmd_format);
      set_sch_data('s_ws_volts[' + treeSelectNum + ']', 'txt_amps', treeSelectNum, setWsTglVal);
      break;
    case 2:
      tch_up_btn("txt_volts", 0.5, i_min_volts, i_max_volts, 'slg_inws_volts', wfs_cmd_format);
      set_sch_data('s_ws_wv_ctrl[' + treeSelectNum + ']', 'txt_volts', treeSelectNum, setWsTglVal);
      break;
    case 3:
      tch_up_btn("txt_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inws_wavecon', current_cmd_format);
      set_aw_data('s_ws_amps[' + treeSelectNum + ']', 'txt_wavecontrol', treeSelectNum, setWsTglVal);
      break;
    case 4:
      tch_up_btn("txt_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inws_pkamps', pk_curr_cmd_format);
      set_aw_data('s_ws_pkamps[' + treeSelectNum + ']', 'txt_pkamps', treeSelectNum, setWsTglVal);
      break;
    case 5:
      tch_up_btn("txt_freq", 0.5, i_min_freq, i_max_freq, 'slg_inws_freq', freq_cmd_format);
      set_aw_data('s_ws_freq[' + treeSelectNum + ']', 'txt_freq', treeSelectNum, setWsTglVal);
      break;
    case 6:
      tch_up_btn("txt_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inws_pulse', pulse_cmd_format);
      set_aw_data('s_ws_pulse[' + treeSelectNum + ']', 'txt_pulse', treeSelectNum, setWsTglVal);
      break;
    default:
      break;
  }
}

function get_weld_sch_lft_scrn(xml_doc_data) {
  var cur_val;

  node_data = xml_doc_data.getElementsByTagName("multipass");
  i_multiview_flg = get_node_value("multiviewFlg");

  node_data = xml_doc_data.getElementsByTagName("weldNumSchedules");
  var weld_no = get_node_value("weldNumber");

  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  s_voltage_unit = get_node_value("volUnit");
  s_wfs_unit = get_node_value("wfsUnit");

  var sch_l_tbl = "<div id=\"left_screen\">";
  for(cur_val = 1; cur_val <= weld_no; cur_val++) {
    sch_l_tbl += "<table id=\"weldsched_item" + cur_val;
    sch_l_tbl += "\" class=\"c-not_slct_bg_color\" style=\"width: 320px; margin: 4px 0px 0px 0px; float:left;\" cellspacing=\"0\" cellpadding=\"0\" onclick=\"treeMenu(" + cur_val + ")\">";
    sch_l_tbl += "<tr>";
    sch_l_tbl += "<td id=\"tree_ricon" + cur_val;
    sch_l_tbl += "\" class=\"c-tree c-tree_txt c-not_slct_bg_color\" style=\"width: 40px; height: 30px; border-right: 3px solid #e7e7ef;";
    if (i_multiview_flg == 1) {
      sch_l_tbl += "\"";
    } else {
      sch_l_tbl += " display:none;\"";
    }
    sch_l_tbl += " align=\"center\" rowspan=\"2\"><img src=\"tree_off.png\"></td>";
    sch_l_tbl += "<td id=\"tree_bicon" + cur_val;
    sch_l_tbl += "\" class=\"c-tree c-tree_txt c-not_slct_bg_color\" style=\"width: 40px; height: 30px; display:none; border-right: 3px solid #e7e7ef;\" align=\"center\" rowspan=\"2\"><img src=\"tree_on.png\"></td>";
    node_data = xml_doc_data.getElementsByTagName("weldSchedules");
    sch_l_tbl += "<td class=\"c-tree\" style=\"width: 280px; height: 30px;\"><p style=\"margin-left: 15px; display: inline;\">" + get_node_value("wdcd_nm" + cur_val) + "</p>" + cur_val + "<sup class=\"c-asterisk\">*</sup>";
    sch_l_tbl += "</td>";
    sch_l_tbl += "</tr>";
    sch_l_tbl += "<tr>";
    sch_l_tbl += "<td id=\"weldschdisplay" + cur_val + "\" style=\"width: 280px; height: 30px;\">";
    sch_l_tbl += "<p class=\"weld_sch_display_cmd_volts\">" + get_node_value("volts" + cur_val) + s_voltage_unit + "</p>";
    sch_l_tbl += "<p class=\"weld_sch_display_cmd_wfs\">" + get_node_value("waveControl" + cur_val) + s_wfs_unit + "</p></td>";
    sch_l_tbl += "</tr>";
    sch_l_tbl += "</table>";
    sch_l_tbl += "<table cellspacing=\"0\" cellpadding=\"0\" style=\"margin: 4px 0px 0px 0px;\"><tr>";
    sch_l_tbl += "<td style=\"height:60px; width:28px; text-align:center;\"><div class=\"c-help_icon\" onclick=\"display_help(" + HELP_WLD_SCHDL + ")\"></div></td>";
    sch_l_tbl += "</tr></table>";
    sch_l_tbl += "<table id=\"treemenu" + cur_val + "\" style=\"width: 348px; display:none;\" cellspacing=\"0\" cellpadding=\"0\">";
    sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
    sch_l_tbl += "<tr id=\"offset_item" + cur_val + "\" class=\"c-not_slct_bg_color\">";
    sch_l_tbl += "<td class=\"c-tree c-tree_txt\" style=\"background-color: #e7e7ef;\"></td>";
    sch_l_tbl += "<td class=\"c-tree c-tree_txt\">";
    sch_l_tbl += "<td class=\"c-tree\" style=\"width: 280px; height: 60px;\" onclick=\"showOffset(" + cur_val + ")\">" + get_prct_dict_text(42) + "</td>";
    sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(" + HELP_OFFSTS + ")\"></div></td>";
    sch_l_tbl += "</tr>";
    sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
    sch_l_tbl += "<tr id=\"weaving_item" + cur_val + "\" class=\"c-not_slct_bg_color\">";
    sch_l_tbl += "<td class=\"c-tree c-tree_txt\" style=\"background-color: #e7e7ef\"></td>";
    sch_l_tbl += "<td class=\"c-tree c-tree_txt\">";
    sch_l_tbl += "<td class=\"c-tree\" style=\"width: 280px; height: 60px;\" onclick=\"showWeaving(" + cur_val + ")\">" + get_prct_dict_text(43) + "</td>";
    sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(" + HELP_WV + ")\"></div></td>";
    sch_l_tbl += "</tr>";
    sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
    sch_l_tbl += "<tr id=\"tracking_item" + cur_val + "\" class=\"c-not_slct_bg_color\">";
    sch_l_tbl += "<td class=\"c-tree c-tree_txt\" style=\"background-color: #e7e7ef\"></td>";
    sch_l_tbl += "<td class=\"c-tree c-tree_txt\">";
    sch_l_tbl += "<td class=\"c-tree\" style=\"width: 280px; height: 60px;\" onclick=\"showTracking(" + cur_val + ")\">" + get_prct_dict_text(44) + "</td>";
    sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(" + HELP_TRCK + ")\"></div></td>";
    sch_l_tbl += "</tr>";
    sch_l_tbl += "</table>";
  }
  sch_l_tbl += "</div>";
  return sch_l_tbl;
}

function get_weld_sch_rght_scrn() {
  var sch_r_tbl = "<table id=\"weldschedule_table\" style=\display:block;\" align=\"center\">";
  sch_r_tbl += "<tr id=\"ws_title\" style=\"display: none;\">";
  sch_r_tbl += "<td></td>";
  sch_r_tbl += "<td><div id=\"ws_title1\" class=\"c-ws_titles\"></div></td>";
  sch_r_tbl += "<td><div id=\"ws_title2\" class=\"c-ws_titles\"></div></td>";
  sch_r_tbl += "<td><div id=\"ws_title3\" class=\"c-ws_titles\"></div></td>";
  sch_r_tbl += "<td></td>";
  sch_r_tbl += "<td></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_item1\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\"><p id=\"ws_amps_name\" style=\"display: inline;\"></p><sup class=\"c-asterisk\">*</sup>";
  sch_r_tbl += "<span id=\"voltage_cmd_help\" class=\"c-help_icon c-help_icon_inlnblck\" style=\"display: none;\" onclick=\"display_help(" + HELP_WLD_CMMND1 + ")\"></span></td>";
  sch_r_tbl += "<td id=\"td_left_cmd1\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_amps_left\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_VOLTS_L + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base\" style=\"width: 130px;\">";
  sch_r_tbl += "<input id=\"txt_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 1, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_right_cmd1\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_amps_right\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_VOLTS_R + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td id=\"ws_amps_units\" class=\"item_base unit_table\"></td>";
  sch_r_tbl += "<td id=\"ws_down_cmd1\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_do_amps\" class=\"c-button\" onclick=\"tch_dwn_weldsched(1)\">";
  sch_r_tbl += "<img id=\"btn_down1\" alt=\"up\" src=\"btn_down.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_slider_cmd1\" class=\"item_base txtbox_table\">";
  sch_r_tbl += "<p class=\"c_value_range\">";
  sch_r_tbl += "<label id=\"lab_ws_min_amps\" style=\"float:left\"></label>";
  sch_r_tbl += "<label id=\"lab_ws_max_amps\" style=\"float:right\"></label>";
  sch_r_tbl += "</p>";
  sch_r_tbl += "<div id=\"slg_outws_amps\" class=\"c-slider\">";
  sch_r_tbl += "<div id=\"slg_inws_amps\" class=\"c-slider-bar\"></div>";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_up_cmd1\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_up_amps\" class=\"c-button\" onclick=\"tch_up_weldsched(1)\">";
  sch_r_tbl += "<img id=\"btn_up1\" alt=\"up\" src=\"btn_up.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_sp1_cmd1\" style=\"display: none;\"></td>";
  sch_r_tbl += "<td id=\"td_sp2_cmd1\" style=\"display: none;\"></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_item2\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\"><p id=\"ws_volts_name\" style=\"display: inline;\"></p><sup class=\"c-asterisk\">*</sup>";
  sch_r_tbl += "<span id=\"wfs_cmd_help\" class=\"c-help_icon c-help_icon_inlnblck\" style=\"display: none;\" onclick=\"display_help(" + HELP_WLD_CMMND2 + ")\"></span></td>";
  sch_r_tbl += "<td id=\"td_left_cmd2\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_volts_left\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_WFS_L + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base\" style=\"width: 130px;\">";
  sch_r_tbl += "<input id=\"txt_volts\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 2, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_right_cmd2\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_volts_right\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_WFS_R + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td id=\"ws_volts_units\" class=\"item_base unit_table\"></td>";
  sch_r_tbl += "<td id=\"ws_down_cmd2\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_do_volts\" class=\"c-button\" onclick=\"tch_dwn_weldsched(2)\">";
  sch_r_tbl += "<img id=\"btn_down2\" alt=\"up\" src=\"btn_down.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_slider_cmd2\" class=\"item_base txtbox_table\">";
  sch_r_tbl += "<p class=\"c_value_range\">";
  sch_r_tbl += "<label id=\"lab_ws_min_volts\" style=\"float:left\"></label>";
  sch_r_tbl += "<label id=\"lab_ws_max_volts\" style=\"float:right\"></label>";
  sch_r_tbl += "</p>";
  sch_r_tbl += "<div id=\"slg_outws_volts\" class=\"c-slider\">";
  sch_r_tbl += "<div id=\"slg_inws_volts\" class=\"c-slider-bar\"></div>";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_up_cmd2\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_up_volts\" class=\"c-button\" onclick=\"tch_up_weldsched(2)\">";
  sch_r_tbl += "<img id=\"btn_up2\" alt=\"up\" src=\"btn_up.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_sp1_cmd2\" style=\"display: none;\"></td>";
  sch_r_tbl += "<td id=\"td_sp2_cmd2\" style=\"display: none;\"></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_item3\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\"><p id=\"ws_wavecontrol_name\" style=\"display: inline;\"></p><sup class=\"c-asterisk\">*</sup>";
  sch_r_tbl += "<span id=\"current_cmd_help\" class=\"c-help_icon c-help_icon_inlnblck\" style=\"display: none;\" onclick=\"display_help(" + HELP_WLD_CMMND3 + ")\"></span></td>";
  sch_r_tbl += "<td id=\"td_left_cmd3\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_wavecontrol_left\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_AMPS_L + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base\" style=\"width: 130px;\">";
  sch_r_tbl += "<input id=\"txt_wavecontrol\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 3, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_right_cmd3\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_wavecontrol_right\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_AMPS_R + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td id=\"ws_wavecontrol_units\" class=\"item_base unit_table\"></td>";
  sch_r_tbl += "<td id=\"ws_down_cmd3\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_do_wavecon\" class=\"c-button\" onclick=\"tch_dwn_weldsched(3)\">";
  sch_r_tbl += "<img id=\"btn_down3\" alt=\"up\" src=\"btn_down.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_slider_cmd3\" class=\"item_base txtbox_table\">";
  sch_r_tbl += "<p class=\"c_value_range\">";
  sch_r_tbl += "<label id=\"lab_ws_min_wavecon\" style=\"float:left\"></label>";
  sch_r_tbl += "<label id=\"lab_ws_max_wavecon\" style=\"float:right\"></label>";
  sch_r_tbl += "</p>";
  sch_r_tbl += "<div id=\"slg_outws_wavecon\" class=\"c-slider\">";
  sch_r_tbl += "<div id=\"slg_inws_wavecon\" class=\"c-slider-bar\"></div>";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_up_cmd3\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_up_wavecon\" class=\"c-button\" onclick=\"tch_up_weldsched(3)\">";
  sch_r_tbl += "<img id=\"btn_up3\" alt=\"up\" src=\"btn_up.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_sp1_cmd3\" style=\"display: none;\"></td>";
  sch_r_tbl += "<td id=\"td_sp2_cmd3\" style=\"display: none;\"></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_item4\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\"><p id=\"ws_pkamps_name\" style=\"display: inline;\"></p>";
  sch_r_tbl += "<span id=\"pk_curr_cmd_help\" class=\"c-help_icon c-help_icon_inlnblck\" style=\"display: none;\" onclick=\"display_help(" + HELP_WLD_CMMND4 + ")\"></span></td>";
  sch_r_tbl += "<td id=\"td_left_cmd4\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_pkamps_left\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_PKAMPSL + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base\" style=\"width: 130px;\">";
  sch_r_tbl += "<input id=\"txt_pkamps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 4, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_right_cmd4\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_pkamps_right\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_PKAMPSR + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td id=\"ws_pkamps_units\" class=\"item_base unit_table\"></td>";
  sch_r_tbl += "<td id=\"ws_down_cmd4\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_do_pkamps\" class=\"c-button\" onclick=\"tch_dwn_weldsched(4)\">";
  sch_r_tbl += "<img id=\"btn_down4\" alt=\"up\" src=\"btn_down.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_slider_cmd4\" class=\"item_base txtbox_table\">";
  sch_r_tbl += "<p class=\"c_value_range\">";
  sch_r_tbl += "<label id=\"lab_ws_min_pkamps\" style=\"float:left\"></label>";
  sch_r_tbl += "<label id=\"lab_ws_max_pkamps\" style=\"float:right\"></label>";
  sch_r_tbl += "</p>";
  sch_r_tbl += "<div id=\"slg_outws_wavecon\" class=\"c-slider\">";
  sch_r_tbl += "<div id=\"slg_inws_pkamps\" class=\"c-slider-bar\"></div>";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_up_cmd4\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_up_wavecon\" class=\"c-button\" onclick=\"tch_up_weldsched(4)\">";
  sch_r_tbl += "<img id=\"btn_up4\" alt=\"up\" src=\"btn_up.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_sp1_cmd4\" style=\"display: none;\"></td>";
  sch_r_tbl += "<td id=\"td_sp2_cmd4\" style=\"display: none;\"></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_item5\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\"><p id=\"ws_freq_name\" style=\"display: inline;\"></p>";
  sch_r_tbl += "<span id=\"freq_cmd_help\" class=\"c-help_icon c-help_icon_inlnblck\" style=\"display: none;\" onclick=\"display_help(" + HELP_WLD_CMMND5 + ")\"></span></td>";
  sch_r_tbl += "<td id=\"td_left_cmd5\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_freq_left\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_FREQ_L + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base\" style=\"width: 130px;\">";
  sch_r_tbl += "<input id=\"txt_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 5, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_right_cmd5\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_freq_right\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_FREQ_R + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td id=\"ws_freq_units\" class=\"item_base unit_table\"></td>";
  sch_r_tbl += "<td id=\"ws_down_cmd5\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_do_freq\" class=\"c-button\" onclick=\"tch_dwn_weldsched(5)\">";
  sch_r_tbl += "<img id=\"btn_down5\" alt=\"up\" src=\"btn_down.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_slider_cmd5\" class=\"item_base txtbox_table\">";
  sch_r_tbl += "<p class=\"c_value_range\">";
  sch_r_tbl += "<label id=\"lab_ws_min_freq\" style=\"float:left\"></label>";
  sch_r_tbl += "<label id=\"lab_ws_max_freq\" style=\"float:right\"></label>";
  sch_r_tbl += "</p>";
  sch_r_tbl += "<div id=\"slg_outws_freq\" class=\"c-slider\">";
  sch_r_tbl += "<div id=\"slg_inws_freq\" class=\"c-slider-bar\"></div>";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_up_cmd5\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_up_freq\" class=\"c-button\" onclick=\"tch_up_weldsched(5)\">";
  sch_r_tbl += "<img id=\"btn_up5\" alt=\"up\" src=\"btn_up.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_sp1_cmd5\" style=\"display: none;\"></td>";
  sch_r_tbl += "<td id=\"td_sp2_cmd5\" style=\"display: none;\"></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_item6\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\"><p id=\"ws_pulse_name\" style=\"display: inline;\"></p>";
  sch_r_tbl += "<span id=\"pulse_cmd_help\" class=\"c-help_icon c-help_icon_inlnblck\" style=\"display: none;\" onclick=\"display_help(" + HELP_WLD_CMMND6 + ")\"></span></td>";
  sch_r_tbl += "<td id=\"td_left_cmd6\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_pulse_left\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_PULSE_L + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base\" style=\"width: 130px;\">";
  sch_r_tbl += "<input id=\"txt_pulse\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 6, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_right_cmd6\" class=\"item_base\" style=\"width: 130px; display: none;\">";
  sch_r_tbl += "<input id=\"txt_pulse_right\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_PULSE_R + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td id=\"ws_pulse_units\" class=\"item_base unit_table\"></td>";
  sch_r_tbl += "<td id=\"ws_down_cmd6\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_do_wavecon\" class=\"c-button\" onclick=\"tch_dwn_weldsched(6)\">";
  sch_r_tbl += "<img id=\"btn_down6\" alt=\"up\" src=\"btn_down.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_slider_cmd6\" class=\"item_base txtbox_table\">";
  sch_r_tbl += "<p class=\"c_value_range\">";
  sch_r_tbl += "<label id=\"lab_ws_min_pulse\" style=\"float:left\"></label>";
  sch_r_tbl += "<label id=\"lab_ws_max_pulse\" style=\"float:right\"></label>";
  sch_r_tbl += "</p>";
  sch_r_tbl += "<div id=\"slg_outws_pulse\" class=\"c-slider\">";
  sch_r_tbl += "<div id=\"slg_inws_pulse\" class=\"c-slider-bar\"></div>";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"ws_up_cmd6\" class=\"item_base unit_table\">";
  sch_r_tbl += "<div id=\"slb_up_wavecon\" class=\"c-button\" onclick=\"tch_up_weldsched(6)\">";
  sch_r_tbl += "<img id=\"btn_up6\" alt=\"up\" src=\"btn_up.png\">";
  sch_r_tbl += "</div>";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td id=\"td_sp1_cmd6\" style=\"display: none;\"></td>";
  sch_r_tbl += "<td id=\"td_sp2_cmd6\" style=\"display: none;\"></td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_heatwave_bttm_spc\" style=\"display: none; height: 16px;\"></tr>";
  sch_r_tbl += "<tr id=\"ws_pulse_freq\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(319) + "</td>";
  sch_r_tbl += "<td class=\"item_base txtbox_table\">";
  sch_r_tbl += "<input id=\"txt_pulse_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_PLS_FRQ + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base unit_table\">Hz</td>";
  sch_r_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>"
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_pulse_duty\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(320) + "</td>";
  sch_r_tbl += "<td class=\"item_base txtbox_table\">";
  sch_r_tbl += "<input id=\"txt_ws_pulse_duty\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, " + WS_PLS_DTY + ", '', '', '')\" ";
  sch_r_tbl += "onKeyup=\"only_numeric(this)\"></td>";
  sch_r_tbl += "<td class=\"item_base unit_table\">%</td>";
  sch_r_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>"
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_travelspeed\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(56) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_TRVL_SPD + ")\"></span></td>";
  sch_r_tbl += "<td class=\"item_base txtbox_table\">";
  sch_r_tbl += "<input id=\"txt_travelspeed\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 7, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td class=\"item_base unit_table\">cm/min</td>";
  sch_r_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>"
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_delaytime\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(57) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_DLY_TM + ")\"></span></td>";
  sch_r_tbl += "<td class=\"item_base txtbox_table\">";
  sch_r_tbl += "<input id=\"txt_delaytime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldsched, 8, '', '', '')\" onKeyup=\"only_numeric(this)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "<td class=\"item_base unit_table\">sec</td>";
  sch_r_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>"
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_ramping_mode\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(163) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_RMP_MD + ")\"></span></td>";
  sch_r_tbl += "<td class=\"item_base c-dropdown\" style=\"text-align: left;\">";
  sch_r_tbl += "<input id=\"select_ramping_mode\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(1)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "<tr id=\"ws_heatwave_mode\" style=\"display: none;\">";
  sch_r_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(327) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(" + HELP_HTWV + ")\"></span></td>";
  sch_r_tbl += "<td class=\"item_base c-dropdown\" colspan=\"3\" style=\"text-align: left;\">";
  sch_r_tbl += "<input id=\"select_heatwave_mode\" type=\"text\" class=\"c-textbox\" style=\"width: 220px;\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(2)\">";
  sch_r_tbl += "</td>";
  sch_r_tbl += "</tr>";
  sch_r_tbl += "</table>";

  return sch_r_tbl;
}

function chkReadyStateChgPrg() {
  if (prg_req.readyState == 4) {
    if ( ( (200 <= prg_req.status) && (prg_req.status < 300) ) || (prg_req.status == 304) ) {
      prg_req.abort();
      set_mode = set_weldsched_mode;
      getXmlData();
    } else {
      prg_req.abort();
    }
  }
}

function getSchData(sch_number) {
  prg_req.onreadystatechange = chkReadyStateChgPrg;
  prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=2&s_ws_number=" + sch_number, true);
  prg_req.send();
}

function treeMenu(tree_num) {
  treeSelectNum = tree_num;
  open_tab_no = 1;
  selected_sch_num = tree_num;
  getSchData(tree_num);

  var weld_no = document.getElementById("weld_dropdown_cnt").value;
  for (var i = 1; i <= weld_no; i++) {
    witbl_no = document.getElementById("weldsched_item" + i);
    tmtbl_no = document.getElementById("treemenu" + i);
    tRIcon = document.getElementById("tree_ricon" + i);
    tBIcon = document.getElementById("tree_bicon" + i);
    offset_no = document.getElementById("offset_item" + i);
    weaving_no = document.getElementById("weaving_item" + i);
    tracking_no = document.getElementById("tracking_item" + i);

    offset_no.style.backgroundColor = Gr02;
    weaving_no.style.backgroundColor = Gr02;
    tracking_no.style.backgroundColor = Gr02;

    if (i_multiview_flg == 1) {
      if (tree_num == i) {
        witbl_no.style.backgroundColor = B01;

        if (tmtbl_no.style.display == "none") {
          tmtbl_no.style.display = "block";
          offset_no.style.display = "block";
          weaving_no.style.display = "block";
          tracking_no.style.display = "block";
          tRIcon.style.display = "none";
          tBIcon.style.display = "block";
        } else {
          tmtbl_no.style.display = "none";
          offset_no.style.display = "none";
          weaving_no.style.display = "none";
          tracking_no.style.display = "none";
          tRIcon.style.display = "block";
          tBIcon.style.display = "none";
        }
      } else {
        witbl_no.style.backgroundColor = Gr02;
        tmtbl_no.style.display = "none";
        tRIcon.style.display = "block";
        tBIcon.style.display = "none";
      }
    } else {
      if (tree_num == i) {
        witbl_no.style.backgroundColor = B01;
        if (tmtbl_no.style.visibility == "hidden") {
          tmtbl_no.style.visibility = "visible";
        } else {
          tmtbl_no.style.visibility = "hidden";
        }
      } else {
        witbl_no.style.backgroundColor = Gr02;
        tmtbl_no.style.visibility = "hidden";
      }
    }
  }
}

function trTreeMenu(tree_num) {

  if(help_stts == HELP_STTS_NONE) {
    window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + tree_num;
  }
  var item_touchretract = document.getElementById("touchretract_item");
  var item_runin = document.getElementById("runin_item");
  var item_burnback = document.getElementById("burnback_item");
  var item_wirestickresets = document.getElementById("wirestickresets_item");
  var item_onthefly = document.getElementById("onthefly_item");
  var item_s2t_st = document.getElementById("s2t_st_item");
  var item_s2t_ed = document.getElementById("s2t_ed_item");
  var right_screen = document.getElementById("right_screen");
  var item_wpstart = document.getElementById("wpstart_item");
  var item_wirepreheat = document.getElementById("wirepreheat_item");
  var item_archeat = document.getElementById("archeat_item");

  treeSelectNum = tree_num;
  item_runin.style.backgroundColor = Gr02;
  item_burnback.style.backgroundColor = Gr02;
  item_wirestickresets.style.backgroundColor = Gr02;
  item_onthefly.style.backgroundColor = Gr02;
  item_s2t_st.style.backgroundColor = Gr02;
  item_s2t_ed.style.backgroundColor = Gr02;
  right_screen.innerHTML = "";
  right_screen.scrollTop = 0;
  item_wpstart.style.backgroundColor = Gr02;
  item_wirepreheat.style.backgroundColor = Gr02;
  item_archeat.style.backgroundColor = Gr02;

  if(tree_num != 1){
    item_touchretract.style.backgroundColor = Gr02;
  }

  switch (tree_num) {
    case 1:
      if((touch_op_status == 1) && (item_touchretract.style.backgroundColor == Gr02)){
        item_touchretract.style.backgroundColor = B01;
        request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_TCRT);
        return;
      }else{
        item_touchretract.style.backgroundColor = Gr02;
      }

      item_touchretract.style.backgroundColor = B01;
      right_screen.innerHTML = get_touch_retract_rght_scrn();

      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_TCRT);

      if(touch_op_status == 0){
        touch_open();
      }else{
        touch_close();
      }
      break;
    case 2:
      item_runin.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_RUNIN);
      break;
    case 3:
      item_burnback.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_BURNBACK);
      break;
    case 4:
      item_wirestickresets.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_WSTK_RESET);
      break;
    case 5:
      item_onthefly.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_ON_THE_FLY);
      break;
    case 6:
      item_s2t_st.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_S2T_ST);
      break;
    case 7:
      item_s2t_ed.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_S2T_ED);
      break;
    case 8:
      item_wpstart.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_WPSTART);
      break;
    case 9:
      item_wirepreheat.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_WPHEAT);
      break;
    case 10:
      item_archeat.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_ARCHET);
      break;
    case 11:
      item_touchretract.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_TCRTST);
      break;
    case 12:
      item_touchretract.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNC_DTL_PROC_TCRTMD);
      break;
    default:
      break;
  }
}

function tch_dwn_runin(setRnTglVal) {
  check_button_status();
  set_dwn_button("runin_down" + setRnTglVal);

  switch (setRnTglVal) {
    case 1:
      tch_dwn_btn("txt_ru_amps", 5, i_min_amps, i_max_amps, 'slg_inru_amps', voltage_cmd_format);
      set_aw_data('s_rn_volts', 'txt_ru_amps', treeSelectNum, setRnTglVal);
      break;
    case 2:
      tch_dwn_btn("txt_ru_volts", 0.5, i_min_volts, i_max_volts, 'slg_inru_volts', wfs_cmd_format);
      set_aw_data('s_rn_wv_ctrl', 'txt_ru_volts', treeSelectNum, setRnTglVal);
      break;
    case 3:
      tch_dwn_btn("txt_ru_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inru_wavecon', current_cmd_format);
      set_aw_data('s_rn_amps', 'txt_ru_wavecontrol', treeSelectNum, setRnTglVal);
      break;
    case 4:
      tch_dwn_btn("txt_ru_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inru_pkamps', pk_curr_cmd_format);
      set_aw_data('s_rn_pkamps', 'txt_ru_pkamps', treeSelectNum, setRnTglVal);
      break;
    case 5:
      tch_dwn_btn("txt_ru_freq", 0.5, i_min_freq, i_max_freq, 'slg_inru_freq', freq_cmd_format);
      set_aw_data('s_rn_freq', 'txt_ru_freq', treeSelectNum, setRnTglVal);
      break;
    case 6:
      tch_dwn_btn("txt_ru_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inru_pulse', pulse_cmd_format);
      set_aw_data('s_rn_pulse', 'txt_ru_pulse', treeSelectNum, setRnTglVal);
      break;
    default:
      break;
  }
}

function tch_up_runin(setRnTglVal) {
  check_button_status();
  set_up_button("runin_up" + setRnTglVal);

  switch (setRnTglVal) {
    case 1:
      tch_up_btn("txt_ru_amps", 5, i_min_amps, i_max_amps, 'slg_inru_amps', voltage_cmd_format);
      set_aw_data('s_rn_volts', 'txt_ru_amps', treeSelectNum, setRnTglVal);
      break;
    case 2:
      tch_up_btn("txt_ru_volts", 0.5, i_min_volts, i_max_volts, 'slg_inru_volts', wfs_cmd_format);
      set_aw_data('s_rn_wv_ctrl', 'txt_ru_volts', treeSelectNum, setRnTglVal);
      break;
    case 3:
      tch_up_btn("txt_ru_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inru_wavecon', current_cmd_format);
      set_aw_data('s_rn_amps', 'txt_ru_wavecontrol', treeSelectNum, setRnTglVal);
      break;
    case 4:
      tch_up_btn("txt_ru_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inru_pkamps', pk_curr_cmd_format);
      set_aw_data('s_rn_pkamps', 'txt_ru_pkamps', treeSelectNum, setRnTglVal);
      break;
    case 5:
      tch_up_btn("txt_ru_freq", 0.5, i_min_freq, i_max_freq, 'slg_inru_freq', freq_cmd_format);
      set_aw_data('s_rn_freq', 'txt_ru_freq', treeSelectNum, setRnTglVal);
      break;
    case 6:
      tch_up_btn("txt_ru_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inru_pulse', pulse_cmd_format);
      set_aw_data('s_rn_pulse', 'txt_ru_pulse', treeSelectNum, setRnTglVal);
      break;
    default:
      break;
  }
}

function get_process_lft_scrn(xml_doc_data) {
  var sch_l_tbl = "<div id=\"left_screen\">";

  sch_l_tbl += "<table id=\"process_l_screen\" class=\"c-l_scrn_mrgn1\" style=\"width: 350px; table-layout:fixed; \" cellspacing=\"0\" cellpadding=\"0\">";
  sch_l_tbl += "<tr id=\"touchretract_item\" style=\"background-color:#e7e7ef;\">";
  sch_l_tbl += "<td id=\"touchretract_treeoff\" class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"width: 40px; height: 30px; display:none; border-right: 3px solid #e7e7ef;\" onclick=\"touch_open()\" ><img id=\"img_off\" alt=\"tree1\" src=\"tree_off.png\"></td>";
  sch_l_tbl += "<td id=\"touchretract_treeon\"  class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"width: 40px; height: 30px; border-right: 3px solid #e7e7ef;\" onclick=\"touch_close()\"><img id=\"img_on\" alt=\"tree2\" src=\"tree_on.png\"></td>";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" style=\"width: 237px; height: 60px;\" onclick=\"trTreeMenu(1)\" colspan=\"2\">" + get_prct_dict_text(46) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\" border=\"2\" bordercolor=\"#0000ff\"><div class=\"c-help_icon\" onclick=\"display_help(260)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
  sch_l_tbl += "<tr id=\"wpstart_item\" style=\"display:none;\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"visibility:hidden; border-right: 3px solid #e7e7ef;\" bgcolor=\"#ff0000\"><img alt=\"tree1\" src=\"tree_off.png\"></td>";
  sch_l_tbl += "<td class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"width: 40px; height: 30px; display:none; border-right: 3px solid #e7e7ef;\" onclick=\"touch_close()\"><img alt=\"tree2\" src=\"tree_on.png\"></td>";
  sch_l_tbl += "<td id=\"wpstart_tab\" class=\"c-tree c-tree_weld_process\" style=\"width: 237px; height: 60px;\" onclick=\"trTreeMenu(8)\" colspan=\"2\">" + get_prct_dict_text(64) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(262)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr id=\"wpstree_space\" style=\"height: 4px; display:none;\"></tr>";
  sch_l_tbl += "<tr id=\"wirepreheat_item\" style=\"display:none;\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"visibility:hidden; border-right: 3px solid #e7e7ef;\" bgcolor=\"#ff0000\"><img alt=\"tree1\" src=\"tree_off.png\"></td>";
  sch_l_tbl += "<td class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"width: 40px; height: 30px; display:none; border-right: 3px solid #e7e7ef;\" onclick=\"touch_close()\"><img alt=\"tree2\" src=\"tree_on.png\"></td>";
  sch_l_tbl += "<td id=\"wirepreheat_tab\" class=\"c-tree c-tree_weld_process\" style=\"width: 237px; height: 60px;\" onclick=\"trTreeMenu(9)\" colspan=\"2\">" + get_prct_dict_text(65) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(265)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr id=\"wptree_space\" style=\"height: 4px; display:none;\"></tr>";
  sch_l_tbl += "<tr id=\"archeat_item\" style=\"display:none;\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"visibility:hidden; border-right: 3px solid #e7e7ef;\" bgcolor=\"#ff0000\"><img alt=\"tree1\" src=\"tree_off.png\"></td>";
  sch_l_tbl += "<td class=\"c-tree c-tree_txt c-not_slct_bg_color\" align=\"center\" style=\"width: 40px; height: 30px; display:none; border-right: 3px solid #e7e7ef;\" onclick=\"touch_close()\"><img alt=\"tree2\" src=\"tree_on.png\"></td>";
  sch_l_tbl += "<td id=\"archeat_tab\" class=\"c-tree c-tree_weld_process\" style=\"width: 237px; height: 60px;\" onclick=\"trTreeMenu(10)\" colspan=\"2\">" + get_prct_dict_text(66) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(270)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "</table>";
  sch_l_tbl += "<table id=\"process_l_screen1\" class=\"c-l_scrn_mrgn2\" style=\"width: 350px;\" cellspacing=\"0\" cellpadding=\"0\">";
  sch_l_tbl += "<tr id=\"ahtree_space\" style=\"height: 4px; display:none;\"></tr>";
  sch_l_tbl += "<tr id=\"runin_item\" class=\"c-not_slct_bg_color\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" colspan=\"2\" onclick=\"trTreeMenu(2)\">" + get_prct_dict_text(47) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(57)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
  sch_l_tbl += "<tr id=\"burnback_item\" class=\"c-not_slct_bg_color\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" colspan=\"2\" onclick=\"trTreeMenu(3)\">" + get_prct_dict_text(48) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(66)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr id=\"s2t_st_item\" class=\"c-not_slct_bg_color\" style=\"display:none;\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" colspan=\"2\" onclick=\"trTreeMenu(6)\">" + get_prct_dict_text(261) + "</td>";
  sch_l_tbl += "<td class=\"help_icon\" style=\"display:none;\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
  sch_l_tbl += "<tr id=\"wirestickresets_item\" class=\"c-not_slct_bg_color\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" colspan=\"2\" onclick=\"trTreeMenu(4)\">" + get_prct_dict_text(49) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(75)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr id=\"s2t_ed_item\" class=\"c-not_slct_bg_color\" style=\"display:none;\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" colspan=\"2\" onclick=\"trTreeMenu(7)\">" + get_prct_dict_text(262) + "</td>";
  sch_l_tbl += "<td class=\"help_icon\" style=\"display:none;\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr style=\"height: 4px;\"></tr>";
  sch_l_tbl += "<tr id=\"onthefly_item\" class=\"c-not_slct_bg_color\">";
  sch_l_tbl += "<td class=\"c-tree c-tree_weld_process\" colspan=\"2\" onclick=\"trTreeMenu(5)\">" + get_prct_dict_text(50) + "</td>";
  sch_l_tbl += "<td class=\"c-tracking_tree_help\"><div class=\"c-help_icon\" onclick=\"display_help(85)\"></div></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "</table>";

  sch_l_tbl += "</div>";
  return sch_l_tbl;
}

function get_runin_rght_scrn() {
  var rght_tbl = "<table id=\"runin_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(67) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_runin\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(8)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"4\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tbody id=\"runin_enable_screen\">";
  rght_tbl += "<tr id=\"runin_item1\" style=\"display: none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"ru_amps_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"ru_amps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_doru_amps\" class=\"c-button\" onclick=\"tch_dwn_runin(1)\"><img id=\"runin_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ru_min_amps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_ru_max_amps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outru_amps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inru_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upru_amps\" class=\"c-button\" onclick=\"tch_up_runin(1)\"><img id=\"runin_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"runin_item2\" style=\"display: none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"ru_volts_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_volts\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"ru_volts_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_doru_volts\" class=\"c-button\" onclick=\"tch_dwn_runin(2)\"><img id=\"runin_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ru_min_volts\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_ru_max_volts\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outru_volts\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inru_volts\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upru_volts\" class=\"c-button\" onclick=\"tch_up_runin(2)\"><img id=\"runin_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"runin_item3\" style=\"display: none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"ru_wavecontrol_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_wavecontrol\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"ru_wavecontrol_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_doru_wavecon\" class=\"c-button\" onclick=\"tch_dwn_runin(3)\"><img id=\"runin_down3\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ru_min_wavecon\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_ru_max_wavecon\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outru_wavecon\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inru_wavecon\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upru_wavecon\" class=\"c-button\" onclick=\"tch_up_runin(3)\"><img id=\"runin_up3\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"runin_item4\" style=\"display: none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"ru_pkamps_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_pkamps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"ru_pkamps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_doru_pkamps\" class=\"c-button\" onclick=\"tch_dwn_runin(4)\"><img id=\"runin_down4\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ru_min_pkamps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_ru_max_pkamps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outru_pkamps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inru_pkamps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upru_pkamps\" class=\"c-button\" onclick=\"tch_up_runin(4)\"><img id=\"runin_up4\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"runin_item5\" style=\"display: none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"ru_freq_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"ru_freq_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_doru_freq\" class=\"c-button\" onclick=\"tch_dwn_runin(5)\"><img id=\"runin_down5\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ru_min_freq\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_ru_max_freq\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outru_freq\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inru_freq\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upru_freq\" class=\"c-button\" onclick=\"tch_up_runin(5)\"><img id=\"runin_up5\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"runin_item6\" style=\"display: none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"ru_pulse_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_pulse\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"ru_pulse_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_doru_pulse\" class=\"c-button\" onclick=\"tch_dwn_runin(6)\"><img id=\"runin_down6\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ru_min_pulse\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_ru_max_pulse\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outru_pulse\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inru_pulse\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upru_pulse\" class=\"c-button\" onclick=\"tch_up_runin(6)\"><img id=\"runin_up6\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\" style=\"width=100px;\">" + get_prct_dict_text(57) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(65)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ru_delaytime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_runin, 7, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</tbody>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_burnback(setBbVal) {
  switch (setBbVal) {
    case 1:
      validate_check_slg("txt_bb_amps", i_min_amps, i_max_amps, 'slg_inbb_amps', voltage_cmd_format);
      set_aw_data('s_bb_volts', 'txt_bb_amps', treeSelectNum, setBbVal);
      break;
    case 2:
      validate_check_slg("txt_bb_volts", i_min_volts, i_max_volts, 'slg_inbb_volts', wfs_cmd_format);
      set_aw_data('s_bb_wv_ctrl', 'txt_bb_volts', treeSelectNum, setBbVal);
      break;
    case 3:
      validate_check_slg("txt_bb_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inbb_wavecon', current_cmd_format);
      set_aw_data('s_bb_amps', 'txt_bb_wavecontrol', treeSelectNum, setBbVal);
      break;
    case 4:
      validate_check_slg("txt_bb_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inbb_pkamps', pk_curr_cmd_format);
      set_aw_data('s_bb_pkamps', 'txt_bb_pkamps', treeSelectNum, setBbVal);
      break;
    case 5:
      validate_check_slg("txt_bb_freq", i_min_freq, i_max_freq, 'slg_inbb_freq', freq_cmd_format);
      set_aw_data('s_bb_freq', 'txt_bb_freq', treeSelectNum, setBbVal);
      break;
    case 6:
      validate_check_slg("txt_bb_pulse", i_min_pulse, i_max_pulse, 'slg_inbb_pulse', pulse_cmd_format);
      set_aw_data('s_bb_pulse', 'txt_bb_pulse', treeSelectNum, setBbVal);
      break;
    case 7:
      validate_check("txt_bb_delaytime", i_min_delaytime, i_max_delaytime);
      set_val_items('s_bb_dly_tm', 'txt_bb_delaytime', 0, i_min_delaytime, i_max_delaytime, 2, setBbVal);
      break;
    case 8:
      set_text_value("txt_bb_amps", i_min_amps, i_max_amps, 'slg_inbb_amps', voltage_cmd_format);
      set_text_value("txt_bb_volts", i_min_volts, i_max_volts, 'slg_inbb_volts', wfs_cmd_format);
      set_text_value("txt_bb_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inbb_wavecon', current_cmd_format);
      set_text_value("txt_bb_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inbb_pkamps', pk_curr_cmd_format);
      set_text_value("txt_bb_freq", i_min_freq, i_max_freq, 'slg_inbb_freq', freq_cmd_format);
      set_text_value("txt_bb_pulse", i_min_pulse, i_max_pulse, 'slg_inbb_pulse', pulse_cmd_format);
      break;
    default:
      break;
  }
}

function tch_dwn_burnback(setBbTglVal) {
  check_button_status();
  set_dwn_button("burn_down" + setBbTglVal);

  switch (setBbTglVal) {
    case 1:
      tch_dwn_btn("txt_bb_amps", 5, i_min_amps, i_max_amps, 'slg_inbb_amps', voltage_cmd_format);
      set_aw_data('s_bb_volts', 'txt_bb_amps', treeSelectNum, setBbTglVal);
      break;
    case 2:
      tch_dwn_btn("txt_bb_volts", 0.5, i_min_volts, i_max_volts, 'slg_inbb_volts', wfs_cmd_format);
      set_aw_data('s_bb_wv_ctrl', 'txt_bb_volts', treeSelectNum, setBbTglVal);
      break;
    case 3:
      tch_dwn_btn("txt_bb_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inbb_wavecon', current_cmd_format);
      set_aw_data('s_bb_amps', 'txt_bb_wavecontrol', treeSelectNum, setBbTglVal);
      break;
    case 4:
      tch_dwn_btn("txt_bb_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inbb_pkamps', pk_curr_cmd_format);
      set_aw_data('s_bb_pkamps', 'txt_bb_pkamps', treeSelectNum, setBbTglVal);
      break;
    case 5:
      tch_dwn_btn("txt_bb_freq", 0.5, i_min_freq, i_max_freq, 'slg_inbb_freq', freq_cmd_format);
      set_aw_data('s_bb_freq', 'txt_bb_freq', treeSelectNum, setBbTglVal);
      break;
    case 6:
      tch_dwn_btn("txt_bb_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inbb_pulse', pulse_cmd_format);
      set_aw_data('s_bb_pulse', 'txt_bb_pulse', treeSelectNum, setBbTglVal);
      break;
    default:
      break;
  }
}

function tch_up_burnback(setBbTglVal) {
  check_button_status();
  set_up_button("burn_up" + setBbTglVal);

  switch (setBbTglVal) {
    case 1:
      tch_up_btn("txt_bb_amps", 5, i_min_amps, i_max_amps, 'slg_inbb_amps', voltage_cmd_format);
      set_aw_data('s_bb_volts', 'txt_bb_amps', treeSelectNum, setBbTglVal);
      break;
    case 2:
      tch_up_btn("txt_bb_volts", 0.5, i_min_volts, i_max_volts, 'slg_inbb_volts', wfs_cmd_format);
      set_aw_data('s_bb_wv_ctrl', 'txt_bb_volts', treeSelectNum, setBbTglVal);
      break;
    case 3:
      tch_up_btn("txt_bb_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inbb_wavecon', current_cmd_format);
      set_aw_data('s_bb_amps', 'txt_bb_wavecontrol', treeSelectNum, setBbTglVal);
      break;
    case 4:
      tch_up_btn("txt_bb_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inbb_pkamps', pk_curr_cmd_format);
      set_aw_data('s_bb_pkamps', 'txt_bb_pkamps', treeSelectNum, setBbTglVal);
      break;
    case 5:
      tch_up_btn("txt_bb_freq", 0.5, i_min_freq, i_max_freq, 'slg_inbb_freq', freq_cmd_format);
      set_aw_data('s_bb_freq', 'txt_bb_freq', treeSelectNum, setBbTglVal);
      break;
    case 6:
      tch_up_btn("txt_bb_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inbb_pulse', pulse_cmd_format);
      set_aw_data('s_bb_pulse', 'txt_bb_pulse', treeSelectNum, setBbTglVal);
      break;
    default:
      break;
  }
}

function get_burnback_rght_scrn() {
  var rght_tbl = "<table id=\"burnback_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(68) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_burnback\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(9)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"4\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tbody id =\"burnback_enable_screen\">";
  rght_tbl += "<tr id=\"burnback_item1\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"bb_amps_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"bb_amps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dobb_amps\" class=\"c-button\" onclick=\"tch_dwn_burnback(1)\"><img id=\"burn_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_bb_min_amps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_bb_max_amps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outbb_amps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inbb_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upbb_amps\" class=\"c-button\" onclick=\"tch_up_burnback(1)\"><img id=\"burn_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"burnback_item2\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"bb_volts_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_volts\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"bb_volts_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dobb_volts\" class=\"c-button\" onclick=\"tch_dwn_burnback(2)\"><img id=\"burn_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_bb_min_volts\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_bb_max_volts\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outbb_volts\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inbb_volts\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upbb_volts\" class=\"c-button\" onclick=\"tch_up_burnback(2)\"><img id=\"burn_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"burnback_item3\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"bb_wavecontrol_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_wavecontrol\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"bb_wavecontrol_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dobb_wavecon\" class=\"c-button\" onclick=\"tch_dwn_burnback(3)\"><img id=\"burn_down3\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_bb_min_wavecon\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_bb_max_wavecon\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outbb_wavecon\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inbb_wavecon\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upbb_wavecon\" class=\"c-button\" onclick=\"tch_up_burnback(3)\"><img id=\"burn_up3\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"burnback_item4\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"bb_pkamps_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_pkamps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"bb_pkamps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dobb_pkamps\" class=\"c-button\" onclick=\"tch_dwn_burnback(4)\"><img id=\"burn_down4\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_bb_min_pkamps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_bb_max_pkamps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outbb_pkamps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inbb_pkamps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upbb_pkamps\" class=\"c-button\" onclick=\"tch_up_burnback(4)\"><img id=\"burn_up4\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"burnback_item5\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"bb_freq_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"bb_freq_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dobb_freq\" class=\"c-button\" onclick=\"tch_dwn_burnback(5)\"><img id=\"burn_down5\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_bb_min_freq\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_bb_max_freq\" style=\"float:right\">1</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outbb_freq\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inbb_freq\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upbb_freq\" class=\"c-button\" onclick=\"tch_up_burnback(5)\"><img id=\"burn_up5\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"burnback_item6\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"bb_pulse_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_pulse\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"bb_pulse_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dobb_pulse\" class=\"c-button\" onclick=\"tch_dwn_burnback(6)\"><img id=\"burn_down6\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_bb_min_pulse\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_bb_max_pulse\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outbb_pulse\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inbb_pulse\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upbb_pulse\" class=\"c-button\" onclick=\"tch_up_burnback(6)\"><img id=\"burn_up6\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(57) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(74)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_bb_delaytime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_burnback, 7, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</tbody>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_val_wiresets(setWrVal) {
  switch (setWrVal) {
    case 1:
      validate_check_slg("txt_wr_amps", i_min_amps, i_max_amps, 'slg_inwr_amps', voltage_cmd_format);
      set_aw_data('s_wr_volts', 'txt_wr_amps', treeSelectNum, setWrVal);
      break;
    case 2:
      validate_check_slg("txt_wr_volts", i_min_volts, i_max_volts, 'slg_inwr_volts', wfs_cmd_format);
      set_aw_data('s_wr_wv_ctrl', 'txt_wr_volts', treeSelectNum, setWrVal);
      break;
    case 3:
      validate_check_slg("txt_wr_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inwr_wavecon', current_cmd_format);
      set_aw_data('s_wr_amps', 'txt_wr_wavecontrol', treeSelectNum, setWrVal);
      break;
    case 4:
      validate_check_slg("txt_wr_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inwr_pkamps', pk_curr_cmd_format);
      set_aw_data('s_wr_pkamps', 'txt_wr_pkamps', treeSelectNum, setWrVal);
      break;
    case 5:
      validate_check_slg("txt_wr_freq", i_min_freq, i_max_freq, 'slg_inwr_freq', freq_cmd_format);
      set_aw_data('s_wr_freq', 'txt_wr_freq', treeSelectNum, setWrVal);
      break;
    case 6:
      validate_check_slg("txt_wr_pulse", i_min_pulse, i_max_pulse, 'slg_inwr_pulse', pulse_cmd_format);
      set_aw_data('s_wr_pulse', 'txt_wr_pulse', treeSelectNum, setWrVal);
      break;
    case 7:
      validate_check("txt_wr_delaytime", i_min_delaytime, i_max_delaytime);
      set_val_items('s_wr_dly_tm', 'txt_wr_delaytime', 0, i_min_delaytime, i_max_delaytime, 2, setWrVal);
      break;
    case 8:
      set_text_value("txt_wr_amps", i_min_amps, i_max_amps, 'slg_inwr_amps', voltage_cmd_format);
      set_text_value("txt_wr_volts", i_min_volts, i_max_volts, 'slg_inwr_volts', wfs_cmd_format);
      set_text_value("txt_wr_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inwr_wavecon', current_cmd_format);
      set_text_value("txt_wr_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inwr_pkamps', pk_curr_cmd_format);
      set_text_value("txt_wr_freq", i_min_freq, i_max_freq, 'slg_inwr_freq', freq_cmd_format);
      set_text_value("txt_wr_pulse", i_min_pulse, i_max_pulse, 'slg_inwr_pulse', pulse_cmd_format);
    default:
      break;
  }
}

function tch_dwn_wiresets(setWrTglVal) {
  check_button_status();
  set_dwn_button("wire_down" + setWrTglVal);

  switch (setWrTglVal) {
    case 1:
      tch_dwn_btn("txt_wr_amps", 5, i_min_amps, i_max_amps, 'slg_inwr_amps', voltage_cmd_format);
      set_aw_data('s_wr_volts', 'txt_wr_amps', treeSelectNum, setWrTglVal);
      break;
    case 2:
      tch_dwn_btn("txt_wr_volts", 0.5, i_min_volts, i_max_volts, 'slg_inwr_volts', wfs_cmd_format);
      set_aw_data('s_wr_wv_ctrl', 'txt_wr_volts', treeSelectNum, setWrTglVal);
      break;
    case 3:
      tch_dwn_btn("txt_wr_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inwr_wavecon', current_cmd_format);
      set_aw_data('s_wr_amps', 'txt_wr_wavecontrol', treeSelectNum, setWrTglVal);
      break;
    case 4:
      tch_dwn_btn("txt_wr_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inwr_pkamps', pk_curr_cmd_format);
      set_aw_data('s_wr_pkamps', 'txt_wr_pkamps', treeSelectNum, setWrTglVal);
      break;
    case 5:
      tch_dwn_btn("txt_wr_freq", 0.5, i_min_freq, i_max_freq, 'slg_inwr_freq', freq_cmd_format);
      set_aw_data('s_wr_freq', 'txt_wr_freq', treeSelectNum, setWrTglVal);
      break;
    case 6:
      tch_dwn_btn("txt_wr_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inwr_pulse', pulse_cmd_format);
      set_aw_data('s_wr_pulse', 'txt_wr_pulse', treeSelectNum, setWrTglVal);
      break;
    default:
      break;
  }
}

function tch_up_wiresets(setWrTglVal) {
  check_button_status();
  set_up_button("wire_up" + setWrTglVal);

  switch (setWrTglVal) {
    case 1:
      tch_up_btn("txt_wr_amps", 5, i_min_amps, i_max_amps, 'slg_inwr_amps', voltage_cmd_format);
      set_aw_data('s_wr_volts', 'txt_wr_amps', treeSelectNum, setWrTglVal);
      break;
    case 2:
      tch_up_btn("txt_wr_volts", 0.5, i_min_volts, i_max_volts, 'slg_inwr_volts', wfs_cmd_format);
      set_aw_data('s_wr_wv_ctrl', 'txt_wr_volts', treeSelectNum, setWrTglVal);
      break;
    case 3:
      tch_up_btn("txt_wr_wavecontrol", 0.5, i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inwr_wavecon', current_cmd_format);
      set_aw_data('s_wr_amps', 'txt_wr_wavecontrol', treeSelectNum, setWrTglVal);
      break;
    case 4:
      tch_up_btn("txt_wr_pkamps", 0.5, i_min_pkamps, i_max_pkamps, 'slg_inwr_pkamps', pk_curr_cmd_format);
      set_aw_data('s_wr_pkamps', 'txt_wr_pkamps', treeSelectNum, setWrTglVal);
      break;
    case 5:
      tch_up_btn("txt_wr_freq", 0.5, i_min_freq, i_max_freq, 'slg_inwr_freq', freq_cmd_format);
      set_aw_data('s_wr_freq', 'txt_wr_freq', treeSelectNum, setWrTglVal);
      break;
    case 6:
      tch_up_btn("txt_wr_pulse", 0.5, i_min_pulse, i_max_pulse, 'slg_inwr_pulse', pulse_cmd_format);
      set_aw_data('s_wr_pulse', 'txt_wr_pulse', treeSelectNum, setWrTglVal);
      break;
    default:
      break;
  }
}

function get_wstk_reset_rght_scrn() {
  var rght_tbl = "<table id=\"wiresets_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(69) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_resets\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(10)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"4\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tbody id=\"wiresets_enable_screen\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(70) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(77)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_resets_cnt\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(11)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"4\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"wiresets_item1\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"wr_amps_name\" style=\"display: inline;\"></p></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"wr_amps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dowr_amps\" class=\"c-button\" onclick=\"tch_dwn_wiresets(1)\"><img id=\"wire_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wr_min_amps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_wr_max_amps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outwr_amps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inwr_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upwr_amps\" class=\"c-button\" onclick=\"tch_up_wiresets(1)\"><img id=\"wire_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"wiresets_item2\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"wr_volts_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_volts\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"wr_volts_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dowr_volts\" class=\"c-button\" onclick=\"tch_dwn_wiresets(2)\"><img id=\"wire_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wr_min_volts\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_wr_max_volts\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outwr_volts\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inwr_volts\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upwr_volts\" class=\"c-button\" onclick=\"tch_up_wiresets(2)\"><img id=\"wire_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"wiresets_item3\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"wr_wavecontrol_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_wavecontrol\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"wr_wavecontrol_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dowr_wavecon\" class=\"c-button\" onclick=\"tch_dwn_wiresets(3)\"><img id=\"wire_down3\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wr_min_wavecon\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_wr_max_wavecon\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outwr_wavecon\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inwr_wavecon\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upwr_wavecon\" class=\"c-button\" onclick=\"tch_up_wiresets(3)\"><img id=\"wire_up3\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"wiresets_item4\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"wr_pkamps_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_pkamps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"wr_pkamps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dowr_pkamps\" class=\"c-button\" onclick=\"tch_dwn_wiresets(4)\"><img id=\"wire_down4\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wr_min_pkamps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_wr_max_pkamps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outwr_pkamps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inwr_pkamps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upwr_pkamps\" class=\"c-button\" onclick=\"tch_up_wiresets(4)\"><img id=\"wire_up4\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"wiresets_item5\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"wr_freq_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"wr_freq_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dowr_freq\" class=\"c-button\" onclick=\"tch_dwn_wiresets(5)\"><img id=\"wire_down5\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wr_min_freq\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_wr_max_freq\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outwr_freq\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inwr_freq\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upwr_freq\" class=\"c-button\" onclick=\"tch_up_wiresets(5)\"><img id=\"wire_up5\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"wiresets_item6\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"wr_pulse_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_pulse\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"wr_pulse_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dowr_pulse\" class=\"c-button\" onclick=\"tch_dwn_wiresets(6)\"><img id=\"wire_down6\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wr_min_pulse\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_wr_max_pulse\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outwr_pulse\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inwr_pulse\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upwr_pulse\" class=\"c-button\" onclick=\"tch_up_wiresets(6)\"><img id=\"wire_up6\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(57) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(84)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wr_delaytime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wiresets, 7, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</tbody>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_onthefly(setOtfVal) {
  var min_val = 0;
  switch (setOtfVal) {
    case 1:
      validate_check_slg("txt_otf_amps", min_val, i_max_amps, 'slg_inotf_amps', voltage_cmd_format);
      set_aw_data('s_of_volts', 'txt_otf_amps', treeSelectNum, setOtfVal);
      break;
    case 2:
      validate_check_slg("txt_otf_volts", min_val, i_max_volts, 'slg_inotf_volts', wfs_cmd_format);
      set_aw_data('s_of_wv_ctrl', 'txt_otf_volts', treeSelectNum, setOtfVal);
      break;
    case 3:
      validate_check_slg("txt_otf_wavecontrol", min_val, i_max_wv_ctrl, 'slg_inotf_wavecon', current_cmd_format);
      set_aw_data('s_of_amps', 'txt_otf_wavecontrol', treeSelectNum, setOtfVal);
      break;
    case 4:
      validate_check_slg("txt_otf_pkamps", min_val, i_max_pkamps, 'slg_inotf_pkamps', pk_curr_cmd_format);
      set_aw_data('s_of_pkamps', 'txt_otf_pkamps', treeSelectNum, setOtfVal);
      break;
    case 5:
      validate_check_slg("txt_otf_freq", min_val, i_max_freq, 'slg_inotf_freq', freq_cmd_format);
      set_aw_data('s_of_freq', 'txt_otf_freq', treeSelectNum, setOtfVal);
      break;
    case 6:
      validate_check_slg("txt_otf_pulse", min_val, i_max_pulse, 'slg_inotf_pulse', pulse_cmd_format);
      set_aw_data('s_of_pulse', 'txt_otf_pulse', treeSelectNum, setOtfVal);
      break;
    case 7:
      validate_check("txt_otf_travelspeed", i_min_travel_sp, i_max_travel_sp);
      set_val_items('s_of_trvl_sp', 'txt_otf_travelspeed', 0, i_min_travel_sp, i_max_travel_sp, 1, setOtfVal);
      break;
    case 8:
      set_text_value("txt_otf_amps", min_val, i_max_amps, 'slg_inotf_amps', voltage_cmd_format);
      set_text_value("txt_otf_volts", min_val, i_max_volts, 'slg_inotf_volts', wfs_cmd_format);
      set_text_value("txt_otf_wavecontrol", min_val, i_max_wv_ctrl, 'slg_inotf_wavecon', current_cmd_format);
      set_text_value("txt_otf_pkamps", min_val, i_max_pkamps, 'slg_inotf_pkamps', pk_curr_cmd_format);
      set_text_value("txt_otf_freq", min_val, i_max_freq, 'slg_inotf_freq', freq_cmd_format);
      set_text_value("txt_otf_pulse", min_val, i_max_pulse, 'slg_inotf_pulse', pulse_cmd_format);
      break;
    default:
      break;
  }
}

function tch_dwn_onthefly(setOtfTglVal) {
  check_button_status();
  set_dwn_button("fly_down" + setOtfTglVal);

  var min_val = 0;
  switch (setOtfTglVal) {
    case 1:
      tch_dwn_btn("txt_otf_amps", 5, min_val, i_max_amps, 'slg_inotf_amps', voltage_cmd_format);
      set_aw_data('s_of_volts', 'txt_otf_amps', treeSelectNum, setOtfTglVal);
      break;
    case 2:
      tch_dwn_btn("txt_otf_volts", 0.5, min_val, i_max_volts, 'slg_inotf_volts', wfs_cmd_format);
      set_aw_data('s_of_wv_ctrl', 'txt_otf_volts', treeSelectNum, setOtfTglVal);
      break;
    case 3:
      tch_dwn_btn("txt_otf_wavecontrol", 0.5, min_val, i_max_wv_ctrl, 'slg_inotf_wavecon', current_cmd_format);
      set_aw_data('s_of_amps', 'txt_otf_wavecontrol', treeSelectNum, setOtfTglVal);
      break;
    case 4:
      tch_dwn_btn("txt_otf_pkamps", 0.5, min_val, i_max_pkamps, 'slg_inotf_pkamps', pk_curr_cmd_format);
      set_aw_data('s_of_pkamps', 'txt_otf_pkamps', treeSelectNum, setOtfTglVal);
      break;
    case 5:
      tch_dwn_btn("txt_otf_freq", 0.5, min_val, i_max_freq, 'slg_inotf_freq', freq_cmd_format);
      set_aw_data('s_of_freq', 'txt_otf_freq', treeSelectNum, setOtfTglVal);
      break;
    case 6:
      tch_dwn_btn("txt_otf_pulse", 0.5, min_val, i_max_pulse, 'slg_inotf_pulse', pulse_cmd_format);
      set_aw_data('s_of_pulse', 'txt_otf_pulse', treeSelectNum, setOtfTglVal);
      break;
    default:
      break;
  }
}

function tch_up_onthefly(setOtfTglVal) {
  check_button_status();
  set_up_button("fly_up" + setOtfTglVal);

  var min_val = 0;
  switch (setOtfTglVal) {
    case 1:
      tch_up_btn("txt_otf_amps", 5, min_val, i_max_amps, 'slg_inotf_amps', voltage_cmd_format);
      set_aw_data('s_of_volts', 'txt_otf_amps', treeSelectNum, setOtfTglVal);
      break;
    case 2:
      tch_up_btn("txt_otf_volts", 0.5, min_val, i_max_volts, 'slg_inotf_volts', wfs_cmd_format);
      set_aw_data('s_of_wv_ctrl', 'txt_otf_volts', treeSelectNum, setOtfTglVal);
      break;
    case 3:
      tch_up_btn("txt_otf_wavecontrol", 0.5, min_val, i_max_wv_ctrl, 'slg_inotf_wavecon', current_cmd_format);
      set_aw_data('s_of_amps', 'txt_otf_wavecontrol', treeSelectNum, setOtfTglVal);
      break;
    case 4:
      tch_up_btn("txt_otf_pkamps", 0.5, min_val, i_max_pkamps, 'slg_inotf_pkamps', pk_curr_cmd_format);
      set_aw_data('s_of_pkamps', 'txt_otf_pkamps', treeSelectNum, setOtfTglVal);
      break;
    case 5:
      tch_up_btn("txt_otf_freq", 0.5, min_val, i_max_freq, 'slg_inotf_freq', freq_cmd_format);
      set_aw_data('s_of_freq', 'txt_otf_freq', treeSelectNum, setOtfTglVal);
      break;
    case 6:
      tch_up_btn("txt_otf_pulse", 0.5, min_val, i_max_pulse, 'slg_inotf_pulse', pulse_cmd_format);
      set_aw_data('s_of_pulse', 'txt_otf_pulse', treeSelectNum, setOtfTglVal);
      break;
    default:
      break;
  }
}

function get_on_the_fly_scrn() {
  var rght_tbl = "<table id=\"onthefly_r_screen\" align=\"center\">";
  rght_tbl += "<tr id=\"onthefly_item1\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"of_amps_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"of_amps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dootf_amps\" class=\"c-button\" onclick=\"tch_dwn_onthefly(1)\"><img id=\"fly_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_otf_min_amps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_otf_max_amps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outotf_amps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inotf_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upotf_amps\" class=\"c-button\" onclick=\"tch_up_onthefly(1)\"><img id=\"fly_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"onthefly_item2\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"of_volts_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_volts\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"of_volts_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dootf_volts\" class=\"c-button\" onclick=\"tch_dwn_onthefly(2)\"><img id=\"fly_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_otf_min_volts\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_otf_max_volts\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outotf_volts\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inotf_volts\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upotf_volts\" class=\"c-button\" onclick=\"tch_up_onthefly(2)\"><img id=\"fly_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"onthefly_item3\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"of_wavecontrol_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_wavecontrol\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"of_wavecontrol_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dootf_wavecon\" class=\"c-button\" onclick=\"tch_dwn_onthefly(3)\"><img id=\"fly_down3\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_otf_min_wavecon\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_otf_max_wavecon\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outotf_wavecon\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inotf_wavecon\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upotf_wavecon\" class=\"c-button\" onclick=\"tch_up_onthefly(3)\"><img id=\"fly_up3\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"onthefly_item4\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"of_pkamps_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_pkamps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"of_pkamps_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dootf_pkamps\" class=\"c-button\" onclick=\"tch_dwn_onthefly(4)\"><img id=\"fly_down4\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_otf_min_pkamps\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_otf_max_pkamps\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outotf_pkamps\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inotf_pkamps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upotf_pkamps\" class=\"c-button\" onclick=\"tch_up_onthefly(4)\"><img id=\"fly_up4\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"onthefly_item5\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"of_freq_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"of_freq_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dootf_freq\" class=\"c-button\" onclick=\"tch_dwn_onthefly(5)\"><img id=\"fly_down5\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_otf_min_freq\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_otf_max_freq\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outotf_freq\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inotf_freq\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upotf_freq\" class=\"c-button\" onclick=\"tch_up_onthefly(5)\"><img id=\"fly_up5\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"onthefly_item6\" style=\"display:none;\">";
  rght_tbl += "<td class=\"item_base item_name\"><p id=\"of_pulse_name\" style=\"display: inline;\"></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_pulse\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"of_pulse_unit\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_dootf_pulse\" class=\"c-button\" onclick=\"tch_dwn_onthefly(6)\"><img id=\"fly_down6\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_otf_min_pulse\" style=\"float:left\"></label>";
  rght_tbl += "<label id=\"lab_otf_max_pulse\" style=\"float:right\"></label>";
  rght_tbl += "</p>";
  rght_tbl += "<div id=\"slg_outotf_pulse\" class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_inotf_pulse\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div id=\"slb_upotf_pulse\" class=\"c-button\" onclick=\"tch_up_onthefly(6)\"><img id=\"fly_up6\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(56) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(92)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_otf_travelspeed\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_onthefly, 7, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">cm/min</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_s2t_st(s2t_st_item_num) {
  switch (s2t_st_item_num) {
    case 1:
      validate_check_slg("txt_s2t_st_cur", 5, 200, 'slg_s2t_st_cur', 0);
      set_aw_data('s_scrn_int', 'txt_s2t_st_cur', treeSelectNum, s2t_st_item_num);
      break;
    case 2:
      validate_check_slg("txt_s2t_st_alc", -10, 10, 'slg_s2t_st_alc', 1);
      set_aw_data('s_scrn_real', 'txt_s2t_st_alc', treeSelectNum, s2t_st_item_num);
      break;
    case 3:
      validate_check("txt_s2t_st_tim", 0, 10);
      set_val_items('s_scrn_real', 'txt_s2t_st_tim', 0, 0, 10, 1, s2t_st_item_num);
      break;
    case 4:
      validate_check("txt_s2t_st_slp", 0, 9.9);
      set_val_items('s_scrn_real', 'txt_s2t_st_slp', 0, 0, 9.9, 1, s2t_st_item_num);
      break;
    default:
      set_text_value("txt_s2t_st_cur", 5, 200, 'slg_s2t_st_cur', 0);
      set_text_value("txt_s2t_st_alc", -10, 10, 'slg_s2t_st_alc', 1);
      break;
  }
}

function tch_dwn_s2t_st(s2t_st_item_num) {
  check_button_status();
  set_dwn_button("s2t_st_down" + s2t_st_item_num);

  switch (s2t_st_item_num) {
    case 1:
      tch_dwn_btn("txt_s2t_st_cur", 5, 5, 200, 'slg_s2t_st_cur', 0);
      set_aw_data('s_scrn_int', 'txt_s2t_st_cur', treeSelectNum, s2t_st_item_num);
      break;
    case 2:
      tch_dwn_btn("txt_s2t_st_alc", 0.5, -10, 10, 'slg_s2t_st_alc', 1);
      set_aw_data('s_scrn_real', 'txt_s2t_st_alc', treeSelectNum, s2t_st_item_num);
      break;
    default:
      break;
  }
}

function tch_up_s2t_st(s2t_st_item_num) {
  check_button_status();
  set_up_button("s2t_st_up" + s2t_st_item_num);

  switch (s2t_st_item_num) {
    case 1:
      tch_up_btn("txt_s2t_st_cur", 5, 5, 200, 'slg_s2t_st_cur', 0);
      set_aw_data('s_scrn_int', 'txt_s2t_st_cur', treeSelectNum, s2t_st_item_num);
      break;
    case 2:
      tch_up_btn("txt_s2t_st_alc", 0.5, -10, 10, 'slg_s2t_st_alc', 1);
      set_aw_data('s_scrn_real', 'txt_s2t_st_alc', treeSelectNum, s2t_st_item_num);
      break;
    default:
      break;
  }
}

function get_s2t_st_rght_scrn() {
  var rght_tbl = "<table id=\"s2t_st_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(257) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_st_cur\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_st, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">%</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_s2t_st(1)\"><img id=\"s2t_st_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_s2t_st_min_cur\" style=\"float:left\">5</label>";
  rght_tbl += "<label id=\"lab_s2t_st_max_cur\" style=\"float:right\">200</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_s2t_st_cur\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_s2t_st(1)\"><img id=\"s2t_st_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(258) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_st_alc\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_st, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_s2t_st(2)\"><img id=\"s2t_st_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_s2t_st_min_alc\" style=\"float:left\">-10.0</label>";
  rght_tbl += "<label id=\"lab_s2t_st_max_alc\" style=\"float:right\">10.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_s2t_st_alc\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_s2t_st(2)\"><img id=\"s2t_st_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(259) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_st_tim\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_st, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(260) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_st_slp\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_st, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_s2t_ed(s2t_ed_item_num) {
  switch (s2t_ed_item_num) {
    case 1:
      validate_check_slg("txt_s2t_ed_cur", 0, 200, 'slg_s2t_ed_cur', 0);
      set_aw_data('s_scrn_int', 'txt_s2t_ed_cur', treeSelectNum, s2t_ed_item_num);
      break;
    case 2:
      validate_check_slg("txt_s2t_ed_alc", -10, 10, 'slg_s2t_ed_alc', 1);
      set_aw_data('s_scrn_real', 'txt_s2t_ed_alc', treeSelectNum, s2t_ed_item_num);
      break;
    case 3:
      validate_check("txt_s2t_ed_tim", 0, 10);
      set_val_items('s_scrn_real', 'txt_s2t_ed_tim', 0, 0, 10, 1, s2t_ed_item_num);
      break;
    case 4:
      validate_check("txt_s2t_ed_slp", 0, 9.9);
      set_val_items('s_scrn_real', 'txt_s2t_ed_slp', 0, 0, 9.9, 1, s2t_ed_item_num);
      break;
    case 5:
      validate_check("txt_s2t_wireretract", 0, 10);
      set_val_items('s_scrn_real', 'txt_s2t_wireretract', 0, 0, 10, 1, s2t_ed_item_num);
      break;
    default:
      set_text_value("txt_s2t_ed_cur", 0, 200, 'slg_s2t_ed_cur', 0);
      set_text_value("txt_s2t_ed_alc", -10, 10, 'slg_s2t_ed_alc', 1);
      break;
  }
}

function tch_dwn_s2t_ed(s2t_ed_item_num) {
  check_button_status();
  set_dwn_button("s2t_ed_down" + s2t_ed_item_num);

  switch (s2t_ed_item_num) {
    case 1:
      tch_dwn_btn("txt_s2t_ed_cur", 5, 0, 200, 'slg_s2t_ed_cur', 0);
      set_aw_data('s_scrn_int', 'txt_s2t_ed_cur', treeSelectNum, s2t_ed_item_num);
      break;
    case 2:
      tch_dwn_btn("txt_s2t_ed_alc", 0.5, -10, 10, 'slg_s2t_ed_alc', 1);
      set_aw_data('s_scrn_real', 'txt_s2t_ed_alc', treeSelectNum, s2t_ed_item_num);
      break;
    default:
      break;
  }
}

function tch_up_s2t_ed(s2t_ed_item_num) {
  check_button_status();
  set_up_button("s2t_ed_up" + s2t_ed_item_num);

  switch (s2t_ed_item_num) {
    case 1:
      tch_up_btn("txt_s2t_ed_cur", 5, 0, 200, 'slg_s2t_ed_cur', 0);
      set_aw_data('s_scrn_int', 'txt_s2t_ed_cur', treeSelectNum, s2t_ed_item_num);
      break;
    case 2:
      tch_up_btn("txt_s2t_ed_alc", 0.5, -10, 10, 'slg_s2t_ed_alc', 1);
      set_aw_data('s_scrn_real', 'txt_s2t_ed_alc', treeSelectNum, s2t_ed_item_num);
      break;
    default:
      break;
  }
}

function get_s2t_ed_rght_scrn() {
  var rght_tbl = "<table id=\"s2t_ed_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(257) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_ed_cur\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_ed, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">%</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_s2t_ed(1)\"><img id=\"s2t_ed_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_s2t_ed_min_cur\" style=\"float:left\">0</label>";
  rght_tbl += "<label id=\"lab_s2t_ed_max_cur\" style=\"float:right\">200</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_s2t_ed_cur\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_s2t_ed(1)\"><img id=\"s2t_ed_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(258) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_ed_alc\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_ed, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_s2t_ed(2)\"><img id=\"s2t_ed_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_s2t_ed_min_alc\" style=\"float:left\">-10.0</label>";
  rght_tbl += "<label id=\"lab_s2t_ed_max_alc\" style=\"float:right\">10.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_s2t_ed_alc\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_s2t_ed(2)\"><img id=\"s2t_ed_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(259) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_ed_tim\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_ed, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(282) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_ed_slp\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_ed, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(263) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_s2t_wireretract\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_s2t_ed, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_sequence_lft_scrn(xml_doc_data) {
  var custom_flg_check = 2;
  var arcendpretime_none = 2;
  var sch_l_tbl = "<div id=\"left_screen\">";

  sch_l_tbl += "<div id=\"sequence_l_screen\" class=\"c-l_scrn_mrgn\" style=\"width: 320px;\">";

  node_data = xml_doc_data.getElementsByTagName("sequence");
  i_custom_flg = get_node_value("custFlg");
  if ((i_custom_flg & 1) == 1) {
  } else {
    sch_l_tbl += "<div id=\"arcstartpretime_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(1)\">";
    sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(74) + "</div>";
    sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_arcstartpretime\">" + get_node_value("arcStartPreTime") + "</label>sec</div>";
    sch_l_tbl += "</div>";
  }
  sch_l_tbl += "<div id=\"gaspurge_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(2)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(71) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_gaspurge\">" + get_node_value("gasPurge") + "</label>sec</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "<div id=\"gaspreflow_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(3)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(72) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_gaspreflow\">" + get_node_value("gasPreflow") + "</label>sec</div>";
  sch_l_tbl += "</div>";

  if ((i_custom_flg & custom_flg_check) == arcendpretime_none) {
  } else {
    sch_l_tbl += "<div id=\"arcendpretime_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(4)\">";
    sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(75) + "</div>";
    sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_arcendpretime\">" + get_node_value("arcEndPreTime") + "</label>msec</div>";
    sch_l_tbl += "</div>";
  }

  sch_l_tbl += "<div id=\"gaspostflow_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(5)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(73) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_gaspostflow\">" + get_node_value("gasPostflow") + "</label>msec</div>";
  sch_l_tbl += "</div>";

  if (ps_type == PS_LINCOLN) {
    sch_l_tbl += "<div id=\"swfeedspeed_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(6)\">";
    sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(76) + "</div>";
    sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_swfeedspeed\">" + get_node_value("swFeedSpeed") + "</label>cm/min</div>";
    sch_l_tbl += "</div>";
  }

  node_data = xml_doc_data.getElementsByTagName("weldSchedules");
  sch_l_tbl += "<div id=\"ramping_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(7)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(51) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_ramping\">";
  if (get_node_value("rampEnb") == 0) {
    sch_l_tbl += get_prct_dict_text(58);
  } else {
    sch_l_tbl += get_prct_dict_text(59);
  }
  sch_l_tbl += "</label></div>";
  sch_l_tbl += "</div>";

  i_heatwave_opt = parseInt(get_node_value("heatWaveOption"), RADIX_DECIMAL_NUMBER);
  if (i_heatwave_opt > HEATWAVE_OPTN_NOT_EXIST) {
    sch_l_tbl += "<div id=\"heatwave_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showSequenceDiagram(8)\">";
    sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(52) + "</div>";
    sch_l_tbl += "<div class=\"c-tree__stage_txt\"><label id=\"lab_heatwave\">";
    if (get_node_value("weaveSynch") == 0) {
      sch_l_tbl += get_prct_dict_text(58);
    } else {
      sch_l_tbl += get_prct_dict_text(59);
    }
    sch_l_tbl += "</label></div>";
    sch_l_tbl += "</div>";
  }

  sch_l_tbl += "</div>";

  sch_l_tbl += "</div>";
  return sch_l_tbl;
}

function set_seq_data(kl_var_name, id_name, item_num, digit_num) {
  var min_val = 0;
  var max_val;
  var current_val;
  switch (item_num) {
    case 1:
      min_val = 0;
      max_val = 500;
      validate_check("txt_arcstartpretime", min_val, max_val);
      current_val = document.getElementById(id_name).value;
      document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);
      document.getElementById("lab_arcstartpretime").innerHTML = document.getElementById("txt_arcstartpretime").value;
      break;
    case 2:
      min_val = 0.00;
      max_val = 2.00;
      validate_check("txt_gaspurge", min_val, max_val);
      current_val = document.getElementById(id_name).value;
      document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);
      document.getElementById("lab_gaspurge").innerHTML = document.getElementById("txt_gaspurge").value;
      break;
    case 3:
      min_val = 0.00;
      max_val = 99.99;
      validate_check("txt_gaspreflow", min_val, max_val);
      current_val = document.getElementById(id_name).value;
      document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);
      document.getElementById("lab_gaspreflow").innerHTML = document.getElementById("txt_gaspreflow").value;
      break;
    case 4:
      min_val = 0.00;
      max_val = 2000;
      validate_check("txt_arcendpretime", min_val, max_val);
      current_val = document.getElementById(id_name).value;
      document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);
      document.getElementById("lab_arcendpretime").innerHTML = document.getElementById("txt_arcendpretime").value;
      break;
    case 5:
      min_val = 0.00;
      max_val = 99.99;
      validate_check("txt_gaspostflow", min_val, max_val);
      current_val = document.getElementById(id_name).value;
      document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);
      document.getElementById("lab_gaspostflow").innerHTML = document.getElementById("txt_gaspostflow").value;
      break;
    case 6:
      min_val = 1.00;
      max_val = 999.00;
      validate_check("txt_swfeedspeed", min_val, max_val);
      current_val = document.getElementById(id_name).value;
      document.getElementById(id_name).value = parseFloat(current_val).toFixed(digit_num);
      document.getElementById("lab_swfeedspeed").innerHTML = document.getElementById("txt_swfeedspeed").value;
      break;
  }
  set_aw_data(kl_var_name, id_name, treeSelectNum);
}

function get_arcstartpre_rght_scrn(arcstartpre_val) {
  var rght_tbl = "<table id=\"arcstartpre_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(74) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(116)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"txt_arcstartpretime\" type=\"text\" class=\"c-textbox\" onfocus=\"set_elem(this, set_seq_data, 's_sq_arc_stt', 'txt_arcstartpretime', 1, 0)\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\" value=\"";
  rght_tbl += arcstartpre_val + "\"></td>";
  rght_tbl += "<td class=\"lmargin_table\">sec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_gaspurge_rght_scrn(gaspurge_val) {
  var rght_tbl = "<table id=\"gaspurge_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(71) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(113)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"txt_gaspurge\" type=\"text\" class=\"c-textbox\" onfocus=\"set_elem(this, set_seq_data, 's_sq_gs_purg', 'txt_gaspurge', 2, 2)\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\" value=\"";
  rght_tbl += gaspurge_val + "\"></td>";
  rght_tbl += "<td class=\"lmargin_table\">sec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">";
  rght_tbl += "<div class=\"c-sequence_image c-sequence_image_gas_purge\">";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:26px;\">" + get_prct_dict_text(176) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"left:110px; top:10px;\">" + get_prct_dict_text(177) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"left:284px; top:44px;\">" + get_prct_dict_text(178) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:120px;\">" + get_prct_dict_text(179) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"color:#e50606; font-weight:bold; left:194px; top:138px;\">" + get_prct_dict_text(181) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:184px;\">" + get_prct_dict_text(180) + "</div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">" + get_prct_dict_text(77) + "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">" + get_prct_dict_text(78) + "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_gaspreflow_rght_scrn(gaspreflow_val) {
  var rght_tbl = "<table id=\"gaspreflow_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(72) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(114)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"txt_gaspreflow\" type=\"text\" class=\"c-textbox\" onfocus=\"set_elem(this, set_seq_data, 's_sq_preflow', 'txt_gaspreflow', 3, 2)\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\" ";
  rght_tbl += "value=\"" + gaspreflow_val + "\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"lmargin_table\">sec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">";
  rght_tbl += "<div class=\"c-sequence_image c-sequence_image_gas_preflow\">";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:26px;\">" + get_prct_dict_text(176) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"left:110px; top:10px;\">" + get_prct_dict_text(177) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"left:254px; top:34px;\">" + get_prct_dict_text(178) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:110px;\">" + get_prct_dict_text(179) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"color:#e50606; font-weight:bold; left:260px; top:134px;\">" + get_prct_dict_text(182) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:184px;\">" + get_prct_dict_text(180) + "</div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">" + get_prct_dict_text(79) + "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">" + get_prct_dict_text(80) + "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_arcendpre_rght_scrn(arcendpre_val) {
  var rght_tbl = "<table id=\"arcendpre_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(75) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(117)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"txt_arcendpretime\" type=\"text\" class=\"c-textbox\" onfocus=\"set_elem(this, set_seq_data, 's_sq_arc_end', 'txt_arcendpretime', 4, 0)\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\" ";
  rght_tbl += "value=\"" + arcendpre_val + "\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"lmargin_table\">msec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_gaspostflow_rght_scrn(gaspostflow_val) {
  var rght_tbl = "<table id=\"gaspostflow_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(73) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(115)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"txt_gaspostflow\" type=\"text\" class=\"c-textbox\" onfocus=\"set_elem(this, set_seq_data, 's_sq_pst_flw', 'txt_gaspostflow', 5, 2)\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\" ";
  rght_tbl += "value=\"" + gaspostflow_val + "\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"lmargin_table\">msec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">";
  rght_tbl += "<div class=\"c-sequence_image c-sequence_image_gas_postflow\">";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:26px;\">" + get_prct_dict_text(176) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"left:110px; top:10px;\">" + get_prct_dict_text(177) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"left:286px; top:36px;\">" + get_prct_dict_text(178) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:114px;\">" + get_prct_dict_text(179) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos\" style=\"color:#e50606; font-weight:bold; left:176px; text-align:center; top:142px; width:320px;\">" + get_prct_dict_text(183) + "</div>";
  rght_tbl += "<div class=\"c-help_img_pos c-sequence_image_item_name\" style=\"top:190px;\">" + get_prct_dict_text(180) + "</div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">" + get_prct_dict_text(81) + "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td colspan=\"3\">" + get_prct_dict_text(82) + "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_swfeedspeed_rght_scrn(swfeedspeed_val) {
  var rght_tbl = "<table id=\"swfeedspeed_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(76) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(118)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"txt_swfeedspeed\" type=\"text\" class=\"c-textbox\" onfocus=\"set_elem(this, set_seq_data, 's_sq_str_wfs', 'txt_swfeedspeed', 6, 0)\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\" ";
  rght_tbl += "value=\"" + swfeedspeed_val + "\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"lmargin_table\">cm/min</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_ramp_enable_rght_scrn(ramp_enable_val) {
  var ramp_enable_text;
  if (ramp_enable_val == 0) {
    ramp_enable_text = get_prct_dict_text(58);
  } else {
    ramp_enable_text = get_prct_dict_text(59);
  }

  var rght_tbl = "<table id=\"ramping_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(51) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(119)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"select_ramp\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(12)\" value=\"" + ramp_enable_text + "\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"lmargin_table\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function get_weav_synch_rght_scrn(weav_synch_val) {
  var weav_synch_text;
  if (weav_synch_val == 0) {
    weav_synch_text = get_prct_dict_text(58);
  } else {
    weav_synch_text = get_prct_dict_text(59);
  }

  var rght_tbl = "<table id=\"heatwave_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"long_table\">" + get_prct_dict_text(52) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(112)\"></span></td>";
  rght_tbl += "<td class=\"multipass_unit\">";
  rght_tbl += "<input id=\"select_heatwave\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(13)\" value=\"" + weav_synch_text + "\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"lmargin_table\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function showArcmonitorDiagram(arc_num) {
  if(help_stts == HELP_STTS_NONE) {
    window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + arc_num;
  }
  var item_method = document.getElementById("method_item");
  var item_judgecondition = document.getElementById("judgecondition_item");
  var item_weldwarn = document.getElementById("weldwarn_item");
  var item_weldstop = document.getElementById("weldstop_item");
  var item_craterwarn = document.getElementById("craterwarn_item");
  var item_craterstop = document.getElementById("craterstop_item");

  item_method.style.backgroundColor = Gr02;
  item_judgecondition.style.backgroundColor = Gr02;
  item_weldwarn.style.backgroundColor = Gr02;
  item_weldstop.style.backgroundColor = Gr02;
  item_craterwarn.style.backgroundColor = Gr02;
  item_craterstop.style.backgroundColor = Gr02;

  treeSelectNum = arc_num;
  switch (arc_num) {
    case 1:
      item_method.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_AMON_METHOD);
      break;
    case 2:
      item_judgecondition.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_AMON_JDGMNT_CNDTN);
      break;
    case 3:
      item_weldwarn.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_AMON_WLD_WRN);
      break;
    case 4:
      item_weldstop.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_AMON_WLD_STP);
      break;
    case 5:
      item_craterwarn.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_AMON_CRTR_WRN);
      break;
    case 6:
      item_craterstop.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_AMON_CRTR_STP);
      break;
    default:
      break;
  }
}

function get_arcmonitor_lft_scrn(xml_doc_data) {
  var sch_l_tbl = "<div id=\"left_screen\">";
  var unit_symbol;

  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("method");
  amon_type = get_node_value("amonType");
  if (amon_type == 1) {
    unit_symbol = "%";
  } else {
    unit_symbol = "V";
  }

  sch_l_tbl += "<div id=\"arcmonitor_l_screen\" class=\"c-l_scrn_mrgn\" style=\"width: 340px;\">";
  sch_l_tbl += "<div id=\"method_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showArcmonitorDiagram(1)\">";
  sch_l_tbl += "<div class=\"center_txt\">" + get_prct_dict_text(99) + "</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "<div id=\"judgecondition_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showArcmonitorDiagram(2)\">";
  sch_l_tbl += "<div class=\"center_txt\">" + get_prct_dict_text(100) + "</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "<div id=\"weldwarn_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showArcmonitorDiagram(3)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(101) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\">";
  sch_l_tbl += "<label>(V)</label>";
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("weldWarn");
  sch_l_tbl += "<label id=\"weldwarn_volts_min\">" + get_node_value("warnVoltsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"weldwarn_volts_max\">" + get_node_value("warnVoltsMax") + "</label>";
  sch_l_tbl += "<label id=\"weldwarn_volts_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "<label>(A)</label>";
  sch_l_tbl += "<label id=\"weldwarn_amps_min\">" + get_node_value("warnAmpsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"weldwarn_amps_max\">" + get_node_value("warnAmpsMax") + "</label>";
  sch_l_tbl += "<label id=\"weldwarn_amps_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "<div id=\"weldstop_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showArcmonitorDiagram(4)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(102) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\">";
  sch_l_tbl += "<label>(V)</label>";
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("weldStop");
  sch_l_tbl += "<label id=\"weldstop_volts_min\">" + get_node_value("stopVoltsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"weldstop_volts_max\">" + get_node_value("stopVoltsMax") + "</label>";
  sch_l_tbl += "<label id=\"weldstop_volts_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "<label>(A)</label>";
  sch_l_tbl += "<label id=\"weldstop_amps_min\">" + get_node_value("stopAmpsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"weldstop_amps_max\">" + get_node_value("stopAmpsMax") + "</label>";
  sch_l_tbl += "<label id=\"weldstop_amps_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "<div id=\"craterwarn_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showArcmonitorDiagram(5)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(103) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\">";
  sch_l_tbl += "<label>(V)</label>";
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("craterWarn");
  sch_l_tbl += "<label id=\"craterwarn_volts_min\">" + get_node_value("warnVoltsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"craterwarn_volts_max\">" + get_node_value("warnVoltsMax") + "</label>";
  sch_l_tbl += "<label id=\"craterwarn_volts_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "<label>(A)</label>";
  sch_l_tbl += "<label id=\"craterwarn_amps_min\">" + get_node_value("warnAmpsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"craterwarn_amps_max\">" + get_node_value("warnAmpsMax") + "</label>";
  sch_l_tbl += "<label id=\"craterwarn_amps_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "<div id=\"craterstop_item\" class=\"c-tree c-not_slct_bg_color\" onclick=\"showArcmonitorDiagram(6)\">";
  sch_l_tbl += "<div class=\"c-tree__stage\">" + get_prct_dict_text(104) + "</div>";
  sch_l_tbl += "<div class=\"c-tree__stage_txt\">";
  sch_l_tbl += "<label>(V)</label>";
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("craterStop");
  sch_l_tbl += "<label id=\"craterstop_volts_min\">" + get_node_value("stopVoltsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"craterstop_volts_max\">" + get_node_value("stopVoltsMax") + "</label>";
  sch_l_tbl += "<label id=\"craterstop_volts_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "<label>(A)</label>";
  sch_l_tbl += "<label id=\"craterstop_amps_min\">" + get_node_value("stopAmpsMin") + "</label>";
  sch_l_tbl += "<label>" + get_prct_dict_text(175) + "</label>";
  sch_l_tbl += "<label id=\"craterstop_amps_max\">" + get_node_value("stopAmpsMax") + "</label>";
  sch_l_tbl += "<label id=\"craterstop_amps_unit\">" + unit_symbol + "</label>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "</div>";
  sch_l_tbl += "</div>";

  sch_l_tbl += "</div>";
  return sch_l_tbl;
}

function set_val_amon_delay() {
  var i_min_arcmonitor = 0.0;
  var i_max_arcmonitor = 99.99;
  var set_no = 3;

  validate_check("txt_amon_dly", i_min_arcmonitor, i_max_arcmonitor);
  set_val_items('s_mon_dly_tm', 'txt_amon_dly', 0, i_min_arcmonitor, i_max_arcmonitor, 2, set_no);
}

function get_method_rght_scrn() {
  var rght_tbl = "<table id=\"method_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(105) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(93)\"></span></td>";
  rght_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  rght_tbl += "<input id=\"select_arcmonitor\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(14)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tbody id=\"amonmethod_enable_screen\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(106) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(96)\"></span></td>";
  rght_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  rght_tbl += "<input id=\"select_method\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(15)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(107) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(97)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_amon_dly\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_amon_delay, '', '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">sec</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(108) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(98)\"></span></td>";
  rght_tbl += "<td class=\"item_base longlmgn_table\" colspan=\"5\">";
  rght_tbl += "<input id=\"select_cratermonitor\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(16)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</tbody>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_method_rght_scrn(xml_doc_data) {
  var tmp_val;
  var disp_amonmethod = document.getElementById("amonmethod_enable_screen");
  var item_judgecondition = document.getElementById("judgecondition_item");
  var item_weldwarn = document.getElementById("weldwarn_item");
  var item_weldstop = document.getElementById("weldstop_item");
  var item_craterwarn = document.getElementById("craterwarn_item");
  var item_craterstop = document.getElementById("craterstop_item");

  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("method");
  if (get_node_value("amonEnb") == 0) {
    tmp_val = get_prct_dict_text(58);
    disp_amonmethod.style.visibility = "visible";
    item_judgecondition.style.display = "block";
    item_weldwarn.style.display = "block";
    item_weldstop.style.display = "block";
  } else {
    tmp_val = get_prct_dict_text(59);
    disp_amonmethod.style.visibility = "hidden";
    item_judgecondition.style.display = "none";
    item_weldwarn.style.display = "none";
    item_weldstop.style.display = "none";
    item_craterwarn.style.display = "none";
    item_craterstop.style.display = "none";
  }
  document.getElementById("select_arcmonitor").value = tmp_val;

  switch (parseInt(get_node_value("amonType"), RADIX_DECIMAL_NUMBER)) {
    case 1:
      tmp_val = document.getElementById("amon_type_dp").innerHTML;
      break;
    case 2:
      tmp_val = get_prct_dict_text(114);
      break;
    case 3:
      tmp_val = get_prct_dict_text(115);
      break;
    default:
      break;
  }
  document.getElementById("select_method").value = tmp_val;

  document.getElementById("txt_amon_dly").value = get_node_value("amonDelayTime");

  if (get_node_value("aeAmonEnb") == 0) {
    tmp_val = get_prct_dict_text(58);
    item_craterwarn.style.display = "block";
    item_craterstop.style.display = "block";
  } else {
    tmp_val = get_prct_dict_text(59);
    item_craterwarn.style.display = "none";
    item_craterstop.style.display = "none";
  }
  document.getElementById("select_cratermonitor").value = tmp_val;
}

function set_val_judgecondition(setWtVal) {
  var i_min_num = 0.0;
  var i_min_alrmcnt_time = 0.1;
  var i_max_alrmcnt_time = 99.9;
  var i_max_time = 99.99;
  var i_max_count = 20;
  treeSelectNum = 2;

  switch (setWtVal) {
    case 1:
      validate_check("txt_warntime", i_min_num, i_max_time);
      set_val_items('s_wn_time', 'txt_warntime', 0, i_min_num, i_max_time, 2, setWtVal);
      break;
    case 2:
      validate_check("txt_stoptime", i_min_num, i_max_time);
      set_val_items('s_ws_time', 'txt_stoptime', 0, i_min_num, i_max_time, 2, setWtVal);
      break;
    case 3:
      validate_check("txt_warncnt", i_min_num, i_max_count);
      set_val_items('s_wn_cnt', 'txt_warncnt', 0, i_min_num, i_max_count, 0, setWtVal);
      break;
    case 4:
      validate_check("txt_stopcnt", i_min_num, i_max_count);
      set_val_items('s_ws_cnt', 'txt_stopcnt', 0, i_min_num, i_max_count, 0, setWtVal);
      break;
    case 5:
      validate_check("txt_warncntime", i_min_alrmcnt_time, i_max_alrmcnt_time);
      set_val_items('s_wncnt_time', 'txt_warncntime', 0, i_min_alrmcnt_time, i_max_alrmcnt_time, 1, setWtVal);
      break;
    case 6:
      validate_check("txt_stopcntime", i_min_alrmcnt_time, i_max_alrmcnt_time);
      set_val_items('s_wscnt_time', 'txt_stopcntime', 0, i_min_alrmcnt_time, i_max_alrmcnt_time, 1, setWtVal);
      break;
    default:
      break;
  }
}

function get_judgecondition_rght_scrn() {
  var rght_tbl = "<table id=\"judgecondition_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td style=\"width: 150px; height: 54px\">" + get_prct_dict_text(109) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(100)\"></span></td>";
  rght_tbl += "<td style=\"width: 111px; height: 54px\">";
  rght_tbl += "<input id=\"txt_warntime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_judgecondition, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td style=\"width: 30px; height: 54px\">sec</td>";
  rght_tbl += "<td class=\"item_base\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td style=\"width: 150px; height: 54px\">" + get_prct_dict_text(110) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(100)\"></span></td>";
  rght_tbl += "<td style=\"width: 111px; height: 54px\">";
  rght_tbl += "<input id=\"txt_stoptime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_judgecondition, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td style=\"width: 30px; height: 54px\">sec</td>";
  rght_tbl += "<td class=\"item_base\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td style=\"width: 150px; height: 32px;\">" + get_prct_dict_text(111) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(101)\"></span></td>";
  rght_tbl += "<td style=\"width: 111px; height: 32px;\">";
  rght_tbl += "<input id=\"txt_warncnt\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_judgecondition, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td style=\"width: 30px; height: 32px;\">" + get_prct_dict_text(148) + "</td>";
  rght_tbl += "<td style=\"width: 50px; height: 32px;\">";
  rght_tbl += "<input id=\"txt_warncntime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_judgecondition, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td style=\"width: 123px; height: 32px;\">sec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td style=\"width: 150px;\">" + get_prct_dict_text(112) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(101)\"></span></td>";
  rght_tbl += "<td style=\"width: 111px;\">";
  rght_tbl += "<input id=\"txt_stopcnt\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_judgecondition, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td style=\"width: 30px;\">" + get_prct_dict_text(148) + "</td>";
  rght_tbl += "<td style=\"width: 50px;\">";
  rght_tbl += "<input id=\"txt_stopcntime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_judgecondition, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td style=\"width: 123px\">sec</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_judgecondition_rght_scrn(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("judgeCondition");
  document.getElementById("txt_warntime").value = get_node_value("warnJudgeTime");
  document.getElementById("txt_stoptime").value = get_node_value("warnStopTime");
  document.getElementById("txt_warncnt").value = get_node_value("warnCnt");
  document.getElementById("txt_warncntime").value = get_node_value("warnCntTime");
  document.getElementById("txt_stopcnt").value = get_node_value("warnScont");
  document.getElementById("txt_stopcntime").value = get_node_value("warnScontTime");
}

function set_val_weldwarn(setWwVal) {
  var i_min_val = 0.0;
  var i_max_val = 99.9;

  switch (setWwVal) {
    case 1:
      validate_check("txt_warnv_min", i_min_val, i_max_val);
      set_val_items('s_ww_vol_min', 'txt_warnv_min', 0, i_min_val, i_max_val, 1, setWwVal);
      document.getElementById("weldwarn_volts_min").innerHTML = document.getElementById("txt_warnv_min").value;
      break;
    case 2:
      validate_check("txt_warnv_max", i_min_val, i_max_val);
      set_val_items('s_ww_vol_max', 'txt_warnv_max', 0, i_min_val, i_max_val, 1, setWwVal);
      document.getElementById("weldwarn_volts_max").innerHTML = document.getElementById("txt_warnv_max").value;
      break;
    case 3:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_warna_min", i_min_val, i_max_val);
      set_val_items('s_ww_amp_min', 'txt_warna_min', 0, i_min_val, i_max_val, 1, setWwVal);
      document.getElementById("weldwarn_amps_min").innerHTML = document.getElementById("txt_warna_min").value;
      break;
    case 4:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_warna_max", i_min_val, i_max_val);
      set_val_items('s_ww_amp_max', 'txt_warna_max', 0, i_min_val, i_max_val, 1, setWwVal);
      document.getElementById("weldwarn_amps_max").innerHTML = document.getElementById("txt_warna_max").value;
      break;
    default:
      break;
  }
}

function get_weldwarn_rght_scrn() {
  var rght_tbl = "<table id=\"weldwarn_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(120) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(103)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_warnv_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldwarn, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_warn_v_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_warnv_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldwarn, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_warn_v_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(121) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(103)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_warna_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldwarn, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_warn_a_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_warna_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldwarn, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_warn_a_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_weldwarn_rght_scrn(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("weldWarn");
  document.getElementById("txt_warnv_min").value = get_node_value("warnVoltsMin");
  document.getElementById("txt_warnv_max").value = get_node_value("warnVoltsMax");
  document.getElementById("txt_warna_min").value = get_node_value("warnAmpsMin");
  document.getElementById("txt_warna_max").value = get_node_value("warnAmpsMax");

  var unit_volts;
  var unit_amps;
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("method");
  if (get_node_value("amonType") == METHOD_DIFF_PERCENT) {
    unit_volts = "%";
    unit_amps = "%";
  } else {
    unit_volts = "V";
    unit_amps = "A";
  }
  document.getElementById("weld_warn_v_n").innerHTML = unit_volts;
  document.getElementById("weld_warn_v_p").innerHTML = unit_volts;
  document.getElementById("weld_warn_a_n").innerHTML = unit_amps;
  document.getElementById("weld_warn_a_p").innerHTML = unit_amps;
}

function set_val_weldstop(setWsVal) {
  var i_min_val = 0.0;
  var i_max_val = 99.9;

  switch (setWsVal) {
    case 1:
      validate_check("txt_stopv_min", i_min_val, i_max_val);
      set_val_items('s_ws_vol_min', 'txt_stopv_min', 0, i_min_val, i_max_val, 1, setWsVal);
      document.getElementById("weldstop_volts_min").innerHTML = document.getElementById("txt_stopv_min").value;
      break;
    case 2:
      validate_check("txt_stopv_max", i_min_val, i_max_val);
      set_val_items('s_ws_vol_max', 'txt_stopv_max', 0, i_min_val, i_max_val, 1, setWsVal);
      document.getElementById("weldstop_volts_max").innerHTML = document.getElementById("txt_stopv_max").value;
      break;
    case 3:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_stopa_min", i_min_val, i_max_val);
      set_val_items('s_ws_amp_min', 'txt_stopa_min', 0, i_min_val, i_max_val, 1, setWsVal);
      document.getElementById("weldstop_amps_min").innerHTML = document.getElementById("txt_stopa_min").value;
      break;
    case 4:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_stopa_max", i_min_val, i_max_val);
      set_val_items('s_ws_amp_max', 'txt_stopa_max', 0, i_min_val, i_max_val, 1, setWsVal);
      document.getElementById("weldstop_amps_max").innerHTML = document.getElementById("txt_stopa_max").value;
      break;
    default:
      break;
  }
}

function get_weldstop_rght_scrn() {
  var rght_tbl = "<table id=\"weldstop_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(122) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(104)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_stopv_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldstop, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_stop_v_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_stopv_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldstop, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_stop_v_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(123) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(104)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_stopa_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldstop, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_stop_a_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_stopa_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_weldstop, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"weld_stop_a_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_weldstop_rght_scrn(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("weldStop");
  document.getElementById("txt_stopv_min").value = get_node_value("stopVoltsMin");
  document.getElementById("txt_stopv_max").value = get_node_value("stopVoltsMax");
  document.getElementById("txt_stopa_min").value = get_node_value("stopAmpsMin");
  document.getElementById("txt_stopa_max").value = get_node_value("stopAmpsMax");

  var unit_volts;
  var unit_amps;
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("method");
  if (get_node_value("amonType") == METHOD_DIFF_PERCENT) {
    unit_volts = "%";
    unit_amps = "%";
  } else {
    unit_volts = "V";
    unit_amps = "A";
  }
  document.getElementById("weld_stop_v_n").innerHTML = unit_volts;
  document.getElementById("weld_stop_v_p").innerHTML = unit_volts;
  document.getElementById("weld_stop_a_n").innerHTML = unit_amps;
  document.getElementById("weld_stop_a_p").innerHTML = unit_amps;
}

function set_val_craterwarn(setCwVal) {
  var i_min_val = 0.0;
  var i_max_val = 99.9;

  switch (setCwVal) {
    case 1:
      validate_check("txt_craterwarnv_min", i_min_val, i_max_val);
      set_val_items('s_cw_vol_min', 'txt_craterwarnv_min', 0, i_min_val, i_max_val, 1, setCwVal);
      document.getElementById("craterwarn_volts_min").innerHTML = document.getElementById("txt_craterwarnv_min").value;
      break;
    case 2:
      validate_check("txt_craterwarnv_max", i_min_val, i_max_val);
      set_val_items('s_cw_vol_max', 'txt_craterwarnv_max', 0, i_min_val, i_max_val, 1, setCwVal);
      document.getElementById("craterwarn_volts_max").innerHTML = document.getElementById("txt_craterwarnv_max").value;
      break;
    case 3:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_craterwarna_min", i_min_val, i_max_val);
      set_val_items('s_cw_amp_min', 'txt_craterwarna_min', 0, i_min_val, i_max_val, 1, setCwVal);
      document.getElementById("craterwarn_amps_min").innerHTML = document.getElementById("txt_craterwarna_min").value;
      break;
    case 4:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_craterwarna_max", i_min_val, i_max_val);
      set_val_items('s_cw_amp_max', 'txt_craterwarna_max', 0, i_min_val, i_max_val, 1, setCwVal);
      document.getElementById("craterwarn_amps_max").innerHTML = document.getElementById("txt_craterwarna_max").value;
      break;
    default:
      break;
  }
}

function get_craterwarn_rght_scrn() {
  var rght_tbl = "<table id=\"craterwarn_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(124) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(105)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterwarnv_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterwarn, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_warn_v_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterwarnv_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterwarn, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_warn_v_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(125) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(105)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterwarna_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterwarn, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_warn_a_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterwarna_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterwarn, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_warn_a_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_craterwarn_rght_scrn(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("craterWarn");
  document.getElementById("txt_craterwarnv_min").value = get_node_value("warnVoltsMin");
  document.getElementById("txt_craterwarnv_max").value = get_node_value("warnVoltsMax");
  document.getElementById("txt_craterwarna_min").value = get_node_value("warnAmpsMin");
  document.getElementById("txt_craterwarna_max").value = get_node_value("warnAmpsMax");

  var unit_volts;
  var unit_amps;
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("method");
  if (get_node_value("amonType") == METHOD_DIFF_PERCENT) {
    unit_volts = "%";
    unit_amps = "%";
  } else {
    unit_volts = "V";
    unit_amps = "A";
  }
  document.getElementById("crat_warn_v_n").innerHTML = unit_volts;
  document.getElementById("crat_warn_v_p").innerHTML = unit_volts;
  document.getElementById("crat_warn_a_n").innerHTML = unit_amps;
  document.getElementById("crat_warn_a_p").innerHTML = unit_amps;
}

function set_val_craterstop(setCsVal) {
  var i_min_val = 0.0;
  var i_max_val = 99.9;

  switch (setCsVal) {
    case 1:
      validate_check("txt_craterstopv_min", i_min_val, i_max_val);
      set_val_items('s_cs_vol_min', 'txt_craterstopv_min', 0, i_min_val, i_max_val, 1, setCsVal);
      document.getElementById("craterstop_volts_min").innerHTML = document.getElementById("txt_craterstopv_min").value;
      break;
    case 2:
      validate_check("txt_craterstopv_max", i_min_val, i_max_val);
      set_val_items('s_cs_vol_max', 'txt_craterstopv_max', 0, i_min_val, i_max_val, 1, setCsVal);
      document.getElementById("craterstop_volts_max").innerHTML = document.getElementById("txt_craterstopv_max").value;
      break;
    case 3:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_craterstopa_min", i_min_val, i_max_val);
      set_val_items('s_cs_amp_min', 'txt_craterstopa_min', 0, i_min_val, i_max_val, 1, setCsVal);
      document.getElementById("craterstop_amps_min").innerHTML = document.getElementById("txt_craterstopa_min").value;
      break;
    case 4:
      if(amon_type != METHOD_DIFF_PERCENT) {
        i_max_val = 999.9;
      }
      validate_check("txt_craterstopa_max", i_min_val, i_max_val);
      set_val_items('s_cs_amp_max', 'txt_craterstopa_max', 0, i_min_val, i_max_val, 1, setCsVal);
      document.getElementById("craterstop_amps_max").innerHTML = document.getElementById("txt_craterstopa_max").value;
      break;
    default:
      break;
  }
}

function get_craterstop_rght_scrn() {
  var rght_tbl = "<table id=\"craterstop_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(126) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(106)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterstopv_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterstop, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_stop_v_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterstopv_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterstop, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_stop_v_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(127) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(106)\"></span></td>";
  rght_tbl += "<td class=\"c-plus_minus\">-</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterstopa_min\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterstop, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_stop_a_n\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\"></td>";
  rght_tbl += "<td class=\"c-plus_minus\">+</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_craterstopa_max\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_craterstop, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"crat_stop_a_p\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base c-arc_monitor_margin\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_craterstop_rght_scrn(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("craterStop");
  document.getElementById("txt_craterstopv_min").value = get_node_value("stopVoltsMin");
  document.getElementById("txt_craterstopv_max").value = get_node_value("stopVoltsMax");
  document.getElementById("txt_craterstopa_min").value = get_node_value("stopAmpsMin");
  document.getElementById("txt_craterstopa_max").value = get_node_value("stopAmpsMax");

  var unit_volts;
  var unit_amps;
  node_data = xml_doc_data.getElementsByTagName("arcMonitor")[0].getElementsByTagName("method");
  if (get_node_value("amonType") == METHOD_DIFF_PERCENT) {
    unit_volts = "%";
    unit_amps = "%";
  } else {
    unit_volts = "V";
    unit_amps = "A";
  }
  document.getElementById("crat_stop_v_n").innerHTML = unit_volts;
  document.getElementById("crat_stop_v_p").innerHTML = unit_volts;
  document.getElementById("crat_stop_a_n").innerHTML = unit_amps;
  document.getElementById("crat_stop_a_p").innerHTML = unit_amps;
}

function get_scaling_lft_scrn(xml_doc_data) {
  var sch_l_tbl = "<div id=\"left_screen\">";

  sch_l_tbl += "<table id=\"scaling_l_screen\" class=\"c-l_scrn_mrgn\" style=\"width: 344px;\" cellspacing=\"0\" cellpadding=\"0\">";
  sch_l_tbl += "<tr id=\"ao1_item\" class=\"c-tree\" style=\"display:none;\">";
  sch_l_tbl += "<td id=\"ao1_title\" class=\"center_txt c-not_slct_bg_color\" onclick=\"show_scaling_diagram(1)\">" + get_prct_dict_text(116) + "1</td>";
  sch_l_tbl += "<td class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(107)\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr class=\"c-tree_space\"></tr>";
  sch_l_tbl += "<tr id=\"ao2_item\" class=\"c-tree\" style=\"display:none;\">";
  sch_l_tbl += "<td id=\"ao2_title\" class=\"center_txt c-not_slct_bg_color\" onclick=\"show_scaling_diagram(2)\">" + get_prct_dict_text(116) + "2</td>";
  sch_l_tbl += "<td class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(107)\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr class=\"c-tree_space\"></tr>";
  sch_l_tbl += "<tr id=\"ao3_item\" class=\"c-tree\" style=\"display:none;\">";
  sch_l_tbl += "<td id=\"ao3_title\" class=\"center_txt c-not_slct_bg_color\" onclick=\"show_scaling_diagram(3)\">" + get_prct_dict_text(116) + "3</td>";
  sch_l_tbl += "<td class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(107)\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr class=\"c-tree_space\"></tr>";
  sch_l_tbl += "<tr id=\"ao4_item\" class=\"c-tree\" style=\"display:none;\">";
  sch_l_tbl += "<td id=\"ao4_title\" class=\"center_txt c-not_slct_bg_color\" onclick=\"show_scaling_diagram(4)\">" + get_prct_dict_text(116) + "4</td>";
  sch_l_tbl += "<td class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(107)\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr class=\"c-tree_space\"></tr>";
  sch_l_tbl += "<tr id=\"ao5_item\" class=\"c-tree\" style=\"display:none;\">";
  sch_l_tbl += "<td id=\"ao5_title\" class=\"center_txt c-not_slct_bg_color\" onclick=\"show_scaling_diagram(5)\">" + get_prct_dict_text(116) + "5</td>";
  sch_l_tbl += "<td class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(107)\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "<tr class=\"c-tree_space\"></tr>";
  sch_l_tbl += "<tr id=\"ao6_item\" class=\"c-tree\" style=\"display:none;\">";
  sch_l_tbl += "<td id=\"ao6_title\" class=\"center_txt c-not_slct_bg_color\" onclick=\"show_scaling_diagram(6)\">" + get_prct_dict_text(116) + "6</td>";
  sch_l_tbl += "<td class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(107)\"></td>";
  sch_l_tbl += "</tr>";
  sch_l_tbl += "</table>";

  sch_l_tbl += "</div>";
  return sch_l_tbl;
}

function set_val_command(text_id, item_num) {
  var i_min_command = -9999999.000;
  var i_max_command = 9999999.000;

  validate_check(text_id, i_min_command, i_max_command);
  switch (item_num) {
    case 1:
      set_val_items('s_eq_val_in[1]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 2:
      set_val_items('s_eq_val_in[2]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 3:
      set_val_items('s_eq_val_in[3]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 4:
      set_val_items('s_eq_val_in[4]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 5:
      set_val_items('s_eq_val_in[5]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 6:
      set_val_items('s_eq_val_in[6]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 7:
      set_val_items('s_eq_val_in[7]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 8:
      set_val_items('s_eq_val_in[8]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 9:
      set_val_items('s_eq_val_in[9]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    case 10:
      set_val_items('s_eq_val_in[10]', text_id, 0, i_min_command, i_max_command, 3, item_num);
      break;
    default:
      break;
  }
}

function set_val_measured(text_id, item_num) {
  var i_min_measured = -9999999.000;
  var i_max_measured = 9999999.000;

  validate_check(text_id, i_min_measured, i_max_measured);
  switch (item_num) {
    case 11:
      set_val_items('s_eq_val_out[1]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 12:
      set_val_items('s_eq_val_out[2]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 13:
      set_val_items('s_eq_val_out[3]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 14:
      set_val_items('s_eq_val_out[4]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 15:
      set_val_items('s_eq_val_out[5]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 16:
      set_val_items('s_eq_val_out[6]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 17:
      set_val_items('s_eq_val_out[7]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 18:
      set_val_items('s_eq_val_out[8]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 19:
      set_val_items('s_eq_val_out[9]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    case 20:
      set_val_items('s_eq_val_out[10]', text_id, 0, i_min_measured, i_max_measured, 3, item_num);
      break;
    default:
      break;
  }
}

function get_scaling_rght_scrn() {
  var rght_tbl = "<table id=\"ao_r_screen\" style=\"display:none;\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base longunit_table\" colspan=\"3\">" + get_prct_dict_text(117) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(109)\"></span></td>";
  rght_tbl += "<td class=\"item_base longunit_table\" colspan=\"2\">";
  rght_tbl += "<input id=\"ao_select_scaling\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(17)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">1</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command1\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command1', 1, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured1\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured1', 11, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">2</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command2\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command2', 2, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured2\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured2', 12, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">3</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command3\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command3', 3, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured3\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured3', 13, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">4</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command4\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command4', 4, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured4\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured4', 14, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">5</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command5\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command5', 5, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured5\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured5', 15, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">6</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command6\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command6', 6, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured6\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured6', 16, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">7</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command7\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command7', 7, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured7\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured7', 17, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">8</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command8\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command8', 8, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured8\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured8', 18, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">9</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command9\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command9', 9, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured9\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured9', 19, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"sc_notable\">10</td>";
  rght_tbl += "<td class=\"sc_txtable\">" + get_prct_dict_text(118) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(110)\"></span></td>";
  rght_tbl += "<td class=\"sc_boxtable\">";
  rght_tbl += "<input id=\"ao_txt_command10\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_command, 'ao_txt_command10', 10, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"sc_ampstable\">" + get_prct_dict_text(119) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(111)\"></span></td>";
  rght_tbl += "<td class=\"sc_txtable\">";
  rght_tbl += "<input id=\"ao_txt_measured10\" type=\"text\" class=\"c-textbox\" maxlength=\"12\" onfocus=\"set_elem(this, set_val_measured, 'ao_txt_measured10', 20, '', '')\" onblur=\"set_weld_data()\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function validate_check_multi(valueId, minValue, maxValue) {
  var valueObj = document.getElementById(valueId);
  var err_message = document.getElementById("message_box");
  if ((parseFloat(valueObj.value) < parseFloat(minValue)) || (parseFloat(valueObj.value) > parseFloat(maxValue)) || (check_numerical_value(valueObj.value) == false)) {
    err_message.innerHTML = get_prct_dict_text(129) + "(" + parseFloat(minValue).toFixed(REAL_VAL_ERR_DIGIT) + "," + parseFloat(maxValue).toFixed(REAL_VAL_ERR_DIGIT) + ")";
    valueObj.value = tmp_value;
  } else {
    err_message.innerHTML = "";
  }

  if(valueObj.value == ""){
    valueObj.value = tmp_value;
  }
}

function set_val_multitub(setMtTub) {
  var i_min_val = 0.0;
  var i_min_pathdata = 0;
  var i_max_pathdata = 99;
  var i_max_gain = 999.9;
  var i_min_track = 0;
  var i_max_track = 999;
  var i_min_timing = 0.01;
  var i_max_timing = 99.99
  var i_min_dltm = 0.000;
  var i_max_dltm = 1.000;
  var i_max_cycle = 9999.9;
  var i_min_cycle = 0;

  switch (setMtTub) {
    case 1:
      validate_check_multi("txt_pathdata", i_min_pathdata, i_max_pathdata);
      set_val_items('s_multi_pt', 'txt_pathdata', 0, i_min_pathdata, i_max_pathdata, 0, setMtTub);
      break;
    case 2:
      validate_check_multi("txt_mdeltime", i_min_dltm, i_max_dltm);
      set_val_items('s_ml_dtim', 'txt_mdeltime', 0, i_min_dltm, i_max_dltm, 3, setMtTub);
      break;
    case 3:
      validate_check_multi("txt_lrgain", i_min_val, i_max_gain);
      set_val_items('s_ml_ycmp', 'txt_lrgain', 0, i_min_val, i_max_gain, 1, setMtTub);
      break;
    case 4:
      validate_check_multi("txt_udgain", i_min_val, i_max_gain);
      set_val_items('s_ml_zcmp', 'txt_udgain', 0, i_min_val, i_max_gain, 1, setMtTub);
      break;
    case 5:
      validate_check_multi("txt_ymininc", i_min_val, i_max_gain);
      set_val_items('s_ml_yminc', 'txt_ymininc', 0, i_min_val, i_max_gain, 1, setMtTub);
      break;
    case 6:
      validate_check_multi("txt_zmininc", i_min_val, i_max_gain);
      set_val_items('s_ml_zminc', 'txt_zmininc', 0, i_min_val, i_max_gain, 1, setMtTub);
      break;
    case 7:
      validate_check_multi("txt_ymax", i_min_cycle, i_max_cycle);
      set_val_items('s_ml_ymax', 'txt_ymax', 0, i_min_cycle, i_max_cycle, 1, setMtTub);
      break;
    case 8:
      validate_check_multi("txt_zmax", i_min_cycle, i_max_cycle);
      set_val_items('s_ml_zmax', 'txt_zmax', 0, i_min_cycle, i_max_cycle, 1, setMtTub);
      break;
    case 9:
      validate_check_multi("txt_ymaxinc", i_min_cycle, i_max_cycle);
      set_val_items('s_ml_ymaxc', 'txt_ymaxinc', 0, i_min_cycle, i_max_cycle, 1, setMtTub);
      break;
    case 10:
      validate_check_multi("txt_zmaxinc", i_min_cycle, i_max_cycle);
      set_val_items('s_ml_zmaxc', 'txt_zmaxinc', 0, i_min_cycle, i_max_cycle, 1, setMtTub);
      break;
    case 11:
      validate_check_multi("txt_ysamp", i_min_track, i_max_track);
      set_val_items('s_ml_ysamp', 'txt_ysamp', 0, i_min_track, i_max_track, 0, setMtTub);
      break;
    case 12:
      validate_check_multi("txt_zsamp", i_min_track, i_max_track);
      set_val_items('s_ml_zsamp', 'txt_zsamp', 0, i_min_track, i_max_track, 0, setMtTub);
      break;
    case 13:
      validate_check_multi("txt_sctim", i_min_track, i_max_track);
      set_val_items('s_ml_sctim', 'txt_sctim', 0, i_min_track, i_max_track, 0, setMtTub);
      break;
    case 14:
      validate_check_multi("txt_ctime", i_min_track, i_max_track);
      set_val_items('s_ml_ctime', 'txt_ctime', 0, i_min_track, i_max_track, 0, setMtTub);
      break;
    case 15:
      validate_check_multi("txt_timng", i_min_timing, i_max_timing);
      set_val_items('s_ml_timing', 'txt_timng', 0, i_min_timing, i_max_timing, 2, setMtTub);
      break;
    default:
      break;
  }
}

function get_tracking_tab_scrn() {
  var trck_tbl = "<div id=\"combine_screen\" style=\"vertical-align:top;\">";

  trck_tbl += "<table style=\"width: 950px;\" align=\"center\">";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(83) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(121)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_pathdata\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\"></td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(84) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(122)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_mdeltime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\">sec</td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\"></td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr><td><br></td></tr>";
  trck_tbl += "<tr></tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td></td>";
  trck_tbl += "<td align=\"left\">" + get_prct_dict_text(197) + "</td>";
  trck_tbl += "<td></td>";
  trck_tbl += "<td align=\"left\">" + get_prct_dict_text(198) + "</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(85) + "</td>";
  trck_tbl += "<td class=\"item_base\" style=\"width: 230px;\" colspan=\"2\">";
  trck_tbl += "<input id=\"select_tlevel\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(23)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base\" style=\"width: 280px;\" colspan=\"2\">";
  trck_tbl += "<input id=\"select_tver\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(24)\">";
  trck_tbl += "</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(87) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(124)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_lrgain\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_udgain\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(89) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(125)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_ymininc\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_zmininc\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\">mm</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(91) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(126)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_ymax\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 7, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_zmax\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 8, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\">mm</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(92) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(127)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_ymaxinc\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 9, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_zmaxinc\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 10, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\">mm</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(93) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(128)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_ysamp\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 11, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_zsamp\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 12, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td align=\"left\" colspan=\"5\"><br>" + get_prct_dict_text(199) + "</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(95) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(129)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_sctim\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 13, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\"></td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(96) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(130)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_ctime\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 14, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\"></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\"></td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td align=\"left\" colspan=\"5\"><br>" + get_prct_dict_text(200) + "</td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(97) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(131)\"></span></td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\">";
  trck_tbl += "<input id=\"txt_timng\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_multitub, 15, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_unit\">sec</td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\"></td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "<tr>";
  trck_tbl += "<td class=\"item_base multipass_txtable\">" + get_prct_dict_text(98) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(132)\"></span></td>";
  trck_tbl += "<td class=\"item_base\" style=\"width: 280px;\" colspan=\"2\">";
  trck_tbl += "<input id=\"select_offset_frame\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(25)\">";
  trck_tbl += "</td>";
  trck_tbl += "<td class=\"item_base multipass_txtbox\"></td>";
  trck_tbl += "<td class=\"item_base multipass_unit_wide\"></td>";
  trck_tbl += "</tr>";
  trck_tbl += "</table>";

  trck_tbl += "</div>";
  trck_tbl += "<div id=\"message_box\" class=\"c-lagemessage_box c-message_box-text\" style=\"display:block; width: 1004px;\"></div>";
  return trck_tbl;
}

function get_power_supply_lft_scrn() {
  var lft_tbl = "<div id=\"left_screen\">";

  lft_tbl += "<table id=\"power_supply_l_screen\" class=\"c-l_scrn_mrgn\" style=\"width: 320px;\" cellspacing=\"0\" cellpadding=\"0\">";
  lft_tbl += "<tr style=\"height: 4px;\"></tr>";
  lft_tbl += "<tr id=\"sfi_item\" class=\"c-not_slct_bg_color\" onclick=\"show_power_supply_diagram(1)\">";
  lft_tbl += "<td class=\"c-tree c-tree_txt\"></td>";
  lft_tbl += "<td class=\"c-tree\" style=\"width: 280px;\" colspan=\"2\">" + get_prct_dict_text(264) + "</td>";
  lft_tbl += "<td class=\"help_icon\" style=\"display:none;\"></td>";
  lft_tbl += "</tr>";
  lft_tbl += "<tr style=\"height: 4px;\"></tr>";
  lft_tbl += "<tr id=\"synchro_pulse_item\" class=\"c-not_slct_bg_color\" onclick=\"show_power_supply_diagram(2)\">";
  lft_tbl += "<td class=\"c-tree c-tree_txt\"></td>";
  lft_tbl += "<td class=\"c-tree\" style=\"width: 280px;\" colspan=\"2\">" + get_prct_dict_text(265) + "</td>";
  lft_tbl += "<td class=\"help_icon\" style=\"display:none;\"></td>";
  lft_tbl += "</tr>";
  lft_tbl += "<tr style=\"height: 4px;\"></tr>";
  lft_tbl += "<tr id=\"others_item\" class=\"c-not_slct_bg_color\" onclick=\"show_power_supply_diagram(3)\">";
  lft_tbl += "<td class=\"c-tree c-tree_txt\"></td>";
  lft_tbl += "<td class=\"c-tree\" style=\"width: 280px;\" colspan=\"2\">" + get_prct_dict_text(266) + "</td>";
  lft_tbl += "<td class=\"help_icon\" style=\"display:none;\"></td>";
  lft_tbl += "</tr>";
  lft_tbl += "</table>";

  lft_tbl += "</div>";
  return lft_tbl;
}

function set_val_ps_sfi() {
  validate_check("txt_ps_sfi_hot_start", 0, 2);
  set_val_items('s_scrn_real', 'txt_ps_sfi_hot_start', 0, 0, 2, 1, 2);
}

function get_ps_sfi_rght_scrn() {
  var rght_tbl = "<table id=\"ps_sfi_r_screen\" align=\"left\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(264) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_ps_sfi\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(26)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(267) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_sfi_hot_start\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_sfi, '', '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_val_ps_sp(ps_sp_item_num) {
  switch (ps_sp_item_num) {
    case 2:
      validate_check("txt_ps_sp_deltawfs", i_ps_sp_deltawfs_min, i_ps_sp_deltawfs_max);
      set_val_items('s_scrn_real', 'txt_ps_sp_deltawfs', 0, i_ps_sp_deltawfs_min, i_ps_sp_deltawfs_max, 1, ps_sp_item_num);
      break;
    case 3:
      validate_check("txt_ps_sp_freq", 0.5, 3);
      set_val_items('s_scrn_real', 'txt_ps_sp_freq', 0, 0.5, 3, 1, ps_sp_item_num);
      break;
    case 4:
      validate_check("txt_ps_sp_duty", 10, 90);
      set_val_items('s_scrn_int', 'txt_ps_sp_duty', 0, 10, 90, 0, ps_sp_item_num);
      break;
    case 5:
      validate_check_slg("txt_ps_sp_alc_high", -10, 10, 'slg_ps_sp_alc_high', 1);
      set_aw_data('s_scrn_real', 'txt_ps_sp_alc_high', treeSelectNum, ps_sp_item_num);
      break;
    case 6:
      validate_check_slg("txt_ps_sp_alc_low", -10, 10, 'slg_ps_sp_alc_low', 1);
      set_aw_data('s_scrn_real', 'txt_ps_sp_alc_low', treeSelectNum, ps_sp_item_num);
      break;
    default:
      set_text_value("txt_ps_sp_alc_high", -10, 10, 'slg_ps_sp_alc_high', 1);
      set_text_value("txt_ps_sp_alc_low", -10, 10, 'slg_ps_sp_alc_low', 1);
      break;
  }
}

function tch_dwn_ps_sp(ps_sp_item_num) {
  check_button_status();
  set_dwn_button("ps_sp_down" + ps_sp_item_num);

  switch (ps_sp_item_num) {
    case 5:
      tch_dwn_btn("txt_ps_sp_alc_high", 0.5, -10, 10, 'slg_ps_sp_alc_high', 1);
      set_aw_data('s_scrn_real', 'txt_ps_sp_alc_high', treeSelectNum, ps_sp_item_num);
      break;
    case 6:
      tch_dwn_btn("txt_ps_sp_alc_low", 0.5, -10, 10, 'slg_ps_sp_alc_low', 1);
      set_aw_data('s_scrn_real', 'txt_ps_sp_alc_low', treeSelectNum, ps_sp_item_num);
      break;
    default:
      break;
  }
}

function tch_up_ps_sp(ps_sp_item_num) {
  check_button_status();
  set_up_button("ps_sp_up" + ps_sp_item_num);

  switch (ps_sp_item_num) {
    case 5:
      tch_up_btn("txt_ps_sp_alc_high", 0.5, -10, 10, 'slg_ps_sp_alc_high', 1);
      set_aw_data('s_scrn_real', 'txt_ps_sp_alc_high', treeSelectNum, ps_sp_item_num);
      break;
    case 6:
      tch_up_btn("txt_ps_sp_alc_low", 0.5, -10, 10, 'slg_ps_sp_alc_low', 1);
      set_aw_data('s_scrn_real', 'txt_ps_sp_alc_low', treeSelectNum, ps_sp_item_num);
      break;
    default:
      break;
  }
}

function get_ps_sp_rght_scrn() {
  var rght_tbl = "<table id=\"ps_sp_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(268) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_ps_sp_enable\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(27)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(269) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_sp_deltawfs\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_sp, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"txt_ps_sp_deltawfs_units\" class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(270) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_sp_freq\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_sp, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">Hz</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(271) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_sp_duty\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_sp, 4, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">%</td>";
  rght_tbl += "<td class=\"item_base lmargin_table\" colspan=\"3\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(272) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_sp_alc_high\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_sp, 5, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_ps_sp(5)\"><img id=\"ps_sp_down5\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ps_sp_min_alc_high\" style=\"float:left\">-10.0</label>";
  rght_tbl += "<label id=\"lab_ps_sp_max_alc_high\" style=\"float:right\">10.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_ps_sp_alc_high\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_ps_sp(5)\"><img id=\"ps_sp_up5\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(273) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_sp_alc_low\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_sp, 6, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_ps_sp(6)\"><img id=\"ps_sp_down6\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_ps_sp_min_alc_low\" style=\"float:left\">-10.0</label>";
  rght_tbl += "<label id=\"lab_ps_sp_max_alc_low\" style=\"float:right\">10.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_ps_sp_alc_low\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_ps_sp(6)\"><img id=\"ps_sp_up6\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function set_val_ps_other(ps_other_item_num) {
  switch (ps_other_item_num) {
    case 1:
      validate_check("txt_ps_other_pene_stabi", 0, i_ps_other_pene_stabi_max);
      set_val_items('s_scrn_real', 'txt_ps_other_pene_stabi', 0, 0, i_ps_other_pene_stabi_max, 1, ps_other_item_num);
      break;
    case 2:
      validate_check("txt_ps_other_arcl_stabi", 0, 5);
      set_val_items('s_scrn_real', 'txt_ps_other_arcl_stabi', 0, 0, 5, 1, ps_other_item_num);
      break;
    default:
      break;
  }
}

function get_ps_other_rght_scrn() {
  var rght_tbl = "<table id=\"ps_other_r_screen\" align=\"left\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(274) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_other_pene_stabi\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_other, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"txt_ps_other_pene_stabi_units\" class=\"item_base unit_table\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base long_table\">" + get_prct_dict_text(275) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_ps_other_arcl_stabi\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_ps_other, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\"></td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";
  return rght_tbl;
}

function showSequenceDiagram(gasNum) {
  if(help_stts == HELP_STTS_NONE) {
    window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + gasNum;
  }
  var custom_flg_check = 2;
  var arcendpretime_none = 2;
  var item_arcstartpretime = document.getElementById("arcstartpretime_item");
  var item_gaspurge = document.getElementById("gaspurge_item");
  var item_gaspreflow = document.getElementById("gaspreflow_item");
  var item_gaspostflow = document.getElementById("gaspostflow_item");
  var item_arcendpretime = document.getElementById("arcendpretime_item");
  var item_swfeedspeed = document.getElementById("swfeedspeed_item");
  var item_ramping = document.getElementById("ramping_item");
  var item_heatwave = document.getElementById("heatwave_item");

  if ((i_custom_flg & 1) == 1) {
  } else {
    item_arcstartpretime.style.backgroundColor = Gr02;
  }
  item_gaspurge.style.backgroundColor = Gr02;
  item_gaspreflow.style.backgroundColor = Gr02;
  if ((i_custom_flg & custom_flg_check) == arcendpretime_none) {
  } else {
    item_arcendpretime.style.backgroundColor = Gr02;
  }
  item_gaspostflow.style.backgroundColor = Gr02;
  if (ps_type == PS_LINCOLN) {
    item_swfeedspeed.style.backgroundColor = Gr02;
  }
  item_ramping.style.backgroundColor = Gr02;
  if (i_heatwave_opt > HEATWAVE_OPTN_NOT_EXIST) {
    item_heatwave.style.backgroundColor = Gr02;
  }

  treeSelectNum = gasNum;
  switch (gasNum) {
    case 1:
      item_arcstartpretime.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_AS_PRE_TIME);
      break;
    case 2:
      item_gaspurge.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_GAS_PURGE);
      break;
    case 3:
      item_gaspreflow.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_GAS_PREFLOW);
      break;
    case 4:
      item_arcendpretime.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_AE_PRE_TIME);
      break;
    case 5:
      item_gaspostflow.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_GAS_POSTFLOW);
      break;
    case 6:
      item_swfeedspeed.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_STRIKE_WFS);
      break;
    case 7:
      item_ramping.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_RAMP_ENABLE);
      break;
    case 8:
      item_heatwave.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_SEQ_WEAVE_SYNCH);
      break;
    default:
      break;
  }
}

function set_text_value(value_id, minValue, maxValue, sliderInsideId, numDigits) {
  var value_obj = document.getElementById(value_id);
  var text_val =  parseFloat(value_obj.value);
  if (text_val < minValue) {
    text_val = minValue;
  }

  if (value_obj.value != "") {
    if ((minValue != 0.0) || (maxValue != 0.0)) {
      var sliderPercent = (text_val - minValue) / (maxValue - minValue) * 100;
      document.getElementById(sliderInsideId).style.width = Math.round(sliderPercent) + "%";
      value_obj.value = parseFloat(value_obj.value).toFixed(numDigits);
    }
  }
}

function set_aw_data(kl_var_name, id_name, tree_select, set_datano) {
  window.location.href = "/KARELCMD/AWPRWRT?" + kl_var_name + "=" + document.getElementById(id_name).value + "&s_ws_number=" + tree_select + "&s_sel_tab=" + select_tab_no + "&s_set_no=" + set_datano + "&s_open_tab=" + open_tab_no;
}

function validate_check_slg(value_id, minValue, maxValue, sliderInsideId, digit_num) {
  var value_obj = document.getElementById(value_id);
  var err_message = document.getElementById("message_box");
  if ((parseFloat(value_obj.value) < parseFloat(minValue)) || (parseFloat(value_obj.value) > parseFloat(maxValue)) || (check_numerical_value(value_obj.value) == false)) {
    err_message.innerHTML = get_prct_dict_text(129) + "(" + parseFloat(minValue).toFixed(REAL_VAL_ERR_DIGIT) + "," + parseFloat(maxValue).toFixed(REAL_VAL_ERR_DIGIT) + ")";
    value_obj.value = tmp_value;
  } else {
    err_message.innerHTML = "";
  }

  if (minValue && maxValue == 0.0){
    value_obj.value = minValue;
  }

  if(value_obj.value == ""){
    value_obj.value = tmp_value;
  } else {
    set_text_value(value_id, minValue, maxValue, sliderInsideId, digit_num);
  }
}

function validate_check(value_id, minValue, maxValue) {
  var value_obj = document.getElementById(value_id);
  var err_message = document.getElementById("message_box");
  if ((parseFloat(value_obj.value) < parseFloat(minValue)) || (parseFloat(value_obj.value) > parseFloat(maxValue)) || (check_numerical_value(value_obj.value) == false)) {
    err_message.innerHTML = get_prct_dict_text(129) + "(" + parseFloat(minValue).toFixed(REAL_VAL_ERR_DIGIT) + "," + parseFloat(maxValue).toFixed(REAL_VAL_ERR_DIGIT) + ")";
    value_obj.value = tmp_value;
  } else {
    err_message.innerHTML = "";
  }

  if(value_obj.value == "") {
    value_obj.value = tmp_value;
  }
}

function set_sch_data(kl_var_name, id_name, tree_select, set_datano) {
  var i_schedu_amps = document.getElementById("txt_amps");
  var i_schedu_volts = document.getElementById("txt_volts");

  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + tree_select + "&" + kl_var_name + "=" + document.getElementById(id_name).value + "&s_sel_tab=" + select_tab_no + "&s_set_no=" + set_datano + "&s_open_tab=" + open_tab_no;
  document.getElementById("weldschdisplay" + tree_select).innerHTML = '<p class="weld_sch_display_cmd_volts">' + i_schedu_amps.value + s_voltage_unit + '</p><p class="weld_sch_display_cmd_wfs">' + i_schedu_volts.value + s_wfs_unit + '</p>';
}

function set_val_weldsched(setWeldVal) {
  var PULSE_FREQ_MAX = 10;
  var PULSE_FREQ_MIN = 0.1;
  var PULSE_DUTY_MAX = 80;
  var PULSE_DUTY_MIN = 20;

  switch (setWeldVal) {
    case 1:
      validate_check_slg("txt_amps", i_min_amps, i_max_amps, 'slg_inws_amps', voltage_cmd_format);
      set_sch_data('s_ws_volts[' + treeSelectNum + ']', 'txt_amps', treeSelectNum, setWeldVal, open_tab_no);
      break;
    case 2:
      validate_check_slg("txt_volts", i_min_volts, i_max_volts, 'slg_inws_volts', wfs_cmd_format);
      set_sch_data('s_ws_wv_ctrl[' + treeSelectNum + ']', 'txt_volts', treeSelectNum, setWeldVal, open_tab_no);
      break;
    case 3:
      validate_check_slg("txt_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inws_wavecon', current_cmd_format);
      set_aw_data('s_ws_amps[' + treeSelectNum + ']', 'txt_wavecontrol', treeSelectNum, setWeldVal);
      break;
    case 4:
      validate_check_slg("txt_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inws_pkamps', pk_curr_cmd_format);
      set_aw_data('s_ws_pkamps[' + treeSelectNum + ']', 'txt_pkamps', treeSelectNum, setWeldVal);
      break;
    case 5:
      validate_check_slg("txt_freq", i_min_freq, i_max_freq, 'slg_inws_freq', freq_cmd_format);
      set_aw_data('s_ws_freq[' + treeSelectNum + ']', 'txt_freq', treeSelectNum, setWeldVal);
      break;
    case 6:
      validate_check_slg("txt_pulse", i_min_pulse, i_max_pulse, 'slg_inws_pulse', pulse_cmd_format);
      set_aw_data('s_ws_pulse[' + treeSelectNum + ']', 'txt_pulse', treeSelectNum, setWeldVal);
      break;
    case 7:
      validate_check("txt_travelspeed", i_min_travel_sp, i_max_travel_sp);
      set_val_items('s_ws_trvl_sp[' + treeSelectNum + ']', 'txt_travelspeed', 0, i_min_travel_sp, i_max_travel_sp, 1, setWeldVal);
      break;
    case 8:
      validate_check("txt_delaytime", i_min_delaytime, i_max_delaytime);
      set_val_items('s_ws_dly_tm[' + treeSelectNum + ']', 'txt_delaytime', 0, i_min_delaytime, i_max_delaytime, 2, setWeldVal);
      break;
    case 9:
      set_text_value("txt_amps", i_min_amps, i_max_amps, 'slg_inws_amps', voltage_cmd_format);
      set_text_value("txt_volts", i_min_volts, i_max_volts, 'slg_inws_volts', wfs_cmd_format);
      set_text_value("txt_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inws_wavecon', current_cmd_format);
      set_text_value("txt_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inws_pkamps', pk_curr_cmd_format);
      set_text_value("txt_freq", i_min_freq, i_max_freq, 'slg_inws_freq', freq_cmd_format);
      set_text_value("txt_pulse", i_min_pulse, i_max_pulse, 'slg_inws_pulse', pulse_cmd_format);
      break;
    case WS_VOLTS_L:
      validate_check("txt_amps_left", i_min_amps, i_max_amps);
      set_val_items('s_scrn_real', 'txt_amps_left', 0, i_min_amps, i_max_amps, voltage_cmd_format, setWeldVal);
      break;
    case WS_VOLTS_R:
      validate_check("txt_amps_right", i_min_amps, i_max_amps);
      set_val_items('s_scrn_real', 'txt_amps_right', 0, i_min_amps, i_max_amps, voltage_cmd_format, setWeldVal);
      break;
    case WS_WFS_L:
      validate_check("txt_volts_left", i_min_volts, i_max_volts);
      set_val_items('s_scrn_real', 'txt_volts_left', 0, i_min_volts, i_max_volts, wfs_cmd_format, setWeldVal);
      break;
    case WS_WFS_R:
      validate_check("txt_volts_right", i_min_volts, i_max_volts);
      set_val_items('s_scrn_real', 'txt_volts_right', 0, i_min_volts, i_max_volts, wfs_cmd_format, setWeldVal);
      break;
    case WS_AMPS_L:
      validate_check("txt_wavecontrol_left", i_min_wv_ctrl, i_max_wv_ctrl);
      set_val_items('s_scrn_real', 'txt_wavecontrol_left', 0, i_min_wv_ctrl, i_max_wv_ctrl, current_cmd_format, setWeldVal);
      break;
    case WS_AMPS_R:
      validate_check("txt_wavecontrol_right", i_min_wv_ctrl, i_max_wv_ctrl);
      set_val_items('s_scrn_real', 'txt_wavecontrol_right', 0, i_min_wv_ctrl, i_max_wv_ctrl, current_cmd_format, setWeldVal);
      break;
    case WS_PKAMPSL:
      validate_check("txt_pkamps_left", i_min_pkamps, i_max_pkamps);
      set_val_items('s_scrn_real', 'txt_pkamps_left', 0, i_min_pkamps, i_max_pkamps, pk_curr_cmd_format, setWeldVal);
      break;
    case WS_PKAMPSR:
      validate_check("txt_pkamps_right", i_min_pkamps, i_max_pkamps);
      set_val_items('s_scrn_real', 'txt_pkamps_right', 0, i_min_pkamps, i_max_pkamps, pk_curr_cmd_format, setWeldVal);
      break;
    case WS_FREQ_L:
      validate_check("txt_freq_left", i_min_freq, i_max_freq);
      set_val_items('s_scrn_real', 'txt_freq_left', 0, i_min_freq, i_max_freq, freq_cmd_format, setWeldVal);
      break;
    case WS_FREQ_R:
      validate_check("txt_freq_right", i_min_freq, i_max_freq);
      set_val_items('s_scrn_real', 'txt_freq_right', 0, i_min_freq, i_max_freq, freq_cmd_format, setWeldVal);
      break;
    case WS_PULSE_L:
      validate_check("txt_pulse_left", i_min_pulse, i_max_pulse);
      set_val_items('s_scrn_real', 'txt_pulse_left', 0, i_min_pulse, i_max_pulse, pulse_cmd_format, setWeldVal);
      break;
    case WS_PULSE_R:
      validate_check("txt_pulse_right", i_min_pulse, i_max_pulse);
      set_val_items('s_scrn_real', 'txt_pulse_right', 0, i_min_pulse, i_max_pulse, pulse_cmd_format, setWeldVal);
      break;
    case WS_PLS_FRQ:
      validate_check("txt_pulse_freq", PULSE_FREQ_MIN, PULSE_FREQ_MAX);
      set_val_items('s_scrn_real', 'txt_pulse_freq', 0, PULSE_FREQ_MIN, PULSE_FREQ_MAX, 1, setWeldVal);
      break;
    case WS_PLS_DTY:
      validate_check("txt_ws_pulse_duty", PULSE_DUTY_MIN, PULSE_DUTY_MAX);
      set_val_items('s_scrn_real', 'txt_ws_pulse_duty', 0, PULSE_DUTY_MIN, PULSE_DUTY_MAX, 1, setWeldVal);
      break;
    default:
      break;
  }
}

function set_header_area_general_purpose() {
  document.getElementById("mode_title").innerHTML = get_prct_dict_text(328);
  document.getElementById("weld_mode").style.display = "";
  if (get_node_value("sel_mode") == 0) {
    document.getElementById("process_select_mode_val").value = get_node_value("wpcfg_prg_cmnd2");
    document.getElementById("process_select_mode").style.display = '';
  }
}

function set_header_area(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("awdata");
  ps_type = parseInt(get_node_value("ps_type"), 10);
  node_data = xml_doc_data.getElementsByTagName("weld_data");
  document.getElementById("number").innerText = "#" + get_node_value("data_no");
  document.getElementById("comment").innerHTML = comment_sp + get_node_value("data_comment");
  var mode = document.getElementById("mode");
  var mode_nm = document.getElementById("mode_nm");
  if (ps_type != PS_FRONIUS_TPSI) {
    mode.innerText = "#" + get_node_value("data_mode");
    mode_nm.innerHTML = comment_sp + get_node_value("data_mode_name");

    switch (ps_type) {
      case PS_FANUC:
      case PS_DAIHEN:
      case PS_SFR:
        document.getElementById("weld_mode").style.display = "";
        if(parseInt(get_node_value("data_mode"), RADIX_DECIMAL_NUMBER) == I_TEST_MD_NO) {
          mode_nm.style.width = "200px";
          document.getElementById("program_no_val").innerHTML = get_node_value("wpcfg_prg_cmnd2");
          document.getElementById("program_no").style.display = '';
        }
        break;
      case PS_GP_STD:
        if (get_node_value("prg_sel_ena") == 0) {
          set_header_area_general_purpose();
        }
        break;
      case PS_GP_DGCS:
        set_header_area_general_purpose();
        break;
      default:
        document.getElementById("weld_mode").style.display = "";
        break;
    }
  } else {
    var op_mode_val = document.getElementById("op_mode_val");
    data_mode = get_node_value("data_mode");
    if (data_mode == SPECIAL_TWO_STEP) {
      op_mode_val.innerText = get_prct_dict_text(279);
      document.getElementById("synergic_id_val").innerText = "#" + get_node_value("synergic_id") + " " + get_node_value("process_name");
      document.getElementById("synergic_id").style.display = '';
    } else {
      if (data_mode == INTERNAL_MODE) {
        op_mode_val.innerText = get_prct_dict_text(278);
      } else {
        op_mode_val.innerText = get_prct_dict_text(280);
      }
    }
    document.getElementById("op_mode").style.display = '';
  }

  node_data = xml_doc_data.getElementsByTagName("weldNumSchedules");
  document.getElementById("weld_dropdown_cnt").value = get_node_value("weldNumber");
}

function set_cmd_digit(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("cmdFormat");
  voltage_cmd_format = get_node_value("voltageCmdFormat");
  wfs_cmd_format = get_node_value("wfsCmdFormat");
  current_cmd_format = get_node_value("currentCmdFormat");
  pk_curr_cmd_format = get_node_value("pkcurrCmdFormat");
  freq_cmd_format = get_node_value("freqCmdFormat");
  pulse_cmd_format = get_node_value("pulseCmdFormat");
}

function set_heatwave_items(sch_no) {
  document.getElementById("txt_amps_left").value = get_node_value("cmdVoltsLeft" + sch_no);
  document.getElementById("txt_amps_right").value = get_node_value("cmdVoltsRight" + sch_no);
  document.getElementById("txt_volts_left").value = get_node_value("cmdWfsLeft" + sch_no);
  document.getElementById("txt_volts_right").value = get_node_value("cmdWfsRight" + sch_no);
  document.getElementById("txt_wavecontrol_left").value = get_node_value("cmdAmpsLeft" + sch_no);
  document.getElementById("txt_wavecontrol_right").value = get_node_value("cmdAmpsRight" + sch_no);
  document.getElementById("txt_pkamps_left").value = get_node_value("cmdPkampsLeft" + sch_no);
  document.getElementById("txt_pkamps_right").value = get_node_value("cmdPkampsRight" + sch_no);
  document.getElementById("txt_freq_left").value = get_node_value("cmdFreqLeft" + sch_no);
  document.getElementById("txt_freq_right").value = get_node_value("cmdFreqRight" + sch_no);
  document.getElementById("txt_pulse_left").value = get_node_value("cmdPulseLeft" + sch_no);
  document.getElementById("txt_pulse_right").value = get_node_value("cmdPulseRight" + sch_no);
  document.getElementById("txt_pulse_freq").value = get_node_value("pulseFreq" + sch_no);
  document.getElementById("txt_ws_pulse_duty").value = get_node_value("pulseDuty" + sch_no);
}

function display_heatwave_weav() {
  if (i_num_ao >= 1) {
    document.getElementById("ws_title1").innerHTML = get_prct_dict_text(314);
    document.getElementById("ws_title2").innerHTML = get_prct_dict_text(315);
    document.getElementById("ws_title3").innerHTML = get_prct_dict_text(316);
    document.getElementById("ws_title").style.display = "block";
    for (var i = 1 ; i <= i_num_ao; i++) {
      document.getElementById("ws_down_cmd" + i).style.display = "none";
      document.getElementById("ws_slider_cmd" + i).style.display = "none";
      document.getElementById("ws_up_cmd" + i).style.display = "none";

      document.getElementById("td_left_cmd" + i).style.display = "block";
      document.getElementById("td_right_cmd" + i).style.display = "block";
      document.getElementById("td_sp1_cmd" + i).style.display = "block";
    }
    document.getElementById("ws_heatwave_bttm_spc").style.display = "block";
  }
}

function display_heatwave() {
  if (i_num_ao >= 1) {
    document.getElementById("ws_title1").innerHTML = get_prct_dict_text(317);
    document.getElementById("ws_title2").innerHTML = get_prct_dict_text(318);
    document.getElementById("ws_title3").innerHTML = "";
    document.getElementById("ws_title").style.display = "block";
    for (var i = 1 ; i <= i_num_ao; i++) {
      document.getElementById("ws_down_cmd" + i).style.display = "none";
      document.getElementById("ws_slider_cmd" + i).style.display = "none";
      document.getElementById("ws_up_cmd" + i).style.display = "none";

      document.getElementById("td_right_cmd" + i).style.display = "block";
      document.getElementById("td_sp1_cmd" + i).style.display = "block";
      document.getElementById("td_sp2_cmd" + i).style.display = "block";
    }
    document.getElementById("ws_heatwave_bttm_spc").style.display = "block";
    document.getElementById("ws_pulse_freq").style.display = "block";
    document.getElementById("ws_pulse_duty").style.display = "block";
  }
}

function non_display_heatwave() {
  document.getElementById("ws_title").style.display = "none";
  for (var i = 1; i <= i_num_ao; i++) {
    document.getElementById("td_left_cmd" + i).style.display = "none";
    document.getElementById("td_right_cmd" + i).style.display = "none";
    document.getElementById("td_sp1_cmd" + i).style.display = "none";
    document.getElementById("td_sp2_cmd" + i).style.display = "none";

    document.getElementById("ws_down_cmd" + i).style.display = "block";
    document.getElementById("ws_slider_cmd" + i).style.display = "block";
    document.getElementById("ws_up_cmd" + i).style.display = "block";
  }
  document.getElementById("ws_heatwave_bttm_spc").style.display = "none";
  document.getElementById("ws_pulse_freq").style.display = "none";
  document.getElementById("ws_pulse_duty").style.display = "none";
}

function set_heatwave(select_no) {
  var status = 0;
  var i_schedu_heatwave_mode = document.getElementById("select_heatwave_mode");
  switch (select_no) {
    case HTWV_NONE:
      non_display_heatwave();
      i_schedu_heatwave_mode.value = get_prct_dict_text(169);
      break;
    case HTWV_STEP_WEAVING:
      if (i_heatwave_opt & R551_OPT_FLG) {
        non_display_heatwave();
        display_heatwave_weav();
        i_schedu_heatwave_mode.value = get_prct_dict_text(170);
      } else {
        status = -1;
      }
      break;
    case HTWV_RAMP_WEAVING:
      if (i_heatwave_opt & R551_OPT_FLG) {
        non_display_heatwave();
        display_heatwave_weav();
        i_schedu_heatwave_mode.value = get_prct_dict_text(171);
      } else {
        status = -1;
      }
      break;
    case HTWV_PULSE:
      non_display_heatwave();
      display_heatwave();
      i_schedu_heatwave_mode.value = get_prct_dict_text(172);
      break;
    default:
      break;
  }
  return status;
}

function display_cmd_help_icon(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("weldSchedules");
  document.getElementById("voltage_cmd_help").style.display = get_cmd_display_value(get_node_value("voltageCmdWeldSignal"));
  document.getElementById("wfs_cmd_help").style.display = get_cmd_display_value(get_node_value("wfsCmdWeldSignal"));
  document.getElementById("current_cmd_help").style.display = get_cmd_display_value(get_node_value("currentCmdWeldSignal"));
  document.getElementById("pk_curr_cmd_help").style.display = get_cmd_display_value(get_node_value("pkCurrCmdWeldSignal"));
  document.getElementById("freq_cmd_help").style.display = get_cmd_display_value(get_node_value("freqCmdWeldSignal"));
  document.getElementById("pulse_cmd_help").style.display = get_cmd_display_value(get_node_value("pulseCmdWeldSignal"));
}

function set_cmd_min_max(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("minMaxValues");
  i_min_amps = get_node_value("minAmps");
  i_max_amps = get_node_value("maxAmps");
  i_min_volts = get_node_value("minVolts");
  i_max_volts = get_node_value("maxVolts");
  i_min_wv_ctrl = get_node_value("minWaveControl");
  i_max_wv_ctrl = get_node_value("maxWaveControl");
  i_min_pkamps = get_node_value("minPkamps");
  i_max_pkamps = get_node_value("maxPkamps");
  i_min_freq = get_node_value("minFrequency");
  i_max_freq = get_node_value("maxFrequency");
  i_min_pulse = get_node_value("minPulse");
  i_max_pulse = get_node_value("maxPulse");
}

function set_weld_sch_scrn_items_val(xml_doc_data, schedule_num) {
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  i_num_ao = get_node_value("numAo");

  document.getElementById("ws_amps_name").innerHTML = get_node_value("volName");
  document.getElementById("ws_volts_name").innerHTML = get_node_value("wfsName");
  document.getElementById("ws_wavecontrol_name").innerHTML = get_node_value("currentName");
  document.getElementById("ws_pkamps_name").innerHTML = get_node_value("pkampsName");
  document.getElementById("ws_freq_name").innerHTML = get_node_value("freqName");
  document.getElementById("ws_pulse_name").innerHTML = get_node_value("pulseName");

  document.getElementById("ws_amps_units").innerHTML = get_node_value("volUnit");
  document.getElementById("ws_volts_units").innerHTML = get_node_value("wfsUnit");
  document.getElementById("ws_wavecontrol_units").innerHTML = get_node_value("currentUnit");
  document.getElementById("ws_pkamps_units").innerHTML = get_node_value("pkampsUnit");
  document.getElementById("ws_freq_units").innerHTML = get_node_value("freqUnit");
  document.getElementById("ws_pulse_units").innerHTML = get_node_value("pulseUnit");

  set_cmd_min_max(xml_doc_data);
  document.getElementById("lab_ws_min_amps").innerHTML = i_min_amps;
  document.getElementById("lab_ws_max_amps").innerHTML = i_max_amps;
  document.getElementById("lab_ws_min_volts").innerHTML = i_min_volts;
  document.getElementById("lab_ws_max_volts").innerHTML = i_max_volts;
  document.getElementById("lab_ws_min_wavecon").innerHTML = i_min_wv_ctrl;
  document.getElementById("lab_ws_max_wavecon").innerHTML = i_max_wv_ctrl;
  document.getElementById("lab_ws_min_pkamps").innerHTML = i_min_pkamps;
  document.getElementById("lab_ws_max_pkamps").innerHTML = i_max_pkamps;
  document.getElementById("lab_ws_min_freq").innerHTML = i_min_freq;
  document.getElementById("lab_ws_max_freq").innerHTML = i_max_freq;
  document.getElementById("lab_ws_min_pulse").innerHTML = i_min_pulse;
  document.getElementById("lab_ws_max_pulse").innerHTML = i_max_pulse;

  node_data = xml_doc_data.getElementsByTagName("weldSchedules");
  document.getElementById("txt_amps").value = get_node_value("volts" + schedule_num);
  document.getElementById("txt_volts").value = get_node_value("waveControl" + schedule_num);
  document.getElementById("txt_wavecontrol").value = get_node_value("amps" + schedule_num);
  document.getElementById("txt_pkamps").value = get_node_value("pkamps" + schedule_num);
  document.getElementById("txt_freq").value = get_node_value("frequency" + schedule_num);
  document.getElementById("txt_pulse").value = get_node_value("pulse" + schedule_num);
  document.getElementById("txt_travelspeed").value = get_node_value("travelSpeed" + schedule_num);
  document.getElementById("txt_delaytime").value = get_node_value("delayTime" + schedule_num);

  for (var i = 1 ; i <= i_num_ao; i++) {
    document.getElementById("ws_item" + i).style.display = "block";
  }
  document.getElementById("ws_travelspeed").style.display = "block";
  document.getElementById("ws_delaytime").style.display = "block";

  if (get_node_value("rampEnb") == 0) {
    var schedu_ramping_mode = document.getElementById("select_ramping_mode");
    switch (parseInt(get_node_value("rampingMode" + schedule_num), RADIX_DECIMAL_NUMBER)) {
      case 1:
        schedu_ramping_mode.value = get_prct_dict_text(164);
        break;
      case 2:
        schedu_ramping_mode.value = get_prct_dict_text(165);
        break;
      case 3:
        schedu_ramping_mode.value = get_prct_dict_text(166);
        break;
      case 4:
        schedu_ramping_mode.value = get_prct_dict_text(167);
        break;
//      case 5:
//        schedu_ramping_mode.value = get_prct_dict_text(168);
//        break;
      default:
        break;
    }
    document.getElementById("ws_ramping_mode").style.display = "block";
  } else {
    document.getElementById("ws_ramping_mode").style.display = "none";
  }

  i_heatwave_opt = parseInt(get_node_value("heatWaveOption"), RADIX_DECIMAL_NUMBER);
  if (i_heatwave_opt > HEATWAVE_OPTN_NOT_EXIST) {
    set_heatwave_items(schedule_num);
    set_heatwave(parseInt(get_node_value("heatwaveMode" + schedule_num), RADIX_DECIMAL_NUMBER));
    if (get_node_value("weaveSynch") == 0) {
      document.getElementById("ws_heatwave_mode").style.display = "block";
    } else {
      non_display_heatwave();
      document.getElementById("ws_heatwave_mode").style.display = "none";
    }
  }

  set_cmd_digit(xml_doc_data);
  set_val_weldsched(9);
  display_cmd_help_icon(xml_doc_data);
}

function set_weld_sch_tab(contents_area_elem, xml_doc_data) {
  treeSelectNum = selected_sch_num;
  open_tab_no = 1;
  document.getElementById("weldsched_tab").style.backgroundColor = Gr03;
  contents_area_elem.innerHTML = get_weld_sch_lft_scrn(xml_doc_data);
  document.getElementById("weldsched_item1").style.backgroundColor = B01;
  contents_area_elem.innerHTML += "<div id=\"right_screen\">" + get_weld_sch_rght_scrn() + "</div>";
  set_weld_sch_scrn_items_val(xml_doc_data, 1);
  contents_area_elem.innerHTML += "<div id=\"message_box\" class=\"c-message_box c-message_box-text\"></div>";
}

function set_val_runin(setRnVal) {
  switch (setRnVal) {
    case 1:
      validate_check_slg("txt_ru_amps", i_min_amps, i_max_amps, 'slg_inru_amps', voltage_cmd_format);
      set_aw_data('s_rn_volts', 'txt_ru_amps', treeSelectNum, setRnVal);
      break;
    case 2:
      validate_check_slg("txt_ru_volts", i_min_volts, i_max_volts, 'slg_inru_volts', wfs_cmd_format);
      set_aw_data('s_rn_wv_ctrl', 'txt_ru_volts', treeSelectNum, setRnVal);
      break;
    case 3:
      validate_check_slg("txt_ru_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inru_wavecon', current_cmd_format);
      set_aw_data('s_rn_amps', 'txt_ru_wavecontrol', treeSelectNum, setRnVal);
      break;
    case 4:
      validate_check_slg("txt_ru_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inru_pkamps', pk_curr_cmd_format);
      set_aw_data('s_rn_pkamps', 'txt_ru_pkamps', treeSelectNum, setRnVal);
      break;
    case 5:
      validate_check_slg("txt_ru_freq", i_min_freq, i_max_freq, 'slg_inru_freq', freq_cmd_format);
      set_aw_data('s_rn_freq', 'txt_ru_freq', treeSelectNum, setRnVal);
      break;
    case 6:
      validate_check_slg("txt_ru_pulse", i_min_pulse, i_max_pulse, 'slg_inru_pulse', pulse_cmd_format);
      set_aw_data('s_rn_pulse', 'txt_ru_pulse', treeSelectNum, setRnVal);
      break;
    case 7:
      validate_check("txt_ru_delaytime", i_min_delaytime, i_max_delaytime);
      set_val_items('s_rn_dly_tm', 'txt_ru_delaytime', 0, i_min_delaytime, i_max_delaytime, 2, setRnVal);
      break;
    case 8:
      set_text_value("txt_ru_amps", i_min_amps, i_max_amps, 'slg_inru_amps', voltage_cmd_format);
      set_text_value("txt_ru_volts", i_min_volts, i_max_volts, 'slg_inru_volts', wfs_cmd_format);
      set_text_value("txt_ru_wavecontrol", i_min_wv_ctrl, i_max_wv_ctrl, 'slg_inru_wavecon', current_cmd_format);
      set_text_value("txt_ru_pkamps", i_min_pkamps, i_max_pkamps, 'slg_inru_pkamps', pk_curr_cmd_format);
      set_text_value("txt_ru_freq", i_min_freq, i_max_freq, 'slg_inru_freq', freq_cmd_format);
      set_text_value("txt_ru_pulse", i_min_pulse, i_max_pulse, 'slg_inru_pulse', pulse_cmd_format);
      break;
  }
}

function set_runin(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  document.getElementById("ru_amps_name").innerHTML = get_node_value("volName");
  document.getElementById("ru_volts_name").innerHTML = get_node_value("wfsName");
  document.getElementById("ru_wavecontrol_name").innerHTML = get_node_value("currentName");
  document.getElementById("ru_pkamps_name").innerHTML = get_node_value("pkampsName");
  document.getElementById("ru_freq_name").innerHTML = get_node_value("freqName");
  document.getElementById("ru_pulse_name").innerHTML = get_node_value("pulseName");

  document.getElementById("ru_amps_unit").innerHTML = get_node_value("volUnit");
  document.getElementById("ru_volts_unit").innerHTML = get_node_value("wfsUnit");
  document.getElementById("ru_wavecontrol_unit").innerHTML = get_node_value("currentUnit");
  document.getElementById("ru_pkamps_unit").innerHTML = get_node_value("pkampsUnit");
  document.getElementById("ru_freq_unit").innerHTML = get_node_value("freqUnit");
  document.getElementById("ru_pulse_unit").innerHTML = get_node_value("pulseUnit");

  set_cmd_min_max(xml_doc_data);
  set_cmd_digit(xml_doc_data);
  document.getElementById("lab_ru_min_amps").innerHTML = i_min_amps;
  document.getElementById("lab_ru_max_amps").innerHTML = i_max_amps;
  document.getElementById("lab_ru_min_volts").innerHTML = i_min_volts;
  document.getElementById("lab_ru_max_volts").innerHTML = i_max_volts;
  document.getElementById("lab_ru_min_wavecon").innerHTML = i_min_wv_ctrl;
  document.getElementById("lab_ru_max_wavecon").innerHTML = i_max_wv_ctrl;
  document.getElementById("lab_ru_min_pkamps").innerHTML = i_min_pkamps;
  document.getElementById("lab_ru_max_pkamps").innerHTML = i_max_pkamps;
  document.getElementById("lab_ru_min_freq").innerHTML = i_min_freq;
  document.getElementById("lab_ru_max_freq").innerHTML = i_max_freq;
  document.getElementById("lab_ru_min_pulse").innerHTML = i_min_pulse;
  document.getElementById("lab_ru_max_pulse").innerHTML = i_max_pulse;

  node_data = xml_doc_data.getElementsByTagName("processSchedules")[0].getElementsByTagName("runin");
  var i_runin_enb = get_node_value("runinEnb");
  var i_runin = document.getElementById("select_runin");
  var disp_runin = document.getElementById("runin_enable_screen");
  var r_screen_runin = document.getElementById("runin_r_screen");
  if (i_runin_enb == 0) {
    i_runin.value = get_prct_dict_text(58);
    disp_runin.style.visibility = "visible";
    r_screen_runin.style.overflow = "";
  } else if (i_runin_enb == 1) {
    i_runin.value = get_prct_dict_text(59);
    disp_runin.style.visibility = "hidden";
    r_screen_runin.style.overflow = "hidden";
  }

  document.getElementById("txt_ru_amps").value = get_node_value("amps");
  document.getElementById("txt_ru_volts").value = get_node_value("volts");
  document.getElementById("txt_ru_wavecontrol").value = get_node_value("waveControl");
  document.getElementById("txt_ru_pkamps").value = get_node_value("pkamps");
  document.getElementById("txt_ru_freq").value = get_node_value("freq");
  document.getElementById("txt_ru_pulse").value = get_node_value("pulse");
  document.getElementById("txt_ru_delaytime").value = get_node_value("delayTime");

  set_val_runin(8);

  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  i_num_ao = get_node_value("numAo");
  for (var i = 1 ; i <= i_num_ao; i++) {
    document.getElementById("runin_item" + i).style.display = "block";
  }
}

function set_burnback(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  document.getElementById("bb_amps_name").innerHTML = get_node_value("volName");
  document.getElementById("bb_volts_name").innerHTML = get_node_value("wfsName");
  document.getElementById("bb_wavecontrol_name").innerHTML = get_node_value("currentName");
  document.getElementById("bb_pkamps_name").innerHTML = get_node_value("pkampsName");
  document.getElementById("bb_freq_name").innerHTML = get_node_value("freqName");
  document.getElementById("bb_pulse_name").innerHTML = get_node_value("pulseName");

  document.getElementById("bb_amps_unit").innerHTML = get_node_value("volUnit");
  document.getElementById("bb_volts_unit").innerHTML = get_node_value("wfsUnit");
  document.getElementById("bb_wavecontrol_unit").innerHTML = get_node_value("currentUnit");
  document.getElementById("bb_pkamps_unit").innerHTML = get_node_value("pkampsUnit");
  document.getElementById("bb_freq_unit").innerHTML = get_node_value("freqUnit");
  document.getElementById("bb_pulse_unit").innerHTML = get_node_value("pulseUnit");

  set_cmd_min_max(xml_doc_data);
  set_cmd_digit(xml_doc_data);
  document.getElementById("lab_bb_min_amps").innerHTML = i_min_amps;
  document.getElementById("lab_bb_max_amps").innerHTML = i_max_amps;
  document.getElementById("lab_bb_min_volts").innerHTML = i_min_volts;
  document.getElementById("lab_bb_max_volts").innerHTML = i_max_volts;
  document.getElementById("lab_bb_min_wavecon").innerHTML = i_min_wv_ctrl;
  document.getElementById("lab_bb_max_wavecon").innerHTML = i_max_wv_ctrl;
  document.getElementById("lab_bb_min_pkamps").innerHTML = i_min_pkamps;
  document.getElementById("lab_bb_max_pkamps").innerHTML = i_max_pkamps;
  document.getElementById("lab_bb_min_freq").innerHTML = i_min_freq;
  document.getElementById("lab_bb_max_freq").innerHTML = i_max_freq;
  document.getElementById("lab_bb_min_pulse").innerHTML = i_min_pulse;
  document.getElementById("lab_bb_max_pulse").innerHTML = i_max_pulse;

  node_data = xml_doc_data.getElementsByTagName("processSchedules")[0].getElementsByTagName("burnback");
  var i_burnba_enb = get_node_value("burnbackEnb");
  var i_burnback = document.getElementById("select_burnback");
  var disp_burnback = document.getElementById("burnback_enable_screen");
  var r_screen_burnback = document.getElementById("burnback_r_screen");
  if (i_burnba_enb == 0) {
    i_burnback.value = get_prct_dict_text(58);
    disp_burnback.style.visibility = "visible";
    r_screen_burnback.style.overflow = "";
  } else {
    i_burnback.value = get_prct_dict_text(59);
    disp_burnback.style.visibility = "hidden";
    r_screen_burnback.style.overflow = "hidden";
  }

  document.getElementById("txt_bb_amps").value = get_node_value("amps");
  document.getElementById("txt_bb_volts").value = get_node_value("volts");
  document.getElementById("txt_bb_wavecontrol").value = get_node_value("waveControl");
  document.getElementById("txt_bb_pkamps").value = get_node_value("pkamps");
  document.getElementById("txt_bb_freq").value = get_node_value("freq");
  document.getElementById("txt_bb_pulse").value = get_node_value("pulse");
  document.getElementById("txt_bb_delaytime").value = get_node_value("delayTime");
  set_val_burnback(8);

  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  i_num_ao = get_node_value("numAo");
  for (var i = 1 ; i <= i_num_ao; i++) {
    document.getElementById("burnback_item" + i).style.display = "block";
  }
}

function set_wstk_reset(wstk_reset_enb) {
  var i_wiresr_resets = document.getElementById("select_resets");
  var disp_wiresets = document.getElementById("wiresets_enable_screen");
  var r_screen_wiresets = document.getElementById("wiresets_r_screen");
  if(wstk_reset_enb == 0) {
    i_wiresr_resets.value = get_prct_dict_text(58);
    disp_wiresets.style.visibility = "visible";
    r_screen_wiresets.style.overflow = "";
  } else {
    i_wiresr_resets.value = get_prct_dict_text(59);
    disp_wiresets.style.visibility = "hidden";
    r_screen_wiresets.style.overflow = "hidden";
  }
}

function set_wirestickResets(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  document.getElementById("wr_amps_name").innerHTML = get_node_value("volName");
  document.getElementById("wr_volts_name").innerHTML = get_node_value("wfsName");
  document.getElementById("wr_wavecontrol_name").innerHTML = get_node_value("currentName");
  document.getElementById("wr_pkamps_name").innerHTML = get_node_value("pkampsName");
  document.getElementById("wr_freq_name").innerHTML = get_node_value("freqName");
  document.getElementById("wr_pulse_name").innerHTML = get_node_value("pulseName");

  document.getElementById("wr_amps_unit").innerHTML = get_node_value("volUnit");
  document.getElementById("wr_volts_unit").innerHTML = get_node_value("wfsUnit");
  document.getElementById("wr_wavecontrol_unit").innerHTML = get_node_value("currentUnit");
  document.getElementById("wr_pkamps_unit").innerHTML = get_node_value("pkampsUnit");
  document.getElementById("wr_freq_unit").innerHTML = get_node_value("freqUnit");
  document.getElementById("wr_pulse_unit").innerHTML = get_node_value("pulseUnit");

  set_cmd_min_max(xml_doc_data);
  set_cmd_digit(xml_doc_data);
  document.getElementById("lab_wr_min_amps").innerHTML = i_min_amps;
  document.getElementById("lab_wr_max_amps").innerHTML = i_max_amps;
  document.getElementById("lab_wr_min_volts").innerHTML = i_min_volts;
  document.getElementById("lab_wr_max_volts").innerHTML = i_max_volts;
  document.getElementById("lab_wr_min_wavecon").innerHTML = i_min_wv_ctrl;
  document.getElementById("lab_wr_max_wavecon").innerHTML = i_max_wv_ctrl;
  document.getElementById("lab_wr_min_pkamps").innerHTML = i_min_pkamps;
  document.getElementById("lab_wr_max_pkamps").innerHTML = i_max_pkamps;
  document.getElementById("lab_wr_min_freq").innerHTML = i_min_freq;
  document.getElementById("lab_wr_max_freq").innerHTML = i_max_freq;
  document.getElementById("lab_wr_min_pulse").innerHTML = i_min_pulse;
  document.getElementById("lab_wr_max_pulse").innerHTML = i_max_pulse;

  node_data = xml_doc_data.getElementsByTagName("processSchedules")[0].getElementsByTagName("wirestickResets");
  set_wstk_reset(get_node_value("wrEnb"));

  document.getElementById("select_resets_cnt").value = get_node_value("tries");
  document.getElementById("txt_wr_amps").value = get_node_value("amps");
  document.getElementById("txt_wr_volts").value = get_node_value("volts");
  document.getElementById("txt_wr_wavecontrol").value = get_node_value("waveControl");
  document.getElementById("txt_wr_pkamps").value = get_node_value("pkamps");
  document.getElementById("txt_wr_freq").value = get_node_value("freq");
  document.getElementById("txt_wr_pulse").value = get_node_value("pulse");
  document.getElementById("txt_wr_delaytime").value = get_node_value("delayTime");
  set_val_wiresets(8);

  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  i_num_ao = get_node_value("numAo");
  for (var i = 1 ; i <= i_num_ao; i++) {
    document.getElementById("wiresets_item" + i).style.display = "block";
  }
}

function set_on_the_fly(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  document.getElementById("of_amps_name").innerHTML = get_node_value("volName");
  document.getElementById("of_volts_name").innerHTML = get_node_value("wfsName");
  document.getElementById("of_wavecontrol_name").innerHTML = get_node_value("currentName");
  document.getElementById("of_pkamps_name").innerHTML = get_node_value("pkampsName");
  document.getElementById("of_freq_name").innerHTML = get_node_value("freqName");
  document.getElementById("of_pulse_name").innerHTML = get_node_value("pulseName");

  document.getElementById("of_amps_unit").innerHTML = get_node_value("volUnit");
  document.getElementById("of_volts_unit").innerHTML = get_node_value("wfsUnit");
  document.getElementById("of_wavecontrol_unit").innerHTML = get_node_value("currentUnit");
  document.getElementById("of_pkamps_unit").innerHTML = get_node_value("pkampsUnit");
  document.getElementById("of_freq_unit").innerHTML = get_node_value("freqUnit");
  document.getElementById("of_pulse_unit").innerHTML = get_node_value("pulseUnit");

  set_cmd_min_max(xml_doc_data);
  set_cmd_digit(xml_doc_data);
  document.getElementById("lab_otf_min_amps").innerHTML = parseFloat(0).toFixed(voltage_cmd_format);
  document.getElementById("lab_otf_max_amps").innerHTML = i_max_amps;
  document.getElementById("lab_otf_min_volts").innerHTML = parseFloat(0).toFixed(wfs_cmd_format);
  document.getElementById("lab_otf_max_volts").innerHTML = i_max_volts;
  document.getElementById("lab_otf_min_wavecon").innerHTML = parseFloat(0).toFixed(current_cmd_format);
  document.getElementById("lab_otf_max_wavecon").innerHTML = i_max_wv_ctrl;
  document.getElementById("lab_otf_min_pkamps").innerHTML = parseFloat(0).toFixed(pk_curr_cmd_format);
  document.getElementById("lab_otf_max_pkamps").innerHTML = i_max_pkamps;
  document.getElementById("lab_otf_min_freq").innerHTML = parseFloat(0).toFixed(freq_cmd_format);
  document.getElementById("lab_otf_max_freq").innerHTML = i_max_freq;
  document.getElementById("lab_otf_min_pulse").innerHTML = parseFloat(0).toFixed(pulse_cmd_format);
  document.getElementById("lab_otf_max_pulse").innerHTML = i_max_pulse;

  node_data = xml_doc_data.getElementsByTagName("processSchedules")[0].getElementsByTagName("onTheFly");
  document.getElementById("txt_otf_amps").value = get_node_value("amps");
  document.getElementById("txt_otf_volts").value = get_node_value("volts");
  document.getElementById("txt_otf_wavecontrol").value = get_node_value("waveControl");
  document.getElementById("txt_otf_pkamps").value = get_node_value("pkamps");
  document.getElementById("txt_otf_freq").value = get_node_value("freq");
  document.getElementById("txt_otf_pulse").value = get_node_value("pulse");
  document.getElementById("txt_otf_travelspeed").value = get_node_value("travelSpeed");

  set_val_onthefly(8);

  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  i_num_ao = get_node_value("numAo");
  for (var i = 1 ; i <= i_num_ao; i++) {
    document.getElementById("onthefly_item" + i).style.display = "block";
  }
}

function set_st2t_st(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("processSchedules")[0].getElementsByTagName("s2t_st");
  document.getElementById("txt_s2t_st_cur").value = get_node_value("s2t_st_cur");
  document.getElementById("txt_s2t_st_alc").value = get_node_value("s2t_st_alc");
  document.getElementById("txt_s2t_st_tim").value = get_node_value("s2t_st_tim");
  document.getElementById("txt_s2t_st_slp").value = get_node_value("s2t_st_slp");
  set_val_s2t_st(5);
}

function set_st2t_ed(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("processSchedules")[0].getElementsByTagName("s2t_ed");
  document.getElementById("txt_s2t_ed_cur").value = get_node_value("s2t_ed_cur");
  document.getElementById("txt_s2t_ed_alc").value = get_node_value("s2t_ed_alc");
  document.getElementById("txt_s2t_ed_tim").value = get_node_value("s2t_ed_tim");
  document.getElementById("txt_s2t_ed_slp").value = get_node_value("s2t_ed_slp");
  var i_s2t_wireretract = document.getElementById("txt_s2t_wireretract");
  i_s2t_wireretract.value = get_node_value("s2t_ed_wireretract");
  if (fron_tpsi_id_custom & 16) {
    i_s2t_wireretract.disabled = false;
  } else {
    i_s2t_wireretract.disabled = true;
  }
  set_val_s2t_ed(6);
}

function set_process_tab(contents_area_elem, xml_doc_data) {
  contents_area_elem.innerHTML = get_process_lft_scrn(xml_doc_data);

  var item_runin = document.getElementById("runin_item");
  var item_burnback = document.getElementById("burnback_item");
  var item_wirestickresets = document.getElementById("wirestickresets_item");
  var item_onthefly = document.getElementById("onthefly_item");
  var item_s2t_st = document.getElementById("s2t_st_item");
  var item_s2t_ed = document.getElementById("s2t_ed_item");
  if (ps_type != PS_FRONIUS_TPSI) {
    if(ps_type == PS_LINCOLN){
      node_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtEnb")[0].firstChild.nodeValue;
      if(node_data == 1){
        contents_area_elem.innerHTML += "<div id=\"right_screen\">" + get_touch_retract_rght_scrn() + "</div>";
        document.getElementById("touchretract_item").style.backgroundColor = B01;
        touch_open();
        set_tcrt(xml_doc_data);
        if(help_stts == HELP_STTS_NONE) {
          window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=1";
        }
      }else{
        close_icon_screen();
        contents_area_elem.innerHTML += "<div id=\"right_screen\">" + get_runin_rght_scrn() + "</div>";
        set_runin(xml_doc_data);
        document.getElementById("runin_item").style.backgroundColor = B01;
      }
    }else{
      close_icon_screen();
      contents_area_elem.innerHTML += "<div id=\"right_screen\">" + get_runin_rght_scrn() + "</div>";
      set_runin(xml_doc_data);
      document.getElementById("runin_item").style.backgroundColor = B01;
    }
  } else {
    close_icon_screen();
    item_burnback.style.display = "none";
    item_wirestickresets.style.display = "none";
    if (data_mode == SPECIAL_TWO_STEP) {
      item_s2t_st.style.display = "";
      item_s2t_ed.style.display = "";
      contents_area_elem.innerHTML += "<div id=\"right_screen\">" +  get_runin_rght_scrn() + "</div>";
      set_runin(xml_doc_data);
      document.getElementById("runin_item").style.backgroundColor = B01;
    } else {
      treeSelectNum = 5;
      item_runin.style.display = "none";
      contents_area_elem.innerHTML += "<div id=\"right_screen\">" +  get_on_the_fly_scrn() + "</div>";
      set_on_the_fly(xml_doc_data);
      document.getElementById("onthefly_item").style.backgroundColor = B01;
    }
  }
}

function set_ps_sfi(xml_doc_data) {
  var i_ps_sfi = document.getElementById("select_ps_sfi");
  var i_ps_sfi_hot_start = document.getElementById("txt_ps_sfi_hot_start");
  node_data = xml_doc_data.getElementsByTagName("powerSupply")[0].getElementsByTagName("ps_sfi");
  if (get_node_value("sfi") == 0) {
    i_ps_sfi.value = get_prct_dict_text(59);
  } else {
    i_ps_sfi.value = get_prct_dict_text(58);
  }
  if (fron_tpsi_id_custom & 4) {
    i_ps_sfi.disabled = false;
  } else {
    i_ps_sfi.disabled = true;
  }
  i_ps_sfi_hot_start.value = get_node_value("sfi_hotstrt");
  if (fron_tpsi_id_custom & 8) {
    i_ps_sfi_hot_start.disabled = false;
  } else {
    i_ps_sfi_hot_start.disabled = true;
  }
}

function set_ps_sp(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("powerSupply")[0].getElementsByTagName("ps_sp");
  var i_ps_sp_enable = document.getElementById("select_ps_sp_enable");
  if (get_node_value("sp_enable") == 0) {
    i_ps_sp_enable.value = get_prct_dict_text(59);
  } else {
    i_ps_sp_enable.value = get_prct_dict_text(58);
  }
  document.getElementById("txt_ps_sp_deltawfs").value = get_node_value("sp_deltawfs");
  document.getElementById("txt_ps_sp_deltawfs_units").innerHTML = get_node_value("sp_deltawfs_units");
  i_ps_sp_deltawfs_max = get_node_value("sp_deltawfs_max");
  i_ps_sp_deltawfs_min = get_node_value("sp_deltawfs_min");
  document.getElementById("txt_ps_sp_freq").value = get_node_value("sp_freq");
  document.getElementById("txt_ps_sp_duty").value = get_node_value("sp_duty");
  document.getElementById("txt_ps_sp_alc_high").value = get_node_value("sp_alc_high");
  document.getElementById("txt_ps_sp_alc_low").value = get_node_value("sp_alc_low");
  set_val_ps_sp(7);
}

function set_ps_other(xml_doc_data) {
  node_data = xml_doc_data.getElementsByTagName("powerSupply")[0].getElementsByTagName("ps_other");
  var i_ps_other_pene_stabi = document.getElementById("txt_ps_other_pene_stabi");
  i_ps_other_pene_stabi.value = get_node_value("pene_stabi");
  if (fron_tpsi_id_custom & 1) {
    i_ps_other_pene_stabi.disabled = false;
  } else {
    i_ps_other_pene_stabi.disabled = true;
  }
  document.getElementById("txt_ps_other_pene_stabi_units").innerHTML = get_node_value("pene_stabi_units");
  i_ps_other_pene_stabi_max = get_node_value("pene_stabi_max");
  var i_ps_other_arcl_stabi = document.getElementById("txt_ps_other_arcl_stabi");
  i_ps_other_arcl_stabi.value = get_node_value("arcl_stabi");
  if (fron_tpsi_id_custom & 2) {
    i_ps_other_arcl_stabi.disabled = false;
  } else {
    i_ps_other_arcl_stabi.disabled = true;
  }
}

function show_power_supply_diagram(item_number) {
  var item_sfi = document.getElementById("sfi_item");
  var item_synchro_pulse = document.getElementById("synchro_pulse_item");
  var item_others = document.getElementById("others_item");
  item_sfi.style.backgroundColor = Gr02;
  item_synchro_pulse.style.backgroundColor = Gr02;
  item_others.style.backgroundColor = Gr02;

  treeSelectNum = item_number;
  switch (item_number) {
    case 1:
      item_sfi.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_EQSETUP_SFI);
      break;
    case 2:
      item_synchro_pulse.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_EQSETUP_SP);
      break;
    case 3:
      item_others.style.backgroundColor = B01;
      request_karel(REQ_FUNC_GET_DATA, REQ_FUNQ_DTL_EQSETUP_OTHER);
      break;
    default:
      break;
  }
}

function show_scaling_diagram(ao_num) {
  var title_ao1 = document.getElementById("ao1_title");
  var title_ao2 = document.getElementById("ao2_title");
  var title_ao3 = document.getElementById("ao3_title");
  var title_ao4 = document.getElementById("ao4_title");
  var title_ao5 = document.getElementById("ao5_title");
  var title_ao6 = document.getElementById("ao6_title");
  var unit_str = "";
  var rght_scrn_scaling = document.getElementById("ao_r_screen");
  var scaling_msg = document.getElementById("message_box");

  title_ao1.style.backgroundColor = Gr02;
  title_ao2.style.backgroundColor = Gr02;
  title_ao3.style.backgroundColor = Gr02;
  title_ao4.style.backgroundColor = Gr02;
  title_ao5.style.backgroundColor = Gr02;
  title_ao6.style.backgroundColor = Gr02;

  treeSelectNum = ao_num;

  switch (ao_num) {
    case 1:
      title_ao1.style.backgroundColor = B01;
      unit_str = s_voltage_unit;
      break;
    case 2:
      title_ao2.style.backgroundColor = B01;
      unit_str = s_wfs_unit;
      break;
    case 3:
      title_ao3.style.backgroundColor = B01;
      unit_str = s_current_unit;
      break;
    case 4:
      title_ao4.style.backgroundColor = B01;
      unit_str = s_pk_curr_unit;
      break;
    case 5:
      title_ao5.style.backgroundColor = B01;
      unit_str = s_freq_unit;
      break;
    case 6:
      title_ao6.style.backgroundColor = B01;
      unit_str = s_pulse_unit;
      break;
    default:
      break;
  }
  if (unit_str == "Amps") {
    rght_scrn_scaling.style.display = "block";
    scaling_msg.innerHTML = "";
  } else {
    rght_scrn_scaling.style.display = "none";
    scaling_msg.innerHTML = document.getElementById("scaling_error_message").innerHTML;
  }

  switch (parseInt(help_stts, RADIX_DECIMAL_NUMBER)) {
    case HELP_STTS_NONE:
      window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + ao_num;
      break;
    case HELP_STTS_EXIT:
      window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_help_num=0&s_help_stts=0";
      help_stts = HELP_STTS_NONE;
      break;
    default:
      window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_help_stts=" + HELP_STTS_COMP;
      help_stts = HELP_STTS_COMP;
      break;
  }
}

function set_scaling_tab(contents_area_elem, xml_doc_data) {
  if(help_stts == HELP_STTS_NONE) {
    window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=1";
  }
  contents_area_elem.innerHTML += get_scaling_lft_scrn(xml_doc_data);
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  i_num_ao = get_node_value("numAo");
  for (var i = 1 ; i <= i_num_ao; i++) {
    document.getElementById("ao"+ i +"_item").style.display = "block";
  }
  contents_area_elem.innerHTML += "<div id=\"right_screen\">" + get_scaling_rght_scrn() + "</div>";
  document.getElementById("ao1_title").style.backgroundColor = B01;
  node_data = xml_doc_data.getElementsByTagName("weldNumAo");
  s_voltage_unit = get_node_value("volUnit");
  s_wfs_unit = get_node_value("wfsUnit");
  s_current_unit = get_node_value("currentUnit");
  s_pk_curr_unit = get_node_value("pkampsUnit");
  s_freq_unit = get_node_value("freqUnit");
  s_pulse_unit = get_node_value("pulseUnit");
  node_data = xml_doc_data.getElementsByTagName("scaling");
  var scaling_setup = document.getElementById("ao_select_scaling");
  if (get_node_value("setupEnb") == 0) {
    scaling_setup.value = get_prct_dict_text(58);
  } else {
    scaling_setup.value = get_prct_dict_text(59);
  }
  for (var i = 1; i <= 10; i++) {
    document.getElementById("ao_txt_command" + i).value = get_node_value("command" + i);
    document.getElementById("ao_txt_measured" + i).value = get_node_value("measured" + i);
  }
  var scaling_msg;
  if (s_voltage_unit == "Amps") {
    document.getElementById("ao_r_screen").style.display = "block";
    scaling_msg = "";
  } else {
    document.getElementById("ao_r_screen").style.display = "none";
    scaling_msg = document.getElementById("scaling_error_message").innerHTML;
  }
  contents_area_elem.innerHTML += "<div id=\"message_box\" class=\"c-message_box c-message_box-text\">" + scaling_msg + "</div>";
}

function display_multipass(contents_area_elem, xml_doc_data) {
  select_tab_no = 6;
  document.getElementById("tab_menu_weld").style.display = "none";
  document.getElementById("tab_menu_multi").style.display = "block";
  document.getElementById("multipass_tab").style.backgroundColor = Gr03;

  contents_area_elem.innerHTML = get_tracking_tab_scrn();

  node_data = xml_doc_data.getElementsByTagName("multipass");
  document.getElementById("txt_pathdata").value = get_node_value("multipassPath");
  document.getElementById("txt_mdeltime").value = get_node_value("multipassDelay");

  var tast_enb_y = document.getElementById("select_tlevel");
  if (get_node_value("multipassEnby") == 0) {
    tast_enb_y.value = get_prct_dict_text(58);
  } else {
    tast_enb_y.value = get_prct_dict_text(59);
  }

  var tast_enb_z = document.getElementById("select_tver");
  if (get_node_value("multipassEnbz") == 0) {
    tast_enb_z.value = get_prct_dict_text(58);
  } else {
    tast_enb_z.value = get_prct_dict_text(59);
  }

  document.getElementById("txt_lrgain").value = get_node_value("multipassCompy");
  document.getElementById("txt_udgain").value = get_node_value("multipassCompz");
  document.getElementById("txt_ymininc").value = get_node_value("multipassMiny");
  document.getElementById("txt_zmininc").value = get_node_value("multipassMinz");
  document.getElementById("txt_ymax").value = get_node_value("multipassMaxy");
  document.getElementById("txt_zmax").value = get_node_value("multipassMaxz");
  document.getElementById("txt_ymaxinc").value = get_node_value("multipassMaxincy");
  document.getElementById("txt_zmaxinc").value = get_node_value("multipassMaxincz");
  document.getElementById("txt_ysamp").value = get_node_value("multipassSpamy");
  document.getElementById("txt_zsamp").value = get_node_value("multipassSpamz");
  document.getElementById("txt_sctim").value = get_node_value("multipassMspam");
  document.getElementById("txt_ctime").value = get_node_value("multipassMstim");
  document.getElementById("txt_timng").value = get_node_value("multipassTiming");

  var offset_frame = document.getElementById("select_offset_frame");
  if (get_node_value("offsetFrame") == 1) {
    offset_frame.value = get_prct_dict_text(173);
  } else {
    offset_frame.value = get_prct_dict_text(174);
  }
}

function set_tab_area(tab_num, xml_doc_data) {
  var WELD_SCHED_TAB = 1;
  var EQ_SETUP_TAB = 7;
  var DIV_MSG_BOX = "<div id=\"message_box\" class=\"c-message_box c-message_box-text\"></div>";
  var contents_area = document.getElementById("contents_area");
  contents_area.innerHTML = "";

  set_header_area(xml_doc_data);

  var tab_process = document.getElementById("process_tab");
  var tab_power_supply = document.getElementById("power_supply_tab");
  var tab_arcmonitor = document.getElementById("arcmonitor_tab");
  var tab_scaling = document.getElementById("scaling_tab");
  var tab_scaling_fron = document.getElementById("scaling_tab_fron");
  var tab_sequence = document.getElementById("sequence_tab");
  var tab_multipass = document.getElementById("multipass_tab");
  document.getElementById("weldsched_tab").style.backgroundColor = Gr02;
  tab_process.style.backgroundColor = Gr02;
  tab_arcmonitor.style.backgroundColor = Gr02;
  tab_scaling.style.backgroundColor = Gr02;
  tab_sequence.style.backgroundColor = Gr02;
  tab_multipass.style.backgroundColor = Gr02;

  node_data = xml_doc_data.getElementsByTagName("arcMonitor");
  if (get_node_value("amonOption") == 0) {
    tab_arcmonitor.disabled = false;
  } else {
    tab_arcmonitor.disabled = true;
    tab_arcmonitor.style.background = Gr03;
  }

  node_data = xml_doc_data.getElementsByTagName("scaling");
  i_scaling_opt = get_node_value("scalEnb");
  if (i_scaling_opt == 0) {
    tab_scaling.disabled = false;
    tab_scaling_fron.disabled = false;
  } else {
    tab_scaling.disabled = true;
    tab_scaling.style.background = Gr03;
  }

  node_data = xml_doc_data.getElementsByTagName("multipass");
  i_multiview_flg = get_node_value("multiviewFlg");
  var tab_page_right = document.getElementById("chg_tab_page_right");
  if (ps_type != PS_FRONIUS_TPSI) {
    if (i_multiview_flg != 1) {
      tab_multipass.style.display = "none";
      tab_page_right.style.display = "none";
    }
  } else {
    if (data_mode == SPECIAL_TWO_STEP) {
      if (i_multiview_flg != 1) {
        tab_multipass.style.display = "none";
        if (i_scaling_opt != 0) {
          tab_page_right.style.display = "none";
        }
      }
      tab_scaling.style.display = "none";
      tab_scaling_fron.style.backgroundColor = Gr02;
      tab_power_supply.style.backgroundColor = Gr02;
      tab_power_supply.style.display = "";
      node_data = xml_doc_data.getElementsByTagName("awdata");
      fron_tpsi_id_custom = parseInt(get_node_value("fron_tpsi_id_custom"), 10);
    } else {
      if (i_multiview_flg != 1) {
        tab_multipass.style.display = "none";
        tab_page_right.style.display = "none";
      }
      if (tab_num == EQ_SETUP_TAB) {
        tab_num = WELD_SCHED_TAB;
      }
    }
  }

  select_tab_no = tab_num;
  switch (tab_num) {
    case 1:
      set_weld_sch_tab(contents_area, xml_doc_data);
      break;
    case 2:

      treeSelectNum = 2;
      tab_process.style.backgroundColor = Gr03;
      if(help_stts == HELP_STTS_NONE) {
        window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + treeSelectNum;
      }
      set_process_tab(contents_area, xml_doc_data);
      contents_area.innerHTML += DIV_MSG_BOX;
      break;
    case 3:
      tab_sequence.style.backgroundColor = Gr03;
      contents_area.innerHTML += get_sequence_lft_scrn(xml_doc_data);

      node_data = xml_doc_data.getElementsByTagName("sequence");
      i_custom_flg = get_node_value("custFlg");
      if((i_custom_flg & 1) == 1) {
        treeSelectNum = 2;
        document.getElementById("gaspurge_item").style.backgroundColor = B01;
        contents_area.innerHTML += "<div id=\"right_screen\">" + get_gaspurge_rght_scrn(get_node_value("gasPurge")) + "</div>";
      } else {
        treeSelectNum = 1;
        document.getElementById("arcstartpretime_item").style.backgroundColor = B01;
        contents_area.innerHTML += "<div id=\"right_screen\">" + get_arcstartpre_rght_scrn(get_node_value("arcStartPreTime")) + "</div>";
      }
      if(help_stts == HELP_STTS_NONE) {
        window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + treeSelectNum;
      }
      contents_area.innerHTML += DIV_MSG_BOX;
      break;
    case 4:
      treeSelectNum = 1;
      tab_arcmonitor.style.backgroundColor = Gr03;
      contents_area.innerHTML += get_arcmonitor_lft_scrn(xml_doc_data);
      document.getElementById("method_item").style.backgroundColor = B01;
      contents_area.innerHTML += "<div id=\"right_screen\">" + get_method_rght_scrn() + "</div>";
      set_method_rght_scrn(xml_doc_data);
      if(help_stts == HELP_STTS_NONE) {
        window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_hlp_oth_tr=" + treeSelectNum;
      }
      contents_area.innerHTML += DIV_MSG_BOX;
      break;
    case 5:
      treeSelectNum = 1;
      tab_scaling.style.backgroundColor = Gr03;
      tab_scaling_fron.style.backgroundColor = Gr03;
      set_scaling_tab(contents_area, xml_doc_data);
      break;
    case 6:
      if ((ps_type == PS_FRONIUS_TPSI) && (data_mode == SPECIAL_TWO_STEP) && (i_scaling_opt == 0)) {
        tab_scaling_fron.style.display = "";
      }
      display_multipass(contents_area, xml_doc_data);
      break;
    case 7:
      treeSelectNum = 1;
      tab_power_supply.style.backgroundColor = Gr03;
      contents_area.innerHTML += get_power_supply_lft_scrn();
      document.getElementById("sfi_item").style.backgroundColor = B01;
      contents_area.innerHTML += "<div id=\"right_screen\">" + get_ps_sfi_rght_scrn() + "</div>";
      set_ps_sfi(xml_doc_data);
      contents_area.innerHTML += DIV_MSG_BOX;
      break;
    case 10:
      if (ps_type != PS_FRONIUS_TPSI) {
        display_multipass(contents_area, xml_doc_data);
      } else {
        if (data_mode == SPECIAL_TWO_STEP) {
          treeSelectNum = 1;
          document.getElementById("tab_menu_weld").style.display = "none";
          document.getElementById("tab_menu_multi").style.display = "block";
          if (i_scaling_opt != 0) {
            display_multipass(contents_area, xml_doc_data);
          } else {
            select_tab_no = 5;
            treeSelectNum = 1;
            tab_scaling_fron.style.display = "";
            tab_scaling_fron.style.backgroundColor = Gr03;
            set_scaling_tab(contents_area, xml_doc_data);
          }
        } else {
          display_multipass(contents_area, xml_doc_data);
        }
      }
      break;
    case 11:
      select_tab_no = 1;
      document.getElementById("tab_menu_weld").style.display = "block";
      document.getElementById("tab_menu_multi").style.display = "none";
      set_weld_sch_tab(contents_area, xml_doc_data);
      break;
    default:
      break;
  }
}

function set_right_screen(req_func_detail_num, xml_doc_data) {
  var right_screen = document.getElementById("right_screen");
  var item_touchretract = document.getElementById("touchretract_item");
  right_screen.innerHTML = "";
  right_screen.scrollTop = 0;
  switch (req_func_detail_num) {
    case REQ_FUNC_DTL_PROC_RUNIN:
      right_screen.innerHTML = get_runin_rght_scrn();
      set_runin(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_BURNBACK:
      right_screen.innerHTML = get_burnback_rght_scrn();
      set_burnback(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_WSTK_RESET:
      right_screen.innerHTML = get_wstk_reset_rght_scrn();
      set_wirestickResets(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_ON_THE_FLY:
      right_screen.innerHTML = get_on_the_fly_scrn();
      set_on_the_fly(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_S2T_ST:
      right_screen.innerHTML = get_s2t_st_rght_scrn();
      set_st2t_st(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_S2T_ED:
      right_screen.innerHTML = get_s2t_ed_rght_scrn();
      set_st2t_ed(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_SEQ_AS_PRE_TIME:
      node_data = xml_doc_data.getElementsByTagName("sequence");
      right_screen.innerHTML = get_arcstartpre_rght_scrn(get_node_value("arcStartPreTime"));
      break;
    case REQ_FUNQ_DTL_SEQ_GAS_PURGE:
      node_data = xml_doc_data.getElementsByTagName("sequence");
      right_screen.innerHTML = get_gaspurge_rght_scrn(get_node_value("gasPurge"));
      break;
    case REQ_FUNQ_DTL_SEQ_GAS_PREFLOW:
      node_data = xml_doc_data.getElementsByTagName("sequence");
      right_screen.innerHTML = get_gaspreflow_rght_scrn(get_node_value("gasPreflow"));
      break;
    case REQ_FUNQ_DTL_SEQ_AE_PRE_TIME:
      node_data = xml_doc_data.getElementsByTagName("sequence");
      right_screen.innerHTML = get_arcendpre_rght_scrn(get_node_value("arcEndPreTime"));
      break;
    case REQ_FUNQ_DTL_SEQ_GAS_POSTFLOW:
      node_data = xml_doc_data.getElementsByTagName("sequence");
      right_screen.innerHTML = get_gaspostflow_rght_scrn(get_node_value("gasPostflow"));
      break;
    case REQ_FUNQ_DTL_SEQ_STRIKE_WFS:
      node_data = xml_doc_data.getElementsByTagName("sequence");
      right_screen.innerHTML = get_swfeedspeed_rght_scrn(get_node_value("swFeedSpeed"));
      break;
      break;
    case REQ_FUNQ_DTL_SEQ_RAMP_ENABLE:
      node_data = xml_doc_data.getElementsByTagName("weldSchedules");
      right_screen.innerHTML = get_ramp_enable_rght_scrn(get_node_value("rampEnb"));
      break;
    case REQ_FUNQ_DTL_SEQ_WEAVE_SYNCH:
      node_data = xml_doc_data.getElementsByTagName("weldSchedules");
      right_screen.innerHTML = get_weav_synch_rght_scrn(get_node_value("weaveSynch"));
      break;
    case REQ_FUNQ_DTL_AMON_METHOD:
      right_screen.innerHTML = get_method_rght_scrn();
      set_method_rght_scrn(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_AMON_JDGMNT_CNDTN:
      right_screen.innerHTML = get_judgecondition_rght_scrn();
      set_judgecondition_rght_scrn(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_AMON_WLD_WRN:
      right_screen.innerHTML = get_weldwarn_rght_scrn();
      set_weldwarn_rght_scrn(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_AMON_WLD_STP:
      right_screen.innerHTML = get_weldstop_rght_scrn();
      set_weldstop_rght_scrn(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_AMON_CRTR_WRN:
      right_screen.innerHTML = get_craterwarn_rght_scrn();
      set_craterwarn_rght_scrn(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_AMON_CRTR_STP:
      right_screen.innerHTML = get_craterstop_rght_scrn();
      set_craterstop_rght_scrn(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_EQSETUP_SFI:
      right_screen.innerHTML = get_ps_sfi_rght_scrn();
      set_ps_sfi(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_EQSETUP_SP:
      right_screen.innerHTML = get_ps_sp_rght_scrn();
      set_ps_sp(xml_doc_data);
      break;
    case REQ_FUNQ_DTL_EQSETUP_OTHER:
      right_screen.innerHTML = get_ps_other_rght_scrn();
      set_ps_other(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_TCRT:
      item_touchretract = document.getElementById("touchretract_item");
      item_touchretract.style.backgroundColor = B01;
      right_screen.innerHTML = get_touch_retract_rght_scrn();
      set_tcrt(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_WPSTART:
      right_screen.innerHTML = get_wire_preheat_start_rght_scrn(xml_doc_data);
      set_wpstart(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_WPHEAT:
      right_screen.innerHTML = get_wire_preheat_rght_scrn(xml_doc_data);
      set_wpheat(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_ARCHET:
      right_screen.innerHTML = get_arc_heat_rght_scrn(xml_doc_data);
      set_acheat(xml_doc_data);
      break;
    case REQ_FUNC_DTL_PROC_TCRTST:
      right_screen.innerHTML = get_touch_retract_rght_scrn();
      set_tcrt(xml_doc_data);
    case REQ_FUNC_DTL_PROC_TCRTMD:
      right_screen.innerHTML = get_touch_retract_rght_scrn();
      set_tcrt(xml_doc_data);
    default:
      break;
  }
}

function set_help_status_afterproc() {
  if (help_stts == HELP_STTS_EXIT) {
    window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_help_num=0&s_help_stts=0";
    help_stts = HELP_STTS_NONE;
  } else {
    window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_help_stts=" + HELP_STTS_COMP;
    help_stts = HELP_STTS_COMP;
  }
}

function help_screen_afterproc_sched_track(s_hlp_sch_tr, s_hlp_oth_tr, s_hlp_tm_dsp, s_hlp_tm_typ) {
  if (help_stts >= HELP_STTS_DISP) {
    switch (select_tab_no) {
      case 1:
        treeMenu(s_hlp_sch_tr);
        if (i_multiview_flg == 1) {
          if (s_hlp_tm_dsp == "0") {
            document.getElementById("treemenu" + s_hlp_sch_tr).style.display = "none";
            document.getElementById("offset_item" + s_hlp_sch_tr).style.display = "none";
            document.getElementById("weaving_item" + s_hlp_sch_tr).style.display = "none";
            document.getElementById("tracking_item" + s_hlp_sch_tr).style.display = "none";
            document.getElementById("tree_ricon" + s_hlp_sch_tr).style.display = "block";
            document.getElementById("tree_bicon" + s_hlp_sch_tr).style.display = "none";
          } else {
            switch (parseInt(s_hlp_tm_typ, RADIX_DECIMAL_NUMBER)) {
              case TREE_OFFSET:
                showOffset(s_hlp_sch_tr);
                break;
              case TREE_WEAVE:
                showWeaving(s_hlp_sch_tr);
                break;
              case TREE_TRACK:
                showTracking(s_hlp_sch_tr);
                break;
              default:
                break;
            }
          }
        }
        break;
      case 2:

        trTreeMenu(s_hlp_oth_tr);
        break;
      case 3:
        showSequenceDiagram(s_hlp_oth_tr);
        break;
      case 4:
        showArcmonitorDiagram(s_hlp_oth_tr);
        break;
      case 5:
        show_scaling_diagram(s_hlp_oth_tr);
        break;
      case 6:
        set_help_status_afterproc();
        break;
      default:
        break;
    }
  }
}

function chk_ready_st_chg_xml() {
  if (xml_req.readyState == XHR_READY_STATE_COMPLETE) {
    if ( ( (XHR_STATUS_OK <= xml_req.status) && (xml_req.status < XHR_STATUS_REDIRECT) ) || (xml_req.status == XHR_STATUS_NOT_MODIFIED) ) {
      switch (request_func_num) {
        case REQ_FUNC_GET_DATA:
          if (request_func_detail_num < REQ_FUNC_DTL_PROC_RUNIN) {
            node_data = xml_req.responseXML.getElementsByTagName("awdata")[0].getElementsByTagName("helpValues");
            help_stts = parseInt(get_node_value("s_help_stts"), RADIX_DECIMAL_NUMBER);
            var s_hlp_sch_tr = get_node_value("s_hlp_sch_tr");
            var s_hlp_oth_tr = parseInt(get_node_value("s_hlp_oth_tr"), RADIX_DECIMAL_NUMBER);
            var s_hlp_tm_dsp = get_node_value("s_hlp_tm_dsp");
            var s_hlp_tm_typ = get_node_value("s_hlp_tm_typ");
            set_tab_area(request_func_detail_num, xml_req.responseXML);
            xml_req.abort();
            window.location.href = "/KARELCMD/AWPRDATA?s_func_mode=" + I_FUNC_SETDT + "&s_sel_tab=" + select_tab_no;
            help_screen_afterproc_sched_track(s_hlp_sch_tr, s_hlp_oth_tr, s_hlp_tm_dsp, s_hlp_tm_typ);
          } else {
            set_right_screen(request_func_detail_num, xml_req.responseXML);
            node_data = xml_req.responseXML.getElementsByTagName("awdata")[0].getElementsByTagName("helpValues");
            help_stts = get_node_value("s_help_stts");
            xml_req.abort();

            if (help_stts >= HELP_STTS_DISP) {
              set_help_status_afterproc();
            }
          }
          break;
        default:
          xml_req.abort();
          break;
      }
    } else {
      xml_req.abort();
    }
  }
}

function chk_ready_st_chg_karel() {
  if (prg_req.readyState == XHR_READY_STATE_COMPLETE) {
    if ( ( (XHR_STATUS_OK <= prg_req.status) && (prg_req.status < XHR_STATUS_REDIRECT) ) || (prg_req.status == XHR_STATUS_NOT_MODIFIED) ) {
      prg_req.abort();
      xml_req.onreadystatechange = chk_ready_st_chg_xml;
      xml_req.open("GET", "/TD/AWPRRESP.XML?" + Math.random(), true);
      xml_req.send();
    } else {
      prg_req.abort();
    }
  }
}

function change_tab(tab_num) {
  request_karel(REQ_FUNC_GET_DATA, tab_num);
}

function display_selecting_tab(tab_num) {
  select_tab_no = parseInt(tab_num, 10);
  switch (select_tab_no) {
    case 5:
      if ((ps_type == PS_FRONIUS_TPSI) && (data_mode == SPECIAL_TWO_STEP)) {
        change_tab(10);
      } else {
        change_tab(select_tab_no);
      }
      break;
    case 6:
      if ((ps_type == PS_FRONIUS_TPSI) && (data_mode == SPECIAL_TWO_STEP)) {
        change_tab(6);
      } else {
        change_tab(10);
      }
      break;
    default:
      change_tab(select_tab_no);
      break;
  }
}

function open_weld_dropdown() {
  var list_div_str = "";
  var WELD_SCH_MAX = 32;
  for (var i = 1; i <= WELD_SCH_MAX; i++) {
    list_div_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_weld_count(" + i +")\">" + i + "</div>";
  }
  var weld_sch_drpdwn_list_area = document.getElementById("weld_sch_dropdown_list_area");
  weld_sch_drpdwn_list_area.innerHTML = "";
  weld_sch_drpdwn_list_area.innerHTML = list_div_str;

  document.getElementById("weld_sch_change_msg_area").style.display = "none";
  weld_sch_drpdwn_list_area.style.display = "block";
  open_dropdown('trnslcnt_scrn', 'weld_sch_dropdown');
}

function select_weld_count(weldValue) {
  var sch_chg_msg = document.getElementById("weld_sch_change_msg");
  var i_weld_dropdown_cnt = document.getElementById("weld_dropdown_cnt");
  if (i_weld_dropdown_cnt.value != weldValue) {
    if (i_weld_dropdown_cnt.value < weldValue) {
      sch_chg_msg.innerHTML = get_prct_dict_text(296) + i_weld_dropdown_cnt.value + get_prct_dict_text(297) + weldValue + get_prct_dict_text(298);
    } else {
      sch_chg_msg.innerHTML = get_prct_dict_text(299) + i_weld_dropdown_cnt.value + get_prct_dict_text(300) + weldValue + get_prct_dict_text(301);
    }
    chg_weld_sch_no = weldValue;
    document.getElementById("weld_sch_dropdown_list_area").style.display = "none";
    document.getElementById("weld_sch_change_msg_area").style.display = "block";
  } else {
    close_dropdown('trnslcnt_scrn', 'weld_sch_dropdown', 'weld_dropdown_cnt');
  }
}

function chk_ready_st_chg_crt_weld_sch_xml() {
  if (prg_req.readyState == XHR_READY_STATE_COMPLETE) {
    if ( ( (XHR_STATUS_OK <= prg_req.status) && (prg_req.status < XHR_STATUS_REDIRECT) ) || (prg_req.status == XHR_STATUS_NOT_MODIFIED) ) {
      prg_req.abort();
      change_tab(select_tab_no);
      close_dropdown('trnslcnt_scrn', 'weld_sch_dropdown', 'weld_dropdown_cnt');
    } else {
      prg_req.abort();
    }
  }
}

function create_l_screen_weldsched_xml(weld_schedule_num) {
  prg_req.onreadystatechange = chk_ready_st_chg_crt_weld_sch_xml;
  prg_req.open("GET", "/KARELCMD/AWPRDATA?s_func_mode=17&s_ws_number=" + weld_schedule_num, true);
  prg_req.send();
}

function weld_sch_change_yes() {
  document.getElementById("weld_dropdown_cnt").value = chg_weld_sch_no;
  create_l_screen_weldsched_xml(chg_weld_sch_no);
}

function select_dropdown_tracking_mode(select_num) {
  var i_tracking_mode = document.getElementById("select_tracking_mode");
  switch (select_num) {
    case 1:
      i_tracking_mode.value = get_prct_dict_text(158);
      break;
    case 2:
      i_tracking_mode.value = get_prct_dict_text(159);
      break;
    case 3:
      i_tracking_mode.value = get_prct_dict_text(160);
      break;
    default:
      break;
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_trk_mode[" + tracking_num + "]=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=4&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_tracking_mode');
}

function select_dropdown_torch_type(select_num) {
  var i_torch_type = document.getElementById("select_torch_type");
  switch (select_num) {
    case 0:
      i_torch_type.value = get_prct_dict_text(161);
      break;
    case 1:
      i_torch_type.value = get_prct_dict_text(162);
      break;
    default:
      break;
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_torch_h[" + tracking_num + "]=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=5&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_torch_type');
}

function select_dropdown_runin(select_num) {
  var i_runin = document.getElementById("select_runin");
  var disp_runin = document.getElementById("runin_enable_screen");
  var r_screen_runin = document.getElementById("runin_r_screen");
  if(select_num == 0) {
    i_runin.value = get_prct_dict_text(58);
    disp_runin.style.visibility = "visible";
    r_screen_runin.style.overflow ="";
  } else {
    i_runin.value = get_prct_dict_text(59);
    disp_runin.style.visibility = "hidden";
    r_screen_runin.style.overflow = "hidden";
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_rn_enb=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=8&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_runin');
}

function select_dropdown_ps_sfi(select_num) {
  var i_ps_sfi = document.getElementById("select_ps_sfi");
  if(select_num == 0) {
    i_ps_sfi.value = get_prct_dict_text(59);
  } else {
    i_ps_sfi.value = get_prct_dict_text(58);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_scrn_int=" + select_num + "&s_sel_tab=" + select_tab_no + "&s_set_no=1";
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ps_sfi');
}

function select_dropdown_ps_sp_enable(select_num) {
  var i_ps_sp_enable = document.getElementById("select_ps_sp_enable");
  if(select_num == 0) {
    i_ps_sp_enable.value = get_prct_dict_text(59);
  } else {
    i_ps_sp_enable.value = get_prct_dict_text(58);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_scrn_int=" + select_num + "&s_sel_tab=" + select_tab_no + "&s_set_no=1";
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ps_sp_enable');
}

function select_dropdown_burnback(select_num) {
  var i_burnback = document.getElementById("select_burnback");
  var disp_burnback = document.getElementById("burnback_enable_screen");
  var r_screen_burnback = document.getElementById("burnback_r_screen");
  if(select_num == 0) {
    i_burnback.value = get_prct_dict_text(58);
    disp_burnback.style.visibility = "visible";
    r_screen_burnback.style.overflow = "";
  } else {
    i_burnback.value = get_prct_dict_text(59);
    disp_burnback.style.visibility = "hidden";
    r_screen_burnback.style.overflow = "hidden";
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_bb_enb=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=8&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_burnback');
}

function select_dropdown_resets(select_num) {
  set_wstk_reset(select_num);
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_wr_enb=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=8&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_resets');
}

function select_dropdown_resets_cnt(select_num) {
  document.getElementById("select_resets_cnt").value = select_num;
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_wr_cnt=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=9&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_resets_cnt');
}

function select_dropdown_ramp(select_num) {
  var seq_l_ramp_enb = document.getElementById("lab_ramping");
  var i_schedu_ramp = document.getElementById("select_ramp");
  treeSelectNum = 7;
  if(select_num == 0) {
    seq_l_ramp_enb.innerHTML = get_prct_dict_text(58);
    i_schedu_ramp.value = get_prct_dict_text(58);
    ramping_select = 0;
  } else {
    seq_l_ramp_enb.innerHTML = get_prct_dict_text(59);
    i_schedu_ramp.value = get_prct_dict_text(59);
    ramping_select = 1;
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_ramp_enb=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ramp');
}

function select_dropdown_heatwave(select_num) {
  var i_l_heatwave = document.getElementById("lab_heatwave");
  var i_heatwave = document.getElementById("select_heatwave");
  if(select_num == 0) {
    i_l_heatwave.innerHTML = get_prct_dict_text(58);
    i_heatwave.value = get_prct_dict_text(58);
  } else {
    i_l_heatwave.innerHTML = get_prct_dict_text(59);
    i_heatwave.value = get_prct_dict_text(59);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_scrn_int=" + select_num + "&s_sel_tab=" + select_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_heatwave');
}

function select_dropdown_arcmonitor(select_num) {
  var i_arcmonitor = document.getElementById("select_arcmonitor");
  var disp_amonmethod = document.getElementById("amonmethod_enable_screen");
  var r_screen_method = document.getElementById("method_r_screen");
  var item_judgecondition = document.getElementById("judgecondition_item");
  var item_weldwarn = document.getElementById("weldwarn_item");
  var item_weldstop = document.getElementById("weldstop_item");
  var item_craterwarn = document.getElementById("craterwarn_item");
  var item_craterstop = document.getElementById("craterstop_item");
  var i_cratermonitor = document.getElementById("select_cratermonitor");
  if(select_num == 0) {
    i_arcmonitor.value = get_prct_dict_text(58);
    disp_amonmethod.style.visibility = "visible";
    r_screen_method.style.overflow = "";
    item_judgecondition.style.display = "block";
    item_weldwarn.style.display = "block";
    item_weldstop.style.display = "block";
    if (i_cratermonitor.value == get_prct_dict_text(58)) {
      item_craterwarn.style.display = "block";
      item_craterstop.style.display = "block";
    }
  } else {
    i_arcmonitor.value = get_prct_dict_text(59);
    disp_amonmethod.style.visibility = "hidden";
    r_screen_method.style.overflow = "hidden";
    item_judgecondition.style.display = "none";
    item_weldwarn.style.display = "none";
    item_weldstop.style.display = "none";
    item_craterwarn.style.display = "none";
    item_craterstop.style.display = "none";
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_amon_enb=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=1&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_arcmonitor');
}

function sel_aw_data() {
  var unit_percent = "%";
  var unit_volts = "V";
  var unit_amps = "A";

  if(document.getElementById("select_method").value == document.getElementById("amon_type_dp").innerHTML) {
    document.getElementById("weldwarn_volts_unit").innerHTML = unit_percent;
    document.getElementById("weldwarn_amps_unit").innerHTML = unit_percent;
    document.getElementById("weldstop_volts_unit").innerHTML = unit_percent;
    document.getElementById("weldstop_amps_unit").innerHTML = unit_percent;
    document.getElementById("craterwarn_volts_unit").innerHTML = unit_percent;
    document.getElementById("craterwarn_amps_unit").innerHTML = unit_percent;
    document.getElementById("craterstop_volts_unit").innerHTML = unit_percent;
    document.getElementById("craterstop_amps_unit").innerHTML = unit_percent;
  } else {
    document.getElementById("weldwarn_volts_unit").innerHTML = unit_volts;
    document.getElementById("weldwarn_amps_unit").innerHTML = unit_amps;
    document.getElementById("weldstop_volts_unit").innerHTML = unit_volts;
    document.getElementById("weldstop_amps_unit").innerHTML = unit_amps;
    document.getElementById("craterwarn_volts_unit").innerHTML = unit_volts;
    document.getElementById("craterwarn_amps_unit").innerHTML = unit_amps;
    document.getElementById("craterstop_volts_unit").innerHTML = unit_volts;
    document.getElementById("craterstop_amps_unit").innerHTML = unit_amps;
  }
}

function select_dropdown_method(select_num) {
  var i_amonmethod = document.getElementById("select_method");
  switch (select_num) {
    case 1:
      i_amonmethod.value = document.getElementById("amon_type_dp").innerHTML;
      break;
    case 2:
      i_amonmethod.value = get_prct_dict_text(114);
      break;
    case 3:
      i_amonmethod.value = get_prct_dict_text(115);
      break;
    default:
      break;
  }
  amon_type = select_num;
  sel_aw_data();
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_amon_type=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=2&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_method');
}

function select_dropdown_cratermonitor(select_num) {
  var i_cratermonitor = document.getElementById("select_cratermonitor");
  var item_craterwarn = document.getElementById("craterwarn_item");
  var item_craterstop = document.getElementById("craterstop_item");
  if(select_num == 0) {
    i_cratermonitor.value = get_prct_dict_text(58);
    item_craterwarn.style.display = "block";
    item_craterstop.style.display = "block";
  } else {
    i_cratermonitor.value = get_prct_dict_text(59);
    item_craterwarn.style.display = "none";
    item_craterstop.style.display = "none";
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_ae_amonenb=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=4&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_cratermonitor');
}

function select_dropdown_scaling(select_drop, select_ao, select_num) {
  var i_scaling_setup = document.getElementById("ao_select_scaling");
  if(select_num == 0) {
    i_scaling_setup.value = get_prct_dict_text(58);
  } else {
    i_scaling_setup.value = get_prct_dict_text(59);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_scal_done=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=21&s_open_tab=" + open_tab_no;
  close_dropdown('trnslcnt_scrn', select_drop, select_ao);
}

function select_dropdown_tlevel(select_num) {
  var i_multipass_enb_y = document.getElementById("select_tlevel");
  if(select_num == 0) {
    i_multipass_enb_y.value = get_prct_dict_text(58);
  } else {
    i_multipass_enb_y.value = get_prct_dict_text(59);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_ml_tlevel=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=16";
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_tlevel');
}

function select_dropdown_tver(select_num) {
  var i_multipass_enb_z = document.getElementById("select_tver");
  if(select_num == 0) {
    i_multipass_enb_z.value = get_prct_dict_text(58);
  } else {
    i_multipass_enb_z.value = get_prct_dict_text(59);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_ml_tver=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=17";
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_tver');
}

function select_dropdown_offset_frame(select_num) {
  var i_multipass_offset_frame = document.getElementById("select_offset_frame");
  if(select_num == 1) {
    i_multipass_offset_frame.value = get_prct_dict_text(173);
  } else {
    i_multipass_offset_frame.value = get_prct_dict_text(174);
  }
  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_ml_ofstfr=" + select_num + "&s_select_num=" + treeSelectNum + "&s_sel_tab=" + select_tab_no + "&s_set_no=18";
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_offset_frame');
}

function display_dropdown_popup(popup_num) {
  var title_str = "";
  var button_str = "";

  title_str += "<table><tr>";
  switch (popup_num) {
    case 1:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(163) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ramping_mode')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_ramping_mode(1)\">" + get_prct_dict_text(164) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_ramping_mode(2)\">" + get_prct_dict_text(165) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_ramping_mode(3)\">" + get_prct_dict_text(166) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_ramping_mode(4)\">" + get_prct_dict_text(167) + "</div>";
      break;
    case 2:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(327) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_heatwave_mode')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_heatwave_mode(1)\">" + get_prct_dict_text(169) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_heatwave_mode(2)\">" + get_prct_dict_text(170) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_heatwave_mode(3)\">" + get_prct_dict_text(171) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"change_heatwave_mode(4)\">" + get_prct_dict_text(172) + "</div>";
      break;
    case 3:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(60) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_offset_mode')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_offset_mode(1)\">" + get_prct_dict_text(149) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_offset_mode(2)\">" + get_prct_dict_text(150) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_offset_mode(3)\">" + get_prct_dict_text(151) + "</div>";
      break;
    case 4:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(43) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_weaving')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weaving(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weaving(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 5:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(133) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_weave_pattern')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weave_pattern(1)\">" + get_prct_dict_text(152) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weave_pattern(2)\">" + get_prct_dict_text(153) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weave_pattern(3)\">" + get_prct_dict_text(154) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weave_pattern(4)\">" + get_prct_dict_text(155) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weave_pattern(5)\">" + get_prct_dict_text(156) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_weave_pattern(6)\">" + get_prct_dict_text(157) + "</div>";
      break;
    case 6:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(143) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_tracking_mode')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tracking_mode(1)\">" + get_prct_dict_text(158) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tracking_mode(2)\">" + get_prct_dict_text(159) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tracking_mode(3)\">" + get_prct_dict_text(160) + "</div>";
      break;
    case 7:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(144) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_torch_type')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_torch_type(0)\">" + get_prct_dict_text(161) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_torch_type(1)\">" + get_prct_dict_text(162) + "</div>";
      break;
    case 8:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(67) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_runin')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_runin(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_runin(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 9:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(48) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_burnback')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_burnback(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_burnback(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 10:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(69) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_resets')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_resets(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_resets(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 11:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(70) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_resets_cnt')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_resets_cnt(1)\">1</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_resets_cnt(2)\">2</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_resets_cnt(3)\">3</div>";
      break;
    case 12:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(51) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ramp')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_ramp(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_ramp(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 13:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(52) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_heatwave')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_heatwave(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_heatwave(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 14:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(105) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_arcmonitor')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_arcmonitor(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_arcmonitor(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 15:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(106) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_method')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_method(1)\">" + document.getElementById("amon_type_dp").innerHTML + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_method(2)\">" + get_prct_dict_text(114) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_method(3)\">" + get_prct_dict_text(115) + "</div>";
      break;
    case 16:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(108) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_cratermonitor')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_cratermonitor(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_cratermonitor(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 17:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(117) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'ao_select_scaling')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_scaling('dropdown_popup', 'ao_select_scaling', 0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_scaling('dropdown_popup', 'ao_select_scaling', 1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 23:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(85) + get_prct_dict_text(197) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_tlevel')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tlevel(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tlevel(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 24:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(85) + get_prct_dict_text(198) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_tver')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tver(1)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_tver(0)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 25:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(98) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_offset_frame')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_offset_frame(1)\">" + get_prct_dict_text(173) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_offset_frame(2)\">" + get_prct_dict_text(174) + "</div>";
      break;
    case 26:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(264) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ps_sfi')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_ps_sfi(1)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_ps_sfi(0)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 27:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(268) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_ps_sp_enable')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_ps_sp_enable(1)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_ps_sp_enable(0)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 28:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(332) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_retract_start')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_s(0)\">" + get_prct_dict_text(58) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_s(1)\">" + get_prct_dict_text(59) + "</div>";
      break;
    case 29:
      title_str += "<td class=\"c-dropdown_list_title_name\">" + get_prct_dict_text(348) + get_prct_dict_text(242) + "</td>";
      title_str += "<td><div class=\"c-dropdown_list_close_button\" onclick=\"close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_retract_mode')\"></div></td>";

      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(1)\">" + get_prct_dict_text(333) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(2)\">" + get_prct_dict_text(334) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(3)\">" + get_prct_dict_text(335) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(4)\">" + get_prct_dict_text(336) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(5)\">" + get_prct_dict_text(337) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(6)\">" + get_prct_dict_text(338) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(7)\">" + get_prct_dict_text(339) + "</div>";
      button_str += "<div class=\"c-button c-dropdown_list_button\" onclick=\"select_dropdown_retract_m(8)\">" + get_prct_dict_text(340) + "</div>";
      break;

    default:
      break;
  }
  title_str += "</tr></table>";

  document.getElementById("dropdown_title").innerHTML = title_str;
  document.getElementById("dropdown_list_button_area").innerHTML = button_str;
  open_dropdown('trnslcnt_scrn', 'dropdown_popup');
}

function get_cmd_help_text(weld_signal) {
  var help_text = "";
  switch (parseInt(weld_signal, RADIX_DECIMAL_NUMBER)) {
    case WELD_SIGNAL_VOLTAGE:
      help_text = get_prhl_dict_text(101);
      break;
    case WELD_SIGNAL_WIRE_SPEED:
      help_text = get_prhl_dict_text(103);
      break;
    case WELD_SIGNAL_CURRENT:
      help_text = get_prhl_dict_text(100);
      break;
    case WELD_SIGNAL_VOLTAGE_CONTROL:
      help_text = get_prhl_dict_text(104);
      break;
    case WELD_SIGNAL_WAVE_CONTROL:
      help_text = get_prhl_dict_text(102);
      break;
    case WELD_SIGNAL_EN_RATIO:
      help_text = get_prhl_dict_text(105);
      break;
    case WELD_SIGNAL_JOB_NUMBER:
      help_text = get_prhl_dict_text(106);
      break;
    default:
      break;
  }
  return help_text;
}

function display_help_popup(help_number) {
  var i_help_num = parseInt(help_number, RADIX_DECIMAL_NUMBER);
  var help_title = document.getElementById("help_title");
  var help_chara_left = document.getElementById("help_chara_left");
  var help_chara_right = document.getElementById("help_chara_right");
  var pict_text;

  switch (i_help_num) {
    case HELP_WLD_SCHDL:
      help_title.innerHTML = get_prhl_dict_text(0);
      help_chara_left.innerHTML = get_prhl_dict_text(1);
      pict_text = "<div class=\"c-help_wld_schdl c-help_wld_schdl_proc\" style=\"top:104px; left:58px; text-align:center; width:192px;\">";
      pict_text += get_prhl_dict_text(2) + " 1</div>";
      pict_text += "<div class=\"c-help_wld_schdl c-help_wld_schdl_proc\" style=\"top:128px; left:257px; text-align:left; width:54px;\">";
      pict_text += get_prhl_dict_text(3) + " 2</div>";
      pict_text += "<div class=\"c-help_wld_schdl c-help_wld_schdl_proc\" style=\"top:146px; left:317px; text-align:left; width:54px;\">";
      pict_text += get_prhl_dict_text(3) + " 3</div>";
      pict_text += "<table><tr><td class=\"c-help_wld_schdl c-help_wld_schdl_sch\" style=\"top:194px; left:65px; height:40px; width:52px;\">";
      pict_text += get_prhl_dict_text(4) + "<br>1</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_wld_schdl c-help_wld_schdl_sch\" style=\"top:194px; left:130px; height:40px; width:52px;\">";
      pict_text += get_prhl_dict_text(4) + "<br>2</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_wld_schdl c-help_wld_schdl_sch\" style=\"top:194px; left:195px; height:40px; width:52px;\">";
      pict_text += get_prhl_dict_text(4) + "<br>3</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_wld_schdl c-help_wld_schdl_sch\" style=\"top:214px; left:254px; height:40px; width:52px;\">";
      pict_text += get_prhl_dict_text(4) + "<br>3</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_wld_schdl c-help_wld_schdl_sch\" style=\"top:234px; left:314px; height:40px; width:52px;\">";
      pict_text += get_prhl_dict_text(4) + "<br>3</td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(wedscd_h.png)';
      break;
    case HELP_WLD_CMMND1:
    case HELP_WLD_CMMND2:
    case HELP_WLD_CMMND3:
    case HELP_WLD_CMMND4:
    case HELP_WLD_CMMND5:
    case HELP_WLD_CMMND6:
      set_wld_cmmnd_help_popup(i_help_num);
      break;
    case HELP_TRVL_SPD:
      help_title.innerHTML = get_prhl_dict_text(5);
      help_chara_left.innerHTML = get_prhl_dict_text(6);
      break;
    case HELP_DLY_TM:
      help_title.innerHTML = get_prhl_dict_text(7);
      help_chara_left.innerHTML = get_prhl_dict_text(8);
      break;
    case HELP_RMP_MD:
      help_title.innerHTML = get_prhl_dict_text(9);
      help_chara_left.innerHTML = get_prhl_dict_text(10);
      pict_text = "<div class=\"c-help_img c-help_img_width c-help_img_mrgn_bttm\" style=\"background-image:url('raptim_h.png'); height:270px;\"></div>";
      pict_text += "<div class=\"c-help_img c-help_img_width c-help_img_mrgn_bttm\" style=\"background-image:url('rappos_h.png'); height:271px;\"></div>";
      pict_text += "<div class=\"c-help_img c-help_img_width\" style=\"background-image:url('rapwit_h.png'); height:270px;\"></div>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_vrtcl\" style=\"top:164px; left:8px;\">" + get_prhl_dict_text(11) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_vrtcl\" style=\"top:206px; left:8px;\">" + get_prhl_dict_text(12) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_hrzntl\" style=\"top:234px; left:96px; color:#BB2856;\">" + get_prhl_dict_text(13) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_vrtcl\" style=\"top:442px; left:8px;\">" + get_prhl_dict_text(11) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_vrtcl\" style=\"top:484px; left:8px;\">" + get_prhl_dict_text(14) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_hrzntl\" style=\"top:512px; left:112px; color:#BB2856;\">" + get_prhl_dict_text(15) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_vrtcl c-help_rmp_md_vrtcl_smll\" style=\"top:732px;\">" + get_prhl_dict_text(11) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_vrtcl c-help_rmp_md_vrtcl_smll\" style=\"top:770px;\">" + get_prhl_dict_text(12) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_rmp_md c-help_rmp_md_hrzntl\" style=\"top:796px; left:68px; color:#BB2856;\">" + get_prhl_dict_text(16) + "</td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      break;
    case HELP_HTWV:
      help_title.innerHTML = get_prhl_dict_text(107);
      help_chara_left.innerHTML = get_prhl_dict_text(108);
      break;
    case HELP_OFFSTS:
      help_title.innerHTML = get_prhl_dict_text(109);
      help_chara_left.innerHTML = get_prhl_dict_text(110);
      pict_text = "<div class=\"c-help_img_pos c-help_img_width\" style=\"background-image:url('offset_h.png'); height:400px; top:0;\"></div>";
      pict_text += "<div class=\"c-help_img_pos c-help_offsts\" style=\"top:146px; left:208px;\">" + get_prhl_dict_text(111) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_offsts\" style=\"top:304px; left:235px;\">" + get_prhl_dict_text(112) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_offsts\" style=\"top:329px; left:171px;\">" + get_prhl_dict_text(113) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_offsts\" style=\"top:239px; left:136px; color:#BB2956; font-size:14px; font-weight:bold;\">" + get_prhl_dict_text(114) + "</div>";
      help_chara_right.innerHTML = pict_text;
      break;
    case HELP_X:
      help_title.innerHTML = "X";
      help_chara_left.innerHTML = get_prhl_dict_text(115);
      help_chara_right.style.backgroundImage = 'url(ofs_x_h.png)';
      break;
    case HELP_Y:
      help_title.innerHTML = "Y";
      help_chara_left.innerHTML = get_prhl_dict_text(116);
      help_chara_right.style.backgroundImage = 'url(ofs_y_h.png)';
      break;
    case HELP_Z:
      help_title.innerHTML = "Z";
      help_chara_left.innerHTML = get_prhl_dict_text(117);
      help_chara_right.style.backgroundImage = 'url(ofs_z_h.png)';
      break;
    case HELP_WRK_ANGLE:
      help_title.innerHTML = get_prhl_dict_text(118);
      help_chara_left.innerHTML = get_prhl_dict_text(119);
      help_chara_right.style.backgroundImage = 'url(wokang_h.png)';
      break;
    case HELP_TRVL_ANGLE:
      help_title.innerHTML = get_prhl_dict_text(120);
      help_chara_left.innerHTML = get_prhl_dict_text(121);
      help_chara_right.style.backgroundImage = 'url(trvang_h.png)';
      pict_text = "<table><tr><td class=\"c-help_img_pos c-help_trvl_angle\" style=\"top:318px; left:298px;\">" + get_prhl_dict_text(122) + "</td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      break;
    case HELP_WV:
      help_title.innerHTML = get_prhl_dict_text(123);
      help_chara_left.innerHTML = get_prhl_dict_text(124);
      help_chara_right.style.backgroundImage = 'url(weving_h.gif)';
      break;
    case HELP_WVPTTRN:
      help_title.innerHTML = get_prhl_dict_text(125);
      help_chara_left.innerHTML = get_prhl_dict_text(126);
      pict_text = "<div class=\"c-help_img c-help_img_mrgn_bttm c-help_wvpttrn_img\" style=\"background-image:url('wevpt1_h.png');\"></div>";
      pict_text += "<div class=\"c-help_img c-help_img_mrgn_bttm c-help_wvpttrn_img\" style=\"background-image:url('wevpt2_h.png');\"></div>";
      pict_text += "<div class=\"c-help_img c-help_img_mrgn_bttm c-help_wvpttrn_img\" style=\"background-image:url('wevpt3_h.png');\"></div>";
      pict_text += "<div class=\"c-help_img c-help_img_mrgn_bttm c-help_wvpttrn_img\" style=\"background-image:url('wevpt4_h.png');\"></div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:12px; left:47px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:79px; left:127px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:30px; left:62px;\">" + get_prhl_dict_text(127) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:58px; left:111px;\">" + get_prhl_dict_text(128) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:122px; left:62px;\">" + get_prhl_dict_text(129) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:12px; left:203px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:79px; left:348px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:18px; left:240px; text-align:center;\">" + get_prhl_dict_text(130) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:178px; left:47px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:246px; left:127px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:196px; left:62px;\">" + get_prhl_dict_text(127) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:225px; left:111px;\">" + get_prhl_dict_text(128) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:294px; left:70px;\">" + get_prhl_dict_text(131) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:178px; left:203px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:246px; left:348px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:183px; left:240px; text-align:center;\">" + get_prhl_dict_text(130) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:344px; left:47px;\">Z</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:393px; left:82px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:440px; left:128px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:400px; left:104px;\">" + get_prhl_dict_text(128) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:344px; left:204px;\">Z</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:393px; left:241px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:454px; left:340px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:366px; left:275px;\">" + get_prhl_dict_text(130) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:510px; left:46px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:578px; left:127px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:530px; left:62px;\">" + get_prhl_dict_text(127) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:557px; left:111px;\">" + get_prhl_dict_text(128) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:626px; left:64px;\">" + get_prhl_dict_text(131) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:510px; left:203px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_xyz\" style=\"top:578px; left:347px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_wvpttrn_char\" style=\"top:515px; left:240px; text-align:center;\">" + get_prhl_dict_text(130) + "</div>";
      help_chara_right.innerHTML = pict_text;
      break;
    case HELP_FRQNCY:
      help_title.innerHTML = get_prhl_dict_text(132);
      help_chara_left.innerHTML = get_prhl_dict_text(133);
      break;
    case HELP_AMPLTD:
      help_title.innerHTML = get_prhl_dict_text(134);
      help_chara_left.innerHTML = get_prhl_dict_text(135);
      pict_text = "<div class=\"c-help_img c-help_ampltd_img\">";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:11px; top:90px;\">" + get_prhl_dict_text(136) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:84px; top:154px;\">Z</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:96px; top:178px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:152px; top:176px;\">" + get_prhl_dict_text(137) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:260px; top:216px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:264px; top:235px;\">" + get_prhl_dict_text(139) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:232px; top:256px;\">" + get_prhl_dict_text(138) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_RGHT_DWLL:
      help_title.innerHTML = get_prhl_dict_text(140);
      help_chara_left.innerHTML = get_prhl_dict_text(141);
      pict_text = "<div class=\"c-help_img c-help_rght_dwll_img\">";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_rght_dwll_char\" style=\"left:222px; top:286px;\">" + get_prhl_dict_text(142) + "</td></tr></table>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_LFT_DWLL:
      help_title.innerHTML = get_prhl_dict_text(143);
      help_chara_left.innerHTML = get_prhl_dict_text(144);
      pict_text = "<div class=\"c-help_img c-help_lft_dwll_img\">";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_lft_dwll_char\" style=\"left:0; top:286px;\">" + get_prhl_dict_text(145) + "</td></tr></table>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_L_PTTRN_ANGL:
      help_title.innerHTML = get_prhl_dict_text(146);
      help_chara_left.innerHTML = get_prhl_dict_text(147);
      pict_text = "<div class=\"c-help_l_pttrn_angl_img\"></div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_ELVTN:
      help_title.innerHTML = get_prhl_dict_text(148);
      help_chara_left.innerHTML = get_prhl_dict_text(149);
      pict_text = "<div class=\"c-help_img c-help_elvtn_img\">";
      pict_text += "<table><tr><td class=\"c-help_img_pos\" style=\"left:88px; top:136px;\">" + get_prhl_dict_text(150) + "<br>(=0deg)</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos\" style=\"left:264px; top:136px;\">" + get_prhl_dict_text(150) + "<br>(=<span style=\"color: #c23f64\">15</span>deg)</td></tr></table>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_AZMTH:
      help_title.innerHTML = get_prhl_dict_text(151);
      help_chara_left.innerHTML = get_prhl_dict_text(152);
      pict_text = "<div class=\"c-help_img c-help_azmth_img\">";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:60px; top:65px;\">" + get_prhl_dict_text(153) + " (=0deg)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:60px; top:217px;\">" + get_prhl_dict_text(153) + " (=10deg)</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_CNTR_RS:
      help_title.innerHTML = get_prhl_dict_text(154);
      help_chara_left.innerHTML = get_prhl_dict_text(155);
      pict_text = "<div class=\"c-help_img c-help_cntr_rs_img\">";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:149px; top:135px;\">Z</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:189px; top:175px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:348px; top:247px;\">X</div>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_cntr_rs_char\" style=\"left:0; top:170px;\">" + get_prhl_dict_text(156) + "</td></tr></table>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:243px; top:158px;\">" + get_prhl_dict_text(157) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_RDS:
      help_title.innerHTML = get_prhl_dict_text(158);
      help_chara_left.innerHTML = get_prhl_dict_text(159);
      pict_text = "<div class=\"c-help_img c-help_rds_img\">";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:41px; top:155px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:124px; top:216px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:200px; top:155px;\">Y</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:346px; top:216px;\">X</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:54px; top:174px;\">" + get_prhl_dict_text(160) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:106px; top:199px;\">" + get_prhl_dict_text(161) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:66px; top:267px;\">" + get_prhl_dict_text(162) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:272px; top:158px;\">" + get_prhl_dict_text(163) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_TRCK:
      help_title.innerHTML = get_prhl_dict_text(164);
      help_chara_left.innerHTML = get_prhl_dict_text(165);
      pict_text = "<div class=\"c-help_img c-help_trck_img\">";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:0; top:88px; font-weight:bold;\">" + get_prhl_dict_text(166) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:0; top:114px;\">" + get_prhl_dict_text(167) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:0; top:278px; color:#c23f64; font-weight:bold;\">" + get_prhl_dict_text(168) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:100; top:153px; color:#5c8ea5;\">" + get_prhl_dict_text(169) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:200; top:88px; font-weight:bold;\">" + get_prhl_dict_text(170) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:200; top:114px;\">" + get_prhl_dict_text(167) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos c-help_trck_char\" style=\"left:200; top:278px; color:#c23f64; font-weight:bold;\">" + get_prhl_dict_text(171) + "</td></tr></table>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_THRT:
      help_title.innerHTML = get_prhl_dict_text(172);
      help_chara_left.innerHTML = get_prhl_dict_text(173);
      break;
    case HELP_THR:
      help_title.innerHTML = get_prhl_dict_text(174);
      help_chara_left.innerHTML = get_prhl_dict_text(175);
      pict_text = "<div class=\"c-help_img c-help_thr_img\">";
      pict_text += "<div class=\"c-help_img_pos c-help_thr_char\" style=\"left:0px; top:56px; color:#c23f64; font-weight:bold; width:388px;\">" + get_prhl_dict_text(176) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_thr_char\" style=\"left:0px; top:300px; width:78px;\">" + get_prhl_dict_text(177) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_LTRL_BS:
      help_title.innerHTML = get_prhl_dict_text(178);
      help_chara_left.innerHTML = get_prhl_dict_text(179);
      pict_text = "<div class=\"c-help_img c-help_ltrl_bs_img\"></div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_VRTCL_BS:
      help_title.innerHTML = get_prhl_dict_text(180);
      help_chara_left.innerHTML = get_prhl_dict_text(181);
      break;
    case HELP_RNN_SCHDL:
      help_title.innerHTML = get_prhl_dict_text(17);
      help_chara_left.innerHTML = get_prhl_dict_text(18);
      pict_text = "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:30px; left:18px; height:0px; width:160px;\">";
      pict_text += get_prhl_dict_text(19) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:72px; left:20\px; height:0px; width:80px;\">";
      pict_text += get_prhl_dict_text(20) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:120px; left:20px; height:0px; width:80px;\">";
      pict_text += get_prhl_dict_text(21) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:185px; left:20px; height:0px; width:80px;\">";
      pict_text += "<span style=\"border-bottom:solid 2px #CA5F01;\">";
      pict_text += get_prhl_dict_text(22) + "</span></td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:185px; left:182px; height:0px; width:156px;\">";
      pict_text += get_prhl_dict_text(23) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:175px; left:300px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(24) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:250px; left:20px; height:0px; width:80px;\">";
      pict_text += "<span style=\"border-bottom:solid 2px #CA5F01;\">";
      pict_text += get_prhl_dict_text(25) + "</span></td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:250px; left:182px; height:0px; width:156px;\">";
      pict_text += get_prhl_dict_text(26) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:242px; left:300px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(27) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:298px; left:20px; height:0px; width:80px;\">";
      pict_text += get_prhl_dict_text(28) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:322px; left:178px; height:0px; width:156px;\">";
      pict_text += get_prhl_dict_text(29) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:292px; left:304px; height:0px; width:110px;\">";
      pict_text += get_prhl_dict_text(30) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:350px; left:80px; height:0px; width:300px;\">";
      pict_text += "<font color=\"#CA5F81\">" + get_prhl_dict_text(31) + "</font></td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(runin_h.png)';
      break;
    case HELP_RNN_TM:
      help_title.innerHTML = get_prhl_dict_text(32);
      help_chara_left.innerHTML = get_prhl_dict_text(33);
      pict_text = "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:30px; left:0px; height:0px; width:174px;\">";
      pict_text += get_prhl_dict_text(19) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:72px; left:48\px; height:0px; width:50px;\">";
      pict_text += get_prhl_dict_text(20) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:120px; left:0px; height:0px; width:98px;\">";
      pict_text += get_prhl_dict_text(21) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:185px; left:20px; height:0px; width:80px;\">";
      pict_text += "<span style=\"border-bottom:solid 2px #CA5F01;\">";
      pict_text += get_prhl_dict_text(22) + "</span></td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:182px; left:188px; height:0px; width:156px;\">";
      pict_text += get_prhl_dict_text(23) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:175px; left:300px; height:0px; width:104px;\">";
      pict_text += get_prhl_dict_text(24) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:250px; left:20px; height:0px; width:80px;\">";
      pict_text += "<span style=\"border-bottom:solid 2px #CA5F01;\">";
      pict_text += get_prhl_dict_text(25) + "</span></td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:250px; left:188px; height:0px; width:156px;\">";
      pict_text += get_prhl_dict_text(26) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:242px; left:300px; height:0px; width:104px;\">";
      pict_text += get_prhl_dict_text(27) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:305px; left:0px; height:0px; width:98\px;\">";
      pict_text += get_prhl_dict_text(28) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:332px; left:178px; height:0px; width:156px;\">";
      pict_text += get_prhl_dict_text(29) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_runin_schdl c-help_runin_schdl_proc\" style=\"top:302px; left:304px; height:0px; width:100px;\">";
      pict_text += "<font color=\"#BB2856\">" + get_prhl_dict_text(30) + "</font></td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(weldsu_h.png)';
      break;
    case HELP_BB_SCHDL:
      help_title.innerHTML = get_prhl_dict_text(34);
      help_chara_left.innerHTML = get_prhl_dict_text(35);
      pict_text = "<table><tr><td align=\"center\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:90px; left:58px; height:0px; width:140px;\">";
      pict_text += get_prhl_dict_text(36) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:302px; left:58px; height:0px; width:140px;\">";
      pict_text += get_prhl_dict_text(37) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:90px; left:224px; height:0px; width:140px;\">";
      pict_text += get_prhl_dict_text(38) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:302px; left:224px; height:0px; width:140px;\">";
      pict_text += get_prhl_dict_text(39) + "</td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(weldbb_h.png)';
      break;
    case HELP_BB_TM:
      help_title.innerHTML = get_prhl_dict_text(40);
      help_chara_left.innerHTML = get_prhl_dict_text(41);
      pict_text = "<table><tr><td align=\"right\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:102px; left:0px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(42) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" valign=\"middle\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:164px; left:0px; height:36px; width:100px;\">";
      pict_text += get_prhl_dict_text(43) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" valign=\"middle\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:216px; left:0px; height:36px; width:100px;\">";
      pict_text += get_prhl_dict_text(44) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:70px; left:130px; height:0px; width:200px;\">";
      pict_text += get_prhl_dict_text(45) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"left\" valign=\"middle\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:136px; left:236px; height:36px; width:140px;\">";
      pict_text += "<font color=\"#BB2856\">" + get_prhl_dict_text(46) + "</font></td></tr></table>";
      pict_text += "<table><tr><td align=\"left\" valign=\"middle\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:178px; left:290px; height:36px; width:140px;\">";
      pict_text += get_prhl_dict_text(47) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" class=\"c-help_bb_schdl c-help_bb_schdl_proc\" style=\"top:280px; left:185px; height:0px; width:140px;\">";
      pict_text += get_prhl_dict_text(48) + "</td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(wdbbtm_h.png)';
      break;
    case HELP_WR_SCHDL:
      help_title.innerHTML = get_prhl_dict_text(49);
      help_chara_left.innerHTML = get_prhl_dict_text(50);
      help_chara_right.style.backgroundImage = 'url(wirrst_h.png)';
      break;
    case HELP_WR_TIMES:
      help_title.innerHTML = get_prhl_dict_text(51);
      help_chara_left.innerHTML = get_prhl_dict_text(52);
      break;
    case HELP_WR_TM:
      help_title.innerHTML = get_prhl_dict_text(53);
      help_chara_left.innerHTML = get_prhl_dict_text(54);
      break;
    case HELP_OTF_SCHDL:
      help_title.innerHTML = get_prhl_dict_text(55);
      help_chara_left.innerHTML = get_prhl_dict_text(56);
      break;
    case HELP_OTF_SPD:
      help_title.innerHTML = get_prhl_dict_text(57);
      help_chara_left.innerHTML = get_prhl_dict_text(58);
      break;
    case HELP_ARC_MNTR:
      help_title.innerHTML = get_prhl_dict_text(182);
      help_chara_left.innerHTML = get_prhl_dict_text(183);
      pict_text = "<div class=\"c-help_img c-help_arc_mntr_img\"></div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_MNTRNG_MTHD:
      help_title.innerHTML = get_prhl_dict_text(184);
      help_chara_left.innerHTML = get_prhl_dict_text(185);
      pict_text = "<div class=\"c-help_img c-help_mntrng_mthd_img\">";
      pict_text += "<table><tr><td class=\"c-help_img_pos\" style=\"left:0; top:110px; color:#e60012; font-weight:bold; text-align:center; width:328px;\">";
      pict_text += get_prhl_dict_text(186) + "</td></tr></table>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:248px; top:161px; color:#ae3029; font-size:14px;\">" + get_prhl_dict_text(187) + " (+)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:258px; top:188px; color:#ba675a; font-size:14px;\">" + get_prhl_dict_text(188) + " (+)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:289px; top:208px; color:#3e4877; font-size:14px;\">" + get_prhl_dict_text(189) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:258px; top:227px; color:#ba675a; font-size:14px;\">" + get_prhl_dict_text(188) + " (-)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:248px; top:250px; color:#ae3029; font-size:14px;\">" + get_prhl_dict_text(187) + " (-)</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_MNTRNG_DLY_TM:
      help_title.innerHTML = get_prhl_dict_text(190);
      help_chara_left.innerHTML = get_prhl_dict_text(191);
      pict_text = "<div class=\"c-help_img c-help_mntrng_dly_tm_img\">";
      pict_text += "<div class=\"c-help_img_pos c-help_mntrng_dly_tm_char\" style=\"left:11; top:94px; color:#bb2856; font-weight:bold;\">" + get_prhl_dict_text(192) + "</div>";
      pict_text += "<div class=\"c-help_img_pos c-help_mntrng_dly_tm_char\" style=\"left:0; top:318px;\">" + get_prhl_dict_text(193) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_CRTRFLL_MNTR:
      help_title.innerHTML = get_prhl_dict_text(194);
      help_chara_left.innerHTML = get_prhl_dict_text(195);
      break;
    case HELP_WRN_STP_TM:
      help_title.innerHTML = get_prhl_dict_text(196);
      help_chara_left.innerHTML = get_prhl_dict_text(197);
      pict_text = "<div class=\"c-help_img c-help_wrn_stp_tm_img\"></div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_WRN_STP_CNT:
      help_title.innerHTML = get_prhl_dict_text(198);
      help_chara_left.innerHTML = get_prhl_dict_text(199);
      pict_text = "<div class=\"c-help_img c-help_wrn_stp_cnt_img\"></div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_WLDNG_WRN:
      help_title.innerHTML = get_prhl_dict_text(200);
      help_chara_left.innerHTML = get_prhl_dict_text(201);
      break;
    case HELP_WLDNG_STP:
      help_title.innerHTML = get_prhl_dict_text(202);
      help_chara_left.innerHTML = get_prhl_dict_text(203);
      pict_text = "<div class=\"c-help_img c-help_wldng_stp_img\">";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:0; top:110px; color:#e60012; font-weight:bold; text-align:center; width:328px;\">" + get_prhl_dict_text(204) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:248px; top:161px; color:#ae3029; font-size:14px;\">" + get_prhl_dict_text(205) + " (+)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:258px; top:188px; color:#ba675a; font-size:14px;\">" + get_prhl_dict_text(206) + " (+)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:289px; top:208px; color:#3e4877; font-size:14px;\">" + get_prhl_dict_text(207) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:258px; top:227px; color:#ba675a; font-size:14px;\">" + get_prhl_dict_text(206) + " (-)</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:248px; top:250px; color:#ae3029; font-size:14px;\">" + get_prhl_dict_text(205) + " (-)</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_CRTR_WRN:
      help_title.innerHTML = get_prhl_dict_text(208);
      help_chara_left.innerHTML = get_prhl_dict_text(209);
      break;
    case HELP_CRTR_STP:
      help_title.innerHTML = get_prhl_dict_text(210);
      help_chara_left.innerHTML = get_prhl_dict_text(211);
      break;
    case HELP_SCLNG:
      help_title.innerHTML = get_prhl_dict_text(212);
      help_chara_left.innerHTML = get_prhl_dict_text(213);
      pict_text = "<div class=\"c-help_img c-help_sclng_img\">";
      pict_text += "<table><tr><td class=\"c-help_img_pos\" style=\"left:0px; top:0px; height:40px; font-size:13px; text-align:center; vertical-align:middle; width:152px;\">";
      pict_text += get_prhl_dict_text(217) + "</td></tr></table>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:180px; top:16px; color:#bb2856; font-size:14px;\">" + get_prhl_dict_text(214) + "</div>";
      pict_text += "<table><tr><td class=\"c-help_img_pos\" style=\"left:104; top:46px; color:#bb2856; font-weight:bold; height:38px; text-align:center; vertical-align:middle; width:200px;\">";
      pict_text += get_prhl_dict_text(215) + "</td></tr></table>";
      pict_text += "<table><tr><td class=\"c-help_img_pos\" style=\"left:130px; top:350px; height:38px; font-size:13px; text-align:center; vertical-align:middle; width:192px;\">";
      pict_text += get_prhl_dict_text(216) + "</td></tr></table>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_SCLNG_STUP:
      help_title.innerHTML = get_prhl_dict_text(218);
      help_chara_left.innerHTML = get_prhl_dict_text(219);
      break;
    case HELP_CMMND:
      help_title.innerHTML = get_prhl_dict_text(220);
      help_chara_left.innerHTML = get_prhl_dict_text(221);
      break;
    case HELP_MSRD:
      help_title.innerHTML = get_prhl_dict_text(222);
      help_chara_left.innerHTML = get_prhl_dict_text(223);
      break;
    case HELP_HW_ONOFF:
      help_title.innerHTML = get_prhl_dict_text(59);
      help_chara_left.innerHTML = get_prhl_dict_text(60);
      break;
    case HELP_GAS_PGTM:
      help_title.innerHTML = get_prhl_dict_text(61);
      help_chara_left.innerHTML = get_prhl_dict_text(62);
      pict_text = "<table><tr><td align=\"center\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:32px; left:160px; height:0px; width:130px;\">";
      pict_text += "<b><font color=\"#CF4069\">" + get_prhl_dict_text(63) + "</font></b></td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:80px; left:60px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(64) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:168px; left:52px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(65) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:250px; left:52px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(66) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:76px; left:120px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(67) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:120px; left:200px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(68) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:342px; left:112px; height:0px; width:100px;\">";
      pict_text += "<b>" + get_prhl_dict_text(69) + "</b></td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:304px; left:196px; height:0px; width:100px;\">";
      pict_text += "<b>" + get_prhl_dict_text(70) + "</b></td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(gusprg_h.png)';
      break;
    case HELP_GAS_PFTM:
      help_title.innerHTML = get_prhl_dict_text(71);
      help_chara_left.innerHTML = get_prhl_dict_text(72);
      pict_text = "<table><tr><td align=\"center\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:32px; left:188px; height:0px; width:160px;\">";
      pict_text += "<b><font color=\"#CF4069\">" + get_prhl_dict_text(73) + "</font></b></td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:80px; left:60px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(74) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:168px; left:52px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(75) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:250px; left:52px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(76) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:76px; left:120px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(77) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"left\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:124px; left:284px; height:0px; width:96px;\">";
      pict_text += get_prhl_dict_text(78) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:342px; left:156px; height:0px; width:100px;\">";
      pict_text += "<b>" + get_prhl_dict_text(79) + "</b></td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:304px; left:230px; height:0px; width:100px;\">";
      pict_text += "<b>" + get_prhl_dict_text(80) + "</b></td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(guspre_h.png)';
      break;
    case HELP_GAS_PTFTM:
      help_title.innerHTML = get_prhl_dict_text(81);
      help_chara_left.innerHTML = get_prhl_dict_text(82);
      break;
    case HELP_AS_PTM:
      help_title.innerHTML = get_prhl_dict_text(83);
      help_chara_left.innerHTML = get_prhl_dict_text(84);
      break;
    case HELP_AE_PTM:
      help_title.innerHTML = get_prhl_dict_text(85);
      help_chara_left.innerHTML = get_prhl_dict_text(86);
      break;
    case HELP_WF_SPD:
      help_title.innerHTML = get_prhl_dict_text(87);
      help_chara_left.innerHTML = get_prhl_dict_text(88);
      pict_text = "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:110px; left:20px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(89) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:216px; left:0px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(90) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"right\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:270px; left:0px; height:0px; width:100px;\">";
      pict_text += get_prhl_dict_text(91) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" valign=\"middle\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:168px; left:130px; height:36px; width:100px;\">";
      pict_text += "<b><font color=\"#CF4069\">" + get_prhl_dict_text(92) + "</font></b></td></tr></table>";
      pict_text += "<table><tr><td align=\"center\" valign=\"middle\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:216px; left:220px; width:156px;\">";
      pict_text += get_prhl_dict_text(93) + "</td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(stwifs_h.png)';
      break;
    case HELP_RMP_ONOFF:
      help_title.innerHTML = get_prhl_dict_text(94);
      help_chara_left.innerHTML = get_prhl_dict_text(95);
      pict_text = "<table><tr><td align=\"left\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:130px; left:26px; height:0px; width:80px;\">";
      pict_text += get_prhl_dict_text(96) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"left\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:250px; left:350px; height:0px; width:60px;\">";
      pict_text += get_prhl_dict_text(97) + "</td></tr></table>";
      pict_text += "<table><tr><td align=\"left\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:110px; left:210px; height:0px; width:100px;\">";
      pict_text += "<b>" + get_prhl_dict_text(98) + "</b></td></tr></table>";
      pict_text += "<table><tr><td align=\"left\" class=\"c-help_seq_setting c-help_seq_setting_proc\" style=\"top:90px; left:210px; height:0px; width:100px;\">";
      pict_text += "<b>" + get_prhl_dict_text(99) + "</b></td></tr></table>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.backgroundImage = 'url(rampch_h.png)';
      break;
    case HELP_RPM_BFFR:
      help_title.innerHTML = get_prhl_dict_text(224);
      help_chara_left.innerHTML = get_prhl_dict_text(225);
      pict_text = "<div class=\"c-help_img c-help_rpm_bffr_img\">";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:0px; top:316px; text-align:right; width:128px;\">" + get_prhl_dict_text(226) + "</div>";
      pict_text += "<div class=\"c-help_img_pos\" style=\"left:148px; top:316px; text-align:center;\">" + get_prhl_dict_text(227) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_ADJST_DLY_TM:
      help_title.innerHTML = get_prhl_dict_text(228);
      help_chara_left.innerHTML = get_prhl_dict_text(229);
      pict_text = "<div class=\"c-help_img c-help_adjst_dly_tm_img\">";
      pict_text += "<div class=\"c-help_img_pos c-help_adjst_dly_tm_char\" style=\"left:120px; top:122px;\">" + get_prhl_dict_text(230) + "</div>";
      pict_text += "</div>";
      help_chara_right.innerHTML = pict_text;
      help_chara_right.style.textAlign = "center";
      break;
    case HELP_GAIN:
      help_title.innerHTML = get_prhl_dict_text(231);
      help_chara_left.innerHTML = get_prhl_dict_text(232);
      break;
    case HELP_DD_BND:
      help_title.innerHTML = get_prhl_dict_text(233);
      help_chara_left.innerHTML = get_prhl_dict_text(234);
      break;
    case HELP_MXMM_OFFST:
      help_title.innerHTML = get_prhl_dict_text(235);
      help_chara_left.innerHTML = get_prhl_dict_text(236);
      break;
    case HELP_MXMM_PR_CYCL:
      help_title.innerHTML = get_prhl_dict_text(237);
      help_chara_left.innerHTML = get_prhl_dict_text(238);
      break;
    case HELP_TRCKNG_STRT_CYCL:
      help_title.innerHTML = get_prhl_dict_text(239);
      help_chara_left.innerHTML = get_prhl_dict_text(240);
      break;
    case HELP_SMPL_STRT_CYCL:
      help_title.innerHTML = get_prhl_dict_text(241);
      help_chara_left.innerHTML = get_prhl_dict_text(242);
      break;
    case HELP_NMBR_OF_SMPL_CYCLS:
      help_title.innerHTML = get_prhl_dict_text(243);
      help_chara_left.innerHTML = get_prhl_dict_text(244);
      break;
    case HELP_SMPLNG_TM:
      help_title.innerHTML = get_prhl_dict_text(245);
      help_chara_left.innerHTML = get_prhl_dict_text(246);
      break;
    case HELP_OFFST_FRM:
      help_title.innerHTML = get_prhl_dict_text(247);
      help_chara_left.innerHTML = get_prhl_dict_text(248);
      break;
    case HELP_TOUCH_RTCT:
      help_title.innerHTML = get_prhl_dict_text(250);
      help_chara_left.innerHTML = get_prhl_dict_text(251);
      get_dictstatus();
      break;
    case HELP_TOUCH_RTCT_MODE:
      help_title.innerHTML = get_prhl_dict_text(259);
      help_chara_left.innerHTML = get_prhl_dict_text(260);
      break;
    case HELP_WPSTART:
      help_title.innerHTML = get_prhl_dict_text(261);
      help_chara_left.innerHTML = get_prhl_dict_text(262);
      break;
    case HELP_WPSTART_AMPS:
      help_title.innerHTML = get_prhl_dict_text(22);
      help_chara_left.innerHTML = get_prhl_dict_text(263);
      break;
    case HELP_WIREHEAT:
      help_title.innerHTML = get_prhl_dict_text(264);
      help_chara_left.innerHTML = get_prhl_dict_text(265);
      break;
    case HELP_WIREHEAT_AMPS:
      help_title.innerHTML = get_prhl_dict_text(22);
      help_chara_left.innerHTML = get_prhl_dict_text(266);
      break;
    case HELP_WIREHEAT_TIME:
      help_title.innerHTML = get_prhl_dict_text(97);
      help_chara_left.innerHTML = get_prhl_dict_text(267);
      break;
    case HELP_WIREHEAT_WFS:
      help_title.innerHTML = get_prhl_dict_text(87);
      help_chara_left.innerHTML = get_prhl_dict_text(268);
      break;
    case HELP_ACHEAT:
      help_title.innerHTML = get_prhl_dict_text(269);
      help_chara_left.innerHTML = get_prhl_dict_text(270);
      break;
    case HELP_ACHEAT_AMPS:
      help_title.innerHTML = get_prhl_dict_text(22);
      help_chara_left.innerHTML = get_prhl_dict_text(271);
      break;
    case HELP_ACHEAT_TIME:
      help_title.innerHTML = get_prhl_dict_text(97);
      help_chara_left.innerHTML = get_prhl_dict_text(272);
      break;
    case HELP_ACHEAT_WFS:
      help_title.innerHTML = get_prhl_dict_text(87);
      help_chara_left.innerHTML = get_prhl_dict_text(273);
      break;
    default:
      return;
      break;
  }
  open_dropdown('transparent_screen', 'help_popup');
  pict_text = null;
}

function touch_open(){
  var tree_status;
  var tree_off;
  var tree_on;
  var icon_on;
  var icon_off;
  if(help_stts != HELP_STTS_NONE) {
    if(touch_op_status == 1){
    }else{
      return;
    }
  }
  tree_off = document.getElementById("touchretract_treeoff");
  tree_on = document.getElementById("touchretract_treeon");
  icon_on = document.getElementById("img_on");
  icon_off = document.getElementById("img_off");

  tree_off.style.display = "none";
  tree_on.style.display = "block";
  icon_on.scr = "frh:\cgtp\tree_on.png";
  icon_off.scr = "frh:\cgtp\tree_on.png";
  touch_op_status = 1;
  tree_status = document.getElementById("wpstart_item");
  tree_status.style.display = "block";
  tree_status.style.backgroundColor = Gr02;
  tree_status = document.getElementById("wpstree_space");
  tree_status.style.display = "block";
  tree_status = document.getElementById("wirepreheat_item");
  tree_status.style.display = "block";
  tree_status.style.backgroundColor = Gr02;
  tree_status = document.getElementById("wptree_space");
  tree_status.style.display = "block";
  tree_status = document.getElementById("archeat_item");
  tree_status.style.display = "block";
  tree_status.style.backgroundColor = Gr02;
  tree_status = document.getElementById("ahtree_space");
  tree_status.style.display = "block";
}

function touch_close(){
  var tree_status;
  var tree_off;
  var tree_on;
  var icon_on;
  var icon_off;

  if(help_stts != HELP_STTS_NONE) {
    return;
  }
  tree_on = document.getElementById("touchretract_treeon");
  tree_off = document.getElementById("touchretract_treeoff");
  icon_on = document.getElementById("img_on");
  icon_off = document.getElementById("img_off");
  tree_on.style.display = "none";
  tree_off.style.display = "block";
  icon_on.scr = "frh:\cgtp\tree_on.png";
  icon_off.scr = "frh:\cgtp\tree_off.png";
  touch_op_status = 0;

  tree_status = document.getElementById("wpstart_item");
  tree_status.style.display = "none";
  tree_status = document.getElementById("wpstree_space");
  tree_status.style.display = "none";
  tree_status = document.getElementById("wirepreheat_item");
  tree_status.style.display = "none";
  tree_status = document.getElementById("wptree_space");
  tree_status.style.display = "none";
  tree_status = document.getElementById("archeat_item");
  tree_status.style.display = "none";
  tree_status = document.getElementById("ahtree_space");
  tree_status.style.display = "none";
}

function set_tcrt(xml_doc_data){
  var select_start;
  var select_mode;
  var tr_mode;
  var xml_data;
  var selcet_list;
  var err_message;

  select_start = document.getElementById("select_retract_start");
  tr_mode = document.getElementById("retract_mode_tr");
  select_mode = document.getElementById("select_retract_mode");
  xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;

  if(xml_data == 1){
    select_start.value = get_prct_dict_text(58);
    tr_mode.style.display = "block";

    xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
    selcet_list = parseInt(xml_data, RADIX_DECIMAL_NUMBER);
    select_back = selcet_list;
    switch (selcet_list) {
      case 1:
        select_mode.value = get_prct_dict_text(333);
        break;
      case 2:
        select_mode.value = get_prct_dict_text(334);
        break;
      case 3:
        select_mode.value = get_prct_dict_text(335);
        break;
      case 4:
        select_mode.value = get_prct_dict_text(336);
        break;
      case 5:
        select_mode.value = get_prct_dict_text(337);
        break;
      case 6:
        select_mode.value = get_prct_dict_text(338);
        break;
      case 7:
        select_mode.value = get_prct_dict_text(339);
        break;
      case 8:
        select_mode.value = get_prct_dict_text(340);
        break;
    }
  }else{
    select_start.value = get_prct_dict_text(59);
    tr_mode.style.display = "none";
  }
}

function set_wpstart(xml_doc_data){
  var wpst_amps;
  var xml_data;

  xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;

  if(xml_data == 0){
    return;
  }

  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
  if(xml_data == 8){
    return;
  }

  wpst_amps = document.getElementById("txt_wrs_amps");
  xml_data = xml_doc_data.getElementsByTagName("wphs")[0].getElementsByTagName("amps")[0].firstChild.nodeValue;
  wpst_amps.value = xml_data;
  set_cmd_digit(xml_doc_data);
  set_text_value("txt_wrs_amps", 5, 200, 'slg_wrs_amps', voltage_cmd_format);

}

function set_wpheat(xml_doc_data){
  var wpht_amps;
  var wpht_time;
  var wpht_wfs;
  var wpht_wfs_unit;
  var xml_data;

  xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;

  if(xml_data == 0){
    return;
  }

  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
  if(xml_data == 8){
    return;
  }

  wpst_amps = document.getElementById("txt_wp_amps");
  wpht_time = document.getElementById("txt_wp_time");
  wpht_wfs = document.getElementById("txt_wp_wfs");
  wpht_wfs_unit = document.getElementById("txt_wp_wfs_unit");

  xml_data = xml_doc_data.getElementsByTagName("wrph")[0].getElementsByTagName("amps")[0].firstChild.nodeValue;
  wpst_amps.value = xml_data;

  xml_data = xml_doc_data.getElementsByTagName("wrph")[0].getElementsByTagName("time")[0].firstChild.nodeValue;
  wpht_time.value = xml_data;

  xml_data = xml_doc_data.getElementsByTagName("wrph")[0].getElementsByTagName("wfs")[0].firstChild.nodeValue;
  wpht_wfs.value = xml_data;

  wpht_wfs_unit.innerText = get_prct_dict_list(xml_doc_data, "wrph");

  set_cmd_digit(xml_doc_data);
  set_text_value("txt_wp_amps", 5, 200, 'slg_wp_amps', voltage_cmd_format);
  set_text_value("txt_wp_time", 0.000, 2.000, 'slg_wp_time', 3);
  set_text_value("txt_wp_wfs", -500.0, -5.0, 'slg_wp_wfs', 1);

}

function set_acheat(xml_doc_data){
  var wpht_amps;
  var wpht_time;
  var wpht_wfs;
  var wpht_wfs_unit;
  var xml_data;

  xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;

  if(xml_data == 0){
    return;
  }

  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
  if(xml_data == 8){
    return;
  }

  wpst_amps = document.getElementById("txt_arch_amps");
  wpht_time = document.getElementById("txt_arch_time");
  wpht_wfs = document.getElementById("txt_arch_wfs");
  wpht_wfs_unit = document.getElementById("txt_arch_wfs_unit");

  xml_data = xml_doc_data.getElementsByTagName("acht")[0].getElementsByTagName("amps")[0].firstChild.nodeValue;
  wpst_amps.value = xml_data;

  xml_data = xml_doc_data.getElementsByTagName("acht")[0].getElementsByTagName("time")[0].firstChild.nodeValue;
  wpht_time.value = xml_data;

  xml_data = xml_doc_data.getElementsByTagName("acht")[0].getElementsByTagName("wfs")[0].firstChild.nodeValue;
  wpht_wfs.value = xml_data;

  wpht_wfs_unit.innerText = get_prct_dict_list(xml_doc_data, "acht");

  set_cmd_digit(xml_doc_data);
  set_text_value("txt_arch_amps", 5, 425, 'slg_arch_amps', voltage_cmd_format);
  set_text_value("txt_arch_time", 0.002, 0.250, 'slg_arch_time', 3);
  set_text_value("txt_arch_wfs", 5.0, 3500.0, 'slg_arch_wfs', 1);

}

function close_icon_screen(){
  var tuch_screen;
  var icon_off;
  var tree_status;

  tuch_screen = document.getElementById("process_l_screen");
  tuch_screen.style.display = "none";
  tree_status = document.getElementById("ahtree_space");
  tree_status.style.display = "block";

}

function create_touch_help_rgt_screen(){
  var help_chara_right = document.getElementById("help_chara_right");
  var pict_text;

  if(dict_status == 'kn'){
    pict_text = "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:130px; left:48px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(252) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:130px; left:220px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(253) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:255px; left:-2px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(254) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:255px; left:120px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(255) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:255px; left:235px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(256) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:397px; left:50px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(257) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:397px; left:215px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(258) + "</td></tr></table>";
  }else{
    pict_text = "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:165px; left:50px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(252) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:165px; left:210px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(253) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:290px; left:-3px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(254) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:290px; left:110px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(255) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:290px; left:238px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(256) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:432px; left:50px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(257) + "</td></tr></table>";
    pict_text += "<table><tr><td align=\"center\" class=\"c-help_touch_schdl c-help_touch_schdl_proc\" style=\"top:432px; left:215px; height:0px; width:160px;\">";
    pict_text += get_prhl_dict_text(258) + "</td></tr></table>";
  }

  help_chara_right.innerHTML = pict_text;
  help_chara_right.style.backgroundImage = 'url(touchretract_h.png)';

}

function get_dictstatus(){
  var sys_value = '$DICT_CONFIG.$LANG_SUFFIX';
  var xmlHttp = new XMLHttpRequest();
  xmlHttp.onreadystatechange = function(){
    if (this.readyState == 4){
      if (((200 <= this.status) && (this.status < 300)) || (this.status == 304)) {
        var json = JSON.parse(xmlHttp.responseText);
        dict_status = json.FANUC.RPC[0].value;
        create_touch_help_rgt_screen();
      } else {
        xmlHttp.abort();
      }
    }
  };
  xmlHttp.open("GET", '/COMET/rpc?func=VMIP_READVA&prog_name=*SYSTEM*&var_name=' + sys_value );
  xmlHttp.setRequestHeader("If-Modified-Since", "Thu, 01 Jun 1970 00:00:00 GMT");
  xmlHttp.send(null);
}

function isiPendant() {
  var userAgent = top.navigator.userAgent;
  if (typeof userAgent === "string") {
    return (userAgent.indexOf("IEMobile") >= 0);
  }
  else {
    return false;
  }
}

function format(fmt) {
  var i = 0;
  var args = arguments;
  return fmt.replace(/%s/g, function(word) { i++; return args[i]; });
}

function appendActiveXControl(elem, classID, id, width, height) {
  elem.innerHTML = format('<object classid="clsid:%s" id="%s" height="%spx" width="%spx"></object>', classID, id, width, height);
}

function get_touch_retract_rght_scrn() {
  var rght_tbl = "<table id=\"retract_r_screen\" align=\"left\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(332) + "</td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_retract_start\" type=\"text\" class=\"c-textbox\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(28)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr id=\"retract_mode_tr\">";
  rght_tbl += "<td class=\"item_base item_name_mode\">" + get_prct_dict_text(348) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(261)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"select_retract_mode\" type=\"text\" class=\"c-textbox_mode\" readonly=\"readonly\" onfocus=\"set_elem_drpdwn(this)\" onclick=\"display_dropdown_popup(29)\">";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}


function get_wire_preheat_start_rght_scrn(xml_doc_data) {

  var rght_tbl;
  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;
  var err_message = document.getElementById("message_box");
  if(xml_data == 0){
    rght_tbl = "";
    err_message.innerHTML = get_prct_dict_text(349);
    return rght_tbl;
  }

  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
  if(xml_data == 8){
    rght_tbl = "";
    err_message.innerHTML = get_prct_dict_text(351);
    return rght_tbl;
  }

  rght_tbl = "<table id=\"wps_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(53) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(263)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wrs_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wrs_amps_st, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">A</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_wrs_amps_st(1)\"><img id=\"wrs_amps_st_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wrs_amps_min\" style=\"float:left\">5</label>";
  rght_tbl += "<label id=\"lab_wrs_amps_max\" style=\"float:right\">200</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_wrs_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_wrs_amps_st(1)\"><img id=\"wrs_amps_st_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_wrs_amps_st(wrs_amps_ed_item_num) {
  validate_check_slg("txt_wrs_amps", 5, 200, 'slg_wrs_amps', voltage_cmd_format);
  set_aw_data('s_ps_volts', 'txt_wrs_amps', 8, 0);
}

function tch_dwn_wrs_amps_st(wrs_amps_st_item_num) {
  check_button_status();
  set_dwn_button("wrs_amps_st_down" + wrs_amps_st_item_num);

  switch (wrs_amps_st_item_num) {
    case 1:
      tch_dwn_btn("txt_wrs_amps", 5, 5, 200, 'slg_wrs_amps', 1);
      set_aw_data('s_ps_volts', 'txt_wrs_amps', 8, 0);
      break;
    default:
      break;
  }
}

function tch_up_wrs_amps_st(wrs_amps_st_item_num) {
  check_button_status();
  set_up_button("wrs_amps_st_up" + wrs_amps_st_item_num);

  switch (wrs_amps_st_item_num) {
    case 1:
      tch_up_btn("txt_wrs_amps", 5, 5, 200, 'slg_wrs_amps', 1);
      set_aw_data('s_ps_volts', 'txt_wrs_amps', 8, 0);
      break;
    default:
      break;
  }
}


function get_wire_preheat_rght_scrn(xml_doc_data) {

  var rght_tb;
  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;
  var err_message = document.getElementById("message_box");

  if(xml_data == 0){
    rght_tbl = "";
    err_message.innerHTML = get_prct_dict_text(349);
    return rght_tbl;
  }

  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
  if(xml_data == 8){
    rght_tbl = "";
    err_message.innerHTML = get_prct_dict_text(351);
    return rght_tbl;
  }

  rght_tbl = "<table id=\"wp_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(53) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(266)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wp_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wp_ed, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">A</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_wp_ed(1)\"><img id=\"wp_ed_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wp_amps_min\" style=\"float:left\">5.0</label>";
  rght_tbl += "<label id=\"lab_wp_amps_max\" style=\"float:right\">400.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_wp_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_wp_ed(1)\"><img id=\"wp_ed_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(166) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(267)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wp_time\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wp_ed, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">Sec</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_wp_ed(2)\"><img id=\"wp_ed_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wp_time_min\" style=\"float:left\">0.000</label>";
  rght_tbl += "<label id=\"lab_wp_time_max\" style=\"float:right\">2.000</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_wp_time\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_wp_ed(2)\"><img id=\"wp_ed_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(343) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(268)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_wp_wfs\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_wp_ed, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"txt_wp_wfs_unit\" class=\"item_base item_name\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_wp_ed(3)\"><img id=\"wp_ed_down3\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_wp_wfs_min\" style=\"float:left\">-500.0</label>";
  rght_tbl += "<label id=\"lab_wp_wfs_max\" style=\"float:right\">-5.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_wp_wfs\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_wp_ed(3)\"><img id=\"wp_ed_up3\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_wp_ed(wp_ed_item_num) {
  switch (wp_ed_item_num) {
    case 1:
      validate_check_slg("txt_wp_amps", 5, 400, 'slg_wp_amps', 1);
      set_aw_data('s_ph_volts', 'txt_wp_amps', 9, 1);
      break;
    case 2:
      validate_check_slg("txt_wp_time", 0.000, 2.000, 'slg_wp_time', 3);
      set_aw_data('s_ph_time', 'txt_wp_time', 9, 7);
      break;
    case 3:
      validate_check_slg("txt_wp_wfs", -500.0, -5.0, 'slg_wp_wfs', 1);
      set_aw_data('s_ph_wfs', 'txt_wp_wfs', 9, 2);
      break;
    default:
      set_text_value("txt_wp_amps", 5, 400, 'slg_wp_amps', 0);
      set_text_value("txt_wp_time", 0.000, 2.000, 'slg_wp_time', 1);
      set_text_value("txt_wp_wfs", -500, -5, 'slg_wp_wfs', 2);
      break;
  }
}

function tch_dwn_wp_ed(wp_ed_item_num) {
  check_button_status();
  set_dwn_button("wp_ed_down" + wp_ed_item_num);

  switch (wp_ed_item_num) {
    case 1:
      tch_dwn_btn("txt_wp_amps", 5.0, 5, 400, 'slg_wp_amps', 1);
      set_aw_data('s_ph_volts', 'txt_wp_amps', 9, 1);
      break;
    case 2:
      tch_dwn_btn("txt_wp_time", 0.005, 0.000, 2.000, 'slg_wp_time', 3);
      set_aw_data('s_ph_time', 'txt_wp_time', 9, 7);
      break;
    case 3:
      tch_dwn_btn("txt_wp_wfs", 5.0, -500.0, -5.0, 'slg_wp_wfs', 1);
      set_aw_data('s_ph_wfs', 'txt_wp_wfs', 9, 2);
      break;
    default:
      break;
  }
}

function tch_up_wp_ed(wp_ed_item_num) {
  check_button_status();
  set_up_button("wp_ed_up" + wp_ed_item_num);

  switch (wp_ed_item_num) {
    case 1:
      tch_up_btn("txt_wp_amps", 5.0, 0, 400, 'slg_wp_amps', 1);
      set_aw_data('s_ph_volts', 'txt_wp_amps', 9, 1);
      break;
    case 2:
      tch_up_btn("txt_wp_time", 0.005, 0.000, 2.000, 'slg_wp_time', 3);
      set_aw_data('s_ph_time', 'txt_wp_time', 9, 7);
      break;
    case 3:
      tch_up_btn("txt_wp_wfs", 5.0, -500.0, -5.0, 'slg_wp_wfs', 1);
      set_aw_data('s_ph_wfs', 'txt_wp_wfs', 9, 2);
      break;
    default:
      break;
  }
}

function get_prct_dict_list(xml_doc_data, header) {
  var display_value = "";
  var xml_data;
  var dict_list_num;

  xml_data = xml_doc_data.getElementsByTagName(header)[0].getElementsByTagName("wfsUnit")[0].firstChild.nodeValue;
  dict_list_num = parseInt(xml_data, RADIX_DECIMAL_NUMBER);

  switch (dict_list_num) {
    case 1:
      display_value = get_prct_dict_text(344);
      break;
    case 2:
      display_value = get_prct_dict_text(345);
      break;
    case 3:
      display_value = get_prct_dict_text(346);
      break;
    case 4:
      display_value = get_prct_dict_text(347);
      break;
    default:
      display_value = "";
      break;
  }
  return display_value;
}

function get_arc_heat_rght_scrn(xml_doc_data) {

  var rght_tbl;
  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtStart")[0].firstChild.nodeValue;
  var err_message = document.getElementById("message_box");

  if(xml_data == 0){
    rght_tbl = "";
    err_message.innerHTML = get_prct_dict_text(349);
    return rght_tbl;
  }

  var xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtMode")[0].firstChild.nodeValue;
  if(xml_data == 8){
    rght_tbl = "";
    err_message.innerHTML = get_prct_dict_text(351);
    return rght_tbl;
  }

  rght_tbl = "<table id=\"arch_r_screen\" align=\"center\">";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(53) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(271)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_arch_amps\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_arch_ed, 1, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">A</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_arch_ed(1)\"><img id=\"arch_ed_down1\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_arch_amps_min\" style=\"float:left\">5</label>";
  rght_tbl += "<label id=\"lab_arch_amps_max\" style=\"float:right\">425</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_arch_amps\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_arch_ed(1)\"><img id=\"arch_ed_up1\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(166) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(272)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_arch_time\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_arch_ed, 2, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">Sec</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_arch_ed(2)\"><img id=\"arch_ed_down2\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_arch_time_min\" style=\"float:left\">0.002</label>";
  rght_tbl += "<label id=\"lab_arch_time_max\" style=\"float:right\">0.250</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_arch_time\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_arch_ed(2)\"><img id=\"arch_ed_up2\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "<tr>";
  rght_tbl += "<td class=\"item_base item_name\">" + get_prct_dict_text(343) + "<span class=\"c-help_icon c-help_icon_inlnblck\" onclick=\"display_help(273)\"></span></td>";
  rght_tbl += "<td class=\"item_base txtbox_table\">";
  rght_tbl += "<input id=\"txt_arch_wfs\" type=\"text\" class=\"c-textbox\" onblur=\"set_weld_data()\" onfocus=\"set_elem(this, set_val_arch_ed, 3, '', '', '')\" onkeyup=\"only_numeric(this)\">";
  rght_tbl += "</td>";
  rght_tbl += "<td id=\"txt_arch_wfs_unit\" class=\"item_base item_name\"></td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_dwn_arch_ed(3)\"><img id=\"arch_ed_down3\" alt=\"down\" src=\"btn_down.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base multipass_unit\">";
  rght_tbl += "<p class=\"c_value_range\">";
  rght_tbl += "<label id=\"lab_arch_wfs_min\" style=\"float:left\">5.0</label>";
  rght_tbl += "<label id=\"lab_arch_wfs_max\" style=\"float:right\">3500.0</label>";
  rght_tbl += "</p>";
  rght_tbl += "<div class=\"c-slider\">";
  rght_tbl += "<div id=\"slg_arch_wfs\" class=\"c-slider-bar\"></div>";
  rght_tbl += "</div>";
  rght_tbl += "</td>";
  rght_tbl += "<td class=\"item_base unit_table\">";
  rght_tbl += "<div class=\"c-button\" onclick=\"tch_up_arch_ed(3)\"><img id=\"arch_ed_up3\" alt=\"up\" src=\"btn_up.png\"></div>";
  rght_tbl += "</td>";
  rght_tbl += "</tr>";
  rght_tbl += "</table>";

  return rght_tbl;
}

function set_val_arch_ed(arch_ed_item_num) {
  switch (arch_ed_item_num) {
    case 1:
      validate_check_slg("txt_arch_amps", 5, 425, 'slg_arch_amps', 1);
      set_aw_data('s_ah_volts', 'txt_arch_amps', 10, 1);
      break;
    case 2:
      validate_check_slg("txt_arch_time", 0.002, 0.250, 'slg_arch_time', 3);
      set_aw_data('s_ah_time', 'txt_arch_time', 10, 7);
      break;
    case 3:
      validate_check_slg("txt_arch_wfs", 5.0, 3500.0, 'slg_arch_wfs', 1);
      set_aw_data('s_ah_wfs', 'txt_arch_wfs', 10, 2);
      break;
    default:
      set_text_value("txt_arch_amps", 5, 425, 'slg_arch_amps', 0);
      set_text_value("txt_arch_time", 0.002, 0.250, 'slg_arch_time', 1);
      set_text_value("txt_arch_wfs", 5.0, 300.0, 'slg_arch_wfs', 2);
      break;
  }
}

function tch_dwn_arch_ed(arch_ed_item_num) {
  check_button_status();
  set_dwn_button("arch_ed_down" + arch_ed_item_num);

  switch (arch_ed_item_num) {
    case 1:
      tch_dwn_btn("txt_arch_amps", 5.0, 5.0, 425.0, 'slg_arch_amps', 1);
      set_aw_data('s_ah_volts', 'txt_arch_amps', 10, 1);
      break;
    case 2:
      tch_dwn_btn("txt_arch_time", 0.005, 0.002, 0.250, 'slg_arch_time', 3);
      set_aw_data('s_ah_time', 'txt_arch_time', 10, 7);
      break;
    case 3:
      tch_dwn_btn("txt_arch_wfs", 5.0, 5.0, 3500.0, 'slg_arch_wfs', 1);
      set_aw_data('s_ah_wfs', 'txt_arch_wfs', 10, 2);
      break;
    default:
      break;
  }
}

function tch_up_arch_ed(arch_ed_item_num) {
  check_button_status();
  set_up_button("arch_ed_up" + arch_ed_item_num);

  switch (arch_ed_item_num) {
    case 1:
      tch_up_btn("txt_arch_amps", 5, 0, 425, 'slg_arch_amps', 1);
      set_aw_data('s_ah_volts', 'txt_arch_amps', 10, 1);
      break;
    case 2:
      tch_up_btn("txt_arch_time", 0.005, 0.000, 0.250, 'slg_arch_time', 3);
      set_aw_data('s_ah_time', 'txt_arch_time', 10, 7);
      break;
    case 3:
      tch_up_btn("txt_arch_wfs", 5.0, 5.0, 3500.0, 'slg_arch_wfs', 1);
      set_aw_data('s_ah_wfs', 'txt_arch_wfs', 10, 2);
      break;
    default:
      break;
  }
}


function select_dropdown_retract_s(select_num) {
  var i_ps_sfi = document.getElementById("select_retract_start");
  var tr_mode  = document.getElementById("retract_mode_tr");

  var tree_num;

  if(select_num == 0) {
    i_ps_sfi.value = get_prct_dict_text(58);
    tr_mode.style.display = "block";
  } else {
    i_ps_sfi.value = get_prct_dict_text(59);
    tr_mode.style.display = "none";
  }
  tree_num = 1;

  window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + tree_num + "&s_tr_enb=" + select_num + "&s_sel_tab=" + select_tab_no + "&s_set_no=1";
  close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_retract_start');
}

function set_chg_trmd() {
  var i_ps_sfi = document.getElementById("select_retract_mode");

  if (xml_req.readyState == 4) {
    if ( ( (200 <= xml_req.status) && (xml_req.status < 300) ) || (xml_req.status == 304) ) {
      xml_doc_data = xml_req.responseXML;
      xml_data = xml_doc_data.getElementsByTagName("tcrt")[0].getElementsByTagName("tcrtModeCheck")[0].firstChild.nodeValue;
      xml_data = parseInt(xml_data, RADIX_DECIMAL_NUMBER);
      xml_req.abort();

      switch (xml_data){
        case 1:
          dropdown_message = get_prct_dict_text(295);
          close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_retract_mode');
          return;
        case 2:
          dropdown_message = get_prct_dict_text(350);
          close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_retract_mode');
          return;
        defalult:
          break;
      }
      switch (select_mode) {
        case 1:
          i_ps_sfi.value = get_prct_dict_text(333);
          break;
        case 2:
          i_ps_sfi.value = get_prct_dict_text(334);
          break;
        case 3:
          i_ps_sfi.value = get_prct_dict_text(335);
          break;
        case 4:
          i_ps_sfi.value = get_prct_dict_text(336);
          break;
        case 5:
          i_ps_sfi.value = get_prct_dict_text(337);
          break;
        case 6:
          i_ps_sfi.value = get_prct_dict_text(338);
          break;
        case 7:
          i_ps_sfi.value = get_prct_dict_text(339);
          break;
        case 8:
          i_ps_sfi.value = get_prct_dict_text(340);
          break;
        default:
          break;
      }
      treeSelectNum = 1;

      alert(7);
      window.location.href = "/KARELCMD/AWPRWRT?s_ws_number=" + treeSelectNum + "&s_tr_mode=" + select_mode + "&s_sel_tab=" + select_tab_no + "&s_set_no=2";
      close_dropdown('trnslcnt_scrn', 'dropdown_popup', 'select_retract_mode');
      alert(8);
    }
  }
}


function getTrchkData() {
  xml_req.onreadystatechange = set_chg_trmd;
  xml_req.open("GET", "/TD/AWPRRESP.XML?" + Math.random(), true);
  xml_req.send();
}

function chkReadyStateChgTrmd() {
  if (prg_req.readyState == 4) {
    if ( ( (200 <= prg_req.status) && (prg_req.status < 300) ) || (prg_req.status == 304)) {
      prg_req.abort();
      getTrchkData();
    } else {
      prg_req.abort();
    }
  }
}

function chkTrmdData(select_num) {
  prg_req.onreadystatechange = chkReadyStateChgTrmd;
  prg_req.open("GET", "/KARELCMD/AWPRADD?s_mod_num=" + select_num, true);
  prg_req.send();
}

function select_dropdown_retract_m(select_num) {
  var tree_num;
  select_mode = select_num;
  chkTrmdData(select_num);
}

var SIPManager = {
  init: function() {
    if (isiPendant()) {
      var doc = document,
      div = doc.createElement("div");
      appendActiveXControl(div, "ECC1F43C-6B1E-4E74-AAED-62395D3597C1", "SIPManager", 1, 1);
      doc.body.appendChild(div);
      doc.getElementById("SIPManager").AutoDeployKeyboard = false;
    }
  },
  terminate: function() {
    if (isiPendant()) {
      document.getElementById("SIPManager").AutoDeployKeyboard = true;
    }
  },
  hideKeyboard: function() {
    var sipm = document.getElementById("SIPManager");
    if (sipm !== null) {
      sipm.HideKeyboard();
    }
  },
  showKeyboard: function() {
    var sipm = document.getElementById("SIPManager");
    if (sipm !== null) {
      sipm.ShowKeyboard();
    }
  }
};
