// ------------------------------------------------------------
// Tab ID
// ------------------------------------------------------------
// Schedule Tab ID
const TAB_PROCESSING = 'Processing';
const TAB_POWERCONTROL = 'PowerControl';
const TAB_SLOPEUP = 'SlopeUp';
const TAB_SLOPEDOWN = 'SlopeDown';
const TAB_POWERCOMPENSATION = 'PowerCompensation';

const TAB_INITSETTING = 'InitSetting';
const TAB_LASERSETTING = 'LaserSetting';
const TAB_WIRESETTING = 'WireSetting';

// I/O Tab ID
const TAB_OSCILLATOR_OUTPUT = 'OscillatorOutput';
const TAB_OSCILLATOR_INPUT = 'OscillatorInput';
const TAB_PERIPHERAL_OUTPUT = 'PeripheralOutput';
const TAB_PERIPHERAL_INPUT = 'PeripheralInput';


// ------------------------------------------------------------
// I/O port count
// ------------------------------------------------------------
const IOPORT_COUNT_AI = 64;
const IOPORT_COUNT_AO = 64;
const IOPORT_COUNT_GI = 300;
const IOPORT_COUNT_GO = 300;

// ------------------------------------------------------------
// I/O type
// ------------------------------------------------------------
const IO_TYPE_DI = 1;
const IO_TYPE_DO = 2;
const IO_TYPE_AI = 3;
const IO_TYPE_AO = 4;
const IO_TYPE_RI = 8;
const IO_TYPE_RO = 9;
const IO_TYPE_GI = 18;
const IO_TYPE_GO = 19;
const IO_TYPE_F = 35;

// ------------------------------------------------------------
// columns 
// ------------------------------------------------------------
// Processing columns
const COLUMN_PROCESSING_NO = 0;
const COLUMN_PROCESSING_POWER = 1;
const COLUMN_PROCESSING_BOTTOM = 2;
const COLUMN_PROCESSING_FREQUENCY = 3;
const COLUMN_PROCESSING_DUTY = 4;
const COLUMN_PROCESSING_PC2 = 5;
const COLUMN_PROCESSING_COMMENT = 6;

// Power control column
const COLUMN_PWR_NO = 0;
const COLUMN_PWR_POWER = 1;
const COLUMN_PWR_BOTTOM = 2;
const COLUMN_PWR_FREQUENCY = 3;
const COLUMN_PWR_DUTY = 4;
const COLUMN_PWR_COMMENT = 5;

// Slope Up Down columns
const COLUMN_SLOPE_NO = 0;
const COLUMN_SLOPE_POWER = 1;
const COLUMN_SLOPE_BOTTOM = 2;
const COLUMN_SLOPE_FREQUENCY = 3;
const COLUMN_SLOPE_DUTY = 4;
const COLUMN_SLOPE_COMMENT = 5;

// pwr_cmp columns
const COLUMN_PWRCMP_NO = 0;
const COLUMN_PWRCMP_COMMAND = 1;
const COLUMN_PWRCMP_ACTUAL = 2;

// Power Control II columns
const COLUMN_PS2_Vx = 0;
const COLUMN_PS2_S = 1;
const COLUMN_PS2_L = 2;
const COLUMN_PS2_P = 3;
const COLUMN_PS2_Q = 4;


// ------------------------------------------------------------
// w2ui 
// ------------------------------------------------------------
// Grid field (Processing)
const GRID_NO = 'no';
const GRID_POWER = 'power';
const GRID_BOTTOM = 'bottom';
const GRID_FREQUENCY = 'frequency';
const GRID_DUTY = 'duty';
const GRID_PC2 = 'pc2';
const GRID_COMMENTS = 'comments';

////////// add pc2 //////////
const GRID_SPEED = 'speed';
const GRID_TITLE1 = 'title1';
const GRID_TITLE2 = 'title2';
const GRID_TITLE3 = 'title3';
const GRID_TITLE4 = 'title4';
const GRID_TITLE5 = 'title5';
const RECID_NUM0 = 0;
const RECID_NUM1 = 1;
const RECID_NUM2 = 2;
const RECID_NUM3 = 3;
const RECID_NUM4 = 4;
const COLUMN_SPEED = 1;
const COLUMN_POWER = 3;
const COLUMN_BOTTOM = 5;
const COLUMN_FREQUENCY = 7;
const COLUMN_DUTY = 9;
////////// add pc2 //////////

// Grid field (pwr_cmp)
const GRID_CMD = 'cmd';
const GRID_ACT = 'act';

// Grid field (I/O)
const GRID_TITLE = 'title';
const GRID_TYPE = 'type';
const GRID_NUMBER = 'number';
const GRID_SIMULATE = 'simulate';
const GRID_STATUS = 'status';

// IO area columun index
const COLUMN_TITLE = 0;
const COLUMN_TYPE = 1;
const COLUMN_NUMBER = 2;
const COLUMN_SIMULATE = 3;
const COLUMN_STATUS = 4;

// ------------------------------------------------------------
// iHMI 
// ------------------------------------------------------------
const SETTING_GENERAL = 1;
const SETTING_MAKER = 3;
const SETTING_YLS = 1;
const SETTING_YLR = 2;
const SETTING_CMND_OUT_IF = 2;
const SETTING_PULSE = 0;
const SETTING_CONT = 1;
const SETTING_UNIT_MS = 1;
const SETTING_UNIT_CM = 2;
const SETTING_UNIT_IM = 3;
// iHMI Color Table
const IHMI_COLOR_RED = top.IHMIComponents.global.colorTable.red02;
const IHMI_COLOR_GREEN = top.IHMIComponents.global.colorTable.green03;
const IHMI_COLOR_ORANGE = top.IHMIComponents.global.colorTable.orange01;
const IHMI_COLOR_YELLOW = top.IHMIComponents.global.colorTable.yellow02;
const IHMI_COLOR_BLUE = top.IHMIComponents.global.colorTable.blue01;
const IHMI_COLOR_BLACK = top.IHMIComponents.global.colorTable.black01;
const IHMI_COLOR_WHITE = top.IHMIComponents.global.colorTable.white01;

const COLOR_GRAY = '#e6e6e6';

// ------------------------------------------------------------
// Timer 
// ------------------------------------------------------------
const TIME_IO_CHECK_INTERVAL_MS = 300;

// ------------------------------------------------------------
// others 
// ------------------------------------------------------------
// Data count
const PROCESSING_DATA_COUNT = 30;
const PWRCTRL_DATA_COUNT = 10;
const SLOPEUP_DATA_COUNT = 10;
const SLOPEDOWN_DATA_COUNT = 10;

// Max comment count
const COMMENT_PROCESSING_MAX = 17;
const COMMENT_SLOPEUP_MAX = 13;
const COMMENT_SLOPEDOWN_MAX = 13;
const COMMENT_PWRCTRL_MAX = 13;

// display setting
const DISPLAY_BLOCK = 'block';
const DISPLAY_INLINE_BLOCK = 'inline-block';
const DISPLAY_NONE = 'none';

const DISABLE_VALUE_STRING = '-';

const NO_COMMENT_STR = '********';

// setting
const SETTING_ON_ERR = 1;
const SETTING_ON_OK = 2;

// popup
const URL_HELP_POPUP = "/frh/irprog/laser/detail_help_ls.stm";
const URL_MSG_POPUP = "/frh/irprog/laser/laser_msg_popup.stm";

// ----------------------------------------------------------------------------------
// Common functions
// ----------------------------------------------------------------------------------
// ------------------------------------------------------------
// Read SYSTEM variables
// ------------------------------------------------------------
function readSystemData(xmlcfg, callback) {
    var lang = top.irprogapi.getCurrentLanguage();
    var frameXml = "";
    frameXml += '<?xml version="1.0" encoding="' + top.irprogapi.global.langEncoding[lang] + '"?>\r';
    frameXml += xmlcfg;

    // Create Blob frame CVR
    var fileCvr = new Blob([frameXml], { type: "text/plain" });
    var argObj = {};
    var cbArgs = {};
    cbArgs.sysIndex = 1;
    cbArgs.cbFunc = callback;
    cbArgs.cbObj = argObj;
    top.getXHR('crxeditorinit.cvr', fileCvr, callback, cbArgs);
}

// ------------------------------------------------------------
// Get XML data (SYSTEM variables)
// ------------------------------------------------------------
function getSysValXmlData(getText, tagName) {
    var xmlObj = null;
    var dom = new DOMParser();
    try {
        xmlObj = dom.parseFromString(getText, 'text/xml');
    }
    catch (e) {
        alert('getXML err');
    }
    if (xmlObj != null) {
        if (xmlObj.getElementsByTagName('parsererror').length > 0) {
        }
        // success get xml data.
        if (xmlObj.getElementsByTagName(tagName).length == 0) {
            xmlObj = null; // Illegal XML data.
        }
    }
    return xmlObj;
}

// ------------------------------------------------------------
// onclick Help icon
// ------------------------------------------------------------
function pushBtnHelpIcon(val) {
    var help_title = "";
    switch (val) {
        case 1:
            help_title = "PeakPower";
            break;
        case 2:
            help_title = "BottomPower";
            break;
        case 3:
            help_title = "Frequency";
            break;
        case 4:
            help_title = "duty";
            break;
        default:
            break;
    }

    var customizeObj = {
        callerWindowObj: window,
        width: "620px",
        height: "420px",
        designpattern: "mouse",
        appendArg: { showHelpTitle: help_title }
    };
    top.IHMIComponents.cf.appendPopupFrm(URL_HELP_POPUP, null, top, customizeObj);
}

// ------------------------------------------------------------
// show popup message
// ------------------------------------------------------------
function showPopupMessage(msg, checked, callback) {

    var customizeObj = {
        callerWindowObj: window,
        hideCloseBtn: true,
        width: "620px",
        height: "420px",
        appendArg: {
            showMessage: msg,
            isShowChecked: checked,
            changeCheckCallback: callback
        }
    };
    top.IHMIComponents.cf.appendPopupFrm(URL_MSG_POPUP, null, top, customizeObj);
}

// ------------------------------------------------------------
// strLength
// ------------------------------------------------------------
function strLength(strSrc) {
    var len = 0;
    strSrc = escape(strSrc);
    for (var i = 0; i < strSrc.length; i++, len++) {
        if (strSrc.charAt(i) == "%") {
            if (strSrc.charAt(++i) == "u") {
                i += 3;
                len++;
            }
            i++;
        }
    }
    return len;
}

// ------------------------------------------------------------
// multByteStringSlice
// ------------------------------------------------------------
function multByteStringSlice(str, strLimit) {

    var beforestr = str;

    while (strLength(str) > strLimit) {
        str = str.slice(0, str.length - 1);
    }

    return str;
}


