/*
 * pop_up_tenkey_hagu.js
 * Operation board 'Popup Tenkey' process.
 * Created:  2021/01/20 FSI
 * Modified:
 */

// ESLint setting.
/* global */

// Required.
// pop_up_tenkey_hagu.css

// Calling sequence sample.
// In the <input> element, add attribute below.
// onclick="hagu_open_soft_tenkey(Target name, My element id);"

// Header title resource
var hagu_tenkeyNameDefine = {
  head: '',
  beforeVal: 'ݒO',
  inputVal: '͒l',
  clearBtn: 'NA',
  cancelBtn: 'eL[',
  applyBtn: 'm'
};

// Make and Open Tenkeyboard.
function hagu_open_soft_tenkey(tenkeyName, targetId, callback) {
  //Delete the currently displayed tenkey.
  if (top.opboardleft.document.getElementById('tenkeyframe') !== null) {
    var tenkeyFrame = top.opboardleft.document.getElementById('tenkeyframe');
    tenkeyFrame.parentElement.removeChild(tenkeyFrame);
   }
  // make popup
  var tenkeyElem = document.createElement('div');
  tenkeyElem.id = 'tenkeyframe';
  tenkeyElem.className = 'tenkey-frame';

  // Define inner element
  // Header
  var tenkeyTitle = document.createElement('div');
  tenkeyTitle.id = 'tenkeyheader';
  tenkeyTitle.className = 'tenkey-header';
  var tenkeyHeadLabel = document.createElement('div');
  tenkeyHeadLabel.id = 'iptheadlbl';
  tenkeyHeadLabel.className = 'tenkey-head-lbl';
  tenkeyHeadLabel.innerText = hagu_tenkeyNameDefine.head;
  var tenkeyHeadInput = document.createElement('div');
  tenkeyHeadInput.id = 'iptheadttl';
  tenkeyHeadInput.className = 'tenkey-head-name';
  tenkeyHeadInput.textContent = tenkeyName;
  tenkeyTitle.appendChild(tenkeyHeadLabel);
  tenkeyTitle.appendChild(tenkeyHeadInput);
  tenkeyElem.appendChild(tenkeyTitle);

  // Value text
  var tenkeyValueArea = document.createElement('div');
  tenkeyValueArea.id = 'tenkeyvalue';
  tenkeyValueArea.className = 'tenkey-valarea';
  var tenkeyValBefore = document.createElement('div');
  tenkeyValBefore.className = 'tenkey-value-upl';
  var tenkeyBeforeLbl = document.createElement('span');
  tenkeyBeforeLbl.innerText = hagu_tenkeyNameDefine.beforeVal;
  tenkeyValBefore.appendChild(tenkeyBeforeLbl);
  var tenkeyIptBefore = document.createElement('input');
  tenkeyIptBefore.id = 'tenkeyvalbfr';
  tenkeyIptBefore.type = 'text';
  tenkeyIptBefore.className = 'tenkey-value-upr';
  tenkeyIptBefore.disabled = true;
  var tenkeyValAfter = document.createElement('div');
  tenkeyValAfter.className = 'tenkey-value-dnl';
  var tenkeyAfterLbl = document.createElement('span');
  tenkeyAfterLbl.innerText = hagu_tenkeyNameDefine.inputVal;
  tenkeyValAfter.appendChild(tenkeyAfterLbl);
  var tenkeyIptAfter = document.createElement('input');
  tenkeyIptAfter.id = 'tenkeyvalaft';
  tenkeyIptAfter.type = 'text';
  tenkeyIptAfter.autocomplete = 'off';
  tenkeyIptAfter.className = 'tenkey-value-dnr';
  tenkeyValueArea.appendChild(tenkeyValBefore);
  tenkeyValueArea.appendChild(tenkeyIptBefore);
  tenkeyValueArea.appendChild(tenkeyValAfter);
  tenkeyValueArea.appendChild(tenkeyIptAfter);
  tenkeyElem.appendChild(tenkeyValueArea);

  // Input buttons
  var tenkeyNumArea = document.createElement('div');
  tenkeyNumArea.id = 'tenkeynumeric';
  tenkeyNumArea.className = 'tenkey-numarea';
  // Tenkey define
  for (var i = 0; i < 10; i++) {
    var tenkeyNumBtn = document.createElement('button');
    var numVal = (i < 9) ? (i + 1) : 0;
    tenkeyNumBtn.id = 'tenkeynumbtn' + numVal;
    tenkeyNumBtn.className =
      (i < 4) ? 'tenkey-numkey-up' : (i == 4) ? 'tenkey-numkey-upr' :
      (i == 9) ? 'tenkey-numkey-midr' : 'tenkey-numkey-mid';
    tenkeyNumBtn.innerText = numVal;
    tenkeyNumBtn.onclick = function() {
      hagu_clickTenkeyNumButton(this);
    };
    tenkeyNumArea.appendChild(tenkeyNumBtn);
  }
  var tenkeyClearBtn = document.createElement('button');
  tenkeyClearBtn.id = 'tenkeyclrbtn';
  tenkeyClearBtn.className = 'tenkey-numkey-clear';
  tenkeyClearBtn.innerText = hagu_tenkeyNameDefine.clearBtn;
  tenkeyClearBtn.onclick = function() {
    hagu_clickTenkeyClearButton(this);
  };
  var tenkeyCancelBtn = document.createElement('button');
  tenkeyCancelBtn.id = 'tenkeycnclbtn';
  tenkeyCancelBtn.className = 'tenkey-numkey-cancel';
  tenkeyCancelBtn.innerText = hagu_tenkeyNameDefine.cancelBtn;
  tenkeyCancelBtn.onclick = function() {
    hagu_clickTenkeyCancelButton(this, targetId);
  };
  var tenkeyApplyBtn = document.createElement('button');
  tenkeyApplyBtn.id = 'tenkeyaplybtn';
  tenkeyApplyBtn.className = 'tenkey-numkey-apply';
  tenkeyApplyBtn.innerText = hagu_tenkeyNameDefine.applyBtn;
  tenkeyApplyBtn.onclick = function() {
    hagu_clickTenkeyApplyButton(this, targetId, callback);
  };
  tenkeyNumArea.appendChild(tenkeyClearBtn);
  tenkeyNumArea.appendChild(tenkeyCancelBtn);
  tenkeyNumArea.appendChild(tenkeyApplyBtn);
  tenkeyElem.appendChild(tenkeyNumArea);

  // Display to Before value
  var targetBox = top.opboardleft.document.getElementById(targetId);
  var targetBoxVal = targetBox.value;
  tenkeyIptBefore.value = targetBoxVal;

  // Get parent element and set tenkeyboard
  var targetParent = top.opboardleft.document.getElementById(targetId).parentElement;
  targetParent.appendChild(tenkeyElem);
  hagu_centeringTenkeyPopup('tenkeyframe');
  tenkeyIptAfter.focus();
}

// Centering popup window
function hagu_centeringTenkeyPopup(popupId) {
  // Get content width/height
  var winX             = top.opboardleft.innerWidth;
  var winY             = top.opboardleft.innerHeight;
  var popupElem        = top.opboardleft.document.getElementById(popupId);
  var popupW           = popupElem.clientWidth;
  var popupH           = popupElem.clientHeight;
  var posLeft          = (winX - popupW) / 2;
  var posTop           = (winY - popupH) / 2;
  popupElem.style.left = posLeft + 'px';
  popupElem.style.top  = posTop + 'px';
}

// Input event prcess.
// Numeric button
function hagu_clickTenkeyNumButton(event) {
  // get and set
  var targetBox = top.opboardleft.document.getElementById('tenkeyvalaft');
  var inputNumVal = targetBox.value;
  inputNumVal += event.id.substr('tenkeynumbtn'.length);
  targetBox.value = inputNumVal;
}

// Clear button
function hagu_clickTenkeyClearButton(event) {
  // set empty
  var targetBox = top.opboardleft.document.getElementById('tenkeyvalaft');
  targetBox.value = '';
}

// Cancel button
function hagu_clickTenkeyCancelButton(event, targetId) {
  // Back to target input box
  var targetBox = top.opboardleft.document.getElementById(targetId);
  var tenkeyFrame = top.opboardleft.document.getElementById('tenkeyframe');
  targetBox.parentElement.removeChild(tenkeyFrame);
  targetBox.focus();
}

// Apply button
function hagu_clickTenkeyApplyButton(event, targetId, callback) {
  // get and set
  var tenkeyBox = top.opboardleft.document.getElementById('tenkeyvalaft');
  var tenkeyFrame = top.opboardleft.document.getElementById('tenkeyframe');
  var inputNumVal = tenkeyBox.value;
  var targetBox = top.opboardleft.document.getElementById(targetId);
  if (inputNumVal !== '') {
    targetBox.value = inputNumVal;
  }
  targetBox.parentElement.removeChild(tenkeyFrame);
  targetBox.focus();
  if (callback != undefined) {
    callback(targetBox);
  }
}
