// import from vis_advlib.js
/*global advlib*/
const advlibf = advlib.funcs;
const advlibv = advlib.vars;

const POS_COMMENT = "FIND GRID POS";

const globalData = {
  deviceConnect: false,
  deviceInfo: null,
  camDataTrained: false,
  cameraConnect: false,
  deviceType: advlibv.TTY_CSCX,
  trainedCamDataList: [],
  onRobotCamDataList: [],
  onRobot: false,
  regList: [],
  gridList: [7.5, 11.5, 15, 22.5, 30].map(value => value.toString()),
  posRegOptions: []
};

const GRID_CUSTOM_VALUE = -1;
const GRID_NOT_SELECTED = -2;
const SNAP_ENABLE = 3; /* The number of moving to the snap position with vision offset after first snap */
const SNAP_DISABLE = 0;

const lsArg = {
  version:     new advlibf.InstArgInt(2),
  camDataName: new advlibf.InstArgString(""),
  gridSpacing: new advlibf.InstArgFloat(GRID_NOT_SELECTED),
  visReg:      new advlibf.InstArgInt(advlibv.REG_NOT_SELECTED),
  errReg:      new advlibf.InstArgInt(advlibv.REG_NOT_SELECTED),
  refPos: {
    data:      new advlibf.InstArgPos(advlibv.POS_KIND_POSNUM, 0),
    number:    new advlibf.InstArgInt(0),
    trained:   new advlibf.InstArgBool(false),
  },
  snapPos: {
    data:      new advlibf.InstArgPos(advlibv.POS_KIND_POSNUM, 0),
    trained:   new advlibf.InstArgBool(false),
  },
  moveType:    new advlibf.InstArgInt(advlibv.POS_MOVE_LINE),
  posSpeed:    new advlibf.InstArgInt(200),
  stopTime:    new advlibf.InstArgFloat(0.1),
  deviceName:  new advlibf.InstArgString(""),
  saveLogImage: new advlibf.InstArgInt(0),
  enableSnapPos: new advlibf.InstArgBool(true),
  numFeedbacks: new advlibf.InstArgInt(SNAP_ENABLE),
  numFoundDots: new advlibf.InstArgInt(0)
};

const instArgs = new advlibf.InstArgs([
  lsArg.version,
  lsArg.camDataName,
  lsArg.gridSpacing,
  lsArg.visReg,
  lsArg.errReg,
  lsArg.refPos.data,
  lsArg.refPos.number,
  lsArg.snapPos.data,
  lsArg.snapPos.trained,
  lsArg.moveType,
  lsArg.posSpeed,
  lsArg.stopTime,
  lsArg.deviceName,
  lsArg.saveLogImage,
  lsArg.enableSnapPos,
  lsArg.numFeedbacks,
  lsArg.numFoundDots,
  lsArg.refPos.trained
]);

const ihmif = top.IHMIComponents.cf;
const editorAPI = parent.editorAPI.funcs;

async function getAllInformation() {
  const deviceOptions = await advlibf.createDeviceOptions(advlibv.TTY_CSCX);
  if (deviceOptions.length === 1) {
    lsArg.deviceName.text = deviceOptions[0];
  }
  const deviceName = lsArg.deviceName.text;
  globalData.cameraConnect = true;
  globalData.deviceConnect = deviceOptions.find(name => name === deviceName) !== undefined;
  document.getElementById("selCameras").refresh(deviceOptions, deviceName, deviceName, false);
  if (deviceName === "" || !globalData.deviceConnect) return;

  const resAllCamData = await advlibf.getCamData({ trained_only: false }, deviceName);
  const resTrainedCamData = await advlibf.getCamData({ trained_only: true }, deviceName);
  const allCamData = resAllCamData.data_names;
  const trainedCamData = resTrainedCamData.data_names;
  
  if (!allCamData.find(dataName => dataName === lsArg.camDataName.text)) {
    lsArg.camDataName.text = "";
  }
  
  const notTrainedCamData = allCamData.filter(dataName => !trainedCamData.includes(dataName));
  const sortedAllCamData = trainedCamData.concat(notTrainedCamData);

  if (sortedAllCamData.length > 0) {
    if (lsArg.camDataName.text === "") {
      lsArg.camDataName.text = sortedAllCamData[0];
    }
  }
  else {
    lsArg.refPos.trained.value = false;
    lsArg.snapPos.trained.value = false;
  }

  const optionsNotTrainedCamData = advlibf.createUntrainedOptions(notTrainedCamData);
  const optionsAllCamData = trainedCamData.concat(optionsNotTrainedCamData);
  document.getElementById("selCameraData").refresh(optionsAllCamData, lsArg.camDataName.text, false);
  globalData.camDataTrained = (trainedCamData.indexOf(lsArg.camDataName.text) >= 0);
  globalData.trainedCamDataList = trainedCamData;

  const { nreg: nregOptions, vreg: vregOptions } = await advlibf.createRegOptions();
  globalData.regList = nregOptions;
  document.getElementById('selVRIndex').refresh(vregOptions, lsArg.visReg.text, null, false);
  document.getElementById('selRIndex').refresh(nregOptions, lsArg.errReg.text, null, false);
  globalData.posRegOptions = await advlibf.createPosRegOptions();
  
  const camDataOnRobot = await advlibf.getCamData({ trained_only: true, cam_on_robot_only: true }, deviceName);
  globalData.onRobotCamDataList = camDataOnRobot.data_names;
  if (globalData.camDataTrained) {
    globalData.onRobot = globalData.onRobotCamDataList.includes(lsArg.camDataName.text);
    if (!(globalData.onRobot && lsArg.enableSnapPos.value)) {
      lsArg.numFeedbacks.value = SNAP_DISABLE;
    }
  }

  const resDeviceInfo = await advlibf.promiseRequest({ request: "get_deviceinfo", device_name: deviceName, type: globalData.deviceType });
  globalData.deviceInfo = resDeviceInfo;
}

// eslint-disable-next-line no-unused-vars
function dispAdvInstData(argStr) {
  const success = setFirstArg(argStr);
  if (!success) return false;

  getAllInformation()
    .catch(status => advlibf.popupAlert(status))
    .finally(() => {
      advlibf.initPositionComponent("posSnap", lsArg.snapPos.data.number, lsArg.snapPos.data.kind, callBackPosition, function () {
        refreshAll();
        const deviceName = lsArg.deviceName.text;
        if (deviceName !== "" && globalData.deviceConnect) {
          advlibf.showVisionRuntime(globalData.deviceType, deviceName);
        }
      }, {noLocalReg: true});
    });
  return true;
}

function setFirstArg(argStr) {
  if (argStr.length === 0) {
    return false;
  }
  instArgs.text = argStr;
  lsArg.refPos.number.value = lsArg.refPos.data.number;
  return true;
}

function callBackPosition(id, operation, posNum) {
  const posInfo = advlibf.getPosInformation(id, operation, posNum);

  advlibf.setPosComment(posInfo, POS_COMMENT);

  if (posInfo.trained) {
    lsArg.snapPos.trained.value = true;
    if (lsArg.refPos.trained.value) {
      openHelp(1);
    }
    else if (lsArg.refPos.number.value !== advlibv.POS_NOT_TRAINED) {
      resetRefPos().then(() => {
        if (lsArg.numFoundDots.value !== 0) {
          openHelp(1);
        }
      });
    }
    else {
      advlibf.popupAlert("Whlen Sie den PR-Index fr die Referenzposition.");
    }
  }
  else if (lsArg.snapPos.data.kind !== posInfo.kind ||
           lsArg.snapPos.data.number !== posInfo.number) {
    lsArg.refPos.trained.value = false;
    lsArg.snapPos.trained.value = false;
  }
  lsArg.snapPos.data.kind = posInfo.kind;
  lsArg.snapPos.data.number = posInfo.number;
  refreshAll();
  setLsArg();
}

function refreshAll() {
  let hide, elemTraining, notTrained;
  const trained = [];
  trained[0] = globalData.camDataTrained;
  advlibf.turnOnOffTrained("divCameraSetup", trained[0]);
  trained[1] = lsArg.gridSpacing.value > 0 && trained[0];
  advlibf.turnOnOffTrained("divDetectionSetup", trained[1]);

  trained[2] = ((lsArg.snapPos.trained.value || !lsArg.enableSnapPos.value) && trained[1] && lsArg.refPos.trained.value) ;
  advlibf.turnOnOffTrained("divSnapPosition", trained[2]);
  advlibf.turnOnOffTrained("divOffsetMotion", trained[2]);

  const isAccordionPosOpen = ihmif.hasClass(document.getElementById('accordionPos'), "position-folding-bg-desc");

  if (!trained[0]) {
    elemTraining = "divCameraSetup";
  }
  else if (!trained[1]) {
    elemTraining = "divDetectionSetup";
  }
  else if (!trained[2]) {
    elemTraining = "divSnapPosition";
  }
  else {
    elemTraining = "divOffsetMotion";
  }
  ihmif.addClassExclusively(document.getElementById("divContent"), document.getElementById(elemTraining), 'training');

  hide = !globalData.cameraConnect;
  ihmif.turnOnOffClass(document.getElementById("divSetupCamera"), 'hide', hide);

  hide = trained[0] || lsArg.camDataName.text !== "" || lsArg.deviceName.text === "" || (!globalData.deviceConnect && lsArg.deviceName.text !== "");
  ihmif.turnOnOffClass(document.getElementById("helpCameraSetup"), 'hide', hide);

  notTrained = lsArg.deviceName.text === "";
  document.getElementById("selCameras").setRequiredMark(notTrained);

  notTrained = !globalData.camDataTrained;
  document.getElementById('btnOpenCamData').setRequiredMark(notTrained);
  document.getElementById('btnOpenCamData2').setRequiredMark(notTrained);
  document.getElementById('btnCreateCamData').setRequiredMark(notTrained);

  hide = (!trained[0] && lsArg.camDataName.text === "") || !globalData.deviceConnect;
  ihmif.turnOnOffClass(document.getElementById("divAccCamData"), 'hide', hide);

  hide = !trained[0];
  ihmif.turnOnOffClass(document.getElementById("divDetectionItems"), 'hide', hide);

  hide = (!trained[0] || !trained[1] || !lsArg.enableSnapPos.value);
  ihmif.turnOnOffClass(document.getElementById("divAccSnapPos"), 'hide', hide);

  hide = (!trained[0] || !trained[1] || isAccordionPosOpen || !lsArg.enableSnapPos.value);
  ihmif.turnOnOffClass(document.getElementById("divTeachPos"), 'hide', hide);

  document.getElementById('btnTeachPos').setRequiredMark(!lsArg.snapPos.trained.value);

  const isAccordionCamDataOpen = !ihmif.hasClass(document.getElementById('accordionCamData'), "position-folding-bg-asc");
  hide = trained[0] || lsArg.camDataName.text !== "" || lsArg.deviceName.text === "" || (!globalData.deviceConnect && lsArg.deviceName.text !== "");
  ihmif.turnOnOffClass(document.getElementById("btnCreateCamData"), 'hide', hide);
  hide = (!trained[0] && lsArg.camDataName.text === "") || !globalData.deviceConnect;
  ihmif.turnOnOffClass(document.getElementById("divCameraData"), 'hide', hide);
  hide = (!trained[0] && lsArg.camDataName.text === "") || isAccordionCamDataOpen || !globalData.deviceConnect;
  ihmif.turnOnOffClass(document.getElementById("btnOpenCamData"), 'hide', hide);

  hide = !trained[1];
  ihmif.turnOnOffClass(document.getElementById("divPositionArea"), 'hide', hide);

  hide = trained[2] || !lsArg.enableSnapPos.value;
  ihmif.turnOnOffClass(document.getElementById("helpSnapPosition"), 'hide', hide);

  hide = (!trained[0] || !trained[1] || !trained[2]);
  ihmif.turnOnOffClass(document.getElementById("helpOffsetMove"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("cameraSetupTitle"), 'bold', hide);
  ihmif.turnOnOffClass(document.getElementById("detectionTitle"), 'bold', hide);
  ihmif.turnOnOffClass(document.getElementById("snapPositionTitle"), 'bold', hide);

  const isCustom = (!globalData.gridList.includes(lsArg.gridSpacing.text) && lsArg.gridSpacing.value > 0);
  hide = lsArg.gridSpacing.value !== GRID_CUSTOM_VALUE && !isCustom;
  ihmif.turnOnOffClass(document.getElementById("txtGridInterval"), 'hide', hide);

  notTrained = lsArg.gridSpacing.value < 0;
  document.getElementById("selGridInterval").setRequiredMark(notTrained);
  document.getElementById("txtGridInterval").setRequiredMark(notTrained);

  document.getElementById("btnResetRefPos").setRequiredMark(!lsArg.refPos.trained.value);

  document.getElementById('txtStopTime').refresh(lsArg.stopTime.text, "0.001", "100", false);
  document.getElementById('selRIndex').refresh(globalData.regList, lsArg.errReg.value, null, false);
  document.getElementById("selSaveLogImage").refresh([], lsArg.saveLogImage.text, null, false);

  const gridList = globalData.gridList.map(value => [`${value}mm`, value]);
  document.getElementById('selGridInterval').refresh(gridList, isCustom  ? GRID_CUSTOM_VALUE.toString() : lsArg.gridSpacing.text, null, false);
  document.getElementById("txtGridInterval").refresh(lsArg.gridSpacing.value > 0 ? lsArg.gridSpacing.text : "NaN", "0.10", "1000000.00", hide);

  hide = !(globalData.onRobot && lsArg.enableSnapPos.value && isAccordionPosOpen);
  ihmif.turnOnOffClass(document.getElementById("divNumFeedbacks"), 'hide', hide);

  hide = !ihmif.hasClass(document.getElementById("divTeachPos"), "hide") ;
  ihmif.turnOnOffClass(document.getElementById("divSnapPosMove"), "hide", hide);
  ihmif.turnOnOffClass(document.getElementById("divRefPosChange"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("divResetRefPos"), "hide", hide);

  document.getElementById("tglNumFeedbacks").refresh(lsArg.numFeedbacks.value === SNAP_DISABLE);
  document.getElementById("tglRefPosIndex").refresh(lsArg.refPos.data.kind === advlibv.POS_KIND_POSREG);

  hide = lsArg.refPos.data.kind === advlibv.POS_KIND_POSNUM;
  const selRefPosIndexElem = document.getElementById('selRefPosIndex');
  selRefPosIndexElem.refresh(globalData.posRegOptions, lsArg.refPos.number.value, null, hide);
  selRefPosIndexElem.setRequiredMark(lsArg.refPos.number.value === advlibv.POS_NOT_TRAINED);
  ihmif.turnOnOffClass(selRefPosIndexElem, "hide", hide);

  document.getElementById("tglSnapPos").refresh(lsArg.enableSnapPos.value);
  hide = !isAccordionPosOpen || !lsArg.enableSnapPos.value;
  ihmif.turnOnOffClass(document.getElementById("accordionPosOpen"), 'hide', hide);

  document.getElementById("selMoveType").refresh([], lsArg.moveType.text, null, false);
  if (lsArg.moveType.value === advlibv.POS_MOVE_LINE) {
    document.getElementById('txtSpeedLine').refresh(lsArg.posSpeed.text, "1", "3000", false);
    hide = false;
  }
  else {
    document.getElementById('txtSpeedJoint').refresh(lsArg.posSpeed.text, "0", "100", false);
    hide = true;
  }
  ihmif.turnOnOffClass(document.getElementById("txtSpeedLine"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("txtSpeedJoint"), 'hide', !hide);

  ihmif.turnOnOffClass(document.getElementById("helpGridSpacing"), "text-not-trained", !trained[1]);

  ihmif.removeClass(document.body, 'hidden');
}

function setLsArg() {
  parent.setInstructionParam(instArgs.text);
}

function inputStopTime(_id, _type, value) {
  lsArg.stopTime.text = value;
  refreshAll();
  setLsArg();
}

function selectVisReg(_id, _type, value) {
  lsArg.visReg.text = value;
  lsArg.errReg.text = document.getElementById('selRIndex').getValue();
  refreshAll();
  setLsArg();
}
function selectReg(_id, _type, value) {
  lsArg.visReg.text = document.getElementById('selVRIndex').getValue();
  lsArg.errReg.text = value;
  refreshAll();
  setLsArg();
}
function selectCamera(_id, _type, value) {
  lsArg.deviceName.text = value;
  lsArg.camDataName.text = "";
  lsArg.refPos.trained.value = false;
  lsArg.snapPos.trained.value = false;
  document.getElementById("btnOpenCamData").refresh(null, null, null, null, false);
  document.getElementById("btnOpenCamData2").refresh(null, null, null, null, false);

  getAllInformation()
    .then(() => {
      refreshAll();
      setLsArg();
      const deviceName = lsArg.deviceName.text;
      if (deviceName !== "" && globalData.deviceConnect) {
        advlibf.showVisionRuntime(globalData.deviceType, deviceName);
      }
    })
    .catch(status => advlibf.popupAlert(status));
}

function selectCameraData(_id, _type, value) {
  lsArg.camDataName.text = value;
  globalData.camDataTrained = globalData.trainedCamDataList.find(name => name === lsArg.camDataName.text) !== undefined;
  if (globalData.camDataTrained) {
    const onRobot = globalData.onRobotCamDataList.includes(lsArg.camDataName.text);
    if (globalData.onRobot !== onRobot) {
      lsArg.numFeedbacks.value = (onRobot && lsArg.enableSnapPos.value) ? SNAP_ENABLE : SNAP_DISABLE;
      globalData.onRobot = onRobot;
    }
  }
  refreshAll();
  setLsArg();
}

function selectGrid(_id, _type, value) {
  if (lsArg.refPos.trained.value) {
    advlibf.confirmMessage("&#39;Gitterweite&#39;, Sie mssen die Referenzposition neu einstellen.  Mchten Sie &#39;Gitterweite&#39; wirklich ndern?", "gridSpacingChange", [{
      finallyCallback: () => refreshAll()
    }, {
      label: "Ja",
      callback: () => changeGridSpacing(value)
    }, {
      label: "Nein"
    }]);
  }
  else {
    changeGridSpacing(value);
    refreshAll();
  }

  function changeGridSpacing(value) {
    lsArg.gridSpacing.text = value;
    lsArg.refPos.trained.value = false;
    setLsArg();
  }
}
function selectSaveLogImage(_id, _type, value) {
  lsArg.saveLogImage.text = value;
  refreshAll();
  setLsArg();
}

function selectMoveType(_id, _type, value) {
  lsArg.moveType.text = value;
  lsArg.posSpeed.value = (lsArg.moveType.value === advlibv.POS_MOVE_LINE) ? 200 : 100;
  refreshAll();
  setLsArg();
}
function inputMoveSpeed(_id, _type, value) {
  lsArg.posSpeed.text = value;
  setLsArg();
}

function btnCreateCamData(_id, _type, _value) {
  const dataName = advlibf.getDataName("CAM_", lsArg.deviceName.text).toUpperCase();
  const prgNameCnt = 0;
  advlibf.tryCreateCamData(dataName, globalData.deviceInfo, prgNameCnt, (dataName) => {
    lsArg.camDataName.text = dataName;
    setLsArg();
    advlibf.jumpVisionPage(dataName);
  });
}

function openCamData(_id, _type, _value) {
  advlibf.jumpVisionPage(lsArg.camDataName.text);
  setLsArg();
}

function toggleSnapPos(_id, _operation, checked) {
  lsArg.enableSnapPos.value = checked;
  lsArg.numFeedbacks.value = (globalData.onRobot && lsArg.enableSnapPos.value) ? SNAP_ENABLE : SNAP_DISABLE;
  refreshAll();
  setLsArg();
}

function enableFeedbacks(checked) {
  lsArg.numFeedbacks.value = checked ? SNAP_DISABLE : SNAP_ENABLE;
  refreshAll();
  setLsArg();
}

function toggleRefPos(_id, _operation, checked) {
  if (lsArg.refPos.trained.value) {
    advlibf.confirmMessage("Die aktuelle Referenzposition wird gelscht.<br>Mchten Sie das Speicherziel der Referenzposition wirklich ndern?", "refPosChange", [{
      finallyCallback: () => refreshAll()
    }, {
      label: "Ja",
      callback: () => {
        changePosType(checked);
        setLsArg();
      }
    }, {
      label: "Nein",
    }]);
  }
  else {
    changePosType(checked);
    setLsArg();
    refreshAll();
  }
}
function changePosType(checked) {
  lsArg.refPos.data.argText = checked ? "PR[...]" : editorAPI.getPosNumber('P[N]');
  lsArg.refPos.number.value = lsArg.refPos.data.number;
  lsArg.refPos.trained.value = false;
  if (lsArg.refPos.data.kind === advlibv.POS_KIND_POSNUM) {
    const tppName = editorAPI.getCurrProg();
    advlibf.initPositionData(tppName, lsArg.refPos.data.number, lsArg.refPos.data.kind);
  }
}

async function selectRefPos(_id, _type, value) {
  if (await advlibf.isPosDataInit(value)) {
    changeRefPosNum(value);
    setLsArg();
    refreshAll();
  }
  else {
    advlibf.confirmMessage("Der ausgewhlte PR wird initialisiert. Mchten Sie wirklich initialisieren?", "posRegNotTrained", [{
      finallyCallback: () => {
        setLsArg();
        refreshAll();
      }
    }, {
      label: "Ja",
      callback: () => {
        changeRefPosNum(value);
        const tppName = editorAPI.getCurrProg();
        advlibf.initPositionData(tppName, lsArg.refPos.data.number, lsArg.refPos.data.kind);
      }
    }, {
      label: "Nein",
    }]);
  }
  function changeRefPosNum(value) {
    lsArg.refPos.data.number = value;
    lsArg.refPos.number.value = value;
    lsArg.refPos.trained.value = true;
  }
}

function toggleFeedbacks(_id, _operation, checked) {
  if (checked) {
    advlibf.confirmMessage("Wenn &#39;Zykluszeit priorisieren&#39; aktiviert ist, bewegt sich der Roboter nicht von der anfnglichen Erfassungsposition, und die Zykluszeit wird verkrzt; der Offset-Fehler ist jedoch erheblich. Es wird empfohlen, &#39;Zykluszeit priorisieren&#39; zu deaktivieren, wenn ein prziser Offset-Vorgang durchgefhrt wird.<br>&#39;Zykluszeit priorisieren&#39; aktivieren?", "enableFeedbacks", [{
      finallyCallback: () => refreshAll()
    }, {
      label: "OK",
      callback: () => enableFeedbacks(checked)
    }, {
      label: "ABBRECHEN"
    }], { designpattern: "mouse"});
  }
  else {
    enableFeedbacks(checked);
  }
}

function openHelp(hlpCode) {
  const helps = [
    ["/grid_hlp_img_logmode.htm", { width: "640px", height: "600px" }],
    ["/grid_hlp_snap_position.htm", { width: "640px", height: "180px"}],
    ["/grid_hlp_offset.htm?failed_only=true", {}],
    ["/grid_hlp_snap_position2.htm", { width: "640px", height: "666px" }],
    ["/grid_hlp_marker_place.htm", { width: "640px", height: "760px" }],
    ["/grid_hlp_difference.htm", { width: "640px", height: "740px" }]
  ];
  advlibf.openHelp(window, advlibv.HELP_PATH + helps[hlpCode][0], helps[hlpCode][1]);
}

function resetRefPos() {
  const tppName = editorAPI.getCurrProg();
  return advlibf.promiseRequest({ request: "set_grid_reference", camdata_name: lsArg.camDataName.text, tpp_name: tppName, pos_id: lsArg.refPos.number.value, grid_spacing: lsArg.gridSpacing.value, pos_kind: lsArg.refPos.data.kind})
    .then((res) => {
      lsArg.numFoundDots.value = res.num_found_dots;
      lsArg.refPos.trained.value = true;
      refreshAll();
      setLsArg();
    }).catch(() => {
      lsArg.numFoundDots.value = 0;
      setLsArg();
      advlibf.popupAlert("Das Gittermuster muss in das Bild passen. Wenn keine Punkte ermittelt werden, ndern Sie die LED-Beleuchtung auf dem Einstellungsbildschirm der Kameraeinrichtung.");
    });
}

function resetRefPosPopup() {
  if (lsArg.refPos.number.value === advlibv.POS_NOT_TRAINED) {
    advlibf.popupAlert("Whlen Sie den PR-Index fr die Referenzposition.");
  }
  else {
    advlibf.confirmMessage("Wenn Sie die Referenzposition zurcksetzen, mssen Sie die Bildverarbeitungs-Offset-Position neu einlernen. Referenzposition zurcksetzen?", "resetRefPos", [{
      label: "Ja",
      callback: () => resetRefPos().then(() => {
        if (lsArg.numFoundDots.value !== 0) {
          ihmif.alertMessage("'Ref.pos. zurcksetzen' wurde abgeschlossen.", null, null, window.parent, null);
        }
      }),
    }, {
      label: "Nein",
    }]);
  }
}
function snapPosAccordion(id, _action) {
  advlibf.accordionOpenClose(id, 'divTeachPos');
  refreshAll();
}

function camAccordion(id, _action) {
  advlibf.accordionOpenClose(id, '');
  refreshAll();
}

window.onload = function () {
  document.getElementById('btnCreateCamData').setCallback(btnCreateCamData);
  document.getElementById('btnOpenCamData').setCallback(openCamData);
  document.getElementById('btnCreateCamData2').setCallback(btnCreateCamData);
  document.getElementById('btnOpenCamData2').setCallback(openCamData);
  document.getElementById('selCameras').setCallback(selectCamera);
  document.getElementById('selCameraData').setCallback(selectCameraData);
  document.getElementById('selVRIndex').setCallback(selectVisReg);
  document.getElementById('selRIndex').setCallback(selectReg);
  document.getElementById('selSaveLogImage').setCallback(selectSaveLogImage);
  document.getElementById('txtStopTime').setCallback(inputStopTime);
  document.getElementById('selGridInterval').setCallback(selectGrid);
  document.getElementById('txtGridInterval').setCallback(selectGrid);
  document.getElementById('btnResetRefPos').setCallback(resetRefPosPopup);
  document.getElementById('selMoveType').setCallback(selectMoveType);
  document.getElementById('txtSpeedLine').setCallback(inputMoveSpeed);
  document.getElementById('txtSpeedJoint').setCallback(inputMoveSpeed);
  document.getElementById('tglNumFeedbacks').setCallback(toggleFeedbacks);
  document.getElementById('tglRefPosIndex').setCallback(toggleRefPos);
  document.getElementById('selRefPosIndex').setCallback(selectRefPos);
  document.getElementById('tglSnapPos').setCallback(toggleSnapPos);
  document.getElementById('btnTeachPos').setCallback((_id, _action) => advlibf.pushTouchUp('posSnap'));
  document.getElementById('accordionOutput').setCallback((id, _action) => advlibf.accordionOpenClose(id, ''));
  document.getElementById('accordionPos').setCallback(snapPosAccordion);
  document.getElementById('accordionCamData').setCallback(camAccordion);
};
