// import from vis_advlib.js
/*global advlib*/
const advlibf = advlib.funcs;
const advlibv = advlib.vars;

// import from vis_markerlib.js
/*global markerlib*/
const markerlibf = markerlib.funcs;
const markerlibv = markerlib.vars;

const POS_COMMENT = "VISION FIND POS";

const globalData = {
  deviceConnect: false,
  deviceInfo: null,
  camDataTrained: false,
  visProcTrained: false,
  visProcExist: false,
  cameraConnect: false,
  prgNameCnt: 0,
  numVisProcs: 0,
  deviceType: advlibv.TTY_CSCX,
  visProgList: [],
  camDataList: [],
  regList: []
};

const lsArg = markerlibf.createFindMarkerLsArgs();
const instArgs = markerlibf.createFindMarkerInstArgs(lsArg);

const ihmif = top.IHMIComponents.cf;

const editorAPI = parent.editorAPI.funcs;

async function getAllInformation() {
  const devices = await advlibf.getDevices(advlibv.TTY_CSCX),
        options = devices.filter(device => device.type === advlibv.TTY_CSCX && !(/_3dv_/.test(device.icon))).map(device => device.name);
  if (options.length === 1) {
    lsArg.deviceName.text = options[0];
  }
  const deviceName = lsArg.deviceName.text;
  globalData.cameraConnect = true;
  globalData.deviceConnect = options.find(name => name === deviceName) !== undefined;
  document.getElementById("selCameras").refresh(options, deviceName, deviceName, false);
  markerlibv.POS_SUFFIXES.forEach((suffix) => {
    document.getElementById(`btnTeach${suffix}`).refresh(null, null, null, null, false, null);
  });
  if (deviceName === "" || !globalData.deviceConnect) return;

  const resTrainedCamData = await advlibf.getCamData({ trained_only: true, cam_on_robot_only: true }, deviceName);
  globalData.camDataList = resTrainedCamData.data_names;
  const resAllCamData = await advlibf.getCamData({ trained_only: false, cam_on_robot_only: true }, deviceName);
  if (lsArg.camDataName.text !== "" && !resAllCamData.data_names.find(dataName => dataName === lsArg.camDataName.text)) {
    lsArg.camDataName.text = "";
  }

  if (globalData.camDataList.length > 0) {
    if (lsArg.camDataName.text === "") {
      lsArg.camDataName.text = globalData.camDataList[0];
    }
  }
  else {
    lsArg.vpName.text = "";
    markerlibv.POS_INDICES.forEach((index) => {
      lsArg.position[index].posTrained.value = advlibv.POS_NOT_TRAINED;
    });
  }
  const vpName = lsArg.vpName.text;
  const resDeviceInfo = await advlibf.promiseRequest({ request: "get_deviceinfo", device_name: deviceName, type: globalData.deviceType });

  globalData.deviceInfo = resDeviceInfo;

  const resVisProcs = await advlibf.promiseRequest({ request: "get_dataprops", category: advlibv.IID_VISIONPROCESS, type: globalData.deviceInfo.visproc_type });

  const propsVisProcs = resVisProcs.properties.filter(props => props.camera_name === deviceName && props.offset_type === advlibv.GAZE_LINE && resAllCamData.data_names.includes(props.camdata_name));
  globalData.visProgList = resVisProcs.properties;
  globalData.visProcExist = propsVisProcs.find(props => props.name === vpName);
  if (globalData.visProcExist) {
    lsArg.camDataName.text = globalData.visProcExist.camdata_name;
    globalData.visProcTrained = globalData.visProcExist.is_trained;
  }
  globalData.camDataTrained = globalData.camDataList.indexOf(lsArg.camDataName.text) >= 0;
  globalData.numVisProcs = propsVisProcs.length;

  const trainedData = propsVisProcs.filter(props => props.is_trained).map(props => props.name),
        untrainedData = propsVisProcs.filter(props => !props.is_trained).map(props => props.name),
        untrainedOptions = advlibf.createUntrainedOptions(untrainedData),
        nameOptions = trainedData.concat(untrainedOptions);
  document.getElementById("selVisProc").refresh(nameOptions, vpName, vpName, false);

  const regOptions = await advlibf.createRegOptions();
  globalData.regList = regOptions.nreg;
  setRegArg();
  document.getElementById('selVRIndex').refresh(regOptions.vreg, lsArg.vreg.value, null, false);
  document.getElementById('selRIndex').refresh(globalData.regList, lsArg.reg.value, null, false);
}

// eslint-disable-next-line no-unused-vars
function dispAdvInstData(argStr) {
  const success = setFirstArg(argStr);
  if (!success) return false;
  getAllInformation()
    .catch(status => advlibf.popupAlert(status))
    .finally(() => {
      markerlibv.POS_INDICES.forEach((value, index) => {
        advlibf.initPositionComponent(`robotPos${markerlibv.POS_SUFFIXES[index]}`, lsArg.position[index].data.number, lsArg.position[value].data.kind, callBackPosition, function () {
          refreshAll();
          const deviceName = lsArg.deviceName.text;
          if (deviceName !== "" && globalData.deviceConnect) advlibf.showVisionRuntime(globalData.deviceType, deviceName);
        }, {noLocalReg: true});
      });
    });
  if (!getDefaultCountPrg()) overPrgCountPopup();
  return true;
}

function setFirstArg(argStr) {
  if (argStr.length === 0) {
    return false;
  }
  instArgs.text = argStr;
  lsArg.version.value = 2;

  return true;
}

function callBackPosition(id, operation, posNum) {
  const posInfo = advlibf.getPosInformation(id, operation, posNum);

  advlibf.setPosComment(posInfo, POS_COMMENT);

  let setLsArgFlg = true;
  const posTrained = posInfo.trained,
        posKind = posInfo.kind,
        posNumber = posInfo.number;
  const posIdx = markerlibv.REG_SUFFIX_FIRST.test(posInfo.id) ? markerlibv.POS_FIRST : markerlibv.POS_SECOND;
  const nextWizardFlg = (posTrained &&
                         lsArg.position[1 - posIdx].posTrained.value === advlibv.POS_TRAINED &&
                         lsArg.position[posIdx].posTrained.value !== advlibv.POS_TRAINED);
  if (posTrained && getHasParentIcon()) {
    const iconsArray = markerlibf.getIconsArrayBetween(markerlibv.MARKSOFFSETSTART, markerlibv.MARKSOFFSETEND),
          stepNum = getStepNum(iconsArray);
    if (lsArg.position[posIdx].posTrained.value !== advlibv.POS_TRAINED && stepNum > 0 && stepNum <= 6) {
      findTarget(stepNum, iconsArray);
      return;
    }
  }
  if (setLsArgFlg) {
    if (nextWizardFlg) {
      lsArg.dateTime.text = Date.now().toString();
    }
    updatePosData(posTrained, posKind, posNumber);
  }

  function findTarget(stepNum, iconsArray) {
    const dateStr = getParentDateTimeArg(iconsArray),
          refPos = getRefPos(iconsArray),
          refPosKind = getRefPosKind(iconsArray),
          tppName = editorAPI.getCurrProg(),
          params = { data_name: lsArg.vpName.text, tpp_name: tppName, vr_num: lsArg.vreg.value, gl_limit: lsArg.distTolerance.value, pos_num: refPos, datetime: dateStr, pos_kind: refPosKind};
    editorAPI.stopAutoRefresh();
    return markerlibf.execute3MarkersProgram(stepNum, params)
      .then(() => top.rpcmc_getVar("irv3marksofs", "error_number", getErrorNumber))
      .finally(() => editorAPI.restartAutoRefresh());
  }
  function getStepNum(iconsArray) {
    const lineNum = parent.instructionGetCurrentLineNum(),
          foundSteps = getFoundSteps(lineNum, iconsArray);
    return foundSteps * 2 + posIdx + 1;
  }
  function getErrorNumber(_progName, _varName, _typeCode, value) {
    if (value === "0") {
      if (setLsArgFlg) {
        updatePosData(posTrained, posKind, posNumber);
      }
      if (nextWizardFlg) {
        lsArg.dateTime.text = Date.now().toString();
        setLsArg();
        top.rpcmc_getVar("irv3mosetref", "complete", nextIconWizard);
      }
    }
    else if (value === "513") {
      overwriteRequestWizard();
    }
  }
  function overwriteRequestWizard() {
    const customizeObj = {
      selectBtn: {
        1: {label: "Yes"},
        2: {label: "No"}
      },
      hideCloseBtn: true
    };
    async function closeDlgConf(id, _operation) {
      if (id === 'btn1') {
        const iconsArray = markerlibf.getIconsArrayBetween(markerlibv.MARKSOFFSETSTART, markerlibv.MARKSOFFSETEND),
              stepNum = getStepNum(iconsArray);
        await markerlibf.execute3MarkersProgram(0, {datetime: getParentDateTimeArg(iconsArray)});
        await findTarget(stepNum, iconsArray);
      }
    }
    const message = "There is 3-Marker Runtime Offset being taught. That data is deleted, if you continue teaching this.\nAre you sure to delete?";
    top.IHMIComponents.cf.confirmMessage(window.webpage, message, "wizConf", null, null, top.home.window, closeDlgConf, null, customizeObj);
  }
  function updatePosData(posTrained, posKind, posNumber) {
    setLsArgFlg = false;
    if (posTrained) {
      lsArg.position[posIdx].posTrained.value = advlibv.POS_TRAINED;
    }
    else if (lsArg.position[posIdx].data.kind !== posKind ||
             lsArg.position[posIdx].data.number !== posNumber) {
      lsArg.position[posIdx].posTrained.value = advlibv.POS_NOT_TRAINED;
    }
    lsArg.position[posIdx].data.kind = posKind;
    lsArg.position[posIdx].data.number = posNumber;
    refreshAll();
    setLsArg();
  }
}

function nextIconWizard(_progName, _varName, _typeNode, value) {
  const complete = value === "TRUE",
        nextData = nextIconMessage(complete);
  if (!getDefaultCountPrg() && nextData === null) {
    overPrgCountPopup();
    return;
  }
  const customizeObj = {
    selectBtn: {
      1: {label: "Yes"},
      2: {label: "No"}
    },
    hideCloseBtn: true,
    isHTML: true
  };
  function closeDlgConf(id, _operation) {
    if (id === 'btn1') {
      parent.instructionSetActiveIcon(nextData.nextIcon.line);
    }
  }
  if (nextData.nextIcon.name === markerlibv.MARKSOFFSETEND && !complete) {
    const custom = { selectBtn: { 1: { label: "Yes" }}};
    Object.assign(customizeObj, custom);
  }
  const message = `Setting 'Find Marker' has completed.<br>${nextData.message}`;
  top.IHMIComponents.cf.confirmMessage(window.webpage, message, "wizConf", null, null, top.home.window, closeDlgConf, null, customizeObj);
}

function getRefPos(iconsArray) {
  const parentNum = iconsArray.find(icon => icon.name === markerlibv.MARKSOFFSETEND).line,
        parentLsArgs = markerlibf.create3MarkersoffsetLsArgs(),
        parentInstArgs = markerlibf.create3MarkersoffsetInstArgs(parentLsArgs);
  parentInstArgs.text = editorAPI.getAdinstArg(parentNum);
  return parentLsArgs.refPos.data.number;
}

function getRefPosKind(iconsArray) {
  const parentNum = iconsArray.find(icon => icon.name === markerlibv.MARKSOFFSETEND).line,
        parentLsArgs = markerlibf.create3MarkersoffsetLsArgs(),
        parentInstArgs = markerlibf.create3MarkersoffsetInstArgs(parentLsArgs);
  parentInstArgs.text = editorAPI.getAdinstArg(parentNum);
  return parentLsArgs.refPos.data.kind;
}

function getParentDateTimeArg(iconsArray) {
  const parentNum = iconsArray.find(icon => icon.name === markerlibv.MARKSOFFSETEND).line,
        parentLsArgs = markerlibf.create3MarkersoffsetLsArgs(),
        parentInstArgs = markerlibf.create3MarkersoffsetInstArgs(parentLsArgs);
  parentInstArgs.text = editorAPI.getAdinstArg(parentNum);
  return parentLsArgs.dateTime.text;
}

function getDefaultCountPrg() {
  if (!getHasParentIcon()) return true;
  return markerlibf.getDefaultCountPrg();
}

function getFoundSteps(lineNum, iconsArray) {
  return iconsArray.filter(icon => icon.line < lineNum && [markerlibv.FINDMARKER, markerlibv.MARKSOFFSETSTART].includes(icon.name)).length - 1;
}

function getFindMarkerPosTrained(line) {
  if (editorAPI.getLineTpName(line) !== markerlibv.FINDMARKER) return true;
  const lsArgs2 = markerlibf.createFindMarkerLsArgs(),
        instArgs2 = markerlibf.createFindMarkerInstArgs(lsArgs2);
  instArgs2.text = editorAPI.getAdinstArg(line);
  return markerlibv.POS_INDICES.every(index => lsArgs2.position[index].posTrained.value === advlibv.POS_TRAINED);
}

function overPrgCountPopup() {
  ihmif.alertMessage("Find Marker should be 3.", null, null, window.parent, null);
}

function nextIconMessage(complete) {
  const iconsArray = markerlibf.getIconsArrayBetween(markerlibv.MARKSOFFSETSTART, markerlibv.MARKSOFFSETEND),
        nextIcon = iconsArray.
          find(icon => (icon.name !== markerlibv.MARKSOFFSETSTART && !getFindMarkerPosTrained(icon.line) && getFoundSteps(icon.line, iconsArray) < 3) || icon.name === markerlibv.MARKSOFFSETEND);
  if (iconsArray.filter(icon => icon.name === markerlibv.FINDMARKER).length !== markerlibv.NUM_OF_FINDMARKER && nextIcon.name === markerlibv.MARKSOFFSETEND) {
    return null;
  }

  const message = (nextIcon.name === markerlibv.FINDMARKER) ? "Teach the next Find Marker?" :  !complete ? "Next, execute Reset Ref. Pos. in 3-Marker Runtime Offset." : "Next, set Output Setup in 3-Marker Runtime Offset?";
  return {
    nextIcon:   nextIcon,
    message:    message
  };
}

function getHasParentIcon() {
  if (parent === null) return undefined;
  return parent.getNestPosition(markerlibv.MARKSOFFSETSTART);
}

function setRegArg() {
  const regNum = lsArg.reg.value;
  lsArg.reg.value = getHasParentIcon() ? markerlibv.ERR_REG_UNVISIBLE : regNum === markerlibv.ERR_REG_UNVISIBLE ? -1 : regNum;
}

function refreshAll() {
  let hide, elemTraining, notTrained;
  const trained = [],
        hasParentIcon = getHasParentIcon();
  trained[0] = globalData.camDataTrained;
  advlibf.turnOnOffTrained("divCameraSetup", trained[0]);

  trained[1] = (trained[0] &&
                globalData.visProcTrained &&
                lsArg.vpName.text !== '' &&
                ((lsArg.reg.value !== -1 && hasParentIcon) ||
                 (lsArg.reg.value > 0 && !hasParentIcon)));
  advlibf.turnOnOffTrained("divDetectionSetup", trained[1]);

  trained[2] = (trained[1] &&
                globalData.visProcTrained &&
                markerlibv.POS_INDICES.every(index => lsArg.position[index].posTrained.value === advlibv.POS_TRAINED));
  advlibf.turnOnOffTrained("divSnapPosition", trained[2]);
  advlibf.turnOnOffTrained("divOffsetMotion", trained[2]);

  if (!trained[0]) {
    elemTraining = "divCameraSetup";
  }
  else if (!trained[1]) {
    elemTraining = "divDetectionSetup";
  }
  else if (!trained[2]) {
    elemTraining = "divSnapPosition";
  }
  else {
    elemTraining = "divOffsetMotion";
  }
  ihmif.addClassExclusively(document.getElementById("divContent"), document.getElementById(elemTraining), 'training');

  hide = !globalData.cameraConnect;
  ihmif.turnOnOffClass(document.getElementById("divSetupCamera"), 'hide', hide);

  hide = !trained[0];
  ihmif.turnOnOffClass(document.getElementById("helpFindMarker"), 'hide', hide);

  hide = trained[0] || lsArg.camDataName.text !== "" || lsArg.deviceName.text === "" || (!globalData.deviceConnect && lsArg.deviceName.text !== "");
  ihmif.turnOnOffClass(document.getElementById("helpCameraSetup"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("btnCreateCamData"), 'hide', hide);

  notTrained = lsArg.deviceName.text === "";
  document.getElementById("selCameras").setRequiredMark(notTrained);

  document.getElementById('btnCreateCamData').setRequiredMark(true);

  notTrained = !globalData.camDataTrained;
  document.getElementById('btnOpenCamData').setRequiredMark(notTrained);

  hide = (!trained[0] && lsArg.camDataName.text === "") || !globalData.deviceConnect;
  ihmif.turnOnOffClass(document.getElementById("btnOpenCamData"), 'hide', hide);

  hide = (!trained[0] || globalData.visProcTrained || globalData.numVisProcs !== 0);
  ihmif.turnOnOffClass(document.getElementById("helpDetectionSetup"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("btnCreateVisProc"), 'hide', hide);

  document.getElementById('btnCreateVisProc').setRequiredMark(true);

  notTrained = lsArg.vpName.text === "";
  document.getElementById('selVisProc').setRequiredMark(notTrained);

  notTrained = lsArg.reg.value === advlibv.REG_NOT_SELECTED;
  document.getElementById('selRIndex').setRequiredMark(notTrained);

  hide = (!trained[0] && lsArg.vpName.text === "") || (!globalData.visProcTrained && globalData.numVisProcs === 0);
  ihmif.turnOnOffClass(document.getElementById("divDetectionItems"), 'hide', hide);

  hide = hasParentIcon;
  ihmif.turnOnOffClass(document.getElementById("divErrorRIndex"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("divOffsetMotion"), 'hide', hide);

  hide = (!trained[0] || !trained[1]);
  ihmif.turnOnOffClass(document.getElementById("divSnapPositionArea"), 'hide', hide);

  markerlibv.POS_SUFFIXES.forEach((suffix, index) => {
    hide = (!trained[0] || !trained[1] || !globalData.visProcTrained);
    ihmif.turnOnOffClass(document.getElementById(`robotPosAcc${suffix}`), 'hide', hide);

    hide = (!trained[0] || !trained[1] || !globalData.visProcTrained || ihmif.hasClass(document.getElementById(`accordionPos${suffix}`), 'position-folding-bg-desc'));
    ihmif.turnOnOffClass(document.getElementById(`helpBtnTeach${suffix}`), 'hide', hide);

    document.getElementById(`btnTeach${suffix}`).setRequiredMark(!lsArg.position[index].posTrained.value);

    hide = (!(trained[0] && trained[1] && !trained[2] && globalData.visProcTrained)) || lsArg.position[index].posTrained.value === advlibv.POS_TRAINED;
    ihmif.turnOnOffClass(document.getElementById(`helpSnapPosition${suffix}`), 'hide', hide);
  });

  hide = (!trained[0] || !trained[1] || !trained[2] || !globalData.visProcTrained);
  ihmif.turnOnOffClass(document.getElementById("helpOffsetMove"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("cameraSetupTitle"), 'bold', hide);
  ihmif.turnOnOffClass(document.getElementById("detectionTitle"), 'bold', hide);
  ihmif.turnOnOffClass(document.getElementById("snapPositionTitle"), 'bold', hide);

  markerlibv.POS_SUFFIXES.forEach((suffix, index) => {
    hide = lsArg.position[index].moveType.value === advlibv.POS_MOVE_LINE;
    ihmif.turnOnOffClass(document.getElementById(`speedJointTextBoxArea${suffix}`), 'hide', hide);
    ihmif.turnOnOffClass(document.getElementById(`jointUnit${suffix}`), 'hide', hide);
    hide = !hide;
    ihmif.turnOnOffClass(document.getElementById(`speedLineTextBoxArea${suffix}`), 'hide', hide);
    ihmif.turnOnOffClass(document.getElementById(`lineUnit${suffix}`), 'hide', hide);

    document.getElementById(`selMoveType${suffix}`).refresh([], lsArg.position[index].moveType.text, null, false);
    if (lsArg.position[index].moveType.value === advlibv.POS_MOVE_LINE) {
      document.getElementById(`txtSpeedLine${suffix}`).refresh(lsArg.position[index].posSpeed.text, "1", "3000", false);
    }
    else {
      document.getElementById(`txtSpeedJoint${suffix}`).refresh(lsArg.position[index].posSpeed.text, "0", "100", false);
    }

    document.getElementById(`txtStopTime${suffix}`).refresh(lsArg.stopTimes[index].text, "0.001", "100", false);
  });
  document.getElementById("btnOpenVisProc").refresh(null, null, null, null, !(globalData.visProcExist && globalData.camDataTrained));
  document.getElementById("btnCreateVisProc2").refresh(null, null, null, null, !globalData.camDataTrained);
  document.getElementById('selRIndex').refresh(globalData.regList, lsArg.reg.text, null, false);
  document.getElementById("txtDistTolerance").refresh(lsArg.distTolerance.text, "0.001", "100.000", false);

  ihmif.removeClass(document.body, "hidden");
}

function setLsArg() {
  parent.setInstructionParam(instArgs.text);
}

function selectMoveType(id, _type, value) {
  const posIdx = markerlibv.REG_SUFFIX_FIRST.test(id) ? markerlibv.POS_FIRST : markerlibv.POS_SECOND;
  lsArg.position[posIdx].moveType.text = value;
  lsArg.position[posIdx].posSpeed.text = (lsArg.position[posIdx].moveType.value === advlibv.POS_MOVE_LINE) ? 200 : 100;
  refreshAll();
  setLsArg();
}
function inputMoveSpeed(id, _type, value) {
  const posIdx = markerlibv.REG_SUFFIX_FIRST.test(id.split(".")[0]) ? markerlibv.POS_FIRST : markerlibv.POS_SECOND;
  lsArg.position[posIdx].posSpeed.text = value;
  setLsArg();
}

function selectVisReg(_id, _type, value) {
  lsArg.vpName.text = document.getElementById('selVisProc').getValue();
  lsArg.vreg.text = value;
  lsArg.reg.text = document.getElementById('selRIndex').getValue();
  refreshAll();
  setLsArg();
}
function selectReg(_id, _type, value) {
  lsArg.vpName.text = document.getElementById('selVisProc').getValue();
  lsArg.vreg.text = document.getElementById('selVRIndex').getValue();
  lsArg.reg.text = value;
  refreshAll();
  setLsArg();
}
function selectVisProg(_id, _type, _value) {
  lsArg.vpName.text = document.getElementById('selVisProc').getValue();
  lsArg.vreg.text = document.getElementById('selVRIndex').getValue();
  markerlibv.POS_INDICES.forEach((index) => {
    lsArg.position[index].posTrained.value = advlibv.POS_NOT_TRAINED;
  });
  globalData.visProcExist = globalData.visProgList.find(props => props.name === lsArg.vpName.text);
  if (globalData.visProcExist) {
    globalData.visProcTrained = globalData.visProcExist.is_trained;
    lsArg.camDataName.text = globalData.visProcExist.camdata_name;
    globalData.camDataTrained = globalData.camDataList.indexOf(globalData.visProcExist.camdata_name) >= 0;
  }

  refreshAll();
  setLsArg();
}
async function selectCamera(_id, _type, _value) {
  lsArg.deviceName.text = document.getElementById('selCameras').getValue();
  lsArg.camDataName.text = "";
  globalData.visProcTrained = false;
  lsArg.vpName.text = "";
  lsArg.vreg.value = 1;
  markerlibv.POS_INDICES.forEach((index) => {
    lsArg.position[index].posTrained.value = advlibv.POS_NOT_TRAINED;
  });
  document.getElementById("btnOpenCamData").refresh(null, null, null, null, false);

  await getAllInformation();

  refreshAll();
  setLsArg();
}

function inputDistTolerance(_id, _type, value) {
  lsArg.distTolerance.text = value;
  refreshAll();
  setLsArg();
}

function inputStopTime(id, _type, value) {
  const posIdx = markerlibv.REG_SUFFIX_FIRST.test(id.split(".")[0]) ? markerlibv.POS_FIRST : markerlibv.POS_SECOND;
  lsArg.stopTimes[posIdx].text = value;
  refreshAll();
  setLsArg();
}

function createVisData(dataName, camName, deviceInfo) {// create new vision program
  lsArg.vpName.text = dataName.toUpperCase();
  const params = { ofs_type: advlibv.GAZE_LINE, set_ofs_frm_method: 0, gpm_dof_angle_enabled: true, gpm_dof_scale_enabled: true, gpm_dof_aspect_enabled: true, gpm_dof_scale_low: 0.8, gpm_dof_scale_high: 1.2, gpm_dof_aspect_low: 0.85 };
  advlibf.createVisData(dataName, camName, deviceInfo, params)
    .then(() => {
      globalData.prgNameCnt = 0;
      markerlibv.POS_INDICES.forEach((index) => {
        lsArg.position[index].posTrained.value = advlibv.POS_NOT_TRAINED;
      });
      setLsArg();
      advlibf.jumpVisionPage(dataName);
    })
    .catch(status => {
      if (advlibv.DAT_E_EXISTS.test(status)) {
        dataName = dataName.replace(/_\d+$/, "");
        globalData.prgNameCnt++;
        createVisData(`${dataName}_${globalData.prgNameCnt}`, lsArg.camDataName.text, deviceInfo);
      }
      else {
        advlibf.popupAlert(status);
      }
    });
}

function btnCreateCamData(_id, _type, _value) {
  const dataName = advlibf.getDataName("CAM_", lsArg.deviceName.text),
        setVisParams = { calib_type: advlibv.TTY_CCGP, on_robot: true, ctlr_name: "", group_num: 1, app_grp_num: 1, app_frm_num: 0 };
  advlibf.createJumpCamData(dataName, globalData.deviceInfo, setVisParams)
    .then(() => {
      lsArg.camDataName.text = dataName;
      setLsArg();
    });
}
function btnCreateVisData(_id, _type, _value) {
  const dataName = advlibf.getDataName("VP_", lsArg.deviceName.text);
  createVisData(dataName, lsArg.camDataName.text, globalData.deviceInfo);
}
function openVisProg(_id, _type, _value) {
  const prgName = document.getElementById("selVisProc").getValue();
  if (prgName === "") {
    ihmif.alertMessage("Please select program.", "Error", null, window.parent, null);
    return;
  }
  advlibf.jumpVisionPage(prgName);
}
function openCamData(_id, _type, _value) {
  setLsArg();
  advlibf.jumpVisionPage(lsArg.camDataName.text);
}

// eslint-disable-next-line no-unused-vars
function openHelp(hlpCode) {
  const helps = [
    ["/findm_hlp_markershape.htm", { width: "640px", height: "660px" }],
    ["/hlp_3marker.htm?failed_only=true", {}],
    ["/findm_hlp_disttolerance.htm", { width: "500px", height: "auto" }]
  ];
  advlibf.openHelp(window, advlibv.HELP_PATH + helps[hlpCode][0], helps[hlpCode][1]);
}

window.onload = function () {
  document.getElementById('btnCreateCamData').setCallback(btnCreateCamData);
  document.getElementById('btnOpenCamData').setCallback(openCamData);
  document.getElementById('btnCreateVisProc').setCallback(btnCreateVisData);
  document.getElementById('btnOpenVisProc').setCallback(openVisProg);
  document.getElementById('btnCreateVisProc2').setCallback(btnCreateVisData);
  document.getElementById('selCameras').setCallback(selectCamera);
  document.getElementById('selVisProc').setCallback(selectVisProg);
  document.getElementById('selVRIndex').setCallback(selectVisReg);
  document.getElementById('selRIndex').setCallback(selectReg);
  document.getElementById("txtDistTolerance").setCallback(inputDistTolerance);
  document.getElementById('accordionOutput').setCallback((id, _action) => advlibf.accordionOpenClose(id, ''));
  markerlibv.POS_SUFFIXES.forEach((suffix) => {
    document.getElementById(`selMoveType${suffix}`).setCallback(selectMoveType);
    document.getElementById(`txtSpeedLine${suffix}`).setCallback(inputMoveSpeed);
    document.getElementById(`txtSpeedJoint${suffix}`).setCallback(inputMoveSpeed);
    document.getElementById(`btnTeach${suffix}`).setCallback((_id, _action) => advlibf.pushTouchUp(`robotPos${suffix}`));
    document.getElementById(`accordionPos${suffix}`).setCallback((id, _action) => advlibf.accordionOpenClose(id, `helpBtnTeach${suffix}`));
    document.getElementById(`txtStopTime${suffix}`).setCallback(inputStopTime);
  });
};
