// import from vis_advlib.js
/*global advlib*/
const advlibf = advlib.funcs;
const advlibv = advlib.vars;

// import from vis_markerlib.js
/*global markerlib*/
const markerlibf = markerlib.funcs;
const markerlibv = markerlib.vars;

const POS_COMMENT = "VISION REF POS";

const globalData = {
  allFindMarkersTrained: false,
  posRegOptions: []
};

const lsArg = markerlibf.create3MarkersoffsetLsArgs();
const instArgs = markerlibf.create3MarkersoffsetInstArgs(lsArg);

const ihmif = top.IHMIComponents.cf;
const editorAPI = parent.editorAPI.funcs;

// eslint-disable-next-line no-unused-vars
function dropAdvInst(argStr) {
  parent.bktAddProgFlag = true;
  const prgInstfind = "CALL -INST_FINDMARKER(1,&#39;...&#39;,&#39;...&#39;,1,1,1.5,P[N],0,0,200,P[N],0,0,200,&#39;...&#39;,&#39;...&#39;)";
  if (argStr.length === 0) {
    return false;
  }
  instArgs.text = argStr[1];
  lsArg.refPos.number.value = lsArg.refPos.data.number;
  lsArg.dateTime.text = Date.now().toString();

  const addPrg = [];
  addPrg[0] = prgInstfind;
  addPrg[1] = prgInstfind;
  addPrg[2] = prgInstfind;
  const dropNum = 1,
        dropEndNum = 5;

  parent.addInstructionBracket(addPrg, dropNum, dropEndNum);
  writePosComment(lsArg.refPos.number.value, true);
}

function setFirstArg(argStr) {
  if (argStr.length === 0) {
    return false;
  }
  instArgs.text = argStr[1];
  lsArg.version.value = 2;
  return true;
}

function setLsArgWithoutUndoHistory() {
  editorAPI.setBracketArgWithCB([lsArg.version.text, instArgs.text], "", "", true);
}

function setLsArg() {
  editorAPI.setBracketArg([lsArg.version.text, instArgs.text]);
}

function setLsArgTemp() {
  parent.setEndInstructionParam(instArgs.text);
  parent.setInstructionParamTemp(lsArg.version.text);
}

// eslint-disable-next-line no-unused-vars
async function dispAdvInstData(argStr) {
  const success = setFirstArg(argStr);
  if (!success) return false;

  await getAllInformation().catch(status => advlibf.popupAlert(status));
  const completeData = await promiseRpcmcGetVar("irv3mosetref", "complete");
  if (completeData === "TRUE") {
    const dateTime = await promiseRpcmcGetVar("irv3mosetref", "comp_datetime");
    if (dateTime === lsArg.dateTime.text) refPosTrainedSetValue();
  }
  else if (markerlibf.getDefaultCountPrg()) {
    advlibf.initPositionComponent("hiddenPosition", lsArg.refPos.number.value, lsArg.refPos.kind.value, null, checkPosTrained);
  }
  if (!markerlibf.getDefaultCountPrg()) overPrgCountPopup();
  return true;
}

function promiseRpcmcGetVar(progName, VarName) {
  return new Promise((resolve) => {
    top.rpcmc_getVar(progName, VarName, (_progName, _varName, _typeName, value) => {
      resolve(value);
    });
  });
}

async function getAllInformation() {
  globalData.allFindMarkersTrained = getAllFindMarkerPosTrained();
  const regOptions = await advlibf.createRegOptions();
  document.getElementById('selVRIndex').refresh(regOptions.vreg, lsArg.vreg.value, null, false);
  document.getElementById('selRIndex').refresh(regOptions.nreg, lsArg.reg.value, null, false);
  globalData.posRegOptions = await advlibf.createPosRegOptions();
  refreshAll();
}

function getAllFindMarkerPosTrained() {
  const iconsArray = markerlibf.getIconsArrayBetween(markerlibv.MARKSOFFSETSTART, markerlibv.MARKSOFFSETEND),
        iconsFindMarker = iconsArray.filter(icon => icon.name === markerlibv.FINDMARKER);
  if (iconsFindMarker.length !== markerlibv.NUM_OF_FINDMARKER) return false;

  const childLsArgs = markerlibf.createFindMarkerLsArgs(),
        childInstArgs = markerlibf.createFindMarkerInstArgs(childLsArgs);
  for (let num = 0; num < markerlibv.NUM_OF_FINDMARKER; num++) {
    childInstArgs.text = editorAPI.getAdinstArg(iconsFindMarker[num].line);
    if (!markerlibv.POS_INDICES.every(index => childLsArgs.position[index].posTrained.value === advlibv.POS_TRAINED)) {
      return false;
    }
  }
  return true;
}
function getFindMarkerDateTime() {
  const iconsArray = markerlibf.getIconsArrayBetween(markerlibv.MARKSOFFSETSTART, markerlibv.MARKSOFFSETEND),
        iconsFindMarker = iconsArray.filter(icon => icon.name === markerlibv.FINDMARKER),
        dateTime = [],
        childLsArgs = markerlibf.createFindMarkerLsArgs(),
        childInstArgs = markerlibf.createFindMarkerInstArgs(childLsArgs);
  for (let num = 0; num < markerlibv.NUM_OF_FINDMARKER; num++) {
    childInstArgs.text = editorAPI.getAdinstArg(iconsFindMarker[num].line);
    dateTime[num] = childLsArgs.dateTime.text;
  }
  return dateTime;
}
function setFindMarkerDateTime() {
  const dateTime = getFindMarkerDateTime();
  if (markerlibv.DATETIME_INDICES.every(index => dateTime[index] !== "")) {
    markerlibv.DATETIME_INDICES.forEach(index => lsArg.findMarkerDateTime[index].text = dateTime[index]);
  }
}
function checkPosTrained() {
  const dateTime = getFindMarkerDateTime();
  lsArg.tppName.text = "";
  if (markerlibv.DATETIME_INDICES.every(index => dateTime[index] !== "")) {
    const posTrained = markerlibv.DATETIME_INDICES.every(index => lsArg.findMarkerDateTime[index].text === dateTime[index]);
    lsArg.refPosValid.value = !posTrained && globalData.allFindMarkersTrained ? true : false;
    if (lsArg.refPosValid.value) startVarMonitor();
    refreshAll();
  }
  setLsArgWithoutUndoHistory();
}
function overPrgCountPopup() {
  ihmif.alertMessage("Trova target deve essere 3.", null, null, window.parent, null);
}

function selectReg(_id, _type, value) {
  lsArg.vreg.text = document.getElementById('selVRIndex').getValue();
  lsArg.reg.text = value;
  refreshAll();
  setLsArg();
}

function selectVisReg(_id, _type, value) {
  lsArg.vreg.text = value;
  lsArg.reg.text = document.getElementById('selRIndex').getValue();
  refreshAll();
  setLsArg();
}

function toggleRefPos(_id, _operation, checked) {
  if (lsArg.refPos.trained.value) {
    advlibf.confirmMessage("La posizione di riferimento attuale viene cancellata.<br>Si conferma di voler cambiare la destinazione di memorizzazione della posizione di riferimento?", "refPosChange", [{
      label: "S",
      callback: () => {
        changePosType(checked);
        setLsArg();
      },
      finallyCallback: () => refreshAll()
    }, {
      label: "No",
    }]);
  }
  else {
    changePosType(checked);
    setLsArg();
    refreshAll();
  }
}
function changePosType(checked) {
  lsArg.refPos.data.argText = checked ? "PR[...]" : editorAPI.getPosNumber('P[N]');
  lsArg.refPos.number.value = lsArg.refPos.data.number;
  lsArg.refPos.kind.value = lsArg.refPos.data.kind;
  lsArg.refPos.trained.value = false;
  if (lsArg.refPos.data.kind === advlibv.POS_KIND_POSNUM) {
    const tppName = editorAPI.getCurrProg();
    advlibf.initPositionData(tppName, lsArg.refPos.data.number, lsArg.refPos.data.kind);
  }
}

async function selectRefPos(_id, _type, value) {
  if (await advlibf.isPosDataInit(value)) {
    changeRefPosNum(value);
    lsArg.refPos.trained.value = true;
    refreshAll();
    setLsArg();
  }
  else {
    advlibf.confirmMessage("Il PR selezionato viene inizializzato. Si conferma di voler inizializzare?", "posRegNotTrained", [{
      label: "S",
      callback: () => {
        changeRefPosNum(value);
        lsArg.refPos.trained.value = false;
        const tppName = editorAPI.getCurrProg();
        advlibf.initPositionData(tppName, lsArg.refPos.data.number, lsArg.refPos.data.kind);
      },
      finallyCallback: () => {
        setLsArg();
        refreshAll();
      }
    }, {
      label: "No",
    }]);
  }
  function changeRefPosNum(value) {
    lsArg.refPos.data.number = value;
    lsArg.refPos.number.value = value;
  }
}

function changeRefPosStatus(_elem, _value) {
  stopVarMonitor();
  lsArg.refPosValid.value = true;
  lsArg.tppName.text = editorAPI.getCurrProg();
  const lineNum = parent.instructionGetCurrentLineNum();
  editorAPI.setBracketArgWithCB([lsArg.version.text, instArgs.text], send3MarkersProgram, lineNum, true);
}

function send3MarkersProgram(_callbackState, lineNum) {
  editorAPI.stopAutoRefresh();
  markerlibf.execute3MarkersProgram(7, { line_num: lineNum, tpp_name: lsArg.tppName.text })
    .then(() => {
      const custmObj = {
        header: "",
        designpattern: "mouse",
        callerWindowObj: window,
        width: "500px",
        appendArg: lineNum,
        hideCloseBtn: true
      };
      ihmif.appendPopupFrm("/frh/vision/crxvision/vis_3markersreset.htm", closeRefPosPopup, window.parent, custmObj);
    });
}

function closeRefPosPopup(removeCbArg) {
  const res = removeCbArg;
  editorAPI.restartAutoRefresh();
  if (!res.ref_flag) {
    refPosTrainedSetValue();
  }
  else {
    if (res.status !== "") advlibf.popupAlert(res.status);
    checkPosTrained();
  }
}
async function cbRefPosStatus(_event, _progName, varName, _typeCode, valStr) {
  if (varName !== "complete".toUpperCase()) return;
  if (valStr === "TRUE") {
    const dateTime = await promiseRpcmcGetVar("irv3mosetref", "comp_datetime");
    if (dateTime === lsArg.dateTime.text) refPosTrainedSetValue();
  } 
}

function refPosTrainedSetValue() {
  stopVarMonitor();
  top.rpcmc_setVar("irv3mosetref", "complete", 0);
  top.rpcmc_setVar("irv3mosetref", "comp_datetime", "");
  top.rpcmc_setVar("irv3mosetref", "curr_datetime", "");
  if (lsArg.refPosValid.value) {
    ihmif.alertMessage("'Ripristinare la Pos. di riferimento' ? completato.", null, null, window.parent, null);
    lsArg.refPosValid.value = false;
  }
  lsArg.refPos.trained.value = true;
  lsArg.tppName.text = "";
  refreshAll();
  setFindMarkerDateTime();
  //Consider the case where the position data comment is deleted by another instruction
  writePosComment(lsArg.refPos.number.value, false);
  setLsArg();
}

function writePosComment(posNum, dropInit) {
  const initArgs = {
    initCompleteCallback: function (args, posInfo) {
      const posElm = document.getElementById("hiddenPosition"),
            posData = posElm.getPosition(posInfo.number);
      posData.comment = POS_COMMENT;
      posElm.postPosition(posData);
      if (args.initCompleteArgs.dropInit) {
        startNextTargetWizard();
        setLsArgTemp();
      }
    },
    initCompleteArgs:     { dropInit: dropInit },
    disableComment:       false,
    number:               posNum
  };
  document.getElementById("hiddenPosition").refresh(initArgs);
}

function startVarMonitor() {
  top.rpcmc_startVarMonitor("irv3mosetref", "complete", 100);
  top.jQuery.varlis.bind("VarEvent", null, cbRefPosStatus);
}
function stopVarMonitor() {
  top.rpcmc_stopVarMonitor("irv3mosetref", "complete", 100);
  top.jQuery.varlis.unbind("VarEvent", cbRefPosStatus);
}

// eslint-disable-next-line no-unused-vars
function openHelp(num) {
  switch (num) {
    case 0:
      ihmif.alertMessage("0 ? l&#39;output in caso di successo. In caso di errore, l&#39;output ? diverso da 0.", null, null, window.parent, { callerWindowObj: window, isHTML: true});
      break;
    case 1:
      advlibf.openHelp(window, `${ advlibv.HELP_PATH }/hlp_3marker.htm`, { width: "90%" });
      break;
  }
}

function refreshAll() {
  let hide, elemTraining;
  const trained = [];

  trained[0] = lsArg.reg.value !== advlibv.REG_NOT_SELECTED;
  const posTrained = lsArg.refPos.number.value === advlibv.POS_NOT_TRAINED;
  advlibf.turnOnOffTrained("divSetup", trained[0] && !posTrained);

  if (!trained[0] || posTrained) {
    elemTraining = "divSetup";
  }
  else {
    elemTraining = "divRefPosStatus";
  }
  ihmif.addClassExclusively(document.getElementById("divContent"), document.getElementById(elemTraining), 'training');

  document.getElementById('selRIndex').setRequiredMark(!trained[0]);
  document.getElementById("tglRefPosIndex").refresh(lsArg.refPos.kind.value === advlibv.POS_KIND_POSREG);

  hide = lsArg.refPos.data.kind === advlibv.POS_KIND_POSNUM;
  const selRefPosIndexElem = document.getElementById('selRefPosIndex');
  selRefPosIndexElem.setRequiredMark(posTrained);
  selRefPosIndexElem.refresh(globalData.posRegOptions, lsArg.refPos.number.value, null, hide);
  ihmif.turnOnOffClass(selRefPosIndexElem, "hide", hide);
  advlibf.turnOnOffTrained('divRefPosStatus', lsArg.refPos.trained.value);

  hide = (!trained[0] || posTrained);
  ihmif.turnOnOffClass(document.getElementById("divRefPosStatusArea"), 'hide', hide);

  trained[1] = lsArg.refPos.trained.value;
  hide = globalData.allFindMarkersTrained;
  ihmif.turnOnOffClass(document.getElementById("resetRefPosStatusArea"), 'hide', !hide);
  ihmif.turnOnOffClass(document.getElementById('notTrainOffset'), 'hide', hide);
  hide = !lsArg.refPosValid.value || !globalData.allFindMarkersTrained;
  ihmif.turnOnOffClass(document.getElementById("enableRefPos"), 'hide', hide);
  hide = !trained[1] || lsArg.refPosValid.value || !globalData.allFindMarkersTrained;
  ihmif.turnOnOffClass(document.getElementById("trainOffset"), 'hide', hide);
  hide = trained[1] || lsArg.refPosValid.value || !globalData.allFindMarkersTrained;
  ihmif.turnOnOffClass(document.getElementById("initRefposData"), 'hide', hide);
  ihmif.removeClass(document.body, "hidden");
}

function startNextTargetWizard() {
  advlibf.confirmMessage("Innanzitutto, registrare 3 Trova target in Compensazione in funzione della posizione dei 3 target.\nIniziare a registrareTrova target?", "wizConf", [{
    label: "S",
    callback: () => {
      const lineNum = parent.instructionGetCurrentLineNum();
      parent.instructionSetActiveIcon(lineNum + 1);
    },
    finallyCallback: () => parent.setInstructionDropEnd()
  }, {
    label: "No",
  }], {
    hideCloseBtn: true
  });
}

window.onload = function () {
  document.getElementById('selRIndex').setCallback(selectReg);
  document.getElementById('selVRIndex').setCallback(selectVisReg);
  document.getElementById('tglRefPosIndex').setCallback(toggleRefPos);
  document.getElementById('selRefPosIndex').setCallback(selectRefPos);
  document.getElementById('resetRefPosStatus').setCallback(changeRefPosStatus);
  document.getElementById('accordionOutput').setCallback((id, _action) => advlibf.accordionOpenClose(id, ''));
  document.getElementById('accordionResetRefPos').setCallback((id, _action) => advlibf.accordionOpenClose(id, ''));
};

ihmif.addEventHandler(window, "pagehide", stopVarMonitor);
