/**********************************************************************
 * Selective Compliance Assembly Robot Arm robot program.
 * Tree button script
 *
 * Created : 2018/09/27 FSI
 * Modified: 
 *
*/

// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
*/

/*
 * jQuery UI Widget
 * http://jqueryui.com
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
*/

var ua = navigator.userAgent;

// FSI 20180927 Event handler when treebtn is clicked
// FSI 20181003 Also added when window is blurred
$(function () {

  // Prevent zoom when double-tap at tablet.
  $('#trbtn').on('touchend click', function (e) {
    e.preventDefault();
    if ($("#treemod", parent.document).is(":hidden")) {
      $('#t35', parent.document).css('display', 'block');
      $('#treestat', parent.document).css('display', 'none');
      $('#treemod', parent.document).css({
        width: '270px',
        display: 'block',
        position: 'absolute'
      });
      if (ua.indexOf('Trident') > 0) {
        // FSI 20190311 display tablet UI for IE11
        var table_flag = true;
        var elem = $('#treemod', parent.document);

        elem.css('margin', '0px');
        elem.contents().find('html').css('overflow', 'hidden');

        while (table_flag) {
          elem = elem.parent();
          if (elem.get(0).tagName == 'TR') {
            elem.css('height', '100%');
          } else if (elem.get(0).tagName == 'TABLE') {
            table_flag = false;
            elem.css('height', '100%');
          }
        }
      }
      top.treemod.setTreePos();
      top.treemod.calcMargin();
      window.parent.tree_resize();
      focus_treemod();
    } else {	// exist tree menu
      hide_treemenu();
    }
  });
});

// FSI 20190806 focuses the treemod
function focus_treemod() {
  top.treemod.focus();
}
// FSI 20190806 hides the treemod
function hide_treemenu() {
  $('#t35', parent.document).css('display', 'none');
  $('#treemod', parent.document).css('display', 'none');
  if (ua.indexOf('iPad') > 0) {
    $('#mainfrm', parent.document).css('margin-left', '0px');
    $('#funckeys', parent.document).css('margin-left', '0px');
    $('#tpkeys', parent.document).css('margin-left', '0px');
  }
}
