var currentLang = null; // Current language
// Language define
var LANG_JP = 'jp';
var LANG_KN = 'kn';

// For MPG icon
var MPG_COORD = {
  JOG: 0,
  WORLD: 2,
  TOOL: 3,
  USER: 4
};
var MPG_DIR = ['X', 'Y', 'Z', 'W', 'P', 'R', 'E1', 'E2', 'E3'];

var g_machine_lock = {
  'g1' : false,
  'g2' : false,
  'g3' : false,
  'g4' : false,
  'g5' : false,
  'g6' : false,
  'g7' : false,
  'g8' : false
};

// for MANOP_DIIDX true
var isManopOn = false;

/**
 * Get lang_suffix from system variable
 */
function setCurLangForSts() {
  top.rpcmc_getVar(top.SYSNAME_C, '$DICT_CONFIG.$LANG_SUFFIX', curLangCbForSts, null);
}

/**
 * Current Language Callback
 * (IN) progname...SYSNAME_C,NUMREG_C
 *      varname...System Variable Name
 *      typecode...Type Code(Not Used)
 *      value...Return Value
 *      callback...CallBack(callbackarg1)
 *      cbarg2...callbackarg2(Not Used)
 */
function curLangCbForSts(progname, varname, typecode, value, callback, cbarg2) {
  var tempLang = '';
  tempLang = value.slice(0);
  currentLang = tempLang;
  if (currentLang == LANG_KN) {
    currentLang = LANG_JP;
  }
  console.log("[Common API] Current Language:" + currentLang);
}

/**
 * Get Current Language
 */
function getCurLangForSts() {
  return currentLang;
}

var ROUND = {
  CEIL: 0,
  FLOOR: 1
};
function getRoundWidth(id, round) {
  var element = document.getElementById(id);
  var style = window.getComputedStyle(element,'');
  var bodyWidth = style.getPropertyValue('width');
  var marginLWidth = style.getPropertyValue('margin-left');
  var marginRWidth = style.getPropertyValue('margin-right');
  var numWidth = Number(bodyWidth.slice(0, -2)) + Number(marginLWidth.slice(0, -2)) + Number(marginRWidth.slice(0, -2));
  var roundWidth = (round == ROUND.CEIL) ? Math.ceil(numWidth) : Math.floor(numWidth);
  return roundWidth;
}

function initSize() {
  var size = $("#stat_container").width() - (getRoundWidth("icoArea", ROUND.CEIL) + $("#backBtn").outerWidth() + $("#forwardBtn").outerWidth()); // - $("#eventIcon").width()
  size = (size > $("#selectprog").width()) ? size : $("#selectprog").width(); // The width of the "#state" is more than the width of the "#selectprog".
  var lineNumW = getRoundWidth("lineNum", ROUND.CEIL);
  size = (size > lineNumW) ? size : lineNumW; // The width of the "#state" is more than the width of the "#lineNum".
  //Change the text size when the "#progInfoArea" width changes.
  var progStatTxt = document.getElementById('progStatTxt');
  var lineNum = document.getElementById('lineNum');
  setTimeout(function() {
    var fontSize = adjustProgStatFontSize();
    progStatTxt.style.fontSize = fontSize;
    lineNum.style.fontSize = fontSize;
  }, 0);
  // for IE
  $("#state").css('min-width', '');
  $("#state").css('width', size);
  setProgName(top.currentProgInfo.currentProgName);
}

function adjustProgStatFontSize() {
  var progInfoArea = $('.progInfoArea').width();
  if (progInfoArea <= 135) {  //Define the minimum width as 135px
    return "15px";
  } else if (progInfoArea <= 168) { //Define the maximum width as 168px
    return "18px";
  }
  return "22px";
}

// get program status
function getPrgState() {
  top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', prgStateCB, null);
}
// get program status call back
function prgStateCB(progname, varname, typecode, value, callback, cbarg2) {
  setProgStatIcon('$ALM_IF.$CURR_STAT', value);
  getStepMode();
}

// change program name 
function chgProgName(sysName, sysValueName, noUse, progName) {
  if ((progName.length <= 0) && (progName != "")) {
    return;
  }
  top.currentProgInfo.currentProgName = progName; // irprog_tabfunc
  initSize();
}

// set program name 
function setProgName(progName) {
  $("#prgName").css('visibility', 'hidden');
  var nameArea = document.getElementById("prgName");
  var tempProg = progName;
  nameArea.innerHTML = tempProg;

  var prgNameCeilWidth = getRoundWidth("prgName", ROUND.CEIL);

  if (prgNameCeilWidth > ($("#state").width() - $("#selectprog").outerWidth())) {
    while ((prgNameCeilWidth > ($("#state").width() - $("#selectprog").outerWidth())) && (tempProg.length > 5)) {
      tempProg = tempProg.slice(0, (tempProg.length - 2)) + ">";
      nameArea.innerHTML = tempProg;
      prgNameCeilWidth = getRoundWidth("prgName", ROUND.CEIL);
    }
    var size = prgNameCeilWidth + $("#selectprog").width();
    var lineNumCeilWidth = getRoundWidth("lineNum", ROUND.CEIL);
    size = (size > lineNumCeilWidth) ? size : lineNumCeilWidth;
    $("#state").css('width', size);
    // for IE
    $("#state").css('min-width', size);
  }
  $("#prgName").css('visibility', '');
}

// running program line number monitor

function setLineNum(num, lang) {
  setLineNumHeight();
  var numArea = document.getElementById("lineNum");
  if (lang === undefined) {
    // noaction
  } else if (lang === "kn" || lang === "jp") {
    numArea.innerHTML = num + " 行";
  } else {
    numArea.innerHTML = "Line " + num;
  }
  initSize();
}

function setProgStatText(statStr) {
  setProgStatHeight();
  var statArea = document.getElementById("progStatTxt");
  statArea.innerHTML = statStr.trim() == "" ? "   " : statStr.trim();
  initSize();
}

function statVarEvent(event, progName, varName, typeCode, valStr) {
  if (varName === '$ALM_IF.$CURR_PROG') {
    chgProgName(null, null, null, valStr); // selected TP program
  } else if (varName === '$ALM_IF.$CURR_LINE') {
    setLineNum(valStr, getCurLangForSts()); // program action line
  } else if (varName === '$ALM_IF.$CURR_STAT') {
    setProgStatText(valStr);
    setProgStatIcon(varName, valStr);  // program action state
  } else if (varName === '$ALM_IF.$TASK_NUM') {
    if (Number(valStr) == 1) setProgStatIcon(varName, valStr);  // program action state
  } else if (varName.indexOf("$MCR_GRP[") >= 0 && varName.indexOf("].$MACHINELOCK") >= 0) {
    g_machine_lock["g" + Number(varName.substring("$MCR_GRP[".length, "$MCR_GRP[".length + 1))] = valStr;
    setTcycMode();  // simulation state
  } else if (varName === "$MCR.$GENOVERRIDE") {
    setORStr("value", valStr);
  } else if (varName === "$MCR.$JOG_FINE") {
    setORStr("fine", valStr);
  } else if (varName === "$MCR.$JOG_V_FINE") {
    setORStr("vFine", valStr);
  } else if (varName === "$MCR.$OVR_ZERO") {
    setORStr("zero", valStr);
  } else if ((top.g_order.s507 || top.g_order.s508 || top.g_order.s553) && (varName === "$MPG_STAT.$DIR_AXS")) {
    setMpgAxsNum(valStr);
    setDispMpgIcon();
  } else if ((top.g_order.s507 || top.g_order.s508 || top.g_order.s553) && (varName === "$JCR_GRP[" + top.pnlarea.getCurGrp() + "].$JOG_COORD")) {
    setJogCoordNum(valStr);
    setDispMpgIcon();
  } else if ((top.g_order.s507 || top.g_order.s508 || top.g_order.s553) && (1 <= getMpgAxsNum()) && (getMpgAxsNum() <= 9) && (varName === "$JCR.$JOG_GP")) {
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$JCR_GRP[grp].$JOG_COORD', getJogCoordCB);
  } else if (varName.indexOf("$JINC") >= 0) {
    getStatJincCB(varName, valStr);
  } else if (varName === "$DCSS_CLLB2[1].$MANOP_DIIDX") {
    getManopDIVal(valStr);
  }
}

var overRideStat = {
  "value" : "0",
  "fine" : "FALSE",
  "vFine" : "FALSE",
  "zero" : "FALSE"
};

var override_text;
var font_siz;

function setORStr(type, value) {
  font_siz = tabtpOvrStr["PSIZE"];
  overRideStat[type] = value;
  if (overRideStat["value"] === "1") {
    if (overRideStat["zero"] === "TRUE") {
      override_text = "0%";
    } else if (overRideStat["vFine"] === "TRUE") {
      font_siz = tabtpOvrStr["SSIZE"];
      override_text = tabtpOvrStr["VF"];
    } else if (overRideStat["fine"] === "TRUE") {
      font_siz = tabtpOvrStr["SSIZE"];
      override_text = tabtpOvrStr["F"];
    } else {
      override_text = overRideStat["value"] + "%";
    }
  } else {
    override_text = overRideStat["value"] + "%";
  }

  $('#ovrArea').removeClass('ovrPerVal');
  if (override_text.indexOf("%") >= 0) {
    $('#ovrArea').addClass('ovrPerVal');
  }
  if (type === "fine" && value === "FALSE"){
    setTimeout(function() {
      $("#ovrValue").css({ 'font-size': font_siz });
      $("#ovrValue").html(override_text);
    }, 100);
  } else {
    $("#ovrValue").css({ 'font-size': font_siz });
    $("#ovrValue").html(override_text);

    // Adjust margin-top of #ovrArea only when incremental jog is enabled and at first startup
    if ((0 < $(".dispJincVal").length) && ($(".confirmedFlag").length < 1)) {
      $("#ovrArea").addClass('confirmedFlag');
      var ovrVal = $("#ovrValue").height();
      var numeratorHeight = 30;  // Upper limit of height of #ovrValue
      if (ovrVal < numeratorHeight) {
        var marginTop = numeratorHeight - ovrVal;
        $("#ovrArea").css('margin-top', marginTop);
      }
    }
  }
}

function setTcycMode(){
  for (var i = 1; i <= top.irprogapi.getGroupCount(); i++){
    if (g_machine_lock["g" + i] === "FALSE"){
      setProgStatIcon("$MCR_GRP[1].$MACHINELOCK", "FALSE");
      return;
    }
  }
  setProgStatIcon("$MCR_GRP[1].$MACHINELOCK", "TRUE");
}

function absorbEvent_(event) {
  var e = event || window.event;
  e.preventDefault && e.preventDefault();
  e.stopPropagation && e.stopPropagation();
  e.cancelBubble = true;
  e.returnValue = false;
  return false;
}
function preventLongPressMenu(node) {
  node.ontouchstart = absorbEvent_;
  node.ontouchmove = absorbEvent_;
  node.ontouchend = absorbEvent_;
  node.ontouchcancel = absorbEvent_;
}

function initLayout() {
  getStatIcon();
  if (!top.g_cgtpmain) {
    // Send "cgtpmain is loaded" external request to GUID task.
    // This is only done once per connection.
    top.g_cgtpmain = true;
    top.rpcmc_tpextreq(0, tp_cgtpmain_done_c);
  }
  else {
    // vt220 window size change
    top.rpcmc_tpextreq2(0, tp_reconfig_c);
  }

  initSize();
  setCurLangForSts();
  getPrgState();
  top.rpcmc_iovalrd(top.IOTYPE_SI, 8, firstCurrentModeCallback);

  top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', chgProgName);
  
  document.oncontextmenu = function () { return false; };
  $("img").css({
    'pointer-events': 'none',
    '-webkit-touch-callout': 'none',
    '-webkit-user-select': 'none',
    '-moz-touch-callout': 'none',
    '-moz-user-select': 'none',
    'touch-callout': 'none',
    'user-select': 'none',
  });
  $('img').attr('ondragstart', 'return false;');
  var imgElements = document.getElementsByClassName("preventLongPress");
  for (var i = 0; i < imgElements.length; i++) {
    preventLongPressMenu(imgElements[i]);
  }
  setTimeout(function () { getStatusOnLoad(); }, 1000);
}

// enable button click event
$("#tpEnable").on('click touchend', function (event) {
  if(event.type.indexOf('touch') >= 0){
    event.preventDefault();
  }

  if ($(".disableTpkey").length > 0) {
    top.openCmpAlert(top.window, 'msgpopup_tpswitchalarm', top.irpDlgRes["msgpopup_tpswitchalarm"]);
    return;
  }

  var src = $("#tpEnableImg").attr('src'); 
  if (src === "tp_on.png") {
    $("#tpEnableImg").attr('src', "tp_off.png");
    top.sendKey("Deadman-L", 0);
  } else if (src === "tp_off.png") {
    $("#tpEnableImg").attr('src', "tp_on.png");
    top.sendKey("Enable", 1);
  } else {
    $("#tpEnableImg").attr('src', "tp_off.png");
    top.sendKey("Deadman-L", 0);
  }
  if (top.g_irprog) {
    // Prevent tp-button bashing.
    $("#tpEnable").css({ "pointer-events": "none" });
    setTimeout(function () {
      $("#tpEnable").css({ "pointer-events": "auto" });
    }, 500);
  }
});

function setDisableTPEnbkey(value) {
  var diStat = (value == 1) ? true :false;
  $("#tpEnable").removeClass("disableTpkey");
  if(diStat && $("#moveModeImg").attr('src') == "mode_auto.png") {
    $("#tpEnable").addClass("disableTpkey");
    if ($("#tpEnableImg").attr('src') === "tp_on.png") {
      $("#tpEnableImg").attr('src', "tp_off.png");
      isManopOn = true;
      top.sendKey("Deadman-L", 0);
    }
  }
}

var curDIIndex = 0;
function getManopDIVal(index) {
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$MANOP_DIIDX', 100);
  top.rpcmc_stopIOMonitor(top.IOTYPE_DI, curDIIndex);
  top.rpcmc_iovalrd(top.IOTYPE_DI, index, getTgtDIVal);
  function getTgtDIVal(iotype, newIndex, value) {
    curDIIndex = index;
    top.rpcmc_startIOMonitor(top.IOTYPE_DI, curDIIndex);
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$MANOP_DIIDX', 100);
    setDisableTPEnbkey(value);
  }
}

function getManopDIIdx() {
  top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$MANOP_DIIDX', getManopDIIdxCB);
  function getManopDIIdxCB(ioType, ioIndex, index, cbarg, chkStatus) {
    if (chkStatus == top.IO_SUCCESS) getManopDIVal(Number(index));
  }
}

// Get TP enable and override.
function getStatusOnLoad() {
  function setEnableState(sys, num, enable) {
    var stat = !(Number(enable) == 0);
    if (stat) {
      $("#tpEnableImg").attr('src', "tp_on.png");
    } else {
      $("#tpEnableImg").attr('src', "tp_off.png");
    }
    top.pnlarea.setTPEnb(stat);
    top.pnlarea.setSlidePnl(stat);
    top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_LINE', getCurrLineCB);
  }
  function getCurrLineCB(prgName, varName, typeCode, valStr) {
    setLineNum(valStr, getCurLangForSts());
    top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', getOvrCB);
  }
  function getOvrCB(prgName, varName, typeCode, ovrStr, arg1, arg2) {
    overRideStat["value"] = ovrStr;
    top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$JOG_FINE', getFineCondCB);
  }
  function getFineCondCB(prgName, varName, typeCode, fine, ovrstr, arg2) {
    overRideStat["fine"] = fine;
    top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$JOG_V_FINE', getVFineCondCB);
  }
  function getVFineCondCB(prgName, varName, typeCode, vfine, ovrstr, arg2) {
    overRideStat["vFine"] = vfine;
    top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$OVR_ZERO', getZeroCondCB);
  }
  function getZeroCondCB(prgName, varName, typeCode, zero, ovrstr, arg2) {
    setORStr("zero", zero);
    if (top.irprogapi.getCurrentLanguage() === null) {
      top.irprogapi.setCurrentLanguage(top.irprogapi.getMachinelockValue, getMachinelockValueCB);
    } else {
      top.irprogapi.getMachinelockValue(getMachinelockValueCB);
    }
    function getMachinelockValueCB(mlList){
      for (var i = 0; i < mlList.length; i++){
        g_machine_lock['g' + (i + 1)] = mlList[i];
      }
      setTcycMode();
    }
  }
  top.rpcmc_iovalrd(top.tpin_type_c, 249, setEnableState);
}


// get step mode
function getStepMode() {
  top.rpcmc_iovalrd(top.tpout_type_c, 3, cbStepState);
}
function cbStepState(iotype, index, str, callbackarg1, callbackarg2) {
  setProgStatIcon("STEP", Number(str));
}

// Language-dependent execution status string table.
var execStatResource = {
  'RUNNING': "run",
  'PAUSED': "pause",
  'ABORTED': "abort",
  '実行': "run",
  '一時停止': "pause",
  '終了': "abort",
  'ｼﾞｯｺｳ': "run",
  'ｲﾁｼﾞﾃｲｼ': "pause",
  'ｼｭｳﾘｮｳ': "abort",
  '运行中': "run",
  '暂停': "pause",
  '中止': "abort",
  'LÄUFT': "run",
  'PAUSE': "pause",
  'ENDE': "abort",
  'EXEC': "run",
  'PAUSE': "pause",
  'ANNULE': "abort",
  'FUNZION.': "run",
  'IN PAUSA': "pause",
  'INTERR.': "abort",
  '運行中': "run",
  '暫停': "pause",
  'PAUSADO': "pause",
  'ABORTADO': "abort",
};

var simulate = null;
var progStat = null;
var stepStat = null;
var runStat = null;

function setProgStatIcon(varName, valStr){
  // get simulate ,program status
  if (varName === "$MCR_GRP[1].$MACHINELOCK") {
    simulate = valStr;

  } else if(varName == '$ALM_IF.$CURR_STAT') {
    if (valStr != "") progStat = valStr;

  } else if(varName === "STEP") {
    stepStat = valStr;

  } else if(varName === "RUN") {
    runStat = valStr;
  }

  // for set icon
  if(progStat != null && simulate != null && runStat != null) {
    progStat = progStat.trim();
    if (progStat in execStatResource) {
      top.currentProgInfo.currentProgStat = execStatResource[progStat];
    } else {
      console.log('[Common API] "execStatResource" does not include ' + progStat);
    }
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, "$ALM_IF.$TASK_NUM", getTaskNumCB);
  }
  function getTaskNumCB(ioType, ioIndex, taskNum, cbArg, chkStatus) {
    var preIcon = (simulate === "TRUE") ? "sim_" : "robo_"; // T-cyc Mode
    // stepStat : 1=ON/0=OFF
    preIcon += (stepStat) ? "step_" : "";
    if (chkStatus != IO_SUCCESS) {
      $("#prgState").attr('src', preIcon + "pause.png");
      return;
    }
    // runStat : 1=ON/0=OFF
    if (Number(taskNum) === 1) {
      if (runStat) {
        $("#prgState").attr('src', preIcon + "run.png");
      } else {
        if (top.currentProgInfo.currentProgStat == "pause") {
          $("#prgState").attr('src', preIcon + "pause.png");
        } else if (top.currentProgInfo.currentProgStat == "abort") {
          $("#prgState").attr('src', preIcon + "stop.png");
        }
      }
    } else {
      if (runStat) {
        $("#prgState").attr('src', preIcon + "run.png");
      } else {
        $("#prgState").attr('src', preIcon + "stop.png");
      }
    }
  }
}

// get current mode AUTO/T1/T2
function getCurrentMode(event, type, index, value) {
  if (type == top.IOTYPE_SI) { // T1 T2 MODE
    if ((index == 8) || (index == 9)) {
      top.rpcmc_iovalrd(top.IOTYPE_SI, 8, firstCurrentModeCallback);
    }
  }
  else if (type == top.tpin_type_c) {
    if (index == top.tp_enbl_c) { // TP Enable
      if (Number(value) == 1) {
        $("#tpEnableImg").attr('src', "tp_on.png");
      } else {
        if (top.isTabTP() && isManopOn) {
          isManopOn = false;
          top.sendKey("Reset", 1);
          top.sendKey("Reset", 0);
        }
        $("#tpEnableImg").attr('src', "tp_off.png");
      }
    }
  } else if (type == top.IOTYPE_DI) { // Automode manual operation
    if (curDIIndex == Number(index)) setDisableTPEnbkey(value);
  } else if (type == top.tpout_type_c) {
    if(Number(index) == 5) {// [RUN]LED status
      setProgStatIcon("RUN", Number(value));  // program action state
    }
    if(Number(index) == 3) {// [STEP]LED status
      setProgStatIcon("STEP", Number(value));  // program action state
    }
  }
}

function firstCurrentModeCallback(iotype, ioindex, iodata, cbarg1, cbarg2) {
  if (iotype == top.IOTYPE_SI) {
    top.rpcmc_iovalrd(top.IOTYPE_SI, 9, currentModeCallBack, iodata);
  }  
}

function currentModeCallBack(iotype, ioindex, iodata, cbarg1, cbarg2) {
  var simArray = [cbarg1, iodata]; // [SI[8], SI[9]]
  setModeIco(simArray);
}
function setModeIco(simArray) {
  if (simArray[0] == 1 && simArray[1] == 1) {
    $("#moveModeImg").attr('src', "mode_auto.png");
  } else if (simArray[0] == 1 && simArray[1] == 0) {
    $("#moveModeImg").attr('src', "mode_t1.png");
  } else if (simArray[0] == 0 && simArray[1] == 0) {
    $("#moveModeImg").attr('src', "mode_t2.png");
  }
  // for TabletTP
  if (top.isTabTP()) getManopDIIdx();
}

// Display software LED substitution icon
function addUserEvent(eventName) {
  var eventIco = $("<img>");
  eventIco.css({
    "width": 45,
    "height":45,
    "margin-top":5
  });
  eventIco.attr('src', "dummy.png");

  // Comment out because details are undecided
  // var eventIco = $("<img>",{"id":eventName});
  // eventIco.attr('ondragstart', 'return false;');
  // switch (eventName) {
  //   case "test":
  //     eventIco.attr('src', "dummy.png");
  //     break;
  //   default:
  //     break;
  // }
  $("#event").append(eventIco);
  if ($("#event").width() >= 153) {
    $("#openBtn").removeClass("clear");
  }
}

// Notification icon area expansion processing
$("#openBtn").on('click touchend', function (event) {
  if(event.type.indexOf('touch') >= 0){
    event.preventDefault();
  }
  if ($("#openBtn").hasClass("left_triangle")) {
    var box = document.getElementById("event");
    var imgs = box.getElementsByTagName("img");
    var size = 18 + 45 * imgs.length;
    $("#event").css({
      "max-width": "380px",
      "overflow": "auto"
    });
    box.style.width = size + "px";
    $("#openBtn").removeClass("left_triangle");
    $("#openBtn").addClass("right_triangle");
  } else {
    $("#event").css({
      "max-width": "153px",
      "overflow": "hidden"
    });
    $("#openBtn").removeClass("right_triangle");
    $("#openBtn").addClass("left_triangle");
  }
});

var mpgNum = {
  axs: -1,
  coord: -1
};
function getMpgAxsNum(){
  return mpgNum.axs;
}
function setMpgAxsNum(arg){
  mpgNum.axs = Number(arg);
}
function getJogCoordNum(){
  return mpgNum.coord;
}
function setJogCoordNum(arg){
  mpgNum.coord = Number(arg);
}
function getMpgAxsCB(ioType, ioIndex, mpgAx, cbArg, chkStatus) {
  if (chkStatus == top.IO_SUCCESS) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MPG_STAT.$DIR_AXS', 100);
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MPG_STAT.$DIR_AXS', 100);
    setMpgAxsNum(mpgAx);
  } else {
    setMpgAxsNum(-1);
  }
  if ((1 <= getMpgAxsNum()) && (getMpgAxsNum() <= 9)) {
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$JCR_GRP[grp].$JOG_COORD', getJogCoordCB);
  } else {
    setDispMpgIcon();
  }
}
function getJogCoordCB(ioType, ioIndex, mpgCoord, cbArg, chkStatus) {
  if (chkStatus == top.IO_SUCCESS) {
    setJogCoordNum(mpgCoord);
  } else {
    setJogCoordNum(-1);
  }
  setDispMpgIcon();
}
function setDispMpgIcon() {
  var beforeMpgIconDinp = $("#mpgIcon").css('display');
  var inTxt = '';
  var mpgIconDisp = 'none';
  if (0 < getMpgAxsNum()) {
    mpgIconDisp = 'inline-block';
    if (getMpgAxsNum() <= 9) {
      if ((getJogCoordNum() == MPG_COORD.JOG) && (1 <= getMpgAxsNum()) && (getMpgAxsNum() <= 6)) {
        inTxt = "J" + getMpgAxsNum();
      } else {
        inTxt = MPG_DIR[getMpgAxsNum() - 1];
      }
    }
  }
  $("#mpgTxt").html(inTxt);
  $("#mpgIcon").css({ 'display': mpgIconDisp });
  if ($("#mpgIcon").css('display') != beforeMpgIconDinp) {
    initSize();
  }
}

function unloadStatbarTabtp(){
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_LINE', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$TASK_NUM', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$GENOVERRIDE', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$JOG_FINE', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$JOG_V_FINE', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$OVR_ZERO', 20);
  for (var i = 1; i <= top.irprogapi.getGroupCount(); i++) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR_GRP[' + i + '].$MACHINELOCK', 100);
  }
  top.rpcmc_stopIOMonitor(top.IOTYPE_SI, 8);
  top.rpcmc_stopIOMonitor(top.IOTYPE_SI, 9);
  top.rpcmc_stopIOMonitor(top.tpout_type_c, 3); // for [STEP] LED status
  top.rpcmc_stopIOMonitor(top.tpout_type_c, 5); // for [RUN] LED status

  top.jQuery.varlis.unbind('VarEvent', statVarEvent);
  top.jQuery.iolis.unbind("IOBooleanEvent", getCurrentMode);
  top.jQuery.devlis.unbind('WarnEvent', warnNoticeEvent);
}

function loadStatbarTabtp(){
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_LINE', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$TASK_NUM', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$GENOVERRIDE', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$JOG_FINE', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$JOG_V_FINE', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$OVR_ZERO', 20);
  for (var i = 1; i <= top.irprogapi.getGroupCount(); i++) {
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR_GRP[' + i + '].$MACHINELOCK', 100);
  }
  if (top.g_order.s507 || top.g_order.s508 || top.g_order.s553) {
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$MPG_STAT.$DIR_AXS', getMpgAxsCB);
  }
  top.rpcmc_startIOMonitor(top.IOTYPE_SI, 8);
  top.rpcmc_startIOMonitor(top.IOTYPE_SI, 9);
  top.rpcmc_startIOMonitor(top.tpout_type_c, 3); // for [STEP] LED status
  top.rpcmc_startIOMonitor(top.tpout_type_c, 5); // for [RUN] LED status

  // system monitor event function
  top.jQuery.varlis.bind('VarEvent', null, statVarEvent);
  top.jQuery.iolis.bind("IOBooleanEvent", null, getCurrentMode);
  top.jQuery.devlis.bind('WarnEvent', null, warnNoticeEvent);
}

$(window).on("pagehide", function () {
  top.jQuery.varlis.unbind('VarEvent', statVarEvent);
  top.jQuery.iolis.unbind("IOBooleanEvent", getCurrentMode);
  top.jQuery.devlis.unbind('WarnEvent', warnNoticeEvent);

  // Alarm display area disable
  var almAreaElem = top.document.getElementById("almArea");
  var almOpenCloseBtnElem = top.document.getElementById("almOpenCloseBtn");
  if(almAreaElem != null) {
    if(almOpenCloseBtnElem != null 
      && $(almOpenCloseBtnElem).hasClass('almOpen')){
      top.clickAlmOpenClose();
    }
    $(almAreaElem).css({ "display" : "none", });
  }
});

$(window).on("load", function () {
  function getStatJincEnbCB(prog_name, var_name, type_code, str) {
    if (str == "TRUE") {
      $("#ovrArea").addClass('dispJincVal');
      if (statJincData.num != top.pnlarea.pnlJincData.num) {
        statJincData = JSON.parse(JSON.stringify(top.pnlarea.pnlJincData));
        dispStatJincData();
      }
    }
  }
  function getModeSelectCB(prog_name, var_name, type_code, str){
    if (str == "2") {
     top.rpcmc_getVar(top.SYSNAME_C, "$TXRAM.$TABLET_TP", getTabTpCB);
    } else {
      $("#moveMode").css({ "pointer-events": "none" });
    }
  }
  function getTabTpCB(prog_name, var_name, type_code, str) {
    if (str == "TRUE") {
      $("#moveMode").on('click', function (event) {
        top.rpcmc_getVar(top.SYSNAME_C, '$DCSS_PARAM.$MODE_TYPE', getTPModeSlctValCB, null);
        function getTPModeSlctValCB(prog, varName, typeCode, val) {
          var appendArg = {TPModeSlctVal : val};
          top.openCmpPupAppendFrm(top.window, '/frh/jcgtp/movemodedlg.stm', appendArg, '', false);
        }
      });
      
    } else {
      $("#moveMode").css({ "pointer-events": "none" });
    }
  }

  function getNumGroupCB(prog, sysvar, type, grp) {
    unloadStatbarTabtp();
    initLayout();
    loadStatbarTabtp();
    $('body').css('font-family', top.getDefFont());
  
    // Enable alarm display area
    var almAreaElem = top.document.getElementById("almArea");
    if(almAreaElem != null) {
      $(almAreaElem).css({ "display" : "", });
      top.setAlmMsgCss();
    }
    var sessionUrl = JSON.parse(sessionStorage.getItem("urlList"));
    if (sessionUrl != null && top.g_startmd != CTRLSTART && sessionUrl.length > 0) {
      dispBackBtn();
    } else {
      hideBackBtn();
      hideForwardBtn();
    }
    top.rpcmc_getVar(top.SYSNAME_C, "$DCSS_PARAM.$MODE_SELECT", getModeSelectCB);
  }
  top.irprogapi.getNumGroup(getNumGroupCB);
  top.rpcmc_getVar(top.SYSNAME_C, "$JINC.$JINC_ENB", getStatJincEnbCB);
  if (top.g_startmd == CTRLSTART) $("#selectprog").css({"display":"none"});
});

$(window).resize(function () {
  initSize();
});

// Prevent zoom when double-tap at tablet.
$('#state').on('touchend', function (e) {
  if(!$(e.target).closest('#selectprog').length) {
    e.preventDefault();
  }
});

$('#selectprog').on('click touchend', function (event) {
  if(event.type.indexOf('touch') >= 0){
    event.preventDefault();
  }
  if (top.isGettingProgList) return;
  function progSlctPopupCB(){
    $('#selectprog').css('pointer-events', '');
    top.progSlctPopupCB = undefined;
  }
  $('#selectprog').css('pointer-events', 'none');
  top.isGettingProgList = true;
  top.progSlctPopupCB = progSlctPopupCB;
  top.buildProgramList();
});

$('#backBtn').on('click touchend',function (event) {
  if(event.type.indexOf('touch') >= 0){
    event.preventDefault();
  }
  if (top.isExistCB()) {
    try {
      top.screenTrans[top.getMyFrameId()].transProc = backBtnProc; //Processing after the instruction from the prim.
      top.screenTrans[top.getMyFrameId()].cb();
    } catch (e) {
      top.screenTrans[top.getMyFrameId()].cb = undefined;
      backBtnProc();
      console.log(e);
    }
  } else {
    backBtnProc();
  }
});
$('#forwardBtn').on('click touchend',function (event) {
  if (event.type.indexOf('touch') >= 0) {
    event.preventDefault();
  }
  if (top.isExistCB()) {
    try {
      top.screenTrans[top.getMyFrameId()].transProc = forwardBtnProc; //Processing after the instruction from the prim.
      top.screenTrans[top.getMyFrameId()].cb();
    } catch (e) {
      top.screenTrans[top.getMyFrameId()].cb = undefined;
      forwardBtnProc();
      console.log(e);
    }
  } else {
    forwardBtnProc();
  }
});

function forwardBtnProc() {
  var urlListFwd = JSON.parse(sessionStorage.getItem("urlListFwd"));
  var nextScreenUrl = urlListFwd[0];
  urlListFwd.shift();
  if (urlListFwd.length == 0) hideForwardBtn();
  sessionStorage.setItem("urlListFwd", JSON.stringify(urlListFwd));
  var props = { value: "", backBtnTrans: false, fwdBtnTrans: true};
  props.value = nextScreenUrl;
  top.treemod.nodeOnClick(null, props);
  
  // update treemenu
  top.treemod.update_tree_url(nextScreenUrl);
}

function backBtnProc() {
  var urlList = JSON.parse(sessionStorage.getItem("urlList"));
  var previousScreenUrl = urlList[0];
  // set urlListFwd
  top.treemod.setUrlListFwd(top.treemod.primScreenId);
  dispForwardBtn();

  // back
  urlList.shift();
  if (urlList.length <= 0) {
    hideBackBtn();
  }
  sessionStorage.setItem("urlList", JSON.stringify(urlList));
  var props = { value: "", backBtnTrans: true, fwdBtnTrans: false};
  props.value = previousScreenUrl;
  top.treemod.nodeOnClick(null, props);
  
  // update treemenu
  top.treemod.update_tree_url(previousScreenUrl);
}

// Adjust the position of the lineNum
function setLineNumHeight() {
  var STAT_HEIGHT = 60;
  var prgNameHeight = $('#prgName').outerHeight(true);
  if ( $('#prgName').text() == "") prgNameHeight = $('#selectprog').outerHeight(true);
  // Subtract program name height from state
  var lineNumHeight = STAT_HEIGHT - prgNameHeight;
  $('#lineNum').css('height', lineNumHeight + 'px');
  // Align to the center of the remaining height
  $('#lineNum').css('line-height', $('#lineNum').height() + 'px');
}
// Adjust the position of the progStat
function setProgStatHeight() {
  var STAT_HEIGHT = 60;
  var prgNameHeight = $('#prgName').outerHeight(true);
  if ( $('#prgName').text() == "") prgNameHeight = $('#selectprog').outerHeight(true);
  // Subtract program name height from state
  var lineNumHeight = STAT_HEIGHT - prgNameHeight;
  $('#progStatTxt').css('height', lineNumHeight + 'px');
  // Align to the center of the remaining height
  $('#progStatTxt').css('line-height', $('#progStatTxt').height() + 'px');
}

function hideBackBtn() {
  $('#backBtn').css({'width': '0px', 'border-right': '0px'});
  $('#backBtn').css({'min-width': '0px'}); // for IE
  $('#backimg').css('width', '0px');
  initSize();
}

function hideForwardBtn() {
  $('#forwardBtn').css({'width': '0px', 'border-right': '0px'});
  $('#forwardBtn').css({'min-width': '0px'}); // for IE
  $('#forwardimg').css('width', '0px');
  initSize();
}

function dispBackBtn() {
  var sessionUrl = JSON.parse(sessionStorage.getItem("urlList"));
  if (sessionUrl == null || sessionUrl.length == 0) {
    var urlList = [];
    urlList[0] = top.IHMI_EDITOR_ADDRESS;
    sessionStorage.setItem("urlList", JSON.stringify(urlList));
  }
  $('#backBtn').css({'width': '46px', 'border-right': 'solid 2px black'});
  $('#backBtn').css({'min-width': '46px'}); // for IE
  $('#backimg').css('width', '44px');
  initSize();
}

function dispForwardBtn() {
  var sessionUrl = JSON.parse(sessionStorage.getItem("urlListFwd"));
  if (sessionUrl != null && sessionUrl.length != 0) {
    $('#forwardBtn').css({'width': '46px', 'border-right': 'solid 2px black'});
    $('#forwardBtn').css({'min-width': '46px'}); // for IE
    $('#forwardimg').css('width', '44px');
    initSize();
  }
}

var JINC_VAR = {
  JOG_INCE: '$JINC.$JOG_INCRE',
  TRANS: '$JINC.$INCRE_TRANS',
  JOINT: '$JINC.$INCRE_JNT'
};
var statJincData = {
  num: undefined,
  trans: [0.000, 0.000, 0.000, 0.000],
  joint: [0.000, 0.000, 0.000, 0.000]
};

function getStatJincCB(varName, value) {
  var transLen = statJincData.trans.length;
  var jointLen = statJincData.joint.length;
  var tagNum = "";
  if (varName === JINC_VAR.JOG_INCE) {
    statJincData.num = Number(value);
  } else if (varName.indexOf(JINC_VAR.TRANS) >= 0) {
    // '$JINC.$INCRE_TRANS'
    tagNum = Number(varName.match(/\[(.+)\]/)[1]) - 1;
    statJincData.trans[tagNum] = Number(value);
  } else if (varName.indexOf(JINC_VAR.JOINT) >= 0) {
    // '$JINC.$INCRE_JNT'
    tagNum = Number(varName.match(/\[(.+)\]/)[1]) - 1;
    statJincData.joint[tagNum] = Number(value);
  }

  if ((0 < statJincData.trans[transLen - 1]) && (0 < statJincData.joint[jointLen - 1])) {
    dispStatJincData();
  }
}

function dispStatJincData() {
  var jincText = tabtpJincStr["continuous"];
  var fontSize = tabtpJincStr["SSIZE"];
  var lineHeight = tabtpJincStr["HLINE"];
  $("#jincValue").removeClass("continuousStr");

  if (statJincData.num != 0) {
    if ((1 <= statJincData.num) && (statJincData.num <= statJincData.trans.length)) {
      var selNum = statJincData.num - 1;
      jincText = statJincData.trans[selNum] + 'mm<br>' + statJincData.joint[selNum] + 'deg';
    } else {
      jincText = 'mm<br>deg';
    }
    fontSize = tabtpJincStr["NSIZE"];
    lineHeight = 'normal';
  }
  $('#jincValue').css({ 'line-height' : lineHeight });
  $('#jincValue').css({ 'font-size' : fontSize });
  $('#jincValue').html(jincText);

  // Set "continuous" text position.
  if (statJincData.num === 0) {
    var jincTextW = $('#jincValue')[0].scrollWidth;
    var ovrAreaW = $('#ovrArea').width();
    if (jincTextW > ovrAreaW) {
      var posVal = Math.abs(ovrAreaW - jincTextW) / 2;
      $("#jincValue").addClass("continuousStr");
      $("#jincValue").css({"right":posVal});
    }
  }
}

function blinkWarnIcon() {
  var Icon = document.getElementById('warnNoticeImg');
  if (Icon.style.visibility === 'visible') {
    Icon.style.visibility = 'hidden';
  } else {
    Icon.style.visibility = 'visible';
  }
}

var blinkInterval = 0;
function warnNoticeEvent(event, img_src, warn_type, warn_url, interval) {
  clearInterval(blinkInterval);
  if (warn_type == PMEV_WARN_MENU_C) {
    $("#warnNoticeImg").attr('src', img_src.slice(9));
    $("#warnNotice").css({ 'display': 'inline-block' });
    blinkInterval = setInterval(blinkWarnIcon, interval);
  } else {
    $("#warnNotice").css({ 'display': 'none' });
  }
  initSize();
}

$('#warnNotice').on('click touchend', function (event) {
  if (event.type.indexOf('touch') >= 0) {
    event.preventDefault();
  }
  var arg = {props: {}};
  arg.props.value = top.Notifications_ADDRESS;
  top.transIrprogMenu(arg);
});