/**********************************************************************
 * Status program Information TRANSlator (sop_sitrans.js)
 * common script (set charset="UTF-8")
 * Created: 2018/11/20 FSI (Porting from pceditor_main)
 * Modified:
 */

// Use jQuery
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
*/

// The following script is necessary
// rpcmc.js
// The following object is necessary
// jQuery.varlis (define at top)

// = Status area setting
var WATCHEXEC_ABORTED = 0;
var WATCHEXEC_RUNNING = 1;
var WATCHEXEC_PAUSED = 2;

// Japanese 'Hankaku Kana' mode status table.
var jpKanaExecStat = ['ｼｭｳﾘｮｳ', 'ｼﾞｯｺｳ', 'ｲﾁｼﾞﾃｲｼ'];
// Language-dependent execution status string table.
var execStatResource = {
	'eg': {
		'execStatRunning': 'RUNNING',
		'execStatPaused': 'PAUSED',
		'execStatAborted': 'ABORTED'
	},
	'jp': {
		'execStatRunning': '実行',
		'execStatPaused': '一時停止',
		'execStatAborted': '終了'
	},
	'ch': {
		'execStatRunning': '运行中',
		'execStatPaused': '暂停',
		'execStatAborted': '中止'
	}
};

// Enable $ALM_IF
top.rpcmc_setVar(top.SYSNAME_C, '$ALM_IF.$ENABLE', 1);
// Start PMON monitor for $ALM_IF.$CURR_PROG
top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', 100);	// Program, Variable, Interval(msec)
// Start PMON monitor for $ALM_IF.$CURR_LINE
top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_LINE', 100);	// Program, Variable, Interval(msec)
// Start PMON monitor for $ALM_IF.$CURR_STAT
top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', 100);	// Program, Variable, Interval(msec)
// Start PMON monitor for $REMOTE_CFG.$REMOTE_TYPE
top.rpcmc_startVarMonitor(top.SYSNAME_C, '$REMOTE_CFG.$REMOTE_TYPE', 250);	// Program, Variable, Interval(msec)
// Start PMON monitor for SI[2]
top.rpcmc_startIOMonitor(IOTYPE_SI, 2);

// Object of Status program information translator
var statusProgramInfoTrans = (function () {
	// === Internal variables ===
	var currentProgVal = { prog: '', line: '', stat: '' };	// Current main program
	var isExecProgFunc;	// Function to check the execution of the program
	var callbackFunc;	// Callback function of change status.
	var callbackCurrentProg;	// Callback function of change current program name.
	var callbackRemoteType;	// Callback function of change remote type.

	// Execution status of the watched object
	var watchExecStack = [];	// {index: 0, prog: '', line: 1, str: '', stat: 0}
	var watchExecIndex = 0;		// Stack index
	var statWordArray = [	// Table of status string to status code.
		{ res: '', stat: WATCHEXEC_RUNNING },
		{ res: '', stat: WATCHEXEC_PAUSED },
		{ res: '', stat: WATCHEXEC_ABORTED }
	];
	var statKanaWords = [	// for Special check 'KATAKANA' mode.
		{ res: jpKanaExecStat[WATCHEXEC_RUNNING], stat: WATCHEXEC_RUNNING },
		{ res: jpKanaExecStat[WATCHEXEC_PAUSED], stat: WATCHEXEC_PAUSED },
		{ res: jpKanaExecStat[WATCHEXEC_ABORTED], stat: WATCHEXEC_ABORTED }
	];

	// === Internal functions ===
	// Reflect monitor value to callback function.
	function reflectProgramStatus(valStr) {
		if ((callbackFunc !== undefined) && (valStr != null)) {	// Add 'Is valStr invalid?'
			callbackFunc(valStr);
		}
	}
	function reflectCurrentProgram(valStr) {
		if ((callbackCurrentProg !== undefined) && (valStr != null)) {
			callbackCurrentProg();
		}
	}
	function reflectRemoteType(valStr, afterCall) {
		var systemMode = Number(valStr);
		if ((callbackRemoteType !== undefined) && (systemMode != null)) {
			callbackRemoteType(systemMode, afterCall);
		}
	}
	// Attach handler for VarEvent.
	top.jQuery.varlis.bind('VarEvent', null, ProgStatVarEvent);
	function ProgStatVarEvent(event, progName, varName, typeCode, valStr) {
		if (varName == '$ALM_IF.$CURR_PROG') {
			l_setCurrentProgramName(valStr);
		} else if (varName == '$ALM_IF.$CURR_LINE') {
			l_setCurrentProgramLine(Number(valStr));
		} else if (varName == '$ALM_IF.$CURR_STAT') {
			l_setCurrentProgramStat(findWatchExecStat(valStr.trim()));
		} else if (varName == '$REMOTE_CFG.$REMOTE_TYPE') {
			reflectRemoteType(valStr, null);
		}
	}
  top.jQuery.iolis.bind("IOBooleanEvent", null, ioMoniVarEvent);
  function ioMoniVarEvent(event, io_type, io_index, io_value) {
    if (io_type == IOTYPE_SI) {
      if (io_index == 2) setRemoteLocalStat(io_value); // Remote mode / Local mode
    }
  }
	var getValCount = 0;
	function getCurrentProgramCallback(progName, varName, typeCode, valStr, callbackProg, callbackarg) {
		if (varName == '$ALM_IF.$CURR_PROG') {
			callbackProg(valStr);
		} else if (varName == '$ALM_IF.$CURR_LINE') {
			callbackProg(Number(valStr));
		} else if (varName == '$ALM_IF.$CURR_STAT') {
			callbackProg(findWatchExecStat(valStr.trim()));
		}
		getValCount++;
		if (getValCount == 3) {
			reflectProgramStatus(currentProgVal);
		}
	}

	// Callback function of get remote config type
	function getRemoteTypeCallback(progName, varName, typeCode, valStr, callbackProg, callbackarg) {
		reflectRemoteType(valStr, callbackProg);
	}
	// Find exec status string from resources and return status code.
	function findWatchExecStat(execStatStr) {
		var stat = -1;
		for (var i = 0; i < statWordArray.length; i++) {
			// Correct a generate the RegExp object because it is not correctly generated on the iPad.
			//var rexp = new RegExp(statWordArray[i].res);
			//if (rexp.test(execStatStr)) {
			if (execStatStr.indexOf(statWordArray[i].res) >= 0) {
				// The status word contains the status list status.
				stat = statWordArray[i].stat;
				break;
			}
		}
		if (stat < 0) {
			// Special check for Jananese KATAKANA mode.
			for (var i = 0; i < statKanaWords.length; i++) {
				// Correct a generate the RegExp object because it is not correctly generated on the iPad.
				//var rexp = new RegExp(statKanaWords[i].res);
				//if (rexp.test(execStatStr)) {
				if (execStatStr.indexOf(statKanaWords[i].res) >= 0) {
					// The status word contains the status list status.
					stat = statKanaWords[i].stat;
					break;
				}
			}
		}
		return stat;
	}
	// Set Processing Program status valiable.
	function l_setCurrentProgramName(progName) {
		currentProgVal.prog = progName;	// Current program
		reflectCurrentProgram(progName);
	}
	// Set Processing Program Line valiable.
	function l_setCurrentProgramLine(progLine) {
		currentProgVal.line = progLine;	// Current program
		reflectCurrentProgram(progLine);
	}
	// Set Processing Program status valiable.
	function l_setCurrentProgramStat(progStat) {
		currentProgVal.stat = progStat;	// Current program
		reflectCurrentProgram(progStat);
	}

	return {
		// Function to expose to the outside
		// Initialize
		initProgStat: function (lang, execProg, callback) {
			isExecProgFunc = execProg;	// Function to check the execution of the program
			callbackCurrentProg = callback;
			statWordArray[0].res = execStatResource[lang]['execStatRunning'];
			statWordArray[1].res = execStatResource[lang]['execStatPaused'];
			statWordArray[2].res = execStatResource[lang]['execStatAborted'];
			top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', getCurrentProgramCallback, l_setCurrentProgramName, null);
			top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_LINE', getCurrentProgramCallback, l_setCurrentProgramLine, null);
			top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', getCurrentProgramCallback, l_setCurrentProgramStat, null);
		},
		// initCurrentProgram(callback function)
		initCurrentProgram: function (callback) {
			callbackCurrentProg = callback;	// Callback function of change current program name
		},
		// initCurrentProgram(callback function)
		initCallbackFunc: function (callback) {
			callbackFunc = callback;	// Callback function of change current program name
		},
		// initRemoteType(callback function)
		initRemoteType: function (callback) {
			callbackRemoteType = callback;	// Callback function of change remote type
		},
		// Get Remote config type valiable.
		getRemoteConfigType: function (afterCall) {
			top.rpcmc_getVar(top.SYSNAME_C, '$REMOTE_CFG.$REMOTE_TYPE', getRemoteTypeCallback, afterCall, null);
		},
		// Get Current Program name valiable.
		getCurrentProgramSI: function () {
			return currentProgVal;
		},
		// Convert stat to status string.
		getExecStatStr: function (stat) {
			for (var i = 0; i < statWordArray.length; i++) {
				if (statWordArray[i].stat == stat) {
					return statWordArray[i].res;
				}
			}
			for (var i = 0; i < statKanaWords.length; i++) {
				if (statKanaWords[i].stat == stat) {
					return statKanaWords[i].res;
				}
			}
			return '';
		},
		unloadStatusTrans: function () {
			// Stop PMON monitor for $ALM_IF.$CURR_PROG
			top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', 100);
			// Stop PMON monitor for $ALM_IF.$CURR_LINE
			top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_LINE', 100);
			// Stop PMON monitor for $ALM_IF.$CURR_STAT
			top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', 100);
			// Stop PMON monitor for $REMOTE_CFG.$REMOTE_TYPE
			top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$REMOTE_CFG.$REMOTE_TYPE', 250);
			// Stop PMON monitor for SI[2] 
			top.rpcmc_stopIOMonitor(IOTYPE_SI, 2);
			// Detach all VarEvents
			top.jQuery.varlis.unbind('VarEvent', ProgStatVarEvent);
			top.jQuery.iolis.unbind("IOBooleanEvent", ioMoniVarEvent);
		},
		setCurrentProgramName: l_setCurrentProgramName,
		setCurrentProgramLine: l_setCurrentProgramLine,
		setCurrentProgramStat: l_setCurrentProgramStat,
	}	// return;
})();

// Event unload.
$(window).on('unload', function (evt) {
	statusProgramInfoTrans.unloadStatusTrans();
});
