/**********************************************************************
 * operatorpanel
 * Main control script
 * Created: 2018/11/16 FSI
 */

// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 */

var g_win_x; // Current window X size.
var g_win_y; // Current window Y size.

var systemMode = LOCAL_MODE; // setting mode
var isTablet = false;	// Tablet use flag for future.

/*
 * Button Event Setting
 */
function setButtonEvent() {
	$("#reset_btn").on('click', function (event) {
		linkStatusLED.resetAlarmStatus();
	});

	$('#config_remote_btn').on('click', function (event) {
		if ((systemMode != REMOTE_MODE) && (!isProgramRun)) {
			$('#config_remote_btn').css('background-color', '#146fca');
			$('#config_local_btn').css('background-color', '#67727e');
			$('#cycle_start_btn').css('background-color', '#c7ced7');
			$('#cycle_start_btn').css('color', '#67727e');
			systemMode = REMOTE_MODE;
			rpcmc_setVar(SYSNAME_C, '$REMOTE_CFG.$REMOTE_TYPE', systemMode);
		}
	});

	$('#config_local_btn').on('click', function (event) {
		if ((systemMode != LOCAL_MODE) && (!isProgramRun)) {
			$('#config_local_btn').css('background-color', '#146fca');
			$('#config_remote_btn').css('background-color', '#67727e');
			$('#cycle_start_btn').css('background-color', '#23ac38');
			$('#cycle_start_btn').css('color', 'white');
			systemMode = LOCAL_MODE;
			rpcmc_setVar(SYSNAME_C, '$REMOTE_CFG.$REMOTE_TYPE', systemMode);
		}
	});

	$('#cycle_start_btn').on('click', function (event) {
		getRecentTopProgram(getTpCallback);
	});

	$('#cycle_hold_btn').on('click', function (event) {
		pauseCycleProgram();
	});

	$('#cycle_stop_btn').on('click', function (event) {
		abortAll(top.g_connect_id, cycleStopCallback);
	});
}

/*
 * Windows OnLoad Event
 */
$(window).on('load', function () {
	g_win_x = window.innerWidth;
	g_win_y = window.innerHeight;
	$(document).width(g_win_x);
	$(document).height(g_win_y);
	if (getCurrentLanguage() === null) {
		setCurrentLanguage(initLayoutAreaCallBack);
	}
});

/*
 * Initialize Layout Area Callback(after get language)
 */
function initLayoutAreaCallBack() {
	initResource();
	statusProgramInfoTrans.initProgStat(getCurrentLanguage(), isExecProgramOn, changeExecProgramStatus);
	linkStatusLED.initLinkAlarm('watchAlarm', 'reset_btn', linkAlarmCallback);
	linkStatusLED.initLinkRun('watchStat', linkStatCallback);
	setButtonEvent();
	statusProgramInfoTrans.initCallbackFunc(getExecProgStatFirst);	// Function to be executed after getting all statuses
	statusProgramInfoTrans.initRemoteType(remoteTypeCallback);	// init remote config type (regist callback)
	statusProgramInfoTrans.getRemoteConfigType(null);	// get the 1st remote config type.
}

function remoteTypeCallback(mode, callbackarg) {
	// set to global variable
	systemMode = mode;	// Whether remote type is REMOTE_MODE or LOCAL_MODE
	if (systemMode == LOCAL_MODE) {
    $('#config_remote_btn, #config_local_btn').css({
      'opacity': '1', 'pointer-events':''
    });
	} else if (systemMode == REMOTE_MODE) {
    $('#config_remote_btn, #config_local_btn').css({
      'opacity': '1', 'pointer-events':''
    });
	} else {
		$('#config_remote_btn, #config_local_btn').css({
      'opacity': '0.5', 'pointer-events':'none'
    });
	}
	if (callbackarg != null) {
		callbackarg(); // decideCycleStartCallback
	}
}

function setRemoteLocalStat(siValue) {
  var remoteStyle = '#67727e';
  var localStyle = '#67727e';
	if (siValue == '0') { // LOCAL_MODE
    localStyle = '#146fca';
    setActiveCycleStart(true);
	} else if (siValue == '1') {  // REMOTE_MODE
    remoteStyle = '#146fca';
    setActiveCycleStart(false);
	}
  $('#config_local_btn').css('background-color', localStyle);
  $('#config_remote_btn').css('background-color', remoteStyle);
}

function setActiveCycleStart(isActive) {
  if (isActive) {
     $('#cycle_start_btn').css('background-color', '#23ac38');
	 $('#cycle_start_btn').css('color', 'white');
  } else {
  	 $('#cycle_start_btn').css('background-color', '#c7ced7');
	 $('#cycle_start_btn').css('color', '#67727e');
  }
}

function decideCycleStartCallback() {
	if (systemMode == LOCAL_MODE || systemMode == EXTERNAL_IO_MODE) {
		// if it call cycle start button, go into the processing
		startCycle(cycleStartCallback);
	}
}

function isExecProgramOn() {
	return true;
}

var isAlarmOn = false;
function linkAlarmCallback(alarmStatus) {
	console.log('SoftPanel: Alarm LED event:[' + alarmStatus + ']');
	isAlarmOn = alarmStatus;
}

var isProgramRun = false;
function linkStatCallback(programStatStatus) {
	console.log('SoftPanel: Run LED event:[' + programStatStatus + ']');
	isProgramRun = programStatStatus;
}

function changeExecProgramStatus() {	// call from sitrans
	var reflectprog = JSON.parse(JSON.stringify(statusProgramInfoTrans.getCurrentProgramSI()));
	$('#execprogram_name').html(reflectprog.prog);
	if (reflectprog.prog != "") {
		$('#execprogram_line').text(reflectprog.line);
	}
	$('#execprogram_stat').html(statusProgramInfoTrans.getExecStatStr(reflectprog.stat));
}

function getExecProgStatFirst() {	// call from sitrans
	var reflectprog = JSON.parse(JSON.stringify(statusProgramInfoTrans.getCurrentProgramSI()));
	console.log('SoftPanel: reflectprog.prog=' + reflectprog.prog + '; line=' + reflectprog.line + '; stat=' + reflectprog.stat + ';');
}

function cycleStartCallback(status) {
	// no operation
}

function cycleStopCallback(result) {
	// no operation
}

/**
 * Get recent top program name.
 * (IN) callback : A callback function to get program name list.
 *          arg1 : SYSNAME_C
 *          arg2 : $ALM_IF.$CURR_PROG
 *          arg3 : no use
 *          arg4 : Defined program name
 */
function getRecentTopProgram(callback) {
	top.rpcmc_getVar(SYSNAME_C, '$ALM_IF.$CURR_PROG', callback);
}

function getTpCallback(sysName, sysValueName, noUse, progName) {
	if ((progName === "")
		|| ($('#cycle_start_btn').css("background-color") == "rgb(199, 206, 215)")) {
		return;
	}
	var dlgArgs = {
		btnId: "#cycle_start_btn", dlgId: "#confcycledlg", textResId: "dlgMsgCycleStart"
	};
	defineDialog.open(dlgArgs);
}

// call from dialog [OK]
function afterConfCycleStart() {
	statusProgramInfoTrans.getRemoteConfigType(decideCycleStartCallback);
}
