/**********************************************************************
 * operatorpanel
 * Cycle start/stop/hold script
 * Created: 2018/11/26 FSI
 */

// Require sop_linkled.js, rpcmc.js

/*
 * Cycle Start to [Start]
 * (IN) callback : A callback function to receive status.
 *                 If no need, set to null..
 */
function startCycle(callback) {
	setLocalStart(setLocalStartCallback, callback);
}
// Callback function to receive start status.
function setLocalStartCallback(status, callback) {
	console.log('SoftPanel: setLocalStartCallback: status=[' + status + ']');
	if (callback != undefined) {
		callback(status);
	}
}

/*
 * Abort All process
 * (IN) connectId : login connection id.
 * (IN) callback : A callback function to receive status.
 *                 If no need, set to null...
 */
function abortAll(connectId, callback) {
	$.get('/softpart/genlink?connect_id=' + connectId + '&current=fctnmenu,20,1', function (result) {
		console.log(result);
		if (callback != undefined) {
			callback(result);
		}
	});
}

/**
 * Local Start/Stop Controll.
 * Start value from 1 to 0
 * (IN) value : 1=Button On, 0=Status Off.
 * (IN) callback : A callback function to receive the return status.
 */
function setLocalStart(callback, cbarg) {
	$.getJSON("/COMET/rpc?func=LOCAL_START&connect_id=" + top.g_connect_id,
		function (json) {
			if (json.FANUC.RPC != undefined) {
				if (json.FANUC.RPC[0].status != 0) {
					top.rpcmc_rprintf("LOCAL_START error status:" + json.FANUC.RPC[0].status);
				}
				if (callback != undefined) {
					callback(json.FANUC.RPC[0].status, cbarg);
				}
			}
		});
}

/**
 * Pause Program.
 * Annotation : Delay processing is necessary to make temporary stop work.
 */
function pauseCycleProgram() {
  $.getJSON("/COMET/rpc?func=LOCAL_PAUSE",
            function (json) {
	      if (json.FANUC.RPC != undefined) {
		if (json.FANUC.RPC[0].status != 0) {
		  top.rpcmc_rprintf("LOCAL_PAUSE error status:" + json.FANUC.RPC[0].status);
		}
	      }
	    });
}
