// rx.js - Constants defined by controller code

// rx.h
var SSC_OS = 0;
var SSC_IO = 10;
var SSC_WD = 17;
var SSC_DP = 33;
var SSC_PMON = 100;
var SSC_TPGL = 169;
var PKT_TYP7 = 7;
var CTRLSTART = 1;

// taskpri.hc
var TID_SV3D = 297; // 3D server task

// iotypdef.hc
var tpin_type_c = 14;   // Teach pendant digital input
var tpout_type_c = 15;  // Teach pendant digital output

// ioreqcod.hc
var io_sim_all_c = 6;   // Simulate all logical signals
var io_sim_c = 7;       // Simulate logical signal
var io_unsim_all_c = 8; // Unsimulate all logical signals
var io_unsim_c = 9;     // Unsimulate logical signal

// tpreqcod.hc
var tp_focuspanel_c = 47;      // Like tp_panel_c but forwards request
var tp_webonload_c = 75;       // Web page onload event
var tp_thispanel_c = 78;       // Execute the command in current panel regardless of focus
var tp_websetfocus_c = 79;     // Command TPMM to set the focus for iPendant
var tp_cgtpmain_done_c = 108;  // CGTP main page loaded in browser
var tp_config_done_c = 109;    // CGTP configuration page loaded in browser
var tp_devonmouseup_c = 113;   // Device onMouseUp event
var tp_maxrestore_c = 127;     // Maximize/Restore pane
var tp_winsize_c = 132;        // Resize windows
var tp_zoom_c = 134;           // Zoom pane
var tp_reconfig_c = 153;       // Reconfigure the display mode

// wdrcodes.hc
var wdwm_req_upd_c = 41;       // update window
var wd_req_scsr_c = 34;        // set cursor

// pmon.h
var PMEV_CURPOS_JOINT_C = 3;
var PMEV_CURPOS_USER_C = 4;
var PMEV_CURPOS_WORLD_C = 5;
var PMEV_DEVICE_C = 6;
var PMEV_CONNECT_ID_C = 7;
var PMEV_WEBPAGE_C = 8;
var PMEV_WEBFRAME_FOCUS_C = 9;
var PMEV_MAIN_MENU_C = 10;
var PMEV_QUIC_MENU_C = 11;
var PMEV_FCTN_MENU_C = 12;
var PMEV_TYPE_MENU_C = 13;
var PMEV_DISP_MENU_C = 15;
var PMEV_SUB_MENU_C = 17;
var PMEV_OVRD_MENU_C = 18;
var PMEV_CANC_MAIN_MENU_C = 22;
var PMEV_CANC_QUIC_MENU_C = 23;
var PMEV_CANC_FCTN_MENU_C = 24;
var PMEV_CANC_TYPE_MENU_C = 25;
var PMEV_CANC_DISP_MENU_C = 26;
var PMEV_CANC_SUB_MENU_C = 27;
var PMEV_CANC_OVRD_MENU_C = 28;
var PMEV_PLDn_MENU_C = 29;
var PMEV_CANC_PLDn_MENU_C = 30;
var PMEV_DISCON_C = 31;
var PMEV_VAR_C = 32;
var PMEV_WSCR_MENU_C = 33;
var PMEV_CANC_WSCR_MENU_C = 34;
var PMEV_PRBX_MENU_C = 35;
var PMEV_CANC_PRBX_MENU_C = 36;
var PMEV_STRINPUT_C = 41;
var PMEV_CANC_STRINPUT_C = 42;
var PMEV_END_STRINPUT_C = 43;
var PMEV_FILE_C = 44;
var PMEV_NUMINPUT_C = 55;
var PMEV_PIPE_C = 63;
var PMEV_WEBFRAME_REFRESH_C = 45;
var PMEV_IO_C = 48;
var PMEV_DIALOG_BOX_C = 53;
var PMEV_WARN_MENU_C = 67;
var PMEV_CANC_WARN_MENU_C = 68;
var PMEV_ALPHA_TYPE_MENU_C = 77;
var PMEV_SAFE_IO_C = 84;
var PMEV_IO_MGTH_C = 85;

var PMON_MON_VAR_C = 3;
var PMON_MON_SYS_C = 5;
var PMON_MON_CURPOS_JOINT_C = 6;
var PMON_MON_CURPOS_USER_C = 7;
var PMON_MON_CURPOS_WORLD_C = 8;
var PMON_MON_DEVICE_C = 9;
var PMON_MON_FILE_C = 10;
var PMON_MON_PIPE_C = 11;
var PMON_MON_IO_NS_C = 12;
var PMON_MON_SAFE_IO_C = 13;
var PMON_MON_IO_MGTH_C = 14;

var PMON_SYS_POSREG_C = 0;
var PMON_SYS_TFRAME_C = 1;
var PMON_SYS_JFRAME_C = 2;
var PMON_SYS_UFRAME_C = 3;
var PMON_SYS_NUMREG_C = 4;
var PMON_SYS_STRREG_C = 5;

// dplang.hc
var dplang_default_c = "DEFAULT     ";
var dplang_english_c = "ENGLISH     ";
var dplang_japanese_c = "JAPANESE    ";
var dplang_kanji_c = "KANJI       ";
var dplang_french_c = "FRENCH      ";
var dplang_german_c = "GERMAN      ";
var dplang_spanish_c = "SPANISH     ";
var dplang_chinese_c = "CHINESE     ";
var dplang_taiwanese_c = "TAIWANESE   ";
var dplang_other_c = "OTHER       ";

// tpmulti.h
var TPCONFIG_INIT_C = 10;
var TPCONFIG_ECHO_C = 11;
var MAX_TIDS_CONN = 3;

var TPCONFIG_OPPNL_C = -6; // Machine Operation Panel(S534) connection

// wdkcodes.hc
var shft_c = 0;
var backspace_c = 8;
var enter_c = 13;
var ctl_w_c = 23;
var group_c = 28;
var prev_c = 128;
var f1_c = 129;
var f2_c = 131;
var f3_c = 132;
var f4_c = 133;
var f5_c = 134;
var next_c = 135;
var prev_s_c = 136;
var f1_s_c = 137;
var f2_s_c = 138;
var f3_s_c = 139;
var f4_s_c = 140;
var f5_s_c = 141;
var next_s_c = 142;
var prog_sel_c = 143;
var menu_sel_c = 144;
var prg_edit_c = 145;
var prg_data_c = 146;
var cmn_func_c = 147;
var line_no_c = 148;
var pct_up_c = 149;
var pct_dn_c = 150;
var hold_c = 151;
var step_c = 152;
var reset_c = 153;
var line_no_s_c = 154;
var pct_up_s_c = 155;
var pct_dn_s_c = 156;
var step_s_c = 157;
var hold_s_c = 158;
var reset_s_c = 159;
var uf_1_c = 173;
var uf_2_c = 174;
var uf_3_c = 175;
var uf_4_c = 176;
var uf_5_c = 177;
var uf_6_c = 178;
var uf_1_s_c = 179;
var uf_2_s_c = 180;
var uf_3_s_c = 181;
var uf_4_s_c = 182;
var uf_5_s_c = 183;
var uf_6_s_c = 184;
var fwd_c = 185;
var bwd_c = 186;
var coord_c = 187;
var fwd_s_c = 200;
var bwd_s_c = 201;
var coord_s_c = 202;
var help_c = 203;
var up_arw_s_c = 204;
var dn_arw_s_c = 205;
var rt_arw_s_c = 206;
var lf_arw_s_c = 207;
var rt_arw_c = 208;
var lf_arw_c = 209;
var uf_7_c = 210;
var uf_7_s_c = 211;
var up_arw_c = 212;
var dn_arw_c = 213;
var tk_ui_loaded_c = 226;
var disp_s_c = 227;
var diag_c = 239;
var disp_c = 240;
var tp_enbl_c = 249;
var estp_c = 250;
var tk_cancel_c = 252;
var flexuif_home_c = 8206;
var menu_search_c = 8208;
var icon_c = 12288;
var menu_i_c = 12298;
var select_i_c = 12299;
var data_i_c = 12300;
var edit_i_c = 12301;
var fctn_i_c = 12302;
var step_i_c = 12303;
var coord_i_c = 12304;
var group_i_c = 12305;
var pct_up_i_c = 12306;
var pct_dn_i_c = 12307;
var up_arw_i_c = 12308;
var dn_arw_i_c = 12309;
var rt_arw_i_c = 12310;
var lf_arw_i_c = 12311;
var disp_i_c = 12312;
var help_i_c = 12313;
var posn_i_c = 12338;
var io_i_c = 12339;
var status_i_c = 12340;
var enter_i_c = 12341;
var refresh_c = 15614;
var mor_ss_c = 16251;
var j_popup_close_c = 16386;
var j_flyout_close_c = 16387;
var dialog_cancel_c = 16388;

// gtpvars.ht
var MOUSE_LEFT = 1;
var MOUSE_DBLCLK = 4;

// local
var LOADED_TIMEOUT = 0;
var DIALOG_OPEN_C = 0;
var DIALOG_CLOSE_C = -1;

// vmnamdef.net
var SYSNAME_C = "*SYSTEM*";
var NUMREG_C = "*NUMREG*";
var NUM_REGISTER_C = "$NUMREG";
var POSREG_C = "*POSREG*";
var POS_REGISTER_C = "$POSREG";
var STRREG_C = "*STRREG*";
var STR_REGISTER_C = "$STRREG";
var PG_MNUTOOL_SYSN_C = "$MNUTOOL";
var PG_MNUFRAME_SYSN_C = "$MNUFRAME";
var TPFDEF_C = "TPFDEF";

// piVdu.h
var DARK_GRAY = "#3A3A3B";
var LIGHT_GRAY = "#C0C0C0";
var BRIGHT_RED = "#E60012";
var BRIGHT_GREEN = "#079A3E";
var BRIGHT_YELLOW = "#FFE109";
var DARK_RED = "#320709";
var DARK_GREEN = "#0B321B";
var DARK_YELLOW = "#322D14";
var BGHelp_Color = "#AADDFF";
var TITLE_DELINK_BG_COLOR = "#C0C0FF";
var MEDIUM_GRAY = "#696969";
var BRIGHT_GRAY = "#E6E6E6";

// mocons.ht
var MAX_GRP_AXES = 9; // maximum number of axes per group
var MAX_NUM_GRPS = 8; // maximum number of groups

// kstddef.h
var NOT_A_SHORT = 32767; // 0x7FFF;

// iofuncod.hc
var F_DISCON = 11;
var F_KEYC = 25;

// mmprgatr.hc
var MM_OWNER_C = 1;
var MM_COMMENT_C = 2;
var MM_MDFY_TIME_C = 7;
var MM_DEF_GROUP_C = 10;
var MM_PROTECT_C = 11;
var MM_STACK_SIZE_C = 12;
var MM_IGNR_PAUS_C = 17;
var MM_CONTROL_C = 18;

// iptreevw.h
var TV_PRG_ALL = 22;
var TV_PRGCMT_ALL = 4118;
var TV_CMTPRG_ALL = 8214;

// mmsymbol.hc
var MM_MNEPRG_C = 1;
var MM_KRLPRG_C = 2;
var MM_NCVAR_C = 6;
var MM_RECENT = 32;
var MM_SUB_UNDEF_C = 0;	// undefined?
var MM_SUB_JOB_C = 1;
var MM_SUB_PROC_C = 2;
var MM_SUB_MACRO_C = 3;
var MM_SUB_COND_C = 4;
var MM_SUB_COLLECT_C = 7;

// txml.h
var TXML_TP_REC_TYPE = 0;
var TXML_POSREG_REC_TYPE = 1;
var TXML_KAREL_REC_TYPE = 2;
var TXML_UFRAME_REC_TYPE = 3;
var TXML_UTOOL_REC_TYPE = 4;
var TXML_USER_DSP_TYPE = 5;
var TXML_WORLD_DSP_TYPE = 6;
var TXML_JOINT_DSP_TYPE = 7;

// vmtypdef.hc
var KXYZWPR = 2;
var KINTEGER = 16;
var KREAL = 17;
var MSTRREG = 39;
var KSTRING = 209;

// rpcm.h
var RPMAX_PARAMS = 10;
var TPXENSBV_KRL_TEXT = 147;

// avpmons.h
var UNINIT_STR_C = "*****";

// tpdb.h
var tpdb_style_indx_sreg_c = 12;

// chart.h
var mGrid_PressBit        = 1;                // touch press event
var mGrid_ReleaseBit      = 2;                // touch release event
var mGrid_TouchButton     = 4;                // touch button, else tile
var mGrid_PressEventVar   = "grid_prsevnt";   // press event flag
var mGrid_PressRowVar     = "grid_prsrow";    // pressed row, Y coord
var mGrid_PressColVar     = "grid_prscol";    // pressed col, X coord
var mGrid_ReleaseEventVar = "grid_rlsevnt";   // release event flag
var mGrid_ReleaseRowVar   = "grid_rlsrow";    // released row, Y coord
var mGrid_ReleaseColVar   = "grid_rlscol";    // released col, X coord

// momor.ht AND isvars.ht
var MFS_DEADMAN = 4;
