/**********************************************************************
 * Selective Compliance Assembly Robot Arm robot program.
 * Override slider script
 *
 * Created : 2017/09/13 FSI
 * Modified: 
 *
 */

// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
*/
/*
 * jQuery UI Widget
 * http://jqueryui.com
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */

/*--------------------------------------------------------------------
 * This feature is a function of the slider for changing the override value.
 *
 * In order to select FINE, VFINE, and specify 1% from 1 to 5, 
 * set the slider setting to the minimum value 0, the maximum value 130, 
 * and set the step value of the slider to 5.
 *
 * FSI 20230403 Changed conversion method.
 * The value of the slider is converted as follows:
 *    5 to a VFINE, 10 to a FINE,
 *   15 to 30 to 1% to 4%, 
 *   35 to 130 to 5% to 100%.
 *
 * When the value of the slider is less than 30, 
 * the setting value is obtained from the conversion table.
 */

// Convert slider value to override value.
var sliderConvertTable = [
  { 'step': 5, 'sendVal': 'VFINE' },
  { 'step': 10, 'sendVal': 'FINE' },
  { 'step': 15, 'sendVal': '1' },
  { 'step': 20, 'sendVal': '2' },
  { 'step': 25, 'sendVal': '3' },
  { 'step': 30, 'sendVal': '4' }
];
// Current setting override value.
var currentOverrideVal = 0;
//  FSI 2019124 Current setting override step.
var currentOverrideStep = 0;
//  FSI 2019124 Determine the slide of the knob.
var touchSlideKnob = false;
//  FSI 20181120 Check iPad or other
var getDevice = (function () {
	var ua = navigator.userAgent;
	if (ua.indexOf('iPad') > 0) {
		return 'ipad';
	} else {
		return 'ext';
	}
})();

// Definition of slider popup.
var popupDialog = (function () {
	// Open Dialog
	function open(popupBox) {
		$('body').append(popupBox);
	}
	// Close Dialog
	function close(popupId) {
		touchSlideKnob = false;
		var idStr = '#' + popupId;
		$(idStr).remove();
	}
	return {
		slider: function (currentOvr, fineCond, vfineCond, zeroCond) {
			// FSI 2019124 Prevent multiple firing of slide events.
			var slideEvent = false;
			// FSI 20181120 slider position adjustment
			var changePosition = false;
			if (window != window.parent) {
				if (parent.location.href.indexOf("softpanel") != -1 && getDevice == "ipad") {
					changePosition = true;
				}
			}
			var $popupSlider = $('#ovrslider');
			if ($popupSlider.length == 0) {	// When popup is not displayed
				// Change the inverse triangle button to triangle button
				var $ddnbtn = $('#ovrddn');	// dropdown button id
				$ddnbtn.removeClass('ui-icon-triangledn-white');
				$ddnbtn.addClass('ui-icon-triangleup-white');
				// Define the outer frame of the popup
				var popupBox = $('<div>',
					{ id: 'getoverride', 'class': 'popupmdldlg' });
				// Definition of slider part
				var popupSlide = $('<div>',
					{ id: 'ovrslider', 'class': 'popupSlider' });
				var popupSlideWidth = 250;	// Set the width of the slider to 250px
				popupSlide.css({ 'width': popupSlideWidth, 'float': 'right' });

				popupBox.append(popupSlide);	// Add slider to popup

				// In order to obtain the display position of the pop-up, 
				// override button information is acquired.
				var $ovrtoolbtn = $('#ovrpup');
				// *Adjust* so that the arrow comes under the triangle button.
				var targetY = $ovrtoolbtn.offset().top + $ovrtoolbtn[0].clientHeight - 23;
				var targetX = $ddnbtn.offset().left;
				targetX = targetX - popupSlideWidth - ($ddnbtn[0].clientWidth / 2.1);
				// if this function called by softpanel, adjustment slider position
				if (changePosition == true) {
					targetX = targetX - 15;
					$('head').append('<style>.popupmdldlg::before { left: 274px } </style>');
					$('head').append('<style>.popupmdldlg::after { left: 273px } </style>');
				}
				popupBox.css({ 'top': targetY, 'left': targetX, 'padding-right': '19px', 'padding-left': '19px' });
				// Add popup to body
				open(popupBox);
				// --- Convert override value and string to step value...
				var stepVal = 130;
				var slideStr = '';
				for (var i = 0; i < sliderConvertTable.length; i++) {
					if (sliderConvertTable[i].sendVal != '') {	// Not value, use String...
						slideStr = sliderConvertTable[i].sendVal;
					}
					if (currentOvr == slideStr) {	// ZERO, VFINE, FINE
						if (currentOvr == 1) {
							stepVal = ((fineCond == 'TRUE') && (vfineCond != 'TRUE')) ? 10 :
								((fineCond == 'TRUE') && (vfineCond == 'TRUE')) ? 5 : 15;
							if (zeroCond == 'TRUE') stepVal = 0;
						} else {
							stepVal = sliderConvertTable[i].step;
						}
						break;
					}
					slideStr = '';
				}
				if (slideStr == '') {	// Not string
					stepVal = parseInt(currentOvr, 10);
					if (stepVal < 5) {	// 1 step
						stepVal = (stepVal + 1) * 5;
					} else {
						stepVal += 30;
					}
				}
				// Definition of slider with jQuery UI
				$('#ovrslider').slider({
					orientation: 'horizontal',
					range: 'min',
					max: 130,
					min: 0,
					step: 5,
					value: stepVal,
					//  FSI 2019124 Change override value one step at a time when clicking the gauge.
					slide: function (event, ui) {
                        if (event.handleObj === undefined) {
                            return false;
                        }
						if (touchSlideKnob) {
							if (top.g_incjog && (ui.value === 0 || ui.value === 5 || ui.value === 10)) {
								event.preventDefault();
								$('#ovrslider').slider("value", 15); // 15 = override 1%
								return;
							} else {
								if (ui.value === 0) {
									event.preventDefault();
									$('#ovrslider').slider("value", 5); // 5 = override VFINE
									return;
								}
							}
							refreshOverride(ui.value);	// Callback when sliding
						} else if (!touchSlideKnob && !slideEvent && (event.handleObj.origType == "mousedown")) {
							slideEvent = true;
							if (currentOverrideStep <= ui.value) {
								var nextStep = (top.g_incjog && currentOverrideStep == 0) ? 15 : 5;
								ui.value = currentOverrideStep + nextStep;
							} else {
								if (currentOverrideStep == 5 || (top.g_incjog && currentOverrideStep == 15)) {
									ui.value = currentOverrideStep; // 5 = override VFINE, 15 = override 1%
								} else {
									ui.value = currentOverrideStep - 5;
								}
							}
							refreshOverride(ui.value);
							return false;
						} else if (!touchSlideKnob && slideEvent && (event.handleObj.origType == "mousemove")) {
							return false;
						} else if (!touchSlideKnob && slideEvent) {
							$(this).slider("value", currentOverrideStep);
							slideEvent = false;
							return false;
						}
					},
					change: function (event, ui) {
						if (touchSlideKnob) {
							refreshOverride(ui.value);
						}
					},
					stop: function (event, ui) {
						if (touchSlideKnob) {
							touchSlideKnob = false;
							refreshOverride(ui.value);
						} else if (!touchSlideKnob && slideEvent) {
							$(this).slider("value", currentOverrideStep);
							slideEvent = false;
						} else {
							getGenOvrVal(currentOverrideVal);
						}
					}
				});
			} else {	// Delete when button is pressed when popup is displayed
				close('getoverride');
				var $ddnbtn = $('#ovrddn');	// dropdown button id
				$ddnbtn.removeClass('ui-icon-triangleup-white');
				$ddnbtn.addClass('ui-icon-triangledn-white');
			}
		}
	};
})();

function refreshOverride(slideVal) {
  if (!touchSlideKnob) {
    clearSendTimer();
    sendOverrideVal(slideVal);
  } else {
    setSendTimer(slideVal);
  }
}

var gtimerSendData = null;
// timer for send override value
function setSendTimer(slideVal) {
  clearSendTimer();
  gtimerSendData = setTimeout(function () { sendOverrideVal(slideVal); }, 200);
}

// clear timer
function clearSendTimer() {
  clearTimeout(gtimerSendData);
  gtimerSendData = null;
}

/**
 * Override slider operation.
 **/
function sendOverrideVal(slideVal) {
	// Search convert table
	var slideStr = '';
	// Convert 5 -> VFINE, 10 -> FINE, 15 to 30 -> 1 to 4
	for (var i = 0; i < sliderConvertTable.length; i++) {
		if (sliderConvertTable[i].step == slideVal) {
			if (sliderConvertTable[i].sendVal != '') {	// Not value, use String...
				slideStr = sliderConvertTable[i].sendVal;
			} else {
				slideStr = ((slideVal / 5) - 1);
			}
			break;
		}
	}
	if (slideStr == '') {	// Other than above, convert 35 to 5, 130 to 100
		slideStr = (slideVal - 30);
	}
	// Send the set value to the control device
	var ovrridVal = parseInt(slideStr, 10);
	if (slideStr == 'FINE') {
		if (currentOverrideVal != 1) {
			top.rpcmc_setVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', 1);
		}
		top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_V_FINE', 0);
		top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_FINE_MD', 1);
		ovrridVal = 1;
	} else if (slideStr == 'VFINE') {
		if (currentOverrideVal != 1) {
			top.rpcmc_setVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', 1);
		}
		top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_FINE_MD', 1);
		top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_V_FINE', 1);
		ovrridVal = 1;
	} else {	// value is 1 to 100			
		top.rpcmc_setVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', slideStr);
		top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_FINE_MD', 0);
		top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_V_FINE', 0);
	}
	if (previewOvrVal == 0) { // Over Ride ZERO -> VFINE
		top.sendKey("+OVR", 1);
		top.sendKey("+OVR", 0);
	}
	currentOverrideVal = ovrridVal;
	currentOverrideStep = slideVal;


  if (!touchSlideKnob) getGenOvrVal(currentOverrideVal);
  clearSendTimer();
}

function getGenOvrVal(curOvrVal) {
  setTimeout(function () {
    if (!touchSlideKnob) top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', getGenOvrCB, curOvrVal);
  }, 300);
}

function getGenOvrCB(prgName, varName, typeCode, ovrStr, sendOvrVal) {
  if (Number(ovrStr) == sendOvrVal) return;
  // Acquire current override value by I / F
  if (runningOvrUpdate) top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', getPassiveOverrideCB);
}

/* 
 * Click Override button.
 */
function getOverridezeroCB(prgName, varName, typeCode, zero, getOvrValObj, arg2) {
  //  FSI 2019124 Setting override step for init.
  //  FSI 20230405 Override ZERO specifications added.
  getOvrValObj["ZERO"] = zero;
  switch (parseInt(currentOverrideVal, 10)) {
    case 1:
      if (getOvrValObj["ZERO"] === "TRUE") {
        currentOverrideStep = 0; // 0 = override ZERO
      } else if (getOvrValObj["FINE"] == 'TRUE' && getOvrValObj["VFINE"] == 'TRUE') {
        currentOverrideStep = 5; // 5 = override VFINE
      } else if (getOvrValObj["FINE"] == 'TRUE' && getOvrValObj["VFINE"] == 'FALSE') {
        currentOverrideStep = 10; // 10 = override FINE
      } else {
        currentOverrideStep = 15;
      }
      break;
    case 2:
      currentOverrideStep = 20;
      break;
    case 3:
      currentOverrideStep = 25;
      break;
    case 4:
      currentOverrideStep = 30;
      break;
    default:
      currentOverrideStep = parseInt(currentOverrideVal, 10) + 30;
      break;
  }
  popupDialog.slider(currentOverrideVal, getOvrValObj["FINE"], getOvrValObj["VFINE"], getOvrValObj["ZERO"]);

  //  FSI 2019124 Determine the slide of the knob.
  $('.ui-slider-handle').on('mousedown touchstart', function (event) {
    event.preventDefault();
    touchSlideKnob = true;
  });
}
function getVFineConditionCB(prgName, varName, typeCode, vfine, getOvrValObj, arg2){
  getOvrValObj["VFINE"] = vfine;
  top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$OVR_ZERO', getOverridezeroCB, getOvrValObj, null);
}
function getFineConditionCB(prgName, varName, typeCode, fine, getOvrValObj, arg2) {
  getOvrValObj["FINE"] = fine;
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_V_FINE', getVFineConditionCB, getOvrValObj, null);
}
function getOverrideCB(prgName, varName, typeCode, ovrStr, arg1, arg2) {
  var getOvrValObj = {"FINE" : 0, "VFINE" : 0, "ZERO": 0};
  currentOverrideVal = parseInt(ovrStr, 10);
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_FINE_MD', getFineConditionCB, getOvrValObj, null);
}
$(function () {
	// Event handler when override button is clicked
	$('#ovrpup').on('click touchend', function (event) {
    if(event.type.indexOf('touch') >= 0){
      event.preventDefault();
    }
		// Acquire current override value by I / F
		top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', getOverrideCB);
		return false;
	});

	$('#getoverride').on('click', function (event) {
		if ($('#getoverride').length == 0) {	// exist override slider
			$('#getoverride').remove();
			var $ddnbtn = $('#ovrddn');	// dropdown button id
			$ddnbtn.removeClass('ui-icon-triangleup-white');
			$ddnbtn.addClass('ui-icon-triangledn-white');
			event.stopPropagation();
		}
	});
});

// FSI 20181013 Delete Override Dialog(resize)
function deleteOverrideDialog() {
	var $popupSlider = $('#ovrslider');
	if ($popupSlider.length > 0) {
		popupDialog.slider(null);
	}
}

// FSI 20181015 Delete Override Dialog(click on statbarframe)
$(document).on('click touchend', function (e) {
  var statbarPar = $(e.target).closest('.statbar').length;
  var props = { value: "" };

  if(statbarPar){
    var $popupSlider = $('#ovrslider');
    if ($popupSlider.length > 0) {
      popupDialog.slider(null);
    }
    if (top.g_irprog) {
      // to move to the alarm
      props.value = top.ALARM_ADDRESS;
      top.treemod.update_tree(top.UT_ALARM);
      top.treemod.nodeOnClick(null, props);  
    }
  }
});

$(window.parent).mouseleave(function() {
	if (touchSlideKnob) {
		$('.ui-slider-handle').mouseup();
		touchSlideKnob = false;
	}
});

// FSI 20181015 Delete Override Dialog(click on other than statbarframe)
window.onblur = function (e) {
	var $popupSlider = $('#ovrslider');
	if ($popupSlider.length > 0) {
		popupDialog.slider(null);
	}
};

// FSI 20190208 Update slider when override value is changed on other controller
var previewOvrVal = null;
var runningOvrUpdate = true;
function getPassiveOverrideCB(prgName, varName, typeCode, ovrStr, arg1, arg2) {
  var getPasOvrValObj = {"FINE" : 0, "VFINE" : 0, "ZERO": 0};
  currentOverrideVal = parseInt(ovrStr, 10);
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_FINE_MD', getPassiveFineConditionCB, getPasOvrValObj, null);
}
function getPassiveFineConditionCB(prgName, varName, typeCode, fine, getPasOvrValObj, arg2) {
  getPasOvrValObj["FINE"] = fine;
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR_GRP[1].$JOG_V_FINE', getPassiveVFineConditionCB, getPasOvrValObj, null);
}
function getPassiveVFineConditionCB(prgName, varName, typeCode, vfine, getPasOvrValObj, arg2){
  getPasOvrValObj["VFINE"] = vfine;
  top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$OVR_ZERO', getPassiveOverridezeroCB, getPasOvrValObj, null);
}
function getPassiveOverridezeroCB(prgName, varName, typeCode, zero, getPasOvrValObj, arg2) {
  getPasOvrValObj["ZERO"] = zero;
  passiveSliderUpdate(currentOverrideVal, getPasOvrValObj["FINE"], getPasOvrValObj["VFINE"], getPasOvrValObj["ZERO"]);
}
function passiveSliderUpdate(currentOvr, fineCond, vfineCond, zeroCond) {
	// --- Convert override value and string to step value...
	var stepVal = 130;
	var slideStr = '';
	for (var i = 0; i < sliderConvertTable.length; i++) {
		if (sliderConvertTable[i].sendVal != '') {	// Not value, use String...
			slideStr = sliderConvertTable[i].sendVal;
		}
		if (currentOvr == slideStr) {	// ZERO, VFINE, FINE
			if (currentOvr == 1) {
				stepVal = ((fineCond == 'TRUE') && (vfineCond != 'TRUE')) ? 10 : ((fineCond == 'TRUE') && (vfineCond == 'TRUE')) ? 5 : 15;
				if (zeroCond == 'TRUE') stepVal = 0;
			} else {
				stepVal = sliderConvertTable[i].step;
			}
			break;
		}
		slideStr = '';
	}
	if (slideStr == '') {	// Not string
		stepVal = parseInt(currentOvr, 10);
		if (stepVal < 5) {	// 1 step
			stepVal = (stepVal + 1) * 5;
		} else {
			stepVal += 30;
		}
	}
	// Definition of slider with jQuery UI
	var currentVal = document.getElementById("ovr1");
	var currentOvr = currentVal.firstChild.innerHTML;
	if (currentOvr != "" && currentOvr == previewOvrVal) {
		currentOverrideStep = stepVal;
		$('#ovrslider').slider({
			value: stepVal,
		});
	}
	runningOvrUpdate = true;
}