/*
 *  This material is the joint property of FANUC America Corporation and
 *  FANUC LTD Japan, and must be returned to either FANUC America Corporation
 *  or FANUC LTD Japan immediately upon request.  This material and
 *  the information illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without the
 *  prior written consent of both FANUC America Corporation and FANUC LTD Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2017
 *           FANUC America Corporation
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.sendkey.js
 *  
 *  Description:
 *    Send key to controller and prevent default behavior.
 *    Do not allow browser to GoBack (backspace key).
 *
 *  Author: Judy Evans
 *          FANUC America Corporation
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  03-APR-2018 EVANSJA pr50823: Initial version.
 *  13-DEC-2018 EVANSJA pr51263: Do not send key if iPendant Controls are being used
 *                      This can cause double keys in certain menus.
 *  -
*/

;(function($) {
  $(document).ready(function() {
    // Attach handler for keyboard key events.
    $(document).keydown(function(event) {
      // Send key to controller.
      event.preventDefault();
      if (event.keyCode == 27) top.rpcmc_sendKeyCode(prev_c)
      else if (event.keyCode == 33) top.rpcmc_sendKeyCode(up_arw_s_c)
      else if (event.keyCode == 34) top.rpcmc_sendKeyCode(dn_arw_s_c)
      else if (event.keyCode == 37) top.rpcmc_sendKeyCode(lf_arw_c)
      else if (event.keyCode == 38) top.rpcmc_sendKeyCode(up_arw_c)
      else if (event.keyCode == 39) top.rpcmc_sendKeyCode(rt_arw_c)
      else if (event.keyCode == 40) top.rpcmc_sendKeyCode(dn_arw_c)
      else top.rpcmc_sendKeyCode(event.keyCode);
    });
  });
})(jQuery);
