/*
*  This material is the joint property of FANUC Robotics America  and
*  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
*  America or FANUC LTD Japan immediately upon request.  This material  and
*  the  information  illustrated or contained herein may not be reproduced,
*  copied, used, or transmitted in whole or in part in any way without  the
*  prior written consent of both FANUC Robotics America and FANUC LTD
*  Japan.
*  
*           All Rights Reserved
*           Copyright (C)   2011
*           FANUC Robotics America
*           FANUC LTD Japan
* 
*  +
*  Module: jquery.mon.js
*  
*  Description:
*    Monitor system variables plugin
*
*  Author: Genevieve Flaspohler
*          FANUC Robotics America
*          3900 W. Hamlin Road
*          Rochester Hills, Michigan    48309-3253
*  
*  Modification history:
*  25-JUN-2014 FLASPOGE Initial version.
*  -
*/

; (function($) {
// 
  //  Usage, using defaults
  //  $('#mon1').mon();
  //
  //  Usage, specify parameters
  //  $('#mon1').mon({ sys_var: '*STRREG*',
  //                   var1: '$STRREG[1]' });
  //
  //  Use for system variables:
  //    sys_var = "*SYSTEM*";
  //
  $.fn.mon = function(settings) {
    $(this).bind('mon', settings,
      function(event, device, line, buffer) { });
  };

  var mon = $.event.special.mon = {
    // Override plugin defaults
    sys_var: '*STRREG*',
    var1: '$STRREG[1]',
    var1_value: 'FALSE', //initial, default value
    $this: null,

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({
        sys_var: mon.sys_var,
        var1: mon.var1,
        var1_value: mon.var1_value,
        $this: $(this)
      }, handleObj.data || {});

      var data = handleObj.data;

      // Create label inside the element.
      data.$this.html('<label />');

      if (top.jQuery.varlis) {
        // Attach handler for VarEvent.
        top.jQuery.varlis.bind('VarEvent', data, HandleVarEvent);

        // Start PMON monitors for vars.
        top.rpcmc_startVarMonitor(data.sys_var, data.var1, 20);
      }
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({
        sys_var: mon.sys_var,
        var1: mon.var1,
        var1_value: mon.var1_value,
        $this: $(this)
      }, handleObj.data || {});

      var data = handleObj.data;
      if (top.jQuery.varlis) {
        // Stop PMON monitors for vars.
        top.rpcmc_stopVarMonitor(data.sys_var, data.var1);

        // Detach handler for VarEvent.
        top.jQuery.varlis.unbind('VarEvent', HandleVarEvent);
      }
    } // remove
  };

  // Private functions

  function HandleVarEvent(event, prog_name, var_name, type_code, value) {
    var data = event.data || event;
    if (var_name == data.var1) {
      data.var1_value = value;
      ChangeValue(data);
    }
  } // HandleVarEvent

  function ChangeValue(data) {
    $('label', data.$this).text("  " + data.var1_value);
    data.$this.css('font-size', '200%');
    //data.$this.css('color', '#C80000 ');
   // data.$this.css('background-color', 'white');
  } // ChangeValue

})(jQuery);
