/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2011
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.led.js
 *  
 *  Description:
 *    LED plugin
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  01-JAN-2011 EVANSJA Initial version.
 *  04-JAN-2017 EVANSJA Remove images and change colors.
 *  -
*/

var show_img = 0;

;(function($) {

  //	Use these properties to customize settings...
  //	$.event.special.led.ledtype = tpout_type_c;
  //  $.event.special.led.ledindex: 7;
  //  $.event.special.led.ledimg: '/frh/cgtp/prod_sb.gif';
  //  $.event.special.led.ledtext: 'Prod';
  //  $.event.special.led.ledoff: 'yellow';
  //  $.event.special.led.ledon: 'lime';
  // 
  //  No callback function, using defaults
  //  $('#led6').led();
  //
  //  No callback functions, specify parameters
  //  $('#led6').led({ ledtype: tpout_type_c,
  //                   ledindex: 7, 
  //                   ledimg: '/frh/cgtp/prod_sb.gif', 
  //                   ledtext: 'Prod',
  //                   ledoff: 'yellow',
  //                   ledon: 'lime' });
  //
  //  Callback function, using defaults
  //  $('#led6').bind('led', function(event, io_type, io_index, io_value) {});
  //
  //  Callback functions, specify parameters
  //  $('#led6').bind('led', { ledtype: tpout_type_c,
  //                           ledindex: 7, 
  //                           ledimg: '/frh/cgtp/prod_sb.gif', 
  //                           ledtext: 'Prod',
  //                           ledoff: 'yellow', 
  //                           ledon: 'lime' },
  //                           function(event, io_type, io_index, io_value) {});
  //
  $.fn.led = function(settings) {
    $(this).bind('led', settings,
      function(event, io_type, io_index, io_value) { });
  };

  var led = $.event.special.led = {
    // LED plugin defaults
    ledtype: tpout_type_c,
    ledindex: 7,
    ledimg: '/frh/cgtp/prod_sb.gif',
    ledtext: 'Prod',
    ledoff: 'yellow',
    ledon: 'lime',
    $this: null,

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({ 
        ledtype: led.ledtype,
        ledindex: led.ledindex,
        ledimg: led.ledimg,
        ledtext: led.ledtext,
        ledoff: led.ledoff,
        ledon: led.ledon,
        $this: $(this) }, handleObj.data || {});

      // Create img and text inside the element.
      var data = handleObj.data;
      data.$this.css("font-family", top.getDefFont());
      if (show_img) {
        var out = '<img src="' + data.ledimg + '" />';
        out += '&nbsp;' + top.srvap_getString(data.ledtext);
      }
      else {
        out = top.srvap_getString(data.ledtext);
      }
      data.$this.html(out);
      LEDOffState(data);
      if (top.jQuery.iolis) {
        // Attach handler for IOBooleanEvent.
        top.jQuery.iolis.bind('IOBooleanEvent', data, HandleIOEvent);

        // Attach handler for SetLangEvent.
        top.jQuery.dictlis.bind('SetLangEvent', data, HandleDictEvent);

        // Start PMON monitor for the I/O port.
        top.rpcmc_startIOMonitor(data.ledtype, data.ledindex);
      }
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({ 
        ledtype: led.ledtype,
        ledindex: led.ledindex,
        ledimg: led.ledimg,
        ledtext: led.ledtext,
        ledoff: led.ledoff,
        ledon: led.ledon,
        $this: $(this) }, handleObj.data || {});

      var data = handleObj.data;
      if (top.jQuery.iolis) {
        // Stop PMON monitor for the I/O port.
        top.rpcmc_stopIOMonitor(data.ledtype, data.ledindex);

        // Detach handler for IOBooleanEvent.
        top.jQuery.iolis.unbind('IOBooleanEvent', HandleIOEvent);

        // Detach handler for SetLangEvent.
        top.jQuery.dictlis.unbind('SetLangEvent', HandleDictEvent);
      }
    } // remove
  };

  // Private functions
  function LEDOffState(data) {
    if (show_img) {
      // Apply off color and hide the image.
      data.$this.css('background-color', data.ledoff);
      data.$this.css('color', '#808080');
      $('img', data.$this).hide();
    }
    else {
      if (data.ledon == 'yellow') {
        data.$this.css('background-color', DARK_YELLOW);
      }
      else if (data.ledon == 'lime') {
        data.$this.css('background-color', DARK_GREEN);
      }
      else if (data.ledon == 'red') {
        data.$this.css('background-color', DARK_RED);
      }
      else {
        data.$this.css('background-color', data.ledoff);
      }
      data.$this.css('color', '#808080');
    }
  } // LEDOffState

  function LEDOnState(data) {
    if (show_img) {
      // Apply on color and show the image.
      data.$this.css('background-color', data.ledon);
      data.$this.css('color', 'black');
      $('img', data.$this).show();
    }
    else {
      if (data.ledon == 'yellow') {
        data.$this.css('background-color', BRIGHT_YELLOW);
      }
      else if (data.ledon == 'lime') {
        data.$this.css('background-color', BRIGHT_GREEN);
      }
      else if (data.ledon == 'red') {
        data.$this.css('background-color', BRIGHT_RED);
      }
      else {
        data.$this.css('background-color', data.ledon);
      }
      if (data.ledon == 'yellow') {
        data.$this.css('color', 'black');
      }
      else {
        data.$this.css('color', 'white');
      }
    }
  } // LEDOnState

  function HandleIOEvent(event, io_type, io_index, io_value) {
    var data = event.data || event;
    if ((io_type == data.ledtype) && (io_index == data.ledindex)) {
      // We have a match.
      if (io_value == 0) {
        LEDOffState(data);
      }
      else {
        LEDOnState(data);
      }
      // Trigger a callback for the element.
      data.$this.triggerHandler('led', [io_type, io_index, io_value]);
    }
  } // HandleIOEvent

  function HandleDictEvent(event) {
    var data = event.data || event;
    // Change the font-family
    data.$this.css("font-family", top.getDefFont());

    // Change the text.
    data.$this.text(top.srvap_getString(data.ledtext));
  } // HandleDictEvent

})(jQuery);
