/*
 *  This material is the joint property of FANUC America Corporation and
 *  FANUC LTD Japan, and must be returned to either FANUC America Corporation
 *  or FANUC LTD Japan immediately upon request.  This material and
 *  the information illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without the
 *  prior written consent of both FANUC America Corporation and FANUC LTD Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2014
 *           FANUC America Corporation
 *           FANUC LTD Japan
 *  +
 *  Module: jquery.iframewrap.js
 *  
 *  Description:
 *    Fixes iPhone/iPod/iPad to stay within iframe height and width
 *    by wraping the iframe with a <div /> which contains css
 *
 *  Author: Judy Evans
 *          FANUC America Corporation
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  10-DEC-2014 EVANSJA Initial version.
 *  -
*/

// Example:
// $("#prim").iframewrap({ width: $("#prim").attr("width"), 
//                         height: $("#prim").attr("height"),
//                           float: "left" });
//
;(function($) {
  $.fn.iframewrap = function(options) {
    var settings = $.extend({ width: 640, height: 480, float: "none" }, options);

    if (/iPhone|iPod|iPad/.test(navigator.userAgent)) {
      if (this.parent().get(0).id == "container") {
        // Already have a wrapper so just resize
        this.parent().css({
          width: settings.width,
          height: settings.height,
          overflow: 'scroll',
          '-webkit-overflow-scrolling': 'touch'
        });
      }
      else {
        this.wrap(function() {
          return $('<div id="container" />').css({
            width: settings.width,
            height: settings.height,
            float: settings.float,
             overflow: 'scroll',
            '-webkit-overflow-scrolling': 'touch'
          });
        });
        // We just wrapped our iframe so change the iframe
        // so it is 100% of the div
        this.css({width: "100%"});
      }
    }
    else {
      return this;
    }
  };
}(jQuery));
