/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2011
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.hmimenu
 *  
 *  Description:
 *    HMI Menu plugin
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  01-JAN-2011 EVANSJA Initial version.
 *  -
*/

;(function($) {

  //  Usage - To bind a key
  // $('#menu1').bind('hmimenu', { menukey: '1' }, false);
  //
  //  Usage - To set the data 
  // $('#menu1').hmimenu({
  //     menuhref: 'javascript:type1()',
  //     menuimg: '/frh/gui/menu1.gif',
  //     menutext: 'UTILITIES',
  // });
  // 
  // $('#menu1').hmimenu({
  //     menuhref: 'current=menupage,153,1',
  //     menuimg: '/frh/gui/menu1.gif',
  //     menutext: 'Hints'
  // });
  //
  $.fn.hmimenu = function(data) {
    // Called each time menu data is set or changed
    data = $.extend({
      menuhref: hmimenu.menuhref,
      menuimg: hmimenu.menuimg,
      menutext: hmimenu.menutext,
      menukey: hmimenu.menukey,
      $this: $(this)
    }, data || {});

    // Create or replace href, img, and text inside the element.
    var idstr = $(data.$this).attr('id');
    var out = '';
    if (data.menuhref != null) {
      if ((typeof (g_echo) == 'undefined') || (!g_echo)) {
        if ((data.menuhref.indexOf('menupage')  >= 0) ||
            (data.menuhref.indexOf('menuclass') >= 0) ||
            (data.menuhref.indexOf('editpage')  >= 0) ||
            (data.menuhref.indexOf('mainedit')  >= 0) ||
            (data.menuhref.indexOf('wintpe')    >= 0) ||
            (data.menuhref.indexOf('iopage')    >= 0) ||
            (data.menuhref.indexOf('config')    >= 0) ||
            (data.menuhref.indexOf('browser')   >= 0)) {
          if (typeof (top.g_connect_id) == 'undefined') {
            out += '<a href="/SOFTPART/GENLINK?' + data.menuhref + '"';
          }
          else {
            out += '<a href="/SOFTPART/GENLINK?connect_id=' + top.g_connect_id + '&' + data.menuhref + '"';
          }
        }
        else {
          out += '<a href="' + data.menuhref + '"';
        }
        out += ' onfocus="addFocus(this)" onblur="removeFocus(this)" >';
        if ((idstr.indexOf('menu0') >= 0) || (idstr.indexOf('menu10') >= 0)) {
          out += '<img src="' + data.menuimg + '" width="32" height="32"></a><br>';
        }
        else {
          out += '<img src="' + data.menuimg + '" width="80" height="60"></a><br>';
        }
      }
      else {
        // No link for echo mode.
        if ((idstr.indexOf('menu0') >= 0) || (idstr.indexOf('menu10') >= 0)) {
          out += '<img src="' + data.menuimg + '" width="32" height="32"><br>';
        }
        else {
          out += '<img src="' + data.menuimg + '" width="80" height="60"><br>';
        }
      }
      out += data.menutext;
    }
    data.$this.html(out);
  };

  var hmimenu = $.event.special.hmimenu = {
    // hmimenu plugin defaults
    menuhref: null,
    menuimg: '/frh/gui/h00000.gif',
    menutext: '',
    menukey: 0,
    $this: null,

    keyMap: { 48: '0', 49: '1', 50: '2', 51: '3', 52: '4', 53: '5', 54: '6', 55: '7', 56: '8', 57: '9',
        27: 'prev'
    },

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({
        menuhref: hmimenu.menuhref,
        menuimg: hmimenu.menuimg,
        menutext: hmimenu.menutext,
        menukey: hmimenu.menukey,
        $this: $(this) }, handleObj.data || {});

      // Attach handler for keyboard events.
      // Since only focused events will get the event, we
      // have to bind to the document. Because of event bubbling, 
      // all key presses will make their way up to the document object.
      $(document).bind('keydown', handleObj.data, HandleKeyDownEvent);
    } // setup  
 };

  function HandleKeyDownEvent(event) {
    var keyName = hmimenu.keyMap[event.keyCode];
    if (undefined != keyName) {
      var data = event.data || event;
      if (keyName == data.menukey) {
        var menuhref = $('a', data.$this).attr('href');
        if (undefined != menuhref) {
          // Perform the URL
          location.href = menuhref;
        }
      }
    }
  } // HandleKeyDownEvent

})(jQuery);

