/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2011
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.hardkey.js
 *  
 *  Description:
 *    Hardkey plugin
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  01-JAN-2011 EVANSJA Initial version.
 *  -
*/

//  Usage - callback function
// $('#_f1').bind('hardkey', {key: 'f1'}, function() {});

$.ajaxSetup({
  // Disable caching of AJAX responses */ 
  cache: false
});

;(function($) {
  // A collection of elements to which the hardkey event is bound.
  var elems = $([]);

  var hardkey = $.event.special.hardkey = {
    // hardkey plugin defaults
    key: 're_issue_c',
    $this: null,

    keyMap: { 209: 'left', 212: 'up', 208: 'right', 213: 'down',
      128: 'prev', 129: 'f1', 131: 'f2', 132: 'f3', 133: 'f4', 134: 'f5', 135: 'next',
      48: '0', 49: '1', 50: '2', 51: '3', 52: '4', 53: '5', 54: '6', 55: '7', 56: '8', 57: '9',
      13: 'return', 8: 'backspace', 171: 're_issue_c'
    },

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({
        key: hardkey.key,
        $this: $(this)
      }, handleObj.data || {});

      // Add this element to the internal collection.
      elems = elems.add(handleObj);

      // If this is the first element to which the event has been bound,
      // bind a handler to catch all hardkey events.
      if (elems.length === 1) {
        // Attach handler for KeyPressedEvent.
        $(document).bind('KeyPressedEvent', HandleKeyEvent);

        // Start events from the robot
        startEvents();
      }
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {

      // Remove this element from the internal collection.
      elems = elems.filter(function() {
        if (handleObj.data.key == this.data.key) {
          return false; // remove
        }
        return true; // keep
      });

      // If this is the last element removed, remove the hardkey
      // event handler.
      if (elems.length === 0) {
        // Detach handler for KeyPressedEvent.
        $(document).unbind('KeyPressedEvent', HandleKeyEvent);

        // Stop events from the robot
        stopEvents();
      }

    } // remove
  };

  // Private functions
  // If the given hardkey matches key, then send event
  function HandleKeyEvent(event, key) {
    var keyName = hardkey.keyMap[key];
    // Find keyName in the collection
    elems.each(function(index) {
      if (keyName == this.data.key) {
        // Trigger a callback for the element.
        this.data.$this.trigger('hardkey', [this.data.key]);
      }
    });
  } // HandleKeyEvent

  // Ask COMET for events.
  function startEvents() {
    // Handle ajax errors
    $(document).ajaxError(function(event, request, settings, exception) {
      if (request.status == 204) {
        // No content
      }
      else if (request.status == 12152) {
        // Connection Closed by Server?
      }
      else if (exception) {
        // top.rpcmc_rprintf('[jquery.hardkey.js] exception: ' + exception + ' setting: ' + settings.url);
      }
      else {
        // top.rpcmc_rprintf('[jquery.hardkey.js] status: ' + request.status + ' setting: ' + settings.url);
      }
      getnextevent();
    });

    // Clear the old events from the robot
    stopEvents();

    // Get events from the robot
    getnextevent();

  } // startEvents

  // Ask COMET to stop events.
  function stopEvents() {
    // Clear the old events from the robot
    var connect_id = 0;
    if (typeof (top.g_connect_id) != 'undefined') {
      connect_id = top.g_connect_id;
    }
    else if (typeof (top.opener) != 'undefined') {
      if (typeof (top.opener.top.g_connect_id) != 'undefined') {
        connect_id = top.opener.top.g_connect_id;
      }
    }
    $.getJSON('/COMET/rpc?func=PMON_CAN_PKT&connect_id=' + connect_id, function(json) { });

  } // stopEvents

  // Ask COMET for the next event.
  function getnextevent() {
    var connect_id = 0;
    if (typeof (top.g_connect_id) != 'undefined') {
      connect_id = top.g_connect_id;
    }
    else if (typeof (top.opener) != 'undefined') {
      if (typeof (top.opener.top.g_connect_id) != 'undefined') {
        connect_id = top.opener.top.g_connect_id;
      }
    }
    $.getJSON('/COMET/rpc?func=PMON_GET_PKT&connect_id=' + connect_id, function(json) {
      if (undefined != json.FANUC.PMEV) {
        for (var idx = 0; idx < json.FANUC.PMEV.length; idx++) {
          switch (parseInt(json.FANUC.PMEV[idx].subsys_code)) {
            case 0:  // SSC_OS:
              if (undefined != json.FANUC.PMEV[idx].key) {
                // Trigger a KeyPressedEvent on the key event listeners.
                if (json.FANUC.PMEV[idx].keytype == 'KeyPressedEvent') {
                  $(document).trigger('KeyPressedEvent', json.FANUC.PMEV[idx].key);
                }
                else {
                  $(document).trigger('KeyReleasedEvent', json.FANUC.PMEV[idx].key);
                }
              }
              break;
          } // switch(subsys_code)
        } // for each event
      } // if PMEV
      getnextevent();
    });
  } // getnextevent


})(jQuery);
