/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *
 *           All Rights Reserved
 *           Copyright (C)   2015
 *           FANUC Robotics America
 *           FANUC LTD Japan
 *
 *  +
 *  Module: jquery.cgop.js
 *
 *  Description:
 *    CGOP plugins
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *
 *  Modification history:
 *  17-MAR-2015 EVANSJA Initial version contains only stubs.
 *  09-JUN-2015 EVANSJA Merge changes by Dan Merchant.
 *  24-AUG-2017 DOWMW   pr50376 - Updated Chart to call correct routines
 *  19-OCT-2017 DOWMW   pr50481 - Updated Draw2D to call correct routines
 *  30-JAN-2018 EVANSJA pr50687 - Support for cgop on dialog boxes.
 *  09-APR-2018 GRASSCM pr50835 - Support for Checkbox viewtype.
 *  26-APR-2018 GRASSCM pr50876 - Support for tpxensub_ext.
 *  -
*/

;(function($) {

  /****************************************************************
   * Common Properties
   ****************************************************************/
  var CGCommon = {
    ButtonText: "",
    FrameName: "",
    Last: ""
  };

  /****************************************************************
   * CGAtChg Plugin
   ****************************************************************/
  $.fn.CGAtChg = function(settings) {
    $(this).bind('CGAtChg', settings,
      function(event) { });
  };

  $.event.special.CGAtChg = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGAtChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGAtChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGAtChg.defaults = {
    Id:"FRIPAutoChange1",
    tabbable:"0",
    width:"32" ,
    height:"32" ,
    DataType:"100" ,
    DataIndex:"",
    Interval:"250" ,
    FastLoad:"0" ,
    PageName01:"",
    PageName02:"",
    PageName03:"",
    PageName04:"",
    PageName05:"",
    PageName06:"",
    PageName07:"",
    PageName08:"",
    PageName09:"",
    PageName10:"",
    ValueMin01:"0" ,
    ValueMin02:"0" ,
    ValueMin03:"0" ,
    ValueMin04:"0" ,
    ValueMin05:"0" ,
    ValueMin06:"0" ,
    ValueMin07:"0" ,
    ValueMin08:"0" ,
    ValueMin09:"0" ,
    ValueMin10:"0" ,
    ValueMax01:"-1" ,
    ValueMax02:"-1" ,
    ValueMax03:"-1" ,
    ValueMax04:"-1" ,
    ValueMax05:"-1" ,
    ValueMax06:"-1" ,
    ValueMax07:"-1" ,
    ValueMax08:"-1" ,
    ValueMax09:"-1" ,
    ValueMax10:"-1" ,
    Periodic:"0" ,
    IOSim:"0" ,
    Pipe:"" ,
    RWAccess:"0" ,
    CtlType: GMCT_ATCHG ,
    $this: null
  };

  /****************************************************************
   * CGBtChg Plugin
   ****************************************************************/
  $.fn.CGBtChg = function(settings) {
    $(this).bind('CGBtChg', settings,
      function(event) { });
  };

  $.event.special.CGBtChg = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGBtChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGBtChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGBtChg.defaults = {
    Id:"FRIPButtonChange1",
    tabbable:"1",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    PageName:"",
    PageName01:"",
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    ViewType:"0" ,
    TrueColor:"" ,
    FalseColor:"" ,
    TrueImage:"",
    FalseImage:"",
    Pipe:"",
    Interval:"250" ,
    ReadOnly:"",
    Invisible:"",
    Disable:"",
    NoContent:"0" ,
    Frame:"",
    ChkDeadman:"0" ,
    ChkTpEnable:"0" ,
    ChkShift:"0" ,
    ChkIo:"0" ,
    ChkIoType:"0" ,
    ChkIoIdx:"0" ,
    CaptionOnImage:"0" ,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    CtlType: GMCT_BTCHG ,
    $this: null
  };

  /****************************************************************
   * CGChart Plugin
   ****************************************************************/
  $.fn.CGChart = function(settings) {
    $(this).bind('CGChart', settings,
      function(event) { });
  };

  $.event.special.CGChart = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGChart.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      chart_NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGChart.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      chart_NPP_Destroy(data);
    } // remove
    
  };

  $.event.special.CGChart.defaults = {
    Id:"FRIPChart1",
    tabbable:"0",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    FastLoad:"0" ,
    ChartType:"1" ,
    TrueFont:"" ,
    Name:"",
    Pipe:"",
    Orientation:"1" ,
    Annotate:"",
    ForeColor:"" ,
    BackColor:"" ,
    CaptionFontSize:"14" ,
    LabelFontSize:"14" ,
    DataFontSize:"14" ,
    AnnotateFontSize:"14" ,
    Border:"0" ,
    DataScale:"0,1" ,
    LineWeight:"0" ,
    GridType:"0" ,
    GridColor:"0" ,
    DataGrid:"0" ,
    SampleScale:"0,1" ,
    SampleGrid:"0" ,
    SampleScaleAspect:"1.0" ,
    DataShowValues:"0" ,
    DataFormat:"%9.3f" ,
    SampleScaleFormat:"%2.1f" ,
    DataScaleFormat:"%3.1f" ,
    LineScaleActive:"0" ,
    SampleMarker1:"",
    SampleMarker2:"",
    SampleMarker3:"",
    SampleMarker4:"",
    SampleMarkerColor:"0" ,
    ChanMonRate:"1000" ,
    PipeMonRate:"1000" ,
    CmdMonRate:"1000" ,
    Verbose:"",
    ch1_Name:"",
    ch1_Color:"0" ,
    ch1_Digital:"0" ,
    ch1_Source:"",
    ch1_Rate:"1000" ,
    ch1_DataScale:"0,1" ,
    ch1_DataGrid:"0" ,
    ch1_State:"0" ,
    ch1_Spread:"",
    ch1_Data:"",
    ch1_AutoRange:"0" ,
    ch1_DataMarker1:"0" ,
    ch1_DataMarker2:"0" ,
    ch1_DataMarker3:"0" ,
    ch1_DataMarker4:"0" ,
    ch2_Name:"",
    ch2_Color:"0" ,
    ch2_Digital:"0" ,
    ch2_Source:"",
    ch2_Rate:"1000" ,
    ch2_DataScale:"0,1" ,
    ch2_DataGrid:"0" ,
    ch2_State:"0" ,
    ch2_Spread:"",
    ch2_Data:"",
    ch2_AutoRange:"0" ,
    ch2_DataMarker1:"0" ,
    ch2_DataMarker2:"0" ,
    ch2_DataMarker3:"0" ,
    ch2_DataMarker4:"0" ,
    ch3_Name:"",
    ch3_Color:"0" ,
    ch3_Digital:"0" ,
    ch3_Source:"",
    ch3_Rate:"1000" ,
    ch3_DataScale:"0,1" ,
    ch3_DataGrid:"0" ,
    ch3_State:"0" ,
    ch3_Spread:"",
    ch3_Data:"",
    ch3_AutoRange:"0" ,
    ch3_DataMarker1:"0" ,
    ch3_DataMarker2:"0" ,
    ch3_DataMarker3:"0" ,
    ch3_DataMarker4:"0" ,
    ch4_Name:"",
    ch4_Color:"0" ,
    ch4_Digital:"0" ,
    ch4_Source:"",
    ch4_Rate:"1000" ,
    ch4_DataScale:"0,1" ,
    ch4_DataGrid:"0" ,
    ch4_State:"0" ,
    ch4_Spread:"",
    ch4_Data:"",
    ch4_AutoRange:"0" ,
    ch4_DataMarker1:"0" ,
    ch4_DataMarker2:"0" ,
    ch4_DataMarker3:"0" ,
    ch4_DataMarker4:"0" ,
    ch5_Name:"",
    ch5_Color:"0" ,
    ch5_Digital:"0" ,
    ch5_Source:"",
    ch5_Rate:"1000" ,
    ch5_DataScale:"0,1" ,
    ch5_DataGrid:"0" ,
    ch5_State:"0" ,
    ch5_Spread:"",
    ch5_Data:"",
    ch5_AutoRange:"0" ,
    ch5_DataMarker1:"0" ,
    ch5_DataMarker2:"0" ,
    ch5_DataMarker3:"0" ,
    ch5_DataMarker4:"0" ,
    ch6_Name:"",
    ch6_Color:"0" ,
    ch6_Digital:"0" ,
    ch6_Source:"",
    ch6_Rate:"1000" ,
    ch6_DataScale:"0,1" ,
    ch6_DataGrid:"0" ,
    ch6_State:"0" ,
    ch6_Spread:"",
    ch6_Data:"",
    ch6_AutoRange:"0" ,
    ch6_DataMarker1:"0" ,
    ch6_DataMarker2:"0" ,
    ch6_DataMarker3:"0" ,
    ch6_DataMarker4:"0" ,
    ch7_Name:"",
    ch7_Color:"0" ,
    ch7_Digital:"0" ,
    ch7_Source:"",
    ch7_Rate:"1000" ,
    ch7_DataScale:"0,1" ,
    ch7_DataGrid:"0" ,
    ch7_State:"0" ,
    ch7_Spread:"",
    ch7_Data:"",
    ch7_AutoRange:"0" ,
    ch7_DataMarker1:"0" ,
    ch7_DataMarker2:"0" ,
    ch7_DataMarker3:"0" ,
    ch7_DataMarker4:"0" ,
    ch8_Name:"",
    ch8_Color:"0" ,
    ch8_Digital:"0" ,
    ch8_Source:"",
    ch8_Rate:"1000" ,
    ch8_DataScale:"0,1" ,
    ch8_DataGrid:"0" ,
    ch8_State:"0" ,
    ch8_Spread:"",
    ch8_Data:"",
    ch8_AutoRange:"0" ,
    ch8_DataMarker1:"0" ,
    ch8_DataMarker2:"0" ,
    ch8_DataMarker3:"0" ,
    ch8_DataMarker4:"0" ,
    ch_Data_1:"",
    ch_Data_2:"",
    ch_Data_3:"",
    ch_Data_4:"",
    ch_Data_5:"",
    ch_Data_6:"",
    ch_Data_7:"",
    ch_Data_8:"",
    ReadOnly:"",
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGComboBox Plugin
   ****************************************************************/
  $.fn.CGComboBox = function(settings) {
    $(this).bind('CGComboBox', settings,
      function(event) { });
  };

  $.event.special.CGComboBox = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGComboBox.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGComboBox.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGComboBox.defaults = {
    Id:"FRIPComboBox1",
    tabbable:"1",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    Type:"1" ,
    Interval:"250" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    ProgType:"1" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    DataSource:"",
    DictName:"" ,
    DictEle:"0" ,
    TextType:"100" ,
    TextIndex:"",
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    Periodic:"0" ,
    IOSim:"0" ,
    Pipe:"",
    ReadOnly:"",
    Invisible:"",
    Disable:"",
    OverrideRO:"0" ,
    RWAccess:"0" ,
    ViewType:"0" ,
    ChkDeadman:"0" ,
    ChkTpEnable:"0" ,
    ChkShift:"0" ,
    ChkIo:"0" ,
    ChkIoType:"0" ,
    ChkIoIdx:"0" ,
    CtlType: GMCT_COMBOBOX ,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    BoolType:"0" ,
    $this: null
  };

  /****************************************************************
   * CGOsBtn Plugin
   ****************************************************************/
  $.fn.CGOsBtn = function(settings) {
    $(this).bind('CGOsBtn', settings,
      function(event) { });
  };

  $.event.special.CGOsBtn = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGOsBtn.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGOsBtn.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGOsBtn.defaults = {
    Id:"FRIPCommandButton1",
    tabbable:"1",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    SetValue:"0" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    Type:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    ViewType:"0" ,
    TrueColor:"" ,
    FalseColor:"" ,
    TrueImage:"",
    FalseImage:"",
    Pulse:"0" ,
    PulseTime:"100" ,
    IOSim:"0" ,
    Pipe:"",
    Interval:"250" ,
    ReadOnly:"",
    Invisible:"",
    Disable:"",
    OverrideRO:"0" ,
    RWAccess:"0" ,
    ValueStr:"",
    ChkDeadman:"0" ,
    ChkTpEnable:"0" ,
    ChkShift:"0" ,
    ChkIo:"0" ,
    ChkIoType:"0" ,
    ChkIoIdx:"0" ,
    CaptionOnImage:"0" ,
    CtlType: GMCT_OSBTN ,
    GroupNum:"1" ,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGDraw2D Plugin
   ****************************************************************/
  $.fn.CGDraw2D = function(settings) {
    $(this).bind('CGDraw2D', settings,
      function(event) { });
  };

  $.event.special.CGDraw2D = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGDraw2D.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      draw2d_NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGDraw2D.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      draw2d_NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGDraw2D.defaults = {
    Id:"FRIPDraw2D1",
    tabbable:"0",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    ChartType:"3" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    Name:"",
    CmdMonRate:"1000" ,
    Pipe:"",
    PipeMonRate:"1000" ,
    InvertY:"0" ,
    Scale:"1.000" ,
    LayerOn:"",
    LayerOff:"",
    Verbose:"0" ,
    Touch:"",
    ReadOnly:"",
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGDraw3D Plugin
   ****************************************************************/
  $.fn.CGDraw3D = function(settings) {
    $(this).bind('CGDraw3D', settings,
      function(event) { });
  };

  $.event.special.CGDraw3D = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGDraw3D.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      draw3d_NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGDraw3D.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      draw3d_NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGDraw3D.defaults = {
    Id:"FRIPDraw3D1",
    tabbable:"0",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    FastLoad:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    TrueFont:"" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    Border:"0" ,
    Name:"",
    Pipe:"",
    PipeMonRate:"1000" ,
    Verbose:"0" ,
    Scene:"",
    SubPane:0,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGEdBox Plugin
   ****************************************************************/
  $.fn.CGEdBox = function(settings) {
    $(this).bind('CGEdBox', settings,
      function(event) { });
  };

  $.event.special.CGEdBox = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGEdBox.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGEdBox.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGEdBox.defaults = {
    Id:"FRIPEditBox1",
    tabbable:"1",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    Interval:"250" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    Type:"0" ,
    ValueMin:VALUEMIN_C ,
    ValueMax:VALUEMAX_C ,
    IncrValue:"0.1" ,
    ViewType:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    Periodic:"0" ,
    IOSim:"0" ,
    Pipe:"",
    ReadOnly:"",
    Invisible:"",
    Disable:"",
    OverrideRO:"0" ,
    RWAccess:"0" ,
    ChkDeadman:"0" ,
    ChkTpEnable:"0" ,
    ChkShift:"0" ,
    ChkIo:"0" ,
    ChkIoType:"0" ,
    ChkIoIdx:"0" ,
    CtlType: GMCT_EDBOX ,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGExecution Plugin
   ****************************************************************/
  $.fn.CGExecution = function(settings) {
    $(this).bind('CGExecution', settings,
      function(event) { });
  };

  $.event.special.CGExecution = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGExecution.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGExecution.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGExecution.defaults = {
    Id:"FRIPExecution1",
    tabbable:"0",
    width:"32" ,
    height:"32" ,
    FastLoad:"0" ,
    Name:"",
    Type:"0" ,
    ClickEvents:"0" ,
    ChangeEvents:"0" ,
    FocusEvents:"0" ,
    IgnoreKeysEvents:"0" ,
    Parameter1:"",
    Parameter2:"",
    Parameter3:"",
    Parameter4:"",
    Parameter5:"",
    Parameter6:"",
    Parameter7:"",
    Parameter8:"",
    Pipe:"",
    Interval:"250" ,
    Disable:"",
    CtlType: GMCT_EXECUTION ,
    $this: null
  };

  /****************************************************************
   * CGGrid Plugin
   ****************************************************************/
  $.fn.CGGrid = function(settings) {
    $(this).bind('CGGrid', settings,
      function(event) { });
  };

  $.event.special.CGGrid = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGGrid.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      grid_NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGGrid.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      grid_NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGGrid.defaults = {
    Id:"FRIPGrid1",
    tabbable:"0",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    ChartType:"4" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    Name:"",
    CmdMonRate:"1000" ,
    Pipe:"",
    PipeMonRate:"1000" ,
    Touch:"",
    Verbose:"0" ,
    $this: null
  };

  /****************************************************************
   * CGHelp Plugin
   ****************************************************************/
  $.fn.CGHelp = function(settings) {
    $(this).bind('CGHelp', settings,
      function(event) { });
  };

  $.event.special.CGHelp = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGHelp.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGBtChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGHelp.defaults = {
    Id:"FRIPHelp1",
    tabbable:"0",
    width:"32" ,
    height:"32" ,
    FastLoad:"0" ,
    PageName:"",
    Pipe:"",
    Interval:"250" ,
    Disable:"",
    CtlType: GMCT_HELP ,
    $this: null
  };

  /****************************************************************
   * CGLabel Plugin
   ****************************************************************/
  $.fn.CGLabel = function(settings) {
    $(this).bind('CGLabel', settings,
      function(event) { });
  };

  $.event.special.CGLabel = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGLabel.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGLabel.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGLabel.defaults = {
    Id:"FRIPLabel1",
    tabbable:"0",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    Interval:"250" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    Periodic:"0" ,
    IOSim:"0" ,
    Pipe:"",
    Invisible:"",
    Disable:"",
    RWAccess:"0" ,
    CtlType: GMCT_LABEL ,
    GroupNum:"1" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    MonType: -1 ,
    MonSysType: "-1" ,
    $this: null
  };

  /****************************************************************
   * CGMnChg Plugin
   ****************************************************************/
  $.fn.CGMnChg = function(settings) {
    $(this).bind('CGMnChg', settings,
      function(event) { });
  };

  $.event.special.CGMnChg = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGMnChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGMnChg.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGMnChg.defaults = {
    Id:"FRIPMenuChange1",
    tabbable:"1",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    PageName01:"",
    PageName02:"",
    PageName03:"",
    PageName04:"",
    PageName05:"",
    PageName06:"",
    PageName07:"",
    PageName08:"",
    PageName09:"",
    PageName10:"",
    PageCaption01:"",
    PageCaption02:"",
    PageCaption03:"",
    PageCaption04:"",
    PageCaption05:"",
    PageCaption06:"",
    PageCaption07:"",
    PageCaption08:"",
    PageCaption09:"",
    PageCaption10:"",
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    ViewType:"0" ,
    TrueColor:"" ,
    FalseColor:"" ,
    TrueImage:"",
    FalseImage:"",
    Pipe:"",
    Interval:"250" ,
    ReadOnly:"",
    Invisible:"",
    Disable:"",
    ChkDeadman:"0" ,
    ChkTpEnable:"0" ,
    ChkShift:"0" ,
    ChkIo:"0" ,
    ChkIoType:"0" ,
    ChkIoIdx:"0" ,
    CaptionOnImage:"0" ,
    CtlType: GMCT_MNCHG ,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGMulti Plugin
   ****************************************************************/
  $.fn.CGMulti = function(settings) {
    $(this).bind('CGMulti', settings,
      function(event) { });
  };

  $.event.special.CGMulti = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGMulti.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGMulti.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGMulti.defaults = {
    Id:"FRIPMulti1",
    tabbable:"0",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    Interval:"250" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    Data01:"",
    Data02:"",
    Data03:"",
    Data04:"",
    Data05:"",
    Data06:"",
    Data07:"",
    Data08:"",
    Data09:"",
    Data10:"",
    ValueMin01:"0" ,
    ValueMin02:"0" ,
    ValueMin03:"0" ,
    ValueMin04:"0" ,
    ValueMin05:"0" ,
    ValueMin06:"0" ,
    ValueMin07:"0" ,
    ValueMin08:"0" ,
    ValueMin09:"0" ,
    ValueMin10:"0" ,
    ValueMax01:"-1" ,
    ValueMax02:"-1" ,
    ValueMax03:"-1" ,
    ValueMax04:"-1" ,
    ValueMax05:"-1" ,
    ValueMax06:"-1" ,
    ValueMax07:"-1" ,
    ValueMax08:"-1" ,
    ValueMax09:"-1" ,
    ValueMax10:"-1" ,
    DataDefault:"",
    ViewType:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    Periodic:"0" ,
    IOSim:"0" ,
    Pipe:"",
    Invisible:"",
    Disable:"",
    RWAccess:"0" ,
    CtlType: GMCT_MULTI ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGTgBtn Plugin
   ****************************************************************/
  $.fn.CGTgBtn = function(settings) {
    $(this).bind('CGTgBtn', settings,
      function(event) { });
  };

  $.event.special.CGTgBtn = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGTgBtn.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGTgBtn.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGTgBtn.defaults = {
    Id:"FRIPToggleButton1",
    tabbable:"1",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    TrueColor:"" ,
    FalseColor:"" ,
    Interval:"250" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    Type:"0" ,
    OtherPhase:"1" ,
    TrueValue:"0" ,
    FalseValue:"0" ,
    TrueChkImg:"/frh/gui/checkbox.png",
    FalseChkImg:"/frh/gui/uchkbox.png",
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    Periodic:"0" ,
    ViewType:"0" ,
    TrueStrColor:"" ,
    FalseStrColor:"" ,
    TrueImage:"",
    FalseImage:"",
    Pulse:"0" ,
    PulseTime:"100" ,
    IOSim:"0" ,
    Pipe:"",
    ReadOnly:"",
    Invisible:"",
    Disable:"",
    OverrideRO:"0" ,
    RWAccess:"0" ,
    TrueCaption:"",
    Momentary:"0" ,
    Confirm:"0" ,
    Invert:"0" ,
    ValueStr:"",
    TrueValueStr:"",
    ChkDeadman:"0" ,
    ChkTpEnable:"0" ,
    ChkShift:"0" ,
    ChkIo:"0" ,
    ChkIoType:"0" ,
    ChkIoIdx:"0" ,
    CaptionOnImage:"0" ,
    CtlType: GMCT_TGBTN ,
    dlgDismiss:"0" ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGTgLmp Plugin
   ****************************************************************/
  $.fn.CGTgLmp = function(settings) {
    $(this).bind('CGTgLmp', settings,
      function(event) { });
  };

  $.event.special.CGTgLmp = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGTgLmp.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGTgLmp.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGTgLmp.defaults = {
    Id:"FRIPToggleLamp1",
    tabbable:"0",
    Caption:"",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"100" ,
    DataIndex:"",
    TrueColor:"" ,
    FalseColor:"" ,
    Interval:"250" ,
    TrueFont:"" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    Type:"0" ,
    CmpOperator:"0" ,
    CmpValue:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    HAlign:"1" ,
    VAlign:"1" ,
    Periodic:"0" ,
    ViewType:"0" ,
    TrueImage:"",
    FalseImage:"",
    IOSim:"0" ,
    Pipe:"",
    Invisible:"",
    Disable:"",
    RWAccess:"0" ,
    TrueCaption:"",
    TrueStrColor:"" ,
    FalseStrColor:"" ,
    ValueStr:"",
    CaptionOnImage:"0" ,
    CtlType: GMCT_TGLMP ,
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

  /****************************************************************
   * CGTree Plugin
   ****************************************************************/
  $.fn.CGTree = function(settings) {
    $(this).bind('CGTree', settings,
      function(event) { });
  };

  $.event.special.CGTree = {

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGTree.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      tree_NPP_New(data);
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({}, $.event.special.CGTree.defaults, CGCommon, handleObj.data);
      var data = handleObj.data;
      data.$this = $(this);
      tree_NPP_Destroy(data);
    } // remove
  };

  $.event.special.CGTree.defaults = {
    Id:"FRIPTreeView1",
    tabbable:"0",
    FontSize:"14" ,
    width:"100" ,
    height:"50" ,
    DataType:"0" ,
    FastLoad:"0" ,
    FontName:"" ,
    FontBold:"0" ,
    FontItalic:"0" ,
    FontWeight:"400" ,
    FontUnderline:"0" ,
    FontStrikethrough:"0" ,
    FontCharSet:"0" ,
    ForeColor:"" ,
    BackColor:"" ,
    Border:"0" ,
    CheckBox:"0" ,
    RootOnly:"0" ,
    Pipe:"",
    PipeMonRate:"1000" ,
    XMLFile:"",
    dlgDeviceId:"-1" ,
    dlgTaskIdx:"-1" ,
    dlgWidth:"0" ,
    dlgHeight:"0" ,
    $this: null
  };

})(jQuery);
