/**********************************************************************
 * Selective Compliance Assembly Robot Arm robot program.
 * Tablet mode script
 *
 * Created : 2019/01/07 FSI
 * Modified:
 *
*/
// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
*/
/*
 * jQuery UI Widget
 * http://jqueryui.com
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
*/

// irprog.stm
var SELECTPROG_ADDRESS = "/softpart/genlink?current=menupage,381,116";
var TAB_EDITOR_ADDRESS = "/softpart/genlink?current=menupage,381,114";
var ALARM_ADDRESS = "/softpart/genlink?current=menupage,18,1";
var MENU_CSTM_ADDRESS = "/softpart/genlink?current=menupage,381,105";
var IHMI_EDITOR_ADDRESS = "/softpart/genlink?current=menupage,381,115";
var ALARM_STATUS_ADDRESS = "/softpart/genlink?current=menupage,381,112";
var DCS_ADDRESS = "/softpart/genlink?config=single&prim=menupage,381,122";
var SPEED_LIMIT_ADDRESS= '/softpart/genlink?current=menupage,381,119';
var Notifications_ADDRESS = "/softpart/genlink?current=menupage,1621,1";
var FILE_ADRESS = "/softpart/genlink?current=menupage,74,1";

// UT means update_tree
var UT_SLCT = 0;
var UT_CSTM = 1;
var UT_EDIT = 2;
var UT_ALARM = 3;
var UT_IHMI = 4;
var UT_NEW_ALAM = 5;

var currentProgInfo = {currentProgStat : "abort", currentProgName : ""};

// ID used to get the IO status.
var IOTYPE_DI = 1; //for DI
var IOTYPE_SI = 11; //for SI

// FSI 20181220 FSI Getting Device info.
var ua = navigator.userAgent;
var getDevice = (function () {
  rpcmc_getVar(top.SYSNAME_C, '$DICT_CONFIG.$LANG_SUFFIX', getCurLangCb);//lang for cstm
  if (ua.indexOf('iPad') > 0 || ua.indexOf('Android') > 0) {
    return 'tab';
  } else {
    return 'PC';
  }
})();

function getCurLangCb(progname, varname, typecode, value, callback, cbarg2) {
  var tempLang = '';
  tempLang = value.slice(0);
  currentLang = tempLang;
  console.log("Current Language:" + currentLang);
}

// FSI 20181003 Resize tree when opening or closing nodes
function tree_resize() {
  if(typeof $('#treemod').contents().find('#treeHead')[0] == 'undefined'){
    return;
  }
  var treefrm_h = get_treeh() + $('#treemod').contents().find('#treeHead')[0].clientHeight + $('#treemod').contents().find('#treeBottom')[0].clientHeight;
  $('#treemod').css({ height: treefrm_h });
  // FSI 20181207 Hide scroll in tree when tablet mode is displayed on PC
  if (getDevice == "PC") {
    var child = top.treemod.document.getElementById("treeScara");
    var childParent = child.parentNode;
    childParent.style.overflow = 'hidden';
  }
}


// FSI 20181003 Change and send touch flag
function change_touchflg() {
  touchflg = false;
}
function send_touchflg() {
  return touchflg;
}
function init_touchflg() {
  touchflg = true;
}

// FSI 20181204 init UI mode
function initUIMode(progname, varName, codeType, uiMode) {
  if (typeof uiMode == 'string') {
    uiMode = Number(uiMode);
  }
  if (uiMode == MODE_TABLET || (uiMode == MODE_AUTO && getDevice == "tab")) {
    tabletUi = true;
  }
  setUICfg(uiMode);
  top.rpcmc_getVar(SYSNAME_C, "$IRPROG_CFG.$VISI_PRG", getVisualMode, null, null);
}
// FSI 20181204 get Visual mode
function getVisualMode(progname, varName, codeType, visualMode) {
  if (typeof visualMode == 'string') {
    visualMode = Number(visualMode);
  }
  if (visualMode == MODE_IHMI) {
    ihmiUi = true;
  }
  modeGetFlg = true;
  hideTreeForTab();
  finish_login();
}
// FSI 20200401 App config for tablet.
function isTabTP() {
  var navUA = navigator.userAgent.toLowerCase();
  if ((navUA.indexOf('android') >= 0) && (navUA.indexOf('wv') >= 0)) {
    return true;
  } else {
    return false;
  }
}
// FSI 20180927 Hide treemenu in tablet mode
function hideTreeForTab() {
  $("iframe").css({
    "margin": "0px",
    "vertical-align": "bottom",
  });
  $('#leds').css({
    'width': '220px',
    'height': '65px'
  });
  $('#statbar').css('height', '63px');
  top.setStatbarCSS();
  $('#t35').css('display', 'none');
  $('#treemod').css({
    'width': '270px',
    'display': 'none',
    'position': 'absolute',
    'margin-top': '45px',
    'margin-left': '5px'
  });
}

// scaratree.stm
var touchflg = true;
var COLDSTART = 2;
var treemodMargin = 5;
// FSI 20181003 set height of tree
function get_treeh() {
  var tree_hmax = top.h_mainfrm;
  var h_pnl_btn = 45;
  if(top.g_startmd == COLDSTART) {
    tree_hmax -= $('#treemod').contents().find('#treeHead')[0].offsetHeight
               + $('#treemod').contents().find('#treeBottom')[0].offsetHeight + treemodMargin;
  } else {
    tree_hmax -= h_pnl_btn + treemodMargin;
  }
  $('#treemod').contents().find('#treeScara').css({
    'max-height': tree_hmax + 'px'
  });

  var elem_tree = top.treemod.document.getElementById('treeScara');
  var tree_h = elem_tree.offsetHeight;
  return tree_h;
}

function colorchange_closearrow() {
  $('#treemod').contents().find('.tree-select .tree-select-closed > .tree-select-node > .tree-select-arrow').css({
    'border-top': '7px solid transparent',
    'border-right': '0px solid transparent',
    'border-bottom': '7px solid transparent',
    'border-left': '13px solid #67727e'
  });
  $('#treemod').contents().find('.tree-select .tree-select-closed-selected > .tree-select-node').css('border-color', 'white');
}
function colorchange_openarrow() {
  $('#treemod').contents().find('.tree-select .tree-select-open > .tree-select-node > .tree-select-arrow').css({
    'border-top': '13px solid #67727e',
    'border-right': '7px solid transparent',
    'border-bottom': '0px solid transparent',
    'border-left': '7px solid transparent',
  });
  $('#treemod').contents().find('.tree-select .tree-select-closed-selected > .tree-select-node').css('border-color', 'white');
}

// Disable back button when focus is not prim
function switchFocusProc() {
  if (top.mainfrm.length > 0) {
    if (top.mainfrm.primstat.document.getElementById('foc1') == null) {
      setTimeout(function () {
        switchFocusProc();
      }, 500);
    } else {
      setTimeout(function () {
      var target = top.mainfrm.primstat.document.getElementById('foc1');
      var observer = new MutationObserver(function(mutations) {
        var currentFrameId = top.getMyFrameId();
        if (currentFrameId == "prim") {
          if (top.treemod.primScreenId != top.IHMI_EDITOR_ADDRESS) {
            if (top.statbar.location.href.indexOf('tabtp') >= 0) {
              top.statbar.dispBackBtn();
              top.statbar.dispForwardBtn();
            }
          }
        } else if (currentFrameId == "dual") {
          if (top.statbar.location.href.indexOf('tabtp') >= 0) {
            top.statbar.hideBackBtn();
            top.statbar.hideForwardBtn();
          }
        } else {
          if (top.statbar.location.href.indexOf('tabtp') >= 0) {
            top.statbar.hideBackBtn();
            top.statbar.hideForwardBtn();
          }
        }
      });
    // Setting the observer's monitoring target
    var filter = ['style'];
    var options = {
      attributes: true,
      attributeFilter: filter
    };
    //Pass target and settings
    observer.observe(target, options);
  }, 1000);
    }
  } else {
    setTimeout(function () {
      switchFocusProc();
    }, 500);
  }
}

var screenTrans = {prim: {cb: undefined}, dual: {cb: undefined}, third: {cb: undefined}};
// isProcCB : This flag will be true during the callback process of screen transition.
var isProcCB = {prim: false,  dual: false, third: false};
/*
 * (IN) scrId : Which screen flame.(prim,dual,third)
 *      value : true(callback is called), false(execution instruction)
 */
function setCBFlag(scrId, value) {
  isProcCB[scrId] = value;
  var transEnb = true;
  for (scr in isProcCB) {
    if (isProcCB[scr]) {
      transEnb = false;
    }
  }
  if (transEnb) {
    screenTrans[scrId].transProc();
  }
}

/*
 * (IN) scrId : Which screen flame.(prim,dual,third)
 */
function getCBFlag(scrId) {
  return isProcCB[scrId];
}

function initCBFlag() {
  for (key in isProcCB) {
    var cbFlag = getCBFlag(key);
    cbFlag = false;
  }
}

/*
 *  Receive callback from mainfrm
 * (IN) callback : Function registered by the mainfrm
 *      window   : callerwindow
 */
function setScrTrsCB(callback, window) {
  var currentFrm = window.frameElement.id;
  screenTrans[currentFrm].cb = callback;
}

// Whether or not a callback is set on the current screen.
function isExistCB() {
  if (screenTrans[top.getMyFrameId()].cb === undefined ||
    typeof screenTrans[top.getMyFrameId()].cb === "undefined") {
      return false;
  } else {
    return true;
  }
}

function transIrprogMenu(transArg) {
  if (isExistCB()) {
    try {
      screenTrans[top.getMyFrameId()].transProc = transIrprogMenu; //Processing after the instruction from the prim.
      screenTrans[top.getMyFrameId()].arg = $.extend(true, {}, transArg);
      screenTrans[top.getMyFrameId()].cb();
    } catch (e) {
      screenTrans[top.getMyFrameId()].cb = undefined;
      top.treemod.nodeOnClick(null, transArg.props);
      top.treemod.update_tree_url(transArg.props.value);
      console.log(e);
    }
  } else {
    top.treemod.nodeOnClick(null, transArg.props);
    top.treemod.update_tree_url(transArg.props.value);
  }
}

/*
 *  Screen transition process after executing callback.
 * (IN) window   : callerwindow
 */
function screenTransProc(window) {
  var currentFrm = window.frameElement.id;
  if (screenTrans[currentFrm].transProc.name == "dologout") { // logout
    setCBFlag(currentFrm, false);
    return;
  }
  screenTrans[currentFrm].cb = undefined; //Delete the registered callback
  if (screenTrans[currentFrm].transProc.name == "selectNode") { // Menu transition
    var props = { value: "" };
    props.value = screenTrans[currentFrm].arg;
    top.treemod.nodeOnClick(null, props);
    top.treemod.update_tree_url(screenTrans[currentFrm].arg);
  } else if (screenTrans[currentFrm].arg) { // Not menu transition
    screenTrans[currentFrm].transProc(screenTrans[currentFrm].arg);
  } else { // Back button, home button and menucustom button transition
    screenTrans[currentFrm].transProc();
  }
  // Initialize properties in objects.
  screenTrans[currentFrm].transProc = undefined;
  screenTrans[currentFrm].arg = undefined;
}