/**********************************************************************
 *
 * Created : 2020/03/5 FSI
 * Modified:
 *
 */

// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 */
/*
 * jQuery UI Widget
 * http://jqueryui.com
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */
// Use roundSlider
/*! roundSlider v1.6.1 | (c) 2015-2020, Soundar | MIT license | http://roundsliderui.com/licence.html */

// = Device setting
var device = ''; // device
var startEvent = ''; // Drag start event
var moveEvent = ''; // Event being dragged
var endEvent = ''; // Drag end event
var androidFlg = false;
var hiddenStr = "";
var visCngStr = "";

// = Exec status
var tpEnb     = false;
var isAlarmOn = false;
var skipObj = { "byManual": false, "currLine": 0, "pauseLine": 0 };
var statMode = WATCHEXEC_ABORTED;
var ledMode = WATCHEXEC_ABORTED;
var progTaskNum = 0;
var programStepMode  = false;
var execStatResource = { 0: 'ｼｭｳﾘｮｳ', 1: 'ｼﾞｯｺｳ', 2: 'ｲﾁｼﾞﾃｲｼ' };
var curGrpNum  = 1;
var allGrpNum  = 1;
var extAxisNum = 0;
var enbCoordMask = [];
var curSI2 = 0;

// = Override slider setting
var curOvrVal = 0;
var touchSlideKnob = "";
var ovr_val = 35;
var curWeightVal = 0;
var weight_val = 50;
var runningOvrUpdate = true;
var runningWeightValUpdate = true;
var jogOvLim = 100;
var ovLimT2 = 100;
var teachWeightMonitorFlag = false;

// = Panel stat setting
var pnlEnb = { 0: true, 1: true, 2: true, 3: true };
var plsExist = false;
var alignExist = false;

// = timer
var gtimerKeepData;
var gtimerGetOveVal;
var gtimerGetTeachWeightVal;
var frmNumObj  = { "T": 0, "U": 0 };
var enblSWObj  = { "L": 1, "R": 1 };
var ldtrSwtAftChkr = null;
var pltModeSwtAftChkr = null;

// = Move Mode
var moveModeName   = MOVE_MODE_AUTO;
var doRelShift     = false;
var sendShiftFlg   = false;
var alignShift     = false;

// = Id of the active keyPanel element
var activeBtnId = "";
var getVarFlg   = true;

// = To save the pop-up message ID during display
var g_called_popupmsg = "";

// = Pulse generator event state
var gPulseState = {
  startFlg: false, PGcnt: null, updateFlg: false, updateCnt: null, updateTimer: null,
  scaleMax: 30, scaleHalf: 15, SE: null, SETrack: null, imgRotate: 0, scaleRotate: 12, centerFlg: false
};
// = Pulse generator vibrate pattern of one vibration
var VIBRATE_PATTERN = [100, 30];
// = Scaling display pattern of Pulse generator panel
var gPulseScalList = {
  ptn1: ["x1", "x5", "x10", "x50"],
  ptn2: ["x1", "x5", "x10", "x50"],
};
var curScalingList;
var gLdtrState = { tabSys: null, sysEnb: false, class: LDTR_MODE_F };

var g_machine_lock = {
  'g1' : false, 'g2' : false, 'g3' : false, 'g4' : false, 'g5' : false, 'g6' : false, 'g7' : false, 'g8' : false
};

var g_safetyTimer = null;

var isJincDisp = false;
var curSubGrp = false;

var curMgtSngDsp = 0;

var hdlBbtn = {
  type: top.IO_TYPE_RIN,
  num: 2,
  assing: false // false=Unassigned
};

//=============================================================================
// Event type determination by device type
//=============================================================================
//Device judgment by UA
if (navigator.userAgent.indexOf('iPhone') > 0 ||
  navigator.userAgent.indexOf('iPod') > 0 ||
  navigator.userAgent.indexOf('Windows Phone') > 0 ||
  navigator.userAgent.indexOf('iPad') > 0 ||
  navigator.userAgent.indexOf('Android') > 0) {
  device = 'smt';
} else {
  device = 'pc';
}

// Set event type
if (device == 'smt') {
  //Types of events when using a smartphone
  startEvent = 'touchstart';
  moveEvent = 'touchmove';
  endEvent = 'touchend';
} else {
  //Event types when using a computer
  startEvent = 'mousedown';
  moveEvent = 'mousemove';
  endEvent = 'mouseup';
}

// Set visibilitychange String
if (typeof document.hidden !== "undefined") {
  hiddenStr = "hidden";
  visCngStr = "visibilitychange";
} else if (typeof document.msHidden !== "undefined") {
  hiddenStr = "msHidden";
  visCngStr = "msvisibilitychange";
} else if (typeof document.webkitHidden !== "undefined") {
  hiddenStr = "webkitHidden";
  visCngStr = "webkitvisibilitychange";
}

var APPJOGPANEL_PATH = "FRH:JCGTP\\";
var APPJOGPANEL_NAME = "appjogpanel";

window.onload = function () {
  // Get current selected group.
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR.$JOG_GP', getCurGrpCB, getPlsValEnb);
  // Get program list for macro and call instructions
  top.rpcmc_iovalrd(top.tpout_type_c, 3, getStepModeCB);
  // Get the status of enable switch.
  top.rpcmc_iovalrd(top.tpin_type_c, 247, getEnblSwValCB);
  top.rpcmc_iovalrd(top.tpin_type_c, 248, getEnblSwValCB);
  // get app for add jog panel
  getAppjogpnl();
  // Get leadthrough panel enable / disable
  getLdtrValEnb();
  // Get current mode AUTO/T1/T2
  getCurMode();
  // Get all group num
  getNumGrp();
  // set select list event
  setSelListEvent();
  // set pulse button event
  setPulseBtnEvent();
  // set help button event
  setHelpBtnEvent();
  // set JINC button event
  setJincBtnEvent();
  // Get limit of override.
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR.$JOGOVLIM', getJogOvLimCB);
  // Get maximum number of payload.
  top.rpcmc_getVar(top.SYSNAME_C, '$PLST_SCHMAD', getPayloadMaxCB);

  // for alarm toast message The Manual guided teaching
  for (var i = 0; i < top.ALMDLG_LDTR.length; i++) {
    var almSpec = top.ALMDLG_LDTR[i];
    top.setAlmToast(almSpec.ID, almSpec.CODE, ldtrMsgRes['system' + almSpec.CODE]);
  }

  top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$MGT_SNGDSP', getMgtSngDspCB, null);
};

// Processing what can be processed after getting group number or pulse enable
function initPnlSetting() {
  // Stop polling
  unloadPanelArea();
  // Start polling
  loadPanelArea();
  // get value of axis num, tool num, user num and display current it
  initSelListVal();
  // Get current coordinate system
  getSubGrp(setPnlArea);
  // set pulse val "X" "J1" "E1" "x1"
  if (plsExist) {
    setPulseAxis(1);
    setPulseMag(1);
    try {
      window.AudioContext = window.AudioContext || window.webkitAudioContext;
      gPulseState.SE = new AudioContext();
      loadPlsBgm(); // send request
    } catch (e) {
      console.log('audio error');
    }
  }
  setTimeout(function () { initialsetting(); }, 1000);
}

function setPnlArea() {
  getJogModeConf(chgCoordDisp);
}

function initSelListVal() {
  // get joint axes
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR_GRP[' + getCurGrp() + '].$NUM_AXES', getJointAxisCB);
  // Get Frame Maximum Number(UTool).
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR.$MAXNUMUTOOL', getfrmMaxNumCB, setFrmNumDisp);
  // Get Frame Maximum Number(UFrame).
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR.$MAXNUMUFRAM', getfrmMaxNumCB, setFrmNumDisp);
  // Get enable frame coordinate.
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR_GRP[' + getCurGrp() + '].$COORD_MASK', getCoordMaskCB);
  // Get kinem_enb.
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR_GRP[' + getCurGrp() + '].$KINEM_ENB', getKinemEnbCB);
}

$(window).on('pagehide', function (evt) {
  //Stop polling
  unloadPanelArea();
});

function getAppjogpnl() {
  $.getJSON("/COMET/rpc?func=GTFILIST&path_name=" + APPJOGPANEL_PATH, function(json) {
    if (json.FANUC.RPC != undefined) {
      json.FANUC.RPC[0].status = json.FANUC.RPC[0].status.toLowerCase();
      var status = json.FANUC.RPC[0].status
      var str = json.FANUC.RPC[0].value;
      getAppJogPnlCB(status, APPJOGPANEL_PATH, str);
    } else {
      rpcmc_rprintf("[rpcmc] unexpected reply " + JSON.stringify(json));
    }
  });
}

function getAppJogPnlCB(status, path_name, liststr) {
  var tmpArray = [];
  //"0x2a0014" empty directory
  //"0x2000a"  nonexistent directory
  if (0x0 == status) { // Normal acquisition
    // Folder contents list
    tmpArray = liststr.split(",");
    var lang = top.irprogapi.getCurrentLanguage();
    lang = ((lang == "jp") ? "kn" : lang);
    var curLangFileName = "";
    var egFileName = "";

    for (var i = 0; i < tmpArray.length && liststr != ""; i++) {
      if (tmpArray[i].trim() == "" || typeof tmpArray[i].trim() == "undefined") {
        continue;
      }
      // Find files in the current language.
      if (tmpArray[i].trim().toLowerCase().indexOf(APPJOGPANEL_NAME + lang) != -1) {
        curLangFileName = tmpArray[i].trim().toLowerCase();
      }
      // Find files in English.
      if (tmpArray[i].trim().toLowerCase().indexOf(APPJOGPANEL_NAME + "eg") != -1) {
        egFileName = tmpArray[i].trim().toLowerCase();
      }
    }

    if(curLangFileName != ""){
      addAppJogPnl(path_name, curLangFileName);
    } else if (egFileName != "") {
      addAppJogPnl(path_name, egFileName);
    }
  }
}

function addAppJogPnl(path_name, file_name) {
  var ajaxPath = "/" + path_name.replace("\\", "/").replace(":", "/") + file_name;
  var $appJogPnlArea = $('<div>', { 'id': 'appJogPnlArea'});
  var $appJogPnlFrm = $('<iframe>', { 'id': 'appJogPnlFrm', 'src': ajaxPath });
  $appJogPnlArea.append($appJogPnlFrm);
  $("#panel_j").append($appJogPnlArea);
  // Fix the iframe height
  var appJogPnlFrmElm = document.getElementById('appJogPnlFrm');
  appJogPnlFrmElm.contentWindow.addEventListener('DOMContentLoaded', function () {
    parent.$("#pnlarea").css({
      "display": "block",
      "z-index": -1,
    });
    var innerH = appJogPnlFrmElm.contentDocument.body.clientHeight;
    $("#appJogPnlArea").css({
      "height": innerH + "px",
    });
    $('#appJogPnlFrm').contents().find('body').css({
      'overflow':'auto',
      'white-space':'nowrap'
    });
    
    var $linkData = $('<link>', { 'rel': 'stylesheet', 'type': 'text/css', 'href': '/frh/ihmi/ihmicomponentscrollbar.css?version=V0.0000'});
    $('#appJogPnlFrm').contents().find('head').append($linkData);
   
    parent.$("#pnlarea").css({
      "display": "none",
      "z-index": 1,
    });
  });
}

// get leadthrough enable and panel hide
function getPlsValEnb() {
  $.getJSON("/COMET/rpc?func=VMIP_READVA&prog_name="
            + top.SYSNAME_C + "&var_name=$TAB_MPG.$ENABLE",
    function (json) {
      try { // If $TAB_MPG.$ENABLE exists, flag it.
        if (undefined != json.FANUC.RPC) {
          if (json.FANUC.RPC[0].status == 0) { plsExist = true; }
        }
      } catch (err) { console.log(err); }
      // Check karel program existence.
      top.rpcmc_chkkey(null, top.mor_ss_c, ALIGNAXS, 'gnum', existAlignKarel, null);
    });
}

function loadPlsBgm() {
  var request = new XMLHttpRequest();
  request.open('GET', "mpg_se.mp3", true);
  request.responseType = 'arraybuffer';
  request.onload = function () {
    gPulseState.SE.decodeAudioData(
      request.response,
      function (buffer) {
        gPulseState.SETrack = buffer;
        if (navigator.userAgent.indexOf('iPad') > 0) {
          unlockAudioIOS();
        }
      },
      function () {
        gPulseState.SE = null;
        console.log('audio error');
      }
    );
  }
  request.send();
}

// To remove playback restrictions, play the SE only once, tied to the user action.
function unlockAudioIOS() {
  $('#pulse_generator').one('touchstart', function () {
    var source = gPulseState.SE.createBufferSource();
    source.buffer = gPulseState.SETrack;
    source.connect(gPulseState.SE.destination);
    source.start(0, 0, 0.01);
  });
}

/*
 =========================================================================
 @function name  : getCurGrp
 @argument       : none
 @description    : Get current group number
 @return         : currentGrpNum
 =========================================================================
*/
function getCurGrp() {
  return curGrpNum;
}
function setCurGrp(grp) {
  curGrpNum = grp;
}

function setNumGrp(nextVal) {
  top.rpcmc_setVar(top.SYSNAME_C, '$JCR.$JOG_GP', nextVal);
}
function getNumGrp() {
  allGrpNum = top.irprogapi.getGroupCount();

  // setting group tab
  if (allGrpNum > 1) { settingMltGrpTab(); }

  // setting test mode
  top.irprogapi.getMachinelockValue(getMachinelockValueCB);
  function getMachinelockValueCB(mlList){
    for (var i = 0; i < mlList.length; i++){
      g_machine_lock['g' + (i + 1)] = (mlList[i] == "TRUE");
    }
    setTcycMode();
  }

  // Get override limit when releasing the deadman at T2.
  top.irprogapi.getT2OvrLmt(allGrpNum, updT2OvrLim);
  function updT2OvrLim(lmtVal) {
    // Update global variables.
    ovLimT2 = lmtVal;
  }
}

// make group button and add event listener.
function settingMltGrpTab() {
  // This class is used to change the css of child elements at once.
  $('#jogPanel').addClass(MULTI_GRP_CLASS);

  var trgtTabArea = $('#selectGroupTab');
  for (var i = 0; i < allGrpNum; i++){

    // add group button
    var newGrpBtnId = 'pnlGrpBtn' + (i + 1);
    var $newGrpBtn  = $('<div>', { 'id': newGrpBtnId, 'class': 'grp_tab', 'text': 'Group' + (i + 1) });
    trgtTabArea.append($newGrpBtn);

    // add event listener
    $('#' + newGrpBtnId).on("mouseup touchend", function (event) {
      var trgtGrpBtn = event.target.id;
      if ($('.grp_tab_active').attr('id') != trgtGrpBtn) {
        // Changes to the elements in the panel occur from polling.
        var trgtGrpNum = trgtGrpBtn.replace(/[^0-9]/g, "");
        setNumGrp(trgtGrpNum); // Send a new group number.
        if ("#" + $('.tab_active').attr('id') == P_TABID[ALIGN_TAB]) {
          pnlSetVar(ALIGNAXS, 'gnum', trgtGrpNum);
          top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + trgtGrpNum + '].$ALIGN_TYPE', alignPnlSetting, trgtGrpNum);
        }
      }
      event.preventDefault();
    });
  }
  // set active color
  $('#pnlGrpBtn' + getCurGrp()).addClass('grp_tab_active');
}

function switchGrpElm(setGrpNum) {
  // do not change display for single group
  if (allGrpNum <= 1) { return; }

  setJogPnlClass();
  $('.grp_tab_active').removeClass('grp_tab_active');
  $('#pnlGrpBtn' + setGrpNum).addClass('grp_tab_active');
}

/*
 =========================================================================
 @function name  : getCurGrpCB
 @argument[num]  : Current group Num
 @description    : Set current group number
 @return         : currentGrpNum
 =========================================================================
*/
function getCurGrpCB(progName, varName, typeCode, groupStr, afterCall, transInfo) {
  setCurGrp(parseInt(groupStr));
  if (afterCall != undefined) {
    afterCall(); // get pulse enable
  }
}

function getJogOvLimCB(progName, varName, typeCode, ovStr, afterCall, transInfo) {
  jogOvLim = Number(ovStr);
}

function getSliderOvVal(ovrVal) {
  return ((ovrVal <= 5) ? ((ovrVal + 2) * 5) : ((Math.ceil(ovrVal / 5) + 6) * 5));
}

function getDispOvrVal(ovrSliderVal) {
  return ((ovrSliderVal < 35) ? ((ovrSliderVal / 5) - 2) : (ovrSliderVal - 30));
}

// get joint axes callback
function getJointAxisCB(sysName, varName, type_code, axisStr) {
  // get robot axes
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR_GRP[' + getCurGrp() + '].$NUM_ROB_AXS', getRobotAxisCB, parseInt(axisStr));
}

// get current group enable coordinate callback
function getCoordMaskCB(sysName, varName, type_code, coordBitArr) {
  var statArr  = [];
  enbCoordMask = []; // init

  for (var i = 0; i < 5; i++) { // Valid bits are 5 bits per word.
    statArr[i] = (Number(coordBitArr) & (1 << i)) != 0; // Set true when bit is on.
  }
  for (var j = 0; j < statArr.length; j++){
    if ((statArr[j]) && (j != 1)) { // Jog Frame is not used
      enbCoordMask.push(j + '0');
    }
  }
  // add class for ldtr panel overlay
  if (($('#jogPanel').hasClass('idp_add')) != (enbCoordMask.join('') == '00')) {
    $('#jogPanel').toggleClass('idp_add');
  }
}

// get current group enable coordinate callback
function getKinemEnbCB(sysName, varName, type_code, kinemEnbVal) {
  // add class for align panel overlay
  if (kinemEnbVal == '2') {
    $('#jogPanel').removeClass('kmd_add');
  } else {
    $('#jogPanel').addClass('kmd_add');
  }
}

// get robot axes callback
// Use only once when first displayed
function getRobotAxisCB(sysName, varName, type_code, axisStr, callParam) {

  // If there are 6 axes or less, reduce the number of jogs
  for (var i = 6; i > 0; i--) {
    var hideJogId  = "#j" + i + "row";
    var hidePlsBtn = ".plsJ" + i;
    if (i - parseInt(axisStr) > 0) {
      $(hideJogId).addClass('hideButton'); // hide jog
      $(hidePlsBtn).addClass('hideButton'); // hide button
    } else {
      $(hideJogId).removeClass('hideButton'); // display jog
      $(hidePlsBtn).removeClass('hideButton'); // display button
    }
  }
  // set Ext. axis num
  extAxisNum = ((callParam - parseInt(axisStr) < 1) ? 0 : callParam - parseInt(axisStr));

  for (var i = 3; i > 0; i--) {
    var hideJogId = "#e" + i + "row";
    var hidePlsBtn = ".plsE" + i;
    if (i - extAxisNum > 0) {
      $(hideJogId).addClass('hideButton'); // hide jog
      $(hidePlsBtn).addClass('hideButton'); // hide button
    } else {
      $(hideJogId).removeClass('hideButton'); // display jog
      $(hidePlsBtn).removeClass('hideButton'); // display button
    }
  }
  set1stPlsBtn();

}

// If the active color button is hidden by group switching, enable the leftmost button
function set1stPlsBtn() {

  if ((!plsExist) || ($(".selBtn.hideButton").length == 0)) { return; }

  if ($(".jogextsel_btn.selBtn.hideButton").length > 0 &&
    $(".jogextsel_btn.selBtn.hideButton")[0].outerText.trim() != "E1") {
    $('.jogextsel_btn').removeClass('selBtn');
    $('.plsE1').addClass('selBtn');
  }
  if ($(".jogjointsel_btn.selBtn.hideButton").length > 0 &&
    $(".jogjointsel_btn.selBtn.hideButton")[0].outerText.trim() != "J1") {
    $('.jogjointsel_btn').removeClass('selBtn');
    $('.plsJ1').addClass('selBtn');
  }
}

// get frame max num callback
function getfrmMaxNumCB(progname, varname, typecode, value, callback) {
  var frameStr = ((varname == '$SCR.$MAXNUMUTOOL') ? "T" : "U");
  var frameInd = ((frameStr == "T") ? TOOL_NUM_IND : USER_NUM_IND);
  frmNumObj[frameStr] = Number(value.slice(0));
  getCurFrmNum(frameInd, callback);
}

// get current frame num
function getCurFrmNum(index, callback) {
  var sysvar = ((index == TOOL_NUM_IND) ? "$MNUTOOLNUM[" + getCurGrp() + "]" : "$MNUFRAMENUM[" + getCurGrp() + "]");
  top.rpcmc_getVar(top.SYSNAME_C, sysvar, callback, index);
}

// set frame num to select box
function setFrmNumDisp(progName, varName, typeCode, frameNumStr, frmIndex) {
  var setBox = ((frmIndex == TOOL_NUM_IND) ? "#utool_num_box" : "#uframe_num_box");
  var setBtn   = setBox.substring(0, 3) + "_box_img";
  var arrw_btn = $(setBtn);

  $(setBox).text(frameNumStr);
  $(setBox).append(arrw_btn);
}

// set frame num
function setFrmNum(frmIndex, frmNum) {
  var sysvar = ((frmIndex == TOOL_NUM_IND) ? "$MNUTOOLNUM[" + getCurGrp() + "]" : "$MNUFRAMENUM[" + getCurGrp() + "]");
  top.rpcmc_setVar(top.SYSNAME_C, sysvar, frmNum);
}

//=============================================================================
// jogkey
//=============================================================================
/* == Stick (Knob/Button) Position data table == */
var knobDiameter   = KNOBSIZEFORTAB;
var knobDefPosT    = KNOBPOSTOPTAB;
var knobDefPlayT   = 35; // px
var knobDefPosL    = KNOBPOSLEFTTAB;
var knobAdjustPos  = 4; // Adjust the upper / left position in the slider area.

//  Stick (Knob/Button) Origin position initialyze
var stickDirection = ''; // Stick direction (Right/Left/Up/Down)
var targetStickId = '';
var prevCursorPos = { x: 0, y: 0 };
var crntCursorPos = { x: 0, y: 0 };
var neutralZone = { t: 0, l: 0, b: 0, r: 0 };
var jogSendStat = { key: '', id: '', grp: 1 };

// JOG key opration
var jogStickState = false;
var sendingJogKey = false;

/*
 * Process of moving the jog stick.
 */
var stickIdBase = 'stick_xx'; // Base part of JOG stick ID
var confKeyIdStickDir = { // A table to convert to key ID depending on stick and direction.
  'stick_pxD': 'xdn', 'stick_pxU': 'xup', 'stick_pyU': 'yri',
  'stick_pyD': 'ylf', 'stick_axD': 'wlf', 'stick_axU': 'wri',
  'stick_ayU': 'pup', 'stick_ayD': 'pdn', 'stick_pzU': 'zup',
  'stick_pzD': 'zdn', 'stick_azU': 'rup', 'stick_azD': 'rdn'
};
// Conversion table of JOG button and 'send key'.
var jogBtnKeyConv = {
  'xup': '+J1', 'xdn': '-J1', 'ylf': '-J2', 'yri': '+J2', 'zup': '+J3', 'zdn': '-J3',
  'pup': '+J5', 'pdn': '-J5', 'wlf': '-J4', 'wri': '+J4', 'rup': '+J6', 'rdn': '-J6',
  'j1p': '+J1', 'j1m': '-J1', 'j2m': '-J2', 'j2p': '+J2', 'j3p': '+J3', 'j3m': '-J3',
  'j4p': '+J4', 'j4m': '-J4', 'j5m': '-J5', 'j5p': '+J5', 'j6p': '+J6', 'j6m': '-J6',
  'rrp': '+J1', 'rrm': '-J1', 'rtm': '-J2', 'rtp': '+J2', 'rzp': '+J3', 'rzm': '-J3',
  'e1p': '+J1', 'e1m': '-J1', 'e2p': '+J2', 'e2m': '-J2', 'e3p': '+J3', 'e3m': '-J3'
};

function initialsetting() {

  //=============================================================================
  // Lower panel area control
  //=============================================================================
  openBtn_control(); // in tpkeys
  keyPanel_control(); // in pnlarea

  document.getElementById("outerframe").addEventListener('touchmove', setMoveEvent, false);
  document.getElementById("outerframe").addEventListener('mousemove', setMoveEvent, false);
  function setMoveEvent(evt) {
    if (isJogStickOn()) {
      canselTextSelection();
      moveJogStick(evt);
      evt.preventDefault();
      return false;
    }
  }

  document.getElementById("outerframe").addEventListener('touchleave', setOuterframeLeaveEvent, false);
  document.getElementById("outerframe").addEventListener('mouseleave', setOuterframeLeaveEvent, false);
  function setOuterframeLeaveEvent(evt) {
    if (isJogStickOn()) {
      canselTextSelection();
      sendJogStickKey(jogSendStat.key, 'off');
      resetJogStick(targetStickId);
      evt.preventDefault();
      return false;
    }
  }

  var stick = document.getElementsByClassName('jogstickbtn');
  for (var cnt = 0; cnt < stick.length; cnt++) {
    stick[cnt].addEventListener('touchstart', setjogStickStartEvent, false);
    stick[cnt].addEventListener('mousedown', setjogStickStartEvent, false);
  }
  function setjogStickStartEvent(evt) {
    befRobotMoveProc(evt);
    evt.preventDefault();
    return false;
  }

  document.getElementById("outerframe").addEventListener('touchend', setOutreFrameEndEvent, false);
  document.getElementById("outerframe").addEventListener('mouseup', setOutreFrameEndEvent, false);
  function setOutreFrameEndEvent(evt){
    sendJogStickKey(jogSendStat.key, 'off');
    resetJogStick(targetStickId);
    evt.preventDefault();
  }

  //Set Android event
  if (navigator.userAgent.indexOf('Android') > 0) {
    androidFlg = true;
  }
  // Reflect status on step button
  document.getElementById("step_tgl_box").checked = getProgramStepMode();
  // Set touchcancel event
  document.addEventListener("touchcancel", releaseJogStick, false);
  // Set visibilitychange event
  document.addEventListener(visCngStr, visChgFunc, false);
}


/*
 =========================================================================
 @function name  : befRobotMoveProc
 @argument       : none
 @description    : Check if the robot can work, and displays a dialog if it is not working.
 @return         : none
 =========================================================================
*/
function befRobotMoveProc(evt) {
  if (!getTPEnb()) { // Please TP ON.
    top.openCmpAlert(top.window, 'msgpopup_alarmtp', top.irpDlgRes["msgpopup_alarmtp"]);

  } else if (getAlarmOn()) { // Please reset alarm.
    top.openCmpAlert(top.window, 'msgpopup_alarm', top.irpDlgRes["msgpopup_alarm"]);

  } else if (gPulseState.startFlg) { // for pulse 
    if (plsExist) {
      top.rpcmc_getVar(top.SYSNAME_C, '$TAB_MPG.$PG_COUNT', setPulseCount);
    } else {
      setPulseCount("", "", "", 1);
    }

  } else if (evt) { // set touch position(Judgment to prevent malfunction is installed.)
    startJogStick(evt);
    if (targetStickId != '') { setJogStickCond(true); }
  }
}

/*
 * Processing of the JOG button that starts with clicking or tapping.
 */
/*
 =========================================================================
 @function name  : startJogStick
 @argument[evt]  : jog event
 @description    : jog start function
 @return         : none
 =========================================================================
*/
function startJogStick(evt) {
  if (!isJogStickOn()) { // Enable and Not already ON.
    targetStickId = evt.target.id;
    prevCursorPos.x = getJogWinClient(evt).clientX;
    prevCursorPos.y = getJogWinClient(evt).clientY;

    neutralZone = getStickNeutralZone(targetStickId);
    debug(DBGDUMP, 'Cursor Position:\nCursor x[' + prevCursorPos.x + ']y[' + prevCursorPos.y + ']');
  }
}

function afStartJogStick() {
  if (targetStickId != ''){
    setJogStickCond(true);
  }
}
/*
 =========================================================================
 @function name  : isJogStickOn
 @argument       : none
 @description    : get jogStickState
 @return         : jogStickState
 =========================================================================
*/
function isJogStickOn() {
  return jogStickState;
}
/*
 =========================================================================
 @function name   : setJogStickCond
 @argument[cond]  : jogStickState
 @description     : set jogStickState
 @return          : none
 =========================================================================
*/
function setJogStickCond(cond) {
  jogStickState = cond;
}
/**
 * Acquisition of client position in pointing device.
 * @param evt event object
 * @return Client position. (.clientX, .clientY)
 */
/*
 =========================================================================
 @function name  : getJogWinClient
 @argument[evt]  : event object
 @description    : getJogWinClient
 @return         : tempEvent
 =========================================================================
*/
function getJogWinClient(evt) {
  var tempEvent = { clientX: 0, clientY: 0 };
  // if (touchBrowser) {
  // if (false) {
  if ((device === 'smt') || (evt.type.indexOf('touch') >= 0)) {
    tempEvent.clientX = evt.touches[0].clientX;
    tempEvent.clientY = evt.touches[0].clientY;
  } else {
    tempEvent.clientX = evt.clientX;
    tempEvent.clientY = evt.clientY;
  }
  return tempEvent;
}
/*
 =========================================================================
 @function name            : getStickNeutralZone
 @argument[targetStickId]  : target stick neutral zone
 @description              : Get target stick neutral zone (top/bottom/left/right).
 @return                   : tempEvent
 =========================================================================
*/
function getStickNeutralZone(targetStickId) {
  var crntStickPos = $('#' + targetStickId).offset();
  var stickNeutral = {};
  stickNeutral.t = crntStickPos.top;
  stickNeutral.b = crntStickPos.top + knobDiameter;
  stickNeutral.l = crntStickPos.left;
  stickNeutral.r = crntStickPos.left + knobDiameter;
  var crntScrollPos = {};
  crntScrollPos.left = $(window).scrollLeft();
  crntScrollPos.top = $(window).scrollTop();
  if (crntScrollPos.top > 0) { // Adjust scroll pos.
    stickNeutral.t -= crntScrollPos.top;
    stickNeutral.b -= crntScrollPos.top;
  }
  if (crntScrollPos.left > 0) { // Adjust scroll pos.
    stickNeutral.l -= crntScrollPos.left;
    stickNeutral.r -= crntScrollPos.left;
  }
  debug(DBGDUMP, 'Get neutral zone:\nPos l[' + stickNeutral.l + ']r[' + stickNeutral.r +
    ']t[' + stickNeutral.t + ']b[' + stickNeutral.b + ']/scrL(' +
    crntScrollPos.left + ')scrT(' + crntScrollPos.top + ')');
  return stickNeutral;
}
/*
 =========================================================================
 @function name  : canselTextSelection
 @argument       : none
 @description    : Cancel text selection.
 @return         : tempEvent
 =========================================================================
*/
// Cancel text selection.
function canselTextSelection() {
  // When the operation of the JOG slider is started,
  // if the text is selected, the selection to be canceled.
  var seltext = document.getSelection();
  if (seltext.toString().length > 0) {
    seltext.removeAllRanges();
  }
}
/*
 =========================================================================
 @function name  : resetJogStick
 @argument       : target Id
 @description    : Reset stick position.
 @return         : none
 =========================================================================
*/
// Reset stick position.
function resetJogStick(targetId) {
  setJogStickCond(false);
  if (targetId == 'stick_al') {
    resetMoveToStick();
  } else if (targetId == 'stick_pl') { // play
    $('#stick_pl').css('left', KNOBPOSLEFTTABP + 'px');
  } else if ((targetId.startsWith('stick_p')) || (targetId.startsWith('stick_a'))) { // cart
    $('#' + targetId).css('top', knobDefPosT + 'px');
  } else if (targetId.startsWith('stick_j')) { // joint
    $('#' + targetId).css('top', knobDefPosT + 'px');
  }
  stickDirection = '';
  targetStickId = '';
}

/*
 =========================================================================
 @function name    : sendJogStickKey
 @argument[keyId]  : keyId
 @argument[onoff]  : on off flag
 @description      : Send JOG key according to JOG stick ID and ON / OFF.
 @return           : none
 =========================================================================
*/

function sendJogStickKey(keyId, onoff) {
  jogSendStat = getJogKey(keyId);
  debug(DBGDUMP, 'send Jog stick key:[' + keyId + '] id:(' + jogSendStat.id + ') grp:[' + jogSendStat.grp + '] onoff:' + onoff + ' stick=[' + isJogStickOn() + ']');
  if (onoff == 'on') {
    if (sendingJogKey) { // Already on.
      debug(DBGDUMP, 'Already On.')
      return;
    }
    debug(DBGDUMP, 'Send JOG key On.')
    sendJogKey(jogSendStat.id, JOGSENDSTAT_SET);
    sendingJogKey = true;
    if (!vibrateInterval) startPersistentVibrate(100, 100);

  } else {
    if (vibrateInterval) stopVibrate();
    if (!isJogStickOn()) { // Already off.
      debug(DBGDUMP, 'Already Off.')
      sendingJogKey = false;
      return;
    }
    if (jogSendStat.id !== '') { // if key sending.
      debug(DBGDUMP, 'Send JOG key Off.')
      sendJogKey(jogSendStat.id, JOGSENDSTAT_CLR);
      sendingJogKey = false;
    }
    jogSendStat = { key: '', id: '', grp: 1 }; // initialize.
  }
}
/*
 =========================================================================
 @function name    : getJogKey
 @argument[id]     : keyId
 @description      : Get JOG key information.
 @return           : sendJogObj
 =========================================================================
*/
function getJogKey(id) {
  var grp = getCurGrp();
  var sendJogObj = { key: '', id: '', grp: 1 };
  if (id.length > 0) { // valid id
    sendJogObj.key = id;
    sendJogObj.id = jogBtnKeyConv[id];
    sendJogObj.grp = grp;
  }
  return sendJogObj;
}
/*
 =========================================================================
 @function name    : getJogKey
 @argument[key]    : keyId
 @argument[status] : status
 @description      : Sending jog key
 @return           : none
 =========================================================================
*/
// Sending jog key
function sendJogKey(key, jogSendStatus) {
  if (targetStickId .startsWith('stick_je') && !curSubGrp) {
    setVarWithSubGrp("1", moveJogkey);
  } else if ((targetStickId .startsWith('stick_a') || targetStickId .startsWith('stick_p') || targetStickId .startsWith('stick_jj') || targetStickId .startsWith('stick_jr')) && curSubGrp) {
    setVarWithSubGrp("0", moveJogkey);
  } else {
    moveJogkey();
  }
  function moveJogkey() {
    if (jogSendStatus == 1) { // Process of command.
      sendShiftKey(1);
      top.sendKey(key, 1);
    } else {
      top.sendKey(key, 0);
      sendShiftKey(0);
    }
  }
}

// Stop shift key release until program execution is completely stopped.
function befSendShiftRel() {

  // Since it is called multiple times in a short time,
  // it is necessary to perform processing to prevent duplicate processing.
  if (sendShiftFlg) { return; }
  sendShiftFlg = true;

  // get running LED status
  setTimeout(function () {
    top.rpcmc_iovalrd(top.tpout_type_c, 5, checkStatShift, 0, 0);
  }, 200);

}

function checkStatShift(iotype, index, stat, callbackarg1, callbackarg2) {
  sendShiftFlg = false;
  if (stat == 0) {
    sendShiftKey(0);
  } else {
    befSendShiftRel();
  }
}

/*
 =========================================================================
 @function name    : sendShiftKey
 @argument[value]  : shift mode.
 @description      : sendShiftKey
 @return           : none
 =========================================================================
*/
function sendShiftKey(value) {
  if (isExistSRDlg()) { return; } // Shift Reset Mode
  top.sendKey("R-shift", value);
  top.sendKey("L-shift", value);
}

function isExistSRDlg() {
  var frmCnt = top.countMultiIFrame();
  var dlgCnt = 0;

  switch (frmCnt) {
    case 3:
      try {
        if (top.mainfrm.third.document.getElementById('shiftResetDlg') != null) {
          if (top.mainfrm.third.document.getElementById('shiftResetDlg').style.display != "none") { dlgCnt++; }
        }
      } catch (e) {}
    case 2:
      try {
        if (top.mainfrm.dual.document.getElementById('shiftResetDlg') != null) {
          if (top.mainfrm.dual.document.getElementById('shiftResetDlg').style.display != "none") { dlgCnt++; }
        }
      } catch (e) {}
    case 1:
      try {
        if (top.mainfrm.prim.document.getElementById('shiftResetDlg') != null) {
          if (top.mainfrm.prim.document.getElementById('shiftResetDlg').style.display != "none") { dlgCnt++; }
        }
      } catch (e) {}
    default:
    break;
  }
  if (dlgCnt > 0) { return true; }
  return false;
}

/*
 =========================================================================
 @function name  : moveJogStick
 @argument[evt]  : jog evt.
 @description    : jog operation function
 @return         : none
 =========================================================================
*/
function moveJogStick(evt) {
  crntCursorPos.x = getJogWinClient(evt).clientX;
  crntCursorPos.y = getJogWinClient(evt).clientY;
  var diffX = crntCursorPos.x - prevCursorPos.x;
  var diffY = crntCursorPos.y - prevCursorPos.y;
  prevCursorPos.x = crntCursorPos.x;
  prevCursorPos.y = crntCursorPos.y;
  var fixKnobPosTop = knobDefPosT;
  var maxKnobPosTop = knobDefPosT * 2;
  var sendKeyId = '';
  var sendJogInfo = {};
  var stickId = targetStickId.substring(0, stickIdBase.length);

  if ((!targetStickId) ||
    ((!targetStickId.startsWith('stick_a')) &&
     (!targetStickId.startsWith('stick_j')) &&
     (!targetStickId.startsWith('stick_p')))) { return; }

  stickDirection = getVertStickDirection(stickDirection, diffX, diffY);
  if (stickDirection.length == 0) { return; }

  if ((targetStickId.startsWith('stick_p')) ||
      (targetStickId.startsWith('stick_a'))) { // cart

    var sendOnPos = (stickDirection == 'U') ? 0 : maxKnobPosTop;
    sendJogInfo = makeJogMoveSendInfo(stickDirection, knobAdjustPos, sendOnPos, fixKnobPosTop);
    sendKeyId = confKeyIdStickDir[stickId + stickDirection];

  } else if (targetStickId.startsWith('stick_j')) { // joint

    var sendOnPos = (stickDirection == 'U') ? 0 : maxKnobPosTop;
    var jogNum = targetStickId.substring('stick_j'.length).toLowerCase();
    sendJogInfo = makeJogMoveSendInfo(stickDirection, knobAdjustPos, sendOnPos, fixKnobPosTop);
    sendKeyId = (stickDirection == 'D') ? jogNum + 'm' : (stickDirection == 'U') ? jogNum + 'p' : '';
  }

  stickDirection = sendJogInfo.direct;
  if (($('#' + targetStickId).css("top") != sendJogInfo.moveT + 'px') ||
      ($('#' + targetStickId).css("left") != sendJogInfo.moveL + 'px')) {
    sendJogStickKey(sendKeyId, sendJogInfo.onoff);
  }
  $('#' + targetStickId).css({ 'top': sendJogInfo.moveT + 'px' });
}

/*
 =========================================================================
 @function name  : movePlayStick
 @argument[evt]  : play evt.
 @description    : play operation function
 @return         : none
 =========================================================================
*/
function movePlayStick(evt) {
  crntCursorPos.x = getJogWinClient(evt).clientX;
  crntCursorPos.y = getJogWinClient(evt).clientY;
  var diffX = crntCursorPos.x - prevCursorPos.x;
  var diffY = crntCursorPos.y - prevCursorPos.y;
  prevCursorPos.x = crntCursorPos.x;
  prevCursorPos.y = crntCursorPos.y;
  var fixKnobPosTop = knobDefPlayT;
  var fixKnobPosLeft = KNOBPOSLEFTTABP;
  var maxKnobPosLeft = KNOBPOSLEFTTABP * 2;
  var sendJogInfo = {};
  var stickId = targetStickId.substring(0, stickIdBase.length);

  if (stickId != "stick_pl") { return; }
  stickDirection = getHorzStickDirection(stickDirection, diffX, diffY);
  if (stickDirection.length == 0) { return; }

  var fixSidePos = ((stickDirection == 'L') || (stickDirection == 'R')) ? fixKnobPosTop : fixKnobPosLeft;
  var sendOnPos  = ((stickDirection == 'R') ? maxKnobPosLeft : 0);
  var sendOffPos = ((stickDirection == 'L') || (stickDirection == 'R')) ? fixKnobPosLeft : fixKnobPosTop;
  sendJogInfo = makeJogMoveSendInfo(stickDirection, fixSidePos, sendOnPos, sendOffPos);
  stickDirection = sendJogInfo.direct;

  if ((sendJogInfo.onoff == "off") && (doRelShift)) {
    doRelShift = false;
    holdProgram();
  } else if ((stickDirection == 'R') && (!doRelShift)) {
    doRelShift = true;
    check_exeprog(BTN_EXE_MODE, befExecProgProc, execProgProc);
  } else if ((stickDirection == 'L') && (!doRelShift)) {
    doRelShift = true;
    check_exeprog(BTN_BACK_MODE, befExecProgProc, execProgProc);
  }
  if (targetStickId == '') { return;}
  $('#' + targetStickId).css({ 'left': sendJogInfo.moveL + 'px' });
}

function moveMoveToStick(evt) {
  crntCursorPos.x = getJogWinClient(evt).clientX;
  var diffX = crntCursorPos.x - prevCursorPos.x;
  prevCursorPos.x = crntCursorPos.x;
  var stopKnobPosLeft = 0;
  var moveKnobPosLeft = 30;
  var sendJogInfo = {};
  var stickId = targetStickId.substring(0, stickIdBase.length);
  if (stickId != "stick_al") { return; }
  stickDirection = getAlignStickDirection(stickDirection, diffX);
  if (stickDirection.length == 0) { return; }

  sendJogInfo = makeAlignMoveSendInfo(stickDirection, moveKnobPosLeft, stopKnobPosLeft);
  stickDirection = sendJogInfo.direct;
  if (targetStickId == '') { return;}
  $('#' + targetStickId).css({ 'left': sendJogInfo.moveL + 'px' });
  if ((sendJogInfo.onoff == "off") && (alignShift)) {
    alignShift = false;
    onEndMvTo();
  } else if ((sendJogInfo.onoff == "on") && (!alignShift)) {
    alignShift = true;
    moveTo();
  }
}

function getAlignStickDirection(direct, diffX) {
  if (direct.length == 0) {
    if ((diffX < 0) && (Math.abs(diffX) > 0)) {
      direct = 'L';
    } else if ((diffX > 0) && (Math.abs(diffX) > 0)) {
      direct = 'R';
    } else {
      direct = '';
    }
  }
  return direct;
}

function makeAlignMoveSendInfo(direction, sendOnPos, sendOffPos) {
  var jogInfo = {};
  jogInfo.direct = direction;
  if (crntCursorPos.x > neutralZone.r) {
    jogInfo.moveL = sendOnPos;
    jogInfo.onoff = 'on';
  } else {
    jogInfo.direct = '';
    jogInfo.moveL = sendOffPos;
    jogInfo.onoff = 'off';
  }
  return jogInfo;
}

function resetMoveToStick() {
  alignShift = false;
  setJogStickCond(false);
  document.getElementById('stick_al').style.left = '0px';
}

/*
 =========================================================================
 @function name     : getCrossStickDirection
 @argument[direct]  : jog evt.
 @argument[diffX]   : diffX.
 @argument[diffY]   : diffY.
 @description       : Get direction of cross type JOG button.
 @return            : none
 =========================================================================
*/
function getCrossStickDirection(direct, diffX, diffY) {
  if (direct.length == 0) {
    if ((diffX < 0) && (Math.abs(diffX) > Math.abs(diffY))) {
      direct = 'L';
    } else if ((diffX > 0) && (diffX > Math.abs(diffY))) {
      direct = 'R';
    } else if ((diffY < 0) && (Math.abs(diffY) > Math.abs(diffX))) {
      direct = 'U';
    } else if ((diffY > 0) && (diffY > Math.abs(diffX))) {
      direct = 'D';
    } else {
      direct = '';
    }
  }
  debug(DBGDUMP, "Direction cross => [" + direct + "]");
  return direct;
}

/*
 =========================================================================
 @function name     : getVertStickDirection
 @argument[direct]  : direction
 @argument[diffX]   : jogInfo.moveT.
 @argument[diffY]   : jogInfo.moveL.
 @description       : Get direction of vertical type JOG button.
 @return            : none
 =========================================================================
*/
function getVertStickDirection(direct, diffX, diffY) {
  if (direct.length == 0) {
    if ((diffY < 0) && (Math.abs(diffY) > Math.abs(diffX))) {
      direct = 'U';
    } else if ((diffY > 0) && (diffY > Math.abs(diffX))) {
      direct = 'D';
    } else {
      direct = '';
    }
  }
  debug(DBGDUMP, "Direction vert => [" + direct + "]");
  return direct;
}
// Get direction of horizontal type JOG button.
function getHorzStickDirection(direct, diffX, diffY) {
  if (direct.length == 0) {
    if ((diffX < 0) && (Math.abs(diffX) > Math.abs(diffY))) {
      direct = 'L';
    } else if ((diffX > 0) && (diffX > Math.abs(diffY))) {
      direct = 'R';
    } else {
      direct = '';
    }
  }
  return direct;
}

/*
 =========================================================================
 @function name         : makeJogMoveSendInfo
 @argument[direction]   : direction
 @argument[fixSidePos]  : jogInfo.moveT.
 @argument[sendOnPos]   : jogInfo.moveL.
 @argument[sendOffPos]  : jogInfo.onoff.
 @description           : Get direction of cross type JOG button.
 @return                : none
 =========================================================================
*/
function makeJogMoveSendInfo(direction, fixSidePos, sendOnPos, sendOffPos) {
  var jogInfo = {};
  jogInfo.direct = direction;
  switch (direction) {
    case 'L': // Left
      jogInfo.moveT = fixSidePos;
      if (crntCursorPos.x < neutralZone.l) {
        jogInfo.moveL = sendOnPos;
        jogInfo.onoff = 'on';
      } else {
        jogInfo.direct = '';
        jogInfo.moveL = sendOffPos;
        jogInfo.onoff = 'off';
      }
      break;
    case 'R': // Right
      jogInfo.moveT = fixSidePos;
      if (crntCursorPos.x > neutralZone.r) {
        jogInfo.moveL = sendOnPos;
        jogInfo.onoff = 'on';
      } else {
        jogInfo.direct = '';
        jogInfo.moveL = sendOffPos;
        jogInfo.onoff = 'off';
      }
      break;
    case 'U': // Up
      jogInfo.moveL = fixSidePos;
      if (crntCursorPos.y < neutralZone.t) {
        jogInfo.moveT = sendOnPos;
        jogInfo.onoff = 'on';
      } else {
        jogInfo.direct = '';
        jogInfo.moveT = sendOffPos;
        jogInfo.onoff = 'off';
      }
      break;
    case 'D': // Down
      jogInfo.moveL = fixSidePos;
      if (crntCursorPos.y > neutralZone.b) {
        jogInfo.moveT = sendOnPos;
        jogInfo.onoff = 'on';
      } else {
        jogInfo.direct = '';
        jogInfo.moveT = sendOffPos;
        jogInfo.onoff = 'off';
      }
      break;
  }
  return jogInfo;
}

function openBtn_control() {
  /* playPanel Display control*/
  var playPanelElm = top.tpkeys.document.getElementById('play_btn_parent');
  var playPanelCntrl = new Hammer(playPanelElm);
  playPanelCntrl.get('swipe').set({ direction: Hammer.DIRECTION_VERTICAL });
  playPanelCntrl.on('tap swipeup', function (event) {
    /* Do not process during variable acquisition */
    if ((getVarFlg) || (top.wait_key_open)) {
      return;
    }
    /* playPanel showing */
    if (activeBtnId == P_BTNID[PLY_PNL]) {
      if (event.type === 'tap') {
        /* playPanel Hidden processing */
        setPnlMode(PLY_PNL, false);
      }
    }
    /* playPanel hidden */
    else {

      /* jogPanel showing */
      if ((activeBtnId == P_BTNID[JOG_PNL]) && (pnlEnb[PLY_PNL])) {
      /* jogPanel hidden processing */
        setPnlMode(JOG_PNL, false);

      }
      /* playPanel display processing*/
      setPnlMode(PLY_PNL, true);
      /* check ldtr toggle*/
      if ($("#ldtr_tgl_area").css('display') != "none") {
        if (document.getElementById('ldtr_tgl_oprt').checked) {
          top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDTR_BTN', "0");
          top.IHMIComponents.cf.toast.show(ldtrMsgRes['ldtr_end']);
        }
      }
      if ($("#pltmode_tgl").css('display') == "none") {
        $('#pltmode_tgl').css('display','inline-block');
      }
    }
  });

  /* jogPanel Display control */
  var jogPanelElm = top.tpkeys.document.getElementById('jog_btn_parent');
  var jogPanelCntrl = new Hammer(jogPanelElm);
  jogPanelCntrl.get('swipe').set({ direction: Hammer.DIRECTION_VERTICAL });
  jogPanelCntrl.on('tap swipeup', function (event) {
    /* Do not process during variable acquisition */
    if ((getVarFlg) || (top.wait_key_open)) {
      return;
    }
    /* jogPanel Showing */
    if (activeBtnId == P_BTNID[JOG_PNL]) {
      if (event.type === 'tap') {
        /* jogPanelHidden processing */
        setPnlMode(JOG_PNL, false);
      }
    }
    /* jogPanel hidden */
    else {

      if (pnlEnb[JOG_PNL]) {
        /* playPanelHidden processing */
        if (activeBtnId == P_BTNID[PLY_PNL]) {
          setPnlMode(PLY_PNL, false);
        }
        setGetVarFlg(true);
        if (gLdtrState.tabSys == LDTR_TAB_STAT.HIDE) {
          hideTabBtn(P_TABID[LDTR_TAB]); // hide leadthrough button and flag reset
          setLdtrEnb(false);
        } else if (gLdtrState.tabSys == LDTR_TAB_STAT.DISP) {
          showTabBtn(P_TABID[LDTR_TAB]);
        }
        top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$TAB_MPG.$DISP_PANEL', getMpgValEnbCB, null);
      }
    }
  });

  switchAllBtnMode(); // For when button is reloaded
}

/*
 =========================================================================
 @function name  : keyPanel_control
 @argument       : none
 @description    : Lower panel area control
 @return         : none
 =========================================================================
*/
function keyPanel_control() {

  /* playPanel swipe control */
  var playPanelTop = document.getElementById('playPanelTop');
  var playPanelSwipeCntrl = new Hammer(playPanelTop);
  playPanelSwipeCntrl.get('swipe').set({ direction: Hammer.DIRECTION_VERTICAL });
  playPanelSwipeCntrl.on('swipedown', function (event) {
    /* playPanelHidden processing */
    setPnlMode(PLY_PNL, false);
  });

  /* jogPanel swipe control*/
  var jogPanelTop = document.getElementById('jogPanelTop');
  var jogPanelSwipeCntrl = new Hammer(jogPanelTop);
  jogPanelSwipeCntrl.get('swipe').set({ direction: Hammer.DIRECTION_VERTICAL });
  jogPanelSwipeCntrl.on('swipedown', function (event) {
    /* jogPanelHidden processing */
    setPnlMode(JOG_PNL, false);
  });

  $('#jogLdtrTab').on("mouseup touchend", function (event) {
    event.preventDefault();
    if (!getVarFlg) {
      var curTab = "#" + $('.tab_active').attr('id');
      if (curTab == P_TABID[LDTR_TAB]) { return; }
      g_selTab = P_TABID[LDTR_TAB];
      setGetVarFlg(true);
      setPlsEnb(false);
      setLdtrEnb(true);
      openLdtrPnl();
    }
  });

  $('#jogMpgTab').on("mouseup touchend", function (event) {
    event.preventDefault();
    if (!getVarFlg) {
      var curTab = "#" + $('.tab_active').attr('id');
      if (curTab == P_TABID[PLS_TAB]) { return; }
      g_selTab = P_TABID[PLS_TAB];
      setLdtrEnb(false);
      setPlsEnb(true);
      switchJogPnlElm(PLS_TAB);
    }
  });

  /* robot operation swiching toggle */
  $('#jogSldrTab').on("mouseup touchend", function (event) {
    event.preventDefault();
    if (!getVarFlg) {
      var curTab = "#" + $('.tab_active').attr('id');
      if (curTab == P_TABID[JOG_TAB]) { return; }
      g_selTab = P_TABID[JOG_TAB];
      setLdtrEnb(false);
      setPlsEnb(false);
      switchJogPnlElm(JOG_TAB);
    }
  });

  $('#jogAlign').on("mouseup touchend", function (event) {
    event.preventDefault();
    if (!getVarFlg) {
      var curTab = "#" + $('.tab_active').attr('id');
      if (curTab == P_TABID[ALIGN_TAB]) { return; }
      g_selTab = P_TABID[ALIGN_TAB];
      setPlsEnb(false);
      setLdtrEnb(false);
      switchJogPnlElm(ALIGN_TAB);
    }
  });

  /* leadthrough Panel button control*/
  $('#ldtr_icon_f_btn').on("mouseup touchend", function (event) {
    event.preventDefault();
    var curBtn = "#" + $('.btn_active').attr('id');
    if (curBtn == L_BTNID[LDTR_MODE_F] || L_BTNID_NUM[curBtn] != gLdtrState.class) { return; }
    settingLdtrPnl(LDTR_MODE_F, true);
  });
  $('#ldtr_icon_p_btn').on("mouseup touchend", function (event) {
    event.preventDefault();
    var curBtn = "#" + $('.btn_active').attr('id');
    if (curBtn == L_BTNID[LDTR_MODE_P] || L_BTNID_NUM[curBtn] != gLdtrState.class) { return; }
    settingLdtrPnl(LDTR_MODE_P, true);
  });
  $('#ldtr_icon_t_btn').on("mouseup touchend", function (event) {
    event.preventDefault();
    var curBtn = "#" + $('.btn_active').attr('id');
    if (curBtn == L_BTNID[LDTR_MODE_T] || L_BTNID_NUM[curBtn] != gLdtrState.class) { return; }
    settingLdtrPnl(LDTR_MODE_T, true);
  });
  $('#ldtr_icon_c_btn').on("mouseup touchend", function (event) {
    event.preventDefault();
    var curBtn = "#" + $('.btn_active').attr('id');
    if (curBtn == L_BTNID[LDTR_MODE_C] || L_BTNID_NUM[curBtn] != gLdtrState.class) { return; }
    settingLdtrPnl(LDTR_MODE_C, true);
  });

  /* play stick processing */
  document.getElementById("crsplboxup").addEventListener('touchmove', setCrsplboxupMoveEvent, false);
  document.getElementById("crsplboxup").addEventListener('mousemove', setCrsplboxupMoveEvent, false);
  function setCrsplboxupMoveEvent(evt){
    if (isJogStickOn()) {
      canselTextSelection();
      movePlayStick(evt);
      evt.preventDefault();
      return false;
    }
  }

  document.getElementById("crsplboxup").addEventListener('touchleave', setCrsplboxupLeaveEvent, false);
  document.getElementById("crsplboxup").addEventListener('mouseleave', setCrsplboxupLeaveEvent, false);
  function setCrsplboxupLeaveEvent(evt){
    resetSafetyTimer();
    if (isJogStickOn()) {
      canselTextSelection();
      holdProgram();
      resetStickProc();
      evt.preventDefault();
      return false;
    }
  }

  document.getElementById("stick_pl").addEventListener('touchstart', setCrsplboxupStartEvent, false);
  document.getElementById("stick_pl").addEventListener('mousedown', setCrsplboxupStartEvent, false);
  function setCrsplboxupStartEvent(evt){
    if (statMode != WATCHEXEC_RUNNING || ledMode != WATCHEXEC_RUNNING) { // The slider cannot be operated while the program is running.
      startJogStick(evt); // Just only pressed a button (stick).
      afStartJogStick();
    }
    evt.preventDefault();
    return false;
  }

  document.getElementById("crsplboxup").addEventListener('touchend', setCrsplboxupEndEvent, false);
  document.getElementById("crsplboxup").addEventListener('mouseup', setCrsplboxupEndEvent, false);
  function setCrsplboxupEndEvent(evt){
    resetSafetyTimer();
    if (isJogStickOn()) {
      holdProgram();
      resetStickProc();
      evt.preventDefault();
      return false;
    }
  }

 /* align move to stick processing */
 document.getElementById("alignMoveArea").addEventListener('touchmove', setAlignAreaMoveEvent, false);
 document.getElementById("alignMoveArea").addEventListener('mousemove', setAlignAreaMoveEvent, false);
 function setAlignAreaMoveEvent(evt){
  if (isJogStickOn()) {
     canselTextSelection();
     moveMoveToStick(evt);
     evt.preventDefault();
     return false;
   }
 }

 document.getElementById("alignMoveArea").addEventListener('touchleave', setAlignAreaLeaveEvent, false);
 document.getElementById("alignMoveArea").addEventListener('mouseleave', setAlignAreaLeaveEvent, false);
 function setAlignAreaLeaveEvent(evt){
   if (isJogStickOn()) {
    canselTextSelection();
    onEndMvTo();
    resetMoveToStick();
    evt.preventDefault();
    return false;
   }
 }

 document.getElementById("stick_al").addEventListener('touchstart', setAlignAreaStartEvent, false);
 document.getElementById("stick_al").addEventListener('mousedown', setAlignAreaStartEvent, false);
 function setAlignAreaStartEvent(evt){
  if (statMode != WATCHEXEC_RUNNING || ledMode != WATCHEXEC_RUNNING) { // The slider cannot be operated while the program is running.
    startJogStick(evt); // Just only pressed a button (stick).
    afStartJogStick();
  }
  evt.preventDefault();
  return false;
 }

 document.getElementById("alignMoveArea").addEventListener('touchend', setAlignAreaEndEvent, false);
 document.getElementById("alignMoveArea").addEventListener('mouseup', setAlignAreaEndEvent, false);
 function setAlignAreaEndEvent(evt){
   if (isJogStickOn()) {
    onEndMvTo();
    resetMoveToStick();
    evt.preventDefault();
    return false;
   }
 }

  // append panel lock button
  var $btnLockPnlP = $('<button>', { id: 'pnlLockBtnP', class: 'pnlLockBtn' });
  var $btnLockPnlJ = $('<button>', { id: 'pnlLockBtnJ', class: 'pnlLockBtn' });
  $("#scroll_play").append($btnLockPnlP);
  $("#panel_j").append($btnLockPnlJ);
  document.getElementById("pnlLockBtnP").addEventListener('touchend', switchPnlLockProc, false);
  document.getElementById("pnlLockBtnJ").addEventListener('touchend', switchPnlLockProc, false);
  document.getElementById("pnlLockBtnP").addEventListener('mouseup', switchPnlLockProc, false);
  document.getElementById("pnlLockBtnJ").addEventListener('mouseup', switchPnlLockProc, false);
  dispPnlLock(!top.is_key_open);
  function switchPnlLockProc(evt) {
    // This is a solution to a problem with the software keyboard on Android devices.
    var skipPnlOpen = false;

    if (androidFlg) { // Android Chrome and Android web view only
      var activeInput = getActvElmAllFrm(top.document.activeElement);
      var inputList = ['text', 'textarea', 'tel', 'url', 'email', 'password'];
      // If you are operating an input element other than a button, the software keyboard is displayed.
      skipPnlOpen = ((activeInput.tagName == 'INPUT') && (inputList.indexOf(activeInput.type) > -1));
    }

    // Display a popup or fixing the panel.
    if (skipPnlOpen) {
      top.openCmpAlert(top.window, 'msgpopup_softkeydisp', top.irpDlgRes["msgpopup_softkeydisp"]);
    } else {
      switchPnlLock(!top.is_lock_pnl, true);
    }
    evt.preventDefault();
    return false;
  }

  if (top.g_crx) {
    $(window).on("resize", function (event) {
      var jogTab = $(".jog_tab");
      for (var i = 0; i < jogTab.length; i++) {
        var trgTab = $('#' + jogTab[i].id);
        var tabText = trgTab.text();
        var tabFontSize = adjustTextFontSize(tabText, 16, trgTab.width());
        trgTab.css({"font-size": tabFontSize, "white-space": "nowrap"});
      }
    });
  }
}

function getActvElmAllFrm(activeElem) {
  var shadowRoot = activeElem.shadowRoot;
  var contentDocument = activeElem.contentDocument;

  if (shadowRoot && shadowRoot.activeElement) {
    return getActvElmAllFrm(shadowRoot.activeElement);
  }
  if (contentDocument && contentDocument.activeElement) {
    return getActvElmAllFrm(contentDocument.activeElement);
  }
  return activeElem;
}

// Precautionary measure to release the shift if the run stick is released but not paused.
function resetSafetyTimer() {
  clearTimeout(g_safetyTimer);
  g_safetyTimer = setTimeout(function () {
    var jogPanelCol = top.tpkeys.document.getElementById("jog_btn_parent").style.background;
    if (jogPanelCol == 'rgb(190, 190, 190)') {
      sendShiftKey(0);
    }
  }, 500);
}

// release stick and init flag
function resetStickProc() {
  doRelShift = false;
  resetJogStick(targetStickId);
  befSendShiftRel(); // release shift is required
  setPnlEnb(null, true, null);
}

function initPnlProc() {
  resetStickProc();
  restrictPlayPnl(false);
}

function resizePnlProc() {
  if (activeBtnId != "") {
    var winH = top.h_mainfrm + top.$('#statbar').outerHeight();
    var frmH = ((activeBtnId == P_BTNID[JOG_PNL]) ? getAppJogH() : PLYPNL_H);
    var frmT = winH - (((activeBtnId == P_BTNID[JOG_PNL]) ? frmH : PLYPNL_H) + TPKEYS_H);
    var statH = top.$('#statbar').outerHeight() + 40;    // 40px:#primstat height
    $('#pnlarea', parent.document).css({ "top": (frmT < statH ? statH : frmT )+ "px" });
  }
}

// set panel display and btn enable
function setPnlMode(btn, swich) {
  // btn invalid
  if (!pnlEnb[btn]) { return;}

  // -------------------- main process
  setPnlDisp(btn, swich);
  swichBtnMode(swich, btn); // change color
  activeBtnId = ((swich) ? P_BTNID[btn] : "");
  // -------------------- main process
}

// Activating the execute button individually
function setPnlDisp(btn, swich) {
  var pnlBase = $('#pnlarea', parent.document);
  var trgtPnl = pnlBase.contents().find(P_PNLID[btn]);

  if (swich) { // Display(block) panel area first.

    var frmH = ((btn == JOG_PNL) ? getAppJogH() : PLYPNL_H);
    var winH = parent.window.innerHeight;
    var frmT = winH - (((btn == JOG_PNL) ? frmH : PLYPNL_H) + TPKEYS_H);
    var statH = top.$('#statbar').outerHeight() + 40;    // 40px:#primstat height
    pnlBase.css({ "display": "block", "top": "auto", "bottom": TPKEYS_H + "px" });
    pnlBase.stop().animate({ height: frmH + 'px' }, 200);
    trgtPnl.stop().animate({ height: '100%' }, 500,
      function () {
        pnlBase.css({ "box-shadow": "0px -3px 5px 0px rgba(0, 0, 0, 0.8)",
        "top": (frmT < statH ? statH : frmT )+ "px", "bottom": "auto" });
        if (top.is_lock_pnl) { switchPnlLock(true, true); }
      }
    );

  } else { // Hides(none) the panel area after storing the panel.

    pnlBase.css({ "box-shadow": "0 0 0 0 #000000" });
    trgtPnl.stop().animate({ height: '0px' }, 500,
      function () { // If another panel is visible, don't hide the panel area.
        if (activeBtnId != "") {
          if (top.is_lock_pnl) { switchPnlLock(true, true); }
        } else {
          pnlBase.css({ "display": "none" });
          if ((top.is_lock_pnl) && (typeof top.iframe_size === 'function')) { top.iframe_size(); } // resize iframe (mainfrm, dummypnlarea)
        }
      }
    );
  }
}

// These functions is called from "irprog_api.js".
// Set the panel status.
var g_selTab = "";
function l_setPnlState(pnlName, isDisp, isLock, tabName, ldtrMode) {
  g_selTab = tabName;
  // Do nothing while the program is running.
  if (!pnlEnb[JOG_PNL]) return;
  // Waiting until ready.
  if ((getVarFlg) || (top.wait_key_open)) {
    setTimeout(function () { l_setPnlState(pnlName, isDisp, isLock, tabName, ldtrMode); }, 100);
  } else {

    // Whether or not to display the panel.
    if (isDisp) {
      if (pnlName == PLY_PNL) {
        if (activeBtnId != P_BTNID[PLY_PNL]) {
          if (activeBtnId == P_BTNID[JOG_PNL]) {
            /* jogPanel hidden processing */
            setPnlMode(JOG_PNL, false);
          }
          if (isLock != top.is_lock_pnl) { switchPnlLock(isLock, top.is_lock_pnl); }
          /* playPanel display processing*/
          setPnlMode(PLY_PNL, true);
        } else {
          if (isLock != top.is_lock_pnl) { switchPnlLock(isLock, true); }
        }

      } else if (pnlName == JOG_PNL) {
        if (activeBtnId != P_BTNID[JOG_PNL]) {
          if (activeBtnId == P_BTNID[PLY_PNL]) {
            /* playPanel hidden processing */
            setPnlMode(PLY_PNL, false);
          }
          if (isLock != top.is_lock_pnl) { switchPnlLock(isLock, top.is_lock_pnl); }

          // Select the JOG_PNL tab.
          if (tabName in P_TABID) {
            var curTab = "#" + $('.tab_active').attr('id');
            if (P_TABID[tabName] != curTab) {
              if (tabName != LDTR_TAB) {
                $(P_TABID[tabName]).trigger("mouseup");
              } else {
                setPlsEnb(false);
                setLdtrEnb(true);
              }
            }
          }
          setGetVarFlg(true);
          top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$TAB_MPG.$DISP_PANEL', getMpgValEnbCB, null);

        } else {
          // Whether or not to lock the panel.
          if (isLock != top.is_lock_pnl) { switchPnlLock(isLock, true); }

          // Select the JOG_PNL tab.
          if (tabName in P_TABID) {
            var curTab = "#" + $('.tab_active').attr('id');
            if (P_TABID[tabName] != curTab) {
              $(P_TABID[tabName]).trigger("mouseup");
            }
          }
        }

        // Select the leadthrough mode.
        if (ldtrMode in L_BTNID) {
          var curBtn = "#" + $('.btn_active').attr('id');
          if (curBtn != L_BTNID[ldtrMode]) {
            top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_TYPE', ldtrMode);
          }
        }
      }

    } else {
      if (activeBtnId == P_BTNID[pnlName]) {
        /* Panel hidden processing */
        setPnlMode(pnlName, false);
      }
      // Whether or not to lock the panel.
      if (isLock != top.is_lock_pnl) { switchPnlLock(isLock, (top.is_lock_pnl || (activeBtnId != ""))); }
    }
  }
}
function l_setNextLdtrMode() {
  var curBtn = "#" + $('.btn_active').attr('id');
  Object.keys(L_BTNID).forEach(function (key) {
    if (this[key] == curBtn) {
      var nextBtnKey = (Number(key) + 1) % Object.keys(L_BTNID).length;
      top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_TYPE', nextBtnKey);
    }
  }, L_BTNID);
}

function setDispLdtrCustMode(isDisp) {
  if (isDisp) {
    var lang = top.irprogapi.getCurrentLanguage();
    if (lang == "eg") $('#cust_frm_txt')[0].style.fontSize = '13px';
    initCust();
    $('#scroll_jog').css('min-width', '696px');
    $(L_SLDRCLASS[LDTR_MODE_P]).css('width', 'calc(100% - 468px)');
    $('#ldtrwindow').css('width', 'calc(100% - 330px)');
    $('#teachweight_txt').css('width', 'calc(100% - 360px)');
    $('.ldtr_mode_c').css('display', 'block');
    $('#coordCustList').removeClass('setVisible');
    $('#slider3_val').css('width', '60px');
  } else {
    fintCust();
    $('#scroll_jog').css('min-width', '650px');
    $(L_SLDRCLASS[LDTR_MODE_P]).css('width', 'calc(100% - 318px)');
    $('#ldtrwindow').css('width', 'calc(100% - 150px)');
    $('#teachweight_txt').css('width', 'calc(100% - 190px)');
    $('.ldtr_mode_c').css('display', 'none');
    $('#coordCustList').addClass('setVisible');
    $('#slider3_val').css('width', '80px');
  }
}

// change button color and set system value
var ldtrTypeMoniActFlg = true;
function settingLdtrPnl(btn, btnOprt) {
  if (!ldtrTypeMoniActFlg) return;
  var orderSliderClass = ((btn == LDTR_MODE_F) ?
    L_SLDRCLASS[LDTR_MODE_P] : // override slider hidden
    L_SLDRCLASS[LDTR_MODE_F]); // weight slider hidden
  setDispLdtrCustMode(btn == LDTR_MODE_C);
  var isDisp = (btn == LDTR_MODE_F) ? false : true;
  dispPltModeTgl(isDisp);
  if (btn != L_BTNID_NUM[getCurSelLdtrBtnId()]) {
    ldtrTypeMoniActFlg = false;
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_TYPE', 100);
    stopLdtrRateMoni();
    $('.btn_active').removeClass('btn_active');
    $(L_BTNID[btn]).addClass('btn_active');
    if (btnOprt) top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_TYPE', btn);
    getTeachWeight(startLdtrRateMoni);
  } else {
    $(orderSliderClass).css('display', 'none');
  }
  function startLdtrRateMoni(weightStr) {
    $(orderSliderClass).css('display', 'none');
    reflectTeachWeight(weightStr);
    ldtrTypeMoniActFlg = true;
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_TYPE', 100);
    top.rpcmc_startVarMonitor(top.SYSNAME_C, TEACH_WEIGHT_VARNAME[Number(btn)], 100);
    if ("#" + $('.tab_active').attr('id') == P_TABID[LDTR_TAB]) {
      $(L_SLDRCLASS[btn]).css('display', 'block');
    }
  }
}

function stopLdtrRateMoni() {
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_RATE', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDCT_RATE[1]', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDCT_RATE[2]', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDCT_RATE[3]', 100);
}

// Calculate the height of app jog area and reply
function getAppJogH() {
  // get displayed tabs
  var cnt = Object.keys(P_TABID).length;
  Object.keys(P_TABID).forEach(function (key) {
    if ($(this[key])[0].style.display == 'none') { cnt--; }
  }, P_TABID);

  var returnH = JOGPNL_H;
  var grpTabH = ((allGrpNum > 1) ? SELGRPTAB_H : 0);
  var jogTabH = (((allGrpNum == 1) && (cnt <= 1)) ? JOGPNLTAB_H : 0);
  var appJogPnlElm = document.getElementById("appJogPnlArea");

  // display jog panel tab
  swichJogTabMode();

  if (appJogPnlElm != null) {
    $("#appJogPnlArea").css('top', (returnH + grpTabH - jogTabH) + 'px');

    var appJogPnlStyle = getComputedStyle(appJogPnlElm, null);
    var appJogPnlHeight = Number(appJogPnlStyle.getPropertyValue("height").slice(0, -2));
    var appJogPnlMaxHeight = Number(appJogPnlStyle.getPropertyValue("max-height").slice(0, -2));

    if (appJogPnlHeight < appJogPnlMaxHeight) {
      returnH += appJogPnlHeight;
    } else {
      returnH += appJogPnlMaxHeight;
    }
  }
  return returnH + grpTabH - jogTabH;
}

function swichJogTabMode() {
  // get displayed tabs
  var cnt = Object.keys(P_TABID).length;
  Object.keys(P_TABID).forEach(function (key) {
    if ($(this[key])[0].style.display == 'none') { cnt--; }
  }, P_TABID);

  if (cnt <= 1) {
    if (allGrpNum == 1) {
      $("#jogPnlTab").hide(); // The panel will be smaller.
    } else {
      $("#jogPnlTab").show(); // Leave the jog tab space reserved as another group may use direct teach.
      $(P_TABID[JOG_TAB]).addClass('tab_active_colorless');
    }
    return;
  }
  var innerTabAreaW = (($('#pnlLockBtnJ')[0].style.display == "none") ? '100%' : 'calc(100% - ' + $('#pnlLockBtnJ').outerWidth(true) + 'px)');
  $(P_TABID[JOG_TAB]).removeClass('tab_active_colorless');
  $("#jogPnlTab").show(); // display jog tab area
  $(P_TABID[JOG_TAB]).show(); // display jog tab
  $("#jogPnlTabFlex").css('width', innerTabAreaW); // adjustment flex box
}

// change button color
function swichBtnMode(showObj, btnNum) {
  var btnId = P_BTNID[btnNum];
  var targetObj   = parent.$("#tpkeys").contents().find(btnId);
  var btnIconUrl  = ((showObj) ? "url(keyhide.png)" : "url(keyshow.png)");
  var btnTxtColor = ((!pnlEnb[btnNum]) ? "rgb(105, 105, 105)" : "rgb(255, 255, 255)");
  var btnBGColor  = ((!pnlEnb[btnNum]) ? "rgb(190, 190, 190)" : // Invalid
                    ((showObj) ? "rgb(14, 110, 184)" : "rgb(60, 60, 60)"));

  targetObj.css({ "background": btnBGColor });
  if (btnNum == KEY_PNL) { return;} // No change icon
  targetObj.find('.tpkey_icon').css({ "background-image": btnIconUrl });
  targetObj.find('.tpkey_text').css({ "color": btnTxtColor });

}

// change button active or inactive
function swichActiveMode(active, btnNum) {
  var btnId = P_BTNID[btnNum];
  var pnlBtnId = btnId.replace('#','');
  if (active) {
    top.tpkeys.document.getElementById(pnlBtnId).classList.remove("key_pnl_btn_inactive");
  } else {
    top.tpkeys.document.getElementById(pnlBtnId).classList.add("key_pnl_btn_inactive");
  }
}

// Change the color of all buttons according to settings
function switchAllBtnMode() {
  var showObjArr = [false, false, false];

  showObjArr[PLY_PNL] = (activeBtnId == P_BTNID[PLY_PNL]); // play
  showObjArr[JOG_PNL] = (activeBtnId == P_BTNID[JOG_PNL]); // jog
  showObjArr[KEY_PNL] = top.is_key_open; // keysheet

  for (var i = 0; i < showObjArr.length; i++) {
    swichBtnMode(showObjArr[i], i); // set color
  }
}

// Change the jog panel internal element according to settings
function switchJogPnlElm(tabnum) {
  if (tabnum != LDTR_TAB) setDispLdtrCustMode(false);
  for (var key in P_TABID) {
    if (key != tabnum) {
      $(P_TABCLASS[key]).css('display', 'none');
    }
  }
  $('.tab_active').removeClass('tab_active');
  $(P_TABID[tabnum]).addClass('tab_active');
  $(P_TABCLASS[tabnum]).css('display', 'block');
  $('#overlay_panel_pls').removeClass('disp_overlay_panel_pls');
  setJogPnlClass();

  if (tabnum == PLS_TAB) {
    if (alignExist) pnlSetVar(ALIGNAXS,'gnum', '0');
    $('#scroll_jog').css('min-width', '680px');
    $("#scroll_jog").removeClass("alignPnl");
    $("#scroll_jog").addClass("ovr_pls");
    if (!isDispPls) $('#overlay_panel_pls').addClass('disp_overlay_panel_pls');
  } else if (tabnum == ALIGN_TAB) {
    top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$ALIGN_TYPE', alignPnlSetting, getCurGrp());
    pnlSetVar(ALIGNAXS,'gnum', String(getCurGrp()));
    $('#scroll_jog').css('min-width', '686px');
    $("#scroll_jog").removeClass("ovr_pls");
    $("#scroll_jog").addClass("alignPnl");
  } else {
    if (alignExist) pnlSetVar(ALIGNAXS,'gnum', '0');
    $('#scroll_jog').css('min-width', '650px');
    $("#scroll_jog").removeClass("ovr_pls");
    $("#scroll_jog").removeClass("alignPnl");
  }
  dispPnlJincData();
}

// Change the class of #jogPanel and change the display
function setJogPnlClass() {
  // do not change display for single group
  if (allGrpNum <= 1) { return; }

  var curTab = "#" + $('.tab_active').attr('id');
  var trgtPnl = $('#jogPanel');
  var selTabClass = ((curTab == P_TABID[PLS_TAB]) ? 'p' : (curTab == P_TABID[LDTR_TAB]) ? 'l' : (curTab == P_TABID[ALIGN_TAB]) ? 'a' : 'j');
  var idpAddClass = ((trgtPnl.hasClass('idp_add')) ? ' idp_add' : '');
  var kmdAddClass = ((trgtPnl.hasClass('kmd_add')) ? ' kmd_add' : '');
  trgtPnl.removeClass();
  trgtPnl.addClass(MULTI_GRP_CLASS + ' disp_' + selTabClass + idpAddClass + kmdAddClass);
}

function alignPnlSetting(progName, varName, typeCode, alignType, grpNum) {
  var curAlign = alignType;
  function setAlignTxt (progName, varName, typeCode, alignBoxTxt) {
    if (alignBoxTxt === "\r\n" || alignBoxTxt === "********") {
      $('#alignTxt').text(alignLangRes["3"] + (Number(curAlign) - 2) + ' ' + alignZAxis);
    } else {
      $('#alignTxt').text(top.irprogapi.unescapeHTML(alignBoxTxt) + ' ' + alignZAxis);
    }
  }
  if (curAlign == 'Uninitialized') {
    curAlign = '1';
    pnlSetVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$ALIGN_TYPE', 1);
  }
  if (Number(curAlign) <= 2) {
    setAlignElm(null, null, null, 'TRUE', curAlign);
    $('#alignTxt').text(alignLangRes[curAlign]);
  } else {
    top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + grpNum + '].$P_NAME[' + (Number(curAlign) - 2) + ']', setAlignTxt);
    top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + grpNum + '].$P_RECORDED[' + (Number(curAlign) - 2) + ']', setAlignElm, curAlign);
  }
}

function setAlignElm(progName, varName, typeCode, moveEnb, curAlign) {
  if (moveEnb == 'FALSE' || moveEnb == 'Uninitialized') {
    $('#alignMoveArea').addClass('disabled');
  } else {
    $('#alignMoveArea').removeClass('disabled');
  }
  if (Number(curAlign) <= 2) {
    $('#recPose').addClass('disabled');
  } else {
    $('#recPose').removeClass('disabled');
  }
}

function getAlignPname(callback) {
  var sysnum_xml = '<?xml version="1.0" encoding="UTF-8"?>\r<XMLCFG>\r<PROG name="*SYSTEM*">\r';
  for (var i = 1; i <= 50; i++) {
    sysnum_xml += '<VAR name="$UIALIGNAXS[' + getCurGrp() + '].$P_NAME[' + i + ']" />\r';
  }
  sysnum_xml += '</PROG>\r</XMLCFG>';
  // Create Blob CVR
  var file_cvr = new Blob([sysnum_xml], { type: "text/plain" });
  top.getXHR("align_sel_box.cvr", file_cvr, getAlignSelBoxCB, callback);
}

function getAlignSelBoxCB(status, getText, callback) {
  if (status != top.IO_SUCCESS) {
    console.log("getXHR error");
  } else {
    var strXml = getText;
    var xmlObj = null;
    var domParser = new DOMParser();
    try {
      xmlObj = domParser.parseFromString(strXml, 'text/xml');
    } catch (e) {
      top.irprogapi.inner.apiErrorLog(e);
    }
    if (xmlObj == null) {
        // failure Get XML Data.
        top.IHMIComponents.cf.toast.show(langRes['align_data_err']);
        top.irprogapi.inner.apiErrorLog('getAlignSelBoxCB: xml error.');
    } else {
      if (xmlObj.getElementsByTagName('parsererror').length) {
        // failure Get XML Data.
        top.irprogapi.inner.apiErrorLog('getAlignSelBoxCB: xml error.');
      }
      // Success Get XML Data.
      var xmlVarElem = xmlObj.getElementsByTagName("XMLVAR");
      var varElem = xmlVarElem[0].getElementsByTagName("ARRAY");
      var arryElem = [];
      for (var i = 0; i < varElem.length; i++) {
        arryElem.push(varElem[i].textContent);
      }
      if (typeof(callback) == "function") {
        callback(arryElem);
      }
    }
  }
}

/*
 =========================================================================
 @function name      : switchPnlLock
 @argument[lockmode] : Panel lock mode you want to set (true:enabled / false:disabled)
 @argument[resizeflg]: Whether to resize the iframe
 @description        : Switch panel display mode
 @return             : none
 =========================================================================
*/
function switchPnlLock(lockmode, resizeflg) {
  if (top.is_key_open) { return; }

  var playPnlIcon = $('#pnlLockBtnP');
  var jogPnlIcon = $('#pnlLockBtnJ');
  var pnlBase = $('#pnlarea', parent.document);
  var iconUrl = ((lockmode) ? 'url(lock.png)' : 'url(unlock.png)');
  var pnlSdwCss = (((lockmode) || (activeBtnId == '')) ? '0 0 0 0 #000000' : 'rgba(0, 0, 0, 0.8) 0px -3px 5px 0px');

  top.is_lock_pnl = lockmode;

  playPnlIcon.css('background-image', iconUrl);
  jogPnlIcon.css('background-image', iconUrl);
  pnlBase.css('box-shadow', pnlSdwCss);

  if ((resizeflg) && (typeof top.iframe_size !== 'undefined')) {
    top.iframe_size(); // resize iframe (mainfrm, dummypnlarea)
  }
}

function dispPnlLock(dispmode) {
  var iconDisp = ((dispmode) ? 'block' : 'none');
  $('#pnlLockBtnP').css('display', iconDisp);
  $('#pnlLockBtnJ').css('display', iconDisp);
  swichJogTabMode();
}

// open ldtr panel
function openLdtrPnl() {
  switchJogPnlElm(LDTR_TAB); // change panel element
  reflectTeachWeight(weight_val); // update slider
  settingLdtrPnl(gLdtrState.class); // change ldtr type element
}

// open jog panel and set value
function openJogPnl() {
  // open panel
  setPnlMode(JOG_PNL, true);
  dispPnlJincData();
  // Fold flag ( Will be able to press the jog panel button )
  setGetVarFlg(false);
}

// set panel enable
function setPnlEnb(playEnb, jogEnb, keyEnb) {
  var nextEnb = {};
  nextEnb[PLY_PNL] = ((playEnb == null) ? pnlEnb[PLY_PNL] : playEnb);
  nextEnb[JOG_PNL] = ((jogEnb == null)  ? pnlEnb[JOG_PNL] : (ledMode == WATCHEXEC_RUNNING) ? false : jogEnb);
  nextEnb[KEY_PNL] = ((keyEnb == null)  ? pnlEnb[KEY_PNL] : keyEnb);

  for (var key in pnlEnb) {
    if (pnlEnb[key] != nextEnb[key]) {
      // change color
      pnlEnb[key] = nextEnb[key];
      swichBtnMode(false, key);
    }
  }
}
// get panel enable
function getPnlEnb(pnlNum) {
  return pnlEnb[pnlNum];
}

/*
 =========================================================================
 @function name              : chgCoordDisp
 @argument[disp_coordinate]  :
 @description                : change coordinate display
 @return                     : none
 =========================================================================
*/
var isDispPls = true;
function chgCoordDisp(jogModeInfo, arg) {
  var isCart = false;
  var isJoint = false;
  var isRtheata = false;
  var isExt = (extAxisNum != 0) ? true : false;
  var crntActiveTab = '#' + $('.tab_active').attr('id');
  var isPlsAct = (crntActiveTab == P_TABID[PLS_TAB]) ? true : false;
  var isOnExt = curSubGrp;
  var sel_btn = '';
  var plsBtnList = {
    '.jogjointsel_btn.selBtn': '.plsJ1',
    '.jogcartsel_btn.selBtn': '.plsX',
    '.jogextsel_btn.selBtn': '.plsE1',
  }
  var axis_list = [];
  
  $('#jogmode_box').text(jogModeInfo.label);
  
  switch(jogModeInfo.cur_frm) {
    case "0": // joint
      isJoint = true;
      axis_list = PULSE_AXIS_LIST_JOINT;
      sel_btn = '.jogjointsel_btn.selBtn';
    break;
    case "8": // R-Theata
      isRtheata = true;
      axis_list = PULSE_AXIS_LIST_CART;
      sel_btn = '.jogcartsel_btn.selBtn';
    break;
    default:
      isCart = true;
      axis_list = PULSE_AXIS_LIST_CART;
      sel_btn = '.jogcartsel_btn.selBtn';
    break;
  }

  if (plsExist) {
    if (isExt) {
      axis_list = isOnExt ? PULSE_AXIS_LIST_EXT : axis_list;
      sel_btn = isOnExt ? ".jogextsel_btn.selBtn" : sel_btn;
    }
    // handle not support (jog, leader, path, r-θ, coord, track)
    isDispPls = (jogModeInfo.cur_mltjog != "0" ||
      jogModeInfo.cur_frm == "1" || jogModeInfo.cur_frm == "5" ||
      jogModeInfo.cur_frm == "6" || jogModeInfo.cur_frm == "8") ? false : true;
    // Pulse generator display setting.
    if ($(sel_btn).length != 1) {
      $('.jogjointsel_btn').removeClass('selBtn');
      $('.jogcartsel_btn').removeClass('selBtn');
      $('.jogextsel_btn').removeClass('selBtn');
      $(plsBtnList[sel_btn]).addClass('selBtn');
    }
    var addPoint = (($(sel_btn)[0].children[0].className.indexOf("jog_arrorw_btn") > 0) ? 4 : 1);
    var selectAxisTxt = $(sel_btn)[0].outerText.trim();
    var setAxisVal = axis_list.indexOf(selectAxisTxt) + addPoint;
    setPulseAxis(setAxisVal);
    // Scaling text setting.
    if (jogModeInfo.coord_mask  != 0) {
      var ptnFlg = ((setAxisVal <= 3) ? "FALSE" : "TRUE");
      setScalingText(ptnFlg);
    } else {
      getRotaryAxs(setAxisVal);
    }
  }

  document.getElementById("jogrheatatbl").style.display = isRtheata ? 'block' : 'none';
  $(".jogbtnjointtbl").css("display", isJoint ? 'block' : 'none');
  $(".jogCartTbl").css("display", isCart ? 'block' : 'none');
  document.getElementById("jogexttbl").style.display   = isExt ? 'block' : 'none';
  document.getElementById("jogpulsecarttbl").style.display  = isCart ? 'block' : 'none';
  document.getElementById("jogpulsejointtbl").style.display = isJoint ? 'block' : 'none';
  document.getElementById("jogpulseexttbl").style.display = isExt ? 'block' : 'none';
  if (isPlsAct && !isDispPls) {
    $('#overlay_panel_pls').addClass('disp_overlay_panel_pls');
  } else {
    $('#overlay_panel_pls').removeClass('disp_overlay_panel_pls');
  }
  
}

// Manual pulse generator event
function pulseEvent(e) {
  switch (e.type) {
    case "start":
      gPulseState.startFlg = true;
      befRobotMoveProc();
      return;
    case "stop":
      stopVibrate();
      stopPGCntInterval();
      return;
    case "change":
      if (!gPulseState.startFlg) {
        // Set pulse handle press
        $('#pulse_generator .rs-handle').mousedown();
      }
      return;
    default:
      console.log("default Event : " + e.type);
      return;
  }
}

// <---- before control rendering do this customization ----->
var _hMove = $.fn.roundSlider.prototype._handleMove;
$.fn.roundSlider.prototype._handleMove = function (e) {
  if (gPulseState.centerFlg) return;
  var point = this._getXY(e), center = this._getCenterPoint();
  var distance = this._getDistance(point, center);
  var block = this.block || this.svgContainer;
  var outerDistance = block.outerWidth() / 2;
  var innerDistance = outerDistance - (this.options.width + this._border());
  // Within the rotation stop range.
  if (innerDistance > distance) {
    gPulseState.centerFlg = true;
  }
  // control rendering for move event
  _hMove.call(this, e);
}

// Manual pulse generator event(drag event only)
function pulseDrag(e) {
  if ((!getTPEnb()) || (getAlarmOn())) { return; }
  // For android devices only, the SE playback speed will be constant during high-speed rotation.
  if ((!androidFlg) || (!gPulseState.updateTimer)) { pulseBGM(); }
  startVibrate(VIBRATE_PATTERN);
  var diffVal = e.value - e.preValue;
  if (gPulseState.scaleHalf <= Math.abs(diffVal)) {
    if (diffVal > 0) {
      diffVal = diffVal - gPulseState.scaleMax;
    } else {
      diffVal = diffVal + gPulseState.scaleMax;
    }
  }
  if (gPulseState.PGcnt !== null) {
    gPulseState.PGcnt += diffVal;
    if (gPulseState.PGcnt > 255) {
      gPulseState.PGcnt = gPulseState.PGcnt - 256;
    } else if (gPulseState.PGcnt < 0) {
      gPulseState.PGcnt = gPulseState.PGcnt + 256;
    }
  }
  // Rotate image of pulse generator
  var rotateVal = gPulseState.scaleRotate * diffVal;
  gPulseState.imgRotate += rotateVal;
  if (Math.round(Math.abs(gPulseState.imgRotate)) === 360) {
    gPulseState.imgRotate = 0;
  }
  $("#mpg_img").css('transform', 'rotate(' + gPulseState.imgRotate + 'deg)');
}

// set Pulse select axis value
function setPulseAxis(val) {
  top.rpcmc_setVar(top.SYSNAME_C, '$TAB_MPG.$SEL_AXIS', val);
}
// set Pulse select magnification value
function setPulseMag(val) {
  top.rpcmc_setVar(top.SYSNAME_C, '$TAB_MPG.$SEL_MAG', val);
}

// set pulse generator count for global value
function setPulseCount(prgName, varName, typeCode, pgCnt) {
  gPulseState.PGcnt = parseInt(pgCnt, 10);
  gPulseState.updateCnt = gPulseState.PGcnt;
  startPGCntInterval();
}

// set Pulse generator count value
function setPGCount(val) {
  if (plsExist) {
    setVarWithCallback(top.SYSNAME_C, '$TAB_MPG.$PG_COUNT', val, pgCntStatChk);
  }
}

// Start $PG_COUNT update timer.
function startPGCntInterval() {
  gPulseState.updateTimer = setInterval(function () {
    updatePGCount();
  }, 100);
}

// If the system variable is not being updated, but the counter is being added,
// the system variable will be updated with the value of the counter.
function updatePGCount() {
  if ((gPulseState.updateCnt !== gPulseState.PGcnt) && (!gPulseState.updateFlg)) {
    // For android devices only, the SE playback speed will be constant during high-speed rotation.
    if (androidFlg) { pulseBGM(); }
    gPulseState.updateFlg = true;
    setPGCount(gPulseState.PGcnt);
    gPulseState.updateCnt = gPulseState.PGcnt;
  }
}

// Stop $PG_COUNT update timer.
function stopPGCntInterval() {
  if (gPulseState.updateTimer) clearInterval(gPulseState.updateTimer);
  updatePGCount();
  gPulseState.startFlg = false;
  gPulseState.PGcnt = null;
  gPulseState.updateCnt = null;
  gPulseState.centerFlg = false;
}

// mpgSetVar function callback.
function pgCntStatChk(status, prgName, varName) {
  gPulseState.updateFlg = false;
}

/*
 =========================================================================
 @function name  : change_t_cyc
 @argument       : none
 @description    : T-cyc switching
 @return         : none
 =========================================================================
*/
function change_t_cyc() {
  var appendArg = {
    allGrpNum : allGrpNum
  };
  function tcycPopupCB(){
    $('#t_cyc_btn').css('pointer-events', '');
  }
  $('#t_cyc_btn').css('pointer-events', 'none');
  top.openCmpPupAppendFrm(top.window, "/frh/jcgtp/msgpopup_tcyc.stm", appendArg, null, false, { width: "640px", height: "550px"}, tcycPopupCB);
}

/*
 =========================================================================
 @function name  : change_step_mode
 @argument       : none
 @description    : step mode switching
 @return         : none
 =========================================================================
*/
function change_step_mode() {
  setProgramStepMode(!getProgramStepMode());
  exchStepMode();
}

/*
 =========================================================================
 @function name  : getProgramStepMode
 @argument       : none
 @description    : Step mode flag.
 @return         : StepMode
 =========================================================================
*/
function getProgramStepMode() {
  return programStepMode;
}

function setProgramStepMode(stat) {
  programStepMode = stat;
}

/*
 =========================================================================
 @function name  : getStepModeCB
 @argument[iotype]        : I/O type
 @argument[index]         : I/O index
 @argument[stepstatus]    : I/O status
 @argument[callbackarg1]  : argument for callback function
 @argument[callbackarg2]  : argument for callback function
 @description    : programStepMode flag change.
 @return         : none
 =========================================================================
*/
function getStepModeCB(iotype, index, stepstatus, callbackarg) {
  if (stepstatus == "1") {
    setProgramStepMode(true); // Reflect current settings
  } else {
    setProgramStepMode(false); // Reflect current settings
  }
  // open dialog or initialsetting
  if (callbackarg != undefined) {
    callbackarg();
  }
}

function switchTcycTgl(tcycMode) {
  if (tcycMode){
    $('#t_cyc_btn').removeClass('t_cyc_off');
    $('#t_cyc_btn').addClass('t_cyc_on');
  } else {
    $('#t_cyc_btn').removeClass('t_cyc_on');
    $('#t_cyc_btn').addClass('t_cyc_off');
  }
}

function getCursorPosition(callback) {
  resetSkipObj();
  top.rpcmc_getVar(top.SYSNAME_C, '$SHELL_WRK.$BY_MANUAL', getVarByManualCB);

  function getVarByManualCB(progName, varName, typeCode, valStr) {
    skipObj["byManual"] = JSON.parse(valStr.toLowerCase());
    if (skipObj["byManual"]) {
      top.rpcmc_getVar(top.SYSNAME_C, '$SHELL_WRK.$CURR_LINE', getVarCurrLineCB);
    } else {
      // No cursor position change
      callback();
    }
  }

  function getVarCurrLineCB(progName, varName, typeCode, valStr) {
    skipObj["currLine"]  = Number(valStr);
    top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$TPEDIT_LINE', getVarPauseLineCB);
  }

  function getVarPauseLineCB(progName, varName, typeCode, valStr) {
    skipObj["pauseLine"] = Number(valStr);
    callback();
  }
}

function dispExeCfmPop() {
  if (statMode == WATCHEXEC_PAUSED) {
    getCursorPosition(getCursorPositionCB);
  } else {
    top.openCmpConfirm('irprog', top.window, 'msgpopup_exec', top.irpDlgRes["msgpopup_exec"], {btnData:top.irpDlgBtnYN, btn1Cb:execProgProc});
  }

  function getCursorPositionCB() {
    if (skipObj["byManual"] && skipObj["currLine"] != skipObj["pauseLine"]) {
      // If the cursor position is changed and the number of lines is different.
      execProgProc(); //= display_popupmsg(true, "skipLine");
    } else {
      top.openCmpConfirm('irprog', top.window, 'msgpopup_exec', top.irpDlgRes["msgpopup_exec"], {btnData:top.irpDlgBtnYN, btn1Cb:execProgProc});
    }
  }
}

var NOT_SEL_PRG_POPUP = {
  NO_DISP_MODE: 0,
  VOICE_MODE: 1
}
// get current progname
function get_currentprogname(callback, errPupMode) {
  //File reading
  top.rpcmc_getVar(top.SYSNAME_C, '$TP_DEFPROG', setRecentTopPrg, callback);

  // get current progname callback
  function setRecentTopPrg(first, secound, third, prgname, callback) {
    if (prgname != "") {
      callback(prgname);
    } else {
      initPnlProc();
      if (errPupMode == NOT_SEL_PRG_POPUP.NO_DISP_MODE) {
        // no action
      } else if (errPupMode == NOT_SEL_PRG_POPUP.VOICE_MODE) {
        top.openCmpPupAppendFrm(top.window, top.mainfrm.prim.VOICE_POPUP_URL, { appendArg: 'noprog' });
        top.voiceApi.reqSpeech(top.mainfrm.prim.getSpeechMsg(top.mainfrm.prim.MSG.NOT_SLCT_PRG_POP));
      } else {
        top.openCmpAlert(top.window, 'msgpopup_noprog', top.irpDlgRes["msgpopup_noprog"]);
      }
    }
  }
}

// output console and uncheck dialog checkbox
function setIOSimCB(stat) {
  if (stat != top.IO_SUCCESS) {
    console.log("Failed to set IO.");
    handle_error(stat);
  }
}

function execProgProc() {
  // Check whether to prevent program execution.
  var execPreventions = top.irprogapi.getExecPreventions();
  if (execPreventions.length >= 1) {
    top.openCmpAlert(top.window, execPreventions[0].id, execPreventions[0].msg);
    if (typeof(execPreventions[0].callback) == "function") {
      execPreventions[0].callback(execPreventions[0].cbarg);
    }
    return;
  }
  if (top.getArcTeachFg()) {
    top.openCmpAlert(top.window, 'msgpopup_arcteaching', top.irpDlgRes["msgpopup_arcteaching"]);
    return;
  }
  if (top.getWristTeachFg()) {
    top.openCmpAlert(top.window, 'msgpopup_wristteaching', top.irpDlgRes["msgpopup_wristteaching"]);
    if (top.home.activeTarget.indexOf('-INST_WRIST_BUTTON_TEACH') == -1){
      top.home.icon_activeChk(top.home.g_btnTeaching_list.wristteach.id);
    }
    return;
  }
  if ((typeof top.home.stretchOrder_allOpen === 'function') && (typeof top.home.exec_bracketOpenCheck === 'function') && (top.home.exec_bracketOpenCheck())) {
    // When doing "stretchOrder_allOpen", wait for the icon and the overlay to be drawn beforehand.
    top.irprogapi.putWaitOvl(true, null);
    $('#play_pause').css({ 'pointer-events': 'none' });
    $('#play_abort').css({ 'pointer-events': 'none' });
    $('#play_gototop').css({ 'pointer-events': 'none' });
    chkSingleTask();
    setTimeout(function () {
      top.home.stretchOrder_allOpen();
      $('#play_pause').css({ 'pointer-events': '' });
      $('#play_abort').css({ 'pointer-events': '' });
      $('#play_gototop').css({ 'pointer-events': '' });
      top.irprogapi.rmvWaitOvl();
      switch (exe_btn) {
        case BTN_EXE_MODE:
          get_currentprogname(execution_tpprog);
          break;
        case BTN_BACK_MODE:
          get_currentprogname(exe_back_tpprog);
          break;
        default:
          break;
      }
    }, 50);
  } else {
    chkSingleTask();
    switch (exe_btn) {
      case BTN_EXE_MODE:
        get_currentprogname(execution_tpprog);
        break;
      case BTN_BACK_MODE:
        get_currentprogname(exe_back_tpprog);
        break;
      default:
        break;
    }
  }
}

// for PCEditor Save confirmation. Check modified and display dialog if necessary.
function checkPCEditorModified() {

  // If the dialog has already been displayed, skip the process
  if (top.mainfrm.prim.document.getElementById('confsavedlg') != null) { return true; }

  var astFile = top.mainfrm.prim.getTempProgName(top.mainfrm.prim.getCurrentProgram());
  if ((top.mainfrm.prim.isProgramModified()) ||
      (top.mainfrm.prim.isPositionModified()) || // If modified
      (top.mainfrm.prim.isExistEditProgramFile(astFile))) { // or edit file is exist.

    top.mainfrm.prim.defineDialog.open('#filesave', '#confsavedlg', ''); // Confirm save dialog
    resetStickProc(); // jog release
    return true;

  }
  return false;
}

/*
 =========================================================================
 @function name       : check_exeprog
 @argument[btn_type]  :
 @argument[callback]   :
 @argument[callback2]  :
 @description         : Program execution
 @return              : none
 =========================================================================
*/
var exe_btn = 0;
function check_exeprog(btn_type, callback, callback2) {
  try {
    if ((top.mainfrm.prim.document.location.href.indexOf('pceditor.stm') >= 0) &&
        (checkPCEditorModified())) { // for PCEditor Save confirmation
      return; // do not exec program
    }
  } catch (e) {}
  exe_btn = btn_type;
  callback(callback2);
}

// for button click (cycle start)
function befStartCycleProc(callback) {
  if (getTPEnb()) { return; } // Please TP OFF.

  // Please change auto mode.
  if (moveModeName != MOVE_MODE_AUTO) {
    top.openCmpAlert(top.window, 'msgpopup_startcyclealarm', top.irpDlgRes["msgpopup_startcyclealarm"]);
    return;
  }

  if (getAlarmOn()) { // Please reset alarm.
    top.openCmpAlert(top.window, 'msgpopup_alarm', top.irpDlgRes["msgpopup_alarm"]);
    return;
  }
  // Manipulate the overlay
  chkSingleTask();
  top.rpcmc_getVar(top.SYSNAME_C, '$REMOTE_CFG.$LOCAL_OPTYP', getLocalOptypCB, callback);
}

// for slide play jog (shiftFWD)
function befExecProgProc(callback) {
  if (!getTPEnb()) { return; } // Please TP ON.

  if (getAlarmOn()) { // Please reset alarm.
    top.openCmpAlert(top.window, 'msgpopup_alarm', top.irpDlgRes["msgpopup_alarm"]);
    return;
  }
  // Manipulate the overlay
  chkSingleTask();

  // If CRXO is not ordered or is not TP-based connection
  if ((!top.g_crx) || (!top.g_tabtp) || !getLdtrEnbLocal()||
      ((enblSWObj["L"] == 1) && (enblSWObj["R"] == 1))) {
    callback();
  } else {
    bfWaitRelEnbSW();
  }
}

// for button click (cycle start)
function getLocalOptypCB(progName, varName, typeCode, valStr, callback) {
  if (Number(valStr) == 0) { // Please change remote mode.
    top.openCmpConfirm('irprog', top.window, 'msgpopup_r_optyp', top.irpDlgRes["msgpopup_r_optyp"], {btnData:{btn1:top.irpDlgBtnOC.btn1}});
    return;
  }
  top.rpcmc_getVar(top.SYSNAME_C, '$REMOTE_CFG.$REMOTE_TYPE', getRemoteTypeCallback, callback);
}

// for button click (cycle start)
function getRemoteTypeCallback(progName, varName, typeCode, remoteType, callback) {
  if (curSI2 == 1 && Number(remoteType) == REMOTE_MODE) {
    // Please change local mode.
    top.openCmpConfirm('irprog', top.window, 'msgpopup_remotealarm', top.irpDlgRes["msgpopup_remotealarm"], {btnData:{btn1:top.irpDlgBtnOC.btn1}});
    return;
  } else if (curSI2 == 1 && Number(remoteType) == EXTERNAL_IO_MODE) {
    // Please change External I/O for Remote / Local to OFF(Local).
    top.openCmpConfirm('irprog', top.window, 'msgpopup_externalIOalarm', top.irpDlgRes["msgpopup_externalIOalarm"], {btnData:{btn1:top.irpDlgBtnOC.btn1}});
    return;
  } else {
    // If CRXO is not ordered or is not TP-based connection
    if ((!top.g_crx) || (!top.g_tabtp) || !getLdtrEnbLocal() ||
    ((enblSWObj["L"] == 1) && (enblSWObj["R"] == 1))) {
      callback();
    } else {
      bfWaitRelEnbSW();
    }
  }
}

function bfWaitRelEnbSW() {
  // Returns the elements manipulated at runtime to the initial state
  initPnlProc();

  // display popup and set timer
  top.openCmpAlert(top.window, 'msgpopup_waitRelSW', top.irpDlgRes["msgpopup_waitRelSW"]);
  waitRelEnbSW();
}

function waitRelEnbSW() {
  if ((enblSWObj["L"] == 0) || (enblSWObj["R"] == 0)) {
    setTimeout(function () { waitRelEnbSW(); }, 500);
    return; // Repeat until enable key is released
  }

  // close popup (Do not execute as it is)
  display_popupmsg(false, "");
}

function getEnblSwValCB(iotype, index, status) {
  if (index == 247) {
    enblSWObj["L"] = Number(status);
  } else if (index == 248) {
    enblSWObj["R"] = Number(status);
  }
}

/*
 =========================================================================
 @function name  : shiftFWD
 @argument       : none
 @description    : Start Program(SHIFT+FOWARD)
 @return         : none
 =========================================================================
*/
function shiftFWD() {
  if (!doRelShift) return;
  clearTimeout(g_safetyTimer);
  setPnlEnb(null, false, null);
  top.sendKey("R-shift", 1);
  top.sendKey("FWD", 1);
  top.sendKey("FWD", 0);
  setTimeout(function () {
    top.rpcmc_iovalrd(top.tpout_type_c, 5, checkExecstatus, 0, 0);
  }, 200);
}

function backFWD() {
  clearTimeout(g_safetyTimer);
  setPnlEnb(null, false, null);
  top.sendKey("R-shift", 1);
  top.sendKey("BWD", 1);
  top.sendKey("BWD", 0);
  setTimeout(function () {
    top.rpcmc_iovalrd(top.tpout_type_c, 5, checkExecstatus, 0, 0);
  }, 200);
}

// If the execution completes instantly, the status does not change, so do this instead.
function checkExecstatus(type, mode, status) {
  if (status == 0) {
    doRelShift = false;
    sendShiftFlg = false;
    sendShiftKey(0);
    resetJogStick(targetStickId);
    setPnlEnb(null, true, null);
    restrictPlayPnl(false);
  }
}

function holdProgram() {
  top.sendKey("Hold", 1);
  top.sendKey("Hold", 0);
  befSendShiftRel();
  if (statMode == WATCHEXEC_RUNNING) {
    statMode = WATCHEXEC_PAUSED;
  }
}

/*
 =========================================================================
 @function name  : abortCallback
 @argument       : none
 @description    : callback function
 @return         : none
 =========================================================================
*/
function abortCallback() {
  statMode = WATCHEXEC_ABORTED;
}

/*
 =========================================================================
 @function name  : exchStepMode
 @argument       : none
 @description    : Change Step Mode
 @return         : none
 =========================================================================
*/
function exchStepMode() {
  top.sendKey('Step', 1);
  top.sendKey('Step', 0);
}

/*
 =========================================================================
 @function name       : abort_tpprog
 @argument[isGototop] : true or false
 @description         : Stop all tasks. If isGototop is true, return the program to line 1.
 @return              : none
 =========================================================================
*/
function abort_tpprog(isGototop) {
  function getChkAbortCB(io_type, io_index, typeStr, cbArg, chk_status) {
    if ((chk_status != top.IO_SUCCESS) || (typeStr == 'FALSE')) {
      abortAllTask();
    } else {
      top.openCmpConfirm('irprog', top.window, 'msgpopup_abort', top.irpDlgRes["msgpopup_abort"], {btnData:top.irpDlgBtnYN, btn1Cb:abortAllTask}, true);
    }
  }
  function abortAllTask() {
    abortProgram('*ALL*', abortCallback);

    // Return the program to line 1.
    if (isGototop) get_currentprogname(chgProg);
  }
  top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$CHK_ABORTAL', getChkAbortCB, null);
}

/*
 =========================================================================
 @function name  : pause_tpprog
 @argument       : none
 @description    : Program pause
 @return         : none
 =========================================================================
*/
function pause_tpprog(progname) {
  if (statMode == WATCHEXEC_RUNNING || ledMode == WATCHEXEC_RUNNING) {
    if ((moveModeName == MOVE_MODE_AUTO) && (!getTPEnb())) {
      pauseCycle();
    } else {
      sendShiftKey(0);
    }
    statMode = WATCHEXEC_PAUSED;
  }
}
/*
 =========================================================================
 @function name  : execution_tpprog
 @argument       : none
 @description    : TP program runtime processing
 @return         : none
 =========================================================================
*/
function execution_tpprog(prgname) {

  if ((moveModeName == MOVE_MODE_AUTO) && (!getTPEnb())) { // TP invalid
    beforeExecProc(prgname, startCycle, true);
  } else if (doRelShift) {
    // Don't execute if shift release is preceded by a short tap
    beforeExecProc(prgname, shiftFWD, false);
  }
}

// Determining whether to change the paused line
function beforeExecProc(tpdefprg, callback, cycle) {
  if (statMode == WATCHEXEC_PAUSED) {
    var timelineprg = "";
    if (cycle) {
      if (skipObj["currLine"] != skipObj["pauseLine"]) {
        top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$TPEDIT_PROG', getVarTimeLinePrgCB);
      } else {
        callback(); // startCycle()
      }
    } else {
      getCursorPosition(getCursorPositionCB);
    }
  } else {
    callback(); // startCycle() or shiftFWD() or backFWD()
  }

  function getCursorPositionCB() {
    if (skipObj["byManual"] && skipObj["currLine"] != skipObj["pauseLine"]) {
      // If the cursor position is changed and the number of lines is different.
      top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$TPEDIT_PROG', getVarTimeLinePrgCB);
    } else {
      callback(); // shiftFWD() or backFWD()
    }
  }

  function getVarTimeLinePrgCB(progName, varName, typeCode, valStr) {
    timelineprg = valStr;
    top.openCmpConfirm('irprog', top.window, 'msgpopup_skipLine', top.irpDlgRes["msgpopup_skipLine"],
    {btnData:top.irpDlgBtnYN, btn1Cb:callSkipLine, btn2Cb:callSkipLine, closeBtnCb:callSkipLine});
    if (!cycle) {
      resetStickProc();
    }
  }

  function callSkipLine(dlgBtnId) {
    if(dlgBtnId == 'btn1') {
      skipLine(tpdefprg, timelineprg, skipObj["currLine"], resetSkipObj);
    } else {
      setLine(timelineprg, skipObj["pauseLine"], resetSkipObj);
    }
  }
}

// change the paused line
// If running sub program, It works even if task_name is set to main program name.
// task_name:TP_DEFPROG, prog_name:Program name displayed on the timeline
function skipLine(task_name, prog_name, line_num, callback) {
  $.getJSON("/COMET/rpc?func=SKIP_LINE&task_name=" + top.encodeASCII(task_name) + "&prog_name=" + top.encodeASCII(prog_name) + "&line_num=" + line_num, function (json) {
    if (json.FANUC.RPC != undefined) {
      json.FANUC.RPC[0].status = json.FANUC.RPC[0].status.toLowerCase();
      if (json.FANUC.RPC[0].status != top.IO_SUCCESS) {
        top.rpcmc_rprintf("stopProgram error status");
        handle_error(json.FANUC.RPC[0].status);
      }
      if (callback != undefined) {
        callback(json.FANUC.RPC[0].status, task_name);
      }
    } else {
      top.rpcmc_rprintf("[rpcmc] unexpected reply " + JSON.stringify(json));
    }
  }).fail(function (xhr, textStatus, errorThrown) {
    putIFFailLog(xhr, textStatus, errorThrown);
  });
}

function resetSkipObj(status, cbarg) {
  if (cbarg != undefined) {
    // callback for setLine or skipLine 
    top.rpcmc_setVar(top.SYSNAME_C, '$SHELL_WRK.$BY_MANUAL', 0);
  }
  skipObj["byManual"] = false;
  skipObj["currLine"] = 0;
  skipObj["pauseLine"] = 0;
}

/*
 * Cycle Start to [Start]
 * (IN) callback : A callback function to receive status.
 *                 If no need, set to null..
 */
function startCycle() {
  setLocalStart(setLocalStartCallback);
  setTimeout(function () {
    top.rpcmc_iovalrd(top.tpout_type_c, 5, checkExecstatus, 0, 0);
  }, 300);
}
// Callback function to receive start status.
function setLocalStartCallback(status) {
  if (status != top.IO_SUCCESS) {
    restrictPlayPnl(false);
  }
}
// pause to cycle
function pauseCycle() {
  top.sendKey("Hold", 1);
  setTimeout(function () { // add timeout
    top.sendKey("Hold", 0);
  }, 500);
}

/**
 * Local Start/Stop Controll.
 * Start value from 1 to 0
 * (IN) value : 1=Button On, 0=Status Off.
 * (IN) callback : A callback function to receive the return status.
 */
function setLocalStart(callback) {
  $.getJSON("/COMET/rpc?func=LOCAL_START&connect_id=" + top.g_connect_id,
    function (json) {
      if (json.FANUC.RPC != undefined) {
        if (json.FANUC.RPC[0].status != 0) {
          top.rpcmc_rprintf("LOCAL_START error status:" + json.FANUC.RPC[0].status);
        }
        if (callback != undefined) {
          callback(json.FANUC.RPC[0].status);
        }
      }
    });
}

/*
 =========================================================================
 @function name  : exe_back_tpprog
 @argument       : none
 @description    : Program reverse playback
 @return         : none
 =========================================================================
*/
function exe_back_tpprog(prgname) {
  if (doRelShift) {
    beforeExecProc(prgname, backFWD, false);
  }
}

/*
 =========================================================================
 @function name     : display_popupmsg
 @argument[showDisp]:
 @argument[dispId]  :
 @description       : Pop-up message display
 @return            :
 =========================================================================
*/
function display_popupmsg(showDisp, dispId) {

  if (!showDisp) {
    var fadeOutMsg = (dispId.startsWith('_') ? dispId : g_called_popupmsg);
    top.$('#msgpopup' + fadeOutMsg).fadeOut("fast");
    top.$('#screenoverlay-dialog').hide();
    top.$('#screenoverlay-dialog').remove();
    return;
  }
  top.openIrprogDialog('#msgpopup' + dispId);
  g_called_popupmsg = dispId;
  restrictPlayPnl(false);
}

//=============================================================================
// override
//=============================================================================

$(function () {
  $("#slider, #slider2").slider({
    range: "min",
    min: 0,
    max: 130,
    step: 5,
    value: 35,
    slide: function (event, ui) {
      if (event.handleObj === undefined) { return false; }
      var old_val = "";
      if ((touchSlideKnob == event.target.id) &&
        (event.handleObj.origType == "mousemove")) {
          if(isJincDisp && (ui.value === 0 || ui.value === 5 || ui.value === 10)) {
            event.preventDefault();
            $("#slider, #slider2").slider("value", 15); // 15 = override 1%
            return;
          } else {
            if (ui.value === 0) {
              event.preventDefault();
              $("#slider, #slider2").slider("value", 5); // 5 = override VFINE
              return;
            }
          }
        old_val = ovr_val;
        ovr_val = ui.value;
      } else if ((touchSlideKnob != event.target.id) &&
        (event.handleObj.origType == "mousedown")) {
        if (ovr_val <= ui.value) {
          var curOvrTxtVal = parseInt($("#slider_val").html());
          if ((curOvrTxtVal > 5) && (curOvrTxtVal % 5 != 0)) {
            var sliderVal = getSliderOvVal(curOvrTxtVal);
            var override_text = override_change(sliderVal, sliderVal - 5);
            $("#slider_val, #slider2_val").html(override_text + "%");
          } else {
            var ovLim = 0;
            if (getTPEnb()) {
              ovLim = getSliderOvVal(jogOvLim);
            }
            if ((moveModeName == MOVE_MODE_T2) && (enblSWObj["L"] == 1) && (enblSWObj["R"] == 1)) {
              ovLim = getSliderOvVal(ovLimT2);
            }
            if (ovr_val + 5 > ovLim && ovLim > 0) {
              $("#slider, #slider2").slider("value", ovLim);
            } else {
              var nextOvrNum = (ovr_val === 0 && isJincDisp) ? 15 : ovr_val + 5; // 15 = override 1%
              $("#slider, #slider2").slider("value", nextOvrNum);
            }
          }
        } else {
          if ((ui.value === 0 && ovr_val <= 5) || (isJincDisp && ovr_val <= 15)) {
            event.preventDefault();
            return;
          }
          $("#slider, #slider2").slider("value", ovr_val - 5);
        }
        return false;
      } else if ((touchSlideKnob != event.target.id) &&
        (event.handleObj.origType == "mousemove")) {
        return false;
      }
      var override_text = override_change(ovr_val, old_val);
      if (ovr_val === 5 || ovr_val === 10) {
        $("#slider_val, #slider2_val").html(override_text);
      } else {
        $("#slider_val, #slider2_val").html(override_text + "%");
      }
      //Changing the slider value
      $("#slider, #slider2").slider("value", ovr_val);
      return false;
    },
    create: function (event, ui) {
      $("#slider_val, #slider2_val").html($(this).slider("value") - 30 + "%");
    },
    change: function (event, ui) {
      if (ui.value != ovr_val) {
        var override_text = override_change(ui.value, ovr_val);
        if (ui.value > 10) {
          $("#slider_val, #slider2_val").html(override_text + "%");
        } else if (ui.value === 5 || ui.value === 10) {
          if(!isJincDisp) {
            $("#slider_val, #slider2_val").html(override_text);
          }
        } else {
          $("#slider_val, #slider2_val").html(override_text + "%");
        }
        ovr_val = ui.value;
      }
    },
    stop: function (event, ui) {
      var ovLim = 0;
      if (getTPEnb() && (ui.value > getSliderOvVal(jogOvLim))) {
        ovLim = getSliderOvVal(jogOvLim);
      }
      if ((moveModeName == MOVE_MODE_T2) && (enblSWObj["L"] == 1) && (enblSWObj["R"] == 1) && (ui.value > getSliderOvVal(ovLimT2)) && (ovLim > getSliderOvVal(ovLimT2))) {
        ovLim = getSliderOvVal(ovLimT2);
      }
      if (ovLim > 0) {
        $("#slider, #slider2").slider("value", ovLim);
      } else if (ui.value != ovr_val) {
        var override_text = override_change(ui.value, ovr_val);
        if (ui.value > 10) {
          $("#slider_val, #slider2_val").html(override_text + "%");
        } else if (ui.value === 5 || ui.value === 10) {
          $("#slider_val, #slider2_val").html(override_text);
        } else {
          $("#slider_val, #slider2_val").html(override_text + "%");
        }
        ovr_val = ui.value;
      } else {
        chgOvrdCB(null, null, getDispOvrVal(ui.value));
      }
      touchSlideKnob = "";
    },

  });
  $('.ui-slider-handle').on('mousedown touchstart', function (event) {
    event.preventDefault();
    touchSlideKnob = event.target.offsetParent.id;
  });

});

function getOverridezeroCB(prgName, varName, typeCode, zero, getValObj, arg2) {

  if (curOvrVal != ovr_val) {
    runningOvrUpdate = true;
    return;
  }

  var override_text = getValObj["OVR"] + "%";
  var next_val = 0;
  var zeroBtnCls = 'disable_ovr_zero';
  getValObj["ZERO"] = zero;
  switch (getValObj["OVR"]) {
    case "1":
      if(getValObj["ZERO"] === "TRUE"){
        override_text = "0%";
        zeroBtnCls = 'active_ovr_zero';
      } else if (getValObj["VFINE"] === "TRUE") {
        next_val = 5;
        override_text = langRes.lightrobot_speedvfine_c;
        zeroBtnCls = 'enable_ovr_zero';
      } else if (getValObj["FINE"] === "TRUE") {
        next_val = 10;
        override_text = langRes.lightrobot_speedfine_c;
      } else {
        if (isJincDisp) zeroBtnCls = 'enable_ovr_zero';
        next_val = 15;
      }
      break;
    case "2":
      next_val = 20;
      break;
    case "3":
      next_val = 25;
      break;
    case "4":
      next_val = 30;
      break;
    default:
      next_val = (parseInt(getValObj["OVR"]) + 30);
      if (next_val % 5 != 0) { next_val = (Math.ceil(next_val / 5) * 5); }
      override_text = getValObj["OVR"] + "%";
      break;
  }
  setZeroBtnCls(zeroBtnCls);

  // Set the position of the slider.
  if (next_val != ovr_val) {
    ovr_val = next_val;
    $("#slider, #slider2").slider("value", ovr_val);
  }
  $("#slider_val, #slider2_val").html(override_text);

  runningOvrUpdate = true;
}

function dispZeroBtn(isDisp){
  if (isDisp) {
    $('#ovr_zero').css('display', '');
  } else {
    $('#ovr_zero').css('display', 'none');
  }
}

function setZeroBtnCls(clsName){
  $('#ovr_zero').removeClass('enable_ovr_zero active_ovr_zero disable_ovr_zero');
  $('#ovr_zero').addClass(clsName);
}

function ovr_plus() {
  var curOvrTxtVal = parseInt($("#slider_val").html());
  if ((curOvrTxtVal > 5) && (curOvrTxtVal % 5 != 0)) {
    var sliderVal = getSliderOvVal(curOvrTxtVal);
    var override_text = override_change(sliderVal, sliderVal - 5);
    $("#slider_val, #slider2_val").html(override_text + "%");
  } else {
    var ovLim = 0;
    if (getTPEnb()) {
      ovLim = getSliderOvVal(jogOvLim);
    }
    if ((moveModeName == MOVE_MODE_T2) && (enblSWObj["L"] == 1) && (enblSWObj["R"] == 1)) {
      ovLim = getSliderOvVal(ovLimT2);
    }
    if (ovr_val + 5 > ovLim && ovLim > 0) {
      $("#slider, #slider2").slider("value", ovLim);
    } else {
      var nextOvrNum = (ovr_val === 0 && isJincDisp) ? 15 : ovr_val + 5; // 15 = override 1%
      $("#slider, #slider2").slider("value", nextOvrNum);
    }
  }
}

function ovr_minus() {
  var slideMin = isJincDisp ? 15 : 5;
  if ($('#ovr_zero').hasClass('disable_ovr_zero') && (ovr_val > slideMin)) {
    $("#slider, #slider2").slider("value", ovr_val - 5);
  }
}

var OVR_25_SEP = [5, 10, 15, 55, 80, 105, 130];

function ovr_plus25() {
  for (var i = 0; i < OVR_25_SEP.length; i ++) {
    if (ovr_val < OVR_25_SEP[i]) {
      var ovLim = OVR_25_SEP[OVR_25_SEP.length - 1];
      if (getTPEnb()) {
        ovLim = getSliderOvVal(jogOvLim);
      }
      if ((moveModeName == MOVE_MODE_T2) && (enblSWObj["L"] == 1) && (enblSWObj["R"] == 1)) {
        ovLim = getSliderOvVal(ovLimT2);
      }
      if (OVR_25_SEP[i] > ovLim) {
        $("#slider, #slider2").slider("value", ovLim);
      } else {
        var nextOvrNum = (ovr_val === 0 && isJincDisp) ? 15 : OVR_25_SEP[i]; // 15 = override 1%
        $("#slider, #slider2").slider("value", nextOvrNum);
      }
      break;
    }
  }
}

function ovr_minus25() {
  var slideMin = isJincDisp ? 15 : 5;
  if ($('#ovr_zero').hasClass('disable_ovr_zero') && (ovr_val > slideMin)) {
    for (var i = OVR_25_SEP.length - 1; i >= 0; i --) {
      if (ovr_val > OVR_25_SEP[i]) {
        $("#slider, #slider2").slider("value", OVR_25_SEP[i]);
        break;
      }
    }
  }
}

function ovr_zero() {
  $('#ovr_zero').css('pointer-events', 'none');
  setTimeout(function () { $('#ovr_zero').css('pointer-events', ''); }, 500);
  if ($('#ovr_zero').hasClass('enable_ovr_zero')) {
    top.sendKey("-OVR", 1);
    top.sendKey("-OVR", 0);
    $("#slider_val, #slider2_val").html("0%");
  } else if ($('#ovr_zero').hasClass('active_ovr_zero')) {
    top.sendKey("+OVR", 1);
    top.sendKey("+OVR", 0);
    if(!isJincDisp) {
      $("#slider_val, #slider2_val").html(langRes.lightrobot_speedvfine_c);
    }
  } else {
    var msg = top.irpDlgRes["msgpopup_disablezero"];
    if(isJincDisp) {
      msg = top.irpDlgRes["msgpopup_disablezero2"];
    }
    top.openCmpAlert(top.window, 'msgpopup_disablezero', msg);
  }
}

function getVFineConditionCB(prgName, varName, typeCode, vfine, getValObj, arg2){
  getValObj["VFINE"] = vfine;
  top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$OVR_ZERO', getOverridezeroCB, getValObj, null);
}

function getFineConditionCB(prgName, varName, typeCode, fine, getValObj, arg2) {
  getValObj["FINE"] = fine;
  top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$JOG_V_FINE', getVFineConditionCB, getValObj, null);
}

function getOverrideCallback(prgName, varName, typeCode, ovrStr, arg1, arg2) {
  var getValOvj = {"OVR": 0, "FINE" : 0, "VFINE" : 0, "ZERO": 0};
  getValOvj["OVR"] = ovrStr;
  top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$JOG_FINE', getFineConditionCB, getValOvj, null);
}

function override_change(value, old_val) {
  var override_text = "";
  var override_val = "";
  var zeroBtnCls = 'disable_ovr_zero';

  // if override value 'fine' or 'vfine', set the override to 1%
  // (only if isLdtr is true)
  switch (value) {
    case 0:
      override_text = 0;
      override_val = -2;
      zeroBtnCls = 'active_ovr_zero';
      break;
    case 5:
      override_text = langRes.lightrobot_speedvfine_c;
      override_val = -1;
      zeroBtnCls = 'enable_ovr_zero';
      break;
    case 10:
      override_text = langRes.lightrobot_speedfine_c;
      override_val = 0;
      break;
    case 15:
      override_text = 1;
      if (isJincDisp) zeroBtnCls = 'enable_ovr_zero';
      break;
    case 20:
      override_text = 2;
      break;
    case 25:
      override_text = 3;
      break;
    case 30:
      override_text = 4;
      break;
    case getSliderOvVal(jogOvLim):
      override_text = ((getTPEnb()) ? jogOvLim : (value - 30));
      break;
    default:
      override_text = (value - 30);
      break;
  }
  if ((moveModeName == MOVE_MODE_T2) && (enblSWObj["L"] == 1) && (enblSWObj["R"] == 1) && (override_text > ovLimT2)) {
    override_text = ovLimT2;
  }
  if (override_val === ""){
    override_val = override_text;
  }
  setZeroBtnCls(zeroBtnCls);
  if (touchSlideKnob == "" || old_val === 0) {
    clearSendTimer();
    sendOvrVal(override_val, old_val);
  } else {
    setSendTimer(override_val, old_val);
  }
  return override_text;
}

// timer for send override value
function setSendTimer(override_val, old_val) {
  clearSendTimer();
  gtimerKeepData = setTimeout(function () { sendOvrVal(override_val, old_val); }, SEND_OVRVAL_INTERVAL);
}

// clear timer
function clearSendTimer() {
  clearTimeout(gtimerKeepData);
  gtimerKeepData = null;
}

// send override value
function sendOvrVal(override_val, old_val) {
  var ovrVal = override_val;
  if (getTPEnb() && (ovrVal > jogOvLim)) {
    ovrVal = jogOvLim;
    $("#slider_val, #slider2_val").html(ovrVal);
    $("#slider, #slider2").slider("value", getSliderOvVal(ovrVal));
  }
  if ((moveModeName == MOVE_MODE_T2) && (enblSWObj["L"] == 1) && (enblSWObj["R"] == 1) && (ovrVal > ovLimT2)) {
    ovrVal = ovLimT2;
    $("#slider_val, #slider2_val").html(ovrVal);
    $("#slider, #slider2").slider("value", getSliderOvVal(ovrVal));
  }
  if (old_val !== 0){
    chgOvrd(ovrVal, chgOvrdCB, null);
  } else {
    top.sendKey("+OVR", 1);
    top.sendKey("+OVR", 0);
    chgOvrd(ovrVal, chgOvrdCB, null);
  }
  clearSendTimer();
}

function chgOvrdCB(status, rpc, ovrd_val) {
  setTimeout(function () {
    top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', getOvrCB, ovrd_val);
  }, 200);

}

function getOvrCB(prgName, varName, typeCode, ovrStr, sendOvrVal) {
  if (Number(ovrStr) == sendOvrVal) return;
  // update override value
  if ((runningOvrUpdate) && (touchSlideKnob == "")) {
    getOvrVal();
  } else {
    setGetOvrTimer();
  }
}

//=============================================================================
// Incremental Jog
//=============================================================================
var JINC_VAR = {
  JOG_INCE: '$JINC.$JOG_INCRE',
  TRANS: '$JINC.$INCRE_TRANS',
  JOINT: '$JINC.$INCRE_JNT'
};

function stopJincMonitor() {
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, JINC_VAR.JOG_INCE, 100);
  for (var i = 1; i <= 4; i++) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, JINC_VAR.TRANS + '[' + i + ']', 100);
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, JINC_VAR.JOINT + '[' + i + ']', 100);
  }
}
function startJincMonitor() {
  // "UI_CFG.DBG_TAB" means that the system variable "$IRPROG_CFG.$TABLET_UI" is "1".
  if (top.getUICfg() == top.UI_CFG.DBG_TAB) top.rpcmc_getVar(top.SYSNAME_C, JINC_VAR.JOG_INCE, getJogIncreCB);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, JINC_VAR.JOG_INCE, 100);
  for (var i = 1; i <= 4; i++) {
    top.rpcmc_startVarMonitor(top.SYSNAME_C, JINC_VAR.TRANS + '[' + i + ']', 100);
    top.rpcmc_startVarMonitor(top.SYSNAME_C, JINC_VAR.JOINT + '[' + i + ']', 100);
  }
}
function getPnlJincEnbCB(prog_name, var_name, type_code, str) {
  stopJincMonitor();
  if (str == "TRUE") {
    isJincDisp = true;
    $(".jinc_val").removeClass("jinc_undisp");
    startJincMonitor();
  }
}

function getJogIncreCB(progName, varName, typeCode, str) {
  pnlJincData.num = Number(str);
}

var pnlJincData = {
  num: undefined,
  trans: [0.000, 0.000, 0.000, 0.000],
  joint: [0.000, 0.000, 0.000, 0.000]
};

function getPnlJincCB(varName, value) {
  var transLen = pnlJincData.trans.length;
  var jointLen = pnlJincData.joint.length;
  var tagNum = "";
  if (varName === JINC_VAR.JOG_INCE) {
    pnlJincData.num = Number(value);
  } else if (varName.indexOf(JINC_VAR.TRANS) >= 0) {
    // '$JINC.$INCRE_TRANS'
    tagNum = Number(varName.match(/\[(.+)\]/)[1]) - 1;
    pnlJincData.trans[tagNum] = Number(value);
  } else if (varName.indexOf(JINC_VAR.JOINT) >= 0) {
    // '$JINC.$INCRE_JNT'
    tagNum = Number(varName.match(/\[(.+)\]/)[1]) - 1;
    pnlJincData.joint[tagNum] = Number(value);
  }

  if ((0 < pnlJincData.trans[transLen - 1]) && (0 < pnlJincData.joint[jointLen - 1])) {
    dispPnlJincData();
  }
}

function dispPnlJincData() {
  var jincText = tabtpJincStrPnl["continuous"];
  $('.jincBtnTxt').css({'font-size': '', 'padding-right': ''});
  var crntActiveTab = '#' + $('.tab_active').attr('id');
  var crntActiveBtn = '#' + $('.btn_active').attr('id');

  if (pnlJincData.num != 0) {
    if ((1 <= pnlJincData.num) && (pnlJincData.num <= pnlJincData.trans.length)) {
      var selNum = pnlJincData.num - 1;
      jincText = pnlJincData.trans[selNum] + 'mm<br>' + pnlJincData.joint[selNum] + 'deg';
      if (crntActiveTab == P_TABID[PLS_TAB] || (crntActiveTab == P_TABID[LDTR_TAB] && crntActiveBtn == L_BTNID[LDTR_MODE_C])) {
        $('.jincBtnTxt').css('padding-right', '0px');
      }
    } else {
      jincText = 'mm<br>deg';
    }
  } else {
    // Set "continuous" text position.
    var fontSize = adjustTextFontSize(jincText, 17, 77);
    $('.jincBtnTxt').css('font-size', fontSize);
    if (crntActiveTab == P_TABID[PLS_TAB] || (crntActiveTab == P_TABID[LDTR_TAB] && crntActiveBtn == L_BTNID[LDTR_MODE_C])) {
      // 'padding-right: 0px;' is only required if text is omitted.
      var crntRangeFontSize = adjustTextFontSize(jincText, 17, $('.jinc_val').width());
      if (fontSize != crntRangeFontSize) $('.jincBtnTxt').css('padding-right', '0px');
    }
  }
  $('.jincBtnTxt').html(jincText);
}

function setJincBtnEvent() {
  $('.jinc_val').on('click', function (event) {
    $('.jinc_val').css('pointer-events', 'none');
    top.openCmpPupAppendFrm(top.window, "/frh/jcgtp/selectjincdlg.stm", pnlJincData, tabtpJincStrPnl["tittle"], false, { width: "600px", height: "530px"}, jincDlgCB);
  });
}

function jincDlgCB() {
  $('.jinc_val').css('pointer-events', '');
}

function setJincNo(no) {
  if (no == null) return;
  var slctNo = Number(no);
  if (pnlJincData.num != slctNo) {
    top.rpcmc_setVar(top.SYSNAME_C, '$JINC.$JOG_INCRE', slctNo);
  }
}

/** Debug function **/
var DBGFATAL = 1;
var DBGERROR = 2;
var DBGWARN = 3;
var DBGINFO = 4;
var DBGDUMP = 5;
var debugLevel = DBGERROR; // Debug level.
var debugDateOn = true; // Datetime add to message
var levelHead = ['', 'FATAL', 'ERROR', 'WARN ', 'INFO ', 'DUMP '];

/*
 =========================================================================
 @function name      : debug
 @argument[level]    : level
 @argument[message]  : message
 @description        : debug function.
 @return             : none
 =========================================================================
*/
function debug(level, message) {
  if (level <= debugLevel) {
    var dbgDttm = (debugDateOn) ? formatDateTime() : '';
    var dbgmsg = levelHead[level] + ':' + message;
    console.log(dbgDttm + dbgmsg);
  }
}
/*
 =========================================================================
 @function name  : formatDateTime
 @argument       : none
 @description    : format DateTime
 @return         : format DateTime
 =========================================================================
*/
function formatDateTime() {
  var dtObj = new Date();
  var yStr = dtObj.getFullYear();
  var mStr = ('00' + (dtObj.getMonth() + 1)).slice(-2);
  var dStr = ('00' + dtObj.getDate()).slice(-2);
  var hStr = ('00' + dtObj.getHours()).slice(-2);
  var nStr = ('00' + dtObj.getMinutes()).slice(-2);
  var sStr = ('00' + dtObj.getSeconds()).slice(-2);
  var fmtStr = '[' + yStr + '/' + mStr + '/' + dStr + ' ' +
    hStr + ':' + nStr + ':' + sStr + ']';
  return fmtStr;
}

// monitor
function unloadPanelArea() {
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR.$JOG_GP', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$GENOVERRIDE', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$JOG_FINE', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$JOG_V_FINE', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR.$OVR_ZERO', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$SCR.$PRC_DSP[7]', 20);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_LABEL', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_SUBGRP', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MNUTOOLNUM[' + getCurGrp() + ']', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MNUFRAMENUM[' + getCurGrp() + ']', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$PLST_PARNUM[' + getCurGrp() + ']', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_ENBL', 100);
  fintCust();
  stopLdtrRateMoni();

  for (var i = 1; i <= allGrpNum; i++){
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MCR_GRP[' + i + '].$MACHINELOCK', 100);
  }
  if (gLdtrState.tabSys != LDTR_TAB_STAT.NONE) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$MAN_IN_AUTO', 100);
  }

  if (isJincDisp) {
    stopJincMonitor();
  }
  
  top.rpcmc_stopIOMonitor(top.tpin_type_c, top.tp_enbl_c);
  top.rpcmc_stopIOMonitor(top.tpout_type_c, 1);
  top.rpcmc_stopIOMonitor(top.tpout_type_c, 3);
  top.rpcmc_stopIOMonitor(top.IOTYPE_SI, 2);
  top.rpcmc_stopIOMonitor(top.IOTYPE_SI, 8);
  top.rpcmc_stopIOMonitor(top.IOTYPE_SI, 9);
  top.rpcmc_stopIOMonitor(top.tpin_type_c, 247);
  top.rpcmc_stopIOMonitor(top.tpin_type_c, 248);
  top.rpcmc_stopIOMonitor(top.tpout_type_c, 5); // for [RUN] LED status

  // For the arc welding hand guide.
  if (top.g_order.s530) top.rpcmc_stopIOMonitor(hdlBbtn.type, hdlBbtn.num);
  if (top.g_order.wnsp) top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_WRSTDWN', 100);

  if ($("#ldtr_tgl_area").css("display") == "inline-block") {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDTR_BTN', 100);
  }

  // system monitor event function
  top.jQuery.varlis.unbind('VarEvent', panelVarEvent);
  top.jQuery.iolis.unbind("IOBooleanEvent", IOEnableEvent);
}

function loadPanelArea() {
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR.$JOG_GP', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$GENOVERRIDE', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$JOG_FINE', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$JOG_V_FINE', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR.$OVR_ZERO', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$SCR.$PRC_DSP[7]', 20);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_LABEL', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_SUBGRP', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MNUTOOLNUM[' + getCurGrp() + ']', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MNUFRAMENUM[' + getCurGrp() + ']', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$PLST_PARNUM[' + getCurGrp() + ']', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_ENBL', 100);
  for (var i = 1; i <= allGrpNum; i++){
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MCR_GRP[' + i + '].$MACHINELOCK', 100);
  }

  // Get incremental jog enable / disable
  top.rpcmc_getVar(top.SYSNAME_C, "$JINC.$JINC_ENB", getPnlJincEnbCB);

  top.rpcmc_startIOMonitor(top.tpin_type_c, top.tp_enbl_c);
  top.rpcmc_startIOMonitor(top.tpout_type_c, 1);
  top.rpcmc_startIOMonitor(top.tpout_type_c, 3);
  top.rpcmc_startIOMonitor(top.IOTYPE_SI, 2);
  top.rpcmc_startIOMonitor(top.IOTYPE_SI, 8);
  top.rpcmc_startIOMonitor(top.IOTYPE_SI, 9);
  top.rpcmc_startIOMonitor(top.tpin_type_c, 247);
  top.rpcmc_startIOMonitor(top.tpin_type_c, 248);
  top.rpcmc_startIOMonitor(top.tpout_type_c, 5); // for [RUN] LED status
  
  // For the arc welding hand guide.
  if (top.g_order.s530) top.rpcmc_chkkey(null, top.mor_ss_c, AWHDLASG, 'hdl_b_typ', getHdlType, null);
  if (top.g_order.wnsp) top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_WRSTDWN', chkPltMode, null);
  top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$CONTACT_TYP', dispLdtrTgl, null);

  // system monitor event function
  top.jQuery.varlis.bind('VarEvent', null, panelVarEvent);
  top.jQuery.iolis.bind("IOBooleanEvent", null, IOEnableEvent);
}

function panelVarEvent(event, progName, varName, typeCode, valStr) {
  if (varName === "$JCR.$JOG_GP") {
    resetPorring(parseInt(valStr));
    switchGrpElm(valStr);

  }else if (varName === '$ALM_IF.$CURR_STAT') {
    // update stat ABORTE or PAUSE or RUNNING
    setProgStatVar(valStr); // program action state

  } else if ((varName === "$MCR.$GENOVERRIDE") || (varName === "$MCR.$JOG_FINE") ||
              (varName === "$MCR.$JOG_V_FINE") || (varName === "$MCR.$OVR_ZERO")) {
    // update override value
    if ((runningOvrUpdate) && (touchSlideKnob == "")) {
      getOvrVal();
    } else {
      setGetOvrTimer();
    }

  } else if (varName === "$SCR.$PRC_DSP[7]"){
    var isDisp = valStr === "TRUE";
    dispZeroBtn(isDisp);
    if (isDisp){
      var clsName = "disable_ovr_zero";
      if (valStr === "FALSE") {
        clsName = "hidden_ovr_zero";
      } else if (ovr_val === 5) {
        clsName = "enable_ovr_zero";
      } else if (ovr_val === 0) {
        clsName = "active_ovr_zero";
      }
      setZeroBtnCls(clsName);
    }
  } else if (varName === "$JCR_GRP[" + getCurGrp() + "].$JOG_LABEL") {
    setPnlArea();

  } else if (varName === "$JCR_GRP[" + getCurGrp() + "].$JOG_SUBGRP") {
    curSubGrp = valStr == "TRUE" ? true : false;
    setPnlArea();

  } else if (varName === "$MNUTOOLNUM[" + getCurGrp() + "]") {
    setFrmNumDisp(null, null, null, valStr, TOOL_NUM_IND);

  } else if (varName === "$MNUFRAMENUM[" + getCurGrp() + "]") {
    setFrmNumDisp(null, null, null, valStr, USER_NUM_IND);

  } else if (varName === "$PLST_PARNUM[" + getCurGrp() + "]") {
    var menu_box = $('#payload_box');
    var arrw_btn = $('#payload_img');
    menu_box.text(valStr);
    menu_box.append(arrw_btn);

  } else if (varName === "$DCSS_CLLB[1].$LDTR_TYPE") {
    gLdtrState.class = valStr;
    var curTab = "#" + $('.tab_active').attr('id');
    if ((activeBtnId == P_BTNID[JOG_PNL]) && (curTab == P_TABID[LDTR_TAB])) {
      settingLdtrPnl(valStr);
    }

  } else if (varName.indexOf('$LDCT_RATE') >= 0 || varName === '$DCSS_CLLB[1].$LDTR_RATE') {
    // update TeachWeight value
    if ((runningWeightValUpdate) && (touchSlideKnob == "")) {
      getWeightVal();
    } else {
      setGetTeachWeightTimer();
    }

  } else if (varName === "$DCSS_CLLB[1].$LDTR_ENBL") {
    setLdtrEnbLocal((valStr == 'TRUE' || valStr == 1));

    // When robot operation panel is open.
    var tabName = "";
    if (getLdtrEnbLocal()) {
      tabName = LDTR_TAB;
    } else {
      tabName = (g_selTab == P_TABID[LDTR_TAB]) ? JOG_TAB : P_TABNUM[g_selTab];
      g_selTab = P_TABID[tabName];
    }
    if (tabName in P_TABID && activeBtnId == P_BTNID[JOG_PNL]) $(P_TABID[tabName]).trigger("mouseup");

  } else if (varName === "$DCSS_CLLB[1].$MAN_IN_AUTO") {
    gLdtrState.tabSys = ((Number(valStr) % 2 == 0) ? LDTR_TAB_STAT.HIDE : LDTR_TAB_STAT.DISP);

  } else if (varName.indexOf("$MCR_GRP[") >= 0 && varName.indexOf("].$MACHINELOCK") >= 0) {
    g_machine_lock["g" + Number(varName.substring("$MCR_GRP[".length, "$MCR_GRP[".length + 1))] = valStr;
    setTcycMode();

  } else if (varName === "$DCSS_CLLB2[1].$LDTR_BTN") {
    updateLdtrTgl(valStr == "TRUE");

  } else if (varName.indexOf("$JINC") >= 0) {
    getPnlJincCB(varName, valStr);

  } else if (varName.indexOf('$JCR_GRP[' + getCurGrp() + '].$JOG_WRSTDWN') >= 0) {
    updatePltModeTgl(JSON.parse(valStr.toLowerCase()));

  } else if (varName == '$DCSS_CLLB[1].$LDCT_FRM') {
    setCustMenuBox(Number(valStr));
    
  } else if (varName.indexOf('$DCSS_CLLB[1].$LDCT_DRCT') >= 0) {
    drawCustTgl(varName.charAt(varName.length - 2), (valStr == "TRUE" ? true : false));

  } else if (varName == '$DCSS_CLLB2[1].$MGT_SNGDSP') {
    if (curMgtSngDsp == 0 && valStr == '1') {
      top.IHMIComponents.cf.toast.show(ldtrMsgRes['ldtr_oprt_sigl']);
    }
    curMgtSngDsp = Number(valStr);

  }
}

function setTcycMode(){
  for (var i = 1; i <= allGrpNum; i++){
    if (g_machine_lock["g" + i] === "FALSE"){
      switchTcycTgl(false);
      return;
    }
  }
  switchTcycTgl(true);
}



function resetPorring(curgrp) {
  // stop porring for before group
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_LABEL', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_SUBGRP', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MNUTOOLNUM[' + getCurGrp() + ']', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$MNUFRAMENUM[' + getCurGrp() + ']', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$PLST_PARNUM[' + getCurGrp() + ']', 100);
  if(top.g_order.wnsp) top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_WRSTDWN', 100);
  // set new group number
  setCurGrp(curgrp);

  // start porring for current group
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + curgrp + '].$JOG_LABEL', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + curgrp + '].$JOG_SUBGRP', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MNUTOOLNUM[' + curgrp + ']', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$MNUFRAMENUM[' + curgrp + ']', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$PLST_PARNUM[' + curgrp + ']', 100);
  if(top.g_order.wnsp) top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_WRSTDWN', 100);

  // get value of axis num, tool num, user num and display current it
  initSelListVal();
}

// set timer for get override value
function setGetOvrTimer() {
  clearGetOvrTimer();
  gtimerGetOveVal = setTimeout("befGetOvrVal()", GET_OVRVAL_INTERVAL);
}

// clear timer for get override value
function clearGetOvrTimer() {
  clearTimeout(gtimerGetOveVal);
  gtimerGetOveVal = null;
}

// set timer or get override value
function befGetOvrVal() {
  if (touchSlideKnob == "") {
    getOvrVal();
  } else {
    clearGetOvrTimer();
  }
}

// get override value
function getOvrVal() {
  runningOvrUpdate = false;
  curOvrVal = ovr_val;
  top.rpcmc_getVar(top.SYSNAME_C, '$MCR.$GENOVERRIDE', getOverrideCallback); // move override slider
  clearGetOvrTimer();
}

// set timer for get TeachWeight value
function setGetTeachWeightTimer() {
  clearGetTeachWeightTimer();
  gtimerGetTeachWeightVal = setTimeout("befGetTeachWeightVal()", GET_OVRVAL_INTERVAL);
}

// clear timer for get TeachWeight value
function clearGetTeachWeightTimer() {
  clearTimeout(gtimerGetTeachWeightVal);
  gtimerGetTeachWeightVal = null;
}

// set timer or get TeachWeight value
function befGetTeachWeightVal() {
  if (touchSlideKnob == "") {
    getWeightVal();
  } else {
    clearGetTeachWeightTimer();
  }
}

// get TeachWeight value
function getWeightVal() {
  runningWeightValUpdate = false;
  curWeightVal = weight_val;
  teachWeightMonitorFlag = true;
  getTeachWeight(reflectTeachWeight);
  clearGetTeachWeightTimer();
}

// For the arc welding hand guide.
// True while pressing the button on the hand guide.
if (top.g_order.s530) var isDTchBtnOn = false;

// Enable status event.
function IOEnableEvent(event, io_type, io_index, io_value) {
  if (typeof io_index === 'undefined') { return; }
  if (io_type == top.tpin_type_c) {

    if (io_index == top.tp_enbl_c) { // TP Enable
      var stat = !(Number(io_value) == 0);
      setTPEnb(stat);
      setSlidePnl(stat);

    } else if (io_index == 247) { // Enable Switch (left)
      enblSWObj["L"] = Number(io_value);

    } else if (io_index == 248) { // Enable Switch (right)
      enblSWObj["R"] = Number(io_value);
    }

  } else if (io_type == top.tpout_type_c) {

    if (io_index == 3) { // Step mode
      var stat = !(Number(io_value) == 0);
      setProgramStepMode(stat);
      document.getElementById("step_tgl_box").checked = stat;

    } else if (io_index == 1) { // Alarm
      var stat = (Number(io_value) == 1);
      setAlarmOn(stat);

    } else if (Number(io_index) == 5) {// [RUN]LED status
      var stat = (Number(io_value) == 1);
      getLEDState("RUN", stat); // program action state // program action state
    }

  } else if (io_type == top.IOTYPE_SI) { // T1 T2 MODE
    if (io_index == 2) curSI2 = Number(io_value);
    if ((io_index != 8) && (io_index != 9)) {
      return;
    }
    getCurMode();
  // For the arc welding hand guide.
  } else if (hdlBbtn.assing && (hdlBbtn.type == top.IO_TYPE_DIN || hdlBbtn.type == top.IO_TYPE_RIN)) {
    if (top.g_order.s530 && io_type == hdlBbtn.type && io_index == hdlBbtn.num) {
      if (Number(io_value) == 0) { // turn off
        if (isDTchBtnOn) {
          l_setNextLdtrMode();
          l_setPnlState(JOG_PNL, PNL_DISP, top.is_lock_pnl, LDTR_TAB);
        }
        isDTchBtnOn = false;
      } else { // turn on
        isDTchBtnOn = true;
      }
    }
  }
}

// get current mode AUTO/T1/T2
function getCurMode() {
  top.rpcmc_iovalrd(top.IOTYPE_SI, 8, getCurModeCB);
}
// get current mode AUTO/T1/T2
function getCurModeCB(iotype, index, iodata, cbarg1, cbarg2) {
  top.rpcmc_iovalrd(top.IOTYPE_SI, 9, setCurMode, iodata);
}

// set current mode AUTO/T1/T2
function setCurMode(iotype, ioindex, iodata, value, cbarg) {
  if (iodata == 1 && value == 1) {
    moveModeName = MOVE_MODE_AUTO;
    $("#slider, #slider2, #slider3, #teachweight_slider").removeClass("hidden-handle");
  } else if (iodata == 0 && value == 1) {
    moveModeName = MOVE_MODE_T1;
    $("#slider, #slider2, #slider3, #teachweight_slider").removeClass("hidden-handle");
  } else if (iodata == 0 && value == 0) {
    moveModeName = MOVE_MODE_T2;
    $("#slider, #slider2, #slider3, #teachweight_slider").addClass("hidden-handle");
  }
}

function hideTabBtn(tab) {
  if ($(tab)[0].style.display != "none") {
    $(tab).hide();
  }
}
function showTabBtn(tab) {
  if ($("#jogPnlTab")[0].style.display == "none") {
    $("#jogPnlTab").show();
  }
  if ($(tab)[0].style.display == "none") {
    $(tab).show();
  }
}

function chg_pltmode_tgl() {
  clearTimeout(pltModeSwtAftChkr);
  pltModeSwtAftChkr = setTimeout(function() {
    var nextTgtEnable = document.getElementById('pltmode_tgl_oprt').checked;
    top.rpcmc_setVar(top.SYSNAME_C, "$JCR_GRP[" + getCurGrp() + "].$JOG_WRSTDWN", nextTgtEnable ? '1' : '0');
    top.rpcmc_setVar(top.SYSNAME_C, "$JCR_GRP[" + getCurGrp() + "].$JOG_SGAVD", nextTgtEnable ? '0' : '1');
    top.rpcmc_setVar(top.SYSNAME_C, "$JCR_GRP[" + getCurGrp() + "].$JOG_WRSTJNT", '0');
    // 2:Palletizing Jog / 3:Singularity Avoidance Jog
    top.rpcmc_setVar(top.SYSNAME_C, "$JCR_GRP[" + getCurGrp() + "].$WRSTJOGTYPE", nextTgtEnable ? 2 : 3);
    updatePltModeTgl(nextTgtEnable);
  }, 500);
}

function updatePltModeTgl(isEnable) {
  document.getElementById('pltmode_tgl_oprt').checked = isEnable;
  if(isEnable) {
    // cust rx
    document.getElementById(LDCT_TGL_ID[4]).checked = false;
    chg_cust_tgl(4);
     // cust ry
    document.getElementById(LDCT_TGL_ID[5]).checked = false;
    chg_cust_tgl(5);
    $('.notUsePltMode').addClass("disabled");
  } else {
    $('.notUsePltMode').removeClass("disabled");
  }
}
function dispPltModeTgl(isDisp) {
  if(!top.g_order.wnsp) isDisp = false;
  $('#pltmode_tgl_area').css('display', isDisp ? 'inline-block' : 'none');
}

// Set var for the manual guided teaching mode.
function chg_ldtr_tgl() {
  clearTimeout(ldtrSwtAftChkr);
  var curTglEnable = document.getElementById('ldtr_tgl_oprt').checked;
  top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDTR_BTN', !curTglEnable ? "0" : "1");
  ldtrSwtAftChkr = setTimeout(function() {
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$LDTR_BTN', getLdtrBtnCB, null);
  },500);
  function getLdtrBtnCB(io_type, io_index, typeStr, cbArg, chk_status) {
    if (chk_status == top.IO_SUCCESS) updateLdtrTgl(typeStr == "TRUE");
  }
}

// Set the manual guided teaching toggle switch valid/invalid.
function updateLdtrTgl(isEnable) {
  document.getElementById('ldtr_tgl_oprt').checked = isEnable;
}

// Display the manual guided teaching toggle switch.
function dispLdtrTgl(io_type, io_index, typeStr, cbArg, chk_status) {
  if (chk_status == top.IO_SUCCESS) {
    if (Number(typeStr) != 0) {
      $('#ldtr_tgl_area').css('display','inline-block');
      top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$LDTR_BTN', 100);
    } else {
      $('#ldtr_tgl_area').css('display','none');
    }
  }
}

function chkPltMode(io_type, io_index, typeStr, cbArg, chk_status) {
  if (chk_status == top.IO_SUCCESS) {
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_WRSTDWN', 100);
    var curBtn = "#" + $('.btn_active').attr('id');
    dispPltModeTgl(!(curBtn == L_BTNID[LDTR_MODE_F]));
    updatePltModeTgl((Number(typeStr) != 0));
  }
}

// get leadthrough status
function getLdtrValEnb() {
  // If CRXO is not ordered
  if (!top.g_crx) {
    hideTabBtn(P_TABID[LDTR_TAB]); // hide leadthrough button and flag reset
    setGetVarFlg(false);
    return;
  }
  top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C,'$DCSS_CLLB[1].$LDTR_ENBL', getLdtrValEnbCB, null);
}
function getLdtrValEnbCB(io_type, io_index, typeStr, cbArg, chk_status) {
  if (chk_status != top.IO_SUCCESS) {
    hideTabBtn(P_TABID[LDTR_TAB]);
    setGetVarFlg(false);
  } else {
    setLdtrEnbLocal((typeStr == 'TRUE' || typeStr == 1));
    //Get current moving speed value
    getLdtrType(settingLdtrPnl);
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB[1].$MAN_IN_AUTO', getLdtrTabEnbCB, null);
  }
}
function getLdtrTabEnbCB(io_type, io_index, typeStr, cbArg, chk_status) {
  if (chk_status == top.IO_SUCCESS) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$MAN_IN_AUTO', 100);
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$MAN_IN_AUTO', 100);
    gLdtrState.tabSys = ((Number(typeStr) % 2 == 0) ? LDTR_TAB_STAT.HIDE : LDTR_TAB_STAT.DISP);
  }
  setGetVarFlg(false);
}

// If $TAB_MPG.$DISP_PANEL exists and the value is 1, 'MPG' button is displayed.
function getMpgValEnbCB(io_type, io_index, typeStr, cbArg, chk_status) {
  if ((chk_status != top.IO_SUCCESS) || (typeStr != "1")) {
    setPlsEnb(false);
    hideTabBtn(P_TABID[PLS_TAB]);
  } else {
    showTabBtn(P_TABID[PLS_TAB]);
  }
  setDispLdtrCustMode(false);
  /* jogPanel display processing */
  if (alignExist) {
    top.rpcmc_getVar(ALIGNAXS, 'gnum', dispPanelProc);
  } else {
    dispPanelProc(null, null, null, 0);
  }
  function dispPanelProc(sysName, varName, typeCode, gnumVal) {
    var alignGnum = gnumVal == 'Uninitialized' ? 0 : Number(gnumVal);
    if ((!plsExist) && (!top.g_crx)) {
      if (alignExist) {
        if (alignGnum > 0) {
          switchJogPnlElm(ALIGN_TAB);
        } else {
          switchJogPnlElm(JOG_TAB);
        }
      }
      openJogPnl();
    } else if (!top.g_crx) {
      getPlsEnb(setPJPnlMode, alignGnum);
    } else {
      setLJPnlMode(alignGnum);
    }
  }
}

// set leadthrough enable
function setLdtrEnb(enable) {
  if (!top.g_crx) { return; }
  var enbNum = ((enable) ? 1 : 0);
  top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB[1].$LDTR_ENBL', enbNum);
}

// set Pulse generator enable
function setPlsEnb(enable) {
  if (!plsExist) { return; }
  var enbNum = ((enable) ? 1 : 0);
  top.rpcmc_setVar(top.SYSNAME_C, '$TAB_MPG.$ENABLE', enbNum);
}

function getLEDState(varStr, valStr) {
  if (varStr == "RUN") {
    if (valStr) { // LED ON
      // RUNNING MODE
      ledMode = WATCHEXEC_RUNNING;
      // for single task mode
      chkSingleTask();
      if (!getTPEnb()) {
        if (activeBtnId == P_BTNID[JOG_PNL]) {
          setPnlMode(JOG_PNL, false); // close jog panel
        }
        setPnlEnb(null, false, null);
      }

    } else { // LED OFF
      // ABORTED MODE
      ledMode = WATCHEXEC_ABORTED;
      initPnlProc();
    }
  }

}

function chkSingleTask() {
  if (top.g_order.j605 || top.g_order.j964) {
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C,'$MULTI_ROBO.$MLT_ENABLE', getMultRoboCB);
  } else {
    top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C,'$SCR.$MULSELENB', getMltSelCB);
  }
  function getMultRoboCB(io_type, io_index, typeStr, cbArg, chk_status) {
    if (chk_status != IO_SUCCESS) {
      top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C,'$SCR.$MULSELENB', getMltSelCB);
    } else {
      restrictPlayPnl(typeStr == "TRUE" ? false : true);
    }
  }
  function getMltSelCB(io_type, io_index, typeStr, cbArg, chk_status) {
    restrictPlayPnl(typeStr == "TRUE" ? false : true);
  }
}

// Language-dependent execution status string table.
function setProgStatVar(valStr) {   // current programe status
  if (valStr == null) {
    return;
  }
  switch (valStr.trim()) {
    case langRes['lightrobot_run_c']:
    case execStatResource[WATCHEXEC_RUNNING]:
      // RUNNING MODE
      statMode = WATCHEXEC_RUNNING;
      break;

    case langRes['lightrobot_pause_c']: // pause
    case execStatResource[WATCHEXEC_PAUSED]:
      // PAUSED MODE
      statMode = WATCHEXEC_PAUSED;
      if (progTaskNum == 1) initPnlProc();
      break;

    case langRes['lightrobot_stop_c']: // stop
    case execStatResource[WATCHEXEC_ABORTED]:
      // ABORTED MODE
      statMode = WATCHEXEC_ABORTED;
      break;

    default:
      break;
  }
}

function setTPEnb(stat) {
  tpEnb = stat;
}
function getTPEnb() {
  return tpEnb;
}
function setAlarmOn(stat) {
  isAlarmOn = stat;
}
function getAlarmOn() {
  return isAlarmOn;
}
function setLdtrEnbLocal(stat) {
  gLdtrState.sysEnb = stat;
}
function getLdtrEnbLocal() {
  return gLdtrState.sysEnb;
}

// Switch panel contents according to TPEnable
function setSlidePnl(stat) {
  if (stat) {
    // set run slider
    $('#play_run_slide').removeClass('hideButton');
    $('#play_pause').addClass('hideButton');
    $('#play_run').addClass('hideButton');
    $('#play_abort').addClass('play_stop_slide');
    $('#play_gototop').addClass('play_gototop_slide');
  } else {
    // remove run slider
    $('#play_run_slide').addClass('hideButton');
    $('#play_pause').removeClass('hideButton');
    $('#play_run').removeClass('hideButton');
    $('#play_abort').removeClass('play_stop_slide');
    $('#play_gototop').removeClass('play_gototop_slide');
  }
  if (statMode == WATCHEXEC_RUNNING || ledMode == WATCHEXEC_RUNNING) {
    chkSingleTask();
  } else {
    restrictPlayPnl(false);
  }
}

// Manipulate the overlay
function restrictPlayPnl(restrict) {
  var indexs = ((restrict) ? '31' : '');
  var indexp = (((restrict) && (!getTPEnb())) ? '31' : '');
  var indexa = ((restrict) ? '3' : ''); // for select prog overlay
  var disp   = ((restrict) ? 'none' : 'auto');
  var panel  = ((restrict) ? ['block', 'transparent'] : ['', '']);

  $('#btnimg_container_step_btn').css({ 'pointer-events': disp });
  $('#play_pause').css({ 'z-index': indexp });
  $('#play_abort').css({ 'z-index': indexs });
  $('#play_gototop').css({ 'z-index': indexs });
  $('#step_btn').css({ 'z-index': indexs });
  $('#overlay_panel').css({ 'display': panel[0], 'background': panel[1] });
  $('#pnlarea', parent.document).css({ "z-index": indexa });
  $('#treemod', parent.document).css({ "z-index": indexa });
}

// Release jog for tablet
function visChgFunc() {
  //  If tab switching occurs, release the jog
  if (document[hiddenStr]) {
    releaseJogStick();
  }
}
// Release jog for tablet main func
function releaseJogStick() {
  if (!isJogStickOn()) { return;}
  var stickId = targetStickId.substring(0, stickIdBase.length);
  if (stickId == "stick_pl") { // hold program
    holdProgram();
    resetStickProc();
  } else if (stickId == "stick_al") {
    holdProgram();
    resetMoveToStick();
  } else {
    sendJogStickKey(jogSendStat.key, 'off'); // stop move
    resetJogStick(targetStickId);
  }
}

//=============================================================================
// weight slider
//=============================================================================

$(function () {
  /* teaching weight */
  $("#teachweight_slider").slider({
    range: "min",
    min: 0,
    max: 110,
    step: 1,
    value: 50,
    slide: function (event, ui) {

      if (event.handleObj === undefined) {
        return false;
      }
      if ((touchSlideKnob == event.target.id) &&
        (event.handleObj.origType == "mousemove")) {
        weight_val = ui.value;
        weight_change(weight_val);
      } else if ((touchSlideKnob != event.target.id) &&
        (event.handleObj.origType == "mousedown")) {
        if (weight_val <= ui.value) {
          $("#teachweight_slider").slider("value", weight_val + 1);
        } else {
          $("#teachweight_slider").slider("value", weight_val - 1);
        }
        return false;
      } else if ((touchSlideKnob != event.target.id) &&
        (event.handleObj.origType == "mousemove")) {
        return false;
      }
      var weight_val_text = ui.value;
      $("#teachweight_slider_val").html(weight_val_text + "%");
      /* Changing the slider value */
      $("#teachweight_slider").slider("value", weight_val);
    },
    create: function (event, ui) {
      $("#teachweight_slider_val").html($(this).slider("value") + "%");
    },
    change: function (event, ui) {
      if (weight_val != ui.value) {
        $("#teachweight_slider_val").html(ui.value + "%");
        weight_val = ui.value;
        weight_change(weight_val);
      }
    },
    stop: function (event, ui) {
      touchSlideKnob = "";
      if (weight_val != ui.value) {
        weight_val = ui.value;
        $("#teachweight_slider_val").html(weight_val + "%");
        weight_change(weight_val);
      } else {
        sendWeightValCB(null, null, null, ui.value);
      }
    },
  });
  $("#slider3").slider({
    range: "min",
    min: 1,
    max: 100,
    step: 1,
    value: 50,
    slide: function (event, ui) {
      if (event.handleObj === undefined) {
        return false;
      }
      if ((touchSlideKnob == event.target.id) &&
        (event.handleObj.origType == "mousemove")) {
        weight_val = ui.value;
        weight_change(weight_val);
      } else if ((touchSlideKnob != event.target.id) &&
        (event.handleObj.origType == "mousedown")) {
        if (weight_val <= ui.value) {
          $("#slider3").slider("value", weight_val + 1);
        } else {
          $("#slider3").slider("value", weight_val - 1);
        }
        return false;
      } else if ((touchSlideKnob != event.target.id) &&
        (event.handleObj.origType == "mousemove")) {
        return false;
      }
      var weight_val_text = ui.value;
      $("#slider3_val").html(weight_val_text + "%");
      /* Changing the slider value */
      $("#slider3").slider("value", weight_val);
    },
    create: function (event, ui) {
      $("#slider3_val").html($(this).slider("value") + "%");
    },
    change: function (event, ui) {
      if (weight_val != ui.value) {
        $("#slider3_val").html(ui.value + "%");
        weight_val = ui.value;
        weight_change(weight_val);
      }
    },
    stop: function (event, ui) {
      touchSlideKnob = "";
      if (weight_val != ui.value) {
        weight_val = ui.value;
        $("#slider3_val").html(weight_val + "%");
        weight_change(weight_val);
      } else {
        sendWeightValCB(null, null, null, ui.value);
      }
    },
  });

  $('.ui-slider-handle').on('mousedown touchstart', function (event) {
    event.preventDefault();
    touchSlideKnob = event.target.offsetParent.id;
  });
});

// plus button
function weight_plus() {
  var trgSlider = (getCurSelLdtrBtnId() === L_BTNID[LDTR_MODE_F]) ? "#teachweight_slider" : "#slider3";
  $(trgSlider).slider("value", weight_val + 1);
}

// minus button
function weight_minus() {
  var trgSlider = (getCurSelLdtrBtnId() === L_BTNID[LDTR_MODE_F]) ? "#teachweight_slider" : "#slider3";
  $(trgSlider).slider("value", weight_val - 1);
}

var WEIGHT_25_SEP = [0, 25, 50, 75, 100, 110];

// plus25 button
function weight_plus25() {
  for (var i = 0; i < WEIGHT_25_SEP.length; i ++) {
    if (weight_val < WEIGHT_25_SEP[i]) {
      var trgSlider = (getCurSelLdtrBtnId() === L_BTNID[LDTR_MODE_F]) ? "#teachweight_slider" : "#slider3";
      $(trgSlider).slider("value", WEIGHT_25_SEP[i]);
      break;
    }
  }
}

// minus25 button
function weight_minus25() {
  for (var i = WEIGHT_25_SEP.length - 1; i >= 0; i --) {
    if (weight_val > WEIGHT_25_SEP[i]) {
      var trgSlider = (getCurSelLdtrBtnId() === L_BTNID[LDTR_MODE_F]) ? "#teachweight_slider" : "#slider3";
      $(trgSlider).slider("value", WEIGHT_25_SEP[i]);
      break;
    }
  }
}

// set val or timer
function weight_change(slideWeightVal) {
  if (touchSlideKnob == "") {
    clearSendTimer();
    sendWeightVal(slideWeightVal);
  } else {
    setWeightSendTimer(slideWeightVal);
  }
}

// set timer for send data
function setWeightSendTimer(sendVal) {
  clearSendTimer();
  gtimerKeepData = setTimeout(function () { sendWeightVal(sendVal); }, SEND_OVRVAL_INTERVAL);
}

// set val
function sendWeightVal(setWeightVal) {
  setVarWithCallback(top.SYSNAME_C, TEACH_WEIGHT_VARNAME[L_BTNID_NUM[getCurSelLdtrBtnId()]], setWeightVal, sendWeightValCB, setWeightVal);
  clearSendTimer();
}

function sendWeightValCB(status, prgName, varName, sendVal) {
  setTimeout(function() {
    getTeachWeight(getTeachWeightCB, sendVal);
  }, 300);
}

function getTeachWeightCB(ovrStr, sendVal) {
  if (ovrStr == sendVal) return;
  // update TeachWeight value
  if ((runningWeightValUpdate) && (touchSlideKnob == "")) {
    getWeightVal();
  } else {
    setGetTeachWeightTimer();
  }
}

// set val
function chg_cust_tgl(num) {
  var tglEnable = document.getElementById(LDCT_TGL_ID[num]).checked;
  tglEnable = !tglEnable;
  var varStr = (tglEnable) ? "0" : "1";
  top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB[1].$LDCT_DRCT[' + num + ']', varStr);
}
function drawCustTgl(num, isEnable) {
  document.getElementById(LDCT_TGL_ID[num]).checked = isEnable;
}
function initCustCB(status, getText) {
  if (status != top.IO_SUCCESS) {
    console.log("getXHR error");
  } else {
    var strXml = getText;
    var xmlObj = null;
    var domParser = new DOMParser();
    try {
      xmlObj = domParser.parseFromString(strXml, 'text/xml');
    } catch (e) {
      top.irprogapi.inner.apiErrorLog(e);
    }
    if ((xmlObj == null) || (xmlObj.getElementsByTagName('parsererror').length)) {
      // failure Get XML Data.
      top.irprogapi.inner.apiErrorLog('initCustCB: xml error.');
    } else {
      // Success Get XML Data.
      var xmlVarElem = xmlObj.getElementsByTagName("XMLVAR");
      var ldctFrmNum = Number(xmlVarElem[0].getElementsByTagName("VAR")[0].textContent);
      var arrayElem = xmlVarElem[0].getElementsByTagName("ARRAY");

      setCustMenuBox(ldctFrmNum);
      for (i = 0; i < 6; i++) {
        var isEnable = (arrayElem[i].textContent == "TRUE") ? true : false;
        drawCustTgl(i+1, isEnable);
        // set monitor for $DCSS_CLLB[1].$LDCT_DRCT[1-6]
        top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDCT_DRCT[' + (i + 1) + ']', 100);
      }
      // set monitor for $DCSS_CLLB[1].$LDCT_FRM
      top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDCT_FRM', 100);
    }
  }
}

function setCustMenuBox(ldctFrmNum) {
  var menu_box = $('#cust_frm_box'); // box
  var arrw_btn = $('#cust_lj_box_img'); // image in box
  var arrKeys = ['50', '30', '40'];
  arrw_btn.css("display", "none");
  menu_box[0].style.fontSize = adjustTextFontSize(coordlangRes[arrKeys[ldctFrmNum]], DEF_FONT_SIZE, TEXT_WIDTH);
  if ("#" + $('.tab_active').attr('id') == P_TABID[LDTR_TAB]) {
    arrw_btn.css("display", "block");
    menu_box.text(coordlangRes[arrKeys[ldctFrmNum]]);
    menu_box.append(arrw_btn);
  }
}

function initCust() {
  var sysnum_xml = '<?xml version="1.0" encoding="UTF-8"?>\r<XMLCFG>\r<PROG name="*SYSTEM*">\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_FRM" />\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_DRCT[1]" />\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_DRCT[2]" />\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_DRCT[3]" />\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_DRCT[4]" />\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_DRCT[5]" />\r'
  + '<VAR name="$DCSS_CLLB[1].$LDCT_DRCT[6]" />\r'
  + '</PROG>\r</XMLCFG>';
  // Create Blob CVR
  var file_cvr = new Blob([sysnum_xml], { type: "text/plain" });
  top.getXHR("get_ldtr_cus_val.cvr", file_cvr, initCustCB);
}

function fintCust() {
  for (var i = 1; i <= 6; i++) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDCT_DRCT[' + i + ']', 100);
  }
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB[1].$LDCT_FRM', 100);
}

// Called from JOG button.
// Display JOG panel or LDTR panel.
function setLJPnlMode(alignGnum) {
  if (getLdtrEnbLocal()) {
    openLdtrPnl();
    openJogPnl();
  } else if ((!getLdtrEnbLocal()) && (plsExist)) {
    getPlsEnb(setPJPnlMode, alignGnum);
  } else if (!plsExist) {
    if (alignGnum > 0) {
      switchJogPnlElm(ALIGN_TAB);
    } else {
      switchJogPnlElm(JOG_TAB);
    }
    openJogPnl();
  }
}

function setPJPnlMode(prgName, varName, typeCode, pulseenable, alignGnum) {
  if (pulseenable == "1") {
    switchJogPnlElm(PLS_TAB);
  } else if (pulseenable == "0") {
    if (alignGnum > 0) {
      switchJogPnlElm(ALIGN_TAB);
    } else {
      switchJogPnlElm(JOG_TAB);
    }
  }
  if(getLdtrEnbLocal()) openLdtrPnl();
  openJogPnl();
}

// set getVar Flg
function setGetVarFlg(stat) {
  getVarFlg = stat;
}

// set coordinate value
function setCoordinate(val) {
  top.rpcmc_setVar(top.SYSNAME_C, "$JCR_GRP[grp].$JOG_COORD", val);
}

// get coordinate value
function getCoordinate(callback) {
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_COORD', getCoordinateCallback, callback);
}

// get coordinate value
// get sub group value
function getSubGrp(callback, arg) {
  top.rpcmc_getVar(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_SUBGRP', getSubGrpCallback, callback, arg);
  // get coordinate value callback
  function getSubGrpCallback(prgName, varName, typeCode, subGrp, callback, arg) {
    curSubGrp = subGrp == "TRUE" ? true : false;
    callback(subGrp, arg);
  }
}
// set subgroup value(callback)
function setVarWithSubGrp(val, callback) {
  setVarWithCallback(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_SUBGRP', val, callback);
}
// set subgroup value
function setJogSubGrp(val) {
  top.rpcmc_setVar(top.SYSNAME_C, '$JCR_GRP[' + getCurGrp() + '].$JOG_SUBGRP', val);
}

// get jogmode value
function getJogModeConf(callback, arg) {
  top.getCurJogmodeConf(getCurGrp(), getCurJogmodeConfCallback, arg);
  function getCurJogmodeConfCallback(status, jogModeConf, arg) {
    callback(jogModeConf, arg);
  }
}

// get Pulse generator enable value
function getPlsEnb(callback, cbArg) {
  top.rpcmc_getVar(top.SYSNAME_C, '$TAB_MPG.$ENABLE', callback, cbArg);
}

// get coordinate value callback
function getCoordinateCallback(prgName, varName, typeCode, coordinate, callback) {
  if (coordinate == "0") {
    getSubGrp(callback, coordinate);
  } else {
    callback(coordinate, "FALSE");
  }
}

// get teach weight value
function getTeachWeight(callback, sendVal) {
  var getVarName = (getCurSelLdtrBtnId() == undefined) ? TEACH_WEIGHT_VARNAME[0] : TEACH_WEIGHT_VARNAME[L_BTNID_NUM[getCurSelLdtrBtnId()]];
  top.rpcmc_getVar(top.SYSNAME_C, getVarName, getTeachWeightCallback, callback, sendVal);
}
// get teach weight value callback
function getTeachWeightCallback(prgName, varName, typeCode, weightStr, callback, sendVal) {
  if (typeof callback !== "undefined") {
    callback(Number(weightStr), sendVal);
  }
}

// get leadthrough type
function getLdtrType(callback, callbackarg) {
  var cbArg = {
    callback: callback,
    arg: callbackarg
  }
  top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C,'$DCSS_CLLB[1].$LDTR_TYPE', getLdtrTypeCB, cbArg);
}
function getLdtrTypeCB(io_type, io_index, typeStr, cbArg, chk_status) {
  if (chk_status != top.IO_SUCCESS) {
    setLdtrEnb(false);
    hideTabBtn(P_TABID[LDTR_TAB]);
  }

  gLdtrState.class = typeStr;
  if (typeof cbArg.callback !== "undefined") {
    cbArg.callback(typeStr, cbArg.arg);
  } else {
    setGetVarFlg(false);
  }
}

function getCurSelLdtrBtnId() {
  var resultId = $('.btn_active').attr('id') == undefined ? undefined : "#" + $('.btn_active').attr('id');
  return resultId;
}

// set teach weight for slider
function reflectTeachWeight(weightStr) {
  if (curWeightVal != weight_val && teachWeightMonitorFlag) {
    setGetVarFlg(false);
    runningWeightValUpdate = true;
    teachWeightMonitorFlag = false;
    return;
  }

  if (weight_val != weightStr) {
    weight_val = parseInt(weightStr);
    if (getCurSelLdtrBtnId() === L_BTNID[LDTR_MODE_F]) {
      $("#teachweight_slider_val").html(weight_val + "%");
      //Changing the slider value
      $("#teachweight_slider").slider("value", weight_val);
    } else {
      $("#slider3_val").html(weight_val + "%");
      //Changing the slider value
      $("#slider3").slider("value", weight_val);
    }
  }
  setGetVarFlg(false);
  runningWeightValUpdate = true;
  teachWeightMonitorFlag = false;
}

// Setting for list height and top position.
function setListHeight(listBox, listArea) {
  var panelHalfH = $('#panel_j').height() / 2;
  var listBoxPos = listBox.getBoundingClientRect();
  var panlBorderH = $('.keypanel_border').height();
  var listAreaH = listArea.height();
  var listAreaTop = listBoxPos.bottom;

  if(panelHalfH <= listBoxPos.bottom) {
    listAreaH = listBoxPos.top - panlBorderH;
    listAreaTop = listBoxPos.top - listAreaH;
  }

  listArea.css({
    'height' : listAreaH + 'px',
    'top' : listAreaTop + 'px',
  });
}

function setListDisplay(listBox, listArea) {
  var panelH = $('#panel_j').height();
  var listBoxPos = listBox.getBoundingClientRect();
  var panlBorderH = $('.keypanel_border').height();
  var listTopSpace = listBoxPos.top;
  var listBtmSpace = panelH - listBoxPos.bottom;
  var listAreaH = listArea.height();
  var listAreaTop = listBoxPos.bottom;
  var overFlowY = 'visible';

  if (listAreaH > listBtmSpace) {
    if (listBtmSpace < listTopSpace) {
      if (listAreaH > listTopSpace) {
        listAreaH = listBoxPos.top - panlBorderH;
        listAreaTop = listBoxPos.top - listAreaH;
        overFlowY = 'scroll';
      } else {
        listAreaTop = listBoxPos.top - listAreaH;
      }
    } else {
      listAreaH = listBtmSpace;
      overFlowY = 'scroll';
    }
  }

  listArea.css({
    'height' : listAreaH + 'px',
    'top' : listAreaTop + 'px',
    'overflow-y' : overFlowY
  });
}

function jogModeDlgCB() {
  $('#jogmode_box').css('pointer-events', '');
}

// Set select list area event
function setSelListEvent() {
  $("#jogmode_box").on('click', function () {
    $('#jogmode_box').css('pointer-events', 'none');
    top.openCmpPupAppendFrm(top.window, "/frh/jcgtp/selectjogmodedlg.stm", "", null, true, null, jogModeDlgCB, true);
  });

  $("#cust_frm_box").on('click', function (event) {

    var sel_menu = $('.list_coord'); // list
    var menu_box = $('#cust_frm_box'); // box
    var arrw_btn = $('#cust_lj_box_img'); // image in box
    var arrKeys = ['50', '30', '40'];

	  if (sel_menu.length) { // close
      var target = $(event.target);
      if ((target[0].className).indexOf('cpage_sel') != -1) menu_box[0].style.fontSize = adjustTextFontSize(target.text(), DEF_FONT_SIZE, TEXT_WIDTH);
      if (top.g_msie) {
        sel_menu.css('overflow-y', 'hidden');
        setTimeout(function () {
          sel_menu.remove();
          menu_box.removeClass('arrow_show');

          if (target.hasClass('cpage_sel')) {
            menu_box.text(target.text());
            menu_box.append(arrw_btn);
            Object.keys(coordlangRes).forEach(function (key) {
              if (this[key] == target.text()) {
                setCustFrm(arrKeys.indexOf(key)); 
              }
            }, coordlangRes);
          }
        }, 30);
      } else {
        sel_menu.remove();
        menu_box.removeClass('arrow_show');
        if (target.hasClass('cpage_sel')) {
          menu_box.text(target.text());
          menu_box.append(arrw_btn);
          Object.keys(coordlangRes).forEach(function (key) {
            if (this[key] == target.text()) {
              setCustFrm(arrKeys.indexOf(key)); 
            }
          }, coordlangRes);
        }
      }
      return;

    } else { // open

      menu_box.addClass('arrow_show');
      var menu_frame = $('<div></div>', { addClass: "list_coord" });
      for (var i = 0; i < arrKeys.length; i++) {
        var menu_sel = $('<div></div>', { addClass: "cpage_sel" });
        menu_sel.text(coordlangRes[arrKeys[i]]);

        if (coordlangRes[arrKeys[i]] == menu_box.text().trim()) {
	        menu_sel.addClass('cpage_select'); // select node
        }
        if (i == arrKeys.length - 1) {
          menu_sel.addClass('cpage_end'); // node end
        }
        menu_frame.append(menu_sel);
      }

      menu_frame.css('left', -$("#testpanel_jog")[0].scrollLeft + 20 + "px");
      menu_frame.css('font-size','22px');
      setScrollEvt('#cust_frm_box', ".list_coord");
      $(this).append(menu_frame);
      setListHeight(this, menu_frame);
      if (top.g_msie) {
        $('#cust_frm_box').focus();
        var pnlSelListH = menu_frame.height();
        menu_frame.css('height', pnlSelListH - 1 + 'px');
        setTimeout(function () {
          menu_frame.css('height', pnlSelListH + 'px');
          return;
        }, 30);
      } else {
        return;
      }
    }
  });

	$("#utool_num_box").on('click', function (event) {

	  var sel_menu = $('.list_tool_num');
	  var menu_box = $('#utool_num_box');
	  var arrw_btn = $('#ut_box_img');

    if (sel_menu.length) { // close
      var target = $(event.target);
      if (top.g_msie) {
        sel_menu.css('overflow-y', 'hidden');
        setTimeout(function () {
          sel_menu.remove();
          menu_box.removeClass('arrow_show');
          if (target.hasClass('cpage_sel')) {
            menu_box.text(target.text());
            menu_box.append(arrw_btn);
            setTimeout(function () { setFrmNum(TOOL_NUM_IND, Number(target.text())); }, 0);
          }
          return;
        }, 30);
      } else {
        sel_menu.remove();
        menu_box.removeClass('arrow_show');

        if (target.hasClass('cpage_sel')) {
          menu_box.text(target.text());
          menu_box.append(arrw_btn);
          setTimeout(function () { setFrmNum(TOOL_NUM_IND, Number(target.text())); }, 0);
        }
        return;
      }

	  } else { // open

      menu_box.addClass('arrow_show');
      var menu_frame = $('<div></div>', { addClass: "list_tool_num" });

	    for (var i = 1; i <= frmNumObj["T"]; i++) {
	      var menu_sel = $('<div></div>', { addClass: "cpage_sel" });
	      menu_sel.text(i);

	      if (i == menu_box.text().trim()) {
	        menu_sel.addClass('cpage_select'); // select node
	      }
	      if (i == frmNumObj["T"]) {
	        menu_sel.addClass('cpage_end'); // node end
	      }
	      menu_frame.append(menu_sel);
      }
      setScrollEvt('#utool_num_box', ".list_tool_num");
      menu_frame.css('left', -$("#testpanel_jog")[0].scrollLeft + 20 + "px");
      $(this).append(menu_frame);
      setListHeight(this, menu_frame);
      if (top.g_msie) {
        $('#utool_num_box').focus();
        var pnlSelListH = menu_frame.height();
        menu_frame.css('height', pnlSelListH - 1 + 'px');
        setTimeout(function () {
          menu_frame.css('height', pnlSelListH + 'px');
          return;
        }, 30);
      } else {
        return;
      }
    }
  });

	$("#uframe_num_box").on('click', function (event) {

	  var sel_menu = $('.list_user_num');
	  var menu_box = $('#uframe_num_box');
	  var arrw_btn = $('#uf_box_img');

    if (sel_menu.length) { // close
      var target = $(event.target);
      if (top.g_msie) {
        sel_menu.css('overflow-y', 'hidden');
        setTimeout(function () {
          sel_menu.remove();
          menu_box.removeClass('arrow_show');
          if (target.hasClass('cpage_sel')) {
            menu_box.text(target.text());
            menu_box.append(arrw_btn);
            setTimeout(function () { setFrmNum(USER_NUM_IND, Number(target.text())); }, 0);
          }
        }, 30);
      } else {
        sel_menu.remove();
        menu_box.removeClass('arrow_show');

        if (target.hasClass('cpage_sel')) {
          menu_box.text(target.text());
          menu_box.append(arrw_btn);
          setTimeout(function () { setFrmNum(USER_NUM_IND, Number(target.text())); }, 0);
        }
      }
	    return;

	  } else { // open

	    menu_box.addClass('arrow_show');
	    var menu_frame = $('<div></div>', { addClass: "list_user_num" });

	    for (var i = 0; i <= frmNumObj["U"]; i++) {
	      var menu_sel = $('<div></div>', { addClass: "cpage_sel" });
	      menu_sel.text(i);

	      if (i == menu_box.text().trim()) {
	        menu_sel.addClass('cpage_select'); // select node
	      }
	      if (i == frmNumObj["U"]) {
	        menu_sel.addClass('cpage_end'); // node end
	      }
	      menu_frame.append(menu_sel);
      }
      setScrollEvt('#uframe_num_box', ".list_user_num");
      menu_frame.css('left', -$("#testpanel_jog")[0].scrollLeft + 20 + "px");
      $(this).append(menu_frame);
      setListHeight(this, menu_frame);
      if (top.g_msie) {
        $('#uframe_num_box').focus();
        var pnlSelListH = menu_frame.height();
        menu_frame.css('height', pnlSelListH - 1 + 'px');
        setTimeout(function () {
          menu_frame.css('height', pnlSelListH + 'px');
          return;
        }, 30);
      } else {
        return;
      }
	  }
	});

  $("#payload_box").on('click', function (event) {

    var sel_menu = $('.list_payload');
    var menu_box = $('#payload_box');
    var arrw_btn = $('#payload_img');

    if (sel_menu.length) { // close
      var target = $(event.target).parent();
      if (top.g_msie) {
        sel_menu.css('overflow-y', 'hidden');
        setTimeout(function () {
          sel_menu.remove();
          menu_box.removeClass('arrow_show');
          if (target.hasClass('cpage_sel')) {
            setPayloadDataIF(getCurGrp(), target.val(), SETSCH_MOVECHK, setPldNumCB);
          }
        }, 30);
      } else {
        sel_menu.remove();
        menu_box.removeClass('arrow_show');

        if (target.hasClass('cpage_sel')) {
          setPayloadDataIF(getCurGrp(), target.val(), SETSCH_MOVECHK, setPldNumCB);
        }
      }
      function setPldNumCB(status, lim_err, pld_stat, mode, setPldInf, cbArg) {
        if (status == top.IO_SUCCESS) {
          menu_box.text(target.val());
          menu_box.append(arrw_btn);
        } else if (status == ER_PLDSET_FAIL) {
          top.openCmpAlert(top.window, 'pldERRPldsetFailDlg', top.irpDlgRes["dlgERRPldsetFail"]);
        } else {
          console.log('Error on /COMET/rpc?func=PGPLDUTL : status [' + status +'], mode [' + mode + ']');
        }
      }
      return;

    } else { // open
      function dispPayloadList(varElem, cbArg) {
        
        cbArg.menu_box.addClass('arrow_show');
        var menu_frame = $('<div></div>', { addClass: "list_payload" });
        for (var i = 1; i <= g_payload_max; i++) {
          var menu_sel = $('<div></div>', { addClass: "cpage_sel" });
          var col_num = $('<div></div>', { addClass: "col_num col_cmn" });
          var col_cmt = $('<div></div>', { addClass: "col_cmt col_cmn" });
          var col_weight = $('<div></div>', { addClass: "col_weight col_cmn" });

          col_num.text(i + ' : ');
          var cmtTxt = (varElem.length >= i + g_payload_max) ? varElem[i - 1 + g_payload_max].textContent : '';
          col_cmt.text(cmtTxt);
          var weightNum = Number(varElem[i - 1].textContent).toFixed(2);
          var weightStr = weightNum + 'kg';
          col_weight.text(weightStr);
          menu_sel.append(col_num);
          menu_sel.append(col_cmt);
          menu_sel.append(col_weight);

          menu_sel.val(i);

          if (i === parseInt(cbArg.menu_box.text())) {
            menu_sel.addClass('cpage_select'); // select node
          }
          if (i == g_payload_max) {
            menu_sel.addClass('cpage_end'); // node end
          }
          menu_frame.append(menu_sel);
        }
        setScrollEvt('#payload_box', ".list_user_num");
        menu_frame.css('left', -$("#testpanel_jog")[0].scrollLeft + 20 + "px");
        menu_frame.css('height', $(cbArg.menu_box).height() * g_payload_max + "px");
        $(cbArg.menu_box).append(menu_frame);
        setListHeight($(cbArg.menu_box)[0], menu_frame);
        if (menu_frame.height() > cbArg.menu_box.outerHeight() * g_payload_max) {
          menu_frame.css({
            'height' : cbArg.menu_box.outerHeight() * g_payload_max + 'px',
            'top' : parseInt(menu_frame[0].style.top) + menu_frame.height() - cbArg.menu_box.outerHeight() * g_payload_max + 'px',
          });
        }
        if (top.g_msie) {
          $('#payload_box').focus();
          var pnlSelListH = menu_frame.height();
          menu_frame.css('height', pnlSelListH - 1 + 'px');
          setTimeout(function () {
            menu_frame.css('height', pnlSelListH + 'px');
            return;
          }, 30);
        } else {
          return;
        }
      }
      var cbArg = {menu_box: menu_box, cmtEnb: true ,tgtGrp: top.pnlarea.getCurGrp(), callback: dispPayloadList, plNum: g_payload_max};
      getPlstSelBox(cbArg); // "true" means weight and comment.
    }
  });

  $("#alignBox").on('click', function (event) {

    var sel_menu = $('.list_align'); // list
    var menu_box = $('#alignBox'); // box
    var menu_txt = $('#alignTxt'); // txt

	  if (sel_menu.length) { // close
      var target = $(event.target);
      function closeListProc() {
        sel_menu.remove();
        menu_box.removeClass('arrow_show');
        if (target.hasClass('cpage_sel')) {
          var curAlign = event.target.id.replace('alignList', '');
          pnlSetVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$ALIGN_TYPE', curAlign);
          if (Number(curAlign) <= 2) {
            setAlignElm(null, null, null, 'TRUE', curAlign);
          } else {
            top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$P_RECORDED[' + (Number(curAlign) - 2) + ']', setAlignElm, curAlign);
          }
          menu_txt.text(target.text());
        }
      }
      if (top.g_msie) {
        sel_menu.css('overflow-y', 'hidden');
        setTimeout(closeListProc, 30);
      } else {
        closeListProc();
      }

    } else { // open
      var listObj = {
        'alignType' : '',
      }
      function getAlignTypeCB(progName, varName, typeCode, alignType) {
        listObj.alignType = alignType;
        getAlignPname(setAlignSelBox);
      }

      function setAlignSelBox(pnameList) {
        var menu_frame = $('<div></div>', { addClass: "list_align" });
        var alignList = JSON.parse(JSON.stringify(alignLangRes));
        var arrKeys = Object.keys(alignList); // ["1":world, "2"user];
        var PNAME_MAX_NUM = 52;
        for (var i = 0; i < PNAME_MAX_NUM; i++) {
          var menu_sel = $('<div></div>', { addClass: "cpage_sel alignSel"});
          menu_sel.attr('id', 'alignList' + (i + 1));
          if(i < 2) {  // i = 0(aligntype=1):world, i = 1(aligntype = 2):user
            menu_sel.text(alignLangRes[arrKeys[i]]);
          } else {
            if (pnameList[i - 2] === "********") {
              menu_sel.text(alignLangRes["3"] + (i - 1) + ' ' + alignZAxis);
            } else {
              menu_sel.text(pnameList[i - 2] + ' ' + alignZAxis);
            }
          }
          if (Number(listObj.alignType) == i + 1) {
            menu_sel.addClass('cpage_select'); // select node
          }
          if (i == PNAME_MAX_NUM - 1) {
            menu_sel.addClass('cpage_end'); // node end
          }
          menu_frame.append(menu_sel);
        }
        menu_frame.css('left', -$("#testpanel_jog")[0].scrollLeft + 140 + "px");
        menu_frame.css('min-width', $("#alignBox").outerWidth() + "px");
        menu_frame.css('max-width', "540px");
        setScrollEvt('#alignBox', ".list_align");
        $(menu_box).append(menu_frame);
        setListDisplay(menu_box[0], menu_frame);
        if (top.g_msie) {
          $('#alignBox').focus();
          var pnlSelListH = menu_frame.height();
          menu_frame.css('height', pnlSelListH - 1 + 'px');
          setTimeout(function () {
            menu_frame.css('height', pnlSelListH + 'px');
          }, 30);
        }
      }
      top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$ALIGN_TYPE', getAlignTypeCB);
    }
  });

  $("#cust_frm_box").on('blur', function (event) {
    if (top.g_msie) {
      var target = $(document.activeElement);
      if (target.hasClass('cpage_sel')) {
        return;
      } else if (target[0].parentElement.id == 'linejoint_box') {
        $("#cust_frm_box").focus();
        return;
      }
    }
    var sel_menu = $('.list_coord');
    var menu_box = $('#cust_frm_box');
    if (sel_menu.length) {
      closeSelList(sel_menu, menu_box);
    }
    return;
  });

  $("#utool_num_box").on('blur', function (event) {
    if (top.g_msie) {
      var target = $(document.activeElement);
      if (target.hasClass('cpage_sel')) {
        return;
      } else if (target[0].parentElement.id == 'utool_num_box') {
        $("#utool_num_box").focus();
        return;
      }
    }
    var sel_menu = $('.list_tool_num');
    var menu_box = $('#utool_num_box');
    if (sel_menu.length) {
      closeSelList(sel_menu, menu_box);
    }
    return;
  });

  $("#uframe_num_box").on('blur', function (event) {
    if (top.g_msie) {
      var target = $(document.activeElement);
      if (target.hasClass('cpage_sel')) {
        return;
      } else if (target[0].parentElement.id == 'uframe_num_box') {
        $("#uframe_num_box").focus();
        return;
      }
    }
    var sel_menu = $('.list_user_num');
    var menu_box = $('#uframe_num_box');
    if (sel_menu.length) {
      closeSelList(sel_menu, menu_box);
    }
    return;
  });

  $("#payload_box").on('blur', function (event) {
    if (top.g_msie) {
      var target = $(document.activeElement);
      if (target.hasClass('cpage_sel') || target.hasClass('col_cmn')) {
        return;
      } else if (target[0].parentElement.id == 'payload_box') {
        $("#payload_box").focus();
        return;
      }
    }
    var sel_menu = $('.list_payload');
    var menu_box = $('#payload_box');
    if (sel_menu.length) {
      closeSelList(sel_menu, menu_box);
    }
    return;
  });

  $("#alignBox").on('blur', function (event) {
    if (top.g_msie) {
      var target = $(document.activeElement);
      if (target.hasClass('cpage_sel')) {
        return;
      } else if (target[0].parentElement.id == 'alignBox') {
        $("#alignBox").focus();
        return;
      }
    }
    var sel_menu = $('.list_align');
    var menu_box = $('#alignBox');
    if (sel_menu.length) {
      closeSelList(sel_menu, menu_box);
    }
    return;
  });

  function closeSelList(sel_menu, menu_box) {
    menu_box.removeClass('arrow_show');
    if (top.g_msie) {
      sel_menu.css('overflow-y', 'hidden');
      setTimeout(function () {
        sel_menu.remove();
      }, 30);
    } else {
      sel_menu.remove();
    }
  }

  // for iPad
  if (navigator.userAgent.indexOf('iPad') > 0) {
    $(document).on('touchend', function (e) {
      var openMenu = $('.arrow_show');
      if (!openMenu.length) { return; }

      var itemBox  = "#" + openMenu[0].getAttribute("id");
      var boxImg   = "#" + $(itemBox).children().attr('id');
      var itemList = "." + $(boxImg).next().attr('class');

      if (($(e.target).closest(itemBox).length) ||
          ($(e.target).closest(itemList).length) ||
          ($(e.target).closest(boxImg).length)) {
          return; // Do not close the list when expanding it.
      }
      setTimeout(function () {
          $(itemBox).removeClass('arrow_show');
          $(itemList).remove();
        }, 200); // close list
    });
  }
}

function setScrollEvt(itemBox, itemList) {
  var pnlS = document.getElementById('testpanel_jog');
  pnlS.onscroll = function () {
    if ($(itemList).length) {
      $(itemBox).removeClass('arrow_show');
      $(itemList).remove();
    }
    this.onscroll = null;
  };
}

var g_payload_max = undefined;
function getPayloadMaxCB(progName, varName, typeCode, plStr, afterCall, transInfo) {
  g_payload_max = Number(plStr);
}

// set coordinate and display panel
function setCustFrm(str) {
  top.rpcmc_setVar(top.SYSNAME_C, '$DCSS_CLLB[1].$LDCT_FRM', str);
}

// Pulse generator button event
function setPulseBtnEvent() {
  $('.jogcartsel_btn').on('click', function (event) {
    if ($('.jogcartsel_btn.selBtn').length == 0) setJogSubGrp('0');

    $('.jogextsel_btn').removeClass('selBtn');
    $('.jogcartsel_btn').removeClass('selBtn');
    $(event.target).addClass('selBtn');
    if (plsExist) {
      var addPoint = ((event.target.children[0].className.indexOf("jog_arrorw_btn") > 0) ? 4 : 1);
      setTimeout(function () { setPulseAxis((PULSE_AXIS_LIST_CART.indexOf(event.target.outerText) + addPoint)); }, 0);
      var ptnFlg = (((PULSE_AXIS_LIST_CART.indexOf(event.target.outerText) + addPoint) <= 3) ? "FALSE" : "TRUE");
      setScalingText(ptnFlg);
    }
  });
  $('.jogjointsel_btn').on('click', function (event) {
    if ($('.jogjointsel_btn.selBtn').length == 0) setJogSubGrp('0');

    $('.jogextsel_btn').removeClass('selBtn');
    $('.jogjointsel_btn').removeClass('selBtn');
    $(event.target).addClass('selBtn');
    if (plsExist) {
      setTimeout(function () { setPulseAxis((PULSE_AXIS_LIST_JOINT.indexOf(event.target.outerText) + 1)); }, 0);
      getRotaryAxs((PULSE_AXIS_LIST_JOINT.indexOf(event.target.outerText) + 1));
    }
  });
  $('.jogextsel_btn').on('click', function (event) {
    if ($('.jogextsel_btn.selBtn').length == 0) setJogSubGrp('1');

    if($('#jogpulsejointtbl').css("display") === "block") {
      $('.jogjointsel_btn').removeClass('selBtn');
    } else {
      $('.jogcartsel_btn').removeClass('selBtn');
    }
    $('.jogextsel_btn').removeClass('selBtn');
    $(event.target).addClass('selBtn');
    if (plsExist) {
      setTimeout(function () { setPulseAxis((PULSE_AXIS_LIST_EXT.indexOf(event.target.outerText) + 1)); }, 0);
      getRotaryAxs((PULSE_AXIS_LIST_EXT.indexOf(event.target.outerText) + 1));
    }
  });
  $('.jogscalingsel_btn').on('click', function (event) {
    $('.jogscalingsel_btn').removeClass('selBtn');
    $(event.target).addClass('selBtn');
    if (plsExist) {
      setTimeout(function () { setPulseMag((getCurScalList().indexOf(event.target.outerText) + 1)); }, 0);
    }
  });
}

// get rotary axs value
function getRotaryAxs(val) {
  top.rpcmc_getVar(top.SYSNAME_C, '$SCR_GRP[' + getCurGrp() + '].$ROTARY_AXS[' + val + ']', getRotaryAxsCallback);
}
// get rotary axs value callback
function getRotaryAxsCallback(prgName, varName, typeCode, axs) {
  setScalingText(axs);
}
// set scaling display text
function setScalingText(ptnFlg) {
  var textList = ((ptnFlg == "FALSE") ? gPulseScalList.ptn1 : gPulseScalList.ptn2);
  setCurScalList(textList);
  for (var i = 0; i < $('.jogscalingsel_txt').length; i++) {
    $('.jogscalingsel_txt')[i].innerText = textList[i];
  }
}
// Get current scaling list
function getCurScalList() {
  return curScalingList;
}
// Set current scaling list
function setCurScalList(list) {
  curScalingList = list;
}


//=============================================================================
// vibrete function
//=============================================================================
var vibrateInterval;
// Vibrete start
function startVibrate(duration) {
  if (!androidFlg || isAlarmOn) { return;}
  navigator.vibrate(duration);
}

// clear interval and stop vibrate
function stopVibrate() {
  if (vibrateInterval) clearInterval(vibrateInterval);
  vibrateInterval = null;
  if (!androidFlg) { return;}
  navigator.vibrate(0);
}

// Repeated vibration
// duration : Vibration time (ms)
// interval : Cycle time (ms)
function startPersistentVibrate(duration, interval) {
  vibrateInterval = setInterval(function() {
      startVibrate(duration);
  }, interval);
}

//=============================================================================
// Pulse generator BGM function
//=============================================================================
function pulseBGM() {
  if (isAlarmOn || gPulseState.SE == null) { return; }
  var source = gPulseState.SE.createBufferSource();
  source.buffer = gPulseState.SETrack;
  source.connect(gPulseState.SE.destination);
  source.start(0, 0, 0.05);
}

//=============================================================================
// Definition of methods that may not be supported.
//=============================================================================
// startsWith() is supported in the ES6
// IE11 is not support startsWith().
if (!String.prototype.startsWith) {
  String.prototype.startsWith = function (searchString, position) {
    position = position || 0;
    return this.substring(position, position + searchString.length) === searchString;
  };
}

// Record pose button event.
function recPoseBtn() {
  top.openCmpPupAppendFrm(top.window, '/frh/jcgtp/pnlalignname.stm', $('#alignTxt').text().replace(' ' + alignZAxis, ''), null, false, null, null);
}

function recPoseProc(chgAlignName, recFlg) {
  function recPoseAlignNumCB(progName, varName, typeCode, alignNumVal) {
    var alignNum = Number(alignNumVal) - 2;
    pnlSetVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$P_NAME[' + alignNum + ']', chgAlignName);
    var setRecPoseName = chgAlignName;
    if (setRecPoseName === "********") {
      setRecPoseName = alignLangRes["3"]+alignNum;
    }
    $('#alignTxt').text(setRecPoseName + ' ' + alignZAxis);
    if (recFlg) pnlSetVar(ALIGNAXS, 'REQUEST_CODE', '1', recPoseCB, alignNumVal);
  }
  function recPoseCB(alignNumVal) {
    exeAlignAxsKarel(ALIGNAXS_URL, getRecPoseStat, alignNumVal);
  }
  function getRecPoseStat(status, alignNumVal) {
    if (status) {
      top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$P_RECORDED[' + (Number(alignNumVal) - 2) + ']', setAlignElm, alignNumVal);
    }
  }
  top.rpcmc_getVar(top.SYSNAME_C, '$UIALIGNAXS[' + getCurGrp() + '].$ALIGN_TYPE', recPoseAlignNumCB);
}

function exeAlignAxsKarel(karelUrl, callback, cbarg) {
  $.ajax({
    type: "GET",
    url: karelUrl,
    cache: false,
  }).done( function() {
    if (callback != undefined) callback(true, cbarg);
  }).fail( function() {
    if (callback != undefined) callback(false, cbarg);
  });
}

function postKarelErrCd(karelErrCode, severity, flag) {
  var severityPad = ('00' + severity).slice(-2);
  var flagPad = ('00' + flag).slice(-2);

  var karelErrCodePad = ('00000' + karelErrCode).slice(-5);
  var alermId = karelErrCodePad.substring(0, 2);
  var errCode = karelErrCodePad.substring(2, 5);
  var alarmIdH = ('00' + (Number(alermId).toString(16))).slice(-2).toUpperCase();
  var errCodeH = ('00' + (Number(errCode).toString(16))).slice(-2).toUpperCase();

  var sendErrCode = '0x' + severityPad + alarmIdH + flagPad + errCodeH;
  top.rpcmc_erpost(top.g_connect_id, sendErrCode, '', 0);
}

function pnlSetVar(
  prog_name, // (in)  program name
  var_name,  // (in)  variable name
  value,     // (in)  value
  callback,  // (in)  callback
  cbArg) {   // (in)  cbArg
$.getJSON("/COMET/rpc?func=VMIP_WRITEVA" +
    "&prog_name=" + prog_name +
    "&var_name=" + var_name +
    "&value=" + value, function(json) {
  if (undefined != json.FANUC.RPC) {
    if (json.FANUC.RPC[0].status != 0) {
      rpcmc_rprintf("[rpcmc] vmip_writeva [" + prog_name + "]" + var_name + " failed, status " +
          json.FANUC.RPC[0].status);
    } else {
      if (typeof callback === 'function') callback(cbArg);
    }
  }
  else {
    rpcmc_rprintf("[rpcmc] unexpected reply " + JSON.stringify(json));
  }
});
} // pnlSetVar

function existAlignKarel(ioType, ioIndex, gnumVal, cbArg, chkStatus) {
  if (chkStatus == top.IO_SUCCESS) {
    alignExist = true;
  }
  if (!alignExist) hideTabBtn(P_TABID[ALIGN_TAB]);
  // panel setting (get value and display adjustment)
  initPnlSetting();
}

// Align move to proc.
function moveTo() {
  var ufutSystemValue = {};
  // Execute karel program. 
  function setReqCodeCB () {
    exeAlignAxsKarel(ALIGNAXS_URL, chkAlignStat);
  }
  // Get align status.
  function chkAlignStat(stat) {
    if (stat) {
      top.rpcmc_getVar(ALIGNAXS, 'STATUS', chkAlignStatCB);
    } else {
      resetMoveToStick();
    }
  }
  // Processing for karel program status.
  function chkAlignStatCB(prog, varName, typeCode, statusNum) {
    function getAlignType() {
      top.rpcmc_getVar(ALIGNAXS, 'ALIGN_TYPE[' + getCurGrp() + ']', getAlignTypeCB);
    }
    function getAlignTypeCB(prog, varName, typeCode, alignType) {
      top.rpcmc_getVar(ALIGNAXS, 'REC_TOOLNUM' + (Number(alignType) - 2) + '[' + getCurGrp() + ']', getRecToolNumCB);
    }
    function getRecToolNumCB(prog, varName, typeCode, recToolNum) {
      var dlgMsg = top.irpDlgRes["dlgDiffToolNum"].replace('{{toolNum}}', recToolNum);
      top.openCmpConfirm('irprog', top.window, 'alignNotReachableDlg', dlgMsg, {btnData:top.irpDlgBtnYN, btn1Cb:chgToolNum});
      function chgToolNum() {
        setFrmNum(TOOL_NUM_IND, Number(recToolNum));
      }
    }
    function karelErrPost(prog, varName, typeCode, convStat) {
      postKarelErrCd(convStat, 0, 0);
      top.openCmpAlert(top.window, 'msgpopup_alarmtp', top.irpDlgRes["dlgNotReachable"]);
    }
    ufutSystemValue.UF = $('#uframe_num_box').text().trim();
    ufutSystemValue.UT = $('#utool_num_box').text().trim();

    if (statusNum == '0') { // status:0(success)
      movetoProc();
    } else if (statusNum == '5') { // status:5(tool number error)
      getAlignType();
    } else if (statusNum == '6') { // status:6(not reach position error)
      top.rpcmc_getVar(ALIGNAXS, 'CONV_STAT', karelErrPost);
    } else { // status:1-4(error)
      resetMoveToStick();
    }
  }
  // Check Movement-only program exist.
  function movetoProc() {
    top.loadFile(MOVETOPROGNAME + '.LS', loadMovetoProgram, 0); // irprog_io
  }
  // Create or edit on movement-only program.
  function loadMovetoProgram(status, progName, lines, lineCount, arg) {
    var extPos = progName.indexOf('.LS'); // have extension
    var progOmitExt = (extPos >= 0) ? progName.substring(0, extPos) : progName;
    if (status != top.IO_SUCCESS) { // May be not exist program...
      // Create movement-only program
      top.createPrg(progOmitExt, createdMovetoProg); // irprog_io
      return;
    }
    // update motion instruction.
    setMotionGroupCallback(null, progOmitExt, 'PRGWRITE_OVW');
  }
  // Create program.
  function createdMovetoProg(status, progName) {
    var PG_PAUS_ABRT_C = 8;
    top.setAttr(progName, top.MM_IGNR_PAUS_C, PG_PAUS_ABRT_C, setVisibilityCallback);
  }
  function setVisibilityCallback(status, progName) {
    top.setAttr(progName, top.MM_CONTROL_C, '1', setMotionGroupCallback); // irprog_io
  }
  // Program the motion.
  function setMotionGroupCallback(status, progName, prgWriteStr) {
    top.setAttr(progName, top.MM_DEF_GROUP_C, Math.pow(2, (curGrpNum - 1)), makeMoveToProg); // irprog_io
    // Add a program line if the program is newly created, or overwrite it if it is existing.
    function makeMoveToProg(status, progName) {
      var movetoInstStr = moveToMotionInst + MOVETOTERMINATECH;
      var progWrite = (prgWriteStr == 'PRGWRITE_OVW') ? 0 : 2;
      top.editPrg(progName, movetoInstStr, 1, progWrite, getAlignPos); // irprog_io
    }
  }
  // Get the position computed by karel.
  function getAlignPos(status, progName) {
    top.rpcmc_getVar(ALIGNAXS,'ALIGNED_JPOS', initMovetoProgCallback, progName);
  }

  // Convert karel position to TP program position.
  function initMovetoProgCallback(prog, varName, typeCode, alignPos, progName) {
    var progTxt = posTxt + '[1]{' + top.CODECRLF;
    progTxt += '   GP' + curGrpNum + ':' + top.CODECRLF;
    progTxt += top.CODETAB + 'UF : ' + ufutSystemValue.UF + ', UT : ' + ufutSystemValue.UT + ', ' + top.CODECRLF;

    var posAxis = [];
    var posTmp = alignPos.split(/J\d\s=/);
    for (var i = 1; i < posTmp.length; i++) {
      if (i != posTmp.length - 1) {
        posAxis[i] = top.CODETAB + 'J' + i + '=  ' + posTmp[i].trim() + ',';
      } else {
        var indexEnd = posTmp[i].indexOf('EXT') > 0 ? posTmp[i].indexOf('EXT') : posTmp[i].length;
        posAxis[i] = top.CODETAB + 'J' + i + '=  ' + posTmp[i].substring(0, indexEnd).trim();
      }
    }
    var posExt = [];
    posTmp = alignPos.split(/EXT\d:/);
    if (posTmp.length > 1) {
      posAxis[posAxis.length - 1] += ',';
      for (var i = 1; i < posTmp.length; i++) {
        posExt[i] = top.CODETAB + 'E' + i + '=  ' + posTmp[i].trim();
        posExt[i] += (i != posTmp.length - 1) ? ',' : '';
      }
    }
    for (var i = 1; i < posAxis.length; i++) {
      posAxis[i] += (i % 3 == 0 || i == posAxis.length - 1) ? top.CODECRLF : '';
      progTxt += posAxis[i];
    }
    for (var i = 1; i < posExt.length; i++) {
      posExt[i] += (i == posExt.length - 1) ? top.CODECRLF : '';
      progTxt += posExt[i];
    }
    progTxt += '};' + top.CODECRLF;
    top.editPos(progName, progTxt, editPosCallback); // irprog_io
  }
  // Execute movement-only program.
  function editPosCallback(status, progName) {
    var lineNum = 1;
    var execType = 7;
    var pauseOnShift = 0;
    var tpMotion = 1;
    var waitType = 0;
    if (alignShift) {
      top.runTask(progName, progName, lineNum, execType, pauseOnShift, tpMotion, waitType, runTaskCallback, 0);
    }
  }
  // Set a timer to check the status of the program.
  function runTaskCallback(status, progName) {
    // Process of execute program of movement.
    setTimeout(function() {
      top.rpcmc_iovalrd(top.tpout_type_c, 5, watchMovetoStatusCallback, progName, 0);
    }, 200);
  }
  // Resetting the timer and do process when the program stops.
  function watchMovetoStatusCallback(type, mode, status, progName, cbArg2) {
    if (status == WATCHEXEC_ABORTED) {  // if finished... stop moveto
      // eslint-disable-next-line no-console
      stopMovetoProgram(progName);
      return;
    }
    setTimeout(function() {
      top.rpcmc_iovalrd(top.tpout_type_c, 5, watchMovetoStatusCallback, progName, 0);
    }, 10);
  }
  function stopMovetoProgram(progName) {
    top.setAttr(progName, top.MM_CONTROL_C, '1', onEndMvTo); // irprog_io
  }

  // Check TP status.
  if (!getTPEnb()) {
    top.openCmpAlert(top.window, 'msgpopup_alarmtp', top.irpDlgRes["msgpopup_alarmtp"]);
    return;
  }
  // Check alarm exist
  if (getAlarmOn()) {
    top.openCmpAlert(top.window, 'msgpopup_alarm', top.irpDlgRes["msgpopup_alarm"]);
    return;
  }
  // Check program run status.
  if (statMode != WATCHEXEC_ABORTED) {
    top.openCmpAlert(top.window, 'msgpopup_move_abort', top.irpDlgRes["dlgMsgMoveAbort"]);
    return;
  }
  // Set request code.
  pnlSetVar(ALIGNAXS, 'REQUEST_CODE', '2', setReqCodeCB);
}

function onEndMvTo() {
  top.sendKey("Hold", 1);
  top.sendKey("Hold", 0);
  befSendShiftRel();
  resetMoveToStick();
}

function adjustTextFontSize(targetText, currentFontSize, desiredTextWidth) {
  // Generate span to check character width
  var span = document.createElement('span');
  span.style.position = 'absolute';
  span.style.top = '-1000px';
  span.style.left = '-1000px';
  span.style.whiteSpace = 'nowrap';
  // Set the characters you want to measure
  span.innerHTML = targetText;
  // Loop until it reaches the appropriate font-size.
  // The minimum font-size for Google Chrome on Windows(OS) is 10px.
  for (var i = currentFontSize; i > 8; i--) {
    span.style.fontSize = i + 'px';
    document.body.appendChild(span);
    var width = span.clientWidth;
    span.parentNode.removeChild(span);
    // Exit if the character width is less than the specified width.
    if (width <= desiredTextWidth || i == 9) {
      adjustedFontSize = i;
      break;
    }
  }
  return adjustedFontSize + 'px';
}

function setHelpBtnEvent() {
  $('#alignHelpLink').on('click', function (event) {
    $('#alignHelpLink.helpBtn').css('pointer-events', 'none');
    prepHelpPopup('#alignHelpLink.helpBtn','align');
  });
}

var helpContents = {
  'align': [
    {kind: 'title', text: 'title'},
    {kind: 'commonItem', text: 'sentence1'},
    {kind: 'img', text: '/frh/jcgtp/alignhelp_ex.png', style:'"width: 450px; height: 350px; background-color: white; margin: 10px 0px 0px 20px; pointer-events: none;"'},
    {kind: 'commonItem', text: 'sentence2', style:'"margin: 0px 0px 10px 20px;"'},
    {kind: 'commonItem', text: 'sentence3'},
    {kind: 'uncommonItem', text: '', child: false, style:'"background-color: white; border: black 2px solid; margin: 10px 0px 10px 20px; width: 300px; line-height: 52px; text-align: left; font-size: 22px; display: flex;"'},
    {kind: 'uncommonItem', text: 'slctBoxMsg', child: true, style:'"height: 100%; width: 280px; padding-left: 4px; overflow: hidden; white-space: nowrap; text-overflow: ellipsis;"'},
    {kind: 'uncommonItem', text: '', child: true, style:'"height: 23px; width: 16px; padding-right: 6px; padding-top: 2px;"'},
    {kind: 'uncommonItem', text: '', child: true, tag:'ins', style:'"display: inline-block; height: 0px; vertical-align: middle; width: 0px; border-top: 11px solid rgb(0, 0, 0); border-right: 7px solid transparent; border-bottom: 7px solid transparent; border-left: 7px solid transparent; margin: 0px 0px 0px 0px;"'},
    {kind: 'commonItem', text: 'sentence4'},
    {kind: 'img', text: '/frh/jcgtp/alignhelp_slider.png', style:'"width: 230px; height: 85px; margin: 10px 0px 0px 20px; pointer-events: none;"'},
    {kind: 'commonItem', text: 'sentence5'}
  ],
}

function prepHelpPopup(btnId, contentElem) {
  var customizeObj = { 'designpattern': 'mouse' };
  var htmlText = '';
  var itemList = helpContents[contentElem];
  var prefix = 'help_' + contentElem + '_';
  for (var i = 0; i < itemList.length; i++) {
    var text = itemList[i].text;
    var style = itemList[i].style;
    switch (itemList[i].kind) {
      case 'title':
        htmlText += '<span style="font-weight: bold; font-size: 18px;">' + helpLangRes[prefix + text] + '</span>';
        break;
      case 'img':
        htmlText += '<br><img style=' + style + 'src="' + text + '"></img>';
        break;
      case 'commonItem':
        if (style != undefined) {
          htmlText += '<br><div style=' + style + '>' + helpLangRes[prefix + text] + '</div>';
        } else {
          htmlText += '<br>' + helpLangRes[prefix + text];
        }
        break;
      case 'uncommonItem':
        if (itemList[i].child) {
          htmlText = htmlText.replace(/<[/]div>$/, '');
          if (text != '') { // text:slctBoxMsg
            htmlText += '<div style=' + style + '>' + helpLangRes[prefix + text] + '</div></div>';
          } else if (itemList[i].tag == 'ins') { // tag:ins
            htmlText = htmlText.replace(/<[/]div>$/, '');
            htmlText += '<ins style=' + style + '>' + '</ins></div></div>';
          } else {
            htmlText += '<div style=' + style + '>' + '</div></div>';
          }
        } else {
          htmlText += '<div style=' + style + '>' + '</div>';
        }
        break;
      default:
        break;
    }
  }
  htmlText = '<span style="margin: 0 15px 0 15px; padding-bottom: 30px; position: absolute;">' + htmlText + '<br></span>';

  // Call ihmicomponents.
  top.IHMIComponents.cf.helpMessage(htmlText, null, null, top, customizeObj);
  // Enable Button.
  $(btnId).css('pointer-events', '');
}

function getPlstSelBox(cbArg) {
  var sysnum_xml = '<?xml version="1.0" encoding="UTF-8"?>\r<XMLCFG>\r<PROG name="*SYSTEM*">\r';
  for (var i = 1; i <= cbArg.plNum; i++) {
    sysnum_xml += '<VAR name="$PLST_GRP' + cbArg.tgtGrp + '[' + i + '].$PAYLOAD" />\r';
  }
  if (cbArg.cmtEnb) {
    // If the language setting is set to Chinese, it may not be possible to get Japanese comments.
    for (var i = 1; i <= cbArg.plNum; i++) {
      sysnum_xml += '<VAR name="$PLST_GRP' + cbArg.tgtGrp + '[' + i + '].$COMMENT" />\r';
    }
  }
  sysnum_xml += '</PROG>\r</XMLCFG>';
  // Create Blob CVR
  var file_cvr = new Blob([sysnum_xml], { type: "text/plain" });
  top.getXHR("plst_sel_box.cvr", file_cvr, getPlstSelBoxCB, cbArg);
}

function getPlstSelBoxCB(status, getText, cbArg) {
  if (status != top.IO_SUCCESS) {
    console.log("getXHR error");
  } else {
    var strXml = getText;
    var xmlObj = null;
    var domParser = new DOMParser();
    try {
      xmlObj = domParser.parseFromString(strXml, 'text/xml');
    } catch (e) {
      top.irprogapi.inner.apiErrorLog(e);
    }
    if (xmlObj == null) {
      if (cbArg.cmtEnb) {
        top.IHMIComponents.cf.toast.show(langRes['payload_cmt_err']);
        cbArg.cmtEnb = false;
        getPlstSelBox(cbArg); // "false" means weight only.
      } else {
        // failure Get XML Data.
        top.IHMIComponents.cf.toast.show(langRes['payload_data_err']);
        top.irprogapi.inner.apiErrorLog('getPlstSelBoxCB: xml error.');
      }
    } else {
      if (xmlObj.getElementsByTagName('parsererror').length) {
        // failure Get XML Data.
        top.irprogapi.inner.apiErrorLog('getPlstSelBoxCB: xml error.');
      }
      // Success Get XML Data.
      var xmlVarElem = xmlObj.getElementsByTagName("XMLVAR");
      var varElem = xmlVarElem[0].getElementsByTagName("VAR");
      if (varElem.length < cbArg.plNum) {
        // failure Get weight.
        top.IHMIComponents.cf.toast.show(langRes['payload_data_err']);
        return;
      } else if (varElem.length < cbArg.plNum * 2) {
        // failure Get comment.
        top.IHMIComponents.cf.toast.show(langRes['payload_cmt_err']);
      }
      if (typeof(cbArg.callback) == "function") {
        cbArg.callback(varElem, cbArg);
      }
    }
  }
}

function getMgtSngDspCB(io_type, io_index, typeStr, cbArg, chk_status) {
  if (chk_status == top.IO_SUCCESS) {
    top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$MGT_SNGDSP', 100);
    curMgtSngDsp = Number(typeStr);
    top.rpcmc_startVarMonitor(top.SYSNAME_C, '$DCSS_CLLB2[1].$MGT_SNGDSP', 100);
  }
}

function getHdlType(io_type, io_index, str, cbArg, chk_status) {
  if (chk_status == top.IO_SUCCESS && str !='Uninitialized') {
    hdlBbtn.type = Number(str);
    top.rpcmc_chkkey(null, top.mor_ss_c, AWHDLASG, 'hdl_b_num', getHdlNum, null);
  } else {
    top.getIOvalue(hdlBbtn.type, hdlBbtn.num, switchHdlIOMonitor, null, null);
  }
}

function getHdlNum(io_type, io_index, str, cbArg, chk_status) {
  if (chk_status == top.IO_SUCCESS && str !='Uninitialized') {
    hdlBbtn.num = Number(str);
  } else {
    hdlBbtn.type = top.IO_TYPE_RIN;
  }
  top.getIOvalue(hdlBbtn.type, hdlBbtn.num, switchHdlIOMonitor, null, null);
}

function switchHdlIOMonitor(status, iotype, index, value, cbArg1, cbArg2) {
  if (status == top.IO_SUCCESS) {
    hdlBbtn.assing = true;
  }
  top.rpcmc_stopIOMonitor(hdlBbtn.type, hdlBbtn.num);
  top.rpcmc_startIOMonitor(hdlBbtn.type, hdlBbtn.num);
}

