/**********************************************************************
 * Selective Compliance Assembly Robot Arm robot program.
 * save program script
 *
 * Created : 2019/07/31 FSI
 * Modified: 
 *
 */

// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 */
/*
 * jQuery UI Widget
 * http://jqueryui.com
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */

/**
 * Confirm with user specified message.
 * webpage:{String} The webpage name from which confirm event is fired.
 * popFrm :{WindowObject} The popFrm is insertion position of popup.
 * dlgId  :{String} The dlgId to be used as request parameter.
 * dlgMsg :{String} The dlgMsg displayed in popup window.
 * btnObj :{Object} dialog button object.
 *         btnData     :{Object} btn1:{String} for 'btn1' text, btn2:{String} for 'btn2' text. etc...
 *         btn*Cb        :{Function} 'btn*' callback.
 *         btn*CbArg     :{String/Object} 'btn*' callback arg. 
 *         closeBtnCb    :{Function} 'closeBtn' callback.
 *         closeBtnCbArg :{String/Object} 'closeBtn' callback arg. 
 * isHideCloseBtn        :{Boolean} specify true when hide close button.
 * headerText            :{String} The popup header text. Usually the header is not displayed.
  */
function openCmpConfirm(webpage, popFrm, dlgId, dlgMsg, btnObj, isHideCloseBtn, headerText) {
  var customizeObj = {};
  customizeObj.isHTML = true;

  // for dialog button setting
  var btnLabel = {};
  for(var i = 0; i < Object.keys(btnObj.btnData).length; i++) {
    var btnNum = i + 1;
    btnLabel[btnNum] = { label: btnObj.btnData['btn' + btnNum]};
  }
  if(btnLabel != null) customizeObj.selectBtn = btnLabel;
  if(btnObj.btnData['width'] != undefined) customizeObj.selectBtn.width = btnObj.btnData['width'];

  // for dialog close button setting
  if(isHideCloseBtn) customizeObj.hideCloseBtn = isHideCloseBtn;

  // for dialog header text setting
  if(headerText != undefined) customizeObj.header = headerText;

  // Call ihmicomponents.
  top.IHMIComponents.cf.confirmMessage(webpage, dlgMsg, dlgId, undefined, null, popFrm, openCmpConfirmCallback, null, customizeObj);

  // Delete play panel overlay.
  if(dlgId.indexOf("msgpopup_") >= 0) top.pnlarea.restrictPlayPnl(false);

  // Component callback function for confirm.
  function openCmpConfirmCallback(dlgBtnId) {
    if(typeof btnObj[dlgBtnId + 'Cb'] === 'function') btnObj[dlgBtnId + 'Cb'](dlgBtnId, btnObj[dlgBtnId + 'CbArg']);
  }
}

/**
 * Display user specified message.
 * popFrm :{WindowObject} The 'popFrm' is insertion position of popup.
 * dlgId  :{String} The 'id' to be used as request parameter.
 * dlgMsg :{String} The 'dlgMsg' displayed in popup window.
 * isHideCloseBtn :{Boolean} specify true when hide close button.
 * closeBtnCb     :{Function} The closeBtn callback function.
 * headerText     :{String} The popup header text. Usually the header is not displayed.
 */
function openCmpAlert(popFrm, dlgId, dlgMsg, isHideCloseBtn, closeBtnCb, headerText) {
  var customizeObj = {};
  customizeObj.isHTML = true;
  if(isHideCloseBtn) customizeObj.hideCloseBtn = isHideCloseBtn;
  if(headerText != undefined) customizeObj.header = headerText;
  top.IHMIComponents.cf.alertMessage(dlgMsg, headerText, openCmpAlertCallback, popFrm, customizeObj);
  // for play panel overlay
  if(dlgId.indexOf("msgpopup_") >= 0) top.pnlarea.restrictPlayPnl(false);

  // component callback Function for alart
  function openCmpAlertCallback(dlgBtnId) {
    if(typeof closeBtnCb === 'function') closeBtnCb(dlgBtnId);
  }
}

/**
 * popFrm         :{WindowObject} The 'popFrm' is insertion position of popup.
 * popFile        :{String} The contensPage is contents in wizard frame.
 * appendArg      :{Object} argument from caller to popup.
 * headerText     :{String} The popup header text. Usually the header is not displayed.
 * isHideCloseBtn :{Boolean} specify true when hide close button.
 * btnSizeObj         :{Object} dialog button size object. 
 *  {width: 'xxxpx', height'xxxpx'}
 * refreshFunc    :{function}
 * isHideDlg    :{Boolean}
 */

function openCmpPupAppendFrm(popFrm, popFile, appendArg, headerText, isHideCloseBtn, btnSizeObj, refreshFunc, isHideDlg) {
  var popFilePath = popFile;
  var cstmObj = {};
  cstmObj.callerWindowObj = window;//if caller window removed, ihcp remove popup.
  if(headerText != undefined) cstmObj.header = headerText;
  if(btnSizeObj != null){
    cstmObj.width = btnSizeObj.width;
    cstmObj.height = btnSizeObj.height;
  }
  if(typeof refreshFunc == 'function') cstmObj.refreshFunc = refreshFunc;
  if(isHideCloseBtn) cstmObj.hideCloseBtn = isHideCloseBtn;
  // Information to be passed from the popup call source to the popup content stm.
  if(appendArg != null) cstmObj.appendArg = appendArg;
  if(isHideDlg != null) cstmObj.hideBox = isHideDlg;

  // Second argument: callback function for close button. Set to null because it is not used.
  top.IHMIComponents.cf.appendPopupFrm(popFilePath, null, popFrm, cstmObj);
}

var isGettingProgList = false;
var dispProgList = [];
var progSlctPopupCB = undefined;
function drawProgramList(progName, varName, typeCode, valStr, callbackProg, callbackarg) {
  if (isDrawProgramList(valStr)) {
    var arg = {props: {}};
    arg.props.value = top.SELECTPROG_ADDRESS
    top.transIrprogMenu(arg);
  } else {
    openCmpConfirm('irprog', top.window, 'emptyprglistdlg', top.irpDlgRes['msgEmptyProgList'], {btnData:{btn1:top.irpDlgBtnOC.btn1}});
  }
  if (typeof progSlctPopupCB === 'function') progSlctPopupCB();
  isGettingProgList = false;
  dispProgList = [];
};

function isDrawProgramList(currentProg){
  // Do not display the program name starting with "IPL_"
  var allProgram = getProgramFileList();
  var countDispProg = 0;
  for (var i = 0; i < allProgram.length; i++) {
    var progName = allProgram[i].name;
    if (!progName.match(/^IPL_.*/)) {
      dispProgList[countDispProg] = allProgram[i];
      countDispProg++;
    }
  }

  var listName = [];
  for (var i = 0; i < dispProgList.length; i++) {
    listName[i] = dispProgList[i].name;
  }
  var numCurrentProg = listName.indexOf(currentProg);
  // Conditions for outputting a dialog notifying that there is no selectable program.
  if (dispProgList.length == 0 || (dispProgList.length == 1 && numCurrentProg >= 0)) {
    return false;
  } else {
    return true;
  }
}

var programFileList = [];
function getProgramFileList() {
  return programFileList;
}

function buildProgramList() {
  // Call Interface of get program list
  subTypeIndex = 0;
  programFileList.length = 0;
  getProgramList(subTypeArray[subTypeIndex].arg, prgListInitCallback);
}

function getProgramList(subType, callback) {
  lstProg(top.TV_PRG_ALL, top.MM_MNEPRG_C, subType, callback);
}

function prgListInitCallback(datatype, prglist, listNum) {
  var result = makeProgramListArray(prglist, prgListInitCallback);
  if (result) {
    top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$TPEDIT_PROG', drawProgramList, null, null);
  }
}

// use attribute configuration
var subTypeArray = [
  { arg: top.MM_SUB_UNDEF_C, type: 'attrSubNone' },
  { arg: top.MM_SUB_MACRO_C, type: 'attrSubMacro' },
  { arg: top.MM_SUB_COND_C, type: 'attrSubCond' }
];
var subTypeIndex = 0;

function makeProgramListArray(prglist, subTypeCallback) {
  // Insert to list.
  // Preprocessing of list construction
  for (var i = 0; i < prglist.length; i++) {
    var regularName = prglist[i];
    if ((regularName.length > 0) && (!regularName.startsWith('*'))) {	// Not found in array
        // add regular program to list
        var allProgList = {};
        allProgList['name'] = regularName;
        allProgList['type'] = irpDlgRes[subTypeArray[subTypeIndex].type];
        programFileList[programFileList.length] = allProgList;
    }
  }
  subTypeIndex++;
  if (subTypeIndex < subTypeArray.length) {
    getProgramList(subTypeArray[subTypeIndex].arg, subTypeCallback);
    return false;	// May be need.
  } else {
    sortProgramList();
    return true;
  }
}

function sortProgramList() {
  programFileList.sort(function (one, two) {
    return (one.name < two.name) ? -1 : 1;
  });
}


function checkRunState(progName, isModeOprt) {
  setSelProgName(progName);
  var pgName = getSelProgName();
  if (top.currentProgInfo.currentProgStat == "abort" || top.currentProgInfo.currentProgStat == undefined) {
    chgProg(pgName, waitChgProgComplete, pgName, isModeOprt);
  } else {
    top.rpcmc_getVar(top.SYSNAME_C, '$TP_DEFPROG', getProgramForMain);
    function getProgramForMain(progName, varName, typeCode, valStr) {
      if (valStr != pgName) {
        if (isModeOprt){
          openCmpPupAppendFrm(top.window, top.mainfrm.prim.VOICE_POPUP_URL, { appendArg: 'checkAbortPrg' });
          top.voiceApi.reqSpeech(top.mainfrm.prim.getSpeechMsg(top.mainfrm.prim.MSG.ABORT_PRG_CHECK_POP));
        } else {
          openCmpConfirm('irprog', top.window, 'abortprogconfdlg', top.irpDlgRes['abortprog'], {btnData : top.irpDlgBtnYN, btn1Cb: top.abortProc});
        }
      }
    }
  }
}

var selProgName = "";
function setSelProgName(progName) {
  selProgName = progName;
}
function getSelProgName() {
  return selProgName;
}

function abortProc(isModeOprt) {
  if (typeof isModeOprt !== 'boolean') isModeOprt = false;
  top.rpcmc_getVar(top.SYSNAME_C, '$TP_DEFPROG', abortProgramForMain);
  function abortProgramForMain(progName, varName, typeCode, valStr){
    abortProgram(valStr, procAfterAbort, isModeOprt);
  }
}

var abortNum =0;
function procAfterAbort(status, prgName, isModeOprt) {
  if (status !== IO_SUCCESS) {
    if (abortNum < 10) {
      setTimeout(function() {
        abortProgram(prgName, procAfterAbort, isModeOprt);
      }, 100);
      abortNum++;
      return;
    } else {
      abortNum = 0;
    }
  }
  abortNum = 0;
  var pgName = getSelProgName();
  chgProg(pgName, waitChgProgComplete, pgName, isModeOprt);
}

var retryChgProgComplete = 0;
function waitChgProgComplete(status, currentProg, selectProg, isModeOprt) {
  if (currentProg != selectProg) {
    if (retryChgProgComplete < 100) {
      setTimeout(function () {
        waitChgProgComplete(status, progName, cbArg);
      }, 50); // Keep a interval
      retryChgProgComplete++;
      return;
    }
  }
  if (status != IO_SUCCESS) {
    if (isModeOprt) {
      openCmpPupAppendFrm(top.window, top.mainfrm.prim.VOICE_POPUP_URL, { appendArg: 'selecterrdlg' });
      top.voiceApi.reqSpeech(top.mainfrm.prim.getSpeechMsg(top.mainfrm.prim.MSG.SLCT_PRG_FAILED_POP));
    } else {
      openCmpConfirm('irprog', top.window, 'selecterrdlg', top.irpDlgRes['selecterr'], {btnData : {btn1:irpDlgBtnOC.btn1}});
    }
    return;
  }
  retryChgProgComplete = 0;
  if (chgProgCB != undefined) {
    chgProgCB(currentProg); // Notify the program name after switching
  }
  if (isModeOprt) {
    top.voiceApi.speechSlctRes(currentProg);
  }
}

var chgProgCB = undefined;
/*
 *  Receive callback from editor
 * (IN) callback : Function registered by the editor
 */
function setChgPrgCB(callback) {
  chgProgCB = callback;
}

// check if unsaved program is open
function checkUnsaved() {
  if (top.sessionStorage.getItem("unsaved") !== null) {
    if (top.sessionStorage.getItem("unsaved") == "true") {
      return true;
    }
  }
  return false;
}
// logout
function logoutProc() {
  top.sessionStorage.removeItem("unsaved");
  // Logout from controller
  top.rpcmc_logout();
  // put HOME page into _top frame in case close window fails.
  top.document.location.href = 'http://' + location.hostname;
  // Close window but after some time so logout completes
  setTimeout(function () {
    top.close()
  }, 2000);
}

function preDoLogout() {
  top.initCBFlag(); // init flag
  for (key in top.screenTrans) {
    if (top.screenTrans[key].cb !== undefined ||
      typeof top.screenTrans[key].cb !== "undefined") {
        top.setCBFlag(key, true); // Set the flag to true if the callback is registered.
        top.screenTrans[key].transProc = dologout;
        sendCB(key);
    }
  }
  var logoutEnb = true;
  for (key in top.isProcCB) {
    if (top.getCBFlag(key)) {
      logoutEnb = false;
    }
  }
  if (logoutEnb) {
    dologout();
  }
  function sendCB(key) {
    setTimeout(function () {
      try {
        top.screenTrans[key].cb();
      } catch (e) {
        top.setCBFlag(key, false);
        console.log(e);
      }
    }, 0);
  }
}

function dologout() {
  for (key in top.screenTrans) {
    top.screenTrans[key].cb = undefined;
  }
  if (top.isTabTP()) {
    android.ApiFinish(); 
  }
  top.closeAll();
  // Logout from controller
  top.rpcmc_logout();
  // put HOME page into _top frame in case close window fails.
  top.document.location.href = 'http://' + location.hostname;
}

// Save file error has occured.
function i_saveFileError(saveParam) {
  // Call from error alert dialog.
  // process is especially none.
}
/**
 * Program save process. (Call from dialog)
 */
function i_saveProgram(saveParam) {
  i_progCreateTime = Number(top.sessionStorage.getItem("progCreateTime"));
  i_getModifyTime(i_getProdProgName(top.sessionStorage.getItem("program")), i_checkProgramModify);
}

/*
 * Get Program Modify/Create time.
 * (IN) progName : Program name.
 * (IN) callback : A callback function.
 */
function i_getModifyTime(progName, callback) {
  getAttr(progName, top.MM_MDFY_TIME_C, callback); // io.js
}

/**
 * Callback function of program modify time.
 * Check modify time and confirm overwrite.
 * status : 0=success, other=error
 * progName : Program name
 * varName : Variable name
 * modifyTime : Modified string
 */
var i_prodModifyTime = '';
var i_progCreateTime = '';
// Check program edited time
function i_checkProgramModify(status, progName, varName, modifyTime) {
  i_prodModifyTime = Number(modifyTime);
  if (i_prodModifyTime > i_progCreateTime) {
    // Confirm overwrite
    openCmpConfirm('irprog', top.window, 'confovwrtdlg', top.irpDlgRes['overwrProg'],
                  {btnData : top.irpDlgBtnOC,
                   btn1Cb : i_overwriteprogram,
                   btn2Cb:logoutProc
                  });
  } else {
    i_programNonSelection(i_getProdProgName(progName));
  }
}
function i_overwriteprogram() {
  i_programNonSelection(i_getProdProgName(top.sessionStorage.getItem("program")));
}

// Change program to empty name.
function i_programNonSelection(progName) {
  // Rename temporaly file (edit file) to production file
  var cbArg = {};
  cbArg.func = i_changeEmptyProgCallback;
  cbArg.saveName = progName;
  chgProg('', i_getConcurrentCurrProgCallback, cbArg);
}
// Check current program name
function i_getConcurrentCurrProgCallback(status, progName, cbArg) {
  cbArg.status = status;
  top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', i_waitChgProgComplete, progName, cbArg);
}

// Wait for the program to change to an empty name.
var i_retryChgProgComplete = 0;
function i_waitChgProgComplete(progName, varName, typeCode, valStr, callbackProg, callbackarg) {
  if (valStr != callbackProg) {
    if (i_retryChgProgComplete < 100) {
      setTimeout(function () {
        top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_PROG', i_waitChgProgComplete, callbackProg, callbackarg);
      }, 200); // Keep a interval
      i_retryChgProgComplete++;
      return;
    }
  }
  i_retryChgProgComplete = 0;
  callbackarg.func(callbackarg.status, callbackProg, callbackarg);
}

/* Callback function to delete program after change prog to empty */
function i_changeEmptyProgCallback(status, progName, cbArg) {
  deletePrg(i_getProdProgName(cbArg.saveName), i_delProgCallback);
}

/* Callback to delete production program before save program. */
function i_delProgCallback(status, progName) {
  if (status != 0) {
    // It can not be deleted because it is in use elsewhere.
    if (status == IOSTAT_MEMO_044) {
      openCmpConfirm('irprog', top.window, 'alreadyuseddlg', irpDlgRes['alreadyUse'], {btnData : {btn1:irpDlgBtnOC.btn1}});
      // Since the program is unselected, select it again.
      var cbArg = {};
      cbArg.func = i_saveFileError;
      chgProg(i_getProdProgName(progName), i_waitChgProgComplete, cbArg);
      return;
    } else if (status == IOSTAT_MEMO_006) {
      openCmpConfirm('irprog', top.window, 'delproterrdlg', irpDlgRes['delProtectErr'], {btnData : {btn1:irpDlgBtnOC.btn1}});
      // Since the program is unselected, select it again.
      var cbArg = {};
      cbArg.func = i_saveFileError;
      chgProg(i_getProdProgName(progName), i_waitChgProgComplete, cbArg);
      return;
    }
  }
  var cbArg = {};
  cbArg.currentName = progName;
  cbArg.targetName = progName;
  renamePrg(i_getTempProgName(progName), progName, i_renProgCallback, cbArg);
}
/* Callback of complete renamePrg for save program. */
function i_renProgCallback(status, progName, cbArg) {
  if (status != 0) { // rename error eq save error... 
    openCmpConfirm('irprog', top.window, 'savefaildlg', irpDlgRes['msgSaveerr'], {btnData : {btn1:irpDlgBtnOC.btn1}});
    return;
  }
  // Set attribute to visible...
  setAttr(i_getProdProgName(progName), top.MM_CONTROL_C, "0", i_setAttrVisibleCB);
}

// Callback of set visible attribute when rename for save.
function i_setAttrVisibleCB(status, progName) {
  var cbArg = {};
  cbArg.func = i_selSavedProgramCB;
  chgProg(i_getProdProgName(progName), i_getConcurrentCurrProgCallback, cbArg); // Select the saved program.
}
// Callback of Select(Change) saved program.
function i_selSavedProgramCB(status, progName) {
  openCmpConfirm('irprog', top.window, 'savesuccessdlg', irpDlgRes['msgSavelogout'], {btnData:{btn1:irpDlgBtnOC.btn1}});
}

/*
 * Get program name to temporary name.
 * (IN) progName : Program name.
 * return : Temporary program name.
 */
function i_getTempProgName(progName) {
  var tempName = (!progName.startsWith('*')) ? '*' + progName : progName;
  return tempName;
}
/*
 * Get production name from temporary name.
 * (IN) progName : Program name.
 * return : Production program name.
 */
function i_getProdProgName(progName) {
  var prodName = (progName.startsWith('*')) ? progName.slice(1) : progName;
  return prodName;
}