/**********************************************************************
 *
 * Created : 2020/06/19 FSI
 * constant define
 *
 */

// = Status area setting
var WATCHEXEC_ABORTED = 0;
var WATCHEXEC_RUNNING = 1;
var WATCHEXEC_PAUSED  = 2;

// = Timer timeout value
var CYCLE_START_INTERVAL = 100;
var SEND_OVRVAL_INTERVAL = 200;
var GET_OVRVAL_INTERVAL  = 500;
var OBS_WIN_H_INTERVAL   = 200;

// = Panel stat setting
var PLY_PNL  = 0;
var JOG_PNL  = 1;
var KEY_PNL  = 2;

var LDTR_TAB = 0;
var JOG_TAB  = 1;
var PLS_TAB  = 2;
var ALIGN_TAB = 3;

// = Frame index
var TOOL_NUM_IND = "3";
var USER_NUM_IND = "4";

// = Move mode setting
var MOVE_MODE_AUTO = 0;
var MOVE_MODE_T1   = 1;
var MOVE_MODE_T2   = 2;

// = Click button kind
var BTN_EXE_MODE  = 1;
var BTN_STEP_MODE = 2;
var BTN_BACK_MODE = 3;

// = Cycle start setting
var CYCLE_LOCALWAIT  = 1;
var CYCLE_LOCALSTART = 0;
var REMOTE_MODE = 1;
var LOCAL_MODE = 2;
var EXTERNAL_IO_MODE = 3;

// = LDTR panel setting
var LDTR_MODE_F = 0; // free
var LDTR_MODE_P = 1; // pose
var LDTR_MODE_T = 2; // TCP
var LDTR_MODE_C = 3; // custom

// = Panel display setting
var PNL_LOCK = true;
var PNL_UNLOCK = false;

// = Panel lock setting
var PNL_DISP = true;
var PNL_HIDE = false;

// = Panel stat setting
var P_BTNID = {
  0: '#play_btn_parent',
  1: '#jog_btn_parent',
  2: '#tpkey_btn_parent'
};
var P_PNLID = {
  0: '#panel_p',
  1: '#panel_j',
  2: '#tpkeysheet_area'
};
var P_TABID = {
  0: '#jogLdtrTab',
  1: '#jogSldrTab',
  2: '#jogMpgTab',
  3: '#jogAlign'
};
var P_TABNUM = {
  '#jogLdtrTab': 0,
  '#jogSldrTab': 1,
  '#jogMpgTab': 2,
  '#jogAlign': 3 
};
var P_TABCLASS = {
  0: '.obl_ldtr',
  1: '.obl_jog',
  2: '.obl_pls',
  3: '.obl_align',
};
var L_BTNID = {
  0: '#ldtr_icon_f_btn',
  1: '#ldtr_icon_p_btn',
  2: '#ldtr_icon_t_btn',
  3: '#ldtr_icon_c_btn'
};
var L_BTNID_NUM = {
  '#ldtr_icon_f_btn': LDTR_MODE_F, // free
  '#ldtr_icon_p_btn': LDTR_MODE_P, // pose
  '#ldtr_icon_t_btn': LDTR_MODE_T, // TCP
  '#ldtr_icon_c_btn': LDTR_MODE_C, // custom
};
var L_SLDRCLASS = {
  0: '.slider_container.obl_ldtr',
  1: '.slider_container3.obl_ldtr',
  2: '.slider_container3.obl_ldtr',
  3: '.slider_container3.obl_ldtr',
};
var LDCT_TGL_ID = {
  1: 'cust_tgl_x_box',
  2: 'cust_tgl_y_box',
  3: 'cust_tgl_z_box',
  4: 'cust_tgl_rx_box',
  5: 'cust_tgl_ry_box',
  6: 'cust_tgl_rz_box'
};
var LDTR_TAB_STAT = {
  NONE: null,
  HIDE: 1,
  DISP: 0
};

var TEACH_WEIGHT_VARNAME = {
  0: '$DCSS_CLLB[1].$LDTR_RATE',
  1: '$DCSS_CLLB2[1].$LDCT_RATE[1]',
  2: '$DCSS_CLLB2[1].$LDCT_RATE[2]',
  3: '$DCSS_CLLB2[1].$LDCT_RATE[3]',
};

// = Panel height setting
var PLYPNL_H = 277;
var JOGPNL_H = 480;
var TPKEYS_H = 55;
var JOGPNLTAB_H = 55;
var SELGRPTAB_H = 67;
var MULTI_GRP_CLASS = 'mlt_grp';

// = Panel menu box setting
var DEF_FONT_SIZE = 22;
var TEXT_WIDTH = 68;

// = Panel payload check result for IF
// select mode for IF
var PLDCHK = 0;
var PLDSET = 1;
var PLDSET_MOVECHK = 2;
var SETSCH = 3;
var SETSCH_MOVECHK = 4;

// status
var ER_PLDSET_FAIL = '0xf029f';  //Robot is moving.
// pld_stat
var ER_OVERLOAD = '0xf00ab';        //overload
var ER_CLOSE_CAPACITY = '0xf00aa'; //90% of the allowable value is exceeded.

//=============================================================================
// jogkey
//=============================================================================

/* == Stick (Knob/Button) Position data table == */
var KNOBSIZEFORTAB = 57; // px
var KNOBPOSTOPTAB  = 24; // px
var KNOBPOSLEFTTAB = 7; // px
var KNOBPOSLEFTTABJ = 24; // px
var KNOBPOSLEFTTABP = 26; // px

//  Stick (Knob/Button) Origin position initialyze
var JOGSENDSTAT_SET = 1;
var JOGSENDSTAT_CLR = 0;


//=============================================================================
// Pulse
//=============================================================================

// = Pulse select list item
var PULSE_AXIS_LIST_JOINT = ["J1", "J2", "J3", "J4", "J5", "J6"];
var PULSE_AXIS_LIST_CART = ["X", "Y", "Z", "W", "P", "R"];
var PULSE_AXIS_LIST_EXT = ["E1", "E2", "E3"];

//=============================================================================
// Align
//=============================================================================

// Align karel data.
var ALIGNAXS = 'IPL_FANUC_ALIGNAXS';
var ALIGNAXS_URL = "/KARELCMD/IPL_FANUC_ALIGNAXS";
// Align programe
var MOVETOPROGNAME = "~MOVE_TO_ALIGN~";
var MOVETOTERMINATECH = '    ;';
// Arc Welding karel data.
var AWHDLASG = 'AWHDLASG';
