// Use jQuery
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 */

var DISP_CLOSE_BTN = 1;

/*
 * for alarm dialog Const
 */
var SERVO = 11;
var SSPC = 69;
var SYSTEM = 24;

var ALMDLG_SRVO065 = {ID: SERVO, CODE: 65};
var ALMDLG_SYST035 = {ID: SYSTEM, CODE: 35};
var ALMDLG_SYST266 = {ID: SYSTEM, CODE: 266}; // Request for cycle power.

var ALMDLG_PAYLOAD_CONF = [
  {ID: SYSTEM, CODE: 374},
  {ID: SYSTEM, CODE: 326},
];

var ALMDLG_SHIFTRESET_FOR_DCS = [
  {ID: SERVO, CODE: 402},
  {ID: SERVO, CODE: 404},
];

var ALMDLG_SHIFTRESET = [
  {ID: SERVO, CODE: 5},
  {ID: SERVO, CODE: 101},
  {ID: SERVO, CODE: 6},
  {ID: SERVO, CODE: 50},
  {ID: SSPC, CODE: 101},
  {ID: SSPC, CODE: 103},
  {ID: SERVO, CODE: 491},
];

var ALMDLG_CHAINRESET = [
  {ID: SERVO, CODE: 230},
  {ID: SERVO, CODE: 231},
  {ID: SERVO, CODE: 235},
  {ID: SERVO, CODE: 244},
  {ID: SERVO, CODE: 245},
  {ID: SERVO, CODE: 246},
  {ID: SERVO, CODE: 247},
  {ID: SERVO, CODE: 248},
  {ID: SERVO, CODE: 266},
  {ID: SERVO, CODE: 267},
  {ID: SERVO, CODE: 268},
  {ID: SERVO, CODE: 269},
  {ID: SERVO, CODE: 270},
  {ID: SERVO, CODE: 271},
  {ID: SERVO, CODE: 274},
  {ID: SERVO, CODE: 275},
  {ID: SERVO, CODE: 370},
  {ID: SERVO, CODE: 371},
  {ID: SERVO, CODE: 372},
  {ID: SERVO, CODE: 373},
  {ID: SERVO, CODE: 374},
  {ID: SERVO, CODE: 375},
  {ID: SERVO, CODE: 376},
  {ID: SERVO, CODE: 377},
  {ID: SERVO, CODE: 378},
];

// for TabletTP app
var ALM_FINISHED_UPD = [
  {ID: SYSTEM, CODE: 176},   // SYST-176
  {ID: SYSTEM, CODE: 239},    // SYST-239
];

// The Manual guided teaching
var ALMDLG_LDTR = [
  {ID: SYSTEM, CODE:387},
  {ID: SYSTEM, CODE:388},
];

// for "Collaborative Speed Limit" popup
var initPldConfChecked = true;

addEventHandler(window, "load", function() {

  setAlmDlg(ALMDLG_SRVO065.ID, ALMDLG_SRVO065.CODE, "/frh/jcgtp/servo065.stm");
  setAlmDlg(ALMDLG_SYST035.ID, ALMDLG_SYST035.CODE, "/frh/jcgtp/system035.stm");
  if (top.g_startmd != CTRLSTART) {
    setAlmDlg(ALMDLG_SYST266.ID, ALMDLG_SYST266.CODE, "/frh/jcgtp/system266.stm", DISP_CLOSE_BTN);
  }
  

  // Payload Confirmation alarm.
  for (var i = 0; i < ALMDLG_PAYLOAD_CONF.length; i++) {
    var almSpec = ALMDLG_PAYLOAD_CONF[i];
    setAlmDlg(almSpec.ID, almSpec.CODE, "/frh/jcgtp/system374.stm");
    var almDlgId = 'almDlg_' + getAlmCode(almSpec.ID, almSpec.CODE);
    var almDlgElm = top.document.getElementById(almDlgId);
    almDlgElm.style.visibility = 'hidden';
  }

  // Shift Reset and Chain Reset alarm.
  for (var i = 0; i < ALMDLG_SHIFTRESET_FOR_DCS.length; i++) {
    var almSpec = ALMDLG_SHIFTRESET_FOR_DCS[i];
    setAlmDlg(almSpec.ID, almSpec.CODE, "/frh/jcgtp/shiftresetdlgdcs.stm");
  }
  for (var i = 0; i < ALMDLG_SHIFTRESET.length; i++) {
    var almSpec = ALMDLG_SHIFTRESET[i];
    setAlmDlg(almSpec.ID, almSpec.CODE, "/frh/jcgtp/shiftresetdlg.stm");
  }
  for (var i = 0; i < ALMDLG_CHAINRESET.length; i++) {
    var almSpec = ALMDLG_CHAINRESET[i];
    setAlmDlg(almSpec.ID, almSpec.CODE, "/frh/jcgtp/chainresetdlg.stm");
  }

  getErractF();
  function getErractF() {
    if(typeof irpDlgRes != 'undefined') {
      loadActiveErrorFile(getErract);
    } else {
      setTimeout(function(){
        getErractF();
      }, 500);
    }  
  }
});

var IRPROG_COL = {
  RED: 'rgba(240, 80, 0, 1)',
  YEL: 'rgba(255, 210, 80, 1)',
  CLR: 'rgba(0, 0, 0, 0)',
};

var almState = {
  lastMsg: '',  // Last alarm message (value of $ALM_IF.$LAST_ALM)
  lastSev: '',  // Severity of last alarm (1bit-8bit value of $ALM_IF.$LAST_ERCODE)
  lastID: '',   // Error ID of last alarm (10bit-22bit value of $ALM_IF.$LAST_ERCODE)
  lastCode: '', // Error code of the last alarm (23bit-32bit value of $ALM_IF.$LAST_ERCODE)
  maxSev: '',   // Severity of the most critical alarms 
  sevRedNum: 0, // Number of active alarms (9bit-16bit value of $ALM_IF.$SEV_AND_NOA)
  sevYelNum: 0, // Number of active alarms (17bit-24bit value of $ALM_IF.$SEV_AND_NOA)
  sevClrNum: 0, // Number of active alarms (25bit-32bit value of $ALM_IF.$SEV_AND_NOA)
  num: 0,       // active severty total number
  actAlmList:[],// active alarm list
  sevAndNoa:'', // $ALM_IF.$SEVANDNOA value.
};

// Const almState for backup.
var almStateBkup = {
  lastMsg: '',  // Last alarm message (value of $ALM_IF.$LAST_ALM)
  lastSev: '',  // Severity of last alarm (1bit-8bit value of $ALM_IF.$LAST_ERCODE)
  lastID: '',   // Error ID of last alarm (10bit-22bit value of $ALM_IF.$LAST_ERCODE)
  lastCode: '', // Error code of the last alarm (23bit-32bit value of $ALM_IF.$LAST_ERCODE)
  maxSev: '',   // Severity of the most critical alarms 
  sevRedNum: 0, // Number of active alarms (9bit-16bit value of $ALM_IF.$SEV_AND_NOA)
  sevYelNum: 0, // Number of active alarms (17bit-24bit value of $ALM_IF.$SEV_AND_NOA)
  sevClrNum: 0, // Number of active alarms (25bit-32bit value of $ALM_IF.$SEV_AND_NOA)
  num: 0,       // active severty total number
  actAlmList:[],// active alarm list
  sevAndNoa:'', // $ALM_IF.$SEVANDNOA value.
};

var SEV_COL = {
  '10000000':IRPROG_COL.CLR,		// 'NONE'
  '00000000':IRPROG_COL.CLR,		// 'WARN'
  '00000010':IRPROG_COL.YEL,		// 'PAUSE.L'
  '00100010':IRPROG_COL.YEL,		// 'PAUSE.G'
  '00000110':IRPROG_COL.YEL,		// 'STOP.L'
  '00100110':IRPROG_COL.YEL,		// 'STOP.G'
  '00110110':IRPROG_COL.RED,		// 'SERVO'
  '00111011':IRPROG_COL.RED,		// 'SERVO2'
  '00001011':IRPROG_COL.RED,		// 'ABORT.L'
  '00101011':IRPROG_COL.RED,		// 'ABORT.G'
  '01111011':IRPROG_COL.RED,		// 'SYSTEM'
};

// Get alarm reset button text.
function getResetLang(){
  var resetResrc = {
    "jp" : "アラーム解除",
    "ch" : "报警解除",
    "default": "RESET",
  };
  var curLang = top.irprogapi.getCurrentLanguage();
  if(!(curLang == 'jp' || curLang == 'ch' )) {
    curLang = 'default';
  }
  return resetResrc[curLang];
}

// ---- alarm event ----
function almVarEvent(event, progName, varName, typeCode, valStr) {
  if (varName === '$ALM_IF.$LAST_ERCODE') {
    var erCodeBin = (('00000000000000000000000000000000' + (Number(valStr) >>> 0).toString(2)).slice(-32));
    almState.lastSev = erCodeBin.slice(0, 8);
    almState.lastID = erCodeBin.slice(9, 22);
    almState.lastCode = erCodeBin.slice(22);
    // for statbar
    setAlmArea();
    // for diarog
    var lastAlmCode = almState.lastID + '_' + almState.lastCode;
    if (isSys374AlmCode(lastAlmCode)) {
      top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$PLDCFM_DONE', getPldCfmDoneCB, lastAlmCode);
    } else {
      dispAlmDlg(lastAlmCode, true);
    }
    dispAlmToast(lastAlmCode);

    // for TabletTP app
    if (top.isTabTP()) {
      for (var i = 0; i < ALM_FINISHED_UPD.length; i++) {
        var almCode = getAlmCode(ALM_FINISHED_UPD[i].ID, ALM_FINISHED_UPD[i].CODE);
        if (almCode == lastAlmCode) {
          try {
            if (Number(android.ApiTabTPVersion()) >= 1.13) {
              if (Number(android.ApiTabTPVersion()) >= 1.26) {
                android.ApiFinishedUpdate(i);
              } else {
                android.ApiFinishedUpdate();
              }
            }
          } catch (e) { }
          return;
        }
      }
    }
  } else if (varName === '$ALM_IF.$LAST_ALM') {
    almState.lastMsg = valStr;
    if ((almState.lastMsg.indexOf('-INST_EXT_PALLET') >= 0) && (almState.lastMsg.indexOf(((top.irprogapi.getCurrentLanguage() == 'jp') ? 'ｼﾞｯｺｳ' : 'INTP') + '-302') >= 0)) {
      top.openCmpAlert(window, 'inst302Alert', top.irpDlgRes["inst302Alert"]);
    }
    if (almState.lastMsg.indexOf(((top.irprogapi.getCurrentLanguage() == 'jp') ? 'ｻｰﾎﾞ' : 'SRVO') + '-514') >= 0) {
      var alarmMsg = almState.lastMsg;
      var orgMsg = top.irpDlgRes["toastServo514"];
      var axisNum = alarmMsg.match(/\d+\)$/)[0].replace(')',"");
      var toastMsg = orgMsg.replace(/{AxisNum}/g, axisNum);
      top.IHMIComponents.cf.toast.show(toastMsg);
    }
    // for statbar
    setAlmArea();
  } else if (varName === '$ALM_IF.$SEV_AND_NOA') {
    var sevNoaBin = ('00000000000000000000000000000000' + (Number(valStr)).toString(2)).slice(-32);
    almState.sevRedNum = parseInt(sevNoaBin.slice(9, 16),2);
    almState.sevYelNum = parseInt(sevNoaBin.slice(17, 24),2);
    almState.sevClrNum = parseInt(sevNoaBin.slice(25, 32),2);
    almState.sevAndNoa = valStr;
    // Set max severty.
    if(almState.sevRedNum > 0) {
      almState.maxSev = IRPROG_COL.RED;
    } else if(almState.sevYelNum > 0) {
      almState.maxSev = IRPROG_COL.YEL;
    } else {
      almState.maxSev = IRPROG_COL.CLR;
    }

    // Set active alarm total num.
    almState.num = almState.sevRedNum + almState.sevYelNum;

    // for statbar
    setAlmArea();
  }
}

function dispAlmDlg(almCode, byAlarm) {
  var almDlgId = '#almDlg_' + almCode;
  if (($(almDlgId).length) && ($(almDlgId).css('display') == 'none')) {
    // Add language info
    var almDlgElem = document.getElementById('almDlg_' + almCode);
    var inputElem = almDlgElem.contentDocument.getElementsByTagName('input');
    var htmPath = inputElem[0].value;
    var htmRoot = htmPath.slice(0, -4);
    var htmEx = htmPath.slice(-4);
    var lang = top.irprogapi.getCurrentLanguage();
    lang = ((lang == "jp") ? "kn" : lang);
    var almContSrc = htmRoot + lang + htmEx;

    $.ajax({
      url: almContSrc,
      cache: false,
      async: false

    }).done(function (xml_data) {
      createAlmDlg(almCode, almContSrc, byAlarm);

    }).fail(function (xmlhttprequest, textstatus, errorthrown) {
      console.log(xmlhttprequest);
      console.log(textstatus);
      console.log(errorthrown);
      
      almContSrc = htmRoot + 'eg' + htmEx;
      $.ajax({
        url: almContSrc,
        cache: false,
        async: false

      }).done(function (xml_data) {
        createAlmDlg(almCode, almContSrc, byAlarm);

      }).fail(function (xmlhttprequest, textstatus, errorthrown) {
        console.log(xmlhttprequest);
        console.log(textstatus);
        console.log(errorthrown);
      });
    });

    
  }
}

var popFrmObj = {};
function notifyLoadCmpDlg(popFrm) {
  var almDlg = popFrm.parent.parent.frameElement;
  popFrmObj[almDlg.id] = popFrm.parent.ihcpPopupFrm;
}

function createAlmDlg(almCode, almSrc, byAlarm) {
  var almDlgId = 'almDlg_' + almCode;
  // Show alarm dialog.
  $('#' + almDlgId).css({ "display": "block" });

  // Set component dialog.
  var fileName = almSrc.split( '/' );
  var pathNum = fileName[0] == '' ? 1 : 0;
  var filePath = fileName[pathNum] + ':\\\\';
  for (var i = pathNum + 1; i < fileName.length - 1; i++) {
    filePath += fileName[i] + '\\\\';
  }
  filePath += fileName[i];
  var dlgData = {
    almDlgId : almDlgId,
    iframe   : document.getElementById(almDlgId).contentWindow,
    almSrc   : almSrc,
    filePath : filePath,
    headText: undefined,
    appendArg : {
      byAlarm : (byAlarm ? true : false),
    }
  };
  top.irprogapi.getXML(dlgData.almSrc, dispCmpAlm, dlgData);
}

function dispCmpAlm(status, XML, dlgData) {
  if(status != IO_SUCCESS) {
    console.log("getXHR error");
  } else {
    // Set the dialog head text.
    var ttlEle = XML.head.getElementsByTagName('title');
    if(ttlEle.length > 0) {
      dlgData.headText = ttlEle[0].text;
    }

    // Set the dialog size.
    var styleEle = XML.body.getElementsByTagName('style');
    if(styleEle.length > 0) {
      var styleObj = (styleEle[0].innerHTML.replace(/\s+/g,"").trim()).split('}');
      var bodyText = '';
      for(var i = 0; i < styleObj.length; i++) {
        if(styleObj[i].indexOf('body') >= 0){
          bodyText = styleObj[i].replace('body{', '');
          break;
        }
      }
      if(bodyText != ''){
        var bodyArr = bodyText.split(';');
        var dlgSize = '';
        for(var i = 0; i < bodyArr.length - 1; i++){
          bodyArr[i] = bodyArr[i].split(':');
          var key = bodyArr[i][0];
          var value = bodyArr[i][1];
          if(key.indexOf('height') >= 0) {
            var bodyH = (value.indexOf('px') >= 0 ? value.replace('px','') : value);
            var headH = (dlgData.headText != undefined) ? '74' : '54';
            value = Number(bodyH) + Number(headH) + 'px';
          }
          dlgSize += '"' + key + '":"' + value + '",';
        }
        dlgSize = '{' + dlgSize.replace(/.$/,'') + '}';
        dlgData.size = $.parseJSON(dlgSize);
      }
    }
  }
  var isHideCloseBtn = true;
  var almDlgEle = (dlgData.iframe).document;
  var closeBtnData = almDlgEle.getElementsByClassName('dlgCloseBtn')[0];
  if(closeBtnData && closeBtnData.value == DISP_CLOSE_BTN) {
    isHideCloseBtn = false;
  }
  top.openCmpPupAppendFrm(dlgData.iframe, dlgData.almSrc, dlgData.appendArg, dlgData.headText, isHideCloseBtn, dlgData.size, notifyLoadCmpDlg);
}

//---- CRX statbar alarm ----
// FILE NAME
var ERRACT = 'ERRACT.LS';
var ERRALL = 'ERRALL.LS';

// ALARM Interval Time
var INDEX_NO = 0;  // number
var INDEX_MSG = 2; // error message
var INDEX_SEV = 4; // severty

var langEncoding = { null: 'UTF-8', 'eg': 'UTF-8', 'jp': 'Shift-JIS', 'kn': 'Shift-JIS', 'ch': 'gb2312', 'gr': 'ISO-8859-1', 'it': 'ISO-8859-1', 'fr': 'ISO-8859-1', 'tw': 'Big5', 'sp': 'ISO-8859-1'};

// Create alarm message row.
function createrow() {
  var empty = {};
  empty.index = "";
  empty.code = "";
  empty.message = "";
  empty.sev = "";
  return empty;
}

function resizeAlm(){
  setAlmAreaMaxH();
  setAlmMsgCss();
}

function setAlmAreaMaxH(){
  if(($('#almArea').length == 0) || ($('#almOpenCloseBtn').length == 0)){
    return;
  }
  var almAreaMax_h = $('#mainfunc_area').height() + 'px';
  $('#almArea').css({
    'max-height': (($('#almOpenCloseBtn').hasClass('almClose')) ? '38px' : almAreaMax_h),
  });
}

// click alarm reset button event
function clickAlmReset() {
  // Prevent reset-button bashing.
  $('#almReset').css({ 'pointer-events': 'none' });

  top.sendKey("Reset", 1);
  top.sendKey("Reset", 0);

  // Get ERRACT.LS
  loadActiveErrorFile(getErract);

  setTimeout(function () {
    $('#almReset').css({ 'pointer-events': 'auto' });
  }, 500);
}

function getErract(almList) {
  function isOcrAlm( ID, CODE){
    for(var i = 0; i < almList.length; i++){
      var almCode = almList[i].code.replace(/[^0-9]/g, '');
      var almId = almList[i].code.slice( 0, -(almCode.length + 1) );
      if((ID == almId) && (String(CODE) == almCode) ){
        return true;
      }
    }
    return  false;
  }

  for (var i = 0; i < ALMDLG_PAYLOAD_CONF.length; i++) {
    var almSpec = ALMDLG_PAYLOAD_CONF[i];
    if(isOcrAlm(irpDlgRes.SYSTEM, almSpec.CODE)){
      top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$PLDCFM_DONE', getPldCfmDoneCB, getAlmCode(almSpec.ID, almSpec.CODE));
      return;
    }
  }
  // If there are no alarms corresponding to "ALMDLG_PAYLOAD_CONF" during the initial start-up, "Collaborative Speed Limit Popup" will not be displayed in the future.
  initPldConfChecked = false;
}

function isSys374AlmCode(almCode) {
  var system374AlmCode = getAlmCode(ALMDLG_PAYLOAD_CONF[0].ID, ALMDLG_PAYLOAD_CONF[0].CODE);
  var system326AlmCode = getAlmCode(ALMDLG_PAYLOAD_CONF[1].ID, ALMDLG_PAYLOAD_CONF[1].CODE);
  return (almCode == system374AlmCode || almCode == system326AlmCode);
}

function getPldCfmDoneCB(ioType, ioIndex, pldCfmDone, almCode, chkStatus) {
  if (!(pldCfmDone == 'TRUE')) {
    if (top.g_crx && initPldConfChecked) {
      top.rpcmc_getVar(top.SYSNAME_C, '$DCSS_CLLB[1].$SPD_LIM', getSpdLimCB, almCode);
    } else {
      dispAlmDlg(almCode, true);
    }
  }
  initPldConfChecked = false;
}

function getSpdLimCB(progname, varname, typecode, spdLimNum, almCode, cbarg2) {
  if (Number(spdLimNum) == 750) { // init = 750mm/sec
    top.rpcmc_getVar(top.SYSNAME_C, '$TABUI_SCRN.$NOSHOSPDLIM', getNoShoSpdLim, almCode);
  } else {
    dispAlmDlg(almCode, true);
  }
}

function getNoShoSpdLim(progname, varname, typecode, isNoshoSpdLim, almCode, cbarg2) {
  if (!JSON.parse(isNoshoSpdLim.toLowerCase())) { // FALSE:unchecked, TRUE:checked
    var appendArg = { almCode: almCode };
    top.openCmpPupAppendFrm(top.window, "/frh/jcgtp/spdlimconfdlg.stm", appendArg, null, true, { width: "680px", height: "400px"});
  } else {
    dispAlmDlg(almCode, true);
  }
}

// click alarm open/close button event
function clickAlmOpenClose() {
  var openCloseBtnElem = top.document.getElementById("almOpenCloseBtn");

  if($('#almOpenCloseBtn').hasClass("almOpen")){
    // open -> close
    openCloseBtnElem.className = "almClose";
    almState.actAlmList = [];
    almStateBkup.actAlmList = [];
  } else {
    // close -> open
    openCloseBtnElem.className = "almOpen";
  }
  setAlmArea();
  setAlmAreaMaxH();
}

function setAlmArea(langChged) {
  var newAlmArea = $("<div>", { "id": "almArea" });  
  if(almState.num == 0 && almState.sevClrNum == 0){
    // for none alarm
    almState.actAlmList = [];
    $('#almArea').remove();
    $('#almReset').remove();
    $('#almOpenCloseBtn').remove();
  } else {
    // Create alarm display Area.
    if($('#almArea').length == 0){
      newAlmArea.css({ "max-height": "38px", });
    } else {
      newAlmArea = $('#almArea');
      setAlmAreaMaxH();
    }
    newAlmArea.css({
      "border-top": "3px solid " + almState.maxSev,
      "font-family": top.getDefFont(),
      "display": (top.statbar.location.href.indexOf('tabtp') < 0) ? "none" : "block",
    });
    
    // Create alarm area open/close button.
    var openCloseBtnElem = top.document.getElementById("almOpenCloseBtn");
    if((almState.num >= 2 ||
       (almState.num == 1 && (almState.sevClrNum > 0 && SEV_COL[almState.lastSev] == IRPROG_COL.CLR )))){
      if(openCloseBtnElem == null){
        var almOpenCloseBtn = $("<button>", {"id": "almOpenCloseBtn", "class":"almClose","src":"arrow_d.png", "ondragstart": "return false", });
        newAlmArea.append(almOpenCloseBtn);
      }
    } else {
      $('#almOpenCloseBtn').remove();
    }
    
    // Create reset button.
    var resetBtnElem = top.document.getElementById("almReset");
    var isArmReset = false;
    if(resetBtnElem == null) {
      var resetbtn = $("<button>", { "id": "almReset" });    
      var text = $("<div>");
      text.text(getResetLang());
      resetbtn.append(text);
      newAlmArea.prepend(resetbtn);
    } else {
      if (langChged) {
        resetBtnElem.getElementsByTagName("div")[0].textContent = getResetLang();
      }
      if (getComputedStyle(resetBtnElem,null).getPropertyValue("pointer-events") == "none") {
        isArmReset = true;
      }
    }
    $('#mainfunc_area').prepend(newAlmArea);
    openCloseBtnElem = top.document.getElementById("almOpenCloseBtn");
    resetBtnElem = top.document.getElementById("almReset");

    // Set click event for alarm reset button.
    if(resetBtnElem != null){
      resetBtnElem.onclick = clickAlmReset;
      if (isArmReset == true) {
        $('#almReset').css({ "pointer-events": "none" });
        setTimeout(function () {
          $('#almReset').css({ "pointer-events": "auto" });
        }, 500);
      }
    }
    // Set click event for alarm open/close button.
    if(openCloseBtnElem != null &&
      (almState.num >= 2 ||
      (almState.num == 1 && (SEV_COL[almState.lastSev] == IRPROG_COL.CLR && almState.sevClrNum > 0)))){
      openCloseBtnElem.onclick = clickAlmOpenClose;
    }

    // Set Alarm message and severty color.
    if($('#almOpenCloseBtn').hasClass('almOpen')){
      // Get ERRACT.LS
      if(almStateBkup.sevAndNoa != almState.sevAndNoa ||
         almState.actAlmList.length == 0 ||
         langChged) {
        $.extend(true, almStateBkup, almState);
        loadActiveErrorFile();
      }
    } else {
      setAlmMsg();
    }
  }
}

function setAlmMsg(){
  if(almState.lastMsg == ''){
    return;
  }
  if($('#almOpenCloseBtn').hasClass('almOpen')){
    return;
  }

  // Remove old alarm.
  $('.almRow').remove();
  // Split message and code.
  var almText = {
    code: '',
    message:''
  };
  almText.code = almState.lastMsg.substring(0, almState.lastMsg.indexOf(" ")).trim();
  almText.message = almState.lastMsg.substring(almState.lastMsg.indexOf(" "), almState.lastMsg.length).trim();
  almText.message = ' ' + almText.message;
  var almRowElem = makeAlmMsg(0, almText.code, almText.message);
  // Append in the part that displays the alarm.
  $('#almArea').append(almRowElem);
  setAlmMsgCss();
  setAlmSev();
}

// Make message element.
function makeAlmMsg(almIndex, almCode, almMsg, almSev){
  var almRowElem = $("<div>", {"class": "almRow"});
  var almMsgPrnElem;
  if(almIndex == 0){
    almMsgPrnElem = $("<div>", {"class": "almMsgParent"});
  } else {
    almMsgPrnElem = $("<div>", {"class": "almMsgParent multiAlm"});
  }

  // Set alarm code.
  var codeElem = $("<span>",{ "class": 'almCode', });
  codeElem.text(almCode);
  if(almSev){
    codeElem.css({
      "color": ((SEV_COL[almSev] == IRPROG_COL.YEL) ? 'black' : 'white'),
      "background-color": SEV_COL[almSev],
    });
  }
  // Set alarm message.
  var msgEle = $("<span>",{ "class": 'almMsg', });
  msgEle.text(almMsg);
  almMsgPrnElem.append(codeElem);
  almMsgPrnElem.append(msgEle);
  almRowElem.append(almMsgPrnElem);

  return almRowElem;
}

// Set alarm message position calculation.
function setAlmMsgCss(){
  var BTN_MARGIN = 8;
  var almAreaElem = top.document.getElementById('almArea');

  if ((top.is_key_open) &&
    (top.getUICfg() == top.UI_CFG.DBG_CRX) &&
    (top.$("#home").css("z-index") == "1")) {
    var almLeft = ((parent.$("#treebtn").css('display') == 'none') ? $("#treemod", parent.document).outerWidth() + "px" : "0px");
      $('#almArea').css({ 'width': top.$("#home").width() + 2 + 'px', 'left': almLeft });
  } else {
      $('#almArea').css({ 'width': $('#mainfunc_area').width() + 'px', 'left' : '' });
  }

  var almCodeElem = top.document.getElementsByClassName('almCode');
  var almMsgElem = top.document.getElementsByClassName('almMsg');
  var almResetElem = top.document.getElementById('almReset');
  var almOpenCloseBtnElem = top.document.getElementById('almOpenCloseBtn');
  
  var resetbtn_w = almResetElem.offsetWidth;
  var almopnClsBtn_w = (almOpenCloseBtnElem != null ? almOpenCloseBtnElem.offsetWidth : 0);
  var btn_w = resetbtn_w + almopnClsBtn_w + BTN_MARGIN;
  var text_w = almCodeElem[0].offsetWidth + almMsgElem[0].offsetWidth;

  var leftPos = ((almAreaElem.offsetWidth - btn_w) - text_w) / 2;
  leftPos = (leftPos < 0) ? 2 : leftPos;

  var almMsgParent_w = 'calc(100% - ' + (leftPos + btn_w) + 'px)';
  var almMsgMultiParent_w = 'calc(100% - ' + (leftPos) + 'px)';

  $('.almMsgParent').css({
    'left': leftPos + 'px',
    'width': almMsgParent_w,
  });

  $('.multiAlm').css({
    'left': leftPos + 'px',
    'width': almMsgMultiParent_w,
  });

}

function setAlmSev(){
  if(almState.lastMsg == ''){
    return;
  }

  if($("#almOpenCloseBtn").hasClass('almOpen')){
    return;
  }
  $('.almCode').css({
     "color": ((SEV_COL[almState.lastSev] == IRPROG_COL.YEL) ? 'black' : 'white'),
      "background-color": SEV_COL[almState.lastSev],
   });

}

// Load Active Error File(ERRACT.LS)
function loadActiveErrorFile(callback) {
  loadFile(ERRACT, loadErrorFileCallback, callback);
}

// Load All Error File(ERRALL.LS)
function loadAllErrorFile(callback) {
  loadFile(ERRALL, loadErrorFileCallback, callback);
}

// CallBack (Load Error File)
function loadErrorFileCallback(status, fileName, fileText, lineCount, callback) {

  if (status != IO_SUCCESS) {
    // put dialog
    document.body.style.cursor = 'auto';
    return;
  }
  // file data convert & get
  convertLSData(fileText, lineCount, callback);
}

// convert Text Data (IN)textData, lineCount
function convertLSData(textData, lineCount, callback) {
  var bytesArray = [];
  var text = "";
  var blobData = [];
  var sendDataArray = []; // Send all data at once.
  var CODECRLF = '\r\n';

  if (lineCount > 0) { // If online data read, need to decode.
    for (var txtIdx = 0; txtIdx < textData.length; txtIdx++) {
      text = window.atob(textData[txtIdx].buf) + CODECRLF;
      bytesArray = [];
      for (var convIdx = 0; convIdx < text.length; convIdx++) {
        var tempCharCode = text.charCodeAt(convIdx);
        if (tempCharCode > 0x00) { // Not null character
          bytesArray.push(tempCharCode);
        }
      }
      Array.prototype.push.apply(sendDataArray, bytesArray);
    }
    blobData[0] = new Blob([new Uint8Array(sendDataArray)]);
    var reader = new FileReader();
    reader.addEventListener("loadend", function () {
      var filelines = reader.result.split(CODECRLF);
      parseErrorFileCallBack(filelines, callback);
    });
    reader.readAsText(blobData[0], langEncoding[top.irprogapi.getCurrentLanguage()]);

  } else { // For offline reading No need to decode.
    parseErrorFileCallBack(textData, callback);
  }
}

// Parse Error text data
function parseErrorFileCallBack(fileLines, callback) {
  if (fileLines[0].indexOf(ERRACT) == -1 &&
      fileLines[0].indexOf(ERRALL) == -1) {
    if (callback == undefined){
      setTimeout(function() {
        loadActiveErrorFile(callback);
      }, 500);
    }
    return;
  }
  var linebuff = [];
  for (var i = 0; i < fileLines.length; i++) {
    // Get 1 line data
    var line = fileLines[i];

    if ((i == 0) || (line == "") || (line === undefined)) {
      // Header
    } else {
      var data = line.split('"');
      var newline = createrow();
      newline.index = data[INDEX_NO]; // Index
      // Get error code and error message
      temp = data[INDEX_MSG].trim();
      if (temp.indexOf('-') == -1) {
        newline.code = temp; // Code Message(no Alarm Code)
      } else {
        newline.code = temp.substring(0, temp.indexOf(' ')); // Alarm Code
        newline.message = temp.substring(temp.indexOf(' ')).trim(); // Message
        newline.message = ' ' + newline.message;
      }
      // Get severty
      temp = data[INDEX_SEV].trim();
      var levelbit = '';
      if (temp.indexOf(' ') == -1) {
        levelbit = temp; // Level Bit(No Alarm Level)
      } else {
        // set Alarm Level (binary)
        var levelText = (temp.substring(0, temp.indexOf(" "))).length;
        newline.sev = (temp.substring(levelText, temp.length)).trim();
      }
      linebuff.push(newline);
    }
  }
  // for alarm reset
  if(callback != undefined) {
    callback(linebuff.concat());
    return;
  }
  if (linebuff.length != 0) {
    var flgArray = [];
    var errDiff = false;
    if (almState.actAlmList.length == linebuff.length && almState.actAlmList.length > 0) {
      for (var i = 0; i < almState.actAlmList.length; i++){
        for (var j = 0; j < linebuff.length; j++){
          if (almState.actAlmList[i].index === linebuff[j].index && almState.actAlmList[i].message === linebuff[j].message) {
            flgArray.push(true);
            break;
          }
        }
      }
      if (flgArray.length != linebuff.length) {
        errDiff = true;
      }
      if (!errDiff) {return;}
    } else {
      errDiff = true;
    }

    if (errDiff && $('#almOpenCloseBtn').hasClass('almOpen')) {
      // oldalarm remove
      $('.almRow').remove();
      almState.actAlmList = linebuff.concat();
      // append alarm Message
      for(var l = 0; l < linebuff.length; l++){
        almRowElem = makeAlmMsg(l, linebuff[l].code, linebuff[l].message, linebuff[l].sev);
        $('#almArea').append(almRowElem);
        setAlmMsgCss();
      }
    }
  }
  return;
}

//---- alarm daialog ----
function setAlmDlg(almId, almNum, almPath, dlgCloseBtn) {
  if (almId == null) {
    return false;
  } else if (almNum == null) {
    return false;
  } else if (almPath == null) {
    return false;
  }
  // Set alarm dialog object
  var almCode = getAlmCode(almId, almNum);
  var almDlgId = '#almDlg_' + almCode;
  var isAlmDisp = false;

  if ($(almDlgId).length) {
    if ($(almDlgId).css('display') == 'block') {
      isAlmDisp = true;
    }
    delAlmDlg(almId, almNum);
  }

  // Make dialog frame
  var $dlgFrame = $('<iframe>', { 'id': 'almDlg_' + almCode, 'class': 'almdlgs almmsgpopup'});
  $('body').append($dlgFrame);

  // Add input data
  var $dlgData = $('<input>', { 'class': 'almDlgInput', 'name': "almHidden_" + almCode, 'type': 'hidden', 'value': almPath});
  $('#almDlg_' + almCode).contents().find('body').append($dlgData);
  $('#almDlg_' + almCode).contents().find('body').css("margin", "0");
  if(dlgCloseBtn) {
    var $dlgCloseBtn = $('<input>', { 'class': 'dlgCloseBtn', 'type': 'hidden', 'value': dlgCloseBtn});
    $('#almDlg_' + almCode).contents().find('body').append($dlgCloseBtn);
    $('#almDlg_' + almCode).contents().find('body').css("margin", "0");
  }
  
  // Add compornent css file.
  var $linkData = $('<link>', { 'rel': 'stylesheet', 'type': 'text/css', 'href': '/frh/ihmi/ihmicomponenttopfrm.css?version=V0.0000'});
  $('#almDlg_' + almCode).contents().find('head').append($linkData);
  $linkData = $('<link>', { 'rel': 'stylesheet', 'type': 'text/css', 'href': '/frh/ihmi/ihmicomponentscrollbar.css?version=V0.0000'});
  $('#almDlg_' + almCode).contents().find('head').append($linkData);

  if (isAlmDisp) {
    if (isSys374AlmCode(almCode)) {
      top.rpcmc_chkkey(null, top.mor_ss_c, top.SYSNAME_C, '$DCSS_CLLB2[1].$PLDCFM_DONE', getPldCfmDoneCB, almCode);
    } else {
      dispAlmDlg(almCode, true);
    }
  } else {
    $(almDlgId).css("display", "none");
  }
  return true;
}

function getAlmCode(almId, almNum) {
  var almIdBin = ('0000000000000' + (Number(almId)).toString(2)).slice(-13);
  var facNext = almIdBin.slice(0, -7);
  var facPre = almIdBin.slice(-7);
  var facCode = facPre + facNext;
  var almNumBin = ('0000000000' + (Number(almNum)).toString(2)).slice(-10);
  var almCode = facCode + '_' + almNumBin;
  return almCode;
}

function hideAlmDlg(almId, almNum) {
  if (almId == null) {
    return false;
  } else if (almNum == null) {
    return false;
  }
  var almDlgId = 'almDlg_' + getAlmCode(almId, almNum);
  popFrmObj[almDlgId].removePopupFrame();
  $('#' + almDlgId).css("display", "none");

  var almDlgExist = document.getElementsByClassName('almdlgs');
  for (var i = 0; i < almDlgExist.length; i++) {
    if (almDlgExist[i].style.display == 'block') {
      return true;
    }
  }
  return true;
}

function delAlmDlg(almId, almNum) {
  if (almId == null) {
    return false;
  } else if (almNum == null) {
    return false;
  }
  var almDlgId = 'almDlg_' + getAlmCode(almId, almNum);
  if (popFrmObj[almDlgId] != undefined) popFrmObj[almDlgId].removePopupFrame();
  var almDlg = document.getElementById(almDlgId);
  almDlg.parentNode.removeChild(almDlg);
  var almDlgExist = document.getElementsByClassName('almdlgs');
  if (almDlgExist.length) {
    for (var i = 0; i < almDlgExist.length; i++) {
      if (almDlgExist[i].style.display == 'block') {
        return true;
      }
    }
  }
  return true;
}

// for TabletTP app
function notifyAlarmForTabTP(almList) {
  var finUpdId = (top.irprogapi.getCurrentLanguage() == 'jp') ? 'ｼｽﾃﾑ' : 'SYST';
  for (var i = 0; i < ALM_FINISHED_UPD.length; i++) {
    if (isFinUpd(finUpdId, ALM_FINISHED_UPD[i].CODE)) {
      try {
        if (Number(android.ApiTabTPVersion()) >= 1.26) {
          android.ApiFinishedUpdate(i);
        } else {
          android.ApiFinishedUpdate();
        }
      } catch (e) { }
      return;
    }
  }
  function isFinUpd(ID, CODE) {
    for (var i = 0; i < almList.length; i++) {
      var actCode = almList[i].code.replace(/[^0-9]/g, '');
      var actId = almList[i].code.slice( 0, -(actCode.length + 1));
      if ((ID == actId) && (String(CODE) == actCode) ) return true;
    }
    return  false;
  }
}
function getErrAll() {
  if (top.isTabTP()) {
    try {
      if (Number(android.ApiTabTPVersion()) >= 1.13) {
        loadAllErrorFile(notifyAlarmForTabTP);
      }
    } catch (e) {}
  }
}

//---- alarm toast ----
function setAlmToast(almId, almNum, toastMsg) {
  if (almId == null || almNum == null) return false;
  var almCode = getAlmCode(almId, almNum);
  // make a toast frame.
  var $dlgFrame = $('<iframe>', { 'id': 'almToast_' + almCode });
  $('body').append($dlgFrame);
  $('#almToast_' + almCode).css("display", "none");
  $('#almToast_' + almCode).contents().find('body').html(toastMsg);
}

function dispAlmToast(almCode) {
  var tagAlmToast = $('#almToast_' + almCode);
  if (tagAlmToast.length == 0) return;
  var toastMsg = $('#almToast_' + almCode).contents().find('body').html();
  top.IHMIComponents.cf.toast.show(toastMsg);
}

//---- alarm monitor ----
function startAlmMon() {
  top.irprogapi.setCurrentLanguage(getErrAll);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$LAST_ERCODE', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$LAST_ALM', 100);
  top.rpcmc_startVarMonitor(top.SYSNAME_C, '$ALM_IF.$SEV_AND_NOA', 100);
  top.jQuery.varlis.bind('VarEvent', null, almVarEvent);
}

$(window).on("pagehide", function () {
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$LAST_ERCODE', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$LAST_ALM', 100);
  top.rpcmc_stopVarMonitor(top.SYSNAME_C, '$ALM_IF.$SEV_AND_NOA', 100);
  top.jQuery.varlis.unbind('VarEvent', almVarEvent);
});