var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*!  Indicate to include this header
********************* Do not edit JavaScript file *********************
********** FRCWebGL is a file generated from typescript source *******
***********************************************************************
 *
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *
 *           All Rights Reserved
 *           Copyright (C)   2017
 *           FANUC Robotics America
 *           FANUC LTD Japan
 *
 *  +
 *  Module: various.ts   This is a generated file
 *
 *  Description:
 *
 *  Author: Various
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *
*/
var FRCIdent = (function () {
    function FRCIdent(scene, connect) {
        this.pushcount = 0;
        this.IDStack = new Array();
        this.NameStack = new Array();
        this.workstack = new Array();
        this.scene = scene;
        this.connect = connect;
    }
    FRCIdent.prototype.IntInit = function (id) {
        if (FRCDebug.dbglvl & DBGLVL_IDENT_C) {
            FRCDebug.log("Init " + id);
        }
        if (id.charAt(id.length - 1) == '/') {
            id = id.substr(0, id.length - 1);
        }
        var pushed = false;
        if (id.search('[$]') == 0) {
            var alias = id.substr(1, 99);
            var enddol = alias.search('[$]');
            alias = id.substr(1, enddol).toUpperCase();
            if (alias == "CID") {
                if (this.connect != undefined && this.connect.contid != undefined) {
                    this.IDStack[idx] = this.connect.contid;
                }
            }
            else {
                id = FRCIdent.GetDefine(this.scene, this.Stack2Name(), alias);
            }
        }
        if (id === undefined) {
            console.log("ID Is not defined");
        }
        else {
            var slash = id.search('[/]');
            if (slash == 0) {
                var subid = id.substring(1);
                this.IDStack = subid.split("/");
            }
            else {
                if (slash == -1) {
                    this.IDStack.push(id);
                    this.pushcount = 1;
                }
                else {
                    this.workstack = id.split("/");
                    this.pushcount = this.workstack.length;
                    for (var idx = 0; idx < this.workstack.length; idx++) {
                        this.IDStack.push(this.workstack[idx]);
                    }
                }
            }
            this.ResolveDefines();
            if (FRCDebug.dbglvl & DBGLVL_IDENT_C) {
                FRCDebug.log("Resolved " + this.Stack2Name());
            }
        }
    };
    FRCIdent.prototype.Initialize = function (id) {
        if (id == "$FP$") {
            id = "$FP$";
        }
        if (id == "/cell/$CID$/toolgrp1/$EOAT1$") {
            id = "/cell/$CID$/toolgrp1/$EOAT1$";
        }
        if (this.IDStack.length > 0) {
            this.NameStack.push(this.Stack2Name());
        }
        this.IntInit(id);
    };
    FRCIdent.prototype.Pop = function () {
        if (this.NameStack.length > 0) {
            var last_name;
            last_name = this.NameStack[this.NameStack.length - 1];
            this.IntInit(last_name);
            this.NameStack.pop();
        }
        else {
            this.IDStack.length = 0;
        }
    };
    FRCIdent.GetHost = function (level, scene, inid) {
        var object;
        var IDStack = inid.split("/");
        var object_id = "";
        var parent_id = "";
        for (var idx = 1; idx < IDStack.length; idx++) {
            object_id += "/" + IDStack[idx];
            if (idx != IDStack.length - 1) {
                parent_id += "/" + IDStack[idx];
            }
        }
        object = scene.GetObjectIf(object_id, parent_id);
        if (object == undefined && parent_id != "/") {
            if (level < 10) {
                object = FRCIdent.GetHost(level + 1, scene, parent_id);
            }
            else {
                console.log("Stack overflow");
            }
        }
        return object;
    };
    FRCIdent.PrepID = function (inid) {
        var dollar = inid.search('[$]');
        if (dollar >= 0) {
            var id = inid.substr(0, dollar - 1);
        }
        else {
            var id = inid;
        }
        return id;
    };
    FRCIdent.prototype.AddDefine = function (scene, inid, name, alias) {
        var id = FRCIdent.PrepID(inid);
        for (var idx = scene.robots.length - 1; idx >= 0; idx--) {
            if (id.search(scene.robots[idx].id) == 0) {
                var rail = id.substr(scene.robots[idx].id.length + 1);
                if (rail != "") {
                    alias = rail + '/' + alias;
                }
                id = scene.robots[idx].id;
                break;
            }
        }
        var object = FRCIdent.GetHost(0, this.scene, id);
        if (object != undefined) {
            object.defines.set(name, alias);
        }
    };
    FRCIdent.GetDefine = function (scene, inid, alias) {
        var newalias;
        var id = FRCIdent.PrepID(inid);
        var defaultid = "";
        for (;;) {
            var object = FRCIdent.GetHost(0, scene, id);
            if (object == undefined) {
                break;
            }
            newalias = object.defines.get(alias);
            if (newalias == undefined) {
                id = FRCIdent.ParentID(id);
                if (id == "") {
                    break;
                }
            }
            else {
                break;
            }
        }
        if (FRCDebug.dbglvl & DBGLVL_IDENT_C) {
            FRCDebug.log("Finding " + alias + " in " + id + " new " + newalias);
        }
        return newalias;
    };
    FRCIdent.prototype.Stack2Name = function () {
        var curr_name;
        curr_name = "/";
        for (var idx = 0; idx < this.IDStack.length; idx++) {
            if (this.IDStack[idx] == undefined) {
                return undefined;
            }
            curr_name += this.IDStack[idx] + "/";
        }
        curr_name = curr_name.substring(0, curr_name.length - 1);
        return curr_name;
    };
    FRCIdent.prototype.FullID = function () {
        this.ResolveDefines();
        var curr_name = this.Stack2Name();
        return curr_name;
    };
    FRCIdent.ParentID = function (id) {
        var curr_name;
        if (id == undefined) {
            return undefined;
        }
        else if (id == "") {
            return undefined;
        }
        else {
            var slash = id.search('[/]');
            if (slash == 0) {
                var subid = id.substring(1);
            }
            else {
                var subid = id;
            }
            var IDStack = subid.split("/");
            curr_name = "/";
            for (var idx = 0; idx < IDStack.length - 1; idx++) {
                curr_name += IDStack[idx] + "/";
                if (IDStack[idx] == undefined) {
                    if (FRCDebug.dbglvl & DBGLVL_IDENT_C) {
                        FRCDebug.log("[FRCXML4D] Parent ID undefined" + id);
                    }
                    return undefined;
                }
            }
            curr_name = curr_name.substring(0, curr_name.length - 1);
            return curr_name;
        }
    };
    FRCIdent.prototype.ResolveDefines = function () {
        var inner;
        for (var idx = 0; idx < this.IDStack.length; idx++) {
            if (this.IDStack[idx] == undefined) {
                console.log("Undefined stack element");
                continue;
            }
            if (this.IDStack.length > 50) {
                console.log("ID Stack overflow");
                break;
            }
            var dollar = this.IDStack[idx].search('[$]');
            if (dollar >= 0) {
                var alias = this.IDStack[idx].substr(dollar + 1, 99);
                var enddol = alias.search('[$]');
                alias = this.IDStack[idx].substr(dollar + 1, enddol).toUpperCase();
                if (alias == "CID") {
                    if (this.connect != undefined && this.connect.contid != undefined) {
                        this.IDStack[idx] = this.connect.contid;
                    }
                }
                else {
                    var value = FRCIdent.GetDefine(this.scene, this.Stack2Name(), alias);
                    if (value != undefined) {
                        if (value == "") {
                            for (inner = idx + 1; inner < this.IDStack.length; inner++) {
                                this.IDStack[inner - 1] = this.IDStack[inner];
                            }
                            this.IDStack.pop();
                            continue;
                        }
                        if (value.charAt(0) == "/") {
                            this.IDStack = value.substr(1).split("/");
                            break;
                        }
                        else {
                            var defines = value.split("/");
                            if (defines.length == 1) {
                                this.IDStack[idx] = defines[0];
                            }
                            else {
                                this.workstack.length = 0;
                                for (inner = 0; inner < idx; inner++) {
                                    this.workstack.push(this.IDStack[inner]);
                                }
                                for (inner = 0; inner < defines.length; inner++) {
                                    this.workstack.push(defines[inner]);
                                }
                                var processedidx = this.workstack.length;
                                for (inner = idx + 1; inner < this.IDStack.length; inner++) {
                                    this.workstack.push(this.IDStack[inner]);
                                }
                                this.IDStack.length = 0;
                                for (var idx = 0; idx < this.workstack.length; idx++) {
                                    this.IDStack.push(this.workstack[idx]);
                                }
                                idx = processedidx - 1;
                            }
                        }
                    }
                }
            }
        }
    };
    return FRCIdent;
}());
var FRCObject4d = (function () {
    function FRCObject4d(inid, scene, parent) {
        this.inited = false;
        this.groupset = false;
        this.podloc = false;
        this.axisflag = false;
        this.defines = new Map();
        this.group = new THREE.Group();
        this.group.HostObject = this;
        this.children = new Array();
        this.id = inid;
        this.group.name = inid;
        this.scene = scene;
        this.parent = parent;
        this.siz = new THREE.Vector3();
        this.spherecenter = new THREE.Vector3();
        this.spherecenter.x = undefined;
        this.loc = new THREE.Matrix4();
        this.invloc = new THREE.Matrix4();
        this.frameoff = new THREE.Matrix4();
        this.tagName = "OBJ4D";
        this.geometry = new THREE.Geometry();
        if (this.parent != undefined) {
            this.parent.add(this);
            this.parent.group.add(this.group);
        }
        else {
            if (inid != "/cell" && inid != "/menu" && inid != "/app") {
                console.log("[FRCObject4d] no parent " + inid);
            }
        }
    }
    FRCObject4d.prototype.InitObject = function (siz, loc, end, aid, fid, endid, tagname, setgroup) {
        this.tagName = tagname;
        if (loc != undefined) {
            this.loc = loc.clone();
            this.invloc.getInverse(this.loc);
            if (setgroup) {
                this.groupset = true;
                this.group.matrix = loc.clone();
                this.ApplyMatrix(this.frameoff);
            }
        }
        if (fid != undefined && fid != "") {
            if (fid != this.fid) {
                FRCFrame.UnSubscribe(fid, this);
                this.fid = fid;
                FRCFrame.Subscribe(fid, this);
            }
        }
        if (siz != undefined) {
            this.siz.x = siz.x;
            this.siz.y = siz.y;
            this.siz.z = siz.z;
        }
        else {
            this.siz.x = 1.0;
            this.siz.y = 1.0;
            this.siz.z = 1.0;
        }
        this.group.scale.x = this.siz.x;
        this.group.scale.y = this.siz.y;
        this.group.scale.z = this.siz.z;
        this.SetAid(aid);
        this.inited = true;
    };
    FRCObject4d.prototype.SetAid = function (aid) {
        this.aid = aid;
        if (aid !== undefined && aid != null) {
            var attribute = FRCAttribute.GetAttribute(this.aid);
            this.opacity = attribute.opac / 100;
        }
        else {
            this.opacity = undefined;
        }
    };
    FRCObject4d.prototype.EveryCall = function (loc, siz, visible, fid) {
        this.IntSetvis(visible, true);
        if (fid != undefined && fid != "") {
            if (fid != this.fid) {
                if (this.fid != null) {
                    FRCFrame.UnSubscribe(this.fid, this);
                }
                this.fid = fid;
                FRCFrame.Subscribe(fid, this);
            }
        }
        if (siz != undefined) {
            this.siz = siz.clone();
            this.group.scale.x = siz.x;
            this.group.scale.y = siz.y;
            this.group.scale.z = siz.z;
        }
        if (loc != undefined) {
            this.group.matrix = loc.clone();
            this.ApplyMatrix(this.frameoff);
        }
    };
    FRCObject4d.prototype.GroupSetvis = function (group, visible, rootflag) {
        if (rootflag) {
            group.visible = visible;
        }
        for (var idx = 0; idx < group.children.length; idx++) {
            this.GroupSetvis(group.children[idx], visible, true);
        }
    };
    FRCObject4d.prototype.IntSetvis = function (visible, rootflag) {
        if (rootflag) {
            this.group.visible = visible;
        }
        if (visible) {
            var parent = this.parent;
            for (; parent != undefined;) {
                parent.group.visible = true;
                parent = parent.parent;
            }
        }
        for (var idx = 0; idx < this.children.length; idx++) {
            this.children[idx].IntSetvis(visible, true);
        }
    };
    FRCObject4d.prototype.aidOK = function (aid) {
        return (aid == undefined || aid == null || aid == "" || this.aid == aid);
    };
    FRCObject4d.prototype.add = function (child) {
        this.children.push(child);
    };
    FRCObject4d.prototype.Animate = function () {
        if ((this.tagName = "SETPOD") || (this.tagName = "SETAXS")) {
            if (this.CheckPODStatus()) {
                this.scene.StopPolling(this);
                if (this.axis != undefined) {
                }
            }
            else if ((this.tagName = "SETSPR") || (this.tagName = "SETTXT")) {
                this.PositionUpdate();
            }
        }
    };
    FRCObject4d.prototype.NewAnchor = function () {
        this.Anchor = new FRCAnchor(this);
    };
    FRCObject4d.prototype.ANISET = function (json) {
        if (this.animation === undefined) {
            this.animation = new Array();
        }
        this.animation = JSON.parse(json);
    };
    FRCObject4d.prototype.ANIFRAME = function (index, x, y, z, w, p, r, v) {
        if (this.animation === undefined) {
            this.animation = new Array();
        }
        var item = new FRCAnimate();
        item.x = x;
        item.y = y;
        item.z = z;
        item.w = w;
        item.p = p;
        item.r = r;
        item.v = v;
        if (index !== undefined) {
            item.i = index;
        }
        else {
            item.i = this.animation[this.animation.length - 1].i + 1;
        }
        this.animation.push(item);
    };
    FRCObject4d.prototype.SyncAnimation = function (count) {
        var last_valid = 0;
        if (this.animation !== undefined) {
            this.jsonanim = JSON.stringify(this.animation);
            this.aindices = new Array();
            last_valid = 0;
            for (var idx = 0; idx < count; idx++) {
                this.aindices[idx] = last_valid;
                if (this.animation[last_valid].x !== undefined && this.animation[last_valid].loc === undefined) {
                    var a = this.animation[last_valid];
                    this.animation[last_valid].loc = new THREE.Matrix4();
                    FRCUtility.MatFromXYZWPR(a.x, a.y, a.z, a.w, a.p, a.r, this.animation[last_valid].loc);
                }
                if (this.animation.length > last_valid + 1) {
                    if (idx >= this.animation[last_valid + 1].i) {
                        last_valid++;
                    }
                }
            }
        }
    };
    FRCObject4d.prototype.AniClear = function () {
        this.animation = undefined;
        this.aindices = undefined;
    };
    FRCObject4d.prototype.AniFrame = function (frameidx) {
        if (this.animation !== undefined) {
            var item = this.animation[this.aindices[frameidx]];
            if (item !== undefined) {
                if (item.loc !== undefined) {
                    this.LOC(item.loc);
                }
                if (item.v !== undefined) {
                    if (item.v == 0) {
                        this.group.visible = false;
                    }
                    else {
                        this.group.visible = true;
                    }
                }
                if (item.siz !== undefined) {
                }
            }
        }
    };
    FRCObject4d.prototype.PositionUpdate = function () {
    };
    FRCObject4d.prototype.CheckPODStatus = function () {
        var geometry;
        var loaded;
        var canvas = FRCCanvas.getInstance();
        var podfile = canvas.globals.podfiles.get(this.URL);
        if (this.axisflag) {
            return true;
        }
        if ((podfile != undefined) && (podfile.IsLoaded)) {
            this.groupset = true;
            this.group.matrix.identity();
            podfile.InitPodGroup(this.group, undefined, this.opacity);
            if (this.fid != undefined) {
            }
            else {
                this.ApplyMatrix(this.loc);
            }
            loaded = true;
            this.scene.Render();
        }
        return loaded;
    };
    FRCObject4d.prototype.ApplyMatrix = function (matrix) {
        this.group.matrixAutoUpdate = false;
        this.group.applyMatrix(matrix);
        this.group.scale.x = this.siz.x;
        this.group.scale.y = this.siz.y;
        this.group.scale.z = this.siz.z;
        this.group.matrixAutoUpdate = true;
    };
    FRCObject4d.prototype.ApplyMatrix2 = function (matrix) {
        this.group.matrix = this.group.matrix.multiplyMatrices(this.group.matrix, matrix);
        this.group.matrix.decompose(this.group.position, this.group.quaternion, this.group.scale);
    };
    FRCObject4d.prototype.ApplyFrame = function (frameobj) {
        this.group.matrix = this.loc.clone();
        this.frameoff = frameobj.frame.clone();
        if (this.fid != undefined) {
            if ((this.fid.search('loc') == 0)) {
                this.ApplyMatrix2(frameobj.frame);
            }
            else {
                this.ApplyMatrix(frameobj.frame);
            }
        }
        console.log("Applying frame " + frameobj.id + " to " + this.id);
    };
    FRCObject4d.prototype.Order = function (geometry) {
        var attr = FRCAttribute.GetAttribute(this.aid);
        geometry.computeBoundingSphere();
        this.spherecenter = geometry.boundingSphere.center.clone();
        if (attr.opac < 100) {
            return geometry.boundingSphere.radius;
        }
        else {
            return 0;
        }
    };
    FRCObject4d.prototype.SETVIS = function (id, vis) {
        if (id != undefined) {
            var visible = vis != 0;
            var setroot = (id.charAt(id.length - 1) != "/");
            this.IntSetvis(visible, setroot);
        }
    };
    FRCObject4d.prototype.SETGN = function (id, loc, vis, aid, fid) {
        if (id != undefined) {
            if (!this.inited) {
                this.InitObject(undefined, loc, undefined, aid, fid, undefined, "SETGN", true);
            }
            this.EveryCall(loc, undefined, vis != 0, fid);
            if (vis == 0 && id == '/cell') {
                this.group.visible = true;
                var floor = this.scene.GetObject('/cell/floor', '/cell');
                this.GroupSetvis(floor.group, true, true);
            }
        }
    };
    FRCObject4d.prototype.SETCELL = function () {
        if (!this.inited) {
            this.InitObject(undefined, undefined, undefined, undefined, undefined, undefined, "CELL", false);
            this.scene.scene.add(this.group);
        }
    };
    FRCObject4d.prototype.SETAPP = function () {
        if (!this.inited) {
            this.InitObject(undefined, undefined, undefined, undefined, undefined, undefined, "APP", false);
            this.scene.scene.add(this.group);
        }
    };
    FRCObject4d.prototype.SETPOD = function (siz, loc, URL, aid, fid) {
        var initpod = true;
        if (this.inited) {
            initpod = !(this.URL == URL);
        }
        if (initpod) {
            this.URL = URL;
            FRCCanvas.QueuePod(URL, this.axisflag);
            this.InitObject(siz, loc, undefined, aid, fid, undefined, "SETPOD", false);
            if (!this.axisflag) {
                this.scene.StartPolling(this);
            }
        }
        this.EveryCall(undefined, undefined, true, fid);
    };
    FRCObject4d.prototype.IDDEL = function () {
    };
    FRCObject4d.prototype.ADDGRID = function (totalsiz, spacing, colgrid, colcenter, decorate) {
        if (this.tagName == "SETWALL") {
            if (colgrid == undefined) {
                colgrid = 0x404040;
            }
            if (colcenter == undefined) {
                colcenter = 0x800000;
            }
            var grid = new THREE.GridHelper(totalsiz, totalsiz / spacing, colcenter, colgrid);
            this.group.add(grid);
            grid.rotateOnAxis(new THREE.Vector3(1, 0, 0), 90 * (Math.PI / 180));
            if (decorate) {
                var material = new THREE.MeshLambertMaterial({ color: 0x8030, emissive: 0x8030 });
                var xboxg = new THREE.BoxBufferGeometry(300, 300, 300);
                var xbox = new THREE.Mesh(xboxg, material);
                xbox.position.x = 3000;
                this.group.add(xbox);
            }
        }
    };
    FRCObject4d.prototype.IDATR = function (aid) {
        if (this.Anchor != undefined) {
            this.Anchor.Highlight(aid);
        }
        else {
            console.log("IDATR call for non-shape ", this.id);
        }
    };
    FRCObject4d.prototype.LOC = function (loc) {
        this.loc = loc;
        this.EveryCall(loc, this.siz, true, undefined);
    };
    return FRCObject4d;
}());
var FRCXML4D = (function () {
    function FRCXML4D(parent) {
        this.railbase = "";
        this.processedcount = 0;
        this.suspend = false;
        this.robotcontext = false;
        this.Parent = parent;
        this.xmlstack = new Array();
        this.AxisStart = -1;
        this.IDObject = new FRCIdent(parent.Scene, this.Parent);
        this.IDFrame = new FRCIdent(parent.Scene, this.Parent);
        this.canvas = FRCCanvas.getInstance();
        if (FRCXML4D.tagmap == undefined) {
            FRCXML4D.tagmap = new Map();
            FRCXML4D.tagmap.set("CELL", this.CELL);
            FRCXML4D.tagmap.set("APP", this.CELL);
            FRCXML4D.tagmap.set("SETPOD", this.SETPOD);
            FRCXML4D.tagmap.set("SETGN", this.SETGN);
            FRCXML4D.tagmap.set("SETOBJ", this.SETOBJ);
            FRCXML4D.tagmap.set("SETAXS", this.SETAXS);
            FRCXML4D.tagmap.set("LOADXML", this.LOADXML);
            FRCXML4D.tagmap.set("REMOTE", this.REMOTE);
            FRCXML4D.tagmap.set("DEFINE", this.DEFINE);
            FRCXML4D.tagmap.set("MOVE", this.MOVE);
            FRCXML4D.tagmap.set("SETFRM", this.SETFRM);
            FRCXML4D.tagmap.set("SETATR", this.SETATR);
            FRCXML4D.tagmap.set("SETATT", this.SETATR);
            FRCXML4D.tagmap.set("SETBOX", this.SETBOX);
            FRCXML4D.tagmap.set("SETCY", this.SETCY);
            FRCXML4D.tagmap.set("MOUNT_LOC", this.MOUNT_LOC);
            FRCXML4D.tagmap.set("SETPT", this.SETPT);
            FRCXML4D.tagmap.set("SETCN", this.SETCN);
            FRCXML4D.tagmap.set("SETDBG", this.SETDBG);
            FRCXML4D.tagmap.set("SETVIS", this.SETVIS);
            FRCXML4D.tagmap.set("SETCFAN", this.SETCFAN);
            FRCXML4D.tagmap.set("SETCIRCLE", this.SETCIRCLE);
            FRCXML4D.tagmap.set("IDDEL", this.IDDEL);
            FRCXML4D.tagmap.set("IDATR", this.IDATR);
            FRCXML4D.tagmap.set("SETLN", this.SETLN);
            FRCXML4D.tagmap.set("SETSPH", this.SETSPH);
            FRCXML4D.tagmap.set("SETVERT", this.SETVERT);
            FRCXML4D.tagmap.set("SETSPR", this.SETSPR);
            FRCXML4D.tagmap.set("SETTXT", this.SETTXT);
            FRCXML4D.tagmap.set("EOF", this.EOF);
            FRCXML4D.tagmap.set("VIEW", this.VIEW);
            FRCXML4D.tagmap.set("VRVIEW", this.VRVIEW);
            FRCXML4D.tagmap.set("VIEWGET", this.VIEWGET);
            FRCXML4D.tagmap.set("VIEWSET", this.VIEWSET);
            FRCXML4D.tagmap.set("CACHE", this.CACHE);
            FRCXML4D.tagmap.set("IDFRM", this.IDFRM);
            FRCXML4D.tagmap.set("SETFLR", this.SETFLR);
            FRCXML4D.tagmap.set("SETTOR", this.SETTOR);
            FRCXML4D.tagmap.set("SETWALL", this.SETWALL);
            FRCXML4D.tagmap.set("SETGRID", this.SETGRID);
            FRCXML4D.tagmap.set("RECORDLOC", this.RECORDLOC);
            FRCXML4D.tagmap.set("INTMOD", this.INTMOD);
            FRCXML4D.tagmap.set("KEYD", this.KEYD);
            FRCXML4D.tagmap.set("KEYU", this.KEYU);
            FRCXML4D.tagmap.set("INST", this.INST);
            FRCXML4D.tagmap.set("STATIC", this.STATIC);
            FRCXML4D.tagmap.set("NOTOOL", this.NOTOOL);
            FRCXML4D.tagmap.set("FINISH", this.FINISH);
            FRCXML4D.tagmap.set("FINISHED", this.FINISHED);
            FRCXML4D.tagmap.set("IDLE", this.IDLE);
            FRCXML4D.tagmap.set("LOC", this.LOC);
            FRCXML4D.tagmap.set("ANIFRAME", this.ANIFRAME);
            FRCXML4D.tagmap.set("ANIMATION", this.ANIMATION);
            FRCXML4D.tagmap.set("ANIMATEND", this.ANIMATEND);
            FRCXML4D.tagmap.set("ANISET", this.ANISET);
            FRCXML4D.tagmap.set("IMAGESRC", this.IMAGESRC);
            FRCXML4D.tagmap.set("ANCHOR", this.ANCHOR);
        }
    }
    FRCXML4D.prototype.strAttribute = function (node, attr) {
        var str = node.getAttribute(attr);
        if (str == undefined || str == null) {
            return undefined;
        }
        ;
        return str;
    };
    FRCXML4D.prototype.xyzwprAttribute = function (node, attr) {
        var str = this.strAttribute(node, attr);
        if (str === undefined) {
            return undefined;
        }
        var rm = new FRCXYZWPR();
        var vals = str.split(",");
        for (var idx = vals.length; idx < 6; idx++) {
            vals.push("0");
            console.log("Not enough values for position " + str);
        }
        rm.x = parseFloat(vals[0]);
        rm.y = parseFloat(vals[1]);
        rm.z = parseFloat(vals[2]);
        rm.w = parseFloat(vals[3]);
        rm.p = parseFloat(vals[4]);
        rm.r = parseFloat(vals[5]);
        return rm;
    };
    FRCXML4D.prototype.locAttribute = function (node, attr) {
        var str = this.strAttribute(node, attr);
        if (str === undefined) {
            return undefined;
        }
        var rm = new THREE.Matrix4();
        var vals = str.split(",");
        for (var idx = vals.length; idx < 6; idx++) {
            vals.push("0");
            console.log("Not enough values for position " + str);
        }
        var x = parseFloat(vals[0]);
        var y = parseFloat(vals[1]);
        var z = parseFloat(vals[2]);
        var w = parseFloat(vals[3]);
        var p = parseFloat(vals[4]);
        var r = parseFloat(vals[5]);
        var x1, y1, z1, w1, p1, r1;
        FRCUtility.MatFromXYZWPR(x, y, z, w, p, r, rm);
        return rm;
    };
    FRCXML4D.prototype.vecAttribute = function (node, attr) {
        var str = this.strAttribute(node, attr);
        if (str === undefined) {
            return undefined;
        }
        var vec = new THREE.Vector3();
        var vals = str.split(",");
        vec.x = parseFloat(vals[0]);
        vec.y = parseFloat(vals[1]);
        vec.z = parseFloat(vals[2]);
        return vec;
    };
    FRCXML4D.prototype.boolAttribute = function (node, attr) {
        var str = this.strAttribute(node, attr);
        if (str === undefined) {
            return undefined;
        }
        var stru = str.toUpperCase();
        if (stru == "FALSE") {
            return false;
        }
        if (stru == "TRUE") {
            return true;
        }
        return undefined;
    };
    FRCXML4D.prototype.numAttribute = function (node, attr) {
        var str = this.strAttribute(node, attr);
        if (str === undefined) {
            return undefined;
        }
        if (str.charAt(0) == "#" || str.charAt(0) == "$") {
            return parseInt(str.substr(1, 1000), 16);
        }
        else if (str.charAt(0) == "0" && (str.charAt(1) == "x" || str.charAt(1) == "X")) {
            return parseInt(str.substr(2, 1000), 16);
        }
        return parseInt(str);
    };
    FRCXML4D.prototype.fltAttribute = function (node, attr) {
        var str = this.strAttribute(node, attr);
        if (str === undefined) {
            return undefined;
        }
        return parseFloat(str);
    };
    FRCXML4D.prototype.GetFID = function (node) {
        var fid = node.getAttribute("fid");
        if (fid == "" || fid == null) {
            return fid;
        }
        if (fid.search(';') >= 0) {
            var IDStack = fid.split(";");
            this.IDFrame.Initialize(IDStack[1]);
            fid = IDStack[0] + ";" + this.IDFrame.FullID();
            return fid;
        }
        else {
            this.IDFrame.Initialize(fid);
        }
        return this.IDFrame.FullID();
    };
    FRCXML4D.prototype.GetENDID = function (node) {
        var endid = node.getAttribute("endid");
        if (endid == "" || endid == null) {
            return endid;
        }
        if (endid.search(';') >= 0) {
            var IDStack = endid.split(";");
            this.IDFrame.Initialize(IDStack[1]);
            endid = IDStack[0] + ";" + this.IDFrame.FullID();
            return endid;
        }
        else {
            this.IDFrame.Initialize(endid);
        }
        return this.IDFrame.FullID();
    };
    FRCXML4D.prototype.INTMOD = function (parser, node, scene) {
        var mode = parser.numAttribute(node, "mode");
        scene.INTMOD(mode);
    };
    FRCXML4D.prototype.IDLE = function (parser, node, scene) {
    };
    FRCXML4D.prototype.FINISH = function (parser, node, scene) {
        scene.FINISH();
    };
    FRCXML4D.prototype.FINISHED = function (parser, node, scene) {
        scene.FINISHED();
    };
    FRCXML4D.prototype.KEYD = function (parser, node, scene) {
        var key = parser.numAttribute(node, "key");
        scene.KEYD(key);
    };
    FRCXML4D.prototype.KEYU = function (parser, node, scene) {
        var key = parser.numAttribute(node, "key");
        scene.KEYU(key);
    };
    FRCXML4D.prototype.INST = function (parser, node, scene) {
        scene.tpgl_instance = parser.numAttribute(node, "inst");
    };
    FRCXML4D.prototype.STATIC = function (parser, node, scene) {
    };
    FRCXML4D.prototype.NOTOOL = function (parser, node, scene) {
    };
    FRCXML4D.prototype.RECORDLOC = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        var slot = parser.numAttribute(node, "slot");
        console.log("RECORDLOC not implemented");
    };
    FRCXML4D.prototype.IDFRM = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        var fid = parser.GetFID(node);
        FRCFrame.Subscribe(fid, object);
    };
    FRCXML4D.prototype.SETFLR = function (parser, node, scene) {
        var size = parser.vecAttribute(node, "siz");
        var grid = parser.fltAttribute(node, "grid");
        var enable = parser.boolAttribute(node, "enable");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        scene.SETFLR(size, grid, enable, aid, fid);
    };
    FRCXML4D.prototype.VIEW = function (parser, node, scene) {
        var loc = parser.xyzwprAttribute(node, "loc");
        scene.VIEW(loc);
    };
    FRCXML4D.prototype.VRVIEW = function (parser, node, scene) {
        var loc = parser.xyzwprAttribute(node, "loc");
        scene.VRVIEW(loc);
    };
    FRCXML4D.prototype.VIEWGET = function (parser, node, scene) {
        scene.VIEWGET();
    };
    FRCXML4D.prototype.VIEWSEL = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        scene.VIEWSEL(id);
    };
    FRCXML4D.prototype.VIEWSET = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var loc = parser.xyzwprAttribute(node, "loc");
        scene.VIEWSET(id, loc);
    };
    FRCXML4D.prototype.CACHE = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var URL = parser.GetURL(node);
        var date = parser.numAttribute(node, "date");
        var type = parser.numAttribute(node, "type");
        var canvas = FRCCanvas.getInstance();
    };
    FRCXML4D.prototype.SETVIS = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        var vis = parser.numAttribute(node, "vis");
        object.SETVIS(id, vis);
    };
    FRCXML4D.prototype.SETDBG = function (parser, node, scene) {
        var level = parser.numAttribute(node, "level");
        FRCDebug.SetLevel(level);
    };
    FRCXML4D.prototype.MOVE = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var joints = node.getAttribute("joints");
        var timestamp = parser.numAttribute(node, "timestamp");
        if (id != undefined) {
            scene.MOVE(id, joints, timestamp);
        }
    };
    FRCXML4D.prototype.SETFRM = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var object = scene.GetFrame(id);
        var loc = parser.locAttribute(node, "loc");
        object.SETFRM(loc);
    };
    FRCXML4D.prototype.MOUNT_LOC = function (parser, node, scene) {
        var invloc = new THREE.Matrix4();
        var id = parser.IDObject.FullID();
        var object = scene.GetFrame(id + "/MOUNT_LOC");
        var loc = parser.locAttribute(node, "loc");
        invloc.getInverse(loc);
        object.SETFRM(invloc);
    };
    FRCXML4D.prototype.SETATR = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var object = FRCAttribute.GetAttribute(id);
        var vis = parser.numAttribute(node, "vis");
        var opac = parser.numAttribute(node, "opac");
        var color = parser.numAttribute(node, "color");
        var weight = parser.numAttribute(node, "weight");
        var sel = parser.numAttribute(node, "sel");
        var bgcolor = parser.numAttribute(node, "bgcolor");
        var font = node.getAttribute("font");
        var pnt = parser.numAttribute(node, "pnt");
        var y = parser.numAttribute(node, "y");
        var charset = parser.numAttribute(node, "charset");
        var style = parser.numAttribute(node, "style");
        var textflag = node.tagName == "SETTXT";
        object.SETATR(textflag, vis, opac, color, weight, style, sel, bgcolor, font, pnt, y, charset);
    };
    FRCXML4D.prototype.IMAGESRC = function (parser, node, inscene) {
        var id = parser.IDObject.FullID();
        inscene.imgpathname = node.getAttribute("pathname");
    };
    FRCXML4D.prototype.DEFINE = function (parser, node, inscene) {
        var alias;
        var id = parser.IDObject.FullID();
        var variable = node.getAttribute("var");
        var val = node.getAttribute("val");
        if (variable == "WORLD") {
            inscene.AddRobot(id);
            parser.worldbase = id;
        }
        if (variable == "BASE") {
            inscene.curr_robot.SetPhase(BBOT_BASEGN);
            if (id != parser.worldbase) {
                parser.railbase = id.substr(parser.worldbase.length + 1, 100000) + '/';
            }
        }
        parser.IDObject.AddDefine(inscene, id, variable, val);
    };
    FRCXML4D.prototype.EOF = function (parser, node, inscene) {
        parser.railbase = "";
        inscene.EndRobot();
    };
    FRCXML4D.prototype.REMOTE = function (parser, node, inscene) {
        var ipadd = node.getAttribute("ipadd");
        var scene = node.getAttribute("scene");
        var myid = node.getAttribute("myid");
        var contid = node.getAttribute("contid");
        var ipsplit = ipadd.split(":");
        if (ipsplit[0] == "0.0.0.0") {
            parser.Parent.contid = "cont" + contid;
        }
        else {
            var url = "http://" + ipsplit[0];
            var connect = FRCCanvas.GetConnect(undefined, url);
            connect.LoginSlave();
        }
    };
    FRCXML4D.prototype.CELL = function (parser, node, scene) {
        var id_cell = "/cell";
        var object_cell = scene.GetObject(id_cell, undefined);
        object_cell.SETCELL();
        var id_app = "/app";
        var object_app = scene.GetObject(id_app, undefined);
        object_app.SETAPP();
    };
    FRCXML4D.prototype.IDATR = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        var aid = node.getAttribute("aid");
        object.IDATR(aid);
    };
    FRCXML4D.prototype.LOC = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        var loc = parser.locAttribute(node, "loc");
        object.LOC(loc);
    };
    FRCXML4D.prototype.ANIMATION = function (parser, node, scene) {
        var rate = parser.numAttribute(node, "rate");
        var count = parser.numAttribute(node, "count");
        var pathname = node.getAttribute("pathname");
        var hide = parser.boolAttribute(node, "hide");
        var oneshot = parser.boolAttribute(node, "oneshot");
        scene.player.ANIMATION(rate, count, pathname, hide, oneshot);
    };
    FRCXML4D.prototype.ANIMATEND = function (parser, node, scene) {
        scene.player.ANIMATEND();
    };
    FRCXML4D.prototype.ANIFRAME = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObjectIf(id, parentid);
        if (object != undefined) {
            var index = parser.numAttribute(node, "idx");
            var jointstr = node.getAttribute("loc");
            var joints = jointstr.split(",");
            for (var idx = joints.length; idx < 6; idx++) {
                joints.push("0");
                console.log("Not enough values for position " + jointstr);
            }
            var vis = parser.numAttribute(node, "vis");
            object.ANIFRAME(index, parseFloat(joints[0]), parseFloat(joints[1]), parseFloat(joints[2]), parseFloat(joints[3]), parseFloat(joints[4]), parseFloat(joints[5]), vis);
        }
    };
    FRCXML4D.prototype.ANISET = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObjectIf(id, parentid);
        if (object != undefined) {
            var json;
            var txtnode = node.childNodes[0];
            if (txtnode == undefined) {
                json = "";
            }
            else {
                json = txtnode.nodeValue;
            }
            object.ANISET(json);
        }
    };
    FRCXML4D.prototype.IDDEL = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        scene.IDDEL(id);
    };
    FRCXML4D.prototype.LOADXML = function (parser, node, scene) {
        var URL = parser.GetURL(node);
        var date = node.getAttribute("date");
        var type = node.getAttribute("type");
        var xmlloader = new FRCLoader(URL, parser.Parent);
        xmlloader.LoadXML();
        parser.suspend = true;
    };
    FRCXML4D.prototype.Walk4dDOM = function (node, scene) {
        var stackop = false;
        if (node.nodeType == 1) {
            var id = node.getAttribute("id");
            if (id != undefined) {
                this.IDObject.Initialize(id);
                stackop = true;
            }
            var function_p = FRCXML4D.tagmap.get(node.tagName);
            FRCDebug.ProcessXML(this.IDObject, node, function_p != undefined);
            if (function_p != undefined) {
                if (this.resuming) {
                    this.resumedcount++;
                    if (this.resumedcount == this.processedcount) {
                        this.resuming = false;
                    }
                }
                else {
                    if (this.IDObject.FullID() == undefined) {
                        var fooey = true;
                    }
                    else {
                        if (FRCDebug.dbglvl & DBGLVL_NOTRY_C) {
                            function_p(this, node, scene);
                        }
                        else {
                            try {
                                function_p(this, node, scene);
                            }
                            catch (err) {
                                console.log("**** ERROR from " + node.tagName + " id = " + this.IDObject.FullID());
                            }
                        }
                    }
                    this.processedcount++;
                    if (this.suspend) {
                        return;
                    }
                }
            }
            else {
                console.log("No function_p for " + node.tagName + " @ " + this.IDObject.FullID());
            }
            node = node.firstElementChild;
            while (node && !this.suspend) {
                this.Walk4dDOM(node, scene);
                if (node.nodeName == "ANIMATION") {
                    scene.player.ANIMATEND();
                }
                node = node.nextElementSibling;
            }
            if (this.robotcontext) {
                var test = this.IDObject.FullID();
                if (this.worldbase == this.IDObject.FullID()) {
                    scene.EndRobot();
                    this.robotcontext = false;
                }
            }
            if (stackop) {
                this.IDObject.Pop();
                if (this.AxisStart > this.IDObject.IDStack.length) {
                    this.AxisStart = -1;
                }
            }
        }
    };
    FRCXML4D.prototype.Parse4d = function (root, scene) {
        this.Walk4dDOM(root, scene);
    };
    FRCXML4D.prototype.XMLResponse = function (xmltext, scene, pipeflag) {
        var xmldom4d;
        var xmldomnew = new FRCXML4D(this.Parent);
        var parser = new DOMParser();
        FRCDebug.RawXML(xmltext);
        if (xmltext.substr(0, 5) == "<?xml") {
            var firstline = xmltext.search(">");
            xmltext = xmltext.substr(firstline + 1, 1000000);
        }
        else {
        }
        xmltext = "<CELL>" + xmltext + "</CELL>\n";
        xmldomnew.xmldoc = parser.parseFromString(xmltext, "text/xml");
        this.xmlstack.push(xmldomnew);
        var done = false;
        for (var count = 0; !done; count++) {
            xmldom4d = this.xmlstack[this.xmlstack.length - 1];
            xmldom4d.suspend = false;
            var root = xmldom4d.xmldoc.getElementsByTagName("CELL");
            xmldom4d.Parse4d(root[0], scene);
            if (xmldom4d.suspend) {
                xmldom4d.resuming = true;
                xmldom4d.resumedcount = 0;
                done = true;
                this.Parent.pipe_suspend = true;
            }
            else {
                this.xmlstack.pop();
                if (this.xmlstack.length == 0) {
                    done = true;
                    if (this.Parent.pipe_suspend) {
                        this.Parent.pipe_suspend = false;
                        if ((this.xmltext_queue != undefined) && this.xmltext_queue.length > 0) {
                            xmltext = this.xmltext_queue;
                            this.xmltext_queue = "";
                            scene.ProcessXML(this.Parent, xmltext, true);
                        }
                    }
                }
            }
            if (count > 5) {
                console.log("Unreasonable xml file loop exiting");
                done = true;
            }
        }
    };
    FRCXML4D.prototype.GetURL = function (node) {
        var URL = node.getAttribute("url");
        if (URL == null || URL == undefined) {
            URL = node.getAttribute("URL");
        }
        return URL;
    };
    FRCXML4D.prototype.SETSPR = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var URL = parser.GetURL(node);
        var aid = node.getAttribute("aid");
        var fid = node.getAttribute("fid");
        var height = parser.numAttribute(node, "height");
        var width = parser.numAttribute(node, "width");
        var parent = scene.GetObject(parentid, grandparent);
        var object = scene.GetObjectIf(id, parentid);
        var pointerEvents = parser.boolAttribute(node, "pointerEvents");
        if (pointerEvents !== true) {
            pointerEvents = false;
        }
        if (object == undefined) {
            object = new FRCSprite(id, scene, parent, "SETSPR", loc, height, width, URL, aid, fid, pointerEvents);
            scene.objects.set(id, object);
        }
        else {
            object.SETSPR(loc, URL, height, width, aid, pointerEvents);
        }
    };
    FRCXML4D.prototype.SETTXT = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var text = node.getAttribute("text");
        var height = parser.numAttribute(node, "height");
        var width = parser.numAttribute(node, "width");
        var cdata = parser.boolAttribute(node, "cdata");
        var pointerEvents = parser.boolAttribute(node, "pointerEvents");
        if (pointerEvents !== true) {
            pointerEvents = false;
        }
        if (cdata === true) {
            var cdnode = node.childNodes[1];
            text = cdnode.wholeText;
        }
        else {
            if (text == undefined) {
                var txtnode = node.childNodes[0];
                if (txtnode == undefined) {
                    text = "";
                }
                else {
                    text = txtnode.nodeValue;
                }
            }
        }
        var parent = scene.GetObject(parentid, grandparent);
        var object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCSprite(id, scene, parent, "SETTXT", loc, height, width, text, aid, fid, pointerEvents);
            scene.objects.set(id, object);
        }
        if (!object.pixeloffset) {
            object.scene.StartPolling(object);
        }
        object.SETTXT(loc, text, height, width, aid, pointerEvents);
    };
    FRCXML4D.prototype.SETLN = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var end = parser.locAttribute(node, "end");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var endid = parser.GetENDID(node);
        var parent = scene.GetObject(parentid, grandparent);
        var object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCLine(id, scene, parent, loc, end, aid, fid, endid);
            scene.objects.set(id, object);
        }
        else {
            object.SETLN(loc, end, aid, fid, endid);
        }
    };
    FRCXML4D.prototype.SETSPH = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var radius = parser.fltAttribute(node, "radius");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        var object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCSphere(id, scene, parent, loc, radius, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETSPH(loc, radius, aid, fid);
        }
    };
    FRCXML4D.prototype.SETTOR = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.xyzwprAttribute(node, "loc");
        var radius = parser.fltAttribute(node, "radius");
        var radius2 = parser.fltAttribute(node, "radius2");
        var start = parser.fltAttribute(node, "start");
        var end = parser.fltAttribute(node, "end");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        var object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCToroid(id, scene, parent, loc, radius, radius2, start, end, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETTOR(loc, radius, radius2, start, end, aid, fid);
        }
    };
    FRCXML4D.prototype.SETGRID = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var siz = parser.vecAttribute(node, "siz");
        var aid = node.getAttribute("aid");
        var gridsize = parser.numAttribute(node, "grid");
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCGrid(id, scene, parent, loc, siz, gridsize, aid);
            scene.objects.set(id, object);
        }
        else {
            object.SETGRID(loc, siz, gridsize, aid);
        }
    };
    FRCXML4D.prototype.SETWALL = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var siz = parser.vecAttribute(node, "siz");
        var side = parser.numAttribute(node, "side");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCWall(id, scene, parent, loc, siz, side, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETWALL(loc, siz, aid, fid);
        }
    };
    FRCXML4D.prototype.SETPOD = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var URL = parser.GetURL(node);
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var locm = parser.locAttribute(node, "loc");
        var scale = parser.vecAttribute(node, "siz");
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        if (parser.Parent.IPAddress == null || parser.Parent.IPAddress == undefined) {
            console.log("parser.Parent.IPAddress undefined ");
        }
        else {
            URL = 'http://' + parser.Parent.IPAddress + URL;
        }
        if (scene.curr_robot != undefined) {
            scene.curr_robot.SETPOD(object, scale, locm, URL, aid, fid);
        }
        else {
            object.SETPOD(scale, locm, URL, aid, fid);
        }
    };
    FRCXML4D.prototype.SETOBJ = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
    };
    FRCXML4D.prototype.SETGN = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var locm = parser.locAttribute(node, "loc");
        var vis = parser.numAttribute(node, "vis");
        if (vis == undefined) {
            vis = 1;
        }
        var parentid = FRCIdent.ParentID(id);
        if (id == "/root") {
            id = "/cell";
        }
        var object = scene.GetObject(id, parentid);
        var axisnode = false;
        var axsnode = node.firstElementChild;
        ;
        while (axsnode) {
            if (axsnode.tagName == "SETAXS") {
                var axisnode = true;
                break;
            }
            axsnode = axsnode.nextElementSibling;
        }
        if (scene.curr_robot != undefined) {
            scene.curr_robot.SETGN(object, id, locm, vis, aid, fid, axisnode);
        }
        else {
            object.SETGN(id, locm, vis, aid, fid);
        }
    };
    FRCXML4D.prototype.ANCHOR = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var locm = parser.locAttribute(node, "loc");
        var vis = parser.numAttribute(node, "vis");
        var flags = parser.numAttribute(node, "flags");
        var multiplier = parser.numAttribute(node, "multiplier");
        if (vis == undefined) {
            vis = 1;
        }
        var parentid = FRCIdent.ParentID(id);
        var object = scene.GetObject(id, parentid);
        object.SETGN(id, locm, vis, aid, fid);
        object.NewAnchor();
        object.Anchor.SETANCHOR(id, locm, vis, multiplier, flags, aid, fid);
    };
    FRCXML4D.prototype.SETAXS = function (parser, node, scene) {
        if (scene.curr_robot == undefined) {
            alert("Robot not defined " + axis.id);
        }
        else {
            if (scene.curr_robot.linked) {
            }
            else {
                parser.robotcontext = true;
                var axis = new FRCAxis(undefined);
                axis.id = parser.IDObject.FullID();
                axis.type = parser.numAttribute(node, "type");
                axis.iid = node.getAttribute("iid");
                axis.mount = node.getAttribute("mount");
                axis.exec = node.getAttribute("exec");
                scene.curr_robot.SETAXS(axis);
            }
        }
    };
    FRCXML4D.prototype.SETBOX = function (parser, node, scene) {
        var id = parser.IDObject.FullID();
        var object;
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var siz = parser.vecAttribute(node, "siz");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        if (!siz.equals(new THREE.Vector3(0, 0, 0))) {
            var parent = scene.GetObject(parentid, grandparent);
            var object = scene.GetObjectIf(id, parentid);
            if (object == undefined) {
                object = new FRCBox(id, scene, parent, loc, siz, aid, fid);
                scene.objects.set(id, object);
            }
            else {
                object.SETBOX(loc, siz, aid, fid);
            }
        }
    };
    FRCXML4D.prototype.SETPT = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var lefty = parser.numAttribute(node, "lefty");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCPoint(id, scene, parent, loc, lefty, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETPT(loc, lefty, aid, fid);
        }
    };
    FRCXML4D.prototype.SETCY = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.vecAttribute(node, "loc");
        var end = parser.vecAttribute(node, "end");
        var radius = parser.numAttribute(node, "radius");
        var typ = parser.numAttribute(node, "typ");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCCylCone(id, scene, parent, "SETCY", loc, end, radius, radius, typ, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETCY(loc, end, radius, radius, typ, aid, fid);
        }
    };
    FRCXML4D.prototype.SETCIRCLE = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var radius = parser.fltAttribute(node, "radius");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCTCFan(id, scene, parent, "SETCIRCLE", loc, radius, 0, 360, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETCFAN("SETCIRCLE", loc, radius, 0, 360, aid, fid);
        }
    };
    FRCXML4D.prototype.SETCFAN = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var radius = parser.fltAttribute(node, "radius");
        var start = parser.fltAttribute(node, "start");
        var end = parser.fltAttribute(node, "end");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCTCFan(id, scene, parent, "SETCFAN", loc, radius, start, end, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETCFAN("SETCFAN", loc, radius, start, end, aid, fid);
        }
    };
    FRCXML4D.prototype.SETCN = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.vecAttribute(node, "loc");
        var end = parser.vecAttribute(node, "end");
        var radius = parser.numAttribute(node, "radius");
        var radius2 = parser.numAttribute(node, "radius2");
        var typ = parser.numAttribute(node, "typ");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCCylCone(id, scene, parent, "SETCN", loc, end, radius, radius, typ, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETCN(loc, end, radius, radius, typ, aid, fid);
        }
    };
    FRCXML4D.prototype.SETVERT = function (parser, node, scene) {
        var object;
        var id = parser.IDObject.FullID();
        var parentid = FRCIdent.ParentID(id);
        var grandparent = FRCIdent.ParentID(parentid);
        var loc = parser.locAttribute(node, "loc");
        var type = parser.numAttribute(node, "type");
        var frmt = parser.numAttribute(node, "frmt");
        var aid = node.getAttribute("aid");
        var fid = parser.GetFID(node);
        var text = node.getAttribute("text");
        if (text == undefined) {
            var txtnode = node.childNodes[0];
            text = txtnode.nodeValue;
        }
        var parent = scene.GetObject(parentid, grandparent);
        object = scene.GetObjectIf(id, parentid);
        if (object == undefined) {
            object = new FRCVertices(id, scene, parent, loc, text, type, frmt, aid, fid);
            scene.objects.set(id, object);
        }
        else {
            object.SETVERT(loc, text, type, frmt, aid, fid);
        }
    };
    return FRCXML4D;
}());
var TPGL_INITDRAW_FC = 2;
var TPGL_DELTADRAW_FC = 3;
var TPGL_INTERACT_FC = 4;
var TPGL_EXIT_FC = 5;
var TPGL_SELECT_FC = 6;
var TPGL_FINISHED_FC = 7;
var TPGL_OCXEXIT_FC = 8;
var TPGL_INITECHO_FC = 9;
var TPGL_REINITDRAW_FC = 10;
var TPGL_STATICDATA_FC = 11;
var TPGL_DISCONNECT_FC = 12;
var TPGL_KARELREQ_FC = 14;
var TPGL_KARELCAN_FC = 15;
var TPGL_TOGGLESCENE_FC = 16;
var TPGL_SOFTKEY_FC = 17;
var TPGL_ENDEDIT_FC = 18;
var TPGL_DISCOECHO_FC = 19;
var TPGL_4DMENU_FC = 20;
var TPGL_4DMENU_SEL_FC = 26;
var TPGL_INITWGLDRAW_FC = 27;
var TPGL_INITWGLECHO_FC = 28;
var TPGL_QUEUEMOVE_FC = 29;
var TPGL_ABUPTFINISH_FC = 30;
var TPGL_QUEUEPART_FC = 31;
var TPGL_DELTAMOVE_FC = 32;
var SSC_PMON = 100;
var PMEV_PIPE_C = 63;
var PMON_MON_PIPE_C = 11;
var Polling = (function () {
    function Polling() {
    }
    return Polling;
}());
var FRCScene = (function () {
    function FRCScene(pipe) {
        this.throttle = 100;
        this.lastframe = 0;
        this.finishing = false;
        this.downtime = Date.now();
        this.standalone = true;
        this.antialias = true;
        this.IsMouseDown = false;
        this.hideplayer = true;
        this.UseVR = false;
        this.showFPS = false;
        this.debug1 = false;
        this.podinprogress = 0;
        this.stalled = 0;
        this.Echo = false;
        var currtime = Date.now();
        this.pipe = pipe;
        this.premoves = new Array();
        this.robots = new Array();
        this.objects = new Map();
        this.animated = new Map();
        this.intersects = new Array();
        this.player = new FRCAnimation(this);
        this.clock = new THREE.Clock();
        this.lastupdate = currtime;
        this.raycaster = new THREE.Raycaster();
        this.mousetime = currtime;
        this.spritelist = new Array();
        this.view = new FRCXYZWPR();
        this.imgpathname = '/frh/tpgl/images/';
        this.frames = new Map();
    }
    FRCScene.prototype.Initialize = function () {
        this.raycaster.params.Points.threshold = 15;
        this.raycaster.linePrecision = 15;
        var canvas = FRCCanvas.getInstance();
        var incanvas;
        canvas.glsupported = true;
        if (canvas.glsupported) {
            if (this.incanvas != undefined) {
                var rendercanvas = document.getElementById(incanvas);
                if (rendercanvas != null) {
                    this.renderer = new THREE.WebGLRenderer({ canvas: rendercanvas, antialias: this.antialias });
                }
                else {
                    alert("Cannot find specified canvas in document " + incanvas);
                    return;
                }
            }
            else {
                this.renderer = new THREE.WebGLRenderer({ antialias: this.antialias });
            }
        }
        var canvasid = this.pipe.substring(0, this.pipe.length - 4);
        this.renderer.domElement.id = canvasid;
        this.scene = new THREE.Scene();
        this.light = new THREE.DirectionalLight(0xffffffff);
        this.light.position.set(0, 0, 1).normalize();
        this.scene.add(this.light);
        this.InitFloor();
        this.InitPlanes();
        if (canvas.glsupported) {
            this.Height = document.documentElement.clientHeight;
            this.Width = document.documentElement.clientWidth;
            this.renderer.setClearColor(0x00e1e7ec);
            this.renderer.setPixelRatio(window.devicePixelRatio);
            document.body.appendChild(this.renderer.domElement);
            this.renderer.setSize(document.documentElement.clientWidth, document.documentElement.clientHeight);
            this.renderer.physicallyCorrectLights = true;
        }
        this.lastupdate = Date.now();
        if (this.standalone) {
            window.addEventListener('resize', this.onWindowResize, false);
        }
        if (this.showFPS) {
            this.stats = new Stats();
            document.body.appendChild(this.stats.domElement);
        }
    };
    FRCScene.prototype.GetFrame = function (name) {
        var id;
        if (name.search(';') >= 0) {
            var IDStack = name.split(";");
            id = IDStack[1];
        }
        else {
            id = name;
        }
        var object = this.frames.get(id);
        if (object == undefined) {
            object = new FRCFrame(id);
            this.frames.set(id, object);
        }
        return object;
    };
    FRCScene.prototype.EchoMode = function () {
        this.Echo = true;
    };
    FRCScene.prototype.Stalled = function () {
        this.stalled = 10;
    };
    FRCScene.prototype.Animate = function () {
        var deltaneeded = false;
        if (!this.finishing) {
            if (this.showFPS) {
                this.stats.update();
            }
            var object;
            var currtime = Date.now();
            this.animated.forEach(FRCScene.ObjAnimate, object);
            this.lastframe = currtime;
            for (var idx = 0; idx < this.robots.length; idx++) {
                this.robots[idx].Animate();
            }
            if (this.player.numframes > 0) {
                this.player.Animate();
                if ((currtime - this.mousetime > 20000) && this.hideplayer) {
                    this.player.Hide();
                }
            }
        }
        if (this.stalled > 0) {
            this.stalled--;
            if (this.stalled == 1) {
                deltaneeded = true;
            }
        }
        var delta = currtime - this.lastupdate;
        var currtime = Date.now();
        if (delta > 500 && this.staleview) {
            deltaneeded = true;
        }
        if (deltaneeded && !this.Echo) {
            var view = "&view=" + this.View();
            FRCCanvas.draw3d_SendPkt(TPGL_DELTADRAW_FC, this.ctrl_data, view);
        }
    };
    FRCScene.ObjAnimate = function (object) {
        object.Animate();
    };
    FRCScene.prototype.ProgressDelegate = function (delegate) {
        this.progresscallback = delegate;
    };
    FRCScene.prototype.ProgUpd = function () {
        if (this.progresscallback) {
            this.progresscallback(this.podinprogress);
        }
    };
    FRCScene.prototype.AddRobot = function (id) {
        var robot;
        var allocate = true;
        for (var idx = 0; idx < this.robots.length; idx++) {
            if (this.robots[idx].id == id) {
                allocate = false;
                robot = this.robots[idx];
            }
        }
        if (allocate) {
            var robot = new FRCRobot(id, this);
            this.robots.push(robot);
        }
        this.curr_robot = robot;
    };
    FRCScene.prototype.EndRobot = function () {
        for (var idx = 0; idx < this.robots.length; idx++) {
            this.robots[idx].EOF();
        }
        this.curr_robot = undefined;
    };
    FRCScene.prototype.EndGNODE = function (id) {
        for (var idx = 0; idx < this.robots.length; idx++) {
            if (this.robots[idx].id == id) {
                this.robots[idx].EOF();
            }
        }
    };
    FRCScene.prototype.MOVE = function (id, joints, timestamp) {
        if (!this.finishing) {
            if (this.robots.length == 0) {
                if ((id == undefined) || (joints == undefined) || (joints == null)) {
                }
                else {
                    var Move = new MoveQueue();
                    Move.id = id;
                    Move.joints = joints;
                    this.premoves.push(Move);
                }
            }
            else {
                for (var idx = 0; idx < this.robots.length; idx++) {
                    if (this.robots[idx].id == id) {
                        this.robots[idx].MOVE(joints, timestamp);
                    }
                }
            }
        }
        else {
            console.log("Ignoreing move during scene change");
        }
    };
    FRCScene.prototype.IDDEL = function (id) {
        var idx;
        if (id != undefined) {
            if (id.charAt(id.length - 1) == "/") {
                id = id.substr(0, id.length - 1);
            }
            if (id.charAt(1) == "/") {
                id = id.substr(1);
            }
            var object = this.objects.get(id);
            if (object != undefined) {
                for (idx = object.children.length - 1; idx >= 0; idx--) {
                    this.IDDEL(object.children[idx].id);
                }
                if (object.parent != undefined) {
                    var parent = object.parent;
                    var childidx = parent.children.indexOf(object);
                    for (idx = childidx; idx < parent.children.length; idx++) {
                        parent.children[idx] = parent.children[idx + 1];
                    }
                    parent.children.pop();
                    var pargroup = parent.group;
                    var childidx = pargroup.children.indexOf(object.group);
                    for (idx = childidx; idx < pargroup.children.length; idx++) {
                        pargroup.children[idx] = pargroup.children[idx + 1];
                    }
                    pargroup.children.pop();
                }
                object.IDDEL();
                this.objects.delete(id);
            }
        }
    };
    FRCScene.prototype.StartPolling = function (object) {
        this.animated.set(object.id, object);
        if (object.tagName == "SETPOD") {
            this.podinprogress++;
        }
    };
    FRCScene.prototype.StopPolling = function (object) {
        this.animated.delete(object.id);
        if (object.tagName == "SETPOD") {
            this.podinprogress--;
        }
        if (this.podinprogress == 0) {
            this.ProgUpd();
        }
    };
    FRCScene.prototype.ProcessXML = function (connect, xmltext, pipeflag) {
        connect.xml4d.XMLResponse(xmltext, this, pipeflag);
        this.Render();
    };
    FRCScene.prototype.IntGetObject = function (id, parent_name, createflag) {
        if (id == undefined) {
            id = "/NotDefined";
        }
        if (id.charAt(id.length - 1) == "/") {
            id = id.substr(0, id.length - 1);
        }
        var object = this.objects.get(id);
        if (object == undefined) {
            if (parent_name != undefined && parent_name != "") {
                var parent = this.objects.get(parent_name);
                if (parent == undefined) {
                    var grandparent = FRCIdent.ParentID(parent_name);
                    parent = this.IntGetObject(parent_name, grandparent, true);
                }
            }
            if (createflag) {
                object = new FRCObject4d(id, this, parent);
                this.objects.set(id, object);
                if (this.objects.size == 1) {
                    this.root_object4d = object;
                }
                if (object.parent == undefined) {
                    console.log("[Scene] Ancestry error no parent for " + id);
                }
            }
        }
        return object;
    };
    FRCScene.prototype.GetObject = function (id, parent_name) {
        return this.IntGetObject(id, parent_name, true);
    };
    FRCScene.prototype.GetObjectIf = function (id, parent_name) {
        return this.IntGetObject(id, parent_name, false);
    };
    FRCScene.prototype.onWindowResize = function () {
        if (FRCDebug.dbglvl == -1) {
            console.log("[Scene] window resize");
        }
        FRCCanvas.ResizeWindow();
    };
    FRCScene.prototype.SETFLR = function (siz, spacing, grid, aid, fid) {
        if (grid === undefined) {
            grid = true;
        }
        if (spacing === undefined || spacing == NaN) {
            spacing = 1000;
        }
        var floorgrid = this.GetObject('/cell/floor/grid', '/cell/floor');
        this.floor.SETWALL(undefined, siz, aid, fid);
        if (grid) {
            floorgrid.SETGRID(floorgrid.loc, siz, spacing, '/floorgrid');
        }
        else {
            floorgrid.SETVIS(floorgrid.id, 0);
        }
    };
    FRCScene.prototype.InitFloor = function () {
        var loc = new THREE.Matrix4();
        var floorxml = "";
        floorxml = floorxml + '<SETATR id="/defaultfloor" vis = "1" style = "1" color = "#0xd0d0d0" opac = "100"/>';
        floorxml = floorxml + '<SETATR id="/floorgrid" vis = "1" style = "1" color = "#ff0000" opac = "100" weight = "2"/>';
        floorxml = floorxml + '<SETGN id="/cell/floor" loc="0,0,0,0,0,0" fid="/cell/flr">';
        floorxml = floorxml + '	<SETWALL  id="wall" loc="0.00,0.00,0.00,0.00,0.00,0.00" siz="6000, 6000, 0" side = "1" aid="/defaultfloor"/>';
        floorxml = floorxml + '	<SETGRID  id="grid" loc="0.00,0.00,0.01,0.00,0.00,0.00" siz="6000, 6000, 0" grid="1000" side="1" aid="/floorgrid"/>';
        floorxml = floorxml + '</SETGN>';
        var connect = FRCCanvas.GetConnect(undefined, "http://*local*/");
        this.ProcessXML(connect, floorxml + '<EOF/>', false);
        this.floor = this.GetObject('/cell/floor/wall', '/cell/floor');
    };
    FRCScene.prototype.InitPlanes = function () {
        this.xyzplanes = new Array();
        var geometry = new THREE.PlaneGeometry(1000000, 1000000);
        var red = new THREE.MeshBasicMaterial({ color: 0xFF0000, transparent: true, side: THREE.DoubleSide });
        red.opacity = 0.6;
        var green = new THREE.MeshBasicMaterial({ color: 0xFF00, transparent: true, side: THREE.DoubleSide });
        green.opacity = 0.6;
        var blue = new THREE.MeshBasicMaterial({ color: 0xFF, transparent: true, side: THREE.DoubleSide });
        blue.opacity = 0.6;
        this.xyzplanes[0] = new THREE.Mesh(geometry, red);
        this.xyzplanes[0].name = "XYPlane";
        this.xyzplanes[1] = new THREE.Mesh(geometry, green);
        this.xyzplanes[1].rotation.x = Math.PI / 2;
        this.xyzplanes[1].name = "XZPlane";
        this.xyzplanes[2] = new THREE.Mesh(geometry, blue);
        this.xyzplanes[2].rotation.y = Math.PI / 2;
        this.xyzplanes[2].name = "YZPlane";
        for (var idx = 0; idx < 3; idx++) {
            this.scene.add(this.xyzplanes[idx]);
            this.xyzplanes[idx].visible = false;
        }
    };
    FRCScene.prototype.FINISH = function () {
        if (!this.Echo) {
            this.finishing = true;
            var view = "&view=" + this.View();
            FRCCanvas.draw3d_SendPkt(TPGL_EXIT_FC, this.ctrl_data, view);
        }
    };
    FRCScene.prototype.FINISHED = function () {
        if (!this.Echo) {
            var view = "&view=" + this.View();
            FRCCanvas.draw3d_SendPkt(TPGL_FINISHED_FC, this.ctrl_data, view);
            this.finishing = false;
        }
    };
    FRCScene.prototype.onClick = function (xcoor, ycoor, button) {
    };
    FRCScene.prototype.onMouseDown = function (xcoor, ycoor, button) {
    };
    FRCScene.prototype.onMouseUp = function (xcoor, ycoor, button) {
    };
    FRCScene.prototype.onMouseMove = function (xcoor, ycoor, button) {
    };
    FRCScene.prototype.PauseOrbit = function () {
    };
    FRCScene.prototype.ResumeOrbit = function () {
    };
    FRCScene.prototype.onDblClick = function (xcoor, ycoor, button) {
    };
    FRCScene.prototype.Select = function (xcoor, ycoor, button) {
    };
    FRCScene.prototype.FindClick2 = function (x, y, CheckChildren) {
        return false;
    };
    FRCScene.prototype.Render = function () {
        if (!this.finishing) {
            this.renderer.render(this.scene, this.camera);
        }
    };
    FRCScene.prototype.DoResize = function (setpos) {
    };
    FRCScene.prototype.View = function () {
        this.lastupdate = Date.now();
        var str = this.view.x.toPrecision(6) + ", " + this.view.y.toPrecision(6) + ", " + this.view.z.toPrecision(6) + ", ";
        str = str + this.view.w.toPrecision(4) + ", " + this.view.p.toPrecision(4) + ", " + this.view.r.toPrecision(4);
        this.staleview = false;
        return str;
    };
    FRCScene.prototype.VIEW = function (xyzwpr) {
    };
    FRCScene.prototype.VRVIEW = function (xyzwpr) {
    };
    FRCScene.prototype.VIEWGET = function () {
    };
    FRCScene.prototype.VIEWSEL = function (id) {
    };
    FRCScene.prototype.VIEWSET = function (id, xyzwpr) {
    };
    FRCScene.prototype.INTMOD = function (mode) {
        console.log("INTMOD not implemented");
    };
    FRCScene.prototype.KEYD = function (key) {
        console.log("KEYD not implemented");
    };
    FRCScene.prototype.KEYU = function (key) {
        console.log("KEYU not implemented");
    };
    return FRCScene;
}());
var ZOOMIDENTITY = 267;
var PITCHLIMIT = 89.9;
var FRCProgress = (function () {
    function FRCProgress() {
        this.iconidx = 0;
    }
    return FRCProgress;
}());
var FRCScene3D = (function (_super) {
    __extends(FRCScene3D, _super);
    function FRCScene3D(pipe) {
        var _this = _super.call(this, pipe) || this;
        _this.camsetup = false;
        _this.viewpos = new THREE.Matrix4();
        _this.progress = new FRCProgress();
        return _this;
    }
    FRCScene3D.prototype.Initialize = function () {
        _super.prototype.Initialize.call(this);
        this.camera = new THREE.OrthographicCamera(this.Width / -.2, this.Width / .2, this.Height / .2, this.Height / -.2, -100000, 100000);
        this.camera.up.set(0, 0, 1);
        this.camsetup = true;
        this.controls = new THREE.OrbitControls(this.camera, this.renderer.domElement);
        this.scene.add(this.camera);
        this.look = new THREE.Vector3();
        this.lastcamera = new THREE.Vector3();
        this.view.x = 0;
        this.view.y = 0;
        this.view.z = 0;
        this.view.w = 1.0;
        this.view.p = 45;
        this.view.r = 45;
        this.SetView(true);
        if (this.showFPS) {
            this.stats = new Stats();
            document.body.appendChild(this.stats.domElement);
        }
        this.progress.last_update = Date.now() - 2000;
        this.InitProgress();
        FRCCanvas.Animate();
    };
    FRCScene3D.prototype.AddMenuTab = function () {
        var loc = new THREE.Matrix4();
        if (this.showFPS) {
            FRCUtility.MatFromXYZWPR(80.0, 0, 0, 0, 0, 0, loc);
        }
        else {
            FRCUtility.MatFromXYZWPR(10.0, 0, 0, 0, 0, 0, loc);
        }
        var attobject = FRCAttribute.GetAttribute('menuseltab');
        attobject.SETATR(true, 1, 60, 0xFFFFFF, 0, 0, 0, 200, "Verdana", 16, 0, 0);
        var parent = this.GetObject("/menu", undefined);
        var object = this.GetObjectIf('/menu/*noselect*', '/menu');
        if (object == undefined) {
            object = new FRCSprite('/menu/*noselect*', this, parent, "SETSPR", loc, 26, 26, '/frh/fcgtp/menu.PNG', 'menuseltab', undefined, false);
            this.objects.set('/menu/*noselect*', object);
        }
        else {
            object.SETSPR(loc, '/frh/fcgtp/menu.PNG', 26, 26, 'menuseltab', false);
        }
    };
    FRCScene3D.prototype.ProgUpd = function () {
        _super.prototype.ProgUpd.call(this);
        if (this.podinprogress > 0) {
            var now = Date.now();
            if ((now - this.progress.last_update) > 100) {
                this.progress.last_update = Date.now();
                var URL = this.imgpathname + this.progress.icons[this.progress.iconidx];
                this.progress.sprite.SETSPR(undefined, URL, undefined, undefined, 'progresssprite', false);
                this.progress.iconidx++;
                if (this.progress.iconidx > 5) {
                    this.progress.iconidx = 0;
                }
                this.Render();
            }
        }
        else {
            _super.prototype.ProgUpd.call(this);
            if (this.progress.visible) {
                this.progress.visible = false;
                this.progress.sprite.SETVIS('/menu/progress/sprite', 0);
            }
        }
    };
    FRCScene3D.prototype.InitProgress = function () {
        var loc = new THREE.Matrix4();
        var attobject = FRCAttribute.GetAttribute('progresssprite');
        attobject.SETATR(false, 1, 0, 0xFFFFFF, 0, 0, 0, 0x404040, "Verdana", 16, 0, 0);
        FRCUtility.MatFromXYZWPR((this.Width / 2) - 16, (this.Height / 2) - 16, 0, 0, 0, 0, loc);
        this.progress.icons = new Array();
        this.progress.icons[0] = "robtime.ico";
        this.progress.icons[1] = "robtime1.ico";
        this.progress.icons[2] = "robtime2.ico";
        this.progress.icons[3] = "robtime3.ico";
        this.progress.icons[4] = "robtime4.ico";
        this.progress.icons[5] = "robtime5.ico";
        this.progress.sprite = new FRCSprite('/menu/progress/sprite', this, undefined, 'SETSPR', loc, 32, 32, this.imgpathname + "robtime.ico", 'progresssprite', undefined, false);
        this.progress.iconidx = 1;
        this.progress.visible = true;
    };
    FRCScene3D.prototype.AddDbgView = function () {
        var loc = new THREE.Matrix4();
        FRCUtility.MatFromXYZWPR(10.0, 50.0, 0, 0, 0, 0, loc);
        var attobject = FRCAttribute.GetAttribute('menuseltab');
        attobject.SETATR(true, 1, 60, 0xFFFFFF, 0, 0, 0, 200, "Verdana", 16, 0, 0);
        var parent = this.GetObject("/menu", undefined);
        var object = this.GetObjectIf('/menu/dbgtab', '/menu');
        if (object == undefined) {
            object = new FRCSprite('/menu/dbgtab', this, parent, "SETTXT", loc, 26, 500, 'Blank', 'menuseltab', undefined, false);
            this.objects.set('/menu/dbgtab', object);
        }
        else {
            object.SETTXT(loc, 'Blank', 26, 500, 'menuseltab', false);
        }
        this.dbgsprite = object;
    };
    FRCScene3D.prototype.Animate = function () {
        if (!this.finishing) {
            if (!this.debug1) {
                _super.prototype.Animate.call(this);
                this.CurrView(this.Width / 2, this.Height / 2);
                if (this.staleview) {
                    this.Render();
                    if (this.view.p < 0) {
                        this.floor.mesh.renderOrder = 100000;
                    }
                    else {
                        this.floor.mesh.renderOrder = 0;
                    }
                }
            }
        }
    };
    FRCScene3D.prototype.EchoMode = function () {
        this.Echo = true;
        this.controls.enabled = false;
    };
    FRCScene3D.prototype.Render = function () {
        if (!this.finishing && this.camsetup) {
            this.renderer.render(this.scene, this.camera);
        }
    };
    FRCScene3D.prototype.NewCenter = function (x, y, z) {
        this.rotcenter.SETVIS(this.rotcenter.id, 1);
        this.view.x = x;
        this.view.y = y;
        this.view.z = z;
        this.SetView(true);
    };
    FRCScene3D.prototype.DoResize = function (setpos) {
        this.Height = document.documentElement.clientHeight;
        this.Width = document.documentElement.clientWidth;
        this.renderer.setSize(this.Width, this.Height);
        this.SetView(setpos);
        this.player.ReSize();
    };
    FRCScene3D.prototype.FindSprite = function (xcoor, ycoor) {
        for (var idx = 0; idx < this.spritelist.length; idx++) {
            var sprite = this.spritelist[idx];
            if (sprite != undefined && sprite.CheckDiv(xcoor, ycoor)) {
                return sprite;
            }
        }
        return undefined;
    };
    FRCScene3D.prototype.CheckAnchor = function (xcoor, ycoor, button, downaction) {
        var anchorobj = null;
        if ((this.AnchoredObj != null) && (this.AnchoredObj.Anchor.State == TPGL_ANCHOR_MAXIMIZED)) {
            this.AnchoredObj.Anchor.ShowPlanes();
        }
        if (this.FindClick(xcoor, ycoor)) {
            if ((this.AnchoredObj != null) && (this.AnchoredObj.Anchor.State == TPGL_ANCHOR_MAXIMIZED)) {
                this.AnchoredObj.Anchor.HidePlanes();
            }
            for (var idx = 0; idx < this.intersects.length; idx++) {
                this.selected = this.intersects[idx].object.parent.HostObject;
                if ((this.selected.parent.Anchor != null) || (this.selected.Anchor != null)) {
                    if (this.selected.Anchor != null) {
                        anchorobj = this.selected;
                    }
                    else {
                        anchorobj = this.selected.parent;
                    }
                    if (this.AnchoredObj != null && this.AnchoredObj != anchorobj) {
                        this.AnchoredObj.Anchor.DeselectAnchor();
                    }
                    if (anchorobj.tagName != "SETGN") {
                        console.log("WTH");
                    }
                    this.AnchoredObj = anchorobj;
                    anchorobj.Anchor.SelectAnchor(this.selected, xcoor, ycoor, button, downaction);
                    break;
                }
            }
        }
        if (this.AnchoredObj != null && anchorobj == null) {
            this.AnchoredObj.Anchor.DeselectAnchor();
            this.AnchoredObj = null;
        }
        return anchorobj != null;
    };
    FRCScene3D.prototype.Select = function (xcoor, ycoor, button) {
        if (!this.CheckAnchor(xcoor, ycoor, button, false)) {
            var sprite = this.FindSprite(xcoor, ycoor);
            if (this.controls !== undefined) {
                this.controls.panLatch = false;
            }
            if (sprite != undefined) {
                var mtest = sprite.id.substr(0, 5);
                if (mtest == '/menu') {
                    if (sprite.playerfc != 0) {
                        this.player.Click(sprite, xcoor, ycoor);
                    }
                    return;
                }
                var world = sprite.group.matrixWorld;
                this.NewCenter(world.elements[12], world.elements[13], world.elements[14]);
                this.selected = sprite;
            }
            else {
                if (this.FindClick(xcoor, ycoor)) {
                    this.selected = this.intersects[0].object.parent.HostObject;
                    if (this.intersects[0].object.parent.HostObject == undefined) {
                        console.log("No host object for " + this.intersects[0].object.parent.name);
                    }
                    else {
                        console.log("Selected " + this.intersects[0].object.parent.HostObject.id);
                        var selected = '&inst=' + this.tpgl_instance + '&select=' + this.intersects[0].object.parent.HostObject.id;
                        FRCCanvas.draw3d_SendPkt(TPGL_SELECT_FC, this.ctrl_data, selected);
                    }
                }
                if (button == 2 && this.selected != undefined && this.selected.spherecenter.x != undefined) {
                    this.NewCenter(this.selected.spherecenter.x, this.selected.spherecenter.y, this.selected.spherecenter.z);
                }
                else {
                    this.NewCenter(this.intersects[0].point.x, this.intersects[0].point.y, this.intersects[0].point.z);
                }
            }
            this.rotcenter.SETVIS(this.rotcenter.id, 1);
            for (var idx = 0; idx < this.rotcenter.children.length; idx++) {
                this.rotcenter.children[idx].SETVIS(this.rotcenter.children[idx].id, 1);
            }
        }
    };
    FRCScene3D.prototype.PauseOrbit = function () {
        this.controls.enabled = false;
    };
    FRCScene3D.prototype.ResumeOrbit = function () {
        this.controls.enabled = true;
    };
    FRCScene3D.prototype.onDblClick = function (xcoor, ycoor, button) {
        if (!this.Echo) {
            if (this.floor.spherecenter != undefined && this.floor.spherecenter.x != undefined) {
                this.NewCenter(this.floor.spherecenter.x, this.floor.spherecenter.y, this.floor.spherecenter.z);
            }
        }
    };
    FRCScene3D.prototype.onMouseDown = function (xcoor, ycoor, button) {
        if (!this.Echo) {
            var now = Date.now();
            if (now - this.downtime > 250) {
                this.downtime = Date.now();
                if (this.AnchoredObj != null && this.AnchoredObj.Anchor.State != TPGL_ANCHOR_MINIMIZED) {
                    this.CheckAnchor(xcoor, ycoor, button, true);
                }
            }
        }
    };
    FRCScene3D.prototype.onMouseUp = function (xcoor, ycoor, button) {
        if (!this.Echo) {
            this.IsMouseDown = false;
            this.mousetime = Date.now();
            var delta = this.mousetime - this.downtime;
            if (this.AnchoredObj != null) {
                this.AnchoredObj.Anchor.EndMove();
            }
            if (delta < 250) {
                this.Select(xcoor, ycoor, button);
            }
        }
    };
    FRCScene3D.prototype.onMouseMove = function (xcoor, ycoor, button) {
        if (!this.Echo) {
            if (this.AnchoredObj != null) {
                this.AnchoredObj.Anchor.ContinueMove(xcoor, ycoor);
            }
        }
    };
    FRCScene3D.prototype.InitPlanes = function () {
        _super.prototype.InitPlanes.call(this);
        var object = FRCAttribute.GetAttribute('/rotsphere');
        object.SETATR(false, 1, 40, 0xff, 0, 0, 0, 0, "", 0, 0, 0);
        object = FRCAttribute.GetAttribute('/rottriad');
        var triadstyle = TPGL_STYLE_TRIAD_CENTER;
        object.SETATR(false, 1, 60, 0, 0, triadstyle, 0, 0, "", 0, 0, 0);
        this.rotcenter = this.GetObject("/cell/rotcenter", "/cell");
        this.rotcenter.SETGN("/cell/rotcenter", undefined, 1, undefined, undefined);
        var sphere = new FRCSphere("/cell/rotcenter/sphere", this, this.rotcenter, undefined, 15, '/rotsphere', undefined);
        var triad = new FRCPoint("/cell/rotcenter/triad", this, this.rotcenter, undefined, 0, '/rottriad', undefined);
    };
    FRCScene3D.prototype.VIEW = function (xyzwpr) {
        this.view = xyzwpr;
        this.SetView(true);
    };
    FRCScene3D.prototype.FindClick = function (x, y) {
        return this.FindClick2(x, y, true);
    };
    FRCScene3D.prototype.FindClick2 = function (x, y, CheckChildren) {
        var retflg = true;
        var mouse = new THREE.Vector2();
        mouse.x = (x / this.Width) * 2 - 1;
        mouse.y = -(y / this.Height) * 2 + 1;
        this.raycaster.setFromCamera(mouse, this.camera);
        if (CheckChildren) {
            this.intersects = this.raycaster.intersectObjects(this.scene.children, true);
        }
        if (this.intersects.length == 0 || !CheckChildren) {
            retflg = false;
            for (var idx = 0; idx < 3; idx++) {
                this.xyzplanes[idx].visible = true;
            }
            this.intersects = this.raycaster.intersectObjects(this.xyzplanes, true);
            for (var idx = 0; idx < 3; idx++) {
                this.xyzplanes[idx].visible = false;
            }
        }
        return retflg;
    };
    FRCScene3D.prototype.SetView = function (setpos) {
        this.camera.left = this.Width / -.2;
        this.camera.right = this.Width / .2;
        this.camera.top = this.Height / .2;
        this.camera.bottom = this.Height / -.2;
        if ((Math.abs(this.view.x) > 100000) ||
            (Math.abs(this.view.y) > 100000) ||
            (Math.abs(this.view.z) > 100000) ||
            (this.view.w < .001) ||
            (this.view.w > 1000) ||
            (Math.abs(this.view.p) > 361)) {
            console.log("Resetting view to default");
            this.view.x = 0;
            this.view.y = 0;
            this.view.z = 0;
            this.view.w = 1.0;
            this.view.p = 45;
            this.view.r = 45;
        }
        if (this.view.p > PITCHLIMIT) {
            this.view.p = PITCHLIMIT;
        }
        else if (this.view.p < -PITCHLIMIT) {
            this.view.p = -PITCHLIMIT;
        }
        if (setpos) {
            var ViewPitch = this.view.p * Math.PI / 180;
            var ViewYaw = this.view.r * Math.PI / 180;
            this.camera.zoom = this.Height / (this.view.w * ZOOMIDENTITY);
            if (this.lastzoom != this.camera.zoom) {
                this.lastzoom = this.camera.zoom;
            }
            var x = Math.cos(ViewYaw) * Math.cos(ViewPitch);
            var y = Math.sin(ViewYaw) * Math.cos(ViewPitch);
            var z = Math.sin(ViewPitch);
            var multiplier = 10000.0;
            this.camera.position.x = x * multiplier + this.view.x;
            this.camera.position.y = y * multiplier + this.view.y;
            this.camera.position.z = z * multiplier + this.view.z;
            if (!this.camera.position.equals(this.lastcamera)) {
                this.lastcamera = this.camera.position.clone();
            }
            this.look.x = this.view.x;
            this.look.y = this.view.y;
            this.look.z = this.view.z;
            this.viewpos.elements[XELE] = this.view.x;
            this.viewpos.elements[YELE] = this.view.y;
            this.viewpos.elements[ZELE] = this.view.z;
            this.rotcenter.LOC(this.viewpos);
            this.camera.updateProjectionMatrix();
            if (this.controls != undefined) {
                this.controls.target.set(this.view.x, this.view.y, this.view.z);
                this.controls.update();
                if (!this.camera.position.equals(this.lastcamera)) {
                    this.lastcamera = this.camera.position.clone();
                }
            }
            else {
                this.camera.lookAt(this.look);
            }
        }
        else {
            this.camera.updateProjectionMatrix();
        }
        var previous = new FRCXYZWPR();
        previous = this.view.clone();
        this.CurrView(this.Width / 2, this.Height / 2);
        this.Render();
    };
    FRCScene3D.prototype.DisplayView = function (Yaw, posnor) {
        if (FRCDebug.dbglvl & DBGLVL_VIEW_C) {
            var object;
            var id = "/menu/viewdisp";
            var aid = "/text/lgsh/eg";
            var canvas = FRCCanvas.getInstance();
            var loc = new THREE.Matrix4();
            loc.elements[13] = 40;
            loc.elements[12] = 12;
            if (canvas.attributes == undefined) {
                return;
            }
            var aobject = canvas.attributes.get(aid);
            if (aobject == undefined) {
                return;
            }
            var height;
            var width;
            var parent = this.GetObjectIf("/menu", undefined);
            var object = this.GetObjectIf(id, "/menu");
            var text = "";
            text = text + " $X = " + this.view.x.toPrecision(4) + " $Y = " + this.view.y.toPrecision(4) + " $Z = " + this.view.z.toPrecision(4) + " $WZ = " + this.view.w.toPrecision(4);
            if (object == undefined) {
                object = new FRCSprite(id, this, parent, "SETTXT", loc, height, width, text, aid, undefined, false);
                this.objects.set(id, object);
            }
            object.SETTXT(loc, text, height, width, aid, false);
        }
    };
    FRCScene3D.prototype.CurrView = function (xcoor, ycoor) {
        if (!this.camera.position.equals(this.lastcamera) || this.lastzoom != this.camera.zoom) {
            this.staleview = true;
            this.lastcamera = this.camera.position.clone();
            this.lastzoom = this.camera.zoom;
            var posnor = new THREE.Vector3();
            this.FindClick(xcoor, ycoor);
            if (this.intersects.length > 0) {
                this.view.x = this.intersects[0].point.x;
                this.view.y = this.intersects[0].point.y;
                this.view.z = this.intersects[0].point.z;
                var panned = this.controls.panLatch;
                if (panned) {
                    this.rotcenter.SETVIS(this.rotcenter.id, 0);
                }
            }
            posnor = this.camera.position.clone();
            posnor.x -= this.view.x;
            posnor.y -= this.view.y;
            posnor.z -= this.view.z;
            posnor.normalize();
            var ViewPitch;
            var CamYaw;
            var MathYaw;
            var ViewYaw1;
            var Yaw;
            ViewPitch = Math.asin(posnor.z);
            this.view.p = ViewPitch * 180.0 / Math.PI;
            if (Math.abs(this.view.p) < PITCHLIMIT) {
                CamYaw = 999;
                var rtof = 1 - (posnor.z * posnor.z);
                ViewYaw1 = Math.acos(posnor.x / Math.sqrt(rtof));
                MathYaw = Math.asin(posnor.y / Math.sqrt(rtof));
                MathYaw = MathYaw * 180.0 / Math.PI;
                if (posnor.x > 0 && posnor.y < 0) {
                    MathYaw = 360 + MathYaw;
                }
                else if (posnor.x < 0) {
                    MathYaw = 180 - MathYaw;
                }
                this.view.r = MathYaw;
            }
            else {
                MathYaw = 999;
                CamYaw = this.camera.rotation.z * 180.0 / Math.PI;
                if ((CamYaw > 90) && (CamYaw < 180)) {
                    CamYaw = CamYaw - 90;
                }
                else {
                    CamYaw = CamYaw + 270;
                }
                if (this.view.p < 0) {
                    var r = CamYaw;
                    CamYaw = 180 - r;
                    CamYaw = 180 - r;
                    if (CamYaw < 0) {
                        CamYaw += 360;
                    }
                }
                this.view.r = CamYaw;
            }
            this.DisplayView(MathYaw, posnor);
            this.view.w = this.Height / (this.camera.zoom * ZOOMIDENTITY);
        }
    };
    return FRCScene3D;
}(FRCScene));
var MAX_NUM_AXES = 9;
var BBOT_IDLE = 0;
var BBOT_BASEGN = 1;
var BBOT_BASEPOD = 2;
var BBOT_AXISGN = 3;
var BBOT_AXISDONE = 4;
var BBOT_RAILGN = 5;
var BBOT_COMPLETE = 6;
var MoveQueue = (function () {
    function MoveQueue() {
    }
    return MoveQueue;
}());
var FRCRobot = (function () {
    function FRCRobot(id, scene) {
        this.num_axes = 0;
        this.linked = false;
        this.phase = BBOT_IDLE;
        this.scene = scene;
        this.axes = new Array();
        this.move = new Array();
        this.id = id;
        this.axvals = new Map();
        this.axvals.set("J1", 0);
        this.axvals.set("J2", 1);
        this.axvals.set("J3", 2);
        this.axvals.set("J4", 3);
        this.axvals.set("J5", 4);
        this.axvals.set("J6", 5);
        this.axvals.set("J7", 6);
        this.axvals.set("J8", 7);
        this.axvals.set("J9", 8);
    }
    FRCRobot.prototype.IsRobot = function (object) {
        if (object == this.basegn) {
            return true;
        }
        for (var idx = 0; idx < this.axes.length; idx++) {
            if (object == this.axes[idx]) {
                return true;
            }
        }
        return false;
    };
    FRCRobot.prototype.SETGN = function (object, id, loc, vis, aid, fid, axischild) {
        if (this.IsRobot(object)) {
            loc = undefined;
        }
        if (object.tagName != "SETAXS") {
            object.SETGN(id, loc, vis, aid, fid);
            switch (this.phase) {
                case BBOT_BASEGN:
                    this.basegn = object;
                    this.phase = BBOT_BASEPOD;
                    break;
                case BBOT_BASEPOD:
                    if (axischild) {
                        this.jnt_gnode = object;
                        object.axis = new FRCAxis(object);
                        this.phase = BBOT_RAILGN;
                    }
                    else {
                        this.phase = BBOT_AXISGN;
                    }
                    break;
                case BBOT_AXISGN:
                    if (axischild) {
                        this.jnt_gnode = object;
                        object.axis = new FRCAxis(object);
                    }
                    break;
                default:
                    if (axischild) {
                        object.axis = new FRCAxis(object);
                        this.jnt_gnode = object;
                        this.phase = BBOT_RAILGN;
                    }
                    else {
                    }
                    break;
            }
        }
    };
    FRCRobot.prototype.SETPOD = function (object, siz, loc, URL, aid, fid) {
        if (this.IsRobot(object)) {
            loc = undefined;
        }
        object.SETPOD(siz, loc, URL, aid, fid);
        switch (this.phase) {
            case BBOT_BASEPOD:
                if ((fid == undefined) || fid == "") {
                    this.basepod = object;
                    this.phase = BBOT_AXISGN;
                    object.axisflag = true;
                    object.podloc = true;
                }
                else {
                }
                break;
            case BBOT_AXISGN:
                if (this.jnt_gnode != undefined) {
                }
                break;
        }
    };
    FRCRobot.prototype.LinkPOD = function (podobj, object) {
        object.axis.podobjects.push(podobj);
        object.URL = podobj.URL;
        podobj.axisflag = true;
        object.scene.StopPolling(podobj);
        object.group.add(podobj.group);
        var vals = object.id.split("/");
        object.axis.id = vals[vals.length - 1];
        if (!FRCUtility.IsIdentity(podobj.loc)) {
            object.podloc = true;
            object.loc = podobj.loc.clone();
        }
        object.invloc.getInverse(object.loc);
    };
    FRCRobot.prototype.SETAXS = function (axis) {
        if (this.phase != BBOT_AXISGN && this.phase != BBOT_RAILGN) {
            console.log("Robot is not in axis state");
            return;
        }
        var object = this.jnt_gnode;
        if (!object.inited) {
        }
        else {
            object.axis.iid = axis.iid;
            object.axis.type = axis.type;
            object.axis.mount = axis.mount;
            object.axis.exec = axis.exec;
            object.tagName = "SETAXS";
            object.axis.host = object;
            object.axisflag = true;
            if (this.phase == BBOT_AXISGN) {
                this.AddAxis(object);
            }
            if (this.phase == BBOT_RAILGN) {
                this.RailAxis(object);
            }
        }
    };
    FRCRobot.prototype.SetPhase = function (phase) {
        this.phase = phase;
    };
    FRCRobot.prototype.RailAxis = function (object) {
        this.AddAxis(object);
        this.phase = BBOT_BASEGN;
        this.jnt_gnode = undefined;
    };
    FRCRobot.prototype.EOF = function () {
        this.phase = BBOT_COMPLETE;
        this.jnt_gnode = undefined;
    };
    FRCRobot.prototype.IntMove = function (injoints) {
        var joints = injoints.split(",");
        for (var idx = 0; idx < joints.length; idx++) {
            this.move[idx] = parseFloat(joints[idx]);
        }
        for (var idx = 0; idx < this.axes.length; idx++) {
            switch (this.axes[idx].axis.type) {
                case POS_LINEAR:
                case NEG_LINEAR:
                    this.axes[idx].axis.UpdateLinearAxis(this);
                    break;
                case M3_3A:
                case M3_3A_ARM:
                case M3_3A_TOP:
                case M3_4A:
                case M3_4A_ARM:
                case M3_6A:
                case M3_6A_ARM:
                    this.axes[idx].axis.UpdateM3(this, M3_GenkotsuIndex);
                    break;
                case M2_4A:
                case M2_4A_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M2_4A_GenkotsuIndex);
                    break;
                case M2_4AL:
                case M2_4AL_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M2_4AL_GenkotsuIndex);
                    break;
                case M2_3A:
                case M2_3A_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M2_3A_GenkotsuIndex);
                    break;
                case M2_3AL:
                case M2_3AL_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M2_3AL_GenkotsuIndex);
                    break;
                case M2_6H:
                case M2_6H_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M2_6H_GenkotsuIndex);
                    break;
                case M2_6HL:
                case M2_6HL_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M2_6HL_GenkotsuIndex);
                    break;
                case M1_4A:
                case M1_4A_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M1_4A_GenkotsuIndex);
                    break;
                case M1_6A:
                case M1_6A_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M1_6A_GenkotsuIndex);
                    break;
                case M1_05AL:
                case M1_05AL_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M1_05AL_GenkotsuIndex);
                    break;
                case M1_05SL:
                case M1_05SL_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M1_05SL_GenkotsuIndex);
                    break;
                case M1_1H:
                case M1_1H_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M1_1H_GenkotsuIndex);
                    break;
                case M1_1HL:
                case M1_1HL_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, M1_1HL_GenkotsuIndex);
                    break;
                case POS_ROTATIONAL:
                case NEG_ROTATIONAL:
                case FOURBAR_POS:
                case FOURBAR_NEG:
                    this.axes[idx].axis.UpdateRotationalAxis(this);
                    break;
                case DR3_8L:
                case DR3_8L_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, DR3_8L_GenkotsuIndex);
                    break;
                case DR3_6M:
                case DR3_6M_ARM:
                    this.axes[idx].axis.UpdateGenkotsu(this, DR3_6M_GenkotsuIndex);
                    break;
                default:
                    console.log("Move type not supported " + this.axes[idx].id);
            }
        }
    };
    FRCRobot.prototype.MOVE = function (injoints, timestamp) {
        if ((injoints == undefined) || (injoints == null)) {
            console.log("No joints");
        }
        else {
            if (this.linked) {
                this.IntMove(injoints);
            }
            else {
                this.lastpos = injoints;
            }
        }
    };
    FRCRobot.prototype.AddAxis = function (host) {
        this.axes.push(host);
        this.num_axes++;
        if (host.axis.iid != undefined) {
            var canvas = FRCCanvas.getInstance();
            var value = FRCIdent.GetDefine(host.scene, host.id, host.axis.iid);
            host.axis.interactor = host.scene.objects.get(this.id + "/" + value);
            if (host.axis.interactor != undefined) {
                host.axis.interaction = true;
            }
        }
        else {
            host.axis.jointzero = host.group.rotation.z;
        }
    };
    FRCRobot.prototype.LinkRobot = function () {
        for (var idx = 0; idx < this.axes.length; idx++) {
            if (idx != 0) {
                this.axes[idx].axis.Configure(this);
            }
        }
        this.linked = true;
        if (this.lastpos !== undefined && this.lastpos != null && this.lastpos != "") {
            this.IntMove(this.lastpos);
        }
        this.Animate();
    };
    FRCRobot.prototype.BuildAxis = function (hostobj, podfile) {
        if (podfile != undefined) {
            hostobj.groupset = true;
            hostobj.group.matrix.identity();
            var normaxis = false;
            if (hostobj.axis != undefined) {
                normaxis = true;
            }
            if (hostobj.podloc) {
                if (normaxis) {
                    if (hostobj.axis.id == "J1") {
                        podfile.InitPodGroup(hostobj.group, hostobj.loc, hostobj.opacity);
                    }
                    else {
                        podfile.InitPodGroup(hostobj.group, hostobj.loc, hostobj.opacity);
                        hostobj.ApplyMatrix(hostobj.invloc);
                    }
                }
                else {
                    podfile.InitPodGroup(hostobj.group, hostobj.loc, hostobj.opacity);
                }
            }
            else {
                podfile.InitPodGroup(hostobj.group, undefined, hostobj.opacity);
                hostobj.ApplyMatrix(hostobj.loc);
            }
        }
    };
    FRCRobot.prototype.BuildRobot = function () {
        var hostobj;
        var canvas = FRCCanvas.getInstance();
        var podfile = canvas.globals.podfiles.get(this.basepod.URL);
        this.BuildAxis(this.basepod, podfile);
        for (var axidx = 0; axidx < this.axes.length; axidx++) {
            hostobj = this.axes[axidx];
            for (var idx = 0; idx < hostobj.axis.podobjects.length; idx++) {
                podfile = canvas.globals.podfiles.get(hostobj.axis.podobjects[idx].URL);
                this.BuildAxis(hostobj, podfile);
            }
        }
        this.LinkRobot();
    };
    FRCRobot.prototype.Animate = function () {
        if (this.linked) {
        }
        else {
            var canvas = FRCCanvas.getInstance();
            if (this.phase != BBOT_COMPLETE) {
                return;
            }
            if (this.basepod != undefined) {
                var podfile = canvas.globals.podfiles.get(this.basepod.URL);
                if ((podfile == undefined) || (!podfile.IsLoaded)) {
                    return;
                }
                for (var idx = 0; idx < this.axes.length; idx++) {
                    podfile = canvas.globals.podfiles.get(this.axes[idx].URL);
                    if ((podfile != undefined) && (!podfile.IsLoaded)) {
                        return;
                    }
                }
                this.BuildRobot();
            }
            else {
                this.LinkRobot();
            }
            this.scene.Render();
        }
    };
    return FRCRobot;
}());
var _a;
var POS_ROTATIONAL = 1;
var NEG_ROTATIONAL = 2;
var POS_LINEAR = 3;
var NEG_LINEAR = 4;
var NOLINKS = 5;
var M3_4A = 5;
var M3_4A_ARM = 6;
var FOURBAR_POS = 7;
var FOURBAR_NEG = 8;
var COMPUTATIONAL = 9;
var M3_6A = 10;
var M3_6A_ARM = 11;
var M3_3A = 12;
var M3_3A_ARM = 13;
var M3_3A_TOP = 14;
var M2_4AL = 15;
var M2_4AL_ARM = 16;
var M2_4A = 17;
var M2_4A_ARM = 18;
var M1_4A = 19;
var M1_4A_ARM = 20;
var M1_6A = 21;
var M1_6A_ARM = 22;
var M1_1H = 23;
var M1_1H_ARM = 24;
var M2_6H = 25;
var M2_6H_ARM = 26;
var M2_6HL = 27;
var M2_6HL_ARM = 28;
var M1_05AL = 29;
var M1_05AL_ARM = 30;
var M1_05SL = 31;
var M1_05SL_ARM = 32;
var M1_1HL = 33;
var M1_1HL_ARM = 34;
var M2_3AL = 35;
var M2_3AL_ARM = 36;
var M2_3A = 37;
var M2_3A_ARM = 38;
var DR3_8L = 39;
var DR3_8L_ARM = 40;
var DR3_6M = 41;
var DR3_6M_ARM = 42;
var M2_4A_GenkotsuIndex = 0;
var M2_4AL_GenkotsuIndex = 1;
var M1_4A_GenkotsuIndex = 2;
var M1_6A_GenkotsuIndex = 3;
var M2_6H_GenkotsuIndex = 4;
var M2_6HL_GenkotsuIndex = 5;
var M1_1H_GenkotsuIndex = 6;
var M1_05AL_GenkotsuIndex = 7;
var M1_05SL_GenkotsuIndex = 8;
var M1_1HL_GenkotsuIndex = 9;
var M2_3A_GenkotsuIndex = 10;
var M2_3AL_GenkotsuIndex = 11;
var M3_GenkotsuIndex = 12;
var DR3_8L_GenkotsuIndex = 13;
var DR3_6M_GenkotsuIndex = 14;
var rad_120 = 3.1415926535 * 2.0 / 3.0;
var rad_240 = 3.1415926535 * 4.0 / 3.0;
var M1_MOTOR_ZERO_ANGLE = 0.69813170079773183076947630739545;
var GENKOTSU_J6_COS30 = 0.86602540378443864676372317075294;
var PVRT_PI_OVER_TWOf = 3.1415926535 / 2.0;
var GenkotsuAxes = (_a = {},
    _a[0] = {
        axis_type: M2_4A,
        arm_type: M2_4A_ARM,
        arm_len: 271.13,
        link_len: 670.5,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 76.5,
        wrist_height: -88.5,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[1] = {
        axis_type: M2_4AL,
        arm_type: M2_4AL_ARM,
        arm_len: 380.0,
        link_len: 890.0,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 70.0,
        wrist_height: -88.5,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[2] = {
        axis_type: M1_4A,
        arm_type: M1_4A_ARM,
        arm_len: 100.0,
        link_len: 270.0,
        motor_zero_len: 110.0,
        motor_zero_angle: M1_MOTOR_ZERO_ANGLE,
        ujoint_offset: 40.0,
        wrist_height: -15.0,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[3] = {
        axis_type: M1_6A,
        arm_type: M1_6A_ARM,
        arm_len: 100.0,
        link_len: 270.0,
        motor_zero_len: 110.0,
        motor_zero_angle: M1_MOTOR_ZERO_ANGLE,
        ujoint_offset: 40.0,
        wrist_height: -15.0,
        wrist_j4_z: 39.0,
        j4_j5_x: 39.5,
        j5_j6_z: 29.0,
        j6_angle: GENKOTSU_J6_COS30,
        j6_flange_z: 7.0
    },
    _a[4] = {
        axis_type: M2_6H,
        arm_type: M2_6H_ARM,
        arm_len: 270.0,
        link_len: 680.0,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 70.0,
        wrist_height: -8.5,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[5] = {
        axis_type: M2_6HL,
        arm_type: M2_6HL_ARM,
        arm_len: 380.0,
        link_len: 890.0,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 70.0,
        wrist_height: -8.5,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[6] = {
        axis_type: M1_1H,
        arm_type: M1_1H_ARM,
        arm_len: 100.0,
        link_len: 270.0,
        motor_zero_len: 110.0,
        motor_zero_angle: M1_MOTOR_ZERO_ANGLE,
        ujoint_offset: 40.0,
        wrist_height: -4.75,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[7] = {
        axis_type: M1_05AL,
        arm_type: M1_05AL_ARM,
        arm_len: 150.0,
        link_len: 405.0,
        motor_zero_len: 110.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 40.0,
        wrist_height: -15.0,
        wrist_j4_z: 39.0,
        j4_j5_x: 39.5,
        j5_j6_z: 29.0,
        j6_angle: GENKOTSU_J6_COS30,
        j6_flange_z: 7.0
    },
    _a[8] = {
        axis_type: M1_05SL,
        arm_type: M1_05SL_ARM,
        arm_len: 150.0,
        link_len: 405.0,
        motor_zero_len: 110.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 40.0,
        wrist_height: -15.0,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[9] = {
        axis_type: M1_1HL,
        arm_type: M1_1HL_ARM,
        arm_len: 150.0,
        link_len: 405.0,
        motor_zero_len: 110.0,
        motor_zero_angle: M1_MOTOR_ZERO_ANGLE,
        ujoint_offset: 40.0,
        wrist_height: -4.75,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[10] = {
        axis_type: M2_3A,
        arm_type: M2_3A_ARM,
        arm_len: 270.0,
        link_len: 680.0,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 70.0,
        wrist_height: 0.0,
        wrist_j4_z: 140.0,
        j4_j5_x: 71.0,
        j5_j6_z: 59.5,
        j6_angle: GENKOTSU_J6_COS30,
        j6_flange_z: 7.0
    },
    _a[11] = {
        axis_type: M2_3AL,
        arm_type: M2_3AL_ARM,
        arm_len: 390.0,
        link_len: 870.0,
        motor_zero_len: 165.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 70.0,
        wrist_height: 115.0,
        wrist_j4_z: 140.0,
        j4_j5_x: 71.0,
        j5_j6_z: 59.5,
        j6_angle: GENKOTSU_J6_COS30,
        j6_flange_z: 7.0
    },
    _a[12] = {
        axis_type: M3_3A,
        arm_type: M3_3A_ARM,
        arm_len: 390.0,
        link_len: 870.0,
        motor_zero_len: 165.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 90.0,
        wrist_height: 115.0,
        wrist_j4_z: 180.0,
        j4_j5_x: 100.0,
        j5_j6_z: 75.0,
        j6_angle: GENKOTSU_J6_COS30,
        j6_flange_z: 10.0
    },
    _a[13] = {
        axis_type: DR3_8L,
        arm_type: DR3_8L_ARM,
        arm_len: 565.0,
        link_len: 1260.0,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 75.0,
        wrist_height: -126.0,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a[14] = {
        axis_type: DR3_6M,
        arm_type: DR3_6M_ARM,
        arm_len: 410.0,
        link_len: 950.0,
        motor_zero_len: 140.0,
        motor_zero_angle: PVRT_PI_OVER_TWOf,
        ujoint_offset: 83.0,
        wrist_height: -50.46,
        wrist_j4_z: 0.0,
        j4_j5_x: 0.0,
        j5_j6_z: 0.0,
        j6_angle: 0.0,
        j6_flange_z: 0.0
    },
    _a);
var FRCAxis = (function () {
    function FRCAxis(host) {
        this.curr_angle = 0;
        this.interaction = false;
        this.jointzero = 0.0;
        if (host != undefined) {
            this.host = host;
            this.podobjects = new Array();
            var vals = host.id.split("/");
            this.id = vals[vals.length - 1];
        }
    }
    FRCAxis.prototype.ComputeOffset = function (move) {
        var result;
        var tokens = this.exec.split(" ");
        var stack = [];
        var first;
        var second;
        for (var i = 0; i < tokens.length; i++) {
            var token = tokens[i];
            if (token === '*') {
                second = stack.pop();
                first = stack.pop();
                if (typeof first == 'undefined') {
                    first = 1;
                }
                if (typeof second == 'undefined') {
                    second = 1;
                }
                stack.push(first * second);
            }
            else if (token == '/') {
                second = stack.pop();
                first = stack.pop();
                stack.push(first / second);
            }
            else if (token == '+') {
                second = stack.pop();
                first = stack.pop();
                stack.push(first + second);
            }
            else if (token == '-') {
                second = stack.pop();
                first = stack.pop();
                stack.push(first - second);
            }
            else if (token == '!') {
                second = stack.pop();
                stack.push(-second);
            }
            else {
                if (token.charAt(0) == 'J') {
                    var jnum = Number(token.charAt(1));
                    if ((jnum == 0) || (jnum == Number.MIN_SAFE_INTEGER) || (jnum == Number.MAX_SAFE_INTEGER)) {
                    }
                    else
                        jnum = --jnum;
                    stack.push(move[jnum]);
                }
                else {
                    stack.push(token);
                }
            }
        }
        result = stack[0];
        return result;
    };
    FRCAxis.prototype.LineMove = function (mat) {
        var matrix = new THREE.Matrix4;
        var temp = new THREE.Group();
        matrix.multiplyMatrices(this.host.loc, mat);
        temp.applyMatrix(matrix);
        this.host.group.position.x = temp.position.x;
        this.host.group.position.y = temp.position.y;
        this.host.group.position.z = temp.position.z;
        this.host.group.rotation.x = temp.rotation.x;
        this.host.group.rotation.y = temp.rotation.y;
        this.host.group.rotation.z = temp.rotation.z;
    };
    FRCAxis.prototype.RotMove = function (joint) {
        var interaction;
        if (!this.interaction) {
            interaction = 0;
        }
        else {
            if (this.type == FOURBAR_NEG) {
                interaction = 0;
            }
            else {
                interaction = this.interactor.axis.curr_angle - this.interactor.axis.jointzero;
                if (this.interactor.axis.iid != undefined) {
                    interaction = interaction + this.interactor.axis.interactor.axis.curr_angle;
                }
            }
        }
        this.curr_angle = (Math.PI / 180 * joint) + this.jointzero - interaction;
        this.host.group.rotation.z = this.curr_angle;
    };
    FRCAxis.prototype.GenMove = function (mat) {
        var xyzwpr = new FRCXYZWPR();
        FRCUtility.ToXyzWpr(mat, xyzwpr);
        if ((this.id == "J1") || (this.id == "J2") || (this.id == "J3")) {
            this.RotMove(xyzwpr.r);
        }
        else {
            var temp = new THREE.Group();
            temp.applyMatrix(mat);
            this.host.group.position.x = temp.position.x;
            this.host.group.position.y = temp.position.y;
            this.host.group.position.z = temp.position.z;
            this.host.group.rotation.x = temp.rotation.x;
            this.host.group.rotation.y = temp.rotation.y;
            this.host.group.rotation.z = temp.rotation.z;
        }
    };
    FRCAxis.prototype.GetAxisValue = function (robot) {
        var jntidx = robot.axvals.get(this.id);
        var value = 0;
        if (jntidx == undefined) {
            jntidx = Number(this.id.charAt(1)) - 1;
            if (this.exec == undefined) {
            }
            else {
                jntidx = robot.axvals.get(this.exec);
                if (jntidx == undefined) {
                    value = this.ComputeOffset(robot.move);
                }
            }
        }
        if (jntidx != undefined) {
            if (this.exec == undefined) {
                if ((this.type == FOURBAR_POS) || (this.type == FOURBAR_NEG)) {
                    value = -robot.move[jntidx];
                    if (this.interaction) {
                        jntidx = robot.axvals.get(this.iid);
                        value -= robot.move[jntidx];
                    }
                    if (this.type == FOURBAR_NEG) {
                        value = -value;
                    }
                }
                else {
                    value = robot.move[jntidx];
                    if ((this.type == NEG_ROTATIONAL) || (this.type == NEG_LINEAR)) {
                        value = -value;
                    }
                }
            }
            else {
                value = this.ComputeOffset(robot.move);
            }
        }
        return value;
    };
    FRCAxis.prototype.UpdateLinearAxis = function (robot) {
        var value = 0;
        value = this.GetAxisValue(robot);
        var Transform = new THREE.Matrix4();
        Transform.identity();
        Transform.elements[14] = value;
        this.LineMove(Transform);
    };
    FRCAxis.prototype.UpdateRotationalAxis = function (robot) {
        var value = 0;
        value = this.GetAxisValue(robot);
        this.RotMove(value);
        var ct = Math.cos(FRCUtility.DEG_TO_RAD(value));
        var st = Math.sin(FRCUtility.DEG_TO_RAD(value));
        var Transform = new THREE.Matrix4();
        Transform.identity();
        Transform.elements[0] = ct;
        Transform.elements[1] = st;
        Transform.elements[4] = -st;
        Transform.elements[5] = ct;
    };
    FRCAxis.prototype.UpdateGenkotsu = function (robot, GenkotsuIndex) {
        var mat = new THREE.Matrix4();
        var b = new THREE.Vector3();
        var Transform = new THREE.Matrix4();
        Transform.identity();
        var jointnum = this.id.substr(0, 2);
        if (GenkotsuAxes[GenkotsuIndex].j6_flange_z > 0.0) {
            var mat2 = new THREE.Matrix4();
            var j4 = FRCUtility.DEG_TO_RAD(robot.move[3]);
            var j5 = FRCUtility.DEG_TO_RAD(robot.move[4]);
            var j6 = FRCUtility.DEG_TO_RAD(robot.move[5]);
            var c4 = Math.cos(j4);
            var c5 = Math.cos(j5);
            var c6 = Math.cos(j6);
            var s4 = Math.sin(j4);
            var s5 = Math.sin(j5);
            var s6 = Math.sin(j6);
            mat.elements[0] = c4 * c6 - s4 * c5 * s6;
            mat.elements[1] = s4 * c6 + c4 * c5 * s6;
            mat.elements[2] = s5 * s6;
            mat.elements[4] = s4 * c5 * c6 + c4 * s6;
            mat.elements[5] = -c4 * c5 * c6 + s4 * s6;
            mat.elements[6] = -s5 * c6;
            mat.elements[8] = -s4 * s5;
            mat.elements[9] = c4 * s5;
            mat.elements[10] = -c5;
            mat.elements[12] = GenkotsuAxes[GenkotsuIndex].j4_j5_x * c4 - GenkotsuAxes[GenkotsuIndex].j5_j6_z * s4 * s5;
            mat.elements[13] = GenkotsuAxes[GenkotsuIndex].j4_j5_x * s4 + GenkotsuAxes[GenkotsuIndex].j5_j6_z * c4 * s5;
            mat.elements[14] = -GenkotsuAxes[GenkotsuIndex].wrist_j4_z - GenkotsuAxes[GenkotsuIndex].j5_j6_z * c5;
            mat2.elements[0] = GenkotsuAxes[GenkotsuIndex].j6_angle;
            mat2.elements[1] = 0.0;
            mat2.elements[2] = -0.5;
            mat2.elements[4] = 0.0;
            mat2.elements[5] = 1.0;
            mat2.elements[6] = 0.0;
            mat2.elements[8] = 0.5;
            mat2.elements[9] = 0.0;
            mat2.elements[10] = GenkotsuAxes[GenkotsuIndex].j6_angle;
            mat2.elements[12] = GenkotsuAxes[GenkotsuIndex].j6_flange_z / 2.0;
            mat2.elements[13] = 0.0;
            mat2.elements[14] = GenkotsuAxes[GenkotsuIndex].j6_flange_z * GenkotsuAxes[GenkotsuIndex].j6_angle;
            mat.multiply(mat2);
            mat2.makeTranslation(-mat.elements[12], -mat.elements[13], -mat.elements[14]);
            var xyzwpr = new FRCXYZWPR();
            xyzwpr.x = robot.move[0];
            xyzwpr.y = robot.move[1];
            xyzwpr.z = robot.move[2];
            FRCUtility.postTranslate(xyzwpr.x, xyzwpr.y, xyzwpr.z, mat2);
            FRCUtility.ToXyzWpr(mat2, xyzwpr);
            mat.identity();
            b.x = xyzwpr.x;
            b.y = xyzwpr.y;
            b.z = xyzwpr.z;
        }
        else {
            b.x = robot.move[0];
            b.y = robot.move[1];
            b.z = robot.move[2] - GenkotsuAxes[GenkotsuIndex].wrist_height;
        }
        if ((jointnum == "J4") && (this.type == GenkotsuAxes[GenkotsuIndex].axis_type)) {
            FRCUtility.MatFromXYZWPR(b.x, b.y, b.z, 0, 0, 0, mat);
            Transform = mat;
        }
        else {
            if (jointnum == "J2") {
                var rot = new THREE.Matrix4();
                FRCUtility.RotationZ(rad_120, rot);
                mat.multiply(rot);
                FRCUtility.postTranslate(b.x, b.y, b.z, mat);
                b.x = FRCUtility.LOCX(mat);
                b.y = FRCUtility.LOCY(mat);
                b.z = FRCUtility.LOCZ(mat);
            }
            else if (jointnum == "J3") {
                var rot = new THREE.Matrix4();
                FRCUtility.RotationZ(rad_240, rot);
                mat.multiply(rot);
                FRCUtility.postTranslate(b.x, b.y, b.z, mat);
                b.x = FRCUtility.LOCX(mat);
                b.y = FRCUtility.LOCY(mat);
                b.z = FRCUtility.LOCZ(mat);
            }
            var r0 = Math.sqrt(GenkotsuAxes[GenkotsuIndex].link_len * GenkotsuAxes[GenkotsuIndex].link_len - b.y * b.y);
            var r1 = GenkotsuAxes[GenkotsuIndex].arm_len;
            var c = (GenkotsuAxes[GenkotsuIndex].motor_zero_len - GenkotsuAxes[GenkotsuIndex].ujoint_offset + b.x);
            var d = Math.sqrt(b.z * b.z + c * c);
            var a = (r0 * r0 - r1 * r1 + d * d) / (d * 2.0);
            var P1 = new THREE.Vector3(-GenkotsuAxes[GenkotsuIndex].motor_zero_len + GenkotsuAxes[GenkotsuIndex].ujoint_offset - b.x, 0.0, -b.z);
            var P2 = new THREE.Vector3(0, 0, 0);
            var P3 = new THREE.Vector3(0, 0, 0);
            var P4 = new THREE.Vector3(0, 0, 0);
            if (r0 < a) {
                r0 = a + 0.01;
            }
            var T = new THREE.Vector3();
            var h = Math.sqrt(r0 * r0 - a * a);
            T = P1.clone();
            T.multiplyScalar(a / d);
            P2.add(T);
            P3 = P2.clone();
            T.set(P1.z, 0.0, P1.x);
            T.multiplyScalar(-h / d);
            P3.add(T);
            P4 = P2.clone();
            T.set(P1.z, 0.0, P1.x);
            T.multiplyScalar(h / d);
            P4.add(T);
            if (this.type == GenkotsuAxes[GenkotsuIndex].axis_type) {
                var mat = new THREE.Matrix4();
                var rot = new THREE.Matrix4();
                if (jointnum == "J1") {
                    mat.identity();
                }
                else if (jointnum == "J2") {
                    FRCUtility.RotationZ(rad_120, mat);
                }
                else if (jointnum == "J3") {
                    FRCUtility.RotationZ(-rad_120, mat);
                }
                FRCUtility.postTranslate(-GenkotsuAxes[GenkotsuIndex].motor_zero_len, 0, 0, mat);
                var ay = b.x - GenkotsuAxes[GenkotsuIndex].ujoint_offset + P3.x + GenkotsuAxes[GenkotsuIndex].motor_zero_len;
                var ax = -b.z - P4.z;
                var angle = -Math.atan2(ay, ax) - GenkotsuAxes[GenkotsuIndex].motor_zero_angle;
                FRCUtility.RotationY(angle, rot);
                mat.multiply(rot);
                var xyzwpr = new FRCXYZWPR();
                FRCUtility.ToXyzWpr(mat, xyzwpr);
                mat.identity();
                FRCUtility.MatFromXYZWPR(0, 0, 0, 0, 0, xyzwpr.p, mat);
                Transform = mat;
            }
            else if (this.type === GenkotsuAxes[GenkotsuIndex].arm_type) {
                var mat = new THREE.Matrix4();
                var rot = new THREE.Matrix4();
                var trans = new THREE.Matrix4();
                var angle = Math.atan2(P3.x, P4.z);
                FRCUtility.RotationY(-angle, mat);
                angle = Math.asin(b.y / GenkotsuAxes[GenkotsuIndex].link_len);
                FRCUtility.RotationX(-angle, rot);
                mat.multiply(rot);
                trans.makeTranslation(b.x - GenkotsuAxes[GenkotsuIndex].ujoint_offset + P3.x, 0, b.z + P4.z);
                mat = mat.multiplyMatrices(trans, mat);
                if (jointnum == "J2") {
                    FRCUtility.RotationZ(-rad_120, rot);
                    mat = mat.multiplyMatrices(rot, mat);
                }
                else if (jointnum == "J3") {
                    FRCUtility.RotationZ(rad_120, rot);
                    mat = mat.multiplyMatrices(rot, mat);
                }
                trans.makeTranslation(0.0, 0.0, -(GenkotsuAxes[GenkotsuIndex].link_len / 2.0));
                mat.multiply(trans);
                Transform = mat;
            }
        }
        this.GenMove(Transform);
    };
    FRCAxis.prototype.UpdateM3 = function (robot, GenkotsuIndex) {
        var mat = new THREE.Matrix4();
        var fp_z = 0;
        var b = new THREE.Vector3();
        var Transform = new THREE.Matrix4();
        Transform.identity();
        var jointnum = this.id.substr(0, 2);
        if ((this.type == M3_6A) || (this.type == M3_6A_ARM)) {
            var mat2 = new THREE.Matrix4();
            var j4 = FRCUtility.DEG_TO_RAD(robot.move[3]);
            var j5 = FRCUtility.DEG_TO_RAD(robot.move[4]);
            var j6 = FRCUtility.DEG_TO_RAD(robot.move[5]);
            var c4 = Math.cos(j4);
            var c5 = Math.cos(j5);
            var c6 = Math.cos(j6);
            var s4 = Math.sin(j4);
            var s5 = Math.sin(j5);
            var s6 = Math.sin(j6);
            mat.elements[0] = c4 * c6 - s4 * c5 * s6;
            mat.elements[1] = s4 * c6 + c4 * c5 * s6;
            mat.elements[2] = s5 * s6;
            mat.elements[4] = s4 * c5 * c6 + c4 * s6;
            mat.elements[5] = -c4 * c5 * c6 + s4 * s6;
            mat.elements[6] = -s5 * c6;
            mat.elements[8] = -s4 * s5;
            mat.elements[9] = c4 * s5;
            mat.elements[10] = -c5;
            mat.elements[12] = GenkotsuAxes[GenkotsuIndex].j4_j5_x * c4 - GenkotsuAxes[GenkotsuIndex].j5_j6_z * s4 * s5;
            mat.elements[13] = GenkotsuAxes[GenkotsuIndex].j4_j5_x * s4 + GenkotsuAxes[GenkotsuIndex].j5_j6_z * c4 * s5;
            mat.elements[14] = -GenkotsuAxes[GenkotsuIndex].wrist_j4_z - GenkotsuAxes[GenkotsuIndex].j5_j6_z * c5;
            mat2.elements[0] = GenkotsuAxes[GenkotsuIndex].j6_angle;
            mat2.elements[1] = 0.0;
            mat2.elements[2] = -0.5;
            mat2.elements[4] = 0.0;
            mat2.elements[5] = 1.0;
            mat2.elements[6] = 0.0;
            mat2.elements[8] = 0.5;
            mat2.elements[9] = 0.0;
            mat2.elements[10] = GenkotsuAxes[GenkotsuIndex].j6_angle;
            mat2.elements[12] = GenkotsuAxes[GenkotsuIndex].j6_flange_z / 2.0;
            mat2.elements[13] = 0.0;
            mat2.elements[14] = GenkotsuAxes[GenkotsuIndex].j6_flange_z * GenkotsuAxes[GenkotsuIndex].j6_angle;
            mat.multiply(mat2);
            mat2.makeTranslation(-mat.elements[12], -mat.elements[13], -mat.elements[14]);
            var xyzwpr = new FRCXYZWPR();
            xyzwpr.x = robot.move[0];
            xyzwpr.y = robot.move[1];
            xyzwpr.z = robot.move[2];
            FRCUtility.postTranslate(xyzwpr.x, xyzwpr.y, xyzwpr.z, mat2);
            FRCUtility.ToXyzWpr(mat2, xyzwpr);
            mat.identity();
            b.x = xyzwpr.x;
            b.y = xyzwpr.y;
            fp_z = xyzwpr.z;
            b.z = fp_z;
        }
        else if ((this.type == M3_4A) || (this.type == M3_4A_ARM)) {
            b.x = robot.move[0];
            b.y = robot.move[1];
            fp_z = robot.move[2];
            b.z = fp_z + GenkotsuAxes[GenkotsuIndex].wrist_height;
        }
        else if ((this.type == M3_3A) || (this.type == M3_3A_ARM) || (this.type == M3_3A_TOP)) {
            b.x = robot.move[0];
            b.y = robot.move[1];
            fp_z = robot.move[2];
            b.z = fp_z;
        }
        if ((jointnum == "J4") && ((this.type == M3_4A) || (this.type == M3_6A))) {
            FRCUtility.MatFromXYZWPR(b.x, b.y, b.z, 0, 0, 0, mat);
            Transform = mat;
        }
        else if (this.type == M3_3A_TOP) {
            FRCUtility.MatFromXYZWPR(b.x, b.y, b.z, 0, 0, 0, mat);
            Transform = mat;
        }
        else {
            if (jointnum == "J2") {
                var rot = new THREE.Matrix4();
                rot.identity();
                FRCUtility.RotationZ(rad_120, rot);
                mat.multiply(rot);
                FRCUtility.postTranslate(b.x, b.y, b.z, mat);
                b.x = FRCUtility.LOCX(mat);
                b.y = FRCUtility.LOCY(mat);
                b.z = FRCUtility.LOCZ(mat);
            }
            else if (jointnum == "J3") {
                var rot = new THREE.Matrix4();
                FRCUtility.RotationZ(rad_240, rot);
                mat.multiply(rot);
                FRCUtility.postTranslate(b.x, b.y, b.z, mat);
                b.x = FRCUtility.LOCX(mat);
                b.y = FRCUtility.LOCY(mat);
                b.z = FRCUtility.LOCZ(mat);
            }
            var r0 = Math.sqrt(GenkotsuAxes[GenkotsuIndex].link_len * GenkotsuAxes[GenkotsuIndex].link_len - b.y * b.y);
            var r1 = GenkotsuAxes[GenkotsuIndex].arm_len;
            var c = (GenkotsuAxes[GenkotsuIndex].motor_zero_len - GenkotsuAxes[GenkotsuIndex].ujoint_offset + b.x);
            var d = Math.sqrt(b.z * b.z + c * c);
            var a = (r0 * r0 - r1 * r1 + d * d) / (d * 2.0);
            var P1 = new THREE.Vector3(-GenkotsuAxes[GenkotsuIndex].motor_zero_len + GenkotsuAxes[GenkotsuIndex].ujoint_offset - b.x, 0.0, -b.z);
            var P2 = new THREE.Vector3(0, 0, 0);
            var P3 = new THREE.Vector3(0, 0, 0);
            var P4 = new THREE.Vector3(0, 0, 0);
            if (r0 > a) {
                var T = new THREE.Vector3();
                var h = Math.sqrt(r0 * r0 - a * a);
                T = P1.clone();
                T.multiplyScalar(a / d);
                P2.add(T);
                P3 = P2.clone();
                T.set(P1.z, 0.0, P1.x);
                T.multiplyScalar(-h / d);
                P3.add(T);
                P4 = P2.clone();
                T.set(P1.z, 0.0, P1.x);
                T.multiplyScalar(h / d);
                P4.add(T);
                if ((this.type == M3_3A) || (this.type == M3_4A) || (this.type == M3_6A)) {
                    var mat = new THREE.Matrix4();
                    var rot = new THREE.Matrix4();
                    if (jointnum == "J1") {
                        mat.identity();
                    }
                    else if (jointnum == "J2") {
                        FRCUtility.RotationZ(rad_120, mat);
                    }
                    else if (jointnum == "J3") {
                        FRCUtility.RotationZ(-rad_120, mat);
                    }
                    FRCUtility.postTranslate(-GenkotsuAxes[GenkotsuIndex].motor_zero_len, 0, 0, mat);
                    var ay = b.x - GenkotsuAxes[GenkotsuIndex].ujoint_offset + P3.x + GenkotsuAxes[GenkotsuIndex].motor_zero_len;
                    var ax = -b.z - P4.z;
                    var angle = -Math.atan2(ay, ax) - GenkotsuAxes[GenkotsuIndex].motor_zero_angle + 0.08;
                    FRCUtility.RotationY(angle, rot);
                    mat.multiply(rot);
                    var xyzwpr = new FRCXYZWPR();
                    FRCUtility.ToXyzWpr(mat, xyzwpr);
                    mat.identity();
                    FRCUtility.MatFromXYZWPR(0, 0, 0, 0, 0, xyzwpr.p, mat);
                    Transform = mat;
                }
                else if ((this.type == M3_3A_ARM) || (this.type == M3_4A_ARM) || (this.type == M3_6A_ARM)) {
                    var mat = new THREE.Matrix4();
                    var rot = new THREE.Matrix4();
                    var trans = new THREE.Matrix4();
                    var angle = Math.atan2(P3.x, P4.z);
                    FRCUtility.RotationY(-angle, mat);
                    angle = Math.asin(b.y / GenkotsuAxes[GenkotsuIndex].link_len);
                    FRCUtility.RotationX(-angle, rot);
                    mat.multiply(rot);
                    trans.makeTranslation(b.x - GenkotsuAxes[GenkotsuIndex].ujoint_offset + P3.x, 0, b.z + P4.z);
                    mat = mat.multiplyMatrices(trans, mat);
                    if (jointnum == "J2") {
                        FRCUtility.RotationZ(-rad_120, rot);
                        mat = mat.multiplyMatrices(rot, mat);
                    }
                    else if (jointnum == "J3") {
                        FRCUtility.RotationZ(rad_120, rot);
                        mat = mat.multiplyMatrices(rot, mat);
                    }
                    trans.makeTranslation(0.0, 0.0, -(GenkotsuAxes[GenkotsuIndex].link_len / 2.0));
                    mat.multiply(trans);
                    Transform = mat;
                }
            }
        }
        this.GenMove(Transform);
    };
    FRCAxis.prototype.Configure = function (robot) {
        var parentm = new THREE.Matrix4();
        var hostobj = this.host;
        if (this.iid != undefined) {
            var canvas = FRCCanvas.getInstance();
            var value = FRCIdent.GetDefine(this.host.scene, robot.id, this.iid);
            this.interactor = hostobj.scene.objects.get(robot.id + "/" + value);
            if (this.interactor != undefined) {
                var xyzwpr = new FRCXYZWPR();
                this.interaction = true;
                FRCUtility.ToXyzWpr(hostobj.loc, xyzwpr);
                if (!FRCUtility.IsZero(xyzwpr.r)) {
                    this.jointzero = FRCUtility.DEG_TO_RAD(xyzwpr.r);
                }
            }
        }
        parentm = hostobj.parent.loc.clone();
        if (hostobj.podloc) {
            hostobj.ApplyMatrix(parentm);
        }
    };
    return FRCAxis;
}());
var DELEGATECLICK = 1;
var DELEGATEMOVE = 2;
var FRCSprite = (function (_super) {
    __extends(FRCSprite, _super);
    function FRCSprite(id, scene, parent, tag, loc, height, width, texturl, aid, fid, pointerEvents) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.lastposx = 10000000;
        _this.lastposy = 10000000;
        _this.playerfc = 0;
        _this.MouseEngaged = false;
        _this.InitObject(_this.siz, loc, undefined, aid, fid, undefined, tag, true);
        _this.pixeloffset = (_this.id.substr(0, 5) == "/menu");
        _this.pointerEvents = pointerEvents;
        if (FRCSprite.divmap == undefined) {
            FRCSprite.divmap = new Map();
        }
        if (!_this.scene.UseVR) {
            _this.div = document.createElement("div");
            _this.div.id = _this.id;
            document.body.appendChild(_this.div);
            if (!pointerEvents) {
                _this.div.style.pointerEvents = "none";
            }
            else {
                _this.div.onclick = _this.onclick;
                _this.div.onmousemove = _this.onmousemove;
                _this.div.onmouseup = _this.onmouseup;
                _this.div.onmousedown = _this.onmousedown;
                _this.div.onmouseleave = _this.onmouseleave;
            }
        }
        _this.AddSprite();
        FRCSprite.divmap.set(_this.id, _this);
        if (tag == "SETTXT") {
            _this.SETTXT(loc, texturl, height, width, aid, pointerEvents);
        }
        else {
            _this.SETSPR(loc, texturl, height, width, aid, pointerEvents);
        }
        return _this;
    }
    FRCSprite.prototype.AddSprite = function () {
        var allocated = false;
        for (var idx = 0; idx < this.scene.spritelist.length; idx++) {
            if (undefined == this.scene.spritelist[idx]) {
                this.scene.spritelist[idx] = this;
                allocated = true;
                break;
            }
        }
        if (!allocated) {
            this.scene.spritelist.push(this);
        }
    };
    FRCSprite.prototype.DelSprite = function () {
        for (var idx = 0; idx < this.scene.spritelist.length; idx++) {
            if (this == this.scene.spritelist[idx]) {
                this.scene.spritelist[idx] = undefined;
            }
        }
    };
    FRCSprite.prototype.CheckDiv = function (xcoor, ycoor) {
        if (this.div === undefined) {
            return false;
        }
        if (this.div.hidden) {
            return false;
        }
        if ((xcoor < this.left) || (xcoor > this.left + this.width)) {
            return false;
        }
        if ((ycoor < this.top) || (ycoor > this.top + this.height)) {
            return false;
        }
        if (this.playerfc == 0) {
            console.log("Selected " + this.id);
            var selected = '&inst=' + this.scene.tpgl_instance + '&select=' + this.id;
            FRCCanvas.draw3d_SendPkt(TPGL_SELECT_FC, this.scene.ctrl_data, selected);
        }
        return true;
    };
    FRCSprite.prototype.SETTXT = function (loc, text, height, width, aid, pointerEvents) {
        if (this.div === undefined) {
            return;
        }
        if (loc !== undefined) {
            this.loc = loc.clone();
            if (this.groupset) {
                this.group.matrix = loc.clone();
                this.ApplyMatrix(this.frameoff);
            }
        }
        if (aid !== undefined) {
            this.SetAid(aid);
        }
        var attribute = FRCAttribute.GetAttribute(this.aid);
        this.div.style.fontFamily = attribute.font;
        this.div.style.fontSize = attribute.pnt.toString();
        this.div.hidden = false;
        this.text = text;
        if ("Verdana" == attribute.font) {
            this.width = text.length * attribute.pnt / 1.2;
        }
        else {
            this.width = text.length * attribute.pnt;
        }
        this.div.style.width = this.width + "px";
        this.height = attribute.pnt + 10;
        this.div.style.height = this.height + "px";
        var color = new THREE.Color(attribute.bgcolor);
        var clr = "rgba(" + color.r * 255 + ", " + color.g * 255 + ", " + color.b * 255 + ", " + attribute.opac / 100.0 + ")";
        this.div.style.background = clr;
        var fcolor = new THREE.Color(attribute.color);
        clr = "rgba(" + fcolor.r * 255 + ", " + fcolor.g * 255 + ", " + fcolor.b * 255 + ", " + 1.0 + ")";
        this.div.style.color = clr;
        this.div.innerText = text;
        this.div.style.position = "absolute";
        if (this.pixeloffset) {
            this.left = this.loc.elements[XELE];
            this.top = this.loc.elements[YELE];
            this.div.style.left = this.left + 'px';
            this.div.style.top = this.top + 'px';
        }
        else {
        }
        if (this.scene.ctrl_data === undefined) {
            if (aid.indexOf("/tabui") === 0) {
                this.div.hidden = true;
            }
            if (aid.indexOf("/dcs") === 0) {
                this.div.hidden = true;
            }
        }
        else {
            if (this.scene.ctrl_data.myPageName.indexOf("/frh/irprog/ihmieditor") === 0) {
                if (aid.indexOf("/prog/") === 0) {
                    this.div.textContent = "";
                    this.div.style.width = "0px";
                    this.div.style.height = "0px";
                    var border_width = attribute.pnt;
                    this.div.style.borderTopStyle = "solid";
                    this.div.style.borderTopWidth = border_width + "px";
                    this.div.style.borderTopColor = "black";
                    this.div.style.borderRightStyle = "solid";
                    this.div.style.borderRightWidth = border_width + "px";
                    this.div.style.borderRightColor = "transparent";
                }
                else if (aid.indexOf("/tabui/pin") === 0) {
                    this.div.style.fontWeight = "bold";
                    var pin_width = attribute.pnt * 5 / 4;
                    var pin_height = attribute.pnt * 5 / 4;
                    var border_width = attribute.pnt / 4;
                    this.div.style.minWidth = pin_width + "px";
                    this.div.style.width = "";
                    this.div.style.height = pin_height + "px";
                    this.div.style.backgroundColor = "white";
                    this.div.style.borderRadius = pin_width + "px";
                    this.div.style.borderStyle = "solid";
                    this.div.style.borderWidth = border_width + "px";
                    this.div.style.borderColor = "black";
                    this.div.style.textAlign = "center";
                }
                else if (aid.indexOf("/tabui/prpin") === 0) {
                    this.div.style.fontWeight = "bold";
                    var pin_width = attribute.pnt * 5 / 4;
                    var pin_height = attribute.pnt * 5 / 4;
                    var border_width = attribute.pnt / 4;
                    this.div.style.minWidth = pin_width + "px";
                    this.div.style.width = "";
                    this.div.style.height = pin_height + "px";
                    this.div.style.backgroundColor = "black";
                    this.div.style.borderRadius = pin_width + "px";
                    this.div.style.borderStyle = "solid";
                    this.div.style.borderWidth = border_width + "px";
                    this.div.style.borderColor = "black";
                    this.div.style.textAlign = "center";
                }
            }
            else {
                if (aid.indexOf("/tabui") === 0) {
                    this.div.hidden = true;
                }
            }
            if (this.scene.ctrl_data.myPageName.indexOf("/frh/irprog/dcs/") === 0) {
                if (aid.indexOf("/attr/text/xs") === 0) {
                    this.div.textContent = "";
                    this.div.style.width = "0px";
                    this.div.style.height = "0px";
                    var border_width = attribute.pnt;
                    this.div.style.borderTopStyle = "solid";
                    this.div.style.borderTopWidth = border_width + "px";
                    this.div.style.borderTopColor = "black";
                    this.div.style.borderRightStyle = "solid";
                    this.div.style.borderRightWidth = border_width + "px";
                    this.div.style.borderRightColor = "transparent";
                }
                else if (aid.indexOf("/dcs/pin") === 0) {
                    this.div.style.fontWeight = "bold";
                    var pin_width = attribute.pnt * 5 / 4;
                    var pin_height = attribute.pnt * 5 / 4;
                    var border_width = attribute.pnt / 4;
                    this.div.style.minWidth = pin_width + "px";
                    this.div.style.width = "";
                    this.div.style.height = pin_height + "px";
                    this.div.style.backgroundColor = "white";
                    this.div.style.borderRadius = pin_width + "px";
                    this.div.style.borderStyle = "solid";
                    this.div.style.borderWidth = border_width + "px";
                    this.div.style.borderColor = "black";
                    this.div.style.textAlign = "center";
                }
            }
            else {
                if (aid.indexOf("/dcs/pin") === 0) {
                    this.div.hidden = true;
                }
            }
        }
    };
    FRCSprite.prototype.SETSPR = function (loc, URL, height, width, aid, pointerEvents) {
        if (this.div === undefined) {
            return;
        }
        if (aid !== undefined) {
            this.SetAid(aid);
            var attribute = FRCAttribute.GetAttribute(this.aid);
            var color = new THREE.Color(attribute.bgcolor);
            var clr = "rgba(" + color.r * 255 + ", " + color.g * 255 + ", " + color.b * 255 + ", " + attribute.opac / 100.0 + ")";
            this.div.style.background = clr;
        }
        if (URL !== undefined && URL != null) {
            var text = '<img src="' + URL + '" style= "width:' + width + 'px;height:' + height + 'px;" >';
            this.div.innerHTML = text;
            this.URL = URL;
        }
        if (loc != undefined) {
            this.loc = loc.clone();
            this.div.style.position = "absolute";
            this.left = this.loc.elements[XELE];
            this.top = this.loc.elements[YELE];
            this.div.style.left = this.left + 'px';
            this.div.style.top = this.top + 'px';
        }
        if (width !== undefined) {
            this.width = width;
        }
        if (height !== undefined) {
            this.height = height;
        }
    };
    FRCSprite.prototype.PositionUpdate = function () {
        if (this.div === undefined) {
            return;
        }
        var world = this.group.matrixWorld;
        var vector = new THREE.Vector3(world.elements[12], world.elements[13], world.elements[14]);
        var position = vector.project(this.scene.camera);
        if ((this.lastposx != position.x) || (this.lastposy != position.y)) {
            var canvas = document.getElementsByTagName('canvas')[0];
            this.lastposx = position.x;
            this.lastposy = position.y;
            var x = (position.x + 1) / 2 * document.documentElement.clientWidth;
            var y = -(position.y - 1) / 2 * document.documentElement.clientHeight;
            this.left = Math.round(x);
            this.top = Math.round(y);
            this.div.style.left = Math.round(x) + 'px';
            this.div.style.top = Math.round(y) + 'px';
        }
    };
    FRCSprite.prototype.IDDEL = function () {
        if (this.id == '/menu/*noselect*') {
        }
        else {
            if (this.div === undefined) {
                return;
            }
            this.div.parentNode.removeChild(this.div);
            this.DelSprite();
            FRCSprite.divmap.delete(this.id);
        }
    };
    FRCSprite.prototype.IntSetvis = function (visible, rootflag) {
        if (this.div === undefined) {
            return;
        }
        if (this.id == '/menu/*noselect*') {
        }
        else {
            this.div.hidden = !visible;
            this.scene.StopPolling(this);
        }
        _super.prototype.IntSetvis.call(this, visible, rootflag);
    };
    FRCSprite.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
        }
    };
    FRCSprite.prototype.MouseDelegate = function (object, delegate) {
        this.MouseFunction = delegate;
        this.delegateHost = object;
    };
    FRCSprite.prototype.onmousedown = function (eventin) {
        var mythis = FRCSprite.divmap.get(this.id);
        mythis.MouseEngaged = true;
    };
    FRCSprite.prototype.onmouseup = function (eventin) {
        var mythis = FRCSprite.divmap.get(this.id);
        mythis.MouseEngaged = false;
    };
    FRCSprite.prototype.onmouseleave = function (eventin) {
        var mythis = FRCSprite.divmap.get(this.id);
        mythis.MouseEngaged = false;
    };
    FRCSprite.prototype.onclick = function (eventin) {
        var mythis = FRCSprite.divmap.get(this.id);
        if (mythis.MouseFunction != undefined) {
            mythis.MouseFunction(mythis.delegateHost, DELEGATECLICK, eventin);
        }
        else {
            console.log("No default function for sprite mouse click.  ");
        }
    };
    FRCSprite.prototype.onmousemove = function (eventin) {
        var mythis = FRCSprite.divmap.get(this.id);
        console.log("Mouse move " + mythis.MouseEngaged);
        if (mythis.MouseEngaged && mythis.MouseFunction != undefined) {
            mythis.MouseFunction(mythis.delegateHost, DELEGATEMOVE, eventin);
        }
    };
    return FRCSprite;
}(FRCObject4d));
var DBGLVL_CANVAS_C = 0x1;
var DBGLVL_SCENE_C = 0x2;
var DBGLVL_GL_C = 0x4;
var DBGLVL_POD_C = 0x8;
var DBGLVL_USER_SHAPE_C = 0x10;
var DBGLVL_SHAPE_C = 0x20;
var DBGLVL_GNODE_C = 0x40;
var DBGLVL_AXIS_C = 0x80;
var DBGLVL_FPS_C = 0x100;
var DBGLVL_DUMPSCENE_C = 0x200;
var DBGLVL_LOGFILE_C = 0x400;
var DBGLVL_TOUCH_C = 0x800;
var DBGLVL_CACHE_C = 0x1000;
var DBGLVL_CAMERA_C = 0x2000;
var DBGLVL_DIV1DUMP_C = 0x4000;
var DBGLVL_RAWXML_C = 0x8000;
var DBGLVL_PROCESSXML_C = 0x10000;
var DBGLVL_DUMPATTR_C = 0x20000;
var DBGLVL_IDENT_C = 0x40000;
var DBGLVL_VIEW_C = 0x80000;
var DBGLVL_NOTRY_C = 0x100000;
var FRCDebug = (function () {
    function FRCDebug() {
        if (!FRCDebug.dmpmap) {
            FRCDebug.dmpmap = new Map();
            FRCDebug.tagstack = new Array();
        }
        FRCDebug.dmpmap.set("CELL", this.CELLDmp);
        FRCDebug.dmpmap.set("SETPOD", this.SETPODDmp);
        FRCDebug.dmpmap.set("SETGN", this.SETGNDmp);
        FRCDebug.dmpmap.set("SETCY", this.SETCYDmp);
        FRCDebug.dmpmap.set("SETAXS", this.SETAXSDmp);
    }
    FRCDebug.log = function (message) {
        if (FRCDebug.dbglvl & DBGLVL_DIV1DUMP_C) {
            FRCDebug.dbgdata = FRCDebug.dbgdata + message + '\n';
        }
        else {
            console.log(message);
        }
    };
    FRCDebug.SetLevel = function (level) {
        if (FRCDebug.dbglvl & DBGLVL_DUMPSCENE_C && level == 0) {
            FRCDebug.Dump(FRCCanvas.Scene);
        }
        FRCDebug.dbglvl = level;
    };
    FRCDebug.Dump = function (scene) {
        var object;
        if (FRCDebug.dbglvl & DBGLVL_DUMPSCENE_C) {
            FRCDebug.indent = "";
            FRCDebug.log("NOTE: This is not double spaced when pasted into code editor");
            FRCDebug.log("Robot Groups");
            for (var robidx = 0; robidx < scene.robots.length; robidx++) {
                var robot = scene.robots[robidx];
                FRCDebug.log("  " + robot.id);
                object = robot.basegn;
                FRCDebug.GENERICDmp(object, '" fullid ="' + object.id);
                for (var idx = 0; idx < robot.axes.length; idx++) {
                    object = robot.axes[idx];
                    FRCDebug.GENERICDmp(object, '" fullid ="' + object.id + '" type ="' + object.axis.type);
                }
            }
            object = scene.GetObject("/cell", undefined);
            FRCDebug.log("4D Object Tree");
            FRCDebug.Recurse4D(object);
            FRCDebug.indent = "";
            FRCDebug.log("THREE Object Tree");
            FRCDebug.Recurse3D(object.group);
            object = scene.GetObject("/menu", undefined);
            FRCDebug.log("Menu Tree");
        }
    };
    FRCDebug.Attributes = function () {
        if (FRCDebug.dbglvl & DBGLVL_DUMPATTR_C) {
            var object;
            var canvas = FRCCanvas.getInstance();
            canvas.attributes.forEach(FRCDebug.DumpAttr, object);
        }
    };
    FRCDebug.DumpAttr = function (object) {
        if (object.id != "root") {
            var str = '<SETATR id="' + object.id + '" vis="' + object.vis + '" opac="' + object.opac + '" color="#' + object.color.toString(16);
            str = str + '" weight="' + object.weight + '" sel="' + object.sel + '" bgcolor="#' + object.bgcolor.toString(16) + '" font="' + object.font;
            str = str + '" pnt="' + object.pnt + '" y="' + object.y + '" charset="' + object.charset + '" \>';
            FRCDebug.log(str);
        }
    };
    FRCDebug.GENERICDmp = function (object, extstr) {
        if (object.loc) {
            var loc = '" loc="' + FRCUtility.Matrix2Str(object.loc);
        }
        else {
            var loc = "";
        }
        if (FRCDebug.dbglvl & DBGLVL_IDENT_C) {
            var shortid = object.id;
        }
        else {
            var vals = object.id.split("/");
            var shortid = vals[vals.length - 1];
        }
        var fidaid = "";
        if (object.fid) {
            fidaid = fidaid + '" fid="' + object.fid;
        }
        if (object.aid) {
            fidaid = fidaid + '" aid="' + object.aid;
        }
        var term;
        if (object.children.length == 0) {
            term = '"/>';
        }
        else {
            term = '">';
        }
        FRCDebug.log(FRCDebug.indent + "<" + object.tagName + ' id = "' + shortid +
            loc + fidaid + extstr + term);
    };
    FRCDebug.prototype.CELLDmp = function (object) {
        FRCDebug.log("<CELL>");
    };
    FRCDebug.prototype.SETGNDmp = function (object) {
        var vis;
        if (object.group.visible) {
            vis = '" vis ="' + object.group.visible;
        }
        else {
            vis = '';
        }
        FRCDebug.GENERICDmp(object, vis);
    };
    FRCDebug.prototype.SETPODDmp = function (object) {
        var siz = FRCUtility.Vector2Str(object.group.scale);
        FRCDebug.GENERICDmp(object, '" URL="' + object.URL + '" siz="' + siz);
    };
    FRCDebug.prototype.SETAXSDmp = function (object) {
        FRCDebug.GENERICDmp(object, '" type ="' + object.axis.type);
    };
    FRCDebug.prototype.SETCYDmp = function (object) {
        FRCDebug.GENERICDmp(object, "");
    };
    FRCDebug.Recurse4D = function (object) {
        var indent;
        var idx;
        FRCDebug.tagstack.push(object.tagName);
        var function_p = FRCDebug.dmpmap.get(object.tagName);
        if (function_p != undefined) {
            function_p(object);
        }
        else {
            FRCDebug.GENERICDmp(object, "");
        }
        FRCDebug.indent = FRCDebug.indent + "  ";
        if (object.children.length) {
            for (idx = 0; idx < object.children.length; idx++) {
                var child = object.children[idx];
                FRCDebug.Recurse4D(child);
            }
            FRCDebug.log(FRCDebug.indent + "</" + FRCDebug.tagstack.pop() + ">");
        }
        else {
            FRCDebug.tagstack.pop();
        }
        FRCDebug.indent = FRCDebug.indent.substring(0, FRCDebug.indent.length - 2);
    };
    FRCDebug.Recurse3D = function (object) {
        var idx;
        if (FRCDebug.dbglvl & DBGLVL_IDENT_C) {
            var shortid = object.name;
        }
        else {
            var vals = object.name.split("/");
            var shortid = vals[vals.length - 1];
        }
        var str = FRCUtility.Matrix2Str(object.matrix);
        str = str + '" siz = "' + object.scale.x.toPrecision(6) + ", " + object.scale.y.toPrecision(6) + ", " + object.scale.z.toPrecision(6);
        FRCDebug.log(FRCDebug.indent + "<" + shortid + ' nch = "' + object.children.length + ' vis = "' + object.visible + '" loc = "' + str + '"/>"');
        var podcnt = 0;
        for (idx = 0; idx < object.children.length; idx++) {
            var podflag = false;
            var child = object.children[idx];
            FRCDebug.indent = FRCDebug.indent + "  ";
            if (child.name.search('\.pod')) {
                var podflag = true;
                podcnt++;
                if (podcnt == 4) {
                    FRCDebug.log("Skipping pod file segments " + object.children.length + "total children");
                }
            }
            if (podcnt < 4 && podflag) {
                FRCDebug.Recurse3D(child);
            }
            FRCDebug.indent = FRCDebug.indent.substring(0, FRCDebug.indent.length - 2);
        }
    };
    FRCDebug.RawXML = function (xmltext) {
        if (FRCDebug.dbglvl & DBGLVL_RAWXML_C) {
            FRCDebug.log(xmltext);
        }
    };
    FRCDebug.ProcessXML = function (idobj, node, processed) {
        if (FRCDebug.dbglvl & DBGLVL_PROCESSXML_C) {
            if (node.tagName == "parsererror") {
                var str = "Ooops";
            }
            if (node.tagName != "SETATT") {
                var fullid = idobj.Stack2Name();
                if (processed) {
                    var str = "<" + node.tagName;
                }
                else {
                    var str = "**<" + node.tagName;
                }
                for (var idx = 0; idx < node.attributes.length; idx++) {
                    var param = node.attributes[idx].name;
                    var value = node.attributes[idx].value;
                    if (param == "id") {
                        if (fullid == undefined || fullid == null || fullid == "") {
                            value = "*" + value;
                        }
                    }
                    str = str + " " + param + '="' + value + '"';
                }
                FRCDebug.log(str + '/>');
            }
        }
    };
    FRCDebug.dbglvl = 0;
    FRCDebug.xmpsent = false;
    FRCDebug.dbgdata = "";
    return FRCDebug;
}());
var FRCLoader = (function () {
    function FRCLoader(URL, connect) {
        if (connect == null) {
            console.log("Can only get vision data from primary connection");
            connect = FRCCanvas.MainConnect();
        }
        this.connect = connect;
        this.URL = "http://" + this.connect.IPAddress + URL;
        this.fs = new PVRFileStream();
    }
    FRCLoader.prototype.LoadPod = function (podobject) {
        var gl = null;
        this.fs.TargetObject = podobject;
        this.fs.Open(this.URL, true, podobject.LoadPod, gl);
    };
    FRCLoader.prototype.LoadXML = function () {
        var gl = null;
        this.fs.TargetConnect = this.connect;
        this.fs.Open(this.URL, true, this.connect.XMLload, gl);
    };
    FRCLoader.prototype.LoadPointCloud = function (object4d) {
        var gl = null;
        this.fs.object4d = object4d;
        this.fs.Open(this.URL, true, FRCVertices.CloudLoad, gl);
    };
    return FRCLoader;
}());
var FRCGlobals = (function () {
    function FRCGlobals() {
        this.podfiles = new Map();
    }
    return FRCGlobals;
}());
var FRCCanvas = (function () {
    function FRCCanvas(globals) {
        this.lastpipe = 0;
        if (FRCCanvas._instance) {
            return FRCCanvas._instance;
        }
        FRCCanvas._instance = this;
        FRCAttribute.Initialize();
        this.globals = new FRCGlobals();
        FRCCanvas.Connections = new Array();
        var diagdump = new FRCDebug();
        this.sphere = new THREE.SphereGeometry(1, 128, 128);
    }
    FRCCanvas.getInstance = function () {
        if (FRCCanvas._instance == undefined) {
            var letsgo = new FRCCanvas(undefined);
        }
        return FRCCanvas._instance;
    };
    ;
    FRCCanvas.MainConnect = function () {
        return FRCCanvas.Connections[0];
    };
    FRCCanvas.GetConnect = function (pipe, responseURL) {
        var Connect;
        var foundit = false;
        if (responseURL.length < 10) {
            return null;
        }
        var splits = responseURL.split("/");
        var splits2 = splits[2].split(":");
        var ipadd = splits[2];
        for (var idx = 0; idx < FRCCanvas.Connections.length; idx++) {
            Connect = FRCCanvas.Connections[idx];
            if (Connect.IPAddress == ipadd) {
                foundit = true;
                break;
            }
        }
        if (!foundit) {
            Connect = new FRCConnect(ipadd);
            this.Connections.push(Connect);
            Connect.Initialize(pipe, ipadd);
        }
        return Connect;
    };
    FRCCanvas.GetScene = function (name) {
        if (FRCCanvas.Scene == undefined) {
            FRCCanvas.Scene = new FRCScene3D(name);
        }
        return FRCCanvas.Scene;
    };
    FRCCanvas.GetVRScene = function (name) {
        alert("VR Functionality has been commented out");
        return undefined;
    };
    FRCCanvas.draw3d_SendPkt = function (fc, data, optional) {
        for (var idx = 0; idx < FRCCanvas.Connections.length; idx++) {
            var Connect = FRCCanvas.Connections[idx];
            if (Connect.IPAddress != "*local*") {
                Connect.SendPacket(fc, optional);
            }
        }
    };
    FRCCanvas.LogOut = function () {
        for (var idx = 0; idx < FRCCanvas.Connections.length; idx++) {
            var Connect = FRCCanvas.Connections[idx];
            Connect.LogOut();
        }
    };
    FRCCanvas.Animate = function () {
        for (var idx = 0; idx < FRCCanvas.Connections.length; idx++) {
            var Connect = FRCCanvas.Connections[idx];
            if (Connect.CheckQueue()) {
                break;
            }
        }
        if (FRCCanvas.Scene !== undefined) {
            FRCCanvas.Scene.Animate();
        }
        requestAnimationFrame(FRCCanvas.Animate);
    };
    FRCCanvas.Render = function () {
        FRCCanvas.Scene.Render();
        requestAnimationFrame(FRCCanvas.Animate);
    };
    FRCCanvas.ResizeWindow = function () {
        if (FRCCanvas.Scene.standalone) {
            FRCCanvas.Scene.DoResize(false);
        }
    };
    FRCCanvas.QueuePod = function (URL, axispod) {
        var canvas = FRCCanvas.getInstance();
        var test = canvas.globals.podfiles.get(URL);
        if (test == undefined) {
            var podfile = new FRCPODLoad(URL, true);
            canvas.globals.podfiles.set(URL, podfile);
        }
    };
    FRCCanvas.PodStatus = function (URL) {
        var canvas = FRCCanvas.getInstance();
        var podobject = canvas.globals.podfiles.get(URL);
        if (podobject != undefined) {
            return podobject.IsLoaded;
        }
        return false;
    };
    FRCCanvas.XMLPipe = function (connect, xmltext) {
        var scene = FRCCanvas.Scene;
        var foundeot = false;
        if (xmltext[xmltext.length - 1] == '\04') {
            xmltext = xmltext.substring(0, xmltext.length - 1);
            foundeot = true;
        }
        var endtag = xmltext.substr(xmltext.length - 7, 6);
        var xmlparser = connect.xml4d;
        if (endtag == "<EOF/>") {
            if (connect.pipe_suspend) {
                xmlparser.xmltext_queue = xmlparser.xmltext_queue + xmltext;
            }
            else {
                scene.ProcessXML(connect, xmlparser.xmltext + xmltext, true);
                xmlparser.xmltext = "";
            }
        }
        else {
            xmlparser.xmltext = xmlparser.xmltext + xmltext;
        }
        return false;
    };
    return FRCCanvas;
}());
var XELE = 12;
var YELE = 13;
var ZELE = 14;
var FRCXYZWPR = (function () {
    function FRCXYZWPR() {
    }
    FRCXYZWPR.prototype.clone = function () {
        var retval = new FRCXYZWPR();
        retval.x = this.x;
        retval.y = this.y;
        retval.z = this.z;
        retval.w = this.w;
        retval.p = this.p;
        retval.r = this.r;
        return retval;
    };
    return FRCXYZWPR;
}());
var FRCUtility = (function () {
    function FRCUtility() {
    }
    FRCUtility.MatFromXYZWPR = function (x, y, z, w, p, r, OutM) {
        var cr = Math.cos(Math.PI / 180 * r);
        var sr = Math.sin(Math.PI / 180 * r);
        var cp = Math.cos(Math.PI / 180 * p);
        var sp = Math.sin(Math.PI / 180 * p);
        var cw = Math.cos(Math.PI / 180 * w);
        var sw = Math.sin(Math.PI / 180 * w);
        OutM.elements[0] = cr * cp;
        OutM.elements[1] = sr * cp;
        OutM.elements[2] = -sp;
        OutM.elements[4] = cr * sp * sw - sr * cw;
        OutM.elements[5] = sr * sp * sw + cr * cw;
        OutM.elements[6] = cp * sw;
        OutM.elements[8] = cr * sp * cw + sr * sw;
        OutM.elements[9] = sr * sp * cw - cr * sw;
        OutM.elements[10] = cp * cw;
        OutM.elements[XELE] = x;
        OutM.elements[YELE] = y;
        OutM.elements[ZELE] = z;
        OutM.elements[3] = OutM.elements[7] = OutM.elements[11] = 0.0;
        OutM.elements[15] = 1.0;
    };
    FRCUtility.LOCX = function (matrix) {
        return matrix.elements[XELE];
    };
    FRCUtility.LOCY = function (matrix) {
        return matrix.elements[YELE];
    };
    FRCUtility.LOCZ = function (matrix) {
        return matrix.elements[ZELE];
    };
    FRCUtility.AX = function (matrix) {
        return matrix.elements[8];
    };
    FRCUtility.AY = function (matrix) {
        return matrix.elements[9];
    };
    FRCUtility.AZ = function (matrix) {
        return matrix.elements[10];
    };
    FRCUtility.OX = function (matrix) {
        return matrix.elements[4];
    };
    FRCUtility.OY = function (matrix) {
        return matrix.elements[5];
    };
    FRCUtility.OZ = function (matrix) {
        return matrix.elements[6];
    };
    FRCUtility.NX = function (matrix) {
        return matrix.elements[0];
    };
    FRCUtility.NY = function (matrix) {
        return matrix.elements[1];
    };
    FRCUtility.NZ = function (matrix) {
        return matrix.elements[2];
    };
    FRCUtility.RAD_TO_DEG = function (angle) {
        return angle * 180.0 / Math.PI;
    };
    FRCUtility.DEG_TO_RAD = function (angle) {
        return angle * Math.PI / 180;
    };
    FRCUtility.ToXyzWpr = function (mat, xyzwpr) {
        var dz = Math.atan2(FRCUtility.NY(mat), FRCUtility.NX(mat));
        var dc = Math.cos(dz);
        var ds = Math.sin(dz);
        xyzwpr.x = FRCUtility.LOCX(mat);
        xyzwpr.y = FRCUtility.LOCY(mat);
        xyzwpr.z = FRCUtility.LOCZ(mat);
        xyzwpr.w = FRCUtility.RAD_TO_DEG(Math.atan2(ds * FRCUtility.AX(mat) - dc * FRCUtility.AY(mat), -ds * FRCUtility.OX(mat) + dc * FRCUtility.OY(mat)));
        xyzwpr.p = FRCUtility.RAD_TO_DEG(Math.atan2(-FRCUtility.NZ(mat), dc * FRCUtility.NX(mat) + ds * FRCUtility.NY(mat)));
        xyzwpr.r = FRCUtility.RAD_TO_DEG(dz);
    };
    FRCUtility.Matrix2Str = function (mat) {
        var str;
        if (mat) {
            var xyzwpr = new FRCXYZWPR;
            FRCUtility.ToXyzWpr(mat, xyzwpr);
            str = xyzwpr.x.toPrecision(6) + ", " + xyzwpr.y.toPrecision(6) + ", " + xyzwpr.z.toPrecision(6) + ", ";
            str = str + xyzwpr.w.toPrecision(4) + ", " + xyzwpr.p.toPrecision(4) + ", " + xyzwpr.r.toPrecision(4);
        }
        else {
            str = "0, 0, 0, 0, 0, 0";
        }
        return str;
    };
    FRCUtility.Vector2Str = function (vector) {
        var str;
        if (vector) {
            str = vector.x.toPrecision(6) + ", " + vector.y.toPrecision(6) + ", " + vector.z.toPrecision(6);
        }
        else {
            str = "0, 0, 0";
        }
        return str;
    };
    FRCUtility.IsZero2 = function (val, delta) {
        return (Math.abs(val) < delta) ? true : false;
    };
    FRCUtility.IsZero = function (val) {
        return (Math.abs(val) < 0.0001) ? true : false;
    };
    FRCUtility.IsIdentity = function (M) {
        var is10 = new Array(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
        for (var idx = 0; idx < 16; idx++) {
            if (is10[idx]) {
                if (!FRCUtility.IsZero(M.elements[idx] - 1)) {
                    return false;
                }
            }
            else {
                if (!FRCUtility.IsZero(M.elements[idx])) {
                    return false;
                }
            }
        }
        return true;
    };
    FRCUtility.postTranslate = function (tx, ty, tz, mat) {
        mat.elements[12] += (tx * mat.elements[0]) + (ty * mat.elements[4]) + (tz * mat.elements[8]);
        mat.elements[13] += (tx * mat.elements[1]) + (ty * mat.elements[5]) + (tz * mat.elements[9]);
        mat.elements[14] += (tx * mat.elements[2]) + (ty * mat.elements[6]) + (tz * mat.elements[10]);
        mat.elements[15] += (tx * mat.elements[3]) + (ty * mat.elements[7]) + (tz * mat.elements[11]);
    };
    FRCUtility.RotationX = function (t, mat) {
        var e = Math.cos(t), i = Math.sin(t);
        mat.elements[0] = 1;
        mat.elements[1] = 0;
        mat.elements[2] = 0;
        mat.elements[3] = 0;
        mat.elements[4] = 0;
        mat.elements[5] = e;
        mat.elements[6] = -i;
        mat.elements[7] = 0;
        mat.elements[8] = 0;
        mat.elements[9] = i;
        mat.elements[10] = e;
        mat.elements[11] = 0;
        mat.elements[12] = 0;
        mat.elements[13] = 0;
        mat.elements[14] = 0;
        mat.elements[15] = 1;
    };
    FRCUtility.RotationY = function (t, mat) {
        var e = Math.cos(t), i = Math.sin(t);
        mat.elements[0] = e;
        mat.elements[1] = 0;
        mat.elements[2] = i;
        mat.elements[3] = 0;
        mat.elements[4] = 0;
        mat.elements[5] = 1;
        mat.elements[6] = 0;
        mat.elements[7] = 0;
        mat.elements[8] = -i;
        mat.elements[9] = 0;
        mat.elements[10] = e;
        mat.elements[11] = 0;
        mat.elements[12] = 0;
        mat.elements[13] = 0;
        mat.elements[14] = 0;
        mat.elements[15] = 1;
    };
    FRCUtility.RotationZ = function (t, mat) {
        var e = Math.cos(t), i = Math.sin(t);
        mat.elements[0] = e;
        mat.elements[1] = -i;
        mat.elements[2] = 0;
        mat.elements[3] = 0;
        mat.elements[4] = i;
        mat.elements[5] = e;
        mat.elements[6] = 0;
        mat.elements[7] = 0;
        mat.elements[8] = 0;
        mat.elements[9] = 0;
        mat.elements[10] = 1;
        mat.elements[11] = 0;
        mat.elements[12] = 0;
        mat.elements[13] = 0;
        mat.elements[14] = 0;
        mat.elements[15] = 1;
    };
    return FRCUtility;
}());
var FRCFrame = (function () {
    function FRCFrame(id) {
        this.id = id;
        this.frame = new THREE.Matrix4();
        this.subscribers = new Array();
    }
    FRCFrame.Subscribe = function (id, object4d) {
        if (id.search(';') >= 0) {
            var IDStack = id.split(";");
            id = IDStack[1];
        }
        var frameobj = object4d.scene.GetFrame(id);
        var subscribed = false;
        for (var idx = 0; idx < frameobj.subscribers.length; idx++) {
            var objectst = frameobj.subscribers[idx];
            if (objectst.id == object4d.id) {
                subscribed = true;
                break;
            }
        }
        if (!subscribed) {
            frameobj.subscribers.push(object4d);
        }
        object4d.ApplyFrame(frameobj);
    };
    FRCFrame.UnSubscribe = function (id, object4d) {
        if (id.search(';') >= 0) {
            var IDStack = id.split(";");
            id = IDStack[1];
        }
        var frameobj = object4d.scene.GetFrame(id);
        var length = frameobj.subscribers.length;
        for (var idx = 0; idx < length; idx++) {
            var objectst = frameobj.subscribers[idx];
            if (objectst.id == object4d.id) {
                frameobj.subscribers.splice(idx, 1);
                break;
            }
        }
    };
    FRCFrame.prototype.SETFRM = function (loc) {
        this.frame = loc.clone();
        for (var idx = 0; idx < this.subscribers.length; idx++) {
            var object = this.subscribers[idx];
            object.ApplyFrame(this);
        }
    };
    return FRCFrame;
}());
var FRCAttribute = (function () {
    function FRCAttribute(id) {
        if (id.substr(0, 5) == "/attr") {
            id = id.substr(5, 10000);
        }
        this.id = id;
    }
    FRCAttribute.Initialize = function () {
        FRCAttribute.dshadermaterial = FRCAttribute.MakeShaderMaterial(new THREE.Vector4(1, 0, 0, 1), "PODVertexShader", "PODFragmentShader");
        FRCAttribute.dlinematerial = new THREE.LineBasicMaterial({ color: 0xFF0000 });
        FRCAttribute.dpointmaterial = new THREE.PointsMaterial({ color: 0xFF0000 });
        FRCAttribute.dphongmaterial = new THREE.MeshPhongMaterial({ color: 0xFF0000 });
    };
    FRCAttribute.GetAttribute = function (id) {
        var canvas = FRCCanvas.getInstance();
        if (id.substr(0, 5) == "/attr") {
            id = id.substr(5, 10000);
        }
        if (canvas.attributes == undefined) {
            canvas.attributes = new Map();
        }
        var object = canvas.attributes.get(id);
        if (object == undefined) {
            object = new FRCAttribute(id);
            canvas.attributes.set(id, object);
        }
        return object;
    };
    FRCAttribute.MakeShaderMaterial = function (matcolor, vertex, fragment) {
        var ambcolor = new THREE.Vector4();
        var blackboost;
        var blackfactor = 0.2;
        var ltransparent = matcolor.w < 1.0;
        var brightness = matcolor.length();
        if (brightness < blackfactor) {
            blackboost = blackfactor;
            matcolor.addScalar(blackfactor);
        }
        else {
            blackboost = 0.0;
        }
        var matcolor = new THREE.Vector4(matcolor.x + blackboost, matcolor.y + blackboost, matcolor.z + blackboost, matcolor.w);
        var ambcolor = new THREE.Vector4(matcolor.x * 0.1, matcolor.y * 0.1, matcolor.z * 0.1, matcolor.w);
        var vShader = FRCAttribute.GetShader(vertex);
        var fShader = FRCAttribute.GetShader(fragment);
        var material = new THREE.RawShaderMaterial({
            uniforms: {
                AmbientColor: { value: ambcolor },
                MaterialColor: { value: matcolor },
                mLightDirection: { value: new THREE.Vector3(0, 0, 1) }
            },
            vertexShader: vShader,
            fragmentShader: fShader,
            transparent: ltransparent
        });
        return material;
    };
    FRCAttribute.GetShaderMaterial = function (id, scene, opac_ovr) {
        return FRCAttribute.GetShaderMaterial2(id, scene, opac_ovr, "PODVertexShader", "PODFragmentShader");
    };
    FRCAttribute.GetFlatShaderMaterial = function (id, scene, opac_ovr) {
        return FRCAttribute.GetShaderMaterial2(id, scene, opac_ovr, "FlatVertexShader", "FlatFragmentShader");
    };
    FRCAttribute.GetShaderMaterial2 = function (id, scene, opac_ovr, vertex, fragment) {
        if (id.substr(0, 5) == "/attr") {
            id = id.substr(5, 10000);
        }
        var object = FRCAttribute.GetAttribute(id);
        if (object == undefined) {
            return FRCAttribute.dshadermaterial;
        }
        if (object.shadermaterial == undefined) {
            var threecolor = new THREE.Color(object.color);
            var w = object.opac / 100.0;
            var rgb = threecolor.toArray();
            var matcolor = new THREE.Vector4(rgb[0], rgb[1], rgb[2], w);
            object.shadermaterial = FRCAttribute.MakeShaderMaterial(matcolor, vertex, fragment);
        }
        return object.shadermaterial;
    };
    FRCAttribute.GetLineMaterial = function (id) {
        if (id.substr(0, 5) == "/attr") {
            id = id.substr(5, 10000);
        }
        var object = FRCAttribute.GetAttribute(id);
        if (object == undefined) {
            return FRCAttribute.dlinematerial;
        }
        if (object.linematerial == undefined) {
            object.linematerial = new THREE.LineBasicMaterial({ color: object.color });
        }
        return object.linematerial;
    };
    FRCAttribute.GetPointMaterial = function (id) {
        if (id.substr(0, 5) == "/attr") {
            id = id.substr(5, 10000);
        }
        var object = FRCAttribute.GetAttribute(id);
        if (object == undefined) {
            return FRCAttribute.dpointmaterial;
        }
        if (object.pointmaterial == undefined) {
            object.pointmaterial = new THREE.PointsMaterial({ color: object.color, size: 5, sizeAttenuation: true });
        }
        return object.pointmaterial;
    };
    FRCAttribute.GetShader = function (name) {
        var shadprog = "\n";
        if (name == "PODVertexShader") {
            shadprog = shadprog + "attribute     highp      vec3   position;\n";
            shadprog = shadprog + "attribute     highp      vec3   normal;\n";
            shadprog = shadprog + "uniform       highp      mat4   modelViewMatrix;\n";
            shadprog = shadprog + "uniform       highp      mat4   projectionMatrix;\n";
            shadprog = shadprog + "uniform       mediump    vec4   AmbientColor;\n";
            shadprog = shadprog + "uniform       mediump    vec4   MaterialColor;\n";
            shadprog = shadprog + "uniform       mediump    vec3   mLightDirection;\n";
            shadprog = shadprog + "varying       mediump    vec4   Color;\n";
            shadprog = shadprog + "void main()\n";
            ;
            shadprog = shadprog + "{\n";
            shadprog = shadprog + "  float df;\n";
            shadprog = shadprog + "  float opac;\n";
            shadprog = shadprog + "  vec3 EyeSpace;\n";
            shadprog = shadprog + "  gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);\n";
            shadprog = shadprog + "  EyeSpace = vec3(modelViewMatrix * vec4(normal,0.0));\n";
            shadprog = shadprog + "  opac = MaterialColor.w;\n";
            shadprog = shadprog + "  df = abs(dot(normalize(EyeSpace), -mLightDirection));\n";
            shadprog = shadprog + "  Color = AmbientColor + df * MaterialColor;\n";
            shadprog = shadprog + "  Color.w = opac;\n";
            shadprog = shadprog + " // Color =  vec4(EyeSpace, 1.0);\n";
            shadprog = shadprog + "}\n";
        }
        else if (name == "PODFragmentShader") {
            shadprog = shadprog + "  varying   mediump   vec4    Color;\n";
            shadprog = shadprog + "  void main()\n";
            shadprog = shadprog + "  {\n";
            shadprog = shadprog + "    gl_FragColor = Color;\n";
            shadprog = shadprog + "    gl_FragColor.w = Color.w;\n";
            shadprog = shadprog + "  }\n";
            shadprog = shadprog + "";
        }
        else if (name == "FlatVertexShader") {
            shadprog = shadprog + "attribute     highp      vec3   position;\n";
            shadprog = shadprog + "attribute     highp      vec3   normal;\n";
            shadprog = shadprog + "uniform       highp      mat4   modelViewMatrix;\n";
            shadprog = shadprog + "uniform       highp      mat4   projectionMatrix;\n";
            shadprog = shadprog + "varying       mediump    vec3   fragVertexEc;\n";
            shadprog = shadprog + "void main()\n";
            shadprog = shadprog + "{\n";
            shadprog = shadprog + " fragVertexEc = (modelViewMatrix * vec4(position, 1.0)).xyz;\n";
            shadprog = shadprog + " gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);\n";
            shadprog = shadprog + "}\n";
        }
        else if (name == "FlatFragmentShader") {
            shadprog = shadprog + "#extension GL_OES_standard_derivatives : enable;\n";
            shadprog = shadprog + "uniform       mediump    vec4   AmbientColor;\n";
            shadprog = shadprog + "uniform       mediump    vec4   MaterialColor;\n";
            shadprog = shadprog + "uniform       mediump    vec3   mLightDirection;\n";
            shadprog = shadprog + "uniform       highp      mat4   modelViewMatrix;\n";
            shadprog = shadprog + "varying       mediump    vec3   fragVertexEc;\n";
            shadprog = shadprog + "void main()\n";
            shadprog = shadprog + "  {\n";
            shadprog = shadprog + "   mediump    float   df;\n";
            shadprog = shadprog + "   vec3 EyeSpace;\n";
            shadprog = shadprog + "   vec3 X = dFdx(fragVertexEc);\n";
            shadprog = shadprog + "   vec3 Y = dFdy(fragVertexEc);\n";
            shadprog = shadprog + "   vec3 N = normalize(cross(X, Y));\n";
            shadprog = shadprog + "   EyeSpace = vec3(modelViewMatrix * vec4(N,0.0));\n";
            shadprog = shadprog + "   df = abs(dot(normalize(EyeSpace), -mLightDirection));\n";
            shadprog = shadprog + "   gl_FragColor = AmbientColor + df * MaterialColor;\n";
            shadprog = shadprog + "   gl_FragColor.w = MaterialColor.w;\n";
            shadprog = shadprog + "  }\n";
            shadprog = shadprog + "";
        }
        else {
            alert("Shader not found " + name);
        }
        return shadprog;
    };
    FRCAttribute.prototype.SETATR = function (textflag, vis, opac, color, weight, style, sel, bgcolor, font, pnt, y, charset) {
        this.textflag = textflag;
        if (undefined == vis) {
            this.vis = 1;
        }
        else {
            this.vis = vis;
        }
        if (undefined == opac) {
            this.opac = 100;
        }
        else {
            this.opac = opac;
        }
        if (undefined == style) {
            this.style = 0;
        }
        else {
            this.style = style;
        }
        if (undefined == color) {
            this.color = 0xFF0000;
        }
        else {
            this.color = color;
        }
        if (undefined == weight) {
            this.weight = 1;
        }
        else {
            this.weight = weight;
        }
        if (undefined == sel) {
            this.sel = 0;
        }
        else {
            this.sel = sel;
        }
        if (undefined == bgcolor) {
            this.bgcolor = 0xFFFFFF;
        }
        else {
            this.bgcolor = bgcolor;
        }
        if (undefined == font) {
            this.font = "";
        }
        else {
            this.font = font;
        }
        if (undefined == pnt) {
            this.pnt = 1;
        }
        else {
            this.pnt = pnt;
        }
        if (undefined == y) {
            this.y = 1;
        }
        else {
            this.y = y;
        }
        if (undefined == charset) {
            this.charset = 1;
        }
        else {
            this.charset = charset;
        }
    };
    return FRCAttribute;
}());
var FRCTSConvert = (function () {
    function FRCTSConvert() {
        FRCTSConvert.lines = new Array();
        this.loader = new THREE.FileLoader();
        this.loader.setResponseType('arraybuffer');
        this.URL = "/frh/glinterface.txt";
        this.loader.load(this.URL, this.onload, this.onprogress, this.onerror);
    }
    FRCTSConvert.prototype.onload = function (data) {
        var reader = new DataStream(data);
        var tabtext = reader.readString(reader.byteLength);
        var line;
        var rawlines = tabtext.split("\n");
        rawlines.forEach(FRCTSConvert.LineFilter, line);
        FRCTSConvert.lines.forEach(FRCTSConvert.Register, line);
        FRCTSConvert.lines.forEach(FRCTSConvert.XMLCalls, line);
        FRCTSConvert.lines.forEach(FRCTSConvert.OBJCalls, line);
    };
    FRCTSConvert.LineFilter = function (line) {
        var columns = line.split("\t");
        if (columns[3] == "yes") {
            FRCTSConvert.lines.push(line);
        }
    };
    FRCTSConvert.ParseLine = function (line, tag, attributes, types, calls) {
        var columns = line.split("\t");
        tag = columns[4];
        for (var idx = 5; idx < columns.length; idx++) {
            var work = columns[idx].split("=");
            if (work.length >= 2) {
                var attribute = work[0].substr(1, work[0].length - 1);
                var format = work[1].substr(2, work[1].length - 5);
                if (attribute != "missingArgs" && attribute != "id") {
                    attributes.push(attribute);
                    if (format == "%s") {
                        calls.push(" = node.getAttribute(\"");
                        types.push(": string");
                    }
                    else if (format == "%d") {
                        calls.push(" = parser.numAttribute(node, \"");
                        types.push(": number");
                    }
                    else if (format == "%f") {
                        calls.push(" = parser.fltAttribute(node, \"");
                        types.push(": number");
                    }
                    else if (format == "%f,%f,%f,%f,%f,%f") {
                        calls.push(" = parser.locAttribute(node, \"");
                        types.push(": THREE.Matrix4");
                    }
                    else if (format == "%f,%f,%f") {
                        calls.push(" = parser.vecAttribute(node, \"");
                        types.push(": THREE.Vector3");
                    }
                    else {
                        calls.push(" = Unknownformat\"" + format);
                        types.push(": number");
                        console.log("Do not recognize " + format);
                    }
                }
            }
        }
    };
    FRCTSConvert.Register = function (line) {
        var columns = line.split("\t");
        var code;
        code = 'FRCXML4D.tagmap.set("' + columns[4] + '", this.' + columns[4] + ");";
        var current = document.getElementById("register").innerHTML;
        document.getElementById("register").innerHTML = current + "<br>" + code;
    };
    FRCTSConvert.XMLCalls = function (line) {
        var code;
        var columns = line.split("\t");
        var tag = columns[4];
        var attributes = new Array();
        var calls = new Array();
        var types = new Array();
        FRCTSConvert.ParseLine(line, tag, attributes, types, calls);
        code = tag + "(parser: FRCXML4D, node: Element, scene: FRCScene): void {<br>";
        code = code + "var id = parser.IDObject.FullID();<br>";
        code = code + "var parentid = FRCIdent.ParentID(id);<br>";
        code = code + "var object = scene.GetObject(id, parentid); <br> ";
        for (var idx = 0; idx < attributes.length; idx++) {
            code = code + "var " + attributes[idx] + calls[idx] + attributes[idx] + '");<br>';
        }
        var current = document.getElementById("xml4d").innerHTML;
        document.getElementById("xml4d").innerHTML = current + code;
        code = "object." + tag + "(";
        for (var idx = 0; idx < attributes.length; idx++) {
            code = code + attributes[idx];
            if (idx < attributes.length - 1) {
                code = code + ", ";
            }
        }
        code = code + ");<br>}<br><br>";
        var current = document.getElementById("xml4d").innerHTML;
        document.getElementById("xml4d").innerHTML = current + "<br>" + code;
    };
    FRCTSConvert.OBJCalls = function (line) {
        var columns = line.split("\t");
        var code, tag;
        var attributes = new Array();
        var calls = new Array();
        var types = new Array();
        FRCTSConvert.ParseLine(line, tag, attributes, types, calls);
        code = columns[4] + "(";
        for (var idx = 0; idx < attributes.length; idx++) {
            code = code + attributes[idx] + types[idx];
            if (idx < attributes.length - 1) {
                code = code + ", ";
            }
        }
        code = code + ') {<br>}<br>';
        var current = document.getElementById("object4d").innerHTML;
        document.getElementById("object4d").innerHTML = current + "<br>" + code;
    };
    FRCTSConvert.prototype.onprogress = function (data) {
    };
    FRCTSConvert.prototype.onerror = function (data) {
        console.log("Cannot open URL " + this.URL);
        return;
    };
    return FRCTSConvert;
}());
var TPGL_CYFLAT = 0;
var TPGL_CYSPHERE = 1;
var TPGL_STYLE_TRIAD_20MM = 0x1;
var TPGL_STYLE_TRIAD_80MM = 0x2;
var TPGL_STYLE_TRIAD_400MM = 0x3;
var TPGL_STYLE_TRIAD_RGB_LEGS = 0x4;
var TPGL_STYLE_TRIAD_CENTER = 0xc;
var TPGL_STYLE_TORUS_FLAT_START = 0x1;
var TPGL_STYLE_TORUS_FLAT_END = 0x2;
var TPGL_STYLE_OUTLINE_BOX = 0x1;
var FRONTSIDE = 1;
var BACKSIDE = 2;
var DOUBLESIDE = 3;
var FRCTemplate = (function (_super) {
    __extends(FRCTemplate, _super);
    function FRCTemplate(id, scene, parent, loc, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.InitObject(undefined, loc, undefined, aid, fid, undefined, "SETTOR", true);
        _this.InitMesh(false);
        return _this;
    }
    FRCTemplate.prototype.XMLTAG = function (loc, aid, siz) {
        this.IDATR(aid);
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
        this.EveryCall(loc, siz, true, undefined);
    };
    FRCTemplate.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
    };
    FRCTemplate.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCTemplate;
}(FRCObject4d));
var FRCBox = (function (_super) {
    __extends(FRCBox, _super);
    function FRCBox(id, scene, parent, loc, siz, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.InitObject(siz, loc, undefined, aid, fid, undefined, "SETBOX", true);
        _this.InitMesh(false);
        return _this;
    }
    FRCBox.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        this.buffgeometry = new THREE.BoxBufferGeometry(1, 1, 1);
        var material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, undefined);
        this.mesh = new THREE.Mesh(this.buffgeometry, material);
        var attribute = FRCAttribute.GetAttribute(this.aid);
        if ((attribute.style & TPGL_STYLE_OUTLINE_BOX) == TPGL_STYLE_OUTLINE_BOX) {
            attribute.color = 0x000000;
            if (this.aid != undefined) {
                var outlineId = this.aid;
            }
            outlineId = this.aid + "/outline";
            var canvas = FRCCanvas.getInstance();
            var object = canvas.attributes.get(outlineId);
            if (object != undefined) {
                attribute = FRCAttribute.GetAttribute(outlineId);
            }
            var linegeometry = new THREE.EdgesGeometry(this.buffgeometry, 1);
            var linematerial = new THREE.LineBasicMaterial({ color: attribute.color });
            linematerial.transparent = false;
            linematerial.opacity = attribute.opac / 100;
            var wireframe = new THREE.LineSegments(linegeometry, linematerial);
            this.mesh.add(wireframe);
        }
        this.group.add(this.mesh);
    };
    FRCBox.prototype.SETBOX = function (loc, siz, aid, fid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
        this.EveryCall(loc, siz, true, fid);
    };
    FRCBox.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCBox;
}(FRCObject4d));
var FRCWall = (function (_super) {
    __extends(FRCWall, _super);
    function FRCWall(id, scene, parent, loc, siz, side, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.Wsiz = siz.clone();
        _this.side = side;
        _this.InitObject(undefined, loc, undefined, aid, fid, undefined, "SETWALL", true);
        _this.InitMesh(false);
        return _this;
    }
    FRCWall.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
            this.group.children.pop();
        }
        var xdim;
        var ydim;
        var orient = new THREE.Matrix4();
        if (this.Wsiz.x < 2) {
            ydim = this.Wsiz.y;
            xdim = this.Wsiz.z;
            FRCUtility.MatFromXYZWPR(0, 0, 0, 0, 90, 0, orient);
        }
        else if (this.Wsiz.y < 2) {
            xdim = this.Wsiz.x;
            ydim = this.Wsiz.z;
            FRCUtility.MatFromXYZWPR(0, 0, 0, 90, 0, 0, orient);
        }
        else {
            xdim = this.Wsiz.x;
            ydim = this.Wsiz.y;
        }
        var geometry = new THREE.PlaneGeometry(xdim, ydim);
        var material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, 1.0);
        switch (this.side) {
            case FRONTSIDE:
                material.side = THREE.FrontSide;
                break;
            case BACKSIDE:
                material.side = THREE.BackSide;
                break;
            default:
                material.side = THREE.DoubleSide;
        }
        this.mesh = new THREE.Mesh(geometry, material);
        this.mesh.applyMatrix(orient);
        this.group.add(this.mesh);
        this.mesh.renderOrder = this.Order(geometry);
    };
    FRCWall.prototype.SETWALL = function (loc, siz, aid, fid) {
        if (!this.aidOK(aid) || !this.Wsiz.equals(siz)) {
            this.IDATR(aid);
            this.Wsiz = siz.clone();
            this.InitMesh(true);
        }
        this.EveryCall(loc, undefined, true, fid);
    };
    FRCWall.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCWall;
}(FRCObject4d));
var FRCPoint = (function (_super) {
    __extends(FRCPoint, _super);
    function FRCPoint(id, scene, parent, loc, lefty, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        if (lefty !== undefined) {
            _this.lefty = lefty;
        }
        else {
            _this.lefty = 0;
        }
        _this.InitObject(undefined, loc, undefined, aid, fid, undefined, "SETPT", true);
        _this.InitMesh(false);
        return _this;
    }
    FRCPoint.prototype.InitMesh = function (reinit) {
        var rgblegs = false;
        if (reinit) {
            this.group.children.pop();
        }
        var lgeometry = new THREE.Geometry();
        var attribute = FRCAttribute.GetAttribute(this.aid);
        var style = attribute.style;
        if (attribute.style & TPGL_STYLE_TRIAD_RGB_LEGS) {
            rgblegs = true;
            style = style - TPGL_STYLE_TRIAD_RGB_LEGS;
        }
        var size = 80;
        switch (style) {
            case TPGL_STYLE_TRIAD_20MM:
                size = 20;
                break;
            case TPGL_STYLE_TRIAD_CENTER - TPGL_STYLE_TRIAD_RGB_LEGS:
                size = 40;
                break;
            case TPGL_STYLE_TRIAD_80MM:
                size = 80;
                break;
            case TPGL_STYLE_TRIAD_400MM:
                size = 400;
                break;
        }
        if (this.lefty) {
            lgeometry.vertices.push(new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, size), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, -size, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(size, 0, 0));
        }
        else {
            lgeometry.vertices.push(new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, 0, size), new THREE.Vector3(0, 0, 0), new THREE.Vector3(0, size, 0), new THREE.Vector3(0, 0, 0), new THREE.Vector3(size, 0, 0));
        }
        var material = FRCAttribute.GetLineMaterial(this.aid);
        if ((attribute.style & TPGL_STYLE_TRIAD_RGB_LEGS) && !this.lefty) {
            var pt = new THREE.AxesHelper(size);
        }
        else {
            var pt = new THREE.LineSegments(lgeometry, material);
        }
        this.group.add(pt);
    };
    FRCPoint.prototype.SETPT = function (loc, lefty, aid, fid) {
        if (!this.aidOK(aid) || this.lefty != lefty) {
            this.SetAid(aid);
            this.lefty = lefty;
            this.InitMesh(true);
        }
        this.EveryCall(loc, undefined, true, fid);
    };
    FRCPoint.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCPoint;
}(FRCObject4d));
var FRCCylCone = (function (_super) {
    __extends(FRCCylCone, _super);
    function FRCCylCone(id, scene, parent, tag, loc3, end, radius, radius2, typ, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.InitObject(undefined, undefined, undefined, aid, fid, undefined, tag, true);
        _this.loc3 = loc3.clone();
        _this.end = end.clone();
        _this.radius = radius;
        _this.radius2 = radius2;
        _this.tag = tag;
        _this.typ = typ;
        _this.height = _this.loc3.distanceTo(_this.end);
        _this.InitMesh(false);
        return _this;
    }
    FRCCylCone.prototype.Cylinder_Setloc = function (point1, point2, rm) {
        rm.lookAt(point1, point2, new THREE.Object3D().up);
        var reorient = new THREE.Matrix4();
        reorient.set(1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 1);
        rm.multiply(reorient);
        rm.elements[12] = (point1.x + point2.x) / 2;
        rm.elements[13] = (point1.y + point2.y) / 2;
        rm.elements[14] = (point1.z + point2.z) / 2;
        if (rm.determinant() == 0) {
            alert("Bad Determinate");
        }
    };
    FRCCylCone.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
            this.group.children.pop();
            this.group.children.pop();
        }
        if (this.tag == "SETCY") {
            this.buffgeometry = new THREE.CylinderBufferGeometry(this.radius2, this.radius, this.height, 32);
        }
        else {
            this.buffgeometry = new THREE.ConeBufferGeometry(this.radius, this.height, 32);
        }
        var material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, undefined);
        this.mesh = new THREE.Mesh(this.buffgeometry, material);
        this.group.add(this.mesh);
        if (this.tag == "SETCY" && this.typ == TPGL_CYSPHERE) {
            var canvas = FRCCanvas.getInstance();
            var spheregeo = canvas.sphere;
            var sphmesh = new THREE.Mesh(spheregeo, material);
            sphmesh.position.x = this.loc3.x;
            sphmesh.position.y = this.loc3.y;
            sphmesh.position.z = this.loc3.z;
            sphmesh.scale.x = this.radius;
            sphmesh.scale.y = this.radius;
            sphmesh.scale.z = this.radius;
            sphmesh.renderOrder = this.Order(spheregeo);
            this.group.add(sphmesh);
            var sphmesh2 = new THREE.Mesh(spheregeo, material);
            sphmesh2.position.x = this.end.x;
            sphmesh2.position.y = this.end.y;
            sphmesh2.position.z = this.end.z;
            this.group.add(sphmesh2);
            sphmesh2.scale.x = this.radius;
            sphmesh2.scale.y = this.radius;
            sphmesh2.scale.z = this.radius;
            sphmesh2.renderOrder = this.Order(spheregeo);
        }
        var loc6 = new THREE.Matrix4();
        this.EveryCall(undefined, undefined, true, undefined);
        this.Cylinder_Setloc(this.loc3, this.end, loc6);
        this.mesh.matrix.identity();
        this.mesh.applyMatrix(loc6);
    };
    FRCCylCone.prototype.CyCone = function (tag, loc3, end, radius, radius2, typ, aid, fid) {
        this.IDATR(aid);
        if (!this.aidOK(aid) ||
            (this.radius != radius) ||
            (this.radius2 != radius2) ||
            (this.typ != typ) ||
            (!this.loc3.equals(loc3)) ||
            (!this.end.equals(end))) {
            this.SetAid(aid);
            this.loc3 = loc3.clone();
            this.end = end.clone();
            this.radius = radius;
            this.radius2 = radius2;
            this.tag = tag;
            this.typ = typ;
            this.height = this.loc3.distanceTo(this.end);
            this.InitMesh(true);
        }
        this.EveryCall(this.loc, this.siz, true, fid);
    };
    FRCCylCone.prototype.SETCY = function (loc3, end, radius, radius2, typ, aid, fid) {
        this.CyCone("SETCY", loc3, end, radius, radius2, typ, aid, fid);
    };
    FRCCylCone.prototype.SETCN = function (loc3, end, radius, radius2, typ, aid, fid) {
        this.CyCone("SETCN", loc3, end, radius, radius2, typ, aid, fid);
    };
    FRCCylCone.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCCylCone;
}(FRCObject4d));
var FRCToroid = (function (_super) {
    __extends(FRCToroid, _super);
    function FRCToroid(id, scene, parent, inloc, radius, radius2, start, end, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.radius = radius;
        _this.radius2 = radius2;
        if (start < 0) {
            start = -start;
        }
        if (end < 0) {
            end = -end;
        }
        if (start > end) {
            start = start - 360;
        }
        _this.start = start;
        _this.end = end;
        inloc.r = inloc.r + start;
        FRCUtility.MatFromXYZWPR(inloc.x, inloc.y, inloc.z, inloc.w, inloc.p, inloc.r, _this.loc);
        _this.InitObject(undefined, _this.loc, undefined, aid, fid, undefined, "SETTOR", true);
        _this.InitMesh(false);
        return _this;
    }
    FRCToroid.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        var arc;
        arc = (this.end - this.start) * Math.PI / 180;
        this.buffgeometry = new THREE.TorusBufferGeometry(this.radius, this.radius2, 16, 100, arc);
        var material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, undefined);
        this.mesh = new THREE.Mesh(this.buffgeometry, material);
        this.group.add(this.mesh);
    };
    FRCToroid.prototype.SETTOR = function (inloc, radius, radius2, start, end, aid, fid) {
        if (start > end) {
            start = start - 360;
        }
        inloc.r = inloc.r + start;
        FRCUtility.MatFromXYZWPR(inloc.x, inloc.y, inloc.z, inloc.w, inloc.p, inloc.r, this.loc);
        this.IDATR(aid);
        if (!this.aidOK(aid) ||
            (this.radius != radius) ||
            (this.radius2 != radius2) ||
            (this.start != start) ||
            (this.end != end)) {
            this.SetAid(aid);
            this.radius = radius;
            this.radius2 = radius2;
            this.start = start;
            this.end = end;
            this.InitMesh(true);
        }
        this.EveryCall(this.loc, undefined, true, fid);
    };
    FRCToroid.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCToroid;
}(FRCObject4d));
var FRCTCFan = (function (_super) {
    __extends(FRCTCFan, _super);
    function FRCTCFan(id, scene, parent, tag, loc, radius, start, end, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.radius = radius;
        _this.start = start;
        _this.end = end;
        _this.tag = tag;
        _this.InitObject(undefined, loc, undefined, aid, fid, undefined, tag, true);
        _this.InitMesh(false);
        return _this;
    }
    FRCTCFan.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        this.geometry = new THREE.CircleGeometry(this.radius, 32, FRCUtility.DEG_TO_RAD(this.start), FRCUtility.DEG_TO_RAD(this.end - this.start));
        var material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, undefined);
        if (material != undefined) {
            material.side = THREE.DoubleSide;
            this.mesh = new THREE.Mesh(this.geometry, material);
            this.group.add(this.mesh);
        }
    };
    FRCTCFan.prototype.SETCFAN = function (tag, loc, radius, start, end, aid, fid) {
        this.IDATR(aid);
        if (!this.aidOK(aid) ||
            (this.tag != tag) ||
            (this.radius != radius) ||
            (this.start != start) ||
            (this.end != end)) {
            this.SetAid(aid);
            this.radius = radius;
            this.start = start;
            this.end = end;
            this.InitMesh(true);
        }
        this.EveryCall(loc, undefined, true, fid);
    };
    FRCTCFan.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCTCFan;
}(FRCObject4d));
var FRCSphere = (function (_super) {
    __extends(FRCSphere, _super);
    function FRCSphere(id, scene, parent, loc, radius, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.radius = radius;
        _this.siz.x = _this.radius;
        _this.siz.y = _this.radius;
        _this.siz.z = _this.radius;
        _this.InitObject(_this.siz, loc, undefined, aid, fid, undefined, "SETSPH", true);
        _this.InitMesh(false);
        return _this;
    }
    FRCSphere.prototype.SETSPH = function (loc, radius, aid, fid) {
        this.IDATR(aid);
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
        this.radius = radius;
        this.siz.x = this.radius;
        this.siz.y = this.radius;
        this.siz.z = this.radius;
        this.EveryCall(loc, this.siz, true, fid);
    };
    FRCSphere.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        var canvas = FRCCanvas.getInstance();
        this.group.children.pop();
        this.geometry = canvas.sphere;
        var material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, undefined);
        material.depthWrite = false;
        this.mesh = new THREE.Mesh(this.geometry, material);
        this.group.add(this.mesh);
        console.log("Sphere render order ", this.radius, " for ", this.id);
        this.mesh.renderOrder = this.Order(this.geometry);
    };
    FRCSphere.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCSphere;
}(FRCObject4d));
var FRCLine = (function (_super) {
    __extends(FRCLine, _super);
    function FRCLine(id, scene, parent, start, end, aid, fid, endid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.endloc = new THREE.Matrix4();
        _this.endline = new THREE.Vector3();
        _this.startline = new THREE.Vector3();
        if (endid != undefined && endid != "") {
            if (endid != _this.endid) {
                FRCFrame.UnSubscribe(endid, _this);
                _this.endid = endid;
                FRCFrame.Subscribe(endid, _this);
            }
        }
        _this.endloc = end;
        _this.startline = new THREE.Vector3(start.elements[12], start.elements[13], start.elements[14]);
        _this.endline = new THREE.Vector3(end.elements[12], end.elements[13], end.elements[14]);
        _this.InitObject(undefined, start, end, aid, fid, endid, "SETLN", false);
        _this.InitMesh(false);
        return _this;
    }
    FRCLine.prototype.SETLN = function (start, end, aid, fid, endid) {
        this.IDATR(aid);
        var startv = new THREE.Vector3(start.elements[12], start.elements[13], start.elements[14]);
        var endv = new THREE.Vector3(end.elements[12], end.elements[13], end.elements[14]);
        if (!this.aidOK(aid) ||
            !endv.equals(this.endline) ||
            !startv.equals(this.startline) ||
            endid != this.endid) {
            this.SetAid(aid);
            this.endline = endv;
            this.startline = startv;
            this.InitMesh(true);
        }
        this.EveryCall(undefined, undefined, true, fid);
    };
    FRCLine.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        this.geometry.vertices.push(this.startline, this.endline);
        var material = FRCAttribute.GetLineMaterial(this.aid);
        var line = new THREE.Line(this.geometry, material);
        this.group.add(line);
    };
    FRCLine.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    FRCLine.prototype.ApplyMatrix = function (matrix) {
        this.geometry.verticesNeedUpdate = true;
        if (this.fid != undefined) {
            var startmat = new THREE.Matrix4();
            startmat.multiplyMatrices(matrix, this.loc);
            this.startline.x = startmat.elements[12];
            this.startline.y = startmat.elements[13];
            this.startline.z = startmat.elements[14];
        }
        if (this.endid != undefined) {
            var endmat = new THREE.Matrix4();
            endmat.multiplyMatrices(matrix, this.endloc);
            this.endline.x = endmat.elements[12];
            this.endline.y = endmat.elements[13];
            this.endline.z = endmat.elements[14];
        }
    };
    FRCLine.prototype.ApplyMatrix2 = function (matrix) {
        this.geometry.verticesNeedUpdate = true;
        if (this.fid != undefined) {
            if (this.fid.search('loc') == 0) {
                var startmat = new THREE.Matrix4();
                startmat.multiplyMatrices(this.loc, matrix);
                this.startline.x = startmat.elements[12];
                this.startline.y = startmat.elements[13];
                this.startline.z = startmat.elements[14];
            }
        }
        if (this.endid != undefined) {
            if (this.endid.search('loc') == 0) {
                var endmat = new THREE.Matrix4();
                endmat.multiplyMatrices(this.endloc, matrix);
                this.endline.x = endmat.elements[12];
                this.endline.y = endmat.elements[13];
                this.endline.z = endmat.elements[14];
            }
        }
    };
    FRCLine.prototype.ApplyFrame = function (frameobj) {
        this.group.matrix = this.loc.clone();
        this.frameoff = frameobj.frame.clone();
        if (this.fid != undefined) {
            if ((this.fid.search('loc') == 0)) {
                this.ApplyMatrix2(frameobj.frame);
            }
            else {
                this.ApplyMatrix(frameobj.frame);
            }
        }
        else if (this.endid != undefined) {
            if ((this.endid.search('loc') == 0)) {
                this.ApplyMatrix2(frameobj.frame);
            }
            else {
                this.ApplyMatrix(frameobj.frame);
            }
        }
        console.log("Applying frame " + frameobj.id + " to " + this.id);
    };
    return FRCLine;
}(FRCObject4d));
var FRCGrid = (function (_super) {
    __extends(FRCGrid, _super);
    function FRCGrid(id, scene, parent, loc, siz, gridsize, aid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.gridsize = gridsize;
        _this.InitObject(undefined, loc, undefined, aid, undefined, undefined, "GRID", true);
        _this.siz = siz;
        _this.InitMesh(false);
        return _this;
    }
    FRCGrid.prototype.SETGRID = function (loc, siz, gridsize, aid) {
        if (!this.aidOK(aid) || gridsize != this.gridsize || !this.siz.equals(siz)) {
            this.SetAid(aid);
            this.siz = siz;
            this.gridsize = gridsize;
            this.InitMesh(true);
        }
        this.EveryCall(loc, new THREE.Vector3(1, 1, 1), true, undefined);
        this.siz = siz;
    };
    FRCGrid.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        this.buffgeometry = new THREE.BufferGeometry();
        var vertices = [], colors = [];
        var divisions = this.siz.x / this.gridsize;
        var ycoor = this.siz.y / 2;
        var xlim = this.siz.x / 2;
        var xcoor = -xlim;
        for (var j = 0; xcoor <= xlim; xcoor = xcoor + this.gridsize) {
            vertices.push(xcoor, -ycoor, 0, xcoor, ycoor, 0);
        }
        var xcoor = this.siz.x / 2;
        var ylim = this.siz.y / 2;
        var ycoor = -ylim;
        for (var j = 0; ycoor <= ylim; ycoor = ycoor + this.gridsize) {
            vertices.push(-xcoor, ycoor, 0, xcoor, ycoor, 0);
        }
        this.buffgeometry.addAttribute('position', new THREE.Float32BufferAttribute(vertices, 3));
        this.material = FRCAttribute.GetLineMaterial(this.aid);
        this.lmesh = new THREE.LineSegments(this.buffgeometry, this.material);
        this.group.add(this.lmesh);
    };
    FRCGrid.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCGrid;
}(FRCObject4d));
var FRCPODLoad = (function () {
    function FRCPODLoad(URL, load) {
        this.IsLoaded = false;
        this.URL = URL;
        this.fs = new PVRFileStream();
        this.mdl = new PVRModel();
        if (load) {
            this.Load();
        }
    }
    FRCPODLoad.prototype.ProgUpd = function () {
        FRCCanvas.Scene.ProgUpd();
    };
    FRCPODLoad.prototype.Load = function () {
        var gl = null;
        this.fs.TargetObject = this;
        this.fs.Open(this.URL, true, this.LoadPod, gl);
    };
    FRCPODLoad.prototype.LoadPod = function (stream) {
        var mythis = stream.TargetObject;
        var podLoader = new PVRPODLoader();
        var result = podLoader.load(stream, mythis.mdl);
        if (result != 0) {
            console.log("Failed to load POD: " + result);
            return;
        }
        mythis.ProgUpd();
        mythis.IsLoaded = true;
    };
    FRCPODLoad.prototype.InitPodGroup = function (group, loc, opacity) {
        var podmaterial;
        var blackboost;
        var blackfactor;
        var podmat = new THREE.Vector4();
        this.ProgUpd();
        if (loc != undefined) {
            if (this.matrix == undefined) {
                this.matrix = new THREE.Matrix4();
                this.matrix = loc.clone();
            }
            else {
                console.log(FRCUtility.Matrix2Str(loc) + " Second offset " + FRCUtility.Matrix2Str(this.matrix));
                loc = undefined;
            }
        }
        for (var idx = 0; idx < this.mdl.data.numMeshes; idx++) {
            var pvrmesh = this.mdl.data.meshes[idx];
            var matindex = this.mdl.data.nodes[idx].data.materialIndex;
            podmaterial = this.mdl.data.materials[matindex];
            podmat.x = podmaterial.data.diffuse[0];
            podmat.y = podmaterial.data.diffuse[1];
            podmat.z = podmaterial.data.diffuse[2];
            if (opacity != undefined) {
                podmat.w = opacity;
            }
            else {
                podmat.w = podmaterial.data.opacity;
            }
            var brightness = podmat.length();
            if (brightness < blackfactor) {
                blackboost = blackfactor;
                podmat.addScalar(blackfactor);
            }
            else {
                blackboost = 0.0;
            }
            var matcolor = new THREE.Vector4(podmaterial.data.diffuse[0] + blackboost, podmaterial.data.diffuse[1] + blackboost, podmaterial.data.diffuse[2] + blackboost, 1.0);
            var ambcolor = new THREE.Vector4(podmaterial.data.diffuse[0] * 0.1, podmaterial.data.diffuse[1] * 0.1, podmaterial.data.diffuse[2] * 0.1, 0.0);
            var bytestride = pvrmesh.data.vertexElements.POSITION0.stride;
            var vertexBuffer = new THREE.InterleavedBuffer(pvrmesh.data.vertexElementData[0], bytestride / 4);
            var geometry = new THREE.BufferGeometry();
            var positions = new THREE.InterleavedBufferAttribute(vertexBuffer, 3, 0, true);
            geometry.addAttribute('position', positions);
            var normals = new THREE.InterleavedBufferAttribute(vertexBuffer, 3, 3, true);
            geometry.addAttribute('normal', normals);
            geometry.setIndex(new THREE.BufferAttribute(pvrmesh.data.faces.data, 1));
            if (loc != undefined) {
                geometry.applyMatrix(loc);
            }
            var material = FRCAttribute.MakeShaderMaterial(podmat, "PODVertexShader", "PODFragmentShader");
            geometry.name = this.URL + idx;
            material.side = THREE.DoubleSide;
            var mesh = new THREE.Mesh(geometry, material);
            mesh.name = this.URL + idx;
            group.add(mesh);
        }
    };
    return FRCPODLoad;
}());
var TPGLANCH_ALL_AXES_C = 0x3F;
var TPGLANCH_XPLS_C = 1;
var TPGLANCH_XMNS_C = 2;
var TPGLANCH_YPLS_C = 4;
var TPGLANCH_YMNS_C = 8;
var TPGLANCH_ZPLS_C = 0x10;
var TPGLANCH_ZMNS_C = 0x20;
var TPGLANCH_XONLY_C = (TPGLANCH_XPLS_C | TPGLANCH_XMNS_C);
var TPGLANCH_YONLY_C = (TPGLANCH_YPLS_C | TPGLANCH_YMNS_C);
var TPGLANCH_ZONLY_C = (TPGLANCH_ZPLS_C | TPGLANCH_ZMNS_C);
var TPGLANCH_CONT_C = 0x40;
var TPGL_ANCHOR_UNDEFINED = 0x7fffffff;
var TPGL_ANCHOR_MINIMIZED = 1;
var TPGL_ANCHOR_MAXIMIZED = 2;
var TPGL_ANCHOR_ACTIVEX = 3;
var TPGL_ANCHOR_ACTIVEY = 4;
var TPGL_ANCHOR_ACTIVEZ = 5;
var TPGL_ANCHOR_HIGHLIGHT = 6;
var HIGHSIZE = 2;
var FRCAnchor = (function () {
    function FRCAnchor(parent) {
        this.State = TPGL_ANCHOR_UNDEFINED;
        this.intersects = new Array();
        this.StartPoint = new THREE.Vector3();
        this.CurrPoint = new THREE.Vector3();
        this.StartLoc = new THREE.Matrix4();
        this.Loc = new THREE.Matrix4();
        this.Parent = parent;
        for (var idx = 0; idx < 2; idx++) {
            this.CurrPoint[idx] = new THREE.Vector3();
        }
    }
    FRCAnchor.prototype.Position = function () {
        var xyzwpr = new FRCXYZWPR();
        FRCUtility.ToXyzWpr(this.Loc, xyzwpr);
        var str = xyzwpr.x.toPrecision(6) + ", " + xyzwpr.y.toPrecision(6) + ", " + xyzwpr.z.toPrecision(6) + ", ";
        str = str + xyzwpr.w.toPrecision(4) + ", " + xyzwpr.p.toPrecision(4) + ", " + xyzwpr.r.toPrecision(4);
        return str;
    };
    FRCAnchor.prototype.SendPkt = function () {
        var view = "&view=" + this.Position();
        FRCCanvas.draw3d_SendPkt(TPGL_DELTAMOVE_FC, this.Parent.scene.ctrl_data, view);
    };
    FRCAnchor.prototype.EndMove = function () {
        if (this.State > TPGL_ANCHOR_MAXIMIZED) {
            this.Parent.loc = this.Loc;
            this.SendPkt();
            this.DeselectAnchor();
        }
    };
    FRCAnchor.prototype.FindIntersects = function (xcoor, ycoor, InGroup) {
        var mouse = new THREE.Vector2();
        var retval = false;
        this.CPIdx = -1;
        this.ShowPlanes();
        mouse.x = (xcoor / document.documentElement.clientWidth) * 2 - 1;
        mouse.y = -(ycoor / document.documentElement.clientHeight) * 2 + 1;
        var scene = this.Parent.scene;
        scene.raycaster.setFromCamera(mouse, scene.camera);
        this.intersects = scene.raycaster.intersectObjects(InGroup.children, true);
        this.HidePlanes();
        return this.intersects.length;
    };
    FRCAnchor.prototype.ContinueMove = function (xcoor, ycoor) {
        var delta;
        if (this.State > TPGL_ANCHOR_MAXIMIZED) {
            var scene = this.Parent.scene;
            if (this.FindIntersects(xcoor, ycoor, this.Parent.group)) {
                for (var idx = 0; idx < this.intersects.length; idx++) {
                    if (this.intersects[idx].object.parent.HostObject == this.Target) {
                        this.CurrPoint = this.intersects[idx].point;
                        break;
                    }
                }
                switch (this.State) {
                    case TPGL_ANCHOR_ACTIVEX:
                        delta = this.StartPoint.x - this.CurrPoint.x;
                        this.Loc.elements[XELE] = this.StartLoc.elements[XELE] - delta;
                        break;
                    case TPGL_ANCHOR_ACTIVEY:
                        delta = this.StartPoint.y - this.CurrPoint.y;
                        this.Loc.elements[YELE] = this.StartLoc.elements[YELE] - delta;
                        break;
                    case TPGL_ANCHOR_ACTIVEZ:
                        delta = this.StartPoint.z - this.CurrPoint.z;
                        this.Loc.elements[ZELE] = this.StartLoc.elements[ZELE] - delta;
                        break;
                }
                if (this.Flags & TPGLANCH_CONT_C) {
                    this.Parent.loc = this.Loc;
                    this.SendPkt();
                }
            }
            else {
                this.Parent.loc.copy(this.StartLoc);
                this.DeselectAxis();
            }
            this.Parent.EveryCall(this.Loc, undefined, true, this.Parent.fid);
            scene.Render();
        }
    };
    FRCAnchor.prototype.SetState = function (state) {
        this.State = state;
    };
    FRCAnchor.prototype.ShowPlanes = function () {
        for (var idx = 0; idx < this.Parent.children.length; idx++) {
            var child = this.Parent.children[idx];
            if (child.tagName == "SETWALL") {
                child.SETVIS(child.id, 1);
            }
        }
    };
    FRCAnchor.prototype.HidePlanes = function () {
        for (var idx = 0; idx < this.Parent.children.length; idx++) {
            var child = this.Parent.children[idx];
            if (child.tagName == "SETWALL") {
                child.SETVIS(child.id, 0);
            }
        }
    };
    FRCAnchor.prototype.MaxAnchor = function (multiplier) {
        this.Parent.siz.x = this.Parent.siz.x * multiplier;
        this.Parent.siz.y = this.Parent.siz.y * multiplier;
        this.Parent.siz.z = this.Parent.siz.z * multiplier;
        this.HidePlanes();
        this.SetState(TPGL_ANCHOR_MAXIMIZED);
        this.Parent.scene.ResumeOrbit();
        this.Parent.scene.Render();
    };
    FRCAnchor.prototype.MinAnchor = function (multiplier) {
        this.Parent.siz.x = this.Parent.siz.x / multiplier;
        this.Parent.siz.y = this.Parent.siz.y / multiplier;
        this.Parent.siz.z = this.Parent.siz.z / multiplier;
        this.ShowPlanes();
        this.SetState(TPGL_ANCHOR_MINIMIZED);
        this.Parent.scene.ResumeOrbit();
        this.Parent.scene.Render();
    };
    FRCAnchor.prototype.DeselectAxis = function () {
        for (var idx = 0; idx < this.Parent.children.length; idx++) {
            this.Parent.children[idx].IDATR(this.DefAttr[idx]);
        }
        this.Target.EveryCall(null, new THREE.Vector3(1.0, 1.0, 1.0), false, null);
        this.SetState(TPGL_ANCHOR_MAXIMIZED);
        this.Parent.scene.ResumeOrbit();
        this.Parent.scene.Render();
    };
    FRCAnchor.prototype.DeselectAnchor = function () {
        if (this.State > TPGL_ANCHOR_MAXIMIZED) {
            this.DeselectAxis();
        }
        if (this.State == TPGL_ANCHOR_MAXIMIZED) {
            this.MinAnchor(this.Multiplier);
        }
        this.Parent.EveryCall(this.Parent.loc, undefined, true, this.Parent.fid);
        this.Parent.scene.Render();
    };
    FRCAnchor.prototype.SelectAxis = function (xcoor, ycoor) {
        var Object4D;
        var delta0 = new Array(3);
        var delta1 = new Array(3);
        var mindistance = 100000;
        var Point;
        var dx, dy, dz;
        var state = TPGL_ANCHOR_MAXIMIZED;
        if (this.FindIntersects(xcoor, ycoor, this.Parent.group) != 0) {
            this.Loc.copy(this.Parent.loc);
            this.StartLoc.copy(this.Parent.loc);
            for (var idx = 0; idx < this.intersects.length; idx++) {
                Object4D = this.intersects[idx].object.parent.HostObject;
                if (Object4D.tagName == "SETWALL") {
                    var world = this.Parent.group.matrixWorld;
                    var split = Object4D.id.split("/");
                    var shortid = split[split.length - 1];
                    dx = Math.abs(world.elements[XELE] - this.intersects[idx].point.x);
                    dy = Math.abs(world.elements[YELE] - this.intersects[idx].point.y);
                    dz = Math.abs(world.elements[ZELE] - this.intersects[idx].point.z);
                    if (shortid == "wallxy") {
                        if (dx > dy) {
                            if (dy < mindistance) {
                                mindistance = dy;
                                this.Target = Object4D;
                                if (this.Flags & TPGLANCH_XONLY_C) {
                                    state = TPGL_ANCHOR_ACTIVEX;
                                }
                                this.StartPoint = this.intersects[idx].point;
                            }
                        }
                        else {
                            if (dx < mindistance) {
                                mindistance = dx;
                                this.Target = Object4D;
                                if (this.Flags & TPGLANCH_YONLY_C) {
                                    state = TPGL_ANCHOR_ACTIVEY;
                                }
                                this.StartPoint = this.intersects[idx].point;
                            }
                        }
                    }
                    else if (shortid == "wallxz") {
                        if (dx > dz) {
                            if (dz < mindistance) {
                                mindistance = dz;
                                this.Target = Object4D;
                                if (this.Flags & TPGLANCH_XONLY_C) {
                                    state = TPGL_ANCHOR_ACTIVEX;
                                }
                                this.StartPoint = this.intersects[idx].point;
                            }
                        }
                        else {
                            if (dx < mindistance) {
                                mindistance = dx;
                                this.Target = Object4D;
                                if (this.Flags & TPGLANCH_ZONLY_C) {
                                    state = TPGL_ANCHOR_ACTIVEZ;
                                }
                                this.StartPoint = this.intersects[idx].point;
                            }
                        }
                    }
                    else if (shortid == "wallyz") {
                        if (dy > dz) {
                            if (dz < mindistance) {
                                mindistance = dz;
                                this.Target = Object4D;
                                if (this.Flags & TPGLANCH_YONLY_C) {
                                    state = TPGL_ANCHOR_ACTIVEY;
                                }
                                this.StartPoint = this.intersects[idx].point;
                            }
                        }
                        else {
                            if (dy < mindistance) {
                                mindistance = dy;
                                this.Target = Object4D;
                                if (this.Flags & TPGLANCH_ZONLY_C) {
                                    state = TPGL_ANCHOR_ACTIVEZ;
                                }
                                this.StartPoint = this.intersects[idx].point;
                            }
                        }
                    }
                    else {
                        console.log("Ignoring " + Object4D.id);
                    }
                }
            }
            this.Target.EveryCall(null, new THREE.Vector3(2.0, 2.0, 2.0), false, null);
            this.SetState(state);
        }
    };
    FRCAnchor.prototype.Highlight = function (aid) {
        if (this.State == TPGL_ANCHOR_MINIMIZED) {
            this.Parent.siz.x = this.Parent.siz.x * HIGHSIZE;
            this.Parent.siz.y = this.Parent.siz.y * HIGHSIZE;
            this.Parent.siz.z = this.Parent.siz.z * HIGHSIZE;
            this.SetState(TPGL_ANCHOR_HIGHLIGHT);
            this.Parent.EveryCall(this.Parent.loc, undefined, true, this.Parent.fid);
            this.Parent.scene.Render();
        }
        else {
            if (this.State == TPGL_ANCHOR_HIGHLIGHT) {
                this.Parent.siz.x = this.Parent.siz.x / HIGHSIZE;
                this.Parent.siz.y = this.Parent.siz.y / HIGHSIZE;
                this.Parent.siz.z = this.Parent.siz.z / HIGHSIZE;
                this.SetState(TPGL_ANCHOR_MINIMIZED);
                this.Parent.EveryCall(this.Parent.loc, undefined, true, this.Parent.fid);
                this.Parent.scene.Render();
            }
        }
    };
    FRCAnchor.prototype.SelectAnchor = function (selected, xcoor, ycoor, button, downaction) {
        var Object4D = this.Parent;
        var cone;
        if (this.DefAttr == null) {
            this.DefAttr = new Array();
            for (var idx = 0; idx < Object4D.children.length; idx++) {
                this.DefAttr[idx] = Object4D.children[idx].aid;
            }
        }
        if (button != 0) {
            this.DeselectAnchor();
        }
        else {
            var scene = Object4D.scene;
            if (this.State == TPGL_ANCHOR_MINIMIZED) {
                this.MaxAnchor(this.Multiplier);
                var selectstr = '&inst=' + scene.tpgl_instance + '&select=' + Object4D.id;
                FRCCanvas.draw3d_SendPkt(TPGL_SELECT_FC, scene.ctrl_data, selectstr);
            }
            else if (this.State == TPGL_ANCHOR_HIGHLIGHT) {
                this.MaxAnchor(this.Multiplier / HIGHSIZE);
                var selectstr = '&inst=' + scene.tpgl_instance + '&select=' + Object4D.id;
                FRCCanvas.draw3d_SendPkt(TPGL_SELECT_FC, scene.ctrl_data, selectstr);
            }
            else {
                if (downaction) {
                    selected.scene.PauseOrbit();
                    this.SelectAxis(xcoor, ycoor);
                    switch (this.State) {
                        case TPGL_ANCHOR_ACTIVEX:
                            for (var idx = 0; idx < Object4D.children.length; idx++) {
                                if (this.Parent.children[idx].tagName == "SETCN") {
                                    cone = Object4D.children[idx];
                                    if (Math.abs(cone.loc3.x) != 0) {
                                        cone.IDATR(this.DefAttr[idx]);
                                    }
                                    else {
                                        cone.IDATR("/anchor/disabled");
                                    }
                                }
                            }
                            break;
                        case TPGL_ANCHOR_ACTIVEY:
                            for (var idx = 0; idx < Object4D.children.length; idx++) {
                                if (this.Parent.children[idx].tagName == "SETCN") {
                                    cone = Object4D.children[idx];
                                    if (Math.abs(cone.loc3.y) != 0) {
                                        cone.IDATR(this.DefAttr[idx]);
                                    }
                                    else {
                                        cone.IDATR("/anchor/disabled");
                                    }
                                }
                            }
                            break;
                        case TPGL_ANCHOR_ACTIVEZ:
                            for (var idx = 0; idx < Object4D.children.length; idx++) {
                                if (this.Parent.children[idx].tagName == "SETCN") {
                                    cone = Object4D.children[idx];
                                    if (Math.abs(cone.loc3.z) != 0) {
                                        cone.IDATR(this.DefAttr[idx]);
                                    }
                                    else {
                                        cone.IDATR("/anchor/disabled");
                                    }
                                }
                            }
                            break;
                        default:
                            console.log("Don't understand what was selected");
                    }
                }
            }
        }
        Object4D.EveryCall(this.Parent.loc, undefined, true, Object4D.fid);
        Object4D.scene.Render();
    };
    FRCAnchor.prototype.SETANCHOR = function (id, loc, vis, multiplier, flags, aid, fid) {
        this.Multiplier = multiplier;
        this.Flags = flags;
        this.Parent.loc = loc;
        this.SetState(TPGL_ANCHOR_MINIMIZED);
        this.Parent.EveryCall(loc, undefined, vis != 0, fid);
    };
    return FRCAnchor;
}());
var PLAYER_PLAYING_FC = 1;
var PLAYER_PAUSED_FC = 2;
var PLAYER_FWD_FC = 3;
var PLAYER_RWD_FC = 4;
var PLAYER_PROGRESS_FC = 5;
var PLAYPAUSE_FC = 6;
var PLAYER_ROTATE_FC = 7;
var PLAYER_SLOW_FC = 8;
var PLAYER_CURSOR_FC = 9;
var PLAYER_NOOP_FC = 10;
var PLAYER_UNHIDE_FC = 10;
var BARHEIGHT_C = 32;
var BARSPACE_C = 50;
var gl_frameidx = 0;
var gl_count = 0;
var FRCAnimate = (function () {
    function FRCAnimate() {
    }
    return FRCAnimate;
}());
var FRCAnitime = (function () {
    function FRCAnitime() {
    }
    return FRCAnitime;
}());
var FRCAnimation = (function () {
    function FRCAnimation(scene) {
        this.initialized = false;
        this.state = PLAYER_PLAYING_FC;
        this.continuous = true;
        this.hide = false;
        this.invisible = false;
        this.strict = true;
        this.horzbar = 50;
        this.barspace = 50;
        this.heightmar = 5;
        this.widthmar = 50;
        this.scene4d = scene;
    }
    FRCAnimation.prototype.Now = function () {
        if (this.strict) {
            return Date.now();
        }
        else {
            return this.time.frames * this.time.frame;
        }
    };
    FRCAnimation.prototype.Time2Str = function (milliseconds) {
        var text;
        var total_seconds = Math.round((milliseconds / 1000) - 0.5);
        var minutes = 0;
        if (total_seconds >= 60) {
            var minutes = Math.trunc(total_seconds / 60);
        }
        var ms = milliseconds % 1000;
        var tenths = Math.round(ms / 100);
        var seconds = total_seconds % 60;
        if (tenths == 10) {
            tenths = 0;
            seconds++;
        }
        if (seconds > 9) {
            text = minutes + ":" + seconds + "." + tenths;
        }
        else {
            text = minutes + ":0" + seconds + "." + tenths;
        }
        return text;
    };
    FRCAnimation.prototype.ForcePause = function () {
        this.state = PLAYER_PAUSED_FC;
        if (!this.invisible) {
            this.slow.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
            this.play.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
            this.forward.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
            this.play.SETSPR(undefined, this.scene4d.imgpathname + "PlayerPlay.png", undefined, undefined, undefined, false);
        }
    };
    FRCAnimation.prototype.Animate = function () {
        this.time.frames++;
        var currtime = this.Now();
        var object;
        if (this.initialized) {
            if (!(this.state == PLAYER_PAUSED_FC)) {
                switch (this.state) {
                    case PLAYER_PLAYING_FC:
                        this.time.elapsed = currtime - this.time.start;
                        gl_frameidx = Math.round(this.time.elapsed / this.time.rate);
                        if (gl_frameidx >= this.numframes) {
                            this.time.elapsed = 0;
                            gl_frameidx = 0;
                            this.time.start = currtime;
                            if (!this.continuous) {
                                this.ForcePause();
                            }
                        }
                        break;
                    case PLAYER_FWD_FC:
                    case PLAYER_SLOW_FC:
                        if (currtime - this.lastindex > this.indextime) {
                            this.lastindex = currtime;
                            gl_frameidx++;
                            if (gl_frameidx >= this.numframes) {
                                gl_frameidx = 0;
                                if (!this.continuous) {
                                    this.ForcePause();
                                }
                                else {
                                    gl_frameidx = 0;
                                }
                            }
                            this.time.elapsed = gl_frameidx * this.time.realrate;
                        }
                        break;
                    case PLAYER_RWD_FC:
                        if (currtime - this.lastindex > this.indextime) {
                            this.lastindex = currtime;
                            gl_frameidx--;
                            if (gl_frameidx < 0) {
                                if (!this.continuous) {
                                    this.state = PLAYER_PAUSED_FC;
                                    this.rewind.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
                                }
                                else {
                                    gl_frameidx = this.numframes;
                                }
                            }
                            this.time.elapsed = gl_frameidx * this.time.realrate;
                        }
                        break;
                }
            }
            if (!this.invisible) {
                var progx = this.zeroprog + (gl_frameidx * this.time.cursorrate);
                FRCUtility.MatFromXYZWPR(progx - (BARSPACE_C / 2), this.verbar, 0, 0, 0, 0, this.progloc);
                if (this.cursor != undefined) {
                    this.cursor.SETSPR(this.progloc, undefined, undefined, undefined, undefined, false);
                }
                var text = this.Time2Str(this.time.elapsed) + " / " + this.Time2Str(this.time.total) + " (" + gl_frameidx + "-" + this.numframes + " )";
                this.timesprite.SETTXT(undefined, text, undefined, undefined, undefined, false);
            }
            if (gl_frameidx != this.last_frameidx) {
                this.last_frameidx = gl_frameidx;
                this.scene4d.objects.forEach(FRCAnimation.AniFrame, object);
                this.scene4d.Render();
            }
        }
    };
    FRCAnimation.prototype.UpdateProgbar = function (x) {
        var offset = x - this.progbar.left;
        var percentage = offset / this.progsize;
        gl_frameidx = Math.round(percentage * this.numframes);
        if (gl_frameidx > this.numframes - 2) {
            gl_frameidx = this.numframes - 2;
        }
        this.time.elapsed = Math.round(gl_frameidx * this.time.realrate);
        this.time.start = this.Now() - this.time.elapsed;
        this.Animate();
    };
    FRCAnimation.prototype.Click = function (sprite, x, y) {
        var currtime = this.Now();
        if (sprite.playerfc == PLAYER_UNHIDE_FC) {
            this.Show();
        }
        else {
            if (sprite.playerfc != PLAYER_ROTATE_FC && sprite.playerfc != PLAYER_NOOP_FC) {
                switch (this.state) {
                    case PLAYER_FWD_FC:
                        this.forward.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
                        break;
                    case PLAYER_RWD_FC:
                        this.rewind.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
                        break;
                    case PLAYER_SLOW_FC:
                        this.slow.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
                        break;
                    default:
                        this.play.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
                }
            }
            switch (sprite.playerfc) {
                case PLAYPAUSE_FC:
                    this.play.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
                    switch (this.state) {
                        case PLAYER_PLAYING_FC:
                        case PLAYER_FWD_FC:
                        case PLAYER_RWD_FC:
                            sprite.SETSPR(undefined, this.scene4d.imgpathname + "PlayerPlay.png", undefined, undefined, undefined, false);
                            this.state = PLAYER_PAUSED_FC;
                            break;
                        case PLAYER_PAUSED_FC:
                        case PLAYER_SLOW_FC:
                            this.state = PLAYER_PLAYING_FC;
                            sprite.SETSPR(undefined, this.scene4d.imgpathname + "PlayerPause.png", undefined, undefined, undefined, false);
                            this.time.start = this.Now() - this.time.elapsed;
                            break;
                    }
                    break;
                case PLAYER_FWD_FC:
                    if (this.state != PLAYER_FWD_FC) {
                        this.indextime = this.time.realrate / 2;
                        this.lastindex = currtime - this.indextime * 2;
                    }
                    else {
                        this.indextime = this.indextime / 2;
                    }
                    this.forward.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
                    this.state = PLAYER_FWD_FC;
                    break;
                case PLAYER_SLOW_FC:
                    if (this.state != PLAYER_SLOW_FC) {
                        this.indextime = this.time.realrate * 4;
                        this.lastindex = currtime - this.indextime;
                    }
                    else {
                        this.indextime = this.indextime * 2;
                    }
                    this.slow.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
                    this.state = PLAYER_SLOW_FC;
                    this.play.SETSPR(undefined, this.scene4d.imgpathname + "PlayerPlay.png", undefined, undefined, undefined, false);
                    break;
                case PLAYER_RWD_FC:
                    if (this.state != PLAYER_RWD_FC) {
                        this.indextime = this.time.realrate;
                        this.lastindex = currtime - this.indextime * 2;
                    }
                    else {
                        this.indextime = this.indextime / 2;
                    }
                    this.rewind.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
                    this.state = PLAYER_RWD_FC;
                    break;
                case PLAYER_ROTATE_FC:
                    if (this.continuous) {
                        this.continuous = false;
                        this.rotate.SETSPR(undefined, undefined, undefined, undefined, 'playernosel', false);
                    }
                    else {
                        this.continuous = true;
                        this.rotate.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
                    }
                    break;
            }
        }
    };
    FRCAnimation.prototype.ANIMATION = function (rate, numframes, imgpath, hide, oneshot) {
        this.timer1 = Date.now();
        if (this.initialized) {
            var object;
            this.initialized = false;
            this.scene4d.objects.forEach(FRCAnimation.AniClear, object);
        }
        else {
            this.progloc = new THREE.Matrix4();
            this.time = new FRCAnitime();
        }
        this.time.realrate = rate;
        this.time.rate = rate;
        this.numframes = numframes;
        this.time.total = rate * numframes;
        if (oneshot !== undefined) {
            this.continuous = !oneshot;
        }
        if (hide !== undefined && hide) {
            this.hide = hide;
            this.invisible = true;
        }
        if (imgpath !== undefined && imgpath != null) {
            this.scene4d.imgpathname = imgpath;
        }
        if (!this.hide) {
            var attobject = FRCAttribute.GetAttribute('playertext');
            attobject.SETATR(false, 1, 0, 0, 0, 0, 0, 0xFFFFFF, "Verdana", 14, 0, 0);
            var attobject = FRCAttribute.GetAttribute('playernosel');
            attobject.SETATR(false, 1, 30, 0, 0, 0, 0, 0xFFFFFF, "Verdana", 14, 0, 0);
            var attobject = FRCAttribute.GetAttribute('playersel');
            attobject.SETATR(false, 1, 30, 0, 0, 0, 0, 0xF0, "Verdana", 10, 0, 0);
            this.parent = this.scene4d.GetObject("/menu/player", undefined);
            this.InitSprites();
        }
        this.time.frame = 4;
        this.time.frames = 0;
        this.time.start = this.Now();
        this.time.elapsed = 0;
    };
    FRCAnimation.prototype.ANIMATEND = function () {
        var object;
        gl_count = this.numframes;
        this.timer2 = Date.now();
        this.scene4d.objects.forEach(FRCAnimation.AniEnd, object);
        console.log("XML process = " + (this.timer2 - this.timer1) + " Sync = ", (Date.now() - this.timer2));
        this.initialized = true;
    };
    FRCAnimation.AniEnd = function (object) {
        object.SyncAnimation(gl_count);
    };
    FRCAnimation.AniFrame = function (object) {
        object.AniFrame(gl_frameidx);
    };
    FRCAnimation.AniClear = function (object) {
        object.AniClear();
    };
    FRCAnimation.prototype.Hide = function () {
        if (!this.invisible) {
            this.invisible = true;
            if (this.initialized) {
                this.parent.SETVIS(this.parent.id, 0);
            }
            this.unhide.SETVIS(this.unhide.id, 1);
        }
    };
    FRCAnimation.prototype.Show = function () {
        if (this.invisible) {
            this.invisible = false;
            this.parent.SETVIS(this.parent.id, 1);
            if (this.initialized) {
                for (var idx = 0; idx < this.parent.children.length; idx++) {
                    this.parent.children[idx].SETVIS(this.parent.children[idx].id, 1);
                }
            }
            this.unhide.SETVIS(this.unhide.id, 0);
        }
    };
    FRCAnimation.prototype.InitSprite = function (tag, inid, fc, height, width, x, y, pointerevents) {
        FRCUtility.MatFromXYZWPR(x, y, 0, 0, 0, 0, this.progloc);
        if (tag == 'SETTXT') {
            imagename = inid;
        }
        else {
            var imagename = this.scene4d.imgpathname + "Player" + inid + '.png';
        }
        var id = "/menu/player/" + inid;
        var object = this.scene4d.GetObjectIf(id, this.parent.id);
        if (object == undefined) {
            object = new FRCSprite(id, this.scene4d, this.parent, tag, this.progloc, height, width, imagename, 'playernosel', undefined, pointerevents);
            this.scene4d.objects.set(id, object);
        }
        else {
            if (tag == 'SETTXT') {
                object.SETTXT(this.progloc, "", height, width, 'playernosel', false);
            }
            else {
                object.SETSPR(this.progloc, imagename, height, width, 'playernosel', false);
            }
        }
        object.playerfc = fc;
        return object;
    };
    FRCAnimation.prototype.InitSprites = function () {
        if (!this.hide) {
            this.progwidth = document.documentElement.clientWidth - (5 * BARSPACE_C) - (2 * this.widthmar);
            this.verbar = document.documentElement.clientHeight - BARHEIGHT_C - this.heightmar;
            var left = this.widthmar;
            this.rotate = this.InitSprite("SETSPR", "Rotate", PLAYER_ROTATE_FC, BARHEIGHT_C, BARSPACE_C - 2, left, this.verbar, false);
            left = left + BARSPACE_C;
            this.rewind = this.InitSprite("SETSPR", "Rew", PLAYER_RWD_FC, BARHEIGHT_C, BARSPACE_C - 2, left, this.verbar, false);
            left = left + BARSPACE_C;
            this.slow = this.InitSprite("SETSPR", "Slow", PLAYER_SLOW_FC, BARHEIGHT_C, BARSPACE_C - 2, left, this.verbar, false);
            left = left + BARSPACE_C;
            this.play = this.InitSprite("SETSPR", "Pause", PLAYPAUSE_FC, BARHEIGHT_C, BARSPACE_C - 2, left, this.verbar, false);
            left = left + BARSPACE_C;
            this.progbar = this.InitSprite("SETSPR", "Prog", PLAYER_PROGRESS_FC, BARHEIGHT_C, this.progwidth, left, this.verbar, true);
            this.progbar.MouseDelegate(this, this.MouseProg);
            left = left + this.progwidth;
            this.forward = this.InitSprite("SETSPR", "Fwd", PLAYER_FWD_FC, BARHEIGHT_C, BARSPACE_C - 2, left, this.verbar, false);
            this.timesprite = this.InitSprite("SETTXT", "TimeStr", PLAYER_NOOP_FC, BARHEIGHT_C, BARSPACE_C - 2, BARSPACE_C * 4 + this.widthmar, this.verbar + 16, false);
            this.timesprite.SETSPR(undefined, undefined, undefined, undefined, 'playertext', false);
            left = document.documentElement.clientWidth / 2 - 32;
            this.unhide = this.InitSprite("SETSPR", "UnHide", PLAYER_UNHIDE_FC, 20, 64, left, this.verbar + 20, false);
            if (!this.invisible) {
                this.unhide.SETVIS(this.unhide.id, 0);
            }
            this.play.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
            if (this.continuous) {
                this.rotate.SETSPR(undefined, undefined, undefined, undefined, 'playersel', false);
            }
            this.zeroprog = (this.progbar.left + BARSPACE_C / 2);
            this.progsize = this.forward.left - this.zeroprog - BARSPACE_C / 3;
            this.time.cursorrate = this.progsize / this.numframes;
            this.time.cursorrate = this.progsize / this.numframes;
            this.cursor = this.InitSprite("SETSPR", "Cursor", PLAYER_CURSOR_FC, BARHEIGHT_C, BARSPACE_C - 2, this.zeroprog, this.verbar, false);
            this.progbar.div.style.cursor = "hand";
            var cursordiv = this.progbar.div.firstChild;
            cursordiv.draggable = false;
        }
    };
    FRCAnimation.prototype.MouseProg = function (mythis, fc, inevent) {
        mythis.ForcePause();
        mythis.UpdateProgbar(inevent.clientX);
    };
    FRCAnimation.prototype.ReSize = function () {
        if (this.initialized) {
            this.InitSprites();
        }
    };
    return FRCAnimation;
}());
var QueueEntry = (function () {
    function QueueEntry(fc, optional) {
        this.fc = fc;
        this.optional = optional;
    }
    return QueueEntry;
}());
var FRCConnect = (function () {
    function FRCConnect(responseURL) {
        this.busy = false;
        this.inisent = false;
        this.pendingevent = false;
        this.standalone = true;
        this.pipe_suspend = false;
        this.logged_in = false;
        this.slave = false;
        this.IPAddress = responseURL;
    }
    FRCConnect.prototype.AddStuff = function (xmlhttp) {
        xmlhttp.mythis = this;
    };
    FRCConnect.prototype.Debug = function (buffer) {
    };
    FRCConnect.prototype.Initialize = function (pipename, ipaddress) {
        this.Scene = FRCCanvas.GetScene(pipename);
        if (pipename != undefined) {
            this.PipeName = pipename;
        }
        this.xml4d = new FRCXML4D(this);
        this.xmlhttp = new XMLHttpRequest();
        this.AddStuff(this.xmlhttp);
        this.exmlhttp = new XMLHttpRequest();
        this.AddStuff(this.exmlhttp);
        this.queue = new Array();
    };
    FRCConnect.prototype.LoginData = function (connect_id, subpane) {
        this.connect_id = connect_id;
        this.subpane = subpane;
        this.logged_in = true;
    };
    FRCConnect.prototype.Login = function (callback) {
        this.logincallback = callback;
        this.Debug("Login");
        this.sendReq('', '/softpart/sfdiagtp?fc=0x43000f&portno=0&login=json&config=0&activex=0&callback=0', this.login_cb, this.HTTPError);
    };
    FRCConnect.prototype.LoginSlave = function () {
        if (this.logged_in) {
        }
        else {
            this.Debug("LoginSlave");
            this.slave = true;
            this.sendReq('', '/softpart/sfdiagtp?fc=0x43000f&portno=0&login=json&config=0&activex=0&callback=0', this.login_cb, this.SlaveError);
        }
    };
    FRCConnect.prototype.LogOut = function () {
        if (this.logged_in && this.connect_id != 0) {
            this.sendReq('', '/softpart/sfdiagtp?fc=0x430017&connect_id=' + this.connect_id, this.noop, this.noop);
            this.connect_id = 0;
        }
    };
    FRCConnect.prototype.noop = function () {
    };
    FRCConnect.prototype.StartProcessing = function (proctype) {
        this.Debug("StartProcessing " + proctype);
        this.busy = false;
        this.Response = this.xmlhttp.responseText;
        try {
            this.json = JSON.parse(this.Response);
        }
        catch (err) {
            alert('[FRCConnect] json err: ' + proctype + ' ' + err.description + ' setting: ' + this.xmlhttp.responseText);
            this.xmlhttp.abort();
            return false;
        }
        this.xmlhttp.abort();
        return true;
    };
    FRCConnect.prototype.FixJSON = function (jsontext) {
        var newjsontext = '';
        var xmlarray = [];
        var xmlstart = jsontext.indexOf('XMLbuf');
        while (xmlstart >= 0) {
            xmlstart += 9;
            var xmlend = jsontext.indexOf('"}', xmlstart);
            if (xmlend >= 0) {
                xmlarray.push(jsontext.substring(xmlstart, xmlend));
                newjsontext = jsontext.substring(0, xmlstart) + jsontext.substr(xmlend);
                jsontext = newjsontext;
            }
            xmlstart = jsontext.indexOf('XMLbuf', xmlstart);
        }
        if (newjsontext == '') {
            newjsontext = jsontext;
        }
        try {
            var json = JSON.parse(newjsontext);
            if (undefined != json.FANUC.PMEV) {
                this.HandleEvents(json, xmlarray);
            }
        }
        catch (err) { }
        ;
    };
    FRCConnect.prototype.HandleEvents = function (json, xmlarray) {
        var xmlidx = 0;
        var xmllen = 0;
        if (xmlarray) {
            xmllen = xmlarray.length;
        }
        this.Debug("HandleEvents ");
        for (var idx = 0; idx < json.FANUC.PMEV.length; idx++) {
            if (parseInt(json.FANUC.PMEV[idx].subsys_code) == SSC_PMON) {
                if (parseInt(json.FANUC.PMEV[idx].pmev_type) == PMEV_PIPE_C) {
                    if (json.FANUC.PMEV[idx].file == this.PipeName) {
                        var buffer;
                        if (undefined == json.FANUC.PMEV[idx].buffer) {
                            if (xmlidx < xmllen) {
                                buffer = xmlarray[xmlidx++];
                            }
                        }
                        else {
                            buffer = json.FANUC.PMEV[idx].buffer;
                        }
                        if (buffer.length > 0) {
                            FRCCanvas.XMLPipe(this, buffer);
                            this.Debug("PipeEvent ");
                        }
                    }
                }
            }
        }
        var scene = FRCCanvas.GetScene(this.PipeName);
        var view = "&view=" + scene.View();
        FRCCanvas.draw3d_SendPkt(TPGL_DELTADRAW_FC, undefined, view);
    };
    FRCConnect.prototype.PMONEvent = function () {
        try {
            var json = JSON.parse(this.exmlhttp.responseText);
        }
        catch (err) {
            var pos = this.exmlhttp.responseText.indexOf('{"FANUC"');
            if (pos >= 0) {
                this.FixJSON(this.exmlhttp.responseText.substr(pos));
            }
            else {
                alert('[webgl.stm] getnextevent err: ' + err.description + ' setting: ' + this.exmlhttp.responseText);
            }
            this.exmlhttp.abort();
            this.pendingevent = true;
            return;
        }
        this.exmlhttp.abort();
        try {
            if (undefined != json.FANUC.RPC) {
                if (parseInt(json.FANUC.RPC[0].status) != 0) {
                    document.location.href = "/frh/diageg/TPIF.htm#TPIF-215";
                    return;
                }
                this.pendingevent = true;
                return;
            }
            if (undefined != json.FANUC.PMEV) {
                this.HandleEvents(json, null);
            }
        }
        catch (err) {
            this.Debug("HandleEvents Error 2");
        }
        ;
        this.pendingevent = true;
    };
    FRCConnect.prototype.getnextevent_cb = function () {
        this.mythis.PMONEvent();
    };
    FRCConnect.prototype.sendEvent = function (parms, callback, onerror) {
        var url = 'http://' + this.IPAddress + '/COMET/rpc?func=PMON_GET_PKT&connect_id=' + this.connect_id + '&' + parms;
        this.Debug("EventURL = PMON_GET_PKT");
        this.exmlhttp.onload = callback;
        this.exmlhttp.onerror = onerror;
        try {
            this.exmlhttp.open("GET", url, true);
            this.exmlhttp.send();
        }
        catch (_a) {
            this.HTTPError();
        }
    };
    FRCConnect.prototype.GetNextEvent = function () {
        if (!this.connect_id) {
            return;
        }
        var get_pkt_seq = new Date().getTime();
        this.sendEvent('/COMET/rpc?func=PMON_GET_PKT&connect_id=' + this.connect_id + '&_seq=' + get_pkt_seq, this.getnextevent_cb, this.HTTPError);
    };
    FRCConnect.prototype.ProcessRPC = function (proctype) {
        if (this.StartProcessing(proctype)) {
            if (this.json.FANUC.RPC[0].status != 0) {
                alert('[FRCConnect] ' + proctype + ' status: ' + this.json.FANUC.RPC[0].status);
                return false;
            }
        }
        else {
            return false;
        }
        return true;
    };
    FRCConnect.prototype.XMLload = function (stream) {
        var length = stream.GetSize();
        var xmltext = stream.ReadString(length, 0);
        stream.TargetConnect.Scene.ProcessXML(stream.TargetConnect, xmltext, false);
    };
    FRCConnect.prototype.ProcessPMON = function () {
        this.StartProcessing('pmon event');
        this.GetNextEvent();
        FRCCanvas.draw3d_SendPkt(TPGL_INITWGLDRAW_FC, undefined, undefined);
    };
    FRCConnect.prototype.pmon_start_mon_cb = function () {
        this.mythis.ProcessPMON();
    };
    FRCConnect.prototype.InitPMON = function () {
        var panepar = this.PipeName.split('.');
        this.subpane = parseInt(panepar[0].substr(3));
        this.sendReq('pmon_start_mon', 'mon_type=' + PMON_MON_PIPE_C + '&file=' + this.PipeName + '&latency=32767', this.pmon_start_mon_cb, this.HTTPError);
    };
    FRCConnect.prototype.ExecLogin = function () {
        this.StartProcessing("Login");
        this.logged_in = true;
        try {
            if (undefined != this.json.FANUC.connect_id) {
                this.connect_id = this.json.FANUC.connect_id;
                if (!this.slave) {
                    this.InitPMON();
                    this.logincallback(this.connect_id);
                }
            }
            else {
                console.log("Undefined connect id in ExecLogin");
            }
        }
        catch (err) {
            if (this.Response.indexOf('"FANUC":{"connect_id') >= 0) {
                document.location.href = "/frh/diageg/TPIF.htm#TPIF-264";
            }
            else {
                document.location.href = '/softpart/sfdiagtp?fc=0x43000f&portno=0&login=json&config=0&activex=0&callback=0';
            }
        }
    };
    FRCConnect.prototype.getpipe_cb = function () {
        var mythis = this.mythis;
        if (mythis.ProcessRPC("GetPipe")) {
            try {
                mythis.PipeName = mythis.json.FANUC.RPC[0].value;
                mythis.InitPMON();
            }
            catch (_a) {
                this.abort();
                console.log("Could not log into " + this.mythis.IPAddress);
            }
        }
    };
    FRCConnect.prototype.SlaveLogin = function () {
        this.ExecLogin();
        this.sendReq('', "/COMET/rpc?func=VMIP_READVA&prog_name=*system*&var_name=$TPGL_OUTPUT.$NEXTPIPE", this.getpipe_cb, this.HTTPError);
    };
    FRCConnect.prototype.login_cb = function () {
        var mythis = this.mythis;
        if (mythis.slave) {
            mythis.SlaveLogin();
        }
        else {
            mythis.ExecLogin();
        }
    };
    FRCConnect.prototype.ossndpkt_cb = function () {
        this.mythis.ProcessRPC("osxndpkt");
    };
    FRCConnect.prototype.sendReq = function (func, parms, callback, onerror) {
        if (func == '') {
            var url = 'http://' + this.IPAddress + parms;
        }
        else {
            var url = 'http://' + this.IPAddress + '/COMET/rpc?func=' + func + '&connect_id=' + this.connect_id + '&' + parms;
        }
        this.Debug("ReqUrl = " + func);
        var randomnumber = Math.floor(Math.random() * 9999999);
        url += '&r=' + randomnumber;
        this.xmlhttp.onload = callback;
        this.xmlhttp.onerror = onerror;
        try {
            this.xmlhttp.open("GET", url, true);
            this.xmlhttp.send();
        }
        catch (_a) {
            this.HTTPError();
        }
    };
    FRCConnect.prototype.HTTPError = function () {
        this.abort();
        alert("Robot has disconnected");
    };
    FRCConnect.prototype.SlaveError = function () {
        this.abort();
        console.log("Could not log into " + this.mythis.IPAddress);
    };
    FRCConnect.prototype.abort = function () {
        this.xmlhttp.abort();
    };
    FRCConnect.prototype.CheckQueue = function () {
        if (this.pendingevent) {
            this.pendingevent = false;
            this.GetNextEvent();
            return true;
        }
        if ((this.queue.length > 0) && (!this.busy)) {
            var current_item = this.queue.pop();
            this.IntSendPkt(current_item.fc, current_item.optional);
            if (this.queue.length > 1) {
                console.log("Dequeing " + current_item.fc + " remaining " + this.queue.length);
            }
            return true;
        }
        return false;
    };
    FRCConnect.prototype.Duplicate = function (fc, optional) {
        for (var idx = 0; idx < this.queue.length; idx++) {
            if (this.queue[idx].fc == fc) {
                this.queue[idx].optional = optional;
                return true;
            }
        }
        return false;
    };
    FRCConnect.prototype.IntSendPkt = function (fc, optional) {
        if ((fc == TPGL_DELTADRAW_FC) && (this.inisent == false)) {
            console.log("Ignoring deltadraw for now");
        }
        else {
            this.busy = true;
            var request = 'p_type=7&r_id=0&s_code=169&t_id=297&p_id=1398158149&vers=910029&pane=254&subpane=' + this.subpane + '&scene=default&r_code=';
            request = request + fc + optional;
            this.sendReq('ossndpkt_ext', request, this.ossndpkt_cb, this.HTTPError);
            if (fc == TPGL_INITWGLDRAW_FC) {
                this.inisent = true;
            }
        }
    };
    FRCConnect.prototype.SendPacket = function (fc, optional) {
        if (this.logged_in) {
            if (this.standalone) {
                var new_item;
                if (this.busy || this.CheckQueue()) {
                    if (!this.Duplicate(fc, optional)) {
                        new_item = new QueueEntry(fc, optional);
                        this.queue.push(new_item);
                    }
                }
                else {
                    this.IntSendPkt(fc, optional);
                }
            }
            else {
                draw3d_SendPkt(fc, this.ctrl_data, optional);
            }
        }
    };
    FRCConnect.Log = '';
    return FRCConnect;
}());
var TPGL_VERT_TFAN = 0;
var TPGL_VERT_TSTRIP = 1;
var TPGL_VERT_TRIANGLE = 2;
var TPGL_VERT_POINTS = 3;
var TPGL_VERT_LINES = 4;
var TPGL_VERT_LINE_LOOP = 5;
var FRCVertices = (function (_super) {
    __extends(FRCVertices, _super);
    function FRCVertices(id, scene, parent, loc, text, type, frmt, aid, fid) {
        var _this = _super.call(this, id, scene, parent) || this;
        _this.text = text;
        _this.type = type;
        _this.frmt = frmt;
        _this.InitObject(undefined, loc, undefined, aid, fid, undefined, "SETVERT", true);
        _this.attribute = FRCAttribute.GetAttribute(_this.aid);
        _this.InitMesh(false);
        return _this;
    }
    FRCVertices.prototype.SETVERT = function (loc, text, type, frmt, aid, fid) {
        this.IDATR(aid);
        if (!this.aidOK(aid) ||
            this.text != text ||
            this.type != type ||
            this.frmt != frmt) {
            this.SetAid(aid);
            this.text = text;
            this.type = type;
            this.frmt = frmt;
            this.attribute = FRCAttribute.GetAttribute(this.aid);
            this.InitMesh(true);
        }
        this.EveryCall(loc, undefined, true, fid);
    };
    FRCVertices.CloudLoad = function (stream) {
        var target = stream.object4d;
        target.CloudLoad(stream);
    };
    FRCVertices.prototype.CloudLoad = function (stream) {
        var length = stream.GetSize();
        if (length < 4) {
            console.log("CloudLoad empty vertex file " + this.text + " @ " + this.id);
        }
        else {
            this.vertfloats32 = stream.ReadFloat32Array(length / 4, 0);
            if (this.NormalType()) {
                var before = Date.now();
                this.vertfloats = Array.prototype.slice.call(this.vertfloats32);
                this.NormalGeometry();
                console.log("Computation time " + (Date.now() - before) + "ms for " + length);
            }
            else {
                this.SimGeometry();
            }
        }
    };
    FRCVertices.prototype.StartLoad = function (url) {
        var myurl;
        var visloader = new FRCLoader(url, null);
        visloader.LoadPointCloud(this);
    };
    FRCVertices.prototype.NormalType = function () {
        var SetNormal;
        switch (this.type) {
            case TPGL_VERT_TSTRIP:
            case TPGL_VERT_TFAN:
            case TPGL_VERT_TRIANGLE:
                SetNormal = true;
                break;
            case TPGL_VERT_POINTS:
            case TPGL_VERT_LINES:
            case TPGL_VERT_LINE_LOOP:
                SetNormal = false;
                break;
        }
        return SetNormal;
    };
    FRCVertices.prototype.InitMesh = function (reinit) {
        if (reinit) {
            this.group.children.pop();
        }
        var check = this.text.search('url:');
        if (check >= 0) {
            this.StartLoad(this.text.substr(check + 4, 10000));
        }
        else {
            var SetNormal = this.NormalType();
            this.text = this.text.replace(new RegExp('\r?\n', 'g'), ',');
            for (; this.text.charAt(0) == ",";) {
                this.text = this.text.substr(1, 10000);
            }
            var vertex = this.text.split(",");
            if (SetNormal) {
                this.vertfloats = new Array();
            }
            else {
                this.vertfloats32 = new Float32Array(vertex.length);
            }
            for (var idx = 0; idx < vertex.length; idx++) {
                vertex[idx] = vertex[idx].trim();
                if (vertex[idx] != "") {
                    if (SetNormal) {
                        this.vertfloats.push(parseFloat(vertex[idx]));
                    }
                    else {
                        this.vertfloats32[idx] = parseFloat(vertex[idx]);
                    }
                }
            }
            if (SetNormal) {
                this.NormalGeometry();
            }
            else {
                this.SimGeometry();
            }
        }
    };
    FRCVertices.prototype.NormalGeometry = function () {
        this.material = FRCAttribute.GetShaderMaterial(this.aid, this.scene, 1.0);
        this.geometry = new THREE.Geometry();
        for (var idx = 0; idx < this.vertfloats.length; idx = idx + 3) {
            this.geometry.vertices.push(new THREE.Vector3(this.vertfloats[idx], this.vertfloats[idx + 1], this.vertfloats[idx + 2]));
        }
        switch (this.type) {
            case TPGL_VERT_TSTRIP:
                this.TSTRIPMesh();
                break;
            case TPGL_VERT_TFAN:
                this.TFANMesh();
                break;
            case TPGL_VERT_TRIANGLE:
                this.TRIANGLEMesh();
                break;
        }
        this.mesh.renderOrder = this.Order(this.geometry);
        this.group.add(this.mesh);
    };
    FRCVertices.prototype.GenTestMaterial = function () {
        this.tmaterial = new THREE.MeshBasicMaterial({ color: this.attribute.color });
        this.tmaterial.side = THREE.DoubleSide;
    };
    FRCVertices.prototype.SimGeometry = function () {
        this.buffgeometry = new THREE.BufferGeometry();
        this.buffgeometry.addAttribute('position', new THREE.BufferAttribute(this.vertfloats32, 3));
        switch (this.type) {
            case TPGL_VERT_POINTS:
                var pmaterial = FRCAttribute.GetPointMaterial(this.aid);
                var pmesh = new THREE.Points(this.buffgeometry, pmaterial);
                this.group.add(pmesh);
                break;
            case TPGL_VERT_LINES:
                var lmaterial = FRCAttribute.GetLineMaterial(this.aid);
                var lmesh = new THREE.LineSegments(this.buffgeometry, lmaterial);
                this.group.add(lmesh);
                break;
            case TPGL_VERT_LINE_LOOP:
                var lmaterial = FRCAttribute.GetLineMaterial(this.aid);
                var lmesh = new THREE.Line(this.buffgeometry, lmaterial);
                this.group.add(lmesh);
                break;
            case TPGL_VERT_TRIANGLE:
                this.GenTestMaterial();
                var mesh = new THREE.Mesh(this.buffgeometry, this.tmaterial);
                mesh.renderOrder = this.Order(this.buffgeometry);
                mesh.drawMode = THREE.TrianglesDrawMode;
                this.material.side = THREE.DoubleSide;
                this.group.add(mesh);
        }
    };
    FRCVertices.prototype.TSTRIPMesh = function () {
        for (var idx = 0; idx < this.geometry.vertices.length - 2; idx++) {
            this.geometry.faces.push(new THREE.Face3(idx, idx + 1, idx + 2));
        }
        this.geometry.computeFaceNormals();
        this.mesh = new THREE.Mesh(this.geometry, this.material);
        this.material.side = THREE.DoubleSide;
        this.mesh.drawMode = THREE.TriangleStripDrawMode;
    };
    FRCVertices.prototype.TFANMesh = function () {
        var num_faces = (this.vertfloats.length / 3) - 2;
        for (var idx = 0; idx < num_faces; idx++) {
            this.geometry.faces.push(new THREE.Face3(0, idx + 1, idx + 2));
        }
        this.geometry.computeFaceNormals();
        this.mesh = new THREE.Mesh(this.geometry, this.material);
        this.material.side = THREE.DoubleSide;
        this.mesh.drawMode = THREE.TriangleFanDrawMode;
    };
    FRCVertices.prototype.TRIANGLEMesh = function () {
        var num_faces = this.vertfloats.length / 9;
        for (var idx = 0; idx < this.geometry.vertices.length; idx = idx + 3) {
            this.geometry.faces.push(new THREE.Face3(idx, idx + 1, idx + 2));
        }
        this.geometry.computeFaceNormals();
        this.material.transparent = false;
        this.material.opacity = 1.0;
        this.material.side = THREE.DoubleSide;
        this.mesh = new THREE.Mesh(this.geometry, this.material);
        this.mesh.drawMode = THREE.TrianglesDrawMode;
    };
    FRCVertices.prototype.IDATR = function (aid) {
        if (!this.aidOK(aid)) {
            this.SetAid(aid);
            this.InitMesh(true);
        }
    };
    return FRCVertices;
}(FRCObject4d));
//# sourceMappingURL=frcwebgl.js.map