/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2011
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: form.js
 *  
 *  Description:
 *    Form Manager routines
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  01-JAN-2011 EVANSJA Initial version.
 *  -
*/

$.ajaxSetup({
  // Disable caching of AJAX responses */ 
  cache: false
});

$(document).ready(function() {
  // Prevent forms from being submitted.
  $("form").submit(function() {
    return false;
  });

  // Handle ajax errors
  jQuery(document).ajaxError(function(event, request, settings, exception) {
    if (request.status == 204) {
      // No content
    }
    else if (request.status == 12152) {
      // Connection Closed by Server?
    }
    else if (exception) {
      rpcmc_rprintf('[form] exception: ' + exception + ' setting: ' + settings.url);
    }
    else {
      rpcmc_rprintf('[form] status: ' + request.status + ' setting: ' + settings.url);
    }
    getnextevent();
  });

  // Get events from the robot
  getnextevent();
});

/*
 * Ask COMET for the next event.  This will wait until an event is returned.
 */
function getnextevent() {
  var connect_id;
  if (typeof (top.g_connect_id) == 'undefined') {
    connect_id = 0;
  }
  else {
    connect_id = top.g_connect_id;
  }
  $.getJSON("/COMET/rpc?func=GET_FORM&connect_id=" + connect_id + "&task_id=" + g_task_id, function(json) {
    if (undefined != json.FANUC.PMEV) {
      for (var idx = 0; idx < json.FANUC.PMEV.length; idx++) {
        if (SSC_WD == parseInt(json.FANUC.PMEV[idx].subsys_code)) {
          if (wdwm_req_upd_c == parseInt(json.FANUC.PMEV[idx].request_code)) {
            if ((undefined != json.FANUC.PMEV[idx].id) &&
                (undefined != json.FANUC.PMEV[idx].value)) {
              var myid = "#" + json.FANUC.PMEV[idx].id;
              var theType = $(myid).attr("type"); 
              var new_val = json.FANUC.PMEV[idx].value;
              if (undefined == theType) {
                $(myid).html(new_val);
              }
              else if (theType == "text") {
                $(myid).val(new_val);
              }
              else if (theType == "checkbox") {
                if (new_val === "0") {
                  $(myid).attr('checked', false);
               }
                else {
                  $(myid).attr('checked', true);
                }
              }
              else if (theType.indexOf("select") >= 0) {
                $(myid).find("option[text='" + new_val + "']").attr('selected', 'selected');
              }
              else if ((theType == "submit") || (theType == "button")) {
                // button
                // Show trailing spaces
                new_val = new_val.replace(/\s/g, '&nbsp;');
                $(myid).html(new_val);
              }
              else if ($(myid + '_list').html() != null) {
                linkselect_event(myid, new_val);             
              }
            }
          }
          else if (wd_req_scsr_c == parseInt(json.FANUC.PMEV[idx].request_code)) {
            if (undefined != json.FANUC.PMEV[idx].id) {
              var myid = "#" + json.FANUC.PMEV[idx].id;
              $(myid).focus();
            }
          }
        } // if SSC_WD
      } // for each event
    } // if PMEV

    getnextevent();
  });
} // getnextevent

/*
 * Select the proper option in the linkselect element.
 */
function linkselect_event(myid, value) {
  if (g_echo) {
    // Backup value
    window[myid] = value;
  }

  var fnd = false;
  // Find text in the list that matches the given value
  $(myid + '_list li').each(function(index) {
    // Trim trailing spaces
    value = value.replace(/\s*$/, '');
    if ($(this).text() == value) {
      // Now select this option using attribute rel without the callback
      $(myid).linkselect('val', $(this).attr('rel'), false);
      fnd = true;
      return false;
    }
  });
  if (!fnd) {
    // Select first
    $(myid + '_list li').each(function(index) {
      $(myid).linkselect('val', $(this).attr('rel'), false);
      return false;
    });
  }
}

/*
 * Tell the web server that the named item has been selected in the named
 * linkselect element.
 */
function linkselect_onchange(myid, id_name, value) {
  if (g_echo) {
    // Restore backup value
    if (undefined != window[myid]) {
      setTimeout('linkselect_event("' + myid + '","' + window[myid] + '")', 0);
    }
    return;
  }
  $.getJSON("/COMET/rpc?func=SET_FORM" +
      "&task_id=" + g_task_id +
      "&id=" + id_name + 
      "&value=" + value, function(json) {
    if (undefined != json.FANUC.RPC) {
      if (json.FANUC.RPC[0].status != 0) {
        rpcmc_rprintf("[rpcmc] SET_FORM " + request_code + " failed, status " 
         + json.FANUC.RPC[0].status);
      }
    }
    else {
      rpcmc_rprintf("[form] unexpected reply " + JSON.stringify(json));
    }
  });
}

/*
 * Tell the web server that the named item has been selected in the named
 * select element.
 */
function selectOnFocus(element) {
  oldIndex = element.selectedIndex;
  return false;
}
function selectOnBlur(element) {
  oldIndex = null;
  return false;
}
function select_onchange(element) {
  if (g_echo) {
    if (undefined != oldIndex) {
      element.selectedIndex = oldIndex;
      return;
    }
  }
  if (!element) element = this;
  // Use the parent div for the name since this contains the item number
  var id_name = $(element).parents('div').attr('id');
  $.getJSON("/COMET/rpc?func=SET_FORM" +
      "&task_id=" + g_task_id +
      "&id=" + id_name + 
      "&value=" + element.options[element.selectedIndex].value, function(json) {
    if (undefined != json.FANUC.RPC) {
      if (json.FANUC.RPC[0].status != 0) {
        rpcmc_rprintf("[rpcmc] SET_FORM " + request_code + " failed, status " 
         + json.FANUC.RPC[0].status);
      }
    }
    else {
      rpcmc_rprintf("[form] unexpected reply " + JSON.stringify(json));
    }
  });
}

/*
 * Tell the web server that the named button has been clicked.
 */
function button_onclick(element) {
  if (g_echo) {
    return;
  }
  if (!element) element = this;
  // Use the parent div for the name since this contains the item number
  var id_name = $(element).parents('div').attr('id');
  element.blur(); // Remove annoying black border
  $.getJSON("/COMET/rpc?func=SET_FORM" +
      "&task_id=" + g_task_id +
      "&id=" + id_name + 
      "&value=" + element.value, function(json) {
    if (undefined != json.FANUC.RPC) {
      if (json.FANUC.RPC[0].status != 0) {
        rpcmc_rprintf("[rpcmc] SET_FORM " + request_code + " failed, status " 
         + json.FANUC.RPC[0].status);
      }
    }
    else {
      rpcmc_rprintf("[form] unexpected reply " + JSON.stringify(json));
    }
  });
}

/*
 * Tell the web server that the named checkbox has been clicked.
 */
function checkBoxOnClick(element) {
  if (!element) element = this;
  if (g_echo) {
    if (element.checked) {
      element.checked = 0;
    }
    else {
      element.checked = 1;
    }
    return;
  }
  var value = 0;
  if (element.checked) {
    if (element.value == "1") { // inverted checkbox
      value = 0;
    }
    else {
      value = 1;
    }
  }
  else {
    if (element.value == "1") { // inverted checkbox
      value = 1;
    }
    else {
      value = 0;
    }
  }

  // Use the parent div for the name since this contains the item number
  var id_name = $(element).parents('div').attr('id');
  $.getJSON("/COMET/rpc?func=SET_FORM" +
      "&task_id=" + g_task_id +
      "&id=" + id_name + 
      "&value=" + value, function(json) {
    if (undefined != json.FANUC.RPC) {
      if (json.FANUC.RPC[0].status != 0) {
        rpcmc_rprintf("[rpcmc] SET_FORM " + request_code + " failed, status " 
         + json.FANUC.RPC[0].status);
      }
    }
    else {
      rpcmc_rprintf("[form] unexpected reply " + JSON.stringify(json));
    }
  });
}


/*
 * Tell the web server that the text has been changed.
 * If the key pressed is 13 (carriage return) and the text has changed, tell 
 * the web server that the named text element has the given new value.
 */

function textOnChange(element, validate, lowerLimit, upperLimit) {
  if (g_echo) {
    // Restore oldText
    if (undefined != oldText) {
      element.value = oldText;
    }
    return;
  }
  var valid = true;
  if (validate) {
    valid = validate(element.value, lowerLimit, upperLimit);
  }
  if (valid === true) {
    // Use the parent div for the name since this contains the item number
    var id_name = $(element).parents('div').attr('id');
    var value = encodeURIComponentShift_jis(element.value);
    $.getJSON("/COMET/rpc?func=SET_FORM" +
        "&task_id=" + g_task_id +
        "&id=" + id_name + 
        "&value=" + value, function(json) {
      if (undefined != json.FANUC.RPC) {
        if (json.FANUC.RPC[0].status != 0) {
          rpcmc_rprintf("[rpcmc] SET_FORM " + request_code + " failed, status " 
           + json.FANUC.RPC[0].status);
        }
      }
      else {
        rpcmc_rprintf("[form] unexpected reply " + JSON.stringify(json));
      }
    });
  }
  else if (typeof valid === "string") {
    element.value = oldText;
    alert(valid);
  }
}

function textOnFocus(element) {
  function selectText() {
    if (selectedTextBox !== null) {
      selectedTextBox.select();
    }
  }
  selectedTextBox = element;
  oldText = element.value;
  selectText();

  return false;
}

function textOnBlur(element, validate, lowerLimit, upperLimit) {
  if (element === selectedTextBox &&
      element.value !== oldText) {
    textOnChange(element, validate, lowerLimit, upperLimit);
  }
  element.value = element.value; // Make sure text is not highlighted
  oldText = null;
  selectedTextBox = null;

  return false;
}

function textOnKeypress(element, key, validate, filter, lowerLimit, upperLimit) {
  var invalid = false;

  switch (key) {
  case 13: // enter key
    if (element.value === oldText) {
      element.select(); // Reselect unmodified text
    }
    else {
      textOnChange(element, validate, lowerLimit, upperLimit);
    }
    break;

  default:
    if (filter) return filter(key, element.value, lowerLimit, upperLimit);
    else        return true;
  }
  return false;
}

var numDecimal = 3, decimalComma = false;
Number.prototype.format = function() {
  var text;
  if (isNaN(this)) return "";
  text = this.toFixed(numDecimal);
  if (decimalComma) {
    text = text.replace(/\./, ",");
  }
  return text;
};

function parseReal(text) {
  var num;
  text = text.replace(/,/, ".");
  num = parseFloat(text);
  return num;
}

function filter_int(keyCode, lowerLimit, upperLimit) {
  var text = String.fromCharCode(keyCode);
  var regexp;
  var option = "";
  if (lowerLimit < 0) option += "-";
  regexp = new RegExp("[\\d" + option + "]");
  return regexp.test(text);
}

function validate_int(text, lowerLimit, upperLimit) {
  var value = parseInt(text, 10);
  if (lowerLimit <= value && value <= upperLimit) {
    return true;
  }
  else {
    return value + " is out of range (" + lowerLimit + "-"+ upperLimit + ")";
  }
}

function filter_real(keyCode, lowerLimit, upperLimit) {
  var text = String.fromCharCode(keyCode);
  var regexp;
  var option = "";
  if (lowerLimit < 0) option += "-";
  option += decimalComma ? "," : "\\.";
  regexp = new RegExp("[\\d" + option + "]");
  return regexp.test(text);
}

function validate_real(text, lowerLimit, upperLimit) {
  var value = parseReal(text);
  if (lowerLimit <= value && value <= upperLimit) {
    return true;
  }
  else {
    return text + " is out of range (" + lowerLimit.format() + "-"+ upperLimit.format() + ")";
  }
}

/*
 * Call encodeURIComponent only for characters in the string that are <= 127 to
 * avoid garbling the shift_jis characters.
 */
function encodeURIComponentShift_jis(string) {
  var index;
  var newString = "";

  for (index = 0; index < string.length; index++) {
    if (string.charCodeAt(index) > 127) {
      newString += string.charAt(index); // Can't encode shift-jis character
    }
    else {
      newString += encodeURIComponent(string.charAt(index));
    }
  }
  return newString;
}

