// events.js - When cgtpmain does not exist, use this to get controller events

// Safari's iPad/iPhone does not support multiple threads
var _nowait = 0;
//if (navigator.userAgent.indexOf("Safari") >= 0) {
//  _nowait = 1;
//}

$.ajaxSetup({
  // Disable caching of AJAX responses */ 
  cache: false
});

var g_connect_id = -1;

// Try to find global connect_id
function GetConnectId() {
  if (g_connect_id == -1) {
    g_connect_id = 0;
    if (typeof (top.g_connect_id) != 'undefined') {
      g_connect_id = top.g_connect_id;
    }
    else if (typeof (top.opener) != 'undefined') {
      if (top.opener) {
        if (typeof (top.opener.top.g_connect_id) != 'undefined') {
          g_connect_id = top.opener.top.g_connect_id;
        }
      }
    }
    if (typeof (g_connect_id) == 'undefined') {
      g_connect_id = 0;
    }
  }
}

// Ask COMET for events.
function startEvents() {
  // Handle ajax errors
  jQuery(document).ajaxError(function(event, request, settings, exception) {
    if (request.status == 204) {
      // No content
    }
    else if (request.status == 12152) {
      // Connection Closed by Server?
    }
    else if (exception) {
      top.rpcmc_rprintf('[events.js] exception: ' + exception + ' setting: ' + settings.url);
    }
    else {
      top.rpcmc_rprintf('[events.js] status: ' + request.status + ' setting: ' + settings.url);
    }
    getnextevent();
  });

  // Restart events from the robot.
  restartEvents();

} // startEvents

// Ask COMET to stop events.
function restartEvents() {
  // Clear the old events from the robot
  GetConnectId();
  $.getJSON('/COMET/rpc?func=PMON_CAN_PKT&connect_id=' + g_connect_id, function(json) {

    // Now start events
    getnextevent();
  });

} // stopEvents

// Ask COMET for the next event.
function getnextevent() {
  GetConnectId();
  $.getJSON("/COMET/rpc?func=PMON_GET_PKT&connect_id=" + g_connect_id + "&nowait=" + _nowait, function(json) {
    //alert("[EVENT] " + JSON.stringify(json));
    try {
      if (undefined != json.FANUC.PMEV) {
        for (var idx = 0; idx < json.FANUC.PMEV.length; idx++) {
          switch (parseInt(json.FANUC.PMEV[idx].subsys_code)) {
          case SSC_PMON:
            switch (parseInt(json.FANUC.PMEV[idx].pmev_type)) {
            case PMEV_IO_C:
              // Trigger an IOBooleanEvent on the io event listeners. 
              top.jQuery.iolis.trigger("IOBooleanEvent", [
                json.FANUC.PMEV[idx].type,
                json.FANUC.PMEV[idx].index,
                json.FANUC.PMEV[idx].value]);
              break;
            case PMEV_SAFE_IO_C:
              // Trigger an SafetyIOEvent on the io event listeners. 
              top.jQuery.iolis.trigger("SafetyIOEvent", [
                json.FANUC.PMEV[idx].type,
                json.FANUC.PMEV[idx].index,
                json.FANUC.PMEV[idx].value]);
              break;
            case PMEV_IO_MGTH_C:
              // Trigger an HandleIOEvent on the io event listeners. 
              top.jQuery.iolis.trigger("HandleIOEvent", [
                json.FANUC.PMEV[idx].type,
                json.FANUC.PMEV[idx].index,
                json.FANUC.PMEV[idx].value,
                json.FANUC.PMEV[idx].jpos1,
              json.FANUC.PMEV[idx].pos1]);
              break;
            case PMEV_VAR_C:
              // Trigger a VarEvent on the var event listeners.  
              top.jQuery.varlis.trigger("VarEvent", [
                json.FANUC.PMEV[idx].prog_name,
                json.FANUC.PMEV[idx].var_name,
                json.FANUC.PMEV[idx].type_code,
                json.FANUC.PMEV[idx].value]);
              break;
            } // switch(pmev_type)
            break;
          } // switch(subsys_code)
        } // for each event
      } // if PMEV
    } catch (err) { /* nop */ };

    getnextevent();
  });
} // getnextevent

if (window.top === window.self) {
  // global object to hold event listeners
  jQuery.iolis = jQuery({});
  jQuery.varlis = jQuery({});

  // Start events from the robot
  startEvents();
}
