/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *
 *           All Rights Reserved
 *           Copyright (C)   2016
 *           FANUC Robotics America
 *           FANUC LTD Japan
 *
 *  +
 *  Module: draw3d.js
 *
 *  Description:
 *    Draw3d plugin
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *
 *  Modification history:
 *  15-APR-2015 EVANSJA Initial version
 *  29-JUN-2016 EVANSJA All functions require unique names
 *  05-JAN-2017 EVANSJA Remove the "Under construction" XML
 *  18-Aug-2017  Krause   WebGL pr50347 Attach to actual webgl objects !  Automode
 *  18-SEP-2017 EVANSJA pr50432 - Move common javascript to util.js
 *  26-Sep-2017  Krause   WebGL pr50402 detect capability, use GL init commands
 *  15-FEB-2018 EVANSJA  pr50687b - Support for draw3d on dialog boxes.
 *  26-Mar-2018  Krause   WebGL pr50817 make mouse events work
 *  26-Mar-2018  Krause   WebGL pr50817c resize events from framework
 *  26-May-2019  Krause   pr51560 Multi-connection
 *  28-Jun-2019  Krause   Fpr51560 fix touch events
 *  -
*/
// tpglpkt.h
var TPGL_INITDRAW_FC = 2;
var TPGL_DELTADRAW_FC = 3;
var TPGL_INTERACT_FC = 4;
var TPGL_EXIT_FC = 5;
var TPGL_SELECT_FC = 6;
var TPGL_FINISHED_FC = 7;
var TPGL_OCXEXIT_FC = 8;
var TPGL_INITECHO_FC = 9;
var TPGL_REINITDRAW_FC = 10;
var TPGL_STATICDATA_FC = 11;
var TPGL_DISCONNECT_FC = 12;
var TPGL_KARELREQ_FC = 14;
var TPGL_KARELCAN_FC = 15;
var TPGL_TOGGLESCENE_FC = 16;
var TPGL_SOFTKEY_FC = 17;
var TPGL_ENDEDIT_FC = 18;
var TPGL_DISCOECHO_FC = 19;
var TPGL_4DMENU_FC = 20;

var TPGL_4DMENU_SEL_FC = 26;
var TPGL_INITWGLDRAW_FC = 27;    /* TPGL_INITDRAW_FC but initiated from WebGL */
var TPGL_INITWGLECHO_FC = 28;    /* TPGL_INITECHO_FC but initiated from WebGL */

var SV3D = 1398158149;  // 'SV3D'

// Private functions
// Create control only when PMON Server is ready
function draw3d_ServerReady(data) {
  // Initialize control data.
  draw3d_InitCtlData(data);

  // Create control.
  //draw3d_CreateCtl(data);

  // Initialize events.
  draw3d_InitRobotEvent(true, data);

  // Create GLWorld
  //GLWorld_new(data);
  // Need the name of the primary pipe to create the scene
  var canvas = new FRCCanvas(top.g_webgl);
  var connect = FRCCanvas.GetConnect(data.Pipe, document.URL);
  var scene = FRCCanvas.GetScene(data.Pipe);  // This will create the scene if it doesn't exist yet
  connect.ctrl_data = data;
  scene.ctrl_data = data;
  scene.standalone = false;
  connect.standalone = false;
  connect.standalone = false;
  connect.logged_in = true;

 // scene.showFPS = true;
  data.glscene = scene;
  data.glconnect= connect;

  scene.Initialize();
  var canvasid = data.Pipe.substring(0, data.Pipe.length - 4);

  var test = document.getElementById(canvasid);

  canvasid = '#' + canvasid;

 // var test = document.getElementById(GLCANVAS)
  $(canvasid).bind("mousedown", data, draw3d_HandleMouseDownEvent);
  $(canvasid).bind("mouseup", data, draw3d_HandleMouseUpEvent);
  $(canvasid).bind("mousemove", data, draw3d_HandleMouseMoveEvent);
  $(canvasid).bind("click", data, draw3d_HandleClickEvent);
  $(canvasid).bind("dblclick", data, draw3d_HandleDblClickEvent);
  $(canvasid).bind("focusin", data, draw3d_HandleFocusEvent);

  $(canvasid).bind('touchstart', data, draw3d_HandleTouchStartEvent);
  $(canvasid).bind('touchend', data, draw3d_HandleTouchEndEvent);
  $(canvasid).bind('touchmove', data, draw3d_HandleTouchMoveEvent);

  $(window).resize(function () {
      FRCCanvas.ResizeWindow();
   });

  // Send packet to init draw
  var pkt_id;
  if (data.IsEcho) {
    pkt_id = TPGL_INITWGLECHO_FC;
    scene.EchoMode();
  }
  else {
      pkt_id = TPGL_INITWGLDRAW_FC;
  }
  top.rpcmc_ossndpkt_ext3d(PKT_TYP7, 0, SSC_TPGL, pkt_id, TID_SV3D, SV3D, top.g_version, data.fTaskIdx, data.SubPane, data.Scene);

} // draw3d_ServerReady

function WebGLDetector() {

    try {
        var canvas = document.createElement('canvas'); return !!(window.WebGLRenderingContext && (canvas.getContext('webgl') || canvas.getContext('experimental-webgl')));
    } catch (e) {
        return false;
    }
}
// New instance of control.
function draw3d_NPP_New(data) {
  if (!WebGLDetector()) {
    window.location.href = "/frh/diageg/TPIF.htm#TPIF-266";
  }

  SetCommonParams(data);
  if (data.IsDialog) {
    draw3d_ServerReady(data);
  }
  else {
    top.rpcmc_getTaskIdx(data.fDeviceId, function(taskIdx) {
      data.fTaskIdx = taskIdx;

      // Complete after top.rpcmc_getTaskIdx completes.
      draw3d_ServerReady(data);
    });
  }

} // draw3d_NPP_New

// Destroy instance of control.
function draw3d_NPP_Destroy(data) {

  // Uninitialize events.
  draw3d_InitRobotEvent(false, data);

  // Delete control.
  draw3d_DeleteCtl(data);

} // draw3d_NPP_Destroy

// Private functions

// Set the border.
function draw3d_SetBorder(data) {

  var border = parseInt(data.Border);
  if (border > 0) {
    data.$this.css({"border-style":"inset", "border-width":"' + border + 'px", "border-color":"white"});
  }
  else if (border < 0) {
    border *= -1;
    data.$this.css({"border-style":"inset", "border-width":"' + border + 'px", "border-color":"white"});
  }
  else {
    data.$this.css("border-style", "none");
  }

} // draw3d_SetBorder

// Update Control.
function draw3d_UpdateCtl(data) {


} // draw3d_UpdateCtl

function draw3d_SendPkt(fc, data, optional) {
    top.rpcmc_ossndpkt_ext3d(PKT_TYP7, 0, SSC_TPGL, fc, TID_SV3D, SV3D, top.g_version, data.fTaskIdx, data.SubPane, data.Scene, optional);
} // draw3d_UpdateCtl

// Initialize or uninitialize pipe event.
function draw3d_InitPipeEvent(init, data) {

  // Notify PMON to start/stop monitoring our pipe
  if (init) {
    top.jQuery.filelis.bind('PipeEvent', data, draw3d_HandlePipeEvent); // Attach handler for PipeEvent
    top.rpcmc_startPipeMonitor(data.Pipe, NOT_A_SHORT); // Start PMON monitor for our pipe
  }
  else {
    top.rpcmc_stopPipeMonitor(data.Pipe); // Stop PMON monitor for our pipe
    top.jQuery.filelis.unbind('PipeEvent', draw3d_HandlePipeEvent); // Detach handler for PipeEvent.
  }
} // draw3d_InitPipeEvent

// Replace any indirection with actual value.
function draw3d_IndirectReplace(data) {

  var l_ind;
  var pos;

 $.each(data, function( argn, argv ) {
    if (typeof argv !== 'string') {
      return;
    }
    // Value contain !PaneId?
    if ((pos = argv.toLowerCase().indexOf("!paneid")) >= 0) {
      argv = argv.substring(0, pos) + data.fTaskIdx + argv.substring(pos+7);
      data[argn] = argv;
    }
  });
} // draw3d_IndirectReplace

// Initialize Control Data.
function draw3d_InitCtlData(data) {

  // Process parameters.
  // Name not supported
  // Border
  // Pipe
  // Scene
  // SubPane
  // Verbose not supported
  // ExecConnectId not required (only for ActiveX Controls)

  data.Pipe = data.Pipe.toUpperCase();
  draw3d_IndirectReplace(data);

  data.SubPane = parseInt(data.SubPane);

  // Need the name of the primary pipe to create the scene
  //scene = new FRCScene(true, data.Pipe);

  if (data.BackColor == "") {
    data.BackColor = data.InvisibleColor;
  }
  else {
    data.BackColor = translateColor(data.BackColor);
  }
  if (data.ForeColor == "") {
    data.ForeColor = data.TextColor;
  }
  else {
    data.ForeColor = translateColor(data.ForeColor);
  }

} // draw3d_InitCtlData

// Initialize or uninitialize events for each type.
function draw3d_InitRobotEvent(init, data) {
  // Start/stop the Pipe Event.
  draw3d_InitPipeEvent(init, data);

} // draw3d_InitRobotEvent

// Create Control.
function draw3d_CreateCtl(data) {

  var out = '<div id="' + data.Id + '">Loading</div>';
  data.$this.html(out);

  data.$this.css("display", "inline-block");
  if (data.width.indexOf("%") >= 0) {
    data.$this.css("width", data.width);
  }
  else {
    data.$this.css("width", data.width + "px");
  }
  if (data.height.indexOf("%") >= 0) {
    data.$this.css("height", data.height);
  }
  else {
    data.$this.css("height", data.height + "px");
  }
  data.$this.css("vertical-align", "top");
  draw3d_SetBorder(data);
  SetColors(data);
  SetFont(data);

  // Attach handler for mousedown event.
  data.$this.bind("mousedown", data, draw3d_HandleMouseDownEvent);

  // Attach handler for mouseup event.
  data.$this.bind("mouseup", data, draw3d_HandleMouseUpEvent);

  // Attach handler for mouseout event.
  data.$this.bind("mouseout", data, draw3d_HandleMouseUpEvent);

} // draw3d_CreateCtl

// Handle Control events.
function draw3d_CtlEvent(data) {

  var sb_state;

  if (data.IsEcho) {
    return;
  }
  if (data.dlgDismiss == "1") {
    // Dismiss dialog box.
    top.rpcmc_sendKeyCode(tk_cancel_c);
  }

} // draw3d_CtlEvent

// Delete Control Data.
function draw3d_DeleteCtl(data) {
    // Web page is exiting cannot do normal send
    //top.rpcmc_ossndpkt_ext3d(PKT_TYP7, 0, SSC_TPGL, TPGL_OCXEXIT_FC, TID_SV3D, SV3D, top.g_version,
    //    data.fTaskIdx, data.SubPane, data.Scene);

    // OCX_EXIT functionality is handled in PMON when the pipe monitor is closed
} // draw3d_DeleteCtl

// Private functions
function draw3d_HandlePipeEvent(event, file, buffer) {
  event.preventDefault();
  var data = event.data || event;
  if (file == data.Pipe) {
    if (buffer.length > 0) {
      var buffer2 = buffer;
      //data.$this.html('<xmp>' + buffer2 + '</xmp>');
      FRCCanvas.XMLPipe(data.glconnect, buffer2);
//      scene.XMLPipe(data.Pipe, buffer2);
    }
    if (!data.IsEcho) {
      var scene = FRCCanvas.GetScene(data.Pipe);
      var view = "&view=" + scene.View();
      if (buffer.substr(buffer.length - 7, 6) == "<EOF/>") {
        setTimeout(() => {
          top.rpcmc_ossndpkt_ext3d(PKT_TYP7, 0, SSC_TPGL, TPGL_DELTADRAW_FC, TID_SV3D, SV3D, top.g_version, data.fTaskIdx, data.SubPane, data.Scene, view);
        }, 300);
      }
    }
  }
  return true;
} // draw3d_HandlePipeEvent

function draw3d_getXmlAsString(xmlDom){
  return (typeof XMLSerializer!=="undefined") ?
         (new window.XMLSerializer()).serializeToString(xmlDom) :
          xmlDom.xml;
} // draw3d_getXmlAsString

function draw3d_HandleMouseDownEvent(event) {
  event.preventDefault();
  var data = event.data || event;
  data.glscene.onMouseDown(event.clientX, event.clientY, event.button);
  return true;
} // draw3d_HandleMouseDownEvent

function draw3d_HandleMouseUpEvent(event) {
  event.preventDefault();
  var data = event.data || event;
  data.glscene.onMouseUp(event.clientX, event.clientY, event.button);
  return true;
} // draw3d_HandleMouseUpEvent

function draw3d_HandleMouseMoveEvent(event) {
  event.preventDefault();
  var data = event.data || event;
  data.glscene.onMouseMove(event.clientX, event.clientY, event.button);
  return true;
} // draw3d_HandleMouseMoveEvent

function draw3d_HandleClickEvent(event) {
    event.preventDefault();
    var data = event.data || event;
    draw3d_CtlEvent(data);
    data.glscene.onClick(event);
    return true;
} // draw3d_HandleClickEvent

function draw3d_HandleDblClickEvent(event) {
    event.preventDefault();
    var data = event.data || event;
    data.glscene.onDblClick(event);
    return true;
} // draw3d_HandleDblClickEvent

//$(canvasid).bind('touchstart', draw3d_HandleTouchStartEvent, false);
//$(canvasid).bind('touchend', draw3d_HandleTouchEndEvent, false);
//$(canvasid).bind('touchmove', draw3d_HandleTouchMoveEvent, false);
// Touch events
function draw3d_HandleTouchStartEvent(event) {
  event.preventDefault();
  var data = event.data || event;
  draw3d_CtlEvent(data);
  var oevent = event.originalEvent;
  data.glscene.onMouseDown(oevent.touches[0].pageX, oevent.touches[0].pageY, oevent.touches.length - 1);
  return true;
} // draw3d_HandleTouchStartEvent

function draw3d_HandleTouchEndEvent(event) {
  event.preventDefault();
    var data = event.data || event;
    var oevent = event.originalEvent;

    draw3d_CtlEvent(data);
    data.glscene.onMouseUp(oevent.changedTouches[0].clientX, oevent.changedTouches[0].clientY, 0);
  return true;
} // draw3d_HandleTouchEndEvent

function draw3d_HandleTouchMoveEvent(event) {
  event.preventDefault();
  var data = event.data || event;
  draw3d_CtlEvent(data);
  var oevent = event.originalEvent;
  data.glscene.onMouseMove(oevent.touches[0].pageX, oevent.touches[0].pageY, oevent.touches.length - 1);
  return true;
} // draw3d_HandleTouchMoveEvent

// Don't think this ever triggers, never say never
function draw3d_HandleFocusEvent(event) {
    // This event never triggers
    event.preventDefault();
    var data = event.data || event;
    data.glscene.onFocus(event);
    return true;
} // draw3d_HandleFocusEvent
