var type_data, serial_data, select_cam_data, select_lense_data, select_imgSize_data, board_data;
var cam_list_data, lense_list_data;
var calcurate_data = { "cam": {}, "lense": {} };
var selectCamTable = null;
var selectLenTable = null;
var INIT_CUSTOM_FOCAL = 6;

function typeDataDef() {
  var json_data = {
    "cam_bw_sc130ef2": "Monochrome camera (SC130EF2 B/W)",
    "cam_color_sc130ef2c": "Color camera (SC130EF2C)",
    "cam_usb_aca640_20": "Basler USB camera (acA640-20um/120um)",
    "cam_usb_aca640_750": "Basler USB camera (acA640-750umFNC)",
    "cam_bw_sc130e": "Kowa digital camera(SC130E B/W)",
    "cam_digital_bw": "New model monochrome digital camera",
    "cam_dig_sc130e": "New model color digital camera (SC130E COLOR)",
    "cam_digital_color": "New model color digital camera",
    "cam_old_dig_sc130c": "Kowa digital camera(SC130C) Old model",
    "cam_old_bw": "Old model monochrome digital camera",
    "cam_old_dig_sc310m": "Kowa digital camera(SC310M) Old model",
    "cam_old_color": "Old model color digital camera",
    "cam_analog_xc56": "Analog camera(XC-56)",
    "cam_analog_xchr50": "Analog camera(XC-HR50))",
    "cam_standard_xc56": "Standard camera(XC-56)",
    "cam_speed_xchr50": "Double speed camera(XC-HR50)",
    "cam_speed_xchr56": "Double speed camera(XC-HR56)",
    "cam_h_reso_sc130c": "High resolution camera(SC130C)",
    "cam_hight_resolution": "High resolution camera",
    "cam_color_sc310m": "Color camera(SC310M)",
    "cam_color": "Color camera",
    "cam_no_shrinking_1280_1024": "No image shrinking (1280&times;1024)",
    "cam_shrinking_640_480": "Image shrinking 1/2 (640&times;480)",
    "cam_shrinking_426_341": "Image shrinking 1/3 (426&times;341)",
    "cam_shrinking_320_240": "Image shrinking 1/4 (320&times;240)",
    "cam_vga_640_512": "1/2&quot; VGA (640&times;512)",
    "cam_1_8_qvga_320_240": "1/8&quot; QVGA (320&times;240)",
    "cam_1_4_qvga_320_240": "1/4&quot; QVGA (320&times;240)",
    "cam_1_4_vga_640_480": "1/4&quot; VGA (640&times;480)",
    "cam_1_2_vga_640_480": "1/2&quot; VGA (640&times;480)",
    "cam_1_3_xga_1024_768": "1/3&quot; XGA (1024&times;768)",
    "cam_1_2_sxga_1280_1024": "1/2&quot; SXGA (1280&times;1024)",
    "cam_vga_1280_480": "VGA_WIDE (1280&times;480)",
    "cam_1_6_qvga_320_240": "1/6&quot; QVGA (320&times;240)",
    "cam_1_3_qvga_320_240": "1/3&quot; QVGA (320&times;240)",
    "cam_1_3_vga_640_480": "1/3&quot; VGA (640&times;480)",
    "cam_vga_tall_640_960": "VGA_TALL (640&times;960)",
    "cam_2_3_vga_640_480": "2/3&quot; VGA (640&times;480)",
    "cam_1_2_xga_1024_768": "1/2&quot; XGA (1024&times;768)",
    "cam_2_3_sxga_1280_1024": "2/3&quot; SXGA (1280&times;1024)",
    "cam_qvga_320_240": "QVGA (320&times;240)",
    "cam_vga_640_480": "VGA (640&times;480)",
    "cam_qvga_256_240": "QVGA (256&times;240)",
    "us_word_use": "Use",
    "us_word_nouse": "Nonuse",
    "cam_vga_512_480": "VGA (512&times;480)",
    "cam_ac640_640_480": "640&times;480",
    "cam_ac640_320_240": "320&times;240",
    "cam_1024_960": "1024&times;960",
    "cam_1280_960": "1280&times;960"
  };
  return json_data;
}

function serialDataDef() {
  var json = {
    "cam_bw_sc130ef2": "SC130EF2_B/W",
    "cam_color_sc130ef2c": "SC130EF2C",
    "cam_usb_aca640_20": "acA640-20um/120um",
    "cam_usb_aca640_750": "acA640-750umFNC",
    "cam_bw_sc130e": "SC130E_B/W",
    "cam_dig_sc130e": "SC130E_COLOR",
    "cam_old_dig_sc130c": "SC130C",
    "cam_old_dig_sc310m": "SC310M",
    "cam_analog_xc56": "XC-56",
    "cam_analog_xchr50": "XC-HR50",
    "cam_standard_xc56": "XC-56",
    "cam_speed_xchr50": "XC-HR50",
    "cam_h_reso_sc130c": "SC130C",
    "cam_color_sc310m": "SC310M"
  };
  return json;
}

function selectCamDataDef() {
  var r30ib_plus = [
    [type_data["cam_bw_sc130ef2"], serial_data["cam_bw_sc130ef2"]],
    [type_data["cam_color_sc130ef2c"], serial_data["cam_color_sc130ef2c"]],
    [type_data["cam_usb_aca640_20"], serial_data["cam_usb_aca640_20"]],
    [type_data["cam_usb_aca640_750"], serial_data["cam_usb_aca640_750"]]
  ];
  var r30ib = [
    [type_data["cam_bw_sc130e"], serial_data["cam_bw_sc130e"]],
    [type_data["cam_dig_sc130e"], serial_data["cam_dig_sc130e"]],
    [type_data["cam_old_dig_sc130c"], serial_data["cam_old_dig_sc130c"]],
    [type_data["cam_old_dig_sc310m"], serial_data["cam_old_dig_sc310m"]],
    [type_data["cam_analog_xc56"], serial_data["cam_analog_xc56"]],
    [type_data["cam_analog_xchr50"], serial_data["cam_analog_xchr50"]],
    [type_data["cam_usb_aca640_20"], serial_data["cam_usb_aca640_20"]],
    [type_data["cam_usb_aca640_750"], serial_data["cam_usb_aca640_750"]]
  ];
  var r30ia = [
    [type_data["cam_standard_xc56"], serial_data["cam_standard_xc56"]],
    [type_data["cam_h_reso_sc130c"], serial_data["cam_h_reso_sc130c"]],
    [type_data["cam_color_sc310m"], serial_data["cam_color_sc310m"]]
  ];
  var r30ia_b = [
    [type_data["cam_standard_xc56"], serial_data["cam_standard_xc56"]],
    [type_data["cam_speed_xchr50"], serial_data["cam_speed_xchr50"]],
    [type_data["cam_h_reso_sc130c"], serial_data["cam_h_reso_sc130c"]],
    [type_data["cam_color_sc310m"], serial_data["cam_color_sc310m"]]
  ];
  var json = {
    "R-30iA": r30ia,
    "R-30iA_b": r30ia_b,
    "R-30iB": r30ib,
    "R-30iB Plus": r30ib_plus
  };
  return json;
}

function selectLenseDef() {
  var array = [
    ["8mm lens", "lense_8mm"],
    ["12mm lens", "lense_12mm"],
    ["16mm lens", "lense_16mm"],
    ["25mm lens", "lense_25mm"],
    ["Kowa MegaPixel 3.5mm lens", "mpix_3_5"],
    ["Kowa MegaPixel 5mm lens", "mpix_5"],
    ["Kowa MegaPixel 6mm lens", "mpix_6"],
    ["Kowa MegaPixel 8mm lens", "mpix_8"],
    ["Kowa MegaPixel 12mm lens", "mpix_12"],
    ["Kowa MegaPixel 16mm lens", "mpix_16"],
    ["Kowa MegaPixel 25mm lens", "mpix_25"],
    ["Kowa MegaPixel 35mm lens", "mpix_35"],
    ["Kowa MegaPixel 50mm lens", "mpix_50"],
    ["Kowa MegaPixel 75mm lens", "mpix_75"],
    ["Kowa MegaPixel 100mm lens", "mpix_100"],
    ["Custom", "customize"]
  ];
  return array;
}

function calculateCamDataDef() {
  var json = {
    "R-30iB Plus": {
      "SC130EF2_B/W": {
        "noreduction": [5.3 * 1, 1280 / 1, 1024 / 1, 1 / 2],  // [cellSize(um),width(px),height(px),image sensor(in,)]
        "r_1_2":       [5.3 * 2, 1280 / 2, 1024 / 2, 1 / 2],
        "r_1_3":       [5.3 * 3, 1280 / 3, 1024 / 3, 1 / 2],
        "r_1_4":       [5.3 * 4, 1280 / 4, 1024 / 4, 1 / 2]
      },
      "SC130EF2C": {
        "vga640_512": [10.6 * 1, 640 / 1, 512 / 1, 1 / 2]
      },
      "acA640-20um/120um": {
        "640_480": [5.6 * 1, 640 / 1, 480 / 1, 1 / 4],
        "320_240": [5.6 * 2, 640 / 2, 480 / 2, 1 / 4]
      },
      "acA640-750umFNC": {
        "640_480": [4.8 * 1, 640 / 1, 480 / 1, 1 / 4],
        "320_240": [4.8 * 2, 640 / 2, 480 / 2, 1 / 4]
      }
    },
    "R-30iB": {
      "SC130E_B/W": {
        "1_8_qvga": [5.3,  320,  240,  1 / 2],
        "1_4_qvga": [10.6, 320,  240,  1 / 2],
        "1_4_vga":  [5.3,  640,  480,  1 / 2],
        "1_2_vga":  [10.6, 640,  480,  1 / 2],
        "1_3_xga":  [5.3,  1024, 768,  1 / 2],
        "1_2_sxga": [5.3,  1280, 1024, 1 / 2],
        "vga_wide": [5.3,  1280, 480,  1 / 2],
        "vga_tall": [5.3,  640,  960,  1 / 2]
      },
      "SC130E_COLOR": {
        "1_4_qvga": [10.6, 320, 240, 1 / 2],
        "1_2_vga":  [10.6, 640, 480, 1 / 2]
      },
      "SC130C": {
        "1_6_qvga": [6.7,  320,  240,  2 / 3],
        "1_3_qvga": [13.4, 320,  240,  2 / 3],
        "1_3_vga":  [6.7,  640,  480,  2 / 3],
        "2_3_vga":  [13.4, 640,  480,  2 / 3],
        "1_2_xga":  [6.7,  1024, 768,  2 / 3],
        "2_3_sxga": [6.7,  1280, 1024, 2 / 3],
        "vga_wide": [6.7,  1280, 480,  2 / 3],
        "vga_tall": [6.7,  640,  960,  2 / 3]
      },
      "SC310M": {
        "1_6_qvga": [6.7, 320,  240, 1 / 2],
        "1_3_vga":  [6.7, 640,  480, 1 / 2],
        "1_2_xga":  [6.7, 1024, 768, 1 / 2]
      },
      "XC-56": {
        "640_480": [7.4, 640, 480, 1 / 3]
      },
      "XC-HR50": {
        "640_480": [7.4, 640, 480, 1 / 3]
      },
      "acA640-20um/120um": {
        "640_480": [5.6 * 1, 640 / 1, 480 / 1, 1 / 4],
        "320_240": [5.6 * 2, 640 / 2, 480 / 2, 1 / 4]
      },
      "acA640-750umFNC": {
        "640_480": [4.8 * 1, 640 / 1, 480 / 1, 1 / 4],
        "320_240": [4.8 * 2, 640 / 2, 480 / 2, 1 / 4]
      }
    },
    "R-30iA": {
      "XC-56": {
        "qvga": [14.8, 256, 240, 1 / 3],
        "vga": [7.4, 512, 480, 1 / 3],
        "1_3_qvga": [13.4, 320, 240, 1 / 3],
        "1_3_vga": [6.7, 640, 480, 1 / 3]
      },
      "XC-HR50": {
        "512_480": [7.4, 512, 480, 1 / 3],
        "640_480": [7.4, 640, 480, 1 / 3]
      },
      "SC130C": {
        "1024_960": [6.7, 1024, 960, 2 / 3],
        "1280_960": [6.7, 1280, 960, 2 / 3]
      },
      "SC310M": {
        "512_480": [6.4, 512, 480, 1 / 2],
        "640_480": [6.4, 640, 480, 1 / 2]
      }
    }
  };
  return json;
}
function calculateLenseDataDef() {
  var json = {
    "lense_8mm": [8, 260, 2 / 3],  // [focal length(mm),close range(mm),image sensor(in,)]
    "lense_12mm": [12, 260, 2 / 3],
    "lense_16mm": [16, 290, 2 / 3],
    "lense_25mm": [25, 210, 2 / 3],
    "mpix_3_5": [3.5, 100, 1 / 1.8],
    "mpix_5": [5, 150, 2 / 3],
    "mpix_6": [6, 100, 1 / 2],
    "mpix_8": [8, 120, 2 / 3],
    "mpix_12": [12, 150, 2 / 3],
    "mpix_16": [16, 200, 2 / 3],
    "mpix_25": [25, 200, 2 / 3],
    "mpix_35": [35, 200, 2 / 3],
    "mpix_50": [50, 200, 2 / 3],
    "mpix_75": [75, 1200, 2 / 3],
    "mpix_100": [100, 2000, 2 / 3]
  };
  return json;
}

function imageSizeListDef() {
  var r30ib_plus = {
    "SC130EF2_B/W": [
      [type_data["cam_no_shrinking_1280_1024"], "noreduction"],
      [type_data["cam_shrinking_640_480"], "r_1_2"],
      [type_data["cam_shrinking_426_341"], "r_1_3"],
      [type_data["cam_shrinking_320_240"], "r_1_4"]
    ],
    "SC130EF2C": [
      [type_data["cam_vga_640_512"], "vga640_512"]
    ],
    "acA640-20um/120um": [
      [type_data["cam_ac640_640_480"], "640_480"],
      [type_data["cam_ac640_320_240"], "320_240"]
    ],
    "acA640-750umFNC": [
      [type_data["cam_ac640_640_480"], "640_480"],
      [type_data["cam_ac640_320_240"], "320_240"]
    ]
  };
  var r30ib = {
    "SC130E_B/W": [
      [type_data["cam_1_8_qvga_320_240"], "1_8_qvga"],
      [type_data["cam_1_4_qvga_320_240"], "1_4_qvga"],
      [type_data["cam_1_4_vga_640_480"], "1_4_vga"],
      [type_data["cam_1_2_vga_640_480"], "1_2_vga"],
      [type_data["cam_1_3_xga_1024_768"], "1_3_xga"],
      [type_data["cam_1_2_sxga_1280_1024"], "1_2_sxga"],
      [type_data["cam_vga_1280_480"], "vga_wide"],
      [type_data["cam_vga_tall_640_960"], "vga_tall"]
    ],
    "SC130E_COLOR": [
      [type_data["cam_1_4_qvga_320_240"], "1_4_qvga"],
      [type_data["cam_1_2_vga_640_480"], "1_2_vga"]
    ],
    "SC130C": [
      [type_data["cam_1_6_qvga_320_240"], "1_6_qvga"],
      [type_data["cam_1_3_qvga_320_240"], "1_3_qvga"],
      [type_data["cam_1_3_vga_640_480"], "1_3_vga"],
      [type_data["cam_2_3_vga_640_480"], "2_3_vga"],
      [type_data["cam_1_2_xga_1024_768"], "1_2_xga"],
      [type_data["cam_2_3_sxga_1280_1024"], "2_3_sxga"],
      [type_data["cam_vga_1280_480"], "vga_wide"],
      [type_data["cam_vga_tall_640_960"], "vga_tall"]
    ],
    "SC310M": [
      [type_data["cam_1_6_qvga_320_240"], "1_6_qvga"],
      [type_data["cam_1_3_vga_640_480"], "1_3_vga"],
      [type_data["cam_1_2_xga_1024_768"], "1_2_xga"]
    ],
    "XC-56": [
      [type_data["cam_vga_640_480"], "640_480"]
    ],
    "XC-HR50": [
      [type_data["cam_vga_640_480"], "640_480"]
    ],
    "acA640-20um/120um": [
      [type_data["cam_ac640_640_480"], "640_480"],
      [type_data["cam_ac640_320_240"], "320_240"]
    ],
    "acA640-750umFNC": [
      [type_data["cam_ac640_640_480"], "640_480"],
      [type_data["cam_ac640_320_240"], "320_240"]
    ]
  };
  var r30ia = {
    "XC-56": [
      [type_data["cam_qvga_256_240"], "qvga"],
      [type_data["cam_vga_512_480"], "vga"]
    ],
    "XC-HR50": [
      [type_data["cam_vga_512_480"], "512_480"]
    ],
    "SC130C": [
      [type_data["cam_1024_960"], "1024_960"]
    ],
    "SC310M": [
      [type_data["cam_vga_512_480"], "512_480"]
    ]
  };
  var r30ia_b = {
    "XC-56": [
      [type_data["cam_qvga_320_240"], "1_3_qvga"],
      [type_data["cam_vga_640_480"], "1_3_vga"]
    ],
    "XC-HR50": [
      [type_data["cam_vga_640_480"], "640_480"]
    ],
    "SC130C": [
      [type_data["cam_1280_960"], "1280_960"]
    ],
    "SC310M": [
      [type_data["cam_vga_640_480"], "640_480"]
    ]
  };
  var json = {
    "R-30iA": r30ia,
    "R-30iA_b": r30ia_b,
    "R-30iB": r30ib,
    "R-30iB Plus": r30ib_plus
  };
  return json;
}

function visionBoardData() {
  var array = [
    [type_data["us_word_nouse"], "false"],
    [type_data["us_word_use"], "true"]
  ];
  return array;
}

function cameraTableDef() {
  var json = {
    "R-30iB Plus": [
      {
        "id": "SC130EF2_B/W",
        "title": "Monochrome digital camera that can be used with R-30iB Plus conroller.",
        "name": "SC130EF2 B/W",
        "img": "./images/sc130ef2bw.png",
        "pdf": "./images/sc130ef2_pdf.png",
        "num": "A05B-1426-K001",
        "ccd": "1/2&quot;",
        "cell": "5.3&micro;m",
        "weight": "50g",
        "resolution": "1280&times;1024 pixels",
        "note": ""
      },
      {
        "id": "SC130EF2C",
        "title": "Color digital camera that can be used with R-30iB Plus conroller.",
        "name": "SC130EF2C",
        "img": "./images/sc130ef2c.png",
        "pdf": "./images/sc130ef2_pdf.png",
        "num": "A05B-1426-K002",
        "ccd": "1/2&quot;",
        "cell": "10.6&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      },
      {
        "id": "acA640-20um/120um",
        "title": "USB camera that can be used with ROBOGUIDE.",
        "name": "acA640-20um/120um",
        "img": "./images/aca640.png",
        "pdf": "./images/aca640_pdf.png",
        "num": "A05B-1405-K551",
        "ccd": "1/4&quot;",
        "cell": "5.6&micro;m",
        "weight": "80g",
        "resolution": "640&times;480 pixels",
        "note": "acA640_120um is only usable with ROBOGUIDE"
      },
      {
        "id": "acA640-750umFNC",
        "title": "",
        "name": "acA640-750umFNC",
        "img": "./images/aca640.png",
        "pdf": "./images/aca640_750_pdf.png",
        "num": "A05B-1405-K555",
        "ccd": "1/4&quot;",
        "cell": "4.8&micro;m",
        "weight": "80g",
        "resolution": "640&times;480 pixels",
        "note": ""
      }
    ],
    "R-30iB": [
      {
        "id": "SC130E_B/W",
        "title": "Monochrome digital camera that can be used with R-30iB conroller.",
        "name": "SC130E B/W",
        "img": "./images/sc130ebw.png",
        "pdf": "./images/sc130ebw_pdf.png",
        "num": "A05B-1405-K533",
        "ccd": "1/2&quot;",
        "cell": "5.3&micro;m",
        "weight": "50g",
        "resolution": "1280&times;1024 pixels",
        "note": ""
      },
      {
        "id": "SC130E_COLOR",
        "title": "Color digital camera that can be used with R-30iB conroller.",
        "name": "SC130E COLOR",
        "img": "./images/sc130ecolor.png",
        "pdf": "./images/sc130ecolor_pdf.png",
        "num": "A05B-1405-K523",
        "ccd": "1/2&quot;",
        "cell": "5.3&micro;m",
        "weight": "50g",
        "resolution": "1280&times;1024 pixels",
        "note": ""
      },
      {
        "id": "SC130C",
        "title": "Monochrome digital camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "SC130C",
        "img": "./images/sc130ebw.png",
        "pdf": "./images/sc130ebw_pdf.png",
        "num": "A05B-1405-K532",
        "ccd": "2/3&quot;",
        "cell": "6.7&micro;m",
        "weight": "50g",
        "resolution": "1280&times;1024 pixels",
        "note": ""
      },
      {
        "id": "SC310M",
        "title": "Color digital camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "SC310M",
        "img": "./images/sc130ecolor.png",
        "pdf": "./images/sc130ecolor_pdf.png",
        "num": "A05B-1405-K521",
        "ccd": "1/2&quot;",
        "cell": "6.4&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      },
      {
        "id": "XC-56",
        "title": "Standard analog camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "XC-56",
        "img": "./images/xc_56.png",
        "pdf": "./images/xc_56_pdf.png",
        "num": "A05B-1405-K501",
        "ccd": "1/3&quot;",
        "cell": "7.4&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      },
      {
        "id": "XC-HR50",
        "title": "Double speed camera that can be used with both R-30iA/R-30iB controllers. Vision Board is required when using with R-30iA.",
        "name": "XC-HR50",
        "img": "./images/xc_hr50.png",
        "pdf": "./images/xc_hr50_pdf.png",
        "num": "A05B-1405-K502",
        "ccd": "1/3&quot;",
        "cell": "7.4&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      },
      {
        "id": "acA640-20um/120um",
        "title": "USB camera that can be used with ROBOGUIDE.",
        "name": "acA640-20um/120um",
        "img": "./images/aca640.png",
        "pdf": "./images/aca640_pdf.png",
        "num": "A05B-1405-K551",
        "ccd": "1/4&quot;",
        "cell": "5.6&micro;m",
        "weight": "80g",
        "resolution": "640&times;480 pixels",
        "note": "acA640_120um is only usable with ROBOGUIDE"
      },
      {
        "id": "acA640-750umFNC",
        "title": "",
        "name": "acA640-750umFNC",
        "img": "./images/aca640.png",
        "pdf": "./images/aca640_750_pdf.png",
        "num": "A05B-1405-K555",
        "ccd": "1/4&quot;",
        "cell": "4.8&micro;m",
        "weight": "80g",
        "resolution": "640&times;480 pixels",
        "note": ""
      }
    ],
    "R-30iA": [
      {
        "id": "XC-56",
        "title": "Standard analog camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "XC-56",
        "img": "./images/xc_56.png",
        "pdf": "./images/xc_56_pdf.png",
        "num": "A05B-1405-K501",
        "ccd": "1/3&quot;",
        "cell": "7.4&micro;m",
        "weight": "50g",
        "resolution": "512&times;480 pixels",
        "note": ""
      },
      {
        "id": "SC130C",
        "title": "Monochrome digital camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "SC130C",
        "img": "./images/sc130ebw.png",
        "pdf": "./images/sc130ebw_pdf.png",
        "num": "A05B-1405-K532",
        "ccd": "2/3&quot;",
        "cell": "6.7&micro;m",
        "weight": "50g",
        "resolution": "1024&times;960 pixels",
        "note": ""
      },
      {
        "id": "SC310M",
        "title": "Color digital camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "SC310M",
        "img": "./images/sc130ecolor.png",
        "pdf": "./images/sc130ecolor_pdf.png",
        "num": "A05B-1405-K521",
        "ccd": "1/2&quot;",
        "cell": "6.4&micro;m",
        "weight": "50g",
        "resolution": "512&times;480 pixels",
        "note": ""
      }
    ],
    "R-30iA_b": [
      {
        "id": "XC-56",
        "title": "Standard analog camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "XC-56",
        "img": "./images/xc_56.png",
        "pdf": "./images/xc_56_pdf.png",
        "num": "A05B-1405-K501",
        "ccd": "1/3&quot;",
        "cell": "7.4&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      },
      {
        "id": "XC-HR50",
        "title": "Double speed camera that can be used with both R-30iA/R-30iB controllers. Vision Board is required when using with R-30iA.",
        "name": "XC-HR50",
        "img": "./images/xc_hr50.png",
        "pdf": "./images/xc_hr50_PDF.png",
        "num": "A05B-1405-K502",
        "ccd": "1/3&quot;",
        "cell": "7.4&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      },
      {
        "id": "SC130C",
        "title": "Monochrome digital camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "SC130C",
        "img": "./images/sc130ebw.png",
        "pdf": "./images/sc130ebw_pdf.png",
        "num": "A05B-1405-K532",
        "ccd": "2/3&quot;",
        "cell": "6.7&micro;m",
        "weight": "50g",
        "resolution": "1280&times;960 pixels",
        "note": ""
      },
      {
        "id": "SC310M",
        "title": "Color digital camera that can be used with both R-30iA/R-30iB controllers.",
        "name": "SC310M",
        "img": "./images/sc130ecolor.png",
        "pdf": "./images/sc130ecolor_pdf.png",
        "num": "A05B-1405-K521",
        "ccd": "1/2&quot;",
        "cell": "6.4&micro;m",
        "weight": "50g",
        "resolution": "640&times;480 pixels",
        "note": ""
      }
    ]
  };
  return json;
}

function flenseTableDef() {
  var array = [
    {
      "id": "lense_8mm",
      "name": "8mm lens",
      "img": "./images/l219hb.png",
      "pdf": "./images/l219hb_pdf.pdf",
      "num": "A05B-1405-K511",
      "focal": "8mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.4 - 16",
      "close": "260mm",
      "weight": "48g",
      "fillter": "25.5&times;0.5mm"
    },
    {
      "id": "lense_12mm",
      "name": "12mm lens",
      "img": "./images/l25hb.png",
      "pdf": "./images/l25hb_pdf.pdf",
      "num": "A05B-1405-K512",
      "focal": "12mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.8 - 16",
      "close": "260mm",
      "weight": "46g",
      "fillter": "25.5&times;0.5mm"
    },
    {
      "id": "lense_16mm",
      "name": "16mm lens",
      "img": "./images/l17hf.png",
      "pdf": "./images/l17hf_pdf.pdf",
      "num": "A05B-1405-K513",
      "focal": "16mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.4 - 16",
      "close": "290mm",
      "weight": "48g",
      "fillter": "25.5&times;0.5mm"
    },
    {
      "id": "lense_25mm",
      "name": "25mm lens",
      "img": "./images/l20hc.png",
      "pdf": "./images/l20hc_pdf.pdf",
      "num": "A05B-1405-K514",
      "focal": "25mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.6 - 16",
      "close": "210mm",
      "weight": "40g",
      "fillter": "25.5&times;0.5mm"
    }
  ];
  return array;
}

function kowaLenseTableDef() {
  var array = [
    {
      "id": "mpix_3_5",
      "name": "Kowa MegaPixel<br>3.5mm lens",
      "img": "./images/lm3nc1m.png",
      "pdf": "./images/lm3nc1m_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM3NC1M",
      "focal": "3.5mm",
      "ccd": "1/1.8&quot;",
      "aperture": "f2.4 to 14",
      "close": "100mm",
      "weight": "75g",
      "fillter": "40.5&times;0.5mm"
    },
    {
      "id": "mpix_5",
      "name": "Kowa MegaPixel<br>5mm lens",
      "img": "./images/lm5jc1m.png",
      "pdf": "./images/lm5jc1m_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM5JC1MCHG",
      "focal": "5mm",
      "ccd": "2/3&quot;",
      "aperture": "f2.8 to 16",
      "close": "150mm",
      "weight": "100g",
      "fillter": "40.5&times;0.5mm"
    },
    {
      "id": "mpix_6",
      "name": "Kowa MegaPixel<br>6mm lens",
      "img": "./images/lm6nc1m.png",
      "pdf": "./images/lm6nc1m_PDF_eg.pdf",
      "maker": "KOWA",
      "num": "LM6NC1M",
      "focal": "6mm",
      "ccd": "1/2&quot;",
      "aperture": "f1.2 to Close",
      "close": "100mm",
      "weight": "90g",
      "fillter": "30.5&times;0.5mm"
    },
    {
      "id": "mpix_8",
      "name": "Kowa MegaPixel<br>8mm lens",
      "img": "./images/lm8jc1ms.png",
      "pdf": "./images/lm8jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM8JC1MS",
      "focal": "8mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.4 to Close",
      "close": "120mm",
      "weight": "75g",
      "fillter": "27&times;0.5mm"
    },
    {
      "id": "mpix_12",
      "name": "Kowa MegaPixel<br>12mm lens",
      "img": "./images/lm12jc1ms.png",
      "pdf": "./images/lm12jc1ms_pdf_egpdf",
      "maker": "KOWA",
      "num": "LM12JC1MS",
      "focal": "12mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.4 to Close",
      "close": "150mm",
      "weight": "81g",
      "fillter": "27&times;0.5mm"
    },
    {
      "id": "mpix_16",
      "name": "Kowa MegaPixel<br>16mm lens",
      "img": "./images/lm16jc1ms.png",
      "pdf": "./images/lm16jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM16JC1MS",
      "focal": "16mm",
      "ccd": "2/3&quot;",
      "aperture": "f1.4 to 16",
      "close": "200mm",
      "weight": "89g",
      "fillter": "27&times;0.5mm"
    },
    {
      "id": "mpix_25",
      "name": "Kowa MegaPixel<br>25mm lens",
      "img": "./images/lm25jc1ms.png",
      "pdf": "./images/lm25jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM25JC1MS",
      "focal": "25mm",
      "ccd": "2/3&quot;",
      "aperture": "f2.0 to 16",
      "close": "200mm",
      "weight": "69g",
      "fillter": "27&times;0.5mm"
    },
    {
      "id": "mpix_35",
      "name": "Kowa MegaPixel<br>35mm lens",
      "img": "./images/lm35jc1ms.png",
      "pdf": "./images/lm35jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM35JC1MS",
      "focal": "35mm",
      "ccd": "2/3&quot;",
      "aperture": "f2.0 to 16",
      "close": "200mm",
      "weight": "69g",
      "fillter": "27&times;0.5mm"
    },
    {
      "id": "mpix_50",
      "name": "Kowa MegaPixel<br>50mm lens",
      "img": "./images/lm50jc1ms.png",
      "pdf": "./images/lm50jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM50JC1MS",
      "focal": "50mm",
      "ccd": "2/3&quot;",
      "aperture": "f2.8 to 22",
      "close": "200mm",
      "weight": "92g",
      "fillter": "27&times;0.5mm"
    },
    {
      "id": "mpix_75",
      "name": "Kowa MegaPixel<br>75mm lens",
      "img": "./images/lm75jc1ms.png",
      "pdf": "./images/lm75jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM75JC1MS",
      "focal": "75mm",
      "ccd": "2/3&quot;",
      "aperture": "f2.5 to 22",
      "close": "1200mm",
      "weight": "105g",
      "fillter": "34&times;0.5mm"
    },
    {
      "id": "mpix_100",
      "name": "Kowa MegaPixel<br>100mm lens",
      "img": "./images/lm100jc1ms.png",
      "pdf": "./images/lm100jc1ms_pdf_eg.pdf",
      "maker": "KOWA",
      "num": "LM100JC1MS",
      "focal": "100mm",
      "ccd": "2/3&quot;",
      "aperture": "f2.8 to 32",
      "close": "2000mm",
      "weight": "150g",
      "fillter": "40.5&times;0.5mm"
    }
  ];
  return array;
}

function getRadioValue(elems) {
  for (var i = 0, len = elems.length; i < len; i++) {
    if (elems[i].checked) {
      return elems[i].value;
    }
  }
  return null;
}
function getController() {
  return getRadioValue(document.getElementsByName("CONTROLLER"));
}

function changeShowHide() {
  var controller = getController();

  if (!isStandalone) {
    this.IHMIComponents.cf.addClass(document.getElementById('contLeft'), 'hide');
    this.IHMIComponents.cf.addClass(document.getElementById('contRight'), 'hide');
  }

  if (controller === "R-30iA") {
    this.IHMIComponents.cf.removeClass(document.getElementById('boardLeft'), 'hide');
    this.IHMIComponents.cf.removeClass(document.getElementById('boardRight'), 'hide');
  } else {
    this.IHMIComponents.cf.removeClass(document.getElementById('sizeLeft'), 'hide');
    this.IHMIComponents.cf.removeClass(document.getElementById('sizeRight'), 'hide');
    this.IHMIComponents.cf.addClass(document.getElementById('boardLeft'), 'hide');
    this.IHMIComponents.cf.addClass(document.getElementById('boardRight'), 'hide');
  }
}

function setSelectFrame(elem, type) {
  var ihmi = this.IHMIComponents.cf;
  removeSelectFrame(type);
  if (type === "cam") {
    selectCamTable = elem;
  } else {
    selectLenTable = elem;
  }
  var nodes = elem.children;
  ihmi.addClass(nodes[0], "selectTblLeft");
  for (var i = 1; i < nodes.length - 1; i++){
    ihmi.addClass(nodes[i], "selectTblTB");
  }
  ihmi.addClass(nodes[i], "selectTblRight");
}
function removeSelectFrame(type) {
  var ihmi = this.IHMIComponents.cf;
  var selectTable = type === "cam" ? selectCamTable : selectLenTable;
  if (selectTable != null) {
    var nodes = selectTable.children;
    if (nodes.length > 0) {
      ihmi.removeClass(nodes[0], "selectTblLeft");
      for (var i = 1; i < nodes.length - 1; i++) {
        ihmi.removeClass(nodes[i], "selectTblTB");
      }
      ihmi.removeClass(nodes[i], "selectTblRight");
    }
    if (type === "cam") {
      selectCamTable = null;
    } else {
      selectLenTable = null;
    }
  }
}

function setListHeight() {
  document.getElementById("divCameraLense").style.height = document.body.clientHeight - 138 + "px";
}

function initLguide() {
  initDefData();
  setListHeight();
  contentResize();
  initSelectList();
  createCamTable();
  initSelectCamera();
}

function test(id,type,value) {
  console.log("id = ", id, "\ntype = ", type, "\nvalue = ", value);
}

function initDefData() {
  type_data = typeDataDef();
  serial_data = serialDataDef();
  select_cam_data = selectCamDataDef();
  select_imgSize_data = imageSizeListDef();
  select_lense_data = selectLenseDef();
  calcurate_data.cam = calculateCamDataDef();
  calcurate_data.lense = calculateLenseDataDef();
  board_data = visionBoardData();
  cam_list_data = cameraTableDef();
}

function refreshCamList(controller) {
  if (controller == "R-30iA" && this.IHMIComponents.cf.parseStrToBoolean(document.getElementById("board").getValue())) {
    controller += "_b";
  }
  document.getElementById("cam").refresh(select_cam_data[controller], select_cam_data[controller][0][1], null, false);
}

function refreshImgSize(controller, camera) {
  if (controller == "R-30iA" && this.IHMIComponents.cf.parseStrToBoolean(document.getElementById("board").getValue())) {
    controller += "_b";
  }
  document.getElementById("image_size").refresh(select_imgSize_data[controller][camera], select_imgSize_data[controller][camera][0][1], null, false);
}

function refreshLenseList() {
  document.getElementById("len").refresh(select_lense_data, select_lense_data[0][1], null, false);
  var ihmi = window.IHMIComponents.cf;
  ihmi.addClass(document.getElementById("focalBox"), "readonly_text");
  ihmi.addClass(document.getElementById("custom_focal"), "readOnly_input");
  document.getElementById("custom_focal").readOnly = true;
  document.getElementById("custom_focal").value = INIT_CUSTOM_FOCAL;
}
function refreshBoardList() {
  document.getElementById("board").refresh(board_data, board_data[0][1], null, false);
}

function initSelectList() {
  refreshCamList(getController());
  refreshImgSize(getController(), document.getElementById("cam").getValue());
  refreshLenseList();
  refreshBoardList();
}

function changeController(controller) {
  refreshCamList(controller);
  refreshImgSize(controller, document.getElementById("cam").getValue());
  refreshLenseList();
  refreshBoardList();

  if (this.IHMIComponents.cf.hasClass(document.getElementById('tab1'), 'tab-selected')) {
    createCamTable();
    initSelectCamera();
  } else {
    createLenseTable();
    selectLense();
  }
  changeShowHide();
}

function calcFoV() { // FoV = Field of View
  var errflag = false;
  var textArea = document.getElementById("resultWarn");
  var controller = getController();
  var cam = document.getElementById("cam").getValue();
  var imgSize = document.getElementById("image_size").getValue();
  var len = document.getElementById("len").getValue();
  var wd = document.getElementById("WD.textbox").value;
  var camera = calcurate_data.cam[controller][cam][imgSize];
  var lens = new Array(3);

  textArea.value = "";
  if (len != "customize") {
    lens = calcurate_data.lense[len];
    if (wd <= 0) { // work distance
      errflag = true;
      document.getElementById("FOV1").value = 0;
      document.getElementById("FOV2").value = 0;
      document.getElementById("SCALE").value = 0;
      wd.value = 0;
      textArea.value += "An invalid work distance is being specified.\n";
    }
    if (lens[2] < camera[3]) { // image senser size
      textArea.value += "The selected lens is not for a large image sensor camera. Select a proper lens according to the image sensor size of the selected camera.<br><br>";
    }
    if (wd - lens[1] < 0) { // Closest distance
      textArea.value += "The specified work distance is shorter than tha shortest distance of the lens, and objects could not be in focus. Move the camera apart, or use an extension tube.\n";
    }
  }
  else {
    var focal = parseFloat(document.getElementById("custom_focal").value)
    if (isNaN(focal)) {
      document.getElementById("custom_focal").value = 1;
      lens[0] = 1;
    }
    else {
      lens[0] = focal;
    }
    lens[1] = 0;
    lens[2] = 0;
  }

  if (!errflag) {
    var answer = ((wd - lens[0]) / lens[0] * camera[0] * camera[1]) / 1000;
    var answer2 = ((wd - lens[0]) / lens[0] * camera[0] * camera[2]) / 1000;
    document.getElementById("FOV1").value = Math.round(answer);
    document.getElementById("FOV2").value = Math.round(answer2);
    var scale = answer / camera[1];
    document.getElementById("SCALE").value = Math.round(100 * scale) / 100;
  }
}

function initSelectCamera() {
  calcFoV();
  var targetElem = document.getElementById(document.getElementById("cam").getValue()).parentElement.parentElement;
  setSelectFrame(targetElem, "cam");
}
function selectCamera(id, type, val) {
  if (window.IHMIComponents.cf.hasClass(document.getElementById('tab1'), 'tab-selected')) {
    var targetElem = document.getElementById(val).parentElement.parentElement;
    setSelectFrame(targetElem, "cam");
  }
  refreshImgSize(getController(), val);
  calcFoV();
}

function selectLense() {
  var ihmi = window.IHMIComponents.cf;
  var lenTxt = document.getElementById("len").getValue();
  if (lenTxt == "customize") {
    ihmi.removeClass(document.getElementById("focalBox"), "readonly_text");
    ihmi.removeClass(document.getElementById("custom_focal"), "readOnly_input");
    document.getElementById("custom_focal").readOnly = false;
    removeSelectFrame();
  } else {
    ihmi.addClass(document.getElementById("focalBox"), "readonly_text");
    ihmi.addClass(document.getElementById("custom_focal"), "readOnly_input");
    document.getElementById("custom_focal").readOnly = true;
    if (window.IHMIComponents.cf.hasClass(document.getElementById('tab2'), 'tab-selected')) {
      var targetElem = document.getElementById(lenTxt).parentElement.parentElement;
      setSelectFrame(targetElem, "len");
    }
  }
  calcFoV();
}

function changeBoard() {
  var controller = getController();
  var cam = document.getElementById("cam").getValue();
  refreshCamList(controller);
  refreshImgSize(controller, cam);

  if (window.IHMIComponents.cf.hasClass(document.getElementById('tab1'), 'tab-selected')) {
    createCamTable();
    initSelectCamera();
  }
}

function createCamTable() {
  var html,note;
  var controller = getController();
  var board = window.IHMIComponents.cf.parseStrToBoolean(document.getElementById("board").getValue());
  if (controller == "R-30iA" && board) { controller += "_b";}
  var camArray = cam_list_data[controller];
  html = '<table id="tblCamera" border="2" cellspacing="0">';
  html += '<span class="tableTitle">[FANUC Camera List]</span><span class="tablTitNote">(Click a camera\'s figure number to display a figure of the external dimensions.)</span>';
  html += '<tr class="tblHeader titleCell">';
  html += '<td align="center">Name';
  html += '<td align="center">Image';
  html += '<td align="center">Figure number';
  html += '<td align="center">Imaging sensor size';
  html += '<td align="center">Cell size';
  html += '<td align="center">Weight';
  html += '<td align="center">Resolution';
  html += '<td align="center">Notes';
  html += '</tr>';
  for (var i = 0; i < camArray.length; i++){
    html += '<tr>';
    html += '<td align="center"><span id="' + camArray[i].id + '" title="' + camArray[i].title + '">' + camArray[i].name + '</span>';
    html += '<td align="center"><img src ="' + camArray[i].img + '"></a>';
    html += '<td align="center" class="modelNum"><a href="' + camArray[i].pdf + '" target="_blank">' + camArray[i].num + '</a>';
    html += '<td id="img_ele_size' + i + '" align="center">' + camArray[i].ccd;
    html += '<td id="cell_size' + i + '" align="center">' + camArray[i].cell;
    html += '<td id="weight' + i + '" align="center">' + camArray[i].weight;
    html += '<td id="resolution' + i + '" align="center">' + camArray[i].resolution + '</td>';
    note = camArray[i].note != "" ? camArray[i].note : "&nbsp;";
    html += '<td align="center" class="noteCell">' + note + '</td>';
    html += '</tr>';
  }
  var parent = document.getElementById("divCameraLense");
  while (parent.firstChild) {
    parent.removeChild(parent.firstChild);
  }
  parent.insertAdjacentHTML('afterbegin', html);
  selectCamTable = null;
}

function createLenseTable() {
  var html;
  var fLense = flenseTableDef();

  html = '<table id="tblLense1" border=2  cellspacing="0">'
    + '<span class="tableTitle">[FANUC Lens List]</span><span class="tablTitNote">(Click a lens\'s figure number to display a figure of the external dimensions.)</span>'
    + '<tr  class="tblHeader titleCell">'
    + '<td nowrap align="center">Name'
    + '<td align="center">Image'
    + '<td align="center">Figure number'
    + '<td nowrap align="center">Focal Distance'
    + '<td nowrap align="center">Supported Sensor Size'
    + '<td nowrap align="center">Lens Aperture'
    + '<td nowrap align="center">Min. Work Distance'
    + '<td nowrap align="center">Weight'
    + '<td nowrap align="center">Filter Size'
    + '</tr>';

  for (var i = 0; i < fLense.length; i++) {
    html += '<tr>';
    html += '<td align="center"><span id="' + fLense[i].id + '">' + fLense[i].name + '</span>';
    html += '<td align="center"><img src ="' + fLense[i].img + '"></a>';
    html += '<td align="center" class="modelNum"><a href="' + fLense[i].pdf + '" target="_blank">' + fLense[i].num + '</a>';
    html += '<td id="focal' + i + '" align="center">' + fLense[i].focal;
    html += '<td id="image_size' + i + '" align="center">' + fLense[i].ccd;
    html += '<td id="aperture' + i + '" align="center">' + fLense[i].aperture;
    html += '<td id="close' + i + '" align="center">' + fLense[i].close + '</td>';
    html += '<td id="weight" align="center">' + fLense[i].weight + '</td>';
    html += '<td id="fillter" align="center">' + fLense[i].fillter + '</td>';
    html += '</tr>';
  }
  html += '</table>';

    var kowaLense = kowaLenseTableDef();
    if (!isStandalone) {
      html += '<br>'
        + '<table id="tblLense2" border=2  cellspacing="0">'
        + '<span class="tableTitle">[List of MegaPixel-Supporting Lens]</span><span class="tablTitNote"></span>'
        + '<tr  class="tblHeader titleCell">'
        + '<td nowrap align="center">Name'
        + '<td align="center">Image'
        + '<td nowrap align="center">Manufacturer Name'
        + '<td nowrap align="center">Type'
        + '<td nowrap align="center">Focal Distance'
        + '<td nowrap align="center">Supported Sensor Size'
        + '<td nowrap align="center">Lens Aperture'
        + '<td nowrap align="center">Min. Work Distance'
        + '<td nowrap align="center">Weight'
        + '<td nowrap align="center">Filter Size'
        + '</tr>';
    }

    else {
      html += '<br>'
        + '<table id="tblLense2" border=2  cellspacing="0">'
        + '<span class="tableTitle">[List of MegaPixel-Supporting Lens]</span><span class="tablTitNote">(Click a lens\'s type to display a figure of the external dimensions.)</span>'
        + '<tr  class="tblHeader titleCell">'
        + '<td nowrap align="center">Name'
        + '<td align="center">Image'
        + '<td nowrap align="center">Manufacturer Name'
        + '<td nowrap align="center">Type'
        + '<td nowrap align="center">Focal Distance'
        + '<td nowrap align="center">Supported Sensor Size'
        + '<td nowrap align="center">Lens Aperture'
        + '<td nowrap align="center">Min. Work Distance'
        + '<td nowrap align="center">Weight'
        + '<td nowrap align="center">Filter Size'
        + '</tr>';
    }

    for (i = 0; i < kowaLense.length; i++) {
      html += '<tr>';
      html += '<td align="center"><span id="' + kowaLense[i].id + '">' + kowaLense[i].name + '</span>';
      html += '<td align="center"><img src ="' + kowaLense[i].img + '"></a>';
      html += '<td id="maker" align="center">' + kowaLense[i].maker;
      html += (!isStandalone) ? '<td id="num" align="center">' + kowaLense[i].num : '<td align="center" class="modelNem"><a href="' + kowaLense[i].pdf + '"target=_blank">' + kowaLense[i].num + '</a>';
      html += '<td id="focal' + i + '" align="center">' + kowaLense[i].focal;
      html += '<td id="image_size' + i + '" align="center">' + kowaLense[i].ccd;
      html += '<td id="aperture' + i + '" align="center">' + kowaLense[i].aperture;
      html += '<td id="close' + i + '" align="center">' + kowaLense[i].close + '</td>';
      html += '<td id="weight" align="center">' + kowaLense[i].weight + '</td>';
      html += '<td id="fillter" align="center">' + kowaLense[i].fillter + '</td>';
      html += '</tr>';
    }


  var parent = document.getElementById("divCameraLense");
  while (parent.firstChild) {
    parent.removeChild(parent.firstChild);
  }
  parent.insertAdjacentHTML('afterbegin', html);
  selectLenTable = null;
}

function contentResize() {
  document.getElementById("content").style.width = (document.body.clientWidth - 412) + "px";
}

function resizeEvent() {
  contentResize();
  setListHeight();
}

function showCamList() {
  createCamTable();
  initSelectCamera();
}
function showLenseList() {
  createLenseTable();
  selectLense();
}
