var g_plugin_list    = [['Select', "0", null]];
var KAREL_PROG       = "EETCMAIN";
var KAREL_DTCH       = "DTCH_STATUS";
var KAREL_ATCH       = "ATCH_STATUS";
var g_monitoring_flg = false;
var g_crr_prog       = "";
var g_plg_idx        = 0;
var g_dtchtime       = [];
var g_major_ver      = "";
var g_minor_ver      = "";
var EETC_POP_TOP     = 68;

function start_up_eetlchg() {
  doc.getElementById("plugin_select").refresh(g_plugin_list, "0", null, true);
  get_plugin_list_data();
  doc.getElementById("detach_btn").setCallback(check_detach_time);
  doc.getElementById("plugin_select").setCallback(select_callback);
  doc.getElementById("attach_btn").setCallback(show_attach_pop);
  top.ihmi_getVar(top.SYSNAME_C, "$TLIF.$MAJOR_VER", get_minor_ver);
}

function unload_eetlchg() {
  if(g_monitoring_flg) {
    if (g_crr_prog === KAREL_DTCH.toLowerCase()) {
      top.rpcmc_stopVarMonitor(KAREL_PROG, g_crr_prog, 100);
      top.jQuery.varlis.unbind('VarEvent', chg_detach_evt);
      g_monitoring_flg = false;
      parent.doc.getElementById("bar1").classList.remove("overlay");
    } else {
      top.rpcmc_stopVarMonitor(KAREL_PROG, g_crr_prog, 100);
      top.jQuery.varlis.unbind('VarEvent', chg_attach_evt);
      g_monitoring_flg = false;
      parent.doc.getElementById("bar1").classList.remove("overlay");
    }
  }
}

function check_detach_time() {
  parent.doc.getElementById("bar1").classList.add("overlay");
  if (g_plg_idx <= 0) {
    //if manual setting is applied
    show_detach_pop();
  } else {
    //some plugin is attached now
    if (g_dtchtime[g_plg_idx] < 0) { //if detach time is not specified, usually g_dtchtime is -1
      show_detach_pop();
    } else {
      //if detachtime is specified
      start_detach();
    }
  }
}

function start_detach() {
  var detach_num = 1;
  var g_crr_prog = "dtch_status";
  doc.getElementById("detach_btn").refresh(null, null, null, null, true, null);
  doc.getElementById("detach_btn").textContent = 'Detaching';
  //start detach Variable Monitor
  //console.log("start detach mon : "+g_crr_prog);
  top.rpcmc_startVarMonitor(KAREL_PROG, g_crr_prog, 100);
  top.jQuery.varlis.bind('VarEvent', null, chg_detach_evt);
  g_monitoring_flg = true;
  $.ajax({
    type: "GET",
    url: "/KARELCMD/EETCMAIN?s_func_type=" + detach_num,
    dataType: "json",
    cache: false,
  }).done(function(json_data) {
    //request done
  }).fail(function() {
    //error
    show_karel_err_pop();
  });
}

function show_detach_pop() {
  //popup function
  var initPopup = function(iframe) {
    var frame = iframe.contentWindow;
    var closePopup = function(id, operation) {
      top.IHMIComponents.cf.removeFrame(iframe);
      switch (id) {
        case "okBtn":
          start_detach();
          break;
        case "cancelBtn":
        case "closeBtn":
        default:
          parent.doc.getElementById("bar1").classList.remove("overlay");
          break;
      }
    };
    frame.document.getElementById("eetc_pop").style.top     = window.scrollY + EETC_POP_TOP + "px";
    frame.document.getElementById("eetc_message").innerHTML = 'The detach wait time is not specified.<br>After pressing "OK", wait enough time before removing the tool.<br>Refer to the tool specification for how long you should wait.<br><br><span class="bold_txt">Warning:</span> If you remove the tool too quickly, you may damage the tool.';
    frame.document.getElementById("okBtn").setCallback(closePopup);
    frame.document.getElementById("cancelBtn").setCallback(closePopup);
    frame.document.getElementById("closeBtn").setCallback(closePopup);
  };
  var eesetPopupFrame = top.IHMIComponents.cf.appendFrame(window, "/frh/irprog/eesetup/eetc_popup.stm", "popup-frame eetc-pop-frm", initPopup);
}

function start_attach() {
  var attach_num = 2;
  var g_crr_prog = "atch_status";
  var s_plugidx  = document.getElementById("plugin_select").getValue();
  doc.getElementById("plugin_select").refresh(g_plugin_list, s_plugidx, null, true);
  doc.getElementById("attach_btn").refresh(null, null, null, null, true, null);
  doc.getElementById("attach_btn").textContent = 'Attaching';
  //start attach Variable Monitor
  //console.log("start attach mon : "+g_crr_prog);
  top.rpcmc_startVarMonitor(KAREL_PROG, g_crr_prog, 100);
  top.jQuery.varlis.bind('VarEvent', null, chg_attach_evt);
  g_monitoring_flg = true;
  $.ajax({
    type: "GET",
    url: "/KARELCMD/EETCMAIN?s_func_type=" + attach_num + "&s_plugidx=" + s_plugidx,
    dataType: "json",
    cache: false,
  }).done(function(json_data) {
    //request done
  }).fail(function() {
    //error
    show_karel_err_pop();
  });
}

function chg_detach_evt(event, prog_name, var_name, type_cd, val_str) {
  if (prog_name === KAREL_PROG) {
    if (var_name === KAREL_DTCH) {
      switch(val_str) {
        case "-1":
          break;
        case "0":
          top.rpcmc_stopVarMonitor(KAREL_PROG, var_name.toLowerCase(), 100);
          top.jQuery.varlis.unbind('VarEvent', chg_detach_evt);
          g_monitoring_flg = false;
          get_plugin_cnct_data();
          break;
        default:
          show_karel_err_pop();
          break;
      }
    }
  }
}

function chg_attach_evt(event, prog_name, var_name, type_cd, val_str) {
  if (prog_name === KAREL_PROG) {
    if (var_name === KAREL_ATCH) {
      switch(val_str) {
        case "-1":
          break;
        case "0":
          top.rpcmc_stopVarMonitor(KAREL_PROG, var_name.toLowerCase(), 100);
          top.jQuery.varlis.unbind('VarEvent', chg_attach_evt);
          g_monitoring_flg = false;
          get_plugin_cnct_data();
          break;
        default:
          show_karel_err_pop();
          break;
      }
    }
  }
}

function select_callback(id, type, value) {
  if (value === "0") {
    doc.getElementById("attach_btn").refresh(null, null, null, null, true, null);
  } else {
    doc.getElementById("attach_btn").refresh(null, null, null, null, false, null);
  }
}

function show_attach_pop() {
  //popup function
  var select_plugin = doc.getElementById("plugin_select").getText();
  var message       = '"' + select_plugin + '"' + ' is now selected.<br>Be sure the right tool is connected, otherwise the tool may be damaged.<br><br>Press "OK" button to start the communication.';
  var initPopup = function(iframe) {
    var frame = iframe.contentWindow;
    var closePopup = function(id, operation) {
      top.IHMIComponents.cf.removeFrame(iframe);
      switch (id) {
        case "okBtn":
          start_attach();
          break;
        case "cancelBtn":
        case "closeBtn":
        default:
          parent.doc.getElementById("bar1").classList.remove("overlay");
          break;
      }
    };
    frame.document.getElementById("eetc_pop").style.top     = window.scrollY + EETC_POP_TOP + "px";
    frame.document.getElementById("eetc_pop").style.height  = "400px";
    frame.document.getElementById("eetc_message").innerHTML = message;
    frame.document.getElementById("okBtn").setCallback(closePopup);
    frame.document.getElementById("cancelBtn").setCallback(closePopup);
    frame.document.getElementById("closeBtn").setCallback(closePopup);
  };
  var eesetPopupFrame = top.IHMIComponents.cf.appendFrame(window, "/frh/irprog/eesetup/eetc_popup.stm", "popup-frame eetc-pop-frm", initPopup);
}

function show_karel_err_pop() {
  var message       = 'Some error occurred.\nConfirm the alarm.';
  var customize_obj = null;
  if (g_crr_prog === KAREL_DTCH.toLowerCase()) {
    top.rpcmc_stopVarMonitor(KAREL_PROG, g_crr_prog, 100);
    top.jQuery.varlis.unbind('VarEvent', chg_detach_evt);
    g_monitoring_flg = false;
  } else {
    top.rpcmc_stopVarMonitor(KAREL_PROG, g_crr_prog, 100);
    top.jQuery.varlis.unbind('VarEvent', chg_attach_evt);
    g_monitoring_flg = false;
  }
  top.IHMIComponents.cf.alertMessage(message, null, get_plugin_cnct_data, window, customize_obj);
}

function get_plugin_list_data(cmt_flag, grp_num, callback) {
  var arg       = {};
  arg.type      = top.REF_TYPE_POS;
  arg.grp       = grp_num;
  arg.callback  = callback;
  arg.cmt_flag  = cmt_flag;
  var frame_xml = '<?xml version="1.0" encoding="' + top.langEncoding[top.currentLang] + '"?>\r';
  frame_xml     = frame_xml + '<XMLCFG>\r<PROG name="*SYSTEM*">\r<VAR name="$TLIF_SCH" />\r';
  frame_xml     = frame_xml + '</PROG>\r</XMLCFG>';
  var file_cvr  = new Blob([frame_xml], {
    type: "text/plain"
  });
  top.getXHR("get_plugin_list_data", file_cvr, get_plugin_list_data_callback, arg);
}

function get_plugin_list_data_callback(status, getText, callbackarg) {
  var str_xml    = "";
  var file_lines = getText.split(top.CODELF);
  var dom_parser = new DOMParser();
  for (var i = 0; i < file_lines.length; i++) {
    str_xml = str_xml + file_lines[i] + "\n";
  }
  var xml_obj = null;
  try {
    xml_obj = dom_parser.parseFromString(str_xml, "text/xml");
  } catch (e) {
    console.log(e);
  }
  // Success Get XML Data.
  if (xml_obj.getElementsByTagName("ARRAY").length != 0) {
    var arr_num  = -1;
    var arr_elem = xml_obj.getElementsByTagName("ARRAY");
    var fld_elem;
    // For position data
    for (var i = 0; i < arr_elem.length; i++) {
      if (arr_elem[i].getAttributeNode("name").value.indexOf("$TLIF_SCH") !== -1) {
        arr_num  = arr_elem[i].getAttributeNode("name").value.replace("$TLIF_SCH[", "").replace("]", "");
        fld_elem = arr_elem[i].getElementsByTagName("FIELD");
        for (var j = 0; j < fld_elem.length; j++) {
          if (fld_elem[j].getAttributeNode("name").value === "$PLGNAME") {
            if ((arr_num === "1") && (fld_elem[j].childNodes[0].data === "********")) {
              doc.getElementById("content").classList.remove("content");
              doc.getElementById("content").classList.add("content_no_plugin");
              doc.getElementById("attach_msg_area_3").classList.remove("item_hide");
            } else {
              if (fld_elem[j].childNodes[0].data != "********") {
                g_plugin_list.push([fld_elem[j].childNodes[0].data, arr_num, null]);
              }
            }
          } else if (fld_elem[j].getAttributeNode("name").value === "$DTCHTIME") {
            g_dtchtime[arr_num] = fld_elem[j].childNodes[0].data;
          }
        }
      }
    }
  }
  get_plugin_cnct_data();
}

function get_plugin_cnct_data(cmt_flag, grp_num, callback) {
  var arg       = {};
  arg.type      = top.REF_TYPE_POS;
  arg.grp       = grp_num;
  arg.callback  = callback;
  arg.cmt_flag  = cmt_flag;
  var frame_xml = '<?xml version="1.0" encoding="' + top.langEncoding[top.currentLang] + '"?>\r';
  frame_xml     = frame_xml + '<XMLCFG>\r<PROG name="*SYSTEM*">\r<VAR name="$TLIF_CUR" />\r';
  frame_xml     = frame_xml + '</PROG>\r</XMLCFG>';
  var file_cvr  = new Blob([frame_xml], {
    type: "text/plain"
  });
  top.getXHR("get_plugin_cnct_data", file_cvr, get_plugin_cnct_data_callback, arg);
}

function get_plugin_cnct_data_callback(status, getText, callbackarg) {
  var str_xml    = "";
  var file_lines = getText.split(top.CODELF);
  var dom_parser = new DOMParser();
  for (var i = 0; i < file_lines.length; i++) {
    str_xml = str_xml + file_lines[i] + "\n";
  }
  var xml_obj = null;
  try {
    xml_obj = dom_parser.parseFromString(str_xml, "text/xml");
  } catch (e) {
    console.log(e);
  }
  // Success Get XML Data.
  if (xml_obj.getElementsByTagName("FIELD").length != 0) {
    var fld_elem = xml_obj.getElementsByTagName("FIELD");
    var pw_stat  = 0;
    var plg_name = "";
    var plg_idx  = 0;
    // For position data
    for (var i = 0; i < fld_elem.length; i++) {
      if (fld_elem[i].getAttributeNode("name").value === "$PWSTAT") {
        pw_stat = fld_elem[i].textContent;
      } else if (fld_elem[i].getAttributeNode("name").value === "$PLGNAME") {
        plg_name = fld_elem[i].textContent;
      } else if (fld_elem[i].getAttributeNode("name").value === "$PLGIDX") {
        plg_idx = fld_elem[i].textContent;
        g_plg_idx = plg_idx;
      }
    }
  }
  switch (pw_stat) {
    case "1":
      if (doc.getElementById("content").classList.contains("content_no_plugin")) {
        doc.getElementById("plugin_select").refresh(g_plugin_list, "0", null, true);
        doc.getElementById("attach_btn").refresh(null, null, null, null, true, null);
        doc.getElementById("attach_btn").textContent = 'Attach';
      } else if (doc.getElementById("plugin_select").getValue() === "0") {
        doc.getElementById("plugin_select").refresh(g_plugin_list, "0", null, false);
        doc.getElementById("attach_btn").refresh(null, null, null, null, true, null);
        doc.getElementById("attach_btn").textContent = 'Attach';
      } else {
        doc.getElementById("plugin_select").refresh(g_plugin_list, doc.getElementById("plugin_select").getValue(), null, false);
        doc.getElementById("attach_btn").refresh(null, null, null, null, false, null);
        doc.getElementById("attach_btn").textContent = 'Attach';
      }
      doc.getElementById("crr_status").textContent = 'Currently No tool is attached';
      doc.getElementById("icon_status_1").classList.remove("not-status-icon", "status-icon");
      doc.getElementById("icon_status_1").classList.add("status-icon");
      doc.getElementById("detach_btn").refresh(null, null, null, null, true, null);
      doc.getElementById("detach_btn").textContent = 'Detached';
      doc.getElementById("icon_status_2").classList.remove("not-status-icon", "status-icon");
      doc.getElementById("icon_status_2").classList.add("not-status-icon");
      doc.getElementById("content").classList.remove("item_hide");
      parent.doc.getElementById("bar1").classList.remove("overlay");
      break;
    case "2":
      if (plg_name === "") {
        doc.getElementById("crr_status").textContent = 'Current config : ' + 'Manual setting';
        doc.getElementById("plugin_select").refresh(g_plugin_list, "0", null, true);
        doc.getElementById("attach_btn").refresh(null, null, null, null, true, null);
      } else {
        doc.getElementById("crr_status").textContent = 'Current config : ' + plg_name;
        doc.getElementById("plugin_select").refresh(g_plugin_list, plg_idx, null, true);
        doc.getElementById("attach_btn").refresh(null, null, null, null, true, null);
      }
      doc.getElementById("icon_status_1").classList.remove("not-status-icon", "status-icon");
      doc.getElementById("icon_status_1").classList.add("not-status-icon");
      doc.getElementById("detach_btn").refresh(null, null, null, null, false, null);
      doc.getElementById("detach_btn").textContent = 'Detach';
      doc.getElementById("icon_status_2").classList.remove("not-status-icon", "status-icon");
      doc.getElementById("attach_btn").textContent = 'Attached';
      doc.getElementById("content").scrollIntoView(true);
      doc.getElementById("content").classList.remove("item_hide");
      parent.doc.getElementById("bar1").classList.remove("overlay");
      break;
    default:
      break;
  }
}

function get_minor_ver(prog_name, var_name, type_code, valStr) {
  g_major_ver = valStr;
  top.ihmi_getVar(top.SYSNAME_C, "$TLIF.$MINOR_VER", disp_version);
}

function disp_version(prog_name, var_name, type_code, valStr) {
  g_minor_ver = valStr;
  doc.getElementById("tlifboard_ver").textContent = "Tool I/F Version: V" + g_major_ver + "." + g_minor_ver;
}
