/* v00073 */
/**
 * @fileoverview iHMI Component JavaScript Library: This file is used to create iHMI Component.
 */
/*jsl:import ihmi_cookie.js*/

/*
var Logger = function() {
  var logs = [];
  var start_time = 0;
  var that = {
    start: function() {
      logs = [];
      start_time = (new Date()).getTime();
    },
    log: function(frame, text) {
      logs.push([(new Date()).getTime(), frame.webpage, text]);
    },
    alert: function() {
      var message = "";
      var log = [start_time, "", ""];
      var prev_time = start_time;
      for (var i = 0, len = logs.length; i < len; i++) {
        log = logs[i];
        message += IHMIComponents.cf.format("[%s] %s: %s\n", log[1], log[2], log[0] - prev_time);
        prev_time = log[0];
      }
      message += IHMIComponents.cf.format("total: %s", log[0] - start_time);
      setTimeout(function() { alert(message); }, 500);
    }
  };
  return that;
};
var logger = top.Logger();
createLogArea_(elem);
innerText_(elem, 'log1', 'log2', ...);
 --> output: log1, log2
function createLogArea_(elem) {
  var divElem = elem.ownerDocument.getElementById('bug01');
  if (divElem === null) {
    divElem = elem.ownerDocument.createElement('div');
    divElem.id = 'bug01';
    divElem.style.position = 'absolute';
    divElem.style.top = '10px';
    divElem.style.right = '20px';
    divElem.style.backgroundColor = '#ffffff';
    elem.ownerDocument.body.appendChild(divElem);
  }
}

function innerText_(elem) {
  createLogArea_(elem);
  var divElem = elem.ownerDocument.getElementById('bug01');
  var pElem = elem.ownerDocument.createElement('p');
  for (var i = 1; i < arguments.length; i++) {
    pElem.innerText += arguments[i] + ':';
  }
  divElem.appendChild(pElem);
}
*/

(function() {
  var ihmi = {
    global: {
      version: 'V9.40444',
      selectedTextbox: null,
      decimalComma: false,
      encoding: "Latin1",
      isIEMobile: false,
      isTablet: false,
      isiPad: false,
      hasTwoFuncKeyPages: false,
      isModernBrowser : (typeof window.addEventListener !== "undefined"),
      popupMessage: [], // To avoid disp same popup.
      colorTable: {
        red02:      "#E60012",
        red03:      "#B31E23",
        green03:    "#079A3E",
        orange01:   "#EB6100",
        yellow02:   "#FFE109",
        blue01:     "#0E6EB8",
        black01:    "#000000",
        white01:    "#FFFFFF"
      },
      svgStrs : {
        triangleUp : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 400 400" fill="#ffffff"><path d="M 100 273 L 300 273 L 200 100 z"/></svg>',
        triangleDown : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 400 400" fill="#ffffff"><path d="M 100 100 L 300 100 L 200 273 z"/></svg>',
        triangleLeft : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 400 400" fill="#ffffff"><path d="M 100 200 L 273 100 L 273 300 z"/></svg>',
        triangleRight : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 400 400" fill="#ffffff"><path d="M 127 100 L 300 200 L 127 300 z"/></svg>',
        chevronsUp : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 15l-6-6-6 6"/></svg>',
        chevronsDown : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M6 9l6 6 6-6"/></svg>',
        chevronsLeft : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6"/></svg>',
        chevronsRight : '<svg width="%s" height="%s" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18l6-6-6-6"/></svg>'
      }
    },
    cf: {
      /** SIP keyboard manager */
      SIPManager: {
        init: function () {
          if (ihmi.cf.isiPendant()) {
            var doc = document,
              div = doc.createElement("div");
            ihmi.cf.appendActiveXControl(div, "ECC1F43C-6B1E-4E74-AAED-62395D3597C1", "SIPManager", 1, 1);
            doc.body.appendChild(div);
            doc.getElementById("SIPManager").AutoDeployKeyboard = false;
          }
        },
        terminate: function () {
          if (ihmi.cf.isiPendant()) {
            document.getElementById("SIPManager").AutoDeployKeyboard = true;
          }
        },
        hideKeyboard: function () {
          var sipm = document.getElementById("SIPManager");
          if (sipm !== null) {
            sipm.HideKeyboard();
          }
        },
        showKeyboard: function () {
          var sipm = document.getElementById("SIPManager");
          if (sipm !== null) {
            sipm.ShowKeyboard();
          }
        }
      },
      /** Handle key event */
      KeyEvent: {
        handlers: [],
        addHandler: function (handler, frame, preventAfter) {
          var that = this;
          var eventType = ((getIEVersion_(userAgent) !== -1) && (getIEVersion_(userAgent) < 11)) ? "unload" : "pagehide";
          if (preventAfter) handler.preventAfter = true;
          if (frame) {
            handler.frameName = frame.webpage;
            ihmi.cf.addEventHandler(frame, eventType, function () {
              that.removeHandler(handler);
            });
          }
          this.handlers.push(handler);
        },
        popHandler: function () {
          this.handlers.pop();
        },
        addHandlers: function (handlers) {
          Array.prototype.push.apply(this.handlers, handlers);
        },
        removeHandlers: function (frame) {
          var oldHandlers = this.handlers,
            newHandlers = [],
            removedHandlers = [],
            frameName = frame.webpage,
            handler;
          for (var i = 0, len = oldHandlers.length; i < len; i++) {
            handler = oldHandlers[i];
            ((handler.frameName === frameName) ? removedHandlers : newHandlers).push(handler);
          }
          this.handlers = newHandlers;

          return removedHandlers;
        },
        removeHandler: function (handler) {
          var oldHandlers = this.handlers,
            newHandlers = [];
          for (var i = 0, len = oldHandlers.length; i < len; i++) {
            if (oldHandlers[i] !== handler) {
              newHandlers.push(oldHandlers[i]);
            }
          }
          this.handlers = newHandlers;
        },
        handle: function (event) {
          var handlers = ihmi.cf.KeyEvent.handlers,
            notHandled = true,
            handler;

          if (event.keyCode === 17) return notHandled;
          //    var message = [ihmi.cf.format("key:%s ctrl:%s shift:%s", event.keyCode, event.ctrlKey, event.shiftKey)];

          for (var i = handlers.length - 1; i >= 0 && notHandled; i--) {
            handler = handlers[i];
            notHandled = handler(event);
            //      message.push(ihmi.cf.format("%s: notHandled: %s", i, notHandled));
            if (handler.preventAfter) break;
          }
          //    if (window.console !== undefined) console.log(message.join("\n"));
          //    alert(message.join("\n"));
          if (notHandled === false) {
            if (event.preventDefault) {
              event.preventDefault();
            }
          }
          return notHandled;
        },
        attachHandlers: function (frame) {
          ihmi.cf.addEventHandler(frame.document, "keydown", this.handle);
        }
      },
      investigateEcho: function () {
        var url = window.location.href;

        if (url.indexOf("echo.stm") !== -1) {
          return true;
        } else {
          return false;
        }
      },
      /**
       * Return a function which is invoked after it stops bein called.
       * @param {Function} func Function to check the condition is met.
       * @param {Number} time Time interval.
       */
      debounce: function (func, time) {
        var timeoutId = null,
          context, args;
        var delayedFunc = function () {
          timeoutId = null;
          func.apply(context, args);
        };
        return function () {
          context = this;
          args = arguments;
          clearTimeout(timeoutId);
          timeoutId = setTimeout(delayedFunc, time);
        };
      },
      /**
       * Wait until the condition is met
       * @param {Function} cond Function to check the condition is met.
       * @param {Number} interval Time interval to check the condition.
       * @param {Number} maxCount Maximum number of times to check the condition.
       * @param {Function} body Function to be exected when the condtion is met.
       */
      waitUntil: function (cond, interval, maxCount, body) {
        if (cond()) {
          body();
        } else {
          if (maxCount <= 0) return;
          setTimeout(function () {
            ihmi.cf.waitUntil(cond, interval, maxCount - 1, body);
          }, interval);
        }
      },
      /**
       * Wait until all frames are loaded
       * @param {Array} frames frames to be checked whether it has been loaded.
       * @param {Function} body Function to be exected when the condtion is met.
       */
      waitFramesLoaded: function (frames, body) {
        var numFrames = frames.length,
          count = 0;

        var checkLoaded = function (event) {
          count++;
          if (count >= numFrames) {
            body();
            for (var i = 0; i < numFrames; i++) {
              ihmi.cf.removeEventHandler(frames[i], "load", checkLoaded);
            }
          }
        };

        for (var i = 0; i < numFrames; i++) {
          ihmi.cf.addEventHandler(frames[i], "load", checkLoaded);
        }
      },
      removeLastUndefined: function (array) {
        if (array[array.length - 1] === undefined) {
          array.pop();
        }
      },
      /** Get frame from top frame */
      getFrame: function (name) {
        return ihmi.cf.getFrame2(top, name);
      },
      /** Get frame from specified frame */
      getFrame2: function (rootFrame, name) {
        var frame = rootFrame,
          names = name.split('.');
        for (var i = 0, len = names.length; i < len; i++) {
          frame = frame[names[i]];
          if (!frame) return null;
          try { // Avoiding cross-origin frame access error
            if (frame.contentWindow) frame = frame.contentWindow;
          } catch (e) {
            return null;
          }
        }
        return frame;
      },
      /**
       * search for ancester window by specified count.
       * @param {Window} rootFrame From this window ancester is searched.
       * @param {Integler} ancestorCount popup position.
       */
      findAncestorFrame: function (rootFrame, ancestorCount) {
        var systemFames = ["home", "prim", "dual", "third"];
        var MAX_ANCESTOR_COUNT = 100;

        if ((ancestorCount === null) ||
            (ancestorCount === undefined) ||
            (ancestorCount == 0)) {
          return rootFrame;
        }

        if (ancestorCount === "top") {
          if (rootFrame.frameElement.tagName === "FRAME") {
            //not support upper prim in TP/CGTP/ECHO/ITP.
            ancestorCount = MAX_ANCESTOR_COUNT;
          } else {
            return top;
          }
        } else {
          ancestorCount = parseInt(ancestorCount, 10);
        }
        for (var candidate = rootFrame; ancestorCount > 0; ancestorCount--, candidate = candidate.parent) {
          for (var i = 0; i < systemFames.length; i++) {
            if (candidate.name === systemFames[i]) {
              return candidate;
            }
          }
          if (candidate === top) {
            break;
          }
        }
        return candidate;
      },
      /**
       * Convert raw URL to version URL.
       *  ex) http://ipaddress/frh/vision/page.htm?param1=value1&param2=value2#hash1#hash2
       */
      convertToVersionURL: function (url) {
        var version = "version=" + ihmi.global.version;
        if (url.indexOf('?') >= 0) {
          return url.replace(/\?/, '?' + version + '&');
        } else if (url.indexOf('#') >= 0) {
          return url.replace(/#/, '?' + version + '#');
        } else {
          return url + '?' + version;
        }
      },
      /** Convert version URL to raw URL. */
      convertToRawURL: function (url) {
        var parts = url.split('?');
        return parts[0];
      },
      /** Load specified page with version to frame. */
      loadVersionPage: function (frame, page) {
        if (!frame.location) frame = frame.contentWindow;
        frame.location = ihmi.cf.convertToVersionURL(page);
      },
      /** Get text from response.*/
      getResponseText: function (response) {
        if (typeof (response) === 'object') {
          return response.text ? response.text : response.firstChild.textContent;
        } else {
          return response;
        }
      },
      /** Load specified page to frame. If the page have been already loaded, it is refreshed.*/
      loadPage: function (frame, page) {
        if (frame.location.href.indexOf(page) == -1) {
          ihmi.cf.loadVersionPage(frame, page);
        } else {
          ihmi.cf.IUIFRequest(frame, { request: "refresh" }).send();
        }
      },
      /** make string replaced %s in fmt with arguments */
      format: function (fmt) {
        var i = 0;
        var args = arguments;
        return fmt.replace(/%s/g, function (word) {
          i++;
          return args[i];
        });
      },
      getIEVersion: function (userAgent) {
        var result = userAgent.match(/MSIE +([\d.]+);/);
        if (result === null) {
          result = userAgent.match(/rv:([\d.]+)/);
        }
        if (result !== null) {
          return parseFloat(result[1]);
        }
        return -1;
      },
      isOldIE: function() {
        var IEVersion = ihmi.cf.getIEVersion(window.navigator.userAgent);
        return (IEVersion > 0 && IEVersion < 10);
      },
      /** check if the browser is supported. */
      isSupportedBrowser: function (useIDC) {
        if (ihmi.cf.isiPendant()) return true;
        var userAgent = window.navigator.userAgent;
        var version = ihmi.cf.getIEVersion(userAgent);
        if (version < 0) return true; // not IE
        if (version < 7) return false;
        if (useIDC && userAgent.match(/\sWin64;/)) return false;
        return true;
      },
      /** attatch refresh function to the onload event for the specified frame */
      attachRefreshEvent: function (frame) {
        function refresh() {
          ihmi.cf.IUIFRequest(frame, { request: "refresh" }).send();
        }
        ihmi.cf.addEventHandler(frame, "load", refresh);
        ihmi.cf.KeyEvent.attachHandlers(frame);
      },
      /** Refresh and reveal frame */
      refreshAndReveal: function (frame) {
        ihmi.cf.IUIFRequest(frame, {
          request: "refresh"
        }).send(function (response){
          try {
            (function () {
              eval(ihmi.cf.getResponseText(response));
            })();
          } finally {
            var body = frame.document.body;
            body.tabIndex = -1;
            removeClass_(body, "hide");
          }
        });
      },
      /** attatch onclick event handler to the frame in CGTP window */
      attachCGTPClickEvent: function (frame, device, page) {
        addEventHandler_(frame.document.body, "click", function(event) {
          IUIFRequest_(window, {
            webpage: page,
            request: "focus",
            value: device
          }).send(function(response) {
            try {
              (function () {
                var top = window;// eslint-disable-line no-unused-vars
                eval(getResponseText_(response));
              })();
            } finally {
              // avoid the problem that soft keyboard does not appear.
              ihmi.global.selectedTextbox = null;
            }
          });
          return true;
        });
      },
      /* rowInvalidof */
      showNotification: function(frame, notifyInfo, appendString) {
        var divElem = frame.document.getElementById("tableNotify");
        var lblElem;
        var tdIcon;
        var imgElem;
        var setLabelText = function(labelElem, text) {
          if (labelElem) {
            labelElem.innerHTML = text;
          }
        };

        if (divElem) {
          if (!notifyInfo) {
            addClass_(divElem, "hide");
          } else {
            removeClass_(divElem, "hide");
            if (notifyInfo.desc) {
              lblElem = frame.document.getElementById("notifyLabel");
              if (appendString) {
                setLabelText(lblElem, notifyInfo.desc + " " + appendString);
              } else {
                setLabelText(lblElem, notifyInfo.desc);
              }
            }
            if (notifyInfo.image) {
              tdIcon = frame.document.getElementById("tdNotifyIcon");
              if (tdIcon) {
                imgElem = frame.document.getElementById("imgNotify");
                if (imgElem) {
                  imgElem.src = notifyInfo.image;
                  imgElem.style.display = 'inline';
                }
              }
            }
          }
        }
      },
      /** get Body or Html Object */
      getScrollingElem: function (frmMain) {
        var doc = frmMain.document;
        //          scrollingElement documentElement body
        // chrome61 OK               OK              0
        // chrome60 OK               0               OK
        // IE       undef            OK              0
        // Edge     OK               0               OK
        if ('scrollingElement' in doc) {
          return doc.scrollingElement;
        }
        // Fallback for legacy browsers
        if (navigator.userAgent.indexOf('WebKit') != -1) {
          return doc.body;
        }
        return doc.documentElement;
      },
      /** Check if the object is Window */
      isWindow: function (object) {
        return (object != null) && (typeof object === 'object') && ('self' in object);
      },
      /** Check if the frame still exists. */
      isFrameExist: function (frame) {
        var currFrame = frame;
        while (currFrame != window && currFrame != currFrame.parent) {
          currFrame = currFrame.parent;
        }
        return (currFrame == window); // Do not use !== for this checking.
      },
      /**
       * add event handlers to 'divTabBegin' and 'divTabEnd' to avoid IE bug that
       * focus can be out of range in which key event can be handled.
       */
      initTabBeginEnd: function (frame) {
        var skipped = false,

          doc = frame.document,
          divTabBegin = doc.getElementById('divTabBegin'),
          divTabEnd = doc.getElementById('divTabEnd');

        attachHandlersToSkip(divTabBegin, divTabEnd, true);
        attachHandlersToSkip(divTabEnd, divTabBegin, false);

        function attachHandlersToSkip(targetNode, nextNode, skipUp) {
          addEventHandler_(targetNode, "focus", function(event) {
            if (skipped) {
              skipped = false;
            } else {
              skipped = true;
              nextNode.focus();
            }
            return true;
          });
          addEventHandler_(targetNode, "keydown", function (event) {
            if (event.keyCode === 9 && event.shiftKey === skipUp) {
              skipped = true;
              nextNode.focus();
              return false;
            }
            return true;
          });
        }
      },
      /**
       * Insert child node before iframe "divTabEnd"
       * @param {Node} parentNode The node to which child node is appended
       * @param {Node} childNode The node which is appended to parent node
       */
      insertBeforeTabEnd: function (parentNode, childNode) {
        var divTabEnd = null;
        if (parentNode.tagName === 'BODY') {
          divTabEnd = parentNode.ownerDocument.getElementById("divTabEnd");
        }
        if (divTabEnd !== null) {
          parentNode.insertBefore(childNode, divTabEnd);
        } else {
          parentNode.appendChild(childNode);
        }
      },
      /**
       * Append iframe to the specified frame
       * @param {Window or Node} object The object on which message frame is appended
       * @param {String} page The page URL
       * @param {String} className The class name defineing frame position and size
       * @param {Function} initialize The function to initialize the message frame
       * @param {Boolean} addOverlay If true, adds an overlay.
       * @return IFrame
       */
      appendFrame: function (object, page, className, initialize, addOverlay) {
        var doc, parentNode, div, iframe, overlayDiv, overlayClass;
        var array = [];

        if (ihmi.cf.isWindow(object)) {
          doc = object.document;
          parentNode = doc.body;
        } else {
          doc = object.ownerDocument;
          parentNode = object;
        }

        div = doc.createElement('div');
        div.style.zIndex = 9999;
        div.className = className;

        iframe = doc.createElement('iframe');
        //AutoTest comment
        iframe.src = ihmi.cf.convertToVersionURL(page);
        iframe.scrolling = "no";
        iframe.frameBorder = "0";
        if (ihmi.global.isModernBrowser) {
          iframe.onload = function () {
            if (typeof initialize === "function") initialize(this);
            ihmi.cf.KeyEvent.attachHandlers(this.contentWindow);
            this.onload = null;
          };
        } else {
          iframe.onreadystatechange = function () {
            if (this.readyState === "complete") {
              if (typeof initialize === "function") initialize(this);
              ihmi.cf.KeyEvent.attachHandlers(this.contentWindow);
              this.onreadystatechange = null;
            }
          };
        }
        div.appendChild(iframe);
        if (addOverlay) {
          // If the pop-up display target scrolls, expand the overlay to the scrolling destination."
          overlayDiv = doc.createElement('div');
          overlayClass =  "popup-background";
          if (isiPendant_()) {
            overlayClass += " ihcp-ipendant";
          }
          overlayDiv.className = overlayClass;
          overlayDiv.style.zIndex = "-1"; // to bring the layer down from the popup box.
          div.appendChild(overlayDiv);
        }
        ihmi.cf.insertBeforeTabEnd(parentNode, div);
        array.push(iframe.contentWindow);
        return iframe;
      },
      /**
       * Remove iframe
       * @param {IFrame} iframe The iframe removed
       */
      removeFrame: function (iframe) {
        if (ihmi.global.isiPad) {
          //Adjusted the frame delete time so that the click event for the element behind the overlay does not occur when the popup is closed. (ios  only)
          setTimeout(function () {
            removeFrameLocal(iframe);
          }, 10);
        } else {
          removeFrameLocal(iframe);
        }
        function removeFrameLocal(iframe) {
          var div = iframe.parentNode;
          var overlay = findDescendant_(div, "div", "popup-background");
          if (!iframe.contentWindow) {
            return;
          }
          iframe.contentWindow.close();
          iframe.src = "";
          div.removeChild(iframe);
          if (overlay) {
            div.removeChild(overlay);
          }
          div.parentNode.removeChild(div);
        }
      },
      /*
      isIDCShown: function(frame) {
        if (frame && frame.ctlImageDisplay1) {
          return !frame.isIDCHidden();
        }
        return false;
      },
      */
      bindEnterToClickEvent: function (id, frame) {
        ihmi.cf.KeyEvent.addHandler(function (event) {
          if (event.keyCode === 13) {
            frame.document.getElementById(id).click();
            return false;
          }
          return true;
        }, frame, false);
      },
      /** Key handler to block key event occured on a popup frame. */
      blockKeysPopupFrame: function (event) {
        switch (event.keyCode) {
          case 9: // up or down (PC Tab)
          case 33: // shift + up (PC PageUp)
          case 34: // shift + down (PC PageDown)
          case 38: // keyboard up or shift-up
          case 40: // keyboard down or shift-down
          case 13: // enter
          case 32: // space
            return false;
          default:
            return true;
        }
      },
      findFunckey: function (frame) {
        var divTags = frame.document.getElementsByTagName('DIV');
        for (var i = 0; i < divTags.length; i++) {
          if (ihmi.cf.hasClass(divTags[i], "func-keys")) {
            return true;
          }
        }
        return false;
      },
      changePopupDesign: function (frame, customizeObj) {
        var contentsMsg;
        var closeBtn = frame.doc.getElementById("closeBtn");
        var popupBody;
        var popupContentsArea;
        if (customizeObj) {
          if (customizeObj.designpattern === "mouse") {
            contentsMsg = frame.doc.getElementById("contentsMessage");
            if (contentsMsg !== null) {
              ihmi.cf.addClass(contentsMsg, "mouse");
            }
            closeBtn = frame.doc.getElementById("closeBtn");
            if (closeBtn !== null) {
              ihmi.cf.replaceClass(closeBtn, "touch", "mouse");
              closeBtn.refresh(null, null, "ihmicomponent-popup-exit-s", null, false);
            }
            popupBody = ihmi.cf.findDescendant(frame.doc, "body", "popup-body");
            if (popupBody !== null) {
              ihmi.cf.replaceClass(popupBody, "touch", "mouse");
            }
            popupContentsArea = ihmi.cf.findDescendant(frame.doc, "div", "popup-contents-area");
            if (popupContentsArea !== null) {
              ihmi.cf.addClass(popupContentsArea, "mouse");
            }
          }
          if (customizeObj.hideCloseBtn === true) {
            ihmi.cf.addClass(closeBtn, "hide");
          }
        }
      },
      adjustPopupHeader: function (frame, customizeObj) {
        var headerMsg = frame.doc.getElementById("headerMessage");
        var popupBody = ihmi.cf.findDescendant(frame.doc, "body", "popup-body");
        var header;
        var helpLink;
        var helpLinkOptionObj = {};
        if (customizeObj == undefined) {
          return;
        }
        header = customizeObj.header;
        if ((header == undefined) || (header === "")) {
          return;
        }
        headerMsg.refresh(header, null, false);
        ihmi.cf.addClass(popupBody, "popup-has-header");

        if (typeof customizeObj.headerHelpLinkCb === 'function') {
          helpLink = frame.doc.getElementById("ihcpHeaderHelpLink");
          if (customizeObj.designpattern === "mouse") {
            helpLinkOptionObj.designpattern = "mouse";
            helpLink.refresh(false, helpLinkOptionObj);
          }
          helpLink.onclick = function () {
            customizeObj.headerHelpLinkCb(customizeObj.headerHelpLinkCbArg);
          };
          ihmi.cf.removeClass(helpLink, "hide");
        }
        setWidthPopupHeader();
        function setWidthPopupHeader() {
          var headerBox = ihmi.cf.findDescendant(frame.doc, "div", "popup-header-box");
          var headerLabel = ihmi.cf.findDescendant(headerBox, "label", "popup-label-header");
          var headerBtn = ihmi.cf.findDescendant(headerBox, "button", "close-button");
          var helpLink = ihmi.cf.findDescendant(headerBox, "a", "help-link");
          var helpLinkWidth = (helpLink !== null) ? getWidth_(helpLink) : 0; // for IE & width=**%(need to use getWidth)
          var headerBtnStyle = ihmi.cf.getCurrentStyle(headerBtn);
          var labelPosTop = 0;
          var headerLabelHeight = 0;
          var isHeaderOver = false;
          var sideArea = 0;
          var headerLabelStyle = ihmi.cf.getCurrentStyle(headerLabel);
          var MIN_FONT_SIZE = 16;
          var rightSpace = parseInt(headerBtnStyle.right);
          var elemFontSize = 0;

          if (ihmi.cf.isOldIE()) { // if browser is IE9 or lower, flex is not available.
            ihmi.cf.addClass(headerBox, "ihcp-regacy");
            labelPosTop = 20;
          }
          if (headerLabel.origin === undefined) { //set default font size
            headerLabel.origin = {};
            headerLabel.origin.fontSize = parseInt(headerLabelStyle.fontSize, 10);
          }
          elemFontSize = headerLabel.origin.fontSize;
          sideArea = (headerBtn.offsetWidth + rightSpace + helpLinkWidth) * 2;
          headerLabel.style.maxWidth = headerBox.offsetWidth - sideArea + 'px';
          headerLabel.style.fontSize = elemFontSize + 'px';
          headerLabelHeight = headerLabel.offsetHeight + labelPosTop;
          isHeaderOver = (headerBox.offsetHeight < headerLabelHeight);

          // Lines are wrapping up.
          while (isHeaderOver &&
                (MIN_FONT_SIZE < elemFontSize)) {
            elemFontSize -= 1;
            headerLabel.style.fontSize = elemFontSize + 'px';
            headerLabelHeight = headerLabel.offsetHeight + labelPosTop;
            isHeaderOver = (headerBox.offsetHeight < headerLabelHeight);
          }
        }
      },
      //divide css paramter numeric + unit.
      //ex conv "10%" to "10","%" / 10 to "10","px"
      divideNumUnit: function (param) {
        var dividResult = {};
        var matchResult;
        if (param === null || param === undefined) {
          return null;
        }
        if (typeof param == 'number') {
          dividResult.num = param;
          dividResult.unit = "px";
          return dividResult;
        }

        matchResult = param.match(/([\d.]+)(\D*)/);
        if ((matchResult === null) || (matchResult[1] === null)) {
          return null;
        }

        if ((matchResult[2] === null) && (matchResult[1] != 0)) {
          //not specified unit, add px.
          matchResult[2] = "px";
        } else {
          //specified unit. Remove symbols (except %) and spaces within the unit.
          // ex ' %;' -> '%'  popup bug report #26
          matchResult[2] = matchResult[2].replace(/[^\w%]+/g, '');
        }

        dividResult.num = matchResult[1];
        dividResult.unit = matchResult[2];
        return dividResult;
      },
      popupMessage: function (frmMain, messageId, refresh, create, buttonHandle, funcKeyHandle, customizeObj) {
        var setCallbackCloseBtn = true;
        var dispMsg = {};
        var createDispMsg = {};
        var distFrameName = (frmMain.name == undefined) ? "undef": frmMain.name;
        var timeoutId = null; // Used as Closure
        var bodyOrHtml = ihmi.cf.getScrollingElem(frmMain);
        var eventType = ((getIEVersion_(userAgent) !== -1) && (getIEVersion_(userAgent) < 11)) ? "unload" : "pagehide";
        if (customizeObj.popupFile && (null !== customizeObj.popupFile.match(/ihcppopupfrm.stm/))) {
          setCallbackCloseBtn = false;
        }
        if (frmMain === null) return;
        if (messageId !== null) { // messageId is null, call from helpMessage().
          for (var i = 0; i < ihmi.global.popupMessage.length; i++) {
            dispMsg = ihmi.global.popupMessage[i];
            if ((dispMsg.distFrmName === distFrameName) && (dispMsg.message === messageId)) {
              return; // Aleady disped.
            }
          }
        }

        var initialize = function (iframe) {
          var frame = iframe.contentWindow,
            doc = frame.document,
            exists = false,
            onclickFuncKey, onclickBtn, elemBtn, elemFuncKey, tabIndex, dividResultWidth, changeBtnWidth, funcKeyParam, existsPopup;

          if (typeof customizeObj.getRemoveFuncCb === "function") {
            customizeObj.getRemoveFuncCb(function removePopup() {
              ihmi.cf.removeFrame(iframe);
            });
          }
          if (messageId !== null) {
            clearTimeout(timeoutId);
            for (var j = 0; j < ihmi.global.popupMessage.length; j++) {
              dispMsg = ihmi.global.popupMessage[j];
              if (dispMsg.timeoutId === timeoutId) {
                exists = true;
                break;
              }
            }
            if (!exists) { // after the timeout, load complete.
              ihmi.global.popupMessage.push(createDispMsg);
            }
          }

          onclickBtn = function (id, type) {
            var elem = doc.getElementById(id);
            var page = ihmi.cf.getDefaultView(elem.ownerDocument).webpage;
            setTimeout(function () {
              buttonHandle(iframe, page, id, type);
            }, 0);
          };

          if (typeof funcKeyHandle === 'function') {
            onclickFuncKey = function (type, page, name, label) {
              setTimeout(function () {
                funcKeyHandle(iframe, page, name, label, type);
              }, 0);
            };
          }

          if (customizeObj.popupFile && (null !== customizeObj.popupFile.match(/ihmipopupalrt.stm|ihmipopupfkalrt.stm|ihmipopupcnfm.stm|ihmipopupfkcnfm.stm/))) {
            //for alertMessage(), confirmMessagge()
            if (customizeObj.selectBtn && customizeObj.selectBtn.width) {
              //change select btn width
              dividResultWidth = ihmi.cf.divideNumUnit(customizeObj.selectBtn.width);
              if (dividResultWidth !== null) {
                changeBtnWidth = dividResultWidth.num + dividResultWidth.unit;
              }
            }
            for (var i = 1; i <= 5; i++) {
              if (customizeObj.selectBtn && customizeObj.selectBtn[i] && customizeObj.selectBtn[i].label) {
                elemBtn = doc.getElementById('btn' + i);
                if (elemBtn) {
                  if (changeBtnWidth !== undefined) {
                    elemBtn.style.width = changeBtnWidth;
                  }
                  elemBtn.refresh(customizeObj.selectBtn[i].label, null, null, null, false, null);
                  top.IHMIComponents.cf.removeClass(elemBtn, "hide");
                  elemBtn.setCallback(onclickBtn);
                  if (customizeObj.designpattern === "mouse") {
                    ihmi.cf.replaceClass(elemBtn, "touch", "mouse");
                  }
                }
              }

              elemFuncKey = doc.getElementById('F' + i);
              if (elemFuncKey) {
                if (customizeObj.selectFuncKey && customizeObj.selectFuncKey[i] && customizeObj.selectFuncKey[i].label) {
                  //refresh funcKey
                  funcKeyParam = customizeObj.selectFuncKey[i];
                  elemFuncKey.refresh(funcKeyParam, null, false, null);
                }
                elemFuncKey.setCallback(onclickFuncKey);
              }
            }
          }
          if (setCallbackCloseBtn) {
            if (doc.getElementById('closeBtn')) {
              doc.getElementById('closeBtn').setCallback(onclickBtn);
            }
          }

          if ((customizeObj.callerWindowObj) &&
              (frmMain !== customizeObj.callerWindowObj)) {
            //If the stm that calls the popup window unloads, remove the popup.
            ihmi.cf.addEventHandler(customizeObj.callerWindowObj, eventType, function () {
              existsPopup = ihmi.cf.findDescendant(frmMain.document, "div", "popup-frame");
              if (existsPopup) {
                ihmi.cf.removeFrame(iframe);
              }
            });
          }

          //change designpattern to mouse
          ihmi.cf.changePopupDesign(frame, customizeObj);

          refresh(frame);
          ihmi.cf.addEventHandler(frame, eventType, function () {
            if (messageId !== null) {
              removePopupMsgListBytimeoutId(timeoutId);
            }
            if (frmMain.frameElement !== null) {
              frmMain.frameElement.tabIndex = tabIndex;
            }
          });

          if (frame.document.getElementById('divTabBegin') !== null) {
            ihmi.cf.initTabBeginEnd(frame);
          }

          if (frmMain.frameElement !== null) {
            tabIndex = frmMain.frameElement.tabIndex;
            frmMain.frameElement.tabIndex = "-1";
          }
        };

        if (messageId !== null) {
          //For cases where screen transitions occur before popup loading is complete.
          timeoutId = setTimeout(function () {
            removePopupMsgListBytimeoutId(timeoutId);
          }, 3000);
          createDispMsg.timeoutId = timeoutId;
          createDispMsg.distFrmName = distFrameName;
          createDispMsg.message = messageId;
          ihmi.global.popupMessage.push(createDispMsg);
        }

        // init and save the scroll position of the popup display window.
        customizeObj.initDistScrollLeft = bodyOrHtml.scrollLeft; // Save the scroll position before displaying a popup.
        customizeObj.initDistScrollTop = bodyOrHtml.scrollTop; // Save the scroll position before displaying a popup.(on iOS12, scrollTop is 0)
        bodyOrHtml.scrollLeft = 0; // When displaying a popup, set the scroll position to the LLeft.
        bodyOrHtml.scrollTop = 0; // When displaying a popup, set the scroll position to the top.

        create(initialize);

        function removePopupMsgListBytimeoutId (targetTimeoutId) {
          for (var i = 0; i < ihmi.global.popupMessage.length; i++) {
            dispMsg = ihmi.global.popupMessage[i];
            if (dispMsg.timeoutId === targetTimeoutId) {
              ihmi.global.popupMessage.splice(i, 1);
            }
          }
        }
      },
      /**
       * Display user specified message.
       * @param {String} message The message displayed in popup window.
       * @param {null} argEmpty this arg is empty.
       * @param {Function} callback The callback function called when message frame is removed.
       * @param {WindowObject} frmMain The frmMain is insertion position of popup.
       * @param {Object} customizeObj customize popup
       *   @param {String} popupFrmAddClass : add class to popup frame.
       *   @param {Boolean} addFuncKey : if specified true, add funcKey component.
       *   @param {Boolean} errPopWindowAlert : specify true when using window.alert().
       *   @param {Boolean} hideCloseBtn : specify true when hide close button.
       *   @param {Object} headerHelpLinkCb : add helpLink on header. call back funtion.
       *   @param {Object} headerHelpLinkCbArg : add helpLink on header. call back argment.
       */
      alertMessage: function (message, argEmpty, callback, frmMain, customizeObj) {
        var refresh;
        var create;
        var buttonHandle;
        var funcKeyHandle;
        var iframe;
        argEmpty = null;//empty

        if (!ihmi.cf.isWindow(frmMain)) {
          return;
        }
        if ((customizeObj === null) || (customizeObj === undefined)) {
          customizeObj = {};
        }

        if (true === customizeObj.errPopWindowAlert) {
          alert(message);
          return;
        }

        refresh = function (frame) {
          var popupContentsArea = ihmi.cf.findDescendant(frame.doc, "div", "popup-contents-area");
          var contentsMsgElem = frame.doc.getElementById("contentsMessage");
          var headerBox = ihmi.cf.findDescendant(frame.doc, "div", "popup-header-box");
          var CONTENTS_PADDING = 8;
          var offsetTop;
          var msgPosShiftUpper;//if no scroll, shift upper;
          var isHTML = false;
          var popupBoxFrame;

          isHTML = ihmi.cf.parseStrToBoolean(customizeObj.isHTML);
          contentsMsgElem.refresh(message, null, false, isHTML);
          ihmi.cf.adjustPopupHeader(frame, customizeObj);
          if (!ihmi.global.isModernBrowser) {
            popupBoxFrame = ihmi.cf.findDescendant(frame.doc, "div", "popup-box-frame");
            //not used calc .popup-contents-area
            popupContentsArea.style.height = popupBoxFrame.offsetHeight - headerBox.offsetHeight + "px";
          }
          offsetTop = (popupContentsArea.clientHeight - contentsMsgElem.offsetHeight - CONTENTS_PADDING*2) / 2;
          if (offsetTop > 0) {
            //no overflow
            msgPosShiftUpper = headerBox.offsetHeight / 2;
            if (offsetTop - msgPosShiftUpper > 0) {
              offsetTop -= msgPosShiftUpper;//shift upper
            }
            contentsMsgElem.style.marginTop = offsetTop + "px";
          }
          ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "init");
          ihmi.cf.addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
            try {
              ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "resize");
            } catch (e) {
              return;
            }
          }, 200));
        };
        create = function (initialize) {
          var addClass = "popup-frame";
          var popupFile = "/frh/ihmi/ihmipopupalrt.stm";

          if (ihmi.global.isTablet) {
            addClass += " touch";
          } else {
            addClass += " mouse";
          }

          if (customizeObj.popupFrmAddClass) {
            addClass += " " + customizeObj.popupFrmAddClass;
          }
          if (customizeObj.errPopAddFuncKey || customizeObj.addFuncKey) {
            popupFile = "/frh/ihmi/ihmipopupfkalrt.stm";
            addClass += " fk-popup";
          }
          customizeObj.popupFile = popupFile;
          iframe = ihmi.cf.appendFrame(frmMain, popupFile, addClass, initialize, true);
          iframe.allowTransparency = true;
        };

        //popupbutton and closebutton
        buttonHandle = function (iframe, page, id, type) {
          ihmi.cf.removeFrame(iframe);
          if (typeof callback === 'function') {
            callback(id, type);
          }
        };

        funcKeyHandle = function (iframe, page, name, label, type) {
          ihmi.cf.removeFrame(iframe);
          if (typeof callback === 'function') {
            callback(type, page, name, label);
          }
        };
        ihmi.cf.popupMessage(frmMain, message, refresh, create, buttonHandle, funcKeyHandle, customizeObj);
      },
      /**
       * Confirm with user specified message.
       * @param {String} webpage The webpage name from which confirm event is fired.
       * @param {String} message The message displayed in popup window
       * @param {String} id The id to be used as request parameter
       * @param {Number} value The value that is sent back arg
       * @param {Function} refresh The function to initialize popup button and function keyes
       * @param {WindowObject} frmMain The frmMain is insertion position of popup.
       * @param {Function} callbackBtn function called when message frame is removed.(for popup button)
       * @param {Function} callbackFuncKey function called when message frame is removed.(for funcKey)
       * @param {Object} customizeObj customize popup
       *    @param {String} popupFrmAddClass : add class to popup frame.
       *    @param {Boolean} addFuncKey : if specified true, add funcKey component.
       *    @param {Boolean} hideCloseBtn : specify true when hide close button.
       *    @param {Object} headerHelpLinkCb : add helpLink on header. call back funtion.
       *    @param {Object} headerHelpLinkCbArg : add helpLink on header. call back argment.
       */
      confirmMessage: function (webpage, message, id, value, refresh, frmMain, callbackBtn, callbackFuncKey, customizeObj) {
        var messageId = ihmi.cf.format("%s&%s&%s", webpage, id, value || "");
        var refreshAll;
        var create;
        var buttonHandle;
        var funcKeyHandle;
        var iframe;
        var CONTENTS_PADDING = 8;

        if (!ihmi.cf.isWindow(frmMain)) {
          return;
        }
        if ((customizeObj === null) || (customizeObj === undefined)) {
          customizeObj = {};
        }

        refreshAll = function (frame) {
          var popupMsgArea = ihmi.cf.findDescendant(frame.doc, "div", "popup-label-frame-confirm");
          var contentsMsgElem = frame.doc.getElementById("contentsMessage");
          var headerBox = ihmi.cf.findDescendant(frame.doc, "div", "popup-header-box");
          var popupSelectBtns;
          var offsetTop;
          var buttons;
          var hasSelectButton = false;
          var msgPosShiftUpper;//if no scroll, shift upper;
          var isHTML = false;
          var popupBoxFrame;
          var popupContentsArea;

          isHTML = ihmi.cf.parseStrToBoolean(customizeObj.isHTML);

          contentsMsgElem.refresh(message, null, false, isHTML);
          if (typeof refresh === 'function') {
            refresh(frame);
          }
          ihmi.cf.adjustPopupHeader(frame, customizeObj);
          if (!ihmi.global.isModernBrowser) {
            popupBoxFrame = ihmi.cf.findDescendant(frame.doc, "div", "popup-box-frame");
            popupContentsArea = ihmi.cf.findDescendant(frame.doc, "div", "popup-contents-area");
            //not used calc .popup-contents-area
            popupContentsArea.style.height = popupBoxFrame.offsetHeight - headerBox.offsetHeight + "px";
          }

          buttons = ihmi.cf.findDescendants(ihmi.cf.nextElementNode(popupMsgArea), 'button', 'button');
          for (var i = 0, len = buttons.length - 1; i < len; i++) {
            if (!ihmi.cf.hasClass(buttons[i], 'hide')) {
              hasSelectButton = true;
              buttons[i].style.verticalAlign = "middle";
            }
          }
          if (!hasSelectButton) {
            popupMsgArea.style.height = "95%";
          }
          offsetTop = (popupMsgArea.offsetHeight - contentsMsgElem.offsetHeight - CONTENTS_PADDING*2) / 2;
          if (offsetTop > 0) {
            //no overflow
            msgPosShiftUpper = headerBox.offsetHeight / 2;
            if ((offsetTop - msgPosShiftUpper > 0) && !hasSelectButton) {
              offsetTop -= msgPosShiftUpper;
            }
            contentsMsgElem.style.marginTop = offsetTop + "px";
          } else {
            //overflow
            popupSelectBtns = ihmi.cf.findDescendant(frame.doc, "div", "popup-button-wrapper");
            ihmi.cf.addClass(popupSelectBtns, 'popup-contents-overflow');
          }

          ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "init");
          ihmi.cf.addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
            try {
              ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "resize");
            } catch (e) {
              return;
            }
          }, 200));
        };
        create = function (initialize) {
          var addClass = "popup-frame";
          var popupFile = "/frh/ihmi/ihmipopupcnfm.stm";
          if (customizeObj.designpattern === "mouse") {
            addClass += " mouse";
          } else {
            addClass += " touch";
          }

          if (customizeObj.popupFrmAddClass) {
            addClass += " " + customizeObj.popupFrmAddClass;
          }

          if (customizeObj.addFuncKey) {
            popupFile = "/frh/ihmi/ihmipopupfkcnfm.stm";
            addClass += " fk-popup";
          }
          customizeObj.popupFile = popupFile;
          iframe = ihmi.cf.appendFrame(frmMain, popupFile, addClass, initialize, true);
          iframe.allowTransparency = true;
        };

        //popupbutton and closebutton
        buttonHandle = function (iframe, page, id, type) {
          var frame = getDefaultView_(iframe.ownerDocument);
          if (typeof callbackBtn === 'function') {
            callbackBtn(id, type, value);
          } else {
            IUIFRequest_(frame, { webpage: page, request: id + "." + type }).send();
          }

          ihmi.cf.removeFrame(iframe);
        };

        funcKeyHandle = function (iframe, page, name, label, type) {
          var frame = getDefaultView_(iframe.ownerDocument);
          if (typeof callbackFuncKey === 'function') {
            callbackFuncKey(type, page, name, label, value);
          } else {
            IUIFRequest_(frame, { webpage: page, request: name + '.' + type, value: value }).send();
          }
          ihmi.cf.removeFrame(iframe);
        };
        ihmi.cf.popupMessage(frmMain, messageId, refreshAll, create, buttonHandle, funcKeyHandle, customizeObj);
      },
      /**
       * append Wizard Page Frame.
       * @param {String} contensPage The contensPage is contents in wizard frame.
       * @param {Function} callback The callback function called when popup frame is removed.
       * @param {WindowObject} frmMain The frmMain is insertion position of popup.
       * @param {Object} customizeObj customize popup
       *   @param {Boolean} addHeader : add popup header.
       *   @param {Boolean} hideCloseBtn : specify true when hide close button.
       *   @param {Integer/String} popupPos : specify layers to put out.
       *   @param {String} popupFrmAddClass : add class to popup frame.
       *   @param {Object} appendArg : argument from caller to popup.
       *   @param {Object} headerHelpLinkCb : add helpLink on header. call back funtion.
       *   @param {Object} headerHelpLinkCbArg : add helpLink on header. call back argment.
       */
      appendPopupFrm: function (contensPage, callback, frmMain, customizeObj) {
        var refresh;
        var create;
        var buttonHandle;
        var iframe;
        var popupFile = "/frh/ihmi/ihcppopupfrm.stm";
        if (!ihmi.cf.isWindow(frmMain)) {
          return;
        }
        if ((customizeObj === null) || (customizeObj === undefined)) {
          customizeObj = {};
        }
        customizeObj.popupFile = popupFile;

        refresh = function (frame) {
          var headerBox = ihmi.cf.findDescendant(frame.doc, "div", "popup-header-box");
          var contents = frame.document.getElementById("ihcpPopupContents");
          var popupBoxFrame = ihmi.cf.findDescendant(frame.doc, "div", "popup-box-frame");
          var changeBoxWidth;
          var changeBoxHeight;
          var dividResultWidth;
          var dividResultHeight;
          var ihcpPopupFrmElem;

          //box size
          if (customizeObj.width) {
            dividResultWidth = ihmi.cf.divideNumUnit(customizeObj.width);
            if (dividResultWidth !== null) {
              customizeObj.width = dividResultWidth.num + dividResultWidth.unit;
              popupBoxFrame.style.width = customizeObj.width;
              changeBoxWidth = dividResultWidth.num;
            }
          }
          if (customizeObj.height) {
            dividResultHeight = ihmi.cf.divideNumUnit(customizeObj.height);
            if (dividResultHeight !== null) {
              customizeObj.height = dividResultHeight.num + dividResultHeight.unit;
              popupBoxFrame.style.height = customizeObj.height;
              changeBoxHeight = dividResultHeight.num;
            }
          }
          //set elem to js global variable.
          ihcpPopupFrmElem = frame.doc.getElementById('ihcpPopupFrm');
          frame.ihcpPopupFrm = ihcpPopupFrmElem;//js global variable.
          ihmi.cf.initComponents(frame.document, 'popupFrm', 'ihcpPopupFrm', {});

          if (typeof callback === 'function') {
            frame.ihcpPopupFrm.config.removeCallback = callback;
          }
          if (customizeObj.appendArg) {
            frame.ihcpPopupFrm.config.appendArg = customizeObj.appendArg;
          }
          if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
            ihmi.cf.removeClass(popupBoxFrame, "ihcp-vis-hidden");//if not exec this, no rendering on IE7.
          }
          contents.src = ihmi.cf.convertToVersionURL(contensPage);
          if (ihmi.global.isModernBrowser) {
            contents.onload = function () {
              loadedFunc();
              this.onload = null;
            };
          } else {
            contents.onreadystatechange = function () {
              if (this.readyState === "complete") {
                loadedFunc();
                this.onreadystatechange = null;
              }
            };
          }
          function loadedFunc() {
            var scrollElem = ihmi.cf.getScrollingElem(contents.contentWindow);
            var TOLERANCE = 2;//for hide scroll bar
            var popupContentsArea = ihmi.cf.findDescendant(frame.doc, "div", "popup-contents-area");

            ihmi.cf.adjustPopupHeader(frame, customizeObj);
            if (typeof customizeObj.refreshFunc === 'function') {
              // set arg (popup contents window, popup handler)
              customizeObj.refreshFunc(contents.contentWindow, frame.ihcpPopupFrm);
            }
            if (changeBoxWidth === undefined) {
              if (popupBoxFrame.offsetWidth < scrollElem.scrollWidth) {
                //content iframe width
                popupBoxFrame.style.width = scrollElem.scrollWidth + TOLERANCE + "px";
              }
            }
            if (changeBoxHeight === undefined) {
              if ((popupBoxFrame.offsetHeight - headerBox.offsetHeight) < scrollElem.scrollHeight) {
                //content iframe height
                popupBoxFrame.style.height = scrollElem.scrollHeight + headerBox.offsetHeight + TOLERANCE +"px";
              }
            }
            if (!ihmi.global.isModernBrowser) {
              //can't used calc() .popup-contents-area
              popupContentsArea.style.height = popupBoxFrame.offsetHeight - headerBox.offsetHeight + "px";
            }
            // use refreshFrame()
            frame.ihcpPopupFrm.config.distFramMain = frmMain;
            frame.ihcpPopupFrm.config.popupFrameMain = frame;
            frame.ihcpPopupFrm.config.popupIframe = iframe;
            frame.ihcpPopupFrm.config.customizeObj = customizeObj;
            ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "init");
            ihmi.cf.addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
              try {
                ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "resize");
                ihmi.cf.adjustPopupHeader(frame, customizeObj);
              } catch (e) {
                return;
              }
            }, 200));

            if (!customizeObj.hideBox) {
              ihmi.cf.removeClass(popupBoxFrame, "ihcp-vis-hidden");
              ihmi.cf.firstElementNode(popupBoxFrame).focus();
            }
          }
        };
        create = function (initialize) {
          var addClass = "popup-frame";

          if (ihmi.global.isTablet) {
            addClass += " touch";
          } else {
            addClass += " mouse";
          }

          if (customizeObj.popupFrmAddClass) {
            addClass += " " + customizeObj.popupFrmAddClass;
          }

          iframe = ihmi.cf.appendFrame(frmMain, popupFile, addClass, initialize, true);
          iframe.allowTransparency = true;
        };
        ihmi.cf.popupMessage(frmMain, null, refresh, create, buttonHandle, null, customizeObj);
      },
      /**
       * append Wizard Page Frame.
       * @param {String} wizardPages The wizardPages is contents in wizard frame.
       * @param {Function} callback The callback function called when message frame is removed.
       * @param {Object} callerWindowObj The callerWindowObj is caller window obj.
       * @param {Object} customizeObj customize popup
       *    @param {Integer/String} popupPos : specify layers to put outt.
       *    @param {String} popupFrmAddClass : add class to popup frame.
       *    @param {Object} appendCbArg : argument from caller to popup.
       */
      appendWizardFrm: function (wizardPages, callback, callerWindowObj, customizeObj) {
        var refresh;
        var initialize;
        var iframe;
        var tabIndex;
        var frmMain = callerWindowObj;
        var popupFile = "/frh/ihmi/ihcpwizardpagefrm.stm";
        var WIZARD_FRAME_DIV_CLASS = "popup-frame";//same as popup.
        var addClass = WIZARD_FRAME_DIV_CLASS;

        if (!ihmi.cf.isWindow(frmMain)) {
          return;
        }
        if (customizeObj) {
          if (customizeObj.popupPos !== "top") {
            frmMain = ihmi.cf.findAncestorFrame(callerWindowObj, customizeObj.popupPos);
          }
        }
        refresh = function (frame) {
          var contents = frame.document.getElementById("wizardPageContents");
          if (typeof callback === 'function') {
            frame.wizardPageCmp.config.removeCallback = callback;
          }
          if (customizeObj) {
            if (customizeObj.appendCbArg) {
              frame.wizardPageCmp.config.appendCbArg = customizeObj.appendCbArg;
            }
          }
          contents.src = ihmi.cf.convertToVersionURL(wizardPages);
        };
        initialize = function (iframe) {
          var frame = iframe.contentWindow;
          if (frame.document.getElementById('divTabBegin') !== null) {
            top.IHMIComponents.cf.initTabBeginEnd(frame);
            frame.document.getElementById('divTabBegin').focus();
          }
          if (frmMain.frameElement !== null) {
            tabIndex = frmMain.frameElement.tabIndex;
            frmMain.frameElement.tabIndex = "-1";//not focus popup window.
            //if popup window unload, restore tabIndex.
            top.IHMIComponents.cf.addEventHandler(frame, "pagehide", function () {
              frmMain.frameElement.tabIndex = tabIndex; //restore
            });
          }
          if (frame.wizardPageCmp.config) {
            //init complete
            refresh(frame);
          } else {
            setTimeout(function () {
              refresh(frame);
            }, 0);
          }
        };
        if (customizeObj) {
          if (customizeObj.popupFrmAddClass) {
            addClass += " " + customizeObj.popupFrmAddClass;
          }
          if (frmMain !== callerWindowObj) {
            //If the stm that calls the popup window unloads, remove the popup.
            ihmi.cf.addEventHandler(callerWindowObj, "pagehide", function () {
              var isExistPopup = ihmi.cf.findDescendant(frmMain.document, "div", WIZARD_FRAME_DIV_CLASS);
              if (isExistPopup) {
                ihmi.cf.removeFrame(iframe);
              }
            });
          }
        }

        iframe = ihmi.cf.appendFrame(frmMain, popupFile, addClass, initialize);
      },
      /**
       * Display user specified message.
       * @param {String} message The message displayed in popup window.
       * @param {null} argEmpty this arg is empty.
       * @param {Function} callback The callback function called when message frame is removed.
       * @param {WindowObject} frmMain The frmMain is insertion position of popup.
       * @param {Object} customizeObj customize popup
       *    @param {Integer} width : popup px width.
       *    @param {Integer} height : popup px height.
       *    @param {String} popupFrmAddClass : add class to popup frame.
       *    @param {Object} headerHelpLinkCb : add helpLink on header. call back funtion.
       *    @param {Object} headerHelpLinkCbArg : add helpLink on header. call back argment.
       */
      helpMessage: function (htmlContents, argEmpty, callback, frmMain, customizeObj) {
        var refresh;
        var create;
        var buttonHandle;
        var iframe;
        argEmpty = null;//empty
        if (!ihmi.cf.isWindow(frmMain)) {
          return;
        }
        if ((customizeObj === null) || (customizeObj === undefined)) {
          customizeObj = {};
        }

        refresh = function (frame) {
          var popupContentsArea = ihmi.cf.findDescendant(frame.doc, "div", "popup-contents-area");
          var contentsElem = frame.doc.getElementById("contentsMessage");
          var popupBoxFrame = ihmi.cf.findDescendant(frame.doc, "div", "popup-box-frame");
          var resizePopupBoxHeight;
          var HELP_BOX_MIN_WIDTH = 666; //default(566px) + 100px
          var HELP_BOX_MIN_HEIGHT = 412; //default(312px) + 100px
          var HEIGHT_REDUCE = 100;//insert popup to top. (The fixed value determined based on specification considerations.)
          var SCROLLBAR_WIDTH = 17; //for IE7
          var TOLERANCE = 2; //for TP
          var bodyOrHtml;
          var dividResultWidth = {};
          var dividResultHeight = {};
          var distWindowHeight;
          var headerBox = ihmi.cf.findDescendant(frame.doc, "div", "popup-header-box");
          var contentWidth;

          contentsElem.innerHTML = htmlContents;
          popupBoxFrame.style.minWidth =  HELP_BOX_MIN_WIDTH + "px";
          if (customizeObj.width) {
            dividResultWidth = ihmi.cf.divideNumUnit(customizeObj.width);
            if (dividResultWidth !== null) {
              customizeObj.width = dividResultWidth.num + dividResultWidth.unit;
              popupBoxFrame.style.width = customizeObj.width;
            }
          }

          if (customizeObj.height) {
            dividResultHeight = ihmi.cf.divideNumUnit(customizeObj.height);
            if (dividResultHeight !== null) {
              resizePopupBoxHeight = dividResultHeight.num;
              customizeObj.height = dividResultHeight.num + dividResultHeight.unit;
              popupBoxFrame.style.height = customizeObj.height;
            }
          }
          ihmi.cf.adjustPopupHeader(frame, customizeObj);
          if (resizePopupBoxHeight === undefined) {
            if (popupContentsArea.scrollHeight > (HELP_BOX_MIN_HEIGHT - headerBox.offsetHeight)) {
              //y scroll
              bodyOrHtml = ihmi.cf.getScrollingElem(frmMain);
              distWindowHeight = (bodyOrHtml.offsetHeight > bodyOrHtml.clientHeight) ? bodyOrHtml.offsetHeight : bodyOrHtml.clientHeight;
              resizePopupBoxHeight = distWindowHeight - HEIGHT_REDUCE;
              if (resizePopupBoxHeight < HELP_BOX_MIN_HEIGHT) {
                resizePopupBoxHeight = HELP_BOX_MIN_HEIGHT;
              }
            } else {
              resizePopupBoxHeight = HELP_BOX_MIN_HEIGHT;
            }
            dividResultHeight.num = resizePopupBoxHeight;
            dividResultHeight.unit = "px";
            popupBoxFrame.style.height = dividResultHeight.num + dividResultHeight.unit;
          }

          if (!ihmi.global.isModernBrowser) {
            popupContentsArea.style.height = popupBoxFrame.offsetHeight - headerBox.offsetHeight + "px";
            if (customizeObj.width == undefined) {
              contentWidth = contentsElem.offsetWidth;
              if (popupContentsArea.scrollHeight > popupContentsArea.clientHeight) {//if y scroll
                contentWidth -= (SCROLLBAR_WIDTH + TOLERANCE);
              }
              contentsElem.style.width = contentWidth + "px";
            }
          }
          ihmi.cf.addClass(popupContentsArea, 'ihcp-scrollbar');
          ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "init");
          ihmi.cf.addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
            try {
              ihmi.cf.adjustBoxPos(frmMain, frame, iframe, customizeObj, "resize");
              ihmi.cf.adjustPopupHeader(frame, customizeObj);
            } catch (e) {
              return;
            }
          }, 200));
        };
        create = function (initialize) {
          var addClass = "popup-frame";
          var popupFile = "/frh/ihmi/ihmipopuphelp.stm";

          if (customizeObj.designpattern === "mouse") {
            addClass += " mouse";
          } else {
            addClass += " touch";
          }

          if (customizeObj.popupFrmAddClass) {
            addClass += " " + customizeObj.popupFrmAddClass;
          }

          iframe = ihmi.cf.appendFrame(frmMain, popupFile, addClass, initialize, true);
          iframe.allowTransparency = true;
        };

        //popupbutton and closebutton
        buttonHandle = function (iframe, page, id, type) {
          ihmi.cf.removeFrame(iframe);
          if (typeof callback === 'function') {
            callback(id, type);
          }
        };
        //not support helpPopup with funckey.

        ihmi.cf.popupMessage(frmMain, null, refresh, create, buttonHandle, null, customizeObj);
      },
      /**
       * Adjust popup box postion.
       * @param {Object} distFramMain The distFramMain is display destination window object.
       * @param {Object} popupFrameMain The popupFrameMain is popup window object.
       * @param {Object} popupIframe The popupIframe is popup iframe dom.(not used)
       * @param {Object} customizeObj customize popup.
       * @param {String} type "init" / "resize" / "refreshFrame"
       */
      adjustBoxPos: function (distFramMain, popupFrameMain, popupIframe, customizeObj, type) {
        var popupBoxFrame = ihmi.cf.findDescendant(popupFrameMain.doc, "div", "popup-box-frame");
        var popupBoxOffsetTop;
        var bodyOrHtml = ihmi.cf.getScrollingElem(distFramMain);
        var distWindowHeight = (bodyOrHtml.offsetHeight > bodyOrHtml.clientHeight) ? bodyOrHtml.offsetHeight : bodyOrHtml.clientHeight;
        var popupBox;
        var ieVer = getIEVersion_(userAgent);
        var popupBoxH;
        var headerBox;
        var margin = 150; //Due to frequent switching between "display: flex" and "display: block", the width of the box was sometimes reduced when specifying the popup in %.
        //var hasFuncKey = false;

        if ((customizeObj === null) || (customizeObj === undefined)) {
          customizeObj = {};
        }
        // if (customizeObj.addFuncKey || customizeObj.errPopAddFuncKey) {
        //   hasFuncKey = true;
        // }

        if (type === "init") {
          popupBoxOffsetTop = calcPopupBoxOffsetTop(distFramMain, popupFrameMain);
          customizeObj.defPopupBoxOffsetTop = popupBoxOffsetTop;
        }

        // Position the popup box vertically centered from the top In case shrink window height.
        if (ieVer === -1) { // not IE
          // clamp(min, preferred value, max);
          if ((type === "refreshFrame") && (customizeObj.contentHeight)) {
            headerBox = findDescendant_(popupFrameMain.doc, "div", "popup-header-box");
            popupBoxFrame.style.top = format_("clamp(0px, 50% - (%s + %spx)/2, %spx)", customizeObj.contentHeight, headerBox.offsetHeight, customizeObj.defPopupBoxOffsetTop);
          } else {
            popupBoxH = customizeObj.height ? customizeObj.height : popupBoxFrame.offsetHeight + "px";
            popupBoxFrame.style.top = format_("clamp(0px, 50% - %s/2, %spx)", popupBoxH, customizeObj.defPopupBoxOffsetTop);
          }
        } else if (ieVer === 11) { // IE11
          var divPopupMain = popupFrameMain.doc.getElementById("divPopupMain") || popupFrameMain.doc.getElementById("divPopupMainOffsetFuncKey");
          if ((popupBoxFrame.offsetHeight + customizeObj.defPopupBoxOffsetTop + margin) > distWindowHeight) {
            divPopupMain.style.display = "flex";
            popupBoxFrame.style.alignItems = "center";
            popupBoxFrame.style.top = "0";
            popupBoxFrame.style.flexShrink = 0; // To prevent the child element's width from becoming smaller when using display: flex,
          } else {
            divPopupMain.style.display = "block";
            popupBoxFrame.style.alignItems = "normal";
            popupBoxFrame.style.top = customizeObj.defPopupBoxOffsetTop + "px";
          }
        }// not support vertically centered lower than IE11.

        if (type === "init") {
          // the same class name may be duplicated.
          // Because multiple popups are displayed in the same window.
          addDupClass(bodyOrHtml, "ihcp-popup-open");

          var eventType = ((ieVer !== -1) && (ieVer < 11)) ? "unload" : "pagehide";
          ihmi.cf.addEventHandler(popupFrameMain, eventType, function () {
            removeDupClass(bodyOrHtml, "ihcp-popup-open");
            // restore scroll position
            // Restore scrollTop->scrollLeft in that order.
            // In the case of IE7, the horizontal scroll position is not correctly restored.
            if (customizeObj.initDistScrollTop !== undefined) {
              bodyOrHtml.scrollTop = customizeObj.initDistScrollTop;
            }
            if (customizeObj.initDistScrollLeft !== undefined) {
              bodyOrHtml.scrollLeft = customizeObj.initDistScrollLeft;
            }
          });
        }
        if (type === "refreshFrame") {
          bodyOrHtml.scrollLeft = 0; // When displaying a popup, set the scroll position to the LLeft.
          bodyOrHtml.scrollTop = 0; // When displaying a popup, set the scroll position to the top.
        }
        if ((type === "init") || (type === "refreshFrame")) {
          popupBox = ihmi.cf.firstElementNode(popupBoxFrame);
          if (popupBox !== null) {
            popupBox.focus();
          }
        }

        /**
         * Calculate the offset position from the top of a popup
         * @param {Object} distFramMain The distFramMain is display destination window object.
         * @param {Object} popupFrameMain The popupFrameMain is popup window object.
         */
        function calcPopupBoxOffsetTop(distFramMain, popupFrameMain) {
          var offsetTopToOwnerFrame = 0;//offset from top window to owner frame.
          var popupBoxFrame = ihmi.cf.findDescendant(popupFrameMain.doc, "div", "popup-box-frame");
          var popupBoxOffsetTop = ihmi.cf.cumulativeOffsetTop(popupBoxFrame);
          var result = popupBoxOffsetTop;
          var offsetTopToMainFrm;
          var childWindow;

          if (distFramMain !== top) {
            return result; // 64px
          }

          // If the destination is 'top', offset by the height of the status bar.
          childWindow = ihmi.cf.getFrame("mainfrm.prim");
          if (childWindow !== null) {
            while (window.top !== childWindow) {//calc offset top from top to mainfrm
              offsetTopToOwnerFrame += childWindow.frameElement.getBoundingClientRect().top;
              childWindow = childWindow.parent;
            }
            //If the software keyboard is displayed, the value of "getBoundingClientRect function" may be negative, so add "window.pageYOffset (scroll amount of top page)" to calculate.
            offsetTopToMainFrm = offsetTopToOwnerFrame + window.pageYOffset;
            if (offsetTopToMainFrm < 0) {//if iPad, offsetTopToOwnerFrame is minus.
              offsetTopToMainFrm = 64;
            }
            result = offsetTopToMainFrm + popupBoxOffsetTop;
            //console.log("offsetTopToMainFrm:" + offsetTopToOwnerFrame + " window.pageYOffset:" + window.pageYOffset + " popupBoxOffsetTop:" + popupBoxOffsetTop);
          }
          return result;
        }

        // Even if the same class name has already been assigned,
        // add the class duplicately
        function addDupClass(target, className) {
          var classes = target.className.split(" ");
          var cssStr;
          classes.push(className);
          cssStr = classes.join(" ");
          cssStr = cssStr.replace(/^\s+/, '').replace(/\s+$/, ''); // for IE7
          target.className = cssStr;
        }
        function removeDupClass(target, className) {
          var classes;
          var index;
          if (!target || !className) {
            return;
          }
          classes = target.className.split(" ");
          if (classes.indexOf) {
            index = classes.indexOf(className);
          } else {
            index = indexOfForIE7(classes, className, 0);
          }
          if (index !== -1) {
            classes.splice(index, 1);
          }
          target.className = classes.join(" ");
        }
        function indexOfForIE7(arry, obj, start) {
          for (var i = (start || 0), j = arry.length; i < j; i++) {
            if (arry[i] === obj) {
              return i;
            }
          }
          return -1;
        }
      },
      /**
       * Call encodeURIComponent only for characters in the string that are <= 127 to
       * avoid garbling the shfit_jis characters.
       */
      encodeURIComponentLocal: function (string) {
        var charArray = [], chr;

        for (var i = 0, len = string.length; i < len; i++) {
          chr = string.charAt(i);
          if (chr.charCodeAt(0) <= 127) {
            chr = encodeURIComponent(chr);
          } else {
            if (ihmi.global.encoding === "Latin1") {
              chr = "%" + chr.charCodeAt(0).toString(16);
            }
          }
          charArray.push(chr);
        }
        return charArray.join("");
      },
      textbox: {
        init: function(that, elem, config, textbox) {
          var isNotIE = (getIEVersion_(userAgent) === -1);
          var isNotTablet = !(ihmi.global.isTablet);
          elem.config = config;
          elem.config.initInfo = {};
          elem.config.initInfo.config = copyInitConfig_(config);
          elem.config.initInfo.root = elem.cloneNode(true);
          elem.config.useRequiredMark = parseStrToBoolean_(elem.config.useRequiredMark);
          elem.config.func = that.func;
          elem.refresh = that.refresh;
          elem.getValue = that.getValue;
          elem.notifyChanged = that.notifyChanged;
          elem.setFocus = that.setFocus;
          elem.setCallback = that.setCallback;
          elem.setCursorPos = that.setCursorPos;
          determineDefaultDesignPattern_(elem);
          if (elem.config.useRequiredMark) {
            elem.setRequiredMark = that.setRequiredMark;
            elem.setRequiredMark(false, null);
          }
          config.oldText = "";
          config.tempValue = "";

          if (ihmi.global.isTablet) {
            //cursor position is the end on tablet.
            if (config.unSelect === "false") {
              config.unSelect = false;
            } else {
              config.unSelect = true;//default
            }
          } else {
            config.unSelect = parseStrToBoolean_(config.unSelect);
          }

          if (textbox === null) {
            /** textboxString */
            elem.setMode = that.setMode;
            elem.setConfig = that.setConfig;

            addEventHandler_(elem, "focus", that.onfocus);
            addEventHandler_(elem, "blur", that.onblur);
            addEventHandler_(elem, "keypress", that.onkeypress);
            addEventHandler_(elem, "keyup", that.onkeyup);
            if (isNotIE && isNotTablet && (config.unSelect === false)) {
              addEventHandler_(elem, 'compositionend', that.onCompositionEnd);
            }
            // [#9488] Delete the radius.
            if (ihmi.global.isiPad) {
              elem.style.webkitAppearance = 'none';
              elem.style.borderRadius = '0px';
            }
          } else {
            /** textboxReal, textboxInteger */
            elem.setBtnsMarginLeft = that.setBtnsMarginLeft;

            addEventHandler_(textbox, "focus", that.onfocus);
            addEventHandler_(textbox, "blur", that.onblur);
            addEventHandler_(textbox, "keypress", that.onkeypress);
            addEventHandler_(textbox, "keyup", that.onkeyup);
            if (isNotIE && isNotTablet && (config.unSelect === false)) {
              addEventHandler_(textbox, 'compositionend', that.onCompositionEnd);
            }
            // [#9488] Delete the radius.
            if (ihmi.global.isiPad) {
              textbox.style.webkitAppearance = 'none';
              textbox.style.borderRadius = '0px';
            }
          }
        },
        /**
         * @param {Object} that Object in textbox
         * @param {HTMLSpanElement | HTMLInputElement} elem HTMLSpanElement->real or integer, HTMLInputElement->string
         * @param {Object} config Setting Object in textbox element
         * @param {HTMLInputElement | null} textbox HTMLInputElement->real or integer, null->string
         * @param {Number} kind 0->real, 1->int
         */
        initIntReal: function(that, elem, config, textbox, kind) {
          var clickEvent = (ihmi.global.isiPad)
                          ? 'touchend'
                          : 'click';
          var func = that.func;
          var modeNumber = (kind === 0) ? 'decimal' : 'numeric';
          var doc = elem.ownerDocument;
          if (!isiPendant_() && "inputType" in config) {
            switch (config.inputType) {
              case "text":
                break;
              case "number":
                textbox.setAttribute("inputmode", modeNumber);
                break;
              case "tel":
                textbox.setAttribute("inputmode", "tel");
                break;
              default:
                break;
            }
          }
          if ("buttons" in config) {
            var btnInc1 = doc.getElementById(elem.id + ".btnInc"),
                btnDec1 = doc.getElementById(elem.id + ".btnDec"),
                btnInc2 = doc.getElementById(elem.id + ".btnInc2"),
                btnDec2 = doc.getElementById(elem.id + ".btnDec2");

            if (kind === 0) {
              config.scale1 = (config.scale1 === undefined)
                              ? Math.sqrt(2)
                              : parseFloat(config.scale1);
              config.scale2 = (config.scale2 === undefined)
                              ? config.scale1 * config.scale1
                              : parseFloat(config.scale2);
            }
            if (config.step1 === undefined) {
              config.step1 = 1;
            } else {
              config.step1 = (kind === 0) ? parseFloat(config.step1)
                                          : parseInt(config.step1, 10);
            }
            if (config.step2 === undefined) {
              config.step2 = config.step1 * 10;
            } else {
              config.step2 = (kind === 0) ? parseFloat(config.step2)
                                          : parseInt(config.step2, 10);
            }

            switch (config.buttons) {
              case "scale":
                if (kind === 1) {
                  throw new Error("unknown buttons value: " + config.buttons);
                }
                btnInc1.scale = func.scaleup1;
                btnDec1.scale = func.scaledown1;
                break;
              case "scale2":
                if (kind === 1) {
                  throw new Error("unknown buttons value: " + config.buttons);
                }
                removeClass_(btnInc2, "hide");
                removeClass_(btnDec2, "hide");
                btnInc2.scale = func.scaleup2;
                btnInc1.scale = func.scaleup1;
                btnDec1.scale = func.scaledown1;
                btnDec2.scale = func.scaledown2;
                break;
              case "step":
                btnInc1.scale = func.increment1;
                btnDec1.scale = func.decrement1;
                break;
              case "step2":
                removeClass_(btnInc2, "hide");
                removeClass_(btnDec2, "hide");
                btnInc2.scale = func.increment2;
                btnInc1.scale = func.increment1;
                btnDec1.scale = func.decrement1;
                btnDec2.scale = func.decrement2;
                break;
              default:
                throw new Error("unknown buttons value: " + config.buttons);
            }
            addEventHandler_(btnDec2, clickEvent, that.onclick);
            addEventHandler_(btnDec1, clickEvent, that.onclick);
            addEventHandler_(btnInc1, clickEvent, that.onclick);
            addEventHandler_(btnInc2, clickEvent, that.onclick);

            addClass_(btnInc1, config.designpattern);
            addClass_(btnDec1, config.designpattern);
            addClass_(btnInc2, config.designpattern);
            addClass_(btnDec2, config.designpattern);
          }
        }
      },
      /** Tell the web server that a text in the textbox has been changed */
      notifyTextboxChanged: function (elem, value, operation, config) {
        var frame, params, encodedValue;

        encodedValue = ihmi.cf.encodeURIComponentLocal(value);
        frame = ihmi.cf.getDefaultView(elem.ownerDocument);
        params = { request: elem.id + ".changed", value: encodedValue };
        if (operation !== undefined) params.operation = operation;

        if (typeof config.callback === 'function') {
          config.callback(elem.id, "changed", value);
        } else {
          ihmi.cf.IUIFRequest(frame, params).send(function (response) {
            (function () {
              eval(ihmi.cf.getResponseText(response));
            })();
            var textbox = ihmi.global.selectedTextbox;
            if (textbox !== null) {
              if (!config.unSelect) {
                try {
                  textbox.select();
                } catch (e) { } // eslint-disable-line no-empty
              }
            }
          });
        }
      },
      /** Add loading indicator to the window from which this script is loaded. */
      addLoadingIndicator: function () {
        var div = document.createElement("div");
        div.id = "loading";
        div.className = "hide";
        div.innerHTML = '<span>Bearbeitung luft ...</span><img src="loading.gif" align="absmiddle" />';
        var numConnections = 0;
        div.start = function () {
          numConnections++;
          ihmi.cf.removeClass(this, "hide");
        };
        div.finish = function () {
          numConnections--;
          if (numConnections <= 0) {
            ihmi.cf.addClass(this, "hide");
          }
        };
        document.body.appendChild(div);

        div = null; // avoid circular reference
      },
      appendActiveXControl: function (elem, classID, id, width, height) {
        elem.innerHTML = ihmi.cf.format('<object classid="clsid:%s" id="%s" height="%spx" width="%spx" tabindex="-1"></object>', classID, id, width, height);
      },
      /**
       * Construct a request object.
       * @param {Window} frame The frame from which request is sent
       * @param {Object} params The parameters of URL
       * @config {String} [webpage = frame.webpage]
       * @config {String} request
       * @config {String} [value]
       * @return A new url object.
       */
      IUIFRequest: function (frame, params) {
        params["webpage"] = params["webpage"] || frame.webpage;
        if ((params["connect_id"] === undefined)  &&
            (top.g_connect_id !== undefined)) {
          params["connect_id"] = top.g_connect_id;
        }
        var iHMIReqParams = frame.iHMIReqParams;

        if (iHMIReqParams === undefined) {
          iHMIReqParams = ihmi.cf.findReqParams(frame);
        }
        for (var keys in iHMIReqParams) {
          if (Object.prototype.hasOwnProperty.call(iHMIReqParams, keys)) {
            params[keys] = iHMIReqParams[keys];
          }
        }

        var procResponse = function (xmlhttp, callback) {
          var response;
          var contentType;

          if (xmlhttp.status === 200) { // success
            contentType = xmlhttp.getResponseHeader("Content-Type");
            if (contentType.indexOf('xml') >= 0) {
              response = xmlhttp.responseXML;
              if (typeof callback === 'function') {
                callback(response);
              } else {
                (function () {
                  eval(ihmi.cf.getResponseText(response));
                })();
              }
            } else {
              response = xmlhttp.responseText;
              if (typeof callback === 'function') {
                callback(response);
              } else {
                //N/A
              }
            }
          } else { // fail
            if (typeof callback === 'function') {
              callback(null);
            } else {
              // alertMessage is not used because vsalrm.htm might not be available
              alert("Das Steuergert konnte nicht angeschlossen werden.");
            }
          }
        };

        var sendAsync = function (callback, options) {
          var loading = (options !== undefined && options.noIndicator === true) ? null : document.getElementById("loading"),
            xmlhttp = new window.XMLHttpRequest(),
            timer = null;

          if (iHMIReqParams === null) {
            return;
          }

          if (options !== undefined && typeof options.timeout === 'number') {
            timer = setTimeout(function () {
              xmlhttp.onreadystatechange = null;
              xmlhttp.abort();
              xmlhttp = null;
              if (loading !== null) loading.finish();
              if (typeof options.timeoutHandler === "function") {
                options.timeoutHandler();
              }
            }, options.timeout);
          }

          if (loading !== null) loading.start();

          xmlhttp.onreadystatechange = function () {
            if (xmlhttp.readyState === 4) {
              if (loading !== null) loading.finish();
              if (timer !== null) clearTimeout(timer);

              procResponse(xmlhttp, callback);

              xmlhttp.onreadystatechange = null;
              xmlhttp = null;
            }
          };
          xmlhttp.open("GET", this.toString(), true);
          xmlhttp.send(null);
        };

        var sendSync = function (callback, options) {
          var loading = (options !== undefined && options.noIndicator === true) ? null : document.getElementById("loading"),
            xmlhttp = new window.XMLHttpRequest();

          if (iHMIReqParams === null) {
            return;
          }

          if (loading !== null) loading.start();
          xmlhttp.open("GET", this.toString(), false);
          xmlhttp.send(null);

          procResponse(xmlhttp, callback);

          if (loading !== null) loading.finish();
          xmlhttp = null;
        };

        var toString = function () {
          var array = [];
          var text;
          var path = iHMIReqParams.path;
          for (var key in params) {
            text = params[key];
            if (text !== null && text !== undefined && key !== "path") {
              array.push(key + "=" + text);
            }
          }
          return path + "?" + array.join("&");
        };

        /////////public functions//////////
        var that = {};
        that.send = sendAsync;
        that.sendSync = sendSync;
        that.toString = toString;

        return that;
      },
      findReqParams: function (frame) {
        for (var candidate = frame; candidate !== top; candidate = candidate.parent) {
          if (candidate.iHMIReqParams !== undefined) {
            return candidate.iHMIReqParams;
          }
        }
        return null;
      },
      triggerEvent: function (elem, name, attr) {
        var event;
        var setAttribute = function (event, attr) {
          for (var key in attr) {
            event[key] = attr[key];
          }
        };
        if (document.createEvent) { // other than IE
          event = document.createEvent("HTMLEvents");
          event.initEvent(name, true, true);
          if (attr) setAttribute(event, attr);
          return elem.dispatchEvent(event);
        } else { // IE
          event = document.createEventObject();
          if (attr) setAttribute(event, attr);
          return elem.fireEvent("on" + name, event);
        }
      },
      /**
       * Find the first element node
       * @param {HTMLElement} Element as a starting point of search. From this element first element is searched.
       */
      firstElementNode: function (elem) {
        var currElem = elem.firstChild;
        while (currElem) {
          if (currElem.nodeType === 1) return currElem;
          currElem = currElem.nextSibling;
        }
        return null;
      },
      /**
       * Find the last element node
       * @param {HTMLElement} Element as a starting point of search. From this element last element is searched.
       */
      lastElementNode: function (elem) {
        var currElem = elem.lastChild;
        while (currElem) {
          if (currElem.nodeType === 1) return currElem;
          currElem = currElem.previousSibling;
        }
        return null;
      },
      /**
       * Find next element node
       * @param {HTMLElement} Element as a starting point of search. From this element next element is searched.
       */
      nextElementNode: function (elem) {
        var currElem = elem.nextSibling;
        while (currElem) {
          if (currElem.nodeType === 1) return currElem;
          currElem = currElem.nextSibling;
        }
        return null;
      },
      /**
       * Find prev element node
       * @param {HTMLElement} Element as a starting point of search. From this element prev element is searched.
       */
      prevElementNode: function (elem) {
        var currElem = elem.previousSibling;
        while (currElem) {
          if (currElem.nodeType === 1) return currElem;
          currElem = currElem.previousSibling;
        }
        return null;
      },
      /**
       * Find first descendant tagName and className of which meet specified value under the specified element.
       * @param {HTMLElement} elem Parent element. Under this element descendant is searched.
       * @param {String} tagName tag name of required elements.
       * @param {String} className class name to be included in that of required elements.
       */
      findDescendant: function (elem, tagName, className) {
        if (elem == null) {
          return null;
        }
        var candidates = elem.getElementsByTagName(tagName.toUpperCase());
        className = ' ' + className + ' ';
        for (var i = 0, len = candidates.length; i < len; i++) {
          if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
            return candidates[i];
          }
        }
        return null;
      },
      /**
       * Find all descendants tagName and className of which meet specified value under the specified element.
       * @param {HTMLElement} elem Parent element. Under this element descendant is searched.
       * @param {String} tagName tag name of required elements.
       * @param {String} className class name to be included in that of required elements.
       */
      findDescendants: function (root, tagName, className) {
        var candidates = root.getElementsByTagName(tagName.toUpperCase());
        var selected = [];
        className = ' ' + className + ' ';
        for (var i = 0, len = candidates.length; i < len; i++) {
          if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
            selected.push(candidates[i]);
          }
        }
        return selected;
      },
      /**
       * Find first ancester tagName and className of which meet specified value.
       * @param {HTMLElement} elem Child element. From this elements ancester is searched.
       * @param {String} tagName tag name of required elements.
       * @param {String} className class name to be included in that of required elements.
       */
      findAncestor: function (elem, tagName, className) {
        var top = elem.ownerDocument;
        tagName = tagName.toUpperCase();
        className = ' ' + className + ' ';
        for (var candidate = elem; candidate !== top; candidate = candidate.parentNode) {
          if (candidate.tagName === tagName && (' ' + candidate.className + ' ').indexOf(className) >= 0) {
            return candidate;
          }
        }
        return null;
      },
      /**
       * Find last ancester tagName and className of which meet specified value.
       * @param {HTMLElement} elem Child element. From this elements ancester is searched.
       * @param {String} tagName tag name of required elements.
       * @param {String} className class name to be included in that of required elements.
       */
      findLastAncestor: function (elem, tagName, className) {
        var lastAncestor = null,
          ancestor = elem;
        while (ancestor !== null) {
          ancestor = ihmi.cf.findAncestor(ancestor.parentNode, tagName, className);
          if (ancestor !== null) {
            lastAncestor = ancestor;
          }
        }
        return lastAncestor;
      },
      /**
       * Add the new class name to the specified element.
       * @param {HTMLElement} elem element to which new class name is added.
       * @param {String} className class name to be added to the element.
       */
      addClass: function (elem, className) {
        var oldClass = elem.className,
          newClass;
        if (!ihmi.cf.hasClass(elem, className)) {
          newClass = oldClass + ' ' + className;
          newClass = newClass.replace(/^\s+/, '')
            .replace(/\s+$/, '');
          if (oldClass !== newClass) {
            elem.className = newClass;
          }
        }
      },
      /**
       * Remove the class name from the specified element.
       * @param {HTMLElement} elem element from which the class name is removed.
       * @param {String} className class name to be removed from the element.
       */
      removeClass: function (elem, className) {
        var oldClass = elem.className,
          newClass;
        newClass = (' ' + oldClass + ' ').replace(' ' + className + ' ', ' ')
          .replace(/^\s+/, '')
          .replace(/\s+$/, '');
        if (oldClass !== newClass) {
          elem.className = newClass;
        }
      },
      /**
       * Add new class names to the specified element.
       * @param {HTMLElement} elem element to which new class name is added.
       * @param {String} classNames class name to be added to the element.
       */
      addClasses: function (elem, classNames) {
        var oldClass = elem.className,
          dummyElement = { className: oldClass },
          classes;
        classNames = classNames.replace(/^\s+/, '')
          .replace(/\s+$/, '');
        classes = classNames.split(/\s+/);
        for (var i = 0, len = classes.length; i < len; i++) {
          addClass_(dummyElement, classes[i]);
        }
        if (dummyElement.className !== oldClass) {
          elem.className = dummyElement.className;
        }
      },
      /**
       * Remove new class names to the specified element.
       * @param {HTMLElement} elem element to which new class name is removeed.
       * @param {String} classNames class name to be removeed to the element.
       */
      removeClasses: function (elem, classNames) {
        var oldClass = elem.className,
          dummyElement = { className: oldClass },
          classes;
        classNames = classNames.replace(/^\s+/, '')
          .replace(/\s+$/, '');
        classes = classNames.split(/\s+/);
        for (var i = 0, len = classes.length; i < len; i++) {
          ihmi.cf.removeClass(dummyElement, classes[i]);
        }
        if (dummyElement.className !== oldClass) {
          elem.className = dummyElement.className;
        }
      },
      /**
       * Replace the class name of the specified element.
       * @param {HTMLElement} elem element from which the class name is removed.
       * @param {String} oldClass class name to be removed from the element.
       * @param {String} newClass class name to be added from the element.
       */
      replaceClass: function (elem, oldClass, newClass) {
        var oldClasses = elem.className,
          newClasses;
        newClasses = (' ' + oldClasses + ' ').replace(' ' + oldClass + ' ', ' ' + newClass + ' ')
          .replace(/^\s+/, '')
          .replace(/\s+$/, '');
        if (oldClasses !== newClasses) {
          elem.className = newClasses;
        }
      },
      /**
       * Check if the specified element has the class name.
       * @param {HTMLElement} elem element to be checed.
       * @param {String} className class name.
       * @return {Boolean} return true if the element has the class name.
       */
      hasClass: function (elem, className) {
        return ((' ' + elem.className + ' ').indexOf(' ' + className + ' ') >= 0) ? true : false;
      },
      /**
       * Add or remove the class name to the specified element.
       * @param {HTMLElement} elem element to which new class name is added.
       * @param {String} className class name to be added to the element.
       * @param {Boolean} on if true the class name is added, otherwise removed.
       */
      turnOnOffClass: function (elem, className, on) {
        if (on) {
          ihmi.cf.addClass(elem, className);
        } else {
          ihmi.cf.removeClass(elem, className);
        }
      },
      /**
       * Add or remove the class name to the specified element.
       * @param {HTMLElement} elem element to which new class name is added.
       * @param {String} classNames class name to be added to the element.
       * @param {Boolean} on if true the class name is added, otherwise removed.
       */
      turnOnOffClasses: function (elem, classNames, on) {
        if (on) {
          ihmi.cf.addClasses(elem, classNames);
        } else {
          ihmi.cf.removeClasses(elem, classNames);
        }
      },
      /**
       * Add the class name to the specified element and remove the class name from the other descendants.
       * @param {HTMLElement} root root element from which descendants are found.
       * @param {HTMLElement} elem element to be added the class name.
       * @param {String} className class name.
       */
      addClassExclusively: function (root, elem, className) {
        var tagName = elem.tagName,
          candidates = ihmi.cf.findDescendants(root, tagName, className);
        for (var i = 0, len = candidates.length; i < len; i++) {
          ihmi.cf.removeClass(candidates[i], className);
        }
        ihmi.cf.addClass(elem, className);
      },
      /**
       * remove the class name to the specified element.
       * @param {HTMLElement} root root element from which descendants are found.
       * @param {String} tag element tag name to be remove the class name.
       * @param {String} className class name.
       */
      removeClassExclusively: function (root, tag, className) {
        var candidates = ihmi.cf.findDescendants(root, tag, className);
        for (var i = 0, len = candidates.length; i < len; i++) {
          ihmi.cf.removeClass(candidates[i], className);
        }
      },
      /**
       * Replace the class name of the specified element and revert the class name for the other descendants.
       * @param {HTMLElement} root root element from which descendants are found.
       * @param {HTMLElement} elem element from which the class name is removed.
       * @param {String} oldClass class name to be removed from the element.
       * @param {String} newClass class name to be added from the element.
       */
      replaceClassExclusively: function (root, elem, oldClass, newClass) {
        var tagName = elem.tagName,
          candidates = ihmi.cf.findDescendants(root, tagName, newClass);
        for (var i = 0, len = candidates.length; i < len; i++) {
          ihmi.cf.replaceClass(candidates[i], newClass, oldClass);
        }
        ihmi.cf.replaceClass(elem, oldClass, newClass);
      },
      /**
       * Get the first text node under the specified element.
       * @param {HTMLElement} elem parent element.
       * @return {Text} text node.
       */
      getTextNode: function (elem) {
        for (var child = elem.firstChild; child !== null; child = child.nextSibling) {
          if (child.nodeType === 3) {
            return child;
          }
        }
        return null;
      },
      /**
       * Get all texts under the specified element.
       * @param {HTMLElement} elem parent element.
       * @return {String} text which is under the element.
       */
      getText: function (elem) {
        var texts = [];
        var value;
        for (var child = elem.firstChild; child !== null; child = child.nextSibling) {
          if (child.nodeType === 3) {
            value = child.nodeValue;
            if (!(/^[ \n]$/).test(value)) {
              texts.push(value);
            }
          }
        }
        return texts.join('');
      },
      /**
       * Calculate disatance between specified element top and window top.
       * @param {HTMLElement} elem DOM object.
       */
      cumulativeOffsetTop: function (elem) {
        var offset = 0;
        do {
          offset += elem.offsetTop;
          elem = elem.offsetParent;
        } while (elem);
        return offset;
      },
      /**
       * Calculate disatance between specified element left and window left.
       * @param {HTMLElement} elem DOM object.
       */
      cumulativeOffsetLeft: function (elem) {
        var offset = 0;
        do {
          offset += elem.offsetLeft;
          elem = elem.offsetParent;
        } while (elem);
        return offset;
      },
      /**
       * Scroll an area object to make a target object visible.
       * @param {HTMLElement} area DOM object containing one element that defines scroll area.
       * @param {HTMLElement} target DOM object containing one element to which area is scrolled.
       * @param {Number} [offset=0] Offset value used when positions of scrollable object and visible area object does not match.
       */
      scrollTo: function (area, target, offset) {
        var TOLERANCE = 1, //for IE zoom75%
            SCROLLBAR_WIDTH = 17,
            baroffset = 0;
        if (offset === undefined) offset = 0;

        var areaTop = area.scrollTop + offset,
          areaHeight = area.offsetHeight - offset,
          targetTop, targetHeight,
          cumulativeOffsetTop = ihmi.cf.cumulativeOffsetTop;
        if (target == null) {
          targetTop = 0 - cumulativeOffsetTop(area);
          targetHeight = 0;
        } else {
          targetTop = cumulativeOffsetTop(target) - cumulativeOffsetTop(area);
          targetHeight = target.offsetHeight;
        }

        if (areaTop > targetTop) {
          /** When scrolling beyond the element you want to display */
          area.scrollTop = targetTop - offset;
        } else if (areaTop + areaHeight < targetTop + targetHeight) {
          /**
           * areaTop + areaHeight -> Bottom of visible area
           * targetTop + targetHeight -> Bottom of target
           */
          if (!((area.clientWidth >= (area.scrollWidth - TOLERANCE)) &&
                (area.clientWidth <= (area.scrollWidth + TOLERANCE)))) { // if exist x scrollbar, clientWidth neqr equall scrollWidth.
            baroffset = SCROLLBAR_WIDTH;
          }
          area.scrollTop = targetTop + targetHeight - areaHeight - offset + baroffset;
        }
      },
      /**
       * Get next node distant from current node by step.
       * @param {Node} parent parent node.
       * @param {Node} current current node.
       * @param {Number} step distance between current node and next node.
       */
      getNextNode: function (parent, current, step) {
        var nextProperty, next, node;
        if (step > 0) {
          nextProperty = 'next';
          if (ihmi.cf.nextElementNode(current) === null) {
            next = ihmi.cf.firstElementNode(parent);
            return next;
          }
        } else {
          nextProperty = 'prev';
          if (ihmi.cf.prevElementNode(current) === null) {
            next = ihmi.cf.lastElementNode(parent);
            return next;
          }
        }

        step = Math.abs(step);
        next = current;
        for (var i = 0; i < step; i++) {
          if (nextProperty === 'next') {
            node = ihmi.cf.nextElementNode(next);
          } else if (nextProperty === 'prev') {
            node = ihmi.cf.prevElementNode(next);
          }
          if (node === null) break;
          next = node;
        }
        return next;
      },
      /**
       * get the amount of movement from key event.
       * @param {Event} event key event
       * @return {Number} distance
       */
      keyEventToDistance: function (event) {
        var dist;
        switch (event.keyCode) {
          case 9: // up and down arrow keys
            dist = event.shiftKey ? -1 : 1;
            break;
          case 33: // shift + up
            dist = -5;
            break;
          case 34: // shift + down
            dist = 5;
            break;
          case 38: // keyboard up or shift-up
            dist = event.shiftKey ? -5 : -1;
            break;
          case 40: // keyboard down or shift-down
            dist = event.shiftKey ? 5 : 1;
            break;
          default:
            dist = 0;
            break;
        }
        return dist;
      },
      /**
       * attachEvent is supported in IE only
       * ihmi.cf.addEventHandler is supported in compliant browsers
       */
      addEventHandler: function (target, event, handler) {
        if (target == null) {
          return;
        }
        if ((typeof target.attachEvent === 'function') ||
            (typeof target.attachEvent === 'object')) {
          target.attachEvent('on' + event, handler);
        } else {
          target.addEventListener(event, handler);
        }
      },
      /**
       * detachEvent is supported in IE only
       * removeEventHandler is supported in compliant browsers
       */
      removeEventHandler: function (target, event, handler) {
        if (target == null) {
          return;
        }
        if ((target.detachEvent !== undefined) &&
           ((typeof target.detachEvent === 'function') || (typeof target.detachEvent === 'object'))) {
          target.detachEvent('on' + event, handler);
        } else {
          target.removeEventListener(event, handler);
        }
      },
      /**
       *  defaultView is supported in compliant browsers
       *  parentWindow is supported in IE only
       */
      getDefaultView: function (doc) {
        if (doc.parentWindow === undefined) {
          /** defaultView is supported in compliant browsers */
          return doc.defaultView;
        } else {
          /** parentWindow is supported in IE only*/
          return doc.parentWindow;
        }
      },
      /**
       *  getComputedStyle is supported in compliant browsers
       *  currentStyle is supported in IE only
       */
      getCurrentStyle: function (elem) {
        var doc, frame;
        if (elem.currentStyle === undefined) {
          doc = elem.ownerDocument;
          if (doc === null) return null;
          frame = ihmi.cf.getDefaultView(doc);
          if (frame === null) return null;
          return frame.getComputedStyle(elem);
        } else {
          return elem.currentStyle;
        }
      },
      getZoomFactor: function (element) {
        var factor = 1;
        var doc = element.ownerDocument;
        if (doc.body.getBoundingClientRect) {
          /** rect is only in physical pixel size in IE before version 8 **/
          var rect = doc.body.getBoundingClientRect();
          var physicalW = rect.right - rect.left;
          var logicalW = doc.body.offsetWidth;

          /** the zoom level is always an integer percent value **/
          factor = Math.round((physicalW / logicalW) * 100) / 100;
        }
        return factor;
      },
      parseStrToBoolean: function (str) {
        // Refine the judgment.
        var boolVal = false;
        if (typeof str === 'string') {
          boolVal = (str === 'false') ? false: true;  // This is the original processing.
        } else if (typeof str === 'number') {
          boolVal = (str === 0) ? false: true;
        } else if (typeof str === 'boolean') {
          boolVal = str;
        } else {
          boolVal = ((str === undefined) || (str === null)) ? false: true;
        }
        return boolVal;
      },
      /** Return true if script is executed on the iPendant. */
      isiPendant: function () {
        return ihmi.global.isIEMobile;
      },
      /** Initialize UIF Components. This function is only called by code embeded by embeduifcomponents.pl */
      initComponents: function (doc, type, id, config) {
        var vuc = ihmi[type];
        if (vuc !== undefined) vuc.init(doc, id, config);
      },
      /** Shoot the button for a moment. */
      lightupBtnMoment: function (elem) {
        addClass_(elem, "clicked");
        setTimeout(function() {
          try {
            removeClass_(elem, "clicked");
          } catch (e) {}  // eslint-disable-line no-empty
        }, 100);
      },
      /** When the designpattern is undefined, change to the mouse design. */
      determineDefaultDesignPattern: function (root) {
        if (root.config.designpattern === undefined) {
          if (hasClass_(root, "mouse")) {
            root.config.designpattern = "mouse";
          } else {
            if (!hasClass_(root, "touch")) {
              addClass_(root, "touch");
            }
            root.config.designpattern = "touch";
          }
        } else if ((root.config.designpattern !== "touch") && (root.config.designpattern !== "mouse")) {
          removeClass_(root, root.config.designpattern);
          root.config.designpattern = "touch";
          addClass_(root, root.config.designpattern);
        }
      },
      /* to change the focus border to transparent in tablet. */
      judgeAddTabletClass: function (root) {
        if (ihmi.global.isTablet) {
          ihmi.cf.addClass(root, "ihcp-tablet");
        }
      },
      /* append waiting overlay screen.
       * targetWin : target window for overlay.
       * id : overlay screen id. Specify also when removing.
       * callerWindowObj : The callerWindowObj is caller window obj.
       * customizeObj : customize option.
       *  customizeObj.timeUntilShowIcon : Time until icon is displayed.
       *  customizeObj.isBackgroundGray : If true, background color of overlay is gray.
       *  customizeObj.removeTimer : Remove overlay after specified time.
       *  customizeObj.iconPosOffsetX : Offset Position of the waiting icon (x direction).
       *  customizeObj.iconPosOffsetY : Offset Position of the waiting icon (y direction).
       */
      appendWaitingOverlayScreen: function(targetWin, id, callerWindowObj, customizeObj) {
        var targetDoc;
        var ovlScrn;
        var CSS_STR_OVRLAY = 'position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 1000;';
        var CSS_STR_BG_GRAY = ' background-color: rgb(0, 0, 0); filter: alpha(opacity=50); -moz-opacity: 0.5; opacity: 0.5;';
        var waitIconId = 'ihmiwaiting_'+id;
        var timeUntilShowIcon;
        var removeTimer;
        var iconPosOffsetX;
        var iconPosOffsetY;
        var existsSameId;
        if (!targetWin || !id || !callerWindowObj) {
          return; //null or empty
        }
        targetDoc = targetWin.document;
        ovlScrn = targetDoc.createElement('div');
        existsSameId = targetDoc.getElementById(id);
        if (existsSameId !== null) {
          return; // exist same overlay
        }
        if (!customizeObj) {
          customizeObj = {};
        }
        timeUntilShowIcon = parseInt(customizeObj.timeUntilShowIcon, 10);
        timeUntilShowIcon = (timeUntilShowIcon && timeUntilShowIcon > 0) ?
                              timeUntilShowIcon :
                              400;

        removeTimer = parseInt(customizeObj.removeTimer, 10);
        removeTimer = (removeTimer && removeTimer > 0) ?
                        removeTimer :
                        -1; //Do not use the auto delete.

        iconPosOffsetX = customizeObj.iconPosOffsetX ?
                          parseInt(customizeObj.iconPosOffsetX, 10) :
                          0;

        iconPosOffsetY = customizeObj.iconPosOffsetY ?
                          parseInt(customizeObj.iconPosOffsetY, 10) :
                          0;

        ovlScrn.id = id;
        // Set the style directly because the target window is outside the component.
        ovlScrn.style.cssText = customizeObj.isBackgroundGray ?
                                  CSS_STR_OVRLAY + CSS_STR_BG_GRAY :
                                  CSS_STR_OVRLAY;
        ovlScrn.className = 'ihmioverlay';
        targetDoc.body.appendChild(ovlScrn);
        //If the stm that calls the append window unloads, remove the overlay.
        addEventHandler_(callerWindowObj, "pagehide", function () {
          removeWaitingOverlayScreen_(targetWin, id);
        });

        ovlScrn.timeoutIdIconShow = setTimeout(function(){
          var waitIcon;
          var waitingImage;
          var WAIT_ICON_CLASSNAME = 'ihmioverlay-wait-icon';
          var searchStr = 'div' + '.' + WAIT_ICON_CLASSNAME;
          var existsOtherIcon = querySelector_(targetDoc, searchStr);
          waitIcon = targetDoc.createElement('div');
          waitIcon.id = waitIconId;
          addClass_(waitIcon, WAIT_ICON_CLASSNAME);
          if (existsOtherIcon !== null) {
            addClass_(waitIcon, 'hide');
          }
          waitIcon.style.cssText = format_('position: fixed; z-index: 1001; top: calc(40% + %spx); left: calc(50% - 20px + %spx);',
                    iconPosOffsetY, iconPosOffsetX);
          waitingImage = targetDoc.createElement('img');
          waitingImage.setAttribute('src', '/frh/ihmi/waitnotice.gif');
          waitIcon.appendChild(waitingImage);
          targetDoc.body.appendChild(waitIcon);
        }, timeUntilShowIcon);
        if (removeTimer > 0) {
          ovlScrn.timeoutIdRemoveOverlay = setTimeout(function(){
            removeWaitingOverlayScreen_(targetWin, id);
          }, removeTimer);
        }
      },
      /* Remove waitin overlay screen.
       * targetWin : target window for overlay.
       * id  : overlay screen id.
       */
      removeWaitingOverlayScreen: function(targetWin, id) {
        var targetDoc;
        var ovlElem;
        var waitIconId = 'ihmiwaiting_'+id;
        var WAIT_ICON_CLASSNAME = 'ihmioverlay-wait-icon';
        var searchStr = 'div' + '.' + WAIT_ICON_CLASSNAME;
        var waitIcon;
        var otherWaitIcons;
        if (!targetWin || !id) {
          return; //null or empty
        }
        targetDoc = targetWin.document;
        ovlElem = targetDoc.getElementById(id);
        if (ovlElem === null) {
          return;
        }
        if (ovlElem.timeoutIdIconShow != null) {
          clearTimeout(ovlElem.timeoutIdIconShow);
          ovlElem.timeoutIdIconShow = null;
        }
        if (ovlElem.timeoutIdRemoveOverlay != null) {
          clearTimeout(ovlElem.timeoutIdRemoveOverlay);
          ovlElem.timeoutIdRemoveOverlay = null;
        }
        waitIcon = targetDoc.getElementById(waitIconId);
        if (waitIcon !== null) {
          targetDoc.body.removeChild(waitIcon);
        }
        targetDoc.body.removeChild(ovlElem);

        otherWaitIcons = querySelector_(targetDoc, searchStr);
        if (otherWaitIcons !== null) {
          removeClass_(otherWaitIcons, 'hide');
        }
      },
      /* querySelector(for IE7) */
      /**
       * The querySelector() method returns the first element that matches a specified CSS selector(s) in the document.
       * @param {HTMLElement} elem serch target element.
       * @param {String} selector Specifies one or more CSS selectors to match the element.
       */
      querySelector: function(elem, selector) {
        var doc = elem.ownerDocument;
        var style;
        var select;

        if (elem.querySelector) {
          return elem.querySelector(selector);
        }

        if (doc === null) {
          // "elem" is used on a node that is itself a document
          doc = elem;
        }
        style = doc.createStyleSheet();
        select = function (selector, maxCount) {
          var all = elem.all;
          var l = all.length;
          var i;
          var resultSet = [];

          style.addRule(selector, "foo:bar");
          for (i = 0; i < l; i += 1) {
            if (all[i].currentStyle.foo === "bar") {
              resultSet.push(all[i]);
              if (resultSet.length > maxCount) {
                break;
              }
            }
          }
          style.removeRule(0);
          return resultSet;
        };

        return select(selector, 1)[0] || null;
      },
      /* querySelectorAll(for IE7) */
      /**
       * method returns all elements in the document that matches a specified CSS selector(s), as a static NodeList object.
       * @param {HTMLElement} elem serch target element.
       * @param {String} selector Specifies one or more CSS selectors to match the element.
       */
      querySelectorAll: function(elem, selector) {
        var doc = elem.ownerDocument;
        var style;
        var select;

        if (elem.querySelectorAll) {
          return elem.querySelectorAll(selector);
        }
        if (doc === null) {
          // "elem" is used on a node that is itself a document
          doc = elem;
        }
        style = doc.createStyleSheet();
        select = function (selector, maxCount) {
          var all = elem.all;
          var l = all.length;
          var i;
          var resultSet = [];

          style.addRule(selector, "foo:bar");
          for (i = 0; i < l; i += 1) {
            if (all[i].currentStyle.foo === "bar") {
              resultSet.push(all[i]);
              if (resultSet.length > maxCount) {
                break;
              }
            }
          }
          style.removeRule(0);
          return resultSet;
        };

        return select(selector, Infinity);
      },
      /* copyInitConfig */
      /**
       * copy init() config argument.
       * @param {Object} src copy src(init() config argument).
       */
      copyInitConfig: function(src) {
        var to = {};
        for (var keys in src) {
          if (Object.prototype.hasOwnProperty.call(src, keys)) {
            if (keys === "initInfo") {
              continue;
            }
            to[keys] = src[keys];
          }
        }
        return to;
      },
      /* setBorderRaius */
      /**
       * set border-radius which is 0.1 times the length of the short side.
       * @param {elem} elem target element.
       */
      setBorderRadius: function(elem) {
        var shortSize;
        if (!ihmi.global.isModernBrowser) {
          return;
        }
        if (elem.offsetHeight > elem.offsetWidth) {
          shortSize = elem.offsetWidth;
        } else {
          shortSize = elem.offsetHeight;
        }
        if (shortSize === 0) {//in case display none.
          return;
        }
        elem.style.borderRadius = shortSize * 0.1 + "px";
      },
      /* createRequiredMark */
      /**
       * creation of required mark.
       * @param {Object} targetElem element to add required mark.
       * @param {Object} position position adjustment of required mark.
       * @param {Object} addParent true: add parent mark aret node(ex textboxString) /false: insert root below.
       * @param {String} requiredMarkAreaClass for add class to targetElem parent("required-mark-area").
       */
      createRequiredMark: function(targetElem, adjustPos, addParent, requiredMarkAreaClass) {
        var doc = targetElem.ownerDocument;
        var IMG_URL = "/frh/ihmi/ihmicomponent_required_mark.png";
        var format = ihmi.cf.format;
        var requiredMark = doc.createElement('img');
        var markAreaHtml = [];
        var position;
        var markId;
        var markElem;
        var defAdjustPos = {
          right: "-10px",
          top: "-10px"
        };
        var areaClassName = "required-mark-area";

        if ((targetElem == null) || (targetElem.id === undefined)) {
          return;
        }
        markId = targetElem.id + ".requiredMark";
        markElem = doc.getElementById(markId);
        if (adjustPos == undefined) {
          adjustPos = defAdjustPos;
        }
        requiredMark.src = IMG_URL;
        requiredMark.id = markId;
        requiredMark.className="required-mark";
        requiredMark.style.top = (adjustPos && adjustPos.top) ? adjustPos.top: "";
        requiredMark.style.right = (adjustPos && adjustPos.right) ? adjustPos.right: "";
        requiredMark.style.left = (adjustPos && adjustPos.left) ? adjustPos.left: "";
        requiredMark.style.bottom = (adjustPos && adjustPos.bottom) ? adjustPos.bottom: "";

        if (markElem !== null) {//aleady exsit
          //adjust position
          markElem.style.top = requiredMark.style.top;
          markElem.style.right = requiredMark.style.right;
          markElem.style.left = requiredMark.style.left;
          markElem.style.bottom = requiredMark.style.bottom;
          return;
        }

        if (addParent) {
          if ((typeof requiredMarkAreaClass === 'string') && (requiredMarkAreaClass !== "")) {
            areaClassName += " " + requiredMarkAreaClass;
          }
          markAreaHtml.push(format('<div class="%s"></div>', areaClassName));
          targetElem.insertAdjacentHTML('beforebegin', markAreaHtml);
          targetElem.previousSibling.appendChild(targetElem);
          targetElem.parentNode.appendChild(requiredMark);
        } else {
          position = ihmi.cf.getCurrentStyle(targetElem).position;
          if (position === "static") {
            targetElem.style.position = "relative";
          }
          targetElem.appendChild(requiredMark);
        }
      },
      /* setRequiredMark */
      /**
       * specify show switching of required mark.
       * @param {elem} targetElem element to switch the display..
       * @param {Boolean} show show switching of required mark.
       */
      setRequiredMark: function(targetElem, show) {
        var doc;
        var markElem;
        var markId;

        if ((targetElem == null) || (targetElem.id === undefined)) {
          return;
        }
        markId = targetElem.id + ".requiredMark";
        doc = targetElem.ownerDocument;
        markElem = doc.getElementById(markId);
        if (show == undefined) {
          return;//no change
        }
        show = ihmi.cf.parseStrToBoolean(show);
        ihmi.cf.turnOnOffClass(markElem, 'hide', !show);
      },
      /* getIsOnRequiredMark */
      /**
       * get whether required mark is displayed.
       * @param {elem} targetElem element to switch the display.
       */
      getIsOnRequiredMark: function(targetElem) {
        var doc;
        var markElem;
        var markId;
        if ((targetElem == null) || (targetElem.id === undefined)) {
          return;
        }
        markId = targetElem.id + ".requiredMark";
        doc = targetElem.ownerDocument;
        markElem = doc.getElementById(markId);
        if (markElem === null) {
          return false;//not exist
        }
        if (ihmi.cf.hasClass(markElem, 'hide')) {
          return false;//off
        }
        return true;//on
      },
      isArray: function(array) {
        return (Object.prototype.toString.call(array) === '[object Array]');
      },
      /*
       * Toast component.
       * Usage: top.IHMIComponents.cf.toast.show(message, msec);
       *        ex) top.IHMIComponents.toast.show('TP key is disabled.', 2000);
       */
      toast: {
        config: {
          speed: 3000,              // Milliseconds when toast disappears
          toastList: {},            // Associative array.
                                    // A set of toast ID (key), message (first value) and timerID (second value).
          topPos: 0,                // A top position of first toast element.
          elemHeight: 0,            // A toast element height.
          observerMainFuncObj: {},  // observe main func area.
          observerAlarmObj:{},      // observe alarm area.
          dispToastID:''            // now display toast ID
        },
        toastDef: {
          DRUG: 'drug',
          NEW_TOAST: 'newToast',
          TIMEOUT: 'timeout',
          TOAST_LIST: 'toastList'
        },
        /**
         * Show toast message to top window
         * @param {String} message Output message (1 line)
         * @param {Object} optionObj toast option
         */
        show: function(message, optionObj) {
          var config = this.config;
          var toastListKey = Object.keys(config.toastList);
          if (optionObj == undefined) {
            optionObj = {};
          }
          // create Unique ID to toast.
          var toastId = 'toast' + Date.now();

          if ((optionObj.speed == undefined) || (optionObj.speed === '')) {
            // If not specified, give it default speed
            optionObj.speed = config.speed;
          }

          if (toastListKey.length > 0) {
            this.remove(toastListKey[0], this.toastDef.NEW_TOAST);
          }

          // Display time (default 3sec)
          var timerId = this.setToastTimer(toastId, optionObj);
          config.toastList[toastId] = [message, timerId];

          var toastElem = this.createToastElem(toastId, message);
          this.setToastPos(toastElem);

          ihmi.cf.addEventHandler(toastElem, "mousedown", this.mouseDown);
          ihmi.cf.addEventHandler(toastElem, "touchstart", this.mouseDown);
          return toastId;
        },
        /**
         * @param {String} toastId
         * @param {String} message
         * @returns {HTMLObject} toast element
         */
        createToastElem: function(toastId, message) {
          // Create toast popup element
          var toastElem = document.createElement('div');
          var toastSpan = document.createElement('span');
          var currentLang = '';
          if (top.irprogapi !== undefined) {
            currentLang = top.irprogapi.getCurrentLanguage();
          }
          var defFont = '';
          var TOAST_FONT_SIZE = 22;
          var className_ = 'ihcp-toast ihcp-toast-fadein ihcp-toast-flexbox';
          var classStrItem = 'ihcp-toast-flex-item';
          var TOAST_HEIGHT = 0;
          var spanHeight = 0;

          switch (currentLang) {
            case 'jp':
              className_ += ' ihcp-toast-font-kn';
              break;
            case 'eg':
              className_ += ' ihcp-toast-font-eg';
              break;
            case 'ch':
              className_ += ' ihcp-toast-font-ch';
              break;
            default:
              defFont = top.getDefFont();
              break;
          }
          if (defFont !== '') {
            switch (defFont) {
              case 'MS Gothic':
                className_ += ' ihcp-toast-font-kn';
                break;
              case 'Verdana':
                className_ += ' ihcp-toast-font-eg';
                break;
              case 'SimSun':
                className_ += ' ihcp-toast-font-ch';
                break;
              default:
                break;
            }
          }
          toastElem.id = toastId;
          toastElem.className = className_;
          toastElem.style.fontSize = TOAST_FONT_SIZE + 'px';
          toastSpan.className = classStrItem + '-adjust-center';
          toastSpan.innerHTML = message;
          toastElem.appendChild(toastSpan);
          document.body.appendChild(toastElem);
          TOAST_HEIGHT = getHeight_(toastElem);
          adjustFontSize_(toastSpan, TOAST_HEIGHT);
          spanHeight = getHeight_(toastSpan);
          if (TOAST_HEIGHT <= spanHeight) {
            toastSpan.classList.replace(classStrItem + '-adjust-center',
                                        classStrItem + '-adjust-top');
          }
          return toastElem;
        },
        setToastPos: function(toastElem) {
          var config = this.config;
          // Calculation of display position
          if (config.elemHeight === 0) {
            config.elemHeight =  toastElem.offsetHeight;
          }
          // when create first toast, set a topPos.
          if (config.topPos === 0) {
            this.setTopPos();
            this.observeMainFunc();
          }
          this.placeToast();
        },
        placeToast: function() {
          var config = this.config;
          var toastID = Object.keys(config.toastList)[0];
          var toastElem = document.getElementById(toastID);
          // sometimes do placeToast method after toast disappear.
          if (toastElem === null) return;
          toastElem.style.position = 'absolute';
          toastElem.style.top = config.topPos + 'px';
        },
        /**
         * setTimeout in toast
         * @param {String} toastID
         * @param {Object} optionObj for debug, edit toast display time.
         * @returns timerID
         */
        setToastTimer: function(toastID, optionObj) {
          var toast = ihmi.cf.toast;
          var config = this.config;
          config.dispToastID = toastID;
          var timerID = setTimeout(function() {
            toast.remove(toastID, toast.toastDef.TIMEOUT);
          }, config.speed);

          // set toast time for debug
          // var timerID = setTimeout(function() {
          //   toast.remove(toastID, toast.toastDef.TIMEOUT);
          // }, optionObj.speed);
          return timerID;
        },
        /** Check toast is displayed.
        * @param {String} toastId Caller's unique ID
        * @return {Boolean}       displayed=true, not displayed=false
        */
        getToast: function(toastId) {
          var toastList = this.config.toastList;
          var toastExistResult = this.checkToast(toastId);
          switch (toastExistResult) {
            case this.toastDef.TOAST_LIST:
              return {'message': toastList[toastId][0]};
            default:
              return null;
          }
        },
        checkToast: function(toastId) {
          var toastDef = this.toastDef;
          var toastList = this.config.toastList;
          var result = null;
          if (toastId in toastList) {
            result = toastDef.TOAST_LIST;
          }
          return result;
        },
        /** Disappear (hide and remove)
        * @param {String} toastId toast element id
        * @param {Number} deleteType
        *           toast item is drug    -> drug
        *           on purpose delete     -> newToast,
        *           timeout call remove method -> timeout,
        *           user remove toast item -> undefined
        * @return {Boolean} remove result
        */
        remove: function(toastId, deleteType) {
          var toast = ihmi.cf.toast;
          var config = this.config;
          var hideToastElem = document.getElementById(toastId);
          var checkToastID = this.checkToast(toastId);
          if (checkToastID === null) return false;
          hideToastElem.classList.remove('ihcp-toast-fadein');

          switch (deleteType) {
            case this.toastDef.DRUG:
            case undefined:
              hideToastElem.classList.add('ihcp-toast-quick-fadeout');
              clearTimeout(config.toastList[toastId][1]);
              delete config.toastList[toastId];
              toastTimeout(hideToastElem, 80);
              break;
            /* eslint-disable no-fallthrough */
            case this.toastDef.NEW_TOAST:
              clearTimeout(config.toastList[toastId][1]);
            case this.toastDef.TIMEOUT:
              hideToastElem.classList.add('ihcp-toast-fadeout');
              delete config.toastList[toastId];
              toastTimeout(hideToastElem, 200);
              break;
            /* eslint-enable no-fallthrough */
            default:
              break;
          }
          return true;
          function toastTimeout(toastElem, timer) {
            setTimeout(function() {
              document.body.removeChild(toastElem);
              config.topPos = 0;
              config.dispToastID = '';
              toast.disconnectObserveMainFunc();
            }, timer);
          }
        },
        // Drug Function
        // mousedown -> mousemove -> mouseup or mouseleave
        mouseDown: function(e) {
          e.preventDefault();
          var event = {};
          var elem = e.currentTarget;
          absorbDeviceDiff(e);
          var toastId = elem.id;
          var toast = ihmi.cf.toast;
          var config = toast.config;
          var firstY = event.clientY;
          var shiftY = firstY - elem.getBoundingClientRect().top;
          var checkToastID = null;
          elem.style.position = 'absolute';
          elem.style.zIndex = 10000;

          if ((e.type === 'touchstart') && (e.touches.length > 1)) {
            return false;
          }
          checkToastID = toast.checkToast(toastId);
          if (checkToastID === null) return false;
          clearTimeout(config.toastList[toastId][1]);
          // hang elem in document
          if (ihmi.global.isTablet) {
            // ie don't support append method.
            // when not this process, tablet (android and iOS) don't function.
            document.body.append(elem);
          }
          // android, iphone -> window don't set event.
          // quick move cause untracking move event.
          //   -> we limit area of leave and cancel.
          if (e.type.startsWith('touch')) {
            addEventHandler_(document, 'touchmove', mouseMove);
            addEventHandler_(elem, 'touchend', mouseUp);
            addEventHandler_(elem, 'touchcancel', mouseUp);
          } else {
            addEventHandler_(document, 'mousemove', mouseMove);
            addEventHandler_(elem, 'mouseup', mouseUp);
            addEventHandler_(elem, 'mouseleave', mouseUp);
          }
          function mouseMove(e) {
            e.preventDefault();
            absorbDeviceDiff(e);
            var nowPoint = document.elementFromPoint(event.pageX, event.pageY);
            var nowY = event.pageY;
            var upDownCheck = (Math.abs(nowY - firstY) > config.elemHeight);
            var leftRightCheck = (nowPoint === null);
            elem.style.top = nowY - shiftY + 'px';
            // if a cursor moves per one element, the element fadeout.
            if (upDownCheck || leftRightCheck) {
              mouseUp(e);
              return;
            }
          }
          function mouseUp(e) {
            removeTouchMouseEvent(e);
            toast.remove(toastId, toast.toastDef.DRUG);
          }
          function absorbDeviceDiff(e) {
            if (e.type.startsWith('touch')) {
              event = e.touches[0];
            } else {
              event = e;
            }
          }
          // android, iphone -> window don't set event.
          function removeTouchMouseEvent() {
            if (e.type.startsWith('touch')) {
              removeEventHandler_(elem, 'touchstart', toast.mouseDown);
              removeEventHandler_(document, 'touchmove', mouseMove);
              removeEventHandler_(elem, 'touchcancel', mouseUp);
              removeEventHandler_(elem, 'touchend', mouseUp);
            } else {
              removeEventHandler_(elem, 'mousedown', toast.mouseDown);
              removeEventHandler_(document, 'mousemove', mouseMove);
              removeEventHandler_(elem, 'mouseleave', mouseUp);
              removeEventHandler_(elem, 'mouseup', mouseUp);
            }
          }
        },
        observeMainFunc: function() {
          var that = this;
          var config = this.config;
          var mainFuncArea = document.getElementById('mainfunc_area');

          if (mainFuncArea === null) return;

          var resultObserverObj = this.checkObserverObj(config.observerMainFuncObj);
          if (!resultObserverObj) {
            config.observerMainFuncObj = new MutationObserver(function(){
              resultObserverObj = that.checkObserverObj(config.observerAlarmObj);
              var alarmArea = document.getElementById('almArea');

              if (alarmArea !== null) {
                that.observeAlarm();
              }
              if (alarmArea === null && resultObserverObj) {
                config.observerAlarmObj.disconnect();
              }
              that.setTopPos();
              that.placeToast();
            });
          }
          var observeOption = {
            childList : true
          };
          config.observerMainFuncObj.observe(mainFuncArea, observeOption);
        },
        observeAlarm: function() {
          var that = this;
          var config = this.config;
          var alarmArea = document.getElementById('almArea');
          var alarmHeight = alarmArea.offsetHeight;
          if (alarmHeight === 0) return;

          var resultObserverObj = this.checkObserverObj(config.observerAlarmObj);
          if (!resultObserverObj) {
            config.observerAlarmObj = new MutationObserver(function(){
              that.setTopPos();
              that.placeToast();
            });
          }
          var observeOption = {
            childList : true
          };
          config.observerAlarmObj.observe(alarmArea, observeOption);
        },
        disconnectObserveMainFunc: function() {
          var config = this.config;
          var resultMainFuncObserverObj = this.checkObserverObj(config.observerMainFuncObj);
          var resultAlarmObserverObj = this.checkObserverObj(config.observerAlarmObj);

          if (resultMainFuncObserverObj) {
            config.observerMainFuncObj.disconnect();
          }
          if (resultAlarmObserverObj) {
            config.observerAlarmObj.disconnect();
          }
        },
        checkObserverObj: function(targetObj) {
          var objType = Object.prototype.toString.call(targetObj);
          var checkIndex = objType.toLowerCase().indexOf('mutation', 8);
          return checkIndex === -1 ? false : true;
        },
        getMainFrmTop: function() {
          var mainfrmElem = document.getElementById('mainfrm');
          return mainfrmElem.getBoundingClientRect().top;
        },
        getAlarmHeight: function() {
          var alarmArea = document.getElementById('almArea');
          var alarmHeight = 0;
          if (alarmArea !== null) {
            alarmHeight = alarmArea.offsetHeight === 0 ?
                            0 : alarmArea.offsetHeight + 5;
          }
          return alarmHeight;
        },
        setTopPos: function() {
          var config = this.config;
          var mainFrmTop = this.getMainFrmTop();
          var alarmHeight = this.getAlarmHeight();
          var STATUS_DEFAULT_HEIGHT = 65;
          // In iOS Device,
          //  sometimes mainFrmTop gets negative value.
          // Because top frame moves.
          if (mainFrmTop < 0) mainFrmTop = STATUS_DEFAULT_HEIGHT;

          config.topPos = mainFrmTop + alarmHeight;
        }
      },
      /**
       * @param {HTMLElemet} elem
       * @param {Number} defaultHeight set in init
       */
      adjustFontSize: function(elem, defaultHeight) {
        var elemStyle = getCurrentStyle_(elem);
        var elemHeight = 0;
        var elemFontSize = 0;
        elem.style.fontSize = "";
        elemFontSize = parseFloat(elemStyle.fontSize);
        do {
          elem.style.fontSize = elemFontSize + 'px';
          /** window is null -> return -1 */
          elemHeight = getHeight_(elem);
          elemFontSize -= 1;
          if (elemHeight == -1) {
            break;
          }
        } while ((defaultHeight < elemHeight) && (16 <= elemFontSize));
        return (elemHeight <= defaultHeight);
      },
      /**
       * @param {HTMLElement} elem
       * @returns number element width
       */
      getWidth: function(elem) {
        var elemRect = {};
        var rectWidth = 0;
        var styleObj = null;
        var zoomFactor = 0;
        var adjustScreenSize = 1;
        var hasPx = false;
        if (elem == null) {
          return -1;
        }
        elemRect = elem.getBoundingClientRect();
        /** if element is hidden, rectWidth is 0. */
        rectWidth = elemRect.right - elemRect.left;
        styleObj = getCurrentStyle_(elem);
        zoomFactor = getZoomFactor_(elem);
        if (zoomFactor !== 1) {
          adjustScreenSize = 1.53;
        }
        if (styleObj === null) {
          return -1;
        }
        /**
         * true -> unit is 'px'
         * false -> unit is '%' or value is 'auto'
         *  corresponds to calc CSS method(tab component:IE11)
         */
        hasPx = (styleObj.width.indexOf('px') === (styleObj.width.length - 2));
        return hasPx ? parseFloat(styleObj.width)
                     : (rectWidth * adjustScreenSize);
      },
      getHeight: function(elem) {
        var elemRect = {};
        var rectHeight = 0;
        var styleObj = null;
        var zoomFactor = 0;
        var adjustScreenSize = 1;
        var hasPx = false;

        if (elem == null) {
          return -1;
        }
        elemRect = elem.getBoundingClientRect();
        /** if element is hidden, rectWidth is 0. */
        rectHeight = elemRect.bottom - elemRect.top;
        styleObj = getCurrentStyle_(elem);
        zoomFactor = getZoomFactor_(elem);
        if (zoomFactor !== 1) {
          adjustScreenSize = 1.53;
        }
        if (styleObj === null) {
          return -1;
        }
        /**
         * true -> unit is 'px'
         * false -> unit is '%' or value is 'auto'
         */
        hasPx = (styleObj.height.indexOf('px') === (styleObj.height.length - 2));
        return hasPx ? parseFloat(styleObj.height)
                     : (rectHeight * adjustScreenSize);
      },
      getClientX: function(event) {
        var e = {};
        e = (event.type.indexOf('touch') === -1)
          ? event                 // mouse Event
          : event.touches[0];     // touch Event
        return e.clientX;
      },
      getClientY: function(event) {
        var e = {};
        e = (event.type.indexOf('touch') === -1)
          ? event                 // mouse Event
          : event.touches[0];     // touch Event
        return e.clientY;
      },
      preventBrowserDefault: function(event) {
        if (event.cancelable) {
          event.preventDefault ? event.preventDefault()
                               : (event.returnValue = false);
        }
      },
      /**
       * Extended version of stopPropagation
       * @param {EventObject} event
       */
      stopEventBubble: function(event) {
        event.stopPropagation ? event.stopPropagation()
                              : (event.cancelBubble = true);
      },
      removeSelection: function(elem) {
        var doc = elem.ownerDocument;
        if (doc.getSelection) {
          var seltext = doc.getSelection();
          if (seltext.toString().length > 0) {
            seltext.removeAllRanges();
          }
        }
      },
      escapeHTML: function(text) {
        text = text.replace(/[<>'`"&]/g, function(match){
          return {
            '&': '&amp;',
            "'": '&#x27;',
            '`': '&#x60;',
            '"': '&quot;',
            '<': '&lt;',
            '>': '&gt;'
          }[match];
        });
        return text;
      },
      createCustomEvent: function(eventTarget, eventType, customArg) {
        var customEvent = null;
        var doc = eventTarget.ownerDocument;
        if (typeof CustomEvent === 'function') {
          customEvent = new CustomEvent(eventType, {
            detail: customArg
          });
        } else {
          /**
           * CustomEvent is Object or no.
           * When IE, CustomEvent is Object.
           */
          customEvent = doc.createEvent('CustomEvent');
          customEvent.initCustomEvent(
            eventType,      // type
            false,          // canBubble
            false,          // cancelable
            customArg       // detail
          );
        }
        eventTarget.dispatchEvent(customEvent);
      },
      /** create Background svg strings.
      * @param {String} svgStr free <svg ~> or global.svgStrs sring.
      * @param {String} definedSvgW Width of predefined SVG data
      * @param {String} definedSvgH Height of predefined SVG data
      * @return {String} encoded svg data
      */
      createBgSvgStr: function(svgStr, definedSvgW, definedSvgH) {
        var headerStr = 'data:image/svg+xml;charset=UTF-8,';
        var dataStr = svgStr;
        var w = (!definedSvgW) ? 32 : definedSvgW;
        var h = (!definedSvgH) ? 32 : definedSvgH;

        if (!dataStr) {
          return '';
        }
        if (dataStr.indexOf('<svg') === -1) {
          // If not svg data, use defined svg.
          dataStr = ihmi.global.svgStrs[svgStr];
          if (!dataStr) {
            return '';
          }
          dataStr = format_(dataStr, w, h);
        }
        dataStr = 'url("' + headerStr + encodeURIComponent(dataStr) + '")';
        return dataStr;
      },
      /** Polyfill for String.prototype.includes() for IE11
      * @param {Array} array - The array to search within.
      * @param {*} searchElement - The element to search for in the array.
      * @param {number} [fromIndex=0] - Returns true if the array contains the searchElement, otherwise false.
      * @returns {Boolean} - true if the element is included, otherwise false.
      */
      includesArray: function(array, searchElement, fromIndex) {
        if (array == null) {
          console.log('[ERROR] ihcp includesArray: "array" is null or not defined');
          return;
        }
        if (Array.prototype.includes) {
          return array.includes(searchElement, fromIndex);
        }

        // for IE
        var len = array.length >>> 0;
        if (len === 0) {
          return false;
        }

        var n = fromIndex | 0;
        var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);

        function sameValueZero(x, y) {
          return x === y || ((typeof x === 'number') && (typeof y === 'number') && isNaN(x) && isNaN(y));
        }

        while (k < len) {
          if (sameValueZero(array[k], searchElement)) {
            return true;
          }
          k++;
        }
        return false;
      },
      /** Polyfill for Object.assign() for IE11
      * @param {Object} target - The target object to which properties will be copied.
      * @param {...Object} sources - One or more source objects containing properties to be copied to the target object.
      * @returns {Object} - The target object with merged properties.
      */
      objectAssignPolyfill: function(target) {
        if (typeof Object.assign == 'function') {
          return Object.assign.apply(Object, arguments);
        }
        // below for IE11
        if (target == null) { // TypeError if undefined or null
          console.log('[ERROR] ihcp objectAssignPolyfill: Cannot convert undefined or null to object');
          return null;
        }
        var to = Object(target);

        for (var index = 1; index < arguments.length; index++) {
          var nextSource = arguments[index];
          if (nextSource != null) { // Skip over if undefined or null
            for (var nextKey in nextSource) {
              // Avoid bugs when hasOwnProperty is shadowed
              if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                to[nextKey] = nextSource[nextKey];
              }
            }
          }
        }
        return to;
      }
    },
    select: {
      init: function(doc, id, config) {
        var frame = getDefaultView_(doc);
        var elem = doc.getElementById(id),
            type = this,
            ul = doc.getElementById(elem.id + '.options'),
            label = doc.getElementById(elem.id + '.label'),
            ieVersion = getIEVersion_(userAgent),
            button;
        var divElem;
        config.numDefaultOptions = ul.children.length;
        config.labelClass = label.className;
        config.selected = null;
        config.onmouseleave = null;
        config.monitoringFrameFunc = null;
        config.onmouseover = null;
        config.onmouseout = null;
        config.useRequiredMark = parseStrToBoolean_(config.useRequiredMark);
        config.notifySameVal = parseStrToBoolean_(config.notifySameVal);
        config.escapeHTML = parseStrToBoolean_(config.escapeHTML);
        config.optionHTML = [];
        config.isEscaped = {};
        elem.config = config;
        elem.config.invalidColorRed03 = parseStrToBoolean_(config.invalidColorRed03);
        elem.refresh = type.refresh;
        elem.getValue = type.getValue;
        elem.getText = type.getText;
        elem.getOptions = type.getOptions;
        elem.getOptionProperty = type.getOptionProperty;
        elem.setLabelText = type.setLabelText;
        elem.setFocus = type.setFocus;
        elem.setCallback = type.setCallback;
        elem.releaseEvents = type.releaseEvents;
        elem.closeOptions = type.closeOptions;
        elem.config.initInfo = {};
        elem.config.initInfo.config = copyInitConfig_(config);
        elem.config.initInfo.root = elem.cloneNode(true);
        button = findDescendant_(elem, 'button', 'select-button');
        if (ieVersion === 7) {
          button.hideFocus = true;
        }
        determineDefaultDesignPattern_(elem);
        config.shrink = false; //option shrink is not needed now.
        /*
        if ((elem.config.designpattern ==="touch") &&
            (ieVersion === -1 || ieVersion >= 11) &&
            (config.width != undefined)) {
          config.shrink = parseStrToBoolean(config.shrink);
        } else {
          config.shrink = false;
        }*/
        if (config.useRequiredMark) {
          elem.setRequiredMark = type.setRequiredMark;
          elem.setRequiredMark(false, null);
        }

        addEventHandler_(button, "focus", type.onfocus);
        addEventHandler_(button, "blur", type.onblur);

        addEventHandler_(elem, "click", type.onclick);
        if (config.escapeHTML) {
          addEventHandler_(frame, 'load', staticEscapeHTML);
        }
        // [#9488] Adjust the position of the 'Down arrow' on the iPad.
        if (ihmi.global.isiPad && hasClass_(elem, 'mouse')) {
          var mouseElem = elem.getElementsByClassName('select-arrow');
          for (var ii = 0; ii < mouseElem.length; ii++) {
            mouseElem[ii].style.marginTop = '8px';
            mouseElem[ii].style.marginLeft = '-2px';
          }
        }
        if (config.shrink) {
          divElem = firstElementNode_(elem);
          config.defaultHeight = getHeight_(divElem);
          addClass_(elem, "select-shrink");
        }
        function staticEscapeHTML() {
          var li = firstElementNode_(ul);
          var props = null;
          var arr = [];
          if (config.optionHTML.length === 0) {
            for (var i = 0; (i < config.numDefaultOptions) && (li !== null); i++) {
              props = elem.getOptionProperty(li);
              props.selected = false;
              if (config.isEscaped[props.value] !== props.text) {
                props.text = escapeHTML_(props.text);
                config.isEscaped[props.value] = props.text;
              }
              if (props.image) {
                props.image = format_(
                  '<img src="%s"'
                + ' class="select-option-icon"'
                + ' align="absmiddle">', props.image);
              } else {
                props.image = '';
              }
              arr.push(format_(
                  '<li class="select-option %s"'
                + ' data-value="%s">'
                + '<a href="javascript:void(0);">%s%s</a>'
                + '</li>',
                props.className, props.value, props.image, props.text)
              );
              li = nextElementNode_(li);
            }
            arr.push(config.optionHTML);
            config.optionHTML = arr;
            ul.innerHTML = config.optionHTML.join('');
          }
        }
      },
      refresh: function(options, selectedValue, selectedText, disabled) {
        var elem = this,
            config = elem.config,
            doc = elem.ownerDocument,
            ul = doc.getElementById(elem.id + '.options'),
            button = findDescendant_(elem, 'button', 'select-button'),
            numDefaultOptions = config.numDefaultOptions,
            optionsHTML = [],
            selectedProps = null,
            decimalComma = ihmi.global.decimalComma,
            isFloat = (/^-?\d*\.\d+$/).test(selectedValue),
            li, i, props, invalidClassName, isObject;

        function formatFloat(text) {
          return decimalComma ? text.replace(/\./, ",")
                              : text.replace(/,/, ".");
        }

        function pushHTMLOptions() {
          props.selected = false;

          if ((selectedProps === null) &&
              (props.value == selectedValue)) {
            props.selected = true;
            selectedProps = props;
          }
          optionsHTML.push(optionHTML(
            props.text,
            props.value,
            props.className,
            props.image,
            props.selected
          ));
        }
        function optionHTML(text, value, className, image, selected) {
          var tagImage = '';
          if (selected) {
            className += " select-option-selected"
                      + " select-option-highlight";
          }
          if (isFloat) {
            text = formatFloat(text);
          }
          if (config.escapeHTML) {
            if (config.isEscaped[value] !== text) {
              text = escapeHTML_(text);
              config.isEscaped[value] = text;
            }
          }
          if (image) {
            tagImage = format_(
              '<img src="%s"'
            + ' class="select-option-icon"'
            + ' align="absmiddle">', image);
          }
          return format_(
              '<li class="select-option %s"'
            + ' data-value="%s">'
            + '<a href="javascript:void(0);">%s%s</a>'
            + '</li>',
            className, value, tagImage, text);
        }
        if (options == null) {
          options = [];
        }
        // float value must not be string, because comparing value does not work properly.
        if (isFloat) {
          selectedValue = parseFloat(selectedValue);
        }

        /* default options */
        li = firstElementNode_(ul);
        for (i = 0; (i < numDefaultOptions) && (li !== null); i++) {
          props = elem.getOptionProperty(li);
          pushHTMLOptions();
          li = nextElementNode_(li);
        }

        /* new options */
        for (i = 0; i < options.length; i++) {
          if (options[i] === undefined) {
            continue;
          }
          isObject = (typeof options[i] === "object");
          props = {
            text: isObject ? options[i][0] : options[i],
            value: isObject ? options[i][1] : options[i],
            image: isObject ? options[i][2] : null
          };
          props.className = "";
          pushHTMLOptions();
        }

        /* invalid option */
        if ((selectedProps === null) &&
            (selectedValue !== null)) {
          invalidClassName = (config.invalidColorRed03 === true)
                                      ? "invalid-red03" : "invalid";
          props = {};
          props.className = invalidClassName;
          props.text = (selectedText !== null) ? selectedText
                                                : selectedValue;
          if (typeof props.text === "number") {
            props.text = "(" + props.text + ")";
          }
          selectedProps = props;
          optionsHTML.push(optionHTML(
            props.text,
            selectedValue,
            props.className,
            null,
            true
          ));
        }

        config.optionHTML = optionsHTML;

        if (isFloat) {
          selectedProps.text = formatFloat(selectedProps.text);
        }
        elem.setLabelText(selectedProps);
        config.selected = selectedValue;
        elem.disabled = disabled;
        button.disabled = disabled;
        turnOnOffClass_(elem, 'disabled', disabled);
        turnOnOffClass_(button, 'disabled', disabled);
        setTimeout(function() {
          ul.innerHTML = config.optionHTML.join('');
        }, 0);
      },
      onfocus: function(event) {
        var target = event.srcElement;
        var elem = hasClass_(target, 'select')
                      ? target : findAncestor_(target, 'span', 'select');

        if (elem.disabled) {
          target.blur();
          return false;
        }
        addClass_(elem, "focus");
        return false;
      },
      onblur: function(event) {
        var target = event.srcElement;
        var elem = hasClass_(target, 'select')
                      ? target : findAncestor_(target, 'span', 'select');
        var isDeviceIE7 = (getIEVersion_(userAgent) === 7);
        var doc = elem.ownerDocument;
        var options = doc.getElementById(elem.id + '.options');
        var isSelectOpen = !hasClass_(options, 'hide');
        if (isDeviceIE7 && isSelectOpen) {
          return false;
        }
        removeClass_(elem, "focus");
        return false;
      },
      getValue: function() {
        var elem = this,
            value = elem.config.selected;
        return (typeof value === "number") ? value.toString(10)
                                           : value;
      },
      getText: function() {
        var elem = this,
            selectedOption = findDescendant_(elem, "li", "select-option-selected"),
            props;
        if (selectedOption === null) {
          return "";
        }
        props = elem.getOptionProperty(selectedOption);
        return props.text;
      },
      getOptions: function() {
        var elem = this,
            doc = elem.ownerDocument;
        return doc.getElementById(elem.id + ".options");
      },
      getOptionProperty: function(option) {
        var img = findDescendant_(option, 'img', 'select-option-icon'),
            iconName = null,
            optionChild = firstElementNode_(option),
            label = optionChild.innerHTML;
        var IMG_END_TAG = '>';
        var endTagIndex = 0;

        if (img !== null) {
          iconName = img.src;
          endTagIndex = label.indexOf(IMG_END_TAG);
          label = label.slice(endTagIndex + 1);//delete img html
        }
        label = label.replace(/[\n]|(<!--)|(-->)/g,'');
        label = label.replace(/(^ +)/,'').replace(/( +$)/, '');

        var props = {
          className: option.className,
          text: label,
          value: option.getAttribute('data-value'),
          image: iconName
        };
        removeClasses_(props, "select-option"
                            + " select-option-selected"
                            + " select-option-highlight");
        return props;
      },
      setLabelText: function(props) {
        var elem = this,
            config = elem.config,
            doc = elem.ownerDocument,
            image = doc.getElementById(elem.id + '.image'),
            label = doc.getElementById(elem.id + '.label'),
            divElem = firstElementNode_(elem),
            iconRightMargine = 0,
            imageWidth = 0,
            userSetWidth = 0,
            SELECT_IMAGE_WIDTH_TOUCH = 40,
            SELECT_IMAGE_WIDTH_MOUSE = 26,
            lblClassStr,
            dividResultWidth,
            shrinkLabel,
            adjustResult;
        if (props == undefined) {
          return;
        }

        if (label) {
          lblClassStr = config.labelClass + " " + props.className;
          if (config.shrink) {
            shrinkLabel = findDescendant_(elem, 'label', 'select-shrinklbl');
            lblClassStr += " select-shrinklbl";
            if (shrinkLabel === null) {
              //add shrink label elem(B) in label elem(A).
              //(A) over flow : hidden
              //(B) break-all,
              shrinkLabel = doc.createElement('label');
              shrinkLabel.id = elem.id + ".shrinkLbl";
              label.appendChild(shrinkLabel);
            }
            shrinkLabel.className = lblClassStr;
            shrinkLabel.innerHTML = props.text;
          } else {
            label.className = lblClassStr;
            label.innerHTML = props.text;
          }
        }
        if (props.image) {
          if (image === null) {
            image = doc.createElement('img');
            image.id = elem.id + ".image";
            image.className = "select-icon";
            image.align = "absmiddle";
            label.parentNode.insertBefore(image, label);
          }
          iconRightMargine = 5;
          image.src = format_("%s", props.image);
          addClass_(elem, 'select-with-icon');
        } else {
          removeClass_(elem, 'select-with-icon');
        }
        if (hasClass_(label, 'select-fixed-width')) { //for css(ellipsis)
          setTimeout(function() {
            if (props.image) {
              if (image.clientWidth > 0) {
                imageWidth = image.clientWidth;
              } else {//display:none
                imageWidth = (config.designpattern === "mouse")
                                          ? SELECT_IMAGE_WIDTH_MOUSE
                                          : SELECT_IMAGE_WIDTH_TOUCH;
              }
            }
            dividResultWidth = divideNumUnit_(divElem.style.width);
            if ((dividResultWidth !== null) &&
                (dividResultWidth.unit === "px")) {
              userSetWidth = parseInt(dividResultWidth.num, 10);
            }
            if (userSetWidth > 0) {
              label.style.width = (((userSetWidth - imageWidth - iconRightMargine) / userSetWidth) * 100) + "%";
            }
            if (config.shrink) {
              adjustResult = adjustFontSize_(shrinkLabel, config.defaultHeight);
              if (adjustResult) {
                label.style.alignItems = "center";
              } else {
                label.style.alignItems = "flex-start";
              }
            }
          }, 0);
        }
      },
      setFocus: function() {
        var elem = this,
            button = findDescendant_(elem, 'button', 'select-button');
        button.focus();
      },
      global: {
        openedElement: null
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      onclick: function(event) {
        var target = event.srcElement,
            elem = hasClass_(target, 'select') ? target : findAncestor_(target, 'span', 'select'),
            global = ihmi.select.global,
            closeSelection = false;

        if ((global.openedElement !== null) &&
            (global.openedElement !== elem)) {
          try { // If global.openedElement does not exist, an error will occur.
            triggerEvent_(global.openedElement, 'click');
          } catch (e) {
            global.openedElement = null;
          }
          if (elem === null || elem.disabled) {
            return false;
          }
        }

        var handleKeys = function(event) {
          var options = findDescendant_(elem, "ul", "select-options"),
              currSelected = findDescendant_(options, "li", "select-option-highlight"),
              nextSelected, dist, direction;

          preventBrowserDefault_(event);
          if (currSelected === null) return true;

          switch (event.keyCode) {
            case 13:  // enter key
              elem.releaseEvents();
              currSelected.click();
              return false;
            case 27:  // prev
              elem.releaseEvents();
              elem.click();
              return false;
            default:
              dist = ihmi.cf.keyEventToDistance(event);
              break;
          }

          if (dist === 0) return true;

          nextSelected = getNextNode_(options, currSelected, dist);
          direction = dist / Math.abs(dist);
          while ((hasClass_(nextSelected, "invalid") ||
                  hasClass_(nextSelected, "invalid-red03")) &&
                  !hasClass_(nextSelected, "select-option-selected")) {
            nextSelected = getNextNode_(options, nextSelected, direction);
            if (nextSelected === currSelected) {
              return true;
            }
          }

          if (nextSelected !== null) {
            addClassExclusively_(options, nextSelected, "select-option-highlight");
            scrollTo_(options, nextSelected);
            return false;
          }
          return true;
        };

        var config = elem.config,
            doc = elem.ownerDocument,
            options = doc.getElementById(elem.id + '.options'),
            button = findDescendant_(elem, 'button', 'select-button'),
            frame = getDefaultView_(doc),
            value = null,
            node, style, zIndex, area, props, selectedOption,
            newTarget, newElem;

        if (!elem.disabled) {
          elem.setFocus();
        }

        if (!hasClass_(options, 'hide') || elem.disabled) { // close options
          switch (target.tagName) {
            case 'LI':
            case 'A':
            case 'IMG':
              if (target.tagName === "A") {
                target = target.parentNode;
              } else if (target.tagName === "IMG") {
                target = target.parentNode.parentNode;
              }
              value = target.getAttribute('data-value');
              break;
            default:
              selectedOption = findDescendant_(options, "li", "select-option-selected");
              if (selectedOption !== null){
                addClassExclusively_(options, selectedOption, "select-option-highlight");
              }
              break;
          }

          closeSelection = elem.disabled ?
            true : config.notifySameVal ?
              (value === null) : (value === null || value == config.selected);
          if (closeSelection) {
            elem.closeOptions(options, elem); // do nothing more than closing option
          } else {
            config.selected = value;

            addClassExclusively_(elem, target, "select-option-highlight");
            addClassExclusively_(elem, target, "select-option-selected");

            frame.setTimeout(function() {
              props = elem.getOptionProperty(target);
              elem.setLabelText(props);
              elem.closeOptions(options, elem);

              if (typeof config.callback === 'function') {
                // Local select function to execute instead of sending request
                config.callback(elem.id, "changed", value);
              } else {
                IUIFRequest_(frame, {
                  request: elem.id + ".changed",
                  value: value
                }).send();
              }
            }, 0);
          }

          triggerEvent_(elem, 'resizeend');
          ihmi.cf.KeyEvent.popHandler();

          elem.releaseEvents();
          if (getIEVersion_(userAgent) !== -1) {  // when IE
            newTarget = doc.elementFromPoint(event.clientX, event.clientY);
            if (newTarget) {
              newElem = hasClass_(newTarget, 'select')
                          ? newTarget : findAncestor_(newTarget, 'span', 'select');
            }
            if (global.openedElement !== newElem) { // another select click
              button.blur();
            }
          }
          if (getIEVersion_(userAgent) === 11) {
            if (newTarget === null                    // outside document
              || newElem === null                     // not select elem
              || newElem.disabled
              || global.openedElement === newElem) {   // same select elem
              global.openedElement = null;
              return false;
            }
            global.openedElement = null;
            newElem.click();    // open another select
          } else {
            global.openedElement = null;
          }
        } else { // open options
          //if not setting default value, first option highlight.
          var ul;
          var firstLi;
          var findResult = findDescendants_(elem, "li", "select-option-highlight");
          if (findResult.length === 0){
            ul = doc.getElementById(elem.id + '.options');
            firstLi = firstElementNode_(ul);
            if (firstLi == undefined) {// not exist options
              return;
            }
            addClass_(firstLi, "select-option-selected select-option-highlight");
          }

          // Because of IE bug, z-index must be specfied to parent element which has 'position:relative'
          zIndex = getCurrentStyle_(options).zIndex;
          node = options.parentNode;
          while ((node !== null) && (node.style !== undefined)) {
            node.style.zIndex = zIndex;
            node = node.parentNode;
          }

          // Find scroll area
          node = options.parentNode;
          style = getCurrentStyle_(node);
          area = null;
          while ((node !== null) && (style !== null) && (area === null)) {
            if (style.overflow !== "visible") {
              area = node;
            }
            node = node.parentNode;
            style = getCurrentStyle_(node);
          }
          if (area === null) {
            area = doc.documentElement;
          }

          removeClass_(options, 'hide'); // This line should be executed before options.clienHeight is got
          addClass_(elem, 'opened');

          var areaTop = area.scrollTop + cumulativeOffsetTop_(area),
              areaLeft = area.scrollLeft + cumulativeOffsetLeft_(area),
              areaHeight = area.clientHeight,
              areaWidth = area.clientWidth,
              targetTop = cumulativeOffsetTop_(elem),
              targetLeft = cumulativeOffsetLeft_(elem),
              targetHeight = elem.offsetHeight,
              margin = 3,
              scrollbarWidth = 18,
              optionsHeight = options.clientHeight + margin * 2,
              optionsWidth = options.clientWidth + margin * 2,
              offsetLeft = 0,
              cssProps = [], currentLeft;

          var marginTop = targetTop - areaTop - optionsHeight;
          var marginBottom = areaTop + areaHeight - (targetTop + targetHeight + optionsHeight);
          var marginLeft = targetLeft - areaLeft;
          var marginRight = areaLeft + areaWidth - (targetLeft + optionsWidth);

          if (marginRight < 0) {
            currentLeft = parseInt(getCurrentStyle_(options).left, 10);
            offsetLeft = Math.max(marginLeft * -1, marginRight);
            cssProps.push('left:' + (currentLeft + offsetLeft) + 'px;');
          }

          if (marginBottom < 0) { // pulldown options will overflow
            if (marginTop >= 0) { // pullup options
              addClass_(options, 'select-options-pullup');
            } else {
              if (optionsHeight <= areaHeight) { // displace options
                if (marginBottom > marginTop) {
                  cssProps.push('top:' + (marginBottom + targetHeight) + 'px;');
                  cssProps.push('bottom: auto;');
                } else {
                  cssProps.push('top: auto;');
                  cssProps.push('bottom:' + (marginTop + targetHeight) + 'px;');
                }
              } else { // options with scroll bar
                if (targetLeft + offsetLeft + optionsWidth + scrollbarWidth < areaLeft + areaWidth) {
                  optionsWidth += scrollbarWidth;
                }
                cssProps.push('width:' + (optionsWidth - margin * 2) + 'px;');
                cssProps.push('height:' + ((areaHeight - margin * 2) - 1) + 'px;'); // if the list is exactly the same height as the <body>, scrollbars may be displayed in the <body>, so set -1.
                cssProps.push('top:' + (areaTop - targetTop + margin) + 'px;');
                addClass_(options, 'scrolling'); // This line should be after options.clientWidth is got
                scrollTo_(options, findDescendant_(options, "li", "select-option-highlight"));
                if (ihmi.global.isIEMobile) {
                  frame.setTimeout(function() { // Wihtout the following line, scroll bar is not shown at first.
                    var height = options.style.height;
                    options.style.height = 0;
                    options.style.height = height;
                  }, 0);
                }
              }
            }
          }

          if (cssProps.length > 0) {
            options.style.cssText = cssProps.join(' ');
          }
          triggerEvent_(elem, 'resizestart');
          ihmi.cf.KeyEvent.addHandler(handleKeys, frame, false);

          if (ihmi.cf.isiPendant()) {
            elem.setCapture(false);
          } else if (getIEVersion_(userAgent) !== -1) {
            elem.setCapture(false);
            config.onmouseover = function(event) {
              // Without calling this method scrollbar cannot be hanlded.
              if (global.openedElement === elem) {
                elem.releaseCapture();
              }
              return false;
            };
            config.onmouseout = function(event) {
              if (global.openedElement === elem) {
                elem.setCapture(false);
              }
              return false;
            };
            addEventHandler_(options, "mouseover", config.onmouseover);
            addEventHandler_(options, "mouseout", config.onmouseout);
          } else if (ihmi.global.isTablet) {
            config.monitoringFrameFunc = function(event) {
              if (event.type === "blur") {
                //if other frame is touched, blur event occured.
                global.openedElement.click();//close list
              } else {
                var touchElem = findAncestor_(event.target, 'span', 'select');
                //when touching on opened select, do not call click.
                if (global.openedElement !== touchElem) {
                  global.openedElement.click();//close list
                }
              }
              return false;
            };
            addEventHandler_(getDefaultView_(doc), "blur", config.monitoringFrameFunc);
            addEventHandler_(doc, "touchend", config.monitoringFrameFunc);
          } else {
            config.onmouseleave = function(event) {
              if (global.openedElement === elem) {
                global.openedElement.click();
              }
              return false;
            };
            addEventHandler_(elem, "mouseleave", config.onmouseleave);
          }
          global.openedElement = elem;
        }
        return false;
      },
      closeOptions: function(options, elem) {
        if (hasClass_(options, 'hide')) {
          return;
        }
        var node = options.parentNode;
        while ((node !== null) && (node.style !== undefined)) {
          node.style.zIndex = '';
          node = node.parentNode;
        }
        addClass_(options, 'hide');
        removeClass_(elem, 'opened');
        removeClasses_(options, 'select-options-pullup scrolling');
        removeClass_(options, 'ihcp-scrollbar');
        options.style.cssText = '';
      },
      releaseEvents: function() {
        var elem = this,
            doc = elem.ownerDocument,
            config = elem.config,
            options = doc.getElementById(elem.id + '.options'),
            iframe = getDefaultView_(doc);

        if (ihmi.cf.isiPendant()) {
          elem.releaseCapture();
        } else if (config.onmouseover !== null) {
          elem.releaseCapture();
          removeEventHandler_(options, "mouseover", config.onmouseover);
          removeEventHandler_(options, "mouseout", config.onmouseout);
          config.onmouseover = null;
          config.onmouseout = null;
        } else if (config.monitoringFrameFunc !== null) {
          //for Tablet
          removeEventHandler_(iframe, "blur", config.monitoringFrameFunc);
          removeEventHandler_(doc, "touchend", config.monitoringFrameFunc);
          config.monitoringFrameFunc = null;
        } else if (config.onmouseleave !== null) {
          removeEventHandler_(elem, "mouseleave", config.onmouseleave);
          config.onmouseleave = null;
        }
      },
      setRequiredMark: function(show, adjustPos)  {
        var root = this;
        createRequiredMark_(root, adjustPos, false, null);
        setRequiredMark_(root, show);
      }
    },
    selectRobot: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        elem.config = config;
        ihmi.cf.determineDefaultDesignPattern(elem);
      }
    },
    button: {
      init: function (doc, id, config) {
        var elem = doc.getElementById(id),
            type = this,
            img;
        elem.refresh = type.refresh;
        elem.createSpriteLeft = type.createSpriteLeft;
        elem.createSpriteRight = type.createSpriteRight;
        elem.setCallback = type.setCallback;
        elem.setFocus = type.setFocus;
        config.useRequiredMark = ihmi.cf.parseStrToBoolean(config.useRequiredMark);
        elem.config = config;
        elem.config.initInfo = {};
        elem.config.initInfo.config = ihmi.cf.copyInitConfig(config);
        elem.config.initInfo.root = elem.cloneNode(true);
        ihmi.cf.determineDefaultDesignPattern(elem);
        if (elem.config.useRequiredMark) {
          elem.setRequiredMark = type.setRequiredMark;
          elem.setRequiredMark(false, null);
        }

        if (!("onclick" in config)) {
          if (ihmi.global.isiPad) {
            ihmi.cf.addEventHandler(elem, "touchend", type.onclick);
          } else {
            ihmi.cf.addEventHandler(elem, "click", type.onclick);
          }
        }
        if (!ihmi.global.isModernBrowser) {
          ihmi.cf.addEventHandler(elem, "focus", type.onfocus);
          ihmi.cf.addEventHandler(elem, "blur", type.onblur);
        }
        if (typeof elem.config.classimageleft === 'string') {
          img = doc.getElementById(id + ".imageleft");
          ihmi.cf.addClass(img, elem.config.classimageleft);
        }
        if (typeof elem.config.classimageright === 'string') {
          img = doc.getElementById(id + ".imageright");
          ihmi.cf.addClass(img, elem.config.classimageright);
        }
        setTimeout(function(){
          ihmi.cf.setBorderRadius(elem);
        }, 0);//setTimeout for popup.
      },
      refresh: function (text, color, spriteleft, spriteright, disabled, callback) {
        var elem = this,
            doc = elem.ownerDocument,
            span;
        if (text !== null) {
          var id = doc.getElementById(elem.id + ".text");
          id.innerHTML = text;
        }
        if (color !== null) {
          elem.style.color = ihmi.global.colorTable[color];
        }
        if (typeof spriteleft === 'string') {
          span = ihmi.cf.findDescendant(elem, "span", "image-button-spriteleft");
          if (span === null) {
            span = elem.createSpriteLeft();
          }
          if (typeof elem.config.spriteleft === 'string') {
            ihmi.cf.replaceClass(span, elem.config.spriteleft, spriteleft);
          } else {
            ihmi.cf.addClass(span, spriteleft);
          }
          elem.config.spriteleft = spriteleft;
        }
        if (typeof spriteright === 'string') {
          span = ihmi.cf.findDescendant(elem, "span", "image-button-spriteright");
          if (span === null) {
            span = elem.createSpriteRight();
          }
          if (typeof elem.config.spriteright === 'string') {
            ihmi.cf.replaceClass(span, elem.config.spriteright, spriteright);
          } else {
            ihmi.cf.addClass(span, spriteright);
          }
          elem.config.spriteright = spriteright;
        }
        if (typeof callback == 'function') {
          elem.setCallback(callback);
        }
        elem.disabled = disabled;
        ihmi.cf.turnOnOffClass(elem, 'disabled', disabled);
        if (elem.disabled) {
          ihmi.cf.removeClasses(elem, "focus");
        }
        setTimeout(function(){
          ihmi.cf.setBorderRadius(elem);
        }, 0);//setTimeout for popup.
      },
      onclick: function (event) {
        var elem = event.srcElement,
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            root = ihmi.cf.findAncestor(elem, 'button', 'button'),
            config = root.config;

        if (ihmi.cf.hasClass(root, 'disabled')) {
          event.preventDefault();
          return false;
        }
        ihmi.cf.lightupBtnMoment(root);

        if (typeof config.callback === 'function') {
          config.callback(root.id, "clicked");
        } else {
          IUIFRequest_(frame, {
            request: root.id + ".clicked"
          }).send();
        }
        // [#9488] Adapt the focus style to the iPad.
        // Since it is difficult to deal with 'iframe', for now commented out.
        //if (ihmi.global.isiPad) {
        //  var previousFocus = ihmi.cf.findDescendant(root.ownerDocument, 'button', 'focus');
        //  if ((previousFocus !== null) && (previousFocus !== root)) {
        //    ihmi.cf.removeClass(previousFocus, "focus");
        //  }
        //  ihmi.cf.addClass(root, "focus");
        //}
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if (!(ihmi.global.isModernBrowser)) {
          ihmi.cf.addClasses(elem, "focus");
        }
        return false;
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if (!(ihmi.global.isModernBrowser)) {
          ihmi.cf.removeClasses(elem, "focus");
        }
        return false;
      },
      setFocus: function(){
        var elem = this;
        elem.focus();
      },
      createSpriteLeft: function(){
        var elem = this;
        var html = elem.innerHTML;
        elem.innerHTML = '<span class="image-button-spriteleft"></span>' + html;
        return ihmi.cf.findDescendant(elem, "span", "image-button-spriteleft");
      },
      createSpriteRight: function(){
        var elem = this;
        var html = elem.innerHTML;
        elem.innerHTML = html + '<span class="image-button-spriteright"></span>';
        return ihmi.cf.findDescendant(elem, "span", "image-button-spriteright");
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      setRequiredMark: function(show, adjustPos)  {
        var root = this;
        ihmi.cf.createRequiredMark(root, adjustPos, false, null);
        ihmi.cf.setRequiredMark(root, show);
      }
    },
    iconButton: {
      def: {
        // dummy opacity src str for sprite
        // If the image is not specified in the src, the border will be displayed.
        DUMMY_SRC : "data:image/gif;base64,R0lGODlhAQABAIABAAAAAP///yH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="
      },
      init: function (doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.def = ihmi.iconButton.def;
        elem.refresh = type.refresh;
        elem.setCallback = type.setCallback;
        elem.setFocus = type.setFocus;
        elem.config = config;
        elem.config.includeText = ihmi.cf.parseStrToBoolean(config.includeText);
        elem.config.btnElem = ihmi.cf.findDescendant(elem, 'button', 'button');
        elem.config.textElem = ihmi.cf.findDescendant(elem, 'label', 'ihcp-icon-button-text');
        elem.config.igmElem = querySelector_(elem, 'img');
        elem.config.initInfo = {};
        elem.config.initInfo.config = ihmi.cf.copyInitConfig(config);
        elem.config.initInfo.root = elem.cloneNode(true);
        elem.setRequiredMark = type.setRequiredMark;
        elem.setRequiredMark(false, null);

        if (elem.config.includeText) {
          ihmi.cf.addClass(elem.config.textElem, "ihcp-icon-button-includetext");
        }
        if (!elem.config.image) {
          elem.config.igmElem.src = elem.def.DUMMY_SRC;
        }
        if (!("onclick" in config)) {
          if (ihmi.global.isiPad) {
            ihmi.cf.addEventHandler(elem.config.btnElem, "touchend", type.onclick);
            ihmi.cf.addEventHandler(elem.config.textElem, "click", type.onclick);//can't be used label for on iOS.
          } else {
            ihmi.cf.addEventHandler(elem.config.btnElem, "click", type.onclick);
          }
        }
        if (!ihmi.global.isModernBrowser) {
          ihmi.cf.addEventHandler(elem.config.btnElem, "focus", type.onfocus);
          ihmi.cf.addEventHandler(elem.config.btnElem, "blur", type.onblur);
        }
        ihmi.cf.setBorderRadius(elem.config.btnElem);
      },
      refresh: function (disabled, argObj) {
        var root = this,
            btnElem = root.config.btnElem,
            imgElem = querySelector_(btnElem, 'img'),
            svgStr = '',
            changeImg = false,
            isDummySrc = false,
            bgi = "none";
        if (!argObj) {
          argObj = {};
        }
        if (argObj.text != undefined) {
          root.config.textElem.innerHTML = argObj.text;
        }
        if (argObj.classImage != undefined) {
          imgElem.className = argObj.classImage;
        }
        if (argObj.image != undefined) {
          if (argObj.image == "") {
            argObj.image = root.def.DUMMY_SRC;
          }
          imgElem.setAttribute("src", argObj.image);
          changeImg = true;
        }
        if (imgElem.src === root.def.DUMMY_SRC) {
          isDummySrc = true;
        }
        if ((argObj.bgSvgData != undefined) ||
            (argObj.bgDefinedSvg != undefined)) {
          svgStr = (argObj.bgSvgData != undefined) ? argObj.bgSvgData : argObj.bgDefinedSvg;
          bgi = ihmi.cf.createBgSvgStr(svgStr);
          changeImg = true;
        }
        if (changeImg) {
          btnElem.style.backgroundImage = bgi;
          // Resize the image inside the button to fit the size of the button.
          turnOnOffClass_(imgElem, "ihcp-icon-button-img", !isDummySrc);
          turnOnOffClass_(imgElem, "hide", svgStr); // If use svg, hide <img> tag.
          turnOnOffClass_(btnElem, "ihcp-bgimage-base", svgStr); // If use svg, set position to center pos and no repeat.
        }

        if (disabled != null) {
          disabled = ihmi.cf.parseStrToBoolean(disabled);
          btnElem.disabled = disabled;
          turnOnOffClass_(root, "disabled", disabled);
          turnOnOffClass_(btnElem, "disabled", disabled);
          if (btnElem.disabled) {
            removeClasses_(btnElem, "focus");
          }
        }
      },
      onclick: function (event) {
        var elem = event.srcElement,
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            root = ihmi.cf.findAncestor(elem, 'span', 'ihcp-icon-button'),
            btnElem = root.config.btnElem,
            config = root.config;

        if (ihmi.cf.hasClass(btnElem, 'disabled')) {
          event.preventDefault();
          return false;
        }
        ihmi.cf.lightupBtnMoment(btnElem);

        if (typeof config.callback === 'function') {
          config.callback(root.id, "clicked");
        } else {
          IUIFRequest_(frame, {
            request: root.id + ".clicked"
          }).send();
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if (!(ihmi.global.isModernBrowser)) {
          ihmi.cf.addClasses(elem, "focus");
        }
        return false;
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if (!(ihmi.global.isModernBrowser)) {
          ihmi.cf.removeClasses(elem, "focus");
        }
        return false;
      },
      setFocus: function() {
        var root = this,
            btnElem = root.config.btnElem;
        btnElem.focus();
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      setRequiredMark: function(show, adjustPos)  {
        var root = this,
            btnElem = root.config.btnElem;
        ihmi.cf.createRequiredMark(btnElem, adjustPos, false, null);
        ihmi.cf.setRequiredMark(btnElem, show);
      }
    },
    helpLink: {
      init: function (doc, id, config) {
        var elem = doc.getElementById(id),
            type = this,
            mark;
        elem.config = config;
        elem.refresh = type.refresh;

        ihmi.cf.determineDefaultDesignPattern(elem);
        if (config.designpattern === "mouse") {
          mark = ihmi.cf.findDescendant(elem, 'span', 'help-link-mark');
          ihmi.cf.replaceClass(mark, "ihmicomponent-touch-helplink-mark", "ihmicomponent-mouse-helplink-mark");
        }
        if (!("onclick" in config)) {
          ihmi.cf.addEventHandler(elem, "click", type.onclick);
        }
      },
      refresh: function (disabled, optionObj) {
        var elem = this;
        var before;
        var after;
        var icon;
        var beforeIconClass;
        var afterIconClass;
        elem.disabled = disabled;
        ihmi.cf.turnOnOffClass(elem, 'disabled', disabled);
        if (optionObj && optionObj.designpattern) {
          if (optionObj.designpattern === "mouse") {
            before = "touch";
          } else if (optionObj.designpattern === "touch") {
            before = "mouse";
          } else {
            return;
          }
          after = optionObj.designpattern;
          elem.config.designpattern = after;
          replaceClass_(elem, before, after);
          beforeIconClass = format_("ihmicomponent-%s-helplink-mark", before);
          afterIconClass = format_("ihmicomponent-%s-helplink-mark", after);
          icon = findDescendant_(elem, 'span', 'help-link-mark');
          replaceClass_(icon, beforeIconClass, afterIconClass);
        }
      },
      onclick: function (event) {
        var elem = event.srcElement,
            root = ihmi.cf.findAncestor(elem, 'a', 'help-link'),
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            page = 'help',
            file, config;
        if (root.disabled) return false;
        config = root.config;
        if ('page' in config) page = config.page;
        file = ('file' in config) ? config.file : root.id;
        ihmi.cf.IUIFRequest(frame, { webpage: page, request: file + ".clicked" }).send();
      }
    },
    textboxReal: {
      init: function(doc, id, config) {
        var type = this,
            elem = doc.getElementById(id),
            textbox = doc.getElementById(elem.id + ".textbox");

        elem.getText = type.getText;
        textbox_.init(type, elem, config, textbox);
        textbox_.initIntReal(type, elem, config, textbox, 0);
        config.zerosuppress = parseStrToBoolean_(config.zerosuppress);
      },
      refresh: function(cur, min, max, disabled, optionObj) {
        var elem = this,
            doc = elem.ownerDocument,
            textbox = doc.getElementById(elem.id + ".textbox"),
            config = elem.config,
            func = config.func,
            color = "black01",
            colorTable = ihmi.global.colorTable,
            DISABLED_COLOR = "#67727e",
            disableDec, disableInc,
            min1, min2, max1, max2;
        var isOption = (optionObj != null);
        var optRange = isOption ?
              (optionObj.range == null) ? null : optionObj.range :
              null;
        var isInvalidValue = false;
        var nextRange = isArray_(optRange) ? optRange[0] : null;
        var isLower = false;
        var isUpper = false;
        var isLowerSub = false;
        var isUpperSub = false;

        config.range1 = {
          min : func.convertUnits(min, config, true),
          max : func.convertUnits(max, config, true)
        };
        min1 = config.range1.min;
        max1 = config.range1.max;
        disabled = parseStrToBoolean_(disabled);
        disableDec = disabled;
        disableInc = disabled;
        config.decimalComma = (/,/).test(cur);
        // convert str to number and convert unit.
        cur = func.convertUnits(cur, config, true);
        if (nextRange === null) {
          config.isExtendLimit = false;
          /** range1(min1 < max1) */
          setLimit(min1, max1, 0, 0);
          isLower = (cur < config.lowerLimit);
          isUpper = (config.upperLimit < cur);
          if (!isNaN(cur)) {
            isInvalidValue = (isLower || isUpper);
          }
          if (config.range2 !== undefined) delete config.range2;
        } else {
          config.isExtendLimit = true;
          config.range2 = {
            min : func.convertUnits(String(nextRange.min), config, true),
            max : func.convertUnits(String(nextRange.max), config, true)
          };
          min2 = config.range2.min;
          max2 = config.range2.max;
          if (max1 < min2) {
            /** range1(min1 < max1) < range2(min2 < max2) */
            setLimit(min1, max2, max1, min2);
          } else if (max2 < min1) {
            /** range2(min2 < max2) < range1(min1 < max1) */
            setLimit(min2, max1, max2, min1);
          } else {
            /** range1(min1 < max1) */
            setLimit(min1, max1, 0, 0);
          }
          if (!isNaN(cur)) {
            isLower = (cur < config.lowerLimit);
            isUpperSub = (config.subUpperLimit < cur);
            isLowerSub = (cur < config.subLowerLimit);
            isUpper = (config.upperLimit < cur);
            /** lowerLimit < subUpperLimit < subLowerLimit < upperLimit */
            isInvalidValue = (isLower ||
                              isUpper ||
                              (isUpperSub && isLowerSub));
          }
        }
        if (isNaN(cur)) {
          disableDec = true;
          disableInc = true;
        } else {
          if (cur <= config.lowerLimit) disableDec = true;
          if (cur >= config.upperLimit) disableInc = true;
          if (isInvalidValue) {
            setInvalidColor();
          }
        }
        elem.disabled = disabled;
        textbox.disabled = disabled;
        textbox.style.color = (disabled)
                                ? DISABLED_COLOR
                                : colorTable[color];
        turnOnOffClass_(textbox, "textbox-no-text", isNaN(cur) && !disabled);
        // convert num to str. and zero padding
        cur = func.formatReal(cur, config);
        if (cur !== config.oldText) {
          config.oldText = cur;
          textbox.value = cur;
        }
        if ("buttons" in config) {
          doc.getElementById(elem.id + ".btnDec2").refresh(null, null, null, null, disableDec, null);
          doc.getElementById(elem.id + ".btnDec").refresh(null, null, null, null, disableDec, null);
          doc.getElementById(elem.id + ".btnInc").refresh(null, null, null, null, disableInc, null);
          doc.getElementById(elem.id + ".btnInc2").refresh(null, null, null, null, disableInc, null);
        }
        // lowerLimit < subUpperLimit < subLowerLimit < upperLimit
        function setLimit(lowerLimit, upperLimit, subUpperLimit, subLowerLimit) {
          config.lowerLimit = lowerLimit;
          config.upperLimit = upperLimit;
          config.subUpperLimit = subUpperLimit;
          config.subLowerLimit = subLowerLimit;
        }
        function setInvalidColor() {
          color = "red02";
          if (config.outOfRangeTextColor && (config.outOfRangeTextColor in colorTable)) {
            color = config.outOfRangeTextColor;
          }
        }
      },
      setBtnsMarginLeft: function(marginLeft) {
        var elem = this,
            doc = elem.ownerDocument,
            config = elem.config,
            btnsParentElem;
        if (!("buttons" in config)) {
          return;
        }
        if (marginLeft == null) {
          return;
        }
        if (isNaN(marginLeft)) {
          return;
        }
        btnsParentElem = doc.getElementById(elem.id + ".btnDec").parentNode;
        btnsParentElem.style.marginLeft = marginLeft + "px";
      },
      notifyChanged: function(text, operation) {
        var elem = this,
            doc = elem.ownerDocument,
            textboxFrameMain = getDefaultView_(doc),
            textbox = doc.getElementById(elem.id + ".textbox"),
            config = elem.config,
            func = config.func,
            errPopFrameMain,
            validated,
            customizeObj = {};
        var isEmpty = (config.oldText === '');
        config.validateError = false;
        validated = func.validate(text, config);
        if (validated instanceof Error) {
          turnOnOffClass_(textbox, "textbox-no-text", isEmpty);
          config.validateError = true;
          textbox.value = config.oldText;
          if (config.errPopClass) {
            customizeObj.popupFrmAddClass = config.errPopClass;
          }

          errPopFrameMain = findAncestorFrame_(textboxFrameMain, config.errPopPos);
          if (errPopFrameMain !== textboxFrameMain) {
            //if the caller and popup dest are differnt
            customizeObj.callerWindowObj = textboxFrameMain;
          }

          if (config.errPopAddFuncKey === "true") {
            customizeObj.errPopAddFuncKey = true;
          }
          if (config.errPopWindowAlert === "true") {
            customizeObj.errPopWindowAlert = true;
          }
          if (config.designpattern === "mouse") {
            customizeObj.designpattern = "mouse";
          }
          alertMessage_(validated.message, null, function() {
            // Without below blur() and focus(), event for textbox is not fired
            // properly after displaying alert message.
            textbox.blur();
            textbox.focus();
          }, errPopFrameMain, customizeObj);

          return false;
        } else {
          config.oldText = validated;
          textbox.value = validated;
          if (!textbox.disabled && (textbox.style.color !== ihmi.global.colorTable["black01"])) {
            //change red to black
            textbox.style.color = ihmi.global.colorTable["black01"];
          }
          notifyTextboxChanged_(textbox, func.revertUnits(validated, config), operation, config);
          return true;
        }
      },
      onclick: function(event) {
        var button = event.srcElement,
            doc = button.ownerDocument,
            root, textbox, config, func, value;
        if ((button.tagName === 'SPAN') || (button.tagName === 'IMG')) {
          button = findAncestor_(button, 'button', 'button');
        }

        if (hasClass_(button, 'disabled')) {
          preventBrowserDefault_(event);
          return false;
        }

        /**
         * [#9687]
         *  Save flush 2times for iPad.
         *  Since something other than the click event
         *   seems to be affecting the button style,
         *   suppress highlight processing by the click event.
         */
        if (!ihmi.global.isiPad) {
          lightupBtnMoment_(button);
        }

        root = findAncestor_(button, 'span', 'textbox');
        textbox = doc.getElementById(root.id + ".textbox");
        config = root.config;
        func = config.func;

        value = func.parseReal(textbox.value);
        value = button.scale(value, config);
        if (button.id.indexOf('btnDec') !== -1) {   // decrement btn
          compareValue(config.subUpperLimit);
        } else if (button.id.indexOf('btnInc') !== -1) {    //increment btn
          compareValue(config.subLowerLimit);
        }

        var text = func.formatReal(value, config);
        // Dealing with a bug that occurs in calculations
        //  between decimal points
        value = (text === "") ? NaN : Number(text);
        if (textbox.value !== text) {
          root.notifyChanged(text);
          func.checkButtonDisabled(value, root, doc, button, "onclick");
        }
        /** lowerLimit < subUpperLimit < subLowerLimit < upperLimit */
        function compareValue(subLimit) {
          if (!config.isExtendLimit) {
            /** cur < lowerLimit -> lowerLimit */
            value = Math.max(config.lowerLimit, value);
            /** upperLimit < cur -> upperLimit */
            value = Math.min(config.upperLimit, value);
          } else {
            if (value < config.lowerLimit) {
              value = config.lowerLimit;
            } else if (config.upperLimit < value) {
              value = config.upperLimit;
            } else if ((config.subUpperLimit < value) &&
                        (value < config.subLowerLimit)) {
              /**
               * subUpperLimit < cur < subLowerLimit
               * btnDec -> (subLimit = subUpperLimit)
               * btnInc -> (subLimit = subLowerLimit)
               */
              value = subLimit;
            }
          }
        }
      },
      onblur: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config,
            func = config.func,
            value,text,button,doc;
        button = findDescendant_(root, 'button', 'inc-dec-button');
        if (config.tempValue !== "") { // Change value
          modifyValue();
          config.tempValue = "";
        }
        value = func.convertUnits(elem.value, config, false);
        text = func.formatReal(value, root.config);
        if (elem.value !== config.oldText) {
          /**
           *  Processing to make the background colour white in case of normal values
           *   because keyup does not occur in case legacy browser.
           */
          turnOnOffClass_(elem, "textbox-no-text", elem.value.length === 0);
          root.notifyChanged(text, "blur");
          if (button !== null){
            doc = button.ownerDocument;
            func.checkButtonDisabled(value, root, doc, button, "onblur");
          }
        }
        if (!(ihmi.global.isModernBrowser)) {
          removeClass_(elem, "focus");
        }
        ihmi.global.selectedTextbox = null;
        return false;
        // The same value is added repeatedly.(PC Chrome, Edge, iOS12)
        function modifyValue() {
          if (config.tempValue !== elem.value) {
            elem.value = config.tempValue;
          }
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config,
            func = config.func,
            key = event.keyCode,
            validatedResult = true,
            filterResult = true,
            value,text,button,doc;
        button = findDescendant_(root, 'button', 'inc-dec-button');
        value = func.convertUnits(elem.value, config, false);
        text = func.formatReal(value, root.config);
        if (key === 46 && config.decimalComma) { // key is dot
          event.keyCode = key = 44; // convert to comma
        }
        if (key !== 13) {
          if (!ihmi.global.isTablet) {
            filterResult = func.filter(key, config);
            if (!filterResult) {
              preventBrowserDefault_(event);
            }
          }
          return filterResult;
        } else {
          if (elem.value === config.oldText) {
            if (!config.unSelect) {
              elem.select();
            }
          } else {
            validatedResult = root.notifyChanged(text, "enter");
            if (button !== null){
              doc = button.ownerDocument;
              func.checkButtonDisabled(value, root, doc, button, "enter");
            }
          }
          if ((true === validatedResult) && (ihmi.global.isTablet)) {
            elem.blur();//hide software key
          }
          return false;
        }
      },
      onkeyup: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config;
        turnOnOffClass_(elem, "textbox-no-text", elem.value.length === 0);
        if (event.code === 'Enter' || event.code === 'NumpadEnter') {
          config.tempValue = "";
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config,
            valLen;

        if (config.unSelect) {
          if (ihmi.global.isTablet) {
            valLen = root.getText().length;
            root.setCursorPos(valLen, valLen);
          }
        } else {
          elem.select();
        }

        if (!(ihmi.global.isModernBrowser)) {
          addClass_(elem, "focus");
        }
        ihmi.global.selectedTextbox = elem;

        return false;
      },
      setFocus: function() {
        var elem = this,
            textbox = elem.ownerDocument.getElementById(elem.id + ".textbox");
        textbox.focus();
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      getValue: function(){
        var elem = this,
            doc = elem.ownerDocument,
            config = elem.config,
            func = config.func,
            text = (doc.getElementById(elem.id + ".textbox").value);
        return (func.revertUnits(text, config));
      },
      getText: function(){
        var elem = this,
            doc = elem.ownerDocument,
            text = (doc.getElementById(elem.id + ".textbox").value);
        return text;
      },
      setCursorPos: function(csrStart, csrEnd) {
        var root = this,
            doc = root.ownerDocument,
            activeObj = doc.activeElement,
            targetObj = doc.getElementById(root.id + ".textbox");

        if (activeObj != targetObj) {
          root.setFocus();
        }

        if (targetObj.setSelectionRange) {
          setTimeout(function() {//for IE. if not exist, don't work properly when start and end is same.
            targetObj.setSelectionRange(csrStart, csrEnd);
            targetObj.click(); // Just in case...(for IE)
          }, 10);
        } else if (targetObj.createTextRange) {
          //for IE7,IE8
          var range = targetObj.createTextRange();
          range.collapse(true);
          range.moveEnd('character', csrEnd);
          range.moveStart('character', csrStart);
          setTimeout(function() {//if not exist, all selected.
            range.select();
          }, 10);
        }
      },
      setRequiredMark: function(show, adjustPos) {
        var root = this;
        var doc = root.ownerDocument;
        var textbox = doc.getElementById(root.id + ".textbox");
        createRequiredMark_(textbox, adjustPos, true, null);
        setRequiredMark_(textbox, show);
      },
      onCompositionEnd: function(e) {
        var root = findAncestor_(this, 'span', 'textbox');
        var config = root.config;
        config.tempValue = e.target.value;
      },
      func: {
        scaleup2: function(value, config) { return value * config.scale2; },  // eslint-disable-line brace-style
        scaleup1: function(value, config) { return value * config.scale1; },  // eslint-disable-line brace-style
        scaledown1: function(value, config) { return value / config.scale1; },  // eslint-disable-line brace-style
        scaledown2: function(value, config) { return value / config.scale2; },  // eslint-disable-line brace-style
        increment2: function(value, config) { return value + config.step2; }, // eslint-disable-line brace-style
        increment1: function(value, config) { return value + config.step1; }, // eslint-disable-line brace-style
        decrement1: function(value, config) { return value - config.step1; }, // eslint-disable-line brace-style
        decrement2: function(value, config) { return value - config.step2; }, // eslint-disable-line brace-style

        formatReal: function(value, config) {
          var func = this,
              text;
          if (isNaN(value)) return "";
          text = value.toFixed(config.decimals);
          if (config.zerosuppress) {
            text = func.zeroSuppress(text);
          }
          text = func.revertDecimalMarker(text, config.decimalComma);
          return text;
        },
        revertDecimalMarker: function(text, decimalComma) {
          if (decimalComma) {
            text = text.replace(/\./, ",");
          }
          return text;
        },
        parseReal: function(text) {
          var num;
          text = text.replace(/,/, ".");
          num = isNaN(text) ? NaN : parseFloat(text);
          return num;
        },
        filter: function(keyCode, config) {
          var text = String.fromCharCode(keyCode),
              allowed = "\\d";
          if (config.lowerLimit < 0) allowed += "-";
          allowed += config.decimalComma ? "," : "\\.";
          return (new RegExp("[" + allowed + "]")).test(text);
        },
        convertUnits: function(text, config, convertFlg) {
          var func = this,
              value = func.parseReal(text, config);
          if (isNaN(value)) return value;
          if (convertFlg) {
            switch (config.conversion) {
              case "percent": value *= 100; break;
              case "degree": value *= 180 / Math.PI; break;
              case "millesimal": value /= 1000; break;
            }
          }
          // round off
          return parseFloat(value.toFixed(config.decimals));
        },
        revertUnits: function(text, config) {
          var func = this,
              value = func.parseReal(text);
          switch (config.conversion) {
          case "percent": value = value / 100; break;
          case "degree": value = value * Math.PI / 180; break;
          case "millesimal": value *= 1000; break;
          }
          return func.revertDecimalMarker(value.toString(), config.decimalComma);
        },
        zeroSuppress: function(text) {
          var i = text.length - 1;
          var result;
          var commma = ".";
          while (text.charAt(i) === "0") {
            i--;
          }
          if (text.charAt(i) === commma) {
            i--;
          }
          result = text.substring(0, i + 1);
          return result;
        },
        checkButtonDisabled: function(value, root, doc, button, operation) {
          var func = this,
              btnIncDisabled = false,
              btnDecDisabled = false,
              config = root.config;
          var btnInc = doc.getElementById(root.id + ".btnInc");
          var btnInc2 = doc.getElementById(root.id + ".btnInc2");
          var btnDec = doc.getElementById(root.id + ".btnDec");
          var btnDec2 = doc.getElementById(root.id + ".btnDec2");
          var isLower = false;
          var isUpper = false;

          if (config.validateError){
            value = func.parseReal(config.oldText, config);
            config.validateError = false;
          }
          isLower = (value <= config.lowerLimit);
          isUpper = (value >= config.upperLimit);
          if (isNaN(value) || isLower) {
            btnDecDisabled = true;
          }
          if (isNaN(value) || isUpper) {
            btnIncDisabled = true;
          }
          btnInc.disabled = btnIncDisabled;
          btnInc2.disabled = btnIncDisabled;
          btnDec.disabled = btnDecDisabled;
          btnDec2.disabled = btnDecDisabled;

          turnOnOffClass_(btnInc, 'disabled', btnIncDisabled);
          turnOnOffClass_(btnInc2, 'disabled', btnIncDisabled);
          turnOnOffClass_(btnDec, 'disabled', btnDecDisabled);
          turnOnOffClass_(btnDec2, 'disabled', btnDecDisabled);
          if (operation === 'onclick'){
            if (btnIncDisabled) {
              removeClass_(button, "focus");
              btnDec.focus();
            } else if (btnDecDisabled) {
              removeClass_(button, "focus");
              btnInc.focus();
            }
          }
        },
        validate: function(text, config) {
          var func = this,
              allowed = "-\\d",
              value = func.parseReal(text);
          var errNaN = "Diese Folge ist keine Zahl.";
          var errOutOfRange = "";
          var isValidNum = false;
          var isFirstRange = false;
          var isSecondRange = false;
          var isLowerEqual = (config.lowerLimit <= value);
          var isUpperEqual = (value <= config.upperLimit);
          var isUpperEqualSub = (value <= config.subUpperLimit);
          var isLowerEqualSub = (config.subLowerLimit <= value);

          allowed += config.decimalComma ? "," : "\\.";
          if (!(new RegExp("^[" + allowed + "]+$")).test(text)) {
            return new Error(errNaN);
          } else if (!config.isExtendLimit) {  // only one range
            isValidNum = (isLowerEqual && isUpperEqual);
            if (isValidNum) return text;
            errOutOfRange = format_(
              "%s liegt auerhalb des zulssigen Bereichs.\n(%s - %s)",
              text,
              func.formatReal(config.lowerLimit, config),
              func.formatReal(config.upperLimit, config));
          } else if (config.isExtendLimit) {
            /** lowerLimit < subUpperLimit < subLowerLimit < upperLimit */
            isFirstRange = (isLowerEqual && isUpperEqualSub);
            isSecondRange = (isLowerEqualSub && isUpperEqual);
            isValidNum = (isFirstRange || isSecondRange);
            if (isValidNum) return text;
            errOutOfRange = format_(
              "%s liegt auerhalb des zulssigen Bereichs.\n(%s - %s),(%s - %s)",
              text,
              config.lowerLimit,
              config.subUpperLimit,
              config.subLowerLimit,
              config.upperLimit);
          }
          return new Error(errOutOfRange);
        }
      }
    },
    textboxInteger: {
      init: function(doc, id, config) {
        var type = this,
            elem = doc.getElementById(id),
            textbox = doc.getElementById(elem.id + ".textbox");

        textbox_.init(type, elem, config, textbox);
        /** use in position */
        elem.config.myElem = elem; // add for use element informations.

        textbox_.initIntReal(type, elem, config, textbox, 1);
      },
      refresh: function(cur, min, max, disabled, optionObj) {
        var elem = this,
            doc = elem.ownerDocument,
            textbox = doc.getElementById(elem.id + ".textbox"),
            config = elem.config,
            color = "black01",
            colorTable = ihmi.global.colorTable,
            DISABLED_COLOR = "#67727e",
            disableDec, disableInc,
            min1, min2, max1, max2;
        var isLower = false;
        var isUpper = false;
        var isLowerSub = false;
        var isUpperSub = false;
        var isOption = (optionObj != null);
        var optRange = isOption ?
              (optionObj.range == null) ? null : optionObj.range :
              null;
        var isInvalidValue = false;
        var nextRange = isArray_(optRange) ? optRange[0] : null;

        config.range1 = {
          min : parseInt(min, 10),
          max : parseInt(max, 10)
        };
        min1 = config.range1.min;
        max1 = config.range1.max;
        disabled = parseStrToBoolean_(disabled);
        disableDec = disabled;
        disableInc = disabled;
        cur = parseInt(cur, 10);
        if (nextRange === null) {
          config.isExtendLimit = false;
          /** range1(min1 < max1) */
          setLimit(min1, max1, 0, 0);
          isLower = (cur < config.lowerLimit);
          isUpper = (config.upperLimit < cur);
          if (!isNaN(cur)) {
            isInvalidValue = (isLower || isUpper);
          }
          if (config.range2 !== undefined) delete config.range2;
        } else {
          config.isExtendLimit = true;
          config.range2 = {
            min : parseInt(nextRange.min),
            max : parseInt(nextRange.max)
          };
          min2 = config.range2.min;
          max2 = config.range2.max;
          if (max1 < min2) {
            /** range1(min1 < max1) < range2(min2 < max2) */
            setLimit(min1, max2, max1, min2);
          } else if (max2 < min1) {
            /** range2(min2 < max2) < range1(min1 < max1) */
            setLimit(min2, max1, max2, min1);
          } else {
            /** range1(min1 < max1) */
            setLimit(min1, max1, 0, 0);
          }
          if (!isNaN(cur)) {
            isLower = (cur < config.lowerLimit);
            isUpper = (config.upperLimit < cur);
            isLowerSub = (cur < config.subLowerLimit);
            isUpperSub = (config.subUpperLimit < cur);
            /** lowerLimit < subUpperLimit < subLowerLimit < upperLimit */
            isInvalidValue = (isLower || isUpper ||
                              (isUpperSub && isLowerSub));
          }
        }
        if (isNaN(cur)) {
          cur = "";
          disableDec = true;
          disableInc = true;
        } else {
          if (cur <= config.lowerLimit) disableDec = true;
          if (cur >= config.upperLimit) disableInc = true;
          if (isInvalidValue) {
            setInvalidColor();
          }
        }
        elem.disabled = disabled;
        textbox.disabled = disabled;
        textbox.style.color = (disabled)
                              ? DISABLED_COLOR : colorTable[color];
        turnOnOffClass_(textbox, "textbox-no-text", (cur === "") && !disabled);
        if (cur !== parseInt(config.oldText, 10) &&
          !(cur === "" && config.oldText === "")) {
          textbox.value = cur;
          config.oldText = textbox.value;
        }
        if ("buttons" in config) {
          doc.getElementById(elem.id + ".btnDec2").refresh(null, null, null, null, disableDec, null);
          doc.getElementById(elem.id + ".btnDec").refresh(null, null, null, null, disableDec, null);
          doc.getElementById(elem.id + ".btnInc").refresh(null, null, null, null, disableInc, null);
          doc.getElementById(elem.id + ".btnInc2").refresh(null, null, null, null, disableInc, null);
        }
        /** lowerLimit < subUpperLimit < subLowerLimit < upperLimit */
        function setLimit(lowerLimit, upperLimit, subUpperLimit, subLowerLimit) {
          config.lowerLimit = lowerLimit;
          config.upperLimit = upperLimit;
          config.subUpperLimit = subUpperLimit;
          config.subLowerLimit = subLowerLimit;
        }
        function setInvalidColor() {
          color = "red02";
          if (config.outOfRangeTextColor && (config.outOfRangeTextColor in colorTable)) {
            color = config.outOfRangeTextColor;
          }
        }
      },
      setBtnsMarginLeft: function(marginLeft) {
        var elem = this,
            doc = elem.ownerDocument,
            config = elem.config,
            btnsParentElem;
        if (!("buttons" in config)) {
          return;
        }
        if ((marginLeft == null) ||
            isNaN(marginLeft)) {
          return;
        }
        btnsParentElem = doc.getElementById(elem.id + ".btnDec").parentNode;
        btnsParentElem.style.marginLeft = marginLeft + "px";
      },
      notifyChanged: function(text, operation) {
        var elem = this,
            doc = elem.ownerDocument,
            textboxFrameMain = getDefaultView_(doc),
            textbox = doc.getElementById(elem.id + ".textbox"),
            config = elem.config,
            errPopFrameMain,
            validated,
            customizeObj = {};
        var isEmpty = (config.oldText === '');
        config.validateError = false;
        validated = config.func.validate(text, config);

        if (validated instanceof Error) {
          turnOnOffClass_(textbox, "textbox-no-text", isEmpty);
          config.validateError = true;
          textbox.value = config.oldText;
          if (config.errPopClass) {
            customizeObj.popupFrmAddClass = config.errPopClass;
          }

          errPopFrameMain = findAncestorFrame_(textboxFrameMain, config.errPopPos);
          if (errPopFrameMain !== textboxFrameMain) {
            /** if the caller and popup dest are differnt */
            customizeObj.callerWindowObj = textboxFrameMain;
          }

          if (config.errPopAddFuncKey === "true") {
            customizeObj.errPopAddFuncKey = true;
          }
          if (config.errPopWindowAlert === "true") {
            customizeObj.errPopWindowAlert = true;
          }
          if (config.designpattern === "mouse") {
            customizeObj.designpattern = "mouse";
          }
          alertMessage_(validated.message, null, function() {
            /**
             * without below blur() and focus(), event for textbox is not fired
             * properly after displaying alert message.
             */
            textbox.blur();
            textbox.focus();
          }, errPopFrameMain, customizeObj);
          return false;
        } else {
          textbox.value = validated;
          config.oldText = validated;
          if (!textbox.disabled && (textbox.style.color !== ihmi.global.colorTable["black01"])) {
            //change red to black
            textbox.style.color = ihmi.global.colorTable["black01"];
          }
          notifyTextboxChanged_(textbox, validated, operation, config);
          return true;
        }
      },
      onclick: function(event) {
        var button = event.srcElement,
            doc = button.ownerDocument,
            root, textbox, config, func, value;

        if ((button.tagName === 'SPAN') || (button.tagName === 'IMG')) {
          button = findAncestor_(button, 'button', 'button');
        }

        if (hasClass_(button, 'disabled')) {
          event.preventDefault();
          return false;
        }

        /**
         *  [#9687] Save flush 2times for iPad.
         *  Since something other than the click event
         *    seems to be affecting the button style,
         *    suppress highlight processing by the click event.
         */
        if (!ihmi.global.isiPad) {
          lightupBtnMoment_(button);
        }

        root = findAncestor_(button, 'span', 'textbox');
        textbox = doc.getElementById(root.id + ".textbox");
        config = root.config;
        func = config.func;

        value = parseInt(textbox.value, 10);
        value = button.scale(value, config);
        if (button.id.indexOf('btnDec') !== -1) {   // decrement btn
          compareValue(config.subUpperLimit);
        } else if (button.id.indexOf('btnInc') !== -1) {    //increment btn
          compareValue(config.subLowerLimit);
        }
        var text = value.toString();
        if (textbox.value !== text) {
          root.notifyChanged(text);
          func.checkButtonDisabled(value, root, doc, button, "onclick");
        }
        /** lowerLimit < subUpperLimit < subLowerLimit < upperLimit */
        function compareValue(subLimit) {
          if (!config.isExtendLimit) {
            /** cur < lowerLimit -> lowerLimit */
            value = Math.max(config.lowerLimit, value);
            /** upperLimit < cur -> upperLimit */
            value = Math.min(config.upperLimit, value);
          } else {
            if (value < config.lowerLimit) {
              value = config.lowerLimit;
            } else if ((config.subUpperLimit < value) &&
                        (value < config.subLowerLimit)) {
              /**
               * subUpperLimit < cur < subLowerLimit
               * btnDec -> (subLimit = subUpperLimit)
               * btnInc -> (subLimit = subLowerLimit)
               */
              value = subLimit;
            } else if (config.upperLimit < value) {
              value = config.upperLimit;
            }
          }
        }
      },
      onblur: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config,
            func = config.func,
            value,button,doc,text;
        button = findDescendant_(root, 'button', 'inc-dec-button');
        if (config.tempValue !== "") {  // Change value
          modifyValue();
          config.tempValue = "";
        }
        value = parseInt(elem.value, 10);
        text = isNaN(value) ? "" : value.toString();
        if (elem.value !== config.oldText) {
          /**
           *  Processing to make the background colour white in case of normal values
           *   because keyup does not occur in case legacy browser.
           */
          turnOnOffClass_(elem, "textbox-no-text", elem.value.length === 0);
          root.notifyChanged(text, "blur");
          if (button !== null){
            doc = button.ownerDocument;
            func.checkButtonDisabled(value, root, doc, button, "onblur");
          }
        }
        if (!(ihmi.global.isModernBrowser)) {
          removeClass_(elem, "focus");
        }
        ihmi.global.selectedTextbox = null;
        return false;
        /** The same value is added repeatedly.(PC Chrome, Edge, iOS12) */
        function modifyValue() {
          if (config.tempValue !== elem.value) {
            elem.value = config.tempValue;
          }
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config,
            func = config.func,
            key = event.keyCode,
            validatedResult = true,
            filterResult = true,
            value,button,doc,text;
        button = findDescendant_(root, 'button', 'inc-dec-button');
        value = parseInt(elem.value, 10);
        text = isNaN(value) ? "" : value.toString();
        if (key !== 13) {
          if (!ihmi.global.isTablet) {
            filterResult = func.filter(key, config);
            if (!filterResult) {
              preventBrowserDefault_(event);
            }
          }
          return filterResult;
        } else {
          if (elem.value === config.oldText) {
            if (!config.unSelect) {
              elem.select();
            }
          } else {
            validatedResult = root.notifyChanged(text, "enter");
            if (button !== null){
              doc = button.ownerDocument;
              func.checkButtonDisabled(value, root, doc, button, "enter");
            }
          }
          if ((true === validatedResult) && (ihmi.global.isTablet)) {
            elem.blur();//hide software key
          }
          return false;
        }
      },
      onkeyup: function(event) {
        var elem = event.srcElement,
            root = ihmi.cf.findAncestor(elem, 'span', 'textbox'),
            config = root.config;
        if (event.code === 'Enter' || event.code === 'NumpadEnter') {
          config.tempValue = "";
        }
        turnOnOffClass_(elem, "textbox-no-text", elem.value.length === 0);
      },
      onfocus: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, 'span', 'textbox'),
            config = root.config,
            valLen;

        if (config.unSelect) {
          if (ihmi.global.isTablet) {
            valLen = root.getValue().length;
            root.setCursorPos(valLen, valLen);
          }
        } else {
          elem.select();
        }

        if (!(ihmi.global.isModernBrowser)) {
          addClass_(elem, "focus");
        }
        ihmi.global.selectedTextbox = elem;
        return false;
      },
      setFocus: function(){
        var elem = this,
            textbox = elem.ownerDocument.getElementById(elem.id + ".textbox");
        textbox.focus();
      },
      setCallback: function(callback){
        var elem = this;
        elem.config.callback = callback;
      },
      getValue: function(){
        var elem = this,
            doc = elem.ownerDocument;
        return (doc.getElementById(elem.id + ".textbox").value);
      },
      setCursorPos: function(csrStart, csrEnd) {
        var root = this,
            doc = root.ownerDocument,
            activeObj = doc.activeElement,
            targetObj = doc.getElementById(root.id + ".textbox");

        if (activeObj != targetObj) {
          root.setFocus();
        }

        if (targetObj.setSelectionRange) {
          setTimeout(function() {//for IE. if not exist, don't work properly when start and end is same.
            targetObj.setSelectionRange(csrStart, csrEnd);
            targetObj.click(); // Just in case...(for IE)
          }, 10);
        } else if (targetObj.createTextRange) {
          //for IE7,IE8
          var range = targetObj.createTextRange();
          range.collapse(true);
          range.moveEnd('character', csrEnd);
          range.moveStart('character', csrStart);
          setTimeout(function() {//if not exist, all selected.
            range.select();
          }, 10);
        }
      },
      setRequiredMark: function(show, adjustPos) {
        var root = this;
        var doc = root.ownerDocument;
        var textbox = doc.getElementById(root.id + ".textbox");
        createRequiredMark_(textbox, adjustPos, true, null);
        setRequiredMark_(textbox, show);
      },
      onCompositionEnd: function(e) {
        var root = findAncestor_(this, 'span', 'textbox');
        var config = root.config;
        config.tempValue = e.target.value;
      },
      func: {
        increment2: function(value, config) { return value + config.step2; }, // eslint-disable-line brace-style
        increment1: function(value, config) { return value + config.step1; }, // eslint-disable-line brace-style
        decrement1: function(value, config) { return value - config.step1; }, // eslint-disable-line brace-style
        decrement2: function(value, config) { return value - config.step2; }, // eslint-disable-line brace-style

        filter: function(keyCode, config) {
          var text = String.fromCharCode(keyCode),
              allowed = "\\d";
          if (config.lowerLimit < 0) allowed += "-";
          return (new RegExp("[" + allowed + "]")).test(text);
        },
        checkButtonDisabled: function(value, root, doc, button, operation) {
          var config = root.config,
              btnIncDisabled = false,
              btnDecDisabled = false;
          var btnInc = doc.getElementById(root.id + ".btnInc");
          var btnInc2 = doc.getElementById(root.id + ".btnInc2");
          var btnDec = doc.getElementById(root.id + ".btnDec");
          var btnDec2 = doc.getElementById(root.id + ".btnDec2");
          var isLower = false;
          var isUpper = false;

          if (config.validateError){
            value = parseInt(config.oldText, 10);
            config.validateError = false;
          }
          isLower = (value <= config.lowerLimit);
          isUpper = (value >= config.upperLimit);
          if (isNaN(value) || isLower) {
            btnDecDisabled = true;
          }
          if (isNaN(value) || isUpper) {
            btnIncDisabled = true;
          }
          btnInc.disabled = btnIncDisabled;
          btnInc2.disabled = btnIncDisabled;
          btnDec.disabled = btnDecDisabled;
          btnDec2.disabled = btnDecDisabled;
          turnOnOffClass_(btnInc, 'disabled', btnIncDisabled);
          turnOnOffClass_(btnInc2, 'disabled', btnIncDisabled);
          turnOnOffClass_(btnDec, 'disabled', btnDecDisabled);
          turnOnOffClass_(btnDec2, 'disabled', btnDecDisabled);

          if (operation === 'onclick'){
            if (btnIncDisabled) {
              removeClass_(button, "focus");
              btnDec.focus();
            } else if (btnDecDisabled) {
              removeClass_(button, "focus");
              btnInc.focus();
            }
          }
        },
        validate: function(text, config) {
          var allowed = "-\\d",
              value = parseInt(text, 10);
          var errNaN = "Diese Folge ist keine Zahl.";
          var errOutOfRange = "";
          var isValidNum = false;
          var isFirstRange = false;
          var isSecondRange = false;
          var isLowerEqual = (config.lowerLimit <= value);
          var isUpperEqual = (value <= config.upperLimit);
          var isUpperEqualSub = (value <= config.subUpperLimit);
          var isLowerEqualSub = (config.subLowerLimit <= value);

          if (isNaN(text) || !(new RegExp("^[" + allowed + "]+$")).test(text)) {
            return new Error(errNaN);
          } else if (!config.isExtendLimit) {  // only one range
            isValidNum = (isLowerEqual && isUpperEqual);
            if (isValidNum) return text;
            errOutOfRange = format_(
              "%s liegt auerhalb des zulssigen Bereichs.\n(%s - %s)",
              text,
              config.lowerLimit,
              config.upperLimit);
          } else if (config.isExtendLimit) {
            // lowerLimit < subUpperLimit < subLowerLimit < upperLimit
            isFirstRange = (isLowerEqual && isUpperEqualSub);
            isSecondRange = (isLowerEqualSub && isUpperEqual);
            isValidNum = (isFirstRange || isSecondRange);
            if (isValidNum) return text;
            errOutOfRange = format_(
              "%s liegt auerhalb des zulssigen Bereichs.\n(%s - %s),(%s - %s)",
              text,
              config.lowerLimit,
              config.subUpperLimit,
              config.subLowerLimit,
              config.upperLimit);
          }
          return new Error(errOutOfRange);
        }
      }
    },
    textboxString: {
      init: function(doc, id, config) {
        var type = this,
            elem = doc.getElementById(id);

        elem.onpaste = type.onpaste;
        textbox_.init(type, elem, config, null);
        config.filter = function(keyCode) {
          var character = String.fromCharCode(keyCode);
          return (/[^&'"\/\\]/).test(character);
        };
        config.validate = function(text) {
          if ((/[&'"\/\\]/g).test(text)) {
            return new Error("Die Folge darf die folgenden Zeichen nicht enthalten: &'\"/\\");
          }
          return text;
        };
        config.minLen = 1;
        elem.setMode(config.mode);
      },
      setMode: function(mode) {
        var INVALID_CHAR = "Die Folgen enthlt ein ungltiges Zeichen.";
        var INVALID_PATH = "Die Folgen enthlt ein ungltiges Zeichen.";
        var NOT_FIRST_NUMBER = "Das erste Zeichen kann keine Zahl sein.";
        var DEVICE_INVALID = "Der Gertename ist ungltig.";
        var elem = this,
            config = elem.config,
            configs = {
              dataname: {
                filter: function(keyCode) {
                  var character = String.fromCharCode(keyCode);
                  return (/[\w]/).test(character);
                },
                validate: function(text) {
                  if (!(/^[\w\uFF65-\uFF9F]*$/).test(text)) {
                    return new Error(INVALID_CHAR);
                  }
                  if ((/^\d/).test(text)) {
                    return new Error(NOT_FIRST_NUMBER);
                  }
                  return text;
                }
              },
              datanamefilter: {
                filter: function(keyCode) {
                  var character = String.fromCharCode(keyCode);
                  return (/[\w ]/).test(character);
                },
                validate: function(text) {
                  text = text.replace(/\u3000+/g, ' '); // replace zenkaku space with hankaku space
                  if (!(/^[\w \uFF65-\uFF9F]*$/).test(text)) {
                    return new top.Error(INVALID_CHAR);
                  }
                  return text;
                },
                minLen: 0
              },
              comment: { minLen: 0 },
              path: {
                filter: function(keyCode) {
                  var character = String.fromCharCode(keyCode);
                  return (/[\w:\\]/).test(character);
                },
                validate: function(text) {
                  if (!(/^[\w:\uFF65-\uFF9F\\]*$/).test(text)) {
                    return new Error(INVALID_PATH);
                  }
                  if (!(/^\w{2,3}:/).test(text)) {
                    return new Error(DEVICE_INVALID);
                  }
                  if (!(/\\$/).test(text)) {
                    text += '\\';
                  }
                  return text;
                }
              },
              filepath: {
                filter: function(keyCode) {
                  var character = String.fromCharCode(keyCode);
                  return (/[\w:\\\.]/).test(character);
                },
                validate: function(text) {
                  if (!(/^[\w:\uFF65-\uFF9F\\\.]*$/).test(text)) {
                    return new Error(INVALID_PATH);
                  }
                  if (!(/^\w{2,3}:/).test(text)) {
                    return new Error(DEVICE_INVALID);
                  }
                  return text;
                }
              },
              allallowed: {
                filter: function(keyCode) {
                  var character = String.fromCharCode(keyCode);
                  return (/.*?/).test(character);
                },
                validate: function(text) {
                  return text;
                },
                minLen: 0
              }
            };
        if (mode !== undefined && mode in configs) {
          var configMode = configs[mode];
          if ("validate" in configMode) config.validate = configMode.validate;
          if ("filter" in configMode) config.filter = configMode.filter;
          if ("minLen" in configMode) config.minLen = configMode.minLen;
        }
      },
      setConfig: function(filter, validate, minLen) {
        var elem = this,
            config = elem.config;
        config.mode = 'original';
        if (typeof validate === 'function') config.validate = validate;
        if (typeof filter === 'function') config.filter = filter;
        if (typeof minLen === 'number') config.minLen = minLen;
      },
      refresh: function(text, maxLen, disabled) {
        var elem = this,
            config = elem.config,
            color = "black01",
            DISABLED_COLOR = "#67727e",
            colorTable = ihmi.global.colorTable;

        disabled = parseStrToBoolean_(disabled);
        config.maxLen = maxLen;
        if (text !== config.oldText) {
          elem.value = text;
          config.oldText = text;
        }
        /**
         * config.minLen = 2
         * a -> text.length = 1
         */
        turnOnOffClass_(elem, "textbox-no-text", !disabled && config.minLen > 0 && text.length === 0);
        elem.disabled = disabled;
        elem.style.color = (disabled)
                          ? DISABLED_COLOR
                          : colorTable[color];
      },
      getValue: function() {
        var elem = this;
        return elem.value;
      },
      notifyChanged: function(text, operation) {
        var elem = this,
            doc = elem.ownerDocument,
            textboxFrameMain = getDefaultView_(doc),
            config = elem.config,
            errPopFrameMain,
            validated,
            customizeObj = {};
        validated = config.func.validate(text, config);
        if (validated instanceof Error) {
          elem.value = config.oldText;
          if (config.errPopClass) {
            customizeObj.popupFrmAddClass = config.errPopClass;
          }

          errPopFrameMain = findAncestorFrame_(textboxFrameMain, config.errPopPos);
          if (errPopFrameMain !== textboxFrameMain) {
            //if the caller and popup dest are differnt
            customizeObj.callerWindowObj = textboxFrameMain;
          }

          if (config.errPopAddFuncKey === "true") {
            customizeObj.errPopAddFuncKey = true;
          }
          if (config.errPopWindowAlert === "true") {
            customizeObj.errPopWindowAlert = true;
          }
          if (config.designpattern === "mouse") {
            customizeObj.designpattern = "mouse";
          }
          turnOnOffClass_(elem, "textbox-no-text", config.minLen > 0 && elem.value.length === 0);
          alertMessage_(validated.message, null, function() {
            elem.blur();
            elem.focus();
          }, errPopFrameMain, customizeObj);
          return false;
        } else {
          elem.value = validated;
          config.oldText = validated;
          notifyTextboxChanged_(elem, validated, operation, config);

          return true;
        }
      },
      onblur: function(event) {
        var elem = event.srcElement,
            config = elem.config;
        if (config.tempValue !== "") {  // Change value
          modifyValue();
          config.tempValue = "";
        }
        if (elem.value !== config.oldText) {
          /**
           *  Processing to make the background colour white in case of normal values
           *   because keyup does not occur in case legacy browser.
           */
          turnOnOffClass_(elem, "textbox-no-text", config.minLen > 0 && elem.value.length === 0);
          elem.notifyChanged(elem.value, "blur");
        }
        if (!(ihmi.global.isModernBrowser)) {
          removeClass_(elem, "focus");
        }
        ihmi.global.selectedTextbox = null;
        return false;
        // The same value is added repeatedly.(PC Chrome, Edge, iOS12)
        function modifyValue() {
          if (config.tempValue !== elem.value) {
            elem.value = config.tempValue;
          }
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement,
            config = elem.config,
            key = event.keyCode,
            validatedResult = true,
            filterResult = true;
        if (key !== 13) {
          if (!ihmi.global.isTablet) {
            filterResult = config.func.filter(key, elem.value, config);
            if (!filterResult) {
              preventBrowserDefault_(event);
            }
          }
          return filterResult;
        } else {
          if (elem.value === config.oldText) {
            if (!config.unSelect) {
              elem.select();
            }
          } else {
            validatedResult = elem.notifyChanged(elem.value, "enter");
          }
          if ((true === validatedResult) && (ihmi.global.isTablet)) {
            elem.blur();//hide software key
          }
          return false;
        }
      },
      onkeyup: function(event) {
        var elem = event.srcElement,
            config = elem.config;
        if (event.code === 'Enter' || event.code === 'NumpadEnter') {
          config.tempValue = "";
        }
        turnOnOffClass_(elem, "textbox-no-text", config.minLen > 0 && elem.value.length === 0);
        return true;
      },
      onfocus: function(event) {
        var elem = event.srcElement,
            config = elem.config,
            valLen;

        if (config.unSelect) {
          if (ihmi.global.isTablet) {
            valLen = elem.getValue().length;
            elem.setCursorPos(valLen, valLen);
          }
        } else {
          if (config.mode !== 'path') {
            elem.select();
          }
        }

        if (!(ihmi.global.isModernBrowser)) {
          addClass_(elem, "focus");
        }
        ihmi.cf.SIPManager.showKeyboard();
        ihmi.global.selectedTextbox = elem;
        return false;
      },
      setFocus: function(){
        var elem = this,
            textbox = elem.ownerDocument.getElementById(elem.id);
        textbox.focus();
      },
      onpaste: function(event) {
        // onpaste event occur when input on the SIP keyboard is done.
        var elem = event.srcElement;
        setTimeout(function() {
          var config = elem.config;
          if (elem.value !== config.oldText) {
            triggerEvent_(elem, 'keypress', {keyCode: 13});
          }
        }, 0);
        return true;
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      setCursorPos: function(csrStart, csrEnd) {
        var root = this,
            activeObj = root.ownerDocument.activeElement;

        if (activeObj != root) {
          root.setFocus();
        }

        if (root.setSelectionRange) {
          setTimeout(function() {//for IE. if not exist, don't work properly when start and end is same.
            root.setSelectionRange(csrStart, csrEnd);
            root.click(); // Just in case...(for IE)
          }, 10);
        } else if (root.createTextRange) {
          //for IE7,IE8
          var range = root.createTextRange();
          range.collapse(true);
          range.moveEnd('character', csrEnd);
          range.moveStart('character', csrStart);
          setTimeout(function() {//if not exist, all selected.
            range.select();
          }, 10);
        }
      },
      setRequiredMark: function(show, adjustPos) {
        var root = this;
        var config = root.config;
        createRequiredMark_(root, adjustPos, true, config.requiredMarkAreaClass);
        setRequiredMark_(root, show);
      },
      onCompositionEnd: function(e) {
        var config = this.config;
        config.tempValue = e.target.value;
      },
      func: {
        textNumBytes: function(text) {
          var numBytes = 0,
              len, i, charCode;
          for (i = 0, len = text.length; i < len; i++) {
            charCode = text.charCodeAt(i); // charCode is returned in UNICODE
            if ((charCode >= 0x00   && charCode <= 0xFF) ||   // latin-1
                (charCode >= 0xFF65 && charCode <= 0xFF9F)) { // hankaku katakana
              numBytes += 1;
            } else {
              numBytes += 2;
            }
          }
          return numBytes;
        },
        filter: function(keyCode, text, config) {
          var func = this,
              result = true;
          if (func.textNumBytes(text) > config.maxLen - 1) {
            result = false;
          } else if (typeof config.filter === 'function') {
            result = config.filter.apply(this, [keyCode]);
          }
          return result;
        },
        validate: function(text, config) {
          var func = this,
              result = text,
              numBytes;
          if (typeof config.validate === 'function') {
            result = config.validate.apply(this, [text]);
          }
          // String length should be checked after calling config.validate,
          // because config.validate may modify string.
          if (typeof result === "string") {
            numBytes = func.textNumBytes(result);
            if (numBytes > config.maxLen) {
              result = new Error("Die Folge ist zu lang.");
            } else if (numBytes < config.minLen) {
              result = new Error("Folge ist zu kurz.");
            }
          }
          return result;
        }
      }
    },
    checkbox: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id);
        var elem = doc.getElementById(id + ".input");
        var span = ihmi.cf.nextElementNode(elem);
        var type = this;
        var addEventHandler = ihmi.cf.addEventHandler;
        root.config = config;
        root.refresh = type.refresh;
        root.setCallback = type.setCallback;
        root.setRequiredMark = type.setRequiredMark;
        root.getChecked = type.getChecked;

        ihmi.cf.determineDefaultDesignPattern(root);
        root.setRequiredMark(false, null);

        if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
          addEventHandler(elem, "keypress", type.onkeypress);
        } else {
          addEventHandler(span, "keypress", type.onkeypress);
        }
        addEventHandler(elem, "click", type.onclick);
      },
      refresh: function(checked, disabled) {
        var root = this;
        var doc = root.ownerDocument;
        var elem = doc.getElementById(root.id + ".input");
        var span = ihmi.cf.nextElementNode(elem);
        if (disabled != null) {
          disabled = ihmi.cf.parseStrToBoolean(disabled);
          if (disabled) {
            span.removeAttribute("tabIndex");
          } else {
            span.setAttribute("tabIndex", 0);
          }
          span.disabled = disabled;
          elem.disabled = disabled;
        }
        if (checked != null) {
          elem.checked = ihmi.cf.parseStrToBoolean(checked);
        }
      },
      setCallback: function(callback) {
        var root = this;
        root.config.callback = callback;
      },
      onclick: function(event) {
        var elem = event.srcElement;
        var doc = elem.ownerDocument;
        var root = elem.parentNode;
        var frame = ihmi.cf.getDefaultView(doc);

        if (typeof root.config.callback === 'function') {
          root.config.callback(root.id, "clicked", elem.checked);
        } else {
          ihmi.cf.IUIFRequest(frame, { request: root.id + ".clicked", value: elem.checked }).send();
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        var doc = elem.ownerDocument;
        var root = elem.parentNode;
        var input = doc.getElementById(root.id + ".input");

        if (event.keyCode === 13) {
          input.click();
        }
      },
      setRequiredMark: function(show, adjustPos)  {
        var root = this;
        ihmi.cf.createRequiredMark(root, adjustPos, false, null);
        ihmi.cf.setRequiredMark(root, show);
      },
      getChecked: function() {
        var root = this;
        var doc = root.ownerDocument;
        var isChecked = false;
        var input = doc.getElementById(root.id + ".input");
        isChecked = (input !== null) ? input.checked : false;
        return isChecked;
      }
    },
    label: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.refresh = type.refresh;
        elem.config = config;
        elem.config.initInfo = {};
        elem.config.initInfo.config = ihmi.cf.copyInitConfig(config);
        elem.config.initInfo.root = elem.cloneNode(true);
      },
      refresh: function(text, color, disabled, isHTML) {
        var elem = this;
        if (isHTML) {
          elem.innerHTML = text;
        } else {
          elem.innerText = text;
        }
        if (typeof color === "string") {
          elem.style.color = (color.charAt(0) === "#") ? color : ihmi.global.colorTable[color];
        }
        elem.disabled = disabled;
        ihmi.cf.turnOnOffClass(elem, 'disabled', disabled);
      }
    },
    labelType: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.refresh = type.refresh;
      },
      refresh: function(image, name, disabled) {
        var elem = this,
            doc = elem.ownerDocument,
            img = doc.getElementById(elem.id + ".image"),
            span = doc.getElementById(elem.id + ".name");
        span.innerHTML = name;
        img.style.backgroundImage = ihmi.cf.format('url(%s)', image);
        elem.disabled = disabled;
        ihmi.cf.turnOnOffClass(elem, 'disabled', disabled);
      }
    },
    messageBox: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        var labeltext;
        elem.config = config;
        elem.refresh = type.refresh;

        if ((ihmi.cf.findDescendant(elem, "label", "text")) && config.designpattern === undefined ) {
          labeltext = ihmi.cf.findDescendant(elem, "label", "text");
          ihmi.cf.addClass(labeltext, "touch");
        }
        ihmi.cf.determineDefaultDesignPattern(elem);
      },
      refresh: function(lefttext, righttext) {
        var elem = this;
        var config = elem.config;
        var leftArea = ihmi.cf.findDescendant(elem, "SPAN", "message-box-contents-left");
        var rightArea = ihmi.cf.findDescendant(elem, "SPAN", "message-box-contents-right");
        if (lefttext !== null) {
          leftArea.innerHTML = lefttext;
        }
        if (righttext !== null) {
          if ((!config.intbox) && (!config.realbox) && (!config.realboxCoversion) && (!config.strbox) && (!config.checkbox)) {
            rightArea.innerHTML = righttext;
          }
        }
      }
    },
    messageArea: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        elem.config = config;
        elem.refresh = type.refresh;
        elem.setMultiLineHeight = type.setMultiLineHeight;

        ihmi.cf.determineDefaultDesignPattern(elem);
        if (("width" in config)||("height" in config)) {
          ihmi.cf.addClass(elem, 'message-area-fixed-size');
        }
        elem.setMultiLineHeight();
      },
      refresh: function(text, color, isHTML) {
        var elem = this;
        var colorTable = ihmi.global.colorTable;
        var label = ihmi.cf.firstElementNode(elem);

        if ((typeof color === "string") && (color in colorTable)) {
          elem.style.color = colorTable[color];
        }

        if (typeof text === "string") {
          if (isHTML) {
            label.innerHTML = text;
          } else {
            label.innerText = text;
          }
          elem.setMultiLineHeight();
        }
      },
      setMultiLineHeight: function() {
        var root = this;
        var labelElem = ihmi.cf.firstElementNode(root);
        var style = ihmi.cf.getCurrentStyle(labelElem);
        var offsetHeight = labelElem.offsetHeight;
        var lineHeight;
        var MULTI_LINE_HEIGHT = 1.3;

        if (style === null) {
          return;
        }
        lineHeight = parseInt(style.lineHeight, 10);

        if (offsetHeight > lineHeight) {
          root.style.lineHeight = MULTI_LINE_HEIGHT;
        }
      }
    },
    guideSteps: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id);
        var type = this;
        var frame = ihmi.cf.getDefaultView(doc);
        root.config = config;
        ihmi.cf.determineDefaultDesignPattern(root);
        root.config.feedByBtn = ihmi.cf.parseStrToBoolean(root.config.feedByBtn);
        root.refresh = type.refresh;
        root.updateTotal = type.updateTotal;
        root.topLiScroll = type.topLiScroll;
        root.isVisible = type.isVisible;
        root.showHideButtons = type.showHideButtons;
        root.selectStep = type.selectStep;
        root.feedStep = type.feedStep;
        root.jumpFirstLastPage = type.jumpFirstLastPage;
        root.setCallback = type.setCallback;
        root.getSelectedValue = type.getSelectedValue;
        root.setLineHeight = type.setLineHeight;
        root.setScrollAreaHeight = type.setScrollAreaHeight;
        root.setButtonWidth = type.setButtonWidth;
        root.getShownFirstValue = type.getShownFirstValue;
        root.refreshCompletedMark = type.refreshCompletedMark;
        root.getValueFromId = type.getValueFromId;
        root.getOptionProperty = type.getOptionProperty;
        root.refreshSelectedStep = type.refreshSelectedStep;

        ihmi.cf.addEventHandler(root, "click", type.onclick);

        if (config.width !== undefined) {
          root.style.width = config.width;
        }

        if (config.feedByBtn) {
          root.config.timeoutId = null;
          ihmi.cf.addEventHandler(root, "mousedown", type.onmousedown);
        } else {
          ihmi.cf.addClass(root, "guide-steps-scroll");
          if (config.height !== undefined) {
            root.style.height = config.height;
          }
        }

        ihmi.cf.addEventHandler(frame, "resize", function(event) {
          root.setScrollAreaHeight();
        });
      },
      getValueFromId: function(idValue) {
        var str = idValue.split(".")[1];
        return parseInt(str, 10);
      },
      getOptionProperty: function(option) {
        var root = this;
        var paragraphLabelElem = ihmi.cf.findDescendant(option, "span", "guide-steps-paragraph");
        var menueElem = ihmi.cf.findDescendant(option, "span", "guide-steps-menu");
        var menueLabelElem = ihmi.cf.firstElementNode(menueElem);
        var paragraphStr;
        var menueStr;
        var value = root.getValueFromId(option.id);
        paragraphStr = paragraphLabelElem.innerText.replace(/^ *\n */, '').replace(/ *\n *$/, '');
        menueStr = menueLabelElem.innerText.replace(/^ *\n */, '').replace(/ *\n *$/, '');

        var props = {
          value: value,
          paragraph: paragraphStr,
          text: menueStr
        };
        return props;
      },
      refresh: function(obj, selected, topval, height) {
        var root = this;
        var config = root.config;
        var ul = ihmi.cf.findDescendant(root, "ul", "guide-steps-items");
        var guideNum;
        var isAllRefresh = false;
        var lis;
        var i;
        var range = [];
        var props;
        var TOTAL_STEPS_AREA = 36;

        function isValueExist(options, checkValue) {
          for (var i = 0; i < options.length; i++) {
            if (options[i].value == checkValue) {
              return true;
            }
          }
          return false;
        }

        function getShowRange(options, topval, isAllRefresh, selected) {
          var NUM_OF_BUTTON = 5;
          var firstIndex;
          var lastIndex;
          var curShowFirstValue;
          var i;

          if (!config.feedByBtn) {
            return null;
          }

          if ((options.length !== 0) && (options.length < NUM_OF_BUTTON)) {
            firstIndex = 0;
            lastIndex = options.length - 1;
          } else {
            if (topval === null) {
              if (isAllRefresh) {
                topval = selected;
              } else {
                curShowFirstValue = root.getShownFirstValue();
                if ((selected < curShowFirstValue) || (selected > curShowFirstValue + (NUM_OF_BUTTON - 1))) {
                  //not visible
                  topval = selected;
                } else {
                  //visible
                  topval = root.getSelectedValue();
                }
              }
            }

            for (i = 0; i < options.length; i++) {
              if (options[i].value == topval) {
                firstIndex = i;
                break;
              }
            }

            if (firstIndex === undefined) {
              firstIndex = 0;
            }

            lastIndex = firstIndex + (NUM_OF_BUTTON - 1);
            if (!options[lastIndex]) {
              //show last page
              firstIndex = options.length - NUM_OF_BUTTON;
              lastIndex = options.length - 1;
            }
          }

          var range = {
            first : firstIndex,
            last : lastIndex
          };

          return range;
        }

        function buildHTML(obj, guideNum, selected, range) {
          var html = [];
          var row = [];
          var classes;
          var headLi;
          var paragraph;
          var menu;
          var menuButton;
          var i;

          for (i = 0; i < guideNum; i++) {
            if (!obj[i].className) {
              obj[i].className = "";
            }
            classes = obj[i].className;
            if (parseInt(obj[i].value, 10) === selected) {
              classes += " guide-steps-item-selected";
            }

            if (i === (guideNum - 1)) {
              classes += " guide-steps-item-last";
            }

            if (config.feedByBtn && (i < range.first) || (i > range.last)) {
              classes += " hide";
            }

            headLi = '<li id="' + root.id + "." + obj[i].value + '" class="guide-steps-item' + classes + '">';

            if (!obj[i].classNameParagraph) {
              obj[i].classNameParagraph = "";
            }
            paragraph = '<span class="guide-steps-paragraph' + obj[i].classNameParagraph + '">' + obj[i].paragraph + '</span>';

            if (!obj[i].classNameMenu) {
              obj[i].classNameMenu = "";
            }
            menu = '<span class="guide-steps-menu' + obj[i].classNameMenu + '"><label>' + obj[i].text + '</label></span>';

            if (!obj[i].classNameMenuButton) {
              obj[i].classNameMenuButton = "";
            }
            menuButton = '<div class="guide-steps-button' + obj[i].classNameMenuButton + '">';

            row.push(headLi);
            row.push(menuButton);
            row.push(paragraph);
            row.push(menu);
            row.push('<span class="ihmicomponent-step-complete"></span></div>');
            row.push('<ins class="guide-steps-arrow"></ins>');
            row.push('</li>');
          }
          html.push(row.join(''));
          return html.join('');
        }
        function adjustTotalWidth() {
          var TEXT_LEFT = 10;
          var BUTTON_RIGHT = 10;
          var bottomArea = ihmi.cf.findDescendant(root, "div", "guide-steps-otherwis-bottom");
          var bottomWidth = bottomArea.offsetWidth;
          var textTotalArea = ihmi.cf.findDescendant(root, "div", "guide-steps-total");
          var btnArea = ihmi.cf.findDescendant(root, "div", "guide-steps-page-button");
          var btnWidth = btnArea === null ? 0 : btnArea.offsetWidth;
          // Space for adjustment
          var notTextSpace = TEXT_LEFT + BUTTON_RIGHT + btnWidth;
          var isOverWidth = (bottomWidth < (textTotalArea.offsetWidth + notTextSpace));
          var styleObj = ihmi.cf.getCurrentStyle(textTotalArea);  // read-only
          if (bottomWidth === 0) return;      // element is hide
          while (isOverWidth) {
            textTotalArea.style.fontSize = parseInt(styleObj.fontSize) - 1 + 'px';
            isOverWidth = (bottomWidth < (textTotalArea.offsetWidth + notTextSpace));
          }
        }

        if ((height > TOTAL_STEPS_AREA) && !config.feedByBtn) {
          root.style.height = height + "px";
        }

        if ((obj === null) || (obj === undefined)) {
          obj = [];
          lis = ihmi.cf.findDescendants(ul, "li", "guide-steps-item");

          for (i = 0; i < lis.length; i++) {
            props = root.getOptionProperty(lis[i]);
            obj.push(props);
          }
        } else {
          isAllRefresh = true;
        }

        if ((selected === null) || (selected === undefined) || (!isValueExist(obj, selected))) {
          selected = root.getSelectedValue();
          if (selected === null) {
            selected = obj[0].value;
          }
        }
        selected = parseInt(selected, 10);

        if ((topval === null) || (topval === undefined) || (!isValueExist(obj, topval))) {
          topval = null;
        }

        ihmi.cf.removeLastUndefined(obj);
        guideNum = obj.length;

        if (config.feedByBtn) {
          range = getShowRange(obj, topval, isAllRefresh, selected);
        }

        if (isAllRefresh) {
          ul.innerHTML = buildHTML(obj, guideNum, selected, range);

          root.setScrollAreaHeight();
          root.setLineHeight();
          root.updateTotal();
          adjustTotalWidth();
          if (config.feedByBtn) {
            root.showHideButtons();
          } else {
            root.setButtonWidth();
            if (topval !== null) {
              root.topLiScroll(topval);
            } else {
              if (!root.isVisible(selected)) {
                root.topLiScroll(selected);
              }
            }
          }
        } else {
          if ((height > TOTAL_STEPS_AREA) && !config.feedByBtn) {
            root.setScrollAreaHeight();
          }
          root.refreshSelectedStep(selected, range, topval);
        }
      },
      setLineHeight: function() {
        var root = this;
        var menus = ihmi.cf.findDescendants(root, "span", "guide-steps-menu");
        var LINE_HEIGT_MULTI_LINE = 1.5;
        var BUTTON_HEIGHT = 60;
        var paragraph;
        var label;
        var marginTop;

        for (var i= 0; i < menus.length; i++) {
          label = ihmi.cf.firstElementNode(menus[i]);
          if (label.offsetHeight > BUTTON_HEIGHT) {
            //multi line
            menus[i].style.lineHeight = LINE_HEIGT_MULTI_LINE + "em";
            paragraph = ihmi.cf.prevElementNode(menus[i]);
            paragraph.style.verticalAlign = "top";
            marginTop = (BUTTON_HEIGHT - menus[i].clientHeight) / 2;
            menus[i].style.marginTop = marginTop + "px";
          }
        }
      },
      setScrollAreaHeight: function() {
        //if window heigh expand, scrollarea height is (root height) - (total step heith).
        var root = this;
        var scrollArea;
        var totalStepArea;
        var scrollAreaHeight;

        if (!ihmi.cf.hasClass(root, "guide-steps-scroll")){
          return;
        }

        //modern browzer use calc().
        if (!ihmi.global.isModernBrowser) {
          scrollArea = ihmi.cf.findDescendant(root, "div", "guide-steps-scrollarea");
          totalStepArea = ihmi.cf.findDescendant(root, "div", "guide-steps-otherwis-bottom");

          scrollAreaHeight = root.clientHeight - totalStepArea.clientHeight;
          if (scrollAreaHeight < 0) {
            return;
          }
          scrollArea.style.height = scrollAreaHeight + 'px';
        }
      },
      setButtonWidth: function() {
        var root = this;
        var ul;
        var scrollArea;
        var UL_LEFT_RIGHT_MARGIN = 20;
        var scrollbarWidth;
        var width;

        if (!ihmi.cf.hasClass(root, "guide-steps-scroll")){
          return;
        }

        if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
          //if do not set width, button width resize small on click.

          scrollArea = ihmi.cf.findDescendant(root, "div", "guide-steps-scrollarea");
          ul = ihmi.cf.findDescendant(root, 'ul', 'guide-steps-items');

          if (scrollArea.scrollHeight > scrollArea.clientHeight) {
            scrollbarWidth = 18; //exist scroll bar
          } else {
            scrollbarWidth = 0;
          }
          width = root.clientWidth - scrollbarWidth - UL_LEFT_RIGHT_MARGIN;
          if (width < 0) {
            return;
          }
          ul.style.width = root.clientWidth - scrollbarWidth - UL_LEFT_RIGHT_MARGIN + 'px';
        } else {
          return;
        }
      },
      updateTotal: function() {
        var root = this;
        var doc = root.ownerDocument;
        var totalElem = doc.getElementById(root.id + ".total");
        var stepNum = ihmi.cf.findDescendants(root, "li", "guide-steps-item").length;
        totalElem.innerText = stepNum;
      },
      topLiScroll: function(value) {
        var root = this;
        var doc = root.ownerDocument;
        var topLi = doc.getElementById(root.id + "." + value);
        var scrollArea = ihmi.cf.findDescendant(root, "div", "guide-steps-scrollarea");
        scrollArea.scrollTop = topLi.offsetTop;
      },
      isVisible: function(value) {
        var root = this;
        var config = root.config;
        var doc = root.ownerDocument;
        var li = doc.getElementById(root.id + "." + value);
        var BUTTON_HEIGHT = 60;
        var target;
        var scrollArea;
        var curPosScrollTop;
        var curPosscrollBtm;
        var targetTop;
        var targetBtm;
        var margin;
        var offsetparentMarginTop;
        var steps;

        if (li === null) {
          return false;
        }

        if (config.feedByBtn) {
          if (ihmi.cf.hasClass(li, "hide")) {
            return false;
          } else {
            return true;
          }
        } else {
          target = ihmi.cf.findDescendant(li, "div", "guide-steps-button");
          scrollArea = ihmi.cf.findDescendant(root, "div", "guide-steps-scrollarea");
          curPosScrollTop = scrollArea.scrollTop;
          curPosscrollBtm = curPosScrollTop + scrollArea.clientHeight;
          margin = Math.round(BUTTON_HEIGHT * 0.9);

          steps = ihmi.cf.findDescendant(root, "ul", "guide-steps-items");
          offsetparentMarginTop = steps.offsetTop;

          targetTop = target.offsetTop + offsetparentMarginTop;
          targetBtm = targetTop + BUTTON_HEIGHT;

          if ((curPosscrollBtm >= (targetTop + margin)) &&
              (curPosScrollTop <= (targetBtm - margin))) {
            return true;
          } else {
            return false;
          }
        }
      },
      showHideButtons: function() {
        var root = this;
        var doc = root.ownerDocument;
        var prevBtn = doc.getElementById(root.id + ".prev");
        var nextBtn = doc.getElementById(root.id + ".next");
        var items = ihmi.cf.findDescendants(root, "li", "guide-steps-item");
        var DEFAULT_VIEW_NUM = 5;
        var dispItems = [];
        var addClass = ihmi.cf.addClass;
        var removeClass = ihmi.cf.removeClass;
        var hasClass = ihmi.cf.hasClass;

        if (items.length <= DEFAULT_VIEW_NUM) {
          addClass(prevBtn, "hide");
          addClass(nextBtn, "hide");
          return;
        }

        for (var i = 0; i < items.length; i++) {
          if (!(hasClass(items[i], "hide"))) {
            dispItems.push(items[i]);
          }
        }
        if (items[0] === dispItems[0]) {
          addClass(prevBtn, "hide");
          removeClass(nextBtn, "hide");
        } else if (items[items.length - 1] === dispItems[dispItems.length - 1]) {
          addClass(nextBtn, "hide");
          removeClass(prevBtn, "hide");
        } else {
          if (hasClass(prevBtn, "hide")) {
            removeClass(prevBtn, "hide");
          }
          if (hasClass(nextBtn, "hide")) {
            removeClass(nextBtn, "hide");
          }
        }
      },
      onclick: function(event) {
        var target = event.srcElement;
        var root = ihmi.cf.findAncestor(target, 'div', 'guide-steps');
        var hasClass = ihmi.cf.hasClass;

        if ( (hasClass(target, "guide-steps-button") && !hasClass(target, "guide-steps-page-button")) || ((target.tagName === "SPAN") && (target.parentNode.className !== "guide-steps-total")) || (target.tagName === "LABEL")) {
          root.selectStep(target);
        } else if (hasClass(target, "guide-steps-page-button") || (target.className === "ihmicomponent-btn-dec1") || (target.className === "ihmicomponent-btn-inc1")) {
          root.feedStep(target);
        }
      },
      onmousedown: function(event) {
        var target = event.srcElement;
        var root = ihmi.cf.findAncestor(target, 'div', 'guide-steps');

        if (ihmi.cf.hasClass(target, "guide-steps-page-button") || (target.className === "ihmicomponent-btn-dec1") || (target.className === "ihmicomponent-btn-inc1")) {
          root.jumpFirstLastPage(target);
        }
      },
      selectStep: function(target) {
        var root = this;
        var doc = root.ownerDocument;
        var frame = ihmi.cf.getDefaultView(doc);
        var config = root.config;
        var li = ihmi.cf.findAncestor(target, 'li', 'guide-steps-item');
        var newValue = root.getValueFromId(li.id);
        var oldValue = root.getSelectedValue();

        if (ihmi.cf.hasClass(li, "disabled")) {
          return;
        }
        ihmi.cf.addClassExclusively(root, li, "guide-steps-item-selected");

        if (oldValue === newValue) {
          return;
        }

        if (typeof config.callback === 'function') {
          config.callback(root.id, "clicked", newValue);
        } else {
          IUIFRequest_(frame, {
            request: root.id + ".clicked",
            value: newValue
          }).send();
        }
      },
      feedStep: function(target) {
        var root = this;
        var doc = root.ownerDocument;
        var button = target;
        var dispItems = [];
        var items;
        var nextView;

        if (root.config.timeoutId !== null) {
          clearTimeout(root.config.timeoutId);
          root.config.timeoutId = null;
        }
        items = ihmi.cf.findDescendants(root, "li", "guide-steps-item");
        if (target.tagName === 'INS') {
          button = target.parentNode;
        }
        for (var i = 0; i < items.length; i++) {
          if (!(ihmi.cf.hasClass(items[i], "hide"))) {
            dispItems.push(items[i]);
          }
        }
        if (button === doc.getElementById(root.id + ".prev")) {
          nextView = dispItems[0].previousSibling;
          ihmi.cf.addClass(dispItems[dispItems.length - 1], "hide");
        } else if (button === doc.getElementById(root.id + ".next")) {
          nextView = dispItems[dispItems.length - 1].nextSibling;
          ihmi.cf.addClass(dispItems[0], "hide");
        }
        ihmi.cf.removeClass(nextView, "hide");
        root.showHideButtons();
      },
      jumpFirstLastPage: function(target) {
        var root = this;
        var doc = root.ownerDocument;
        var button = target;
        var nextViews = [];
        var DEFAULT_VIEW_NUM = 5;
        var items, i;

        root.config.timeoutId = setTimeout(function(){
          items = ihmi.cf.findDescendants(root, "li", "guide-steps-item");
          if (target.tagName === 'INS') {
            button = target.parentNode;
          }
          if (button === doc.getElementById(root.id + ".prev")) {
            for (i = 0; i < DEFAULT_VIEW_NUM; i++) {
              nextViews.push(items[i]);
            }
          } else if (button === doc.getElementById(root.id + ".next")) {
            for (i = (items.length - DEFAULT_VIEW_NUM); i < items.length; i++) {
              nextViews.push(items[i]);
            }
          }
          for (i = 0; i < items.length; i++) {
            if (!(ihmi.cf.hasClass(items[i], "hide"))) {
              ihmi.cf.addClass(items[i], "hide");
            }
          }
          for (i = 0; i < nextViews.length; i++) {
            ihmi.cf.removeClass(nextViews[i], "hide");
          }
          root.showHideButtons();
          root.config.timeoutId = null;
        }, 500);
      },
      getSelectedValue: function() {
        var root = this;
        var selected;

        selected = ihmi.cf.findDescendant(root, 'LI', "guide-steps-item-selected");
        if (selected === null) {
          return null;
        }
        return root.getValueFromId(selected.id);
      },
      getShownFirstValue: function() {
        var root = this;
        var options;
        var i;
        var len;

        options = ihmi.cf.findDescendants(root, 'LI', "guide-steps-item");
        if (options === null) {
          return null;
        }

        for (i = 0, len = options.length; i < len; i++) {
          if (!ihmi.cf.hasClass(options[i], "hide")) {
            break;
          }
        }

        if (i >= len) {
          return null;
        }

        return root.getValueFromId(options[i].id);
      },
      setCallback: function(callback) {
        var root = this;
        root.config.callback = callback;
      },
      refreshCompletedMark: function(value, isCompleted) {
        var root = this;
        var targetId = root.id + "." + value;
        var doc = root.ownerDocument;
        var targetButton = doc.getElementById(targetId);

        if (null === targetButton) {
          return;
        }
        ihmi.cf.turnOnOffClass(targetButton, 'guide-steps-item-completed', isCompleted);
      },
      refreshSelectedStep: function(selected, range, topval) {
        var root = this;
        var config = root.config;
        var targetId = root.id + "." + selected;
        var doc = root.ownerDocument;
        var targetButton = doc.getElementById(targetId);
        var ul;
        var li;
        var checkIndex;

        if (null === targetButton) {
          return;
        }
        root.selectStep(targetButton);

        if (config.feedByBtn) {
          ul = ihmi.cf.findDescendant(root, "ul", "guide-steps-items");

          for (checkIndex = 0, li = ihmi.cf.firstElementNode(ul); checkIndex < ul.childNodes.length && li !== null; checkIndex++, li = ihmi.cf.nextElementNode(li)) {
            ihmi.cf.turnOnOffClass(li, 'hide', (checkIndex < range.first) || (checkIndex > range.last));
          }
          root.showHideButtons();
        } else {
          if (topval !== null) {
            root.topLiScroll(topval);
          } else {
            if (!root.isVisible(selected)) {
              root.topLiScroll(selected);
            }
          }
        }
      }
    },
    thumbnail: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.refresh = type.refresh;
      },
      refresh: function(src) {
        var elem = this,
        frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            img = frame.document.getElementById(elem.id + ".image");
        if (src !== null) {
          img.src = src;
          ihmi.cf.removeClass(img, "hide");
        } else {
          ihmi.cf.addClass(img, "hide");
        }
      }
    },
    treeMenu: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id);
        var type = this;
        var methods = [
          'refresh',
          'buildTree',
          'getValue',
          'getSelectedProps',
          'getSelectedNode',
          'getFocusedNode',
          'scrollToFocused',
          'scrollToSelected',
          'selectNode',
          'selectClosedNode',
          'openNode',
          'closeNode',
          'handleKeys',
          'setSelectCallback',
          'setOpenCallback',
          'setCloseCallback',
          'onfocus',
          'onblur',
          'resScroll',
          'setAncestorArray',
          'addNode',
          'removeNode',
          'setRequiredMark',
          'func'
        ];
        config.expanded = {};
        config.handleKeys = null;
        config.scrollAmount = null;
        config.alignment = parseStrToBoolean_(config.alignment);
        config.escapeHTML = parseStrToBoolean_(config.escapeHTML);
        root.config = config;

        determineDefaultDesignPattern_(root);
        for (var i = 0, len = methods.length; i < len; i++) {
          root[methods[i]] = type[methods[i]];
        }
        root.delayedSelectNode = debounce_(function(nextSelected) {
          root.selectNode(nextSelected);
        }, 200);
        root.keyOperation = function(event) {
          return root.handleKeys(event);
        };
        addEventHandler_(root, "click", type.onclick);
        addEventHandler_(root, "focus", root.onfocus);
        addEventHandler_(root, "blur", root.onblur);
      },
      onfocus: function(event){
        var root;
        var frame;
        var curFocused;
        var curSelected;

        root = (event === undefined) ? this
                                     : event.srcElement;
        if (root.disabled === true) {
          return;
        }
        frame = getDefaultView_(root.ownerDocument);
        curFocused = findDescendant_(root, 'A', "tree-menu-focus");
        curSelected = findDescendant_(root, 'A', "tree-menu-selected");
        if ((curFocused === null) &&
            (curSelected !== null)) {
          addClass_(curSelected, "tree-menu-focus");
        }
        ihmi.cf.KeyEvent.addHandler(root.keyOperation, frame, false);
      },
      onblur: function(event){
        var root;
        root = (event === undefined) ? this
                                     : event.srcElement;
        ihmi.cf.KeyEvent.removeHandler(root.keyOperation);
        removeClassExclusively_(root, "A", "tree-menu-focus");
      },
      refresh: function(json, selected, disabled){
        var root = this;
        root.buildTree(json, selected, disabled);
      },
      buildTree: function(json, selected, disabled) {
        var root = this;
        var htmls = [];
        var config = root.config;
        var func = root.func;
        var i;
        var len;
        var isView = (config.treetype === 'view');
        var isSelect = (config.treetype === 'select');
        if (isSelect) addClass_(root, "tree-menu-select");
        if (isView) addClass_(root, "tree-menu-view");
        if (json !== null) {
          if (json.length === 0) {
            config.expanded = [];
          } else {
            removeLastUndefined_(json);
            for (i = 0, len = json.length; i < len; i++) {
              func.cleanJSON(json[i]);
              config.expanded = func.buildExpanded(config.expanded, json[i]);
              htmls.push([
                '<ul>',
                  func.nodeHTML(json[i], selected, config.expanded, (i === len - 1), config),
                '</ul>'
              ].join(''));
            }
          }
          root.innerHTML = htmls.join('');
        }
        root.setAncestorArray();
        for (i = 0; i < config.ancestorNodes.length; i++) {
          if (hasClass_(config.ancestorNodes[i], "tree-menu-open")) {
            addClass_(config.ancestorNodes[i].parentNode, "tree-menu-ancestor-open");
          }
        }
        root.disabled = disabled;
        turnOnOffClass_(root, 'disabled', disabled);
        (disabled) ? root.removeAttribute("tabIndex")
                   : root.setAttribute("tabIndex", 0);
        root.scrollToSelected();
        root.selectClosedNode(root.getSelectedNode());
      },
      selectNode: function(target) {
        var root = this,
            config = root.config,
            frame = getDefaultView_(target.ownerDocument),
            props;
        addClassExclusively_(root, target, 'tree-menu-selected');
        root.selectClosedNode(target);
        props = root.getSelectedProps();
        if (props !== null) {
          window.setTimeout(function() {
            if (typeof config.selectCallback === 'function') {
              config.selectCallback(root.id, "clicked", props);
            } else {
              IUIFRequest_(frame, {
                request: root.id + ".clicked",
                value: props.value
              }).send();
            }
          }, 0);
        }
      },
      selectClosedNode: function(target) {
        var root = this;
        var classStrClosed = 'tree-menu-closed';
        var classStrClosedSelected = 'tree-menu-closed-selected';
        var closedNode = findLastAncestor_(target, 'li', classStrClosed);
        if (closedNode !== null) {
          addClassExclusively_(root, closedNode, classStrClosedSelected);
        } else {
          closedNode= findDescendant_(root, 'li', classStrClosedSelected);
          if (closedNode !== null) {
            removeClass_(closedNode, classStrClosedSelected);
          }
        }
      },
      onclick: function(event) {
        var target = event.srcElement,
            root = findAncestor_(target, 'div', 'tree-menu'),
            config = root.config,
            tagName = target.tagName,
            className = target.className,
            btnClicked = false,
            li, scrollFrame;
        var classStrNode = 'tree-menu-node';
        var classStrFocus = 'tree-menu-focus';
        var classStrArrow = 'tree-menu-arrow';
        var classStrLeaf = 'tree-menu-leaf';
        var classStrOpen = 'tree-menu-open';
        var classStrClosed = 'tree-menu-closed';
        var classStrSelected = 'tree-menu-selected';

        if (root.disabled) return false;

        if (hasClass_(root.parentNode, "tree-scroll-frame")) {
          scrollFrame = root.parentNode;
        }
        if (config.treetype === 'view') {
          if ((className === classStrArrow) ||
              (className === 'tree-view-btn')) {
            btnClicked = true;
          }
        }
        if (findAncestor_(target, 'a', classStrNode) !== null) {
          target = findAncestor_(target, 'a', classStrNode);
          tagName = target.tagName;
          className = target.className;
        }
        if (scrollFrame !== undefined) {
          config.scrollAmount = scrollFrame.scrollTop;
          addEventHandler_(scrollFrame, "scroll", root.resScroll);
        }
        try {
          root.setActive();
        } catch (e) {
          root.focus();
        }
        if (scrollFrame !== undefined) {
          setTimeout(function(){ //wait scrollEvent end
            config.scrollAmount = null;
            removeEventHandler_(scrollFrame, "scroll", root.resScroll);
          }, 50);
        }
        if (tagName === 'A') {
          li = target.parentNode;
          addClassExclusively_(root, target, classStrFocus);
          if (hasClass_(li, classStrLeaf) &&
              hasClass_(li, classStrOpen)) {
            if (!hasClass_(target, classStrSelected)) {
              if (!btnClicked) {
                root.selectNode(target);
              }
            }
            if (btnClicked) {
              root.closeNode(li);
            }
          } else if (hasClass_(li, classStrLeaf) &&
                     hasClass_(li, classStrClosed)) {
            if (!hasClass_(target, classStrSelected)) {
              if (!btnClicked) {
                root.selectNode(target);
              }
            }
            if (btnClicked) {
              root.openNode(li);
            }
          } else if (hasClass_(li, classStrLeaf)) {
            if (!hasClass_(target, classStrSelected)) {
              if (!btnClicked) {
                root.selectNode(target);
              }
            }
          } else if (hasClass_(li, classStrOpen)) {
            root.closeNode(li);
          } else if (hasClass_(li, classStrClosed)) {
            root.openNode(li);
          }
          event.returnValue = false; // prevent default action
        }
        return false;
      },
      getSelectedNode: function() {
        var root = this;
        var classStrSelected = 'tree-menu-selected';
        return findDescendant_(root, 'a', classStrSelected);
      },
      getFocusedNode: function() {
        var root = this;
        var classStrFocus = 'tree-menu-focus';
        return findDescendant_(root, 'a', classStrFocus);
      },
      getSelectedProps: function() {
        var root = this,
            selected = root.getSelectedNode(),
            node;
        if (selected === null) return null;
        node = selected.parentNode;
        return {
          value: node.id,
          attr: node.getAttribute('data-attr')
        };
      },
      getValue: function() {
        var root = this,
            props = root.getSelectedProps();
        return (props !== null) ? props.value : "";
      },
      openNode: function(node) {
        var root = findAncestor_(node, 'div', 'tree-menu'),
            frame = getDefaultView_(node.ownerDocument),
            text = node.id,
            config = root.config;
        var classStrOpen = 'tree-menu-open';
        var classStrClosed = 'tree-menu-closed';

        for (var i = 0; i < config.ancestorNodes.length; i++) {
          if ((config.ancestorNodes[i] === node) &&
              !hasClass_(node.parentNode, "tree-menu-ancestor-open")) {
            addClass_(node.parentNode, "tree-menu-ancestor-open");
          }
        }
        replaceClass_(node, classStrClosed, classStrOpen);
        root.selectClosedNode(root.getSelectedNode());
        config.expanded[text] = true;
        if (typeof config.openCallback === 'function') {
          config.openCallback(root.id, "open", text);
        } else {
          IUIFRequest_(frame, {
            request: root.id + ".open",
            value: text
          }).send();
        }
      },
      closeNode: function(node) {
        var root = findAncestor_(node, 'div', 'tree-menu'),
            frame = getDefaultView_(node.ownerDocument),
            text = node.id,
            config = root.config;
        var classStrOpen = 'tree-menu-open';
        var classStrClosed = 'tree-menu-closed';

        for (var i = 0; i < config.ancestorNodes.length; i++) {
          if ((config.ancestorNodes[i] === node) &&
              hasClass_(node.parentNode, "tree-menu-ancestor-open")) {
            removeClass_(node.parentNode, "tree-menu-ancestor-open");
          }
        }
        replaceClass_(node, classStrOpen, classStrClosed);
        root.selectClosedNode(root.getSelectedNode());
        config.expanded[text] = false;
        if (typeof config.closeCallback === 'function') {
          config.closeCallback(root.id, "close", text);
        } else {
          IUIFRequest_(frame, {
            request: root.id + ".close",
            value: text
          }).send();
        }
      },
      setAncestorArray: function() {
        var root = this;
        var ul = root.children;
        var ancestorNodes = [];

        //Last Nodes don't have bottom margin.
        for (var i = 0; i < (ul.length - 1); i++) {
          if (firstElementNode_(ul[i]).tagName === 'LI') {
            ancestorNodes.push(firstElementNode_(ul[i]));
          }
        }
        root.config.ancestorNodes = ancestorNodes;
      },
      handleKeys: function(event) {
        if (event.preventDefault) {
          event.preventDefault();
        }
        var root = this,
            config = root.config,
            currSelected = root.getSelectedNode(),
            currFocused = root.getFocusedNode(),
            liSelected, liFocused, currNode, liPoint,
            dist = 0,
            idxSelected = -1,
            idxNext, leafNodes, openNodes,
            closedNode, nextSelected, numLeaves,
            findElem;
        var classStrOpen = 'tree-menu-open';
        var classStrClosed = 'tree-menu-closed';
        var classStrSelected = 'tree-menu-selected';
        var classStrLeaf = 'tree-menu-leaf';
        var classStrFocus = 'tree-menu-focus';
        var isTypeSelect = (config.movetype === 'select');
        var isTypeFocus = (config.movetype === 'focus');

        if (root.offsetHeight === 0) return true;
        if (currSelected === null) return true;
        if (currFocused === null) return true;

        liSelected = currSelected.parentNode;
        liFocused = currFocused.parentNode;

        switch (event.keyCode) {
          case 37: // left arrow
            if (isTypeSelect) {
              findElem = currSelected;
            } else if (isTypeFocus) {
              findElem = currFocused;
            }
            currNode = findLastAncestor_(findElem, 'li', classStrClosed);
            if (currNode !== null) {
              root.openNode(currNode);
              return false;
            }
          break;
          case 39: // right arrow
            if (isTypeSelect) {
              findElem = liSelected;
            } else if (isTypeFocus) {
              findElem = liFocused;
            }
            currNode = findAncestor_(findElem, 'li', classStrOpen);
            if (currNode !== null) {
              root.closeNode(currNode);
              return false;
            }
          break;
          case 13: // enter
            if (isTypeFocus &&
                !hasClass_(currFocused, classStrSelected)) {
              root.selectNode(currFocused);
              return false;
            }
          break;
        }

        dist = ihmi.cf.keyEventToDistance(event);

        if (dist === 0) {
          return true;
        }

        leafNodes = findDescendants_(root, 'li', classStrLeaf);
        openNodes = [];
        numLeaves = leafNodes.length;
        for (var i = 0; i < numLeaves; i++) {
          closedNode = findAncestor_(leafNodes[i], 'li', classStrClosed);
          if (closedNode === null ||
              leafNodes[i] === liSelected ||
              (dist > 0 && prevElementNode_(leafNodes[i]) === null) ||
              (dist < 0 && nextElementNode_(leafNodes[i]) === null)) {
            openNodes.push(leafNodes[i]);
          }
        }
        numLeaves = openNodes.length;
        if (numLeaves === 0) return true;

        if (!ihmi.global.isIEMobile && (event.keyCode === 9)) { // tab key is ignored on PC
          return true;
        }

        if (isTypeSelect) {
          liPoint = liSelected;
        } else if (isTypeFocus) {
          liPoint = liFocused;
        }

        if ((dist > 0) && (liPoint === openNodes[numLeaves - 1])) {
          idxNext = 0;
        } else if ((dist < 0) && (liPoint === openNodes[0])) {
          idxNext = numLeaves - 1;
        } else {
          for (i = 0; i < numLeaves; i++) {
            if (openNodes[i] === liPoint) {
              idxSelected = i;
            }
          }
          if (idxSelected < 0) return true;

          idxNext = idxSelected + dist;

          idxNext = Math.max(idxNext, 0);
          idxNext = Math.min(idxNext, numLeaves - 1);
        }
        nextSelected = firstElementNode_(openNodes[idxNext]);

        if (isTypeSelect) {
          addClassExclusively_(root, nextSelected, classStrSelected);
          addClassExclusively_(root, nextSelected, classStrFocus);
          root.delayedSelectNode(nextSelected);
        } else if (isTypeFocus) {
          addClassExclusively_(root, nextSelected, classStrFocus);
        }
        root.scrollToFocused();
        return false;
      },
      scrollToSelected: function() {
        var root = this,
            selected = root.getSelectedNode();
        if (selected === null) return;
        scrollTo_(root.parentNode, selected, 0);
      },
      scrollToFocused: function() {
        var root = this,
            selected = root.getFocusedNode();
        if (selected === null) return;
        scrollTo_(root.parentNode, selected, 0);
      },
      resScroll: function(event) {
        var scrollFrame = event.srcElement;
        var root = scrollFrame.children[0];
        var config = root.config;
        scrollFrame.scrollTop = config.scrollAmount;
      },
      setSelectCallback: function(callback) {
        var root = this;
        root.config.selectCallback = callback;
      },
      setOpenCallback: function(callback) {
        var root = this;
        root.config.openCallback = callback;
      },
      setCloseCallback: function(callback) {
        var root = this;
        root.config.closeCallback = callback;
      },
      addNode: function(json, targetid, addline, selected) {
        var root = this;
        var config = root.config;
        var data = json[0].data;
        var value = data.value;
        var doc = root.ownerDocument;
        var addTargetNode =  doc.getElementById(targetid);
        var childNodeHtml = [];
        var classStrOpen = 'tree-menu-open';
        var classStrClosed = 'tree-menu-closed';
        var classStrArrow = 'tree-menu-arrow';
        var classStrFocus = 'tree-menu-focus';
        var classStrLeaf = 'tree-menu-leaf';
        var classStrSelected = 'tree-menu-selected';
        var classStrSelectAlign = 'tree-menu-select-alignment';
        var classStrViewAlign = 'tree-menu-view-alignment';
        var addTargetNodeType = (root.id === targetid) ? "root"
                                : ((hasClass_(addTargetNode, classStrOpen) ||
                                  hasClass_(addTargetNode, classStrClosed))
                                  ? "parent"
                                  : "children");

        function createChildNode() {
          var attr = ((typeof data.attr === 'string') && (data.attr !== "")) ? data.attr : "";
          var createHtml = data.createHtml ? data.createHtml : "";
          var tagIcon;
          var insClass;
          var addClass = data.className ? data.className : "";
          var nodeText = data.text ? data.text : "";
          var top;
          var right;
          var bottom;
          var left;

          if (config.escapeHTML) {
            nodeText = escapeHTML_(nodeText);
          }
          if (config.alignment) {
            insClass = (config.treetype === "select")
                              ? (" " + classStrSelectAlign)
                              : (" " + classStrViewAlign);
          } else {
            insClass = "";
          }
          tagIcon = data.icon ? format_('<ins style="background-image: url(%s); background-repeat: no-repeat;"'
                                         + 'class="tree-menu-icon%s"></ins>',
                                        data.icon,
                                        insClass) : "";
          if (tagIcon) insClass = "";
          if (addTargetNodeType === "children") {
            convertToParentNode();
          }

          if (data.requiredMarkPos == undefined) {
            top = "top: -3px ;";
            right = "right: -3px ;";
            left = "";
            bottom = "";
          } else {
            top = (data.requiredMarkPos.top) ? "top: " + data.requiredMarkPos.top + ";": "";
            right =  (data.requiredMarkPos.right) ? "right: " + data.requiredMarkPos.right + ";": "";
            left =  (data.requiredMarkPos.left) ? "left: " + data.requiredMarkPos.left + ";": "";
            bottom =  (data.requiredMarkPos.bottom) ? "bottom: " + data.requiredMarkPos.bottom + ";": "";
          }

          //Creating a child node
          if ((addTargetNodeType === "children") ||
              (addTargetNodeType === "root")) {
            childNodeHtml.push(format_('<ul>'));
          }
          childNodeHtml.push(format_('<li class="tree-menu-leaf %s" id="%s" data-attr="%s">'
                                      + '<a class="tree-menu-node %s"',
                                      addClass,
                                      value,
                                      attr,
                                      addClass));
          childNodeHtml.push(format_('tabindex="-1">'));
          childNodeHtml.push(format_('<img src="/frh/ihmi/ihmicomponent_required_mark.png" id="%s.requiredMark" class="required-mark hide" style="%s %s %s %s">',
                                      value,
                                      top,
                                      right,
                                      bottom,
                                      left));
          if (config.treetype === "select") {
            childNodeHtml.push(format_('%s<span class="tree-menu-text %s">%s</span>',
                                        tagIcon,
                                        insClass,
                                        nodeText));
            childNodeHtml.push(format_('%s</a>', createHtml));
          } else {
            childNodeHtml.push(format_('<div class="tree-view-text-node">%s<span class="tree-menu-text %s">%s</span>',
                                        tagIcon,
                                        insClass,
                                        nodeText));
            childNodeHtml.push(format_('%s</div></a></li>', createHtml));
          }
          if ((addTargetNodeType === "children") ||
              (addTargetNodeType === "root")) {
            childNodeHtml.push(format_('</ul>'));
          }
          childNodeHtml = childNodeHtml.join('');
        }

        function convertToParentNode() {
          var arrowBtnHtml = [];
          var arrowBtnParentNode = addTargetNode.children[0];
          var textNodeMarginLeft;
          var alignmentTagName;
          var alignmentRemoveClass;

          //Convert child node to parent node
          addClass_(addTargetNode, classStrOpen);
          if (config.treetype === "select") {
            removeClass_(addTargetNode, classStrLeaf);
          }
          //Create arrow button.
          if (config.treetype === "view") {
            arrowBtnHtml.push(format_('<span class="tree-view-btn">'
                                      + '<ins class="'+ classStrArrow + '"></ins>'
                                      + '</span>'));
            textNodeMarginLeft = (config.designpattern === 'touch') ? '54px': '28px';
            arrowBtnParentNode.lastChild.style.marginLeft = textNodeMarginLeft;
          } else {
            arrowBtnHtml.push(format_('<ins class="'+ classStrArrow + '"></ins>'));
            if (hasClass_(arrowBtnParentNode, classStrSelected)) {
              removeClass_(arrowBtnParentNode, classStrSelected);
            }
          }
          if (config.alignment) {
            alignmentRemoveClass = (config.treetype === "view")
                                                ? classStrViewAlign
                                                : classStrSelectAlign;
            alignmentTagName = (findDescendant_(addTargetNode, 'span', alignmentRemoveClass)) ? 'span' : 'ins';
            removeClass_(findDescendant_(addTargetNode, alignmentTagName, alignmentRemoveClass), alignmentRemoveClass);
          }
          arrowBtnParentNode.insertAdjacentHTML('afterbegin', arrowBtnHtml);
        }

        function addChildNode() {
          var ADD_FIRST_LINE = 1;
          var addChildNode;
          var addParentNode;
          var selectedTargetElem; // -selected, -focus target elem
          addline = (addline === undefined) ? 0 : addline;

          if (addTargetNodeType === "children") {
            // target node is child
            // add <ul><li><a> in <li>.
            addTargetNode.insertAdjacentHTML('beforeend', childNodeHtml);
            addChildNode = addTargetNode.children[1].lastChild;
            addClass_(addChildNode, 'tree-menu-last');
          } else {
            if (addTargetNodeType === "parent") {
              // target node is parent
              // add <li> in <ul>.
              for (var i = 0; i < addTargetNode.children.length; i++) {
                if (addTargetNode.children[i].tagName === 'UL') {
                  addParentNode = addTargetNode.children[i];
                  break;
                }
              }
            } else {
              // target node is root
              // add <ul> in <div>.
              addParentNode = root;
            }

            if (addline === ADD_FIRST_LINE) {
              addParentNode.insertAdjacentHTML('afterbegin', childNodeHtml);
              addChildNode = addParentNode.firstChild;
            } else if ((addline !== 0) && ((addline-1) < addParentNode.children.length))  {
              addParentNode.children[(addline-1)].insertAdjacentHTML('beforebegin', childNodeHtml);
              addChildNode = addParentNode.children[(addline-1)];
            } else {
              addParentNode.insertAdjacentHTML('beforeend', childNodeHtml);
              addChildNode = addParentNode.lastChild;
              addClassExclusively_(addParentNode, addChildNode, "tree-menu-last");
            }
          }
          if (parseStrToBoolean_(selected)) {
            if (hasClass_(addTargetNode, classStrClosed)) {
              replaceClass_(addTargetNode, classStrClosed, classStrOpen);
              removeClass_(addTargetNode, classStrClosed + "-selected");
            }
            if (addTargetNodeType === "root") {
              selectedTargetElem = addChildNode.children[0].children[0];
            } else {
              selectedTargetElem = addChildNode.children[0];
            }
            addClassExclusively_(root, selectedTargetElem, classStrSelected);
            addClassExclusively_(root, selectedTargetElem, classStrFocus);
          }
        }

        // Main processing of addNode function
        if (doc.getElementById(value) !== null) {
          //console.log('[ERROR]An element with the specified ID already exists. (id =' + value + ' )');
          return;
        }
        createChildNode();
        addChildNode();
      },
      removeNode: function(deleteid) {
        var root = this;
        var config = root.config;
        var doc = root.ownerDocument;
        var targetNode = doc.getElementById(deleteid);
        var parentUlElem;
        var parentLiElem;
        var arrowBtn;
        var prevNode;
        var deleteEndNode;
        var DELETE_NODE_ONLY = 1;
        var alignmentTagName;
        var alignmentNodeClass;
        var alignmentAddClass;

        if ((targetNode === null) ||
            (root.id === deleteid)) {// remove Root Node
          // console.log('[ERROR]targetNode is not found (id =' + deleteid + ' )');
          return;
        }
        if (root !== findAncestor_(targetNode, 'div', 'tree-menu')) {
          // to delete other than under root
          return;
        }
        parentUlElem = targetNode.parentElement;
        parentLiElem = parentUlElem.parentElement;
        //Check if "tree-menu-class" is assigned to the target node
        if (hasClass_(targetNode, 'tree-menu-last')) {
          deleteEndNode = true;
        }
        //Check the remaining child nodes. (Including the node to be deleted)
        if (parentUlElem.children.length === DELETE_NODE_ONLY) {
          //Processing when there are no child nodes in the parent node
          prevNode = prevElementNode_(parentUlElem);
          if (prevNode === null) {
            //What to do when all nodes are deleted
            parentUlElem.removeChild(targetNode);
            if (parentUlElem !== root) {
              parentLiElem.removeChild(parentUlElem);
            }
            return;
          }
          if (prevNode.tagName === 'A') {
            //Processing to convert from parent node to child node
            removeClasses_(parentLiElem, "tree-menu-open tree-menu-closed");
            if (config.treetype === "select") {
              alignmentAddClass = "tree-menu-select-alignment";
              addClass_(parentLiElem, "tree-menu-leaf");
              arrowBtn = findDescendants_(parentLiElem, 'ins', 'tree-menu-arrow');
            } else {
              alignmentAddClass = "tree-menu-view-alignment";
              prevNode.lastChild.style.marginLeft = '';
              arrowBtn = findDescendants_(parentLiElem, 'span', 'tree-view-btn');
            }
            if (config.alignment) {
              if (findDescendant_(prevNode, 'ins', "tree-menu-icon")) {
                alignmentTagName = 'ins';
                alignmentNodeClass = 'tree-menu-icon';
              } else {
                alignmentTagName = 'span';
                alignmentNodeClass = 'tree-menu-text';
              }
              addClass_(findDescendant_(prevNode, alignmentTagName, alignmentNodeClass), alignmentAddClass);
            }
            arrowBtn[0].parentNode.removeChild(arrowBtn[0]);
          } else if (prevNode.tagName === 'UL') {
            //Processing when the parent node is deleted
            if (deleteEndNode === true) {
              addClass_(prevNode.firstChild, "tree-menu-last");
            }
          }
          parentUlElem.removeChild(targetNode);
          parentLiElem.removeChild(parentUlElem);
        } else {
          //Processing when a parent node has multiple child nodes
          if (deleteEndNode === true) {
            prevNode = prevElementNode_(targetNode);
            addClass_(prevNode, "tree-menu-last");
          }
          parentUlElem.removeChild(targetNode);
        }
      },
      setRequiredMark: function(show, treeId) {
        var root = this;
        var doc = root.ownerDocument;
        var treeElem =  doc.getElementById(treeId);
        if (treeElem !== null) {
          setRequiredMark_(treeElem, show);
        }
      },
      func: {
        cleanJSON: function(json) {
          var children = json.children,
              newChildren = [],
              child;
          for (var i = 0, len = children.length; i < len; i++) {
            child = children[i];
            if (child !== undefined) {
              newChildren.push(child);
              this.cleanJSON(child);
            }
          }
          json.children = newChildren;
        },
        buildExpanded: function(expanded, json) {
          function buildExpandedRecurse(oldExpanded, json, newExpanded) {
            var data = json.data,
                children = json.children,
                value = data.value,
                added = false;
            for (var i = 0, len = children.length; i < len; i++) {
              added |= buildExpandedRecurse(oldExpanded, children[i], newExpanded);
            }
            if (oldExpanded[value] === undefined) added = true;
            newExpanded[value] = added ? true : oldExpanded[value];

            return added;
          }
          var newExpanded = [];
          buildExpandedRecurse(expanded, json, newExpanded);
          return newExpanded;
        },
        nodeHTML: function(json, selected, expanded, last, config) {
          var data = json.data,
              children = json.children,
              numChildren = children.length,
              value = data.value, tagIcon,
              attr, html, createHtml, top, right, bottom, left,
              liATag, imgTag, divTag, spanTag, divClose, aClose, islast;
          var isView = (config.treetype === 'view');
          var isSelect = (config.treetype === 'select');
          var insClass = '';
          var tagArrow = '';
          var textNodeMarginLeft = '';
          var liClass = data.className ? data.className : "";
          var selectedClass = data.className ? data.className : "";
          var nodeText = data.text ? data.text : "";
          var classStrOpen = 'tree-menu-open';
          var classStrClosed = 'tree-menu-closed';
          var classStrLeaf = 'tree-menu-leaf';
          var classStrArrow = 'tree-menu-arrow';

          if (config.escapeHTML) {
            nodeText = escapeHTML_(nodeText);
          }
          if (!(/\b(tree-menu-leaf|tree-menu-open|tree-menu-closed)\b/).test(liClass)) {
            if (isView) {
              liClass += ' ' + classStrLeaf;
              if (numChildren !== 0) {
                liClass += (expanded[value])  ? ' ' + classStrOpen
                                              :' ' + classStrClosed;
              }
            }
            if (isSelect) {
              liClass += (numChildren === 0) ? ' ' + classStrLeaf
                            : (expanded[value]) ? ' ' + classStrOpen
                                                : ' ' + classStrClosed;
            }
          }
          attr = (typeof data.attr === 'string' && data.attr !== "") ? (' data-attr="' + data.attr + '"') : "";
          if (numChildren === 0) {
              tagArrow = '';
          } else {
            if (isView) {
              tagArrow = '<span class="tree-view-btn">'
                            + '<ins class="' + classStrArrow + '"></ins>'
                        +'</span>';
              textNodeMarginLeft = (config.designpattern === 'touch')
                                      ? 'style="margin-left: 54px;"'
                                      : 'style="margin-left: 28px;"';
            }
            if (isSelect) {
              tagArrow = '<ins class="' + classStrArrow + '"></ins>';
            }
          }
          if ((numChildren === 0) && (config.alignment)) {
            insClass = isSelect ? " tree-menu-select-alignment"
                                : " tree-menu-view-alignment";
          }
          tagIcon = data.icon ? format_('<ins style="background-image: url(%s); background-repeat: no-repeat;" class="tree-menu-icon%s"></ins>', data.icon, insClass) : '';

          if (last) liClass += ' tree-menu-last';
          if (value === selected) {
            if (isView ||
                isSelect && numChildren === 0) {
                selectedClass += ' tree-menu-selected';
            }
          }
          if (tagIcon) insClass = "";
          createHtml = data.createHtml ? data.createHtml : "";
          if (data.requiredMarkPos == undefined) {
            top = "top: -3px ;";
            right = "right: -3px ;";
            left = "";
            bottom = "";
          } else {
            top = (data.requiredMarkPos.top) ? "top: " + data.requiredMarkPos.top + ";": "";
            right =  (data.requiredMarkPos.right) ? "right: " + data.requiredMarkPos.right + ";": "";
            left =  (data.requiredMarkPos.left) ? "left: " + data.requiredMarkPos.left + ";": "";
            bottom =  (data.requiredMarkPos.bottom) ? "bottom: " + data.requiredMarkPos.bottom + ";": "";
          }
          liATag = [
            '<li class="',
            liClass,
            '" id="',
            value,
            '"',
            attr,
            '><a class="tree-menu-node ',
            selectedClass,
            '" tabindex="-1">',
            tagArrow
          ];
          imgTag = [
            '<img src="/frh/ihmi/ihmicomponent_required_mark.png" id="',
            value,
            '.requiredMark" class="required-mark hide" style="',
            top,
            right,
            bottom,
            left,
            '">'
          ];
          divTag = [
            '<div class="tree-view-text-node"',
            textNodeMarginLeft,
            '>'
          ];
          spanTag = [
            '<span class="tree-menu-text',
            insClass,
            '">',
            nodeText,
            '</span>'
          ];
          divClose =  '</div>';
          aClose = '</a>';
          if (isView) html = liATag.concat(imgTag, divTag, tagIcon, spanTag, createHtml, divClose, aClose);
          if (isSelect) html = liATag.concat(tagIcon, imgTag, spanTag, createHtml, aClose);
          if (numChildren > 0) {
            html.push('<ul>');
            for (var i = 0; i < numChildren; i++) {
              islast = (i == numChildren - 1);
              html.push(this.nodeHTML(children[i], selected, expanded, islast, config));
            }
            html.push('</ul>');
          }
          html.push('</li>');
          return html.join('');
        }
      }
    },
    listview: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id),
            frame = getDefaultView_(doc),
            type = this,
            addEventHandler = ihmi.cf.addEventHandler;

        if (!(config.movetype === "focus") || (config.movetype === "select")) {
          config.movetype = "select";
        }
        if (config.movetype === "select") {
          // windows tablet is same behavior with tablet.
          ihmi.cf.judgeAddTabletClass(root);
        }
        root.config = {
          sortKey: 0,
          sortType: 'asc',
          handleKeys: null,
          keyHandlers: [],
          timeoutId: null,
          movetype: config.movetype,
          fixcol: parseStrToBoolean_(config.fixcol)
        };
        root.refresh = type.refresh;
        root.sortRows = type.sortRows;
        root.addRows = type.addRows;
        root.refreshTable = type.refreshTable;
        root.scrollToSelected = type.scrollToSelected;
        root.scrollToFocused = type.scrollToFocused;
        root.getSelectedValue = type.getSelectedValue;
        root.selectRow = type.selectRow;
        root.sortArrayRows = type.sortArrayRows;
        root.handleKeys = type.handleKeys;
        root.addKeyHandler = type.addKeyHandler;
        root.adjustTableWidth = type.adjustTableWidth;
        root.setCallback = type.setCallback;
        root.scrollTo = type.scrollTo;

        addEventHandler_(root, "click", type.onclick);

        if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
          ihmi.cf.addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
            try {
              root.adjustTableWidth();
            } catch (e) {
              return;
            }
          }, 200));
        }

        // IE11 does not suppurt CSS expression and position sticky.
        if (ihmi.cf.getIEVersion(window.navigator.userAgent) >= 7) {
          ihmi.cf.addEventHandler(root, "scroll", type.stickyAlt);
        }

        if (!ihmi.global.isIEMobile &&
            "dblclick" in config && config.dblclick === "true") {
          addEventHandler(root, "dblclick", type.ondblclick);
        }
        if (root.config.fixcol) {
          ihmi.cf.addClass(root, "ihcp-listview-fixcol");
        }
        if ("focus" in config && config.focus === "false") {
          root.config.focus = false;
          addEventHandler(frame, "load", function() {
            ihmi.cf.KeyEvent.addHandler(function(event) {
              return root.handleKeys(event, false);
            }, frame, false);
          });
        } else {
          root.config.focus = true;
          addEventHandler(root, "focus", type.onfocus);
          addEventHandler(root, "blur", type.onblur);
        }
      },
      refresh: function(json, selected, disabled, argObj) {
        var root = this,
            config = root.config,
            sortKey = config.sortKey,
            sortType = config.sortType,
            firstElementNode = ihmi.cf.firstElementNode,
            nextElementNode = ihmi.cf.nextElementNode,
            lastElementNode = ihmi.cf.lastElementNode,
            table = firstElementNode(root),
            thead = firstElementNode(table),
            theadInfo,
            ROW_HEIGHT = 42,//height + border
            isCategorized = false,
            numCols, innerHead, innerBody, tbody, tr, rowCount, curSelected, value, offsetHeight, td;

        if (json != null) {
          innerHead = null;
          if ('head' in json) {
            removeLastUndefined_(json.head);
            theadInfo = theadHTML(json.head, sortKey, sortType);
            innerHead = theadInfo.html;
            numCols = theadInfo.numCols;
          } else {
            numCols = lastElementNode(thead).children.length;
          }
          innerBody = ('body' in json) ? tbodyHTML(json.body, sortKey, sortType, numCols) : null;
          if (!('body' in json)) {//only header
            isCategorized = hasClass_(root, "ihcp-listview-categorized");
          } else if (json.body &&
                     json.body[0] &&
                     json.body[0].category) {
            isCategorized = true;
          }

          turnOnOffClass_(root, 'ihcp-listview-categorized', isCategorized);

          root.refreshTable(innerHead, innerBody);
        }

        table = firstElementNode(root);
        thead = firstElementNode(table);
        tbody = nextElementNode(thead);

        if (json != null) {
          if (theadInfo && theadInfo.numRows && (theadInfo.numRows > 1)) {
            //multi rows header
            offsetHeight = 0;
            for (tr = firstElementNode(thead), rowCount = 0; tr !== null; tr = nextElementNode(tr), rowCount++) {
              if (rowCount === 0) {
                offsetHeight += (tr.offsetHeight > 0) ? tr.offsetHeight : ROW_HEIGHT;
                continue;//skip first row
              }
              for (var th = firstElementNode(tr); th !== null; th = nextElementNode(th)) {
                th.style.top = offsetHeight + "px";//for position:sticky
              }
              offsetHeight += (offsetHeight > 0) ? tr.offsetHeight : ROW_HEIGHT;
            }
          }
          if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
            //set last col class
            for (tr = firstElementNode(tbody); tr !== null; tr = nextElementNode(tr)) {
              td = firstElementNode(tr);
              if (td !== null) {
                ihmi.cf.addClass(td, 'ihcp-listview-firstcol');
              }
              td = lastElementNode(tr);
              if (td !== null) {
                ihmi.cf.addClass(td, 'ihcp-listview-lastcol');
              }
            }
          }
        }
        if (selected !== null) {
          for (tr = firstElementNode(tbody); tr !== null; tr = nextElementNode(tr)) {
            value = tr.getAttribute('data-value');
            if (value === null || value === '') value = ihmi.cf.getText(firstElementNode(tr));
            if (value === selected) {
              ihmi.cf.addClassExclusively(tbody, tr, 'ihcp-listview-selected');
              break;
            }
          }
        }
        if (config.focus === false) {
          curSelected = ihmi.cf.findDescendant(tbody, 'TR', 'ihcp-listview-selected');
          if (curSelected !== null) {
            ihmi.cf.addClass(curSelected, 'ihcp-listview-focused');
          }
        }
        root.scrollToSelected();
        root.adjustTableWidth();

        if ((disabled != null) && (table.disabled !== disabled)) {
          table.disabled = disabled;
          ihmi.cf.turnOnOffClass(root, 'disabled', disabled);
        }
        function theadHTML(json, sortKey, sortType) {
          var html = [],
              theadInfo = {},
              i, len, classes, row, cell, isLastRow, numCols, numRows, text, cells;

          if (typeof json[0] === "string") {
            //single row
            /* ex ["item1", "item2", "item3"] */
            html.push('<tr>');
            for (i = 0, len = json.length; i < len; i++) {
              row = json[i];
              html.push('<th');
              classes = [];
              if (i === sortKey) classes.push('ihcp-listview-sort-' + sortType);
              if (classes.length > 0) html.push(' class="' + classes.join(' ') + '"');
              html.push('>');
              html.push(json[i]);
              html.push('</th>');
            }
            numCols = len;
            numRows = 1;
            html.push('</tr>');
          } else {
            //multi rows
            /* ex [ { cells: ['header1-1', { text: 'header1-2', colspan: '2'} ], { cells: [... */
            for (i = 0, len = json.length; i < len; i++) {
              row = json[i];
              html.push('<tr>');
              if (row !== undefined) {
                isLastRow = ((i === (len - 1)) ? true : false);
                cells = ((row.cells != undefined) ? row.cells : row);
                if (isLastRow) {
                  numCols = cells.length;
                  numRows = len;
                }
                for (var j = 0, numCells = cells.length; j < numCells; j++) {
                  cell = cells[j];
                  if (cell === undefined) break;
                  html.push('<th');
                  classes = [];
                  if ((isLastRow) && (j === sortKey)) { // selected col
                    classes.push('ihcp-listview-sort-' + sortType);
                  }
                  if (typeof cell === "object") {
                    if ('className' in cell) {
                      classes.push(cell.className);
                    }
                    if (classes.length > 0) html.push(' class="' + classes.join(' ') + '"');
                    if (!isLastRow && ('colspan' in cell)) {
                      html.push(ihmi.cf.format(' colspan="%s"', cell.colspan));
                    }
                    text = cell.text;
                  } else {
                    if (classes.length > 0) html.push(' class="' + classes.join(' ') + '"');
                    text = cell;
                  }
                  html.push('>');
                  html.push(text);
                  html.push('</th>');
                }
              }
              html.push('</tr>');
            }
          }
          theadInfo.html = html.join('');
          theadInfo.numCols = numCols;
          theadInfo.numRows = numRows;
          return theadInfo;
        }

        function tbodyRowHTML(json, sortKey, sortType) {
          var arrayRows = [],
              row, cell, className, value, cells, html, key;
          for (var i = 0, numRows = json.length; i < numRows; i++) {
            row = json[i];
            if (row === undefined) break;

            className = row.className === undefined ? '' : ' class="' + row.className + '"';
            value = row.value === undefined ? '' : ' data-value="' + row.value + '"';
            cells = row.cells;

            html = [];
            html.push('<tr' + className + value + '>');
            for (var j = 0, numCells = cells.length; j < numCells; j++) {
              cell = cells[j];
              if (cell === undefined) break;

              if (typeof cell === "object") {
                html.push('<td');
                if ('className' in cell) {
                  html.push(ihmi.cf.format(' class="%s"', cell.className));
                }
                if ('key' in cell) {
                  html.push(ihmi.cf.format(' data-value="%s"', cell.key));
                }
                if ('bgcolor' in cell) {
                  html.push(ihmi.cf.format(' style="background-color: %s;"', cell.bgcolor));
                }
                if ('title' in cell) {
                  html.push(ihmi.cf.format(' title="%s"', cell.title));
                }
                html.push('>');
                if ('image' in cell) {
                  html.push('<img class="ihcp-listview-img" src="');
                  html.push(cell.image);
                  html.push('" align="absmiddle">');
                }
                html.push(cell.text);
                html.push('</td>');
              } else {
                html.push('<td>');
                html.push(cell);
                html.push('</td>');
              }
            }
            html.push('</tr>');

            key = cells[sortKey];
            if (typeof key === 'object') {
              key = ('key' in key) ? key.key : key.text;
            }
            arrayRows.push({ key: key, node: html.join('') });
          }
          return root.sortArrayRows(arrayRows, sortType);
        }
        function tbodyHTML(json, sortKey, sortType, numCols) {
          var category, className, html;

          if (json.length == 0) return '';

          if (json[0].category) {
            html = [];
            for (var i = 0, numCategorys = json.length; i < numCategorys; i++) {
              category = json[i];
              if (category === undefined) break;
              if (category.category) {
                className = (category.className == undefined) ? '' : category.className;
                html.push(ihmi.cf.format('<tr class="ihcp-listview-category %s">', className));
                if (config.fixcol) {
                  html.push('<td><span class="ihcp-listview-category"></span>');
                  html.push(ihmi.cf.format('<span style="position: absolute;">%s</span>', category.text));
                  html.push(ihmi.cf.format('<td colspan="%s">', numCols-1));
                } else {
                  html.push(ihmi.cf.format('<td colspan="%s">', numCols));
                  html.push(ihmi.cf.format('<div class="ihcp-listview-category">%s</div>', category.text));
                }
                html.push('</td></tr>');
                html.push(tbodyRowHTML(category.rows, sortKey, sortType));
              }
            }
            return html.join('');
          } else {
            return tbodyRowHTML(json, sortKey, sortType);
          }
        }
      },
      addRows: function(json) {
        var root = this,
            doc = root.ownerDocument,
            table = ihmi.cf.firstElementNode(root),
            thead = ihmi.cf.firstElementNode(table),
            tbody = ihmi.cf.nextElementNode(thead),
            isIE7 = (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7),
            tr, td,
            row, cell, value, cells, img, addClassName;
        for (var i = 0, numRows = json.length; i < numRows; i++) {
          row = json[i];
          if (row === undefined) break;

          cells = row.cells;

          tr = doc.createElement('tr');
          if (row.className !== undefined) tr.className = row.className;
          value = row.value;
          if ((value !== null) && (value !== undefined)) tr.setAttribute('data-value', value);

          for (var j = 0, numCells = cells.length; j < numCells; j++) {
            cell = cells[j];
            if (cell === undefined) break;

            td = doc.createElement('td');
            if (typeof cell === "object") {
              if ('image' in cell) {
                img = doc.createElement('img');
                img.className = 'ihcp-listview-img';
                img.src = cell.image;
                img.align = 'absmiddle';
              }
              td.innerText = cell.text;
              if ('className' in cell) {
                addClassName = cell.className;
                if (isIE7) {
                  if (j == 0) {
                    addClassName += " ihcp-listview-firstcol";
                  } else if (j == (numCells-1)) {
                    addClassName += " ihcp-listview-lastcol";
                  }
                }
                td.className = addClassName;
              }
              if ('key' in cell) {
                td.setAttribute('data-value', cell.key);
              }
              if ('bgcolor' in cell) {
                td.style.backgroundColor = cell.bgcolor;
              }
            } else {
              img = null;
              td.innerText = cell;
              if (isIE7) {
                if (j == 0) {
                  td.className = "ihcp-listview-firstcol";
                } else if (j == (numCells-1)) {
                  td.className = "ihcp-listview-lastcol";
                }
              }
            }
            if (img !== null) {
              td.insertBefore(img, td.firstChild);
              img = null;
            }
            tr.appendChild(td);
          }
          tbody.appendChild(tr);
        }
        root.adjustTableWidth();
        root.sortRows();
      },
      sortRows: function() {
        var root = this,
            config = root.config,
            table = ihmi.cf.firstElementNode(root),
            thead = ihmi.cf.firstElementNode(table),
            tbody = ihmi.cf.nextElementNode(thead),
            firstRow = ihmi.cf.firstElementNode(tbody),
            arrayRows, html, tr, innerBody;
        if (firstRow === null) return;

        function getKey(cell) {
          var key = cell.getAttribute('data-value');
          if (!key) key = ihmi.cf.getText(cell);
          return key;
        }

        if (ihmi.cf.hasClass(firstRow, 'ihcp-listview-category')) {
          html = [];
          tr = firstRow;
          while (tr !== null) {
            arrayRows = [];
            html.push(tr.outerHTML);
            for (tr = ihmi.cf.nextElementNode(tr); tr !== null && !ihmi.cf.hasClass(tr, 'ihcp-listview-category'); tr = ihmi.cf.nextElementNode(tr)) {
              arrayRows.push({ key: getKey(tr.children[config.sortKey]), node: tr.outerHTML });
            }
            html.push(root.sortArrayRows(arrayRows, config.sortType));
          }
          innerBody = html.join('');
        } else {
          arrayRows = [];
          for (tr = firstRow; tr !== null; tr = ihmi.cf.nextElementNode(tr)) {
            arrayRows.push({
              key: getKey(tr.children[config.sortKey]),
              node: tr.outerHTML
            });
          }
          innerBody = root.sortArrayRows(arrayRows, config.sortType);
        }
        root.refreshTable(null, innerBody);
      },
      refreshTable: function(innerHead, innerBody) {
        var root = this,
            oldHTML = root.innerHTML,
            newHTML = oldHTML;

        if (innerHead !== null) {
          newHTML = newHTML.replace(/(<thead[^>]*>)[^\0]*?(<\/thead>)/i, '$1' + innerHead + '$2');
        }

        if (innerBody !== null) {
          newHTML = newHTML.replace(/(<tbody[^>]*>)[^\0]*?(<\/tbody>)/i, '$1' + innerBody + '$2');
        }

        if (oldHTML !== newHTML) {
          newHTML = newHTML.replace(/style="top: *\d+px"/ig, ''); // style top is automatically added to tr and th tag because of css expression.
          root.innerHTML = newHTML;
        }
      },
      sortArrayRows: function(arrayRows, sortType) {
        function sortAsc(a, b) {
          var keyA = a.key,
              keyB = b.key,
              diff;
          if (keyA === keyB) return 0;

          diff = keyA - keyB;
          if (!isNaN(diff)) return diff;

          return (keyA < keyB) ? -1 : 1;
        }

        function sortDesc(a, b) {
          return -1 * sortAsc(a, b);
        }

        var arrayHTML = [],
            i, len, key, funcSort, row;

        funcSort = sortType === "desc" ? sortDesc : sortAsc;

        for (i = 0, len = arrayRows.length; i < len; i++) {
          row = arrayRows[i];
          key = row.key;
          if ((/^[-+]?\d*,\d+$/).test(key)) row.key = key.replace(/,/, ".");
        }

        arrayRows.sort(funcSort);

        for (i = 0, len = arrayRows.length; i < len; i++) {
          arrayHTML.push(arrayRows[i].node);
        }

        return arrayHTML.join('');
      },
      scrollTo: function(row, col) {
        //this function scrollTo() is to place target elem at the first col or row.
        //on the other hand, ihmi.cf.scrollTo() is to place target elem at visible area.
        var root = this,
            firstElementNode = ihmi.cf.firstElementNode,
            nextElementNode = ihmi.cf.nextElementNode,
            lastElementNode = ihmi.cf.lastElementNode,
            container = root,
            table = firstElementNode(root),
            thead = firstElementNode(table),
            tbody = nextElementNode(thead),
            offsetCol = 0,
            lastRowTr, isFind;
        if (thead.offsetHeight <= 0) {
          return;//if display:none, return;
        }
        if (row != null) {
          row = parseInt(row, 10);
          isFind = false;
          for (var tr = firstElementNode(tbody), rowCount = 1; tr !== null; tr = nextElementNode(tr), rowCount++) {
            if (row === rowCount) {
              isFind = true;
              break;
            }
          }
          if (isFind) {
            container.scrollTop = tr.offsetTop - thead.offsetHeight;
          }
        }
        if (col != null) {
          col = parseInt(col, 10);
          lastRowTr = lastElementNode(thead);
          isFind = false;
          for (var th = firstElementNode(lastRowTr), colCount = 1; th !== null; th = nextElementNode(th), colCount++) {
            if (root.config.fixcol && (colCount === 1)) {
              //get first header width for sticky
              offsetCol = th.offsetWidth;
            }
            if (col === colCount) {
              isFind = true;
              break;
            }
          }
          if (isFind) {
            container.scrollLeft = th.offsetLeft - offsetCol;
          }
        }
      },
      scrollToSelected: function() {
        var root = this,
            config = root.config,
            container = root,
            table = ihmi.cf.firstElementNode(root),
            thead = ihmi.cf.firstElementNode(table),
            tbody = ihmi.cf.nextElementNode(thead),
            selected = ihmi.cf.findDescendant(tbody, 'tr', 'ihcp-listview-selected');
        if (config.focus) {
          root.tabIndex = (ihmi.cf.firstElementNode(tbody) === null) ? -1 : 0; // enable tab stop if selected element exists
        }
        if (selected === null) return;
        ihmi.cf.scrollTo(container, selected, thead.offsetHeight);
      },
      scrollToFocused: function() {
        var root = this;
        var config = root.config;
        var container = root;
        var table = ihmi.cf.firstElementNode(root);
        var thead = ihmi.cf.firstElementNode(table);
        var tbody = ihmi.cf.nextElementNode(thead);
        var focused = ihmi.cf.findDescendant(tbody, 'tr', 'ihcp-listview-focused');

        if (config.focus) {
          root.tabIndex = (ihmi.cf.firstElementNode(tbody) === null) ? -1 : 0; // enable tab stop if selected element exists
        }
        if (focused === null) return;
        ihmi.cf.scrollTo(container, focused, thead.offsetHeight);
      },
      getSelectedValue: function() {
        var root = this,
            table = ihmi.cf.firstElementNode(root),
            thead = ihmi.cf.firstElementNode(table),
            tbody = ihmi.cf.nextElementNode(thead),
            selected = ihmi.cf.findDescendant(tbody, 'tr', 'ihcp-listview-selected'),
            value;
        if (selected === null) return "";
        value = selected.getAttribute('data-value');
        if (value === null || value === '') value = ihmi.cf.getText(ihmi.cf.firstElementNode(selected));
        return value;
      },
      selectRow: function(row, timeout) {
        var root = this,
            frame = ihmi.cf.getDefaultView(root.ownerDocument),
            config = root.config,
            tbody = row.parentNode,
            value;

        ihmi.cf.addClassExclusively(tbody, row, 'ihcp-listview-selected');
        root.scrollToSelected();

        if (config.timeoutId !== null) {
          frame.clearTimeout(config.timeoutId);
        }
        value = row.getAttribute('data-value');
        if (value === null || value === '') value = ihmi.cf.getText(ihmi.cf.firstElementNode(row));

        config.timeoutId = frame.setTimeout(function() {
          if (ihmi.cf.isFrameExist(frame)) { // Check whether the frame still exists.
            if (typeof config.callback === 'function') {
              config.callback(root.id, "clicked", value);
            } else {
              IUIFRequest_(frame, {
                request: root.id + ".clicked",
                value: value
              }).send();
            }
          } else {
            if (config.handleKeys !== null) {
              ihmi.cf.KeyEvent.removeHandler(config.handleKeys);
              config.handleKeys = null;
            }
          }
          config.timeoutId = null;
        }, timeout);
      },
      ondblclick: function(event) { // for PC
        var target = event.srcElement,
            root = ihmi.cf.findAncestor(target, 'div', 'ihcp-listview'),
            table = ihmi.cf.firstElementNode(root),
            frame, tr, tbody, value;

        if (table.disabled) {
          return;
        }

        if (target.tagName === 'IMG') {
          target = target.parentNode;
        }
        if (target.tagName === 'TD') {
          tr = target.parentNode;
          tbody = tr.parentNode;
          root = ihmi.cf.findAncestor(tbody, 'div', 'ihcp-listview');
          frame = ihmi.cf.getDefaultView(root.ownerDocument);
          value = tr.getAttribute('data-value');
          if (value === null || value === '') value = ihmi.cf.getText(ihmi.cf.firstElementNode(tr));
          if (typeof root.config.callback === 'function') {
            root.config.callback(root.id, "dblclicked", value);
          } else {
            ihmi.cf.IUIFRequest(frame, { request: root.id + ".dblclicked", value: value }).send();
          }
          return false;
        }
        return true;
      },
      onclick: function(event) {
        var target = event.srcElement,
            root = ihmi.cf.findAncestor(target, 'div', 'ihcp-listview'),
            table = ihmi.cf.firstElementNode(root),
            config = root.config,
            tr, sortType, sortKey, thead, lastTheadTr;

        if (table.disabled) {
          return;
        }

        switch (target.tagName) {
        case 'TH':
          thead = ihmi.cf.firstElementNode(table);
          lastTheadTr = ihmi.cf.lastElementNode(thead);
          tr = target.parentNode;
          if (lastTheadTr !== tr) {
            return; //except last row
          }
          sortType = ihmi.cf.hasClass(target, "ihcp-listview-sort-asc") ? "desc" : "asc";
          sortKey = target.cellIndex;

          ihmi.cf.removeClass(tr.children[config.sortKey], "ihcp-listview-sort-" + config.sortType);
          ihmi.cf.addClass(target, "ihcp-listview-sort-" + sortType);

          config.sortKey = sortKey;
          config.sortType = sortType;

          root.sortRows();
          root.scrollToSelected();
          return false;

        case 'IMG':
        case 'TD':
          if (target.tagName === 'IMG') {
            target = target.parentNode;
          }
          tr = target.parentNode;
          if (ihmi.cf.hasClass(tr, 'ihcp-listview-category')) return false;
          root.selectRow(tr, 0);
          ihmi.cf.addClassExclusively(root, tr, 'ihcp-listview-focused');
          // don't use focus() method, because listivew is scrolled to top from the side effect of the method.
          try {
            root.setActive();
          } catch (e) {}  // eslint-disable-line no-empty
          return false;
        default:
          return true;
        }
      },
      addKeyHandler: function(handler) {
        var root = this,
            keyHandlers = root.config.keyHandlers;
        keyHandlers.push(handler);
      },
      handleKeys: function(event, focus) {
        var root = this,
            config = root.config,
            keyHandlers = root.config.keyHandlers,
            dist = 0,
            TOP_NUM = 1,
            direction,
            table = ihmi.cf.firstElementNode(root),
            thead = ihmi.cf.firstElementNode(table),
            tbody = ihmi.cf.nextElementNode(thead),
            getNextNode = ihmi.cf.getNextNode,
            currSelected, currFocused, nextTr, notHandled, firstTr, lastTr;

        if (table.disabled) {
          return;
        }

        currSelected = ihmi.cf.findDescendant(tbody, 'tr', 'ihcp-listview-selected');
        currFocused = ihmi.cf.findDescendant(tbody, 'tr', 'ihcp-listview-focused');

        switch (event.keyCode) {
        case 13: /* Enter */
          if (currSelected === null && currFocused === null && ihmi.cf.firstElementNode(tbody) !== null) {
            firstTr = ihmi.cf.firstElementNode(tbody);
            if (ihmi.cf.hasClass(firstTr, "ihcp-listview-category")) {
              firstTr = ihmi.cf.nextElementNode(firstTr);
            }
            root.selectRow(firstTr, 0);
            ihmi.cf.addClass(firstTr, 'ihcp-listview-focused');
          } else if (config.movetype === 'focus' && currFocused !== null) {
            root.selectRow(currFocused, 300);
          }
          break;
        case 36: /* Home */
          if (config.movetype === 'select') {
            if (currSelected === ihmi.cf.firstElementNode(tbody)) return true;
          } else if (config.movetype === 'focus') {
            if (currFocused === ihmi.cf.firstElementNode(tbody)) return true;
          }
          dist = -tbody.childNodes.length;
          break;
        case 35: /* End */
          if (config.movetype === 'select') {
            if (currSelected === tbody.lastChild) return true;
          } else if (config.movetype === 'focus') {
            if (currFocused === tbody.lastChild) return true;
          }
          dist = tbody.childNodes.length;
          break;
        default:
          dist = ihmi.cf.keyEventToDistance(event);
          break;
        }

        if (dist === 0) {
          for (var i = 0, len = keyHandlers.length; i < len; i++) {
            notHandled = keyHandlers[i](event);
            if (!notHandled) return false;
          }
          return true;
        }

        if (currSelected === null || currFocused === null) return true;

        // if current selected or focused row are last one, move focus to another element.
        if (focus && event.keyCode === 9) {
          firstTr = ihmi.cf.firstElementNode(tbody);
          if (ihmi.cf.hasClass(firstTr, "ihcp-listview-category")) {
            firstTr = ihmi.cf.nextElementNode(firstTr);
          }
          lastTr = ihmi.cf.lastElementNode(tbody);
          if (ihmi.cf.hasClass(lastTr, "ihcp-listview-category")) {
            lastTr = ihmi.cf.prevElementNode(lastTr);
          }

          if (config.movetype === 'select') {
            if ((dist > 0 && currSelected === lastTr) || (dist < 0 && currSelected === firstTr)) {
              return true;
            }
          } else if (config.movetype === 'focus') {
            if ((dist > 0 && currFocused === lastTr) || (dist < 0 && currFocused === firstTr)) {
              return true;
            }
          }
        }

        if (config.movetype === 'select') {
          nextTr = getNextNode(tbody, currSelected, dist);
        } else if (config.movetype === 'focus') {
          nextTr = getNextNode(tbody, currFocused, dist);
        }

        if ((event.keyCode === 36) && (ihmi.cf.hasClass(nextTr, "ihcp-listview-category"))) {
          if (config.movetype === 'select') {
            nextTr = getNextNode(tbody, nextTr, TOP_NUM);
          } else if (config.movetype === 'focus') {
            nextTr = getNextNode(tbody, nextTr, TOP_NUM);
          }
        }

        direction = dist / Math.abs(dist);
        while (ihmi.cf.hasClass(nextTr, "ihcp-listview-category")) {
          nextTr = getNextNode(tbody, nextTr, direction);
          if (config.movetype === 'select') {
            if (nextTr === currSelected) return true;
          } else if (config.movetype === 'focus') {
            if (nextTr === currFocused) return true;
          }
        }
        if (nextTr !== null) {
          ihmi.cf.addClassExclusively(tbody, nextTr, 'ihcp-listview-focused');
          if (config.movetype === 'select') {
            root.selectRow(nextTr, 300);
          } else if (config.movetype === 'focus') {
            root.scrollToFocused();
          }
        }
        return false;
      },
      onfocus: function(event) {
        var root = event.srcElement,
            frame = ihmi.cf.getDefaultView(root.ownerDocument),
            config = root.config,
            curSelected = ihmi.cf.findDescendant(root, 'TR', 'ihcp-listview-selected');

        if (config.handleKeys !== null) return true;

        if (curSelected !== null) {
          ihmi.cf.addClass(curSelected, 'ihcp-listview-focused');
        }
        config.handleKeys = function(event) {
          return root.handleKeys(event, true);
        };
        ihmi.cf.KeyEvent.addHandler(config.handleKeys, frame, false);
        root.scrollToSelected();

        return false;
      },
      onblur: function(event) {
        var root = event.srcElement,
            config = root.config,
            curFocused = ihmi.cf.findDescendant(root, 'TR', 'ihcp-listview-focused');

        if (config.handleKeys === null) return true;
        if (curFocused !== null) {
          ihmi.cf.removeClass(curFocused, 'ihcp-listview-focused');
        }
        ihmi.cf.KeyEvent.removeHandler(config.handleKeys);
        config.handleKeys = null;

        return false;
      },
      adjustTableWidth: function() {
        var root = this;
        var table;
        var scrollElem;
        var scrollWidth;
        var TOLERANCE = 2; //smaller than 2px, the x scroll bar will appear in old tp.
        var SCROLLBAR_WIDTH = 17;
        //To prevent the horizontal scroll bar from appearing due to the vertical scroll bar appearing in IE7.
        if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
          setTimeout(function() {
            table = ihmi.cf.firstElementNode(root);
            scrollElem = root;
            if (table === null) return;
            scrollWidth = scrollElem.clientWidth;
            if (scrollWidth > 0) {
              if (ihmi.cf.isiPendant()) {//if y scroll bar exist, Reduce the width of the scroll bar in old tp.
                if (scrollElem.scrollHeight > scrollElem.offsetHeight) {//if y scroll
                  scrollWidth = scrollElem.offsetWidth;
                  scrollWidth -= (SCROLLBAR_WIDTH + TOLERANCE);
                }
              }
              table.style.width = scrollWidth + "px";
            }
          }, 0);
        }
      },
      stickyAlt: function(event) {
        var target = event.srcElement;
        var root = target;
        var firstElementNode = ihmi.cf.firstElementNode;
        var table = firstElementNode(root);
        var thead = firstElementNode(table);
        var value = target.scrollTop;
        var tbody;
        var firstTd;
        var tr;
        for (tr = firstElementNode(thead); tr !== null; tr = ihmi.cf.nextElementNode(tr)) {
          for (var th = firstElementNode(tr); th !== null; th = ihmi.cf.nextElementNode(th)) {
            if (root.config.fixcol && (th === firstElementNode(tr))) {
              th.style.left = target.scrollLeft + 'px';
              th.style.position = 'relative';
            }
            th.style.top = value + 'px';
            th.style.position = 'relative';
          }
        }
        if (root.config.fixcol) {
          tbody = ihmi.cf.nextElementNode(thead);
          for (tr = firstElementNode(tbody); tr !== null; tr = ihmi.cf.nextElementNode(tr)) {
            firstTd = firstElementNode(tr);
            firstTd.style.left = target.scrollLeft + 'px';
            firstTd.style.position = 'relative';
          }
        }
        return false;
      },
      setCallback: function(callback) {
        var root = this;
        root.config.callback = callback;
      }
    },
    tab: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            type = this,
            addEventHandler = ihmi.cf.addEventHandler;
        elem.config = config;
        elem.select = type.select;
        elem.setCallback = type.setCallback;

        if (config.blank === "true") {
          ihmi.cf.addClass(elem, "tab-blank");
          elem.innerText = "";
          addEventHandler(frame, "load", function(){
            elem.removeAttribute("tabIndex");
          });
        } else {
          addEventHandler(elem, "click", type.onclick);
          addEventHandler(elem, "keypress", type.onkeypress);
        }
        if (!(ihmi.global.isModernBrowser)) {
          addEventHandler(elem, "focus", type.onfocus);
          addEventHandler(elem, "blur", type.onblur);
        }
      },
      select: function() {
        var elem = this,
            doc = elem.ownerDocument,
            root = ihmi.cf.findAncestor(elem, 'div', 'tabbar'),
            value = elem.config.value,
            page, style;
        page = doc.getElementById(value);
        if (page !== null && !ihmi.cf.hasClass(page, 'tab-page-selected')) {
          style = page.style;
          style.display = 'block'; // Without this line, tab page is not displayed properly on IE9.
          ihmi.cf.addClassExclusively(page.parentNode, page, 'tab-page-selected');
          style.display = '';
        }
        ihmi.cf.addClassExclusively(root, elem, 'tab-selected');
      },
      onclick: function(event) {
        var elem = event.srcElement,
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            config;
        if (elem.tagName === "INS" || elem.tagName === "IMG" || elem.tagName === "SPAN") {
          elem = elem.parentNode;
        }
        if (elem.disabled) {
          return false;
        }
        config = elem.config;
        if (elem.tagName === "LI") {
          elem.select();
          if (typeof config.callback === 'function') {
            setTimeout(function() {
              config.callback(elem.id, "clicked", elem.config.value);
            }, 50);
          } else {
            setTimeout(function() {
              IUIFRequest_(frame, {
                request: elem.id + ".clicked",
                value: elem.config.value
              }).send();
            }, 50);
          }
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        if (event.keyCode === 13) { // enter
          elem.click();
        }
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if ((elem.tagName === 'INS') || (elem.tagName === 'SPAN') || (elem.tagName === 'IMG')) {
          elem = elem.parentNode;
        }
        ihmi.cf.addClass(elem, "focus");
        return false;
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if ((elem.tagName === 'INS') || (elem.tagName === 'SPAN') || (elem.tagName === 'IMG')) {
          elem = elem.parentNode;
        }
        ihmi.cf.removeClass(elem, "focus");
        return false;
      }
    },
    tabbar: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id),
            frame = ihmi.cf.getDefaultView(doc),
            type = this;
        root.refresh = type.refresh;
        root.equalizeTabs = type.equalizeTabs;
        root.findViewTabs = type.findViewTabs;
        root.findTopTabs = type.findTopTabs;
        root.adjustBorder = type.adjustBorder;
        root.config = config;

        ihmi.cf.determineDefaultDesignPattern(root);
        ihmi.cf.addEventHandler(frame, "load", function(){
          root.adjustBorder();
          root.equalizeTabs();
        });

        ihmi.cf.addEventHandler(frame, "resize", function(event) {
          root.equalizeTabs();
        });
      },
      refresh: function(value, disabled) {
        var root = this,
            tabs = ihmi.cf.findDescendants(root, "li", "tab"),
            buttons = ihmi.cf.findDescendants(root, "li", "tab-arrow"),
            selected;
        for (var i = 0, len = tabs.length; i < len; i++) {
          tabs[i].disabled = disabled;
          if (tabs[i].config.value === value) {
            selected = tabs[i];
          }
          if (disabled) {
            tabs[i].removeAttribute("tabIndex");
          } else if (!disabled) {
            tabs[i].setAttribute("tabIndex", 0);
          }
        }
        for (var h = 0; h < buttons.length; h++) {
          if ((buttons.length === 2) && (disabled === false)) {
            buttons[0].disabledBtn();
          } else {
            buttons[h].disabled = disabled;
            ihmi.cf.turnOnOffClass(buttons[h], "disabled", disabled);
            if (disabled) {
              buttons[h].removeAttribute("tabIndex");
            } else if (!disabled) {
              buttons[h].setAttribute("tabIndex", 0);
            }
          }
        }
        if ((selected !== undefined) && (!ihmi.cf.hasClass(selected, "tab-blank"))) {
          selected.select();
        }
      },
      equalizeTabs: function() {
        var root = this;
        var tabs = ihmi.cf.findDescendants(root, "LI", "tab");
        var viewTabs = root.findViewTabs();
        var buttons = ihmi.cf.findDescendants(root, "LI", "tab-arrow");
        var topTabs = root.findTopTabs();
        var MAX_TABS = 5;
        var BORDER_WIDTH = 2;
        var BUTTON_MARGIN = 0;
        var ONE_BTN_WIDTH_TOUCH = 58;
        var TWO_BTN_WIDTH_TOUCH = 114;
        var ONE_BTN_WIDTH_MOUSE = 40;
        var TWO_BTN_WIDTH_MOUSE = 78;
        var margin = 1; //prevent fall column
        var frameWidth;
        var tabWidth;
        var groupWidth;
        var borderMargin;
        var style;
        var padding;
        var difference;

        if ((viewTabs === null) || (viewTabs.length > MAX_TABS)) {
          return;
        }
        switch (buttons.length) {
          case 1:
            if (ihmi.cf.hasClass(root, 'touch')) {
              BUTTON_MARGIN = ONE_BTN_WIDTH_TOUCH;
            } else {
              BUTTON_MARGIN = ONE_BTN_WIDTH_MOUSE;
            }
            break;
          case 2:
            if (ihmi.cf.hasClass(root, 'touch')) {
              BUTTON_MARGIN = TWO_BTN_WIDTH_TOUCH;
            } else {
              BUTTON_MARGIN = TWO_BTN_WIDTH_MOUSE;
            }
            break;
          default:
            break;
        }
        frameWidth = root.parentNode.scrollWidth - margin;
        if (frameWidth <= 0) {
          frameWidth = root.ownerDocument.documentElement.scrollWidth;
        }

        borderMargin = BORDER_WIDTH * viewTabs.length;

        style = ihmi.cf.getCurrentStyle(tabs[0]);
        if (style === null) {
          return;
        }
        padding = (parseInt(style.paddingLeft, 10) + parseInt(style.paddingRight, 10)) * viewTabs.length;
        tabWidth = parseInt((frameWidth - borderMargin - BUTTON_MARGIN - padding) / viewTabs.length, 10);

        for (var i = 0; i < tabs.length; i++) {
          tabs[i].style.width = tabWidth + "px";
        }
        groupWidth = tabWidth * viewTabs.length + (borderMargin + BUTTON_MARGIN + padding);
        if (frameWidth > groupWidth) {
          difference = frameWidth - groupWidth;
          for (var h = 0; h < topTabs.length; h++) {
            topTabs[h].style.width = (tabWidth + difference) + "px";
          }
        }
      },
      findViewTabs: function() {
        var root = this;
        var groups = ihmi.cf.findDescendants(root, "ul", "tab-group");
        for (var i = 0; i < groups.length; i++) {
          if (!(ihmi.cf.hasClass(groups[i], "hide")) && (groups[i].tagName ==='UL')) {
            return groups[i].children;
          }
        }
        return null;
      },
      findTopTabs: function() {
        var root = this;
        var groups = ihmi.cf.findDescendants(root, "ul", "tab-group");
        var topTabs = [];
        for (var i = 0; i < groups.length; i++) {
          topTabs.push(ihmi.cf.firstElementNode(groups[i]));
        }
        return topTabs;
      },
      adjustBorder: function() {
        var root = this;
        var groups = ihmi.cf.findDescendants(root, "ul", "tab-group");
        var buttons = ihmi.cf.findDescendants(root, "LI", "tab-arrow");
        var firstTab;
        var lastTab;
        var firstBtn;
        var lastBtn;
        var addClass = ihmi.cf.addClass;

        for (var i = 0; i < groups.length; i++) {
          firstTab = ihmi.cf.firstElementNode(groups[i]);
          lastTab = ihmi.cf.lastElementNode(groups[i]);
          addClass(firstTab, "tab-first");
        }
        if (buttons.length < 1) {
          addClass(lastTab, "tab-last");
        } else {
          firstBtn = buttons[0];
          lastBtn = buttons[buttons.length - 1];
          addClass(firstBtn, "tab-arrow-frist");
          addClass(lastBtn, "tab-arrow-last");
        }
      }
    },
    tabPageChangeButton: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        var root = elem.parentNode;
        var buttons = ihmi.cf.findDescendants(root, "LI", "tab-arrow");
        var addClass = ihmi.cf.addClass;
        var addEventHandler = ihmi.cf.addEventHandler;
        elem.config = config;
        elem.switchArrow = type.switchArrow;
        elem.prevPageView = type.prevPageView;
        elem.nextPageView = type.nextPageView;
        elem.getGroups = type.getGroups;
        elem.getCurDisplay = type.getCurDisplay;
        elem.disabledBtn = type.disabledBtn;

        addEventHandler(elem, "click", type.onclick);
        addEventHandler(elem, "keypress", type.onkeypress);

        if (!(ihmi.global.isModernBrowser)) {
          addEventHandler(elem, "focus", type.onfocus);
          addEventHandler(elem, "blur", type.onblur);
        }

        if (buttons.length === 1) {
          addClass(ihmi.cf.firstElementNode(buttons[0]), "tab-arrow-next");
        } else {
          addClass(ihmi.cf.firstElementNode(buttons[0]), "tab-arrow-prev");
          addClass(ihmi.cf.firstElementNode(buttons[1]), "tab-arrow-next");
          elem.disabledBtn();
        }
      },
      switchArrow: function() {
        var elem = this;
        var firstElementNode = ihmi.cf.firstElementNode;

        if (ihmi.cf.hasClass(firstElementNode(elem), "tab-arrow-prev")) {
          ihmi.cf.removeClass(firstElementNode(elem), "tab-arrow-prev");
          ihmi.cf.addClass(firstElementNode(elem), "tab-arrow-next");
        } else if (ihmi.cf.hasClass(firstElementNode(elem), "tab-arrow-next")) {
          ihmi.cf.removeClass(firstElementNode(elem), "tab-arrow-next");
          ihmi.cf.addClass(firstElementNode(elem), "tab-arrow-prev");
        }
      },
      onclick: function(event) {
        var target = event.srcElement;
        var root;
        var buttons;
        var groups;
        var curDisplay;

        if (target.tagName === "INS") {
          target = target.parentNode;
        }
        if (target.disabled) {
          return false;
        }

        root = target.parentNode;
        buttons = ihmi.cf.findDescendants(root, "LI", "tab-arrow");
        groups = target.getGroups(root);
        curDisplay = target.getCurDisplay(groups);

        if (ihmi.cf.hasClass(ihmi.cf.firstElementNode(target), "tab-arrow-prev")) {
          target.prevPageView(groups, curDisplay);
        } else if (ihmi.cf.hasClass(ihmi.cf.firstElementNode(target), "tab-arrow-next")) {
          target.nextPageView(groups, curDisplay);
        }
        if (buttons.length === 1) {
          target.switchArrow();
        } else if (buttons.length === 2) {
          target.disabledBtn();
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        if (event.keyCode === 13) { // enter
          elem.click();
        }
      },
      nextPageView: function(groups, cur) {
        var nextPage;
        if (cur === null) {
          return;
        }
        nextPage = ihmi.cf.nextElementNode(cur);
        if (ihmi.cf.hasClass(nextPage, "tab-arrow")) {
          nextPage = groups[0];
        }
        ihmi.cf.addClass(cur, "hide");
        ihmi.cf.removeClass(nextPage, "hide");
      },
      prevPageView: function(groups, cur) {
        var prevPage;

        if (cur === null) {
          return;
        }
        prevPage = ihmi.cf.prevElementNode(cur);
        if (prevPage === null) {
          prevPage = groups[groups.length - 1];
        }
        ihmi.cf.addClass(cur, "hide");
        ihmi.cf.removeClass(prevPage, "hide");
      },
      getGroups: function(root) {
        var groups = [];
        for (var i = 0; i < root.children.length; i++) {
          if ((root.children[i].tagName === 'UL') && (ihmi.cf.hasClass(root.children[i], "tab-group"))) {
            groups.push(root.children[i]);
          }
        }
        return groups;
      },
      getCurDisplay: function(groups) {
        for (var i = 0; i < groups.length; i++) {
          if (!ihmi.cf.hasClass(groups[i], "hide")) {
            return groups[i];
          }
        }
        return null;
      },
      disabledBtn: function() {
        var elem = this;
        var root = elem.parentNode;
        var buttons = ihmi.cf.findDescendants(root, "LI", "tab-arrow");
        var groups = elem.getGroups(root);
        var curDisplay = elem.getCurDisplay(groups);

        if (curDisplay === groups[0]) {
          buttons[0].disabled = true;
          buttons[1].disabled = false;
          buttons[0].removeAttribute("tabIndex");
          ihmi.cf.addClassExclusively(root, buttons[0], "disabled");

          if (ihmi.cf.hasClass(buttons[0], 'focus')) {
            ihmi.cf.removeClass(buttons[0], 'focus');
          }
        } else if (curDisplay === groups[groups.length - 1]) {
          buttons[0].disabled = false;
          buttons[1].disabled = true;
          buttons[1].removeAttribute("tabIndex");
          ihmi.cf.addClassExclusively(root, buttons[1], "disabled");

          if (ihmi.cf.hasClass(buttons[1], 'focus')) {
            ihmi.cf.removeClass(buttons[1], 'focus');
          }
        } else {
          buttons[0].disabled = false;
          buttons[1].disabled = false;
          ihmi.cf.removeClassExclusively(root, "LI", "disabled");
          buttons[0].setAttribute("tabIndex", 0);
          buttons[1].setAttribute("tabIndex", 0);
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if (elem.tagName === 'INS') {
          elem = elem.parentNode;
        }
        if (elem.disabled) {
          elem.blur();
        }
        ihmi.cf.addClass(elem, "focus");
        return false;
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if (elem.tagName === 'INS') {
          elem = elem.parentNode;
        }
        ihmi.cf.removeClass(elem, "focus");
        return false;
      }
    },
    tabItem: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.config = config;
        elem.select = type.select;
        elem.getBorderPadding = type.getBorderPadding;

        addEventHandler_(elem, "click", type.onclick);
        addEventHandler_(elem, "keypress", type.onkeypress);
        addEventHandler_(elem, "focus", type.onfocus);
        addEventHandler_(elem, "blur", type.onblur);
      },
      select: function() {
        var elem = this,
            doc = elem.ownerDocument,
            root = findAncestor_(elem, 'div', 'ihcp-tabs'),
            value = elem.config.value,
            page, style;
        page = doc.getElementById(value);
        if (page !== null && !hasClass_(page, 'ihcp-tab-page-selected')) {
          style = page.style;
          style.display = 'block'; // Without this line, tab page is not displayed properly on IE9.
          addClassExclusively_(page.parentNode, page, 'ihcp-tab-page-selected');
          style.display = '';
        }
        addClassExclusively_(root, elem, 'ihcp-tab-selected');
        root.config.selectedValue = value;
      },
      onclick: function(event) {
        var elem = event.srcElement,
            frame = getDefaultView_(elem.ownerDocument),
            root = findAncestor_(elem, 'div', 'ihcp-tabs'),
            config;
        var tabConfig = root.config;
        elem = findAncestor_(elem, "li", "ihcp-tab-item");
        if (elem.disabled) {
          return false;
        }
        /** tabConfig.isMouseMoving -> true in mousemove */
        if (tabConfig.isMouseMoving) {
          tabConfig.isMouseMoving = false;
          return false;
        }
        config = elem.config;
        if (elem.tagName === "LI") {
          if (hasClass_(elem, "ihcp-tab-selected")){
            return;
          }
          elem.select();
          if (typeof tabConfig.callback === 'function') {
            setTimeout(function() {
              tabConfig.callback(elem.id, "clicked", config.value);
            }, 50);
          } else {
            setTimeout(function() {
              IUIFRequest_(frame, { request: elem.id + ".clicked", value: config.value }).send();
            }, 50);
          }
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        if (event.keyCode === 13) { // enter
          elem.click();
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        var tabs = findAncestor_(elem, 'div', 'ihcp-tabs');
        var config = tabs.config;
        var viewAllTabs = tabs.findViewAllTabs();
        var tabScrollArea = findDescendant_(tabs, 'div', 'ihcp-tabs-scroll-area');

        if ((elem.tagName === 'INS') || (elem.tagName === 'SPAN') || (elem.tagName === 'IMG')) {
          elem = elem.parentNode;
        }
        if (!(ihmi.global.isModernBrowser)) {
          addClass_(elem, "focus");
        }
        if (elem.id === viewAllTabs[0].id) {
          focusOnFirstTab();
        }
        /**
         * Scrolling does not occur
         *  when the left side of the screen is focused with the tab key.
         */
        function focusOnFirstTab() {
          if (0 < config.curLeftIdx) {
            tabScrollArea.scrollLeft = 0;
          }
        }
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if ((elem.tagName === 'INS') || (elem.tagName === 'SPAN') || (elem.tagName === 'IMG')) {
          elem = elem.parentNode;
        }
        if (!(ihmi.global.isModernBrowser)) {
          ihmi.cf.removeClass(elem, "focus");
        }
      },
      getBorderPadding: function() {
        var tabItem = this;
        var tabItemStyle = getCurrentStyle_(tabItem);

        var TAB_BORDER = parseFloat(tabItemStyle.borderLeftWidth);
        var TAB_PADDING = parseFloat(tabItemStyle.paddingLeft);

        return ((TAB_BORDER + TAB_PADDING) * 2);
      }
    },
    tabs: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id),
            frame = getDefaultView_(doc),
            type = this,
            arrowTabs = findDescendants_(root, "div", "ihcp-tab-arrow");
        root.config = config;
        config.showNumPerPage = 5;    // use showNumPerPage when limit tab num.
        config.myElem = root;     // add for use element informations.
        config.width;             // for anscestor is display:none.
        config.selectedValue;
        config.isTabScroll = false;
        config.curLeftIdx = 0;    // current left index in showing tab
        config.maxLeftIdx = 0;    // set in showHideTabs
        config.shrink = ((getIEVersion_(userAgent) > 10) ||
                         (getIEVersion_(userAgent) === -1))
                          ? parseStrToBoolean_(config.shrink)
                          : false;
        config.isMouseMoving = false;
        config.overWidth = 0;  // set in equalizeTabs
        config.scrollLeft = 0;  // for distinguish flip and scroll
        config.MOUSE_UP_LIMIT = 400;    /** To distinguish between mousemove and mouseup */
        config.scrollTimeoutId = null;
        config.EDGE_THRESHOLD = 0.05;

        root.refresh = type.refresh;
        root.equalizeTabs = type.equalizeTabs;
        root.findViewTabs = type.findViewTabs;
        root.findViewAllTabs = type.findViewAllTabs;
        root.prevPageView = type.prevPageView;
        root.nextPageView = type.nextPageView;
        root.disabledBtn = type.disabledBtn;
        root.showHideTabs = type.showHideTabs;
        root.setCallback = type.setCallback;
        root.onMoveStart = type.onMoveStart;
        root.slideTabs = type.slideTabs;
        root.setLeftTabIdx = type.setLeftTabIdx;

        // windows tablet is same behavior with tablet.
        var isTouchable = ihmi.global.touchable;
        var MOUSE_EVENT = 'mousedown';
        var TOUCH_EVENT = 'touchstart';
        var CLICK_EVENT = ihmi.global.isiPad ? "touchend" : "click";
        var tabScrollArea = doc.getElementById(id + '.scrollArea');
        judgeAddTabletClass_(root);

        if (!isTouchable) {
          tabScrollArea.style.overflow = 'hidden';
        }
        if (config.shrink) {
          addClass_(root, 'ihcp-tabs-shrink');
        }
        for (var i = 0; i < arrowTabs.length; i++) {
          addEventHandler_(arrowTabs[i], "keypress", type.onkeypress);
          addEventHandler_(arrowTabs[i], CLICK_EVENT, type.onclick);
          if (!(ihmi.global.isModernBrowser)) {
            addEventHandler_(arrowTabs[i], "focus", type.onfocus);
            addEventHandler_(arrowTabs[i], "blur", type.onblur);
          }
        }
        addEventHandler_(tabScrollArea, 'scroll', function() {
          clearTimeout(config.scrollTimeoutId);
          config.scrollTimeoutId = setTimeout(tabScroll, 100);
        });
        addEventHandler_(frame, "load", function(){
          var tabItems = findDescendants_(root, "li", "ihcp-tab-item");
          var visibleAllItems = root.findViewAllTabs();
          var zoomFactor = getZoomFactor_(root);
          var isTabOver = false;

          /** For when there is no child element of tabs */
          if (tabItems.length === 0) {
            return;
          }
          if (visibleAllItems.length < config.showNumPerPage) {
            config.showNumPerPage = visibleAllItems.length;
          }
          isTabOver = (config.showNumPerPage < visibleAllItems.length);
          config.isTabScroll = ((zoomFactor === 1) && isTabOver);
          if (config.isTabScroll) {
            removeEventHandler_(tabScrollArea, MOUSE_EVENT, root.onMoveStart);
            removeEventHandler_(tabScrollArea, TOUCH_EVENT, root.onMoveStart);
            addEventHandler_(tabScrollArea, MOUSE_EVENT, root.onMoveStart);
            addEventHandler_(tabScrollArea, TOUCH_EVENT, root.onMoveStart);
          }
          // tab not select
          if (findDescendants_(root, "LI", "ihcp-tab-selected").length !== 1){
            tabItems[0].select();
          }
          root.showHideTabs(config.curLeftIdx);
        });
        addEventHandler_(frame, "resize", debounce_(function() {
          root.showHideTabs(config.curLeftIdx);
        }, 200));
        function tabScroll() {
          if (root.disabled) {
            return;
          }
          /** Switching tab status while moving. */
          root.disabledBtn();
          if (config.isMouseMoving) {
            config.isMouseMoving = false;
            return;
          }
          if (config.overWidth < tabScrollArea.scrollLeft) {
            tabScrollArea.scrollLeft = config.overWidth;
          }
          root.setLeftTabIdx();
        }
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      refresh: function(startValue, numOfTabsPerPage, selectedValue, disabled, argObj) {
        var root = this,
            config = root.config,
            tabItems = findDescendants_(root, "li", "ihcp-tab-item"),
            selectTab,
            isOneTab = false,
            tempTabVal;
        var visibleAllItems = root.findViewAllTabs();
        var zoomFactor = getZoomFactor_(root);
        var isSetNumOfPerPage = ((typeof numOfTabsPerPage === 'number') &&
                                  (numOfTabsPerPage !== 0));
        var doc = root.ownerDocument;
        var tabScrollArea = doc.getElementById(root.id + '.scrollArea');
        var MOUSE_EVENT = 'mousedown';
        var TOUCH_EVENT = 'touchstart';
        var isTabShow = false;
        var hideIdx = 0;
        var isTabOver = false;

        /** For when there is no child element of tabs */
        if (tabItems.length === 0) {
          return;
        }
        if ((argObj != undefined) &&
            (argObj.width != undefined)) {
          config.width = argObj.width;
        }
        if (startValue == null) {  // startValue is not set
          startValue = ((visibleAllItems.length === 0)
                          ? tabItems[0].config.value  // all tab hide
                          : visibleAllItems[config.curLeftIdx].config.value);
        }
        selectedValue = (selectedValue == null) ?
                          (config.selectedValue == undefined)
                            ? tabItems[0].config.value  // component setting
                            : config.selectedValue  // re-refresh
                          : selectedValue;  // user setting
        if (isSetNumOfPerPage) {
          config.showNumPerPage = numOfTabsPerPage;
        }
        // Toggle enable/disable of the entire tab.
        if (disabled == null) {
          disabled = root.disabled;
        } else {
          root.disabled = disabled;
        }
        turnOnOffClass_(root, "disabled", disabled);
        for (var i = 0; i < tabItems.length; i++) {
          tempTabVal = tabItems[i].config.value;
          // use tabStartIndex in showHideTabs
          if (tempTabVal === startValue) {
            config.curLeftIdx = i - hideIdx;
          }
          // when select tab, select.
          if (tempTabVal === selectedValue) {
            selectTab = tabItems[i];
          }
          // Enable/disable settings per tab
          disablePerTab(disabled, argObj);
          // Show/Hide settings for each tab
          hidePerTab(argObj);
        }
        // when display tab is nothing, visibleAllItems is [](empty array).
        // So visibleAllItems[0].id is error.
        visibleAllItems = root.findViewAllTabs();
        /** When we hide everything with refresh */
        if (visibleAllItems.length === 0) {
          return;
        }
        if (visibleAllItems.length < config.showNumPerPage) {
          config.showNumPerPage = visibleAllItems.length;
        }
        isTabOver = (config.showNumPerPage < visibleAllItems.length);
        config.isTabScroll = ((zoomFactor === 1) && isTabOver);
        if (config.isTabScroll) {
          removeEventHandler_(tabScrollArea, MOUSE_EVENT, root.onMoveStart);
          removeEventHandler_(tabScrollArea, TOUCH_EVENT, root.onMoveStart);
          addEventHandler_(tabScrollArea, MOUSE_EVENT, root.onMoveStart);
          addEventHandler_(tabScrollArea, TOUCH_EVENT, root.onMoveStart);
        }
        /** When mouse down event is attached but mouse down event is not needed */
        if ((zoomFactor === 1) && !isTabOver) {
          removeEventHandler_(tabScrollArea, MOUSE_EVENT, root.onMoveStart);
        }
        /** used to switch arrow tab status(enable <-> disable) */
        root.showHideTabs(config.curLeftIdx);
        if (root.config.showNumPerPage === 1) {
          isOneTab = true;
        }
        turnOnOffClass_(root, "ihcp-tabs-one", isOneTab);

        if (selectTab !== undefined) {
          selectTab.select();
        }

        function hidePerTab(argObj) {
          // Do you want to specify hide for each tab?
          if ((argObj != undefined) && (argObj.showTabObj != null)) {
            isTabShow = argObj.showTabObj[tempTabVal];
            if (isTabShow !== undefined) {
              turnOnOffClasses_(tabItems[i], "ihcp-tab-hide", !isTabShow);
              if (!isTabShow) {
                hideIdx++;
              }
            }
          }
        }

        function disablePerTab(disabled, argObj) {
          // If you specify to disable the entire tab, specify all tabs to be disabled individually.
          if (disabled) {
            tabItems[i].disabled = true;
            // To avoid double invalidation for the whole tab and for each tab.
            turnOnOffClasses_(tabItems[i], "disabled", false);
            tabItems[i].removeAttribute("tabIndex");
            return;
          }
          // Do you specify invalidity on a per-tab basis?
          if ((argObj != undefined) && (argObj.disabledTabObj != null)) {
            // Gives the specified tab an invalid class.
            tabItems[i].disabled = argObj.disabledTabObj[tempTabVal];
            turnOnOffClasses_(tabItems[i], "disabled", tabItems[i].disabled);
            tabItems[i].disabled ? tabItems[i].removeAttribute("tabIndex") : tabItems[i].setAttribute("tabIndex", 0);
          } else {
            // Enable tabs.
            tabItems[i].disabled = false;
            turnOnOffClasses_(tabItems[i], "disabled", false);
            tabItems[i].setAttribute("tabIndex", 0);
          }
        }
      },
      /**
       * switch tab status with display and hide
       * @param {Integer} startIndex
       */
      showHideTabs: function(startIndex) {
        var root = this,
            config = root.config,
            arrowTabs = findDescendants_(root, "div", "ihcp-tab-arrow"),
            visibleAllItems = root.findViewAllTabs(),
            showPrevNextPageBtn;
        var ulElem = findDescendant_(root, 'ul', 'ihcp-tabs-frame');
        /** When resize occurs with no child elements */
        if (visibleAllItems.length === 0) {
          return;
        }
        removeClass_(ulElem, 'hide');
        config.maxLeftIdx = (visibleAllItems.length - config.showNumPerPage);

        startIndex = (startIndex < config.maxLeftIdx) ? startIndex
                                                      : config.maxLeftIdx;
        config.curLeftIdx = startIndex;
        showPrevNextPageBtn = (config.showNumPerPage < visibleAllItems.length);

        turnOnOffClasses_(arrowTabs[0], "hide", !showPrevNextPageBtn);
        turnOnOffClasses_(arrowTabs[1], "hide", !showPrevNextPageBtn);
        root.equalizeTabs();
        if (showPrevNextPageBtn) {
          root.disabledBtn();
        }
      },
      equalizeTabs: function() {
        var root = this;
        var config = root.config;
        var viewAllTabs = root.findViewAllTabs();     // set width property in modern browser.
        var ulElem = findDescendant_(root, 'ul', 'ihcp-tabs-frame');
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');
        var arrowTabs = findDescendants_(root, "div", "ihcp-tab-arrow");
        var arrowTabStyle = getCurrentStyle_(arrowTabs[0]);

        if (arrowTabStyle === null) {
          return;
        }
        var arrowTabWidth = parseFloat(arrowTabStyle.width);    // legacy browser don't include border
        var arrowBorder = parseFloat(arrowTabStyle.borderRightWidth) * 2;
        var prevNextBtnSize = arrowTabWidth * 2;
        var dividResultWidth;
        var ieVersion = getIEVersion_(userAgent);
        var rootWidth = getWidth_(root);
        var adjustWidth = 0;
        var tabItemWidth = 0;
        var tabOverSpace = 0;
        var i = 0;
        var viewAllTabsLength = viewAllTabs.length;
        var hideTabNum = viewAllTabsLength - config.showNumPerPage;
        var scrollLeft = tabScrollArea.scrollLeft;

        if (viewAllTabs.length === 0) {
          return;
        }
        // Overall width of the display area
        if (config.width != undefined) {
          dividResultWidth = divideNumUnit_(config.width);
          if (dividResultWidth !== null) {
            if (dividResultWidth.unit === "px") {
              rootWidth = parseInt(dividResultWidth.num, 10);
              root.style.width = rootWidth + "px";
            }
          }
        }
        if (hasClass_(arrowTabs[0], 'hide') &&
            hasClass_(arrowTabs[1], 'hide')) {
          prevNextBtnSize = 0;
        }

        /** reset width(ul, underLine), ulLeft, scrollLeft */
        if (ihmi.global.isModernBrowser && !config.isTabScroll) {
          tabScrollArea.style.width = '100%';
          tabScrollArea.scrollLeft = 0;
          ulElem.style.width = '';
          /** modernBrowser and hide arrow tab */
          if (ieVersion !== -1) {
            adjustWidth = 1;
          }
          tabItemWidth = format_('calc((100% - %spx)/ %s)', adjustWidth, config.showNumPerPage);
          for (i = 0; i < viewAllTabsLength; i++) {
            viewAllTabs[i].style.width = tabItemWidth;
          }
        } else {
          /** display:none and no config.width */
          if (rootWidth <= 0) {
            return;
          }
          /**
           * ie7 don't include border in arrowTabs
           *    and don't include padding and border in tab items.
           */
          if (ieVersion === 7) {
            if (prevNextBtnSize !== 0) {
              prevNextBtnSize += (arrowBorder * 2);
            }
            tabOverSpace = Math.ceil(viewAllTabs[0].getBorderPadding());
          }
          if (scrollLeft !== config.scrollLeft) {// flick Operation
            root.setLeftTabIdx();
          }
          /** Because a decimal point causes column dropout */
          tabItemWidth = Math.floor((rootWidth - prevNextBtnSize) / config.showNumPerPage);
          tabScrollArea.style.width = tabItemWidth * config.showNumPerPage + 'px';

          ulElem.style.width = (tabItemWidth * viewAllTabsLength) + 'px';
          scrollLeft = (tabItemWidth * config.curLeftIdx);
          tabScrollArea.scrollLeft = scrollLeft;

          config.overWidth = (tabItemWidth * hideTabNum);
          tabItemWidth -= tabOverSpace;
          for (i = 0; i < viewAllTabsLength; i++) {
            viewAllTabs[i].style.width = tabItemWidth + 'px';
            if (config.shrink) {
              setTabFontSize(viewAllTabs[i], root);
            }
          }
        }
        config.scrollLeft = tabScrollArea.scrollLeft;
        function setTabFontSize(elem, root) {
          var parentHeight = parseFloat(getCurrentStyle_(root).height);
          var elemHeight = elem.scrollHeight;
          var elemFontSize = 18;
          do {
            elem.style.fontSize = elemFontSize + 'px';
            elemHeight = elem.scrollHeight;
            elemFontSize -= 1;
          } while ((parentHeight < elemHeight) && (16 <= elemFontSize));
        }
      },
      findViewTabs: function() {
        var root = this;
        var config = root.config;
        var tabItems = root.findViewAllTabs();
        var startIdx = config.curLeftIdx;
        var endIdx = startIdx + config.showNumPerPage;

        return tabItems.slice(startIdx, endIdx);
      },
      findViewAllTabs: function() {
        var root = this;
        var tabItems = findDescendants_(root, "li", "ihcp-tab-item");
        var viewAllTabs = [];
        var viewsTabAllCount = 0;
        var isUserHide = false;

        for (var i = 0; i < tabItems.length; i++) {
          isUserHide = hasClass_(tabItems[i], "ihcp-tab-hide");
          if (!isUserHide) {
            viewAllTabs[viewsTabAllCount] = tabItems[i];
            viewsTabAllCount++;
          }
        }
        return viewAllTabs;
      },
      onclick: function(event) {
        var target = event.srcElement;
        var root;
        var config = null;
        if (target.tagName === "INS") {
          target = target.parentNode;
        }
        if (hasClass_(target, 'disabled')) {
          return false;
        }

        root = findAncestor_(target, "div", "ihcp-tabs");
        config = root.config;
        config.isMouseMoving = false;

        if (hasClass_(firstElementNode_(target), "ihcp-tab-arrow-prev")) {
          root.prevPageView(root);
        } else if (hasClass_(firstElementNode_(target), "ihcp-tab-arrow-next")) {
          root.nextPageView(root);
        }
        root.slideTabs();
        lightupBtnMoment_(target);
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        if (hasClass_(elem, 'disabled')) {
          return;
        }
        if (event.keyCode === 13) { // enter
          elem.click();
        }
      },
      nextPageView: function(root) {
        var viewTabs = root.findViewTabs();
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');
        var config = root.config;

        var scrollLeft = tabScrollArea.scrollLeft;
        var ieVersion = getIEVersion_(userAgent);
        var tabWidth = getWidth_(viewTabs[0]);
        var tabOverSpace = 0;
        /** ie7 don't include padding and border in tab items. */
        if (ieVersion === 7) {
          tabOverSpace = Math.ceil(viewTabs[0].getBorderPadding());
        }
        /** How much scrolling per tab */
        var moveAmount = (scrollLeft / (tabWidth + tabOverSpace));
        var diff = Math.abs(config.curLeftIdx - moveAmount);
        var isEdgeThreshold = (diff < config.EDGE_THRESHOLD);
        config.curLeftIdx = (isEdgeThreshold) ? config.curLeftIdx + 1
                                              : Math.floor(moveAmount) + 1;
        if (config.maxLeftIdx < config.curLeftIdx) {
          config.curLeftIdx = config.maxLeftIdx;
        }
      },
      prevPageView: function(root) {
        var viewTabs = root.findViewTabs();
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');
        var config = root.config;

        var scrollLeft = tabScrollArea.scrollLeft;
        var ieVersion = getIEVersion_(userAgent);
        var tabWidth = getWidth_(viewTabs[0]);
        var tabOverSpace = 0;
        /** ie7 don't include padding and border in tab items. */
        if (ieVersion === 7) {
          tabOverSpace = Math.ceil(viewTabs[0].getBorderPadding());
        }
        /**
         *  How much scrolling per tab.
         *  Deal with width effects of screen magnification.
         */
        var moveAmount = (scrollLeft / (tabWidth + tabOverSpace));
        var diff = Math.abs(config.curLeftIdx - moveAmount);
        var isEdgeThreshold = (diff < config.EDGE_THRESHOLD);
        config.curLeftIdx = (isEdgeThreshold) ? config.curLeftIdx - 1
                                              : Math.floor(moveAmount);
      },
      slideTabs: function() {
        var root = this;
        var config = root.config;
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');
        var tabItems = root.findViewAllTabs();

        var ieVersion = getIEVersion_(userAgent);
        var tabWidth = getWidth_(tabItems[0]);
        var tabOverSpace = 0;
        /** ie7 don't include padding and border in tab items. */
        if (ieVersion === 7) {
          tabOverSpace = Math.ceil(tabItems[0].getBorderPadding());
        }
        /** When property scrollLeft changes, scroll event occurs. */
        tabScrollArea.scrollLeft = (tabWidth + tabOverSpace) * config.curLeftIdx;
      },
      disabledBtn: function() {
        var root = this;
        var config = root.config;
        var buttons = findDescendants_(root, "div", "ihcp-tab-arrow");
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');
        var tabItems = findDescendants_(root, "li", "ihcp-tab-item");
        var tabItemStyle = getCurrentStyle_(tabItems[0]);

        if (tabItemStyle === null) {
          return;
        }
        var TAB_BORDER = parseFloat(tabItemStyle.borderLeftWidth);
        var scrollLeft = tabScrollArea.scrollLeft;
        var isLeftEdge = (scrollLeft === 0);
        var isRightEdge = (config.overWidth <= (scrollLeft + TAB_BORDER));

        if (root.disabled) {
          disableBtn(buttons[0]);
          disableBtn(buttons[1]);
        } else {
          (isLeftEdge) ? disableBtn(buttons[0])
                        : ableBtn(buttons[0]);
          (isRightEdge) ? disableBtn(buttons[1])
                         : ableBtn(buttons[1]);
        }
        // Active the "prev" or "next" button.
        function ableBtn(elem) {
          if (hasClass_(elem, 'disabled')) {
            removeClass_(elem, 'disabled');
            elem.setAttribute("tabIndex", 0);
          }
        }
        // Disable the "prev" or "next" button.
        function disableBtn(elem) {
          if (!hasClass_(elem, 'disabled')) {
            addClass_(elem, 'disabled');
            elem.removeAttribute("tabIndex");
            if (hasClass_(elem, 'focus')) {
              removeClass_(elem, 'focus');
            }
            elem.blur();
          }
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if (elem.tagName === 'INS') {
          elem = elem.parentNode;
        }
        if (hasClass_(elem, 'disabled')) {
          elem.blur();
        }
        addClass_(elem, "focus");
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if (elem.tagName === 'INS') {
          elem = elem.parentNode;
        }
        removeClass_(elem, "focus");
      },
      setLeftTabIdx: function() {
        var root = this;
        var config = root.config;
        var viewAllTabs = root.findViewAllTabs();
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');

        var scrollLeft = tabScrollArea.scrollLeft;
        var tabItemWidth = getWidth_(viewAllTabs[0]);
        var TAB_BORDER = parseFloat(getCurrentStyle_(viewAllTabs[0]).borderLeftWidth);

        config.scrollLeft = tabScrollArea.scrollLeft;
        config.curLeftIdx = Math.floor((scrollLeft + TAB_BORDER) / tabItemWidth);
        if (config.maxLeftIdx < config.curLeftIdx) {
          config.curLeftIdx = config.maxLeftIdx;
        }
      },
      onMoveStart: function(event) {
        var srcElem = event.srcElement;
        var root = findAncestor_(srcElem, 'div', 'ihcp-tabs');
        var doc = root.ownerDocument;
        var htmlElem = doc.body.parentElement;
        var config = root.config;
        var tabScrollArea = findDescendant_(root, 'div', 'ihcp-tabs-scroll-area');
        var startX = getClientX_(event);
        var startY = getClientY_(event);
        var startTime = (new Date()).getTime();
        var isTouchEvent = (event.type.indexOf('touch') !== -1);
        if (isTouchEvent && root.disabled) {
          preventBrowserDefault_(event);
        }

        if (!config.isTabScroll ||
            root.disabled ||
            isTouchEvent) {
          return;
        }
        /** prevent mousemove -> click */
        config.isMouseMoving = false;
        addEventHandler_(htmlElem, 'mousemove', onMoving);
        addEventHandler_(htmlElem, 'mouseup', onMoveStop);
        /** attaching mouseleave in doc.body cause unexpected cancel event */
        addEventHandler_(htmlElem, 'mouseleave', onMoveStop);
        function onMoving(event) {
          config.isMouseMoving = true;
          removeSelection_(root);
          preventBrowserDefault_(event);
          var curX = getClientX_(event);
          var curY = getClientY_(event);
          var elem = doc.elementFromPoint(curX, curY);
          if (elem === null) {
            onMoveStop(event);
          }
          var diff = startX - curX;
          if (config.overWidth < (tabScrollArea.scrollLeft + diff)) {
            tabScrollArea.scrollLeft = config.overWidth;
          } else {
            tabScrollArea.scrollLeft += diff;
          }
          startX = curX;
        }
        function onMoveStop(event) {
          var endX = getClientX_(event);
          var endY = getClientY_(event);
          var endTime = (new Date()).getTime();
          var times = (endTime - startTime);
          var isSamePosition = ((startX === endX) && (startY === endY));
          var isShortTime = (times < config.MOUSE_UP_LIMIT);
          /** prevent mousemove -> click */
          config.isMouseMoving = !(isSamePosition && isShortTime);
          removeEventHandler_(htmlElem, 'mousemove', onMoving);
          removeEventHandler_(htmlElem, 'mouseup', onMoveStop);
          removeEventHandler_(htmlElem, 'mouseleave', onMoveStop);
          root.setLeftTabIdx();
          root.disabledBtn();
        }
      }
    },
    funcKeys: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = ihmi.cf.getDefaultView(doc),
            type = this,
            div, funcKey;
        elem.handleFuncKeys = type.handleFuncKeys;
        ihmi.cf.KeyEvent.addHandler(function(event) {
          return elem.handleFuncKeys(event);
        }, frame, true);
        if (!ihmi.global.isIEMobile) {
          elem.changeNumRows = type.changeNumRows;
          if (ihmi.cf.findDescendants(elem, 'div', 'func-key-page').length == 2) {
            ihmi.global.hasTwoFuncKeyPages = true;
          } else if (ihmi.global.hasTwoFuncKeyPages) {
            // append dummy funcKeyPage so that the onresize event handler works properly.
            div = doc.createElement('div');
            div.className = 'func-key-page dummy';
            for (var i = 0; i < 5; i++) {
              funcKey = doc.createElement('div');
              ihmi.cf.addClasses(funcKey, 'func-key disabled');
              div.appendChild(funcKey);
            }
            elem.insertBefore(div, ihmi.cf.firstElementNode(elem));
          }
          ihmi.cf.addEventHandler(frame, "load", function (event) {
            elem.changeNumRows();
          });
          ihmi.cf.addEventHandler(frame, "resize", function (event) {
            elem.changeNumRows();
          });
        }
      },
      handleFuncKeys: function(event) {
        var elem = this,
            doc = elem.ownerDocument,
            index = event.keyCode - 48,
            funcKey = null,
            textbox, select, count, fkNext, offset;

        if (!event.ctrlKey || index < 0 || index > 10) return true;

        if (index === 0) index = 10;
        count = 0;
        for (var page = ihmi.cf.firstElementNode(elem); page !== null && funcKey === null; page = ihmi.cf.nextElementNode(page)) {
          if (!ihmi.cf.hasClass(page, "hide")) {
            if (index === 6) { // check if fkNext exists
              fkNext = doc.getElementById(page.id + '.fkNext');
              if (fkNext && !ihmi.cf.hasClass(fkNext, "hide")) {
                fkNext.click();
                return false;
              }
            }
            count += 5;
            if (index <= count) {
              offset = doc.getElementById(page.id + '.fkPrev') ? 1 : 0;
              funcKey = page.children[(index - 1) % 5 + offset];
            }
          }
        }
        if (funcKey === null || funcKey === undefined) return true;

        if (!ihmi.cf.hasClass(funcKey, 'disabled')) {
          ihmi.cf.addClass(funcKey, "clicked");
          textbox = ihmi.global.selectedTextbox;
          if (textbox !== null) {
            try {
              textbox.blur(); // fire onblur event for text box
              textbox.focus();
            } catch (e) {} // eslint-disable-line no-empty
          }
          select = ihmi.select.global.openedElement;
          if (select !== null) {
            try {
              select.click();
            } catch (e) {} // eslint-disable-line no-empty
          }
          setTimeout(function() { // wait onblur event finish
            funcKey.click();
          }, 0);
        }
        return false;
      },
      changeNumRows: function() {
        var elem = this,
            doc = elem.ownerDocument,
            body = doc.body,
            page1 = ihmi.cf.firstElementNode(elem),
            page2 = ihmi.cf.nextElementNode(page1),
            doubleRowMode, doubleRow,
            elemWidth, pageWidth, page1Width, page2Width;
        elemWidth = elem.clientWidth;
        page1Width = page1.scrollWidth;
        page2Width = (page2 === null) ? 0 : page2.scrollWidth;
        doubleRow = (page2 !== null && ((page1Width + page2Width) > elemWidth));
        doubleRowMode = ihmi.cf.hasClass(body, 'double-row');
        if (doubleRow && !doubleRowMode) {
          ihmi.cf.addClass(body, 'double-row');
        } else if (!doubleRow && doubleRowMode) {
          ihmi.cf.removeClass(body, 'double-row');
        }
        pageWidth = page1Width;
        if (!doubleRow) pageWidth += page2Width;
        elem.style.paddingLeft = ((pageWidth >= elemWidth) ? 0 : ((elemWidth - pageWidth) / 2)) + 'px';
      }
    },
    funcKeyPage: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.closeSelects = type.closeSelects;
        if (!ihmi.global.isIEMobile) {
          ihmi.cf.removeClass(elem, "hide");
        }
      },
      closeSelects: function() {
        var elem = this,
            pages = [],
            funcKeys, node, i, numPages;

        if (ihmi.global.isIEMobile) {
          pages.push(elem);
        } else { // On PC, function keys on the other page must be closed.
          funcKeys = elem.parentNode;
          for (node = ihmi.cf.firstElementNode(funcKeys); node !== null; node = ihmi.cf.nextElementNode(node)) {
            if (ihmi.cf.hasClass(node, "func-key-page") && !ihmi.cf.hasClass(node, "dummy")) {
              pages.push(node);
            }
          }
        }

        for (i = 0, numPages = pages.length; i < numPages; i++) {
          for (node = ihmi.cf.firstElementNode(pages[i]); node !== null; node = ihmi.cf.nextElementNode(node)) {
            if (ihmi.cf.hasClass(node, "func-key")) {
              node.closeSelect();
            }
          }
        }
      }
    },
    funcKey: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = ihmi.cf.getDefaultView(doc),
            type = this,
            iconPullup = doc.getElementById(elem.id + ".pullup"),
            funcSelect,
            addEventHandler = ihmi.cf.addEventHandler;
        config.handleKeys = null;
        elem.config = config;
        elem.refresh = type.refresh;
        elem.setCallback = type.setCallback;
        elem.getSelect = type.getSelect;
        elem.initSelect = type.initSelect;
        elem.openSelect = type.openSelect;
        elem.closeSelect = type.closeSelect;
        elem.handleSelectKeys = type.handleSelectKeys;
        addEventHandler(elem, "click", type.onclick);
        if (!ihmi.global.isIEMobile) {
          addEventHandler(elem, "mousedown", type.onmousedown);
          addEventHandler(elem, "mouseout", type.onmouseout);
        }
        funcSelect = elem.getSelect();
        if (funcSelect !== null && iconPullup !== null) {
          ihmi.cf.removeClass(iconPullup, 'hide');
        }
        elem.initSelect();
        if (config.page === undefined) {
          config.page = frame.webpage;
        }
        if (config.name === undefined) {
          ihmi.cf.addClass(elem, 'disabled');
        }
      },
      refresh: function(params, options, disabled, onclick) {
        var elem = this,
            doc = elem.ownerDocument,
            divLabel = ihmi.cf.findDescendant(elem, 'div', 'func-key-lower'),
            iconPullup = doc.getElementById(elem.id + ".pullup"),
            config = elem.config,
            img = null,
            colorTable = ihmi.global.colorTable,
            textNode, funcSelect,
            html, option, div, ol, propDisabled, className;

        function setImage(img, params) {
          if ('sprite' in params) {
            img.className = 'func-key-sprite ' + params.sprite;
          } else {
            img.className = 'func-key-image';
            img.style.backgroundImage = ihmi.cf.format('url(%s)', params.image);
          }
        }

        elem.closeSelect();

        if ('label' in params) {
          textNode = ihmi.cf.getTextNode(divLabel);
          if (textNode === null) {
            textNode = doc.createTextNode(params.label);
            divLabel.appendChild(textNode);
          } else {
            textNode.nodeValue = params.label;
          }
        }
        if ('name' in params) config.name = params.name;
        if ('page' in params) config.page = params.page;
        elem.style.backgroundColor = ('color' in params && params.color in colorTable) ? colorTable[params.color]: '';

        // if color is member of colorTable, color is used as className.
        className = ('color' in params && !(params.color in colorTable)) ? params.color : '';
        if (typeof config.className === 'string' && config.className !== '') {
          ihmi.cf.removeClass(elem, config.className);
        }
        if (className !== '') {
          ihmi.cf.addClass(elem, className);
        }
        config.className = className;

        img = doc.getElementById(elem.id + ".image");
        if ('sprite' in params || 'image' in params) {
          if (params.sprite === '' || params.image === '') {
            if (img !== null) {
              elem.removeChild(img.parentNode);
              img = null;
            }
          } else {
            if (img === null) {
              div = doc.createElement('div');
              div.className = 'func-key-upper';
              img = doc.createElement('ins');
              img.id = elem.id + '.image';
              setImage(img, params);
              div.appendChild(img);
              elem.insertBefore(div, ihmi.cf.firstElementNode(elem));
            } else {
              setImage(img, params);
            }
          }
        }

        if (options === null) {
          funcSelect = elem.getSelect();
          if (funcSelect !== null) {
            divLabel.removeChild(funcSelect);
          }
          if (iconPullup !== null) {
            ihmi.cf.addClass(iconPullup, 'hide');
          }
        } else {
          if (options.length > 0) {
            html = [];
            ol = doc.createElement('ol');
            ol.className = 'func-select hide';
            for (var i = 0, len = options.length; i < len; i++) {
              option = options[i];
              if (option !== undefined) {
                propDisabled = option[2] ? ' disabled="true" class="disabled"' : '';
                html.push(ihmi.cf.format('<li data-value="%s"%s><a href="javascript:void(0);">%s</a></li>', option[0], propDisabled, option[1]));
              }
            }
            ol.innerHTML = html.join('');

            funcSelect = elem.getSelect();
            if (funcSelect === null) {
              divLabel.appendChild(ol);
            } else {
              divLabel.replaceChild(ol, funcSelect);
            }
            elem.initSelect();
            if (iconPullup !== null) {
              ihmi.cf.removeClass(iconPullup, 'hide');
            }
          }
        }

        if (typeof config.name !== "string" || config.name === '') {
          disabled = true;
        }
        ihmi.cf.turnOnOffClass(elem, 'disabled', disabled);
        if (typeof(onclick) === "function") {
          elem.setCallback(onclick);
        }
      },
      setCallback: function(callback) {
        var root = this;
        root.config.onclick = callback;
      },
      getSelect: function() {
        var elem = this;
        return ihmi.cf.findDescendant(elem, "ol", "func-select");
      },
      initSelect: function() {
        var elem = this,
            funcSelect = elem.getSelect(),
            child;
        if (funcSelect !== null) {
          for (var node = ihmi.cf.firstElementNode(funcSelect), i = 1; node !== null; node = ihmi.cf.nextElementNode(node), i++) {
            child = ihmi.cf.firstElementNode(node);
            child.innerText = i + " " + child.innerText;
            ihmi.cf.addEventHandler(child, "focus", ihmi.funcKey.onfocus);
          }
        }
      },
      openSelect: function() {
        var elem = this,
            config = elem.config,
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            funcSelect = elem.getSelect(),
            divLabel = ihmi.cf.findDescendant(elem, 'div', 'func-key-lower'),
            textNode;
        if (funcSelect === null) return;

        if (ihmi.cf.hasClass(funcSelect, "hide")) {
          textNode = ihmi.cf.getTextNode(divLabel);
          if (textNode !== null) {
            textNode.nodeValue = textNode.nodeValue.replace(/[\[\]]/g, "|");
          }
          ihmi.cf.removeClass(funcSelect, "hide");
          ihmi.cf.addClass(elem, "opened");

          if (config.handleKeys !== null) {
            ihmi.cf.KeyEvent.removeHandler(config.handleKeys);
          }
          config.handleKeys = function(event) {
            return elem.handleSelectKeys(event);
          };
          ihmi.cf.KeyEvent.addHandler(config.handleKeys, frame, false);
        }
      },
      closeSelect: function() {
        var elem = this,
            config = elem.config,
            funcSelect = elem.getSelect(),
            divLabel = ihmi.cf.findDescendant(elem, 'div', 'func-key-lower'),
            textNode;
        if (funcSelect === null) return;

        if (!ihmi.cf.hasClass(funcSelect, "hide")) {
          textNode = ihmi.cf.getTextNode(divLabel);
          if (textNode !== null) {
            textNode.nodeValue = textNode.nodeValue.replace(/\|([^\|]+)\|/, "[$1]");
          }
          ihmi.cf.addClass(funcSelect, "hide");
          ihmi.cf.removeClass(elem, "opened");

          if (config.handleKeys !== null) {
            ihmi.cf.KeyEvent.removeHandler(config.handleKeys);
            config.handleKeys = null;
          }
        }
      },
      handleSelectKeys: function(event) {
        var elem = this,
            funcSelect = elem.getSelect(),
            keyCode = event.keyCode,
            keyOneCode = 49,
            index, currSelected, nextSelected, dist, direction;

        switch (keyCode) {
        case 13: // enter key
          currSelected = ihmi.cf.findDescendant(elem, "li", "selected");
          if (currSelected !== null) {
            currSelected.click();
          }
          return false;

        case 27: // prev
          elem.click();
          return false;

        default:
          dist = ihmi.cf.keyEventToDistance(event);
          if (dist !== 0) {
            currSelected = ihmi.cf.findDescendant(elem, "li", "selected");
            if (currSelected !== null) {
              nextSelected = ihmi.cf.getNextNode(funcSelect, currSelected, dist);
              if (nextSelected !== null) {
                direction = dist / Math.abs(dist);
                while (nextSelected.disabled) {
                  nextSelected = ihmi.cf.getNextNode(funcSelect, nextSelected, direction);
                  if (nextSelected === currSelected) return false;
                }
                ihmi.cf.addClassExclusively(funcSelect, nextSelected, "selected");
                return false;
              }
            }
          } else {
            if (!event.ctrlKey && keyCode >= keyOneCode - 1 && keyCode < keyOneCode + 9) { // number keys
              index = keyCode - keyOneCode;
              if (index === -1) index += 10;
              nextSelected = funcSelect.children[index];
              if (nextSelected !== null && nextSelected !== undefined) {
                nextSelected.click();
                return false;
              }
            }
          }
        }
        return true;
      },
      onclick: function(event) {
        var elem = event.srcElement,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            funcKey, funcSelect, config, type, label;

        function getFuncKeyLabel(elem) {
          var divLabel = ihmi.cf.findDescendant(elem, 'div', 'func-key-lower'),
              textNode, label;
          textNode = ihmi.cf.getTextNode(divLabel);
          if (textNode === null) return null;
          label = textNode.nodeValue.replace(/^\s+/, "");
          label = label.replace(/\s+$/, "");
          return (label === "") ? null : ihmi.cf.encodeURIComponentLocal(label);
        }

        switch (elem.tagName) {
        case "DIV":
        case "INS":
        case "SPAN":
          funcKey = ihmi.cf.findAncestor(elem, 'div', 'func-key');
          if (ihmi.cf.hasClass(funcKey, 'disabled')) return false;

          ihmi.cf.lightupBtnMoment(funcKey);
          config = funcKey.config;
          funcSelect = funcKey.getSelect();
          if (funcSelect === null) {
            funcKey.parentNode.closeSelects();
            label = getFuncKeyLabel(funcKey);
            if (label !== null) {
              if (config.onclick !== undefined && config.onclick !== null) {
                config.onclick('clicked', config.page, config.name, label);
              } else {
                ihmi.cf.IUIFRequest(frame, { webpage: config.page, request: config.name + ".clicked", label: label}).send();
              }
            }
          } else {
            if (!ihmi.cf.hasClass(funcSelect, "hide")) {
              funcKey.closeSelect();
              type = "resizeend";
            } else {
              for (var option = ihmi.cf.firstElementNode(funcSelect); option !== null; option = ihmi.cf.nextElementNode(option)) {
                if (!option.disabled) break;
              }
              if (option !== null) {
                ihmi.cf.addClassExclusively(funcSelect, option, "selected");
              }
              funcKey.parentNode.closeSelects();
              funcKey.openSelect();
              type = "resizestart";
            }
            ihmi.cf.triggerEvent(funcKey, type);
          }
          break;

        case "A":
        case "LI":
          if (elem.tagName === "A") {
            elem = elem.parentNode;
          }
          if (elem.disabled) return false;

          funcSelect = ihmi.cf.findAncestor(elem, "ol", "func-select");
          ihmi.cf.addClassExclusively(funcSelect, elem, "selected");

          setTimeout(function() {
            funcKey = ihmi.cf.findAncestor(elem, "div", "func-key");
            funcKey.closeSelect();
            ihmi.cf.triggerEvent(funcKey, 'resizeend');
            config = funcKey.config;
            label = getFuncKeyLabel(funcKey);
            if (label !== null) {
              if (config.onclick !== undefined && config.onclick !== null) {
                config.onclick('selected', config.page, config.name, elem.getAttribute('data-value'), label);
              } else {
                ihmi.cf.IUIFRequest(frame, { webpage: config.page, request: config.name + ".selected", value: elem.getAttribute('data-value'), label: label }).send();
              }
            }
          }, 100);
          break;
        }
        return false;
      },
      onmousedown: function(event) {
        var elem = event.srcElement;
        if (elem.tagName === "DIV" && !ihmi.cf.hasClass(elem, 'disabled')) {
          ihmi.cf.addClass(elem, "clicked");
        }
        return false;
      },
      onmouseout: function(event) {
        var elem = event.srcElement;
        if (elem.tagName === "DIV" && !ihmi.cf.hasClass(elem, 'disabled')) {
          ihmi.cf.removeClass(elem, "clicked");
        }
        return false;
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        elem.blur(); /* remove annoying dotted line */
        return false;
      }
    },
    thumbnailGrid: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            addEventHandler = ihmi.cf.addEventHandler,
            frame = ihmi.cf.getDefaultView(doc),
            type = this;
        config.numImages = 0;
        if (!("upperChecked" in config) ||
            !("lowerChecked" in config)) {
          config.upperChecked = 'ihmicomponent-large-radiomark-on';
        }
        if (!("upperUnChecked" in config) ||
            !("lowerUnChecked" in config)) {
          config.upperUnChecked = 'ihmicomponent-large-radiomark-off';
        }
        config.notifySize = ihmi.cf.parseStrToBoolean(config.notifySize);
        elem.config = config;
        elem.refresh = type.refresh;
        elem.refreshOne = type.refreshOne;
        elem.thumbHTML = type.thumbHTML;
        elem.setCallback = type.setCallback;
        addEventHandler(elem, "click", type.onclick);
        elem.notifySize = type.notifySize;
        addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
          try {
            elem.notifySize('resized');
          } catch (e) {
            return;
          }
        }, 200));
        elem.handleKeys = type.handleKeys;
        addEventHandler(frame, "load", function() {
          ihmi.cf.KeyEvent.addHandler(function(event) {
            return elem.handleKeys(event);
          }, frame, false);
          elem.notifySize('initialized');
        });
      },
      refresh: function(margin, options, url, imageWidth, selected, disabled) {
        var elem = this,
            config = elem.config,
            numThumbnails, html, i,
            sumWidth;
        sumWidth = 0;
        html = [];

        ihmi.cf.removeLastUndefined(options);
        numThumbnails = options.length;

        if (config.mode === 'thumbnail-horizontal') {
          for (i = 0; i < numThumbnails; i++) {
            sumWidth += options[i].width * options[i].zoom + margin;
          }
          sumWidth += margin;
          elem.style.width = sumWidth + 'px';
        }
        for (i = 0; i < numThumbnails; i++) {
          html.push(elem.thumbHTML(margin, options[i], url, imageWidth, selected));
        }
        elem.innerHTML = html.join('');
      },
      refreshOne: function(margin, option, url, selected) {
        var elem = this,
            config = elem.config,
            zoom = option.zoom || 1,
            divThumb, imgThumb, divOverlay,
            buttonLower, buttonUpper,
            checked,
            findDescendant = ihmi.cf.findDescendant,
            hasClass = ihmi.cf.hasClass,
            turnOnOffClass = ihmi.cf.turnOnOffClass;

          var findThumb = function(elem, index) {
            var divThumb;
            for (divThumb = ihmi.cf.firstElementNode(elem); divThumb !== null; divThumb = ihmi.cf.nextElementNode(divThumb)) {
              if (parseInt(divThumb.getAttribute('data-value'), 10) === index) {
                return divThumb;
              }
            }
            return null;
          };

        divThumb = findThumb(elem, option.index);
        if (divThumb === null) return;
        imgThumb = findDescendant(divThumb, 'img', 'thumbnail-grid-img');
        if (imgThumb === null) return;

        divOverlay = findDescendant(divThumb, "div", "thumbnail-grid-ov");
        buttonLower = findDescendant(divThumb, 'ins', 'thumbnail-button-lower');
        buttonUpper = findDescendant(divThumb, 'ins', 'thumbnail-button-upper');

        if (option.upperCheck !== undefined) {
          checked = option.upperCheck;
          turnOnOffClass(buttonUpper, config.upperChecked, checked);
          turnOnOffClass(buttonUpper, config.upperUnChecked, !checked);
        }
        if (option.lowerCheck !== undefined) {
          checked = option.lowerCheck;
          turnOnOffClass(buttonUpper, config.lowerChecked, checked);
          turnOnOffClass(buttonUpper, config.lowerUnChecked, !checked);
        }

        if (hasClass(buttonLower, config.lowerChecked)   && !hasClass(buttonLower, 'hide') ||
            hasClass(buttonUpper, config.upperUnChecked) && !hasClass(buttonUpper, 'hide')) {
          ihmi.cf.removeClass(divOverlay, 'hide');
        } else {
          ihmi.cf.addClass(divOverlay, 'hide');
        }

        imgThumb.onload = function() {
          var imgThumb = this;
          var format = ihmi.cf.format;
          imgThumb.style.left   = format('-%spx', option.y * zoom);
          imgThumb.style.top    = format('-%spx', option.x * zoom);
          imgThumb.style.width  = format('%spx', option.width * zoom);
          divThumb.style.width  = format('%spx', option.width * zoom);
          divThumb.style.height = format('%spx', option.height * zoom);
          imgThumb.onload = null;
        };
        imgThumb.src = url;
      },
      thumbHTML: function(margin, option, url, imageWidth, selected) {
        var elem = this,
            config = elem.config,
            border = 2,
          html, zoom;
        var format = ihmi.cf.format;
        html = [];
        zoom = option.zoom || 1;
        html.push('<div class="thumbnail-grid');
        if (selected === option.index) {
          html.push(' thumbnail-grid-selected');
        }
        html.push(format('" data-value="%s" ', option.index));
        html.push(format('style="width: %spx; height: %spx; margin-left: %spx; margin-top: %spx; border-width: %spx;">', option.width * zoom, option.height * zoom, margin - border * 2, margin - border * 2, border));
        html.push(format('<img class="thumbnail-grid-img" src="%s" style="left: -%spx; top: -%spx; width: %spx;"></img>', url, option.y * zoom, option.x * zoom, imageWidth * zoom));
        html.push(format('<div class="thumbnail-grid-ov %s"></div>', (option.upperCheck === false || option.lowerCheck === true) ? "" : "hide"));
        if (option.text) html.push(format('<div class="thumbnail-grid-status">%s</div>', option.text.replace(/\n/g, '<br>')));
        html.push(format('<ins class="thumbnail-button-upper %s"></ins>', (option.upperCheck === undefined) ? 'hide' : (option.upperCheck ? config.upperChecked : config.upperUnChecked)));
        html.push(format('<ins class="thumbnail-button-lower %s"></ins>', (option.lowerCheck === undefined) ? 'hide' : (option.lowerCheck ? config.lowerChecked : config.lowerUnChecked)));
        html.push(format('<div class="thumbnail-index">%s</div>', option.index + 1));
        html.push('</div>');

        return html.join('');
      },
      onclick: function(event) {
        var target = event.srcElement,
            doc = target.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            findDescendant = ihmi.cf.findDescendant,
            divOverlay, buttonUpper, buttonLower,
            root, grid, config, checked, hasClass, turnOnOffClass;
        switch (target.tagName) {
        case "INS":
          grid = target.parentNode;
          root = grid.parentNode;
          config = root.config;
          hasClass = ihmi.cf.hasClass;
          turnOnOffClass = ihmi.cf.turnOnOffClass;

          divOverlay = findDescendant(grid, "div", "thumbnail-grid-ov");
          buttonLower = findDescendant(grid, 'ins', 'thumbnail-button-lower');
          buttonUpper = findDescendant(grid, 'ins', 'thumbnail-button-upper');

          if (hasClass(target, 'thumbnail-button-upper')) {
            checked = hasClass(target, config.upperChecked);
            turnOnOffClass(target, config.upperChecked, !checked);
            turnOnOffClass(target, config.upperUnChecked, checked);
            if (typeof config.clickCallback === 'function') {
              config.clickCallback(root.id, "upperChecked", parseInt(grid.getAttribute('data-value'), 10), !checked);
            } else {
              ihmi.cf.IUIFRequest(frame, { request: root.id + ".upperChecked", type: parseInt(grid.getAttribute('data-value'), 10), value: !checked }).send();
            }
          } else {
            checked = hasClass(target, config.lowerChecked);
            turnOnOffClass(target, config.lowerChecked, !checked);
            turnOnOffClass(target, config.lowerUnChecked, checked);
            if (typeof config.clickCallback === 'function') {
              config.clickCallback(root.id, "lowerChecked", parseInt(grid.getAttribute('data-value'), 10), !checked);
            } else {
              ihmi.cf.IUIFRequest(frame, { request: root.id + ".lowerChecked", type: parseInt(grid.getAttribute('data-value'), 10), value: !checked }).send();
            }
          }

          if (hasClass(buttonLower, config.lowerChecked)   && !hasClass(buttonLower, 'hide') ||
              hasClass(buttonUpper, config.upperUnChecked) && !hasClass(buttonUpper, 'hide')) {
            ihmi.cf.removeClass(divOverlay, 'hide');
          } else {
            ihmi.cf.addClass(divOverlay, 'hide');
          }
          break;
        case "IMG":
        case "DIV":
          grid = ihmi.cf.findAncestor(target, "div", "thumbnail-grid");
          if (grid !== null) {
            root = grid.parentNode;
            config = root.config;
            root = grid.parentNode;
            if (ihmi.cf.findDescendant(root, 'div', 'thumbnail-grid-selected') !== null) {
              ihmi.cf.addClassExclusively(root, grid, "thumbnail-grid-selected");
            }
            if (typeof config.clickCallback === 'function') {
              config.clickCallback(root.id, "clicked", parseInt(grid.getAttribute('data-value'), 10));
            } else {
              ihmi.cf.IUIFRequest(frame, { request: root.id + ".clicked", type: parseInt(grid.getAttribute('data-value'), 10) }).send();
            }
          }
          break;
        }
      },
      notifySize: function(requestName) {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            div = elem.parentNode,
            config = elem.config;
        if (elem === null) return;
        if (config.notifySize) {
          if (typeof config.resizeCallback === 'function') {
            config.resizeCallback(elem.id, requestName, div.clientWidth, div.clientHeight);
          } else {
            ihmi.cf.IUIFRequest(frame, { request: elem.id + '.' + requestName, value: ihmi.cf.format('%sx%s', div.clientWidth, div.clientHeight) }).send();
          }
        }
      },
      handleKeys: function(event) {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            config = elem.config,
            currThumb, nextThumb;
        switch (event.keyCode) {
        case 37: // left arrow
        case 39: // right arrow
          currThumb = ihmi.cf.findDescendant(elem, 'div', 'thumbnail-grid-selected');
          if (currThumb !== null) {
            nextThumb = currThumb[event.keyCode === 37 ? 'previousSibling' : 'nextSibling'];
            if (nextThumb !== null) {
              ihmi.cf.addClassExclusively(elem, nextThumb, "thumbnail-grid-selected");
              if (typeof config.callback === 'function') {
                config.callback(elem.id, "selected", parseInt(nextThumb.getAttribute('data-value'), 10));
              } else {
                IUIFRequest_(frame, {
                  request: elem.id + ".selected",
                  type: parseInt(nextThumb.getAttribute('data-value'), 10)
                }).send();
              }
              return false;
            }
          }
          break;
        }
        return true;
      },
      setCallback: function(type, callback) {
        var elem = this;
        if (type === "click"){
          elem.config.clickCallback = callback;
        } else {
          elem.config.resizeCallback = callback;
        }
      }
    },
    imageViewer: {
      global : {
        cacheId: 0
      },
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = ihmi.cf.getDefaultView(doc),
            type = this,
            textNode;
        if (!("interval" in config)) {
          config.interval = 100;
        }
        config.timeoutId = null;
        config.cancelInvoke = false;
        elem.config = config;
        elem.refresh = type.refresh;
        elem.alignVertically = type.alignVertically;
        elem.showText = type.showText;
        elem.scrollToPos = type.scrollToPos;
        elem.invoke = type.invoke;
        elem.cancelRefresh = type.cancelRefresh;
        elem.setCallback = type.setCallback;
        // Without the following line, scroll bar is shown unexpectedly.
        textNode = ihmi.cf.getTextNode(doc.getElementById(elem.id + ".div"));
        if (textNode !== null) {
          textNode.nodeValue = "";
        }
        ihmi.cf.addEventHandler(frame, "resize", function (event) {
          elem.alignVertically();
        });
        if (elem.config.nofifySize === "true") {
          ihmi.cf.IUIFRequest(frame, { request: elem.id + '.initialized', value: ihmi.cf.format('%sx%s', elem.parentNode.clientWidth, elem.parentNode.clientHeight) }).send();
        }
      },
      refresh: function(url, width, height, option, invokeNext) {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            config = elem.config,
            global = ihmi.imageViewer.global,
            div = doc.getElementById(elem.id + '.div'),
            img = doc.getElementById(elem.id + '.img');
        if (config.timeoutId !== null) {
          frame.clearTimeout(config.timeoutId);
          config.timeoutId = null;
        }
        if (config.cancelInvoke) {
          config.cancelInvoke = false;
          if (invokeNext) return;
        }
        if (url === null) {
          div.style.width = 0;
          div.style.height = 0;
        } else {
          img.onload = function() {
            var img = this;
            // img.style.width = width + 'px';
            // img.style.height = height + 'px';
            div.style.width = width + 'px';
            div.style.height = height + 'px';
            elem.style.width = width + 'px';
            elem.style.height = height + 'px';
            if (typeof option.scroll === 'object') {
              elem.scrollToPos(option.scroll.x, option.scroll.y);
            }
            if (typeof option.text === 'object') {
              elem.showText(option.text.text, option.text.className, option.text.overlay);
            } else {
              elem.showText('', '', false);
            }
            if (config.cancelInvoke) {
              config.cancelInvoke = false;
            } else if (invokeNext) {
              elem.invoke();
            }
            elem.alignVertically();
            img.onload = null;
          };
          img.src = ihmi.cf.format('%s?nocache=1&id=%s', url, global.cacheId);
          global.cacheId = 1 - global.cacheId;
        }
      },
      alignVertically: function() {
        var elem = this;
        elem.style.marginTop = (elem.offsetHeight < elem.parentNode.offsetHeight) ? parseInt((elem.parentNode.offsetHeight - elem.offsetHeight), 10) / 2 + "px" : "0";
      },
      showText: function(text, className, overlay) {
        var elem = this,
            doc = elem.ownerDocument,
            divOverlay = doc.getElementById(elem.id + '.overlay'),
            divText = doc.getElementById(elem.id + '.text'),
            hide;
        divText.innerText = text;
        divText.className = ''; // Clear class
        hide = (text === '') ? true : false;
        if (className === '') {
          className = 'image-viewer-text';
        }
        ihmi.cf.addClass(divText, className);
        ihmi.cf.turnOnOffClass(divText, 'hide', hide);
        ihmi.cf.turnOnOffClass(divOverlay, 'hide', !overlay);
      },
      scrollToPos: function(x, y) {
        var elem = this;
        elem.scrollTop = x - elem.clientHeight / 2;
        elem.scrollLeft = y - elem.clientWidth / 2;
      },
      invoke: function() {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            config = elem.config;
        if (config.timeoutId !== null) {
          frame.clearTimeout(config.timeoutId);
        }
        config.timeoutId = frame.setTimeout(function() {
          if (typeof config.callback === 'function') {
            config.callback(elem.id, "invoked");
          } else {
            try {
              IUIFRequest_(frame, {
                request: elem.id + ".invoked"
              }).send();
            } catch (e) {} // eslint-disable-line no-empty
          }
          config.timeoutId = null;
        }, config.interval);
      },
      cancelRefresh: function() {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            config = elem.config;
        if (config.timeoutId !== null) { // timeout handler has not been fired yet
          frame.clearTimeout(config.timeoutId);
          config.timeoutId = null;
        } else {
          config.cancelInvoke = true;
        }
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      }
    },
    imageIllust: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.refresh = type.refresh;
      },
      refresh: function(image) {
        var elem = this;
        if (image === null || image === '') {
          elem.style.width = 0;
          elem.style.height = 0;
        } else {
          elem.src = ihmi.cf.format('%s', image);
          elem.style.width = 'auto';
          elem.style.height = 'auto';
        }
      }
    },
    progressBar: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        if (!("interval" in config)) {
          config.interval = 500;
        }
        config.timeoutId = null;
        elem.config = config;
        elem.invoke = type.invoke;
        elem.refresh = type.refresh;
        elem.setCallback = type.setCallback;

        ihmi.cf.determineDefaultDesignPattern(elem);
      },
      invoke: function() {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            config = elem.config;
        config.timeoutId = frame.setTimeout(function() {
          if (typeof config.callback === 'function') {
            config.callback(elem.id, "invoked");
          } else {
            IUIFRequest_(frame, {
              request: elem.id + ".invoked"
            }).send();
          }
          config.timeoutId = null;
        }, config.interval);
      },
      refresh: function(parcent, invokeNext) {
        var elem = this,
            doc = elem.ownerDocument,
            frame = ihmi.cf.getDefaultView(doc),
            bar = doc.getElementById(elem.id + '.bar'),
            config = elem.config;
        parcent = Math.min(1.0, parcent);
        bar.style.width = (parcent * 100) + '%';
        if (config.timeoutId != null) {
          frame.clearTimeout(config.timeoutId);
        }
        if (invokeNext) {
          elem.invoke();
        }
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      }
    },
    listSelect: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = getDefaultView_(doc),
            type = this,
            icons= findDescendants_(elem, "ins", "list-select-mark"),
            options = findDescendants_(elem, "li", "list-select-option"),
            DEF_HEIGHT_TOUCH = 52,
            DEF_HEIGHT_MOUSE = 26;
        if (config.horizontal === "true") {
          config.horizontal = true;
          config.widthAdjusted = false;
        } else {
          if ("horizontal" in config) {
            alert(format_('[listSelect] invalid horizontal value "%s"', config.horizontal));
          }
          config.horizontal = false;
        }
        if (config.icon === "false") {
          config.icon = false;
          for (var i = 0; i < icons.length; i++) {
            icons[i].style.display = "none";
            icons[i].parentNode.style.width = "0px";
          }
        } else {
          config.icon = true;
        }
        config.shrink = ((getIEVersion_(userAgent) > 10) ||
                         (getIEVersion_(userAgent) === -1))
                          ? parseStrToBoolean_(config.shrink)
                          : false;
        if (config.shrink) addClass_(elem, 'list-select-shrink');

        elem.config = config;
        elem.refresh = type.refresh;
        elem.setWidth = type.setWidth;
        elem.setCallback = type.setCallback;
        elem.turnOnOffTabindex = type.turnOnOffTabindex;
        elem.setTextWidth = type.setTextWidth;
        elem.setIconPosition = type.setIconPosition;
        elem.getImageClass = type.getImageClass;
        elem.getValue = type.getValue;
        elem.setHeight = type.setHeight;
        elem.adjustWidthHeight = type.adjustWidthHeight;

        determineDefaultDesignPattern_(elem);
        // li height
        if (options.length > 0) {
          config.defaultHeight = parseFloat(getCurrentStyle_(options[0]).height);
        } else {
          // no lisetSelectOption
          config.defaultHeight = (config.designpattern === "touch" ? DEF_HEIGHT_TOUCH : DEF_HEIGHT_MOUSE);
        }
        addEventHandler_(elem, "click", type.onclick);
        addEventHandler_(elem, "keypress", type.onkeypress);
        if (getIEVersion_(userAgent) === 7) {
          for (var h = 0; h < options.length; h++) {
            addEventHandler_(options[h], "focus", type.onfocus);
            addEventHandler_(options[h], "blur", type.onblur);
            addEventHandler_(options[h].children[0], "focus", type.onfocus);
            addEventHandler_(options[h].children[0], "blur", type.onblur);
            addEventHandler_(options[h].children[1], "focus", type.onfocus);
            addEventHandler_(options[h].children[1], "blur", type.onblur);
          }
        }

        addEventHandler_(frame, "load", resizeWidth);
        addEventHandler_(frame, "load", function() {
          addEventHandler_(frame, "resize", debounce_(resizeWidth, 200));
        });
        function resizeWidth() {
          elem.adjustWidthHeight();
        }

        if (config.designpattern === 'mouse') {
          for (h = 0; h < options.length; h++) {
            var btnStatus = findDescendant_(options[h], "ins", "ihmicomponent-large-radiomark-off");
            replaceClass_(btnStatus, "ihmicomponent-large-radiomark-off", "ihmicomponent-small-radiomark-off");
          }
        }
      },
      refresh: function(options, selected, disabled) {
        var elem = this,
            ul = firstElementNode_(elem),
            config = elem.config,
            html = [],
            i, len, li, icon, optionLeft, addClass, newOptions, btnStatus;

        if (options === null) {
          for (li = firstElementNode_(ul); li !== null; li = nextElementNode_(li)) {
            if (li.getAttribute('data-value') === selected || parseInt(li.getAttribute('data-value'), 10) === selected) {
              addClassExclusively_(ul, li, 'selected');
              break;
            }
          }
        } else {
          removeLastUndefined_(options);
          if (config.icon) {
            optionLeft = '<div class="list-select-option-left">';
            icon = '<ins class="list-select-mark %s"></ins>';
          } else {
            optionLeft = '<div class="list-select-option-left" style="width:0px;">';
            icon = '<ins class="list-select-mark %s" style="display:none;"></ins>';
          }
          for (i = 0, len = options.length; i < len; i++) {
            addClass = '';
            if (options[i].className !== undefined && options[i].className !== null) {
              addClass = options[i].className;
            }

            if (options[i].value === selected) {
              addClass += ' selected';
            }
            html.push(format_('<li class="list-select-option %s" data-value="%s" tabindex="0">' + optionLeft + icon + '</div><div class="list-select-option-right">%s</div></li>',
                            addClass, options[i].value,elem.getImageClass(elem.config.designpattern,'radiomark-off'), options[i].text));
          }
          ul.innerHTML = html.join('');
          config.widthAdjusted = true;

          if (config.icon) {
            elem.setIconPosition();
          }
          if (getIEVersion_(userAgent) === 7) {
            setTimeout(function() {
              newOptions = findDescendants_(elem, "li", "list-select-option");
              for (var h = 0; h < newOptions.length; h++) {
                addEventHandler_(newOptions[h], "focus", ihmi.listSelect.onfocus);
                addEventHandler_(newOptions[h], "blur", ihmi.listSelect.onblur);
                addEventHandler_(newOptions[h].children[0], "focus", ihmi.listSelect.onfocus);
                addEventHandler_(newOptions[h].children[0], "blur", ihmi.listSelect.onblur);
                addEventHandler_(newOptions[h].children[1], "focus", ihmi.listSelect.onfocus);
                addEventHandler_(newOptions[h].children[1], "blur", ihmi.listSelect.onblur);
              }
            }, 0);
          }
        }
        if (config.horizontal && !config.widthAdjusted) {
          elem.setWidth();
        }

        setTimeout(function() {
          elem.setTextWidth();
        }, 0);

        //If this is not defined, elem.disabled = false (IE), elem.disabled = undefined (Chrome).
        elem.disabled = (disabled === true);

        turnOnOffClass_(elem, 'disabled', disabled);
        elem.turnOnOffTabindex(disabled);

        //Initialize the image class.
        options = findDescendants_(elem, "li", "list-select-option");
        for (var h = 0; h < options.length; h++) {
          btnStatus = findDescendant_(options[h], "ins", "list-select-mark");
          if (!hasClass_(btnStatus,elem.getImageClass(config.designpattern,'radiomark-off'))) {
            if (config.designpattern === "touch" ) {
              removeClasses_(btnStatus, "ihmicomponent-large-radiomark-on ihmicomponent-large-radiomark-disabled ihmicomponent-large-radiomark-disabled-on");
            } else {
              removeClasses_(btnStatus, "ihmicomponent-small-radiomark-on ihmicomponent-small-radiomark-disabled ihmicomponent-small-radiomark-disabled-on");
            }
            addClass_(btnStatus, elem.getImageClass(config.designpattern, 'radiomark-off'));
          }
        }
        //Processing to switch image classes
        for (h = 0; h < options.length; h++) {
          btnStatus = findDescendant_(options[h], "ins", "list-select-mark");
          if (disabled === true) {
            if (hasClass_(options[h], "selected")) {
              replaceClass_(btnStatus,
                elem.getImageClass(config.designpattern,'radiomark-off'),
                elem.getImageClass(config.designpattern,'radiomark-disabled-on'));
            } else {
              replaceClass_(btnStatus,
                elem.getImageClass(config.designpattern,'radiomark-off'),
                elem.getImageClass(config.designpattern,'radiomark-disabled'));
            }
          } else {
            if (hasClass_(options[h], "selected")) {
              replaceClass_(btnStatus,
                elem.getImageClass(config.designpattern,'radiomark-off'),
                elem.getImageClass(config.designpattern,'radiomark-on'));
            }
          }
        }
      },
      setWidth: function() {
        var elem = this,
            config = elem.config,
            parentElem = elem.parentElement,
            ul = firstElementNode_(elem),
            liArray = findDescendants_(elem, 'li', 'list-select-option'),
            icon = findDescendant_(elem, 'div', 'list-select-option-left'),
            rightTextArray = findDescendants_(elem, 'div', 'list-select-option-right'),
            parentWidth = getWidth_(parentElem),
            rootWidth = getWidth_(elem),
            liStyle,
            rightTextStyle,
            liMarginLeft = 0,
            borderWidth = 0,
            textMarginLeft = 0,
            ulWidth = getWidth_(ul),
            liWidth = 0,
            iconWidth = getWidth_(icon),
            notTextWidth = 0,
            i = 0,
            len = 0;

        if (parentWidth === -1) {
          return;
        }
        if ((liArray.length == 0) ||
            (rightTextArray.length == 0)) {
          // no lisetSelectOption
          return;
        }
        liStyle = getCurrentStyle_(liArray[0]);
        rightTextStyle = getCurrentStyle_(rightTextArray[0]);
        if (rightTextStyle === null) {
          return;
        }
        textMarginLeft = parseInt(rightTextStyle.marginLeft, 10); //  between icon and text,
        liMarginLeft = parseInt(liStyle.marginLeft, 10);
        borderWidth = Math.ceil(parseFloat(liStyle.borderLeftWidth) * 2);
        if (ulWidth === 0) {
          ulWidth = (rootWidth == 0) ? parentWidth : rootWidth;
        }
        if (ulWidth <= 0) {
          return;
        }

        ulWidth = Math.floor(ulWidth);
        liWidth = Math.floor((ulWidth / liArray.length) - borderWidth);
        notTextWidth = liMarginLeft + iconWidth + textMarginLeft;
        for (i, len = liArray.length - 1; i < len; i++) {
          liArray[i].style.width = (liWidth - liMarginLeft) + 'px';
          rightTextArray[i].style.width = (liWidth - notTextWidth) + 'px';
          if (config.shrink) {
            adjustFontSize_(rightTextArray[i], config.defaultHeight);
          }
        }
        liWidth = ulWidth - ((liWidth + borderWidth) * len) - borderWidth;
        liArray[len].style.width = (liWidth - liMarginLeft) + 'px';
        rightTextArray[len].style.width = (liWidth - notTextWidth) + 'px';
        if (config.shrink) {
          adjustFontSize_(rightTextArray[len], config.defaultHeight);
        }
        config.widthAdjusted = true;
      },
      setTextWidth: function() {
        var elem = this,
            config = elem.config,
            liArray = findDescendants_(elem, 'li', 'list-select-option'),
            icon = findDescendant_(elem, 'div', 'list-select-option-left'),
            rightTextArray = findDescendants_(elem, 'div', 'list-select-option-right'),
            MARGIN_RIGHT = 8, //option right margin
            paddingLeft, paddingRight, textMarginLeft, width, i, len, style;

        if ((liArray.length === 0) ||
            (rightTextArray.length === 0)) {
          return;
        }
        style = getCurrentStyle_(rightTextArray[0]);
        if (style === null) {
          return;
        }

        textMarginLeft = parseInt(style.marginLeft , 10); //between icon - text,
        for (i = 0, len = liArray.length; i < len; i++) {
          style = getCurrentStyle_(liArray[i]);
          if (style === null) {
            return;
          }
          paddingLeft = parseInt(style.paddingLeft , 10); //option left paddin
          paddingRight = parseInt(style.paddingRight , 10); //option right paddin
          if (paddingRight === 0) {
            paddingRight = MARGIN_RIGHT;
          }
          width = liArray[i].clientWidth - paddingLeft - icon.clientWidth - textMarginLeft - paddingRight;
          if (width < 0) {
            return;
          }
          rightTextArray[i].style.width = width + 'px';
          if (config.shrink) {
            adjustFontSize_(rightTextArray[i], config.defaultHeight);
          }
        }
      },
      setIconPosition: function() {
        var root = this;
        var options = findDescendants_(root, "li", "list-select-option");
        var marginTop;
        var iconSize;
        var TP_ICON_SIZE = 24;
        var PC_ICON_SIZE = 10;
        var icon;
        var optionHeight = 0;
        iconSize = (root.config.designpattern == 'mouse')
                              ? PC_ICON_SIZE : TP_ICON_SIZE;
        for (var i= 0; i < options.length; i++) {
          /** window is null -> return -1 */
          optionHeight = getHeight_(options[i]);
          if (optionHeight === -1) {
            return;
          }
          marginTop = (optionHeight - iconSize) / 2;
          icon = findDescendant_(options[i], "ins", "list-select-mark");
          if (icon !== null) {
            icon.style.marginTop = marginTop + "px";
            if (getIEVersion_(userAgent) === 7 ) {
              icon.style.verticalAlign = "top";
            }
          }
        }
      },
      setHeight: function() {
        var root = this;
        var config = root.config;
        var tempHeight = 0;
        var rightTextArr = findDescendants_(root, "div", "list-select-option-right");
        var maxHeight = config.horizontal ? getMaxHeight(rightTextArr) : 0;

        if (!config.shrink) {
          return;
        }
        setListHeight(root, rightTextArr, maxHeight);
        function getMaxHeight(rightArr) {
          var maxHeight_ = 0;
          for (var i = 0; i < rightArr.length; i++) {
            /** window is null -> return -1 */
            tempHeight = getHeight_(rightArr[i]);
            if (maxHeight_ < tempHeight) {
              maxHeight_ = tempHeight;
            }
          }
          return maxHeight_;
        }
        function setListHeight(root_, rightArr, maxHeight_) {
          var options = findDescendants_(root_, "li", "list-select-option");
          var optionHeight = 0;
          var DEFAULT_HEIGHT = root_.config.defaultHeight;
          var i = 0;

          if (config.horizontal) {
            optionHeight = (DEFAULT_HEIGHT < maxHeight_)
                    ? parseFloat(maxHeight_) : DEFAULT_HEIGHT;
            for (i = 0; i < options.length; i++) {
              options[i].style.height = optionHeight + 'px';
            }
          } else {
            for (i = 0; i < options.length; i++) {
              /** window is null -> return -1 */
              tempHeight = getHeight_(rightArr[i]);
              optionHeight = (DEFAULT_HEIGHT < tempHeight)
                      ? parseFloat(tempHeight) : DEFAULT_HEIGHT;
              options[i].style.height = optionHeight + 'px';
            }
          }
        }
      },
      onclick: function(event) {
        var target = event.srcElement,
            doc = target.ownerDocument,
            frame = getDefaultView_(doc),
            li, ul, root, ins;
        switch (target.tagName) {
        case "INS":
          li = target.parentNode.parentNode;
          break;
        case "DIV":
          li = target.parentNode;
          break;
        case "LI":
          li = target;
          break;
        default:
          return true;
        }

        if (!hasClass_(li, 'list-select-option')) {
          return;
        }

        ul = li.parentNode;
        root = ul.parentNode;

        if (root.disabled) return true;

        if (!hasClass_(li, 'selected')) {
          addClassExclusively_(ul, li, 'selected');
          ins = findDescendant_(li, 'ins', 'list-select-mark');
          if (ins !== null) {
            replaceClassExclusively_(ul, ins, root.getImageClass(root.config.designpattern,'radiomark-off'), root.getImageClass(root.config.designpattern,'radiomark-on'));
          }
          frame.setTimeout(function() {
            if (typeof root.config.callback === 'function') {
              root.config.callback(root.id, "changed", li.getAttribute('data-value'));
            } else {
              IUIFRequest_(frame, { request: root.id + ".changed", value: li.getAttribute('data-value') }).send();
            }
          }, 100);
          return false;
        }
        return true;
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        if (event.keyCode === 13) {
          elem.click();
        }
      },
      turnOnOffTabindex: function(disabled) {
        var elem = this;
        var options = findDescendants_(elem, 'li', 'list-select-option');

        for (var i = 0; i < options.length; i++) {
          disabled ? options[i].removeAttribute("tabIndex")
                   : options[i].setAttribute("tabIndex", 0);
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if (!(hasClass_(elem,"list-select-option"))) {
          elem = findAncestor_(elem, "li", "list-select-option");
        }
        addClass_(elem, "focus");
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if (!(hasClass_(elem,"list-select-option"))) {
          elem = findAncestor_(elem, "li", "list-select-option");
        }
        removeClasses_(elem, "focus");
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      getImageClass: function(designpattern, className) {
        if (designpattern === "touch") {
          designpattern = 'large';
        } else if (designpattern === "mouse") {
          designpattern = 'small';
        } else {
          designpattern = null;
        }
        var imageClassName = 'ihmicomponent-' + designpattern + '-' + className;

        return imageClassName;
      },
      getValue: function() {
        var elem = this,
            li = null;
        if (hasClass_(elem, 'list-select')) {
          li = findDescendant_(elem, 'li', 'selected');
        }
        if (li === null) {
          return null;
        }
        return (li.getAttribute('data-value'));
      },
      adjustWidthHeight: function() {
        var elem = this;
        var config = elem.config;
        config.horizontal ? elem.setWidth()
                          : elem.setTextWidth();
        if (config.shrink) {
          elem.setHeight();
        }
        if (config.icon) {
          elem.setIconPosition();
        }
      }
    },
    funcKeyNext: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            image = doc.getElementById(elem.id + '.image'),
            root = ihmi.cf.findAncestor(elem, 'div', 'func-keys'),
            type = this;
        ihmi.funcKey.init(doc, id, config);
        ihmi.cf.addEventHandler(elem, 'click', type.onclick);
        if (root.children.length <= 1) {
          elem.disabled = true;
          ihmi.cf.addClass(elem, 'disabled', true);
          ihmi.cf.addClass(image, 'hide', true);
        }
      },
      onclick: function(event) {
        var elem = event.srcElement,
            findAncestor = ihmi.cf.findAncestor,
            root = findAncestor(elem, 'div', 'func-keys'),
            page = findAncestor(elem, 'div', 'func-key-page');
        if (!ihmi.cf.hasClass(elem, 'func-key-next')) {
          elem = findAncestor(elem, 'div', 'func-key-next');
        }
        if (elem.disabled) return false;
        if (!ihmi.cf.hasClass(elem, "hide")) {
          page.closeSelects();
          ihmi.cf.addClassExclusively(root, page, "hide");
        }
        return false;
      }
    },
    funcKeysConfirm: {
      init: function(doc, id, config) {
        var frame = ihmi.cf.getDefaultView(doc);
        ihmi.funcKeys.init(doc, id, config);
        ihmi.cf.KeyEvent.addHandler(function(event) {
          if (event.keyCode === 27) { // prev
            doc.getElementById("F5").click();
            return false;
          }
          return true;
        }, frame);
      }
    },
    funcKeysPopupClose: {
      init: function(doc, id, config) {
        var frame = ihmi.cf.getDefaultView(doc);
        ihmi.funcKeys.init(doc, id, config);
        ihmi.cf.KeyEvent.addHandler(function(event) {
          if (event.keyCode === 27) { // prev
            doc.getElementById("F5").click();
            return false;
          }
          return true;
        }, frame);
      }
    },
    wizardBar: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = ihmi.cf.getDefaultView(doc),
            type = this;
        elem.config = config;
        elem.refresh = type.refresh;
        elem.adjustWidth = type.adjustWidth;
        elem.setCallback = type.setCallback;
        ihmi.cf.addEventHandler(elem, "click", type.onclick);
        ihmi.cf.addEventHandler(frame, "resize", ihmi.cf.debounce(function(event) {
          try {
            elem.adjustWidth();
          } catch (e) {
            return;
          }
        }, 200));
      },
      refresh: function(steps, selected, disabled) {
        var elem = this,
            ul = ihmi.cf.firstElementNode(elem),
            html = [],
            classes,
            sumWidth,
            marginLeft = 0,
            marginRight = 0,
            li, i, len;
        var format = ihmi.cf.format;
        ihmi.cf.removeLastUndefined(steps);
        for (i = 0, len = steps.length; i < len; i++) {
          classes = [];
          if (steps[i].className) classes.push(steps[i].className);
          if (steps[i].value === selected) classes.push('selected');
          if (steps[i].disabled || disabled) classes.push('disabled');
          html.push(format('<li class="wizard-bar-step %s" data-value="%s" %s %s>',
                          classes.join(' '),
                          steps[i].value,
                          (steps[i].disabled || disabled) ? 'disabled' : '',
                          (typeof steps[i].attr === 'string') ? format('data-attr="%s"', steps[i].attr) : ''));
          html.push(format('<div class="wizard-bar-step-icon">'));
          html.push(format('<span class="wizard-bar-step-index">%s</span>', i + 1));
          html.push(format('<ins class="wizard-bar-step-icon-ins %s"></ins>',
                            steps[i].icon));
          html.push(format('</div>'));
          html.push(format('<span class="wizard-bar-step-label">%s</span>',
                            steps[i].text));
          html.push(format('<ins class="wizard-bar-step-trained ihmicomponent-step-complete"></ins>'));
          html.push(format('<ins class="wizard-bar-step-arrow %s"></ins>',
                            (i === 0) ? 'hide' : ''));
          html.push(format('</li>'));
        }
        ul.innerHTML = html.join('');
        sumWidth = 0;
        li = ihmi.cf.firstElementNode(ul);
        if (li) {
          marginLeft = parseInt(ihmi.cf.getCurrentStyle(li).marginLeft, 10);
          marginRight = parseInt(ihmi.cf.getCurrentStyle(li).marginRight, 10);
          for (; li !== null; li = ihmi.cf.nextElementNode(li)) {
            sumWidth += li.offsetWidth + marginLeft + marginRight;
          }
        }
        ul.style.width = sumWidth + 'px';
        elem.adjustWidth();
      },
      adjustWidth: function() {
        var elem = this,
            ul = ihmi.cf.firstElementNode(elem),
            elemWidth, ulWidth;
        elemWidth = elem.clientWidth;
        ulWidth = ul.scrollWidth;
        ul.style.left = ((ulWidth >= elemWidth) ? 0 : ((elemWidth - ulWidth) / 2)) + 'px';
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      onclick: function(event) {
        var elem = event.srcElement,
            frame = ihmi.cf.getDefaultView(elem.ownerDocument),
            root = ihmi.cf.findAncestor(elem, 'div', 'wizard-bar'),
            hasClass = ihmi.cf.hasClass,
            config = root.config;

        if (elem.tagName === "UL") return true;
        if (elem.tagName === "INS" && hasClass(elem, 'wizard-bar-step-arrow')) return true;
        if (elem.tagName === "DIV" || elem.tagName === "SPAN" || elem.tagName === "INS") {
          elem = ihmi.cf.findAncestor(elem, 'li', 'wizard-bar-step');
        }
        if ( elem !== null && hasClass(elem, "disabled")) return true;
        if ( elem !== null && elem.tagName === "LI" && !hasClass(elem, 'selected')) {
          ihmi.cf.addClassExclusively(root, elem, 'selected');

          if (typeof config.callback == 'function') {
            config.callback(root, elem.getAttribute('data-value'), elem.getAttribute('data-attr'), "selected");
          } else {
            frame.setTimeout(function() {
              ihmi.cf.IUIFRequest(frame, { request: root.id + ".selected", value: elem.getAttribute('data-value') }).send();
            }, 50);
          }
          return false;
        }
        return true;
      }
    },
    wizardSteps: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        elem.refresh = type.refresh;
        elem.getSelectedText = type.getSelectedText;
      },
      refresh: function(selected) {
        var elem = this,
            li, i;
            for (i = 0, li = ihmi.cf.firstElementNode(elem); li !== null; i++, li = ihmi.cf.nextElementNode(li)) {
          // Cannot use ihmi.cf.addClassExclusively(), because it will change substeps property.
          ihmi.cf.turnOnOffClass(li, 'selected', (i === selected));
        }
      },
      getSelectedText: function() {
        var elem = this,
            li;
        for (li = ihmi.cf.firstElementNode(elem); li !== null; li = ihmi.cf.nextElementNode(li)) {
          if (ihmi.cf.hasClass(li, 'selected')) {
            return ihmi.cf.getTextNode(ihmi.cf.firstElementNode(li)).nodeValue;
          }
        }
        return "";
      }
    },
    buttonToggleSidebar: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        config.onclick = true; // dummy property to avoid onclick being set.
        ihmi.button.init(doc, id, config);
        ihmi.cf.addEventHandler(elem, "click", type.onclick);
      },
      onclick: function (event) {
        var elem = event.srcElement,
            body = elem.ownerDocument.body;

        if ((elem.tagName === 'SPAN') || (elem.tagName === 'IMG')) {
          elem = elem.parentNode;
        }
        ihmi.cf.lightupBtnMoment(elem);
        if (ihmi.cf.hasClass(body, "sidebar-close")) {
          ihmi.cf.removeClass(body, "sidebar-close");
          elem.refresh("&laquo;", null, null, null, false, null);
        } else {
          ihmi.cf.addClass(body, "sidebar-close");
          elem.refresh("&raquo;", null, null, null, false, null);
        }
      }
    },
    slider: {
      globalConfig: {
        moveElement: null  // slide is moving -> true
      },
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this;
        var sliderGageArea = doc.getElementById(elem.id + "-gauge");
        var gaugeBase = doc.getElementById(elem.id + "-gauge-base");
        var upbtn = doc.getElementById(elem.id + "-upbtn");
        var plusVertical = doc.getElementById(elem.id + "-plus-vertical");
        var plusHorizontal = doc.getElementById(elem.id + "-plus-horizontal");
        var downbtn = doc.getElementById(elem.id + "-downbtn");
        var minus = doc.getElementById(elem.id + "-minus");
        var elemMin = doc.getElementById(elem.id + "-min");
        var elemMax = doc.getElementById(elem.id + "-max");
        var addEventHandler = ihmi.cf.addEventHandler;
        var sliderHandle = doc.getElementById(elem.id + "-handle");
        var elemCurrentValPos = doc.getElementById(elem.id + "-current-val-pos");
        var elemCurrentVal = doc.getElementById(elem.id + "-current-val");
        var rectLefMag = 1.0;
        var touchMagnification = 1.0;
        var VGA_TO_XGA = 1.53;
        var zoomFactor = ihmi.cf.getZoomFactor(elem);

        elem.config = config;
        config.min = (config.min === null || config.min === undefined) ? 1 : config.min;
        config.max = (config.max === null || config.max === undefined) ? 100 : config.max;
        elemMin.innerText = config.min;
        elemMax.innerText = config.max;
        elem.refresh = type.refresh;
        elem.getValue = type.getValue;
        elem.setCallback = type.setCallback;
        elem.adjustGauge = type.adjustGauge;
        elem.onmovegaugeBase = type.onmovegaugeBase;
        elem.onstartgaugeBase = type.onstartgaugeBase;
        elem.onendgaugeBase = type.onendgaugeBase;
        elem.canMoveSlide = type.canMoveSlide;
        elem.resetGlobalConfigSliderElement = type.resetGlobalConfigSliderElement;
        elem.step = 1;
        gaugeBase.min = parseInt(config.min, 10);
        gaugeBase.max = parseInt(config.max, 10);
        gaugeBase.setValue = type.setValue;
        gaugeBase.sliderValue = gaugeBase.min;
        gaugeBase.presentValue = gaugeBase.sliderValue;
        gaugeBase.notifyChanged = true;
        gaugeBase.setValue(gaugeBase);
        plusVertical.mark = "plusMinus";
        plusHorizontal.mark = "plusMinus";
        minus.mark = "plusMinus";
        downbtn.disabled = true;
        upbtn.tabIndex = -1;
        config.clickGauge = (config.clickGauge !== undefined) ?
          ihmi.cf.parseStrToBoolean(config.clickGauge) : true;
        config.rangeValDisplay = ihmi.cf.parseStrToBoolean(config.rangeValDisplay);
        config.currentValDisplay = ihmi.cf.parseStrToBoolean(config.currentValDisplay);

        ihmi.cf.turnOnOffClass(downbtn, 'disabled', true);

        // VGA -> XGA, 1.53 times in original size.
        if (zoomFactor !== 1) {
          if (ihmi.cf.isiPendant()) {
            touchMagnification = VGA_TO_XGA;
            rectLefMag = VGA_TO_XGA;
          } else {
            rectLefMag = VGA_TO_XGA;
          }
        }
        elem.config.rectLefMag = rectLefMag;
        elem.config.touchMagnification = touchMagnification;

        if (config.rangeValDisplay) {
          ihmi.cf.removeClass(elemMin, "hide");
          ihmi.cf.removeClass(elemMax, "hide");
          ihmi.cf.addClass(elem, "ihcp-slider-rangevaldisp");
        }
        if (config.currentValDisplay) {
          ihmi.cf.removeClass(elemCurrentValPos, "hide");
          elemCurrentVal.innerText = config.max;
        }
        if (config.clickGauge) {
          addEventHandler(gaugeBase, "click", type.onclickgaugeBase);
        } else {
          gaugeBase.style.cursor = 'default';
          sliderHandle.style.cursor = 'pointer';
        }
        addEventHandler(upbtn, "focus", type.onfocus);
        addEventHandler(plusVertical, "focus", type.onfocus);
        addEventHandler(plusHorizontal, "focus", type.onfocus);
        addEventHandler(downbtn, "focus", type.onfocus);
        addEventHandler(minus, "focus", type.onfocus);
        addEventHandler(upbtn, "blur", type.onblur);
        addEventHandler(plusVertical, "blur", type.onblur);
        addEventHandler(plusHorizontal, "blur", type.onblur);
        addEventHandler(downbtn, "blur", type.onblur);
        addEventHandler(minus, "blur", type.onblur);
        addEventHandler(upbtn, "keypress", type.onkeypressBtn);
        addEventHandler(downbtn, "keypress", type.onkeypressBtn);

        if (ihmi.cf.getIEVersion(window.navigator.userAgent) === 7) {
          config.onselectstart = function(event) {
            return false;
          };
          addEventHandler(sliderGageArea, "selectstart", config.onselectstart);
        }
        // judge device
        if (!ihmi.cf.isiPendant()) { // not iPendant -> use PC, tablet
          addEventHandler(sliderHandle, "touchstart", type.onstartgaugeBase);
          addEventHandler(sliderHandle, "mousedown", type.onstartgaugeBase);
        } else {  // use iPendant and not tablet
          ihmi.cf.addClass(sliderHandle, "hide");
        }
        if (ihmi.global.isiPad) {
          addEventHandler(upbtn, "touchend", type.onclickBtn);
          addEventHandler(downbtn, "touchend", type.onclickBtn);
        } else {
          addEventHandler(upbtn, "click", type.onclickBtn);
          addEventHandler(downbtn, "click", type.onclickBtn);
        }
        elem.adjustGauge(elem, doc);
      },
      adjustGauge: function(root, doc) {
        if (ihmi.cf.isiPendant()) {
          ihmi.cf.addClass(root, "ihcp-ipendant");
        }
      },
      refresh: function(sliderValue, disabled, argObj) {
        var elem = this;
        var doc = elem.ownerDocument;
        var elemMin = doc.getElementById(elem.id + "-min");
        var elemMax = doc.getElementById(elem.id + "-max");
        var gaugeBase = doc.getElementById(elem.id + "-gauge-base");
        var elemCurrentVal = doc.getElementById(elem.id + "-current-val");

        if (disabled != null){
          elem.disabled = disabled;
          ihmi.cf.turnOnOffClass(elem, 'disabled', disabled);
        }

        if (sliderValue != undefined) {
          gaugeBase.sliderValue = parseInt(sliderValue, 10);
          gaugeBase.notifyChanged = false;
          gaugeBase.setValue(gaugeBase);
          gaugeBase.notifyChanged = true;
          if (elem.config.currentValDisplay) {
            elemCurrentVal.innerText = gaugeBase.sliderValue;
          }
        }

        if (argObj == undefined) {
          argObj = {};
        }

        if (argObj.step != undefined) {
          elem.step = Math.abs(argObj.step);
        }

        if (argObj.min != undefined) {
          elemMin.innerText = argObj.min;
          gaugeBase.min = parseInt(argObj.min, 10);
          if (sliderValue == undefined) {
            gaugeBase.sliderValue = gaugeBase.min;
          }
        }
        if (argObj.max != undefined) {
          elemMax.innerText = argObj.max;
          gaugeBase.max = parseInt(argObj.max, 10);
        }
      },
      onclickgaugeBase: function(event) {
        var gaugeBase = event.srcElement;
        var root = ihmi.cf.findAncestor(gaugeBase, 'div', 'ihcp-slider');
        // that click a handle don't move.
        if (ihmi.cf.hasClass(gaugeBase, "ihcp-slider-handle")) {
          return;
        }
        // class of root doesn't contain disable : true
        // class of root contains disable : false
        if (!root.canMoveSlide(root)) {
          return;
        }
        ihmi.slider.globalConfig.moveElement = root;
        root.config.dragging = true;
        root.onmovegaugeBase(event);
        root.onendgaugeBase(event);
      },
      onstartgaugeBase: function (event) {
        var gaugeBase = event.srcElement;
        var addEventHandler = ihmi.cf.addEventHandler;
        var root = ihmi.cf.findAncestor(gaugeBase, 'div', 'ihcp-slider');
        var doc = gaugeBase.ownerDocument;
        var frame = ihmi.cf.getDefaultView(doc);
        var eventType = ((getIEVersion_(userAgent) !== -1) && (getIEVersion_(userAgent) < 11)) ? "unload" : "pagehide";

        if (ihmi.slider.globalConfig.moveElement !== null) {
          return;
        }
        // class of root doesn't contain disable : true
        // class of root contains disable : false
        if (!root.canMoveSlide(root)) {
          return;
        }
        // stop a scroll move a moving slider causes.
        preventBrowserDefault_(event);
        root.config.dragging = true;
        ihmi.slider.globalConfig.moveElement = root;
        if (event.type.indexOf('touch') === 0) {
          addEventHandler(doc.body, "touchmove", root.onmovegaugeBase);
          addEventHandler(doc.body, "touchend", root.onendgaugeBase);
          addEventHandler(doc.body, "touchcancel", root.onendgaugeBase);
        } else {
          addEventHandler(doc.body, "mousemove", root.onmovegaugeBase);
          addEventHandler(doc.body, "mouseup", root.onendgaugeBase);
          addEventHandler(doc.body, "mouseleave", root.onendgaugeBase);
        }
        addEventHandler(frame, eventType, root.resetGlobalConfigSliderElement);
      },
      onmovegaugeBase: function (event) {
        var root = ihmi.slider.globalConfig.moveElement;
        var sliderElem = ihmi.cf.findDescendant(root, "div", "ihcp-slider-outgauge");
        var doc = root.ownerDocument;
        var curGageX = event.clientX;
        var curGageY;
        var curElem;
        var rect;
        var sliderValue;
        var sliderMagnification;
        // stop a scroll move a moving slider causes.
        preventBrowserDefault_(event);
        /**
         * [#15565] Remove in the move event
         *           because the end event does not occur outside the viewport
         *           when a touch operation is performed
         */
        if (event.type === "touchmove") {
          // event.type === "touchend" -> event.touches[0] is null.
          curGageX = event.touches[0].clientX;
          curGageY = event.touches[0].clientY;
          // "MEMO-073 bar" -> null, Robot Operation -> object HTMLElement, when use tablet
          curElem = doc.elementFromPoint(curGageX, curGageY);
          if (curElem === null) {
            root.onendgaugeBase(event);
            return false;
          }
        }
        if (root.config.dragging) {
          sliderMagnification = sliderElem.clientWidth / 101;
          rect = sliderElem.getBoundingClientRect();
          /**
           * (curGageX * touchMagnification) is the coordinate value of the touched(clicked) position,
           * (rect.left * rectLefMag) is gauge leftmost coordinate value,
           * slidermagnification is a value which is dividing the gauge width by "100",
           * This expression calculates the value of the slider.
           */
          sliderValue = Math.round(((curGageX * root.config.touchMagnification) - (rect.left * root.config.rectLefMag))/sliderMagnification);
          /* This expression recalculates the value of the slider if max value and min value is specified. */
          // "max - min" -> length ratio, expand or shrink.
          sliderValue = Math.round((sliderElem.min + sliderValue * (sliderElem.max - sliderElem.min) / 100) * 10) /10;

          if (sliderValue < sliderElem.min) {
            sliderValue = sliderElem.min;
          } else if (sliderValue > sliderElem.max) {
            sliderValue = sliderElem.max;
          }
          sliderElem.sliderValue = sliderValue;

          sliderElem.setValue(sliderElem);
        }
      },
      onendgaugeBase: function (event) {
        var removeEventHandler = ihmi.cf.removeEventHandler;
        // root is component element.
        var root = ihmi.slider.globalConfig.moveElement;
        var gaugeBase = ihmi.cf.findDescendant(root, "div", "ihcp-slider-outgauge");
        // drugEvent set in ownerDocument.
        var doc = root.ownerDocument;
        var frame = ihmi.cf.getDefaultView(root.ownerDocument);
        var sliderValue = gaugeBase.sliderValue;
        var eventType = ((getIEVersion_(userAgent) !== -1) && (getIEVersion_(userAgent) < 11)) ? "unload" : "pagehide";

        if (event.type.indexOf('touch') === 0) {
          removeEventHandler(doc.body, "touchmove", root.onmovegaugeBase);
          removeEventHandler(doc.body, "touchend", root.onendgaugeBase);
          removeEventHandler(doc.body, "touchcancel", root.onendgaugeBase);
        } else {
          removeEventHandler(doc.body, "mousemove", root.onmovegaugeBase);
          removeEventHandler(doc.body, "mouseup", root.onendgaugeBase);
          removeEventHandler(doc.body, "mouseleave", root.onendgaugeBase);
        }
        removeEventHandler(frame, eventType, root.resetGlobalConfigSliderElement);

        root.config.dragging = false;
        if (gaugeBase.presentValue !== sliderValue && gaugeBase.notifyChanged === true) {
          if (typeof root.config.callback === 'function') {
            root.config.callback(root.id, "clicked", sliderValue);
          } else {
            ihmi.cf.IUIFRequest(frame, { request: root.id + ".clicked", value: sliderValue }).send();
          }
          gaugeBase.presentValue = sliderValue;
        }
        ihmi.slider.globalConfig.moveElement = null;
      },
      onclickBtn: function(event) {
        var elem = event.srcElement;
        var doc = elem.ownerDocument;
        var root = ihmi.cf.findAncestor(elem, 'div', 'ihcp-slider');
        var idname;
        var elemParent;
        var elemParentName;
        var countupdown;
        var gaugeBase;
        var rootName;

        if (ihmi.cf.hasClass(event.srcElement, "ihcp-slider-handle")) {
          return;
        }
        if (ihmi.cf.hasClass(root, 'disabled')) {
          // stop a scroll move a moving slider causes.
          preventBrowserDefault_(event);
          return false;
        }
        if (elem.mark === "plusMinus") {
          elem = elem.parentNode;
          elem.focus();
        }
        if (ihmi.cf.hasClass(elem, "ihcp-slider-ingauge")) {
          rootName = elem.id.replace("-gauge-on", "");
          elem = doc.getElementById(rootName + "-downbtn");
        } else if (ihmi.cf.hasClass(elem, "ihcp-slider-outgauge")){
          rootName = elem.id.replace("-gauge-base", "");
          elem = doc.getElementById(rootName + "-upbtn");
        } else {
          ihmi.cf.lightupBtnMoment(elem);
        }

        idname = elem.id;

        if (idname.indexOf("downbtn") != -1) {
          elemParentName = idname.replace("-downbtn", "");
        } else {
          elemParentName = idname.replace("-upbtn", "");
        }

        elemParent = doc.getElementById(elemParentName);
        gaugeBase = doc.getElementById(elemParentName + "-gauge-base");
        root = ihmi.cf.findAncestor(gaugeBase, 'div', 'ihcp-slider');
        root.config.dragging = false;
        countupdown = elemParent.step;

        if (idname.indexOf("downbtn") != -1) {
          if ((gaugeBase.sliderValue - countupdown) < gaugeBase.min) {
            gaugeBase.sliderValue = gaugeBase.min;
          } else {
            gaugeBase.sliderValue = gaugeBase.sliderValue - countupdown;
          }
        } else {
          if ((gaugeBase.sliderValue + countupdown) > gaugeBase.max) {
            gaugeBase.sliderValue = gaugeBase.max;
          } else {
            gaugeBase.sliderValue = gaugeBase.sliderValue + countupdown;
          }
        }

        gaugeBase.setValue(gaugeBase);
      },
      onblur: function(event) {
        var elem = event.srcElement;
        if (elem.mark === "plusMinus") {
          elem = elem.parentNode;
        }
        ihmi.cf.removeClass(elem, "focus");

        return false;
      },
      onfocus: function(event) {
        var elem = event.srcElement;
        if (elem.mark === "plusMinus") {
          elem = elem.parentNode;
          elem.focus();
        }
        ihmi.cf.addClasses(elem, "focus");

        return false;
      },
      onkeypressBtn: function(event) {
        var elem = event.srcElement;
        if (event.keyCode === 13) {
          elem.click();
        }
      },
      setValue: function(element) {
        var elem = element;
        var doc = elem.ownerDocument;
        var gaugeBase = doc.getElementById(elem.id);
        var root = ihmi.cf.findAncestor(gaugeBase, 'div', 'ihcp-slider');
        var idname = elem.id;
        var frame = ihmi.cf.getDefaultView(root.ownerDocument);
        var gaugeOn;
        var gaugeOnName;
        var sliderRange;
        var sliderValue = elem.sliderValue;
        var upBtn = doc.getElementById(root.id + "-upbtn");
        var plusVertical = doc.getElementById(elem.id + "-plus-vertical");
        var plusHorizontal = doc.getElementById(elem.id + "-plus-horizontal");
        var downBtn = doc.getElementById(root.id + "-downbtn");
        var minus = doc.getElementById(elem.id + "-minus");
        var sliderHandle = doc.getElementById(root.id + "-handle");
        var elemCurrentVal = doc.getElementById(root.id + "-current-val");

        if (sliderValue == elem.max) {
          downBtn.disabled = false;
          downBtn.tabIndex = 0;
          ihmi.cf.turnOnOffClass(downBtn, 'disabled', false);
          if ((doc.activeElement == upBtn) || (doc.activeElement == plusVertical) || (doc.activeElement == plusHorizontal)) {
            downBtn.focus();
          }
          upBtn.disabled = true;
          upBtn.tabIndex = -1;
          ihmi.cf.turnOnOffClass(upBtn, 'disabled', true);
          setTimeout(function() {//for tp, need setTimeout.
            ihmi.cf.removeClass(upBtn, "focus");
          }, 0);
        } else if (sliderValue == elem.min) {
          upBtn.disabled = false;
          upBtn.tabIndex = 0;
          ihmi.cf.turnOnOffClass(upBtn, 'disabled', false);
          if ((doc.activeElement == downBtn) || (doc.activeElement == minus)) {
            upBtn.focus();
          }
          downBtn.disabled = true;
          downBtn.tabIndex = -1;
          ihmi.cf.turnOnOffClass(downBtn, 'disabled', true);
          setTimeout(function() {//for tp, need setTimeout.
            ihmi.cf.removeClass(downBtn, "focus");
          }, 0);
        } else {
          upBtn.disabled = false;
          upBtn.tabIndex = 0;
          ihmi.cf.turnOnOffClass(upBtn, 'disabled', false);
          downBtn.disabled = false;
          downBtn.tabIndex = 0;
          ihmi.cf.turnOnOffClass(downBtn, 'disabled', false);
        }

        if (root.config.currentValDisplay) {
          elemCurrentVal.innerText = parseInt(sliderValue, 10);
        }
        sliderRange = sliderValue;

        /* This expression converts the value of the slider to the ratio of the gauge width. */
        sliderRange = (sliderRange - elem.min) / (elem.max - elem.min) * 100;

        gaugeOnName = idname.replace("-base", "-on");
        gaugeOn = doc.getElementById(gaugeOnName);

        gaugeOn.style.width = sliderRange + "%";
        //Adjust the position of the knob button.
        sliderHandle.style.left = sliderRange + "%";

        if (elem.presentValue !== elem.sliderValue && elem.notifyChanged === true && !root.config.dragging) {
          if (typeof root.config.callback === 'function') {
            root.config.callback(root.id, "clicked", elem.sliderValue);
          } else {
            ihmi.cf.IUIFRequest(frame, { request: root.id + ".clicked", value: elem.sliderValue }).send();
          }
          gaugeBase.presentValue = gaugeBase.sliderValue;
        }
      },
      getValue: function() {
        var elem = this;
        var doc = elem.ownerDocument;
        var gaugeBase = doc.getElementById(elem.id + "-gauge-base");
        return gaugeBase.sliderValue;
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      /**
       * when slide is disabled, slide is able to move on ie7.
       * class of root doesn't contain disable -> true
       * class of root contains disable -> false
       * @param {Object} root
       * @returns {Boolean} true  -> slider is disabled.
       *                    false -> slider is not disabled.
       */
      canMoveSlide: function(root) {
        if (ihmi.cf.hasClass(root, 'disabled')) {
          return false;
        }
        return true;
      },
      resetGlobalConfigSliderElement: function() {
        ihmi.slider.globalConfig.moveElement = null;
      }
    },
    accordion: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            type = this,
            openMode;
        elem.config = config;
        openMode = ihmi.cf.parseStrToBoolean(config.openMode);
        elem.setOpenMode = type.setOpenMode;

        ihmi.cf.determineDefaultDesignPattern(elem);
        if (ihmi.global.isiPad) {
          ihmi.cf.addEventHandler(elem, "touchend", type.onclick);
        } else {
          ihmi.cf.addEventHandler(elem, "click", type.onclick);
        }
        elem.setOpenMode(openMode);
      },
      onclick: function(event) {
        var target = ihmi.cf.findAncestor(event.srcElement, "div", "accordion-header");
        if (ihmi.cf.hasClass(event.srcElement, "accordion-header")) {
          return true;
        }
        target.setOpenMode(!target.config.openMode);
        return false;
      },
      setOpenMode: function(openMode) {
        var elem = this;
        var hideElem = ihmi.cf.findDescendant(elem.parentNode, "div", "accordion-style");
        var img = ihmi.cf.findDescendant(elem, "div", "accordion-img");
        if (openMode) {
          if (ihmi.cf.hasClass(img, "close")) {
            ihmi.cf.replaceClass(img, "close", "open");
          } else {
            ihmi.cf.addClass(img, "open");
          }
          ihmi.cf.removeClass(hideElem, "hide");
        } else {
          if (ihmi.cf.hasClass(img, "open")) {
            ihmi.cf.replaceClass(img, "open", "close");
          } else {
            ihmi.cf.addClass(img, "close");
          }
          ihmi.cf.addClass(hideElem, "hide");
        }
        elem.config.openMode = openMode;
      }
    },
    radioButton: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id),
            frame = getDefaultView_(doc),
            type = this,
            options = findDescendants_(elem, "li", "radio-button-option"),
            DEF_HEIGHT_TOUCH = 54,
            DEF_HEIGHT_MOUSE = 28;
        elem.config = config;

        determineDefaultDesignPattern_(elem);
        if (config.horizontal === "true") {
          config.horizontal = true;
          config.widthAdjusted = false;
        } else {
          if ("horizontal" in config) {
            alert(format_('[radioButton] invalid horizontal value "%s"', config.horizontal));
          }
          config.horizontal = false;
        }
        config.shrink = ((getIEVersion_(userAgent) > 10) ||
                         (getIEVersion_(userAgent) === -1))
                          ? parseStrToBoolean_(config.shrink)
                          : false;
        if (config.shrink) addClass_(elem, 'radio-button-shrink');
        if (options.length > 0) {
          config.defaultHeight = parseFloat(getCurrentStyle_(options[0]).height);
        } else {
          // no radioButtonOption
          config.defaultHeight = (config.designpattern === "touch" ? DEF_HEIGHT_TOUCH : DEF_HEIGHT_MOUSE);
        }

        elem.config = config;
        elem.refresh = type.refresh;
        elem.setWidth = type.setWidth;
        elem.setCallback = type.setCallback;
        elem.turnOnOffTabindex = type.turnOnOffTabindex;
        elem.setTextWidth = type.setTextWidth;
        elem.setIconPosition = type.setIconPosition;
        elem.getImageClass = type.getImageClass;
        elem.getValue = type.getValue;
        elem.formatImageClass = type.formatImageClass;
        elem.getImage = type.getImage;
        elem.setHeight = type.setHeight;
        elem.adjustWidthHeight = type.adjustWidthHeight;
        elem.addEventOptions = type.addEventOptions;

        elem.addEventOptions();
        addEventHandler_(frame, "load", resizeWidth);
        addEventHandler_(frame, "load", function() {
          addEventHandler_(frame, "resize", debounce_(resizeWidth, 200));
        });
        function resizeWidth() {
          elem.adjustWidthHeight();
        }
      },
      refresh: function(options, selected, disabled) {
        var elem = this,
            ul = firstElementNode_(elem),
            config = elem.config,
            html = [],
            i, len, li, icon, optionLeft,addClass,btnStatus;
        if (options === null) {
          for (li = firstElementNode_(ul); li !== null; li = nextElementNode_(li)) {
            if (li.getAttribute('data-value') === selected || parseInt(li.getAttribute('data-value'), 10) === selected) {
              addClassExclusively_(ul, li, 'selected');
              break;
            }
          }
        } else {
          removeLastUndefined_(options);
          optionLeft = '<div tabindex="0" class="radio-button-option-left">';
          icon = '<ins class="radio-button-mark %s"></ins>';
          for (i = 0, len = options.length; i < len; i++) {
            addClass = '';
            if (options[i].className !== undefined && options[i].className !== null) {
              addClass = options[i].className;
            }

            if ( options[i].value === selected) {
              addClass += ' selected';
            }
            html.push(format_('<li class="radio-button-option %s" data-value="%s" >' + optionLeft + icon + '</div><div class="radio-button-option-right"><span>%s</span></div></li>',
                            addClass, options[i].value, elem.getImageClass('radiomark-off'), options[i].text));
          }
          ul.innerHTML = html.join('');
          config.widthAdjusted = true;
          elem.setIconPosition();
          setTimeout(function() {
            elem.addEventOptions();
          }, 0);
        }
        if (config.horizontal) {
          elem.setWidth();
        }

        setTimeout(function() {
          elem.setTextWidth();
        }, 0);

        //If this is not defined, elem.disabled = false (IE), elem.disabled = undefined (Chrome).
        elem.disabled = (disabled === true);
        turnOnOffClass_(elem, 'disabled', disabled);
        elem.turnOnOffTabindex(disabled);

        //Initialize the image class.
        elem.formatImageClass(elem);

        //Processing to switch image classes
        if (disabled === true) {
          options = findDescendants_(elem, "li", "radio-button-option");
          for (var h = 0; h < options.length; h++) {
            btnStatus = findDescendant_(options[h], "ins", "radio-button-mark");
            if (hasClass_(options[h], 'selected')) {
              replaceClass_(btnStatus,elem.getImageClass('radiomark-off'),elem.getImageClass('radiomark-disabled-on'));
            } else {
              replaceClass_(btnStatus,elem.getImageClass('radiomark-off'),elem.getImageClass('radiomark-disabled'));
            }
          }
        } else {
          elem.getImage(elem);
        }
      },
      setWidth: function() {
        var elem = this,
            config = elem.config,
            parentElem = elem.parentElement,
            ulElem = firstElementNode_(elem),
            liArray = findDescendants_(elem, 'li', 'radio-button-option'),
            icon = findDescendant_(elem, 'div', 'radio-button-option-left'),
            rightTextArray = findDescendants_(elem, 'div', 'radio-button-option-right'),
            offset = 4, // this value depends on margin-left-width
            parentWidth = getWidth_(parentElem),
            rootWidth = getWidth_(elem),
            rightTextStyle,
            ulWidth = getWidth_(ulElem),
            liWidth = 0,
            iconWidth = getWidth_(icon),
            i = 0,
            len = 0,
            textMarginLeft = 0,
            textWidth = 0,
            adjustWidth = 0;

        if (parentWidth === -1) {
          return;
        }
        if ((liArray.length == 0) ||
            (rightTextArray.length == 0)) {
          // no radioButtonOption
          return;
        }
        rightTextStyle = getCurrentStyle_(rightTextArray[0]);
        if (rightTextStyle === null) {
          return;
        }
        textMarginLeft = parseInt(rightTextStyle.marginLeft, 10); //between icon - text
        if (ulWidth === 0) {
          ulWidth = (rootWidth == 0) ? parentWidth : rootWidth;
        }
        if (ulWidth <= 0) {
          return;
        }
        ulWidth = Math.floor(ulWidth);
        liWidth = Math.floor(ulWidth / liArray.length);
        textWidth = liWidth - offset - iconWidth - textMarginLeft;
        adjustWidth = (textWidth < 0) ? 0 : textWidth;

        for (i, len = liArray.length - 1; i < len; i++) {
          liArray[i].style.width = (liWidth - offset) + 'px';
          rightTextArray[i].style.width = adjustWidth + 'px';
          if (config.shrink) {
            adjustFontSize_(rightTextArray[i], config.defaultHeight);
          }
        }
        liArray[len].style.width = (ulWidth - (liWidth * len) - offset) + 'px';
        rightTextArray[len].style.width = adjustWidth + 'px';
        if (config.shrink) {
          adjustFontSize_(rightTextArray[len], config.defaultHeight);
        }

        config.widthAdjusted = true;
      },
      setTextWidth: function() {
        var elem = this,
            config = elem.config,
            liArray = findDescendants_(elem, 'li', 'radio-button-option'),
            icon = findDescendant_(elem, 'div', 'radio-button-option-left'),
            rightTextArray = findDescendants_(elem, 'div', 'radio-button-option-right'),
            MARGIN_RIGHT = 8, //option right margin
            paddingLeft, paddingRight, textMarginLeft, width, i, len, style;
        if (liArray.length === 0 || rightTextArray.length === 0) return;
        style = getCurrentStyle_(rightTextArray[0]);
        if (style === null) {
          return;
        }
        textMarginLeft = parseInt(style.marginLeft , 10); //between icon - text,
        for (i = 0, len = liArray.length; i < len; i++) {
          style = getCurrentStyle_(liArray[i]);
          if (style === null) {
            return;
          }
          paddingLeft = parseInt(style.paddingLeft , 10); //option left paddin
          paddingRight = parseInt(style.paddingRight , 10); //option right paddin
          if (paddingRight === 0) {
            paddingRight = MARGIN_RIGHT;
          }
          width = liArray[i].clientWidth - paddingLeft - icon.clientWidth - textMarginLeft - paddingRight;
          if (width < 0) {
            return;
          }
          rightTextArray[i].style.width = width + 'px';
          if (config.shrink) {
            adjustFontSize_(rightTextArray[i], config.defaultHeight);
          }
        }
      },
      setIconPosition: function() {
        var root = this;
        var options = findDescendants_(root, "li", "radio-button-option");
        var marginTop;
        var iconSize;
        var LARGE_ICON_SIZE = 24;
        var icon;
        var optionHeight = 0;

        iconSize = LARGE_ICON_SIZE;
        for (var i = 0; i < options.length; i++) {
          /** window is null -> return -1 */
          optionHeight = getHeight_(options[i]);
          if (optionHeight == -1) {
            break;
          }
          marginTop = (optionHeight - iconSize) / 2;
          icon = findDescendant_(options[i], "ins", "radio-button-mark");
          if (icon !== null) {
            icon.style.marginTop = marginTop + "px";
            if (getIEVersion_(userAgent) === 7 ) {
              icon.style.verticalAlign = "top";
            }
          }
        }
      },
      setHeight: function() {
        var root = this;
        var config = root.config;
        var tempHeight = 0;
        var rightTextArr = findDescendants_(root, "div", "radio-button-option-right");
        var maxHeight = config.horizontal ? getMaxHeight(rightTextArr) : 0;

        if (!config.shrink) {
          return;
        }
        setBtnHeight(root, rightTextArr, maxHeight);
        function getMaxHeight(rightArr) {
          var maxHeight_ = 0;
          for (var i = 0; i < rightArr.length; i++) {
            /** window is null -> return -1 */
            tempHeight = getHeight_(rightArr[i]);
            if (maxHeight_ < tempHeight) {
              maxHeight_ = tempHeight;
            }
          }
          return maxHeight_;
        }
        function setBtnHeight(root_, rightArr, maxHeight_) {
          var options = findDescendants_(root_, "li", "radio-button-option");
          var optionHeight = 0;
          var DEFAULT_HEIGHT = root_.config.defaultHeight;
          var i = 0;

          if (config.horizontal) {
            optionHeight = (DEFAULT_HEIGHT < maxHeight_)
                      ? parseFloat(maxHeight_) : DEFAULT_HEIGHT;
            for (i = 0; i < options.length; i++) {
              options[i].style.height = optionHeight + 'px';
            }
          } else {
            for (i = 0; i < options.length; i++) {
              /** window is null -> return -1 */
              tempHeight = getHeight_(rightArr[i]);
              optionHeight = (DEFAULT_HEIGHT < tempHeight)
                      ? parseFloat(tempHeight) : DEFAULT_HEIGHT;
              options[i].style.height = optionHeight + 'px';
            }
          }
        }
      },
      onclick: function(event) {
        var target = event.srcElement,
            doc = target.ownerDocument,
            frame = getDefaultView_(doc),
            li = findAncestor_(target, 'li', 'radio-button-option'),
            ul, root, ins;

        if (!hasClass_(li, 'radio-button-option')) {
          return;
        }

        ul = li.parentNode;
        root = findAncestor_(ul, 'div', 'radio-button');

        if (root.disabled) return true;

        li.children[0].focus(); // Using triggerEvent(), onblur() not occur.
        if (!hasClass_(li, 'selected')) {
          addClassExclusively_(ul, li, 'selected');
          ins = findDescendant_(li, 'ins', 'radio-button-mark');
          if (ins !== null) {
            root.formatImageClass(root);
            root.getImage(root);
          }

          frame.setTimeout(function() {
            if (typeof root.config.callback === 'function') {
              root.config.callback(root.id, "changed", li.getAttribute('data-value'));
            } else {
              IUIFRequest_(frame, { request: root.id + ".changed", value: li.getAttribute('data-value') }).send();
            }
          }, 100);
          return false;
        }
        return true;
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        if (event.keyCode === 13) {
          elem.click();
        }
      },
      turnOnOffTabindex: function(disabled) {
        var elem = this;
        var options = findDescendants_(elem, 'div', 'radio-button-option-left');

        for (var i = 0; i < options.length; i++) {
          if (disabled) {
            options[i].removeAttribute("tabIndex");
          } else if (!disabled) {
            options[i].setAttribute("tabIndex", 0);
          }
        }
      },
      onfocus: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, "div", "radio-button");
        if (!(hasClass_(elem, "radio-button-option"))) {
          elem = findAncestor_(elem, "li", "radio-button-option");
        }
        addClass_(elem, "focus");
        root.formatImageClass(root);
        root.getImage(root);
      },
      onblur: function(event) {
        var elem = event.srcElement,
            root = findAncestor_(elem, "div", "radio-button");
        elem = findAncestor_(elem, "li", "radio-button-option");
        removeClasses_(elem, "focus");
        if (!hasClass_(root,"disabled")) {
          root.formatImageClass(root);
          root.getImage(root);
        }
      },
      formatImageClass: function(root) {
        var options = findDescendants_(root, "li", "radio-button-option"),
            icon;
        for (var i = 0; i < options.length; i++) {
          icon = findDescendant_(options[i], "ins", "radio-button-mark");
          removeClasses_(icon, "ihmicomponent-large-radiomark-focus ihmicomponent-large-radiomark-on ihmicomponent-large-radiomark-focus-on ihmicomponent-large-radiomark-disabled ihmicomponent-large-radiomark-disabled-on");
          addClass_(icon, root.getImageClass('radiomark-off'));
        }
      },
      getImage: function(root) {
        var options = findDescendants_(root, "li", "radio-button-option"),
            icon;
        for (var i = 0; i < options.length; i++) {
          icon = findDescendant_(options[i], "ins", "radio-button-mark");
          if (hasClass_(options[i],"selected")) {
            if (hasClass_(options[i],"focus")) {
              replaceClass_(icon, root.getImageClass('radiomark-off'), root.getImageClass('radiomark-focus-on'));
            } else {
              replaceClass_(icon, root.getImageClass('radiomark-off'), root.getImageClass('radiomark-on'));
            }
          } else if (hasClass_(options[i],"focus")) {
            replaceClass_(icon, root.getImageClass('radiomark-off'), root.getImageClass('radiomark-focus'));
          }
        }
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      getImageClass: function(className) {
        return  'ihmicomponent-large'+ '-' + className;
      },
      getValue: function() {
        var elem = this,
            li = null;
        if (hasClass_(elem, 'radio-button')) {
          li = findDescendant_(elem, 'li', 'selected');
        }
        if (li === null) {
          return null;
        }
        return (li.getAttribute('data-value'));
      },
      adjustWidthHeight: function() {
        var elem = this;
        var config = elem.config;
        config.horizontal ? elem.setWidth()
                          : elem.setTextWidth();
        if (config.shrink) {
          elem.setHeight();
        }
        elem.setIconPosition();
      },
      addEventOptions: function() {
        var elem = this;
        var options = findDescendants_(elem, "li", "radio-button-option");
        var icon;
        var label;
        for (var i = 0; i < options.length; i++) {
          icon = options[i].children[0];
          label = options[i].children[1].children[0];
          addEventHandler_(icon, "keypress", ihmi.radioButton.onkeypress);
          addEventHandler_(icon, "focus", ihmi.radioButton.onfocus);
          addEventHandler_(icon, "blur", ihmi.radioButton.onblur);
          addEventHandler_(icon, "click", ihmi.radioButton.onclick);
          addEventHandler_(label, "click", ihmi.radioButton.onclick);
        }
      }
    },
    position: {
      // some posDef is shared with moveto component.
      posDef: {
        MAXROBOTAXES: 6,
        MAXEXTAXES: 3,
        CARTESIANKEY: ['X', 'Y', 'Z', 'W', 'P', 'R'],
        EXTAXESKEY: ['E1', 'E2', 'E3'],
        MOVETOPROGRAMNAME: '~MOVET2~',
        MOVETOMOTIONINST: 'L P[1] 100mm/sec FINE Wjnt',
        LISTVIEWASCIMG: '/frh/ihmi/ihmicomponent_listview_asc.png',
        LISTVIEWDESCIMG: '/frh/ihmi/ihmicomponent_listview_desc.png',
        MOVETOTERMINATECH: '    ;',  // Why separate? Because for when using VIA.
        PRGWRITE_OVW: 0, // Program write mode over write. (refer to PC editor)
        PRGWRITE_ADD: 2, // Program write mode after specified line (add). (refer to PC editor)
        WATCHEXEC_ABORTED: 0,
        WATCHEXEC_RUNNING: 1,
        WATCHEXEC_PAUSED: 2,
        MAXCOMMENTBYTE: 16,
        POSITION_RO_COLOR: '#EBEBE3',
        DISPLAYSETTING_CART: 0,
        DISPLAYSETTING_JOINT: 1, // used only moveto component.
        DISPLAYSETTING_NORMAL: 2,
        CHECKOVERLAY_START: 0,
        CHECKOVERLAY_END: 1,
        CHECKOVERLAY_END_FORCE: 2,
        ADJUST_INPUTFONTSIZE: '19px',
        ADJUST_INPUTFONTSIZE_CH: '19px',
        ADJUST_INPUTFONTSIZE_TW: '17px',
        DRAWORIGIN_REFRESH: 0,
        DRAWORIGIN_NEW: 1,
        DRAWORIGIN_CHANGENUM: 2, //change pos num or pos reg num
        DRAWORIGIN_GROUP: 3,
        DRAWORIGIN_SELPOSKIND: 4,
        DRAWORIGIN_NOCALLBACK: -1,
        // Change pos kind
        CHANGEKIND_REFRESH: 1, // Refresh
        CHANGEKIND_OPE: 2,     // User operation
        CHANGEKIND_IF: 3,      // Called changePosKind()
        CREATETYEP_NEW: "new", //selected new and touchup
        CREATETYEP_SELPOSKIND: "selposkind", //posreg to pos
        CREATETYEP_USEOPE_OR_CALLEDIF: "touchup", //clicked touchup or public if called.
        // Error result conv cart to joint check.
        CONVRSLT_DIFFERENT: "ihcp_convresult_differnt",            // Joint1->Cart->Joint2, Joint1 and Joint2 are different.
        CONVRSLT_ERR: "ihcp_convresult_error",                     // Unexpected error.
        CONVRSLT_CHECKINGOTHER: "ihcp_convresult_checkingohter",   // While checking other.
        //pos kind
        POSKIND_NUM: 1, // Position specify only Pos Number(0b0001)
        POSKIND_REG: 2, // Position specify only Position Regester(0b0010)
        POSKIND_REGREG: 4, // Position specify only Pos Reg[Reg](0b0100)
        POSKIND_REGARG: 8, // Position specify only Pos Reg[Arg](0b1000)
        POSKIND_SEL: (1 | 2), // Position specify both Pos Num and Pos Reg
        POSKIND_SEL_ALL: (1 | 2 | 4 | 8),
        //status
        STATUS_OK: 0,               // OK
        STATUS_POSINFO_UNDEF: 1,    // local pos reg, PR[reg], PR[arg].(0b0001)
        STATUS_DIFFERNT_SETTING: 2, // displaySetting and frame in program are differnt.(0b0002)
        //localPosReg
        LOCAL_REG_NUM_MIN: 10001 // local register min number.
      },
      // posPopupMsg is shared with moveto component.
      posPopupMsg : {
        'statAborted': 'ENDE',
        'msgEnableOff': 'Die TP-Aktivierungstaste aktivieren.',
        'msgIdResetAlarm': 'Vor dem Ausfhren den Alarm zurcksetzen.',
        'msgIdProgExec': 'Der Bewegungsvorgang kann nicht whrend der Programmausfhrung erfolgen.<br>Die Ausfhrung des Programms abbrechen.',
        'msgIdIlgUfUt': 'Der Roboter kann nicht bewegt werden, da das ausgewhlte Koordinatensystem und die Positionsdaten nicht bereinstimmen.',
        'msgInvalidChars': 'Die Zeichenfolge darf die folgenden Zeichen nicht enthalten.',
        'msgIdConfTouchup': 'Aktuelle Position aufnehmen?',
        'msgIdUseMultiCmd': 'Position [%s] wird anderweitig verwendet.\r\n',
        'msgConfigErrorFirst': 'Eingabe in die Konfiguration von \r\n[',
        'msgConfigErrorJoint': 'Gelenkanordnung',
        'msgConfigErrorTurnNum': 'Anzahl Drehungen',
        'msgConfigErrorEnd': '].',
        'msgRecPosCartError': 'Diese Position kann nicht in kartesischen Koordinaten eingelernt werden.',
        'msgRecPosJoint': '<br>Sie wird in Gelenkkoordinaten eingelernt.',
        'msgErrConvToCart': 'Diese Position kann nicht in kartesische Koordinaten konvertiert werden.',
        'msgConfFormError': 'Der Wert der Konfigurationsfolge ist unzulssig.',
        'msgSaveError': 'Speichern des Programms fehlgeschlagen.\r\nBitte berprfen Sie die Positionsdaten.',
        'msgSettingError': 'Die in der Anweisung angegebene Positionsdarstellung weicht von der Darstellung der Positionsinformationen ab.\r\nBitte das Programm berprfen.',
        //'msgIllegalPosTypeError': 'Unzulssiger Positionstyp.',
        'msg2byteCharError': 'Doppelbyte-Zeichen knnen nicht eingegeben werden, wenn diese Sprache ausgewhlt ist.',
        'msgGetCurPosError': 'Aktuelle Position konnte nicht abgerufen werden.',
        'msgRecPosError': 'Nachbesserung/Aufnahme fehlgeschlagen.',
        'msgNoExecRecPosError': 'This position can\'t be taught.',
        'msgNoExecPost': 'This position information can\'t be changed.',
        'msgNoExecAltFrame': 'This position can\'t be converted.',
        'msgNoExecChangeNum': 'This position number can\'t be changed.',
        'msgNoExecChangeKind': 'This position kind can\'t be changed.',
        'msgNoExecRetry': 'Please try again.',
        'msgNoExecVerify': 'Verify the specified position data (number, kind, coordinates, group).',
        'msgNoExecEmpty': 'Position data without teaching has been specified.',
        'msgProtectOnError': 'Verletzung des Speicherschutzes.<br>Bitte Programmschutz auslsen.',
        'dlgBtnIdOk': 'OK',
        'dlgBtnIdCancel': 'ABBRECHEN'
      },
      init: function(doc, id, config) {
        var tpVersion = 0;
        var elem = doc.getElementById(id),
            type = this;
        elem.iptElm = {}; // Shortened form of Input element.
        elem.iptElm.textboxComment = doc.getElementById(id + '.cmnttxt');
        elem.iptElm.textboxuf = doc.getElementById(id + '.uftxt');
        elem.iptElm.textboxut = doc.getElementById(id + '.uttxt');
        elem.iptElm.textboxConf = doc.getElementById(id + '.conftxt');
        elem.iptElm.textboxX = doc.getElementById(id + '.cartxtxt');
        elem.iptElm.textboxY = doc.getElementById(id + '.cartytxt');
        elem.iptElm.textboxZ = doc.getElementById(id + '.cartztxt');
        elem.iptElm.textboxW = doc.getElementById(id + '.cartwtxt');
        elem.iptElm.textboxP = doc.getElementById(id + '.cartptxt');
        elem.iptElm.textboxR = doc.getElementById(id + '.cartrtxt');
        elem.iptElm.textboxJ1 = doc.getElementById(id + '.jnt1txt');
        elem.iptElm.textboxJ2 = doc.getElementById(id + '.jnt2txt');
        elem.iptElm.textboxJ3 = doc.getElementById(id + '.jnt3txt');
        elem.iptElm.textboxJ4 = doc.getElementById(id + '.jnt4txt');
        elem.iptElm.textboxJ5 = doc.getElementById(id + '.jnt5txt');
        elem.iptElm.textboxJ6 = doc.getElementById(id + '.jnt6txt');
        elem.iptElm.textboxE1 = doc.getElementById(id + '.ext1txt');
        elem.iptElm.textboxE2 = doc.getElementById(id + '.ext2txt');
        elem.iptElm.textboxE3 = doc.getElementById(id + '.ext3txt');
        elem.iptElm.textPosRegNum = doc.getElementById(id + '.intposregnum.textbox');

        elem.selElm = {}; // Shortened form of Selection element.
        elem.selElm.btnSelPos = doc.getElementById(id + '.selposnum');
        elem.selElm.btnSelPosKind = doc.getElementById(id + '.selposkind');

        elem.optElem = {};
        elem.optElem.regReg = doc.getElementById(id + '.optKindRegReg');
        elem.optElem.regArg = doc.getElementById(id + '.optKindRegArg');

        removeClass_(elem.optElem.regReg, 'hide');
        removeClass_(elem.optElem.regArg, 'hide');

        elem.btnElm = {}; // Shortened form of Button element.
        elem.btnElm.btnTgl = doc.getElementById(id + '.altframebtn');
        elem.btnElm.btnMoveTo = doc.getElementById(id + '.moveto');
        elem.btnElm.btnMovBar = doc.getElementById(id + '.movebar');
        elem.btnElm.btnMvArea = doc.getElementById(id + '.movtoslide');
        elem.btnElm.btnTouchUp = doc.getElementById(id + '.touchup');
        elem.btnElm.txtTgl = doc.getElementById(id + '.altframelbl');
        elem.btnElm.txtMoveTo = doc.getElementById(id + '.movlbl');
        elem.btnElm.txtTouchUp = doc.getElementById(id + '.tuplbl');
        elem.btnElm.btnFold = doc.getElementById(id + '.posfolding');
        elem.tabElem = doc.getElementById(id + '.grouptab');

        config.func = type.func;
        elem.config = config;
        elem.config.targetProgramName = '';
        elem.config.isTrackingProgram = false; //true: target program is tracking. / false: target program is not tracking.
        elem.config.maxNumOfLocalRegs = [0, 0, 0]; //max num of local registers. [reg, posreg, mojireg] 10001~
        elem.config.noLocalReg = false;
        elem.config.currentFrame = top.COORDINATECART;
        elem.config.componentMode = ihmi.position.posDef.POSKIND_NUM; // Default component mode is only posnum.
        elem.config.currentPosKind = ihmi.position.posDef.POSKIND_NUM; // Default position kind is posnum.
        elem.config.currentPosNumber = 0; // Rename to distinguish from PosReg
        elem.config.currentPosRegNum = 1;
        elem.config.currentPosRegRegNum = 1;
        elem.config.currentPosRegArgNum = 1;
        elem.config.groupCount = 1; // default group count
        elem.config.enableGroupCount = 1; // enable group count (if displaySetting is cart only and Independent Axis group, no count.)
        elem.config.posAxesCount = { 'joint': [], 'robot': [] };
        elem.config.posAxesUnit = []; // Unit string of Axes.
        elem.config.armType = []; // 27 is Independent Axis.
        elem.config.currentGroupNum = 0;
        elem.config.currentConfigStr = '';
        elem.config.configStrCheck = null;
        elem.config.initialized = false;
        elem.config.runningRefresh = false; //true: while refreshing / false: no executing refresh.
        elem.config.retryInitCount = 0;
        elem.config.retryExchgCount = 0;
        elem.config.targetIdPrefix = id;
        elem.config.posNumList = [];
        elem.config.currentPosInfo = {};
        elem.config.deleteComment = false;//if sel pos kind form pos to posreg, delete comment.
        // Position Register configuration data
        elem.config.posRegRecord = {};
        elem.config.isContinuingInput = false;	// true = on update (except pos reg num textbox)
        elem.config.hasFocusPosRegNum = false;	// true = pos reg num textbox has focus.
        elem.config.hasBeenChanged = false; // Pos Reg data has been changed?
        elem.config.timerIdInputPR = null; // PosReg input timer
        elem.config.isConvertFrame = false; // true = on convert
        elem.config.timerIdPosReg = null; // PosReg polling timer
        elem.config.POSREG_INTERVAL_TIME = 2000;	// Interval Time for get Position register value. original is 1000
        elem.config.POSREG_INPUTTXT_TIME = 300;	// Interval Time for input Position register value.
        config.posRegLimit = {};
        config.posRegLimit.lower = 1;
        config.posRegLimit.upper = 100; // default max PosRegNum. updated from $MAXPREGNUM.
        config.regLimit = {};
        config.regLimit.lower = 1;
        config.regLimit.upper = 100;    // default max PosRegRegNum. updated from $MAXREGNUM.
        config.argLimit = {};
        config.argLimit.lower = 1;
        config.argLimit.upper = 16383;    // default max PosRegArgNum. CRX max value.
        config.jposrecEnable = 0;         // joint pos rec enable
        config.isUnload = false;

        // A flag that indicates whether to call the callback when the value changes
        // when rendering the PosReg screen.
        elem.config.isCallPRCallback = false;
        elem.config.isCallPNCallback = false;

        /* if error occurd, back prev value */
        elem.config.confPreviousVal;
        elem.config.cmntPreviousVal;

        // Popup Message table.
        elem.config.posPopupMsg = type.posPopupMsg;
        elem.config.posLSText = {
          'posCommandStr': 'P',
          'posConfigStr': 'CONFIG',
          'posTrackNum': 'LINE_TRACK_SCHEDULE_NUMBER'
        };
        elem.config.posDict = {
          'posStr': 'Position',
          'posRegStr': 'Pos.Reg',
          'posRegRegStr': 'Pos.Reg[Reg',
          'posRegArgStr': 'Pos.Reg[Arg'
        };
        // Reacquire
        var defaultView = ihmi.cf.getDefaultView(elem.ownerDocument);
        elem.config.myWebPage = (defaultView != null) ? defaultView.webpage : "";
        // [Extension] Comment element disable (true/false(default))
        elem.config.disableComment = false;
        elem.config.dispErrorPopup = false;
        /** if error comment saved. */
        elem.config.dispErrorPopup_xmlCmnt = false; // eslint-disable-line camelcase
        elem.config.dispRefreshOverlay = null;
        elem.config.displaySetting = parseInt(elem.config.displaySetting);
        if (elem.config.displaySetting !== config.func.getPosDef('DISPLAYSETTING_CART')) {
          elem.config.displaySetting = config.func.getPosDef('DISPLAYSETTING_NORMAL');
        }
        elem.config.mvbtnActive = false;
        elem.config.disabled = true; // [#11556] If true, disable the component when PROTECT is READ.
        elem.config.isProgReadOnly = false; // [#11556] Is the PROTECT attribute of the program READ?
        elem.config.status = ihmi.position.posDef.STATUS_OK;

        // some functions are shared with moveto component.
        // Open functions
        elem.refresh = type.refresh;
        elem.drawPosition = type.drawPosition;
        elem.drawPosReg = type.drawPosReg;
        elem.updatePositionList = type.updatePositionList;
        elem.setCallback = type.setCallback;
        elem.setCallbackTouchup = type.setCallbackTouchup;
        elem.setPrgInfoCallback = type.setPrgInfoCallback;
        elem.getCurrentPosNumber = type.getCurrentPosNumber;
        elem.getCurrentProgramName = type.getCurrentProgramName;
        elem.getPosition = type.getPosition;//not recommended
        elem.getPositionAsync = type.getPositionAsync;
        elem.getPositionMulti = type.getPositionMulti;
        elem.getPosInfoCurrentKind = type.getPosInfoCurrentKind;
        elem.getPosNumList = type.getPosNumList;
        elem.getCurrentPosKind = type.getCurrentPosKind;
        elem.getPosRegNumber = type.getPosRegNumber;
        elem.getPosRegister = type.getPosRegister;
        elem.postPosition = type.postPosition;
        elem.alternateFrame = type.alternateFrame;
        elem.moveto = type.moveto;
        elem.touchup = type.touchup;
        elem.changePosKind = type.changePosKind;
        elem.changeNumber = type.changeNumber;
        elem.copyPosition = type.copyPosition;
        elem.onendMvTo = type.onendMvTo;
        elem.getCurrentConfig = type.getCurrentConfig;
        elem.createRecord = type.createRecord;
        // Internal(Private) functions
        elem.onmoveMvTo = type.onmoveMvTo;
        elem.execRefresh = type.execRefresh;
        elem.getPosValAndAnalize = type.getPosValAndAnalize;
        elem.judgeDrawPosition = type.judgeDrawPosition;
        elem.setPosition = type.setPosition;
        elem.dispPositionData = type.dispPositionData;
        elem.getRobotAxesCount = type.getRobotAxesCount;
        elem.getExtendAxesCount = type.getExtendAxesCount;
        elem.getJointAxesCount = type.getJointAxesCount;
        elem.toggleFrameType = type.toggleFrameType;
        elem.popupConfirm = type.popupConfirm;
        elem.positionString = type.positionString;
        elem.savePosition = type.savePosition;
        elem.putPositionRecord = type.putPositionRecord;
        elem.savePosRegister = type.savePosRegister;
        elem.createNewPosition = type.createNewPosition;
        elem.onChangePosRegNum = type.onChangePosRegNum;
        elem.refreshPosNumList = type.refreshPosNumList;
        elem.onClickSelChangePosKind = type.onClickSelChangePosKind;
        elem.onSelChangePosKind = type.onSelChangePosKind;
        elem.stopPosAction = type.stopPosAction;

        addEventHandler_(elem.selElm.btnSelPos, 'click', type.onclickSelPos);
        addEventHandler_(elem.selElm.btnSelPos, 'change', type.onchange);
        addEventHandler_(elem.selElm.btnSelPos, 'blur', type.onblurSelPos);
        addEventHandler_(elem.selElm.btnSelPosKind, 'change', type.onClickSelChangePosKind);
        addEventHandler_(elem.btnElm.btnTgl, 'click', type.onclickTglBtn);

        if (ihmi.global.isModernBrowser) {
          addEventHandler_(elem.btnElm.btnMoveTo, 'touchstart', type.onstartMvTo);
          addEventHandler_(elem.btnElm.btnMoveTo, 'mousedown', type.onstartMvTo);
        }
        addEventHandler_(elem.btnElm.btnTouchUp, 'click', type.onclickTouchUp);
        addEventHandler_(elem.btnElm.btnFold, 'click', type.onclickFoldBtn);
        // Add an event handler to the input text box.
        Object.keys(elem.iptElm).forEach(function(key) {
          // PosRegNum is controlled by the textboxinteger component.
          if (key == 'textPosRegNum') {
            // It is better to prepare I/F with textboxInteger component.
            addEventHandler_(this[key], 'focus', type.onFocusBlurPosRegText);
            addEventHandler_(this[key], 'blur', type.onFocusBlurPosRegText);
            return; // No handler to set.
          }
          addEventHandler_(this[key], 'change', type.onchange);
          addEventHandler_(this[key], 'keypress', type.onkeypress);
          addEventHandler_(this[key], 'focus', type.onFocusText);
          addEventHandler_(this[key], 'blur', type.onBlurText);
        }, elem.iptElm);

        // Catch and stop moveto before unloading.
        var myFrameWin = getDefaultView_(elem.ownerDocument);
        addEventHandler_(myFrameWin, 'beforeunload', type.onBeforeunload);
        // Call out so that you can have some time to clean up.
        addEventHandler_(myFrameWin, 'pagehide', type.onUnload);

        // Disable each textbox for safety.
        config.func.toggleSelectableTextboxes(true, elem);
        config.func.toggleSelectableButton(elem, true);
        config.func.disablePosRegMoveToBtn(elem, true);

        // Disable position number select box for safety.
        config.func.toggleSelectablePosNumAndRegNum(true, elem);
        if (top.isTabTP()) {
          try {
            tpVersion = Number(android.ApiTabTPVersion());    // eslint-disable-line no-undef
            if ((tpVersion >= 1.22) &&
                android.ApiShouldInputBeNumeric()) {          // eslint-disable-line no-undef
              config.func.convertTelToNumber(elem);
            }
          } catch (e) {
            console.log(e.message);
          }
        }

        // [#9488] Add for delete radius of iPad.
        if (ihmi.global.isiPad) {
          elem.selElm.btnSelPos.style.webkitAppearance = 'none';
          elem.selElm.btnSelPos.style.borderRadius = '0px';
          elem.selElm.btnSelPosKind.style.webkitAppearance = 'none';
          elem.selElm.btnSelPosKind.style.borderRadius = '0px';
          Object.keys(elem.iptElm).forEach(function(key) {
            this[key].style.webkitAppearance = 'none';
            this[key].style.borderRadius = '0px';
          }, elem.iptElm);
        }
      },
      refresh: function(initArgs) {
        var root = this;
        var func = root.config.func;
        var queueItem = {};
        queueItem.initArgs = initArgs;
        if (queueItem.initArgs.number == undefined) {
          queueItem.initArgs.number = null; // posKind=NUM...New, =REG...?
        }
        queueItem.root = root;
        // Manage by enqueuing in a queue.
        // Because multiple position component refresh() may be called.
        func.posRefreshQueue.enqueue(queueItem, ihmi.cf.getDefaultView(root.ownerDocument));
        func.posRefreshQueue.exec();
      },
      execRefresh: function(initArgs) {
        var root = this;
        var rootId = root.id;
        var config = root.config;
        var func = config.func;
        var doc = root.ownerDocument;
        config.runningRefresh = true;
        config.initialized = false;
        if (func.checkUnloadWhileRefreshing(root)) return;
        config.initCompleteCallback = initArgs.initCompleteCallback; // save callback
        config.initCompleteArgs = initArgs;
        config.specifiedPosNum = parseInt(initArgs.number, 10); // save pos number
        config.currentGroupNum = parseInt(initArgs.group, 10); // save group
        config.motionGroup = 1; // default motion group
        config.posLimit = {};
        config.posLimit.lower = -99999999;
        config.posLimit.upper = 99999999;
        config.ufLimit = {};
        config.ufLimit.lower = 0;
        config.ufLimit.upper = 9;
        config.utLimit = {};
        config.utLimit.lower = 1;
        config.utLimit.upper = 10;
        config.INFLATEMVTOLEFT = 0;      // [#15565] set individual button left edge
        config.allGrpPosInfo = null;     //for editPos() multi group.
        config.allGrpPosRegInfo = null;  //for multi group. Because it is not correct comment except for posreg[1].
        config.allGrpPosInfoByNew = null;//for editPos() multi group. user selected new.
        config.disableComment = (initArgs.disableComment !== undefined) ?
          ihmi.cf.parseStrToBoolean(initArgs.disableComment): false;
        config.saveConvCartToJoint = {};               // Check that joint data are the same before and after conversion.(Joint->Cart->Joint)
        config.saveConvCartToJoint.oldJoint = null;    // Joint data before convert.
        config.saveConvCartToJoint.cart = null;        // Cart data of convert joint to cart.
        config.diffConvCartToJoint = false;            // Convert joint1->cart->joint2, if joint1 and joint2 are different, set true.

        // [#11556] disable the component when PROTECT is READ.
        config.disabled = (initArgs.disabled !== undefined) ? initArgs.disabled: false;
        if (config.specifiedPosNum === -1) config.disabled = true;
        // [#11556] Attribute is PROTECTED or Program is not selected?
        config.isProgReadOnly = false;
        config.isTrackingProgram = false; //true: target program is tracking. / false: target program is not tracking.
        // Get Position Specified Mode/Kind.
        config.componentMode = getInitPositionMode(config.componentMode, initArgs.posMode);
        config.currentPosKind = func.checkPosKindMatchesMode(root, config.currentPosKind, config.componentMode, initArgs.posKind);
        config.currentFrame = top.COORDINATECART;
        config.status = ihmi.position.posDef.STATUS_OK;
        if (initArgs.noLocalReg != undefined) {
          config.noLocalReg = ihmi.cf.parseStrToBoolean(initArgs.noLocalReg);
        }
        // Set Callback to PosRegNum textbox.
        doc.getElementById(rootId + '.intposregnum').setCallback(root.onChangePosRegNum);
        // Keep the current fontFamily for <select> or something.
        var elementStyle = window.getComputedStyle(root);
        // Set fontFamily to <select>.
        root.selElm.btnSelPosKind.style.fontFamily = elementStyle.fontFamily;
        doc.getElementById(rootId + '.selposnum').style.fontFamily = elementStyle.fontFamily;
        // Save flag when specified [UF/UT fixed to 'F'] for disable UF/UT.
        config.ufutFixedtoF = (initArgs.ufutFixedtoF !== undefined) ?
          ihmi.cf.parseStrToBoolean(initArgs.ufutFixedtoF): false;
        // adjust pos reg number text box font-size
        doc.getElementById(rootId + '.intposregnum.textbox').style.fontSize = func.getPosDef('ADJUST_INPUTFONTSIZE');

        // adjust padding and width of pos reg number text box
        doc.getElementById(rootId + '.intposregnum.textbox').style.padding = '0 4px';
        doc.getElementById(rootId + '.intposregnum.textbox').style.width = '60px';
        func.checkRefreshOverlay(root, func.getPosDef('CHECKOVERLAY_START'));

        //1st Get current language ($DICT_CONFIG.$LANG_SUFFIX)
        if (top.irprogapi.getCurrentLanguage() == null) { // api
          top.irprogapi.setCurrentLanguage(getPosCrntLangCallback, null);
        } else {
          getPosCrntLangCallback();  // Already get current lang.
        }

        //2nd get sysytem values.
        function getPosCrntLangCallback(progName, varName, typeCode, valStr, cbArg1, cbArg2) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          var sysValObj = {
            system : [],
            posreg : []
          };
          sysValObj.system = [
            '$SCR.$NUM_GROUP',
            '$SCR.$MAXNUMUFRAM',
            '$SCR.$MAXNUMUTOOL',
            '$JPOSREC_ENB'
          ];
          sysValObj.posreg = [
            '$MAXPREGNUM'
          ];
          sysValObj.numreg = [
            '$MAXREGNUM'
          ];
          // adjustFontSize
          var selPosKind = root.selElm.btnSelPosKind;
          var currLang = top.irprogapi.getCurrentLanguage();
          // adjust pos/pos reg selectbox font-size
          if (currLang != null) {
            switch (ihmi.global.encoding) {
              case 'EUC-CN':
                selPosKind.style.fontSize = func.getPosDef('ADJUST_INPUTFONTSIZE_CH');
                break;
              case 'Big5':
                selPosKind.style.fontSize = func.getPosDef('ADJUST_INPUTFONTSIZE_TW');
                break;
              default:
                break;
            }
          }
          top.irprogapi.getSystemValByXvr(sysValObj, getPosInfoCallback, 'posInfo.cvr');
        }
        function getPosInfoCallback(cbArg, xmlError) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          // In the case of a new work cell, "**** Uninitialized ****" becomes CRLF.
          // get total axis.
          var matchResult = [];
          var maxPosRegNum;
          var maxRegNum;
          // var subProgramName;
          var sysKeyTable = [
            {matchKey: 'NUMGROUP', matchStr: /\$SCR.\$NUM_GROUP/},
            {matchKey: 'MAXUFRAME', matchStr: /\$SCR.\$MAXNUMUFRAM/},
            {matchKey: 'MAXUTOOL', matchStr: /\$SCR.\$MAXNUMUTOOL/},
            {matchKey: 'JPOSRECENB', matchStr: /\$JPOSREC_ENB/},
            {matchKey: 'PREGNUM', matchStr: /\$MAXPREGNUM/},
            {matchKey: 'REGNUM', matchStr: /\$MAXREGNUM/}
          ];
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp getPosInfoCallback: xml error detect');
            config.targetProgramName = '';
            func.getCurrentConfigString(root);
          }
          for (var keys in cbArg) {
            if (Object.prototype.hasOwnProperty.call(cbArg, keys)) {
              matchResult = func.checkSystemKeys(keys, sysKeyTable);
              if (matchResult == null) {
                continue;
              }
              switch (matchResult.matchKey) {
              case 'NUMGROUP':
                config.groupCount = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'MAXUFRAME':
                config.ufLimit.upper = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'MAXUTOOL':
                config.utLimit.upper = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'JPOSRECENB':
                config.jposrecEnable = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'PREGNUM':
                maxPosRegNum = cbArg[keys];
                config.posRegLimit.upper = (maxPosRegNum != null) ? parseInt(maxPosRegNum.slice(0), 10): 100;
                break;
              case 'REGNUM':
                maxRegNum = cbArg[keys];
                config.regLimit.upper = (maxRegNum != null) ? parseInt(maxRegNum.slice(0), 10): 200;
                break;
              }
            }
          }
          setBehindDefaultNumber(initArgs);
          // Get Motion Group from Program.
          top.getAttr(config.targetProgramName, top.MM_DEF_GROUP_C, getGroupPosInfo, cbArg); // io

          function setBehindDefaultNumber(initArgs) {
            setByPosKind(func.getPosDef('POSKIND_REG'));
            setByPosKind(func.getPosDef('POSKIND_REGREG'));
            setByPosKind(func.getPosDef('POSKIND_REGARG'));
            function setByPosKind(targetPosKind) {
              var behindDefNum;
              if (config.currentPosKind == targetPosKind) {
                return; //if targetKind is same as current kind, don't set. becase set in drawPosReg().
              }
              behindDefNum = (targetPosKind == ihmi.position.posDef.POSKIND_REG) ?
              initArgs.behindDefaultPosRegNum : (targetPosKind== ihmi.position.posDef.POSKIND_REGREG) ?
              initArgs.behindDefaultPosRegRegNum : (targetPosKind== ihmi.position.posDef.POSKIND_REGARG) ?
              initArgs.behindDefaultPosRegArgNum : undefined;
              if (behindDefNum == undefined ) {
                return;
              }
              behindDefNum = (typeof behindDefNum === 'string') ? parseInt(behindDefNum): behindDefNum;
              func.setConfCurRegNumByKind(root, targetPosKind, behindDefNum);
            }
          }
        }
        // 2.5th
        function getGroupPosInfo(status, progName, mmVarName, mmValue, cbArg) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          var sysValObj = {
            system : [],
            posreg : []
          };
          var specifiedGrp = [ // Generated by the number of groups.
            '$SCR_GRP[%%GROUPNUM%%].$NUM_AXES',
            '$SCR_GRP[%%GROUPNUM%%].$NUM_ROB_AXS',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[1]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[2]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[3]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[4]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[5]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[6]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[7]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[8]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[9]', //MAXROBOTAXES + MAXEXTAXES
            '$SCR_GRP[%%GROUPNUM%%].$ARM_TYPE'
          ];
          if (status !== top.IO_SUCCESS) {
            console.log('[ERROR] ihcp getGroupPosInfo: getAttr() error detect');
          }

          config.motionGroup = parseInt(mmValue); // Set Motion group
          var motionGrpArr = func.getMotionGroupArray(config.motionGroup);
          var sysIdx = sysValObj.system.length;
          for (var gNum = 0; gNum < motionGrpArr.length; gNum++) {
            if (motionGrpArr[gNum]) { // valid group
              for (var gIdx = 0; gIdx < specifiedGrp.length; gIdx++) {
                sysValObj.system[sysIdx] = specifiedGrp[gIdx].replace('%%GROUPNUM%%', '' + (gNum + 1));
                sysIdx++;
              }
            }
          }
          top.irprogapi.getSystemValByXvr(sysValObj, getPosGroupCallback, 'posGrp' + (gNum + 1) + '.cvr');
        }
        function getPosGroupCallback(cbArg, xmlError) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          var matchResult = [];
          var sysGroup = 1;
          var motionGrpArr = func.getMotionGroupArray(config.motionGroup);
          var minGrpNum;
          var axsunit;
          var axsindex;
          var sysGrpTable = [
            {matchKey: 'NUMAXES', matchStr: /\$SCR_GRP\[(\d)\].\$NUM_AXES/},
            {matchKey: 'ROBAXS', matchStr: /\$SCR_GRP\[(\d)\].\$NUM_ROB_AXS/},
            {matchKey: 'ROTARY', matchStr: /\$SCR_GRP\[(\d)\].\$ROTARY_AXS\[(\d)\]/},
            {matchKey: 'ARMTYPE', matchStr: /\$SCR_GRP\[(\d)\].\$ARM_TYPE/}
          ];
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp getPosGroupCallback: xml error detect');
          }
          for (var keys in cbArg) {
            if (Object.prototype.hasOwnProperty.call(cbArg, keys)) {
              matchResult = func.checkSystemKeys(keys, sysGrpTable);
              if (matchResult == null) {
                continue;
              }
              sysGroup = parseInt(matchResult[1]);
              switch (matchResult.matchKey) {
              case 'NUMAXES':
                config.posAxesCount.joint[sysGroup] = parseInt(cbArg[keys]);
                break;
              case 'ROBAXS':
                config.posAxesCount.robot[sysGroup] = parseInt(cbArg[keys]);
                break;
              case 'ROTARY':
                axsunit = config.posAxesUnit;
                if (axsunit[sysGroup] === undefined) {
                  axsunit[sysGroup] = [];
                }
                axsindex = parseInt(matchResult[2]) - 1;
                axsunit[sysGroup][axsindex] = (cbArg[keys].toLowerCase() == 'true') ? 'deg' : 'mm';
                break;
              case 'ARMTYPE':
                config.armType[sysGroup] = parseInt(cbArg[keys]);
                break;
              }
            }
          }
          // serch minimum group num
          for (var i = 0; i < motionGrpArr.length; i++) {
            if (motionGrpArr[i] === true) {
              minGrpNum = i + 1;
              break;
            }
          }
          if (minGrpNum === undefined) {
            config.targetProgramName = ''; // all disabled
            console.log('[ERROR] enable group does not exist.');
            minGrpNum = 1; // dummy
          }

          config.currentGroupNum = ((config.currentGroupNum == null) || (motionGrpArr[config.currentGroupNum - 1] !== true)) ?
            minGrpNum :
            config.currentGroupNum;

          // 3th for get current config string.
          func.getCurrentConfigString(root, getCurrentConfigStringCallback);
        }
        // 4th get position number list.
        function getCurrentConfigStringCallback(isSuccess) {
          if (!isSuccess) {
            ihmi.cf.toast.show(config.posPopupMsg['msgGetCurPosError']);
            config.targetProgramName = ''; // all disabled
          }
          var makePosArgs = {};
          makePosArgs.myRoot = root;
          makePosArgs.callback = refreshPosNumListcallback;
          root.refreshPosNumList(makePosArgs);
        }
        function refreshPosNumListcallback() {
          if (func.checkUnloadWhileRefreshing(root)) return;
          if (config.targetProgramName.length == 0) {
            completeRefresh();
            return;
          }
          top.get_appLineTrack(config.targetProgramName, getAppLineTrackCallback, null, null);
        }
        //5th set line tracking.
        function getAppLineTrackCallback(status, progName, schdNum, contTrck, selBound, cbArg1, cbArg2) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          if (status !== top.IO_SUCCESS) {
            //not exist position or not teached
            //console.log('[ERROR] getAppLineTrackCallback: get_appLineTrack() failed. (status=' + status +'.)');
          } else {
            if (schdNum > 0) {
              config.isTrackingProgram = true;
            }
          }
          if (config.targetProgramName.length == 0) {
            completeRefresh();
            return;
          }
          // [#11556] For cbArg is not in the getAttr(), set it in config.
          top.getAttr(config.targetProgramName, top.MM_PROTECT_C, getProtectAttrCallback); // io
        }

        // [#11556] 6th get program protect attribute.
        function getProtectAttrCallback(status, progName, mmVarName, mmValue) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          if (status == top.IO_SUCCESS) {
            config.isProgReadOnly = (parseInt(mmValue) == 2); // value:2=READ;, 1=READ_WRITE;
          }
          completeRefresh();
        }
        // 7th Complete refresh pre process. Initialize the display and complete.
        function completeRefresh() {
          if (func.checkUnloadWhileRefreshing(root)) return;
          // Initialize group tab
          func.initGroupTab(root);

          // Will "PosArea" be unfolded at initialization?
          var initFold = (initArgs.fold == undefined) ? true : ihmi.cf.parseStrToBoolean(initArgs.fold);
          func.redrawPosArea(root, initFold);

          func.toFoldUnfoldPosArea(root, false, initFold); // Unfold 'PosArea'.
          // Enable textboxes.
          func.toggleSelectableTextboxes(false, root);
          // Enable touchup/moveto/alternate button.
          func.disablePosRegMoveToBtn(root, false);
          // Enable/Disable position mode select.
          func.togglePosModeSelElement(root, false);
          func.toggleSelectableButton(root, false);

          func.refreshPosKindSelct(root, ihmi.position.posDef.CHANGEKIND_REFRESH);
          /****                                    *****/
          // Enable position number select box.
          func.toggleSelectablePosNumAndRegNum(false, root);

          if (config.displaySetting !== func.getPosDef('DISPLAYSETTING_NORMAL')) {
            //check display Setting in same document.
            var positions = doc.querySelectorAll('div.position');
            var posLen = positions.length;

            for (var y = 0; y < posLen; y++) {
              if (config.displaySetting !== positions[y].config.displaySetting) {
                func.popupErrorNotClosed(root, config.posPopupMsg['msgSettingError']);
                break;
              }
            }
            hideTglBtn();

            // [#11018:No.26] Initialize pos reg and pos value area to setteing frame type.
            if (config.displaySetting != func.getPosDef('DISPLAYSETTING_NORMAL')) {
              config.currentFrame = config.displaySetting;
            }
            func.switchPositionDisp(root, config.currentFrame); // switching position frame.
          }

          // Continue drawing
          var drawArgs = {root: root, posNum: config.specifiedPosNum, posFrame: null, origin: ihmi.position.posDef.DRAWORIGIN_REFRESH};
          func.drawPosition(drawArgs);
          // [P19] Call Callback after drawPosition. Delete below comment after correct.
          //if ((initArgs.initCompleteCallback != undefined) && (typeof initArgs.initCompleteCallback === 'function')) {
          //  // Call callback function of initialize completion.
          //  initArgs.initCompleteCallback(initArgs.initCompleteArgs);
          //}
          //func.checkRefreshOverlay(root, func.getPosDef('CHECKOVERLAY_END'));
          //func.posRefreshQueue.exec();

          //console.log('init: Complete(' + config.initialized + ')'); // debug message
        }
        function getInitPositionMode(crntComponentMode, mode) {
          var initPosMode = mode;
          if (mode === undefined) { // For compatibility.
            initPosMode = crntComponentMode;
          } else if ((mode != func.getPosDef('POSKIND_NUM')) &&
              (mode != func.getPosDef('POSKIND_REG')) &&
              (mode != func.getPosDef('POSKIND_SEL')) &&
              (mode != func.getPosDef('POSKIND_SEL_ALL'))) {
            // If the Mode is invalid, the position number is used.
            initPosMode = crntComponentMode;
          }
          return parseInt(initPosMode);
        }
        function hideTglBtn() {
          var altElem = doc.getElementById(root.id + '.altframe');
          ihmi.cf.addClass(altElem, 'hide');
        }
      },
      // refresh position number List.
      // *Private function*
      // mkPosArgs.myRoot : root
      //          .selElem: select pos num list element
      //          .callback : Callback to finish make list.
      //          .posListFromEditor : Position number list form editor.
      refreshPosNumList: function(mkPosArgs) {
        var root = mkPosArgs.myRoot;
        var config = root.config;
        if (config.targetProgramName.length == 0) {
          makeSelPosNum([], mkPosArgs);
          if ((mkPosArgs.callback != undefined) && (typeof mkPosArgs.callback === 'function')) {
            mkPosArgs.callback(mkPosArgs); // Call callback function.
          }
        } else if (mkPosArgs.posListFromEditor != undefined) {
          makeSelPosNum(mkPosArgs.posListFromEditor, mkPosArgs);
        } else {
          top.get_posNumList(config.targetProgramName, getPosNumListCallback, mkPosArgs, null);
        }

        function getPosNumListCallback(status, progName, posCnt, posLst, callbackarg1, callbackarg2) {
          if (status !== top.IO_SUCCESS) {
            //not exist pos info in program.
            posLst = [];
          }
          //console.log("getPosNumListCallback:" + posLst);
          makeSelPosNum(posLst, mkPosArgs);
          if ((mkPosArgs.callback != undefined) && (typeof mkPosArgs.callback === 'function')) {
            mkPosArgs.callback(mkPosArgs); // Call callback function.
          }
        }
        function makeSelPosNum (posNumList, mkPosArgs) {
          var root = mkPosArgs.myRoot;
          var config = root.config;
          var func = config.func;
          var doc = root.ownerDocument;
          var selectedPosNum;

          if (!Array.isArray(posNumList)) {
            return; //error
          }
          posNumList = posNumList.map(Number);//str to int
          posNumList = Array.from(new Set(posNumList));//Deduplication
          posNumList.sort(function(a,b) { //sort
            if ( a < b ) return -1;
            if ( a > b ) return 1;
            return 0;
          });
          config.posNumList = posNumList;

          if (!config.initialized) { // while refreshing
            selectedPosNum = config.specifiedPosNum; // currentPosNumber is not yet set. use specifiedPosNum.
          } else {
            selectedPosNum = config.currentPosNumber;
          }
          checkRangeAndAddOption(root, selectedPosNum);
          if (!config.initialized) {
            return;
          }

          var allPos = doc.querySelectorAll('div.position');
          // serch position component on same document.
          for (var n = 0; n < allPos.length; n++) {
            var eachPos = allPos[n];
            var eachPosConf = eachPos.config;
            if (root.id == eachPos.id) { // same component
              continue; // skip
            }
            var destSelPosElem = doc.getElementById(eachPos.id + '.selposnum');
            if (destSelPosElem === null) {
              continue; //not component
            }
            // Position mode is PosReg only mode?
            if (eachPosConf.componentMode == config.func.getPosDef('POSKIND_REG')) {
              continue; // skip refresh.
            }
            // select list update.
            eachPosConf.posNumList = JSON.parse(JSON.stringify(posNumList));
            var destSelNum = eachPosConf.currentPosNumber;
            checkRangeAndAddOption(eachPos, destSelNum);
          }

          function checkRangeAndAddOption(targetRoot, posNum) {
            var doc = targetRoot.ownerDocument;
            var selElem = targetRoot.selElm.btnSelPos;
            var inRange = func.checkNumberRange(targetRoot, ihmi.position.posDef.POSKIND_NUM, posNum, false);
            var optNew = doc.createElement('option');
            var optElem;
            var optOutOfRangeVal;
            var selectVal = posNum;
            optNew.value = 'New';
            optNew.text = 'New';

            while (selElem.lastChild) {  // Initialize option list
              selElem.removeChild(selElem.lastChild);
            }
            if (!inRange) { //out of range
              selElem.required = true; // for change color red
              optOutOfRangeVal = doc.createElement('option');
              optOutOfRangeVal.value = ""; // for change color red
              optOutOfRangeVal.text = (posNum === 0) ? "..." : posNum;
              optOutOfRangeVal.hidden = true;
              selElem.appendChild(optOutOfRangeVal);
              selectVal = optOutOfRangeVal.value;
            }

            for (var i = 0; i < posNumList.length; i++) {
              optElem = doc.createElement('option');
              optElem.value = posNumList[i];
              optElem.text = posNumList[i];
              selElem.appendChild(optElem);
            }
            selElem.appendChild(optNew);
            selElem.value = selectVal;
          }
        }
      },
      // Get Position value and Analyze and make position info.
      // (IN) posArgs : Position arguments.
      //      .number : Position number.
      //      .frame : Position frame.
      //      .origin : Caller origin. (for carry around)
      //      .rootElem : Root element object.
      //      .callback : Callback after analyze.
      //      .isSync : Synchronous flag.
      getPosValAndAnalize: function(posArgs) {
        var root = this;
        var config = root.config;
        var isSync = ihmi.cf.parseStrToBoolean(posArgs.isSync);
        if (posArgs.number <= 0) { // Illegal position number
          console.log('[ERROR] getPosValAndAnalize: invalid posNum (' + posArgs.number + ')');
          return;
        }
        // Get position value of specified number.
        top.get_posValue(isSync, config.targetProgramName, posArgs.number, config.func.analizePosTxtAndMakePosInfo, posArgs, null);
      },
      // Judge various conditions and display the position data.
      // (I don't know what to judge...)
      // (IN) judgeArg : each conditions.
      //      .number : Requested position number.
      //      .frame : Requested position frame kind.
      //      .origin : Requested caller origin.
      //      .posRec : Position record.
      judgeDrawPosition: function(judgeArg) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var posData;
        var reqPosNum = judgeArg.number;
        var reqPosFrame = judgeArg.frame;
        var isIndAxis = (config.armType[config.currentGroupNum] == 27) ? true : false;
        var isDifferntSetting = false;
        var isUndefPosInfo;
        if (func.checkUnloadWhileRefreshing(root)) return;
        isUndefPosInfo = func.updatePosInfoUndefStatus(root, reqPosNum);

        if (judgeArg.getAllGroup && Array.isArray(judgeArg.posRecArray)) {
          if (judgeArg.posRecArray.length > 1) {
            config.allGrpPosInfo = judgeArg.posRecArray;
          }
          for (var i = 0; i < judgeArg.posRecArray.length; i++) {
            if (config.currentGroupNum === judgeArg.posRecArray[i].group) {
              posData = judgeArg.posRecArray[i];
              break;
            }
          }
        } else {
          posData = judgeArg.posRec;
        }
        config.prevPosNumber = config.currentPosNumber; // Save previous position number.

        if (config.dispErrorPopup) {
          if (judgeArg.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
            func.callbackInitComplete(root, false);
          }
          return;
        }
        /*
        if (config.isTrackingProgram) {
          // if moveto component, it able to select joint only mode.
          if (config.useProg && config.displaySetting === func.getPosDef('DISPLAYSETTING_JOINT')){
            if (judgeArg.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
              func.callbackInitComplete(root, false);
            }
            func.popupErrorNotClosed(root, config.posPopupMsg['msgSettingError']);
            return;
          }
        }*/
        if (isIndAxis) {
          if (config.displaySetting === func.getPosDef('DISPLAYSETTING_CART')){
            if (judgeArg.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
              func.callbackInitComplete(root, false);
            }
            func.popupErrorNotClosed(root, config.posPopupMsg['msgSettingError']);
            return;
          }
          reqPosFrame = top.COORDINATEJOINT;
        }
        if ((!isUndefPosInfo) && (posData != undefined)) { // valid pos data
          if (config.displaySetting !== func.getPosDef('DISPLAYSETTING_NORMAL')) {
            reqPosFrame = config.displaySetting;
          } else if ((reqPosFrame !== top.COORDINATECART) && (reqPosFrame !== top.COORDINATEJOINT)) {
            reqPosFrame = (posData.empty) ? config.currentFrame : reqPosFrame = posData.frame;
          }

          if ((reqPosFrame !== posData.frame) && (!posData.empty)) {
            isDifferntSetting = true;
            func.popupPositionAlert(root, config.posPopupMsg['msgSettingError'], null, null, {});
          }
          func.setConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING, isDifferntSetting);

          config.currentPosNumber = reqPosNum;
          root.setPosition(reqPosNum, posData); // Set to pos data area, when valid posnum.
          config.currentFrame = (posData.empty) ? reqPosFrame : posData.frame;
          func.toggleDisabledFormsExceptKindAndNum(root);
          root.dispPositionData(posData);

          // If call origin is refresh, callback initComplete.
          if (judgeArg.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
            func.disablePosNumMoveToBtn(root, false); //[#18288 bugv3 No26]
            func.callbackInitComplete(root, true); // Call initCompleteCallback
            config.isCallPNCallback = false;
            config.isCallPRCallback = false;
          }
          // [#11556] add check R/O
          func.toggleSelectableTextboxes(false, root);
          judgePosNumCallback();
        } else {
          if (posData == undefined) {
            posData = root.createRecord.get();
            posData.posNumber = reqPosNum;
          }
          config.currentPosNumber = reqPosNum;
          root.setPosition(reqPosNum, posData);//set dummy pos data.
          func.toggleDisabledFormsExceptKindAndNum(root);
          root.dispPositionData(posData);

          // If call origin is refresh, callback initComplete.
          if (judgeArg.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
            func.callbackInitComplete(root, true); // Call initCompleteCallback
            config.isCallPNCallback = false;
            config.isCallPRCallback = false;
          }
        }

        function judgePosNumCallback() {
          if (config.isCallPNCallback) {//call from changePosRecord()
            config.isCallPNCallback = false;
            if (typeof config.callback === 'function') {
              var notifyInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
              config.callback(root.id, 'selposnum', reqPosNum, notifyInfo); // Modify for match with other parts.
            }
          } else {
            if (judgeArg.origin == ihmi.position.posDef.DRAWORIGIN_GROUP) {
              // tap group tab
              func.callbackChangeGroupTab(root);
            }
          }
        }
      },
      // Notify update of position number list from editor.
      // posList : (IN) update position list.
      updatePositionList: function(posList) {
        //console.log("updatePositionList:" + posList);
        var root = this;
        var makePosArgs = {};
        makePosArgs.myRoot = root;
        makePosArgs.callback = undefined;
        makePosArgs.posListFromEditor = posList;
        root.refreshPosNumList(makePosArgs);
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      setCallbackTouchup: function(callback) {
        var root = this;
        root.config.callbackTouchUp = callback;
      },
      // [#11911] Set [Get Position Id List callback].
      setPrgInfoCallback: function(callback, fixedProgInfo, notifyEditPos) {
        var elem = this;
        var config = elem.config;
        config.prgInfoCallback_option = callback;  // eslint-disable-line camelcase

        if (fixedProgInfo && fixedProgInfo.progName) {
          config.targetProgramName = fixedProgInfo.progName;
        } else {
          console.log('[ERROR] ihcp setPrgInfoCallback: progName is empty');
        }
        if (fixedProgInfo && fixedProgInfo.lRegNums) {
          config.maxNumOfLocalRegs = fixedProgInfo.lRegNums;
        } else {
          console.log('[ERROR] ihcp setPrgInfoCallback: lRegNums is empty');
        }
        if (typeof notifyEditPos === "function") {
          config.notifyEditPos = notifyEditPos;
        }
      },
      dispPositionData: function(posData) {
        var root = this;
        var config = root.config;
        var confFunc = config.func;
        var iptElm = root.iptElm;
        var emptyStr = "********";
        var setValue;
        var dispFrame;
        var isEmpty = false;
        var isUndefPosInfo = confFunc.getConfigStatus(root, ihmi.position.posDef.STATUS_POSINFO_UNDEF);
        var errOccured = (config.status === ihmi.position.posDef.STATUS_OK) ? false : true;
        var isPosComp = root.selElm ? true : false; // this function shared with moveto component.

        if (!((config.currentPosKind === ihmi.position.posDef.POSKIND_NUM) &&
              (isUndefPosInfo))) {
          //if POSKIND_NUM selected, value is "" for red color.
          if (isPosComp) {
            root.selElm.btnSelPos.value = posData.posNumber;
          }
        }
        if (isPosComp) {
          iptElm.textboxComment.value = posData.comment;
        }
        if (!isUndefPosInfo) {
          dispFrame = (posData.empty) ? config.currentFrame : posData.frame;
          confFunc.switchPositionDisp(root, dispFrame); // switching position frame.
          Object.keys(iptElm).forEach(function(key) {
            // No switch disable mode when PosReg and UF/UT.
            switch (key) {
              case "textboxuf":
                setValue = (config.ufutFixedtoF || posData.empty) ? top.POS_REG_UF_VAL: posData.uf;
                break;
              case "textboxut":
                setValue = (config.ufutFixedtoF || posData.empty) ? top.POS_REG_UT_VAL: posData.ut;
                break;
              case "textboxComment":
                return;//N.A.
              case "textboxConf":
                setValue = (posData.empty) ? emptyStr: posData.conf;
                break;
              case "textPosRegNum":
                return;//N.A.
              case "textboxX":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.cart.X);
                break;
              case "textboxY":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.cart.Y);
                break;
              case "textboxZ":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.cart.Z);
                break;
              case "textboxW":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.cart.W);
                break;
              case "textboxP":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.cart.P);
                break;
              case "textboxR":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.cart.R);
                break;
              case "textboxJ1":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.joint.J1);
                break;
              case "textboxJ2":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.joint.J2);
                break;
              case "textboxJ3":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.joint.J3);
                break;
              case "textboxJ4":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.joint.J4);
                break;
              case "textboxJ5":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.joint.J5);
                break;
              case "textboxJ6":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.joint.J6);
                break;
              case "textboxE1":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.ext.E1);
                break;
              case "textboxE2":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.ext.E2);
                break;
              case "textboxE3":
                setValue = (posData.empty) ? emptyStr: confFunc.round3digit(posData.ext.E3);
                break;
              default:
                console.log('[ERROR] dispPositionData: no key:' + key);
                break;
            }
            this[key].value = setValue;
            if (!ihmi.cf.hasClass(this[key], "position-txt-disable")) {
              ihmi.cf.turnOnOffClass(this[key], 'position-txt-empty', posData.empty);
            }
          }, iptElm);
        }

        if (isPosComp) {
          var isReqMarkOn = ihmi.cf.getIsOnRequiredMark(root.btnElm.btnTouchUp);

          //checkAllGroup
          if (!errOccured) {
            isEmpty = checkEmptyAllGroup(posData);
          }

          if (isReqMarkOn !== isEmpty) {
            confFunc.toggleSelectableTextboxes(false, root);
            confFunc.toggleSelectableButton(root, false);
          }
          confFunc.toggleRequiredMark(root, isEmpty);
        } else {
          confFunc.disablePosNumMoveToBtn(root, posData.empty);
        }

        function checkEmptyAllGroup(posData) {
          var isEmpty = false;
          var posKind = config.currentPosKind;
          var allGrpInfo;
          if (posData.empty) {
            return true;
          }
          switch (posKind) {
            case ihmi.position.posDef.POSKIND_NUM:
              allGrpInfo = config.allGrpPosInfo;
              if (Array.isArray(allGrpInfo)) {
                for (var g = 0; g < allGrpInfo.length; g++) {
                  if (allGrpInfo[g].empty) {
                    isEmpty = true;
                    break;
                  }
                }
              }
              break;
            case ihmi.position.posDef.POSKIND_REG:
              allGrpInfo = config.allGrpPosRegInfo;
              Object.keys(allGrpInfo).forEach(function(key) {
                var posDataOneGrp = this[key];
                if (!posDataOneGrp.rep) {
                  isEmpty = true;// data is invalid or nothing.
                }
                return;
              }, allGrpInfo);
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
            case ihmi.position.posDef.POSKIND_REGARG:
              return false;
            default:
              console.log('[ERROR] checkEmptyAllGroup: invalid posKind');
              return false;
          }
          return isEmpty;
        }
      },
      getRobotAxesCount: function(grpNum) {
        var root = this;
        return root.config.posAxesCount.robot[grpNum];
      },
      getExtendAxesCount: function(grpNum) {
        var root = this;
        var config = root.config;
        // Get joint axes count.
        var axesCount = config.posAxesCount.joint[grpNum]; // Get Axes count of current group (total axes count)
        var robotCount = config.posAxesCount.robot[grpNum];
        var extAxes = axesCount - robotCount;
        return extAxes;
      },
      getJointAxesCount: function(grpNum) {
        var root = this;
        return root.config.posAxesCount.joint[grpNum];
      },
      getCurrentConfig: function() {
        var root = this;
        var config = root.config;
        return config.currentConfigStr;
      },
      postPosition: function(posRec) {
        var root = this;
        var rootId = root.id;
        var config = root.config;
        var func = config.func;
        var targetId;
        var calledCopyPosition = config.calledCopyPosition;
        config.calledCopyPosition = false;

        if (!config.func.checkInitComp(root)) {
          return;
        }

        if (config.isProgReadOnly) {
          if (calledCopyPosition) {
            config.allGrpPosInfoByNew = null;
          }
          ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
          return;
        }

        if (((posRec.posKind != ihmi.position.posDef.POSKIND_NUM) &&
              (posRec.posKind != ihmi.position.posDef.POSKIND_REG)) ||
            (posRec.posKind != config.currentPosKind)) {
              func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [1, 2, 3, 4]);
          return;
        }

        if (config.status !== ihmi.position.posDef.STATUS_OK) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [1, 2, 3, 4]);
          return;
        }

        if (config.currentFrame !== posRec.frame) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [1, 2, 3, 4]);
          return;
        }

        if (posRec.group == undefined) {
          posRec.group = config.currentGroupNum;
        }
        if (config.currentGroupNum !== posRec.group) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [1, 2, 3, 4]);
          return;
        }

        if ((posRec == undefined) || posRec.empty) {
          // Illegal record
          func.toastErrByCalledIf(root,
            config.posPopupMsg['msgNoExecPost'] + config.posPopupMsg['msgNoExecEmpty'],
            null);
          if (calledCopyPosition) {
            config.allGrpPosInfoByNew = null;
          }
          return;
        }

        if (!calledCopyPosition) {
          // Called publid I/F by stm.
          if (!checkNumber(root, posRec)) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [1, 2, 3, 4]);
            return; // Out of range
          }

          if (posRec.posKind == ihmi.position.posDef.POSKIND_REG) {
            if (posRec.comment != undefined) {
              posRec.chgCmnt = true;
            }
            root.savePosRegister(posRec, rootId + '.ifpost');
            return;
          }
        }

        // Set to position.
        root.setPosition(posRec.posNumber, posRec);
        root.dispPositionData(posRec);

        if (calledCopyPosition) {
          //selected New
          targetId = root.id + ".new";
        } else {
          targetId = root.id + ".ifpost";
        }
        root.putPositionRecord(posRec, targetId, true, true);

        // Check posRec number and current number are same.
        function checkNumber(root, posRec) {
          var config = root.config;
          var result = false;
          var reqNumber;
          switch (posRec.posKind) {
            case ihmi.position.posDef.POSKIND_NUM:
              // Check pos num list.
              if (posRec.posNumber === config.currentPosNumber) {
                result = true;
              }
              return result;
            case ihmi.position.posDef.POSKIND_REG:
              reqNumber = posRec.posRegNum;
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              reqNumber = posRec.posRegRegNum;
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              reqNumber = posRec.posRegArgNum;
              break;
            default:
              return result;
          }
          if (func.getCurrentKindNumber(config) === reqNumber){
            result = true;
          }
          return result;
        }
      },
      createRecord: {
        get: function() {
          var newRec = {
              posKind: 1, // 1=pos num, 2=pos reg
              posNumber: 0,
              posRegNum: 0,
              axes: 0, // axes count for pos reg
              comment: '',
              frame: -1,
              group: 1,
              uf: 0,
              ut: 0,
              conf: '',
              rep: 0,
              cart: {X: 0.0, Y: 0.0, Z: 0.0, W: 0.0, P: 0.0, R: 0.0},
              joint: {J1: 0.0, J2: 0.0, J3: 0.0, J4: 0.0, J5: 0.0, J6: 0.0},
              ext: {E1: 0.0, E2: 0.0, E3: 0.0},
              empty: true
          };
          return newRec;
        }
      },
      getCurrentPosNumber: function() {
        var root = this;
        root.config.func.checkInitComp(root);
        return root.config.currentPosNumber;
      },
      getCurrentProgramName: function() {
        var root = this;
        return root.config.targetProgramName;
      },
      getPosition: function(posNum) {//not recommended
        var root = this;
        var config = root.config;
        var func = config.func;
        var cbArg = {};
        var resultPosRec;
        var isExistNum;
        func.checkInitComp(root);
        posNum = parseInt(posNum);
        isExistNum = func.checkNumberRange(root, ihmi.position.posDef.POSKIND_NUM, posNum, false);
        if (posNum <= 0) {
          return undefined;
        }
        if ((isExistNum) &&
            (posNum === config.currentPosNumber)) {
          resultPosRec = JSON.parse(JSON.stringify(config.currentPosInfo));
          resultPosRec = func.createReturnParamByStatus(root, resultPosRec);
          return resultPosRec;
        }
        cbArg.rootElem = root;
        cbArg.callback = function(cbArg) {
          resultPosRec = cbArg.posRec;
          resultPosRec = func.createReturnParamByStatus(root, resultPosRec);
        };
        cbArg.isSync = true;
        cbArg.number = posNum;
        root.getPosValAndAnalize(cbArg);
        return resultPosRec;
      },
      getPositionAsync: function(posNum, callback, callbackarg) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var cbArg = {};
        var resultPosRec;
        var isExistNum;
        func.checkInitComp(root);
        posNum = parseInt(posNum);
        if (typeof callback !== 'function') {
          return;
        }
        if (posNum <= 0) {
          resultPosRec = undefined;
          callback(posNum, resultPosRec, callbackarg); // Call callback function.
        }
        isExistNum = func.checkNumberRange(root, ihmi.position.posDef.POSKIND_NUM, posNum, false);

        if ((isExistNum) &&
            (posNum === config.currentPosNumber)) {
          resultPosRec = JSON.parse(JSON.stringify(config.currentPosInfo));
          resultPosRec = func.createReturnParamByStatus(root, resultPosRec);
          callback(posNum, resultPosRec, callbackarg); // Call callback function.
          return;
        }
        cbArg.rootElem = root;
        cbArg.callback = function(cbArg) {
          posNum = cbArg.number;
          resultPosRec =  cbArg.posRec;
          resultPosRec = func.createReturnParamByStatus(root, resultPosRec);
          callback(posNum, resultPosRec, callbackarg); // Call callback function.
        };
        cbArg.isSync = false;
        cbArg.number = posNum;
        root.getPosValAndAnalize(cbArg);
      },
      getPositionMulti: function(posNum, isSync, callback, callbackarg) {
        var root = this;
        var cbArg = {};
        var resultPosRecArray = [];
        root.config.func.checkInitComp(root);
        posNum = parseInt(posNum);
        if (typeof callback !== 'function') {
          return;
        }
        if (posNum <= 0) {
          callback(posNum, resultPosRecArray, callbackarg); // Call callback function.
        }
        cbArg.rootElem = root;
        cbArg.callback = function(cbArg) {
          var config = cbArg.rootElem.config;
          var func = config.func;
          posNum = cbArg.number;
          resultPosRecArray = cbArg.posRecArray;
          for (var i = 0; i < resultPosRecArray.length; i++) {
            if (resultPosRecArray[i].group === config.currentGroupNum) {
              resultPosRecArray[i] = func.createReturnParamByStatus(root, resultPosRecArray[i]);
            }
          }
          callback(posNum, resultPosRecArray, callbackarg); // Call callback function.
        };
        cbArg.getAllGroup = true;
        cbArg.isSync = isSync;
        cbArg.number = posNum;
        root.getPosValAndAnalize(cbArg);
      },
      getPosInfoCurrentKind: function() {
        var root = this;
        var config = root.config;
        var func = config.func;
        var resultInfo;
        var posDataIndirect = {
          posKind: config.currentPosKind,
          group: config.currentGroupNum
        };
        func.checkInitComp(root);
        switch (config.currentPosKind) {
          case ihmi.position.posDef.POSKIND_NUM:
            resultInfo = JSON.parse(JSON.stringify(config.currentPosInfo));
            break;
          case ihmi.position.posDef.POSKIND_REG:
            resultInfo = JSON.parse(JSON.stringify(root.config.posRegRecord));
            break;
          case ihmi.position.posDef.POSKIND_REGREG:
            posDataIndirect['posRegRegNum'] = config.currentPosRegRegNum;
            resultInfo = posDataIndirect;
            break;
          case ihmi.position.posDef.POSKIND_REGARG:
            posDataIndirect['posRegArgNum'] = config.currentPosRegArgNum;
            resultInfo = posDataIndirect;
            break;
          default:
            console.log('[ERROR] getPosInfoCurrentKind: invalid posKind');
            return undefined;
        }
        resultInfo = func.createReturnParamByStatus(root, resultInfo);
        return resultInfo;
      },
      getPosNumList: function() {
        var root = this;
        var posNumList = root.config.posNumList;
        root.config.func.checkInitComp(root);
        return JSON.parse(JSON.stringify(posNumList));
      },
      getCurrentPosKind: function() {
        var root = this;
        root.config.func.checkInitComp(root);
        return root.config.currentPosKind; // PosNum=1, PosReg=2
      },
      getPosRegNumber: function() {
        var root = this;
        root.config.func.checkInitComp(root);
        return root.config.currentPosRegNum;
      },
      getPosRegister: function() {
        var root = this;
        var config = root.config;
        var func = config.func;
        var posRegData = JSON.parse(JSON.stringify(config.posRegRecord));
        if (config.currentPosKind !== ihmi.position.posDef.POSKIND_REG) {
          return undefined;
        }
        posRegData = func.createReturnParamByStatus(root, posRegData);
        root.config.func.checkInitComp(root);
        return posRegData;
      },
      setPosition: function(posNum, posData) {
        var root = this;
        var config = root.config;
        if ((posNum === config.currentPosNumber) &&
            (posData != undefined)) {
          config.currentPosInfo = JSON.parse(JSON.stringify(posData)); // deep copy
          if (config.confPreviousVal === undefined) {
            config.confPreviousVal = config.currentPosInfo.conf;
          }
          if (config.cmntPreviousVal === undefined) {
            config.cmntPreviousVal = config.currentPosInfo.comment;
          }
        }
      },
      toggleFrameType: function(posData, toFrameType) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var isPosKindNum = (config.currentPosKind == ihmi.position.posDef.POSKIND_NUM) ? true : false;
        var isPosKindReg = (config.currentPosKind == ihmi.position.posDef.POSKIND_REG) ? true : false;
        var execCheck = (top.g_crx &&
                         (config.currentGroupNum === 1) &&
                         (posData.frame == top.COORDINATEJOINT));
        if (!isPosKindNum && !isPosKindReg) {
          return;
        }
        if ((func.isSamePosRegNumSameAsServer) && (!func.isSamePosRegNumSameAsServer(root))) {
          //if edit posreg num and not update, no exchange.
          return;
        }
        if (func.isProgramProtectOn(config)) {
          ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
          return;
        }
        // If PosReg data is empty(nothing/undefined),
        if (posData.empty) {
          // Only toggle Cart./Joint display.
          root.config.currentFrame = toFrameType;
          if (isPosKindNum) {
            root.dispPositionData(posData);
          } else if (isPosKindReg) {
            // [#17465:v3 No.13] Polling has long intervals. call drawPosReg().
            config.isCallPRCallback = false;
            var drawArgs = {root: root, prNum: config.currentPosRegNum, origin: ihmi.position.posDef.DRAWORIGIN_NOCALLBACK};
            func.drawPosReg(drawArgs); // Draw for update and polling
          }
          return;
        }
        // convert format
        func.toggleDisabledForms(root, true);
        func.disableGroupTab(root, true);

        config.isConvertFrame = true; // Start PosReg record exchange.
        if (execCheck) {
          // Joint to Cart.
          // Exchange Joint->Cart->Joint, check that joint data are the same before and after conversion.
          func.checkConvCartToJoint(root, posData, true, setExchangedPosData);
        } else {
          // Carto to joint.
          func.convertPositionFormat(root, posData, setExchangedPosData);
        }
        // Callback function of complete exchange.
        function setExchangedPosData(status, posNum, posItem) {
          if ((status == top.IO_SUCCESS) && (posItem != undefined) && (!posItem.empty)) {
            // Exchange succeed.
            config.posRegRecord = JSON.parse(JSON.stringify(posItem));
            // view change to specified frame type.
            func.switchPositionDisp(root, posItem.frame);
            if (posItem.posKind == config.func.getPosDef('POSKIND_REG')) {
              root.savePosRegister(config.posRegRecord, root.id + '.altframebtn'); // Save the PosReg record
            } else {
              root.setPosition(posNum, posItem);
              root.putPositionRecord(posItem, root.id + '.altframebtn', true, true);
            }
            config.currentFrame = posItem.frame;
          } else {
            // not converted
            if (status == ihmi.position.posDef.CONVRSLT_DIFFERENT) {
              // check convert different.
              ihmi.cf.toast.show(config.posPopupMsg['msgErrConvToCart']);
            } else if (status == ihmi.position.posDef.CONVRSLT_CHECKINGOTHER) {
              // ignore
            } else {
              // Exchange failed.
              if (config.displaySetting !== config.func.getPosDef('DISPLAYSETTING_NORMAL')) {
                func.popupErrorNotClosed(root, config.posPopupMsg['msgSettingError']); // no continue.
              }
            }
          }
          func.toggleDisabledForms(root, false);
          func.disableGroupTab(root, false);

          config.isConvertFrame = false; // End PosReg record exchange.
          if (posItem.posKind != config.func.getPosDef('POSKIND_REG')) {
            root.dispPositionData(posItem); // PosReg is called within savePosRegister.
          }
        }
      },
      touchup: function(posNum, argObj, privateParam) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var origin = (privateParam != undefined) ? privateParam.origin: undefined;
        var operation = (privateParam != undefined) ? privateParam.createType: ihmi.position.posDef.CREATETYEP_USEOPE_OR_CALLEDIF;
        // origin, operation
        // touchup I/F called : origin == undefined / createType == CREATETYEP_USEOPE_OR_CALLEDIF
        // touchup button clicked : origin == undefined / createType == CREATETYEP_USEOPE_OR_CALLEDIF
        // new selected from empty position : origin == undefined / createType == CREATETYEP_NEW
        // change selposkind from posreg([reg/arg]) to position : origin == undefined / createType == CREATETYEP_SELPOSKIND
        // called from completeRefresh(number=0) : origin == DRAWORIGIN_REFRESH / createType == CREATETYEP_SELPOSKIND
        // called from refreshAnotherPosData() : origin == DRAWORIGIN_NEW / createType == CREATETYEP_SELPOSKIND

        // To avoid duplicate checks.
        // In the case of new or change of type, the format conversion has been checked before this function is called.
        var execCheckedConvCartJoint  = (privateParam != undefined) ? privateParam.execCheckedConvCartJoint: false;
        // the format conversion result
        var diffConvCartToJoint  = ((privateParam != undefined) && (privateParam.diffConvCartToJoint != undefined)) ? privateParam.diffConvCartToJoint : config.diffConvCartToJoint;
        var isValidRange = false;
        var frame;
        var touchupArg = {};
        // true(def): call function of setCallbackTouchup(). / false: don't call.
        touchupArg.doCallback = (typeof config.callbackTouchUp === 'function') ? true : false;
        // true(def): show touchup confirm popup. / false: don't show.
        touchupArg.doConfirmPopup = true;

        config.diffConvCartToJoint = false; // init

        if (origin != ihmi.position.posDef.DRAWORIGIN_REFRESH) { // no case of refresh(number=0).
          if (!func.checkInitComp(root)) {
            return;
          }
        }
        if (argObj) {
          if (argObj.doCallback === false) {
            touchupArg.doCallback = false;
          }
          if (argObj.doConfirmPopup === false) {
            touchupArg.doConfirmPopup = false;
          }
        }
        if (touchupArg.doCallback && (operation === ihmi.position.posDef.CREATETYEP_USEOPE_OR_CALLEDIF)) {
          doCallback(); // call callback, and no touchup.
          return;
        }

        if ((config.currentPosKind != func.getPosDef('POSKIND_NUM')) &&
           (config.currentPosKind != func.getPosDef('POSKIND_REG'))) {
          if (operation === ihmi.position.posDef.CREATETYEP_USEOPE_OR_CALLEDIF) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecRecPosError'], [1, 2, 3]);
          }
          return;
        }

        if (func.isProgramProtectOn(config)) {
          ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
          if (origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
            func.callbackInitComplete(root, false); // Call initCompleteCallback
          }
          return;
        }
        if (operation === ihmi.position.posDef.CREATETYEP_USEOPE_OR_CALLEDIF) {
          if (config.status !== ihmi.position.posDef.STATUS_OK) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecRecPosError'], [1, 2, 3]);
            return;
          }
          if (posNum == undefined) {
            // set current number.
            posNum = func.getCurrentKindNumber(config);
          }
          isValidRange = func.checkNumberRange(root, config.currentPosKind, posNum, false);
          if (!isValidRange) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecRecPosError'], [1, 2, 3]);
            return;
          }
          // User click touchp button or called touchup() I/F.
          if (execCheckedConvCartJoint) {
            // called from onclickTouchUp(), aleady checkConvCartJointBeforeRecPos() called.
            callPopupConfirm(); // aleady checked in onclickTouchUp().
          } else {
            // called from touchup() I/F.
            func.checkConvCartJointBeforeRecPos(root, false,
              function (execRecpos, isDiffernt) {
                if (execRecpos) {
                  if (isDiffernt) {
                    diffConvCartToJoint = true;
                  }
                  callPopupConfirm();
                }
                return;
              }
            );
          }
        } else {
          // In case create new position. Selected new or change posreg to posnum.
          settingTouchup(true);
        }
        /**
         * Callback registered by setCallbackTouchup()
         */
        function doCallback() {
          var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
          var number = func.getCurrentKindNumber(config);
          if (typeof config.callbackTouchUp === 'function') {
            //hook by stm
            setTimeout(function() {
              config.callbackTouchUp(root.id, 'touchup', number, cbInfo);
            }, 0);
            // Need for setTimeout
            //   ex
            //   If popupA popupB is same confirmMessage, unable to show popupB.
            //   setCallbackTouchup(callbackF);
            //   var callbackF = function () {
            //     confirmMessage(~, confirmBtnCb,~); //popupA
            //   }
            //   var confirmBtnCb = function (~) { ~
            //     touchup(~, argObj.doCallback=true, ~);
            //       -> callbackF is called again //popupB
            //   }
          }
        }
        function callPopupConfirm() {
          // [#11911] Get Position Id List. (call application callback function)
          if (((config.prgInfoCallback_option != undefined) && (typeof config.prgInfoCallback_option === 'function')) &&
              (config.currentPosKind != func.getPosDef('POSKIND_REG'))) { // and not PosReg.
            config.prgInfoCallback_option(getProgPosIdListCallback);
            return;
          }

          if (touchupArg.doConfirmPopup) {
            root.popupConfirm(config.posPopupMsg['msgIdConfTouchup'], popupTouchUpCallback);
          } else {
            popupTouchUpCallback('btn1', 'click');
          }
        }
        function getProgPosIdListCallback(cbArg) { // Callback from application.
          var numOfUse = 0;
          config.progPosIdList = cbArg['progPosIdList'];
          var progPosIdList = config.progPosIdList;
          for (var ref = 0; ref < progPosIdList.length; ref++) {
            if (progPosIdList[ref] == posNum) {
              numOfUse++;
            }
          }
          var confMsg = '';
          if (numOfUse > 1) { // Used in multiple command.
            confMsg = ihmi.cf.format(config.posPopupMsg['msgIdUseMultiCmd'], posNum); // Add to message.
          }
          confMsg += config.posPopupMsg['msgIdConfTouchup'];
          if ((numOfUse > 1) || touchupArg.doConfirmPopup) {
            root.popupConfirm(confMsg, popupTouchUpCallback);
          } else {
            popupTouchUpCallback('btn1', 'click');
          }
        }
        function popupTouchUpCallback(id, operation) {
          if (id == 'btn1') {
            func.toggleDisabledForms(root, true);
            top.rpcmc_iovalrd(top.tpin_type_c, 249, getTPValidCallback, config.targetProgramName, 0);
          }
        }
        function getTPValidCallback(iotype, index, validTP, progName, callbackarg2) {
          if (parseInt(validTP) == 0) {
            // Please TP ON.
            ihmi.cf.toast.show(config.posPopupMsg['msgEnableOff']);
            func.toggleDisabledForms(root, false);
            return;
          }
          settingTouchup(false);
        }
        function settingTouchup(isCreateNewPos) {
          var recPosRep = top.POS_REP_NONE;
          var msg = null;
          var robotPosFrame;
          if (top.g_crx) {
            robotPosFrame = func.getCrxRobotPosFrame(root, isCreateNewPos); // robot frame, not Independent Axis frame.
            if (robotPosFrame == top.COORDINATECART) {
              if (config.jposrecEnable === 1) {
                // If $JPOSREC_ENB is 1, recPos(joint).
                recPosRep = top.POS_REP_JOINT;
                if (!isCreateNewPos) {
                  msg = config.posPopupMsg['msgRecPosCartError'] + config.posPopupMsg['msgRecPosJoint'];
                }
              } else {
                if (diffConvCartToJoint) { // Differnt before and after conversion.
                  recPosRep = top.POS_REP_JOINT;
                  if (!isCreateNewPos) {
                    // if exist position and conv cart to joint, call popup.
                    msg = config.posPopupMsg['msgRecPosCartError']; // popup
                    msg += config.posPopupMsg['msgRecPosJoint'];
                  }
                }
              }
            }
          }
          execTouchUp(recPosRep, msg);
        }
        function execTouchUp(recPosRep, msg) {
          var cbArg = {};
          cbArg.posNum = posNum;
          cbArg.rec = {};
          cbArg.tblKind = 0;
          cbArg.grp = config.currentGroupNum;
          if (msg != null) {
            cbArg.alert = msg;
          }
          // Disable each elements.
          if (operation === ihmi.position.posDef.CREATETYEP_NEW) {
            func.toggleDisabledForms(root, true);
          }

          func.notifyEditPos && func.notifyEditPos(root, true);

          // [#9917] Call recPos().
          // [#11018:No.23] However, in the case of PosReg, it calls the original process.
          var pregFlag = ((config.currentPosKind != func.getPosDef('POSKIND_REG')) ? 0 : 1);
          top.recPos_multi(config.targetProgramName, posNum, recPosRep, top.TXML_TP_REC_TYPE, pregFlag, tupRecPosCallback, cbArg); // irprog_io
          // Since UTUF data can be retrieved at the time of recPos, the process of referencing individual system variables is not performed.
        }
        function tupRecPosCallback(status, progName, str, cbArg) {
          var posAnlArray;
          func.notifyEditPos && func.notifyEditPos(root, false);

          if (((status == top.IO_SUCCESS) || (status == top.IOSTAT_HRTL_022)) &&
              ((str != undefined) && (str.length > 0))) { // recpos succeeded or partially successful.
            posAnlArray = top.irprogapi.analyzeMultiPositionStr(str);
            if (config.currentPosKind != func.getPosDef('POSKIND_REG')) {
              //save all group info
              var comment = config.currentPosInfo.comment;
              var cbArg2 = {};
              cbArg2.rootElem = root;
              cbArg2.callback = updateAllGrpPosInfo;
              cbArg2.isSync = false;
              cbArg2.getAllGroup = true;
              func.analizePosTxtAndMakePosInfo(status, progName, posNum, str, comment, cbArg2, null);
            }
            for (var i = 0; i < posAnlArray.length; i++) {
              if (posAnlArray[i].GP === cbArg.grp) {
                if (cbArg.alert != null) {
                  // alert if change from cart to joint.
                  ihmi.cf.toast.show(cbArg.alert);
                }
                cbArg.rec = posAnlArray[i];
                //different current frame to recPos() result frame
                cbArg.rep = posAnlArray[i].rep;
                frame = config.func.getFrameRep(cbArg.rep);
                var setRec = setPositionRecord(frame, cbArg.rep, cbArg.grp, cbArg);
                storePositionData(setRec);
                return;
              }
            }
          }
          // below is error. alert and enable forms
          // eslint-disable-next-line no-console
          console.log('[ERROR] touchup: recpos() failed. status=(' + status + '), program=(' + progName + ')');
          config.deleteComment = false;
          if (operation === ihmi.position.posDef.CREATETYEP_USEOPE_OR_CALLEDIF) {
            func.popupPositionAlert(root, config.posPopupMsg['msgRecPosError'], null, null, {});
          } else {
            //if new pos, can't continue.
            func.popupErrorNotClosed(root, config.posPopupMsg['msgRecPosError']);
          }
          // setTimeOuf() if selposkind(rege to pos
          func.toggleDisabledForms(root, false);
          if (origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
            func.callbackInitComplete(root, false); // Call initCompleteCallback
          }
          function updateAllGrpPosInfo(updArg) {
            var root = updArg.rootElem;
            var posRecArray = updArg.posRecArray;
            var config = root.config;
            if (Array.isArray(posRecArray) && posRecArray.length > 1) {
              config.allGrpPosInfo = posRecArray;
            }
          }
        }
        // Setup the touchuped position data.
        function setPositionRecord(posFrame, posRep, grpNum, cbArg) {
          var posAnl = cbArg.rec;
          var posRec = root.createRecord.get();

          posRec.rep = posRep;
          posRec.frame = posFrame;
          posRec.group = grpNum;
          posRec.posNumber = cbArg.posNum;
          posRec.conf = posAnl.Config;
          posRec.uf = posAnl.UF;
          posRec.ut = posAnl.UT;
          if (posFrame == top.COORDINATECART) { // Cartesian.
            posRec.cart.X = posAnl.X;
            posRec.cart.Y = posAnl.Y;
            posRec.cart.Z = posAnl.Z;
            posRec.cart.W = posAnl.W;
            posRec.cart.P = posAnl.P;
            posRec.cart.R = posAnl.R;
          } else { // Joint.
            posRec.joint.J1 = posAnl.J1;
            posRec.joint.J2 = posAnl.J2;
            posRec.joint.J3 = posAnl.J3;
            posRec.joint.J4 = posAnl.J4;
            posRec.joint.J5 = posAnl.J5;
            posRec.joint.J6 = posAnl.J6;
          }
          posRec.ext.E1 = posAnl.EXT1;
          posRec.ext.E2 = posAnl.EXT2;
          posRec.ext.E3 = posAnl.EXT3;
          posRec.empty = false;

          return posRec;
        }
        // Put or Save position record / position register data.
        function storePositionData(posData) {
          if (config.currentPosKind != func.getPosDef('POSKIND_REG')) {
            // Fill in the data (comments) that is not acquired.
            var posOrgRec = config.currentPosInfo;
            posData.comment = ((posOrgRec === undefined) || (posOrgRec.comment === undefined) || config.deleteComment) ? '' : posOrgRec.comment;
            config.deleteComment = false;
            config.posNumList.push(posData.posNumber);
            config.posNumList = Array.from(new Set(config.posNumList));//Deduplication
            config.posNumList.sort(function(a,b){//sort
              if ( a < b ) return -1;
              if ( a > b ) return 1;
              return 0;
            });
            var judgeArg = {number: posData.posNumber, frame: posData.frame, origin: origin, posRec: posData};
            root.judgeDrawPosition(judgeArg);
            // Refrect another component and each button.
            root.putPositionRecord(posData, root.id + "." + operation, false, (origin != ihmi.position.posDef.DRAWORIGIN_REFRESH));
          } else {
            var targetRec = root.createRecord.get(); // Create new record.
            targetRec.group = config.currentGroupNum;
            targetRec.posRegNum = Number(posData.posNumber);
            // Fill in the data (comments) that is not acquired.
            // PosReg handles comments separately, but I will add it just in case.
            posData.comment = config.posRegRecord.comment; // copy comment.
            posData.force = true; // data to force.
            posData.chgCmnt = false; // no change comment.
            func.setPosRegTupVal(root, posData, targetRec); // set to config.posRegRecord.
            // [#11018:No.22] resume element to enable.
            func.toggleDisabledForms(root, false);
            root.savePosRegister(config.posRegRecord, root.id + ".touchup"); // Save the PosReg record
          }
        }
      },
      copyPosition: function(posNum) {
        var root = this;
        var config = root.config;
        var posInfo = JSON.parse(JSON.stringify(config.currentPosInfo));//current group info
        var posRecArray = JSON.parse(JSON.stringify(config.allGrpPosInfo));//all group info
        posInfo.posNumber = posNum;//change new pos number

        if (Array.isArray(posRecArray)) {
          for (var i = 0; i < posRecArray.length; i++) {
            posRecArray[i].posNumber = posNum; //edit new pos num
          }
          config.allGrpPosInfoByNew = posRecArray;
        }
        config.calledCopyPosition = true;
        config.currentPosNumber = posNum;
        root.postPosition(posInfo);
      },
      moveto: function(event, posNum) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var posMovetoRec = (config.currentPosKind != func.getPosDef('POSKIND_REG')) ?
            config.currentPosInfo: config.posRegRecord;
        var ufutSystemValue;
        var moveToBtn = root.btnElm.btnMoveTo;
        var switchArgs = {};
        var isPosComp = root.selElm ? true : false; // this function shared with moveto component.
        switchArgs.srcRoot = root;

        if ((posMovetoRec == undefined) || (posMovetoRec.empty)) {
          // eslint-disable-next-line no-console
          console.log('[ERROR] moveto: Position data is not found.(' + posNum + ')');
          return; // Position data is not found.
        }

        // 1st check. Get TP condition.
        top.rpcmc_iovalrd(top.tpin_type_c, 249, getTPValidCallback, undefined, undefined);

        // Functions
        function getTPValidCallback(iotype, index, validTP, progName, callbackarg2) {
          //console.log('getTPValid: status(' + validTP + ')');
          if (parseInt(validTP) == 0) {
              // Please TP ON.
              popupAlert(config.posPopupMsg['msgEnableOff']);
              return;
          }
          // get Alarm status
          top.rpcmc_iovalrd(top.tpout_type_c, 1, getAlarmStatusCallback);
        }
        function popupAlert(message) {
          ihmi.cf.toast.show(message);
          // [#16602] finish move event.
          config.mvbtnActive = false; // Move to inactive.
          root.onendMvTo(event);
          return;
        }
        function getAlarmStatusCallback(iotype, index, alarmStatus, progName, callbackarg2) {
          //console.log('getAlarmStatus: status(' + alarmStatus + ')');
          if (parseInt(alarmStatus) == 1) {
            // Please reset alarm.
            popupAlert(config.posPopupMsg['msgIdResetAlarm']);
            return;
          }
          // check program behavior.
          top.rpcmc_getVar(top.SYSNAME_C, '$ALM_IF.$CURR_STAT', getCurrentProgStat, null);
        }
        function getCurrentProgStat(sysName, varName, type_code, currStat, cbArg) { // eslint-disable-line camelcase
          //console.log('getCurrentProgStat: status(' + currStat + ')');
          if ((config.useProg == undefined) || (config.useProg == true)) {
             // check program status if position component or moveto component(useProg==true)
            if (currStat.trim() != config.posPopupMsg['statAborted']) {
              popupAlert(config.posPopupMsg['msgIdProgExec']);
              return;
            }
          }
          var sysValObj = { system: ['$MNUFRAMENUM[' + config.currentGroupNum + ']', '$MNUTOOLNUM[' + config.currentGroupNum + ']'] };
          top.irprogapi.getSystemValByXvr(sysValObj, GetUFUTValueCallback, 'currentProgStat.cvr');
        }
        function GetUFUTValueCallback(cbArg, xmlError) {
          // check uf/ut... valid = joint or uf/ut is match.
          // PosReg does not check the UF/UT value, it uses the system value.
          var sysGrpTable = {
            UF: cbArg['$MNUFRAMENUM[' + config.currentGroupNum + ']'],
            UT: cbArg['$MNUTOOLNUM[' + config.currentGroupNum + ']']
          };
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp GetUFUTValueCallback: xml error detect');
          }
          ufutSystemValue = sysGrpTable; // current UF/UT value.
          if (posMovetoRec.posKind != func.getPosDef('POSKIND_REG')) {
            if (posMovetoRec.frame != top.COORDINATEJOINT) {
              // Check UF/UT value.
              if ((ufutSystemValue.UF != posMovetoRec.uf) || (ufutSystemValue.UT != posMovetoRec.ut)) {
                popupAlert(config.posPopupMsg['msgIdIlgUfUt']);
                return;
              }
            }
          }
          movetoProc();
        }
        function movetoProc() {
          // Check Movement-only program exist.
          top.loadFile(func.getPosDef('MOVETOPROGRAMNAME') + '.LS', loadMovetoProgram, 0); // irprog_io
        }
        function loadMovetoProgram(status, progName, lines, lineCount, arg) {
          var extPos = progName.indexOf('.LS'); // have extension
          var progOmitExt = (extPos >= 0) ? progName.substr(0, extPos) : progName;
          if (status != top.IO_SUCCESS) { // May be not exist program...
            // Create movement-only program
            top.createPrg(progOmitExt, createdMovetoProg); // irprog_io
            return;
          }
          // update motion instruction.
          setMotionGroupCallback(null, progOmitExt, 'PRGWRITE_OVW');
        }
        function createdMovetoProg(status, progName) {
          var PG_PAUS_ABRT_C = 8;
          top.setAttr(progName, top.MM_IGNR_PAUS_C, PG_PAUS_ABRT_C, setVisibilityCallback);
        }
        function setVisibilityCallback(status, progName) {
          top.setAttr(progName, top.MM_CONTROL_C, '1', setMotionGroupCallback); // irprog_io
        }
        function setMotionGroupCallback(status, progName, prgWriteStr) {
          top.setAttr(progName, top.MM_DEF_GROUP_C, Math.pow(2, (config.currentGroupNum - 1)), makeMoveToProg); // irprog_io

          // Add a program line if the program is newly created, or overwrite it if it is existing.
          function makeMoveToProg(status, progName) {
            var movetoInstStr = func.getPosDef('MOVETOMOTIONINST') + func.getPosDef('MOVETOTERMINATECH');
            top.editPrg(progName, movetoInstStr, 1, func.getPosDef(prgWriteStr || 'PRGWRITE_ADD'), initMovetoProgCallback); // irprog_io
          }
        }
        function initMovetoProgCallback(status, progName) {
          // Call editPos()
          var posTempRec = JSON.parse(JSON.stringify(posMovetoRec));
          posTempRec.posNumber = 1;   // moveto position is number 1.
          posTempRec.comment = ''; // no need comment.
          // If the source record is PosReg, the UF/UT value will use the system value.
          if (config.currentPosKind == func.getPosDef('POSKIND_REG')) {
            posTempRec.uf = ufutSystemValue.UF;
            posTempRec.ut = ufutSystemValue.UT;
          }
          var posDataText = root.positionString(posTempRec, null);
          top.editPos(progName, posDataText, editPosCallback); // irprog_io
        }
        function editPosCallback(status, progName) {
          var line_num = 1;       // eslint-disable-line camelcase
          var exec_type = 7;      // eslint-disable-line camelcase
          var pause_on_shift = 0; // eslint-disable-line camelcase
          var tp_motion = 1;      // eslint-disable-line camelcase
          var wait_type = 0;      // eslint-disable-line camelcase
          if (config.mvbtnActive) {
            ihmi.cf.addClass(moveToBtn, 'position-moveto-on');
            switchArgs.toDisable = true;
            if (isPosComp) {
              func.switchDisablePosText(switchArgs);
              func.switchDisableOperationButton(switchArgs);
              func.switchDisablePosNumAndRegNum(switchArgs);
            }
            // If position component, It link width TP Program, and other position components.
            // Therefore, disabled all forms in position components.
            // But in case move to component, does not work with TP Program and other components.
            // Moveto components no need to disable.
            disableMoveToBtnInMovetoCmps(switchArgs.toDisable);
            // In case position component,
            // Disable Pos mode select
            func.switchDisableModeSel && func.switchDisableModeSel(switchArgs);
            // Polling off when MoveTo is active. (Pos Reg)
            func.stopGetPosRegPolling && func.stopGetPosRegPolling(config);
            top.runTask(progName, progName, line_num, exec_type, pause_on_shift, tp_motion, wait_type, runTaskCallback, 0);
          } else {
            return;
          }
        }
        function runTaskCallback(status, progName) {
          // Process of execute program of movement.
          setTimeout(function() {
              top.rpcmc_iovalrd(top.tpout_type_c, 5, watchMovetoStatusCallback, progName, 0);
          }, 200);
        }
        function watchMovetoStatusCallback(type, mode, status, progName, cbArg2) {
          //console.log('movetoStatusCallback: status=' + status);
          if (status == func.getPosDef('WATCHEXEC_ABORTED')) {  // if finished... stop moveto
            // eslint-disable-next-line no-console
            //console.log('[INFO] Program is already aborted.');
            stopMovetoProgram(progName);
            return;
          }
          setTimeout(function() {
            top.rpcmc_iovalrd(top.tpout_type_c, 5, watchMovetoStatusCallback, progName, 0);
          }, 10);
        }
        function stopMovetoProgram(progName) {
          //console.log('stopMovetoProgram: progName=' + progName);
          top.setAttr(progName, top.MM_CONTROL_C, '1', completeMovetoProg); // irprog_io
        }
        function completeMovetoProg (status, progName) {
          ihmi.cf.removeClass(moveToBtn, 'position-moveto-on');
          config.mvbtnActive = false; // Move to inactive.
          root.onendMvTo(event);
          switchArgs.toDisable = false;
          if (isPosComp) {
            func.switchDisablePosText(switchArgs);
            // button enable
            func.switchDisableOperationButton(switchArgs);
            // position select enable
            func.switchDisablePosNumAndRegNum(switchArgs);
            // Resume (Enable) Pos mode select
            func.switchDisableModeSel && func.switchDisableModeSel(switchArgs);
            // Polling on when MoveTo is finished. (Pos Reg)
            if (config.currentPosKind == func.getPosDef('POSKIND_REG')) {
              config.isCallPRCallback = false;
              var drawArgs = {root: root, prNum: config.currentPosRegNum, origin: ihmi.position.posDef.DRAWORIGIN_NOCALLBACK};
              func.drawPosReg(drawArgs); // Draw for update and polling
            }
          }
          disableMoveToBtnInMovetoCmps(switchArgs.toDisable);
        }

        // disable/enable moveto btn in all moveto components.
        function disableMoveToBtnInMovetoCmps(toDisable) {
          var movetoes = root.ownerDocument.querySelectorAll('div.ihcp-moveto');
          var positions;
          var targetCompo;
          var targetConf;

          // disable moveto component's button.
          for (var midx = 0; midx < movetoes.length; midx++) {
            targetCompo = movetoes[midx];
            if (root.id == targetCompo.id) { // Skip myself
              continue;
            }
            targetConf = targetCompo.config;
            if ((targetConf !== undefined) && targetConf.initialized) {// Initialization is not yet complete.
              targetConf.func.disablePosNumMoveToBtn(targetCompo, toDisable);
              if (targetCompo.selElm) { // target is position component
                targetConf.func.disablePosRegMoveToBtn(targetCompo, toDisable);
              }
            }
          }

          if (isPosComp) {
            return;
          }

          // If self is moveto component, disabl other all moveto button.
          positions = root.ownerDocument.querySelectorAll('div.position');

          for (var pidx = 0; pidx < positions.length; pidx++) {
            targetCompo = positions[pidx];
            if (root.id == targetCompo.id) { // Skip myself
              continue;
            }
            targetConf = targetCompo.config;
            if ((targetConf !== undefined) && targetConf.initialized) {// Initialization is not yet complete.
              targetConf.func.disablePosNumMoveToBtn(targetCompo, toDisable);
              targetConf.func.disablePosRegMoveToBtn(targetCompo, toDisable);
            }
          }
        }
      },
      popupConfirm: function(message, popupBtnCallback) {
        var root = this;
        var config = root.config;
        var id = 'posalert';
        var doc = root.ownerDocument;
        var popupFrameMain;
        var rootFrameMain = ihmi.cf.getDefaultView(doc);
        var customizeObj = {};

        customizeObj.selectBtn = {
          1 : {label: config.posPopupMsg['dlgBtnIdOk']},
          2 : {label: config.posPopupMsg['dlgBtnIdCancel']}
        };
        if (rootFrameMain == null) return;
        popupFrameMain = ihmi.cf.findAncestorFrame(rootFrameMain, config.popupPos);
        if (rootFrameMain !== popupFrameMain) {
          customizeObj.callerWindowObj = rootFrameMain;//if unload caller window object, removeFrame() called;
        }
        ihmi.cf.confirmMessage(config.myWebPage, message, id, undefined, null, popupFrameMain, popupBtnCallback, null, customizeObj);
      },
      positionString: function(posRec, allGrpPosInfo) {
        var root = this;
        var config = root.config;

        function convFtoA(fVal) {
          if (fVal === '') {
            return ' ****.******';
          }
          // 'toFixed' is only Number, so convert if it is a string.
          if (typeof fVal === 'string') {
            fVal = parseFloat(fVal);
          }
          var fStr = ' ' + fVal.toFixed(6); // Rounded to 6 decimal places
          return fStr;
        }

        function makePosTxt(posRec, allGrpPosInfo) {
          // Gen. pos header
          var posText = '';
          var allGrpInfo = [];
          var otherGroupPosRec;
          var encStr = '';
          posText += config.posLSText['posCommandStr'] + '[' + posRec.posNumber;
          if (posRec.comment != '') {
            encStr = posRec.comment;
            encStr = encStr.replace(/%/g, '%25').replace(/#/g, '%23').replace(/\+/g, '%2B');
            posText += ':"' + encStr + '"';
          }
          posText += ']{' + top.CODECRLF;
          makePosTxtOneGrp(posRec);

          if (allGrpPosInfo && Array.isArray(allGrpPosInfo)) {
            allGrpInfo = JSON.parse(JSON.stringify(allGrpPosInfo));
            //copy position
            for (var i = 0; i < allGrpInfo.length; i++) {
              otherGroupPosRec = allGrpInfo[i];
              if ((otherGroupPosRec.posNumber === posRec.posNumber) &&
                  (config.currentGroupNum !== otherGroupPosRec.group)) {
                makePosTxtOneGrp(otherGroupPosRec);
              }
            }
          }

          function makePosTxtOneGrp(targetPosRec) {
            // Gen. group block
            // group header
            posText += '   GP' + targetPosRec.group + ':' + top.CODECRLF;
            posText += top.CODETAB + 'UF : ' + targetPosRec.uf + ', ';
            posText += 'UT : ' + targetPosRec.ut + ', ';
            // Either rec.X or rec.J1 may be used for judgment.
            if (targetPosRec.frame == top.COORDINATECART) {
              posText += top.CODETAB + top.CODETAB + config.posLSText['posConfigStr'] + ':\'' + targetPosRec.conf + '\',';
            }
            posText += top.CODECRLF;
            // position data
            var robotAxes = root.getRobotAxesCount(targetPosRec.group);
            var axesUnit = config.posAxesUnit[targetPosRec.group];
            if (targetPosRec.frame == top.COORDINATECART) {  // Cartesian
              posText += top.CODETAB + 'X = ' + convFtoA(targetPosRec.cart.X) + '  mm,';
              posText += top.CODETAB + 'Y = ' + convFtoA(targetPosRec.cart.Y) + '  mm,';
              posText += top.CODETAB + 'Z = ' + convFtoA(targetPosRec.cart.Z) + '  mm,' + top.CODECRLF;
              posText += top.CODETAB + 'W = ' + convFtoA(targetPosRec.cart.W) + ' deg,';
              posText += top.CODETAB + 'P = ' + convFtoA(targetPosRec.cart.P) + ' deg,';
              posText += top.CODETAB + 'R = ' + convFtoA(targetPosRec.cart.R) + ' deg';
            } else {  // Joint
              for (var m = 0; m < robotAxes; m++) {
                if (m > 0) {
                  posText += ',';
                }
                if (m == 3) {
                  posText += top.CODECRLF;
                }
                posText += top.CODETAB + 'J' + (m + 1) + '= ' + convFtoA(targetPosRec.joint['J' + (m + 1)]) + ' ' + axesUnit[m];
              }
            }
            var extendAxes = root.getExtendAxesCount(targetPosRec.group);
            if (extendAxes > 0) {
              posText += ',' + top.CODECRLF;
              for (var ext = 1; ext <= extendAxes; ext++) {
                if (ext > 1) {
                  posText += ',';
                }
                posText += top.CODETAB + 'E' + ext + '= ' + convFtoA(targetPosRec.ext['E' + ext]);
                // The unit of the extend axis is specified from the continuation of the robot axis.
                posText += ' ' + axesUnit[ext + (robotAxes - 1)];
              }
            }
            posText += top.CODECRLF;
          }
          posText += '};' + top.CODECRLF;
          return posText;
        }

        if (posRec == undefined) {
          return '';
        }
        return makePosTxt(posRec, allGrpPosInfo);
      },
      savePosition: function(argObj, newUfutVal) {
        var posNumber = argObj.posNumber;
        var targetId = argObj.targetId;
        var root = argObj.root;
        var doc = root.ownerDocument;
        var config = root.config;
        var func = config.func;
        var posData = config.currentPosInfo;
        var ufutSysVal;

        if (config.currentPosKind !== ihmi.position.posDef.POSKIND_NUM) {
          return;//error
        }
        function correctedPosData(posData) {
          root.setPosition(posData.posNumber, posData);  // posData refrect to position array.
          root.dispPositionData(posData);
          root.putPositionRecord(posData, targetId, true, true);
        }
        if (posData == undefined) {
          //not call drawPosition()
          posData = root.createRecord.get(); // Position data is not found.
          posData.group = config.currentGroupNum;
        }
        if (posData.empty) {
          posData.frame = config.currentFrame;
          posData.posNumber = posNumber;
          ufutSysVal = newUfutVal;
        }
        // Update and save the corrected position data only.
        if (targetId.indexOf('.cmnttxt') >= 0) {
          posData.comment = doc.getElementById(targetId).value;
          if (!posData.empty) {
            root.setPosition(posNumber, posData); // posData refrect to position array.
            root.putPositionRecord(posData, targetId, true, true);
          }
        } else {
          if (config.currentFrame == top.COORDINATECART) {
            var cartIdentifyList = [/.uftxt/, /.uttxt/, /.conftxt/, /.cartxtxt/, /.cartytxt/, /.cartztxt/, /.cartwtxt/, /.cartptxt/, /.cartrtxt/];
            var cartPosIdList = ['uf', 'ut', 'conf'];
            cartPosIdList = cartPosIdList.concat(config.func.getPosDef('CARTESIANKEY'));
            if (posData.empty) {
              // set initialize data.
              if (cartIdentifyList[0].test(targetId)) {
                posData.uf = parseInt(doc.getElementById(targetId).value);
                posData.ut = ufutSysVal.UT;
                posData.conf = config.currentConfigStr;
              } else if (cartIdentifyList[1].test(targetId)) {
                posData.uf = ufutSysVal.UF;
                posData.ut = parseInt(doc.getElementById(targetId).value);
                posData.conf = config.currentConfigStr;
              } else if (cartIdentifyList[2].test(targetId)) {
                posData.uf = ufutSysVal.UF;
                posData.ut = ufutSysVal.UT;
                posData.conf = doc.getElementById(targetId).value;
              } else {
                for (var cIdx = 3; cIdx < cartIdentifyList.length; cIdx++) {
                  if (cartIdentifyList[cIdx].test(targetId)) {   // match
                    posData.cart[cartPosIdList[cIdx]] = parseFloat(doc.getElementById(targetId).value);
                    break;
                  }
                }
                posData.uf = ufutSysVal.UF;
                posData.ut = ufutSysVal.UT;
                posData.conf = config.currentConfigStr;
              }
              posData.rep = func.getRepKind(root, posData.frame, posData.group);
              posData.empty = false;
            } else {
              for (var n = 0; n < cartIdentifyList.length; n++) {
                if (cartIdentifyList[n].test(targetId)) {   // match
                  if (n < 2) {
                    posData[cartPosIdList[n]] = parseInt(doc.getElementById(targetId).value);
                  } else if (n == 2) {
                    posData[cartPosIdList[n]] = doc.getElementById(targetId).value;
                  } else {
                    posData.cart[cartPosIdList[n]] = parseFloat(doc.getElementById(targetId).value);
                  }
                  break;
                }
              }
            }
          } else {  // Joint
            for (var jIdx = 0; jIdx < 6; jIdx++) {
              var targetPosId = '.jnt' + (jIdx + 1) + 'txt';
              var jointIdTest = new RegExp(targetPosId);
              if (jointIdTest.test(targetId)) {
                posData.joint['J' + (jIdx + 1)] = parseFloat(doc.getElementById(targetId).value);
                break;
              }
            }
            if (posData.empty) {
              posData.uf = ufutSysVal.UF;
              posData.ut = ufutSysVal.UT;
              posData.rep = func.getRepKind(root, posData.frame, posData.group);
            }
            posData.empty = false;
          }
          // Check extend axes...
          var extendAxes = root.getExtendAxesCount(posData.group);
          if (extendAxes > 0) {
            for (var eIdx = 0; eIdx < 6; eIdx++) {
              var targetExtId = '.ext' + (eIdx + 1) + 'txt';
              var extIdTest = new RegExp(targetExtId);
              if (extIdTest.test(targetId)) {
                posData.ext['E' + (eIdx + 1)] = parseFloat(doc.getElementById(targetId).value);
                break;
              }
            }
          }
          correctedPosData(posData);
        }
      },
      putPositionRecord: function(posData, targetId, isCallEditPos, callbackCall) {
        var root = this;
        var doc = root.ownerDocument;
        var config = root.config;
        var func = config.func;
        var allGrpInfo = ((config.allGrpPosInfoByNew !== null) ? config.allGrpPosInfoByNew : config.allGrpPosInfo);
        var mergeDataArray = [];
        var mergeArgs;
        var editPosRowText;
        if (config.allGrpPosInfoByNew !== null) {
          allGrpInfo = JSON.parse(JSON.stringify(config.allGrpPosInfoByNew));
          config.allGrpPosInfoByNew = null;
        } else {
          allGrpInfo = JSON.parse(JSON.stringify(config.allGrpPosInfo));
        }

        if (posData == undefined) { // Position is empty.
          // eslint-disable-next-line no-console
          console.log('[ERROR] putPositionRecord: Position data is empty.');
          return;
        }
        if (posData.posKind == func.getPosDef('POSKIND_NUM')) {
          // Disable each button until save position data.
          func.toggleDisabledForms(root, true);
        }

        // I/F call
        if (isCallEditPos) { // If need to call an interface.
          func.notifyEditPos && func.notifyEditPos(root, true);
          if (Array.isArray(allGrpInfo) && allGrpInfo.length > 1) {
            mergeDataArray.push(posData);
            mergeArgs = { baseData: allGrpInfo, mergeData: mergeDataArray, armType: config.armType };
            top.irprogapi.editMergePositionData(config.targetProgramName, mergeArgs, putPosRowCallback);
          } else {
            editPosRowText = root.positionString(posData, null);
            top.editPos(config.targetProgramName, editPosRowText, function(status, progName) {
              putPosRowCallback({status: status, progName: progName});
            });
          }
        } else {
          putPosRowCallback({status: top.IO_SUCCESS});
        }

        function putPosRowCallback(response) {
          if (isCallEditPos) {
            func.notifyEditPos && func.notifyEditPos(root, false);
          }
          //console.log('putPosRowCallback: status=' + response.status + '/ progName=' + progName + '.');
          var strValidateResult;
          var cmntId = root.id + '.cmnttxt';
          var previousVal;
          // to enable each button.
          func.toggleDisabledForms(root, false);
          func.updateAllGroupInfo(root);
          if (response.status !== top.IO_SUCCESS) {
            // Failed to save Configuration data.
            previousVal = (targetId === cmntId) ? config.cmntPreviousVal : config.confPreviousVal;
            strValidateResult = new Error(config.posPopupMsg['msgSaveError']);
            return func.validateError(root, strValidateResult, targetId, previousVal);
          }
          if (posData.posKind == func.getPosDef('POSKIND_NUM')) { // Reflect data to another component
            refreshAnotherPosData(posData);
          }
          // update previous
          config.confPreviousVal = posData.conf;
          config.cmntPreviousVal = posData.comment;

          // Call callback function.
          if ((typeof config.callback === 'function') && callbackCall) {
            // Modify for match with other parts.
            var posDataNumber = (config.currentPosKind == ihmi.position.posDef.POSKIND_REG) ?
                posData.posRegNum: posData.posNumber;
            var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
            var operation = func.convIdToOpeStr(root, targetId);
            config.callback(root.id, operation, posDataNumber, cbInfo);
          }
        }

        //refresh another position component in only same document.
        function refreshAnotherPosData(srcPosData) {
          var srcElem = root;
          var srcConfig = srcElem.config;
          var positions = doc.querySelectorAll('div.position');
          var srcPosNum = srcConfig.currentPosNumber;
          var destPos;
          var destSelPosNum;
          var destConfig;

          if (positions.length > 1) {
            srcElem.updatePositionList(JSON.parse(JSON.stringify(srcConfig.posNumList)));
          }

          //search position component on same document.
          for (var i = 0, len = positions.length; i < len; i++) {
            destPos = positions[i];
            destConfig = destPos.config;

            if (srcElem.id !== destPos.id) {
              //refresh pos number list
              destSelPosNum = doc.getElementById(destPos.id + '.selposnum');
              if (destSelPosNum === null) {
                continue; //not component
              }
              // The position data kind is not "pos_num".
              if (destConfig.currentPosKind != func.getPosDef('POSKIND_NUM')) {
                continue; // skip refresh.
              }
              // The target group number is different.
              if (destConfig.currentGroupNum != srcPosData.group) {
                continue;
              }

              destPos.setPosition(srcPosNum, srcPosData); // posData refrect to position array.

              if (destPos.config.currentPosNumber === srcPosNum) { // Same number
                destConfig.currentFrame = srcPosData.frame;
                destPos.dispPositionData(srcPosData);
                if (destPos.config.status !== ihmi.position.posDef.STATUS_OK) {
                  var drawArgs = {root: destPos, posNum: srcPosNum, posFrame: null, origin: ihmi.position.posDef.DRAWORIGIN_REFRESH};
                  destConfig.func.drawPosition(drawArgs);
                }
              }
            }
          }
        }
      },
      savePosRegister: function(posRegRec, targetId) {
        var root = this;
        var config = root.config;
        var func = config.func;

        if (config.isContinuingInput) { // Some textbox is active.
          // Check again
          setTimeout(function() {
            if (root.config.isContinuingInput) { // textbox is active
              return; // no save.
            }
          }, 0);
        }
        if (targetId.indexOf('.touchup') > 0) {
          setPosRegCallback();
          return;
        }
        // Save to position register.
        var writeRec = createPosRegWriteData(posRegRec);
        // data exchange?
        if (config.currentFrame != posRegRec.frame) {
          writeRec.force = true;
        }
        var writeRecs = [];
        writeRecs[0] = writeRec;
        top.irprogapi.setPosRegValue(config.currentGroupNum, writeRecs, setPosRegCallback);

        /*
        * Create Position Register write data
        * (porting from pceditor_posreg.js)
        */
        function createPosRegWriteData(record) {
          var grpNum = record.group;
          var writePRData = {};
          writePRData.id = record.posRegNum;
          writePRData.gnum = grpNum;
          writePRData.comment = (record.comment == undefined) ? '' : record.comment;
          writePRData.force = (record.force != undefined) ? record.force: false;
          writePRData.only_cmt_flag = false;  // eslint-disable-line camelcase
          writePRData.only_pos_flag = (record.chgCmnt != undefined) ? !record.chgCmnt: true;  // eslint-disable-line camelcase
          record.chgCmnt = false; // reset change comment flag.
          if (record.conf.length == 0) {
            record.conf = config.currentConfigStr;
          }
          var axesCount = func.getPosDef('MAXROBOTAXES');
          var fromExtStrs = func.getPosDef('EXTAXESKEY');
          for (var i = 0; i < top.REF_POS_EXT.length; i++) {
            var fromExtStr = fromExtStrs[i];
            var up_str = top.REF_POS_EXT[i];  // eslint-disable-line camelcase
            if (record.ext[fromExtStr] !== '') {
              writePRData[up_str] = {};       // eslint-disable-line camelcase
              writePRData[up_str].data = record.ext[fromExtStr];  // eslint-disable-line camelcase
              writePRData[up_str].unit = getJointUnitStr(grpNum, axesCount);  // eslint-disable-line camelcase
              axesCount++;
            }
          }
          switch (record.rep) {
            case top.POS_REP_CART:
            case top.POS_REP_BOTH:
              writePRData.rep = record.rep;
              writePRData.axes = record.axes;
              writePRData.Config = record.conf;
              writePRData.X = record.cart.X;
              writePRData.Y = record.cart.Y;
              writePRData.Z = record.cart.Z;
              writePRData.W = record.cart.W;
              writePRData.P = record.cart.P;
              writePRData.R = record.cart.R;
              break;
            case top.POS_REP_JOINT:
              writePRData.rep = record.rep;
              writePRData.axes = record.axes;
              writePRData.rob_axes = root.getRobotAxesCount(grpNum);  // eslint-disable-line camelcase
              writePRData.force = true;
              writePRData.Config = record.conf;
              var jointCount = 0;
              for (var j = 0; j < top.REF_POS_JOINT.length; j++) {
                var jointStr = top.REF_POS_JOINT[j];
                if (record.joint[jointStr] !== '') {
                  writePRData[jointStr] = {};
                  writePRData[jointStr].data = record.joint[jointStr];
                  writePRData[jointStr].unit = getJointUnitStr(grpNum, jointCount);
                  jointCount++;
                }
              }
              break;
            case top.POS_REP_NONE: // Record data is empty...
              writePRData.only_cmt_flag = true; // eslint-disable-line camelcase
              break;
          }
          return writePRData;
        }
        /* - Get Joint Axes Unit String. - */
        function getJointUnitStr(grp, axes) {
          var axesUnits = config.posAxesUnit[grp];
          if (axesUnits.length > axes) {
            return axesUnits[axes];
          }
          // If the unit is not the acquisition target, it returns the default unit.
          return 'mm'; // return default unit.
        }
        function setPosRegCallback(/*result, callbackArg*/) {
          // [#11018:No.22] no call putPositionRecord()
          //Position register value setting completed.
          posRegRec.empty = false;

          // draw for start polling.
          config.isCallPRCallback = false;
          var drawArgs = {root: root, prNum: posRegRec.posRegNum, origin: ihmi.position.posDef.DRAWORIGIN_NOCALLBACK};
          func.drawPosReg(drawArgs);

          func.toggleDisabledForms(root, false);

          // Notify to callback.
          if (typeof config.callback === 'function') {
            var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
            var operation = func.convIdToOpeStr(root, targetId); // altframebtn,touchup,***txt,ifpost
            config.callback(root.id, operation, posRegRec.posRegNum, cbInfo);
          }
        }
      },
      createNewPosition: function(newPosNum, isCopy, origin) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var isIndAxis = (config.armType[config.currentGroupNum] == 27) ? true : false;
        var errOccured = (config.status === ihmi.position.posDef.STATUS_OK) ? false : true;

        // set new record frame by displaySetting
        if (config.displaySetting !== func.getPosDef('DISPLAYSETTING_NORMAL')) {
          config.currentFrame = config.displaySetting;
        }
        // touchup for new position record.
        if (config.isTrackingProgram && !isIndAxis) {
          config.currentFrame = top.COORDINATECART;//cart only
        }
        // touchup for new position record.
        if (isIndAxis) { // Independent Axis
          config.currentFrame = top.COORDINATEJOINT;//joint only
        }
        newPosNum = func.assignNumber(root, newPosNum);
        if (isCopy &&                                   // selected NEW
           (config.currentPosInfo.rep !== undefined) && // not empty
           (!config.currentPosInfo.empty) &&            // not empty
            !errOccured) {                              // no err
          //copy position
          //renew posNumList, because posNumList is not renuewed in postPosiion().
          config.posNumList.push(newPosNum);
          config.posNumList = Array.from(new Set(config.posNumList));//Deduplication
          config.posNumList.sort(function(a,b){//sort
            if ( a < b ) return -1;
            if ( a > b ) return 1;
            return 0;
          });
          root.copyPosition(newPosNum); // Pos num already exist, copy pos data.
        } else { // Pos num is 0, need to touchup.
          var privateParam = {};
          privateParam.origin = origin;
          if (isCopy) {
            privateParam.createType = ihmi.position.posDef.CREATETYEP_NEW; //selected new and empty.
          } else {
            privateParam.createType = ihmi.position.posDef.CREATETYEP_SELPOSKIND; //selposkind to pos or called refhres(number=0)
          }
          root.touchup(newPosNum, null, privateParam);
        }
        return newPosNum;
      },
      onclickSelPos: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var doc = root.ownerDocument;
        var rootId = root.id;
        //var selImgElem = doc.getElementById(root.id + '.selposnum'); Comment out by #10481
        var addSelClass = '';
        var rmvSelClass = '';

        /* #10481  Provisional comment out (GK design)  */
        /* #11618 Deleted unnecessary image switching by pull-down ON / OFF. */

        ihmi.cf.removeClass(doc.getElementById(rootId + '.selposnum'), rmvSelClass);
        ihmi.cf.addClass(doc.getElementById(rootId + '.selposnum'), addSelClass);
      },
      onblurSelPos: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var doc = root.ownerDocument;
        var rootId = root.id;
        /* #10481  Provisional comment out (GK design)  */
        /* #11618 Deleted unnecessary image switching by pull-down ON / OFF. */
        ihmi.cf.addClass(doc.getElementById(rootId + '.selposnum'), 'position-sel-imgoff');
      },
      onstartMvTo: function(event) {
        var addEventHandler = ihmi.cf.addEventHandler;
        var clickedElem = event.srcElement;
        var root = (findAncestor_(clickedElem, 'div', 'position') || findAncestor_(clickedElem, 'div', 'ihcp-moveto'));
        var doc = root.ownerDocument;
        var config = root.config;
        var mvtoBtn = doc.getElementById(root.id + '.moveto');
        event.preventDefault();

        // [#11018:No.20] if event is touchstart and moveto button is disable, ignore event.
        // [#11819:No.1] Check regardless of device.
        var mvtoBtnDisable = ihmi.cf.hasClass(root.btnElm.btnMoveTo, 'position-btn-disable');
        if (mvtoBtnDisable) {
          return false;
        }
        // [#15565] set individual button left edge.
        if (config.INFLATEMVTOLEFT === 0) {
          config.INFLATEMVTOLEFT = mvtoBtn.getBoundingClientRect().left;
        }
        //config.mvKnobStart = config.func.getEventClientPos(event, root); // for future.
        // Calculate slidable area.
        var mvtoArea = doc.getElementById(root.id + '.movtoslide');
        if (event.type.indexOf('touch') === 0) {
          addEventHandler(mvtoArea, 'touchmove', root.onmoveMvTo);
          addEventHandler(mvtoArea, 'touchend', root.onendMvTo);
          addEventHandler(mvtoArea, 'touchcancel', root.onendMvTo);
        } else {
          addEventHandler(mvtoArea, 'mousemove', root.onmoveMvTo);
          addEventHandler(mvtoArea, 'mouseup', root.onendMvTo);
          addEventHandler(mvtoArea, 'mouseleave', root.onendMvTo);
        }
        var startKnobRect = {};
        startKnobRect.left = 0;
        startKnobRect.top = 0;
        startKnobRect.right = mvtoArea.clientWidth;
        startKnobRect.bottom = mvtoArea.clientHeight;
        config.mvKnobRect = startKnobRect; // save to config
        return false;
      },
      onmoveMvTo: function(event) {
        var clickedElem = event.srcElement;
        var root = (findAncestor_(clickedElem, 'div', 'position') || findAncestor_(clickedElem, 'div', 'ihcp-moveto'));
        var doc = root.ownerDocument;
        var config = root.config;
        var func = config.func;

        event.preventDefault();
        func.cancelTextSelection(doc); // Cansel text selection when move to button move.
        var crntKnobPos = func.getEventClientPos(event, root); // Get current(moved) client pos.
        var mvtoBtn = doc.getElementById(root.id + '.moveto');
        if (config.mvbtnActive) { // Move to on?
          // [#15565] When you pull back the slide, finish moveto event.
          var btnBarElem = doc.getElementById(root.id + '.movebar');
          var btnArea = event.currentTarget;
          var btnAreaRect = btnArea.getBoundingClientRect();
          var btnBarLeft = btnBarElem.getBoundingClientRect().left;
          var topSideCheck = (crntKnobPos.clientY < btnAreaRect.top);
          var bottomSideCheck = (btnAreaRect.bottom < crntKnobPos.clientY);
          var rightSideCheck = (btnAreaRect.right < crntKnobPos.clientX);
          var leftSideCheck = (crntKnobPos.clientX < btnBarLeft);
          /**
           * [#15565] Touch operation does not generate an end event
           *           when exiting the operation range,
           *           so the move event removes it.
           */
          if ( topSideCheck || bottomSideCheck
            || leftSideCheck || rightSideCheck) {
            root.onendMvTo(event); // Finish moveto.
            return false;
          }
          // Moving but within range.
        } else {
          // passed the right edge of the slide button.
          if (crntKnobPos.clientX >= (mvtoBtn.clientWidth + config.INFLATEMVTOLEFT)) {
            mvtoBtn.style.left = '35px'; // Slide the button.
            var posNum = (config.currentPosKind != func.getPosDef('POSKIND_REG')) ?
                func.pickPosNumber(doc, root.id): func.pickPosRegNum(doc, root.id); // get pos/posreg number.
            // Set up after checking for errors, callbacks occur repeatedly.
            config.mvbtnActive = true;
            root.moveto(event, posNum);
          }
        }
        return false;
      },
      onendMvTo: function(event) {
        var removeHandler = ihmi.cf.removeEventHandler;
        var clickedElem = event.srcElement;
        var root = (findAncestor_(clickedElem, 'div', 'position') || findAncestor_(clickedElem, 'div', 'ihcp-moveto'));
        var doc = root.ownerDocument;
        var btnMvArea = doc.getElementById(root.id + '.movtoslide');
        var moveToBtn = root.btnElm.btnMoveTo;
        event.preventDefault();
        if (event.type.indexOf('touch') === 0) {
          removeHandler(btnMvArea, 'touchmove', root.onmoveMvTo);
          removeHandler(btnMvArea, 'touchend', root.onendMvTo);
          removeHandler(btnMvArea, 'touchcancel', root.onendMvTo);
        } else {
          removeHandler(btnMvArea, 'mousemove', root.onmoveMvTo);
          removeHandler(btnMvArea, 'mouseup', root.onendMvTo);
          removeHandler(btnMvArea, 'mouseleave', root.onendMvTo);
        }
        // [#16602] If a warning is issued, it will not pass.
        if (root.config.mvbtnActive || ihmi.cf.hasClass(moveToBtn, 'position-moveto-on')) {
          top.sendKey("Hold", 1);
          top.sendKey("Hold", 0);
        }
        ihmi.cf.removeClass(moveToBtn, 'position-moveto-on');
        // [#15565] remove and reset left property.
        moveToBtn.style.removeProperty('left');
        root.config.mvbtnActive = false;
        root.config.func.cancelTextSelection(doc); // Cansel text selection when move to button move.
      },
      onclickTouchUp: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var config = root.config;
        var func = config.func;
        var doc = root.ownerDocument;
        var posNum;
        var privateParam = {};
        privateParam.createType = ihmi.position.posDef.CREATETYEP_USEOPE_OR_CALLEDIF;
        privateParam.execCheckedConvCartJoint = false; // true: checkConvCartJointBeforeRecPos() called
        privateParam.diffConvCartToJoint = false; // true: isDiffernt param of checkConvCartJointBeforeRecPos() return.

        if ((config.currentPosKind != func.getPosDef('POSKIND_NUM')) &&
           (config.currentPosKind != func.getPosDef('POSKIND_REG'))) {
          return false;
        }

        posNum = (config.currentPosKind != func.getPosDef('POSKIND_REG')) ?
        func.pickPosNumber(doc, root.id): func.pickPosRegNum(doc, root.id);
        root.touchup(posNum, null, privateParam);
        return false;
      },
      alternateFrame: function(toFrame) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var posData;
        var isIndAxis = (config.armType[config.currentGroupNum] == 27) ? true : false;
        var isPosComp = root.selElm ? true : false; // this function shared with moveto component.
        var addIndex = isPosComp ? [1, 2, 3] :  [3]; // if moveto component, there is no number.
        if (!func.checkInitComp(root)) {
          return;
        }
        if (config.status !== ihmi.position.posDef.STATUS_OK) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecAltFrame'], addIndex);
          return;
        }
        if (config.currentFrame == toFrame) {
          return;
        }
        if (isIndAxis) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecAltFrame'], addIndex);
          return;
        }

        posData = (config.currentPosKind != func.getPosDef('POSKIND_REG')) ?
            config.currentPosInfo: config.posRegRecord; // get record data.
        if (config.displaySetting !== func.getPosDef('DISPLAYSETTING_NORMAL')) {
          if (config.displaySetting !== toFrame) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecAltFrame'], addIndex);
            return;
          }
        }
        if (config.isTrackingProgram && !isIndAxis &&
           (toFrame == top.COORDINATEJOINT)) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecAltFrame'], addIndex);
          return;
        }
        root.toggleFrameType(posData, toFrame);
      },
      onclickTglBtn: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var config = root.config;
        var toFrameType = (config.currentFrame == top.COORDINATEJOINT) ?
            top.COORDINATECART : top.COORDINATEJOINT;
        root.alternateFrame(toFrameType);
        return false;
      },
      onclickFoldBtn: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        root.config.func.toFoldUnfoldPosArea(root, true, null);
      },
      onkeypress: function(event) {
        var kpResult = true;
        var elem = event.srcElement;
        if (event.keyCode === 13) { // Input [Enter]
          elem.blur(); // focus out
          kpResult = false;
        }
        return kpResult;
      },
      onFocusText: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var config = root.config;
        var func = config.func;
        var switchArgs = {};
        if ((config.currentPosKind != func.getPosDef('POSKIND_NUM')) &&
           (config.currentPosKind != func.getPosDef('POSKIND_REG'))) {
          return false;
        }

        switchArgs.toDisable = true;
        switchArgs.srcRoot = root;

        // Disable Operation buttons
        func.switchDisableOperationButton(switchArgs);
        func.switchDisablePosNumAndRegNum(switchArgs);
        if (config.currentPosKind == func.getPosDef('POSKIND_REG')) {
          //posA poB is same number. If posA change X: and focusd posB X:, posB stop polling.
          func.switchDisablePosText(switchArgs, true);// enable/disable other position textbox
        }

        // Position register process
        if (config.currentPosKind == ihmi.position.posDef.POSKIND_REG) {
          // Reset the input timer
          if (config.timerIdInputPR != null) {
            clearTimeout(config.timerIdInputPR);
            config.timerIdInputPR = null;
          }
          // If the focus is on something other than the PosReg number,
          // "Continuing input" is set to true.
          config.isContinuingInput = (clickedElem.id.indexOf('intposregnum') < 0);
          if (config.isContinuingInput) {
            // Disable Inc/Dec button
            var regNumVal = func.pickPosRegNum(root.ownerDocument, root.id);
            func.refreshPosRegNum(root, regNumVal, true);
          }
          // Polling off when textbox is active. (Pos Reg)
          func.stopGetPosRegPolling(config);
        } else {
          config.isContinuingInput = true;
        }
        // Set cursor position to edge of the right.
        var posValLeng = clickedElem.value.length;
        if (clickedElem.setSelectionRange) {
          setTimeout(function() { //for IE. if not exist, don't work properly when start and end is same.
            clickedElem.setSelectionRange(posValLeng, posValLeng);
            clickedElem.click(); // Just in case...(for IE)
          }, 10);
        } else if (clickedElem.createTextRange) {
          //for IE7,IE8
          var range = clickedElem.createTextRange();
          range.collapse(true);
          range.moveEnd('character', posValLeng);
          range.moveStart('character', posValLeng);
          setTimeout(function() { //if not exist, all selected.
            range.select();
          }, 10);
        }
      },
      onBlurText: function(event) { // except pos reg number textbox
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var config = root.config;
        var func = config.func;
        var switchArgs = {};
        if ((config.currentPosKind != func.getPosDef('POSKIND_NUM')) &&
           (config.currentPosKind != func.getPosDef('POSKIND_REG'))) {
          return false;
        }
        switchArgs.srcRoot = root;

        // [#11394:No.6] Enable process move into timeout.
        // Enable Operation buttons
        var doEnableElem = true;  // The process of enable each element is performed here.

        // Position register process
        if (config.currentPosKind == ihmi.position.posDef.POSKIND_REG) {
          var drawArgs = {root: root, prNum: config.currentPosRegNum, origin: ihmi.position.posDef.DRAWORIGIN_NOCALLBACK};
          if (config.isContinuingInput) { // Continuing to input
            if (config.timerIdInputPR != null) { // Reset the input timer
              clearTimeout(config.timerIdInputPR);
            }
            config.timerIdInputPR = setTimeout(function() {
              // Even after waiting for few mili second, the focus is out.
              config.isContinuingInput = false;
              if (config.hasBeenChanged) { // PosReg data has been changed
                root.savePosRegister(config.posRegRecord, clickedElem.id); // Save the PosReg record
                config.hasBeenChanged = false;
                doEnableElem = false;
              } else { // No change
                config.isCallPRCallback = false;
                func.drawPosReg(drawArgs); // Draw for update and polling
                // [#11394:No.6] enble after timeout.
                switchArgs.toDisable = func.hasFocusSomewhere(root);
                func.switchDisableOperationButton(switchArgs);
                func.switchDisablePosNumAndRegNum(switchArgs);
                if (config.currentPosKind == func.getPosDef('POSKIND_REG')) {
                  func.switchDisablePosText(switchArgs, true);// enable/disable other position textbox
                }
              }
            }, config.POSREG_INPUTTXT_TIME);
          } else { // No continuing input
            if (config.hasBeenChanged) { // PosReg data has been changed
              root.savePosRegister(config.posRegRecord, clickedElem.id); // Save the PosReg record
              config.hasBeenChanged = false;
              doEnableElem = false;
            } else {
              func.drawPosReg(drawArgs); // Draw for update and polling
            }
          }
        } else {
          config.isContinuingInput = false;
        }

        // [#11394:No.6] enable each elements.
        if (doEnableElem) {
          // [#11394:No.6] check enable and set.
          var blurDisable = (config.targetProgramName.length == 0) ? true:
              func.hasFocusSomewhere(root); // check focus.
          switchArgs.toDisable = blurDisable;
          func.switchDisableOperationButton(switchArgs);
          func.switchDisablePosNumAndRegNum(switchArgs);
          if (config.currentPosKind == func.getPosDef('POSKIND_REG')) {
            func.switchDisablePosText(switchArgs, true);// enable/disable other position textbox
          }
        }
      },
      onFocusBlurPosRegText: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'position');
        var config = root.config;
        var func = config.func;
        config.hasFocusPosRegNum = (event.type === 'focus');

        if (config.currentPosKind != func.getPosDef('POSKIND_REG')) {
          return false;
        }
        func.toggleDisabledFormsExceptKindAndNum(root);
      },
      onChangePosRegNum: function(elemId, operation, value) {
        var elem = this.myElem; // get target element from textboxInteger's config.
        var root = ihmi.cf.findAncestor(elem, 'div', 'position');
        var config = root.config;
        var func = config.func;
        var prNum = (typeof value === 'string') ? parseInt(value) : value;
        var curPosKind = config.currentPosKind;
        var posRegNumParent = findDescendant_(root, 'div', 'position-reg-num');
        func.updatePosInfoUndefStatus(root, prNum);
        removeClass_(posRegNumParent, 'position-undef-reg-num');

        if (curPosKind != func.getPosDef('POSKIND_REG')) {
          func.setConfCurRegNumByKind(root, curPosKind, prNum);
          if (typeof config.callback === 'function') {
            var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
            config.callback(root.id, 'selposregnum', prNum, cbInfo);
          }
          return;
        }

        // To switch the display earlier before polling.
        func.toggleDisabledFormsExceptKindAndNum(root);

        // Reset the input timer
        if (config.timerIdInputPR != null) {
          clearTimeout(config.timerIdInputPR);
        }
        // Check if the focus has moved to something other than PosReg number
        config.timerIdInputPR = setTimeout(function(eventElem) {
          var drawArgs = {root: root, prNum: prNum, origin: ihmi.position.posDef.DRAWORIGIN_CHANGENUM};
          // Focus out (not exist another textbox)
          config.isCallPRCallback = true; // Data has changed, call callback.
          func.drawPosReg(drawArgs); // Draw for update and polling
        }, config.POSREG_INPUTTXT_TIME, elem);
      },
      onchange: function(event) {
        var elem = event.srcElement;
        var targetId = elem.id;
        var root = (findAncestor_(elem, 'div', 'position') || findAncestor_(elem, 'div', 'ihcp-moveto'));
        var rootId = root.id;
        var config = root.config;
        var func = config.func;
        var doc = root.ownerDocument;
        var posNum;
        var ufutCbArg = {};
        var errOccured = (config.status === ihmi.position.posDef.STATUS_OK) ? false : true;
        // Display selected position data.
        function changePosRecord(posNumStr) {
          var chgPosNum = (typeof posNumStr === 'string') ? parseInt(posNumStr): posNumStr;
          config.isCallPNCallback = true;
          var drawArgs = {root: root, posNum: chgPosNum, posFrame: undefined, origin: ihmi.position.posDef.DRAWORIGIN_CHANGENUM};
          func.drawPosition(drawArgs);
        }
        // Get previous record data.
        function getTargetPrevious(crntPos, targetId) {
          var dotPos = targetId.indexOf('.');
          var branchId = targetId.substring(dotPos + 1);
          var leafId = '';
          var prevVal = 0;
          if (branchId.startsWith('cart')) {
            leafId = branchId.substring(4, 5);  // cart_
            prevVal = crntPos.cart[leafId.toUpperCase()];
          } else if (branchId.startsWith('jnt')) {
            leafId = branchId.substring(3, 4);  // jnt_
            prevVal = crntPos.joint['J' + leafId];
          } else if (branchId.startsWith('ext')) {
            leafId = branchId.substring(3, 4);  // ext_
            prevVal = crntPos.ext['E' + leafId];
          } else if (branchId == 'uftxt') {
            prevVal = crntPos.uf;
          } else if (branchId == 'uttxt') {
            prevVal = crntPos.ut;
          } else if (branchId == 'conftxt') {
            prevVal = crntPos.conf;
          }
          return prevVal;
        }
        // Put the input data to the PosReg record.
        function putTargetFollowing(targetId, value, posRec) {
          var dotPos = targetId.indexOf('.');
          var branchId = targetId.substring(dotPos + 1);
          var leafId = '';
          if (branchId.startsWith('cart')) {
            leafId = branchId.substring(4, 5);  // cart_
            posRec.cart[leafId.toUpperCase()] = (typeof value === 'string') ? Number(value): value;
          } else if (branchId.startsWith('jnt')) {
            leafId = branchId.substring(3, 4);  // jnt_
            posRec.joint['J' + leafId] = (typeof value === 'string') ? Number(value): value;
          } else if (branchId.startsWith('ext')) {
            leafId = branchId.substring(3, 4);  // ext_
            posRec.ext['E' + leafId] = (typeof value === 'string') ? Number(value): value;
          } else if (branchId == 'uftxt') {
            posRec.uf = value;
          } else if (branchId == 'uttxt') {
            posRec.ut = value;
          } else if (branchId == 'conftxt') {
            posRec.conf = value;
          } else if (branchId == 'cmnttxt') {
            posRec.comment = value;
            posRec.chgCmnt = true;
          }
          return;
        }

        var callProc = 'none';
        var targetElem = null;
        switch (targetId) {
          case rootId + '.selposnum':
            if (func.isProgramProtectOn(config)) {
              targetElem = doc.getElementById(targetId);
              ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
              targetElem.value = config.currentPosNumber;
              return;
            }
            if (elem.value == 'New') {
              var selPosNums = doc.getElementById(root.id + '.selposnum');
              var optList = selPosNums.options;
              // Is position empty?
              if (parseInt(optList[0].value) == 0) { // only 'New' option
                selPosNums.remove(0);
                var switchArgs = {};
                switchArgs.toDisable = false;
                switchArgs.srcRoot = root;
                func.switchDisablePosText(switchArgs);
                func.switchDisableOperationButton(switchArgs);
              }
              callProc = 'create';
              break;
            }
            callProc = 'select';
            break;
          case rootId + '.cmnttxt':
            posNum = func.pickPosNumber(doc, rootId);
            // Cut out to byte limit.
            var cmntTxt = event.target.value;
            var isPosReg = (config.currentPosKind === func.getPosDef('POSKIND_REG'));
            cmntTxt = func.cutOutSjisBytes(cmntTxt, func.getPosDef('MAXCOMMENTBYTE'));
            var prevComment = isPosReg ? config.posRegRecord.comment
                                       : config.currentPosInfo.comment;
            var matchStr;
            var errStr;
            config.cmntPreviousVal = prevComment;
            // check 2byte character.
            if (ihmi.global.encoding === "Latin1") {
              if (cmntTxt.match(/[^\x20-\x7E]/)) { // 2byte character is exist.
                // [#11018:No.13] get previous text [#11394:No.1] PosReg invalid reference.
                return func.validateError(root,
                                          new Error(config.posPopupMsg['msg2byteCharError']),
                                          targetId,
                                          prevComment);
              }
            }
            if (isPosReg) {
              matchStr = /[&'<]/;
              errStr = "&'<";
            } else {
              matchStr = /["&\]<]/;
              errStr = "\"&]<";
            }
            if (cmntTxt.match(matchStr)) {
              return func.validateError(root,
                                        new Error(config.posPopupMsg['msgInvalidChars'] + '\n' + errStr),
                                        targetId,
                                        prevComment);
            }

            doc.getElementById(targetId).value = cmntTxt;
            if (func.isProgramProtectOn(config)) {
              targetElem = doc.getElementById(targetId);
              ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
              targetElem.value = prevComment;
              return;
            }
            callProc = 'save';
            break;
          case rootId + '.uftxt':
          case rootId + '.uttxt':
            posNum = func.pickPosNumber(doc, rootId);
            var ufutText = event.target.value;
            var ufutVal = getTargetPrevious(config.currentPosInfo, targetId);
            // Check UF/UT range
            var targetLimit = (targetId.indexOf('.uf') > 0) ? config.ufLimit: config.utLimit;
            var ufutValidResult = func.validate(ufutText, targetLimit, 'int');
            if (ufutValidResult instanceof Error) {
              return func.validateError(root, ufutValidResult, targetId, ufutVal);
            }
            if (func.isProgramProtectOn(config)) {
              targetElem = doc.getElementById(targetId);
              ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
              targetElem.value = ufutVal;
              return;
            }
            callProc = 'save';
            break;
          case rootId + '.conftxt':
            posNum = func.pickPosNumber(doc, rootId);
            var confText = event.target.value;
            var confData;
            var strValidateResult;
            var confPos = (config.currentPosKind == func.getPosDef('POSKIND_REG')) ?
                config.posRegRecord: config.currentPosInfo;
            // Check config string format
            var prevConfig = getTargetPrevious(confPos, targetId); // get prev val
            config.confPreviousVal = prevConfig; // keep to prev.
            var popupFlg = false;
            var validCharCount = config.configStrCheck.charCount;
            var regexpChar = config.configStrCheck.regexpChar;
            var validNumCount = config.configStrCheck.numCount;
            var inputChars = confText.match(/[a-zA-Z]/g);

            // Check configuration string turn number digits
            if (ihmi.cf.parseStrToBoolean(top.irprogapi.confirmConfigAxisNum(confText, validNumCount)) &&
               ((inputChars !==null) && (inputChars.length === validCharCount))) {
              // Formatting
              confText = confText.replace(/\s+/g, ""); // delete all spaces
              confText = confText.replace(/,(?![0-9]|[\-])/g, ""); // delete unnecessary commas
              confText = confText.replace(/,/g, ", "); // insert a space after commas
              confText = confText.replace(/(([a-zA-Z]))/g, " $1"); // insert a space before alphabetical letters
              confText = confText.trim(); // delete a leading space
              confText = confText.toUpperCase();
              confData = confText.split(",");

              /* The process of strictly checking the format. */
              var formValid = true;

              for (var f = 0; f < confData.length; f++) {
                if (f == 0) { // Check Joint placement's Alphabetical letters
                  var placement = confData[0].replace(/\s+/g, ""); // delete spaces
                  // check alphabet char first.
                  if (placement.match(/[^A-Z]/) != null) { // if illegal char exist.
                    formValid = false;
                    break;
                  }
                  for (var c = 0; c < placement.length; c++) {
                    // Check same char
                    var targetChar = placement[c];
                    var count = (placement.match(new RegExp(targetChar, "g")) || []).length;
                    if (count > 1) {
                      formValid = false;
                      break;
                    }
                    if (!regexpChar[c].test(targetChar)) {
                      formValid = false;
                      break;
                    }
                  }
                  if (!formValid) {
                    break;
                  }
                } else {
                  if (isNaN(confData[f])) {
                    formValid = false;
                    break;
                  }
                  var degVal = parseInt(confData[f]);
                  if ((degVal < -1) || (degVal > 1)) {
                    formValid = false;
                    break;
                  }
                }
              }
              if (!formValid) {
                strValidateResult = new Error(config.posPopupMsg['msgConfFormError']);
                popupFlg = true;
              } else {
                doc.getElementById(rootId + '.conftxt').value = confText;
              }
            } else {
              var msgConfigError = config.posPopupMsg['msgConfigErrorFirst'];
              for (var i = 0; validCharCount > i; i++) {
                msgConfigError += config.posPopupMsg['msgConfigErrorJoint'];
                if (i !== validCharCount - 1) {
                  msgConfigError += ' ';
                }
              }
              for (i = 0; validNumCount > i; i++) {
                msgConfigError +=  ',' + ' ' + config.posPopupMsg['msgConfigErrorTurnNum'];
              }
              msgConfigError += config.posPopupMsg['msgConfigErrorEnd'];
              strValidateResult = new Error(msgConfigError);
              popupFlg =true;
            }
            if (popupFlg) {
              return func.validateError(root, strValidateResult, targetId, prevConfig);
            }
            if (func.isProgramProtectOn(config)) {
              targetElem = doc.getElementById(targetId);
              ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
              targetElem.value = prevConfig;
              return;
            }
            callProc = 'save';
            break;
          case rootId + '.cartxtxt':
          case rootId + '.cartytxt':
          case rootId + '.cartztxt':
          case rootId + '.cartwtxt':
          case rootId + '.cartptxt':
          case rootId + '.cartrtxt':
          case rootId + '.jnt1txt':
          case rootId + '.jnt2txt':
          case rootId + '.jnt3txt':
          case rootId + '.jnt4txt':
          case rootId + '.jnt5txt':
          case rootId + '.jnt6txt':
          case rootId + '.ext1txt':
          case rootId + '.ext2txt':
          case rootId + '.ext3txt':
            posNum = func.pickPosNumber(doc, rootId);
            var elemText = event.target.value;
            var crntPos = (config.currentPosKind == func.getPosDef('POSKIND_REG')) ?
                config.posRegRecord: config.currentPosInfo;
            var prevVal = getTargetPrevious(crntPos, targetId);
            var validateResult = func.validate(elemText, config.posLimit, 'float');
            if (validateResult instanceof Error) {
              return func.validateError(root, validateResult, targetId, prevVal);
            }
            if (func.isProgramProtectOn(config)) {
              targetElem = doc.getElementById(targetId);
              ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
              targetElem.value = prevVal;
              return;
            }
            callProc = 'save';
            break;
          default:
            break;
        }
        // Call by each process.
        switch (callProc) {
          case 'create':
            if ((config.currentPosInfo.rep == undefined) || // empty
                (config.currentPosInfo.empty) ||            // empty
                (errOccured)) {                             // error occured
              // If create new position from current robot position, need to check
              func.checkConvCartJointBeforeRecPos(root, true,
                function (execRecpos, isDiffernt) {
                  if (execRecpos) {
                    if (isDiffernt) {
                      config.diffConvCartToJoint = true;
                    }
                    root.createNewPosition(0, true);
                  } else {
                    // can't recPos(). back to previous.
                    root.selElm.btnSelPos.value = config.currentPosNumber;
                  }
                }
              );
            } else {
              // Copy source pos information exists.
              root.createNewPosition(0, true);
            }
            break;
          case 'select':
            changePosRecord(elem.value);
            break;
          case 'save':
            if (config.currentPosKind == func.getPosDef('POSKIND_REG')) {
              // Overwrite position data.
              putTargetFollowing(targetId, event.target.value, config.posRegRecord);
              if (config.isContinuingInput) {
                config.hasBeenChanged = true; // set change flag
                break;
              }
              root.savePosRegister(config.posRegRecord, targetId);
              config.hasBeenChanged = false; // initialyze change flag
              break;
            }

            ufutCbArg.posNumber = posNum;
            ufutCbArg.targetId = targetId;
            ufutCbArg.root = root;
            if (config.currentPosInfo.empty) {
              var sysValObj = { system: ['$MNUFRAMENUM[' + config.currentGroupNum + ']', '$MNUTOOLNUM[' + config.currentGroupNum + ']'] };
              top.irprogapi.getSystemValByXvr(sysValObj, GetUFUTValueCallback, 'selGrpUtUf' + config.currentGroupNum + '.cvr');
            } else {
              root.savePosition(ufutCbArg, null);
            }
            break;
          default:
            break;
        }
        ihmi.global.selectedTextbox = null;
        return false;
        function GetUFUTValueCallback(cbArg, xmlError) {
          var sysGrpTable = {
            UF: Number(cbArg['$MNUFRAMENUM[' + config.currentGroupNum + ']']),
            UT: Number(cbArg['$MNUTOOLNUM[' + config.currentGroupNum + ']'])
          };
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp GetUFUTValueCallback: xml error detect');
          }
          root.savePosition(ufutCbArg, sysGrpTable);
        }
      },
      onClickSelChangePosKind: function(event) {
        var elem =  event.srcElement;
        var selKind = elem.value;
        var root = ihmi.cf.findAncestor(elem, 'div', 'position');
        var config = root.config;
        var func = config.func;
        var selPosKind = root.selElm.btnSelPosKind;
        var selOption;

        if (config.isProgReadOnly) {
          ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
          if (selPosKind !== null) {
            selOption = func.getPosKindSelOption(root, config.currentPosKind);
            if (selOption !== null) {
              selPosKind.value = selOption;
            }
          }
          return;
        }

        if ((config.currentPosKind !== ihmi.position.posDef.POSKIND_NUM) &&
            (selKind === "posdata")) {
          func.checkConvCartJointBeforeRecPos(root, true,
            function(execRecpos, isDiffernt) {
              if (execRecpos) {
                if (isDiffernt) {
                  config.diffConvCartToJoint = true;
                }
                root.onSelChangePosKind(selKind, ihmi.position.posDef.CHANGEKIND_OPE);
              } else {
                // can't recPos(). set previous value.
                if (selPosKind !== null) {
                  selOption = func.getPosKindSelOption(root, config.currentPosKind);
                  if (selOption !== null) {
                    selPosKind.value = selOption;
                  }
                }
              }
            }
          );
        } else {
          root.onSelChangePosKind(selKind, ihmi.position.posDef.CHANGEKIND_OPE);
        }
      },
      changePosKind: function(posKind) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var checkedPosKind;

        if (!func.checkInitComp(root)) {// Check initialize complete.
          return;
        }

        posKind = parseInt(posKind, 10);
        if ((posKind !== ihmi.position.posDef.POSKIND_NUM) &&
          (posKind !== ihmi.position.posDef.POSKIND_REG) &&
          (posKind !== ihmi.position.posDef.POSKIND_REGREG) &&
          (posKind !== ihmi.position.posDef.POSKIND_REGARG)) {
            func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecChangeKind'], [2]);
          return;
        }
        if (config.currentPosKind === posKind) {
          return; // N/A
        }
        checkedPosKind = func.checkPosKindMatchesMode(root, config.currentPosKind, config.componentMode, posKind);
        if (config.currentPosKind === checkedPosKind) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecChangeKind'], [2]);
          return;
        }
        if (config.isProgReadOnly) {
          ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
          return;
        }
        if (config.isConvertFrame) {
          func.toastErrByCalledIf(root,
            config.posPopupMsg['msgNoExecChangeKind'] + config.posPopupMsg['msgNoExecRetry'],
            null);
          return;
        }
        if ((config.currentPosKind !== ihmi.position.posDef.POSKIND_NUM) &&
            (posKind === ihmi.position.posDef.POSKIND_NUM)) {
          // exec recPos()
          func.checkConvCartJointBeforeRecPos(root, true,
            function(execRecpos, isDiffernt) {
              if (execRecpos) {
                if (isDiffernt) {
                  config.diffConvCartToJoint = true;
                }
                config.currentPosKind = posKind;
                func.refreshPosKindSelct(root, ihmi.position.posDef.CHANGEKIND_IF);
              } else {
                return;
              }
            }
          );
        } else {
          config.currentPosKind = posKind;
          func.refreshPosKindSelct(root, ihmi.position.posDef.CHANGEKIND_IF);
        }
      },
      changeNumber: function(number) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var drawArgs = {root: root, origin: ihmi.position.posDef.DRAWORIGIN_CHANGENUM};
        var currentNum = func.getCurrentKindNumber(config);
        number = parseInt(number, 10);
        if (currentNum === number) {
          return;
        }
        if (!func.checkInitComp(root)) {// Check initialize complete.
          return;
        }
        if (!func.checkNumberRange(root, config.currentPosKind, number, true)) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecChangeNum'], [1]);
          return;
        }
        if (config.isProgReadOnly) {
          ihmi.cf.toast.show(config.posPopupMsg['msgProtectOnError']);
          return;
        }

        switch (config.currentPosKind) {
          case ihmi.position.posDef.POSKIND_NUM:
            config.isCallPNCallback = true;
            drawArgs.posFrame = undefined;
            drawArgs.posNum = number;
            func.drawPosition(drawArgs);
            break;
          case ihmi.position.posDef.POSKIND_REG:
          case ihmi.position.posDef.POSKIND_REGREG:
          case ihmi.position.posDef.POSKIND_REGARG:
            drawArgs.prNum = number;
            config.isCallPRCallback = true; // Data has changed, call callback.
            func.drawPosReg(drawArgs); // Draw for update and polling
            break;
          default:
            return;
        }
      },
      onSelChangePosKind: function(posKind, changedBy) {
        var root = this;
        var config = root.config;
        var doc = root.ownerDocument;
        var func = config.func;
        var chgNumber = 0;
        var changePosKind;
        var currentNum;
        var switchArgs = {};
        switchArgs.srcRoot = root;

        if (posKind == 'posdata') {
          //to pos num
          // Stop the Polling
          func.stopGetPosRegPolling(config);
          if (config.dispErrorPopup_xmlCmnt) {//show error popup once.
            /** for disp error popup when typesel change from pos num to pos reg. */
            config.dispErrorPopup_xmlCmnt = false;  // eslint-disable-line camelcase
          }
          func.togglePosRegMode(root, func.getPosDef('POSKIND_NUM'));
          // PosReg -> PosNum ... P[New]
          if (config.targetProgramName.length > 0) {
            // If currently position is only 'New', remove empty option.
            var selPosNums = doc.getElementById(root.id + '.selposnum');
            var optList = selPosNums.options;
            // Is position empty?
            if ((parseInt(optList[0].value) == 0) && (changedBy != ihmi.position.posDef.CHANGEKIND_REFRESH)) { // 'New' or called changePosKind()
              selPosNums.remove(0);
            }
            // [#11018:No.28]
            if (config.displaySetting != config.func.getPosDef('DISPLAYSETTING_NORMAL')) {
              config.currentFrame = config.displaySetting;
            }
            if (changedBy != ihmi.position.posDef.CHANGEKIND_REFRESH) {
              config.deleteComment = true;
              chgNumber = root.createNewPosition(0, false); // touch up and draw.
              config.currentPosNumber = chgNumber;
            }
          } else {
            // Program name is not exist. Disable PosNum component.
            var tempRec = root.createRecord.get(); // Create new record.
            tempRec.posNumber = '';
            tempRec.comment = '';
            tempRec.frame = 0;
            tempRec.uf = '';
            tempRec.ut = '';
            tempRec.empty = true;
            root.dispPositionData(tempRec); // Initialize textbox.
            switchArgs.toDisable = true;
            func.switchDisablePosText(switchArgs);
            func.switchDisableOperationButton(switchArgs);
            func.switchDisablePosNumAndRegNum(switchArgs);
          }
        } else if (posKind == 'posreg') {
          //to reg
          func.togglePosRegMode(root, func.getPosDef('POSKIND_REG'));
          if (changedBy == ihmi.position.posDef.CHANGEKIND_REFRESH) return;
          switchArgs.toDisable = false;
          func.switchDisableOperationButton(switchArgs);
          chgNumber = config.currentPosRegNum;
          config.isCallPRCallback = true; // Data has changed, call callback.
          var drawArgs = {root: root, prNum: chgNumber, origin: ihmi.position.posDef.DRAWORIGIN_SELPOSKIND};
          func.drawPosReg(drawArgs);
        } else {//to posreg[reg] or posreg[arg]
          // Stop the Polling
          func.stopGetPosRegPolling(config);
          if (config.dispErrorPopup_xmlCmnt) {//show error popup once.
            /** for disp error popup when typesel change from pos num to pos reg. */
            config.dispErrorPopup_xmlCmnt = false;  // eslint-disable-line camelcase
          }

          changePosKind = (posKind == 'posregreg') ? func.getPosDef('POSKIND_REGREG') : func.getPosDef('POSKIND_REGARG');
          func.togglePosRegMode(root, changePosKind);
          func.toggleRequiredMark(root, false);
          if (changedBy == ihmi.position.posDef.CHANGEKIND_REFRESH) return;
          if (typeof config.callback === 'function') {
            currentNum = (changePosKind == func.getPosDef('POSKIND_REGREG')) ? config.currentPosRegRegNum : config.currentPosRegArgNum;
            var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
            config.callback(root.id, "selposkind", currentNum, cbInfo);
          }
        }
      },
      onBeforeunload: function(event) {
        //console.log('[INFO] BeforeUnload event. (' + event.type + ')');
        var baseElem = ihmi.cf.findDescendant(event.srcElement, 'div', 'position');
        var config;
        // Stop the MoveTo process.
        ihmi.position.func.unloadMvTo(event.srcElement, event.type);
        if (baseElem !== null) {
          config = baseElem.config;
          //disp overlay?
          config.func.checkRefreshOverlay(baseElem, config.func.getPosDef('CHECKOVERLAY_END_FORCE'));
        }
        ihmi.position.func.stopAllPosRegPolling(event.srcElement);
      },
      onUnload: function(event) {
        var baseElem = ihmi.cf.findDescendant(event.srcElement, 'div', 'position');
        var doc;
        var positions;

        ihmi.position.func.unloadMvTo(event.srcElement, event.type);
        ihmi.position.func.stopAllPosRegPolling(event.srcElement);
        if (baseElem == null) return;
        doc = baseElem.ownerDocument;
        if (doc == null) return;
        positions = doc.querySelectorAll('div.position');
        for (var i = 0; i < positions.length; i++) {
          positions[i].config.isUnload = true;
        }
      },
      stopPosAction: function() {
        var root = this;
        var config = root.config;
        var doc = root.ownerDocument;
        var func = root.config.func;
        func.unloadMvTo(doc, "beforeunload");
        func.stopGetPosRegPolling(root.config);
        /** show error popup once. */
        if (config.dispErrorPopup_xmlCmnt) {  //eslint-disable-line camelcase
          /** for disp error popup when typesel change from pos num to pos reg. */
          config.dispErrorPopup_xmlCmnt = false;  //eslint-disable-line camelcase
        }
      },
      func: {
        getPosDef: function(defItem) {
          return ihmi.position.posDef[defItem];
        },
        getRepKind: function(root, frame, group) { // frame to rep
          var repKind = (frame == top.COORDINATEJOINT) ? top.POS_REP_JOINT :
              (root.getExtendAxesCount(group) > 0) ? top.POS_REP_BOTH : top.POS_REP_CART;
          return repKind;
        },
        getFrameRep: function(rep) { // rep to frame
          return (rep == top.POS_REP_JOINT) ? top.COORDINATEJOINT: top.COORDINATECART;
        },
        pickPosNumber: function(doc, elemId) {
          var posNum = doc.getElementById(elemId + '.selposnum').value;
          return (typeof posNum === 'string') ? ((posNum.length > 0) ? parseInt(posNum): 0): posNum;
        },
        pickPosRegNum: function(doc, rootId) {
          var posRegNum = doc.getElementById(rootId + '.intposregnum').getValue();
          return (posRegNum === "") ? 0 : posRegNum;
        },
        getMotionGroupArray: function(motionGrp) {
          var motionGrpArray = [];
          for (var i = 0; i < 8; i++) {
            motionGrpArray[i] = ((motionGrp & (1 << i)) != 0);
          }
          return motionGrpArray;
        },
        getMotionGroupCount: function(motionGrp) {
          var motionCount = 0;
          for (var i = 0; i < 8; i++) {
            if ((motionGrp & (1 << i)) != 0) {
              motionCount++;
            }
          }
          return motionCount;
        },
        // Check system variable string and return key.
        checkSystemKeys: function(keyStr, keyTable) {
          var matchResult = null;
          for (var kIdx = 0; kIdx < keyTable.length; kIdx++) {
            matchResult = keyStr.match(keyTable[kIdx].matchStr);
            if (matchResult != null) {
              matchResult.matchKey = keyTable[kIdx].matchKey;
              break;
            }
          }
          return matchResult;
        },
        callbackInitComplete: function(root, callbackCall) {
          var config = root.config;
          var func = config.func;
          config.initialized = true;
          if (callbackCall && (config.initCompleteCallback != undefined) && (typeof config.initCompleteCallback === 'function')) {
            // Call callback function of initialize completion.
            var initRefreshInfo = {id: root.id};
            initRefreshInfo.number = config.func.getCurrentKindNumber(config);
            initRefreshInfo.group = config.currentGroupNum;
            initRefreshInfo.posKind = config.currentPosKind;
            initRefreshInfo.status = config.status;
            config.initCompleteCallback(config.initCompleteArgs, initRefreshInfo);
          }
          func.checkRefreshOverlay(root, func.getPosDef('CHECKOVERLAY_END'));
          func.posRefreshQueue.exec();
        },
        callbackChangeGroupTab: function(root) {
          var config = root.config;
          var func = config.func;
          if ((typeof config.callback === 'function') &&
              (!config.disabled)) { // when disabled is false (enable)
            var grpTabId = root.id + '.gp' + config.currentGroupNum;
            var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
            var chgdNumber = func.getCurrentKindNumber(config);
            var operation = func.convIdToOpeStr(root, grpTabId);
            config.callback(root.id, operation, chgdNumber, cbInfo); // Modify for match with other parts.
          }
        },
        convertTelToNumber: function(root) {
          var coordinate = ['X', 'Y', 'Z', 'W', 'P', 'R'];
          var i = 0;
          for (i = 0; i < coordinate.length; i++) {
            changeType(coordinate[i]);
          }
          for (i = 1; i <= 6; i++) {
            changeType('J' + i);
          }
          for (i = 1; i <= 3; i++) {
            changeType('E' + i);
          }
          function changeType(idSuffix) {
            var property = 'textbox' + idSuffix;
            var targetElem = root.iptElm[property];
            targetElem.type = 'text';
            targetElem.setAttribute("inputmode", "numeric");
          }
        },
        getCurrentKindNumber: function(config) {
          // return pos(reg) number by current pos kind.
          var crntKindNumber = -1;
          switch (config.currentPosKind) {
            case ihmi.position.posDef.POSKIND_NUM:
              crntKindNumber = config.currentPosNumber;
              break;
            case ihmi.position.posDef.POSKIND_REG:
              crntKindNumber = config.currentPosRegNum;
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              crntKindNumber = config.currentPosRegRegNum;
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              crntKindNumber = config.currentPosRegArgNum;
              break;
            default:
              console.log('[ERROR] Invalid kind. (curPosKind =' + config.currentPosKind + ' )');
              break;
          }
          return crntKindNumber;
        },
        round3digit: function(fVal) {
          var roundStr = '';
          if (typeof fVal === 'string') {
            if (fVal.length == 0) {
              return roundStr;
            }
            fVal = parseFloat(fVal);
          }
          var dec = Math.round(fVal * 1000);
          roundStr = '' + (dec / 1000);
          return roundStr;
        },
        // Draw position data to component.
        // (IN) drawArgs : Argument for draw. Modify for Multi group after [P19]
        //      .root : Target position component.
        //      .posNum : Number of position
        //      .posFrame : Frame of position
        //      .origin : Caller of origin (Refresh/New/Change/Group)
        drawPosition: function(drawArgs) {
          var root = drawArgs.root;
          var config = root.config;
          var func = config.func;
          var cbArg = {};
          var posNum = drawArgs.posNum;
          var callOrigin = drawArgs.origin;
          cbArg.rootElem = root;
          cbArg.callback = root.judgeDrawPosition;
          cbArg.number = posNum;
          cbArg.frame = drawArgs.posFrame;
          cbArg.origin = callOrigin; // The original caller. (Caller of origin)
          cbArg.isSync = false;
          posNum = parseInt(posNum);
          // Separate by posnum/posreg/posreg[reg]/posreg[arg]
          if ((config.currentPosKind == func.getPosDef('POSKIND_REG')) ||
              (config.currentPosKind == func.getPosDef('POSKIND_REGREG')) ||
              (config.currentPosKind == func.getPosDef('POSKIND_REGARG'))) {
            if (callOrigin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
              config.isCallPRCallback = false; // Only draw.
            }
            var drawPrArgs = {root: root, prNum: posNum, origin: callOrigin};
            func.drawPosReg(drawPrArgs);
            return;
          }

          if ((config.targetProgramName.length == 0) || isNaN(posNum)) { // If no select program, no read program.
            cbArg.number = 0;
            cbArg.posRec = undefined;
            root.judgeDrawPosition(cbArg);
            return;
          }
          cbArg.number = posNum;
          cbArg.getAllGroup = true;
          if (posNum > 0) {
            //get Pos Info from Servier.
            root.getPosValAndAnalize(cbArg);
          } else {
            //use inner pos info.
            cbArg.posRec = undefined;
            root.judgeDrawPosition(cbArg);
          }
        },
        // Draw position register value.
        // (IN) posNum : Number of position
        //      origin : Caller of origin (Refresh/Group/other(or null))
        drawPosReg: function(prArgs) {
          var root = prArgs.root;
          var posNum = prArgs.prNum;
          var origin = prArgs.origin;
          var config = root.config;
          var doc = root.ownerDocument;
          var func = config.func;
          var isUndefPosInfo = false;
          posNum = (typeof posNum === 'string') ? parseInt(posNum): posNum;
          isUndefPosInfo = func.updatePosInfoUndefStatus(root, posNum);
          switch (config.currentPosKind) {
            case ihmi.position.posDef.POSKIND_REG:
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
            case ihmi.position.posDef.POSKIND_REGARG:
              drawPosRegIndirect(root, posNum);
              if (origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
                func.callbackInitComplete(root, true);
              } else if (origin == ihmi.position.posDef.DRAWORIGIN_CHANGENUM) {
                if (typeof config.callback === 'function') {
                  // Called changeNumber()
                  var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
                  config.callback(root.id, 'selposregnum', posNum, cbInfo);
                }
              }
              return;
            default:
              console.log('[ERROR] drawPosReg: invalid posKind');
              return;
          }
          if (config.dispErrorPopup_xmlCmnt && //show error popup once.
             (config.currentPosRegNum !== posNum)) {//different from the pos reg number when the error occurred.
            config.dispErrorPopup_xmlCmnt = false;//eslint-disable-line camelcase
          }
          config.currentPosRegNum = posNum;
          func.refreshPosRegNum(root, config.currentPosRegNum, false);

          // Initialize each flags.
          func.stopGetPosRegPolling(config); // Clear polling timer.

          //console.log('[INFO] stopGetPosRegPolling: PosRegNum(' + posNum + '): [' + root.id + ']');
          if (ihmi.cf.getDefaultView(doc) == undefined) { // If the window has disappeared, do not draw.
            func.checkUnloadWhileRefreshing(root);
            return;
          }
          if (config.targetProgramName.length == 0) {
            return;
          }
          // reset status. update in posRegValueCallback().
          func.setConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING, false);
          // Get specified number PosReg record.
          getPosRegMulti(root, posNum, isUndefPosInfo);

          function drawPosRegIndirect(root, no) {
            var config = root.config;
            var func = config.func;
            func.setConfCurRegNumByKind(root, config.currentPosKind, no);
            func.refreshPosRegNum(root, no, false);
          }

          function startGetPosRegPolling(targetConf, posRegStartNum) {
            if (targetConf.timerIdPosReg != null) {
              clearTimeout(targetConf.timerIdPosReg);
            }
            //console.log('[INFO] startGetPosRegPolling: PosRegNum(' + posRegStartNum + '): [' + targetConf.targetIdPrefix + ']');
            // Get position register value after 2 seconds.
            targetConf.timerIdPosReg = setTimeout(function() {
              getPosRegMulti(root, posRegStartNum, isUndefPosInfo);
            }, targetConf.POSREG_INTERVAL_TIME);
          }

          function posRegValueCallback(posRegData, xmlError) {
            if (func.checkUnloadWhileRefreshing(root)) return;
            var saveComment;
            var data;
            var id;
            var recPosRegNum;
            var targetRec = {};
            isUndefPosInfo = func.updatePosInfoUndefStatus(root, posNum);
            // XML error has occured.
            if ((xmlError) && (!config.dispErrorPopup_xmlCmnt)) {//To avoid display error popup every time polling.
              var logStr = ihmi.cf.format("[ERROR] ihcp posRegValueCallback() xmlError:[%s] / webpage:[%s]", xmlError, root.config.myWebPage);
              console.log(logStr);
              config.dispErrorPopup_xmlCmnt = true;//eslint-disable-line camelcase
            }
            if ((posRegData == null) || 	// err
                (Object.keys(posRegData).length == 0) || // data empty
                (config.isConvertFrame) ||	// on convert
                (config.mvbtnActive) || // on move to
                (config.currentPosKind != ihmi.position.posDef.POSKIND_REG) || // [P20:No.43] Kind is already changed.
                (config.isContinuingInput)) { // continuous input is in progress.
              return;	// NOP
            }
            Object.keys(posRegData).forEach(function(key) {
              var posRegDataOneGrp = this[key];
              var rowno = key.toString();
              var grp = Number(rowno.slice(0, 1));
              if (grp === 1) {
                saveComment = posRegDataOneGrp.comment;
              }
              if (config.currentGroupNum === grp) {
                data = posRegDataOneGrp;
                data.comment = saveComment;//copy pos reg1 comment.
                id = rowno.toString().slice(2);
                recPosRegNum = Number(id);
              }
            }, posRegData);
            if (data == undefined) {
              if (config.initialized) {
                console.log('[ERROR] posRegValueCallback: get posreg failed.');
                startGetPosRegPolling(config, config.currentPosRegNum);
              }
              return;//if no initialized, wait called by drawPosReg();
            }
            if (recPosRegNum !== config.currentPosRegNum) {
              // For when the posreg num button is pressed continuously.
              return;
            }
            isUndefPosInfo = func.updatePosInfoUndefStatus(root, recPosRegNum);

            config.allGrpPosRegInfo = posRegData;//save all group pos reg info.
            if (!isUndefPosInfo) {
              targetRec = root.createRecord.get(); // Create new record.
            }
            var isDifferntSetting = false;
            var showDifferntSettingPopup = false;
            targetRec.posRegNum = recPosRegNum;
            targetRec.group = config.currentGroupNum;
            func.setRecordPosRegValue(root, config.currentGroupNum, data, targetRec);

            // If displaySetting is exist, check frame.
            if ((targetRec.empty) && (config.displaySetting !== config.func.getPosDef('DISPLAYSETTING_NORMAL'))) {
              config.currentFrame = config.displaySetting;
            }
            if ((!isUndefPosInfo) && (!targetRec.empty) && (config.displaySetting !== config.func.getPosDef('DISPLAYSETTING_NORMAL'))) {
              var toFrame = config.func.getFrameRep(data.rep);
              if (config.displaySetting !== toFrame) { // unmatch
                isDifferntSetting = true;
                // popup error alert
                if (!func.getConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING)) {
                  showDifferntSettingPopup = true; // To show popup only once.
                }
              }
            }
            func.setConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING, isDifferntSetting);
            func.toggleDisabledFormsExceptKindAndNum(root);
            if (showDifferntSettingPopup) {
              var message = config.posPopupMsg['msgSettingError'];
              var customizeObj = {};
              config.func.popupPositionAlert(root, message, null, null, customizeObj);
            }
            // [#11394:No.3] Move from the record setting process to here.
            if ((config.isCallPRCallback) && // Notify Change PosRegNum to HTML.
                (targetRec.posRegNum == config.currentPosRegNum)) {  // For when the button is pressed continuously.[#14475:No44]
              if (origin == ihmi.position.posDef.DRAWORIGIN_GROUP) {
                // tap group tab
                origin = ihmi.position.posDef.DRAWORIGIN_NOCALLBACK;
                config.isCallPRCallback = false;
                func.callbackChangeGroupTab(root);
              } else {
                //change pos reg num or change poskind to pos reg
                if (typeof config.callback === 'function') {
                  var cbInfo = {group: config.currentGroupNum, posKind: config.currentPosKind, status: config.status};
                  var operation;
                  if (origin == ihmi.position.posDef.DRAWORIGIN_CHANGENUM) {
                    operation = "selposregnum";
                  } else if (origin == ihmi.position.posDef.DRAWORIGIN_SELPOSKIND) {
                    operation = "selposkind";
                  }
                  origin = ihmi.position.posDef.DRAWORIGIN_NOCALLBACK;
                  config.isCallPRCallback = false;
                  config.callback(root.id, operation, targetRec.posRegNum, cbInfo);
                }
              }
            }

            root.dispPositionData(targetRec); // Reflect pos reg data to screen.
            // [#11394:No.6] Disable the MoveTo button if the other buttons are disabled.
            var tupBtnElem = doc.getElementById(root.id + '.touchup');
            var mvtoDisable = (tupBtnElem.disabled) ? true: targetRec.empty;
            // If record is empty, disable the MoveTo button.
            func.disablePosRegMoveToBtn(root, mvtoDisable); // no empty or component enable, disp on.

            // add refresh callback
            if (origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
              origin = ihmi.position.posDef.DRAWORIGIN_NOCALLBACK;
              func.callbackInitComplete(root, true);
            }

            if (isUndefPosInfo) {
              return; // No need for polling
            }
            // Start polling of pos reg.
            startGetPosRegPolling(config, targetRec.posRegNum);
          }

          function getPosRegMulti(root, posNum, isUndefPosInfo) {
            var config = root.config;
            var motionGrpArr = func.getMotionGroupArray(config.motionGroup);
            motionGrpArr[0] = true;//need posreg1. Because it is not correct comment except for posreg[1].
            var groupArray = [];
            var posRegData = {};
            var key;
            var grpNum;
            for (var i = 0; i < motionGrpArr.length; i++) {
              if (motionGrpArr[i]) {
                grpNum = i + 1;
                groupArray.push(grpNum);
                if (isUndefPosInfo) {
                  key = grpNum + ',' + posNum;
                  posRegData[key] = {};
                  posRegData[key].gnum = grpNum.toString();
                  posRegData[key].comment = "";
                }
              }
            }
            if (isUndefPosInfo) {
              posRegValueCallback(posRegData, false);
            } else {
              top.irprogapi.getPosRegValue(groupArray, posNum, 1, posRegValueCallback, ("compoposreg" + posNum));
            }
          }
        },
        redrawPosArea: function(myRoot, fold) {
          var config = myRoot.config;
          var rootId = myRoot.id;
          var doc = myRoot.ownerDocument;
          var extendAxes = myRoot.getExtendAxesCount(config.currentGroupNum);
          var robotAxes = myRoot.getRobotAxesCount(config.currentGroupNum);

          // show/hide joint axes
          for (var n = 1; n <= 6; n++) {
            var targetJoint = doc.getElementById(rootId + '.jnt' + n);
            if (n > robotAxes) {
              ihmi.cf.addClass(targetJoint, 'hide');
            } else {
              ihmi.cf.removeClass(targetJoint, 'hide');
            }
          }
          // show/hide extend axis
          for (var m = 1; m <= 3; m++) {
            var targetExt = doc.getElementById(rootId + '.ext' + m);
            if (m > extendAxes) {
              ihmi.cf.addClass(targetExt, 'hide');
            } else {
              ihmi.cf.removeClass(targetExt, 'hide');
            }
          }
          var targetExtArea = doc.getElementById(rootId + '.extaxis');
          if (extendAxes > 0) { // display extend axes area.
            ihmi.cf.removeClass(targetExtArea, 'hide');
          } else {
            ihmi.cf.addClass(targetExtArea, 'hide');
          }
          // stretch or shrink position data area
          if (fold !== null) {
            var boxHeight = config.func.calcClientHeight(myRoot, (fold) ? 'Head' : 'Full');
            doc.getElementById(rootId).style.height = boxHeight + 'px';
          }
        },
        // Click or Tap group tab
        selectGroupTab: function(id, operation, value) {
          var tabs = this.myElem; // get target element from tabs's config.
          var ids = id.split('.');
          var doc = tabs.ownerDocument;
          var root = doc.getElementById(ids[0]);
          var config = root.config;
          var curPosNumber = config.func.getCurrentKindNumber(config);

          // Draw specified group data.
          config.currentGroupNum = parseInt(value.slice(2), 10); // extract number.
          config.func.getCurrentConfigString(root);
          // Redraw the position data area to match the configuration of the selection group.
          config.func.redrawPosArea(root, false); // already opened.
          // Draw position data.
          config.isCallPRCallback = true; // change pos reg num (group)
          var drawArgs = {root: root, posNum: curPosNumber, posFrame: null, origin: ihmi.position.posDef.DRAWORIGIN_GROUP};
          config.func.drawPosition(drawArgs);
          config.func.judgeDisableTglAltframeBtn(root, false);
        },
        // get config string of the currently selected group.
        getCurrentConfigString: function(root, callback) {
          var config = root.config;
          if (config.func.checkUnloadWhileRefreshing(root)) return;
          // get config string
          var cbArg = {};
          var ARMTYPE_IND_ADD_AXIS = 27; // 0x1B
          cbArg.tblKind = 0;
          var posRec = root.createRecord.get();
          posRec.group = config.currentGroupNum;
          cbArg.rec = posRec;
          if (config.armType[config.currentGroupNum] === ARMTYPE_IND_ADD_AXIS) {
            config.currentConfigStr = "";
            config.configStrCheck = null;
            if (typeof callback === 'function') {
              // Fixed to true since only joint.
              callback(true);
            }
          } else {
            top.get_curpos(top.KXYZWPR, top.TXML_TP_REC_TYPE, config.currentGroupNum, getCurrentConfigCallback, cbArg); // irprog_io
          }
          // analyze current position for get default(current) config string.
          function getCurrentConfigCallback(pos_rep, pos_type, grp_num, str, cbArg) { // eslint-disable-line camelcase
            var isSuccess = false;
            if (config.func.checkUnloadWhileRefreshing(root)) return;
            if (cbArg.status === top.IO_SUCCESS) {
              isSuccess = true;
              var posJson = top.irprogapi.analyzePositionStr(top.COORDINATECART, str, cbArg.rec);
              config.currentConfigStr = posJson.Config;
              config.configStrCheck = setCheckConfigStrInfo();
            }
            if (typeof callback === 'function') {
              callback(isSuccess);
            }
          }
          // for Compares input characters with the current Config string.
          // set check
          function setCheckConfigStrInfo() {
            //var isPosComp = root.selElm ? true : false; // this function shared with moveto component.
            var separatedCurrentConfig = config.currentConfigStr.split(",");
            var curConfChars = separatedCurrentConfig[0];
            var regexpNum = /[0-9]+/;
            var regexpStr = /[a-zA-Z]+/;
            var numCount = 0;
            var charCount = 0;
            var regexpChar = []; // for Compare with input characters.
            var configChar;
            var configStrCheck = {};
            configStrCheck.numCount = 0;
            configStrCheck.charCount = 0;
            configStrCheck.regexpStr = [];

            // Get the number of turn numbers.
            for (var num = separatedCurrentConfig.length - 1; num > 0; num--) {
              if (regexpNum.test(separatedCurrentConfig[num])) {
                numCount++;
              }
            }
            configStrCheck.numCount = numCount;

            // Get axis layout chars.
            for (var i = 0; i < curConfChars.length; i++) {
              configChar = curConfChars.charAt(i);
              if (regexpStr.test(configChar)) {
                switch (configChar) {
                  case 'F':
                  case 'N':
                    regexpChar[charCount] = /[FN]/;
                    break;
                  case 'L':
                  case 'R':
                    regexpChar[charCount] = /[LR]/;
                    break;
                  case 'U':
                  case 'D':
                    regexpChar[charCount] = /[UD]/;
                    break;
                  case 'T':
                  case 'B':
                    regexpChar[charCount] = /[TB]/;
                    break;
                  default:
                    regexpChar[charCount] = /[A-Z]/;
                    break;
                }
                charCount++;
              }
            }
            configStrCheck.charCount = charCount;
            configStrCheck.regexpChar = regexpChar;
            return configStrCheck;
          }
        },
        updateAllGroupInfo: function(root) {
          var config = root.config;
          var posNum = config.currentPosNumber;
          var cbArg = {};

          cbArg.rootElem = root;
          cbArg.number = posNum;
          cbArg.callback = getAllGrpPosInfoCb;
          cbArg.isSync = false;
          cbArg.getAllGroup = true;

          root.getPosValAndAnalize(cbArg);

          function getAllGrpPosInfoCb(cbArg) {
            var root = cbArg.rootElem;
            var posRecArray = cbArg.posRecArray;
            var config = root.config;
            if (Array.isArray(posRecArray) && posRecArray.length > 1) {
              config.allGrpPosInfo = posRecArray;
            }
          }
        },
        // Get Position component vertical size
        // This Func is called by only position component.(not called by moveto component)
        // moveto component adjust by css , not js.
        calcClientHeight: function(root, targetSize) {
          var config = root.config;
          var rootId = root.id;
          var doc = root.ownerDocument;
          var heightHead = 0;
          var headElem = doc.getElementById(rootId + '.poshead');
          var rowCount = 0;
          var rowHeight = 0;
          var PADDING_BOTTOM = 8; //between the last line textbox and the tab frame(6px) + border height(2px)
          var tabArea = doc.getElementById(root.id + '.tabarea');
          var showTabArea = !ihmi.cf.hasClass(tabArea, 'hide');

          if (headElem) {
            heightHead = headElem.clientHeight;
            if (heightHead == 0) { // Maybe disaplay:none, get default height from class value.
              heightHead = parseInt(window.getComputedStyle(doc.querySelector(".position-head")).height);
            }
          }
          if (targetSize == 'Full') {
            rowCount = 3; // uf/ut/config, xyz|j1j2j3, wpr|j4j5j6
            var extendAxes = root.getExtendAxesCount(config.currentGroupNum);
            if (extendAxes > 0) { // exist extend axes.
              rowCount++; // e1e2e3
            }
            rowHeight = rowCount * 60 + 4 + (showTabArea ? 50 : 0);  // 60px per Row + Inner margin + Group tab height
            rowHeight += PADDING_BOTTOM;
          }
          return (heightHead + rowHeight);
        },
        toFoldUnfoldPosArea: function(root, doClicked, forceFold) {
          var config = root.config;
          var func = config.func;
          var rootId = root.id;
          var doc = root.ownerDocument;
          var foldBtn = root.btnElm.btnFold;
          var posDataBox = doc.getElementById(rootId + '.posdata');
          var posRootElem = doc.getElementById(rootId);
          var posAreaDisp = ihmi.cf.hasClass(foldBtn, 'position-folding-bg-desc');
          var errOccured = (config.status === ihmi.position.posDef.STATUS_OK) ? false : true;
          if (errOccured) {
            forceFold = true;
          }
          if ((forceFold != undefined) && (posAreaDisp !== forceFold)) {
            return;
          }
          func.toggleDisableFoldUnfoldBtn(root, true);
          var boxHeight = config.func.calcClientHeight(root, (posAreaDisp) ? 'Head': 'Full');
          //When position component is dynamically hidden, nothing is done.
          if (boxHeight === 0) {
            return;
          }
          if (posAreaDisp) { // to disappear posData
            ihmi.cf.removeClass(posDataBox, 'posfold-show');
            ihmi.cf.replaceClass(foldBtn, 'position-folding-bg-desc', 'position-folding-bg-asc');
            setTimeout(function() {
              ihmi.cf.addClass(posDataBox, 'hide');
              posRootElem.style.height = boxHeight + 'px';
              func.toggleDisableFoldUnfoldBtn(root, false);
              if (doClicked) {
                foldBtn.focus();
              }
            }, 100);
          } else { // to appear posData
            posRootElem.style.height = boxHeight + 'px';
            ihmi.cf.removeClass(posDataBox, 'hide');
            ihmi.cf.replaceClass(foldBtn, 'position-folding-bg-asc', 'position-folding-bg-desc');
            setTimeout(function() {
              // adjust box border width.
              var boxWidth = doc.getElementById(rootId + '.posdata').offsetWidth;
              if (boxWidth > 0) {
                doc.getElementById(rootId).style.width = boxWidth + 'px';
              }
              ihmi.cf.addClass(posDataBox, 'posfold-show');
              root.tabElem.equalizeTabs();//for calculate tab width
              func.toggleDisableFoldUnfoldBtn(root, false);
              if (doClicked) {
                foldBtn.focus();
              }
            }, 20);
          }
        },
        prepareExchgInfo: function(root, posData) {
          // Set the information according to the format of format exchange.
          var config = root.config;
          var posRec = {};
          posRec.rep = posData.rep;
          posRec.frame = posData.frame;
          posRec.UF = posData.uf;
          posRec.UT = posData.ut;
          posRec.Config = posData.conf;
          var cartKeys = config.func.getPosDef('CARTESIANKEY');
          for (var iCart = 0; iCart < cartKeys.length; iCart++) {
            posRec[cartKeys[iCart]] = posData.cart[cartKeys[iCart]];
          }
          var exExtendAxes = root.getExtendAxesCount(posData.group);
          var exRobotAxes = root.getRobotAxesCount(posData.group);
          for (var iJoint = 0; iJoint < exRobotAxes; iJoint++) {
            var jointName = 'J' + (iJoint + 1);
            posRec[jointName] = posData.joint[jointName];
          }
          for (var iExt = 0; iExt < exExtendAxes; iExt++) {
            posRec['EXT' + (iExt + 1)] = posData.ext['E' + (iExt + 1)];
          }
          var exchgInfo = {};
          exchgInfo.srcRec = posRec;
          exchgInfo.grp = posData.group;
          exchgInfo.ext = exExtendAxes;
          exchgInfo.robot = exRobotAxes;
          exchgInfo.UTVal = posData.ut;
          exchgInfo.UFVal = posData.uf;
          exchgInfo.unit = config.posAxesUnit[posData.group];
          return exchgInfo;
        },
        exchgPosCallback: function(status, posStr, exchgInfo) {
          var root = exchgInfo.rootElem;
          var func = root.config.func;
          var exchgRec = root.createRecord.get();   // Create new record for analyze exchanged data.
          var posItem = exchgInfo.posRec; // pickup target position record.
          // Exchange data analyze when succeed.
          if ((status == top.IO_SUCCESS) && (posStr != undefined) && (posStr.length > 0)) {
            exchgRec = top.irprogapi.analyzePositionStr(exchgInfo.exchgTo, posStr, exchgRec);
            // Set exchange data to record
            if (exchgInfo.exchgTo == top.COORDINATECART) {
              posItem.axes = root.getExtendAxesCount(posItem.group);
              posItem.conf = exchgRec.Config;
              posItem.cart.X = exchgRec.X;
              posItem.cart.Y = exchgRec.Y;
              posItem.cart.Z = exchgRec.Z;
              posItem.cart.W = exchgRec.W;
              posItem.cart.P = exchgRec.P;
              posItem.cart.R = exchgRec.R;
              posItem.frame = top.COORDINATECART;
            } else {  // JOINT
              posItem.axes = root.getJointAxesCount(posItem.group);
              posItem.force = true;
              posItem.joint.J1 = exchgRec.J1;
              posItem.joint.J2 = exchgRec.J2;
              posItem.joint.J3 = exchgRec.J3;
              posItem.joint.J4 = exchgRec.J4;
              posItem.joint.J5 = exchgRec.J5;
              posItem.joint.J6 = exchgRec.J6;
              posItem.frame = top.COORDINATEJOINT;
            }
            posItem.rep = func.getRepKind(root, posItem.frame, posItem.group);
          } else {  // Conversion failed.
            // eslint-disable-next-line no-console
            console.log('[ERROR] exchgPosCallback: Exchange data analysis failed. (status=' + status +'.)');
          }
          exchgInfo.call(status, exchgInfo.posNum, posItem);
        },
        // Returns whether or not the focus has somewhere.
        hasFocusSomewhere: function(root) {
          var hasFocus = false;
          var allPos = root.ownerDocument.querySelectorAll('div.position');
          for (var prc = 0; prc < allPos.length; prc++) {
            var posRoot = allPos[prc];
            if ((posRoot.config != undefined) &&
                (posRoot.config.isContinuingInput)) { // has focus.
              hasFocus = true;
              break;
            }
          }
          return hasFocus;
        },
        // [#11618:No.12] Makes the argument an object for future expansion.
        //  switchArgs.srcRoot : root object
        //            .toDisable : true=disable, false=enable
        switchDisablePosText: function(switchArgs, exceptMySelf) {
          var toDisable = switchArgs.toDisable;
          var root = switchArgs.srcRoot;
          var positions;
          var targetPosCompo;
          var func = root.config.func;

          if (!exceptMySelf) {
            func.toggleSelectableTextboxes(toDisable, root);
          }

          // Enable another position component in only same document.
          positions = root.ownerDocument.querySelectorAll('div.position');
          // Process all other components.
          for (var idx = 0; idx < positions.length; idx++) {
            targetPosCompo = positions[idx];
            if (root.id === targetPosCompo.id) { // Skip myself
              continue;
            }
            var targetConf = targetPosCompo.config;
            if ((targetConf !== undefined) && targetConf.initialized) {// Initialization is not yet complete.
              targetConf.func.toggleSelectableTextboxes(toDisable, targetPosCompo);
            }
          }
        },
        // [#11618:No.12] Makes the argument an object for future expansion.
        //  switchArgs.srcRoot : root object
        //            .toDisable : true=disable, false=enable
        switchDisablePosNumAndRegNum: function(switchArgs) {
          var toDisable = switchArgs.toDisable;
          var root = switchArgs.srcRoot;
          var func = root.config.func;
          var doc = root.ownerDocument;
          var positions = doc.querySelectorAll('div.position');
          var targetPosCompo;

          func.toggleSelectablePosNumAndRegNum(toDisable, root);

          // Another position component selElement switch.
          for (var idx = 0; idx < positions.length; idx++){
            targetPosCompo = positions[idx];
            if (root.id === targetPosCompo.id){
              continue;
            }
            var targetConf = targetPosCompo.config;
            if ((targetConf != undefined) && targetConf.initialized) {
              func.toggleSelectablePosNumAndRegNum(toDisable, targetPosCompo);
            }
          }
        },
        toggleRequiredMark: function(root, isOn) {
          var btnTouchUp = root.btnElm.btnTouchUp;
          var adjustPos = {
            left: "60px",
            top: "-10px",
            position: "absolute"
          };
          var errOccured = (root.config.status === ihmi.position.posDef.STATUS_OK) ? false : true;
          if ((isOn === true) && (errOccured)) {
            isOn = false;// localreg, pos reg[reg] or pos reg[arg] have not pos data.
                         // If displaySetting and frame in program are diffrent, touchup button disabled.
                         // If button is disabled, requiredMark is not required.
          }
          ihmi.cf.createRequiredMark(btnTouchUp, adjustPos, true, null);
          ihmi.cf.setRequiredMark(btnTouchUp, isOn);
        },
        toggleSelectablePosNumAndRegNum: function(toDisable, root) {
          var config = root.config;
          var func = config.func;
          var doc = root.ownerDocument;
          var selElm;
          var regNumVal;
          var textbox;

          toDisable = config.func.isDisableEachElements(config) ? true: toDisable;
          if (root.config.currentPosKind == func.getPosDef('POSKIND_NUM')) {
            selElm = root.selElm.btnSelPos;
            if (selElm.disabled === toDisable) {
              return;// already switched.
            }
            selElm.disabled = toDisable;
            if (toDisable) {
              ihmi.cf.replaceClass(selElm, 'position-sel-imgoff', 'position-sel-imgdisabled');
            } else {
              ihmi.cf.replaceClass(selElm, 'position-sel-imgdisabled', 'position-sel-imgoff');
            }
          } else {
            textbox = root.iptElm.textPosRegNum;
            if (textbox.disabled === toDisable) {
              return;// already switched.
            }
            // Enable/Disable Inc/Dec button
            regNumVal = func.pickPosRegNum(doc, root.id);
            func.refreshPosRegNum(root, regNumVal, toDisable);
          }
        },
        // [#11618:No.12] Makes the argument an object for future expansion.
        //  switchArgs.srcRoot : root object
        //            .toDisable : true=disable, false=enable
        switchDisableModeSel: function(switchArgs) {
          var root = switchArgs.srcRoot;
          var toDisable = switchArgs.toDisable;
          var config = root.config;
          var func = config.func;
          var doc = root.ownerDocument;

          if ((config.componentMode != func.getPosDef('POSKIND_SEL')) &&
              (config.componentMode != func.getPosDef('POSKIND_SEL_ALL'))) {
            return;
          }
          config.func.togglePosModeSelElement(root, toDisable);

          var positions = doc.querySelectorAll('div.position');
          // Another position component selElement switch.
          for (var idx = 0; idx < positions.length; idx++){
            var targetPosCompo = positions[idx];
            if (root.id === targetPosCompo.id) { // myself...skip
              continue;
            }
            config.func.togglePosModeSelElement(targetPosCompo, toDisable);
          }
        },
        togglePosModeSelElement: function(root, toDisable) {
          var config = root.config;
          var func = config.func;
          var doc = root.ownerDocument;
          var selElem;
          var myDisable;
          if ((config.componentMode != func.getPosDef('POSKIND_SEL')) &&
              (config.componentMode != func.getPosDef('POSKIND_SEL_ALL'))) {
            return;
          }
          selElem = doc.getElementById(root.id + '.selposkind'); // Mode select elem
          myDisable = func.isDisableEachElements(config) ? true : toDisable;
          if (selElem.disabled === myDisable) { // already switched.
            return;
          }
          selElem.disabled = myDisable;
          var repFrom = (myDisable) ? 'position-sel-imgoff': 'position-sel-imgdisabled';
          var repTo = (myDisable) ? 'position-sel-imgdisabled': 'position-sel-imgoff';
          ihmi.cf.replaceClass(selElem, repFrom, repTo);
        },
        switchPositionDisp: function(root, switchTo) {
          var rootId = root.id;
          var doc = root.ownerDocument;
          if (switchTo == top.COORDINATEJOINT) {
            ihmi.cf.addClass(doc.getElementById(rootId + '.ufval'), 'hide');
            ihmi.cf.addClass(doc.getElementById(rootId + '.utval'), 'hide');
            ihmi.cf.addClass(doc.getElementById(rootId + '.confval'), 'hide');
            ihmi.cf.addClass(doc.getElementById(rootId + '.cartposition'), 'hide');
            ihmi.cf.addClass(doc.getElementById(rootId + '.cartattitude'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.jointmain'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.jointwrist'), 'hide');
          } else {
            ihmi.cf.addClass(doc.getElementById(rootId + '.jointmain'), 'hide');
            ihmi.cf.addClass(doc.getElementById(rootId + '.jointwrist'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.ufval'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.utval'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.confval'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.cartposition'), 'hide');
            ihmi.cf.removeClass(doc.getElementById(rootId + '.cartattitude'), 'hide');
          }
        },
        // [#11618:No.12] Makes the argument an object for future expansion.
        //  switchArgs.srcRoot : root object
        //            .toDisable : true=disable, false=enable
        switchDisableOperationButton: function(switchArgs) {
          var toDisable = switchArgs.toDisable;
          var srcRoot = switchArgs.srcRoot;
          var config = srcRoot.config;
          var func = config.func;

          // Toggle when position is not pos register.
          func.toggleSelectableButton(srcRoot, toDisable);
          func.disablePosRegMoveToBtn(srcRoot, toDisable);

          // Disable/Enable another position component operation button in only same document.
          // Get all pos component
          var positions = srcRoot.ownerDocument.querySelectorAll('div.position');
          // Process all other components.
          for (var idx = 0; idx < positions.length; idx++) {
            var targetPosCompo = positions[idx];
            if (srcRoot.id == targetPosCompo.id) { // Skip myself
              continue;
            }
            var targetConf = targetPosCompo.config;
            if ((targetConf !== undefined) && targetConf.initialized) {// Initialization is not yet complete.
              // Disable/Enable target button
              var targetFunc = targetConf.func;
              // [#11394:No.8] Add check sel kind. no check list when PosReg.
              var btnDisable = toDisable;
              // It is necessary to process in the order below.
              targetFunc.toggleSelectableButton(targetPosCompo, btnDisable);
              targetFunc.disablePosRegMoveToBtn(targetPosCompo, toDisable);
            }
          }
        },
        disablePosNumMoveToBtn: function(root, toDisable) {
          var config = root.config;
          var btnElem = root.btnElm;
          var elmMto = btnElem.btnMoveTo;
          var elmMvBar = btnElem.btnMovBar;
          var curPosInfo = root.config.currentPosInfo;
          if (config.currentPosKind != ihmi.position.posDef.POSKIND_NUM) {
            return; // If the kind is posreg, it is not processed.
          }
          //It is not executed when "MOVE TO".
          if (!hasClass_(elmMto, 'position-moveto-on')) {
            if (!toDisable) {
              if (curPosInfo.empty || config.func.isDisableEachElements(config)) {
                toDisable = true; //not enable
              } else if (config.posNumList.length < 1) {
                toDisable = true; //not enable
              }
            }
            if (elmMto.disabled === toDisable) {
              return;
            }
            elmMto.disabled = toDisable;
            elmMvBar.disabled = toDisable;
            turnOnOffClass_(elmMto, 'position-btn-disable', toDisable);
            turnOnOffClass_(elmMvBar, 'position-btn-disable', toDisable);
            turnOnOffClass_(btnElem.txtMoveTo, 'position-txt-disable', toDisable);
          }
        },
        // If record is empty, disable the MoveTo button when PosReg.
        // If MoveTo is running, disable the another position's MoveTo button.
        disablePosRegMoveToBtn: function(targetRoot, toDisable) {
          var targetConf = targetRoot.config;
          if (targetConf.currentPosKind != ihmi.position.posDef.POSKIND_REG) {
            return; // If the kind is posnum, it is not processed.
          }
          var func = targetConf.func;
          var disableMode = false;
          var targetBtnElem = targetRoot.btnElm;
          var elemMvto = targetBtnElem.btnMoveTo;
          if ((Object.keys(targetConf.posRegRecord).length == 0) ||
              (targetConf.posRegRecord.empty) ||
              (targetConf.hasFocusPosRegNum) ||
              ((func.isSamePosRegNumSameAsServer) && (!func.isSamePosRegNumSameAsServer(targetRoot))) ||
              (targetConf.func.isDisableEachElements(targetConf))) {
            // Target PosReg value is empty, disable moveto button.
            disableMode = true;
          } else {
            // Source position moveto on, disable target moveto button.
            disableMode = (getMoveToCondition(targetRoot) == 1) ? true :
                          ((ihmi.cf.hasClass(elemMvto, 'position-moveto-on') ? false : toDisable));
          }
          elemMvto.disabled = disableMode;
          ihmi.cf.turnOnOffClass(elemMvto, 'position-btn-disable', disableMode);
          var elemMvBar = targetBtnElem.btnMovBar;
          elemMvBar.disabled = disableMode;
          ihmi.cf.turnOnOffClass(elemMvBar, 'position-btn-disable', disableMode);
          ihmi.cf.turnOnOffClass(targetBtnElem.txtMoveTo, 'position-txt-disable', disableMode);

          // Move to status : 0 = move to myself, no move to / 1 = move to other pos.
          function getMoveToCondition(myRoot) {
            if (myRoot.config.mvbtnActive) {
              return 0;
            }
            // Check if MoveTo is done anywhere
            var allPos = myRoot.ownerDocument.querySelectorAll('div.position');
            var mvtoStatus = 0;
            for (var p = 0; p < allPos.length; p++) {
              var leafPos = allPos[p];
              if (leafPos.config.mvbtnActive) {
                mvtoStatus = 1;
              }
            }
            return mvtoStatus;
          }
        },
        // disable / enable group tab.
        disableGroupTab: function(root, toDisable) {
          var config = root.config;
          if (config.enableGroupCount < 1) {
            return;
          }
          // if show one group tab, disable.
          toDisable = (config.enableGroupCount === 1) ? true : toDisable;
          root.tabElem.refresh(null, null, null, toDisable, null);
        },
        // Initialize PosReg screen conditions.
        togglePosRegMode: function(root, toPosKind) {
          var config = root.config;
          var rootId = root.id;
          var func = config.func;
          var doc = root.ownerDocument;
          var mode = config.componentMode;
          var dispPosNum = false;
          var chgToIndirect = false;
          var closeChr = doc.getElementById(root.id + '.closechr');
          var adjustPosRight; //adjust pos no close char

          var posRegNum;
          switch (toPosKind) {
            case ihmi.position.posDef.POSKIND_NUM:
              dispPosNum = true;
              if (mode == func.getPosDef('POSKIND_NUM')) {
                adjustPosRight = 212;
              } else {
                adjustPosRight = 124;
              }
              break;
            case ihmi.position.posDef.POSKIND_REG:
              posRegNum = config.currentPosRegNum;
              if (mode == func.getPosDef('POSKIND_REG')) {
                adjustPosRight = 120;
              } else {
                adjustPosRight = 38;
              }
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              posRegNum = config.currentPosRegRegNum;
              chgToIndirect = true;
              adjustPosRight = 28;
              func.setConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING, false);
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              posRegNum = config.currentPosRegArgNum;
              chgToIndirect = true;
              adjustPosRight = 28;
              func.setConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING, false);
              break;
            default:
              console.log('[ERROR]invalid val. (toPosKind =' + toPosKind + ' )');
              return;
          }
          config.currentPosKind = toPosKind;
          if (closeChr !== null) {
            closeChr.style.right = adjustPosRight + "px";
          }
          func.refreshPosRegNum(root, posRegNum, false);
          ihmi.cf.turnOnOffClass(doc.getElementById(rootId + '.posregnum'), 'hide', dispPosNum );
          ihmi.cf.turnOnOffClass(doc.getElementById(rootId + '.comboposnum'), 'hide', !dispPosNum);
          if (config.currentPosKind != ihmi.position.posDef.POSKIND_NUM) {
            // Do not check if the posKind is position.
            // When the type is changed from PR,PR[R],PR[ARG] to P,
            // this function may work before the number is numbered,
            // and checkNumberRange() will always return false.
            // Number checks will be done later.
            func.updatePosInfoUndefStatus(root, posRegNum);
          }
          func.toggleDisabledFormsExceptKindAndNum(root);
          toggleDirectIndirect(chgToIndirect);

          //direct(pos or posreg) <--> indirect(posreg[reg] or posreg[arg] )
          function toggleDirectIndirect(chgToIndirect) {
            var cmntArea = doc.getElementById(root.id + '.cmnt');
            var closeChr = doc.getElementById(root.id + '.closechr');
            var changeChar = ']';//pos, pos reg
            if (chgToIndirect) {
              changeChar = ']]';//pos reg[reg] , pos reg[arg]
            }
            if (closeChr !== null) {
              closeChr.innerText = changeChar;
            }
            //hide/show comment textbox.
            if (cmntArea !== null) {
              ihmi.cf.turnOnOffClass(cmntArea, 'hide', chgToIndirect);
            }
          }
        },
        /* The process of cutting out the specified number of bytes from a SJIS string. */
        cutOutSjisBytes: function(targetStr, byteCount) {
          var strLength = 0;
          var cutOutStr = "";
          for (var i = 0; i < targetStr.length; i++) {
            var c = targetStr.charCodeAt(i);
            if (((c >= 0x0) && (c < 0x81)) || (c === 0xf8f0) ||
                ((c >= 0xff61) && (c < 0xffa0)) ||
                ((c >= 0xf8f1) && (c < 0xf8f4))) { // Single byte char.
              strLength += 1;
            } else {
              strLength += 2;
            }
            if (strLength > byteCount) { // Limit over.
              break;
            }
            cutOutStr += targetStr[i];
          }
          return cutOutStr;
        },
        isMovetoRunning: function(baseElem) {
          // get position component list
          var posCompos = ihmi.cf.findDescendants(baseElem, 'div', 'position');
          var targetElm = null;
          var moveToBtn;
          // MoveTo program is running?
          for (var p = 0; p < posCompos.length; p++) {
            var root = posCompos[p];
            if (root.btnElm == undefined) {
              break;
            }
            moveToBtn = root.btnElm.btnMoveTo;
            if (ihmi.cf.hasClass(moveToBtn, 'position-moveto-on')) {  // Moveto running component.
              targetElm = root;
              break;
            }
          }
          return targetElm;
        },
        validate: function(text, limit, kind) {
          var allowChar = (kind == 'float') ? '^-?[\\d.]': '^-?[\\d]';
          if (!(new RegExp(allowChar + "+$")).test(text)) {
            return new Error("Diese Folge ist keine Zahl.");
          }
          var value = (kind == 'int') ? parseInt(text): parseFloat(text);
          if ((limit.lower <= value) && (value <= limit.upper)) {
            return text;
          } else if (text.trim().length == 0) {
            return new Error("Diese Folge ist keine Zahl.");
          } else {
            return new Error(ihmi.cf.format('%s liegt auerhalb des zulssigen Bereichs.\n(%s - %s)',
                             text, limit.lower, limit.upper));
          }
        },
        popupErrorNotClosed: function(root, message) {
          var doc = root.ownerDocument;
          var config = root.config;
          var positions = doc.querySelectorAll('div.position');
          var posLen = positions.length;
          var customizeObj = {};

          for (var x = 0; x < posLen; x++) {
            if (positions[x].config.dispErrorPopup) {
              return;
            }
          }
          customizeObj.hideCloseBtn = true;
          config.func.popupPositionAlert(root, message, null, null, customizeObj);
          config.dispErrorPopup = true;
        },
        popupPositionAlert: function(root, message, callback, cbArgs, custObj) {
          var doc = root.ownerDocument;
          var config = root.config;
          var rootFrameMain = ihmi.cf.getDefaultView(doc);
          var popupFrameMain;
          var frameCategory;
          var MAX_ANCESTOR_COUNT = 100;
          if (rootFrameMain == null) return;
          popupFrameMain = ihmi.cf.findAncestorFrame(rootFrameMain, config.popupPos);
          if (popupFrameMain === top) {
            if (custObj.hideCloseBtn) {
              frameCategory = ihmi.cf.findAncestorFrame(rootFrameMain, MAX_ANCESTOR_COUNT);
              if (frameCategory.name === "home") {
                //if rootFrameMain is in home frame and popupPos="top", disp popup to home frame.
                popupFrameMain = frameCategory;
              }
            }
          }
          if (popupFrameMain !== rootFrameMain) {
            //if the caller and popup dest are differnt
            custObj.callerWindowObj = rootFrameMain;
          }
          ihmi.cf.alertMessage(message, null, function() {
            if ((callback !== null) && (typeof callback === 'function')) {
              callback(cbArgs);
            }
          }, popupFrameMain, custObj);
        },
        setConfigStatus: function(root, targetBit, isOn) {
          var config = root.config;
          if (isOn) {
            config.status = config.status | targetBit;
          } else {
            config.status = config.status & ~targetBit;
          }
        },
        getConfigStatus: function(root, targetBit) {
          var config = root.config;
          var status = config.status;
          var result;
          result = (targetBit === (status & targetBit)) ? true : false;
          return result;
        },
        createReturnParamByStatus: function(root, posInfo) {
          var config = root.config;
          var func = config.func;
          var isUndefPosInfo;
          var targetKeys;
          var isExistNum;

          if (posInfo == undefined) {
            return undefined;
          }
          if (posInfo.posKind === ihmi.position.posDef.POSKIND_NUM) {
            // config.status is the currently selected type of information.
            // If this function called from getPosition()/getPositionAsync(),
            // while selected PR[], PR[R], PR[ARG] selected, check posNumber
            isExistNum = func.checkNumberRange(root, ihmi.position.posDef.POSKIND_NUM, posInfo.posNumber, false);
            isUndefPosInfo = !isExistNum;
          } else {
            isUndefPosInfo = func.getConfigStatus(root, ihmi.position.posDef.STATUS_POSINFO_UNDEF);
          }

          if (isUndefPosInfo) {
            targetKeys = ["posKind", "posNumber", "posRegNum", "posRegRegNum", "posRegArgNum", "group", "status" ];
            Object.keys(posInfo).forEach(function(key) {
              if (!targetKeys.includes(key)) {
                delete this[key];
              }
            }, posInfo);
          }
          posInfo.status = config.status;
          return posInfo;
        },
        toggleDisabledFormsExceptKindAndNum: function(root) {
          var config = root.config;
          var func = config.func;
          var target = {};
          var disable;
          if (config.status !== ihmi.position.posDef.STATUS_OK) {
            disable = true;
          } else {
            disable = false;
          }

          if (disable) {
             //force fold
            func.toFoldUnfoldPosArea(root, false, true);
          }
          // change enable / disable
          func.toggleDisableFoldUnfoldBtn(root, disable);
          func.judgeDisableTouchupBtn(root, disable);
          func.judgeDisableTglAltframeBtn(root, disable);
          func.disablePosRegMoveToBtn(root, disable);
          Object.keys(root.iptElm).forEach(function(key) {
            if (key == 'textPosRegNum') {
              return; // no target.
            }
            target[key] = this[key];
          }, root.iptElm);
          func.toggleSelectableTextboxes(disable, root, target);
        },
        updatePosInfoUndefStatus: function(root, posNum) {
          var config = root.config;
          var func = config.func;
          var posKind = config.currentPosKind;
          var isUndefInfo = false;
          isUndefInfo = func.checkNumberRange(root, posKind, posNum, false) ? false : true;
          if ((posKind == func.getPosDef('POSKIND_REGREG')) ||
              (posKind == func.getPosDef('POSKIND_REGARG'))) {
            isUndefInfo = true;
          }
          func.setConfigStatus(root, ihmi.position.posDef.STATUS_POSINFO_UNDEF, isUndefInfo);
          return isUndefInfo;
        },
        checkRefreshOverlay: function(root, overlayMode) {
          var doc = root.ownerDocument;
          var func = root.config.func;
          var positions = doc.querySelectorAll('div.position');
          var posLen = positions.length;
          var rootFrameMain;
          var popupFrameMain;
          var targetRootPos;
          var i;
          var overlayId = 'refreshOverlay_' + root.id;

          if (overlayMode === func.getPosDef('CHECKOVERLAY_START')) {//disp overlay
            rootFrameMain = ihmi.cf.getDefaultView(doc);
            if (rootFrameMain === null) {
              return;
            }
            popupFrameMain = ihmi.cf.findAncestorFrame(rootFrameMain, root.config.popupPos);
            appendWaitingOverlayScreen_(popupFrameMain, overlayId, rootFrameMain, null);
            root.config.dispRefreshOverlay = popupFrameMain;
          } else if (overlayMode === func.getPosDef('CHECKOVERLAY_END')) {//remove overlay
            if (root.config.dispRefreshOverlay !== null) {
              removeWaitingOverlayScreen_(root.config.dispRefreshOverlay, overlayId);
              root.config.dispRefreshOverlay = null;
            }
          } else if (overlayMode === func.getPosDef('CHECKOVERLAY_END_FORCE')) { //for beforeunload
            for (i = 0; i < posLen; i++) {
              targetRootPos = positions[i];
              if ((targetRootPos.config != null) &&
                  (targetRootPos.config.dispRefreshOverlay != null)) {
                removeWaitingOverlayScreen_(targetRootPos.config.dispRefreshOverlay, overlayId);
                targetRootPos.config.dispRefreshOverlay = null;
              }
            }
          }
        },
        posRefreshQueue: {
          refreshQueue: [],
          enqueue: function (item, frame) {
            var that = this;
            if (frame) {
              ihmi.cf.addEventHandler(frame, "pagehide", function () {
                that.dequeue(item);
              });
            }
            this.refreshQueue.push(item);
          },
          dequeue: function (item) {
            var oldQueue = this.refreshQueue,
              newQueue = [];
            for (var i = 0, len = oldQueue.length; i < len; i++) {
              if (oldQueue[i] !== item) {
                newQueue.push(oldQueue[i]);
              }
            }
            this.refreshQueue = newQueue;
          },
          exec: function () {
            var items = this.refreshQueue,
                firstItem,
                firstElem,
                nextItem,
                nextElem;

            firstItem = items[0];

            if (firstItem == undefined) {
              return;
            }
            firstElem = firstItem.root;
            if (!firstElem.config.runningRefresh) {
              firstElem.execRefresh(firstItem.initArgs);
              return;
            }

            if (firstElem.config.initialized) { //refresh complete
              firstElem.config.runningRefresh = false;
              //after refresh complete, next exec refresh.
              this.dequeue(firstItem);
              nextItem = this.refreshQueue[0];
              if (nextItem !== undefined) {
                nextElem = nextItem.root;
                nextElem.execRefresh(nextItem.initArgs);
              }
            }
          }
        },//posRefreshQueue end
        validateError: function (root, vResult, targetId, prevVal) {
          var doc = root.ownerDocument;
          var config = root.config;
          var targetElem = doc.getElementById(targetId);
          var inputboxFrameMain = ihmi.cf.getDefaultView(doc);
          var errPopFrameMain;
          var customizeObj = {};
          var posRec;
          var confId = root.id + '.conftxt';
          var cmntId = root.id + '.cmnttxt';
          // back to previous
          config.currentPosInfo.comment = config.cmntPreviousVal;
          config.currentPosInfo.conf = config.confPreviousVal;
          targetElem.value = ((targetId != cmntId) && (targetId != confId)) ?
          config.func.round3digit(prevVal): prevVal;

          if (config.currentPosKind == config.func.getPosDef('POSKIND_REG')) {
            posRec = config.posRegRecord;
          } else {
            posRec = config.currentPosInfo;
          }
          if (posRec.empty) {
            root.dispPositionData(posRec);
          }
          if (inputboxFrameMain == null) { // can't disp popup.
            setTimeout(function() {
              targetElem.blur();
              targetElem.focus();
            },0);
            return false;
          }
          if (config.errPopClass) {
            customizeObj.popupFrmAddClass = config.errPopClass;
          }
          errPopFrameMain = ihmi.cf.findAncestorFrame(inputboxFrameMain, config.popupPos);
          customizeObj.errPopAddFuncKey = ihmi.cf.parseStrToBoolean(config.errPopAddFuncKey);
          customizeObj.errPopWindowAlert = ihmi.cf.parseStrToBoolean(config.errPopWindowAlert);
          if (errPopFrameMain !== inputboxFrameMain) {
            //if the caller and popup dest are differnt
            customizeObj.callerWindowObj = inputboxFrameMain;
          }
          alertMessage_(vResult.message, null, function() {
            targetElem.blur();
            targetElem.focus();
          }, errPopFrameMain, customizeObj);
          return false;
        },
        unloadMvTo: function (element, eventType) {
          var targetElm = ihmi.position.func.isMovetoRunning(element);
          var config;
          var moveToName;
          var moveToBtn;

          // MoveTo program is running?
          if (targetElm != null) {  // if MoveTo program exec, stop move to.
            config = targetElm.config;
            moveToBtn = targetElm.btnElm.btnMoveTo;
            if (ihmi.cf.hasClass(moveToBtn, 'position-moveto-on')) {
              top.sendKey("Hold", 1);
              top.sendKey("Hold", 0);
              ihmi.cf.removeClass(moveToBtn, 'position-moveto-on');
            }
            config.mvbtnActive = false;
            if (eventType === "beforeunload") {
              moveToName = config.func.getPosDef('MOVETOPROGRAMNAME');
              top.setAttr(moveToName, top.MM_CONTROL_C, '1', function(status, progName) {
                //console.log('[INFO] position: MoveTo program set to invisible. (' + status + ')');
              }); // irprog_io
            }
            // Allows you to do post-processing even a little.
            setTimeout(function() {}, 10);
          }
        },
        stopGetPosRegPolling: function(config) {
          if (config.timerIdPosReg != null) {
            clearTimeout(config.timerIdPosReg);
            config.timerIdPosReg = null;
          }
        },
        stopAllPosRegPolling: function(element) {
          if (element == undefined) {
            return;
          }
          // Stops the Pos Reg update polling process.
          var positions = element.querySelectorAll('div.position');
          for (var p = 0; p < positions.length; p++) {
            var posRoot = positions[p];
            if (posRoot.config == undefined) {
              continue;
            }
            posRoot.config.func.stopGetPosRegPolling(posRoot.config);
          }
        },
        setRecordPosRegValue: function(root, grp, data, record) {
          var config = root.config;
          var func = config.func;
          var isUndefPosInfo = func.getConfigStatus(root, ihmi.position.posDef.STATUS_POSINFO_UNDEF);

          record.posKind = ihmi.position.posDef.POSKIND_REG;
          record.group = grp;
          record.comment = data.comment;
          if (!isUndefPosInfo) {
            if (data.rep) { // valid data.
              config.currentFrame = config.func.getFrameRep(data.rep);
              record.rep = Number(data.rep);
              record.conf = data.Config;
              record.ut = top.POS_REG_UT_VAL;
              record.uf = top.POS_REG_UF_VAL;
              record.axes = data.axes;
              var toExtStrs = ihmi.position.posDef.EXTAXESKEY;
              for (var e = 0; e < top.REF_POS_EXT.length; e++) {
                var extStr = top.REF_POS_EXT[e];
                record.ext[toExtStrs[e]] = (data[extStr]) ? Number(data[extStr].data) : '';
              }
              if (config.armType[grp] == 27) { // Independent Axis
                data.rep = top.POS_REP_JOINT;
              }
              switch (Number(data.rep)) {
                case top.POS_REP_CART:
                case top.POS_REP_BOTH:
                  for (var c = 0; c < top.REF_POS_CART.length; c++) {
                    var cartStr = top.REF_POS_CART[c];
                    record.cart[cartStr] = Number(data[cartStr]);
                  }
                  record.frame = top.COORDINATECART;
                  break;
                case top.POS_REP_JOINT:
                  for (var j = 0; j < top.REF_POS_JOINT.length; j++) {
                    var jointStr = top.REF_POS_JOINT[j];
                    record.joint[jointStr] = (data[jointStr]) ? Number(data[jointStr].data) : '';
                  }
                  record.frame = top.COORDINATEJOINT;
                  break;
              }
              record.empty = false;
            } else { // data is invalid or nothing.
              if (config.armType[config.currentGroupNum] == 27) { // Independent Axis
                config.currentFrame = top.COORDINATEJOINT; //joint only
              // [P19-P20]
              // Comment out: The reason is as follows.
              // If you do not want to AS IS the frame kind when not teaching,
              // enable the following comments.
              //} else { // Not independent axis.
              //  // The same frame kind as the position
              //  if ((config.allGrpPosInfo != null) && (config.allGrpPosInfo[grp - 1].frame !== -1)) {
              //    config.currentFrame = config.allGrpPosInfo[grp - 1].frame;
              //  } else {
              //    config.currentFrame = top.COORDINATECART; // Frame kind to default.
              //  }
              }
              var crntFrm = config.currentFrame;
              record.frame = crntFrm;
              record.rep = config.func.getRepKind(root, crntFrm, grp);
              record.ut = top.POS_REG_UT_VAL;
              record.uf = top.POS_REG_UF_VAL;
              record.conf = config.currentConfigStr;
              record.axes = (crntFrm == top.COORDINATECART) ? root.getExtendAxesCount(grp): root.getJointAxesCount(grp);
              record.empty = true;
            }
          }
          config.posRegRecord = JSON.parse(JSON.stringify(record));
        },
        toggleSelectableTextboxes: function(toDisable, targetRoot, targetTextboxes) {
          var targetConf = targetRoot.config;
          var func = targetConf.func;
          var elems = (targetTextboxes ? targetTextboxes : targetRoot.iptElm);
          var errOccured = (targetConf.status === ihmi.position.posDef.STATUS_OK) ? false : true;
          var hasFocusSomewhere = (targetConf.currentPosKind == ihmi.position.posDef.POSKIND_REG) ?
                                    func.hasFocusSomewhere(targetRoot) : false; // if kind is posreg, need to continue disable. because forcus myself, stop polling.

          if (!toDisable) {
            toDisable = (func.isDisableEachElements(targetConf) || targetConf.disabledPosData) ? true: toDisable;
            if (targetConf.currentPosKind == ihmi.position.posDef.POSKIND_NUM) {
              if (targetConf.posNumList.length < 1) {
                toDisable = true;
              }
            }
          }
          Object.keys(elems).forEach(function(key) {
            var setDisable = toDisable;
            // No switch disable mode when PosReg and UF/UT.
            if ((key === 'textboxuf') || (key === 'textboxut')) {
              if (targetConf.currentPosKind == targetConf.func.getPosDef('POSKIND_REG')) {
                setDisable = true;
              }
              setDisable = (targetConf.ufutFixedtoF) ? true: setDisable;
            } else if (key === 'textboxComment') {
              if (targetConf.disableComment ||
                 (hasFocusSomewhere) ||
                 (targetConf.hasFocusPosRegNum) ||
                 ((func.isSamePosRegNumSameAsServer) && (!func.isSamePosRegNumSameAsServer(targetRoot))) ||
                 ((targetConf.currentPosKind == ihmi.position.posDef.POSKIND_NUM) &&
                  targetConf.currentPosInfo.empty === true) ||
                  errOccured ) {
                setDisable = true;
              }
            } else if (key === 'textPosRegNum') {
              if (targetConf.currentPosKind == ihmi.position.posDef.POSKIND_REG) {
                if (this[key].disabled !== setDisable) {
                  func.refreshPosRegNum(targetRoot, targetConf.currentPosRegNum, setDisable);
                }
              }
              return;
            } else {
              if ((hasFocusSomewhere) ||
                  (targetConf.hasFocusPosRegNum) ||
                  ((func.isSamePosRegNumSameAsServer) && (!func.isSamePosRegNumSameAsServer(targetRoot)))) {
                setDisable = true;
              }
            }
            if (this[key].disabled === setDisable) {
              return;
            }
            this[key].disabled = setDisable;
            if (this[key].disabled) {
              ihmi.cf.addClass(this[key], 'position-txtbox-disable');
            } else {
              ihmi.cf.removeClass(this[key], 'position-txtbox-disable');
            }
          }, elems);
        },
        toggleSelectableButton: function(root, toDisable) {
          var func = root.config.func;
          func.judgeDisableTouchupBtn && func.judgeDisableTouchupBtn(root, toDisable);
          func.disablePosNumMoveToBtn(root, toDisable);
          func.judgeDisableTglAltframeBtn(root, toDisable);
        },
        judgeDisableTouchupBtn: function(root, toDisable) {
          var config = root.config;
          var func = config.func;
          var btnElem = root.btnElm;
          var elmTup = btnElem.btnTouchUp;
          var curPosKind = root.config.currentPosKind;
          var errOccured = (config.status === ihmi.position.posDef.STATUS_OK) ? false : true;
          var hasFocusSomewhere = func.hasFocusSomewhere(root);
          if (!toDisable) {
            if (config.func.isDisableEachElements(config)) {
              toDisable = true;
            } else if ((curPosKind == func.getPosDef('POSKIND_REGREG')) ||
                       (curPosKind == func.getPosDef('POSKIND_REGARG'))) {
              toDisable = true;
            } else if (errOccured) {
              toDisable = true;
            } else if (hasFocusSomewhere) {
              toDisable = true;
            } else if (config.hasFocusPosRegNum ||
                      ((func.isSamePosRegNumSameAsServer) && (!func.isSamePosRegNumSameAsServer(root)))) {
              toDisable = true;
            }
          }
          if (elmTup.disabled === toDisable) {
            return;
          }
          elmTup.disabled = toDisable;
          ihmi.cf.turnOnOffClass(elmTup, 'position-btn-disable', toDisable);
          ihmi.cf.turnOnOffClass(btnElem.txtTouchUp, 'position-txt-disable', toDisable);
        },
        judgeDisableTglAltframeBtn: function(root, toDisable) {
          var config = root.config;
          var func = config.func;
          var curPosKind = root.config.currentPosKind;
          var hasFocusSomewhere = (func.hasFocusSomewhere ? func.hasFocusSomewhere(root) : false);
          if (!toDisable ) {
            if (config.func.isDisableEachElements(config)) {
              toDisable = true;
            } else {
              if (config.isTrackingProgram) {
                toDisable = true;
              }
              if (config.currentPosKind === config.func.getPosDef('POSKIND_NUM')) {
                if (config.posNumList.length < 1) {
                  toDisable = true; //not enable
                }
              } else if ((curPosKind == func.getPosDef('POSKIND_REGREG')) ||
                      (curPosKind == func.getPosDef('POSKIND_REGARG'))) {
                toDisable = true;
              } else if (hasFocusSomewhere) {
                toDisable = true;
              } else if ((config.hasFocusPosRegNum) ||
                         ((func.isSamePosRegNumSameAsServer) && (!func.isSamePosRegNumSameAsServer(root)))) {
                toDisable = true;
              }
              if (config.armType[config.currentGroupNum] == 27) { // Independent Axis
                toDisable = true;
              }
            }
          }
          toggleAltframeButton(root, toDisable);

          function toggleAltframeButton(root, toDisable) {
            var elmTgl = root.btnElm.btnTgl;
            // If the three buttons are already the same,
            // they will not be processed because they are duplicates.
            if (elmTgl.disabled === toDisable) {
              return;
            }
            elmTgl.disabled = toDisable;
            ihmi.cf.turnOnOffClass(elmTgl, 'position-btn-disable', toDisable);
            ihmi.cf.turnOnOffClass(root.btnElm.txtTgl, 'position-txt-disable', toDisable);
          }
        },
        toggleDisableFoldUnfoldBtn: function(root, toDisable) {
          var config = root.config;
          var foldBtn = root.btnElm.btnFold;
          var errOccured = (config.status === ihmi.position.posDef.STATUS_OK) ? false : true;

          if (!toDisable) {
            if (errOccured) {
              toDisable = true;
            }
          }
          if (foldBtn.disabled === toDisable) {
            return;
          }
          foldBtn.disabled = toDisable;
          ihmi.cf.turnOnOffClass(foldBtn, 'position-btn-disable', toDisable);
        },
        refreshPosRegNum: function(root, setValue, toDisable) {
          var doc = root.ownerDocument;
          var config = root.config;
          var textbox = doc.getElementById(root.id + '.intposregnum');
          var posRegNumParent = findDescendant_(root, 'div', 'position-reg-num');
          var min;
          var max;
          var optionObj = null;
          var maxNumOfLR = 0;
          var isUndefNumber = false;
          if (textbox === null) {
            return;
          }
          switch (root.config.currentPosKind) {
            case ihmi.position.posDef.POSKIND_REG:
              min = config.posRegLimit.lower;
              max = config.posRegLimit.upper;
              maxNumOfLR = config.maxNumOfLocalRegs[1];
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              min = config.regLimit.lower;
              max = config.regLimit.upper;
              maxNumOfLR = config.maxNumOfLocalRegs[0];
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              min = config.argLimit.lower;
              max = config.argLimit.upper;
              break;
            default:
              return;
          }
          if (setValue === 0) {//PR[...]
            setValue = "";
            isUndefNumber = true;
          }
          turnOnOffClass_(posRegNumParent, 'position-undef-reg-num', isUndefNumber);
          if ((maxNumOfLR > 0) && (!config.noLocalReg)) {
            optionObj = {};
            optionObj.range = [];
            optionObj.range[0] = {};
            optionObj.range[0].min = ihmi.position.posDef.LOCAL_REG_NUM_MIN;
            optionObj.range[0].max = ihmi.position.posDef.LOCAL_REG_NUM_MIN + maxNumOfLR - 1;
          }
          if (config.func.isDisableEachElements(config)) {
            toDisable = true;
          }
          textbox.refresh(setValue, min, max, toDisable, optionObj);
        },
        // judge if pos reg num is the same on the screen and the controller?
        // Because of the time lag in setting pos reg number to server.
        isSamePosRegNumSameAsServer: function(root) {
          var doc = root.ownerDocument;
          var config = root.config;
          var func = config.func;
          var regNumVal;
          var isSame = true;
          if (config.initialized && // if refresh not complete, return true.
              config.currentPosKind === func.getPosDef('POSKIND_REG')) {
            regNumVal = func.pickPosRegNum(doc, root.id);
            if (config.currentPosRegNum != regNumVal) {
              isSame = false;
            }
          }
          return isSame;
        },
        setPosRegTupVal: function(root, data, record) {
          var config = root.config;
          record.posKind = ihmi.position.posDef.POSKIND_REG;
          record.frame = config.func.getFrameRep(data.rep);
          var recGrp = data.group;
          record.group = recGrp;
          record.rep = Number(data.rep);
          record.comment = data.comment;
          record.conf = (data.conf != undefined) ? data.conf: config.currentConfigStr;
          record.force = true;
          record.ut = top.POS_REG_UT_VAL;
          record.uf = top.POS_REG_UF_VAL;
          record.axes = (record.frame == top.COORDINATECART) ? root.getExtendAxesCount(recGrp): root.getJointAxesCount(recGrp);
          record.cart = JSON.parse(JSON.stringify(data.cart));
          record.joint = JSON.parse(JSON.stringify(data.joint));
          var toExtStrs = ihmi.position.posDef.EXTAXESKEY;
          for (var e = 0; e < toExtStrs.length; e++) {
            var extStr = toExtStrs[e];
            record.ext[extStr] = (data.ext[extStr] != undefined) ? Number(data.ext[extStr]) : '';
          }
          record.empty = false;
          config.posRegRecord = JSON.parse(JSON.stringify(record));
        },
        cancelTextSelection: function(doc) {
          // When the operation of the slider is started,
          // if the text is selected, the selection to be canceled.
          var seltext = doc.getSelection();
          if (seltext && (seltext.toString().length > 0)) {
            seltext.removeAllRanges();
          }
        },
        getEventClientPos: function(event, myRoot) {
          var tempClient = {clientX: 0, clientY: 0};
          tempClient.clientX = myRoot.config.func.isEventMouse(event) ? event.clientX: event.touches[0].clientX;
          tempClient.clientY = myRoot.config.func.isEventMouse(event) ? event.clientY: event.touches[0].clientY;
          return tempClient;
        },
        getEventOffsetPos: function(event, myRoot) {
          var tempOffset = {offsetX: 0, offsetY: 0};
          tempOffset.offsetX = myRoot.config.func.isEventMouse(event) ? event.offsetX: event.touches[0].offsetX;
          tempOffset.offsetY = myRoot.config.func.isEventMouse(event) ? event.offsetY: event.touches[0].offsetY;
          return tempOffset;
        },
        isEventMouse: function(event) {
          return event.type.startsWith('mouse');
        },
        isProgramProtectOn: function(targetConf) {
          // [#11556] The check of protection is not necessary for the position register.
          return ((targetConf.currentPosKind == targetConf.func.getPosDef('POSKIND_NUM')) && (targetConf.isProgReadOnly));
        },
        isDisableEachElements: function(targetConf) {
          // [#11556] Disables the element
          //          if the PROTECT attribute is Protect On or Program is not selected.
          return (targetConf.disabled || (targetConf.targetProgramName.length == 0));
        },
        checkInitComp: function(root) {
          var initialized = root.config.initialized;
          var logStr;
          if (!initialized) {
            logStr = ihmi.cf.format("ihcp error/webpage:[%s] Don't call position I/F until refresh complete.", root.config.myWebPage);
            console.log(logStr);
            return false;
          }
          return true;
        },
        setConfCurRegNumByKind: function(root, posKind, no) {
          var config = root.config;
          switch (posKind) {
            case ihmi.position.posDef.POSKIND_REG:
              config.currentPosRegNum = no;//PosReg num
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              config.currentPosRegRegNum = no;//PosReg[Reg] reg num
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              config.currentPosRegArgNum = no;//PosReg[Arg] arg num
              break;
            case ihmi.position.posDef.POSKIND_NUM:
            default:
              console.log('[ERROR] setConfCurRegNumByKind: invalid posKind');
              return;
          }
        },
        refreshPosKindSelct: function(root, changedBy) {
          var config = root.config;
          var func = config.func;
          var doc = root.ownerDocument;
          var selPosKind = root.selElm.btnSelPosKind;
          var posLabel = doc.getElementById(root.id + '.poslbl');//no title (not selectable mode.)
          var fixedLabel;//pos num only, or pos reg only
          var isSelectable = false;
          var selOption = func.getPosKindSelOption(root, config.currentPosKind);
          if (config.currentPosKind == ihmi.position.posDef.POSKIND_NUM) {
            fixedLabel = config.posDict['posStr'];
          } else if (config.currentPosKind == ihmi.position.posDef.POSKIND_REG) {
            fixedLabel = config.posDict['posRegStr'];
          }
          if ((config.componentMode == func.getPosDef('POSKIND_SEL')) ||
              (config.componentMode == func.getPosDef('POSKIND_SEL_ALL'))) {
            selPosKind.value = selOption;
            isSelectable = true;
          }
          if (posLabel !== null) {
            ihmi.cf.turnOnOffClass(posLabel, 'hide', isSelectable);
            if (!isSelectable) {
              if (config.addPosLabel) {
                fixedLabel += config.addPosLabel;
              }
              posLabel.innerHTML = fixedLabel;
            }
          }
          ihmi.cf.turnOnOffClass(selPosKind, 'hide', !isSelectable);
          root.onSelChangePosKind(selOption, changedBy);
          refreshPosKindSelOpt();

          //refresh posKind select option
          function refreshPosKindSelOpt() {
            var selPosKind = root.selElm.btnSelPosKind;
            var regReg = root.optElem.regReg;
            var regArg = root.optElem.regArg;
            var showIndirectOpt = (config.componentMode == func.getPosDef('POSKIND_SEL_ALL')) ? true : false;
            if (showIndirectOpt) {
              selPosKind.appendChild(regReg);
              selPosKind.appendChild(regArg);
            } else if (selPosKind.contains(regReg)) {
              selPosKind.removeChild(regReg);
              selPosKind.removeChild(regArg);
            }
          }
        },
        // get position kind select list option value.
        getPosKindSelOption: function(root, posKind) {
          var selOption = null;
          switch (posKind) {
            case ihmi.position.posDef.POSKIND_NUM:
              selOption = 'posdata';
              break;
            case ihmi.position.posDef.POSKIND_REG:
              selOption = 'posreg';
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              selOption = 'posregreg';
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              selOption = 'posregarg';
              break;
            default:
          }
          return selOption;
        },
        analizePosTxtAndMakePosInfo: function(status, progName, posNum, postxt, comment, cbArg1, cbArg2) {
          var root = cbArg1.rootElem;
          var config = root.config;
          var func = config.func;
          var isNotTeached = false;
          var posRecArray = [];
          var posRec;
          var resultPosRec;
          if ((status == top.IO_SUCCESS) || (status == top.IOSTAT_HRTL_022)) { // HRTL_022 : Get halfway
            if (Array.isArray(postxt)) {
              //ex1 [{"rpc":"14","status":"0x0","comment":"aaa","value":["Group: 1 Uninitialized"]}]
              //ex2 [{"rpc":"14","status":"0x0","comment":"",
              //     "value":[{"rpc":"14","status":"0x0","comment":"","value":["\r\n  Group: 1   Config: N U T, 0, 0, 0\r\n  X:    465.000000   Y:      0.000000   Z:    365.000000\r\n  W:   -180.000000   P:    -90.000000   R:      0.000000\r\n  UF: 0 UT: 1","Group: 2 Uninitialized"]}]
              for (var i = 0; i < postxt.length; i++) {
                posRec = root.createRecord.get();
                isNotTeached = analizePosTxt(postxt[i], posRec);
                addInfo(isNotTeached, posRec);
                posRecArray.push(posRec);
              }
            } else { // Single group
              //This route does not pass.
              posRec = root.createRecord.get();
              isNotTeached = analizePosTxt(postxt, posRec);
              addInfo(isNotTeached, posRec);
              posRecArray.push(posRec);
            }
          } else if ((status === top.IOSTAT_MEMO_189) || (status === "0x700BD")) { //server return "0x700BD" on ROBOGUIDE
            // Uninitialyzed.
            //ex [{"rpc":"14","status":"0x700bd"}]
            // Create according to the number of groups.
            if ((cbArg1.getAllGroup) && (func.getMotionGroupCount(config.motionGroup) > 1)) { // valid multi group.
              var mtnGrpArr = func.getMotionGroupArray(config.motionGroup);
              for (var g = 1; g <= config.groupCount; g++) {
                if (!mtnGrpArr[g - 1]) continue; // Skip if it is an invalid group.
                posRec = root.createRecord.get();
                addInfo(true, posRec);
                posRec.group = g;
                posRecArray.push(posRec);
              }
            } else {
              posRec = root.createRecord.get();
              addInfo(true, posRec);
              posRec.group = config.currentGroupNum;
              posRecArray.push(posRec);
            }
          } else {
            //specified pos number does not exist.
            //console.log('[ERROR] analizePosTxtAndMakePosInfo: get_posValue() failed. (status=' + status +'.)');
          }

          if (cbArg1.getAllGroup) {
            resultPosRec = [];
            resultPosRec = posRecArray;
          } else {
            for (var j = 0; j < posRecArray.length; j++) {
              if (config.currentGroupNum === posRecArray[j].group) {
                resultPosRec = posRecArray[j];
                break;
              }
            }
          }

          if ((cbArg1.callback != undefined) && (typeof cbArg1.callback === 'function')) {
            // Call judgeDrawPosition() or updateAllGrpPosInfo()
            cbArg1.posRec = resultPosRec;
            cbArg1.posRecArray = posRecArray;
            cbArg1.callback.apply(root, [cbArg1]); // Call callback function.
          }

          function addInfo(isNotTeached, posRec) {
            if (isNotTeached) {
              //exist pos info but not teached.
              posRec.posNumber = posNum;
              posRec.empty = true;
              posRec.comment = (comment !== null) ? comment:  "";
            } else {
              posRec.axes = (posRec.crntFrm == top.COORDINATECART) ? root.getExtendAxesCount(posRec.group): root.getJointAxesCount(posRec.group);
              posRec.posNumber = posNum;
              posRec.comment = comment;
              var frameType = ((posRec.conf != undefined) && (posRec.conf.length > 0)) ?
                  top.COORDINATECART : top.COORDINATEJOINT;
              posRec.frame = frameType;
              posRec.rep = func.getRepKind(root, frameType, posRec.group);
              posRec.empty = false;
            }
          }

          function analizePosTxt(postxt, posRec) {
            //judge uninitialize
            //ex "Group: 1 Uninitialized"
            var uninitMatchResult = postxt.match(/Group:\s*\d+\s*Uninitialized\s*/);
            var isNotTeached = (uninitMatchResult === null) ? false: true;

            //1st incase joint. J1 = 0.000000 deg  -> J1 : 0.000000 deg
            postxt = postxt.replace(/\s*=/g,':');
            //2nd text data"X: 0.000000 Y: 0.000000~" -> make array ["X: 0.000000", "Y: 0.000000", ~]
            var matchArray = postxt.match(/\w+:\s*[a-zA-Z0-9.-]+\s*/g);
            var matchResult;
            var key;
            var utVal;
            var ufVal;
            var posKeyTable = [ // for Analyze position string.
              {matchKey: 'GROUP', matchStr: /^Group$/},
              {matchKey: 'CART', matchStr: /^[XYZWPR]/},
              {matchKey: 'JOINT', matchStr: /^[J]\d/},
              {matchKey: 'EXT', matchStr: /^EXT\d/},
              {matchKey: 'UF', matchStr: /^UF$/},
              {matchKey: 'UT', matchStr: /^UT$/}
            ];

            for (var i = 0; i < matchArray.length; i++) {
              //3rd array ["X: 0.000000", "Y: 0.000000", ,]
              //matchResult[1] == "X" , matchResult[2] == "0.000000"
              matchResult = matchArray[i].match(/(\w+):\s*([a-zA-Z0-9.-]+)\s*/);
              if (matchResult !== null) {
                //set posRec struct
                key = matchResult[1];
                var matchPos = func.checkSystemKeys(key, posKeyTable);
                if (matchPos == null) {
                  continue;
                }
                switch (matchPos.matchKey) {
                case 'GROUP':
                  posRec.group = parseInt(matchResult[2]);
                  if (isNotTeached) {
                    return isNotTeached;
                  }
                  break;
                case 'CART': // cartesian
                  posRec.cart[key] = parseFloat(matchResult[2]);
                  break;
                case 'JOINT':
                  posRec.joint[key] = parseFloat(matchResult[2]);
                  break;
                case 'EXT': // extend axis
                  var extendNum = parseInt(key.substr(3));
                  posRec.ext['E' + extendNum] = parseFloat(matchResult[2]);
                  break;
                case 'UF':
                  ufVal = parseInt(matchResult[2]);
                  if (isNaN(ufVal)) {
                    ufVal = '';
                  }
                  posRec.uf = parseInt(ufVal);
                  break;
                case 'UT':
                  utVal = parseInt(matchResult[2]);
                  if (isNaN(utVal)) {
                    utVal = '';
                  }
                  posRec.ut = parseInt(utVal);
                  break;
                }
              }
            }
            var matchArrayConf = postxt.match(/(Config):\s*(.+)[\r\n]/);
            if (matchArrayConf !== null) {//config
                posRec.conf = matchArrayConf[2];
            }
            return isNotTeached;
          }
        },
        //convert id(rootId.childId) to callback operation param.
        convIdToOpeStr: function(root, id) {
          var opeStr = id;
          if (opeStr.indexOf('.') === -1) {
            return opeStr;
          }
          //get childId("rootId.childId")
          opeStr = opeStr.substr(root.id.length + 1);
          if (opeStr.indexOf("btn")) {//if altframebtn
            opeStr = opeStr.replace(/btn$/, '');//return altframe
          } else if (opeStr === "intposregnum.textbox") {
            opeStr = 'selposregnum';//return altframe
          }
          return opeStr;
        },
        // Initialize group tab
        initGroupTab: function(root) {
          var config = root.config;
          var func = config.func;
          var doc = root.ownerDocument;
          var groupArray = func.getMotionGroupArray(config.motionGroup);
          var startGrpNum = 8;
          var enblGrpCount = 0;
          var isIndAxis;
          var grpEnable;
          var tabDisabled = false;
          var onlyCart = (config.displaySetting === func.getPosDef('DISPLAYSETTING_CART'));
          var isHideTab;
          var showTabArray = {};
          var tabArgObj = {};
          var grptabElem = root.tabElem;
          var tabArea = doc.getElementById(root.id + '.tabarea');
          var posDataBox = doc.getElementById(root.id + '.posdata');

          // delete style define for building by old vut.
          tabArea.style.margin = 0; //style="margin: 0 0 10px 0;" in vut.
          tabArea.style.border = 0; //style="border: 1px solid #4d4d4d;

          for (var mgIdx = 0; mgIdx < groupArray.length; mgIdx++) {
            grpEnable = groupArray[mgIdx];
            isIndAxis = (config.armType[mgIdx+1] == 27) ? true : false;

            // if displaySetting is cart only, hide Independent Axis group.
            if (grpEnable && !(isIndAxis && onlyCart) &&
            // if hideOtherGroupTab is true, hide group tab except currentGroupTab
               ((!config.hideOtherGroupTab) || // undefined or false
                (config.hideOtherGroupTab) && (config.currentGroupNum == (mgIdx + 1)))) {
              enblGrpCount++;
              if (enblGrpCount < startGrpNum) {
                startGrpNum = enblGrpCount; // To set the minimum group number.
              }
            } else {
              grpEnable = false;
            }
            showTabArray['gp' + (mgIdx + 1)] = grpEnable;
          }
          config.enableGroupCount = enblGrpCount;
          tabArgObj.showTabObj = showTabArray;
          // One robot configuration. or
          // enable group no. (if displaySetting is cart only, hide Independent Axis groups.)
          isHideTab = ((config.groupCount <= 1) || (enblGrpCount < 1));

          if (enblGrpCount < 1) {
            config.targetProgramName = ''; // hide tabs and disable all forms.
          } else if (enblGrpCount === 1) {
            tabDisabled = true; // show but disabled
          }

          turnOnOffClass_(tabArea, 'hide', isHideTab);
          turnOnOffClass_(posDataBox, 'position-show-tab', !isHideTab);
          grptabElem.refresh('gp' + startGrpNum, enblGrpCount, 'gp' + config.currentGroupNum, tabDisabled, tabArgObj);
          grptabElem.setCallback(func.selectGroupTab);
        },
        //assign position number.
        //if the position number does not exist, add it the sel pos num list.
        assignNumber: function(root, newPosNum) {
          var config = root.config;
          var doc = root.ownerDocument;
          var posNumList = config.posNumList;
          var addNewPos = -1;// search empty position
          var selPosNums = doc.getElementById(root.id + '.selposnum');

          if (newPosNum <= 0) { // create new position.
            newPosNum = 1;
            for (var posNumListIdx = 0 ; posNumListIdx < posNumList.length; posNumListIdx++) {
              if (newPosNum !== posNumList[posNumListIdx]) {
                break;
              }
              newPosNum++;
            }
            addNewPos = newPosNum - 1; // empty record position
          } else {  // specified position but no position record
            var optList = selPosNums.options;
            for (var optListIdx = 0; optListIdx < optList.length; optListIdx++) {
              if (newPosNum < parseInt(optList[optListIdx].value)) {
                addNewPos = optListIdx; // Found in between
                break;
              }
            }
            if (addNewPos == -1) {  // Was not found in between
              addNewPos = optList.length - 1; // put to last
            }
          }

          // add position number to option list
          var posRecNumStr = '' + newPosNum;
          var optElem = doc.createElement('option');
          optElem.value = posRecNumStr;
          optElem.text = posRecNumStr;
          selPosNums.add(optElem, addNewPos);

          doc.getElementById(root.id + '.selposnum').value = '' + newPosNum; // set after add option.
          return newPosNum;
        },
        // Check number range
        checkNumberRange: function(root, posKind, reqNumber, allowLocalReg) {
          var config = root.config;
          var result = false;
          var min;
          var max;
          var maxNumOfLR = 0;
          switch (posKind) {
            case ihmi.position.posDef.POSKIND_NUM:
              // Check pos num list.
              if (config.posNumList.includes(reqNumber)) {
                result = true;
              }
              return result;
            case ihmi.position.posDef.POSKIND_REG:
              min = config.posRegLimit.lower;
              max = config.posRegLimit.upper;
              maxNumOfLR = config.maxNumOfLocalRegs[1];
              break;
            case ihmi.position.posDef.POSKIND_REGREG:
              min = config.regLimit.lower;
              max = config.regLimit.upper;
              maxNumOfLR = config.maxNumOfLocalRegs[0];
              break;
            case ihmi.position.posDef.POSKIND_REGARG:
              min = config.argLimit.lower;
              max = config.argLimit.upper;
              break;
            default:
              return result;
          }
          if ((min <= reqNumber) && (reqNumber <= max)){
            result = true;
          }
          // allowLocalReg
          //   true: return true if local reg number is within the range.
          //   false: return false if local reg number is out of range.
          if (allowLocalReg && (maxNumOfLR > 0) && (!config.noLocalReg)) {
            if ((reqNumber >= ihmi.position.posDef.LOCAL_REG_NUM_MIN) &&
                (reqNumber <= (ihmi.position.posDef.LOCAL_REG_NUM_MIN + maxNumOfLR - 1))) {
              result = true;
            }
          }
          return result;
        },
        // check posKind if it matched posMode.
        //if kind is invalid, return currentPosKind.
        checkPosKindMatchesMode: function(root, currentPosKind, mode, kind) {
          var func = root.config.func;
          var initPosKind = currentPosKind;
          switch (mode) {
            case ihmi.position.posDef.POSKIND_NUM:
            case ihmi.position.posDef.POSKIND_REG:
              initPosKind = mode;
              break;
            case ihmi.position.posDef.POSKIND_SEL:
              if ((kind == func.getPosDef('POSKIND_NUM')) ||
                  (kind == func.getPosDef('POSKIND_REG'))) {
                initPosKind = kind;
              }
              if ((currentPosKind == func.getPosDef('POSKIND_REGREG')) ||
                  (currentPosKind == func.getPosDef('POSKIND_REGARG'))) {
                 initPosKind = func.getPosDef('POSKIND_NUM');
              }
              break;
            case ihmi.position.posDef.POSKIND_SEL_ALL:
              if ((kind == func.getPosDef('POSKIND_NUM')) ||
                  (kind == func.getPosDef('POSKIND_REG')) ||
                  (kind == func.getPosDef('POSKIND_REGREG')) ||
                  (kind == func.getPosDef('POSKIND_REGARG'))) {
                initPosKind = kind;
              }
              break;
            default:
              console.log('[ERROR] Invalid mode. (mode =' + mode + ' )');
              break;
          }
          return parseInt(initPosKind);
        },
        checkUnloadWhileRefreshing: function(root) {
          var config = root.config;
          var func = config.func;
          if (!config.initialized && config.isUnload) { // no initialized.
            config.initialized = true;
            func.checkRefreshOverlay(root, func.getPosDef('CHECKOVERLAY_END')); // stop refresh().
            func.posRefreshQueue.exec(); // next start on other document pos component. (if undload, dequeue.)
            return true;
          }
          return false;
        },
        // get Robot Pos Frame to recPos.
        getCrxRobotPosFrame: function(root, isCreateNewPos) {
          var config = root.config;
          var func = config.func;
          var robotGroupNums = func.getRobotGroupNumInEnableGroup(root);
          var frame = top.COORDINATECART;
          var CRX_ROBOT_GROUP = 1; // CRX robot A is only attached to Group 1
          if (!top.g_crx) {
            console.log("[ERROR] ihcp fail getCrxRobotPosFrame");
          }
          if (robotGroupNums === null) {
            return top.COORDINATEJOINT; // only Independent Axis
          }
          if (config.displaySetting !== func.getPosDef('DISPLAYSETTING_NORMAL')) {
            return config.displaySetting;
          }
          if (isCreateNewPos) {
            return top.COORDINATECART;
          }
          // recPos() to exist position.
          // this position touched up by selected frame.
          frame = func.getTargetRobotInEnableGrpFrame(root, CRX_ROBOT_GROUP);
          if (frame === -1) {// no teached
            frame = top.COORDINATECART;
          }
          return frame;
        },
        // check to createNewPos().
        // convert joint1->cart->joint2, and diff joint1 and joint2.(Only CRX)
        // If joint1 and joint2 are different, this position can't be taught in cartesian coordinates.
        checkConvCartJointBeforeRecPos: function(root, isCreateNewPos, callback) {
          var config = root.config;
          var func = config.func;
          var cbArg = {};
          var posRec;
          var execRecpos = true; // true: exec recPos() / false: no exec recPos()
          // recPos_multi() exec to touchup all group in same number.
          // for this reason, get robot group(not Independent Axis) in enable motion group.
          // In case CRX, Group1 is Robot and Group2~Group8 are Independent Axis)
          // this check is need Only Group1()
          var robotGroupNums = func.getRobotGroupNumInEnableGroup(root);
          var frame = top.COORDINATECART;
          var CRX_ROBOT_GROUP = 1; // CRX robot A is only attached to Group 1
          if (typeof callback !== 'function') {
            return;
          }

          // If ordered CRXO, and Valid motion group contains group 1,
          // needs to be checked
          if (!(top.g_crx && robotGroupNums && ihmi.cf.includesArray(robotGroupNums, CRX_ROBOT_GROUP))) {
            callback(true, false);
            return;
          }

          if (!isCreateNewPos && config.isConvertFrame){
            // if touchup() I/F called, ignore touchup() while converting frame.
            // disabled forms while converting frame.
            // isConvertFrame checked in changePosKind();
            callback(false, false);
            return;
          }
          // If isCraeteNewPos is true, need to convert check. because touchup in cart.
          if (config.displaySetting === func.getPosDef('DISPLAYSETTING_NORMAL')) {
            if (!isCreateNewPos) {
              // recPos() to exist position.
              // this position touched up by selected frame.
              frame = func.getTargetRobotInEnableGrpFrame(root, CRX_ROBOT_GROUP);
              if (frame === -1) {// no teached
                frame = top.COORDINATECART; //if empty, touched up by cart.
              }
            }
          } else {
            frame = config.displaySetting;
          }

          if (frame == top.COORDINATECART) { // if joint or tracking, no check.
            if (config.jposrecEnable === 1) {
              if ((config.displaySetting !== config.func.getPosDef('DISPLAYSETTING_NORMAL')) ||
                 config.isTrackingProgram) {
                // can't recPos
                ihmi.cf.toast.show(config.posPopupMsg['msgRecPosCartError']);
                execRecpos = false;
              }
            } else {
              // get current robot joint position.
              posRec = root.createRecord.get();
              posRec.group = CRX_ROBOT_GROUP; // robot group number
              cbArg.rec = posRec;
              cbArg.rep = func.getRepKind(root, top.COORDINATEJOINT, posRec.group);

              // to disabled prevent to toggle frame
              func.toggleDisabledForms(root, true);
              top.get_curang(posRec.group, getCurrentJointPosCallback, cbArg); // irprog_io
              return;
            }
          }
          if (typeof callback === 'function') {
            callback(execRecpos, false);
          }

          function getCurrentJointPosCallback(grpNum, str, cbArg) {
            var defJoint = top.COORDINATEJOINT;
            var posAnl = top.irprogapi.analyzePositionStr(defJoint, str, cbArg.rec);
            var posJoint = root.createRecord.get();
            posJoint.posNumber = 1; // dummy number for checkConvCartToJoint()
            posJoint.frame = defJoint;
            posJoint.group = grpNum;
            posJoint.conf = posAnl.Config;
            posJoint.rep = top.POS_REP_JOINT;
            posJoint.force = cbArg.force;
            posJoint.joint.J1 = posAnl.J1;
            posJoint.joint.J2 = posAnl.J2;
            posJoint.joint.J3 = posAnl.J3;
            posJoint.joint.J4 = posAnl.J4;
            posJoint.joint.J5 = posAnl.J5;
            posJoint.joint.J6 = posAnl.J6;
            posJoint.ext.E1 = posAnl.EXT1;
            posJoint.ext.E2 = posAnl.EXT2;
            posJoint.ext.E3 = posAnl.EXT3;
            posJoint.empty = false;
            func.checkConvCartToJoint(root, posJoint, false, convResultCallback);
          }

          function convResultCallback (status, posNum, posItem) {
            var execRecpos = true;  // enable to recPos().
            var isDiffernt = false; // true: conv joint1->cart->joint2, joint1 and joint2 are deffernt. / false : same.
            if (((status == top.IO_SUCCESS) || (status == ihmi.position.posDef.CONVRSLT_DIFFERENT)) &&
                 (posItem != undefined) && (!posItem.empty)) {
              if (status == ihmi.position.posDef.CONVRSLT_DIFFERENT) { // Differnt before and after conversion.
                if ((config.displaySetting == config.func.getPosDef('DISPLAYSETTING_CART')) ||
                    config.isTrackingProgram) {
                  // only cart
                  ihmi.cf.toast.show(config.posPopupMsg['msgRecPosCartError']);
                  execRecpos = false;
                } else {
                  isDiffernt = true;
                }
              }
            } else {  // convert failed. or convert check by other
              ihmi.cf.toast.show(config.posPopupMsg['msgRecPosCartError']);
              execRecpos = false;
            }
            if (typeof callback === 'function') {
              callback(execRecpos, isDiffernt);
            }
          }
        },
        // get robot group(not Independent Axis) in enable motion group.
        getRobotGroupNumInEnableGroup: function(root) {
          var config = root.config;
          var func = config.func;
          var groupArray = func.getMotionGroupArray(config.motionGroup);
          var isIndAxis;
          var grpNumList = [];

          for (var mgIdx = 0; mgIdx < groupArray.length; mgIdx++) {
            var grpEnable = groupArray[mgIdx];
            if (grpEnable) {
              isIndAxis = (config.armType[mgIdx+1] == 27) ? true : false;
              if (isIndAxis) {
                continue;
              } else {
                grpNumList.push(mgIdx + 1);
              }
            }
          }
          if (grpNumList.length === 0) {
            grpNumList = null; // no robot in enabled motion group.
          }
          return grpNumList;
        },
        // get Robot Frame in enable motion group.
        getTargetRobotInEnableGrpFrame: function(root, robotGroupNum) {
          var config = root.config;
          var func = config.func;
          var robotFrame = -1; // if target robot frame is empty, return cart.
                                // because if empty, touched up by cart.
          var robotPosInfo;
          //var number = func.getCurrentKindNumber();
          var allGrpInfo;

          if (robotGroupNum === null) {
            return robotFrame;
          }
          if (root.config.currentPosKind == func.getPosDef('POSKIND_NUM')) {
            allGrpInfo = config.allGrpPosInfo;

            if ((allGrpInfo != null) && (Array.isArray(allGrpInfo))) {
              // multi motion group
              Object.keys(allGrpInfo).forEach(function(key) {
                var posDataOneGrp = this[key];
                if (posDataOneGrp.group === robotGroupNum) {// robotGroupNum is 1.
                  robotPosInfo = posDataOneGrp;
                }
              }, allGrpInfo);
            } else {
              // robot only in motion group.
              robotPosInfo = config.currentPosInfo;
            }
            if (robotPosInfo.empty) {
              return robotFrame;
            }
            robotFrame = robotPosInfo.frame;
          } else if (root.config.currentPosKind == func.getPosDef('POSKIND_REG')) {
            allGrpInfo = config.allGrpPosRegInfo;
            Object.keys(allGrpInfo).forEach(function(key) {
              var posDataOneGrp = this[key];
              if (posDataOneGrp.gnum != undefined) { //if not teached, gnum is undefined.
                if (parseInt(posDataOneGrp.gnum, 10) === robotGroupNum) {// robotGroupNum is 1.
                  robotFrame = config.func.getFrameRep(posDataOneGrp.rep);
                }
              }
            }, allGrpInfo);
          }
          return robotFrame;
        },
        // Convert Joint->Cart->Joint, Check that joint data are the same before and after conversion.
        checkConvCartToJoint: function(root, posItem, toDisabledCheckEnd, callback) {
          var config = root.config;
          var func = config.func;
          var oldJoint; // Current Joint data.

          // validate check
          if (posItem.frame !== top.COORDINATEJOINT) {
            return; // joint only
          }
          oldJoint = JSON.parse(JSON.stringify(posItem)); // Current Joint data.
          if (config.saveConvCartToJoint.oldJoint !== null) {
            // while checking other
            var posNum = (oldJoint.posKind != func.getPosDef('POSKIND_REG')) ? oldJoint.posNumber: oldJoint.posRegNum;
            callback(ihmi.position.posDef.CONVRSLT_CHECKINGOTHER, posNum, oldJoint);
            return;
          }
          initCheckConvConfig();

          // 1st. Convert joint to cart.
          config.saveConvCartToJoint.oldJoint = oldJoint;
          func.convertPositionFormat(root, JSON.parse(JSON.stringify(oldJoint)), diffConvResult);

          function diffConvResult(status, posNum, posItem) {
            var convResult = top.IO_SUCCESS;
            var resultData = {};
            if ((config.saveConvCartToJoint.oldJoint !== null) && (config.saveConvCartToJoint.cart === null)) {
              // Converted joint to cart.
              if ((status == top.IO_SUCCESS) && (posItem != undefined) && (!posItem.empty)) {
                // rewrite position data
                config.saveConvCartToJoint.cart = posItem;
                // 2nd. convert cart to joint
                func.convertPositionFormat(root, posItem, diffConvResult);
              } else {  // convert failed.
                resultData = JSON.parse(JSON.stringify(config.saveConvCartToJoint.oldJoint));
                initCheckConvConfig();
                func.toggleDisabledForms(root, toDisabledCheckEnd);
                callback(ihmi.position.posDef.CONVRSLT_ERR, posNum, resultData);
              }
            } else if ((config.saveConvCartToJoint.oldJoint !== null) && (config.saveConvCartToJoint.cart !== null)) {
              // convert result cart to joint.
              resultData = JSON.parse(JSON.stringify(config.saveConvCartToJoint.oldJoint)); // Set default

              if ((status == top.IO_SUCCESS) && (posItem != undefined) && (!posItem.empty)) {
                // rewrite position data
                var robotAxesCount = root.getRobotAxesCount(config.currentGroupNum);
                if (diffJointData(config.saveConvCartToJoint.oldJoint, posItem, robotAxesCount)) {
                  // same
                  resultData = JSON.parse(JSON.stringify(config.saveConvCartToJoint.cart));
                } else {
                  // differ
                  convResult = ihmi.position.posDef.CONVRSLT_DIFFERENT;
                }
              } else {
                 // convert failed.
                 convResult = ihmi.position.posDef.CONVRSLT_ERR;
              }
              initCheckConvConfig();
              func.toggleDisabledForms(root, toDisabledCheckEnd);
              callback(convResult, posNum, resultData);
            } else {
              console.log('[ERROR] ihcp fail checkConvCartToJoint');
              initCheckConvConfig();
              func.toggleDisabledForms(root, toDisabledCheckEnd);
            }
          }
          function initCheckConvConfig() {
            config.saveConvCartToJoint.oldJoint = null;
            config.saveConvCartToJoint.cart = null;
          }
          // diff old joint data to new joint data.
          function diffJointData(oldJoint, newJoint, robotAxesCount) {
            var MAX_ROBOT_AXES = 6;
            var dataOld;
            var dataNew;
            var DECIMAL_TO_INT = 1000000; // Notified to the 6th decimal place
            var ALLOWABLE = 0.1; //Tolerance for difference between old and new comparison.

            if (!((oldJoint.frame === top.COORDINATEJOINT) && (newJoint.frame === top.COORDINATEJOINT))) {
              return false;
            }

            // robot axes (comparison of extend axises are not necessary.)
            for (var n = 1; n <= MAX_ROBOT_AXES; n++) {
              if (n <= robotAxesCount) {
                dataOld = oldJoint.joint["J" + n];
                dataNew = newJoint.joint["J" + n];
                if ((dataOld != undefined) && (dataNew != undefined)) {
                  if ((Math.abs(dataNew * DECIMAL_TO_INT - dataOld * DECIMAL_TO_INT) / DECIMAL_TO_INT) > ALLOWABLE) {
                    return false; // differ
                  }
                }
              }
            }

            return true; // same
          }
        },
        convertPositionFormat: function(root, posItem, callback) {
          var config = root.config;
          var func = config.func;
          var curPosItem =  JSON.parse(JSON.stringify(posItem));
          // Get and set format conversion data
          var exchgInfo = func.prepareExchgInfo(root, curPosItem);
          exchgInfo.exchgTo = (curPosItem.frame == top.COORDINATECART) ? top.COORDINATEJOINT: top.COORDINATECART;
          exchgInfo.posNum = (curPosItem.posKind != func.getPosDef('POSKIND_REG')) ? curPosItem.posNumber: curPosItem.posRegNum;
          exchgInfo.posRec = curPosItem;
          exchgInfo.call = callback;
          exchgInfo.rootElem = root;
          var posStr = top.irprogapi.constructExchangePosText(exchgInfo);
          top.rpcmc_mnchgrep(posStr, func.exchgPosCallback, exchgInfo); // rpcmc
        },
        toggleDisabledForms: function(root, toDisable) {
          var config = root.config;
          var func = config.func;
          var switchArgs = {};
          switchArgs.srcRoot = root;
          switchArgs.toDisable = toDisable;
          func.switchDisablePosText(switchArgs);
          func.switchDisableOperationButton(switchArgs);
          func.switchDisablePosNumAndRegNum(switchArgs);
          func.switchDisableModeSel(switchArgs);
        },
        // create and show toast Msg and show, when if cannot be executed.
        toastErrByCalledIf: function(root, baseStr, addIndex) {
          var config = root.config;
          var str = (baseStr != undefined) ? baseStr : "";
          var SEPARATOR = ",";
          var vefiryStr = config.posPopupMsg['msgNoExecVerify'];
          var orgItemsStr = vefiryStr.match(/\((.+)\)/)[1]; //Get the string in parentheses.
          var allItems = [];
          var addItems = [];
          if (addIndex === 0) {
            // 0 -> remove "(xxx, xxx, ...)"
            vefiryStr = vefiryStr.replace(/\(.*\)/g, "");
          } else if (Array.isArray(addIndex)) {
            // [1,2,3,4] -> (number, kind, group, coordinates)
            // [1,2,3] -> (number, kind, group)
            // [1,2] -> (number, kind)
            // [1] -> (number)
            // [2] -> (kind)
            allItems = orgItemsStr.split(SEPARATOR);
            for (var i = 0; i < allItems.length; i++) {
              if (addIndex.indexOf(i+1) !== -1) {
                addItems.push(allItems[i]);
              }
            }
            if (addItems.length > 0) {
              addItems = addItems.join(SEPARATOR);
              addItems = addItems.replace(/^\s+|\s+$/g, ''); // remove first space
              vefiryStr = vefiryStr.replace(orgItemsStr, addItems);
            } else {
              vefiryStr = ""; // only baseStr
            }
          } else {
            // undefined, null -> only baseStr
            vefiryStr = "";
          }
          str += vefiryStr;
          ihmi.cf.toast.show(str);
        },
        // Notification of program start and end.
        // for avoiding to reload timeline.
        notifyEditPos: function(root, isStart) {
          var config = root.config;
          if (typeof config.notifyEditPos === "function") {
            config.notifyEditPos(isStart);
          }
        }
      }
    },
    moveto: {
      movetoDef: {
        DUMMY_PROG_NAME: "ihcpMovetoNoPrg"
      },
      init: function(doc, id, config) {
        var tpVersion = 0;
        var elem = doc.getElementById(id),
            type = this;

        elem.iptElm = {}; // Shortened form of Input element.
        elem.iptElm.textboxuf = doc.getElementById(id + '.uftxt');
        elem.iptElm.textboxut = doc.getElementById(id + '.uttxt');
        elem.iptElm.textboxConf = doc.getElementById(id + '.conftxt');
        elem.iptElm.textboxX = doc.getElementById(id + '.cartxtxt');
        elem.iptElm.textboxY = doc.getElementById(id + '.cartytxt');
        elem.iptElm.textboxZ = doc.getElementById(id + '.cartztxt');
        elem.iptElm.textboxW = doc.getElementById(id + '.cartwtxt');
        elem.iptElm.textboxP = doc.getElementById(id + '.cartptxt');
        elem.iptElm.textboxR = doc.getElementById(id + '.cartrtxt');
        elem.iptElm.textboxJ1 = doc.getElementById(id + '.jnt1txt');
        elem.iptElm.textboxJ2 = doc.getElementById(id + '.jnt2txt');
        elem.iptElm.textboxJ3 = doc.getElementById(id + '.jnt3txt');
        elem.iptElm.textboxJ4 = doc.getElementById(id + '.jnt4txt');
        elem.iptElm.textboxJ5 = doc.getElementById(id + '.jnt5txt');
        elem.iptElm.textboxJ6 = doc.getElementById(id + '.jnt6txt');
        elem.iptElm.textboxE1 = doc.getElementById(id + '.ext1txt');
        elem.iptElm.textboxE2 = doc.getElementById(id + '.ext2txt');
        elem.iptElm.textboxE3 = doc.getElementById(id + '.ext3txt');

        elem.btnElm = {}; // Shortened form of Button element.
        elem.btnElm.btnTgl = doc.getElementById(id + '.altframebtn');
        elem.btnElm.btnMoveTo = doc.getElementById(id + '.moveto');
        elem.btnElm.btnMovBar = doc.getElementById(id + '.movebar');
        elem.btnElm.btnMvArea = doc.getElementById(id + '.movtoslide');
        elem.btnElm.txtTgl = doc.getElementById(id + '.altframelbl');
        elem.btnElm.txtMoveTo = doc.getElementById(id + '.movlbl');
        elem.btnElm.txtTouchUp = doc.getElementById(id + '.tuplbl');
        elem.tabElem = doc.getElementById(id + '.grouptab');

        config.func = type.func;
        elem.config = config;
        elem.config.useProg = false;
        elem.config.targetProgramName = ihmi.moveto.movetoDef.DUMMY_PROG_NAME; // no check program

        elem.config.isTrackingProgram = false; //true: target program is tracking. / false: target program is not tracking.
        elem.config.currentFrame = top.COORDINATECART;
        elem.config.componentMode = ihmi.position.posDef.POSKIND_NUM;  // dummy
        elem.config.currentPosKind = ihmi.position.posDef.POSKIND_NUM; // dummy
        elem.config.currentPosNumber = 1; // dummy
        elem.config.groupCount = 1; // default group count
        elem.config.enableGroupCount = 1; // enable group count (if displaySetting is cart only and Independent Axis group, no count.)
        elem.config.posAxesCount = { 'joint': [], 'robot': [] };
        elem.config.posAxesUnit = []; // Unit string of Axes.
        elem.config.armType = []; // 27 is Independent Axis.
        elem.config.currentGroupNum = 0;
        elem.config.currentConfigStr = '';
        elem.config.configStrCheck = null;
        elem.config.initialized = false;
        elem.config.posNumList = [1, 2, 3]; // dummy
        elem.config.currentPosInfo = {};  // current pos info
        elem.config.allGrpPosInfo = null; // all group pos info
        elem.config.jposrecEnable = 0;         // joint pos rec enable
        elem.config.isUnload = false;
        elem.config.ufutFixedtoF = false;
        elem.config.hideOtherGroupTab = false;

        /* if error occurd, back prev value */
        elem.config.confPreviousVal;

        // Popup Message table.
        elem.config.posPopupMsg = ihmi.position.posPopupMsg;
        elem.config.posLSText = {
          'posCommandStr': 'P',
          'posConfigStr': 'CONFIG',
          'posTrackNum': 'LINE_TRACK_SCHEDULE_NUMBER'
        };
        // Reacquire
        var defaultView = ihmi.cf.getDefaultView(elem.ownerDocument);
        elem.config.myWebPage = (defaultView != null) ? defaultView.webpage : "";
        // [Extension] Comment element disable (true/false(default))
        elem.config.dispErrorPopup = false; // dummy
        elem.config.displaySetting = parseInt(elem.config.displaySetting);

        if ((elem.config.displaySetting !== ihmi.position.posDef.DISPLAYSETTING_CART) &&
            (elem.config.displaySetting !== ihmi.position.posDef.DISPLAYSETTING_JOINT)) {
          elem.config.displaySetting = ihmi.position.posDef.DISPLAYSETTING_NORMAL;
        }
        elem.config.mvbtnActive = false;
        elem.config.disabledPosData = false; // disable position textboxes.
        elem.config.disabled = true; // [#11556] If true, disable the component when PROTECT is READ.
        elem.config.status = ihmi.position.posDef.STATUS_OK;

        // Open functions
        elem.refresh = type.refresh;
        elem.getPos = type.getPos;
        elem.setPos = type.setPos;
        elem.setCurPos = type.setCurPos;
        elem.setCallback = type.setCallback;
        // Open functions (Use the same function as position component)
        elem.alternateFrame = ihmi.position.alternateFrame;
        elem.setPosition = ihmi.position.setPosition;
        elem.toggleFrameType = ihmi.position.toggleFrameType;

        // Internal(Private) functions
        elem.dispPositionData = type.dispPositionData;
        elem.putPositionRecord = type.putPositionRecord;

        //Use the same function as position component
        elem.moveto = ihmi.position.moveto;
        elem.onendMvTo = ihmi.position.onendMvTo;
        elem.onmoveMvTo = ihmi.position.onmoveMvTo;
        elem.popupConfirm = ihmi.position.popupConfirm;
        elem.positionString = ihmi.position.positionString;
        elem.createRecord = ihmi.position.createRecord;
        elem.dispPositionData = ihmi.position.dispPositionData;
        // Removing the comment out causes the event to occur twice.
        //elem.onstartMvTo = ihmi.position.onstartMvTo;
        //elem.onkeypress = ihmi.position.onkeypress;
        //elem.onchange = ihmi.position.onchange;
        elem.getRobotAxesCount = ihmi.position.getRobotAxesCount;
        elem.getExtendAxesCount = ihmi.position.getExtendAxesCount;
        elem.getJointAxesCount = ihmi.position.getJointAxesCount;
        elem.getCurrentConfig = ihmi.position.getCurrentConfig;
        elem.savePosition = ihmi.position.savePosition;

        var func = config.func;
        var posF = ihmi.position.func;
        func.convertPositionFormat = posF.convertPositionFormat;
        func.toastErrByCalledIf = posF.toastErrByCalledIf;
        func.getRobotGroupNumInEnableGroup = posF.getRobotGroupNumInEnableGroup;
        func.checkConvCartJointBeforeRecPos = posF.checkConvCartJointBeforeRecPos;
        func.getTargetRobotInEnableGrpFrame = posF.getTargetRobotInEnableGrpFrame;
        func.checkConvCartToJoint = posF.checkConvCartToJoint;
        func.getCrxRobotPosFrame = posF.getCrxRobotPosFrame;
        func.validateError = posF.validateError;
        func.toggleSelectableTextboxes = posF.toggleSelectableTextboxes;
        func.moveto = posF.moveto;
        func.popupConfirm = posF.popupConfirm;
        func.positionString = posF.positionString;
        func.getPosDef = posF.getPosDef;
        func.getRepKind = posF.getRepKind;
        func.getFrameRep = posF.getFrameRep;
        func.getMotionGroupArray = posF.getMotionGroupArray;
        func.getMotionGroupCount = posF.getMotionGroupCount;
        func.checkSystemKeys = posF.checkSystemKeys;
        func.convertTelToNumber = posF.convertTelToNumber;
        func.getCurrentKindNumber = posF.getCurrentKindNumber;
        func.round3digit = posF.round3digit;
        func.redrawPosArea = posF.redrawPosArea;
        func.selectGroupTab = posF.selectGroupTab;
        func.getCurrentConfigString = posF.getCurrentConfigString;
        func.calcClientHeight = posF.calcClientHeight;
        func.prepareExchgInfo = posF.prepareExchgInfo;
        func.exchgPosCallback = posF.exchgPosCallback;
        func.switchPositionDisp = posF.switchPositionDisp;
        func.switchDisableOperationButton = posF.switchDisableOperationButton;
        func.toggleSelectableButton = posF.toggleSelectableButton;
        func.disablePosNumMoveToBtn = posF.disablePosNumMoveToBtn;
        func.disablePosRegMoveToBtn = posF.disablePosRegMoveToBtn;
        func.cutOutSjisBytes = posF.cutOutSjisBytes;
        func.validate = posF.validate;
        func.popupErrorNotClosed = posF.popupErrorNotClosed;
        func.popupPositionAlert = posF.popupPositionAlert;
        func.setConfigStatus = posF.setConfigStatus;
        func.getConfigStatus = posF.getConfigStatus;
        func.judgeDisableTglAltframeBtn = posF.judgeDisableTglAltframeBtn;
        func.cancelTextSelection = posF.cancelTextSelection;
        func.getEventClientPos = posF.getEventClientPos;
        func.getEventOffsetPos = posF.getEventOffsetPos;
        func.isEventMouse = posF.isEventMouse;
        func.isProgramProtectOn = posF.isProgramProtectOn;
        func.isDisableEachElements = posF.isDisableEachElements;
        func.checkInitComp = posF.checkInitComp;
        func.convIdToOpeStr = posF.convIdToOpeStr;
        func.initGroupTab = posF.initGroupTab;
        func.disableGroupTab = posF.disableGroupTab;

        addEventHandler_(elem.btnElm.btnTgl, 'click', type.onclickTglBtn);

        if (ihmi.global.isModernBrowser) {
          addEventHandler_(elem.btnElm.btnMoveTo, 'touchstart', ihmi.position.onstartMvTo);
          addEventHandler_(elem.btnElm.btnMoveTo, 'mousedown', ihmi.position.onstartMvTo);
        }
        // Add an event handler to the input text box.
        Object.keys(elem.iptElm).forEach(function(key) {
          // PosRegNum is controlled by the textboxinteger component.
          addEventHandler_(this[key], 'change', ihmi.position.onchange);
          addEventHandler_(this[key], 'keypress', ihmi.position.onkeypress);
          addEventHandler_(this[key], 'focus', type.onFocusText);
          addEventHandler_(this[key], 'blur', type.onBlurText);
        }, elem.iptElm);

        // Catch and stop moveto before unloading.
        var myFrameWin = getDefaultView_(elem.ownerDocument);
        addEventHandler_(myFrameWin, 'beforeunload', type.onBeforeunload);
        // Call out so that you can have some time to clean up.
        addEventHandler_(myFrameWin, 'pagehide', type.onUnload);

        // Disable each textbox for safety.
        config.func.toggleSelectableTextboxes(true, elem);
        config.func.toggleSelectableButton(elem, true);

        // Disable position number select box for safety.
        if (top.isTabTP()) {
          try {
            tpVersion = Number(android.ApiTabTPVersion());    // eslint-disable-line no-undef
            if ((tpVersion >= 1.22) &&
                android.ApiShouldInputBeNumeric()) {          // eslint-disable-line no-undef
              config.func.convertTelToNumber(elem);
            }
          } catch (e) {
            console.log(e.message);
          }
        }

        // [#9488] Add for delete radius of iPad.
        if (ihmi.global.isiPad) {
          Object.keys(elem.iptElm).forEach(function(key) {
            this[key].style.webkitAppearance = 'none';
            this[key].style.borderRadius = '0px';
          }, elem.iptElm);
        }
      },
      refresh: function(initArgs) {
        var root = this;
        var config = root.config;
        var func = config.func;
        if (!initArgs) {
          initArgs = {};
        }
        config.initialized = false;
         // useProg=true && curProgName is specifed.
         //   -show enable motion group.
         //   -disable toggle frame button, if tracking program.
         // useProg=false && curProgName is not specifed.
         //   -show all exist group.
        config.useProg = (initArgs.useProg != undefined) ? initArgs.useProg : config.useProg;
        if (config.useProg) {
          if (initArgs.curProgName != undefined) {
            config.targetProgramName = initArgs.curProgName;
          } else {
            config.targetProgramName = config.curProgName;
          }
        } else {
          config.targetProgramName = ihmi.moveto.movetoDef.DUMMY_PROG_NAME;
        }
        config.initCompleteCallback = initArgs.initCompleteCallback; // save callback
        config.initCompleteArgs = initArgs;
        config.specifiedPosNum = 1; //dummy
        config.currentGroupNum = parseInt(initArgs.group, 10); // save group
        config.hideOtherGroupTab = ((initArgs.hideOtherGroupTab !== undefined) ? initArgs.hideOtherGroupTab : false); // hide group tab except current group.
        config.motionGroup = 1; // default motion group
        config.posLimit = {};
        config.posLimit.lower = -99999999;
        config.posLimit.upper = 99999999;
        config.ufLimit = {};
        config.ufLimit.lower = 0;
        config.ufLimit.upper = 9;
        config.utLimit = {};
        config.utLimit.lower = 1;
        config.utLimit.upper = 10;
        config.INFLATEMVTOLEFT = 0;      // [#15565] set individual button left edge
        config.allGrpPosInfo = null;     //for editPos() multi group.
        config.saveConvCartToJoint = {};               // Check that joint data are the same before and after conversion.(Joint->Cart->Joint)
        config.saveConvCartToJoint.oldJoint = null;    // Joint data before convert.
        config.saveConvCartToJoint.cart = null;        // Cart data of convert joint to cart.
        config.diffConvCartToJoint = false;            // Convert joint1->cart->joint2, if joint1 and joint2 are different, set true.

        // disabled position textboxes.
        config.disabledPosData = (initArgs.disabledPosData !== undefined) ? initArgs.disabledPosData: false;

        // [#11556] disable the component when PROTECT is READ.
        config.disabled = (initArgs.disabled !== undefined) ? initArgs.disabled: false;
        if (config.specifiedPosNum === -1) config.disabled = true;
        // [#11556] Attribute is PROTECTED or Program is not selected?
        config.isTrackingProgram = false; //true: target program is tracking. / false: target program is not tracking.
        // Get Position Specified Mode/Kind.
        config.componentMode = func.getPosDef('POSKIND_SEL'); // dummy
        config.currentPosKind = ihmi.position.posDef.POSKIND_NUM; // dummy
        config.currentFrame = top.COORDINATECART; // default
        config.status = ihmi.position.posDef.STATUS_OK;
        // Save flag when specified [UF/UT fixed to 'F'] for disable UF/UT.
        config.ufutFixedtoF = (initArgs.ufutFixedtoF !== undefined) ?
          ihmi.cf.parseStrToBoolean(initArgs.ufutFixedtoF): false;

        //get sysytem values.
        getSysVal();

        //1st get sysytem values.
        function getSysVal() {
          if (func.checkUnloadWhileRefreshing(root)) return;
          var sysValObj = {
            system : []
          };
          sysValObj.system = [
            '$SCR.$NUM_GROUP',
            '$SCR.$MAXNUMUFRAM',
            '$SCR.$MAXNUMUTOOL',
            '$JPOSREC_ENB'
          ];
          top.irprogapi.getSystemValByXvr(sysValObj, getPosInfoCallback, 'posInfo.cvr');
        }
        function getPosInfoCallback(cbArg, xmlError) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          // In the case of a new work cell, "**** Uninitialized ****" becomes CRLF.
          // get total axis.
          var matchResult = [];
          var sysKeyTable = [
            {matchKey: 'NUMGROUP', matchStr: /\$SCR.\$NUM_GROUP/},
            {matchKey: 'MAXUFRAME', matchStr: /\$SCR.\$MAXNUMUFRAM/},
            {matchKey: 'MAXUTOOL', matchStr: /\$SCR.\$MAXNUMUTOOL/},
            {matchKey: 'JPOSRECENB', matchStr: /\$JPOSREC_ENB/}
          ];
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp getPosInfoCallback: xml error detect');
          }
          for (var keys in cbArg) {
            if (Object.prototype.hasOwnProperty.call(cbArg, keys)) {
              matchResult = func.checkSystemKeys(keys, sysKeyTable);
              if (matchResult == null) {
                continue;
              }
              switch (matchResult.matchKey) {
              case 'NUMGROUP':
                config.groupCount = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'MAXUFRAME':
                config.ufLimit.upper = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'MAXUTOOL':
                config.utLimit.upper = parseInt(cbArg[keys].trim(), 10);
                break;
              case 'JPOSRECENB':
                config.jposrecEnable = parseInt(cbArg[keys].trim(), 10);
                break;
              }
            }
          }

          // Get Motion Group from Program.
          if (config.targetProgramName === ihmi.moveto.movetoDef.DUMMY_PROG_NAME) {
            // Any group that exists is a enable motion group.
            var existGroup = 0;
            for (var i = 0; i < config.groupCount; i++) {
              existGroup += (1 << i);
            }
            config.motionGroup = existGroup;

            getGroupPosInfo(top.IO_SUCCESS, '', undefined, config.motionGroup, cbArg);
            // conv motion group count to enable group
          } else {
            top.getAttr(config.targetProgramName, top.MM_DEF_GROUP_C, getGroupPosInfo, cbArg); // io
          }
        }
        // 2.5th
        function getGroupPosInfo(status, progName, mmVarName, mmValue, cbArg) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          var sysValObj = {
            system : [],
            posreg : []
          };
          var specifiedGrp = [ // Generated by the number of groups.
            '$SCR_GRP[%%GROUPNUM%%].$NUM_AXES',
            '$SCR_GRP[%%GROUPNUM%%].$NUM_ROB_AXS',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[1]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[2]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[3]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[4]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[5]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[6]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[7]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[8]',
            '$SCR_GRP[%%GROUPNUM%%].$ROTARY_AXS[9]', //MAXROBOTAXES + MAXEXTAXES
            '$SCR_GRP[%%GROUPNUM%%].$ARM_TYPE'
          ];
          if (status !== top.IO_SUCCESS) {
            // no select current program. mmValue is undefined.
            //console.log('[ERROR] ihcp getGroupPosInfo: getAttr() error detect');
            mmValue = 0;
          }
          config.motionGroup = parseInt(mmValue); // Set Motion group
          var motionGrpArr = func.getMotionGroupArray(config.motionGroup);
          var sysIdx = sysValObj.system.length;
          for (var gNum = 0; gNum < motionGrpArr.length; gNum++) {
            if (motionGrpArr[gNum]) { // valid group
              for (var gIdx = 0; gIdx < specifiedGrp.length; gIdx++) {
                sysValObj.system[sysIdx] = specifiedGrp[gIdx].replace('%%GROUPNUM%%', '' + (gNum + 1));
                sysIdx++;
              }
            }
          }
          top.irprogapi.getSystemValByXvr(sysValObj, getPosGroupCallback, 'posGrp' + (gNum + 1) + '.cvr');
        }
        function getPosGroupCallback(cbArg, xmlError) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          var matchResult = [];
          var sysGroup = 1;
          var motionGrpArr = func.getMotionGroupArray(config.motionGroup);
          var minGrpNum;
          var axsunit;
          var axsindex;
          var sysGrpTable = [
            {matchKey: 'NUMAXES', matchStr: /\$SCR_GRP\[(\d)\].\$NUM_AXES/},
            {matchKey: 'ROBAXS', matchStr: /\$SCR_GRP\[(\d)\].\$NUM_ROB_AXS/},
            {matchKey: 'ROTARY', matchStr: /\$SCR_GRP\[(\d)\].\$ROTARY_AXS\[(\d)\]/},
            {matchKey: 'ARMTYPE', matchStr: /\$SCR_GRP\[(\d)\].\$ARM_TYPE/}
          ];
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp getPosGroupCallback: xml error detect');
          }
          for (var keys in cbArg) {
            if (Object.prototype.hasOwnProperty.call(cbArg, keys)) {
              matchResult = func.checkSystemKeys(keys, sysGrpTable);
              if (matchResult == null) {
                continue;
              }
              sysGroup = parseInt(matchResult[1]);
              switch (matchResult.matchKey) {
              case 'NUMAXES':
                config.posAxesCount.joint[sysGroup] = parseInt(cbArg[keys]);
                break;
              case 'ROBAXS':
                config.posAxesCount.robot[sysGroup] = parseInt(cbArg[keys]);
                break;
              case 'ROTARY':
                axsunit = config.posAxesUnit;
                if (axsunit[sysGroup] === undefined) {
                  axsunit[sysGroup] = [];
                }
                axsindex = parseInt(matchResult[2]) - 1;
                axsunit[sysGroup][axsindex] = (cbArg[keys].toLowerCase() == 'true') ? 'deg' : 'mm';
                break;
              case 'ARMTYPE':
                config.armType[sysGroup] = parseInt(cbArg[keys]);
                break;
              }
            }
          }
          // serch minimum group num
          for (var i = 0; i < motionGrpArr.length; i++) {
            if (motionGrpArr[i] === true) {
              minGrpNum = i + 1;
              break;
            }
          }
          if (minGrpNum === undefined) {
            // no select current program
            config.targetProgramName = ''; // all disabled
            //console.log('[ERROR] enable group does not exist.');
            minGrpNum = 1; // dummy
          }
          config.currentGroupNum = ((config.currentGroupNum == null) || (motionGrpArr[config.currentGroupNum - 1] !== true)) ?
            minGrpNum :
            config.currentGroupNum;

          // 3th for get current config string.
          func.getCurrentConfigString(root, getCurrentConfigStringCallback);
        }
        // 4th get position number list.
        function getCurrentConfigStringCallback(isSuccess) {
          if (!isSuccess) {
            ihmi.cf.toast.show(config.posPopupMsg['msgGetCurPosError']);
            config.targetProgramName = ''; // all disabled
          }
          if (config.targetProgramName === ihmi.moveto.movetoDef.DUMMY_PROG_NAME) {
            completeRefresh(); // no tracking
          } else {
            top.get_appLineTrack(config.targetProgramName, getAppLineTrackCallback, null, null);
          }
        }
        //5th set line tracking.
        function getAppLineTrackCallback(status, progName, schdNum, contTrck, selBound, cbArg1, cbArg2) {
          if (func.checkUnloadWhileRefreshing(root)) return;
          if (status !== top.IO_SUCCESS) {
            //not exist position or not teached
            //console.log('[ERROR] getAppLineTrackCallback: get_appLineTrack() failed. (status=' + status +'.)');
          } else {
            if (schdNum > 0) {
              config.isTrackingProgram = true;
            }
          }
          completeRefresh();
        }

        // 7th Complete refresh pre process. Initialize the display and complete.
        function completeRefresh() {
          if (func.checkUnloadWhileRefreshing(root)) return;
          // Initialize group tab
          func.initGroupTab(root);

          // Will "PosArea" be unfolded at initialization?
          func.redrawPosArea(root, null); // specify null and don't set root height.

          // Enable textboxes.
          func.toggleSelectableTextboxes(false, root);
          // Enable/Disable position mode select.
          func.toggleSelectableButton(root, false);

          // Continue drawing
          var drawArgs = {root: root, posFrame: undefined, origin: ihmi.position.posDef.DRAWORIGIN_REFRESH};
          func.drawPosition(drawArgs);
          //console.log('init: Complete(' + config.initialized + ')'); // debug message
        }
      },
      setCallback: function(callback) {
        var elem = this;
        elem.config.callback = callback;
      },
      setPos: function(posRec) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var defPos = root.createRecord.get();
        var reqPos = JSON.parse(JSON.stringify(posRec));

        if (!config.func.checkInitComp(root)) {
          return false;
        }
        if (config.status !== ihmi.position.posDef.STATUS_OK) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [3, 4]);
          return false;
        }

        if (config.currentFrame !== reqPos.frame) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [3, 4]);
          return false;
        }

        if (reqPos.group == undefined) {
          reqPos.group = config.currentGroupNum;
        }
        if (config.currentGroupNum !== reqPos.group) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgNoExecPost'], [3, 4]);
          return false;
        }

        if ((reqPos == undefined) || reqPos.empty) {
          // Illegal record
          func.toastErrByCalledIf(root,
            config.posPopupMsg['msgNoExecPost'] + config.posPopupMsg['msgNoExecEmpty'],
            null);
          return false;
        }
        reqPos = ihmi.cf.objectAssignPolyfill(defPos, reqPos);
        reqPos.posKind = 1; //dummy
        reqPos.posNumber = 1; //dummy

        // Set to position.
        root.setPosition(1, reqPos);
        root.dispPositionData(reqPos);
        if (!root.putPositionRecord(reqPos, null, false)) {
          return false;
        }
        return true;
      },
      getPos: function() {
        var root = this;
        var config = root.config;
        var func = config.func;
        var posRec;
        var robotAxes = root.getRobotAxesCount(config.currentGroupNum);
        var extendAxes = root.getExtendAxesCount(config.currentGroupNum);
        var targetKeys = ["frame", "group", "empty"];
        var CART_KEYS = ["rep", "cart", "uf", "ut", "conf"];
        var JOINT_KEYS = ["rep", "joint", "uf", "ut"];
        var EX_AXES_KEYS = ["ext"];

        if (!func.checkInitComp(root)) {
          return null;
        }
        posRec = JSON.parse(JSON.stringify(config.currentPosInfo));

        if (!posRec.empty) {
          switch (Number(posRec.rep)) {
            case top.POS_REP_CART:
            case top.POS_REP_BOTH:
              targetKeys = targetKeys.concat(CART_KEYS);
              break;
            case top.POS_REP_JOINT:
              targetKeys = targetKeys.concat(JOINT_KEYS);
              break;
          }
          if (extendAxes > 0) {
            targetKeys = targetKeys.concat(EX_AXES_KEYS);
          }
        }
        // Delete unnecessary data
        Object.keys(posRec).forEach(function(key) {
          if (!ihmi.cf.includesArray(targetKeys, key)) {
            delete this[key];
          }
        }, posRec);

        // Notify only existing robot axes
        if (posRec.joint) {
          Object.keys(posRec.joint).forEach(function(key) {
            if (key.replace(/[^0-9]/g, '') > robotAxes) {
              delete this.joint[key];
            }
          }, posRec);
        }

        // Notify only existing extend axes
        if (posRec.ext) {
          Object.keys(posRec.ext).forEach(function(key) {
            if (key.replace(/[^0-9]/g, '') > extendAxes) {
              delete this.ext[key];
            }
          }, posRec);
        }
        return posRec;
      },
      setCurPos: function() {
        var root = this;
        var config = root.config;
        var func = config.func;
        var cbArg = {};
        var posRec = {};
        var currentGrp = config.currentGroupNum;
        var frame = config.currentFrame;
        var ufutSystemValue;
        var saveJoingStr = '';
        var sysValObj = { system: ['$MNUFRAMENUM[' + config.currentGroupNum + ']', '$MNUTOOLNUM[' + config.currentGroupNum + ']'] };

        cbArg.posNum = 1; // dummy
        cbArg.callback = posExtendAxisCallback;
        cbArg.rec = posRec;
        cbArg.tblKind = 0;

        if (!func.checkInitComp(root)) {
          return;
        }
        if (config.status !== ihmi.position.posDef.STATUS_OK) {
          func.toastErrByCalledIf(root, config.posPopupMsg['msgRecPosError'], [3, 4]);
          return;
        }
        root.popupConfirm(config.posPopupMsg['msgIdConfTouchup'], popupTouchUpCallback);
        function popupTouchUpCallback(id, operation) {
          if (id == 'btn1') { // OK
            // Disable each elements.
            func.toggleSelectableTextboxes(true, root);
            func.toggleSelectableButton(root, true);
            func.disableGroupTab(root, true);
            //get current Robot Position
            top.irprogapi.getSystemValByXvr(sysValObj, GetUFUTValueCallback, 'currentProgStat.cvr');
          }
        }

        function GetUFUTValueCallback(ufutCbArg, xmlError) {
          // check uf/ut... valid = joint or uf/ut is match.
          // PosReg does not check the UF/UT value, it uses the system value.
          var sysGrpTable;
          if (xmlError) {
            //xml error detect
            console.log('[ERROR] ihcp GetUFUTValueCallback: xml error detect');
          }
          sysGrpTable = {
            UF: parseInt(ufutCbArg['$MNUFRAMENUM[' + config.currentGroupNum + ']']),
            UT: parseInt(ufutCbArg['$MNUTOOLNUM[' + config.currentGroupNum + ']'])
          };
          ufutSystemValue = sysGrpTable; // current UF/UT value.

          if (frame == top.COORDINATECART) { // Cartesian coordinate
            top.get_curpos(top.KXYZWPR, top.TXML_TP_REC_TYPE, currentGrp, getCurposCallback, cbArg);  // irprog_io
          } else { // Joint coordinate
            top.get_curang(currentGrp, getCurangCallback, cbArg); // irprog_io
          }
        }

        function getCurposCallback(posRep, posType, grpNum, str, cbArg) {
          // Return object
          var defCart = top.COORDINATECART;
          var posAnl = top.irprogapi.analyzePositionStr(defCart, str, cbArg.rec);
          var posCart = root.createRecord.get();
          posCart.posNumber = cbArg.posNum;
          posCart.frame = defCart;
          posCart.group = grpNum;
          posCart.conf = posAnl.Config;
          posCart.uf = ufutSystemValue.UF;
          posCart.ut = ufutSystemValue.UT;
          posCart.cart.X = posAnl.X;
          posCart.cart.Y = posAnl.Y;
          posCart.cart.Z = posAnl.Z;
          posCart.cart.W = posAnl.W;
          posCart.cart.P = posAnl.P;
          posCart.cart.R = posAnl.R;
          posCart.empty = false;
          // Get extend axis
          cbArg.rec = posCart;
          top.get_curang(grpNum, getExtAxisCallback, cbArg);  // irprog_io
        }
        function getCurangCallback(grpNum, str, cbArg) {
          var defJoint = top.COORDINATEJOINT;
          var posAnl = top.irprogapi.analyzePositionStr(defJoint, str, cbArg.rec);
          var posJoint = root.createRecord.get();
          posJoint.posNumber = cbArg.posNum;
          posJoint.frame = defJoint;
          posJoint.group = grpNum;
          posJoint.conf = posAnl.Config;
          posJoint.uf = ufutSystemValue.UF;
          posJoint.ut = ufutSystemValue.UT;
          posJoint.rep = top.POS_REP_JOINT;
          posJoint.force = cbArg.force;
          posJoint.joint.J1 = posAnl.J1;
          posJoint.joint.J2 = posAnl.J2;
          posJoint.joint.J3 = posAnl.J3;
          posJoint.joint.J4 = posAnl.J4;
          posJoint.joint.J5 = posAnl.J5;
          posJoint.joint.J6 = posAnl.J6;
          posJoint.ext.E1 = posAnl.EXT1;
          posJoint.ext.E2 = posAnl.EXT2;
          posJoint.ext.E3 = posAnl.EXT3;
          posJoint.empty = false;
          if (cbArg.callback != undefined) {
            cbArg.callback(posJoint);
          }
        }
        function getExtAxisCallback(grpNum, posStr, cbArg) {
          // Analyze
          var posJson = cbArg.rec;
          var posTemp = JSON.parse(JSON.stringify(posJson));  // Copy(Clone) position data to temp data.
          var tempJson = top.irprogapi.analyzePositionStr(top.COORDINATEJOINT, posStr, posTemp);
          saveJoingStr = posStr; // save for checkConvCartJointBeforeRecPos

          // Set data
          var posRep = top.POS_REP_CART;
          for (var i = 0; i < 3; i++) {   // Max ext axes
            var tempExt = tempJson['EXT' + (i + 1)];
            if (tempExt != undefined) {   // data exist, rep is both.
              posRep = top.POS_REP_BOTH;
            }
            posJson.ext['E' + (i + 1)] = tempExt;
          }
          posJson.frame = top.COORDINATECART;
          posJson.rep = posRep;
          posJson.force = cbArg.force;
          if (cbArg.callback != undefined) {
            cbArg.callback(posJson);
          }
        }

        function posExtendAxisCallback(posData) {
          var isCreateNewPos = false;
          // In calse moveto component,
          // settings only for the Group of the Robot currently displayed.
          // The only conditions that must be checked are CRX Robot(Group1) and frame is Cart.
          if (top.g_crx &&
             (config.currentFrame === top.COORDINATECART) &&
             (config.currentGroupNum === 1)) {

            func.checkConvCartJointBeforeRecPos(root, isCreateNewPos,
              function (execRecpos, isDiffernt) {
                var convJoint = false;
                var CONV_JOINT_STR = config.posPopupMsg['msgRecPosCartError'] + config.posPopupMsg['msgRecPosJoint'];
                if (!execRecpos) {
                  drawForms(null);
                  return;
                }

                if (config.jposrecEnable === 1) {
                  // If $JPOSREC_ENB is 1, recPos(joint).
                  convJoint = true;
                } else {
                  if (isDiffernt) { // Differnt before and after conversion.
                    convJoint = true;
                  }
                }
                if (convJoint) {
                  config.currentFrame = top.COORDINATEJOINT;
                  getCurangCallback(config.currentGroupNum, saveJoingStr, cbArg);
                  ihmi.cf.toast.show(CONV_JOINT_STR);
                  return;
                }
                drawForms(posData);
                return;
              }
            );
          } else {
            // no need to check
            drawForms(posData);
          }

          function drawForms(posData) {
            func.toggleSelectableTextboxes(false, root);
            func.toggleSelectableButton(root, false);
            func.disableGroupTab(root, false);
            if (posData) {
              var drawArgs = {root: root, frame: undefined, origin: undefined, posRec: posData};
              func.drawPosition(drawArgs);
              root.putPositionRecord(posData, root.id + "." + "setCurPos", true); // callback
            }
          }
        }
      },
      putPositionRecord: function(posData, targetId, callbackCall) {
        var root = this;
        var config = root.config;
        var func = config.func;

        if (posData == undefined) { // Position is empty.
          // eslint-disable-next-line no-console
          console.log('[ERROR] putPositionRecord: Position data is empty.');
          return false;
        }

        // update previous
        config.confPreviousVal = posData.conf;

        // Call callback function.
        if ((typeof config.callback === 'function') && callbackCall) {
          // Modify for match with other parts.
          var cbInfo = {group: config.currentGroupNum};
          var operation = func.convIdToOpeStr(root, targetId);
          config.callback(root.id, operation, cbInfo);
        }
        return true;
      },
      onclickTglBtn: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'ihcp-moveto');
        var config = root.config;
        var toFrameType = (config.currentFrame == top.COORDINATEJOINT) ?
            top.COORDINATECART : top.COORDINATEJOINT;
        root.alternateFrame(toFrameType);
        return false;
      },
      onFocusText: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'ihcp-moveto');
        var func = root.config.func;

        // Disable Operation buttons
        func.toggleSelectableButton(root, true);

        // Set cursor position to edge of the right.
        var posValLeng = clickedElem.value.length;
        if (clickedElem.setSelectionRange) {
          setTimeout(function() { //for IE. if not exist, don't work properly when start and end is same.
            clickedElem.setSelectionRange(posValLeng, posValLeng);
            clickedElem.click(); // Just in case...(for IE)
          }, 10);
        } else if (clickedElem.createTextRange) {
          //for IE7,IE8
          var range = clickedElem.createTextRange();
          range.collapse(true);
          range.moveEnd('character', posValLeng);
          range.moveStart('character', posValLeng);
          setTimeout(function() { //if not exist, all selected.
            range.select();
          }, 10);
        }
      },
      onBlurText: function(event) {
        var clickedElem = event.srcElement;
        var root = ihmi.cf.findAncestor(clickedElem, 'div', 'ihcp-moveto');
        var func = root.config.func;

        // Disable Operation buttons
        func.toggleSelectableButton(root, false);
      },
      onBeforeunload: function(event) {
        //console.log('[INFO] BeforeUnload event. (' + event.type + ')');
        var unloadDoc = event.srcElement;
        if (getIEVersion_(userAgent) === 11) {
          // In the case of IE, event.srcElement is an object of the window rather than the document.
          // To prevent errors in findDescendant().
          unloadDoc = event.srcElement.document;
        }
        var baseElem = ihmi.cf.findDescendant(unloadDoc, 'div', 'ihcp-moveto');
        if (baseElem == null) return;
        // Stop the MoveTo process.
        baseElem.config.func.unloadMvTo(unloadDoc, event.type);
      },
      onUnload: function(event) {
        var unloadDoc = event.srcElement;
        var baseElem;
        var doc;
        var movetos;
        if (getIEVersion_(userAgent) === 11) {
          // In the case of IE, event.srcElement is an object of the window rather than the document.
          // To prevent errors in findDescendant().
          unloadDoc = event.srcElement.document;
        }
        baseElem = ihmi.cf.findDescendant(unloadDoc, 'div', 'ihcp-moveto');
        if (baseElem == null) return;
        baseElem.config.func.unloadMvTo(unloadDoc, event.type);
        doc = baseElem.ownerDocument;
        if (doc == null) return;
        movetos = doc.querySelectorAll('div.ihcp-moveto');
        for (var i = 0; i < movetos.length; i++) {
          movetos[i].config.isUnload = true;
        }
      },
      /* use position component functions */
      /*
      dispPositionData:
      getRobotAxesCount:
      getExtendAxesCount:
      getJointAxesCount:
      getCurrentConfig:
      createRecord:
      setPosition:
      toggleFrameType:
      moveto:
      popupConfirm:
      positionString:
      savePosition:
      onstartMvTo:
      onmoveMvTo:
      onendMvTo:
      alternateFrame:
      onkeypress:
      onchange:
      */
      func: {
        pickPosNumber: function(doc, elemId) {
          return 1; // dummy
        },
        callbackInitComplete: function(root, callbackCall) {
          var config = root.config;
          config.initialized = true;
          if (callbackCall && (config.initCompleteCallback != undefined) && (typeof config.initCompleteCallback === 'function')) {
            // Call callback function of initialize completion.
            var initRefreshInfo = {id: root.id};
            initRefreshInfo.group = config.currentGroupNum;
            config.initCompleteCallback(config.initCompleteArgs, initRefreshInfo);
          }
        },
        callbackChangeGroupTab: function(root) {
          var config = root.config;
          var func = config.func;
          if ((typeof config.callback === 'function') &&
              (!config.disabled)) { // when disabled is false (enable)
            var grpTabId = root.id + '.gp' + config.currentGroupNum;
            var cbInfo = {group: config.currentGroupNum};
            var operation = func.convIdToOpeStr(root, grpTabId);
            config.callback(root.id, operation, cbInfo); // Modify for match with other parts.
          }
        },
        // Draw position data to component.
        // (IN) drawArgs : Argument for draw.
        //      .root : Target position component.
        //      .posFrame : (not used) Frame of position
        //      .origin : Caller of origin (DRAWORIGIN_REFRESH / DRAWORIGIN_GROUP / undefined:setCurPos())
        drawPosition: function(drawArgs) {
          var root = drawArgs.root;
          var doc = root.ownerDocument;
          var config = root.config;
          var func = config.func;
          var posData;
          var reqPosNum = 1; // Fixed 1
          var isIndAxis = (config.armType[config.currentGroupNum] == 27) ? true : false;
          var groupArray = func.getMotionGroupArray(config.motionGroup);
          var enableGrpCount = func.getMotionGroupCount(config.motionGroup);
          var altElem = doc.getElementById(root.id + '.altframe');
          var reqPosFrame = top.COORDINATECART;
          var isDifferntSetting = false;

          if (enableGrpCount > 0) {
            switch (drawArgs.origin) {
              case ihmi.position.posDef.DRAWORIGIN_REFRESH:
                if (config.allGrpPosInfo === null) {
                  config.allGrpPosInfo = [];
                  for (var grp = 0; grp < groupArray.length; grp++) {
                    // if enabel motion group exist, set default.
                    config.allGrpPosInfo[grp] = root.createRecord.get();
                    config.allGrpPosInfo[grp].group = grp + 1;
                  }
                }
                break;
              case ihmi.position.posDef.DRAWORIGIN_GROUP:
                for (var i = 0; i < config.allGrpPosInfo.length; i++) {
                  if (config.allGrpPosInfo[i].group === config.currentPosInfo.group) {
                    // save old info before group change;
                    config.allGrpPosInfo[i] = JSON.parse(JSON.stringify(config.currentPosInfo));
                  }
                  if (config.allGrpPosInfo[i].group === config.currentGroupNum) {
                    // set new pos info of new group.
                    posData = JSON.parse(JSON.stringify(config.allGrpPosInfo[i]));
                  }
                }
                break;
              default:  //undefined is called from setCurPos();
                posData = drawArgs.posRec;
                break;
            }
          }

          if (config.targetProgramName.length == 0) {
            // useProg=true but not exist enable group
            // useProg=true but displaySettting=0 and enable group is Independent Axis.
            isDifferntSetting = true;
          }
          func.setConfigStatus(root, ihmi.position.posDef.STATUS_DIFFERNT_SETTING, isDifferntSetting);
          // judge frame start
          if (isIndAxis) { // Independent Axis -> joint
            if (config.displaySetting === func.getPosDef('DISPLAYSETTING_CART')){
              // useProg=true, and enable motion group is Independent Axis, all disabled and no tabs.
            } else {
              reqPosFrame = top.COORDINATEJOINT;
            }
          }

          if (config.displaySetting !== func.getPosDef('DISPLAYSETTING_NORMAL')) {
            // displaySetting check
            ihmi.cf.addClass(altElem, 'hide');
            reqPosFrame = config.displaySetting;
          }
          if (posData != undefined) {
            // by tab change -> new group posInfo's frame
            // by setCurPos() -> current robot posInfo's frame
            reqPosFrame = (posData.empty) ? reqPosFrame : posData.frame;
          }
          config.currentFrame = reqPosFrame;
          // judge frame end

          if (posData != undefined) { // valid pos data
            root.setPosition(reqPosNum, posData); // Set to pos data area, when valid posnum.
            root.dispPositionData(posData);

            // If call origin is refresh, callback initComplete.
            if (drawArgs.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
              func.disablePosNumMoveToBtn(root, false); //[#18288 bugv3 No26]
              func.callbackInitComplete(root, true); // Call initCompleteCallback
            }
            // [#11556] add check R/O
            func.toggleSelectableTextboxes(false, root);
          } else {
            posData = root.createRecord.get();
            posData.group = config.currentGroupNum;
            posData.posNumber = reqPosNum;
            root.setPosition(reqPosNum, posData);//set dummy pos data.
            root.dispPositionData(posData);
          }

          // callback
          if (drawArgs.origin == ihmi.position.posDef.DRAWORIGIN_REFRESH) {
            func.callbackInitComplete(root, true); // Call initCompleteCallback
          } else if (drawArgs.origin == ihmi.position.posDef.DRAWORIGIN_GROUP) {
            func.callbackChangeGroupTab(root);     // tap group tab
          }
        },
        isMovetoRunning: function(baseElem) {
          // get position component list
          var movetoCompos = ihmi.cf.findDescendants(baseElem, 'div', 'ihcp-moveto');
          var targetElm = null;
          var moveToBtn;
          // MoveTo program is running?
          for (var p = 0; p < movetoCompos.length; p++) {
            var root = movetoCompos[p];
            if (root.btnElm == undefined) {
              break;
            }
            moveToBtn = root.btnElm.btnMoveTo;
            if (ihmi.cf.hasClass(moveToBtn, 'position-moveto-on')) {  // Moveto running component.
              targetElm = root;
              break;
            }
          }
          return targetElm;
        },
        unloadMvTo: function (element, eventType) {
          var targetElm = ihmi.moveto.func.isMovetoRunning(element);
          var config;
          var moveToName;
          var moveToBtn;

          // MoveTo program is running?
          if (targetElm != null) {  // if MoveTo program exec, stop move to.
            config = targetElm.config;
            moveToBtn = targetElm.btnElm.btnMoveTo;
            if (ihmi.cf.hasClass(moveToBtn, 'position-moveto-on')) {
              top.sendKey("Hold", 1);
              top.sendKey("Hold", 0);
              ihmi.cf.removeClass(moveToBtn, 'position-moveto-on');
            }
            config.mvbtnActive = false;
            if (eventType === "beforeunload") {
              moveToName = config.func.getPosDef('MOVETOPROGRAMNAME');
              top.setAttr(moveToName, top.MM_CONTROL_C, '1', function(status, progName) {
                //console.log('[INFO] position: MoveTo program set to invisible. (' + status + ')');
              }); // irprog_io
            }
            // Allows you to do post-processing even a little.
            setTimeout(function() {}, 10);
          }
        },
        checkUnloadWhileRefreshing: function(root) {
          var config = root.config;
          if (!config.initialized && config.isUnload) { // no initialized.
            config.initialized = true;
            return true;
          }
          return false;
        },
        // disabled textboxes in case moveto component.
        // differnt from toggleDisabledForms() in position component.
        toggleDisabledForms: function(root, toDisable) {
          // called timing
          // toggleFrameType
          // setCurPos() and check joing->cart->joint
          var config = root.config;
          var func = config.func;
          var switchArgs = {};
          switchArgs.srcRoot = root;
          switchArgs.toDisable = toDisable;
          func.toggleSelectableTextboxes(toDisable, root);
        }
        /* use position component functions */
        /*getPosDef:
        getRepKind:
        getFrameRep:
        getMotionGroupArray:
        getMotionGroupCount:
        checkSystemKeys:
        convertTelToNumber:
        getCurrentKindNumber:
        round3digit:
        redrawPosArea:
        selectGroupTab:
        getCurrentConfigString:
        calcClientHeight:
        prepareExchgInfo:
        exchgPosCallback:
        switchPositionDisp:
        switchDisableOperationButton:
        toggleSelectableButton:
        disablePosNumMoveToBtn:
        disablePosRegMoveToBtn:
        cutOutSjisBytes:
        validate:
        popupErrorNotClosed:
        popupPositionAlert:
        getConfigStatus:
        validateError:
        toggleSelectableTextboxes:
        judgeDisableTglAltframeBtn:
        cancelTextSelection:
        getEventClientPos:
        getEventOffsetPos:
        isEventMouse:
        isProgramProtectOn:
        isDisableEachElements:
        checkInitComp:
        convIdToOpeStr:
        initGroupTab:
        getCrxRobotPosFrame:
        checkConvCartJointBeforeRecPos:
        getRobotGroupNumInEnableGroup:
        getTargetRobotInEnableGrpFrame:
        checkConvCartToJoint:
        convertPositionFormat:
        toastErrByCalledIf:
        */
      }
    },
    inputFormList: {
      init: function(doc, id, config) {
        var root = doc.getElementById(id);
        var type = this;
        var frame = getDefaultView_(doc);
        root.config = config;
        if ((root.config.maxRow !== undefined) && (root.config.maxRow >= 1)) {
          root.config.maxRow = parseInt(root.config.maxRow, 10);
        } else {
          root.config.maxRow = 100;
        }
        root.config.numOfRow = 1;
        root.config.rowList = {};
        root.config.baseOption = null;
        root.config.btnDisabled = false;
        root.refresh = type.refresh;
        root.getRowCount = type.getRowCount;
        root.getRowList = type.getRowList;
        root.setCallback = type.setCallback;
        root.addRow = type.addRow;
        root.scrollToLastLine = type.scrollToLastLine;
        root.removeAllRows = type.removeAllRows;
        root.removeRow = type.removeRow;
        root.checkAddRemoveBtn = type.checkAddRemoveBtn;
        root.initIncDecBtns = type.initIncDecBtns;
        root.getSpecifiedRow = type.getSpecifiedRow;
        root.setBtnPosition = type.setBtnPosition;
        determineDefaultDesignPattern_(root);
        root.config.btnAddElem = doc.getElementById(id + ".btnAdd");
        root.config.btnRemoveElem = doc.getElementById(id + ".btnRemove");
        addEventHandler_(root.config.btnAddElem, "click", type.onclick);
        addEventHandler_(root.config.btnRemoveElem, "click", type.onclick);
        root.checkAddRemoveBtn();
        if (ihmi.global.isiPad) {
          if (root.config.designpattern === "mouse") {
            root.config.btnAddElem.style.top = "-6px";
            root.config.btnRemoveElem.style.top = "-6px";
          }
        }
        if (ihmi.global.isModernBrowser) {
          addEventHandler_(frame, 'resize', debounce_(function() {
            root.setBtnPosition();
          }, 200));
        }
      },
      refresh: function(baseOption, addRowCount, maxRow, width, disabled) {
        var root = this;
        var config = root.config;
        var copyCount = addRowCount;

        if (disabled != undefined) {
          disabled = ihmi.cf.parseStrToBoolean(disabled);
          config.btnDisabled = disabled;
        }

        if ((maxRow != undefined) && (maxRow >= 1)) {
          config.maxRow = maxRow;
        }

        if (width != undefined) {
          root.style.width = width;
        }

        if ((config.numOfRow + addRowCount) > config.maxRow) {
          //error
          return;
        }

        if (baseOption != undefined) {
          config.baseOption = baseOption;
        }
        config.rowList[1] = config.baseOption;

        while (copyCount > 0) {
          root.addRow(false);
          copyCount = copyCount - 1;
        }
        root.checkAddRemoveBtn();
        root.setBtnPosition();
      },
      setCallback: function(callback) {
        var root = this;
        root.config.callback = callback;
      },
      getRowCount: function() {
        var root = this;
        return root.config.numOfRow;
      },
      getRowList: function() {
        var root = this;
        var returnRowList = {};

        if (typeof JSON === "object") {
          returnRowList = JSON.parse(JSON.stringify(root.config.rowList));
        } else {
          //can't deep copy
          returnRowList = root.config.rowList;
        }
        return returnRowList;
      },
      onclick: function(event) {
        var srcElement = event.srcElement;
        var button = findAncestor_(srcElement, 'button', 'input-form-list-btn');
        var root = findAncestor_(button, 'div', 'input-form-list');
        var buttonType = button.id.match(/\.(.*)$/)[1];

        lightupBtnMoment_(button);

        if (buttonType === "btnAdd") {
          root.addRow(true);
        } else if (buttonType === "btnRemove") {
          root.removeRow(true, true);
        }
      },
      addRow: function(isUserOpe) {
        var root = this;
        var ul = findDescendant_(root, 'ul', 'input-form-list-rows');
        var doc = root.ownerDocument;
        var config = root.config;
        var baseOption = config.baseOption;
        var firstRow = root.getSpecifiedRow(1);
        var cloneNode = firstRow.cloneNode(true);
        var baseId;
        var baseIdStr;
        var baseElem;
        var innerRootElem;
        var innerRootInitElem;
        var newId;
        var searchStr;
        var initConfig;
        var callBackArg = {};
        var addFormArray = [];

        if (baseOption === null) {
          return;
        }

        config.numOfRow = config.numOfRow + 1;
        ul.appendChild(cloneNode);

        root.checkAddRemoveBtn();

        function replaceChildId(searchStr, targetNode, newId) {
          //replace to newid for childElements.
          var innerRootElems = ihmi.cf.querySelectorAll(targetNode, searchStr);

          for (var i = 0; i < innerRootElems.length; i++) {
            var elem = innerRootElems[i];
            var oldId = elem.id;
            elem.id = oldId.replace(baseId, newId);
          }
        }

        for (var i = 0; i < baseOption.length; i++) {
          //change id
          baseId = baseOption[i].id;
          baseIdStr = baseId.match(/^(\w+)_(\d+)$$/);//split id name to string / number.
          //baseIdStr[1] : id name
          //baseIdStr[2] : index
          baseElem = doc.getElementById(baseId);
          newId = baseIdStr[1] + "_" + config.numOfRow;

          searchStr = "[id^=" + baseId + "]";

          innerRootElem = querySelector_(cloneNode, searchStr); //search input form in li.
          if (innerRootElem !== null) {
            initConfig = {};
            if ((baseElem.config != undefined) && (baseElem.config.initInfo != null)) {
              //replace cloned component object to init() HTML
              innerRootInitElem = baseElem.config.initInfo.root.cloneNode(true); //HTML Object when init() function called.
              innerRootElem.parentNode.insertBefore(innerRootInitElem, innerRootElem.nextSibling);
              innerRootElem.parentNode.removeChild(innerRootElem);
              initConfig = copyInitConfig_(baseElem.config.initInfo.config);
            }

            replaceChildId(searchStr, cloneNode, newId);

            addFormArray[i] = {};
            addFormArray[i].type = baseOption[i].type;
            addFormArray[i].id = newId;
            if (addFormArray[i].type !== null) {
              initComponents_(doc, baseOption[i].type, newId, initConfig);
              switch (addFormArray[i].type) {
                case "textboxInteger":
                case "textboxReal":
                  root.initIncDecBtns(doc, newId, initConfig);
                  break;
                default:
                  break;
              }
            }
          }
        }

        if (addFormArray.length > 0) {
          config.rowList[config.numOfRow] = addFormArray;
        }

        if (typeof config.callback === 'function') {
          callBackArg.numOfRow = config.numOfRow;

          if (typeof JSON !== "object") {
            callBackArg.addFormArray = JSON.parse(JSON.stringify(addFormArray));
          } else {
            //can't deep copy
            callBackArg.addFormArray = addFormArray;
          }

          callBackArg.isUserOpe = isUserOpe;
          config.callback(root.id, 'addRow', callBackArg);
        }
      },
      scrollToLastLine: function(scrollObj) {
        var root = this;
        var classStr = 'input-form-list';
        var inputFormListBtns = findDescendant_(root, 'span', classStr + '-btns');
        var inputFormListBtn = null;
        var lastIndex = 0;
        var lastRow = null;

        if (scrollObj == undefined) {
          return;
        }
        /**
         * When elements and buttons overlap,
         *  btns elemnt class has input-form-list-position
         */
        if (hasClass_(inputFormListBtns, classStr + '-position')) {
          lastIndex = root.getRowCount();
          lastRow = root.getSpecifiedRow(lastIndex);
          scrollTo_(scrollObj, lastRow);
        } else {
          inputFormListBtn = findDescendants_(inputFormListBtns, 'button', classStr + '-btn');
          scrollTo_(scrollObj, inputFormListBtn[0]);
        }
      },
      removeRow: function(isUserOpe, execCallback) {
        var root = this;
        var config = root.config;
        var ul = findDescendant_(root, 'ul', 'input-form-list-rows');
        var callBackArg = {};
        var lastRow;

        if (config.numOfRow <= 1) {
          return;
        }
        lastRow = ul.lastChild;
        ul.removeChild(lastRow);
        delete config.rowList[config.numOfRow];
        config.numOfRow = config.numOfRow - 1;

        root.checkAddRemoveBtn();
        if (execCallback && (typeof config.callback === 'function')) {
          callBackArg.numOfRow = config.numOfRow;
          callBackArg.addFormArray = null;
          callBackArg.isUserOpe = isUserOpe;
          config.callback(root.id, 'removeRow', callBackArg);
        }
      },
      removeAllRows: function() {
        var root = this;
        var config = root.config;
        var callBackArg = {};
        while (config.numOfRow > 1) {
          root.removeRow(false, false);
        }
        if (typeof config.callback === 'function') {
          callBackArg.numOfRow = config.numOfRow;
          callBackArg.addFormArray = null;
          callBackArg.isUserOpe = false;
          config.callback(root.id, 'removeAllRows', callBackArg);
        }
      },
      getSpecifiedRow: function(rowIndex) {
        var root = this;
        var ul = findDescendant_(root, 'ul', 'input-form-list-rows');
        var target = null;

        rowIndex = rowIndex - 1;

        for (var i = 0, li = firstElementNode_(ul); li !== null; i++, li = nextElementNode_(li)) {
          if (rowIndex === i) {
            target = li;
            break;
          }
        }
        return target;
      },
      checkAddRemoveBtn: function() {
        var root = this;
        var config = root.config;
        var btnAddElem = config.btnAddElem;
        var btnRemoveElem = config.btnRemoveElem;
        var btnDisabled = config.btnDisabled;
        var removeBtnDisabled = false;
        var addBtnDisabled = false;

        //check min
        if ((config.numOfRow <= 1) || (btnDisabled === true)) {
          removeBtnDisabled = true;
        }
        btnRemoveElem.disabled = removeBtnDisabled;
        turnOnOffClass_(btnRemoveElem, 'disabled', removeBtnDisabled);

        //check max
        if ((config.numOfRow >= config.maxRow) || (btnDisabled === true)) {
          addBtnDisabled = true;
        }
        btnAddElem.disabled = addBtnDisabled;
        turnOnOffClass_(btnAddElem, 'disabled', addBtnDisabled);
      },
      initIncDecBtns: function(doc, newId, initConfig) {
        if ("buttons" in initConfig) {
          //if modified vut, also need to edit js.
          initComponents_(doc, 'button', newId + '.btnDec2', {'spriteleft':'ihmicomponent-btn-dec2','className':'inc-dec-button hide','onclick':'return true;'});
          initComponents_(doc, 'button', newId + '.btnDec', {'spriteleft':'ihmicomponent-btn-dec1', 'className':'inc-dec-button','onclick':'return true;'});
          initComponents_(doc, 'button', newId + '.btnInc', {'spriteleft':'ihmicomponent-btn-inc1', 'className':'inc-dec-button','onclick':'return true;'});
          initComponents_(doc, 'button', newId + '.btnInc2', {'spriteleft':'ihmicomponent-btn-inc2','className':'inc-dec-button hide','onclick':'return true;'});
        }
      },
      setBtnPosition: function() {
        var root = this;
        var classStr = 'input-form-list';
        var liElemArr = findDescendants_(root, 'li', classStr + '-row');
        var lastLiElem = liElemArr[liElemArr.length - 1];
        var liChildren = lastLiElem.children;
        var liWidth = getWidth_(lastLiElem);
        var liLeft = lastLiElem.getBoundingClientRect().left;
        var btnElem = findDescendant_(root, 'span', classStr + '-btns');
        var btnWidth = getWidth_(btnElem);
        var lastChild = liChildren[liChildren.length - 1];
        var lastChildRight = lastChild.getBoundingClientRect().right;
        var restSpace = liWidth - (lastChildRight - liLeft);

        if (liWidth === -1) {
          return;
        }
        if (restSpace < btnWidth) {
          removeClass_(btnElem, classStr + '-position');
        } else {
          addClass_(btnElem, classStr + '-position');
        }
      }
    },
    wizardPage: {//called from ihcpwizardpagefrm.stm
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        //elem.config.appendCbArg setting in appendWizardFrm()
        elem.removeCbArg = null;
        elem.config = config;
        elem.config.pages = null;
        elem.config.currentPageId = null;
        elem.config.currentPageIdKey = 0;
        elem.config.callback = null;
        //elem.config.notifyBeforeUnload = false;
        //wizard page elem
        elem.config.contentsIFrm = doc.getElementById("wizardPageContents");
        elem.config.contentsFrm = elem.config.contentsIFrm.contentWindow;
        elem.config.currentPageLbElem = doc.getElementById("wizardPageCurrentPage");
        elem.config.currentTotalPageLbElem = doc.getElementById("wizardPageTotalPage");
        elem.config.BtnsParentElem = doc.getElementById("wizardPageButtons");
        elem.config.prevBtnElem = doc.getElementById("wizardPagePrevBtn");
        elem.config.nextBtnElem = doc.getElementById("wizardPageNextBtn");
        elem.config.compBtnElem = doc.getElementById("wizardPageCompBtn");
        elem.config.closeBtnElem = doc.getElementById("wizardPageCloseBtn");
        elem.config.validatePage = false;
        //functions
        elem.config.func = type.func;
        elem.refresh = type.refresh;
        elem.setCallback = type.setCallback;
        elem.removeWizardPageFrame = type.removeWizardPageFrame;
        elem.getAppendCallbackArg = type.getAppendCallbackArg;
        elem.getRemoveCallbackArg = type.getRemoveCallbackArg;
        elem.setRemoveCallbackArg = type.setRemoveCallbackArg;
        elem.popupConfirm = type.popupConfirm;
        //set callback
        elem.config.prevBtnElem.setCallback(elem.config.func.onclickBtn);
        elem.config.nextBtnElem.setCallback(elem.config.func.onclickBtn);
        elem.config.compBtnElem.setCallback(elem.config.func.onclickBtn);
        elem.config.closeBtnElem.setCallback(elem.config.func.onclickBtn);

        /*
        var wizardFrmObj = ihmi.cf.getDefaultView(elem.ownerDocument);
        ihmi.cf.addEventHandler(wizardFrmObj, "beforeunload", function () {
          if (elem.config.notifyBeforeUnload){
            return;
          }
          if ((elem.config.callback !== null) &&
              (typeof elem.config.callback === 'function')) {
              elem.config.notifyBeforeUnload = true;
              elem.config.callback('beforeunload', elem.config.pages[elem.config.currentPageIdKey]);
          }
        });
        */
      },
      refresh: function (pages, currentPageId, switchDisableBtns, argObj) {
        var root = this;
        var config = root.config;
        var func = config.func;
        var execRefreshByUser = false;
        if (pages && pages.length > 0) {
          config.pages = pages;
          ihmi.cf.removeClass(root.config.BtnsParentElem, "hide");
        }
        if (typeof currentPageId === "string") {
          config.currentPageIdKey = func.getCurrentPageIdKey(currentPageId, root);
        }
        if (argObj != undefined) {
          if (argObj.validatePage === true) {
            config.validatePage = true;
          } else {
            config.validatePage = false;
          }
          if (argObj.showBarItem != undefined) {
            execRefreshByUser = func.switchShowBarItem(argObj.showBarItem, root);
          }
        }
        func.refreshLabelAndBtn(config.currentPageIdKey, root, execRefreshByUser);
        func.switchDisabledButtons(switchDisableBtns, root);
        func.changePage(root);
      },
      setCallback: function (callback) {
        var root = this;
        var config = root.config;
        config.callback = callback;
      },
      removeWizardPageFrame: function () {
        var root = this;
        var config = root.config;
        var wizardFrmObj = ihmi.cf.getDefaultView(root.ownerDocument);
        var wizardPageDivs = top.IHMIComponents.cf.findDescendants(wizardFrmObj.parent.document, "div", "popup-frame");
        var wizardPageIframe;
        config.func.removeContentsFrame(root);
        if (!wizardPageDivs) {
          return;
        }
        for (var i = 0, len = wizardPageDivs.length; i < len; i++) {
          wizardPageIframe = wizardPageDivs[i].childNodes[0];
          if (wizardPageIframe && (wizardFrmObj === wizardPageIframe.contentWindow)) {
            ihmi.cf.removeFrame(wizardPageIframe);
          }
        }
        config.func.notifyRemoveCallback(root);
      },
      getAppendCallbackArg: function () {
        var root = this;
        if (root.config.appendCbArg) {
          return root.config.appendCbArg;
        }
        return null;
      },
      getRemoveCallbackArg: function () {
        var root = this;
        return root.removeCbArg;
      },
      setRemoveCallbackArg: function (data) {
        var root = this;
        root.removeCbArg = data;
      },
      popupConfirm: function(header, message, callback) {
        var root = this;
        var id = 'wizardPageClosePopup';
        var frameMain = ihmi.cf.getDefaultView(root.ownerDocument);
        var customizeObj = {};
        customizeObj.selectBtn = {
          1 : {label: 'OK'},
          2 : {label: 'ABBRECHEN'}
        };
        var popupBtnCallback = function (id, operation) {
          var isOk = false;
          if (id == 'btn1') {
            isOk = true;
          }
          setTimeout(function () {
            if ((callback !== null) &&
            (typeof callback === 'function')) {
              callback(isOk);
            }
          }, 0);
        };
        ihmi.cf.confirmMessage('ihcpwizardpagefrm', message, id, undefined, null, frameMain, popupBtnCallback, null, customizeObj);
      },
      func: {
        notifyRemoveCallback: function (root) {
          var config = root.config;
          var removeCbArg;
          if (typeof config.removeCallback === 'function') {
            removeCbArg = root.getRemoveCallbackArg();
            //notify remove wizard page frame
            if (removeCbArg !== null) {
              config.removeCallback(removeCbArg);
            } else {
              config.removeCallback();
            }
          }
        },
        removeContentsFrame: function (root) {
          var config = root.config;
          var contentsIframe = config.contentsIFrm;
          var contentsDiv;
          if (!contentsIframe) {
            return;
          }
          contentsDiv = contentsIframe.parentNode;
          if (!contentsDiv) {
            return;
          }
          config.contentsFrm.close();
          contentsIframe.src = "";
          contentsDiv.removeChild(contentsIframe);
        },
        onclickBtn: function (id, operation) {
          var root = this.initInfo.root.ownerDocument.getElementById("wizardPageFrm");
          var config = root.config;
          var func = config.func;
          var wpOperation;
          var allowChangePage = false;

          //conv button id to operation.
          switch (id) {
            case "wizardPagePrevBtn":
              wpOperation = "prev";
              break;
            case "wizardPageNextBtn":
              wpOperation = "next";
              break;
            case "wizardPageCompBtn":
              wpOperation = "comp";
              break;
            case "wizardPageCloseBtn":
              wpOperation = "close";
              break;
            default:
              //error
              return false;
          }

          if (!config.validatePage) {
            changePageByBtn(wpOperation);
          }

          if (typeof config.callback === 'function') {
            allowChangePage = config.callback(wpOperation, config.pages[config.currentPageIdKey]);
          }
          if (config.validatePage && allowChangePage) {
            changePageByBtn(wpOperation);
          }

          function changePageByBtn(wpOperation) {
            var changePageId;
            if (wpOperation === "prev") {
              changePageId = config.currentPageIdKey - 1;
            } else if (wpOperation === "next"){
              changePageId = config.currentPageIdKey + 1;
            } else {//comp, close
              return;
            }
            func.refreshLabelAndBtn(changePageId, root, false);
            func.changePage(root);
          }
        },
        getCurrentPageIdKey: function (targetId, root) {
          var config = root.config;
          var pages = config.pages;
          for (var keys in pages) {
            if (Object.prototype.hasOwnProperty.call(pages, keys)) {
              //console.log(pages[keys]);
              if (targetId === pages[keys]) {
                keys = parseInt(keys, 10);
                return keys;
              } else {
                continue;
              }
            }
          }
          return null;
        },
        changePage: function (root) {
          var config = root.config;
          var pages = config.pages;
          var targetId = pages[config.currentPageIdKey];
          var targetElem;
          var isHide;
          for (var i = 0, len = pages.length; i < len; i++) {
            targetElem = config.contentsFrm.document.getElementById(pages[i]);
            if (targetId === pages[i]) {
              isHide = false;
            } else {
              isHide = true;
            }
            ihmi.cf.turnOnOffClass(targetElem, "hide", isHide);
          }
        },
        refreshLabelAndBtn: function (key, root, execRefreshByUser) {
          var config = root.config;
          var maxKey = config.pages.length - 1;
          var isFirstPage;
          var isLastPage;
          config.currentPageIdKey = key;

          //refresh prev key
          if (key <= 0) {
            //first page
            isFirstPage = true;
            config.currentPageIdKey = 0;
          } else {
            isFirstPage = false;
          }
          ihmi.cf.turnOnOffClass(config.prevBtnElem, "hide", isFirstPage);

          //refresh next key
          if (key >= maxKey) {
            //last page
            config.currentPageIdKey = maxKey;
            isLastPage = true;
          } else {
            isLastPage = false;
          }
          ihmi.cf.turnOnOffClass(config.nextBtnElem, "hide", isLastPage);
          if (!execRefreshByUser || isLastPage) {
            ihmi.cf.turnOnOffClass(config.compBtnElem, "hide", !isLastPage);
          }
          config.currentPageLbElem.refresh((config.currentPageIdKey + 1), false);
          config.currentTotalPageLbElem.refresh((config.pages.length), false);
        },
        switchDisabledButtons: function (switchDisableBtns, root) {
          var config = root.config;
          var isDisable;
          var targetElem;
          if (!switchDisableBtns) {
            return;
          }
          for (var keys in switchDisableBtns) {
            if (Object.prototype.hasOwnProperty.call(switchDisableBtns, keys)) {
              switch (keys) {
                case 'prev' :
                  targetElem = config.prevBtnElem;
                  break;
                case 'next' :
                  targetElem = config.nextBtnElem;
                  break;
                case 'comp' :
                  targetElem = config.compBtnElem;
                  break;
                case 'close' :
                  targetElem = config.closeBtnElem;
                  break;
                default:
                  continue;
              }
              isDisable = switchDisableBtns[keys];
              if ((isDisable === undefined) || (isDisable === null)) {
                continue;
              }
              isDisable = ihmi.cf.parseStrToBoolean(isDisable);
              targetElem.refresh(null,null,null,null,isDisable);
            }
          }
        },
        switchShowBarItem: function (showBarItem, root) {
          var config = root.config;
          var showPageNumber;
          var showCompBtn;
          var execRefreshByUser = false;//true:specify by user / false:not specify by user
          if (!showBarItem) {
            return execRefreshByUser;
          }
          //curent/total page number
          if (showBarItem.pageNumber != undefined) {
            showPageNumber = true;//default: disp
            if (showBarItem.pageNumber === false) {
              showPageNumber = false;
            }
            ihmi.cf.turnOnOffClass(config.currentPageLbElem.parentNode, "hide", !showPageNumber);
          }
          //comp btn
          if (showBarItem.comp != undefined) {
            execRefreshByUser = true;//refresh by user
            showCompBtn = false;//default: hide
            if (showBarItem.comp === true) {
              showCompBtn = true;
            }
            ihmi.cf.turnOnOffClass(config.compBtnElem, "hide", !showCompBtn);
          }
          return execRefreshByUser;
        }
      }
    },
    popupFrm: {//called from ihcppopupfrm.stm
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        //elem.config.appendArg setting in appendPopupFrm()
        elem.removeCbArg = null;
        elem.config = config;
        elem.config.callback = null;
        //popup page elem
        elem.config.contentsIFrm = doc.getElementById("ihcpPopupContents");
        elem.config.contentsFrm = elem.config.contentsIFrm.contentWindow;
        elem.config.closeBtnElem = doc.getElementById("closeBtn");
        //functions
        elem.config.func = type.func;
        elem.setCallback = type.setCallback;
        elem.removePopupFrame = type.removePopupFrame;
        elem.getAppendArg = type.getAppendArg;
        elem.getRemoveCallbackArg = type.getRemoveCallbackArg;
        elem.setRemoveCallbackArg = type.setRemoveCallbackArg;
        elem.refreshFrame = type.refreshFrame;
        //set callback
        elem.config.closeBtnElem.setCallback(elem.config.func.onclickBtn);
      },
      setCallback: function (callback) {
        var root = this;
        var config = root.config;
        config.callback = callback;
      },
      removePopupFrame: function () {
        var root = this;
        var config = root.config;
        var popupFrmObj = ihmi.cf.getDefaultView(root.ownerDocument);
        var popupFrameParentDivs = top.IHMIComponents.cf.findDescendants(popupFrmObj.parent.document, "div", "popup-frame");
        var contentsIframe;
        config.func.removeContentsFrame(root);
        if (!popupFrameParentDivs) {
          return;
        }
        for (var i = 0, len = popupFrameParentDivs.length; i < len; i++) {
          contentsIframe = popupFrameParentDivs[i].childNodes[0];
          if (contentsIframe && (popupFrmObj === contentsIframe.contentWindow)) {
            ihmi.cf.removeFrame(contentsIframe);
          }
        }
        config.func.notifyRemoveCallback(root);
      },
      getAppendArg: function () {
        var root = this;
        if (root.config.appendArg) {
          return root.config.appendArg;
        }
        return null;
      },
      getRemoveCallbackArg: function () {
        var root = this;
        return root.removeCbArg;
      },
      setRemoveCallbackArg: function (data) {
        var root = this;
        root.removeCbArg = data;
      },
      refreshFrame: function (customizeObj) {
        var root = this;
        var config = root.config;
        var popupBoxFrame = ihmi.cf.findDescendant(root.ownerDocument, "div", "popup-box-frame");
        var dividResultWidth;
        var dividResultHeight;
        var isChanged = false;
        var popupContentsArea;
        var headerBox = ihmi.cf.findDescendant(root.ownerDocument, "div", "popup-header-box");

        if (!customizeObj) {
          return;
        }
        if (config.distFramMain == undefined) {
          // #25 loadedFunc() has not been called yet.
          setTimeout(function () {
            if (root != undefined) {
              root.refreshFrame(customizeObj);
            }
          }, 0);
          return;
        }
        if (customizeObj.width) {
          // change width
          dividResultWidth = ihmi.cf.divideNumUnit(customizeObj.width);
          if (dividResultWidth !== null) {
            customizeObj.width = dividResultWidth.num + dividResultWidth.unit;
            config.customizeObj.width = customizeObj.width;
            popupBoxFrame.style.width = customizeObj.width;
            isChanged = true;
          }
        }
        if (customizeObj.contentHeight) {
          // change height
          dividResultHeight = ihmi.cf.divideNumUnit(customizeObj.contentHeight);
          if (dividResultHeight !== null) {
            customizeObj.contentHeight = dividResultHeight.num + dividResultHeight.unit;
            config.customizeObj.contentHeight = customizeObj.contentHeight;
            config.customizeObj.height = null;
            if (ihmi.global.isModernBrowser) {
              popupBoxFrame.style.height = format_("calc((%s + %spx)", customizeObj.contentHeight, headerBox.offsetHeight);
            } else {
              popupBoxFrame.style.height = parseFloat(dividResultHeight.num) + headerBox.offsetHeight + "px";
            }
            isChanged = true;
          }
          if (!ihmi.global.isModernBrowser) {
            //can't used calc() .popup-contents-area
            popupContentsArea = ihmi.cf.findDescendant(root.ownerDocument, "div", "popup-contents-area");
            popupContentsArea.style.height = parseFloat(popupBoxFrame.offsetHeight) - headerBox.offsetHeight + "px";
          }
        }

        if ((customizeObj.hideBox != undefined) && (customizeObj.hideBox === false)) {
          isChanged = true;
        }

        if (isChanged) {
          // adjust popup contents position
          try {
            ihmi.cf.adjustBoxPos(config.distFramMain,
                                        config.popupFrameMain,
                                        config.popupIframe,
                                        config.customizeObj,
                                        "refreshFrame");
            ihmi.cf.adjustPopupHeader(config.popupFrameMain, config.customizeObj);
          } catch (e) {
            return; // Cross-domain errors
          }
        }
        if (customizeObj.hideBox != undefined) {
          turnOnOffClass_(popupBoxFrame, "ihcp-vis-hidden", customizeObj.hideBox);
        }
      },
      func: {
        notifyRemoveCallback: function (root) {
          var config = root.config;
          var removeCbArg;
          if (typeof config.removeCallback === 'function') {
            removeCbArg = root.getRemoveCallbackArg();
            //notify remove popup frame
            if (removeCbArg !== null) {
              config.removeCallback(removeCbArg);
            } else {
              config.removeCallback();
            }
          }
        },
        removeContentsFrame: function (root) {
          var config = root.config;
          var contentsIframe = config.contentsIFrm;
          var contentsDiv;
          if (!contentsIframe) {
            return;
          }
          contentsDiv = contentsIframe.parentNode;
          if (!contentsDiv) {
            return;
          }
          config.contentsFrm.close();
          contentsIframe.src = "";
          contentsDiv.removeChild(contentsIframe);
        },
        onclickBtn: function (id, operation) {
          var root = this.initInfo.root.ownerDocument.getElementById("ihcpPopupFrm");
          var config = root.config;

          if (typeof config.callback === 'function') {
            config.callback("close");
          } else {
            root.removePopupFrame();
          }
        }
      }
    },
    requiredMark: {
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        elem.setRequiredMark = type.setRequiredMark;
        elem.markElem = doc.getElementById(id + ".requiredMark");
      },
      setRequiredMark: function(show, adjustPos, disabled)  {
        var root = this;
        if (disabled != undefined) {
          ihmi.cf.turnOnOffClass(root.markElem, 'disabled', disabled);
        }
        if (adjustPos != undefined) {
          ihmi.cf.createRequiredMark(root, adjustPos, null, null);
        }
        ihmi.cf.setRequiredMark(root, show);
      }
    },
    toggleSwitch: {
      init: function (doc, id, config) {
        var elem = doc.getElementById(id),
            btnElm = doc.getElementById(id + ".btnon"),
            frame = getDefaultView_(doc),
            btnLabelElem = elem.querySelector('label'),
            onStringElem = doc.getElementById(id + ".stringon"),
            offStringElem= doc.getElementById(id + ".stringoff"),
            type = this;
        elem.refresh = type.refresh;
        elem.config = config;
        elem.config.callback = null;
        if (config.page === undefined) {
          config.page = frame.webpage;
        }
        elem.setCallback = type.setCallback;
        elem.setRequiredMark = type.setRequiredMark;
        elem.expandWidth = type.expandWidth;
        elem.getValue = type.getValue;
        elem.setRequiredMark(false, null);
        btnLabelElem.setAttribute('tabindex', '0');
        addEventHandler_(btnLabelElem, "keypress", type.onkeypress);
        addEventHandler_(btnElm, "click", type.onclick);
        if ((onStringElem !== null) && (onStringElem.textContent === "")) {
          onStringElem.textContent = "ON";
        }
        if ((offStringElem !== null) && (offStringElem.textContent === "")) {
          offStringElem.textContent = "OFF";
        }
        if (!config.width) elem.expandWidth();
      },
      refresh: function (checked, disabled, argObj) {
        var elem = this,
            doc = elem.ownerDocument,
            toggleBtn = doc.getElementById(elem.id + ".switchicon"),
            btnOn = doc.getElementById(elem.id + ".btnon"),
            btnLabelElem = elem.querySelector('label'),
            stringOn = doc.getElementById(elem.id + ".stringon"),
            stringOff = doc.getElementById(elem.id + ".stringoff"),
            imgOn = doc.getElementById(elem.id + ".imgon"),
            imgOff = doc.getElementById(elem.id + ".imgoff");
        var classEnabled = "ihmicomponent-toggleswitch-enabled";
        var classDisabled = "ihmicomponent-toggleswitch-disabled";
        if (disabled != null) {
          disabled = parseStrToBoolean_(disabled);
          elem.disabled = disabled;
          btnOn.disabled = disabled;
          disabled ? replaceClass_(toggleBtn, classEnabled, classDisabled)
                   : replaceClass_(toggleBtn, classDisabled, classEnabled);
          disabled ? btnLabelElem.removeAttribute("tabindex") : btnLabelElem.setAttribute('tabindex', '0');
        }
        if (checked != null) {
          checked = parseStrToBoolean_(checked);
          btnOn.checked = checked;
        }
        if (argObj != null) {
          if (argObj.onString != null) {
            stringOn.innerText = argObj.onString;
          }
          if (argObj.offString != null) {
            stringOff.innerText = argObj.offString;
          }

          if ((argObj.onImg != null) && (imgOn != null)) {
            imgOn.src = argObj.onImg;
          }
          if ((argObj.offImg != null) && (imgOff != null)) {
            imgOff.src = argObj.offImg;
          }
        }
        if (!elem.config.width) elem.expandWidth();
      },
      onclick: function (event) {
        var elem = event.srcElement,
            root = elem.parentNode,
            frame = getDefaultView_(root.ownerDocument),
            config = root.config;
        if (typeof config.callback === 'function') {
          config.callback(root.id, "clicked", elem.checked);
        } else {
          IUIFRequest_(frame, {
            webpage: config.page,
            request: root.id + ".clicked",
            value: elem.checked
          }).send();
        }
      },
      setCallback: function (callback) {
        var root = this;
        var config = root.config;
        config.callback = callback;
      },
      setRequiredMark: function(show, adjustPos)  {
        var root = this;
        createRequiredMark_(root, adjustPos, false, null);
        setRequiredMark_(root, show);
      },
      expandWidth: function() {
        var onWidth;
        var offWidth;
        var elem = this;
        var doc = elem.ownerDocument;
        var isDisplayNone = window.getComputedStyle(elem).getPropertyValue('display') == 'none';
        var onStringElem = doc.getElementById(elem.id + ".stringon");
        var offStringElem= doc.getElementById(elem.id + ".stringoff");
        if (isDisplayNone) {
          onWidth = getHiddenTextWidth(elem, 'on');
          offWidth = getHiddenTextWidth(elem, 'off');
        } else {
          onWidth = getWidth_(onStringElem);
          offWidth = getWidth_(offStringElem);
        }
        if (onWidth === -1) {
          return;
        }
        var longWidth = onWidth < offWidth ? offWidth : onWidth;
        setWidth(longWidth);
        function setWidth(targetWidth) {
          var ELEM_WIDTH = 110;
          var toggleBtn = doc.getElementById(elem.id + ".switchicon");
          var btnWidth = getWidth_(toggleBtn);
          var borderRadius = parseFloat(getCurrentStyle_(elem).borderRadius);
          var tempWidth = targetWidth + btnWidth + borderRadius;

          if (ELEM_WIDTH < tempWidth) ELEM_WIDTH = tempWidth;
          elem.style.width = ELEM_WIDTH + 'px';
        }
        function getHiddenTextWidth(target, textType) {
          var textElem;
          var labelWidth;
          var bodyElem = target.ownerDocument.body;
          var clonedElement = target.cloneNode(true);
          clonedElement.style.position = 'absolute';
          clonedElement.style.visibility = 'hidden';
          clonedElement.style.top = '0px';
          clonedElement.style.setProperty('display', 'block', 'important');
          bodyElem.appendChild(clonedElement);
          if (textType === 'on') {
            textElem = querySelector_(clonedElement, '.ihcp-toggle-switch-on');
            labelWidth = getWidth_(textElem);
          } else {
            textElem = querySelector_(clonedElement, '.ihcp-toggle-switch-off');
            labelWidth = getWidth_(textElem);
          }
          bodyElem.removeChild(clonedElement);
          return labelWidth;
        }
      },
      onkeypress: function(event) {
        var elem = event.srcElement;
        var doc = elem.ownerDocument;
        var PrntElem = elem.parentElement;
        var btnOn = doc.getElementById(PrntElem.id + ".btnon");
        if (event.keyCode === 13) { // enter
          btnOn.click();
        }
      },
      getValue: function() {
        var root = this;
        var doc = root.ownerDocument;
        var isChecked = false;
        var input = doc.getElementById(root.id + ".btnon");
        isChecked = (input !== null) ? input.checked : false;
        return isChecked;
      }
    },
    slideButton: {
      // A button that turns on only while sliding.
      init: function(doc, id, config) {
        var elem = doc.getElementById(id);
        var type = this;
        var frameWin = ihmi.cf.getDefaultView(doc);

        elem.config = config;
        elem.config.frameWin = frameWin;
        elem.config.callback = null;
        elem.config.cbArgs = {}; // Callback argument.
        elem.config.prevBtnClass = null; // expanded button class.
        elem.config.prevBarClass = null; // expanded bar class.
        elem.config.prevLabelClass = null; // expanded label class.
        if (config.page === undefined) {
          elem.config.page = frameWin.webpage;
        }
        elem.config.defaultBtnHeight = 40;
        // Initialize of each flags and objects.
        elem.config.slideStart = false; // Button on(true)/off(false)
        elem.config.slideOn = false; // Slide on(true)/off(false)
        elem.config.slideDirection = 'off'; // Button direction : 'left'/'off'/'right'.
        elem.config.slideThumbRect = {}; // Thumb(Knob) rectangle data.
        // Initialization of the elements that make up the button.
        elem.elemSlideBox = doc.getElementById(id);
        elem.elemSlideBtn = doc.getElementById(id + '.slidebtn');
        elem.elemSlideBar = doc.getElementById(id + '.slidebar');
        elem.elemSlideLbl = doc.getElementById(id + '.slidelbl');

        // Slide button adjust data table
        elem.config.slideBtnPos = {sensingRange: 10, rangeMargin: 10};

        // Register Functions
        elem.config.func = type.func;
        elem.refresh = type.refresh;
        elem.setCallback = type.setCallback;
        elem.onMoveSlide = type.onMoveSlide;
        elem.onEndSlide = type.onEndSlide;

        // Register Event Handler.
        if (ihmi.global.isModernBrowser) {
          ihmi.cf.addEventHandler(elem.elemSlideBtn, 'touchstart', type.onStartSlide);
          ihmi.cf.addEventHandler(elem.elemSlideBtn, 'mousedown', type.onStartSlide);
        }
      },
      refresh: function(disabled, argObj) {
        var root = this;
        var config = root.config;
        var doc = root.ownerDocument;

        disabled = (disabled === undefined) ? null: disabled;
        // Setting arguments
        config.btnPattern = getOptionValue(config.btnPattern, argObj, 'btnPattern', 'left');
        config.labelText = getOptionValue(config.labelText, argObj, 'labelText', '');
        // Get default style with slide button / bar class
        var slideBtnThumb = ihmi.cf.findDescendant(root, 'div', 'ihcp-slidebutton-thumb');
        var slideBtnBar = ihmi.cf.findDescendant(root, 'div', 'ihcp-slidebutton-bar');

        // Set refresh style to element
        if (root.elemSlideBtn !== null) { // Element is exist
          if (disabled !== null) { // Other than null and undefined.
            if (disabled) {
              ihmi.cf.addClass(root.elemSlideBtn, 'ihcp-slidebutton-disabled');
              ihmi.cf.addClass(root.elemSlideBar, 'ihcp-slidebutton-disabled');
              ihmi.cf.addClass(root.elemSlideLbl, 'ihcp-slidebutton-textdsbl');
            } else {
              ihmi.cf.removeClass(root.elemSlideBtn, 'ihcp-slidebutton-disabled');
              ihmi.cf.removeClass(root.elemSlideBar, 'ihcp-slidebutton-disabled');
              ihmi.cf.removeClass(root.elemSlideLbl, 'ihcp-slidebutton-textdsbl');
            }
          }
        }
        //var slideBtnBody = doc.getElementById(root.id + '.slidebtn');
        ihmi.cf.addClass(slideBtnThumb, 'ihcp-slidebutton-' + config.btnPattern);
        ihmi.cf.addClass(slideBtnBar, 'ihcp-slidebutton-bar' + config.btnPattern);
        slideBtnThumb.style.height = config.buttonHeight;
        if (argObj.btnClass != null) {
          // 1st, remove previous class
          if (config.prevBtnClass != null) {
            ihmi.cf.removeClasses(slideBtnThumb, config.prevBtnClass);
          }
          // 2nd, add specified class
          ihmi.cf.addClasses(slideBtnThumb, argObj.btnClass);
          config.prevBtnClass = argObj.btnClass;
        }
        // save button color
        config.buttonColor = ihmi.cf.getCurrentStyle(slideBtnThumb).backgroundColor;
        if (argObj.barClass != null) {
          if (config.prevBarClass != null) {
            ihmi.cf.removeClasses(slideBtnBar, config.prevBarClass);
          }
          ihmi.cf.addClasses(slideBtnBar, argObj.barClass);
          config.prevBarClass = argObj.barClass;
        }
        var slideBtnLbl = doc.getElementById(root.id + '.slidelbl');
        if (argObj.labelClass != null) {
          if (config.prevLabelClass != null) {
            ihmi.cf.removeClasses(slideBtnLbl, config.prevLabelClass);
          }
          ihmi.cf.addClasses(slideBtnLbl, argObj.labelClass);
          config.prevLabelClass = argObj.labelClass;
        }
        // Check if the button height is customized.
        if (slideBtnThumb.clientHeight > config.defaultBtnHeight) { // default button height
          // Adjust the top of the label.
          var slideTextElem = doc.getElementById(root.id + '.slidetxt');
          slideTextElem.style.top = slideBtnThumb.offsetTop + slideBtnThumb.offsetHeight + 'px';
        }

        if ((disabled != null) && (!disabled)) { // Specified enable.
          slideBtnThumb.style.backgroundColor = config.buttonColor;
          slideBtnBar.style.backgroundColor = config.btnbarColor;
          slideBtnLbl.style.color = config.btntxtColor;
        }
        slideBtnLbl.innerHTML = config.labelText;

        // Get the value set in the template or refresh argument.
        function getOptionValue(currentValue, argObj, param, defaultVal) {
          // If specified in config, uses config as the default.
          return getArgOption(argObj, param, (currentValue != undefined) ? currentValue : defaultVal);
        }
        // Get the value set in the refresh argument.
        function getArgOption(argObj, param, defaultVal) {
          // get Argument option from argObj.
          return ((argObj != null) && (argObj[param] != undefined)) ? argObj[param] : defaultVal;
        }
      },
      setCallback: function(callback, cbArgs) {
        var root = this;
        root.config.callback = callback;
        root.config.cbArgs = cbArgs;
      },
      onStartSlide: function(event) { // Call when button click / tap.
        var clickedElem = event.srcElement;
        var root = clickedElem.parentNode;
        var doc = root.ownerDocument;
        var config = root.config;
        var touchList = [];
        event.preventDefault();
        // If event is touchstart and slide button is disable, ignore event.
        // Check regardless of device.
        if (ihmi.cf.hasClass(root.elemSlideBtn, 'ihcp-slidebutton-disabled')) {
          return false;
        }
        // For Windows Tablet, mouse pointer hide during touch event.
        if (event.type.indexOf('touch') === 0) {
          touchList = event.touches;
          if (touchList.length > 1) return false;
        }
        stopEventBubble_(event);
        config.slideStart = true; // onClick / onTapStart
        // Get current button(thumb/knob) position / size.
        var startThumbRect = {};
        var elemRect = clickedElem.getBoundingClientRect();
        startThumbRect.left = elemRect.left;
        startThumbRect.top = elemRect.top;
        startThumbRect.right = elemRect.right;
        startThumbRect.bottom = elemRect.bottom;
        startThumbRect.x = elemRect.X;
        startThumbRect.y = elemRect.y;
        startThumbRect.width = elemRect.width;
        startThumbRect.clientX = config.func.isEventMouse(event.type) ? event.clientX: event.touches[0].clientX;
        startThumbRect.clientY = config.func.isEventMouse(event.type) ? event.clientY: event.touches[0].clientY; // for future
        config.slideThumbRect = startThumbRect; // save to config
        if (event.type.indexOf('touch') === 0) {
          ihmi.cf.addEventHandler(clickedElem, 'touchmove', root.onMoveSlide);
          ihmi.cf.addEventHandler(doc, 'touchcancel', root.onEndSlide);
          ihmi.cf.addEventHandler(doc, 'touchend', root.onEndSlide);
        } else {
          /**
           * [#15565] When using ie,
           *           if the event registration target is a document,
           *           it can be operated off-screen.
           */
          ihmi.cf.addEventHandler(doc.body, 'mousemove', root.onMoveSlide);
          ihmi.cf.addEventHandler(doc.body, 'mouseup', root.onEndSlide);
          ihmi.cf.addEventHandler(doc.body, 'mouseleave', root.onEndSlide);
        }
        return false;
      },
      onMoveSlide: function(event) {
        var slideBtnFunc = ihmi.slideButton.func;
        var eventTarget = event.currentTarget;
        var doc = (eventTarget.ownerDocument != null) ? eventTarget.ownerDocument : eventTarget;
        var root = slideBtnFunc.findRootElem(doc);
        var xPoint = 0;
        var yPoint = 0;
        var curElem = null;
        var slideElem = null;
        event.preventDefault();
        event.stopPropagation(); // just in case
        slideElem = root.elemSlideBtn; // reset target element
        if (slideElem == null) {
          return false; // check for safety...
        }
        /**
         * [#15565] Remove in the move event
         *           because the end event does not occur outside the viewport
         *           when a touch operation is performed
         */
        if (event.type === 'touchmove') {
          xPoint = event.touches[0].clientX;
          yPoint = event.touches[0].clientY;
          curElem = doc.elementFromPoint(xPoint, yPoint);
          if (curElem === null) {
            root.onEndSlide(event);
            return false;
          }
        }
        var config = root.config;
        var func = config.func;
        // Cansel text selection when button slide.
        var seltext = doc.getSelection();
        if (seltext.toString().length > 0) {
          seltext.removeAllRanges();
        }
        // Check moved range.
        var crntThumbPos = {clientX: 0, clientY: 0};
        crntThumbPos.clientX = func.isEventMouse(event.type) ? event.clientX: event.touches[0].clientX;
        crntThumbPos.clientY = func.isEventMouse(event.type) ? event.clientY: event.touches[0].clientY; // for future.
        var movedRect = slideElem.getBoundingClientRect(); // Get button rectangle.
        var btnLeft = config.slideBtnPos.rangeMargin;
        var btnSlideWidth = movedRect.width / 2 - 1; // Calculate Slide amount. (Half button width - border.)
        if (!config.slideOn) { // Slide button not active?
          // Did it exceed the threshold?
          if (config.btnPattern == 'left') {
            if (crntThumbPos.clientX >= (config.slideThumbRect.right - 3)) {
              // move out from button right side-3. (3 is detection range)
              slideElem.style.left = (btnLeft + btnSlideWidth) + 'px'; // Slide the button.
              config.slideDirection = 'right';
              config.slideOn = true;
            }
          } else if (config.btnPattern == 'center') {
            if (crntThumbPos.clientX >= (config.slideThumbRect.right - 3)) {
              // move out from button right side-3. (3 is Detection range)
              slideElem.style.left = (btnLeft + (btnSlideWidth * 2) + 2) + 'px';
              config.slideDirection = 'right';
              config.slideOn = true;
            } else if (crntThumbPos.clientX < (config.slideThumbRect.left + 3)) {
              // move out from button left side+3. (3 is detechtion range)
              slideElem.style.left = btnLeft + 'px'; // left margin.
              config.slideDirection = 'left';
              config.slideOn = true;
            }
          } else if (config.btnPattern == 'right') {
            if (crntThumbPos.clientX < (config.slideThumbRect.left + 3)) {
              // move out from button left side+3. (3 is detechtion range)
              slideElem.style.left = btnLeft + 'px'; // Slide the button.
              config.slideDirection = 'left';
              config.slideOn = true;
            }
          }
          if (config.slideOn) {
            slideElem.style.backgroundColor = ihmi.global.colorTable.blue01; // button color is ON
            config.func.callCallback(root);
          }
        } else { // When Slide ON.
          // In the case of the central pattern,
          //  when passing through the central area from left to right or right to left.
          if (config.btnPattern == 'center') {
            if (((config.slideDirection == 'left') && (crntThumbPos.clientX >= (movedRect.right- 1))) ||
                ((config.slideDirection == 'right') && (crntThumbPos.clientX <= (movedRect.left + 1)))) {
              func.setSlideOff(root, slideElem); // Slide off process.
            }
          }
        }
        return false;
      },
      onEndSlide: function(event) { // mouse off / tap off / move out from doc
        var slideBtnFunc = ihmi.slideButton.func;
        var eventTarget = event.currentTarget;
        var doc = (eventTarget.ownerDocument != null) ? eventTarget.ownerDocument : eventTarget;
        var root = slideBtnFunc.findRootElem(doc);
        var slideBtnElem = doc.getElementById(root.id + '.slidebtn');
        if (event.type.indexOf('touch') === 0) {
          ihmi.cf.removeEventHandler(slideBtnElem, 'touchmove', root.onMoveSlide);
          ihmi.cf.removeEventHandler(doc, 'touchcancel', root.onEndSlide);
          ihmi.cf.removeEventHandler(doc, 'touchend', root.onEndSlide);
        } else {
          ihmi.cf.removeEventHandler(doc.body, 'mousemove', root.onMoveSlide);
          ihmi.cf.removeEventHandler(doc.body, 'mouseleave', root.onEndSlide);
          ihmi.cf.removeEventHandler(doc.body, 'mouseup', root.onEndSlide);
        }
        var config = root.config;
        event.stopPropagation(); // just in case
        config.func.setSlideOff(root, slideBtnElem); // Slide off process.
        event.preventDefault();
        config.slideStart = false; // Slide finish.
        return false;
      },
      func: {
        setSlideOff: function(root, btnElem) {
          var config = root.config;
          // Slide off process.
          var movedRect = btnElem.getBoundingClientRect();
          var btnLeft = config.slideBtnPos.rangeMargin;
          var sensingWidth = (movedRect.width / 2) - 1; // Calculate Slide amount. (Half button width - border.)
          btnElem.style.left = (config.btnPattern == 'left') ?
              btnLeft + 'px' : (btnLeft + sensingWidth) + 'px'; // Slide-button back to origin position.
          btnElem.style.backgroundColor = config.buttonColor; // Button color back to initial.
          config.slideOn = false; // Slide off.
          config.slideDirection = 'off';
          config.func.callCallback(root);
        },
        callCallback: function(root) {
          var conf = root.config;
          if ((conf.callback !== null) && (typeof conf.callback === 'function')) {
            // Call callback function.
            conf.callback(root.id, conf.slideDirection, conf.cbArgs);
          } else {
            ihmi.cf.IUIFRequest(conf.frameWin, { webpage: conf.page, request: root.id, operation: conf.slideDirection }).send();
          }
        },
        isEventMouse: function(eventType) {
          var eventResult = (!eventType.startsWith) ?
            (eventType.substr(0, 'mouse'.length) === 'mouse'): // for IE
            eventType.startsWith('mouse');
          return eventResult;
        },
        findRootElem: function(ownerDoc) {
          var btns = ihmi.cf.findDescendants(ownerDoc, 'div', 'ihcp-slidebutton-box');
          var root = null;
          for (var i = 0; i < btns.length; i++) {
            var tgtConf = btns[i].config;
            if ((tgtConf != null) && tgtConf.slideStart) { // detected slide on/start button.
              root = btns[i];
              break;
            }
          }
          return root;
        }
      }
    },
    handleResize: {
      init: function(doc, id, config) {
        var type = this;
        var root = doc.getElementById(id);
        var frame = getDefaultView_(doc);

        var cssMinProperty = 'min';
        var firstMinSize = parseFloat(config.firstMinSize);
        var secondMinSize = parseFloat(config.secondMinSize);
        var barElem = doc.getElementById(id + '.bar');
        var firstArea = doc.getElementById(id + '.first');
        var secondArea = doc.getElementById(id + '.second');
        var firstElem = doc.getElementById(config.firstElemID);
        var secondElem = doc.getElementById(config.secondElemID);
        var firstHide = doc.getElementById(root.id + '.firstHide');
        var secondHide = doc.getElementById(root.id + '.secondHide');
        var firstHideStyle = firstHide.style;
        var secondHideStyle = secondHide.style;

        config.BAR_SIZE = 12;
        config.elem = {};
        config.elem.barElem = barElem;
        config.elem.firstArea = firstArea;
        config.elem.secondArea = secondArea;
        config.elem.firstHide = firstHide;
        config.elem.secondHide = secondHide;
        /** user-specified elements */
        config.elem.firstElem = firstElem;
        config.elem.secondElem = secondElem;

        config.classDef = {};
        config.classDef.main = 'ihcp-handle';
        config.classDef.bar = config.classDef.main + '-bar';
        config.classDef.handleType = config.classDef.main + '-' + config.handleType;
        config.classDef.barType = config.classDef.bar + '-' + config.handleType;
        if (config.handleType === 'vertical') {
          config.cssProperty = 'width';
          config.firstSuffix = 'left';
          config.secondSuffix = 'right';
        } else {
          config.handleType = 'horizon';
          config.cssProperty = 'height';
          config.firstSuffix = 'top';
          config.secondSuffix = 'bottom';
        }
        cssMinProperty += '-' + config.cssProperty;
        config.cssMinProperty = cssMinProperty;
        config.classDef.handleFirst = 'ihcp-handle-bar-' + config.firstSuffix;
        config.classDef.secondFirst = 'ihcp-handle-bar-' + config.secondSuffix;

        barElem.classList.add(config.classDef.barType);
        root.classList.add(config.classDef.handleType);

        if (isNaN(firstMinSize)) {
          firstMinSize = 0;
        }
        if (isNaN(secondMinSize)) {
          secondMinSize = 0;
        }

        config.resizebarBorderSize = config.handleType === 'vertical' ? barElem.clientLeft : barElem.clientTop;
        config.firstMinSize = firstMinSize;
        config.secondMinSize = secondMinSize;
        config.isFirstHide = parseStrToBoolean_(config.isFirstHide);
        config.isSecondHide = parseStrToBoolean_(config.isSecondHide);
        config.firstAreaSize = 50;
        config.isReductFirstElem = false;
        config.isReductSecondElem = false;

        firstHide.classList.add(config.classDef.main + '-hide-' + config.firstSuffix);
        // The parent element is shifted by the border size, so add
        firstHideStyle.setProperty(config.firstSuffix, - (config.firstMinSize + config.resizebarBorderSize) + 'px');
        // Since there may be a gap, add an extra border size to the firstHide and set the height of the firstHide.
        firstHideStyle.setProperty(config.cssProperty, (config.firstMinSize + config.resizebarBorderSize) + 'px');
        secondHide.classList.add(config.classDef.main + '-hide-' + config.secondSuffix);
        // The parent element is shifted by the border size, so add
        secondHideStyle.setProperty(config.firstSuffix, config.BAR_SIZE - config.resizebarBorderSize + 'px');
        secondHideStyle.setProperty(config.cssProperty, config.secondMinSize + 'px');

        if (config.addShadow === 'first') {
          barElem.classList.add(config.classDef.handleFirst);
        } else if (config.addShadow === 'second') {
          barElem.classList.add(config.classDef.secondFirst);
        }

        firstArea.style[cssMinProperty] = firstMinSize + 'px';
        secondArea.style[cssMinProperty] = secondMinSize + 'px';
        root.style[cssMinProperty] = (firstMinSize + config.BAR_SIZE + secondMinSize) + 'px';

        firstArea.style[config.cssProperty] = format_("calc((100% - %spx) / 2)", config.BAR_SIZE);
        secondArea.style[config.cssProperty] = format_("calc((100% - %spx) / 2)", config.BAR_SIZE);

        firstArea.appendChild(firstElem);
        secondArea.appendChild(secondElem);

        root.refresh = type.refresh;
        root.switchRestrict = type.switchRestrict;
        root.getSize = type.getSize;
        root.config = config;
        addEventHandler_(barElem, 'touchstart', type.onMoveStart);
        addEventHandler_(barElem, 'mousedown', type.onMoveStart);
        addEventHandler_(frame, 'load', adjustSize);
        addEventHandler_(frame, 'resize', adjustSize);

        function adjustSize(event) {
          root.switchRestrict(event);
        }
      },
      /**
       * @param {Object} setOption
       * @param {Integer} setOption.height
       * @param {Boolean} setOption.extraHeight
       * @param {Integer} setOption.firstAreaSize
       * @returns
       */
      refresh: function(setOption) {
        var root = this;
        var config = root.config;

        var rootSize = 0;
        var optHeight = 0;
        var isExtraHeight = false;
        var firstAreaSize = 0;
        var barSize = 0;
        var firstOpt = null;
        var secondOpt = null;
        var DEFAULT_SIZE = 50;

        if (config.handleType === 'vertical') {
          rootSize = getWidth_(root);
          barSize = getWidth_(config.elem.barElem);
        } else {
          rootSize = getHeight_(root);
          barSize = getHeight_(config.elem.barElem);
        }

        if (setOption == null) {
          return;
        }
        firstOpt = setOption.first;
        secondOpt = setOption.second;

        switch (setOption.extraHeight) {
          case null:
          case undefined:
          case '':
            setOption.extraHeight = config.isExtraHeight;
            break;
          default:
            break;
        }
        isExtraHeight = parseStrToBoolean_(setOption.extraHeight);
        config.isExtraHeight = isExtraHeight;

        optHeight = parseFloat(setOption.height);

        if (!isNaN(optHeight)) {
          setRootHeight(root, config);
        }

        firstAreaSize = parseFloat(setOption.firstAreaSize);
        if (!isNaN(firstAreaSize)) {
          if ((setOption.firstAreaSize.toString().indexOf('px') !== -1) &&
              (firstAreaSize < (rootSize - barSize))) {
            firstAreaSize = (firstAreaSize <= (rootSize - barSize))
              ? ((firstAreaSize / (rootSize - barSize)) * 100)
              : DEFAULT_SIZE;
          }
          if ((firstAreaSize < 0) || (100 < firstAreaSize)) {
            firstAreaSize = DEFAULT_SIZE;
          }
          setElemSize(config);
          config.firstAreaSize = firstAreaSize;
        }
        setMinInfo(config, 'first', firstOpt);
        setMinInfo(config, 'second', secondOpt);
        root.style[config.cssMinProperty] = (config.firstMinSize + barSize + config.secondMinSize) + 'px';
        root.switchRestrict();

        function setRootHeight(root, config) {
          if (optHeight < 0) {
            return;
          }
          root.style.height = isExtraHeight
            ? format_("calc(100% - %spx)", optHeight)
            : optHeight + 'px';
          config.optHeight = optHeight;
        }

        function setElemSize(config) {
          var firstArea = config.elem.firstArea;
          var secondArea = config.elem.secondArea;
          var cssProp = '';
          var firstFormula = '((100% - %spx) * %s)';
          var secondFormula = '(100% - ' + firstFormula + ' - %spx)';
          var firstAreaScale = (firstAreaSize / 100);
          cssProp = (config.handleType === "vertical") ? 'width' : 'height';

          firstArea.style[cssProp] = format_("calc" + firstFormula,
                                              barSize, firstAreaScale);
          secondArea.style[cssProp] = format_("calc" + secondFormula,
                                              barSize, firstAreaScale, barSize);
        }
        function setMinInfo(config, type, optObj) {
          var minSize = 0;
          var elemArea = null;
          var elemHide = null;
          if ((optObj != null) &&
              (optObj !== '')) {
            minSize = parseFloat(optObj.minSize);
            if (!isNaN(minSize)) {
              switch (type) {
                case 'first':
                  elemArea = config.elem.firstArea;
                  elemHide = config.elem.firstHide;
                  config.firstMinSize = minSize;
                  // The parent element is shifted by the border size, so add
                  elemHide.style.setProperty(config.firstSuffix, - (minSize + config.resizebarBorderSize) + 'px');
                  // Since there may be a gap, add an extra border size to the firstHide and set the height of the firstHide.
                  elemHide.style.setProperty(config.cssProperty, (minSize + config.resizebarBorderSize) + 'px');
                  break;
                case 'second':
                  elemArea = config.elem.secondArea;
                  elemHide = config.elem.secondHide;
                  config.secondMinSize = minSize;
                  // The parent element is shifted by the border size, so add
                  elemHide.style.setProperty(config.firstSuffix, config.BAR_SIZE - config.resizebarBorderSize + 'px');
                  elemHide.style.setProperty(config.cssProperty, minSize + 'px');
                  break;
                default:
                  break;
              }
              elemArea.style[config.cssMinProperty] = minSize + 'px';
            }
            if ((optObj.hide != null) &&
                (optObj.hide !== '')) {
              switch (type) {
                case 'first':
                  config.isFirstHide = Boolean(optObj.hide);
                  break;
                case 'second':
                  config.isSecondHide = Boolean(optObj.hide);
                  break;
                default:
                  break;
              }
            }
          }
        }
      },
      onMoveStart: function(event) {
        var elem = this;
        var root = findAncestor_(elem, 'div', 'ihcp-handle');
        var config = root.config;
        var doc = root.ownerDocument;
        var frame = getDefaultView_(doc);
        var firstArea = config.elem.firstArea;
        var secondArea = config.elem.secondArea;
        var barElem = config.elem.barElem;

        var barSize = 0;
        var draggingClass = config.classDef.bar + '-dragging';
        var cursorClass = '';
        var rootRect = root.getBoundingClientRect();
        var rootEdge = 0;
        var i = 0;
        preventBrowserDefault_(event);
        stopEventBubble_(event);

        if (config.handleType === 'vertical') {
          barSize = getWidth_(barElem);
          cursorClass = config.classDef.bar + '-vertical-dragging';
          rootEdge = rootRect['left'];
        } else {
          barSize = getHeight_(barElem);
          cursorClass = config.classDef.bar + '-horizon-dragging';
          rootEdge = rootRect['top'];
        }

        createCustomEvent_(root, 'ihcp-hr-start', {
          event: event
        });

        if (event.type.indexOf('touch') !== -1) {
          addEventHandler_(root, 'touchmove', onMoving);
          addEventHandler_(root, 'touchend', onMoveEnd);
          addEventHandler_(root, 'touchcancel', onMoveEnd);
        } else {
          elem.classList.add(draggingClass);
          firstArea.classList.add(draggingClass);
          secondArea.classList.add(draggingClass);
          root.classList.add(cursorClass);
          addEventHandler_(frame, 'mousemove', onMoving);
          addEventHandler_(frame, 'mouseup', onMoveEnd);
          addEventHandler_(root, 'mouseleave', onMouseLeave);
          addEventHandler_(window, 'mouseup', onMoveEnd);
          addEventHandler_(frame, 'pagehide', onMoveEnd);
          for (i = 0; i < window.length; i++) {
            addEventHandler_(window[i], 'mouseup', onMoveEnd);
          }
        }
        function onMoving(event) {
          var rootSize = 0;
          var firstElemArea = 0;
          var secondElemArea = 0;

          var curPosition = 0;
          var percent = 0;
          preventBrowserDefault_(event);
          stopEventBubble_(event);

          if (config.handleType === 'vertical') {
            rootSize = getWidth_(root);
            firstElemArea = getWidth_(firstArea);
            secondElemArea = getWidth_(secondArea);
            curPosition = getClientX_(event);
          } else {
            rootSize = getHeight_(root);
            firstElemArea = getHeight_(firstArea);
            secondElemArea = getHeight_(secondArea);
            curPosition = getClientY_(event);
          }
          percent = (curPosition - rootEdge) / rootSize * 100;
          percent = (percent < 0)
                      ? 0
                      : (percent < 100)
                        ? percent
                        : 100;

          switchShadow();
          root.switchRestrict(event);
          /** Minimum up or left */
          if (config.isReductFirstElem) {
            percent = 0;
          }
          /** Minimum down or right */
          if (config.isReductSecondElem) {
            percent = 100;
          }

          if (!config.isReductFirstElem &&
              !config.isReductSecondElem) {
            createCustomEvent_(root, 'ihcp-hr-moving', {
              event: event
            });
          }
          slideBar(percent);
          function switchShadow() {
            var firstBarClass = config.classDef.bar + '-' + config.firstSuffix;
            var secondBarClass = config.classDef.bar + '-' + config.secondSuffix;
            var BOX_SHADOW_WIDTH = 5;

            if (config.addShadow === 'first') {
              if (firstElemArea < BOX_SHADOW_WIDTH) {
                barElem.classList.remove(firstBarClass);
              } else {
                barElem.classList.add(firstBarClass);
              }
            }
            if (config.addShadow === 'second') {
              if (secondElemArea < BOX_SHADOW_WIDTH) {
                barElem.classList.remove(secondBarClass);
              } else {
                barElem.classList.add(secondBarClass);
              }
            }
          }
        }
        function onMoveEnd(event) {
          createCustomEvent_(root, 'ihcp-hr-moveEnd', {
            event: event,
            isFirstEdge: config.isReductFirstElem,
            isSecondEdge: config.isReductSecondElem
          });

          if (event.type.indexOf('touch') !== -1) {
            removeEventHandler_(root, 'touchmove', onMoving);
            removeEventHandler_(root, 'touchend', onMoveEnd);
            removeEventHandler_(root, 'touchcancel', onMoveEnd);
          } else {
            elem.classList.remove(draggingClass);
            firstArea.classList.remove(draggingClass);
            secondArea.classList.remove(draggingClass);
            root.classList.remove(cursorClass);
            removeEventHandler_(frame, 'mousemove', onMoving);
            removeEventHandler_(frame, 'mouseup', onMoveEnd);
            removeEventHandler_(root, 'mouseleave', onMouseLeave);
            removeEventHandler_(window, 'mouseup', onMoveEnd);
            removeEventHandler_(frame, 'pagehide', onMoveEnd);
            for (i = 0; i < window.length; i++) {
              removeEventHandler_(window[i], 'mouseup', onMoveEnd);
            }
          }
        }
        function onMouseLeave(event) {
          var curPosition = (config.handleType === 'vertical')
                              ? getClientX_(event) : getClientY_(event);
          var percent = 0;
          var topLeftEdge = Math.floor(rootRect[config.firstSuffix]);
          var bottomRightEdge = Math.floor(rootRect[config.secondSuffix]);
          preventBrowserDefault_(event);
          stopEventBubble_(event);

          if (curPosition <= topLeftEdge) {
            config.isReductFirstElem = true;
          } else if (bottomRightEdge <= curPosition) {
            percent = 100;
            config.isReductSecondElem = true;
          } else {
            return;
          }
          slideBar(percent);
        }
        function slideBar(percent) {
          firstArea.style[config.cssProperty] = format_("calc(%s% - %spx)", percent, barSize/2);
          secondArea.style[config.cssProperty] = format_("calc(%s% - %spx)", 100 - percent, barSize/2);
        }
      },
      switchRestrict: function(event) {
        var root = this;
        var config = root.config;
        var barElem = config.elem.barElem;
        var rootRect = root.getBoundingClientRect();

        var rootEdge = 0;
        var rootSize = 0;
        var barSize = 0;
        var firstSize = 0;
        var secondSize = 0;
        var curPosition = 0;
        var totalSize = 0;
        var totalMinSize = parseFloat(root.style['min-' + config.cssProperty]);

        if (config.handleType === 'vertical') {
          rootEdge = rootRect['left'];
          rootSize = getWidth_(root);
          barSize = getWidth_(barElem);
          firstSize = getWidth_(config.elem.firstElem);
          secondSize = getWidth_(config.elem.secondElem);
        } else {
          rootEdge = rootRect['top'];
          rootSize = getHeight_(root);
          barSize = getHeight_(barElem);
          firstSize = getHeight_(config.elem.firstElem);
          secondSize = getHeight_(config.elem.secondElem);
        }
        if (rootSize === 0) {
          return;
        }
        if (event !== undefined &&
            (event.type === 'mousemove' ||
             event.type === 'touchmove')) {
          curPosition = (config.handleType === 'vertical')
                          ? getClientX_(event)
                          : getClientY_(event);
          firstSize = curPosition - rootEdge - (barSize / 2);
          secondSize = rootSize - firstSize - barSize;

          if (firstSize < config.firstMinSize) {
            firstSize = config.firstMinSize;
            secondSize = rootSize - firstSize - barSize;
          }
          if (secondSize < config.secondMinSize) {
            secondSize = config.secondMinSize;
            firstSize = rootSize - secondSize - barSize;
          }
        }
        totalSize = firstSize + barSize + secondSize;

        checkFirstEdge(event);
        checkSecondEdge(event);

        turnOnOffHide();

        function checkFirstEdge(event) {
          if (firstSize <= config.firstMinSize) {
            if (!config.isReductFirstElem) {
              config.isReductFirstElem = true;
              customReachEvent(event);
            }
          } else if (totalMinSize < totalSize) {
            if (config.isReductFirstElem) {
              config.isReductFirstElem = false;
              customLeaveEvent(event, 'first');
            }
          }
        }
        function checkSecondEdge(event) {
          if (secondSize <= config.secondMinSize) {
            if (!config.isReductSecondElem) {
              config.isReductSecondElem = true;
              customReachEvent(event);
            }
          } else if (totalMinSize < totalSize) {
            if (config.isReductSecondElem) {
              config.isReductSecondElem = false;
              customLeaveEvent(event, 'second');
            }
          }
        }
        function customReachEvent(event) {
          createCustomEvent_(root, 'ihcp-hr-reachEdge', {
            event: event,
            isFirstEdge: config.isReductFirstElem,
            isSecondEdge: config.isReductSecondElem
          });
        }
        function customLeaveEvent(event, orient) {
          createCustomEvent_(root, 'ihcp-hr-leaveEdge', {
            event: event,
            which: orient
          });
        }
        function turnOnOffHide() {
          var firstHide = config.elem.firstHide;
          var secondHide = config.elem.secondHide;

          turnOnOffClass_(firstHide, 'hide', (!config.isFirstHide || !config.isReductFirstElem));
          turnOnOffClass_(secondHide, 'hide', (!config.isSecondHide || !config.isReductSecondElem));
          barElem.style['border-' + config.firstSuffix + '-color'] = config.isReductFirstElem ? '#bebebe' : '#a0a0a0';
          barElem.style['border-' + config.secondSuffix + '-color'] = config.isReductSecondElem ? '#bebebe' : '#a0a0a0';
        }
      },
      getSize: function() {
        var root = this;
        var config = root.config;
        var firstArea = config.elem.firstArea;
        var secondArea = config.elem.secondArea;
        var barElem = config.elem.barElem;
        var rootSize = 0;
        var firstSize = 0;
        var secondSize = 0;
        var barSize = 0;
        var firstPercent = 0;
        var secondPercent = 0;

        if (config.handleType === 'vertical') {
          rootSize = getWidth_(root);
          firstSize = getWidth_(firstArea);
          secondSize = getWidth_(secondArea);
          barSize = getWidth_(barElem);
        } else {
          rootSize = getHeight_(root);
          firstSize = getHeight_(firstArea);
          secondSize = getHeight_(secondArea);
          barSize = getHeight_(barElem);
        }
        firstPercent = (firstSize / (rootSize - barSize)) * 100;
        secondPercent = (secondSize / (rootSize - barSize)) * 100;

        return {
          first: firstPercent,
          second: secondPercent
        };
      }
    }
  };

ihmi.messageBoxTextboxIntegler   = ihmi.messageBox;
ihmi.messageBoxTextboxReal       = ihmi.messageBox;
ihmi.messageBoxTextboxString     = ihmi.messageBox;
ihmi.messageBoxCheckbox          = ihmi.messageBox;
ihmi.selectFrame                 = ihmi.selectRobot;

  var userAgent = top.navigator.userAgent;
  var isIEMobile = ((typeof userAgent === 'string') && (userAgent.indexOf('IEMobile') >= 0)) ? true : false;

  // var isIEMobile = true;  // See shtmlib.c to debug iPendant pages on PC.
  ihmi.global.isIEMobile = isIEMobile;

  ihmi.global.isTablet = (window.ontouchstart === undefined) ? false : true;
  ihmi.global.isiPad = (userAgent.toLowerCase().indexOf('ipad') >= 0);
  ihmi.global.isAndroid = (userAgent.toLowerCase().indexOf('android') >= 0);
/**
   * window.navigator.maxTouchPoints
   *  : PC_Chrome -> 0
   *  : PC_ie11 -> 0
   *  : PC_ie7 -> undefined
   *  : android 9 -> 5
   *  : iOS12.1 -> undefined
   *  : WT_Chrome -> 10
   *  : WT_IE11 -> 10
   * android, ios, WT_Chrome, WT_IE -> true
   * TP, other -> false
   */
  ihmi.global.touchable = ((0 < window.navigator.maxTouchPoints) || ihmi.global.isiPad);

  /** shortcut ihmi.cf function */
  var addClass_ = ihmi.cf.addClass;
  var addClassExclusively_ = ihmi.cf.addClassExclusively;
  var addEventHandler_ = ihmi.cf.addEventHandler;
  var adjustFontSize_ = ihmi.cf.adjustFontSize;
  var alertMessage_ = ihmi.cf.alertMessage;
  var copyInitConfig_ = ihmi.cf.copyInitConfig;
  var createCustomEvent_ = ihmi.cf.createCustomEvent;
  var createRequiredMark_ = ihmi.cf.createRequiredMark;
  var cumulativeOffsetLeft_ = ihmi.cf.cumulativeOffsetLeft;
  var cumulativeOffsetTop_ = ihmi.cf.cumulativeOffsetTop;
  var debounce_ = ihmi.cf.debounce;
  var determineDefaultDesignPattern_ = ihmi.cf.determineDefaultDesignPattern;
  var divideNumUnit_ = ihmi.cf.divideNumUnit;
  var escapeHTML_ = ihmi.cf.escapeHTML;
  var findAncestor_ = ihmi.cf.findAncestor;
  var findAncestorFrame_ = ihmi.cf.findAncestorFrame;
  var findDescendant_ = ihmi.cf.findDescendant;
  var findDescendants_ = ihmi.cf.findDescendants;
  var findLastAncestor_ = ihmi.cf.findLastAncestor;
  var firstElementNode_ = ihmi.cf.firstElementNode;
  var format_ = ihmi.cf.format;
  var getClientX_ = ihmi.cf.getClientX;
  var getClientY_ = ihmi.cf.getClientY;
  var getCurrentStyle_ = ihmi.cf.getCurrentStyle;
  var getDefaultView_ = ihmi.cf.getDefaultView;
  var getHeight_ = ihmi.cf.getHeight;
  var getIEVersion_ = ihmi.cf.getIEVersion;
  var getNextNode_ = ihmi.cf.getNextNode;
  var getResponseText_ = ihmi.cf.getResponseText;
  var getWidth_ = ihmi.cf.getWidth;
  var getZoomFactor_ = ihmi.cf.getZoomFactor;
  var hasClass_ = ihmi.cf.hasClass;
  var initComponents_ = ihmi.cf.initComponents;
  var isArray_ = ihmi.cf.isArray;
  var isiPendant_ = ihmi.cf.isiPendant;
  var IUIFRequest_ = ihmi.cf.IUIFRequest;
  var judgeAddTabletClass_ = ihmi.cf.judgeAddTabletClass;
  var lightupBtnMoment_ = ihmi.cf.lightupBtnMoment;
  var nextElementNode_ = ihmi.cf.nextElementNode;
  var notifyTextboxChanged_ = ihmi.cf.notifyTextboxChanged;
  var parseStrToBoolean_ = ihmi.cf.parseStrToBoolean;
  var prevElementNode_ = ihmi.cf.prevElementNode;
  var preventBrowserDefault_ = ihmi.cf.preventBrowserDefault;
  var querySelector_ = ihmi.cf.querySelector;
  var scrollTo_ = ihmi.cf.scrollTo;
  var setRequiredMark_ = ihmi.cf.setRequiredMark;
  var stopEventBubble_ = ihmi.cf.stopEventBubble;
  var textbox_ = ihmi.cf.textbox;
  var turnOnOffClass_ = ihmi.cf.turnOnOffClass;
  var turnOnOffClasses_ = ihmi.cf.turnOnOffClasses;
  var triggerEvent_ = ihmi.cf.triggerEvent;
  var removeClass_ = ihmi.cf.removeClass;
  var removeClasses_ = ihmi.cf.removeClasses;
  var removeClassExclusively_ = ihmi.cf.removeClassExclusively;
  var removeEventHandler_ = ihmi.cf.removeEventHandler;
  var removeLastUndefined_ = ihmi.cf.removeLastUndefined;
  var removeSelection_ = ihmi.cf.removeSelection;
  var replaceClass_ = ihmi.cf.replaceClass;
  var replaceClassExclusively_ = ihmi.cf.replaceClassExclusively;
  var appendWaitingOverlayScreen_ = ihmi.cf.appendWaitingOverlayScreen;
  var removeWaitingOverlayScreen_ = ihmi.cf.removeWaitingOverlayScreen;

  this.IHMIComponents = ihmi;
})();

//for iRVision start
/** Return true if script is executed on the iRProgrammer. */
function isiRProgrammer() {
  return top === null ? false : typeof top.g_irprog == "undefined" ? false : top.g_irprog;
}
/* eslint-disable no-unused-vars */
function getVisTop(frame) {
  if (!isiRProgrammer()) return top;
  function isDescendant(upper, frame) {
    if (!frame) return false;
    var currFrame = frame;
    while (currFrame != upper && currFrame != currFrame.parent) {
      currFrame = currFrame.parent;
    }
    return (currFrame == upper); // Do not use !== for this checking.
  }
  var names = ["prim", "dual", "third"];
  for (var i = 0, len = names.length; i < len; i++) {
    if (isDescendant(top.mainfrm[names[i]], frame)) {
      return top.mainfrm[names[i]];
    }
  }
  return top.mainfrm[names[0]]; // FIXME: should return null
}
/* eslint-enable no-unused-vars */
//for iRVision end