/*jsl:import idc.js*/
/*jsl:import imgdisp.js*/
var webpage = "vsimg1";
var LiveSnapWait = 50;
var UndoFKey = 1;   // Undo = F1
var Ins_Vtx_FKey = "F6";
var Del_Vtx_FKey = "F7";
var Arc_FKey = "F10";
var Reset_FKey = "F2";
var Edit_FKey = "F2";
var OK_FKey = "F4";
var SegLineVtxLimit = 15;  // Max. number of segmented line vertices in graphical edit
var ZoomValues = [0.125, 0.25, 0.333, 0.5, 1, 2, 4, 8];  // Zoom values available, 1.0 = 100%

var delaySizeChangeEvent;
var savedArea;
var LiveTimer;

var InteractiveFinishCommand = "";
var LiveModeEnabled = false;
var ContSFModeEnabled = false;
var FirstImageLoaded = false;
var InteractiveMode = "none";
var WaitOnLiveUpdate = false;
var IDCWasHidden = false;
var CurrentResultsSize = "";
var ShapeStarted = false;
var CurrentZoom = 0.0;
var imageWidth = 0;
var imageHeight = 0;
var imageScale = 1;
var IDCInitialized = false;
var waitingOnZoomChange = false;
var ActiveDrawTool = 0;
var IsMultiviewImage = false;
var LastSampleRowPct = 0;
var LastSampleColPct = 0;
var EditEnded = false;
var ResetZoomAfterEndEditResize = false;
var MostRecentZoomChangeSent = 0.0;
var GraphicEditStarted = false;
var WaitForImageLoadAfterResize = false;
var preventRecalcZoom = false;

// Mask tools
var MaskTool_Rectangle = 1;
var MaskTool_Ellipse = 2;
var MaskTool_SegLine = 3;
var MaskTool_Fill = 4;
var MaskTool_Unfill = 5;
var MaskTool_Circle = 6;
var MaskTool_FreeDraw = 7;
var MaskTool_FreeErase = 8;
var NumMaskTools = 8;

// Mask help files
var maskHelpFiles = ["hlp_area_rectangle",
                     "hlp_area_ellipse",
                     "hlp_area_segline",
                     "hlp_area_filling",
                     "hlp_area_clearing",
                     "hlp_area_circle",
                     "hlp_area_freedraw",
                     "hlp_area_freeerase"];

// Draw tools
var DrawTool_Rectangle = 1;
var DrawTool_Ellipse = 2;
var DrawTool_SegLine = 3;
//var DrawTool_Unused1 = 4;  // placeholders
//var DrawTool_Unused2 = 5;
var DrawTool_Circle = 6;
var NumDrawTools = 5;

var FKey_Context_Interactive = "frmInteractiveKeys";
var FKey_Context_Masking = "frmMaskDrawKeys";
//var RequestTime = 0.0;
//var LoadedTime = 0.0;
var topLeftOffset = {row: 0, col: 0};
var combinedZoomBinLevel = 1;

var win_3dview = null; // 3dview using three.js

function getOpenHelp() {
  if (vtop.openHelp === undefined) vtop.openHelp = false; // default value
  return vtop.openHelp;
}

function setOpenHelp(open) {
  vtop.openHelp = open;
}

function addViewportEventHandlers() {
  var viewport = document.getElementById("viewport");
  if (!viewport) {
    return;
  }

  // Add mousewheel event handler if not touch screen
  if (!window.ontouchstart) {
    vtop.addEventHandler(viewport, "wheel", onScrollZoom);
  }

  // Event handler for mouse wheel (only in new browsers)
  function onScrollZoom(event) {
    if (!event.ctrlKey) {  // Only handle if user presses Ctrl
      return;
    }
    event.preventDefault();  // Don't allow the browser to perform the default action
    var newZoom = incDecZoom(parseFloat(CurrentZoom), event.deltaY < 0);
    if (newZoom == undefined) {
      // incDecZoom did not return a valid zoom selection value
      return;
    }

    // Calculate new center point
    var newCenter = ctlImageDisplay1.getVPCenterPixel(event.pageX, event.pageY, newZoom);
    setImageZoom(newZoom);
    ctlImageDisplay1.setVPCenterPixel(newCenter);
    SelectZoomOption(newZoom.toString());
  }

  // Determine the new zoom value based on increment or decrement
  function incDecZoom(zoomValue, inc) {
    var newZoom;
    var index = ZoomValues.indexOf(zoomValue);
    if (index >= 0) {
      index += inc ? 1 : -1;
      index = Math.max(0, Math.min(index, ZoomValues.length - 1));
      newZoom = ZoomValues[index];
    }
    return newZoom;
  }
}

function InitializeFunc() {
  InitializeHostName();
  InitializePortNo(vtop.getFrame('frmDataList'));
  ctlImageDisplay1.left = 0;
  delaySizeChangeEvent = vtop.isiPendant() ? 0 : 100;
  EnableMaskingControls(false, null);
  ShowMaxWindowButton(false);
  ShowShowLabelsButton(false);
  vtop.KeyEvent.attachHandlers(window);
  ctlImageDisplay1.SetProperty("MaskingVersion", "830");
  if (ctlImageDisplay1.initIDC === undefined) {
    ctlImageDisplay1.SelectMaskTool(MaskTool_SegLine);  // segmented line by default
  }
  else {
    ctlImageDisplay1.SelectMaskTool(MaskTool_FreeDraw); // freehand by default on PC
  }
  var selectZoom = document.getElementById("selZoom");
  // Custom functions for select dropdowns
  if (selectZoom) {
    if (ctlImageDisplay1.initIDC === undefined) {
      vtop.addEventHandler(selectZoom, "resizestart", selectOnOpen);
      vtop.addEventHandler(selectZoom, "resizeend", restoreIDC);
    }
    selectZoom.onselectoptionlocal = OnZoomChanged;
    SelectZoomOption("1.000");  // show 100% by default
  }
  var selectPenWidth = document.getElementById("selPenWidth");
  if (selectPenWidth) {
    if (ctlImageDisplay1.initIDC === undefined) {
      vtop.addEventHandler(selectPenWidth, "resizestart", selectOnOpen);
      vtop.addEventHandler(selectPenWidth, "resizeend", restoreIDC);
    }
    selectPenWidth.onselectoptionlocal = OnPenWidthChanged;
  }

  CurrentResultsSize = GetResultsSize();
  setTimeout(BodyResize, 50);
  if (!isActiveXIDC()) vtop.regPinchEvent(document.getElementById("viewport"), function () { changeZoomValue(false); }, function () { changeZoomValue(true); });

  // Add other viewport event handlers
  if (!isActiveXIDC()) {
    addViewportEventHandlers();
  }

  vtop.addEventHandler(document.getElementById("btnOpen"), "click", syncBodyFrame);
  vtop.addEventHandler(document.getElementById("btnSave"), "click", syncBodyFrame);

  if (vtop.isTablet()) {
    vtop.addClass(document.getElementById("btnPan"), "hide");
  }

  var txtAngle = document.getElementById("txtAngle");
  txtAngle.setCallback(function (_id, _eventName, value) {
    var floorVal = Math.floor(value * 10) / 10;
    txtAngle.setValue(floorVal);
    if (!isActiveXIDC()) ctlImageDisplay1.setCursorAngle(floorVal);
  });
}

function InitializeVariables() {
  InteractiveMode = "none";
  LiveModeEnabled = false;
  ContSFModeEnabled = false;
  WaitOnLiveUpdate = false;
  ShapeStarted = false;
  FirstImageLoaded = false;
  SetDrawingMode(false);

  IDCInitialized = false;
  imageWidth = 0;
  imageHeight = 0;
  imageScale = 1;
  CurrentZoom = 0.0;
  savedArea = { width: 0, height: 0, top: 0, left: 0 };

  InteractiveFinishCommand = "";
  CurrentResultsSize = "";
  waitingOnZoomChange = false;
  EditEnded = false;
  ResetZoomAfterEndEditResize = false;
  MostRecentZoomChangeSent = 0.0;
  GraphicEditStarted = false;
  WaitForImageLoadAfterResize = false;
  topLeftOffset = {row: 0, col: 0};
  combinedZoomBinLevel = 1;
}

function frameHasClass(mode) {
  var doc = document,
      bodyThis = doc.body;
  return vtop.hasClass(bodyThis, mode);
}

function refreshOnAppear() {
  LoadImageWithZoom('', '', CurrentZoom);
  hideShowIDC(true);
  IDCWasHidden = false;
  syncBodyFrame();
}
function syncBodyFrame() {
  if (vtop.hasClass(document.body, 'image-max-size')) {
    resizeFrame('image-max-size');
  }
  else if (vtop.hasClass(document.body, 'interactive-mode')) { // should not occur
    resizeFrame('interactive-mode');
  }
}
function appendFuncKeysFrame(file, initFrame, keyHandler) {
  var initialize = function(iframe) {
    var frame = iframe.contentWindow,
        doc = frame.document,
        funcKey, disabled;
    for (var i = 1; i <= 10; i++) {
      disabled = (i === UndoFKey); // undo button is disabled at first
      funcKey = doc.getElementById('F' + i);
      if (funcKey !== null) {
        funcKey.refresh({}, null, disabled, OnFuncKeyClicked);
      }
    }
    if (keyHandler === undefined) { // woarkaround to prevent handleInteractiveKeys from being added in mask mode.
      keyHandler = handleInteractiveKeys;
    }
    if (typeof keyHandler === 'function') {
      vtop.KeyEvent.addHandler(keyHandler, frame);
    }
    vtop.KeyEvent.addHandler(function(event) {
      if (event.keyCode === 27) { // prev
        frame.document.getElementById("F5").click();
        return false;
      }
      return true;
    }, frame);
    if (typeof initFrame === 'function') {
      initFrame(frame);
    }
  };
  var iframe = vtop.appendFrame(parent, file + ".stm", "funckeys-frame", initialize);
  if (vtop.isCRXMode() && vtop.isTablet()) {
    toggleImageOverFuncKey(document.getElementById("displaySection").clientHeight);
  }
  return iframe;
}

function startInteractiveMode(file, initFrame, keyHandler) {
  resizeFrame('interactive-mode');
  hideShowPanButton(true);
  var iframe = appendFuncKeysFrame(file, initFrame, keyHandler);
  iframe.id = "frmInteractiveKeys";
  // Resize body and use new zoom unless already in drawing mode
  if (!IsDrawingMode()) {
    window.setTimeout(function() {
      BodyResize();
      UseIDCCalcZoom(false);
    }, 125);
  }
}

function DisableUndo(disable) {
  if (InteractiveMode == "none") return;
  var frameName = (InteractiveMode == "mask" && ShapeStarted) ? "frmMaskDrawKeys" : "frmInteractiveKeys";
  var frameElem = parent.document.getElementById(frameName);
  if (frameElem) {
    vtop.waitUntil(function() {
      var fkey = frameElem.contentWindow.document.getElementById("F" + UndoFKey);
      if (fkey !== undefined && fkey !== null) {
        return typeof fkey.refresh === 'function';
      } else {
        return false;
      }
    },
    50, 40,
    function() {
      frameElem.contentWindow.document.getElementById("F" + UndoFKey).refresh({}, null, disable);
    });
  }
}

function handleInteractiveKeys(event) {
  // if event.keyCode == 0, reference event.key
  // (Because iPad Bluetooth keyboard returns keycode of 0 when press key in Pg Up, Pg Dn, ��, ��, ��, ��)
  var tmpKeyCode = event.keyCode;
  if (tmpKeyCode == 0) {
    switch (event.key){
    case "UIKeyInputPageUp":
      tmpKeyCode = 33;
      break;
    case "UIKeyInputPageDown":
      tmpKeyCode = 34;
      break;
    case "UIKeyInputLeftArrow":
      tmpKeyCode = 37;
      break;
    case "UIKeyInputUpArrow":
      tmpKeyCode = 38;
      break;
    case "UIKeyInputRightArrow":
      tmpKeyCode = 39;
      break;
    case "UIKeyInputDownArrow":
      tmpKeyCode = 40;
      break;
    default:
      break;
    }
  }
  // Try bump keys first
  if (interpretBumpKeys(tmpKeyCode, event.shiftKey)) {
    return false;
  }
  else {
    if ((event.keyCode >= 48) && (event.keyCode <= 57)) {  // 0-9
      // Interactive handle selection
      if (event.ctrlKey == true) {
        // Actually an F-key
        return true;
      }
      ctlImageDisplay1.SelectHandle(event.keyCode - 48);
      return false;
    }
    if ((event.keyCode >= 96) && (event.keyCode <= 105)) {  // 0-9 on keypad
      ctlImageDisplay1.SelectHandle(event.keyCode - 96);
      return false;
    }
    return true;
  }
}

var resizeTimer = null;
function BodyResize() {
  if (preventRecalcZoom) {
    preventRecalcZoom = false;
    return;
  }
  if (vtop.isiPendant()) {
    BodyResize2();
  }
  else {
    if (resizeTimer == null) {
      resizeTimer = window.setTimeout(BodyResize2, 100);
    }
  }
}

function BodyResize2() {
  var newResultsSize = GetResultsSize();
  var resetZoom = false;
  var recalcZoom = false;

  function isImageOverFuncKey(imageHeight, frameHeight, funcKeyHeight) {
    return (imageHeight > frameHeight - funcKeyHeight) && (imageHeight < frameHeight);
  }

  if (vtop.isCRXMode() && vtop.isTablet()) {
    var selZoom = document.getElementById("selZoom"),
        displaySection = document.getElementById("displaySection"),
        displaySectionHeight = displaySection.clientHeight,
        frmDataSetupDoc = vtop.getFrame("frmDataSetup").document,
        divMain = frmDataSetupDoc.getElementById("divMain"),
        divImageDisplay = frmDataSetupDoc.getElementById("divImageDisplay"),
        currentZoomValue = selZoom.getValue(),
        previousRatio = selZoom.getPreviousValue() / currentZoomValue,
        nextRatio = selZoom.getNextValue() / currentZoomValue,
        previousImageHeight = displaySectionHeight * previousRatio,
        nowImageHeight = displaySectionHeight,
        nextImageHeight = displaySectionHeight * (displaySection.clientWidth * nextRatio < divImageDisplay.clientWidth ? nextRatio : 1),
        funcKeyHeight = vtop.hasClass(frmDataSetupDoc.body, 'func-key-down') ? 70 : 90,
        frameHeight = divImageDisplay.clientHeight + (vtop.hasClass(divMain, "over-func-key") ? 0 : funcKeyHeight),
        addClassOverFuncKey = (isImageOverFuncKey(previousImageHeight, frameHeight, funcKeyHeight) ||
                               isImageOverFuncKey(nowImageHeight, frameHeight, funcKeyHeight) ||
                               isImageOverFuncKey(nextImageHeight, frameHeight, funcKeyHeight));
    vtop.turnOnOffClass(divMain, "over-func-key", addClassOverFuncKey);
  }
  if (EditEnded) {
    if ((ResetZoomAfterEndEditResize !== undefined) && (ResetZoomAfterEndEditResize == true)) {
      // Recalculate zoom now (but after resize)
      recalcZoom = true;
    }
    else {
      resetZoom = true;
    }
    // Reset EditEnded flag
    EditEnded = false;
  }
  if (!resetZoom) {
    CurrentResultsSize = newResultsSize;
  }
  else {
    // Reset CurrentZoom to force zoom to be calculated on load
    if (!IsDrawingMode()) {
      CurrentZoom = 0.0;
      // If an image isn't loaded in a timely manner, recalculate zoom anyway.
      WaitForImageLoadAfterResize = true;
      window.setTimeout(CheckOnZoomChangeAfterLoad, 200);
    }
    else {
      recalcZoom = true;  // Need to recalculate and maintain zoom rather than reset
    }
  }
  IDCBodyResize(resetZoom);
  resizeTimer = null;
  if (recalcZoom) {
    // Recalculate zoom now
    RecalculateZoom();
    ResetZoomAfterEndEditResize = false;
  }
}

function CheckOnZoomChangeAfterLoad() {
  if (WaitForImageLoadAfterResize == true) {
    // Still waiting, so recalculate zoom
    WaitForImageLoadAfterResize = false;
    RecalculateZoom();
  }
}

function GetResultsSize() {
  var bodyTop = vtop.getFrame('frmDataSetup').document.body;
  if (bodyTop) {
    var resultSizes = ["result-mid-size", "result-max-size"];
    for (var i = 0; i < 2; i++) {
      if (vtop.hasClass(bodyTop, resultSizes[i])) {
        return resultSizes[i];
      }
    }
  }
  return "";
}

function StartInteractiveWindow(FinishCommand, offsetX, offsetY, height, width, angle, rotatable, config, initFuncKey) {
  if (InteractiveFinishCommand == "") {
    changeOverview(true, config);
    var initFrame = function(frame) {
      InteractiveFinishCommand = FinishCommand;
      ctlImageDisplay1.SetMovableWindow(offsetX, offsetY, height, width, angle, rotatable);
      ShowMaxWindowButton(true);
      ShowShowLabelsButton(true);
      if (IsDrawingMode()) {
        ActiveDrawTool = DrawTool_Rectangle;
        ctlImageDisplay1.SelectMaskTool(DrawTool_Rectangle);
        MarkDrawToolSelected();
      }
      if (typeof initFuncKey === 'function') {
        initFuncKey(frame);
      }
      window.setTimeout(ctlImageDisplay1.EditMovableWindow, 50);
      if (!isActiveXIDC()) {
        changeResetKey(true);
      }
    };
    InteractiveMode = "window";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    startInteractiveMode("vsfkin", initFrame, undefined);
  }
}

function StartInteractiveSegmLine(FinishCommand, allowArc, numVertices, closed, vertexArray, config) {
  if (InteractiveFinishCommand == "") {
    changeOverview(true, config);
    var initFrame;
    InteractiveMode = "segmline";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    if (numVertices > 0) {
      initFrame = function(frame) {
        ctlImageDisplay1.EditMovableSegmLine();
        ctlImageDisplay1.StartSegLineEdit();
        CheckSegLineFkeys();
      };
      startInteractiveMode("vsfkss", initFrame, undefined);
    } else {
      initFrame = function(frame) {
        ctlImageDisplay1.EditMovableSegmLine();
        // Just change btnReset to btnEdit (disabled)
        var fKey = GetFkey(Reset_FKey, FKey_Context_Interactive);
        fKey.refresh({label: "༭", sprite: "vficon-segment"}, null, true);
        // Disable OK button to start (must have 2 or more vertices)
        EnableFkey(OK_FKey, FKey_Context_Interactive, false);
      };
      startInteractiveMode("vsfkin", initFrame, undefined);
    }
    InteractiveFinishCommand = FinishCommand;
    ctlImageDisplay1.StartMovableSegmLine(allowArc? 1 : 0);
    for (var i = 0; i < numVertices; i++) {
      // [[vt1, hz1, arc1], ..., [vtN, hzN, arcN]]
      ctlImageDisplay1.AddNodeToSegmLine(vertexArray[i][0], vertexArray[i][1], vertexArray[i][2]);
    }
    if (closed) ctlImageDisplay1.AddNodeToSegmLine(vertexArray[0][0], vertexArray[0][1], vertexArray[0][2]);
    ShowMaxWindowButton(false);
    ShowShowLabelsButton(false);
    if (IsDrawingMode()) {
      ActiveDrawTool = DrawTool_SegLine;
      MarkDrawToolSelected();
    }
  }
}

function StartInteractiveEllipse(FinishCommand, centerVt, centerHz, semiMajor, semiMinor, angle) {
  if (InteractiveFinishCommand == "") {
    var initFrame = function(frame) {
      InteractiveFinishCommand = FinishCommand;
      ctlImageDisplay1.SetMovableEllipse(centerVt, centerHz, semiMajor, semiMinor, angle);
      ShowMaxWindowButton(false);
      ShowShowLabelsButton(true);
      if (IsDrawingMode()) {
        ActiveDrawTool = DrawTool_Ellipse;
        MarkDrawToolSelected();
      }
      window.setTimeout(ctlImageDisplay1.EditMovableEllipse, 50);
    };
    InteractiveMode = "ellipse";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    startInteractiveMode("vsfkin", initFrame, undefined);
  }
}

function StartInteractiveCircle(FinishCommand, centerVt, centerHz, radius, config) {
  if (InteractiveFinishCommand == "") {
    changeOverview(true, config);
    var initFrame = function(frame) {
      InteractiveFinishCommand = FinishCommand;
      ctlImageDisplay1.SetMovableCircle(centerVt, centerHz, radius);
      ShowMaxWindowButton(false);
      ShowShowLabelsButton(true);
      if (IsDrawingMode()) {
        ActiveDrawTool = DrawTool_Circle;
        MarkDrawToolSelected();
      }
      window.setTimeout(ctlImageDisplay1.EditMovableCircle, 50);
      if (!isActiveXIDC()) {
        changeResetKey(true);
      }
    };
    InteractiveMode = "circle";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    startInteractiveMode("vsfkin", initFrame, undefined);
  }
}

function StartEditPoint(FinishCommand, row, column, angle, config, initFuncKey) {
  if (InteractiveFinishCommand == "") {
    changeOverview(true, config);
    var initFrame = function(frame) {
      InteractiveFinishCommand = FinishCommand;
      if (!isActiveXIDC()) {
        ctlImageDisplay1.SetMovableCursor(column, row, angle);
      }
      else {
        ctlImageDisplay1.SetMovableCursor(column, row);
      }
      if (typeof initFuncKey === 'function') {
        initFuncKey(frame);
      }
      updateTxtAngle(angle);
      window.setTimeout(function () {
        if (!isActiveXIDC()) {
          ctlImageDisplay1.EditMovableCursor(false, true);
          changeResetKey(true);
        }
        else {
          ctlImageDisplay1.EditMovableCursor();
        }
      }, 50);
    };
    InteractiveMode = "cursor";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    startInteractiveMode("vsfkin", initFrame, undefined);
  }
}

function toggleAngleMode() {
  var isAngle = isAngleMode();

  changeOverview(true, isAngle ?
                 { overview: "ԭ㡣µԭλá", help: "hlp_area_setorigin" } :
                 { overview: "ģͽǶȡ뽫&#9650;ϵ趨ĽǶȡ\n趨ģͽǶΪ0&deg;ҪͼĽǶȡ\nҲɸģ͵ԭλá", help: "hlp_area_setangle" });
  vtop.turnOnOffClass(document.getElementById("divAngle"), "hide", isAngle);
  window.setTimeout(function () {
    if (!isActiveXIDC()) {
      ctlImageDisplay1.EditMovableCursor(!isAngle, false);
    }
    else {
      ctlImageDisplay1.EditMovableCursor();
    }
  }, 50);
  return !isAngle;
}

function isAngleMode() {
  return !vtop.hasClass(document.getElementById("divAngle"), "hide");
}

function isActiveXIDC() {
  return document.getElementById("viewport") === null; // FIXME: view port is not defined in IE7 mode
}

function setInteractivePoint(x, y) {
  ctlImageDisplay1.SetMovableCursor(y, x);
  if (isActiveXIDC()) {
    window.setTimeout(function () {
      ctlImageDisplay1.EditMovableCursor();
      DisableUndo(true);
    }, 50);
  }
}

function StartTrainingMaskEdit(FinishCommand, HostName, TrainModelFileName, MaskFile, config) {
  if (InteractiveFinishCommand == "") {
    InteractiveMode = "mask";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    EnableMaskingControls(true, config);
    InteractiveFinishCommand = FinishCommand;
    EditMask(HostName, TrainModelFileName, MaskFile, 1);
  }
}

function StartEmphasisMaskEdit(FinishCommand, HostName, TrainModelFileName, MaskFile, config) {
  if (InteractiveFinishCommand == "") {
    InteractiveMode = "mask";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    EnableMaskingControls(true, config);
    InteractiveFinishCommand = FinishCommand;
    EditMask(HostName, TrainModelFileName, MaskFile, 2);
  }
}

function EditMask(hostName, modelFile, maskFile, type) {
  ctlImageDisplay1.LoadImage(hostName, modelFile, "", "");
  ctlImageDisplay1.LoadMask(hostName, maskFile, "", "", type);
  startInteractiveMode("vsfkms", undefined, null);
  switch (type) {
  case 1:
    ctlImageDisplay1.EditDontCareMask();
    break;
  case 2:
    ctlImageDisplay1.EditEmphasisMask();
    break;
  }
}

function StartInteractiveLine(FinishCommand, row1, col1, row2, col2, use_arrows, config) {
  if (InteractiveFinishCommand == "") {
    changeOverview(true, config);
    var initFrame = function(frame) {
      InteractiveFinishCommand = FinishCommand;
      ctlImageDisplay1.SetMovableLine(col1, row1, col2, row2, use_arrows);
      window.setTimeout(ctlImageDisplay1.EditMovableLine, 50);
      if (!isActiveXIDC()) {
        changeResetKey(true);
      }
    };
    InteractiveMode = "line";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    startInteractiveMode("vsfkin", initFrame, undefined);
  }
}

function StartInteractiveLinePair(FinishCommand, row1, col1, row2, col2, pair_width, min_width, max_width, config) {
  if (InteractiveFinishCommand == "") {
    changeOverview(true, config);
    var initFrame = function(frame) {
      InteractiveFinishCommand = FinishCommand;
      ctlImageDisplay1.SetProperty("MinPairWidth", min_width);
      ctlImageDisplay1.SetProperty("MaxPairWidth", max_width);
      ctlImageDisplay1.SetMovableLinePair(col1, row1, col2, row2, pair_width);
      window.setTimeout(ctlImageDisplay1.EditMovableLinePair, 50);
      if (!isActiveXIDC()) {
        changeResetKey(true);
      }
    };
    InteractiveMode = "linepair";
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
    startInteractiveMode("vsfkin", initFrame, undefined);
  }
}

vtop.addEventHandler(window, vtop.unloadEvent, function() {
  if (ctlImageDisplay1.deleteIDC) {
    ctlImageDisplay1.deleteIDC();
  }
});
// This code executes so that select options can be seen.
// Otherwise, the IDC hides the select options.
function selectOnOpen(event) {
  if (isIDCHidden()) return true;
  var target = event.srcElement;
  var area = getIDCArea();
  var diffHeight = target.getOptions().offsetHeight * getBrowserZoomY();
  // Determine which way to shrink IDC
  var newHeight = area.height - diffHeight;
  var newWidth = target.offsetLeft * getBrowserZoomX();

  // Leave vertical shrink as default if there is enough room
  if ((newHeight > 100) && (newWidth / newHeight < 3)) {
    ctlImageDisplay1.Resize(area.width, Math.max(0, area.height - diffHeight));
    ctlImageDisplay1.Reposition(area.left, area.top + diffHeight);
  }
  else {
    ctlImageDisplay1.Resize(target.offsetLeft, area.height);
  }
  return false;
}
function restoreIDC() {
  if (isIDCHidden()) return true;
  delayResizeReposition(savedArea);
  return false;
}
function CheckPenWidthDisable(toolNumber) {
  DisablePenWidthSelect((toolNumber != MaskTool_SegLine) &&
                        (toolNumber != MaskTool_FreeDraw) &&
                        (toolNumber != MaskTool_FreeErase));
}

function GetGraphicToolButton(toolIndex, isDrawing) {
  var buttonElem;
  var buttonId = "";
  switch (parseInt(toolIndex, 10)) {
  case 0:
    // none
    return null;
    break;
  case MaskTool_Rectangle:  // Rectangle
    buttonId = "btnRectangle";
    break;
  case MaskTool_Ellipse:  // Ellipse
    buttonId = "btnEllipse";
    break;
  case MaskTool_SegLine:  // Jointed line
    buttonId = "btnSegLine";
    break;
  case MaskTool_Fill:  // Fill
    buttonId = "btnFill";
    break;
  case MaskTool_Unfill:  // Unfill
    buttonId = "btnUnfill";
    break;
  case MaskTool_Circle: // Circle
    buttonId = "btnCircle";
    break;
  case MaskTool_FreeDraw: // Freehand draw
    buttonId = "btnFreeDraw";
    break;
  case MaskTool_FreeErase: // Freehand erase
    buttonId = "btnFreeErase";
    break;
  }
  if (buttonId != "") {
    if (isDrawing) {
      buttonId = buttonId + "D";
    }
    buttonElem = document.getElementById(buttonId);
  }
  else {
    buttonElem = null;
  }
  return buttonElem;
}
function OnEndEdit(clickedOK) {
  setTimeout(function () { // visual effect of a function key is not displayed without setTimeout.
    switch (InteractiveMode) {
      case "window":
        ctlImageDisplay1.ShowMovableWindow(0);
        if (ActiveDrawTool == DrawTool_Rectangle) {
          FinishDrawing(DrawTool_Rectangle);
        }
        else {
          ShowMaxWindowButton(false);
          ShowShowLabelsButton(false);
          ctlImageDisplay1.ClearGraphics();
        }
        break;
      case "cursor":
        if (!isActiveXIDC()) {
          ctlImageDisplay1.ShowMovableCursor(0, false);
        }
        else {
          ctlImageDisplay1.ShowMovableCursor(0);
        }
        ctlImageDisplay1.ClearGraphics();
        vtop.addClass(document.getElementById("divAngle"), "hide");
        break;
      case "mask":
        EnableMaskingControls(false);
        ctlImageDisplay1.FinishEditMask(clickedOK);
        break;
      case "line":
        ctlImageDisplay1.ShowMovableLine(0);
        ctlImageDisplay1.ClearGraphics();
        break;
      case "linepair":
        ctlImageDisplay1.ShowMovableLinePair(0);
        ctlImageDisplay1.ClearGraphics();
        break;
      case "segmline":
        FinishDrawing(DrawTool_SegLine);
        break;
      case "circle":
        FinishDrawing(DrawTool_Circle);
        break;
    }
    InteractiveMode = "none";
    if (!IsDrawingMode()) {  // Editing hasn't ended if still in drawing mode
      EditEnded = true;  // Signal BodyResize to reset zoom
      changeOverview(false);
    }
    hideShowPanButton(false);
    resizeFrame('interactive-mode');
    vtop.removeFrame(parent.document.getElementById("frmInteractiveKeys"));
    showFuncKeyFrame();
    if (InteractiveFinishCommand) {
      InteractiveFinishCommand(clickedOK);
      InteractiveFinishCommand = "";
    }
  }, 0);
}

function showFuncKeyFrame() {
  if (vtop.isCRXMode() && vtop.isTablet()) {
    var funcKeyFrame = vtop.findDescendants(vtop.getFrame("frmDataSetup").document, 'div', 'funckeys-frame');
    if (funcKeyFrame.length > 0) {
      vtop.removeClass(funcKeyFrame[funcKeyFrame.length - 1], "hide");
    }
  }
}

function FinishDrawing(drawTool) {
  ShowMaxWindowButton(false);
  ShowShowLabelsButton(false);
  var toolButtonId;
  switch (ActiveDrawTool) {
  case DrawTool_Rectangle:
    toolButtonId = "btnRectangleD";
    break;
  case DrawTool_Circle:
    toolButtonId = "btnCircleD";
    break;
  case DrawTool_SegLine:
    toolButtonId = "btnSegLineD";
    break;
  }
  EnableDrawToolButtons(true);
  MarkSelectGraphicTool("divDrawControls", 0);
  ActiveDrawTool = 0;
  ctlImageDisplay1.FinishEdit(drawTool);
  ctlImageDisplay1.ClearGraphics();
  // Update zoom so that refreshed display is correct
  ajax_control_event("OnZoomChangedNoRefresh", parseFloat(CurrentZoom) * 100);
}

function OnImageLoaded() {
  // If live mode, request a new snap
  if (LiveModeEnabled) {
    // Request the next image
    if (!WaitOnLiveUpdate) {
      //      var d2 = new Date();
      //      LoadedTime = d2.getTime();
      //      ctlImageDisplay1.OutputDebug("Time between request and loaded = " + (LoadedTime - RequestTime) + " ms");
      WaitOnLiveUpdate = true;
      LiveTimer = setTimeout(DelayedLiveSnap, LiveSnapWait);
    }
  }
  else {
    if (InteractiveMode != "none") {
      GraphicEditStarted = false;
      // Use zoom from Image display
      UseIDCCalcZoom(false);
    }
    else if (GraphicEditStarted) {
      // If Graphic Edit was just started; it always sends zoom = 1.0 but InteractiveMode = "none"
      // Use zoom from Image display
      GraphicEditStarted = false;
      UseIDCCalcZoom(false);
    }
    else {
      var oldImageWidth = imageWidth;
      var oldImageHeight = imageHeight;
      var oldScale = imageScale;
      var zoomScale = Math.round(1 / (CurrentZoom === 0 ? 1 : CurrentZoom));
      // Get the current image size and compare to old dimensions
      imageWidth = ctlImageDisplay1.ImageWidth();
      imageHeight = ctlImageDisplay1.ImageHeight();
      if (CurrentZoom < 1.0) {
        imageWidth *= zoomScale;
        imageHeight *= zoomScale;
        imageScale = zoomScale;
      }
      else {
        imageScale = 1;
      }
      var sizeTolerance = Math.max(imageScale, oldScale);
      if ((Math.abs(oldImageWidth - imageWidth) > sizeTolerance) ||
          (Math.abs(oldImageHeight - imageHeight) > sizeTolerance)) {
        // Send OnSizeChanged event with new image width/height
        if (savedArea === undefined) {
          // Attempt to get savedArea
          savedArea = getIDCArea();
        }
        if (savedArea != undefined) {
          delayedSendSizeChangeEvent(!FirstImageLoaded);
        }
      }
      else {
        if (!FirstImageLoaded) {
          waitingOnZoomChange = false;
          ctlImageDisplay1.SetProperty("WaitOnZoomChange", "0");
        }
      }
      FirstImageLoaded = true;
    }
  }
  // If multiview image, disable sample button
  if (IsMultiviewImage) {
    EnableSampleButton(false);
    EnableCrosshairButton(false);
    IsMultiviewImage = false;
  }
  else {
    EnableSampleButton(true);
    EnableCrosshairButton(true);
  }
  // If sample tool is turned on, update
  if (isPropertyOn("SampleToolEnabled")) {
    ForceSampleUpdate();
  }
}

function DelayedLiveSnap() {
//  var d = new Date();
//  RequestTime = d.getTime();
//  ctlImageDisplay1.OutputDebug("Wait between load and next req. = " + (RequestTime - LoadedTime) + " ms");
  if (LiveModeEnabled) {
    ajax_control_event("LiveSnap", 0);
  }
  WaitOnLiveUpdate = false;
}

function EnableLiveMode(enable) {
  if (LiveModeEnabled == enable) {
    // Ignore - same state as current
    return;
  }
  LiveModeEnabled = enable;
  var idcFrame = vtop.getIDCFrame(),
      selectZoom = idcFrame.document.getElementById("selZoom");
  ctlImageDisplay1.SetProperty("LiveMode", (enable ? "1" : "0"));
  if (isZoomLimitedBrowser()) {
    if (LiveModeEnabled && idcFrame.ctlImageDisplay1.GetProperty("Zoom") > 1) {
      idcFrame.ForceSetIDCZoom("1.000");
      ajax_control_event("OnZoomChangedNoRefresh", 100);
    }
    selectZoom.refresh([], parseFloat(selectZoom.getValue()), null, enable);
  }
  if (LiveModeEnabled) {
//    var d2 = new Date();
//    LoadedTime = d2.getTime();
//    ctlImageDisplay1.OutputDebug("Time between request and loaded = " + (LoadedTime - RequestTime) + " ms");
    LiveTimer = window.setTimeout(DelayedLiveSnap, LiveSnapWait);
  }
}

function EnableContSFMode(enable) {
  ContSFModeEnabled = enable;
}

function OnDrawClicked() {
  CommitShape(true);
}

function OnEraseClicked() {
  CommitShape(false);
}

function OnEndShape() {
  // Enable/disable Undo
  ShapeStarted = false;
  ActiveDrawTool = 0;
  var isUndoEmpty = (ctlImageDisplay1.GetProperty("IsUndoQueueEmpty") == "1" ? true : false);
  window.setTimeout(function() {
    vtop.removeFrame(parent.document.getElementById("frmMaskDrawKeys"));
    showFuncKeyFrame();
    // Enable mask tool buttons
    EnableMaskToolButtons(true);
    DisableUndo(isUndoEmpty);
  }, 0);
}

function EnableMaskToolButtons(blnEnable) {
  var buttonElem;
  for (var i = 1; i <= NumMaskTools; i++) {
    buttonElem = GetGraphicToolButton(i.toString(), false);
    if (buttonElem !== null) {
      if (blnEnable) {
        buttonElem.refresh(null, false);
      }
      else if (!vtop.hasClass(buttonElem, "image-button-pressed")) {
        buttonElem.refresh(null, true);
      }
    }
  }
}

function EnableDrawToolButtons(blnEnable) {
  var buttonElem;
  for (var i = 1; i <= NumDrawTools; i++) {
    buttonElem = GetGraphicToolButton(i.toString(), true);
    if (buttonElem !== null) {
      if (blnEnable) {
        buttonElem.refresh(null, false);
      }
      else if (!vtop.hasClass(buttonElem, "image-button-pressed")) {
        buttonElem.refresh(null, true);
      }
    }
  }
}

function CommitShape(drawShapeIfTrue) {
  if (drawShapeIfTrue) {
    ctlImageDisplay1.DrawShape();
  }
  else {
    ctlImageDisplay1.EraseShape();
  }
  try {
    OnEndShape();
  }
  catch (e) { }
}

function OnMaskToolClicked(toolButton) {
  OnGraphicToolClicked("divMaskControls", toolButton);
}

function OnDrawToolClicked(toolButton) {
  var toolValue = 0;
  switch (toolButton.id) {
  case "btnRectangleD":
    toolValue = 1;
    break;
  case "btnCircleD":
    toolValue = 2;
    break;
  case "btnSegLineD":
    toolValue = 3;
    break;
  }
  if (toolValue > 0) {
    GraphicEditStarted = true; // Flag to use IDC zoom on first image load
    resetPanButton();
    vtop.VTRNRequest(window, { webpage: "vsfkge", request: "btnAddShape.selected", value: toolValue, label: "" }).send();
  }
}

function MarkDrawToolSelected() {
  MarkSelectGraphicTool("divDrawControls", ActiveDrawTool);
  EnableDrawToolButtons(false);
}

function OnGraphicToolClicked(divName, toolButton) {
  var toolNumber = 0;
  switch (toolButton.id) {
  case "btnRectangle":
    toolNumber = MaskTool_Rectangle;
    break;
  case "btnEllipse":
    toolNumber = MaskTool_Ellipse;
    break;
  case "btnSegLine":
    toolNumber = MaskTool_SegLine;
    break;
  case "btnFill":
    toolNumber = MaskTool_Fill;
    break;
  case "btnUnfill":
    toolNumber = MaskTool_Unfill;
    break;
  case "btnCircle":
    toolNumber = MaskTool_Circle;
    break;
  case "btnFreeDraw":
    toolNumber = MaskTool_FreeDraw;
    break;
  case "btnFreeErase":
    toolNumber = MaskTool_FreeErase;
    break;
  }
  if (toolNumber > 0 && toolNumber <= NumMaskTools) {
    var helpArea = document.getElementById("helpArea");
    vtop.loadVersionPage(helpArea, vtop.format("/frh/vision/help/%s.htm", maskHelpFiles[toolNumber - 1]));
    vtop.addEventHandler(helpArea, "load", function (_event) {
      vtop.addBodyClass(helpArea.contentWindow.document.body);
    });
    if (divName == "divMaskControls") {
      CheckPenWidthDisable(toolNumber);
    }
    ctlImageDisplay1.SelectMaskTool(toolNumber);
  }
  resetPanButton();
  MarkSelectGraphicTool(divName, toolNumber.toString());
}

function onPanButtonClicked(button) {
  var buttonPressed = !isPropertyOn("scrollLock");
  vtop.turnOnOffClass(button, "image-button-pressed", buttonPressed);
  turnOnOffProperty("scrollLock", buttonPressed);
}

function DisablePenWidthSelect(disable) {
  var selectPenWidth = document.getElementById("selPenWidth");
  if (selectPenWidth) {
    selectPenWidth.refresh([], selectPenWidth.getValue(), null, disable);
    var selectLabel = document.getElementById("lblPenWidth");
    if (selectLabel) {
      vtop.turnOnOffClass(selectLabel, "disabled", disable);
    }
  }
}

function GetFkey(fKey, context) {
  var fkeyFrame = parent.document.getElementById(context);
  if (fkeyFrame != undefined) {
    return fkeyFrame.contentWindow.document.getElementById(fKey);
  }
}

function EnableFkey(fKey, context, enable) {
  var fkeyElem = GetFkey(fKey, context);
  if (fkeyElem !== undefined && fkeyElem !== null) {
    fkeyElem.refresh({}, null, !enable);
  }
}

function closeImageDisplay() {
  hideHelpFile();
  if (LiveModeEnabled) {
    clearTimeout(LiveTimer);
    EnableLiveMode(false);
  }
  if (ContSFModeEnabled) {
    EnableContSFMode(false);
  }
  hideShowIDC(false);
  IDCWasHidden = true;
  InitializeVariables();
}

function OnFuncKeyClicked(type, page, name, selected) {
  switch (name) {
  case "btnOK":
    OnEndEdit(1);
    break;
  case "btnCancel":
    OnEndEdit(0);
    break;
  case "btnReset":
    ctlImageDisplay1.Reset();
    break;
  case "btnUndo":
    ShowProcessing();
    window.setTimeout(function() {
      ctlImageDisplay1.Undo();
      if ((InteractiveMode == "mask") || (InteractiveMode == "segmline")) {
        CheckSegLineFkeys();
      }
      HideProcessing();
    }, 50);
    break;
  case "btnDraw":
    OnDrawClicked();
    break;
  case "btnErase":
    OnEraseClicked();
    break;
  case "btnCancelDraw":
    ctlImageDisplay1.CancelShape();
    OnEndShape();
    break;
  case "btnEdit":
    ChangeToEditMode();
    break;
  case "btnPrevVtx":
    ctlImageDisplay1.SelPrevVertex();
    break;
  case "btnNextVtx":
    ctlImageDisplay1.SelNextVertex();
    break;
  case "btnDeleteVtx":
    ctlImageDisplay1.DeleteVertex();
    break;
  case "btnInsertVtx":
    ctlImageDisplay1.InsertVertex();
    break;
  case "btnArc":
    ctlImageDisplay1.ToggleArc();
    var context = (InteractiveMode == "mask") ? FKey_Context_Masking : FKey_Context_Interactive;
    ConfigureArcFkey(context);
    break;
  default:
    break;
  }
}
function OnShapeStarted() {
  var graphicTool = ctlImageDisplay1.GetProperty("GraphicTool");
  var iframe;
  var initFrame = function(frame) {
    if (graphicTool == MaskTool_SegLine) {
      frame.document.getElementById("F2").refresh({ name: "btnEdit", label: "༭", sprite: "vficon-segment" }, null, true);
      if (IsDrawingMode()) {
        CheckSegLineFkeys();
      }
    }
    if (InteractiveMode == "mask") {
      // Disable all mask tool buttons except selected
      EnableMaskToolButtons(false);
    }
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "0");
  };

  ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
  if (InteractiveMode == "mask") {
    ShapeStarted = true;
    iframe = appendFuncKeysFrame("vsfkdr", initFrame, undefined);
    iframe.id = "frmMaskDrawKeys";
  }
  else {
    vtop.removeFrame(parent.document.getElementById("frmInteractiveKeys"));
    iframe = appendFuncKeysFrame("vsfkin", initFrame);
    iframe.id = "frmInteractiveKeys";
  }
}
function ChangeToEditMode() {
  var iframe;
  var initFrame = function(frame) {
    ctlImageDisplay1.StartSegLineEdit();
    CheckSegLineFkeys();
    ctlImageDisplay1.SetProperty("InteractiveStartPending", "0");
  };
  ctlImageDisplay1.SetProperty("InteractiveStartPending", "1");
  if (InteractiveMode == "mask") {
    vtop.removeFrame(parent.document.getElementById("frmMaskDrawKeys"));
    iframe = appendFuncKeysFrame("vsfkse", initFrame, undefined);
    iframe.id = "frmMaskDrawKeys";
  }
  else {
    vtop.removeFrame(parent.document.getElementById("frmInteractiveKeys"));
    iframe = appendFuncKeysFrame("vsfkss", initFrame, undefined);
    iframe.id = "frmInteractiveKeys";
  }
}
function CheckSegLineFkeys() {
  var context = (InteractiveMode == "mask") ? FKey_Context_Masking : FKey_Context_Interactive;
  var currentTool = parseInt(ctlImageDisplay1.GetProperty("GraphicTool"), 10);
  if (currentTool == MaskTool_SegLine) {
    var numVertices = parseInt(ctlImageDisplay1.GetProperty("NumSegLineVertices"), 10);
    var selectedVertex = parseInt(ctlImageDisplay1.GetProperty("SelectedVertex"), 10);
    var isClosed = ctlImageDisplay1.GetProperty("IsSegLineClosed") == "1";

    if (parseInt(ctlImageDisplay1.GetProperty("IsSegLineEditStarted"), 10) == 1) {
      // Edit mode keys
      // Disable INS_VTX if not closed and selected is the end vertex
      var enableInsert = isClosed || (selectedVertex < numVertices - 1);
      if (IsDrawingMode()) {
        // If number of vertices > limit, disable INS_VTX
        enableInsert = enableInsert && (numVertices < SegLineVtxLimit);
      }
      EnableFkey(Ins_Vtx_FKey, context, enableInsert);
      // If number of vertices < 3, disable DEL_VTX
      var enableDelete = (numVertices > 2);
      EnableFkey(Del_Vtx_FKey, context, enableDelete);
      // Enable/disable ARC
      var enableArc = ctlImageDisplay1.GetProperty("IsVertexArcAllowed") == "1";
      EnableFkey(Arc_FKey, context, enableArc);
      // Configure ARC key based on selected vertex
      if (enableArc) {
        ConfigureArcFkey(context);
      }
    }
    else {
      // Create mode keys
      // If number of vertices < 2, disable Edit
      var enableEdit = (numVertices > 1);
      EnableFkey(Edit_FKey, context, enableEdit);
    }

    // If drawing, disable OK button if less than 2 vertices
    if (IsDrawingMode()) {
      var enableOK = (numVertices > 1);
      EnableFkey(OK_FKey, context, enableOK);
      // Tell IDC to check whether new vertices can now be added
      ctlImageDisplay1.TestSegLineNumVtx(SegLineVtxLimit);
    }
  }
}
function ConfigureArcFkey(context) {
  // Is selected vertex Arc'ed or not?
  var fKey = GetFkey(Arc_FKey, context);
  if (fKey !== undefined) {
    if (ctlImageDisplay1.GetProperty("IsSelVertexArcSet") == "1") {
      // Yes: Provide UN-ARC
      fKey.refresh({label: "Բ", sprite: "vficon-polygon"}, null, false);
    }
    else {
      // No: Provide ARC
      fKey.refresh({ label: "Բ", sprite: "vficon-arc" }, null, false);
    }
  }
}
function OnMaskAllClicked() {
  ctlImageDisplay1.MaskAll();
}
function OnUnmaskAllClicked() {
  ctlImageDisplay1.UnmaskAll();
}
function OnCrosshairClicked(button) {
  var buttonPressed = !isPropertyOn("Crosshair");
  vtop.turnOnOffClass(button, "button-pressed", buttonPressed);
  vtop.turnOnOffClass(button, "image-button-pressed", buttonPressed);
  turnOnOffProperty("Crosshair", buttonPressed);
}
function OnMaxWindowClicked(button) {
  ctlImageDisplay1.MaximizeMovableWindow();
}
function OnShowLabelsClicked(button) {
  var buttonPressed = !isPropertyOn("ShowLabels");
  vtop.turnOnOffClass(button, "image-button-pressed", buttonPressed);
  turnOnOffProperty("ShowLabels", buttonPressed);
}
function ResetZoomBeforeLoad() {
  // NOP; for compatibility
}
function EnableCrosshairButton(enable) {
  var button = document.getElementById("btnCross");
  if (button && button.refresh && isButtonEnabled(button) !== enable) {
    button.refresh(null, !enable);
    var onOff = (enable && vtop.hasClass(button, "button-pressed"));
    vtop.turnOnOffClass(button, "image-button-pressed", onOff);
    turnOnOffProperty("Crosshair", onOff);
  }
}
function ShowCrosshairButton(showButton) {
  var button = document.getElementById("btnCross");
  if (button) {
    vtop.turnOnOffClass(button, "hide", !showButton);
    var onOff = (showButton && vtop.hasClass(button, "button-pressed"));
    turnOnOffProperty("Crosshair", onOff);
  }
}
function ShowMaxWindowButton(showButton) {
  var button = document.getElementById("btnMaxWindow");
  if (button) {
    vtop.turnOnOffClass(button, "hide", !showButton);
  }
}
function ShowShowLabelsButton(showButton) {
  var button = document.getElementById("btnShowLabels");
  if (button) {
    vtop.turnOnOffClass(button, "hide", !showButton);
    var onOff = (showButton && vtop.hasClass(button, "image-button-pressed"));
    turnOnOffProperty("ShowLabels", onOff);
  }
}
function resetPanButton() {
  var button = document.getElementById("btnPan");
  vtop.turnOnOffClass(button, "image-button-pressed", false);
  turnOnOffProperty("scrollLock", false);
}
function hideShowPanButton(show) {
  if (vtop.isiPendant()) return;

  if (show) {
    vtop.removeClass(document.getElementById("btnPan"), "hide");
  }
  else {
    resetPanButton();
    vtop.turnOnOffClass(document.getElementById("btnPan"), "hide", vtop.isTablet());
  }
}
function OnOperationStart() {
  ShowProcessing();
  window.setTimeout(ContinueOperation, 50);
}
function ContinueOperation() {
  var pausedOp = ctlImageDisplay1.GetProperty("PausedOperation");
  if ((pausedOp.valueOf() == MaskTool_Fill) || (pausedOp.valueOf() == MaskTool_Unfill)) {
    // Tell IDC to continue
    ctlImageDisplay1.ContinueOperation();
  }
  else {
    // Abort
    HideProcessing();
  }
}

function closeOperationImagePage() {
  var iframeOperation, iframeFuncKey;
  var doc = vtop.getFrame('frmDataSetup').document;
  iframeOperation = doc.getElementById("frmOperationTool");
  if (iframeOperation !== null) {
    vtop.removeFrame(iframeOperation);
  }
  iframeFuncKey = doc.getElementById("frmFuncKeyOperation");
  if (iframeFuncKey !== null) {
    vtop.removeFrame(iframeFuncKey);
  }
  vtop.removeClass(doc.body, "setup-hide");
}

function OnSegLineVertexAdded() {
  var numVertices = ctlImageDisplay1.GetProperty("NumSegLineVertices");
  if (parseInt(numVertices, 10) == 2) {
    // Enable EDIT button
    EnableFkey("F2", (InteractiveMode == "mask") ? FKey_Context_Masking : FKey_Context_Interactive, true);
  }
  if (IsDrawingMode()) {
    // Tell IDC to check whether new vertices can now be added
    ctlImageDisplay1.TestSegLineNumVtx(SegLineVtxLimit);
  }
  vtop.waitUntil(function() {
    var fKey = GetFkey(Reset_FKey, FKey_Context_Interactive);
    if (fKey !== undefined && fKey !== null) {
      return (fKey.innerText !== "" ? fKey.innerText.match("༭") !== null
                                    : fKey.textContent.indexOf("༭") > -1);
    } else {
      return false;
    }
  },
  50, 40, CheckSegLineFkeys
  );
}

function IsDrawingMode() {
  return (ctlImageDisplay1.GetProperty("IsDrawing") == "1");
}
function SetDrawingMode(onOff) {
  ctlImageDisplay1.SetProperty("IsDrawing", (onOff ? "1" : "0"));
  if (!onOff) {
    // Set EditEnded flag for drawing mode
    EditEnded = true;
  }
}

function is3DViewShowable() {
  var browser = vtop.getBrowserType();
  switch(browser) {
  case 'Edge': case 'Safari': case 'Firefox': case 'Opera': case 'Samsung Internet': case 'Internet Explorer 7': case 'Unknown Browser':
    return false;
  case 'Chrome': case 'iOSChrome': case 'Internet Explorer 11': case 'TabletTPAndroidApp':
    return true;
  default:
    break;
  }
  return false;
}

function refresh3DViewButton(show, disabled)
{
  var button = document.getElementById("btn3DView");

  if (button && button.refresh) {
    if (!is3DViewShowable()) {
      show = false;
      disabled = true;
    }
    vtop.turnOnOffClass(button, 'hide', !show); // vuif_hideshow_element
    button.refresh(null, disabled); // vuif_refresh_button_image
  }
}

function open3DView()
{
  toggleHideShow3DView();
}

function changeHelpArea(open) {
  hideshowHelpArea(open);
  setOpenHelp(open);
}
function hideshowHelpArea(open) {
  vtop.turnOnOffClass(document.getElementById("helpArea"), "hide", !open);
  vtop.turnOnOffClass(document.getElementById("btnChangeHelp"), "image-button-pressed", open);
  if (!isActiveXIDC()) vtop.turnOnOffClass(document.getElementById("viewport"), "showHelpArea", open);
  if (!vtop.hasClass(document.getElementById("divOverview"), "hide")) BodyResize();
}
function hideshowOverview(open) {
  if (!isActiveXIDC()) vtop.turnOnOffClass(document.getElementById("viewport"), "showOverview", open);
  vtop.turnOnOffClass(document.getElementById("divOverview"), "hide", !open);
  hideshowHelpArea(open && getOpenHelp());
}
function changeOverview(open, config) {
  if (open) {
    if (config.overview) {
      var helpArea = document.getElementById("helpArea");
      if (typeof config.overview === "function") {
        config = config.overview();
      }
      document.getElementById("lblOverview").refresh(config.overview, "#000000", false, true);
      vtop.loadVersionPage(helpArea, vtop.format("/frh/vision/help/%s.htm", config.help));
      vtop.addEventHandler(helpArea, "load", function(event) {
        vtop.addBodyClass(helpArea.contentWindow.document.body);
      });
    }
    else {
      open = false;
    }
  }
  hideshowOverview(open);
}
function delayResizeReposition(area) {
  // Delay the restore to avoid sending touch to IDC
  window.setTimeout(function() {
    ctlImageDisplay1.Resize(area.width, area.height);
    ctlImageDisplay1.Reposition(area.left, area.top);
  }, 0);
}
function updateTxtAngle(degree) {
  document.getElementById("txtAngle").setValue(degree);
}
function changeResetKey(disable) {
  GetFkey(Reset_FKey, FKey_Context_Interactive).refresh({}, null, disable);
}
