/**
* @fileoverview This file is iRVision Image Display Library.
*/
//function ConsoleLog(func, output) {
//  try {
//    console.log("[" + func + "] " + output);
//  } catch (e) {
//  }
//}

if (!window.devicePixelRatio) {
  var pixelRatio = window.screen.deviceXDPI / window.screen.logicalXDPI;
  window.devicePixelRatio = pixelRatio ? pixelRatio : 1;
}

function getBrowserZoomX() {
  if (vtop.isiPendant()) {
    return 1;
  }
  else {
    var pixelRatio = window.screen.deviceXDPI / window.screen.logicalXDPI;
    if (pixelRatio) {
      return pixelRatio;
    }
    else {
      return window.devicePixelRatio;
    }
  }
}
function getBrowserZoomY() {
  if (vtop.isiPendant()) {
    return 1;
  }
  else {
    var pixelRatio = window.screen.deviceYDPI / window.screen.logicalYDPI;
    if (pixelRatio) {
      return pixelRatio;
    }
    else {
      return window.devicePixelRatio;
    }
  }
}

function getIDCArea() {
  var doc = document;
  var body = doc.body;
  var toolbar = doc.getElementById("divToolbar");
  var toolbarHeight = (toolbar != undefined) ? toolbar.offsetHeight : 0;
  var subtoolbar = doc.getElementById("divSubToolbar");
  var subtoolbarHeight = (subtoolbar != undefined) ? subtoolbar.offsetHeight : 0;
  var overview = doc.getElementById("divOverview");
  var overviewHeight = (overview != undefined) ? overview.offsetHeight : 0;
  var help = doc.getElementById("helpArea");
  var helpWidth = (help != undefined) ? help.offsetWidth : 0;
  var bottom = doc.getElementById("divBottom");
  var bottomHeight = (bottom != undefined) ? bottom.offsetHeight : 0;
  var browserZoomX = getBrowserZoomX();
  var browserZoomY = getBrowserZoomY();
  var offsetIDC = 2; // IDC should be shifted.
  var frameOffset = vtop.cumulativeFrameOffset(window);
  var innerOffsetTop = toolbarHeight + subtoolbarHeight + overviewHeight;

  var widthIDC = Math.max(1, body.offsetWidth - helpWidth) * browserZoomX;
  var heightIDC = Math.max(1, body.offsetHeight - innerOffsetTop - bottomHeight) * browserZoomY;
  var topIDC = (frameOffset.top + innerOffsetTop) * browserZoomY + offsetIDC;
  var leftIDC = frameOffset.left + (vtop.isiPendant() ? 0 : offsetIDC);

  //ConsoleLog("getIDCArea", "w=" + widthIDC + ", h=" + heightIDC + ", t=" + topIDC + ", l=" + leftIDC);
  return { width: widthIDC, height: heightIDC, top: topIDC, left: leftIDC };
}

function hideShowIDC(show) {
  var wasHidden = isIDCHidden();
  ctlImageDisplay1.SetProperty("Show", show ? 1 : 0);
  if (show && (!IDCInitialized || wasHidden)) {
    IDCResizeReposition();
  }
}

function isIDCHidden() {
  return (ctlImageDisplay1.GetProperty("IsShown") == "0");
}

function showIDC(showControl) {
  if (IDCWasHidden == showControl) {
    hideShowIDC(showControl);
    IDCWasHidden = !showControl;
  }
}

function isButtonEnabled(button) {
  return (button && !button.disabled);
}

function turnOnOffProperty(property, onOff) {
  ctlImageDisplay1.SetProperty(property, onOff ? "1" : "0");
}

function isPropertyOn(property) {
  return ctlImageDisplay1.GetProperty(property) === "1";
}

function sendIDCSize() {
  var area = getIDCArea();
  var params = [Math.floor(area.width), Math.floor(area.height), 0, 0, 0].join(',');
  ajax_control_event("OnSizeChanged", params);
}

function IDCResizeReposition() {
  var area = getIDCArea();
  savedArea = area;
  if (!isIDCHidden()) {  // If hidden, do not reposition
    ctlImageDisplay1.Reposition(area.left, area.top);
  }
  ctlImageDisplay1.Resize(area.width, area.height);
  // Magnify UIF elements if necessary
  //ctlImageDisplay1.OutputDebug("[IDCResizeReposition] w=" + area.width + ", h=" + area.height);
  if (area.width > 900 || area.height > 450) {
    ctlImageDisplay1.SetProperty("UIFMagnify", "2");
  }
  else {
    ctlImageDisplay1.SetProperty("UIFMagnify", "1");
  }
  IDCInitialized = true;
}

function IDCBodyResize(changeZoom) {
  IDCResizeReposition();  // Resize needs to be processed
  if (changeZoom) {
    if (InteractiveMode == "none") {
      delayedSendSizeChangeEvent(!FirstImageLoaded);
    }
    else {
      // Use IDC calculated zoom
      UseIDCCalcZoom(true);
    }
  }
}

function setImageZoom(zoomValue) {
  var zoomFloat = parseFloat(zoomValue);
  var curZoomFloat = parseFloat(CurrentZoom);
  var isInteractive = (InteractiveMode == "none");

  if (zoomFloat != curZoomFloat) {
    CurrentZoom = zoomValue;
    if (vtop.isCRXMode()) {
      var calcHeight = document.getElementById("displaySection").clientHeight;

      calcHeight = calcHeight / curZoomFloat * zoomFloat;
      toggleImageOverFuncKey(calcHeight);
    }
    if (isInteractive && ((curZoomFloat < 1.0) || (zoomFloat < 1.0))) {
      ajax_control_event("OnZoomChanged", zoomFloat * 100);
    }
    else {
      ctlImageDisplay1.SetProperty("Zoom", zoomValue);
      ajax_control_event("OnZoomChangedNoRefresh", zoomFloat * 100);
    }
    if (LiveModeEnabled == true || ContSFModeEnabled == true) {
      // Prevent images with outdated zoom values from being displayed
      MostRecentZoomChangeSent = zoomValue;
    }
  }
}

function OnZoomChanged(zoomValue) {
  var viewport = document.getElementById("viewport");
  if (viewport !== null) { // viewport exists only with Canvas IDC.
    // Keep viewport on the current center pixel
    var viewRect = viewport.getBoundingClientRect();
    var currentCenterPixel = ctlImageDisplay1.getVPCenterPixel(
      viewRect.left + viewRect.width / 2,
      viewRect.top + viewRect.height / 2,
      zoomValue);
  }
  setImageZoom(zoomValue);
  if (viewport !== null) { // viewport exists only with Canvas IDC.
    ctlImageDisplay1.setVPCenterPixel(currentCenterPixel);
  }
}

function toggleImageOverFuncKey(displaySectionHeight) {
  var frmDataSetupDoc = vtop.getFrame("frmDataSetup").document;
  var divMain = frmDataSetupDoc ? frmDataSetupDoc.getElementById("divMain") : null;

  if (vtop.isCRXMode() && vtop.isTablet() && (divMain !== null)) {
    var ImageDisplayHeight = frmDataSetupDoc.getElementById("divImageDisplay").clientHeight,
        divMainOverFuncKey = vtop.hasClass(divMain, "over-func-key"),
        isImageOverFuncKey = displaySectionHeight > ImageDisplayHeight - (divMainOverFuncKey ? (vtop.hasClass(frmDataSetupDoc.body, 'func-key-down') ? 70 : 90) : 0);

    preventRecalcZoom = (divMainOverFuncKey !== isImageOverFuncKey);
    vtop.turnOnOffClass(divMain, "over-func-key", isImageOverFuncKey);
  }
}

function OnPenWidthChanged(value) {
  ctlImageDisplay1.SetProperty("PenWidth", value);
}

function LoadImageWithZoom(host, filePath, zoom) {
  hideHelpFile();
  // Check for null load first
  if (filePath == "") {
    if (LiveModeEnabled == false && ContSFModeEnabled == false) {
      ClearIDCImage(); // Clearing image/graphics
      // Reset to the initial state where no image has been loaded.  This causes the automatic
      // zoom calculation to wait unil after an image is loaded.
      FirstImageLoaded = false;
    }
    return;
  }

  // Check if waiting on zoom change
  if (FirstImageLoaded) {
    var waitOnZoomChange = ctlImageDisplay1.GetProperty("WaitOnZoomChange") == "1" ? true : false;
    if (waitOnZoomChange) {
      waitingOnZoomChange = false;
      ctlImageDisplay1.SetProperty("WaitOnZoomChange", "0");
    }
  }

  zoom = zoom.toString().replace(",", ".").valueOf();
  var floatCurrentZoom = parseFloat(CurrentZoom);
  var floatZoom = parseFloat(zoom);

  // Check if zoom matches the last zoom change sent
  if (MostRecentZoomChangeSent !== undefined) {
    if (MostRecentZoomChangeSent != 0.0) {
      if (floatZoom != MostRecentZoomChangeSent) {
        if ((floatZoom < 1.0) || (MostRecentZoomChangeSent < 1.0)) { // Okay if both are >= 1.0
          // Discard this load
          //ConsoleLog("LoadImageWithZoom", "skipped: zoom="+ zoom + ", mrz=" + MostRecentZoomChangeSent);
          return;
        }
      }
    }
    // Zoom matches okay, so reset last zoom change value
    MostRecentZoomChangeSent = 0.0;
  }

  // If zoom == 1.0, use calculated zoom or current zoom (if > 1)
  if (floatZoom == 1.0 && floatCurrentZoom > 1.0) {
    zoom = CurrentZoom;
    if (EditEnded) {
      // May need to reset zoom after ending edit, with resizing frames
      ResetZoomAfterEndEditResize = true;
    }
  }
  else if (floatCurrentZoom != floatZoom) {
    // If edit ended, IDC may not yet be resized. If so, reset zoom after resize.
    if (floatCurrentZoom == 0.0 && floatZoom == 1.0 && EditEnded) {
      if (ResetZoomAfterEndEditResize !== undefined) {
        ResetZoomAfterEndEditResize = true;
      }
    }
    ForceSetIDCZoom(zoom);
  }
  // If first image has not been loaded yet, have the IDC hold on until final zoom is determined
  if (!FirstImageLoaded) {
    ctlImageDisplay1.SetProperty("WaitOnZoomChange", "1");
    waitingOnZoomChange = true;
  }
  if (WaitForImageLoadAfterResize) {
    WaitForImageLoadAfterResize = false;
  }
  ctlImageDisplay1.LoadImageWithZoom(host, filePath, '', '', zoom);
}

function SelectZoomOption(zoomValue) {
  var selectZoom = document.getElementById("selZoom");
  if (selectZoom && selectZoom.refresh) {
    selectZoom.refresh([], parseFloat(zoomValue), null, selectZoom.disabled);
  }
}

function ShowProcessing() {
  var loading = vtop.document.getElementById("loading");
  if (loading !== null) {
    loading.start();
  }
}

function HideProcessing() {
  var loading = vtop.document.getElementById("loading");
  if (loading !== null) {
    loading.finish();
  }
}

function InitializeHostName() {
  ctlImageDisplay1.HostName = document.location.host;
}

function InitializePortNo(ancestor) {
  if (ancestor == null) return;
  try {
    ctlImageDisplay1.SetProperty("HTTPPortNo", ancestor.getHTTPPortNo());
    if (ancestor.isVirtual) {
      ajax_control_event("OnGetFTPPortNumber", 0);
    }
    else {
      SetFTPPortNo(21);
    }
  } catch(err) {
    SetFTPPortNo(21);  // default
  }
}

function SetFTPPortNo(port) {
  ctlImageDisplay1.SetProperty("FTPPortNo", port);
}

function ajax_control_event(event, value) {
  vtop.VTRNRequest(window, {request: "ctlImageDisplay." + event,
                           value: value,
                           exitinteract: 0}).send();
}

function delayedSendSizeChangeEvent(resetZoomOnFirstLoad) {
  window.setTimeout(function() {
    SendSizeChangeEvent(true, resetZoomOnFirstLoad);
  }, delaySizeChangeEvent);
}

function SendSizeChangeEvent(forceSend, forceReset) {
  if (!IDCWasHidden || forceSend) {
    var resetZoom = (forceReset == true)? 1 : 0;
    var params = [Math.floor(savedArea.width), Math.floor(savedArea.height), imageWidth, imageHeight, resetZoom].join(',');
    ajax_control_event("OnSizeChanged", params);
    // If waiting on zoom change, make sure we stop waiting if no zoom change comes
    if (waitingOnZoomChange) {
      window.setTimeout(ZoomChangeTimeout, 250);
    }
  }
}

function UseIDCCalcZoom(checkFirst) {
  if (!FirstImageLoaded) {
    // No image yet, so IDC cannot calc zoom. Set CurrentZoom to 1.0 and select it.
    ForceSetIDCZoom(1.0);
    return;
  }
  ctlImageDisplay1.RecalculateZoom();
  var calcZoom = ctlImageDisplay1.GetProperty("CalculatedZoom");
  if (calcZoom != 0.0) {
    if (checkFirst) {
      // Check zoom
      var idcZoom = ctlImageDisplay1.GetProperty("Zoom");
      if (idcZoom == calcZoom) {
        return; // No need to force IDC zoom
      }
    }
    ForceSetIDCZoom(calcZoom);
  }
}

function setIDCZoom(newZoom) {
  FirstImageLoaded = true;
  ForceSetIDCZoom(newZoom);
}

function ForceSetIDCZoom(newZoom) {
  CurrentZoom = newZoom;
  SelectZoomOption(CurrentZoom);
  ctlImageDisplay1.SetProperty("Zoom", CurrentZoom);
}

function ZoomChangeTimeout() {
  if (waitingOnZoomChange) {
    // Stop waiting
    waitingOnZoomChange = false;
    ctlImageDisplay1.SetProperty("WaitOnZoomChange", "0");
  }
}

function ShowRowColDisplay(show) {
  vtop.turnOnOffClass(document.body, "showSubToolbar", show);
  if (!isIDCHidden()) {
    IDCResizeReposition();
  }
}

function UpdateRowColumnDisplay() {
  var lastSample = ctlImageDisplay1.GetProperty("LastSample");
  if (lastSample != "") {
    var sampleFields = lastSample.split(",");
    sampleFields[0] = parseInt(sampleFields[0], 10);
    sampleFields[1] = parseInt(sampleFields[1], 10);
    // Get row/col as percentage of image width/height
    LastSampleRowPct = sampleFields[0] / (ctlImageDisplay1.ImageHeight() - 1);
    LastSampleColPct = sampleFields[1] / (ctlImageDisplay1.ImageWidth() - 1);
    // Adjust row/col for zoom * binning
    var floatCurrentZoom = parseFloat(CurrentZoom);
    if (floatCurrentZoom < 1.0 || combinedZoomBinLevel > 1) {
      sampleFields[0] = Math.round(sampleFields[0] * combinedZoomBinLevel);
      sampleFields[1] = Math.round(sampleFields[1] * combinedZoomBinLevel);
    }
    // Adjust row/col for local offset
    sampleFields[0] += topLeftOffset.row;
    sampleFields[1] += topLeftOffset.col;

    var outputString = "]AC^=(<b>" + sampleFields[0] +
                       "</b>,<b>" + sampleFields[1] + "</b>)";
    document.getElementById('lblRowCol').innerHTML = outputString;
    switch (sampleFields[2]) {
    case "1":
      // Grayscale
      outputString = "Ǧ=<b>" + sampleFields[3] + "</b>";
      break;
    case "2":
      // Color
      outputString = "RGB=(<b>" + sampleFields[3] +
        "</b>,<b>" + sampleFields[4] +
        "</b>,<b>" + sampleFields[5] + "</b>)";
      break;
    default:
      outputString = "";
      break;
    }
    document.getElementById('lblColor').innerHTML = outputString;
  }
}
function OnSampleToolClicked(button) {
  var buttonPressed = !isPropertyOn("SampleToolEnabled");
  if (isPropertyOn("scrollLock")) {
    resetPanButton();
    if (!buttonPressed) {
      return;
    }
  }
  vtop.turnOnOffClass(button, "button-pressed", buttonPressed);
  TurnSampleToolOnOff(buttonPressed);
}
function EnableSampleButton(enable) {
  var button = document.getElementById("btnSample");
  if (button && button.refresh && isButtonEnabled(button) !== enable) {
    button.refresh(null, !enable);
    var onOff = (enable && vtop.hasClass(button, "button-pressed"));
    TurnSampleToolOnOff(onOff);
  }
}
function ShowSampleButton(showButton) {
  var button = document.getElementById("btnSample");
  if (button) {
    vtop.turnOnOffClass(button, "hide", !showButton);
    var onOff = (showButton && vtop.hasClass(button, "button-pressed"));
    TurnSampleToolOnOff(onOff);
  }
}
function TurnSampleToolOnOff(onOff) {
  var button = document.getElementById("btnSample");
  if (button) {
    turnOnOffProperty("SampleToolEnabled", onOff);
    if (onOff) {
      vtop.KeyEvent.addHandler(handleBumpKeys, window);
      UpdateRowColumnDisplay();
    }
    else {
      vtop.KeyEvent.removeHandler(handleBumpKeys);
    }
    vtop.turnOnOffClass(button, "image-button-pressed", onOff);
    // Allow user to bump the sample tool cursor if turning on the sample tool
    ShowRowColDisplay(onOff);
  }
}

function handleBumpKeys(event) {
  return !interpretBumpKeys(event.keyCode, event.shiftKey);
}

function interpretBumpKeys(keyCode, shiftKey) {
  // Note: directions inside IDC: 0, 1, 2, 3 = up, right, down, left
  var dir, isLarge;
  switch (keyCode) {
  case 9: // up or down - detected as tab/shift-tab
    // If shifted, map as up
    // else, map as down
    dir = (shiftKey) ? 0 : 2;
    isLarge = 0;
    break;
  case 33: // shift + up
    dir = 0;
    isLarge = 1;
    break;
  case 34: // shift + down
    dir = 2;
    isLarge = 1;
    break;
  case 37: // left or shift-left
    dir = 3;
    isLarge = (shiftKey) ? 1 : 0;
    break;
  case 38: // keyboard up or shift-up
    dir = 0;
    isLarge = (shiftKey) ? 1 : 0;
    break;
  case 39: // right or shift-right
    dir = 1;
    isLarge = (shiftKey) ? 1 : 0;
    break;
  case 40: // keyboard down or shift-down
    dir = 2;
    isLarge = (shiftKey) ? 1 : 0;
    break;
  default:
    return false; // Key is not a bump key
  }
  ctlImageDisplay1.Bump(dir, isLarge);
  return true; // Key was handled as a bump key
}

function ClearIDCImage() {
  ctlImageDisplay1.LoadImage(document.location.host, '', '', '');
  EnableSampleButton(false);
  if (typeof EnableCrosshairButton === 'function') {
    EnableCrosshairButton(false);
  }
}

function ForceSampleUpdate() {
  ctlImageDisplay1.ForceSampleUpdate(LastSampleRowPct, LastSampleColPct);
}

function RecalculateZoom() {
  // If no image loaded, exit
  if (!FirstImageLoaded) {
    return;
  }
  ctlImageDisplay1.RecalculateZoom();
  var calcZoom = ctlImageDisplay1.GetProperty("CalculatedZoom");
  var actualZoom = ctlImageDisplay1.GetProperty("Zoom");
  if (actualZoom != calcZoom) {
    ForceSetIDCZoom(calcZoom);
  }
  else if (CurrentZoom != actualZoom) {
    // CurrentZoom needs to be set
    CurrentZoom = actualZoom;
  }
}

function isHelpFileShown(helpFile) {
  var frmHelpPage = document.getElementById('frmHelpPage'),
      divHelpPage = document.getElementById('divHelpPage');
  if (frmHelpPage &&
      divHelpPage &&
      frmHelpPage.src.lastIndexOf(helpFile) > 0 &&
      !vtop.hasClass(divHelpPage, 'hide')) {
    return true;
  }
  return false;
}

function showHelpFile2(helpFile) { // Continuation of showHelpFile() after image tab is displayed
  var frmHelpPage = document.getElementById('frmHelpPage');
  if (frmHelpPage) {
    if (vtop.isCRXMode()) {
      vtop.setIFrameOnLoad(frmHelpPage, function(iframe) {
        vtop.addBodyClass(iframe.contentWindow.document.body);
      });
    }
    frmHelpPage.src = vtop.convertToVersionURL(helpFile);
  }

  var divHelpPage = document.getElementById('divHelpPage');
  if (divHelpPage) {
    vtop.turnOnOffClass(divHelpPage, "hide", false);
  }

  var divToolbar = document.getElementById('divToolbar');
  if (divToolbar) {
    vtop.turnOnOffClass(divToolbar, "hide", true);
  }

  hideShowIDC(false);
}

function toggleHideShowHelpFile(helpFile) {
  if (isHelpFileShown(helpFile)) {
    hideHelpFile();
  }
  else {
    var tabImage = parent.document.getElementById('tabImage');
    if (tabImage) {
      tabImage.click(); // Switch to image tab first.
    }
    window.setTimeout(function () { showHelpFile2(helpFile); }, 0);
  }
}

function hideHelpFile() {
  var divHelpPage = document.getElementById('divHelpPage');
  if (divHelpPage) {
    if (!vtop.hasClass(divHelpPage, 'hide')) {

      var divToolbar = document.getElementById('divToolbar');
      if (divToolbar) {
        vtop.turnOnOffClass(divToolbar, "hide", false);
      }

      hideShowIDC(true);

      vtop.turnOnOffClass(divHelpPage, "hide", true);
    }
  }
}

function toggleHideShow3DView() {
  if (is3DViewShown()) {
    hide3DView();
  }
  else {
    var tabImage = parent.document.getElementById('tabImage');
    if (tabImage) {
      tabImage.click(); // Switch to image tab first.
    }
    window.setTimeout(function () { show3DView(); }, 0);
  }
}

function is3DViewShown() {
  var frm3DView = document.getElementById('frm3DView'),
      div3DView = document.getElementById('div3DView');
  if (frm3DView &&
      div3DView &&
      frm3DView.src.lastIndexOf("vs3dview.htm") > 0 &&
      !vtop.hasClass(div3DView, 'hide')) {
    return true;
  }
  return false;
}

function hide3DView() {
  var div3DView = document.getElementById('div3DView');
  if (div3DView) {
    if (!vtop.hasClass(div3DView, 'hide')) {
      var divToolbar = document.getElementById('divToolbar');
      if (divToolbar) {
        vtop.turnOnOffClass(divToolbar, "hide", false);
      }

      hideShowIDC(true);

      vtop.turnOnOffClass(div3DView, "hide", true);
      var frm3DView = document.getElementById('frm3DView');
      div3DView.removeChild(frm3DView);
    }
  }
}

function show3DView() { // Continuation of showHelpFile() after image tab is displayed
  var div3DView = document.getElementById('div3DView');
  var frm3DView = document.getElementById('frm3DView');

  if (div3DView) {
    if (frm3DView === null) {
      frm3DView = document.createElement("iframe");
      frm3DView.id = 'frm3DView';
      div3DView.appendChild(frm3DView);
    }

    vtop.setIFrameOnLoad(frm3DView, function (iframe) {
      vtop.addBodyClass(iframe.contentWindow.document.body);
    });
    frm3DView.src = vtop.convertToVersionURL("vs3dview.htm");

    vtop.turnOnOffClass(div3DView, "hide", false);

    var divToolbar = document.getElementById('divToolbar');
    if (divToolbar) {
      vtop.turnOnOffClass(divToolbar, "hide", true);
    }

    hideShowIDC(false);
  }
}

function SetOffsetAndBinning(offsetRow, offsetCol, combinedZoomBin) {
  topLeftOffset = {row: (offsetRow >= 0)? offsetRow : 0,
                   col: (offsetCol >= 0)? offsetCol : 0};
  combinedZoomBinLevel = combinedZoomBin;
}

function changeZoomValue(isZoomUp) {
  if (LiveModeEnabled && isZoomLimitedBrowser()) return;
  var selZoom = document.getElementById("selZoom");
  var nextVal = isZoomUp ? selZoom.getNextValue() : selZoom.getPreviousValue();

  SelectZoomOption(nextVal);
  OnZoomChanged(parseFloat(nextVal));
}

function isZoomLimitedBrowser() {
  var ZOOM_LIMIT_VAR = 103;
  // Older android chrome browsers will freeze if they are enlarged during live display.
  return vtop.isWebView() && vtop.getChromeVersion() < ZOOM_LIMIT_VAR;
}
