var newdictData = {
  title: "iRVision: Configuration",
  contents: {
    text:"iRVision: Configuration",
    hlpEnableLog:"When this item is not checked, the system does not perform any processing related to saving of the vision log or logged images.<br>To enable the vision log, check it on.",
    hlpLogPath:"This item is used to specify the destination folder of the vision log or logged images.<br>The available storage units for the vision log are Memory Card (MC:), USB memory (UD1:), and PC Share (C1:).",
    hlpDisableMonit:"When this item is checked, the system does not perform any processing related to the vision runtime display and the Vision Runtime screen does not display any information. Network traffic as well as the time required for vision processing is reduced.",
    hlpBufSize:"Select the buffer size for images to be displayed on the Vision Runtime from the following two items.<br><br>[1280 &#xD7; 1024]<br>By default, this size is selected.<br><br>[640 &#xD7; 512]<br>The buffer size is configured 1/4 of the default size.<br><br>The resolution of the image displayed on the PC vision runtime will become lower, but it will reduce the network traffic. The image displayed on the vision runtime of the teach pendant will not be affected because its resolution does not exceed that of the teach pendant screen.<br>`N<br>Changing the size of Runtime Display Buffer requires rebooting the controller.",
    hlpAllowAllOperations:"The vision data edit screen can be displayed even during production operation, like when the teach pendant is disabled and the controller is in the AUTO mode. However, operations which can affect production operation (snapping an image, doing a test detection, etc.) are disabled by default on the edit screen during production operation. If this item is checked, you are allowed to do such operations even during production operation.<br>`N<br>Snapping an image or performing a test during production operation may increase cycle time or stop the system due to a memory shortage. Check [Allow Snap and Find in Auto Mode] only when necessary.",
    hlpEngToolname:"When this item is checked, the default vision tool name will be English. To set the vision tool name in English, vision data created in Japanese does not get garbled even if it is opened in an English environment. This item is disabled by default, which sets the default vision tool name in a language selected in the robot controller.",
    hlpDecimalComma:"When this item is checked, a comma (,) is used in place of a period (.) as a decimal point. This item is provided for use in Europe.",
    hlpCopyPasteBufVP:"This item shows the name of vision data and vision tool in the clipboard. The clipboard is used for the copy/paste operation. Contents of a vision tool can be copied to the clipboard and pasted from the clipboard tool to another tool in the same vision process or another vision process.<br>In this screen, the vision program name and vision tool name copied to the clipboard are displayed.<br>Press [Clear] to clear the clipboard. Cycling power will also clear the clipboard.",
    hlpDataPath:"This item is used to specify the destination folder of vision data.<br>This item is read-only and cannot be changed.",
    hlpVemtPath:"This item is used to specify the destination folder for storing model teach files and image files used with External Model Teach function.<br>This item is read-only and cannot be changed.",
    hlpDisableImg:"When this item is checked, the system does not perform any processing related to saving images for ZDT function and images are not sent to your mobile device. Network traffic as well as the time required for IRVZDT processing is reduced.",
    hlpImgSize:"Select the maximum size of images to be sent to your mobile device with the ZDT function from the following items.<br><br>[640 &#xD7; 512]<br>When the camera image is larger than this size, the image size will be reduced to this size and then sent to your mobile device. It will reduce the network traffic and the capacity load of the ZDT server.<br><br>[1280 &#xD7; 1024]<br>By default, this size is selected.<br>",
    hlpPlot3d:"When this item is checked, the calibration data and found results are displayed on the 4D Display screen when calling RUN_FIND from an application program. This item is disabled by default because it can affect cycle time.",
    hlpNumAsynBuf:"This item is used to specify how many times detection results can be stored to enable the VISION RUN_FIND command and the VISION GET_OFFSET command to be executed asynchronously with each other. If vision processes are executed asynchronously more than the specified number of times, the oldest stored detection result is discarded.",
    hlpMaxNFound:"This item is used to specify the maximum number to find in the vision processes.",
    hlp3DMap:"This item is used to specify the size of 3D Map Storage Area in DRAM. The size of 3D Map Storage Ares is specified by the number of blocks, instead of in bytes. The default value is one (block). A block can store one normal-density 3D map. The item also shows the number of coarse-density 3D maps and fine-density 3D maps that can be stored below for your reference. Storing a coarse-density 3D map requires one block, and storing a fine-density 3D map requires four blocks. Determine the densities and number of 3D maps that you need to have simultaneously, and then calculate the number of blocks for them. For example, when storing one coarse-density 3D map and one fine-3D map simultaneously requires five blocks.  If you use them not simultaneously but one after another, the required number of blocks is four.",
    hlpVSCLEnabled:"Check the checkbox in order to use this iPC Box Setting.",
    hlpVSCLName:"Set a name which is used to indetify target iPC Box to communicate with. The name is used in TP program as, for example, \"Vision Command [the name].[vision data name]\".",
    hlpVSCLIPAddr:"Set IP address of iPC Box to communicate with.",
    hlpVisionDataCache:"Vision data (Camera data, vision process tools and etc.) will be stored in vision data cache once it is read so that future request will be served faster. Old data will be removed when new data is read if cache is full. If vision data is bigger than vision data cache, it can not be read. You can increase vision data cache here to solve it. The range of vision data cache size is %s - %s MB.".replace(/%s/, 1).replace(/%s/, (isIpc() ? 500 : 20)), //MIN_VD_DATA_CACHE, MAX_IPC_VD_DATA_CACHE, MAX_VD_DATA_CACHE
    hlpSAMode:"pGܡ²桨Ah|vó]mءAezѡAĳǪ̨ϥΡC <br/>ܡšiܩҦ]mA˵x iRVision ΤC <br/>L׿ܭؼҦAbоɾާ@L{AҥiھڻݨDҦC",
    hlpLogNoWait: "When this item is checked, RUN_FIND can start before saving log completion.<br><br>`N<br>Please make sure to add 'CALL IRVWAITLOG' in a TP program in order to specify at which line the program can wait for completion of logging.",
    acrdAlarmRowhelp: "If you register alarms here, robot will not pause when that alarms occur, but will only display warning.",
    hlpNumImregs:"This item is used to specify the number of areas where captured images are temporarily stored.<br>Changing Number of Image Registers requires rebooting the controller.",
    hlpImregSize:"Set the total size of all image registers.<br>Not only one image register, but also all storage of the image registers specified by Number of Image Registers.<br>Changing Size of Image Registers requires rebooting the controller."
  }
};
function closeHelp() {
  var doc = window.document;
  var iframe = document.getElementById("frmPopupHelp");
  vtop.removeFrame(iframe);
}

function clickedHelpLink(target, titleStr) {
  var targetId = target.id.replace(".", "");
  var iframe = vtop.appendFrame(window, "vcfghelp.stm", "syspopup-frame", function (iframe) {
    var frame = iframe.contentWindow;
    var clickElem = document.getElementById(target.id);
    var title = clickElem.innerText;
    var content = newdictData.contents[targetId];
    var doc = frame.document;
    var labelElem, contentElem;
    if (titleStr !== undefined) title = titleStr;
    labelElem = doc.getElementById("lblHeader");
    labelElem.refresh(title, null, false, false);
    contentElem = doc.getElementById("lblContents");
    contentElem.refresh(content, null, false, true);
  });
  iframe.allowTransparency = true;
  iframe.id = "frmPopupHelp";
}
