/**
 * @fileoverview iRVision JavaScript Library: This file is used to create UIF Component.
 */
/*jsl:import cookie.js*/

/*
var Logger = function() {
  var logs = [];
  var start_time = 0;
  var that = {
    start: function() {
      logs = [];
      start_time = (new Date()).getTime();
    },
    log: function(frame, text) {
      logs.push([(new Date()).getTime(), frame.webpage, text]);
    },
    alert: function() {
      var message = "";
      var log = [start_time, "", ""];
      var prev_time = start_time;
      for (var i = 0, len = logs.length; i < len; i++) {
        log = logs[i];
        message += format("[%s] %s: %s\n", log[1], log[2], log[0] - prev_time);
        prev_time = log[0];
      }
      message += format("total: %s", log[0] - start_time);
      setTimeout(function() { alert(message); }, 500);
    }
  };
  return that;
};

var logger = vtop.Logger();
*/
var showSriptError = false; // use on iPendant

/** The table of color definition */
var colorTable = {
  red:        "#B31E23",
  green:      "#00993E",
  orange:     "#EA7000",
  yellow:     "#FEE100",
  darkYellow: "#CAB000",
  gray:       "#A9A9A9",
  lightGray:  "#DDDDDD",
  lightRed:   "#FF0000",
  lightGreen: "#00FF00",
  skyBlue:    "#0E6EB8",
  black:      "#000000",
  white:      "#FFFFFF"
};

var isModernBrowser = (typeof window.addEventListener !== "undefined");
var vtop = getVisTop(window);
var unloadEvent;

/** Get the vision data name. */
function getDataName() {
  var frame = getFrame('frmDataSetup');
  return (frame && frame.dataName !== undefined) ? frame.dataName :
    isiRProgrammer() ? top.name :
    (vtop.name !== undefined) ? vtop.name : ""; // Special treatment for Visual Tracking and Bin Picking
}

/** Get the vision tool name. */
function getToolName() {
  var frame = getFrame('frmDataSetup');
  return (frame && frame.toolName !== undefined) ? frame.toolName :
    (vtop.toolName !== undefined) ? vtop.toolName : "";
}

/** Get the setup page. */
function getPageName() {
  var frame = getFrame('frmDataSetup');
  return (frame && frame.pageName !== undefined) ? frame.pageName :
    (vtop.pageName !== undefined) ? vtop.pageName : "";
}

/** Set the vision data name. */
function setDataName(dataName) {
  if (getFrame('frmDataSetup')) {
    getFrame('frmDataSetup').dataName = dataName;
  }
}

/** Set the vision tool name. */
function setToolName(toolName) {
  if (getFrame('frmDataSetup')) {
    getFrame('frmDataSetup').toolName = toolName;
  }
}

/** Set the setup page. */
function setPageName(pageName) {
  if (getFrame('frmDataSetup')) {
    getFrame('frmDataSetup').pageName = pageName;
  }
}

/** Get the application name */
function getAppName(appType) {
  switch(appType) {
  case 1: case 7: return "ı]m";
  case 2: return "iRPickTool";
  case 3: return "zAj׳]m";
  case 4: return "M޲z]m";
  case 5: return "ı˸m";
  case 8: return "Yɵıl";
  case 9: return "ıl";
  default:  break;
  }
  return "";
}

/**
 * Return a function which is invoked after it stops bein called.
 * @param {Function} func Function to check the condition is met.
 * @param {Number} time Time interval.
 */
function debounce(func, time) {
  var timeoutId = null,
      context, args;
  var delayedFunc = function() {
    timeoutId = null;
    func.apply(context, args);
  };
  return function() {
    context = this;
    args = arguments;
    clearTimeout(timeoutId);
    timeoutId = setTimeout(delayedFunc, time);
  };
}

/**
 * Wait until the condition is met
 * @param {Function} cond Function to check the condition is met.
 * @param {Number} interval Time interval to check the condition.
 * @param {Number} maxCount Maximum number of times to check the condition.
 * @param {Function} body Function to be exected when the condtion is met.
 */
function waitUntil(cond, interval, maxCount, body) {
  if (cond()) {
    body();
  }
  else {
    if (maxCount <= 0) return;
    setTimeout(function() {
      waitUntil(cond, interval, maxCount - 1, body);
    }, interval);
  }
}

/**
 * Wait until all frames are loaded
 * @param {Array} frames frames to be checked whether it has been loaded.
 * @param {Function} body Function to be exected when the condtion is met.
 */
function waitFramesLoaded(frames, body) {
  var numFrames = frames.length,
      count = 0;

  var checkLoaded = function(event) {
    count++;
    if (count >= numFrames) {
      body();
      for (var i = 0; i < numFrames; i++) {
        removeEventHandler(frames[i], 'load', checkLoaded);
      }
    }
  };

  for (var i = 0; i < numFrames; i++) {
    addEventHandler(frames[i], "load", checkLoaded);
  }
}

function removeLastUndefined(array) {
  if (array[array.length - 1] === undefined) {
    array.pop();
  }
}

function getVisTop(frame) {
  if (!isiRProgrammer()) return top;
  function isDescendant(upper, frame) {
    if (!frame) return false;
    var currFrame = frame;
    while (currFrame != upper && currFrame != currFrame.parent) {
      currFrame = currFrame.parent;
    }
    return (currFrame == upper); // Do not use !== for this checking.
  }
  var names = ["prim", "dual", "third"];
  for (var i = 0, len = names.length; i < len; i++) {
    if (isDescendant(top.mainfrm[names[i]], frame)) {
      return top.mainfrm[names[i]];
    }
  }
  return top.mainfrm[names[0]]; // FIXME: should return null
}

function inCGTPFrame(frame) {
  function isDescendant(upper, frame) {
    if (!frame) return false;
    var currFrame = frame;
    while (currFrame != upper && currFrame != currFrame.parent) {
      currFrame = currFrame.parent;
    }
    return (currFrame == upper); // Do not use !== for this checking.
  }
  if (!top.mainfrm) return false;
  var names = ["prim", "dual", "third"];
  for (var i = 0, len = names.length; i < len; i++) {
    if (isDescendant(top.mainfrm[names[i]], frame)) {
      return true;
    }
  }
  return false;
}

/** Get frame from top frame */
function getFrame(name) {
  return getFrame2(vtop, name);
}

/** Get frame from specified frame */
function getFrame2(rootFrame, name) {
  var frame = rootFrame,
      names = name.split('.');
  for (var i = 0, len = names.length; i < len; i++) {
    frame = frame[names[i]];
    if (!frame) return null;
    if (frame.contentWindow) frame = frame.contentWindow;
  }
  return frame;
}

/**
 * Convert raw URL to version URL.
 *  ex) http://ipaddress/frh/vision/page.htm?param1=value1&param2=value2#hash1#hash2
 */
function convertToVersionURL(url) {
  var version = "version=" + UIFComponents.global.version;
  if (isiRProgrammer() && url.indexOf("/frh/vision/") !== 0) {
    url = "/frh/vision/" + url;
  }
  if (url.indexOf('?') >= 0) {
    return url.replace(/\?/, '?' + version + '&');
  }
  else if (url.indexOf('#') >= 0) {
    return url.replace(/#/, '?' + version + '#');
  }
  else {
    return url + '?' + version;
  }
}

/** Convert version URL to raw URL. */
function convertToRawURL(url) {
  var parts = url.split('?');
  return parts[0];
}

/** Load specified page with version to frame. */
function loadVersionPage(frame, page) {
  if (!frame.location) frame = frame.contentWindow;
  frame.location = convertToVersionURL(page);
}

function loadErrorPage(error) {
  var frame = getFrame("frmDataList");
  if (!frame) frame = window;
  loadVersionPage(frame, format('vserrx.stm?_code=%s', error));
}

/** Get text from response.*/
function getResponseText(response) {
  function escapeScript(script) {
    return script.replace(/\\/g, '\\\\')
                 .replace(/[\n\r]/g, '\\n')
                 .replace(/\'/g, "\\'");
  }
  var script = response.text ? response.text : response.firstChild.textContent;
  if (showSriptError) {
    script = format("try {%s} catch(e) {alert(e.name + ': ' + e.message + '\\n' + '%s');}", script, escapeScript(script));
  }
  return script;
}

/** Load specified page to frame. If the page have been already loaded, it is refreshed.*/
function loadPage(frame, page) {
  if (frame.location.href.indexOf(page) == -1) {
    loadVersionPage(frame, page);
  }
  else {
    VTRNRequest(frame, {request: "refresh"}).send();
  }
}

/**
 * Load specified page to frame when tree is clicked.
 * @deprecated This function is obsolete. Do not use this function.
 */
function loadPageOnClick(frame, page, onclick) {
  if (frame.location.href.indexOf(page) == -1) {
    loadVersionPage(frame, page);
    onclick();
  }
  else {
    onclick();
    window.setTimeout(function() {
      VTRNRequest(frame, {request: "refresh"}).send();
    }, 0);
  }
}

/** make string replaced %s in fmt with arguments */
function format(fmt) {
  var i = 0;
  var args = arguments;
  return fmt.replace(/%s/g, function(word) { i++; return args[i]; });
}

function getIEVersion(userAgent) {
  var result = userAgent.match(/MSIE +([\d.]+);/);
  if (result === null) {
    result = userAgent.match(/rv:([\d.]+)/);
  }
  if (result !== null) {
    return parseFloat(result[1]);
  }
  return -1;
}

/** check if the browser is supported. */
function isSupportedBrowser(useIDC) {
  if (isiPendant()) return true;
  var userAgent = window.navigator.userAgent;
  var version = getIEVersion(userAgent);
  if (version < 0) return true; // not IE
  if (version < 7) return false;
  if (useIDC && userAgent.match(/\sWin64;/)) return false;
  return true;
}

function isOldIE() {
  var IEVersion = getIEVersion(window.navigator.userAgent);
  return (IEVersion > 0 && IEVersion < 10);
}

/** check if IDC is compatible and robot is added to Trusted Sites */
function checkIDCVersAndTrustedSite(compatibleGVN) {
  if (isiPendant()) return true; // version already checked on server side, no Trusted Site issue
  if (!isOldIE()) return true;
  var idIDC = "IDC",
      doc = document,
      idcVersion = null,
      idcVersionOK = false,
      objIDC = null;
  try {
    objIDC = doc.getElementById(idIDC);
    if (objIDC === null) {
      var div = doc.createElement("div");
      appendActiveXControl(div, "3B148695-E1D8-4B6C-9BEE-57B7389BDCD9", idIDC, 1, 1);
      objIDC = div.firstChild;
    }
  } catch (err) {}

  if (objIDC !== null) {
    idcVersion = objIDC.Version;
  }

  if ((objIDC === null) || (idcVersion === undefined) || (idcVersion === null)) {
    // Need to install IDC
    loadVersionPage(window, 'vsinst.stm?_code=2');
    return false;
  }

  // IDC version
  if (idcVersion !== null && idcVersion !== undefined) {
    var parseGVN = function(version) {
      var vers = /V\d+\.\d{2}\d+\.(\d+)/.exec(version);
      return (vers == null) ? 0 : parseInt(vers[1], 10);
    };
    if (parseGVN(idcVersion) >= parseInt(compatibleGVN, 10)) {
      idcVersionOK = true;
    }
  }
  if (!idcVersionOK) {
    // Check Automatic Crash Recovery if possible
    var autoRecoverEnabled = false;
    try {
      var autoRecoverSetting = objIDC.QueryIESetting("AutoRecover");
      autoRecoverEnabled = (autoRecoverSetting == "1");
    }
    catch (err) {
      loadVersionPage(window, 'vsinst.stm?_code=4');
      return false;
    }
    if (autoRecoverEnabled) {
      // Show install page with AutoRecoverSetting message
      loadVersionPage(window, 'vsinst.stm?_code=3');
    }
    else {
      loadVersionPage(window, 'vsinst.stm?_code=1');
    }
    return false;
  }
  // Trusted Site check
  if (objIDC.IsTrustedSiteA(window.location.host, window.location.protocol) != 1) {
    loadVersionPage(window, 'vserrx.stm?_code=8');
    return false;
  }
  return true;
}

/** attatch refresh function to the onload event for the specified frame */
function attachRefreshEvent(frame) {
  function refresh() {
    VTRNRequest(frame, { request: "refresh" }).send();
  }
  addEventHandler(frame, "load", refresh);
  KeyEvent.attachHandlers(frame);
  addBodyClass(frame.document.body);
}

function initGuideIDC(frame, name) {
  waitFramesLoaded([getFrame2(frame, name)], function() {
    var idcFrame = getFrame2(frame, name);
    idcFrame.webpage = frame.webpage;
    idcFrame.sendIDCSize();
    addBodyClass(idcFrame.document.body);
  });
}

function initGuideFrame(frame) {
  addEventHandler(frame, "DOMContentLoaded", function() {
    addBodyClass(frame.document.body); // Without this line, imageViewer sends incorrect size when initialized.
  });
}

/** Refresh and reveal frame */
function refreshAndReveal(frame) {
  VTRNRequest(frame, {request: "refresh"}).send(function(response) {
    try {
      (function(){eval(getResponseText(response));})();
    }
    finally {
      var body = frame.document.body;
      body.tabIndex = -1;
      removeClass(body, "hide");
      addBodyClass(body);
    }
  });
}

function addBodyClass(body) {
  if (body == null || body == undefined) return;
  var classes = [];
  if (isCRXMode()) {
    classes.push("crxmode");
  }
  if (isWebView()) {
    classes.push("web-view");
  }
  if (isiRProgrammer()) {
    classes.push("irprog");
  }
  if (classes.length > 0) {
    addClasses(body, classes.join(" "));
  }
}

/** attatch onclick event handler to the frame in CGTP window */
function attachCGTPClickEvent(frame, device) {
  addEventHandler(frame.document.body, "click", function(event) {
    VTRNRequest(window, {webpage: "vslink", request: "focus", value: device}).send(function(response) {
      try {
        (function(){
          var top = window;
          eval(getResponseText(response));
        })();
      }
      finally {
        // avoid the problem that soft keyboard does not appear.
        UIFComponents.global.selectedTextbox = null;
      }
    });
    return true;
  });
}

/**
 * Initiazlie only setup frame.
 * This function is available if the parent frame does not have result frame.
 */
function initOnlySetupFrame(frame, resultPageName) {
  function refreshSetupFrame() {
    refreshAndReveal(frame);
    /* prevent memory leak */
    removeEventHandler(frame, 'load', refreshSetupFrame);
  }
  addEventHandler(frame, "load", refreshSetupFrame);

  KeyEvent.attachHandlers(frame);
}

/**
 * Define function initResultFrame and initSetupFrame in frameDataSetup.
 */
function defineResultSetupFuncs(frameDataSetup) {
  var refreshWhenLoaded;

  frameDataSetup.initResultFrame = function(frame) {
    function onresize() {
      var doc = frame.document,
          body = doc.body,
          left  = doc.getElementById("resultLeft"),
          right = doc.getElementById("resultRight");
      if (isCRXMode()) return;
      if (left !== null && right !== null) {
        right.style.width = Math.max(body.offsetWidth - left.offsetWidth - 1, 0) + "px"; // css calc() cannot be used on old browser.
      }
    }
    function onload() {
      var body = frame.document.body;
      body.tabIndex = -1;
      addBodyClass(body);
      onresize();
    }
    if (refreshWhenLoaded != undefined) {
      addEventHandler(frame, "load", refreshWhenLoaded);
    }
    addEventHandler(frame, "load", onload);
    addEventHandler(frame, "resize", onresize);
    KeyEvent.attachHandlers(frame);
  };

  frameDataSetup.initSetupFrame = function(frame, resultPageName) {
    var body = frameDataSetup.document.body,
        frmImageDisplay = getFrame2(frameDataSetup, 'frmImageDisplay'),
        count = 0;
    refreshWhenLoaded = function() {
      count++;
      if (count === 2) { /* If this function is called from frmSetup and frmResults */
        refreshAndReveal(frame);
        frame.alreadyLoaded = true;

        if (frmImageDisplay && frmImageDisplay.document.body) {
          frmImageDisplay.refreshOnAppear();
        }
        /* prevent memory leak */
        removeEventHandler(frame, 'load', refreshWhenLoaded);
        refreshWhenLoaded = undefined;
      }
    };
    if (resultPageName === null ||
        resultPageName === getFrame2(frameDataSetup, 'frmResults').webpage) {
      refreshWhenLoaded();
    }
    else {
      loadVersionPage(getFrame2(frameDataSetup, 'frmResults'), resultPageName + ".htm");
    }
    turnOnOffClass(body, "result-hide", (resultPageName === null));
    if (frmImageDisplay && frmImageDisplay.document.body) {
      turnOnOffClass(frmImageDisplay.document.body, "result-hide", (resultPageName === null));
      // frmImageDisplay.refreshOnAppear();
    }

    if (frame.alreadyLoaded) {
      refreshWhenLoaded();
    }
    else {
      addEventHandler(frame, "load", refreshWhenLoaded);
      KeyEvent.attachHandlers(frame);
    }
    addClass(frame.document.body, 'setupBody');
  };
}

/** get function key frame */
function getFuncKeyFrame() {
  var frame;
  frame = vtop.document.getElementById('frmDataSetup');
  if (frame !== null) {
    return frame.contentWindow;
  }

  frame = vtop.document.getElementById('frmDataList');
  if (frame !== null) {
    return frame.contentWindow;
  }
  return top;
}

/** Check if the object is Window */
function isWindow(object) {
  return (typeof object === 'object') && ('self' in object);
}

/** Check if the frame still exists. */
function isFrameExist(frame) {
  var currFrame = frame;
  while (currFrame != window && currFrame != currFrame.parent) {
    currFrame = currFrame.parent;
  }
  return (currFrame == window); // Do not use !== for this checking.
}

function cumulativeFrameOffset(frame) {
  var currFrame = frame,
      offset = {left: 0, top: 0},
      parentFrame;
  while (currFrame != window && currFrame != currFrame.parent) {
    parentFrame = currFrame.parent;
    var iframes = parentFrame.document.getElementsByTagName("iframe");
    for (var i = 0, len = iframes.length; i < len; i++) {
      if (iframes[i].contentWindow == currFrame) { // === cannot be used.
        offset.left += cumulativeOffsetLeft(iframes[i]);
        offset.top += cumulativeOffsetTop(iframes[i]);
        break;
      }
    }
    currFrame = parentFrame;
  }
  return offset;
}

/**
 * add event handlers to 'divTabBegin' and 'divTabEnd' to avoid IE bug that
 * focus can be out of range in which key event can be handled.
 */
function initTabBeginEnd(frame) {
  var skipped = false,
      doc = frame.document,
      divTabBegin = doc.getElementById('divTabBegin'),
      divTabEnd = doc.getElementById('divTabEnd');

  attachHandlersToSkip(divTabBegin, divTabEnd, true);
  attachHandlersToSkip(divTabEnd, divTabBegin, false);

  function attachHandlersToSkip(targetNode, nextNode, skipUp) {
    addEventHandler(targetNode, "focus", function(event) {
      if (skipped) {
        skipped = false;
      }
      else {
        skipped = true;
        nextNode.focus();
      }
      return true;
    });
    addEventHandler(targetNode, "keydown", function(event) {
      if (event.keyCode === 9 && event.shiftKey === skipUp) {
        skipped = true;
        nextNode.focus();
        return false;
      }
      return true;
    });
  }
}

/**
 * Insert child node before iframe "divTabEnd"
 * @param {Node} parentNode The node to which child node is appended
 * @param {Node} childNode The node which is appended to parent node
 */
function insertBeforeTabEnd(parentNode, childNode) {
  var divTabEnd = null;
  if (parentNode.tagName === 'BODY') {
    divTabEnd = parentNode.ownerDocument.getElementById("divTabEnd");
  }
  if (divTabEnd !== null) {
    parentNode.insertBefore(childNode, divTabEnd);
  }
  else {
    parentNode.appendChild(childNode);
  }
}

function setIFrameOnLoad(iframe, callback) {
  if (isModernBrowser) {
    iframe.onload = function () {
      callback(this);
      this.onload = null;
    };
  }
  else {
    iframe.onreadystatechange = function () {
      if (this.readyState === "complete") {
        callback(this);
        this.onreadystatechange = null;
      }
    };
  }
}

/**
 * Append iframe to the specified frame
 * @param {Window or Node} object The object on which message frame is appended
 * @param {String} page The page URL
 * @param {String} className The class name defineing frame position and size
 * @param {Function} initialize The function to initialize the message frame
 * @return IFrame
 */
function appendFrame(object, page, className, initialize) {
  var doc, parentNode, div, iframe, onload;

  if (isWindow(object)) {
    doc = object.document;
    parentNode = doc.body;
  }
  else {
    doc = object.ownerDocument;
    parentNode = object;
  }

  div = doc.createElement('div');
  div.className = className;

  iframe = doc.createElement('iframe');
  iframe.src = convertToVersionURL(page);
  iframe.scrolling = "no";
  iframe.frameBorder = "0";
  setIFrameOnLoad(iframe, function(iframe) {
    if (typeof initialize === "function") initialize(iframe);
    KeyEvent.attachHandlers(iframe.contentWindow);
    addBodyClass(iframe.contentWindow.document.body);
  });
  div.appendChild(iframe);
  insertBeforeTabEnd(parentNode, div);

  return iframe;
}

/**
 * Remove iframe
 * @param {IFrame} iframe The iframe removed
 */
function removeFrame(iframe) {
  var div = iframe.parentNode;
  iframe.contentWindow.close();
  iframe.src = "";
  div.removeChild(iframe);
  div.parentNode.removeChild(div);
}

function openPopupPage(page, id, right) { // right = TRUE, popup message to right pane.
  var frmDataSetup = getFrame('frmDataSetup'),
      divRight = frmDataSetup.document.getElementById("divPaneRight"),
      iframe = frmDataSetup.document.getElementById(id);
  if (iframe === null) {
    iframe = appendFrame(right ? divRight : frmDataSetup, page, "popup-frame", null);
    iframe.id = id;
    iframe.allowTransparency = true;
  }
  else {
    iframe.src = convertToVersionURL(page);
    setIFrameOnLoad(iframe, function(iframe) {
      addBodyClass(iframe.contentWindow.document.body);
      KeyEvent.attachHandlers(iframe.contentWindow);
    });
  }
}

function closePopupPage(id) {
  var iframe = getFrame('frmDataSetup').document.getElementById(id);
  if (iframe !== null) {
    removeFrame(iframe);
  }
}

function isIDCShown(frame) {
  if (frame && frame.ctlImageDisplay1) {
    return !frame.isIDCHidden();
  }
  return false;
}

function bindEnterToClickEvent(id, frame) {
  KeyEvent.addHandler(function(event) {
    if (event.keyCode === 13) {
      frame.document.getElementById(id).click();
      return false;
    }
    return true;
  }, frame, false);
}

/** Key handler to block key event occured on a popup frame. */
function blockKeysPopupFrame(event) {
  switch (event.keyCode) {
  case 9: // up or down
  case 33: // shift + up
  case 34: // shift + down
  case 38: // keyboard up or shift-up
  case 40: // keyboard down or shift-down
  case 13: // enter
  case 32: // space
    return false;
  default:
    return true;
  }
}

function popupMessage(frmMain, messageId, refresh, create, handle) {
  if (frmMain === null) return;
  if (popupMessage.messages[messageId]) return;

  popupMessage.messages[messageId] = true;

  var initialize = function(iframe) {
    var frame = iframe.contentWindow,
        doc = frame.document;
    var onclick = function(type, page, name, selected) {
      setTimeout(function() {
        delete popupMessage.messages[messageId];
        handle(iframe, page, name);
      }, 0);
    };
    for (var i = 1; i <= 5; i++) {
      doc.getElementById('F' + i).refresh({}, null, false, onclick);
    }
    refresh(frame);

    KeyEvent.addHandler(blockKeysPopupFrame, frame, false);
  };

  create(initialize);
}
popupMessage.messages = {};

function popupMessageOnIDC(frmMain, messageId, refresh, create, handle) {
  var wasIDCShown = false;

  var createOnIDC = function(initialize) {
    create(initialize);
    wasIDCShown = isIDCShown(frmMain.frmImageDisplay);
    if (wasIDCShown) {
      frmMain.frmImageDisplay.hideShowIDC(false);
    }
  };
  var handleOnIDC = function(iframe, page, name) {
    handle(iframe, page, name);
    if (wasIDCShown) {
      frmMain.frmImageDisplay.hideShowIDC(true);
    }
  };
  popupMessage(frmMain, messageId, refresh, createOnIDC, handleOnIDC);
}

/**
 * Display user specified message.
 * @param {String} message The message displayed in popup window
 * @param {Function} callback callback function called when message frame is removed.
 * @param {String} image image file name shown in message.
 */
function alertMessage(message, callback, image) {
  var frmMain = getFuncKeyFrame();
  if (frmMain === null || findDescendant(frmMain.document, 'div', 'func-keys') === null) {
    // For the pages in CGTP such as Vision Config.
    alert(message);
    if (typeof callback === 'function') {
      callback();
    }
    return;
  }

  var refresh = function(frame) {
    frame.doc.getElementById("lblMessage").refresh(message, null, false);
    frame.doc.getElementById('F4').refresh({}, null, false);
    if (image) {
      var illust = frame.doc.getElementById("imgIllust");
      removeClass(illust, "hide");
      illust.refresh(image);
    }
  };
  var create = function(initialize) {
    var iframe = appendFrame(frmMain, "vsalrt.stm", "popup-frame", initialize);
    iframe.allowTransparency = true;
  };
  var handle = function(iframe, page, name) {
    removeFrame(iframe);
    if (typeof callback === 'function') {
      callback();
    }
  };
  popupMessageOnIDC(frmMain, message, refresh, create, handle);
}

/**
 * Confirm with user specified message.
 * @param {String} webpage The webpage name from which confirm event is fired.
 * @param {String} message The message displayed in popup window
 * @param {String} id The id to be used as request parameter
 * @param {Number} value The value that is sent back when OK clicked
 * @param {Function} refresh The function to initialize function keyes
 */
function confirmMessage(webpage, message, id, value, refresh, frameId) {
  var frmMain = getFuncKeyFrame(),
      messageId = format("%s&%s&%s", webpage, id, value || "");

  var refreshAll = function(frame) {
    frame.document.getElementById("lblMessage").refresh(message, null, false);
    refresh(frame);
  };
  var create = function(initialize) {
    var iframe = appendFrame(frmMain, "vscnfm.stm", "popup-frame", initialize);
    iframe.allowTransparency = true;
    if (frameId) {
      iframe.id = frameId;
    }
  };
  var handle = function(iframe, page, name) {
    var frame = iframe.contentWindow;
    VTRNRequest(frame, { webpage: page, request: name + '.clicked', value: value }).send();
    removeFrame(iframe);
  };
  popupMessageOnIDC(frmMain, messageId, refreshAll, create, handle);
}

/**
 * Confirm with user specified message on right frame.
 * @param {String} webpage The webpage name from which confirm event is fired.
 * @param {String} message The message displayed in popup window
 * @param {String} id The id to be used as request parameter
 * @param {Number} value The value that is sent back when OK clicked
 * @param {Function} refresh The function to initialize function keyes
 */
function confirmMessageRight(webpage, message, id, value, refresh, frameId) {
  var frmMain = getFuncKeyFrame(),
      messageId = format("%s&%s&%s", webpage, id, value || ""),
      docMain = frmMain.document,
      bodyMain = docMain.body,
      divRight = docMain.getElementById("divPaneRight"),
      divMessage;

  if (divRight === null) return;

  var create = function(initialize) {
    var iframe = appendFrame(frmMain, "vsfkcn.stm", "funckeys-frame message-right", function(iframe) {
      var frame = iframe.contentWindow;
      addClass(frame.document.getElementById("funcKeys"), "func-key-popup");
      initialize(iframe);
    });
    if (frameId) {
      iframe.id = frameId;
    }
    divMessage = docMain.createElement('div');
    divMessage.className = 'popup-right';
    message = message.replace(/\n/g, '<br>');
    divMessage.innerHTML = format('<div class="message-background"></div><div class="message-box"><label>%s</label></div>', message);
    divRight.appendChild(divMessage);
    addClass(bodyMain, "setup-hide");
  };
  var handle = function(iframe, page, name) {
    var frame = iframe.contentWindow;
    VTRNRequest(frame, { webpage: page, request: name + '.clicked', value: value }).send();
    removeFrame(iframe);
    divRight.removeChild(divMessage);
    removeClass(bodyMain, "setup-hide");
  };
  popupMessage(frmMain, messageId, refresh, create, handle);
}

/**
 * Show help page on popup
 * @param {String} file help file name
 */
function showHelpPage(file) {
  var frmMain = getFuncKeyFrame();
  var refresh = function(frame) {
    frame.doc.getElementById('F4').refresh({}, null, false);
  };
  var create = function(initialize) {
    var iframe = appendFrame(frmMain, format("vshelp.stm?_file=%s", file), "popup-frame", initialize);
    iframe.allowTransparency = true;
  };
  var handle = function(iframe, page, name) {
    removeFrame(iframe);
  };
  popupMessageOnIDC(frmMain, file, refresh, create, handle);
}

/**
 * Call encodeURIComponent only for characters in the string that are <= 127 to
 * avoid garbling the shfit_jis characters.
 */
function encodeURIComponentLocal(string) {
  var charArray = [], chr;

  for (var i = 0, len = string.length; i < len; i++) {
    chr = string.charAt(i);
    if (chr.charCodeAt(0) <= 127) {
      chr = encodeURIComponent(chr);
    }
    else {
      if (UIFComponents.global.encoding === "Latin1") {
        chr = "%" + chr.charCodeAt(0).toString(16);
      }
    }
    charArray.push(chr);
  }
  return charArray.join("");
}

/** Tell the web server that a text in the textbox has been changed */
function notifyTextboxChanged(elem, value, operation, config) {
  var frame, params, encodedValue;

  encodedValue = encodeURIComponentLocal(value);
  frame = getDefaultView(elem.ownerDocument);
  params = {request: elem.id + ".changed", value: encodedValue};
  if (operation !== undefined) params.operation = operation;

  if ((config.callback !== undefined) && (typeof config.callback === 'function')) {
    config.callback(elem.id, "changed", value);
  }
  else {
    VTRNRequest(frame, params).send(function (response) {
      (function () { eval(getResponseText(response)); })();
      var textbox = UIFComponents.global.selectedTextbox;
      if (textbox !== null) {
        try { textbox.select(); } catch (e) { }
      }
    });
  }
}

var SFVTRN_function_codes = {
  HCFC_CGTPLOGIN_C:       "0x43000f",
  HCFC_CGTPLOGOUT_C:      "0x430017",
  HCFC_FORCELOGOUT_C:     "0x43001E",
  HCFC_CGTPINIT_C:        "0x430018",
  HCFC_CGTPVERS_C:        "0x430019",
  HCFC_VERIFYLOGIN_C:     "0x43001F",
  HCFC_ACCEPTUPDT_C:      "0x430020",
  HCFC_DECLINEUPDT_C:     "0x430021",
  HCFC_SFVTRN_CALLBACK_C: "0x430023"
};

/**
 * Construct a request object to sfvtrn.
 * @param {String} fcode The function code
 * @param {Array} params The parameters of URL
 * @return A new url object.
 */
function SFVTRNRequest(fcode, params) {
  var send = function(callback) {
    var xmlhttp = new window.XMLHttpRequest();
    xmlhttp.open("GET", this.toString(), false);
    try {
      xmlhttp.send(null);
    }
    catch (err) {
      alert("ı]mwg_sC");
      window.close();
      xmlhttp = null;
      return;
    }
    if (xmlhttp.status === 200) {
      var response = xmlhttp.responseXML;
      if (typeof callback === 'function') {
        callback(response);
      }
      else {
        (function(){eval(getResponseText(response));})();
      }
    }
    else {
      alert("ı]mwg_sC");
      window.close();
    }
    xmlhttp = null;
  };

  var sendAsync = function(callback, timeout) {
    var xmlhttp = new window.XMLHttpRequest();
    timeout = timeout || 10000;

    var timer = setTimeout(function() {
      xmlhttp.onreadystatechange = null;
      xmlhttp.abort();
      xmlhttp = null;
      alert("ı]mwg_sC");
      window.close();
     }, timeout);

    xmlhttp.onreadystatechange = function() {
      if (xmlhttp.readyState === 4) {
        if (timer !== null) clearTimeout(timer);

        var response = xmlhttp.responseXML;
        if (typeof callback === 'function') {
          callback(response);
        }
        else {
          (function(){eval(getResponseText(response));})();
        }
        xmlhttp.onreadystatechange = null;
        xmlhttp = null;
      }
    };

    xmlhttp.open("GET", this.toString(), true);
    xmlhttp.send(null);
  };

  // To avoid webpage closed before sending the request, use Fetch keepalive flag to perform the request background
  var sendFetch = function(callback) {
    window.fetch(this.toString(), {
      method: "GET",
      keepalive: true
    }).then(function(response){
      if (typeof callback === 'function') {
        callback(response);
      }
    });
  };

  var toString = function() {
    var array = ["/SOFTPART/SFVTRN?fc=" + SFVTRN_function_codes[fcode]];
    for (var i = 0, len = params.length; i < len; i++) {
      array.push("=" + params[i]);
    }
    return array.join("&");
  };

  /////////public functions//////////
  var that = {};
  that.send = send;
  that.sendAsync = sendAsync;
  that.sendFetch = sendFetch;
  that.toString = toString;

  return that;
}

/** Add loading indicator to the window from which this script is loaded. */
function addLoadingIndicator() {
  var div = document.createElement("div");
  div.id = "loading";
  div.className = "hide";
  div.innerHTML = '<span>Bz...</span><img src="images/loading.gif" align="absmiddle" />';
  var numConnections = 0;
  div.start = function() {
    numConnections++;
    removeClass(this, "hide");
  };
  div.finish = function() {
    numConnections--;
    if (numConnections <= 0) {
      addClass(this, "hide");
    }
  };
  document.body.appendChild(div);

  div = null; // avoid circular reference
}

function appendActiveXControl(elem, classID, id, width, height) {
  elem.innerHTML = format('<object classid="clsid:%s" id="%s" height="%spx" width="%spx" tabindex="-1"></object>', classID, id, width, height);
}

/** SIP keyboard manager */
var SIPManager = {
  init: function() {
    if (isiPendant()) {
      var doc = document,
          div = doc.createElement("div");
      appendActiveXControl(div, "ECC1F43C-6B1E-4E74-AAED-62395D3597C1", "SIPManager", 1, 1);
      doc.body.appendChild(div);
      doc.getElementById("SIPManager").AutoDeployKeyboard = false;
    }
  },
  terminate: function() {
    if (isiPendant()) {
      document.getElementById("SIPManager").AutoDeployKeyboard = true;
    }
  },
  hideKeyboard: function() {
    var sipm = document.getElementById("SIPManager");
    if (sipm !== null) {
      sipm.HideKeyboard();
    }
  },
  showKeyboard: function() {
    var sipm = document.getElementById("SIPManager");
    if (sipm !== null) {
      sipm.ShowKeyboard();
    }
  }
};

/**
 * Construct a request object.
 * @param {Window} frame The frame from which request is sent
 * @param {Object} params The parameters of URL
 * @config {String} [webpage = frame.webpage]
 * @config {String} request
 * @config {String} [value]
 * @return A new url object.
 */
function VTRNRequest(frame, params) {
  params["webpage"]  = params["webpage"]  || frame.webpage;
  params["dataname"] = params["dataname"] || getDataName();
  params["toolname"] = params["toolname"] || getToolName();

  var globalReqParams = vtop.globalReqParams;
  if (globalReqParams !== undefined) {
    params["apptype"] = globalReqParams.appType;
    params["connectid"] = globalReqParams.connectId;
  }
  if (!("connect_id" in params) && typeof top.g_connect_id !== 'undefined') {
    params.connect_id = top.g_connect_id; // for iRProgrammer
  }

  var procResponse = function(xmlhttp, callback) {
    var response;

    if (xmlhttp.status === 200) { // success
      response = xmlhttp.responseXML;
      if (typeof callback === 'function') {
        callback(response);
      }
      else {
        (function(){eval(getResponseText(response));})();
      }
    }
    else { // fail
      if (typeof callback === 'function') {
        callback(null);
      }
      else {
        // alertMessage is not used because vsalrm.htm might not be available
        alert("LksC");
      }
    }
  };

  var sendAsync = function(callback, options) {
    var loading = (options !== undefined && options.noIndicator === true) ? null : document.getElementById("loading"),
        xmlhttp = new window.XMLHttpRequest(),
        timer = null;

    if (options !== undefined && typeof options.timeout === 'number') {
      timer = setTimeout(function() {
        xmlhttp.onreadystatechange = null;
        xmlhttp.abort();
        xmlhttp = null;
        if (loading !== null) loading.finish();
        if (typeof options.timeoutHandler === "function") {
          options.timeoutHandler();
        }
      }, options.timeout);
    }

    if (loading !== null) loading.start();

    xmlhttp.onreadystatechange = function() {
      if (xmlhttp.readyState === 4) {
        if (loading !== null) loading.finish();
        if (timer !== null) clearTimeout(timer);

        procResponse(xmlhttp, callback);

        xmlhttp.onreadystatechange = null;
        xmlhttp = null;
      }
    };
    xmlhttp.open("GET", this.toString(), true);
    xmlhttp.send(null);
  };

  var sendSync = function(callback, options) {
    var loading = (options !== undefined && options.noIndicator === true) ? null : document.getElementById("loading"),
        xmlhttp = new window.XMLHttpRequest();

    if (loading !== null) loading.start();
    xmlhttp.open("GET", this.toString(), false);
    xmlhttp.send(null);

    procResponse(xmlhttp, callback);

    if (loading !== null) loading.finish();
    xmlhttp = null;
  };

  // To avoid webpage closed before sending the request, use Fetch keepalive flag to perform the request background
  var sendFetch = function(callback) {
    window.fetch(this.toString(), {
      method: "GET",
      keepalive: true
    }).then(function(response){
      if (typeof callback === 'function') {
        callback(response);
      }
    });
  };

  var toString = function() {
    var array = [];
    var text;
    for (var key in params) {
      text = params[key];
      if (text !== null && text !== undefined) {
        array.push(key + "=" + text);
      }
    }
    return "/SOFTPART/SFVTRN?" + array.join("&");
  };

  /////////public functions//////////
  var that = {};
  that.send = sendAsync;
  that.sendSync = sendSync;
  that.sendFetch = sendFetch;
  that.toString = toString;

  return that;
}

function SFVTRNRequestCallback(frame, params) {
  params["fc"] = SFVTRN_function_codes.HCFC_SFVTRN_CALLBACK_C;
  return VTRNRequest(frame, params);
}

function triggerEvent(elem, name, attr) {
  var event;
  var setAttribute = function(event, attr) {
    var value;
    for (var key in attr) {
      event[key] = attr[key];
    }
  };
  if (document.createEvent) { // other than IE
    event = document.createEvent("HTMLEvents");
    event.initEvent(name, true, true );
    if (attr) setAttribute(event, attr);
    return elem.dispatchEvent(event);
  }
  else { // IE
    event = document.createEventObject();
    if (attr) setAttribute(event, attr);
    return elem.fireEvent("on" + name, event);
  }
}

/**
 * Find the first element node
 * @param {HTMLElement} Element as a starting point of search. From this element first element is searched.
 */
function firstElementNode(elem) {
  var currElem = elem.firstChild;
  while (currElem) {
    if (currElem.nodeType === 1) return currElem;
    currElem = currElem.nextSibling;
  }
  return null;
}

/**
 * Find next element node
 * @param {HTMLElement} Element as a starting point of search. From this element next element is searched.
 */
function nextElementNode(elem) {
  var currElem = elem.nextSibling;
  while (currElem) {
    if (currElem.nodeType === 1) return currElem;
    currElem = currElem.nextSibling;
  }
  return null;
}

/**
 * Find prev element node
 * @param {HTMLElement} Element as a starting point of search. From this element prev element is searched.
 */
function prevElementNode(elem) {
  var currElem = elem.previousSibling;
  while (currElem) {
    if (currElem.nodeType === 1) return currElem;
    currElem = currElem.previousSibling;
  }
  return null;
}

/**
 * Find first descendant tagName and className of which meet specified value under the specified element.
 * @param {HTMLElement} elem Parent element. Under this element descendant is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findDescendant(elem, tagName, className) {
  var candidates = elem.getElementsByTagName(tagName.toUpperCase());
  className = ' ' + className + ' ';
  for (var i = 0, len = candidates.length; i < len; i++) {
    if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
      return candidates[i];
    }
  }
  return null;
}

/**
 * Find all descendants tagName and className of which meet specified value under the specified element.
 * @param {HTMLElement} elem Parent element. Under this element descendant is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findDescendants(root, tagName, className) {
  var candidates = root.getElementsByTagName(tagName.toUpperCase());
  var selected = [];
  className = ' ' + className + ' ';
  for (var i = 0, len = candidates.length; i < len; i++) {
    if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
      selected.push(candidates[i]);
    }
  }
  return selected;
}


/**
 * Find first ancester tagName and className of which meet specified value.
 * @param {HTMLElement} elem Child element. From this elements ancester is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findAncestor(elem, tagName, className) {
  var top = elem.ownerDocument;
  tagName = tagName.toUpperCase();
  className = ' ' + className + ' ';
  for (var candidate = elem; candidate !== top; candidate = candidate.parentNode) {
    if (candidate.tagName === tagName && (' ' + candidate.className + ' ').indexOf(className) >= 0) {
      return candidate;
    }
  }
  return null;
}

/**
 * Find last ancester tagName and className of which meet specified value.
 * @param {HTMLElement} elem Child element. From this elements ancester is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findLastAncestor(elem, tagName, className) {
  var lastAncestor = null,
      ancestor = elem;
  while (ancestor !== null) {
    ancestor = findAncestor(ancestor.parentNode, tagName, className);
    if (ancestor !== null) {
      lastAncestor = ancestor;
    }
  }
  return lastAncestor;
}

/**
 * Add the new class name to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} className class name to be added to the element.
 */
function addClass(elem, className) {
  var oldClass = elem.className,
      newClass;
  if (!hasClass(elem, className)) {
    newClass = oldClass + ' ' + className;
    newClass = newClass.replace(/^\s+/, '')
                       .replace(/\s+$/, '');
    if (oldClass !== newClass) {
      elem.className = newClass;
    }
  }
}

/**
 * Remove the class name from the specified element.
 * @param {HTMLElement} elem element from which the class name is removed.
 * @param {String} className class name to be removed from the element.
 */
function removeClass(elem, className) {
  var oldClass = elem.className,
      newClass;
  newClass = (' ' + oldClass + ' ').replace(' ' + className + ' ', ' ')
                                   .replace(/^\s+/, '')
                                   .replace(/\s+$/, '');
  if (oldClass !== newClass) {
    elem.className = newClass;
  }
}

/**
 * Add new class names to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} classNames class name to be added to the element.
 */
function addClasses(elem, classNames) {
  var oldClass = elem.className,
      dummyElement = {className: oldClass},
      classes;
  if (!Array.isArray(classNames)) {
    classNames = classNames.replace(/^\s+/, '')
                           .replace(/\s+$/, '');
    classes = classNames.split(/\s+/);
  }
  else {
    classes = classNames;
  }
  for (var i = 0, len = classes.length; i < len; i++) {
    addClass(dummyElement, classes[i]);
  }
  if (dummyElement.className !== oldClass) {
    elem.className = dummyElement.className;
  }
}

/**
 * Remove new class names to the specified element.
 * @param {HTMLElement} elem element to which new class name is removeed.
 * @param {String} classNames class name to be removeed to the element.
 */
function removeClasses(elem, classNames) {
  var oldClass = elem.className,
      dummyElement = {className: oldClass},
      classes;
  if (!Array.isArray(classNames)) {
    classNames = classNames.replace(/^\s+/, '')
                           .replace(/\s+$/, '');
    classes = classNames.split(/\s+/);
  }
  else {
    classes = classNames;
  }
  for (var i = 0, len = classes.length; i < len; i++) {
    removeClass(dummyElement, classes[i]);
  }
  if (dummyElement.className !== oldClass) {
    elem.className = dummyElement.className;
  }
}

/**
 * Replace the class name of the specified element.
 * @param {HTMLElement} elem element from which the class name is removed.
 * @param {String} oldClass class name to be removed from the element.
 * @param {String} newClass class name to be added from the element.
 */
function replaceClass(elem, oldClass, newClass) {
  var oldClasses = elem.className,
      newClasses;
  newClasses = (' ' + oldClasses + ' ').replace(' ' + oldClass + ' ', ' ' + newClass + ' ')
                                       .replace(/^\s+/, '')
                                       .replace(/\s+$/, '');
  if (oldClasses !== newClasses) {
    elem.className = newClasses;
  }
}

/**
 * Check if the specified element has the class name.
 * @param {HTMLElement} elem element to be checed.
 * @param {String} className class name.
 * @return {Boolean} return true if the element has the class name.
 */
function hasClass(elem, className) {
  return ((' ' + elem.className + ' ').indexOf(' ' + className + ' ') >= 0) ? true : false;
}

/**
 * Add or remove the class name to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} className class name to be added to the element.
 * @param {Boolean} on if true the class name is added, otherwise removed.
 */
function turnOnOffClass(elem, className, on) {
  if (on) {
    addClass(elem, className);
  }
  else {
    removeClass(elem, className);
  }
}

/**
 * Add or remove the class name to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} classNames class name to be added to the element.
 * @param {Boolean} on if true the class name is added, otherwise removed.
 */
function turnOnOffClasses(elem, classNames, on) {
  if (on) {
    addClasses(elem, classNames);
  }
  else {
    removeClasses(elem, classNames);
  }
}

/**
 * Add the class name to the specified element and remove the class name from the other descendants.
 * @param {HTMLElement} root root element from which descendants are found.
 * @param {HTMLElement} elem element to be added the class name.
 * @param {String} className class name.
 */
function addClassExclusively(root, elem, className) {
  var tagName = elem.tagName,
      candidates = findDescendants(root, tagName, className);
  for (var i = 0, len = candidates.length; i < len; i++) {
    removeClass(candidates[i], className);
  }
  addClass(elem, className);
}

/**
 * Replace the class name of the specified element and revert the class name for the other descendants.
 * @param {HTMLElement} root root element from which descendants are found.
 * @param {HTMLElement} elem element from which the class name is removed.
 * @param {String} oldClass class name to be removed from the element.
 * @param {String} newClass class name to be added from the element.
 */
function replaceClassExclusively(root, elem, oldClass, newClass) {
  var tagName = elem.tagName,
      candidates = findDescendants(root, tagName, newClass);
  for (var i = 0, len = candidates.length; i < len; i++) {
    replaceClass(candidates[i], newClass, oldClass);
  }
  replaceClass(elem, oldClass, newClass);
}

/**
 * Get the first text node under the specified element.
 * @param {HTMLElement} elem parent element.
 * @return {Text} text node.
 */
function getTextNode(elem) {
  for (var child = elem.firstChild; child !== null; child = child.nextSibling) {
    if (child.nodeType === 3) {
      return child;
    }
  }
  return null;
}

/**
 * Refresh text node of the specified element.
 * @param {HTMLElement} elem parent element which has text node.
 * @param {String} text text which is set to text node.
 * @return {Text} text node.
 */
function refreshText(elem, text) {
  var doc = elem.ownerDocument,
      textNode = getTextNode(elem);
  if (textNode === null) {
    textNode = doc.createTextNode(elem);
    elem.appendChild(textNode);
  }
  if (textNode !== null) {
    textNode.nodeValue = text;
  }
}

/**
 * Get all texts under the specified element.
 * @param {HTMLElement} elem parent element.
 * @return {String} text which is under the element.
 */
function getText(elem) {
  var texts = [];
  var value;
  for (var child = elem.firstChild; child !== null; child = child.nextSibling) {
    if (child.nodeType === 3) {
      value = child.nodeValue;
      if (!(/^[ \n]$/).test(value)) {
        texts.push(value);
      }
    }
  }
  return texts.join('');
}

/**
 * Calculate disatance between specified element top and window top.
 * @param {HTMLElement} elem DOM object.
 */
function cumulativeOffsetTop(elem) {
  var offset = 0;
  do {
    offset += elem.offsetTop;
    elem = elem.offsetParent;
  } while (elem);
  return offset;
}

/**
 * Calculate disatance between specified element left and window left.
 * @param {HTMLElement} elem DOM object.
 */
function cumulativeOffsetLeft(elem) {
  var offset = 0;
  do {
    offset += elem.offsetLeft;
    elem = elem.offsetParent;
  } while (elem);
  return offset;
}

/**
 * Scroll an area object to make a target object visible.
 * @param {HTMLElement} area DOM object containing one element that defines scroll area.
 * @param {HTMLElement} target DOM object containing one element to which area is scrolled.
 * @param {Number} [offset=0] Offset value used when positions of scrollable object and visible area object does not match.
 */
function scrollTo(area, target, offset) {
  if (offset === undefined) offset = 0;

  var areaTop = area.scrollTop + offset,
      areaHeight = area.offsetHeight - offset,
      targetTop, targetHeight;
  if (target == null) {
    targetTop = 0 - cumulativeOffsetTop(area);
    targetHeight = 0;
  }
  else {
    targetTop = cumulativeOffsetTop(target) - cumulativeOffsetTop(area);
    targetHeight = target.offsetHeight;
  }

  if (areaTop > targetTop) {
    area.scrollTop = targetTop - offset;
  }
  else if (areaTop + areaHeight < targetTop + targetHeight) {
    area.scrollTop = targetTop + targetHeight - areaHeight - offset;
  }
}

function scrollToHorizontally(area, target, offset) {
  if (offset === undefined) offset = 0;

  var areaLeft = area.scrollLeft + offset,
      areaWidth = area.offsetWidth - offset,
      targetLeft, targetWidth;
  if (target == null) {
    targetLeft = 0 - cumulativeOffsetLeft(area);
    targetWidth = 0;
  }
  else {
    targetLeft = cumulativeOffsetLeft(target) - cumulativeOffsetLeft(area);
    targetWidth = target.offsetWidth;
  }

  if (areaLeft > targetLeft) {
    area.scrollLeft = targetLeft - offset;
  }
  else if (areaLeft + areaWidth < targetLeft + targetWidth) {
    area.scrollLeft = targetLeft + targetWidth - areaWidth - offset;
  }
}

/**
 * Get next node distant from current node by step.
 * @param {Node} parent parent node.
 * @param {Node} current current node.
 * @param {Number} step distance between current node and next node.
 */
function getNextNode(parent, current, step, loopable) {
  var nextProperty, firstProperty, next, node;
  if (step > 0) {
    nextProperty = 'nextSibling';
    firstProperty = loopable ? 'firstChild' : 'lastChild';
  }
  else {
    nextProperty = 'previousSibling';
    firstProperty = loopable ? 'lastChild' : 'firstChild';
  }

  if (current[nextProperty] === null) {
    next = parent[firstProperty];
  }
  else {
    step = Math.abs(step);
    next = current;
    for (var i = 0; i < step; i++) {
      node = next[nextProperty];
      if (node === null) break;
      next = node;
    }
  }
  return next;
}

/** Handle key event */
var KeyEvent = {
  handlers: [],
  addHandler: function(handler, frame, preventAfter) {
    var that = this;
    if (preventAfter) handler.preventAfter = true;
    if (frame) {
      handler.frameName = frame.webpage;
      addEventHandler(frame, unloadEvent, function () {
        that.removeHandler(handler);
      });
    }
    this.handlers.push(handler);
  },
  popHandler: function() {
    this.handlers.pop();
  },
  addHandlers: function(handlers) {
    Array.prototype.push.apply(this.handlers, handlers);
  },
  removeHandlers: function(frame) {
    var oldHandlers = this.handlers,
        newHandlers = [],
        removedHandlers = [],
        frameName = frame.webpage,
        handler;
    for (var i = 0, len = oldHandlers.length; i < len; i++) {
      handler = oldHandlers[i];
      ((handler.frameName === frameName) ? removedHandlers : newHandlers).push(handler);
    }
    this.handlers = newHandlers;

    return removedHandlers;
  },
  removeHandler: function(handler) {
    var oldHandlers = this.handlers,
        newHandlers = [];
    for (var i = 0, len = oldHandlers.length; i < len; i++) {
      if (oldHandlers[i] !== handler) {
        newHandlers.push(oldHandlers[i]);
      }
    }
    this.handlers = newHandlers;
  },
  handle: function(event) {
    var handlers = KeyEvent.handlers,
        notHandled = true,
        handler;

    if (event.keyCode === 17) return notHandled;
    //    var message = [vtop.format("key:%s ctrl:%s shift:%s", event.keyCode, event.ctrlKey, event.shiftKey)];

    for (var i = handlers.length - 1; i >= 0 && notHandled; i--) {
      handler = handlers[i];
      notHandled = handler(event);
      //      message.push(vtop.format("%s: notHandled: %s", i, notHandled));
      if (handler.preventAfter) break;
    }
    //    if (window.console !== undefined) console.log(message.join("\n"));
    //    alert(message.join("\n"));
    return notHandled;
  },
  attachHandlers: function(frame) {
    addEventHandler(frame.document, "keydown", this.handle);
  }
};

/**
 * get the amount of movement from key event.
 * @param {Event} event key event
 * @return {Number} distance
 */
function keyEventToDistance(event) {
  var dist;
  switch (event.keyCode) {
  case 9: // up and down arrow keys
    dist = event.shiftKey ? -1 : 1;
    break;
  case 33: // shift + up
    dist = -5;
    break;
  case 34: // shift + down
    dist = 5;
    break;
  case 38: // keyboard up or shift-up
    dist = event.shiftKey ? -5 : -1;
    break;
  case 40: // keyboard down or shift-down
    dist = event.shiftKey ? 5 : 1;
    break;
  default:
    dist = 0;
    break;
  }
  return dist;
}

/**
 * attachEvent is supported in IE only
 * addEventHandler is supported in compliant browsers
 */
function addEventHandler(target, event, handler) {
  if (target.attachEvent) {
    target.attachEvent('on' + event, handler);
  }
  else {
    target.addEventListener(event, handler);
  }
}

/**
 * detachEvent is supported in IE only
 * removeEventHandler is supported in compliant browsers
 */
function removeEventHandler(target, event, handler) {
  if (target.detachEvent) {
    target.detachEvent('on' + event, handler);
  }
  else {
    target.removeEventListener(event, handler);
  }
}

/**
 *  defaultView is supported in compliant browsers
 *  parentWindow is supported in IE only
 */
function getDefaultView(doc) {
  if (doc.parentWindow === undefined) {
    /** defaultView is supported in compliant browsers */
    return doc.defaultView;
  }
  else {
    /** parentWindow is supported in IE only*/
    return doc.parentWindow;
  }
}

/**
 *  getComputedStyle is supported in compliant browsers
 *  currentStyle is supported in IE only
 */
function getCurrentStyle(elem) {
  var doc, frame;
  if (elem.currentStyle === undefined) {
    doc = elem.ownerDocument;
    if (doc === null) return null;
    frame = getDefaultView(doc);
    return frame.getComputedStyle(elem);
  }
  else {
    return elem.currentStyle;
  }
}
/**
 *  Change string to boolean
 */
function parseStrToBoolean(str) {
  return (str === 'true') ? true : false;
}

/** replace of setcapture and releaseCapture    **/
function preventGlobalMouseEvents(elem, frame) {
  if (!isModernBrowser) {
    elem.setCapture(false);
  }
  else {
    frame.doc.body.style['pointer-events'] = 'none';
    elem.style['pointer-events'] = 'auto';
  }
}

function restoreGlobalMouseEvents(elem, frame) {
  if (!isModernBrowser) {
    elem.releaseCapture();
  }
  else {
    frame.doc.body.style['pointer-events'] = 'auto';
    elem.style['pointer-events'] = '';
  }
}

function SAMouseUpListener(e) {
  var elem = e.srcElement;

  if (!isModernBrowser &&
      ((new RegExp("^cmpSAMode\.")).test(elem.id))) return true;
  hideshowSAModePage(false);

  if (!isModernBrowser && elem.id == "btnShowSAMode") {
    // This is bad code. But btnShowSAMode cannot close popup without the line.
    turnOnOffClass(elem, "image-button-pressed", true);
  }
  return stopPropagation(e);
}

function stopPropagation(e) {
  if (e.stopPropagation) e.stopPropagation();
  return false;
}

/**
 *  hide and show the simple and advanced mode change page.
 */
function hideshowSAModePage(show) {
  var frame = getFrame('frmDataSetup'),
      doc = frame.doc,
      button = doc.getElementById('btnShowSAMode'),
      complex = doc.getElementById('cmpSAMode');
  turnOnOffClass(button, "image-button-pressed", show);
  turnOnOffClass(complex, "hide", !show);

  // handle mouse events by the following code;
  if (show) {
    preventGlobalMouseEvents(complex, frame);
    addEventHandler(complex, "mouseup", stopPropagation);
    addEventHandler(doc, "mouseup", SAMouseUpListener);
  }
  else {
    restoreGlobalMouseEvents(complex, frame);
    removeEventHandler(complex, "mouseup", stopPropagation);
    removeEventHandler(doc, "mouseup", SAMouseUpListener);
  }
  return false;
}

/**
 *  toggle hide and show of the simple and advanced mode change page.
 */
function toggleSAModePage() {
  var frame = getFrame('frmDataSetup'),
      button = frame.doc.getElementById('btnShowSAMode');
  hideshowSAModePage(!hasClass(button, 'image-button-pressed'));
}

/**
 *  hide or show simple/advanced elements.
 */
function hideshowSAElements(frame, SAMode) {
  var doc = frame.document,
      hasSAElems = false,
      classArray, i, len, elems;

  function changeClass(doc, fromClass, toClass) {
    var changeElems = findDescendants(doc, '*', fromClass);
    for (var i = 0; i < changeElems.length; i++) {
      replaceClass(changeElems[i], fromClass, toClass);
    }
  }

  classArray = [
    'simple', 'simple-hide',
    'simple-only', 'simple-only-hide',
    'wizard-only', 'wizard-only-hide',
    'advanced', 'advanced-hide'
  ];
  for (i = 0, len = classArray.length, hasSAElems = false; i < len && !hasSAElems; i++) {
    if (findDescendants(doc, '*', classArray[i]).length !== 0) {
      hasSAElems = true;
    }
  }

  if (hasSAElems) {
    switch (SAMode) {
    case 3: // wizard mode
      changeClass(doc, 'simple', 'simple-hide');
      changeClass(doc, 'simple-only-hide', 'simple-only');
      changeClass(doc, 'wizard-only-hide', 'wizard-only');
      changeClass(doc, 'advanced', 'advanced-hide');
      break;
    case 1: // simple mode
      changeClass(doc, 'simple-hide', 'simple');
      changeClass(doc, 'simple-only-hide', 'simple-only');
      changeClass(doc, 'wizard-only', 'wizard-only-hide');
      changeClass(doc, 'advanced', 'advanced-hide');
      break;
    default:// advanced mode
      changeClass(doc, 'simple-hide', 'simple');
      changeClass(doc, 'simple-only', 'simple-only-hide');
      changeClass(doc, 'wizard-only', 'wizard-only-hide');
      changeClass(doc, 'advanced-hide', 'advanced');
      break;
    }
  }
  return hasSAElems;
}

/**
 *  hide or show elements is specified as advanced one.
 */
function hideshowAdvanced(SAMode) {
  var frame = getFrame('frmDataSetup'),
      doc = frame.document,
      frmSetup = getFrame2(frame, 'frmSetup'),
      docSetup = frmSetup.document,
      btnShowSAMode = doc.getElementById('btnShowSAMode'),
      btnShowSAModeSwitch = doc.getElementById('btnShowSAModeSwitch'),
      i, len, show, elems;

  var elemSAMode = doc.getElementById('selSAMode');
  if (elemSAMode !== null) {
    var getVal = elemSAMode.getValue();
    if (getVal !== null) {
      SAMode = parseInt(getVal, 10);
    }
    elemSAMode.refresh(null, SAMode, false);
  }

  show = hideshowSAElements(frmSetup, SAMode);

  if (btnShowSAMode !== null) {
    btnShowSAMode.refresh(SAMode === 0 ? 'vsbttn-advanced' : 'vsbttn-simple', false);
    turnOnOffClass(btnShowSAMode, 'hide', !show);
  }
  if (btnShowSAModeSwitch !== null) {
    btnShowSAModeSwitch.refresh(!(SAMode === 0), false);
    // turnOnOffClass(btnShowSAModeSwitch, 'hide', !show);
  }
  elems = [docSetup.body, doc.body];
  for (i = 0, len = elems.length; i < len; i++) {
    turnOnOffClass(elems[i], 'advancedmode', SAMode === 0);
    turnOnOffClass(elems[i], 'simplemode', SAMode === 1);
    turnOnOffClass(elems[i], 'wizardmode', SAMode === 3);
  }
  if (typeof frame.afterHideshowAdvanced === 'function') {
    frame.afterHideshowAdvanced(SAMode);
  }
}

function isSAModeConfigured() {
  var docBody = getFrame('frmDataSetup').document.body;
  return hasClass(docBody, "advancedmode") ||
         hasClass(docBody, "simplemode") ||
         hasClass(docBody, "wizardmode");
}

/**
 *  open alert message when simple mode is not set.
 */
function confirmDefaultSAMode() {
  var page = "vsalsl.stm",
      frmMain = getFuncKeyFrame();
  var refresh = function(frame) {
    frame.doc.getElementById("selDefSAMode").refresh(null, 1, false);
  };
  var create = function(initialize) {
    var iframe = appendFrame(frmMain, page, "popup-frame", initialize);
    iframe.allowTransparency = true;
  };
  var handle = function (iframe, page, name) {
    var frame = iframe.contentWindow,
        value = frame.doc.getElementById("selDefSAMode").getValue();
    VTRNRequest(frame, {request: name + '.clicked', value: value}).send();
    removeFrame(iframe);
  };
  popupMessageOnIDC(frmMain, page, refresh, create, handle);
}

function hideshowParentRow(frame, id, show) {
  var elem = frame.document.getElementById(id),
      rowParent = findAncestor(elem, 'tr', 'row-item');
  turnOnOffClass(rowParent, "hide", !show);
}

function getIDCFrame() {
  var frame = getFrame('frmDataSetup.frmWizard.frmWizardMain.frmImageDisplay');
  if (frame !== null) return frame;
  return getFrame('frmDataSetup.frmImageDisplay');
}

function deleteAllChildNodes(parentElm) {
  while (parentElm.firstElementChild) {
    parentElm.removeChild(parentElm.firstElementChild);
  }
}

var Interactive = {
  Window: {
    start: function(page, idcFrame, id, rotatable, x, y, height, width, angle, initFuncKey) {
      var elem = getFrame('frmDataSetup.frmSetup').document.getElementById(id);
      var that = this;
      var finishEdit = function(accepted) {
        that.finish(page, idcFrame, id, rotatable, accepted);
      };
      if (rotatable) {
        idcFrame.StartInteractiveWindow(finishEdit, x, y, height, width, angle, 1, (elem !== null ? elem.config : ""), initFuncKey);
      }
      else {
        idcFrame.StartInteractiveWindow(finishEdit, x, y, height, width, 0.0, 0, (elem !== null ? elem.config : ""), initFuncKey);
      }
    },
    finish: function(page, idcFrame, id, rotatable, accepted) {
      if (accepted) {
        var obj = idcFrame.ctlImageDisplay1;
        var array;
        if (rotatable) {
          array = [parseFloat(obj.MovableWindowTop).toFixed(3),
                   parseFloat(obj.MovableWindowLeft).toFixed(3),
                   parseFloat(obj.MovableWindowHeight).toFixed(3),
                   parseFloat(obj.MovableWindowWidth).toFixed(3),
                   parseFloat(obj.MovableWindowAngle).toFixed(3)];
        }
        else {
          array = [Math.round(obj.MovableWindowTop),
                   Math.round(obj.MovableWindowLeft),
                   Math.round(obj.MovableWindowHeight),
                   Math.round(obj.MovableWindowWidth)];
        }
        var value = array.join(", ");

        VTRNRequest(window, { webpage: page, request: id + ".finish", value: value, exitinteract: 1 }).send();
      }
      else {
        VTRNRequest(window, { webpage: page, request: id + ".cancel", exitinteract: 1 }).send();
      }
    }
  },
  Mask: {
    start: function(page, idcFrame, id, mode, pattern, mask) {
      var elem = getFrame('frmDataSetup.frmSetup').document.getElementById(id);
      var that = this;
      var finishEdit = function(accepted) {
        that.finish(page, idcFrame, id, mode, accepted);
      };
      switch (mode) {
      case 1: //VUIFMASK_NORMAL
        idcFrame.StartTrainingMaskEdit(finishEdit, window.location.host, pattern, mask, (elem !== null ? elem.config : ""));
        break;
      case 2: //VUIFMASK_EXTRACARE
        idcFrame.StartEmphasisMaskEdit(finishEdit, window.location.host, pattern, mask, (elem !== null ? elem.config : ""));
        break;
      }
    },
    finish: function(page, idcFrame, id, mode, accepted) {
      if (accepted) {
        var filename = idcFrame.ctlImageDisplay1.MaskImageFilename(mode);
        VTRNRequest(window, { webpage: page, request: id + ".finish", value: filename, exitinteract: 1 }).send();
      }
      else {
        VTRNRequest(window, { webpage: page, request: id + ".cancel", exitinteract: 1 }).send();
      }
    }
  },
  Line: {
    start: function(page, idcFrame, id, isDouble, isArrow, x1, y1, x2, y2, width, minWidth, maxWidth) {
      var elem = getFrame('frmDataSetup.frmSetup').document.getElementById(id);
      var that = this;
      var finishEdit = function(accepted) {
        that.finish(page, idcFrame, id, isDouble, accepted);
      };
      if (isDouble) {
        idcFrame.StartInteractiveLinePair(finishEdit, x1, y1, x2, y2, width, minWidth, maxWidth, (elem !== null ? elem.config : ""));
      }
      else {
        idcFrame.StartInteractiveLine(finishEdit, x1, y1, x2, y2, isArrow, (elem !== null ? elem.config : ""));
      }
    },
    finish: function(page, idcFrame, id, isDouble, accepted) {
      if (accepted) {
        var obj = idcFrame.ctlImageDisplay1;
        var array = [
          Math.round(obj.MovableLinePairEndpoint(1, "Y")),
          Math.round(obj.MovableLinePairEndpoint(1, "X")),
          Math.round(obj.MovableLinePairEndpoint(2, "Y")),
          Math.round(obj.MovableLinePairEndpoint(2, "X"))
        ];
        if (isDouble) array.push(obj.MovableLinePairWidth());
        var value = array.join(",");
        VTRNRequest(window, { webpage: page, request: id + ".finish", value: value, exitinteract: 1 }).send();
      }
      else {
        VTRNRequest(window, { webpage: page, request: id + ".cancel", exitinteract: 1 }).send();
      }
    }
  },
  Point: {
    start: function(page, idcFrame, id, x, y, r, initFuncKey) {
      var elem = getFrame('frmDataSetup.frmSetup').document.getElementById(id);
      var that = this;
      var finishEdit = function(accepted) {
        that.finish(page, idcFrame, id, accepted);
      };
      idcFrame.StartEditPoint(finishEdit, x, y, r, (elem !== null ? elem.config : ""), initFuncKey);
    },
    finish: function(page, idcFrame, id, accepted) {
      if (accepted) {
        var obj = idcFrame.ctlImageDisplay1;
        var values;
        if (typeof obj.getInteractiveResult === 'function') { // Canvas IDC and Modern browser
          var result = obj.getInteractiveResult();
          values = [result.x, result.y, result.angle].map(function(value) {
            return value.toFixed(3);
          });
        }
        else { // ActiveX IDC and old browser
          values = [parseFloat(obj.MovableCursorY).toFixed(3), parseFloat(obj.MovableCursorX).toFixed(3), 0.0];
        }
        VTRNRequest(window, { webpage: page, request: id + ".finish", value: values.join(","), exitinteract: 1 }).send();
      }
      else {
        VTRNRequest(window, { webpage: page, request: id + ".cancel", exitinteract: 1 }).send();
      }
    }
  },
  Segmline: {
    start: function(page, idcFrame, id, allowArc, numVertices, closed, vertexArray /*[[vt1, hz1, arc1], ..., [vtN, hzN, arcN]]*/) {
      var elem = getFrame('frmDataSetup.frmSetup').document.getElementById(id);
      var that = this;
      var finishEdit = function(accepted) {
        that.finish(page, idcFrame, id, accepted);
      };
      idcFrame.StartInteractiveSegmLine(finishEdit, allowArc, numVertices, closed, vertexArray, (elem !== null ? elem.config : ""));
    },
    finish: function(page, idcFrame, id, accepted) {
      if (accepted) {
        var obj = idcFrame.ctlImageDisplay1;
        var numVertices = parseInt(obj.GetProperty("NumSavedVertices"), 10);
        var closed = (obj.SegLineVtxString(0) == obj.SegLineVtxString(numVertices - 1));
        if (closed) numVertices = numVertices - 1;
        var array = [numVertices,(closed ? 1 : 0)];
        var vertexString, vertexArray;
        for (var i = 0; i < numVertices; i++) {
          vertexString = obj.SegLineVtxString(i);
          vertexArray  = vertexString.split(",");
          vertexArray[0] = parseFloat(vertexArray[0]).toFixed(1);
          vertexArray[1] = parseFloat(vertexArray[1]).toFixed(1);
          array.push(vertexArray);
        }
        var value = array.join(":");
        VTRNRequest(window, { webpage: page, request: id + ".finish", value: value, exitinteract: 1}).send();
      }
      else {
        VTRNRequest(window, { webpage: page, request: id + ".cancel", exitinteract: 1 }).send();
      }
    }
  },
  Circle: {
    start: function(page, idcFrame, id, centerVt, centerHz, radius) {
      var elem = getFrame('frmDataSetup.frmSetup').document.getElementById(id);
      var that = this;
      var finishEdit = function(accepted) {
        that.finish(page, idcFrame, id, accepted);
      };
      idcFrame.StartInteractiveCircle(finishEdit, centerVt, centerHz, radius, (elem !== null ? elem.config : ""));
    },
    finish : function(page, idcFrame, id, accepted) {
      if (accepted) {
        var obj = idcFrame.ctlImageDisplay1;
        var value = [parseFloat(obj.CenterX).toFixed(3),
                     parseFloat(obj.CenterY).toFixed(3),
                     parseFloat(obj.Radius).toFixed(3)].join(",");
        VTRNRequest(window, { webpage: page, request: id + ".finish", value: value, exitinteract: 1}).send();
      }
      else {
        VTRNRequest(window, { webpage: page, request: id + ".cancel", exitinteract: 1}).send();
      }
    }
  }
};

var UIFComponents = {
  global: {
    version: 'V9.40444',
    selectedTextbox: null,
    decimalComma: false,
    encoding: "big5",
    isIEMobile: false,
    hasTwoFuncKeyPages: false,
    isStandalone: false
  },
  select: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this,
          ul = doc.getElementById(elem.id + '.options'),
          label = doc.getElementById(elem.id + '.label');
      config.numDefaultOptions = ul.children.length;
      config.labelClass = label.className;
      config.selected = null;
      config.onmouseover = null;
      config.onmouseout = null;
      config.func = type.func;
      elem.config = config;
      elem.refresh = type.refresh;
      elem.getPreviousValue = type.getPreviousValue;
      elem.getValue = type.getValue;
      elem.getNextValue = type.getNextValue;
      elem.getOptions = type.getOptions;
      elem.getOptionProperty = type.getOptionProperty;
      elem.setLabelText = type.setLabelText;
      elem.setFocus = type.setFocus;
      elem.onselectoptionlocal = null;
      addEventHandler(elem, "click", type.onclick);
    },
    refresh: function(options, selectedValue, selectedText, disabled) {
      var elem = this,
          config = elem.config,
          doc = elem.ownerDocument,
          ul = doc.getElementById(elem.id + '.options'),
          button = findDescendant(elem, 'button', 'select-button'),
          numDefaultOptions = config.numDefaultOptions,
          optionsHTML = [],
          selectedProps = null,
          decimalComma = UIFComponents.global.decimalComma,
          isFloat = (/^-?\d*\.\d+$/).test(selectedValue),
          li, i, len, props;

      function formatFloat(text) {
        return decimalComma ? text.replace(/\./, ",") : text.replace(/,/, ".");
      }

      function optionHTML(text, value, className, image, selected) {
        var tagImage = '';
        if (selected) className += " select-option-selected select-option-highlight";
        if (isFloat) text = formatFloat(text);
        if (image) tagImage = format('<image src="images/%s" class="select-option-icon" align="absmiddle">', image);
        return format('<li class="select-option %s" data-value="%s"><a href="javascript:void(0);">%s%s</a></li>', className, value, tagImage, text);
      }

      // float value must not be string, because comparing value does not work properly.
      if (isFloat) selectedValue = parseFloat(selectedValue);

      /* default options */
      for (i = 0, li = firstElementNode(ul); i < numDefaultOptions && li !== null; i++, li = nextElementNode(li)) {
        props = elem.getOptionProperty(li);
        props.selected = false;

        if (selectedProps === null && props.value == selectedValue) {
          props.selected = true;
          selectedProps = props;
        }
        optionsHTML.push(optionHTML(props.text, props.value, props.className, props.image, props.selected));
      }

      /* new options */
      for (i = 0, len = options.length; i < len; i++) {
        if (options[i] !== undefined) {
          if (typeof options[i] === "object") {
            props = {text: options[i][0], value: options[i][1], image: options[i][2]};
          }
          else {
            props = {text: options[i], value: options[i], image: null};
          }
          props.selected = false;
          props.className = "";

          if (selectedProps === null && props.value == selectedValue) {
            props.selected = true;
            selectedProps = props;
          }
          optionsHTML.push(optionHTML(props.text, props.value, props.className, props.image, props.selected));
        }
      }

      /* invalid option */
      if (selectedProps === null && selectedValue !== null) {
        props = {className: "invalid"};
        props.text = (selectedText !== null) ? selectedText : selectedValue;
        if (typeof props.text === "number") props.text = "(" + props.text + ")";
        selectedProps = props;
        optionsHTML.push(optionHTML(props.text, selectedValue, props.className, null, true));
      }

      ul.innerHTML = optionsHTML.join('');
      if (isFloat) {
        selectedProps.text = formatFloat(selectedProps.text);
      }
      elem.setLabelText(selectedProps);
      config.selected = selectedValue;
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
      turnOnOffClass(button, 'disabled', disabled);
    },
    getPreviousValue: function() {
      var elem = this,
          options = elem.getOptions(),
          value = getNextNode(options, findDescendant(options, "li", "select-option-selected"), -1, false).dataset.value;
      return (typeof value === "number") ? value.toString(10) : value;
    },
    getValue: function() {
      var elem = this,
          value = elem.config.selected;
      return (typeof value === "number") ? value.toString(10) : value;
    },
    getNextValue: function() {
      var elem = this,
          options = elem.getOptions(),
          value = getNextNode(options, findDescendant(options, "li", "select-option-selected"), 1, false).dataset.value;
      return (typeof value === "number") ? value.toString(10) : value;
    },
    getOptions: function() {
      var elem = this,
          doc = elem.ownerDocument;
      return doc.getElementById(elem.id + ".options");
    },
    getOptionProperty: function(option) {
      var img = findDescendant(option, 'img', 'select-option-icon'),
          iconName = null,
          result;
      if (img !== null) {
        result = img.src.match(/\/([^\/]*)$/);
        if (result !== null) {
          iconName = result[1];
        }
      }
      var props = {
        className: option.className,
        // text: getText(firstElementNode(option)),
        text: firstElementNode(option).innerText.replace(/^ *\n */, '').replace(/ *\n *$/, ''),
        value: option.getAttribute('data-value'),
        image: iconName
      };
      removeClasses(props, "select-option select-option-selected select-option-highlight");
      return props;
    },
    setLabelText: function(props) {
      var elem = this,
          config = elem.config,
          doc = elem.ownerDocument,
          image = doc.getElementById(elem.id + '.image'),
          label = doc.getElementById(elem.id + '.label');
      if (label) {
        label.className = config.labelClass + " " + props.className;
        label.innerText = props.text;
      }
      if (props.image) {
        if (image === null) {
          image = doc.createElement('img');
          image.id = elem.id + ".image";
          image.className = "select-icon";
          image.align = "absmiddle";
          label.parentNode.insertBefore(image, label);
        }
        image.src = format("images/%s", props.image);
        addClass(elem, 'select-with-icon');
      }
      else {
        removeClass(elem, 'select-with-icon');
      }
    },
    setFocus: function() {
      var elem = this,
          button = findDescendant(elem, 'button', 'select-button');
      button.focus();
    },
    global: {
      openedElement: null
    },
    onclick: function(event) {
      var target = event.srcElement,
          elem = hasClass(target, 'select') ? target : findAncestor(target, 'span', 'select'),
          global = UIFComponents.select.global;

      if (global.openedElement !== null && global.openedElement !== elem) {
        global.openedElement.config.func.closeOpenedElement(global.openedElement);
        if (elem === null || elem.disabled) {
          return false;
        }
      }

      var handleKeys = function(event) {
        var options = findDescendant(elem, "ul", "select-options"),
            currSelected = findDescendant(options, "li", "select-option-highlight"),
            nextSelected, dist, direction, numOptions;

        if (currSelected === null) return true;

        switch (event.keyCode) {
        case 13:  // enter key
          if (elem.releaseCapture) elem.releaseCapture();
          currSelected.click();
          return false;
        case 27:  // prev
          if (elem.releaseCapture) elem.releaseCapture();
          elem.click();
          return false;
        default:
          dist = keyEventToDistance(event);
          break;
        }

        if (dist === 0) return true;

        nextSelected = getNextNode(options, currSelected, dist, true);
        direction = dist / Math.abs(dist);
        while (hasClass(nextSelected, "invalid") && !hasClass(nextSelected, "select-option-selected")) {
          nextSelected = getNextNode(options, nextSelected, direction, true);
          if (nextSelected === currSelected) return true;
        }

        if (nextSelected !== null) {
          addClassExclusively(options, nextSelected, "select-option-highlight");
          scrollTo(options, nextSelected);
          return false;
        }
        return true;
      };

      if (elem.disabled) return false;

      var config = elem.config,
          doc = elem.ownerDocument,
          options = doc.getElementById(elem.id + '.options'),
          frame = getDefaultView(doc),
          value = null,
          node, style, zIndex, type, area, props;

      if (!hasClass(options, 'hide')) { // close options
        switch (target.tagName) {
        case 'LI':
        case 'A':
          if (target.tagName === "A") {
            target = target.parentNode;
          }
          value = target.getAttribute('data-value');
          break;

        default:
          addClassExclusively(options, findDescendant(options, "li", "select-option-selected"), "select-option-highlight");
          break;
        }

        var closeOptions = function(options) {
          for (var node = options.parentNode; node !== null && node.style !== undefined; node = node.parentNode) {
            node.style.zIndex = '';
          }
          addClass(options, 'hide');
          removeClass(elem, 'opened');
          removeClasses(options, 'select-options-pullup scrolling');
          options.style.cssText = '';
        };

        if (value === null || value == config.selected) {
          closeOptions(options); // do nothing more than closing option
        }
        else {
          config.selected = value;

          addClassExclusively(elem, target, "select-option-highlight");
          addClassExclusively(elem, target, "select-option-selected");

          frame.setTimeout(function() {
            if (typeof elem.onselectoptionlocal === 'function') {
              // Local select function to execute instead of sending request
              elem.onselectoptionlocal(value);
            }
            else {
              VTRNRequest(frame, { request: elem.id + ".changed", value: value }).send();
            }

            props = elem.getOptionProperty(target);
            elem.setLabelText(props);
            closeOptions(options);
          }, 0);
        }

        triggerEvent(elem, 'resizeend');
        KeyEvent.popHandler();
        if (elem.releaseCapture) elem.releaseCapture();

        if (config.onmouseover !== null) {
          removeEventHandler(options, "mouseover", config.onmouseover);
          removeEventHandler(options, "mouseout", config.onmouseout);
          config.onmouseover = null;
          config.onmouseout = null;
        }

        if (isModernBrowser) {
          removeEventHandler(global.openedElement, "focusout", global.openedElement.config.func.onFocusOut);
          removeEventHandler(doc.getElementById(global.openedElement.id + ".options"), "mousedown", global.openedElement.config.func.optionClick);
        }
        global.openedElement = null;
      }
      else { // open options
        // Because of IE bug, z-index must be specfied to parent element which has 'position:relative'
        zIndex = getCurrentStyle(options).zIndex;
        for (node = options.parentNode; node !== null && node.style !== undefined; node = node.parentNode) {
          node.style.zIndex = zIndex;
        }

        // Find scroll area
        for (node = options.parentNode, style = getCurrentStyle(node), area = null;
             node !== null && style !== null && area === null;
             node = node.parentNode, style = getCurrentStyle(node)) {
          if (style !== null && style.overflow !== "visible") {
            area = node;
          }
        }
        if (area === null) area = doc.documentElement;

        removeClass(options, 'hide'); // This line should be executed before options.clienHeight is got
        addClass(elem, 'opened');

        var areaTop = area.scrollTop + cumulativeOffsetTop(area),
            areaLeft = area.scrollLeft + cumulativeOffsetLeft(area),
            areaHeight = area.clientHeight,
            areaWidth = area.clientWidth,
            targetTop = cumulativeOffsetTop(elem),
            targetLeft = cumulativeOffsetLeft(elem),
            targetHeight = elem.offsetHeight,
            targetWidth = elem.offsetWidth,
            margin = 3,
            scrollbarWidth = 18,
            optionsHeight = options.clientHeight + margin * 2,
            optionsWidth = options.clientWidth + margin * 2,
            offsetLeft = 0,
            cssProps = [],
            marginTop, marginBottom, marginLeft, marginRight, currentLeft, topVal, bottomVal, heightVal;

        marginTop = targetTop - areaTop - optionsHeight;
        marginBottom = areaTop + areaHeight - (targetTop + targetHeight + optionsHeight);
        marginLeft = targetLeft - areaLeft;
        marginRight = areaLeft + areaWidth - (targetLeft + optionsWidth);

        if (marginRight < 0) {
          currentLeft = parseInt(getCurrentStyle(options).left, 10);
          offsetLeft = Math.max(marginLeft * -1, marginRight);
          cssProps.push('left:' + (currentLeft + offsetLeft) + 'px;');
        }

        if (marginBottom < 0) { // pulldown options will overflow
          if (marginTop >= 0) { // pullup options
            addClass(options, 'select-options-pullup');
          }
          else {
            if (optionsHeight <= areaHeight) { // displace options
              if (marginBottom > marginTop) {
                topVal = marginBottom;
                if (UIFComponents.global.isIEMobile) topVal += targetHeight;
                cssProps.push('top:' + topVal + 'px;');
                cssProps.push('bottom: auto;');
              }
              else {
                bottomVal = marginTop + targetHeight;
                if (!UIFComponents.global.isIEMobile) bottomVal -= 20; // FIXME: why is minus 20 necessary?
                cssProps.push('top: auto;');
                cssProps.push('bottom:' + bottomVal + 'px;');
              }
            }
            else { // options with scroll bar
              if (targetLeft + offsetLeft + optionsWidth + scrollbarWidth < areaLeft + areaWidth) {
                optionsWidth += scrollbarWidth;
              }
              cssProps.push('width:' + (optionsWidth - margin * 2) + 'px;');

              topVal = areaTop - targetTop + margin;
              if (!UIFComponents.global.isIEMobile) {
                topVal -= targetHeight;
              }
              cssProps.push('top:' + topVal + 'px;');
              cssProps.push('height:' + (areaHeight - margin * 2) + 'px;');
              addClass(options, 'scrolling'); // This line should be after options.clientWidth is got
              scrollTo(options, findDescendant(options, "li", "select-option-highlight"));
              if (UIFComponents.global.isIEMobile) {
                frame.setTimeout(function() { // Wihtout the following line, scroll bar is not shown at first.
                  var height = options.style.height;
                  options.style.height = 0;
                  options.style.height = height;
                }, 0);
              }
            }
          }
        }

        if (cssProps.length > 0) {
          options.style.cssText = cssProps.join(' ');
        }
        triggerEvent(elem, 'resizestart');
        KeyEvent.addHandler(handleKeys, frame, false);

        if (!UIFComponents.global.isIEMobile) { // The following lines does not work on iPendant.
          config.onmouseover = function(event) {
            if (global.openedElement === elem) {
              if (elem.releaseCapture) elem.releaseCapture(); // Without calling this method scrollbar cannot be hanlded.
            }
            return false;
          };
          config.onmouseout = function(event) {
            if (global.openedElement === elem) {
              if (elem.setCapture) elem.setCapture(false);
            }
            return false;
          };
          addEventHandler(options, "mouseover", config.onmouseover);
          addEventHandler(options, "mouseout", config.onmouseout);
        }

        if (elem.setCapture) elem.setCapture(false);

        global.openedElement = elem;
        elem.setFocus();
        if (isModernBrowser) {
          addEventHandler(elem, "focusout", elem.config.func.onFocusOut);
          addEventHandler(options, "mousedown", elem.config.func.optionClick);
        }
      }
      return false;
    },
    func: {
      onFocusOut: function(event) {
        var openedElement = UIFComponents.select.global.openedElement;

        if (isModernBrowser) {
          removeEventHandler(openedElement, "focusout", openedElement.config.func.onFocusOut);
          removeEventHandler(openedElement.ownerDocument.getElementById(openedElement.id + ".options"), "mousedown", openedElement.config.func.optionClick);
        }
        if (openedElement !== null) {
          openedElement.config.func.closeOpenedElement(openedElement);
        }
      },
      optionClick: function(event) {
        var openedElement = UIFComponents.select.global.openedElement;

        if (isModernBrowser) {
          removeEventHandler(openedElement, "focusout", openedElement.config.func.onFocusOut);
          removeEventHandler(openedElement.ownerDocument.getElementById(openedElement.id + ".options"), "mousedown", openedElement.config.func.optionClick);
        }
      },
      closeOpenedElement: function(openedElement) {
        try { // If openedElement does not exist, an error will occur.
          if (openedElement.fireEvent) {
            openedElement.fireEvent('onclick');
          } else {
            openedElement.click();
          }
        }
        catch (e) {
          openedElement = null;
        }
      }
    }
  },

  buttonText: {
    init: function (doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;
      elem.config = config;
      elem.refresh = type.refresh;
      elem.setHoldMode = type.setHoldMode;
      elem.ontouch = type.ontouch;
      if (config.page === undefined) {
        config.page = frame.webpage;
      }
      config.holdMode = false;
      if (!("onclick" in config)) {
        addEventHandler(elem, "click", type.onclick);
      }
      if (!UIFComponents.global.isIEMobile) {
        if (isTablet()) {
          addEventHandler(elem, "touchstart", type.onmousedown);
          addEventHandler(elem, "touchend", type.onmouseup);
        }
        else {
          addEventHandler(elem, "mousedown", type.onmousedown);
          addEventHandler(elem, "mouseup", type.onmouseup);
        }
        addEventHandler(elem, "mouseout", type.onmouseout);
      }
    },
    refresh: function (text, color, disabled) {
      var elem = this;
      if (text !== null) {
        elem.innerText = text;
      }
      if (color !== null) {
        elem.style.color = colorTable[color];
      }
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
    },
    setHoldMode: function(holdMode, pageEnd) {
      var elem = this,
          config = elem.config;
      config.holdMode = holdMode;
      config.pageEnd = pageEnd;
    },
    onclick: function (event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument),
          config;
      if (!hasClass(elem, 'label-button')) {
        elem = findAncestor(elem, 'button', 'label-button');
      }
      config = elem.config;
      if (!config.holdMode) {
        VTRNRequest(frame, { webpage: config.page, request: elem.id + ".clicked" }).send();
      }
    },
    ontouch: function(isStart) {
      var elem = this,
          config = elem.config,
          frame = getDefaultView(elem.ownerDocument),
          page, action, params;

      if (!config.holdMode || hasClass(elem, 'disabled')) return false;
      turnOnOffClass(elem, "clicked", isStart);

      page = isStart ? config.page : config.pageEnd;
      action = isStart ? 'touchstart': 'touchend';
      params = { webpage: page, request: [elem.id, action].join('.') };
      if (!isStart) {
        params["fc"] = SFVTRN_function_codes.HCFC_SFVTRN_CALLBACK_C;
      }
      VTRNRequest(frame, params).send();
      return false;
    },
    onmousedown: function(event) {
      var elem = event.srcElement;
      if (!hasClass(elem, 'label-button')) {
        elem = findAncestor(elem, 'button', 'label-button');
      }
      return elem.ontouch(true);
    },
    onmouseup: function(event) {
      var elem = event.srcElement;
      if (!hasClass(elem, 'label-button')) {
        elem = findAncestor(elem, 'button', 'label-button');
      }
      return elem.ontouch(false);
    },
    onmouseout: function(event) {
      var elem = event.srcElement,
          config;
      if (!hasClass(elem, 'label-button')) {
        elem = findAncestor(elem, 'button', 'label-button');
      }
      config = elem.config;
      if (!config.holdMode || hasClass(elem, 'disabled')) return false;
      removeClass(elem, "clicked");
      return false;
    }
  },

  helpLink: {
    init: function (doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.config = config;
      elem.refresh = type.refresh;
      if ("popup" in config) {
        config.popup = (config.popup === "true");
      }
      if (!("onclick" in config)) {
        addEventHandler(elem, "click", type.onclick);
      }
    },
    refresh: function (text, color, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          textNode;
      if (text !== null) {
        textNode = getTextNode(elem);
        if (textNode === null) {
          textNode = doc.createTextNode(elem);
          elem.appendChild(textNode);
        }
        if (textNode !== null) {
          textNode.nodeValue = text;
        }
      }
      if (color !== null) {
        elem.style.color = colorTable[color];
      }
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
    },
    onclick: function (event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument),
          page = 'vshelp',
          config, file, names;
      if (elem.tagName === "SPAN") {
        elem = elem.parentNode;
      }
      config = elem.config;
      if ('page' in config) page = config.page;
      file = ('file' in config) ? config.file : elem.id;
      if (config.popup) {
        names = file.split(".");
        showHelpPage(names.pop());
      }
      else {
        VTRNRequest(frame, { webpage: page, request: file + ".clicked" }).send();
      }
    }
  },

  buttonImage: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;
      elem.config = config;
      elem.refresh = type.refresh;
      if (config.page === undefined) {
        config.page = frame.webpage;
      }
      if (!("onclick" in config)) {
        addEventHandler(elem, "click", type.onclick);
      }
      if (UIFComponents.global.isIEMobile) {
        addClass(elem, "image-button-tp");
      }
    },
    refresh: function(image, disabled, onclick) {
      var elem = this,
          style, height, borderTop, borderBottom, offset, span;
      if (disabled === undefined) alert("buttonImage::refresh() is called wrongly.");
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
      if (typeof image === 'string') {
        span = findDescendant(elem, "span", "image-button-sprite");
        if (typeof elem.config.sprite === 'string') {
          replaceClass(span, elem.config.sprite, image);
        }
        else {
          addClass(span, image);
        }
        elem.config.sprite = image;
      }
      if (onclick !== undefined) {
        elem.config.onclick = onclick;
      }
    },
    onclick: function(event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument),
          config;
      if (elem.tagName === 'SPAN') {
        elem = elem.parentNode;
      }
      config = elem.config;
      if (!hasClass(elem, "disabled")) {
        if (config.onclick !== undefined && config.onclick !== null) {
          config.onclick('clicked', config.page, elem.id, elem);
        }
        else {
          VTRNRequest(frame, { webpage: config.page, request: elem.id + ".clicked" }).send();
        }
      }
    }
  },

  textboxReal: {
    init: function (doc, id, config) {
      var type = this,
          elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          textbox = doc.getElementById(elem.id + ".textbox"),
          func = type.func;

      config.func = func;

      elem.config = config;
      elem.refresh = type.refresh;
      elem.notifyChanged = type.notifyChanged;
      elem.setFocus = type.setFocus;
      elem.setCallback = type.setCallback;
      elem.convert = type.convert;
      elem.setValue = type.setValue;

      addEventHandler(textbox, "focus", type.onfocus);
      addEventHandler(textbox, "blur", type.onblur);
      addEventHandler(textbox, "keypress", type.onkeypress);

      config.oldText = "";
      if (isTablet()) {
        textbox.setAttribute("inputmode", "tel");
      }

      if (config.lowerLimit !== undefined) config.lowerLimit = func.parseReal(config.lowerLimit);
      if (config.upperLimit !== undefined) config.upperLimit = func.parseReal(config.upperLimit);

      if (config.scale1 === undefined) config.scale1 = Math.sqrt(2);
      else config.scale1 = parseFloat(config.scale1);

      if (config.scale2 === undefined) config.scale2 = config.scale1 * config.scale1;
      else config.scale2 = parseFloat(config.scale2);

      if (config.step1 === undefined) config.step1 = 1;
      else config.step1 = parseFloat(config.step1);

      if (config.step2 === undefined) config.step2 = config.step1 * 10;
      else config.step2 = parseFloat(config.step2);

      if ("buttons" in config) {
        var btnInc1 = doc.getElementById(elem.id + ".btnInc"),
            btnDec1 = doc.getElementById(elem.id + ".btnDec"),
            btnInc2 = doc.getElementById(elem.id + ".btnInc2"),
            btnDec2 = doc.getElementById(elem.id + ".btnDec2");

        switch (config.buttons) {
        case "scale":
          btnInc1.scale = func.scaleup1;
          btnDec1.scale = func.scaledown1;
          break;
        case "scale2":
          removeClass(btnInc2, "hide");
          removeClass(btnDec2, "hide");
          btnInc2.scale = func.scaleup2;
          btnInc1.scale = func.scaleup1;
          btnDec1.scale = func.scaledown1;
          btnDec2.scale = func.scaledown2;
          break;
        case "step":
          btnInc1.scale = func.increment1;
          btnDec1.scale = func.decrement1;
          break;
        case "step2":
          removeClass(btnInc2, "hide");
          removeClass(btnDec2, "hide");
          btnInc2.scale = func.increment2;
          btnInc1.scale = func.increment1;
          btnDec1.scale = func.decrement1;
          btnDec2.scale = func.decrement2;
          break;
        default:
          throw new Error("unknown buttons value: " + config.buttons);
          break;
        }
        addEventHandler(btnDec2, "click", type.onclick);
        addEventHandler(btnDec1, "click", type.onclick);
        addEventHandler(btnInc1, "click", type.onclick);
        addEventHandler(btnInc2, "click", type.onclick);
      }

      if ("slider" in config) {
        var btnIncS1 = doc.getElementById(elem.id + ".btnIncSlider"),
            btnDecS1 = doc.getElementById(elem.id + ".btnDecSlider");
        switch (config.slider) {
        case "scale":
          btnIncS1.scale = func.scaleup1;
          btnDecS1.scale = func.scaledown1;
          break;
        case "scale2":
          btnIncS1.scale = func.scaleup2;
          btnDecS1.scale = func.scaledown2;
          break;
        case "step":
          btnIncS1.scale = func.increment1;
          btnDecS1.scale = func.decrement1;
          break;
        case "step2":
          btnIncS1.scale = func.increment2;
          btnDecS1.scale = func.decrement2;
          break;
        default:
          throw new Error("unknown slider value: " + config.slider);
          break;
        }
        addEventHandler(btnDecS1, "click", type.onclick);
        addEventHandler(btnIncS1, "click", type.onclick);
        addEventHandler(frame, "load", function () {
          var slider = doc.getElementById(elem.id + ".slider"),
              step = ("step" in config) ? parseFloat(config.step) : Math.pow(0.1, config.decimals);
          
          slider.setStep(step);
          slider.setOnInput(function (value) {
            textbox.value = func.formatReal(value, config);
          });
          slider.setOnChange(function (_isLowHandle, value) {
            elem.setValue(value);
          });
        });
      }
    },
    convert: function (text) {
      var elem = this,
          config = elem.config,
          func = config.func;
      return func.convertUnits(text, config);
    },
    setValue: function (value) {
      var elem = this,
          config = elem.config,
          func = config.func;
      var text = func.formatReal(value, config);
      if (text !== config.oldText) {
        elem.notifyChanged(text);
      }
    },
    refresh: function (cur, min, max, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          textbox = doc.getElementById(elem.id + ".textbox"),
          config = elem.config,
          func = config.func,
          color = "black",
          disableDec = disabled,
          disableInc = disabled,
          curText;

      config.decimalComma = (/,/).test(cur);
      config.lowerLimit = func.convertUnits(min, config);
      config.upperLimit = func.convertUnits(max, config);
      cur = func.convertUnits(cur, config);
      if (isNaN(cur)) {
        disableDec = true;
        disableInc = true;
      }
      else {
        if (cur <= config.lowerLimit) disableDec = true;
        if (cur >= config.upperLimit) disableInc = true;
        if (cur < config.lowerLimit || cur > config.upperLimit) {
          color = "red";
        }
      }
      elem.disabled = disabled;
      textbox.disabled = disabled;
      textbox.style.color = colorTable[color];
      turnOnOffClass(textbox, "textbox-no-text", isNaN(cur) && !disabled);
      curText = func.formatReal(cur, config);
      if (curText !== config.oldText) {
        textbox.value = curText;
        config.oldText = textbox.value;
      }
      if ("buttons" in config) {
        doc.getElementById(elem.id + ".btnDec2").refresh(null, disableDec);
        doc.getElementById(elem.id + ".btnDec").refresh(null, disableDec);
        doc.getElementById(elem.id + ".btnInc").refresh(null, disableInc);
        doc.getElementById(elem.id + ".btnInc2").refresh(null, disableInc);
      }
      if ("slider" in config) {
        var slider = doc.getElementById(elem.id + ".slider");
        doc.getElementById(elem.id + ".btnDecSlider").refresh(null, disableDec);
        doc.getElementById(elem.id + ".btnIncSlider").refresh(null, disableInc);
        slider.refresh(null, cur, config.lowerLimit, config.upperLimit, disabled);
      }
    },
    notifyChanged: function (text, operation) {
      var elem = this,
          doc = elem.ownerDocument,
          textbox = doc.getElementById(elem.id + ".textbox"),
          config = elem.config,
          func = config.func,
          validated;
      validated = func.validate(text, config);
      if (validated instanceof Error) {
        textbox.value = config.oldText;
        alertMessage(validated.message, function() {
          // Without below blur() and focus(), event for textbox is not fired
          // properly after displaying alert message.
          textbox.blur();
          textbox.focus();
        });

        return false;
      }
      else {
        config.oldText = textbox.value = validated;
        notifyTextboxChanged(textbox, func.revertUnits(validated, config), operation, config);
        return true;
      }
    },
    onclick: function(event) {
      var elem = event.srcElement,
          doc = elem.ownerDocument,
          root = findAncestor(elem, 'span', 'textbox'),
          textbox = doc.getElementById(root.id + ".textbox"),
          config = root.config,
          func = config.func,
          button, value;

      // This code depends on the inner structure of buttonImage.
      button = (elem.tagName === 'SPAN') ? elem.parentNode : elem;

      value = func.parseReal(textbox.value);
      value = button.scale(value, config);
      value = Math.max(config.lowerLimit, value);
      value = Math.min(config.upperLimit, value);

      var text = func.formatReal(value, config);
      if (textbox.value !== text) {
        root.notifyChanged(text);
      }
    },
    onblur: function(event) {
      var elem = event.srcElement,
          root = elem.parentNode,
          config = root.config;

      if (elem.value !== config.oldText) {
        root.notifyChanged(elem.value, "blur");
      }
      UIFComponents.global.selectedTextbox = null;
      if (isTablet()) inputFocusSlideForm(elem, false);
      return false;
    },
    onkeypress: function(event) {
      var elem = event.srcElement,
          root = elem.parentNode,
          config = root.config,
          key = event.keyCode,
          allowed;
      if (key === 46 && config.decimalComma) { // key is dot
        event.keyCode = key = 44; // convert to comma
      }
      if (key !== 13) {
        allowed = config.func.filter(key, config);
        if (!allowed && event.preventDefault) event.preventDefault();
        return allowed;
      }
      else {
        if (elem.value === config.oldText) {
          elem.select();
        }
        else {
          root.notifyChanged(elem.value, "enter");
        }
        return false;
      }
    },
    onfocus: function(event) {
      var elem = event.srcElement;
      elem.select();
      UIFComponents.global.selectedTextbox = elem;
      if (isTablet()) inputFocusSlideForm(elem, true);
      return false;
    },
    setFocus: function () {
      var elem = this,
          textbox = elem.ownerDocument.getElementById(elem.id + ".textbox");
      textbox.focus();
    },
    setCallback: function (callback) {
      var elem = this;
      elem.config.callback = callback;
    },
    func: {
      scaleup2: function (value, config) { return value * config.scale2; },
      scaleup1: function (value, config) { return value * config.scale1; },
      scaledown1: function (value, config) { return value / config.scale1; },
      scaledown2: function (value, config) { return value / config.scale2; },
      increment2: function (value, config) { return value + config.step2; },
      increment1: function (value, config) { return value + config.step1; },
      decrement1: function (value, config) { return value - config.step1; },
      decrement2: function (value, config) { return value - config.step2; },

      formatReal: function (value, config) {
        var func = this,
            text;
        if (isNaN(value)) return "";
        text = value.toFixed(config.decimals);
        text = func.revertDecimalMarker(text, config.decimalComma);
        return text;
      },
      revertDecimalMarker: function (text, decimalComma) {
        if (decimalComma) {
          text = text.replace(/\./, ",");
        }
        return text;
      },
      parseReal: function(text) {
        var num;
        text = text.replace(/,/, ".");
        num = isNaN(text) ? NaN : parseFloat(text);
        return num;
      },
      filter: function(keyCode, config) {
        var text = String.fromCharCode(keyCode),
            regexp,
            allowed = "\\d";
        if (config.lowerLimit < 0) allowed += "-";
        allowed += config.decimalComma ? "," : "\\.";
        return (new RegExp("[" + allowed + "]")).test(text);
      },
      convertUnits: function(text, config) {
        var func = this,
            value = func.parseReal(text, config);
        if (isNaN(value)) return value;

        switch (config.conversion) {
        case "percent": value *= 100; break;
        case "degree": value *= 180 / Math.PI; break;
        case "millesimal": value /= 1000; break;
        }
        // round off
        return parseFloat(value.toFixed(config.decimals));
      },
      revertUnitsValue: function(value, config) {
        var func = this;
        switch (config.conversion) {
        case "percent": value = value / 100; break;
        case "degree": value = value * Math.PI / 180; break;
        case "millesimal": value *= 1000; break;
        }
        return func.revertDecimalMarker(value.toString(), config.decimalComma);
      },
      revertUnits: function(text, config) {
        var func = this,
            value = func.parseReal(text);
        switch (config.conversion) {
        case "percent": value = value / 100; break;
        case "degree": value = value * Math.PI / 180; break;
        case "millesimal": value *= 1000; break;
        }
        return func.revertDecimalMarker(value.toString(), config.decimalComma);
      },
      validate: function(text, config) {
        var func = this,
            allowed = "-\\d",
            value = func.parseReal(text);

        if (config.decimalComma) {
          text = text.replace(/\./, ",");
        }
        allowed += config.decimalComma ? "," : "\\.";
        if (!(new RegExp("^[" + allowed + "]+$")).test(text)) {
          return new Error("oӦrꤣOƦrC");
        }
        else if (config.lowerLimit <= value && value <= config.upperLimit) {
          return text;
        }
        else {
          return new Error(format("%sWLdC\n(%s-%s)", text,
                                  func.formatReal(config.lowerLimit, config),
                                  func.formatReal(config.upperLimit, config)));
        }
      }
    }
  },

  textboxInteger: {
    init: function(doc, id, config) {
      var type = this,
          elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          textbox = doc.getElementById(elem.id + ".textbox"),
          func = type.func;

      config.func = func;

      elem.config = config;
      elem.refresh = type.refresh;
      elem.notifyChanged = type.notifyChanged;
      elem.setFocus = type.setFocus;
      elem.setValue = type.setValue;

      if (isTablet()) {
        textbox.setAttribute("inputmode", "tel");
      }
      addEventHandler(textbox, "focus", type.onfocus);
      addEventHandler(textbox, "blur", type.onblur);
      addEventHandler(textbox, "keypress", type.onkeypress);

      config.oldText = "";

      if (config.step1 === undefined) config.step1 = 1;
      else config.step1 = parseInt(config.step1, 10);

      if (config.step2 === undefined) config.step2 = config.step1 * 10;
      else config.step2 = parseInt(config.step2, 10);

      if ("buttons" in config) {
        var btnInc1 = doc.getElementById(elem.id + ".btnInc"),
            btnDec1 = doc.getElementById(elem.id + ".btnDec"),
            btnInc2 = doc.getElementById(elem.id + ".btnInc2"),
            btnDec2 = doc.getElementById(elem.id + ".btnDec2");

        switch (config.buttons) {
        case "step":
          btnInc1.scale = func.increment1;
          btnDec1.scale = func.decrement1;
          break;
        case "step2":
          removeClass(btnInc2, "hide");
          removeClass(btnDec2, "hide");
          btnInc2.scale = func.increment2;
          btnInc1.scale = func.increment1;
          btnDec1.scale = func.decrement1;
          btnDec2.scale = func.decrement2;
          break;
        default:
          throw new Error("unknown buttons value: " + config.buttons);
          break;
        }
        addEventHandler(btnInc1, "click", type.onclick);
        addEventHandler(btnDec1, "click", type.onclick);
        addEventHandler(btnInc2, "click", type.onclick);
        addEventHandler(btnDec2, "click", type.onclick);
      }
      if ("slider" in config) {
        var btnIncS1 = doc.getElementById(elem.id + ".btnIncSlider"),
            btnDecS1 = doc.getElementById(elem.id + ".btnDecSlider");
        switch (config.buttons) {
        case "step":
          btnIncS1.scale = func.increment1;
          btnDecS1.scale = func.decrement1;
          break;
        case "step2":
          btnIncS1.scale = func.increment2;
          btnDecS1.scale = func.decrement2;
          break;
        default:
          throw new Error("unknown slider value: " + config.slider);
          break;
        }
        btnIncS1.scale = func.increment1;
        btnDecS1.scale = func.decrement1;
        addEventHandler(btnDecS1, "click", type.onclick);
        addEventHandler(btnIncS1, "click", type.onclick);
        addEventHandler(frame, "load", function () {
          var slider = doc.getElementById(elem.id + ".slider"),
              step = ("step" in config) ? parseInt(config.step) : 1;

          slider.setStep(step);
          slider.setOnInput(function (value) {
            textbox.value = value.toString();
          });
          slider.setOnChange(function (_isLowHandle, value) {
            elem.setValue(value);
          });
        });
      }
    },
    refresh: function(cur, min, max, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          textbox = doc.getElementById(elem.id + ".textbox"),
          config = elem.config,
          color = "black",
          disableDec = disabled,
          disableInc = disabled;

      config.lowerLimit = parseInt(min, 10);
      config.upperLimit = parseInt(max, 10);
      cur = parseInt(cur, 10);
      if (isNaN(cur)) {
        cur = "";
        disableDec = true;
        disableInc = true;
      }
      else {
        if (cur <= config.lowerLimit) disableDec = true;
        if (cur >= config.upperLimit) disableInc = true;
        if (cur < config.lowerLimit || cur > config.upperLimit) {
          color = "red";
        }
      }
      elem.disabled = disabled;
      textbox.disabled = disabled;
      textbox.style.color = colorTable[color];
      turnOnOffClass(textbox, "textbox-no-text", (cur === "") && !disabled);
      if (cur !== parseInt(config.oldText, 10) &&
          !(cur === "" && config.oldText === "")) {
        textbox.value = cur;
        config.oldText = textbox.value;
      }
      if ("buttons" in config) {
        doc.getElementById(elem.id + ".btnDec2").refresh(null, disableDec);
        doc.getElementById(elem.id + ".btnDec").refresh(null, disableDec);
        doc.getElementById(elem.id + ".btnInc").refresh(null, disableInc);
        doc.getElementById(elem.id + ".btnInc2").refresh(null, disableInc);
      }
      if ("slider" in config) {
        var slider = doc.getElementById(elem.id + ".slider");
        doc.getElementById(elem.id + ".btnDecSlider").refresh(null, disableDec);
        doc.getElementById(elem.id + ".btnIncSlider").refresh(null, disableInc);
        slider.refresh(null, cur, config.lowerLimit, config.upperLimit, disabled);
      }
    },
    notifyChanged: function (text, operation) {
      var elem = this,
          doc = elem.ownerDocument,
          textbox = doc.getElementById(elem.id + ".textbox"),
          config = elem.config,
          validated;
      validated = config.func.validate(text, config);
      if (validated instanceof Error) {
        textbox.value = config.oldText;
        alertMessage(validated.message, function() {
          // without below blur() and focus(), event for textbox is not fired
          // properly after displaying alert message.
          textbox.blur();
          textbox.focus();
        });
        return false;
      }
      else {
        config.oldText = textbox.value = validated;
        notifyTextboxChanged(textbox, validated, operation, config);
        return true;
      }
    },
    setValue: function(value) {
      var elem = this,
          config = elem.config,
          func = config.func;
      var text = value.toString();
      if (text !== config.oldText) {
        elem.notifyChanged(text);
      }
    },
    onclick: function(event) {
      var elem = event.srcElement,
          doc = elem.ownerDocument,
          root = findAncestor(elem, 'span', 'textbox'),
          textbox = doc.getElementById(root.id + ".textbox"),
          config = root.config,
          button, value;

      // This code depends on the inner structure of buttonImage.
      button = (elem.tagName === 'SPAN') ? elem.parentNode : elem;

      value = parseInt(textbox.value, 10);
      value = button.scale(value, config);
      value = Math.max(config.lowerLimit, value);
      value = Math.min(config.upperLimit, value);

      var text = value.toString();
      if (textbox.value !== text) {
        root.notifyChanged(text);
      }
    },
    onblur: function(event) {
      var elem = event.srcElement,
          root = elem.parentNode,
          config = root.config;
      if (elem.value !== config.oldText) {
        root.notifyChanged(elem.value, "blur");
      }
      UIFComponents.global.selectedTextbox = null;
      if (isTablet()) inputFocusSlideForm(elem, false);
      return false;
    },
    onkeypress: function(event) {
      var elem = event.srcElement,
          root = elem.parentNode,
          config = root.config,
          key = event.keyCode,
          allowed;
      if (key !== 13) {
        allowed = config.func.filter(key, config);
        if (!allowed && event.preventDefault) event.preventDefault();
        return allowed;
      }
      else {
        if (elem.value === config.oldText) {
          elem.select();
        }
        else {
          root.notifyChanged(elem.value, "enter");
        }
        return false;
      }
    },
    onfocus: function(event) {
      var elem = event.srcElement;
      elem.select();
      UIFComponents.global.selectedTextbox = elem;
      if (isTablet()) inputFocusSlideForm(elem, true);
      return false;
    },
    setFocus: function(){
      var elem = this,
          textbox = elem.ownerDocument.getElementById(elem.id + ".textbox");
      textbox.focus();
    },
    func: {
      increment2: function(value, config) { return value + config.step2; },
      increment1: function(value, config) { return value + config.step1; },
      decrement1: function(value, config) { return value - config.step1; },
      decrement2: function(value, config) { return value - config.step2; },

      filter: function(keyCode, config) {
        var text = String.fromCharCode(keyCode),
            regexp,
            allowed = "\\d";
        if (config.lowerLimit < 0) allowed += "-";
        return (new RegExp("[" + allowed + "]")).test(text);
      },
      validate: function(text, config) {
        var func = this,
            allowed = "\\d",
            value = parseInt(text, 10);

        if (!(new RegExp("^[-]?[" + allowed + "]+$")).test(text)) {
          return new Error("oӦrꤣOƦrC");
        }
        else if (config.lowerLimit <= value && value <= config.upperLimit) {
          return text;
        }
        else {
          return new Error(format("%sWLdC\n(%s-%s)",
                                  text, config.lowerLimit, config.upperLimit));
        }
      }
    }
  },

  textboxString: {
    init: function(doc, id, config) {
      var type = this,
          elem = doc.getElementById(id);

      config.func = type.func;

      elem.config = config;
      elem.refresh = type.refresh;
      elem.getValue = type.getValue;
      elem.notifyChanged = type.notifyChanged;
      elem.setMode = type.setMode;
      elem.setConfig = type.setConfig;
      elem.setFocus = type.setFocus;
      elem.setCallback = type.setCallback;

      addEventHandler(elem, "focus", type.onfocus);
      addEventHandler(elem, "blur", type.onblur);
      addEventHandler(elem, "keypress", type.onkeypress);
      addEventHandler(elem, "keyup", type.onkeyup);
      addEventHandler(elem, "paste", type.onpaste);

      config.oldText = "";

      config.filter = function(keyCode) {
        var character = String.fromCharCode(keyCode);
        return (/[^&'"\/\\]/).test(character);
      };
      config.validate = function(text) {
        if (!(/^[^&'"\/\\\u00a5]*$/).test(text)) {
          return new Error("rꤣo]tUCršG&&#39;\&quot;/\\");
        }
        return text;
      };
      config.minLen = 1;
      elem.setMode(config.mode);
    },
    setMode: function(mode) {
      var elem = this,
          config = elem.config,
          configs = {
            dataname: {
              filter: function(keyCode) {
                var character = String.fromCharCode(keyCode);
                return (/[\w]/).test(character);
              },
              validate: function(text) {
                if (!(/^[\w\uFF65-\uFF9F]*$/).test(text)) {
                  return new Error("r]tLĪrC");
                }
                if ((/^\d/).test(text)) {
                  return new Error("Ĥ@ӦrOƦrC");
                }
                return text;
              }
            },
            datanamefilter: {
              filter: function(keyCode) {
                var character = String.fromCharCode(keyCode);
                return (/[\w ]/).test(character);
              },
              validate: function(text) {
                text = text.replace(/\u3000+/g, ' '); // replace zenkaku space with hankaku space
                if (!(/^[\w \uFF65-\uFF9F]*$/).test(text)) {
                  return new Error("r]tLĪrC");
                }
                return text;
              },
              minLen: 0
            },
            comment: { minLen: 0 },
            path: {
              filter: function(keyCode) {
                var character = String.fromCharCode(keyCode);
                return (/[\w:\\]/).test(character);
              },
              validate: function(text) {
                var regexp;
                if (!(/^[\w:\uFF65-\uFF9F\\]*$/).test(text)) {
                  return new Error("r]tLĪrC");
                }
                if (!(/^\w{2,3}:/).test(text)) {
                  return new Error("]ƦWٵLġC");
                }
                if (!(/\\$/).test(text)) {
                  text += '\\';
                }
                return text;
              }
            },
            filepath: {
              filter: function(keyCode) {
                var character = String.fromCharCode(keyCode);
                return (/[\w:\\\.]/).test(character);
              },
              validate: function(text) {
                var regexp;
                if (!(/^[\w:\uFF65-\uFF9F\\\.]*$/).test(text)) {
                  return new Error("r]tLĪrC");
                }
                if (!(/^\w{2,3}:/).test(text)) {
                  return new Error("]ƦWٵLġC");
                }
                return text;
              }
            },
            alarmNum: {
              filter: function (keyCode) {
                var text = String.fromCharCode(keyCode),
                    allowed = "\\d";
                return (new RegExp("[" + allowed + "]")).test(text);
              },
              validate: function (text) {
                var allowed = /\D/g;
                if (text === "") {
                  return text;
                }
                if (allowed.test(text)) {
                  return new Error("oӦrꤣOƦrC");
                }
                else {
                  var paddingStr = "0",
                      padding = "";
                  for (var i = 0; i < config.maxLen; i++) {
                    padding = padding + paddingStr;
                  }
                  return (padding + text).slice(-3);
                }
              },
              minLen: 0
            }
          };
      if (mode !== undefined && mode in configs) {
        var configMode = configs[mode];
        if ("validate" in configMode) config.validate = configMode.validate;
        if ("filter" in configMode) config.filter = configMode.filter;
        if ("minLen" in configMode) config.minLen = configMode.minLen;
      }
    },
    setConfig: function(filter, validate, minLen) {
      var elem = this,
          config = elem.config;
      if (typeof validate === 'function') config.validate = validate;
      if (typeof filter === 'function') config.filter = filter;
      if (typeof minLen === 'number') config.minLen = minLen;
    },
    setCallback: function (callback) {
      var elem = this;
      elem.config.callback = callback;
    },
    refresh: function(text, maxLen, disabled, validated) {
      var elem = this,
          config = elem.config;
      config.maxLen = maxLen;
      if (text !== config.oldText) {
        elem.value = (validated) ? config.func.validate(text, config) : text;
        config.oldText = elem.value;
      }
      turnOnOffClass(elem, "textbox-no-text", !disabled && config.minLen > 0 && text.length === 0);
      elem.disabled = disabled;
    },
    getValue: function() {
      var elem = this;
      return elem.value;
    },
    notifyChanged: function(text, operation) {
      var elem = this,
          config = elem.config,
          validated;
      validated = config.func.validate(text, config);
      if (validated instanceof Error) {
        elem.value = config.oldText;
        turnOnOffClass(elem, "textbox-no-text", config.minLen > 0 && elem.value.length === 0);
        alertMessage(validated.message, function() {
          elem.blur();
        });
        return false;
      }
      else {
        config.oldText = validated;
        elem.value = validated;
        notifyTextboxChanged(elem, validated, operation, config);
        return true;
      }
    },
    onblur: function(event) {
      var elem = event.srcElement,
          config = elem.config;
      if (elem.value !== config.oldText) {
        elem.notifyChanged(elem.value, "blur");
      }
      UIFComponents.global.selectedTextbox = null;
      if (isTablet()) inputFocusSlideForm(elem, false);
      return false;
    },
    onkeypress: function(event) {
      var elem = event.srcElement,
          config = elem.config,
          key = event.keyCode,
          allowed;
      if (key !== 13) {
        allowed = config.func.filter(key, elem.value, config);
        if (!allowed && event.preventDefault) event.preventDefault();
        return allowed;
      }
      else {
        if (elem.value === config.oldText) {
          elem.select();
        }
        else {
          elem.notifyChanged(elem.value, "enter");
        }
        return false;
      }
    },
    onkeyup: function(event) {
      var elem = event.srcElement,
          config = elem.config;
      turnOnOffClass(elem, "textbox-no-text", config.minLen > 0 && elem.value.length === 0);
      return true;
    },
    onfocus: function(event) {
      var elem = event.srcElement,
          config = elem.config;
      if (config.mode !== 'path') {
        elem.select();
      }
      if (config.mode !== "alarmNum") SIPManager.showKeyboard();
      UIFComponents.global.selectedTextbox = elem;
      if (isTablet()) inputFocusSlideForm(elem, true);
      return false;
    },
    setFocus: function(){
      var elem = this,
          textbox = elem.ownerDocument.getElementById(elem.id);
      textbox.focus();
    },
    onpaste: function(event) {
      // onpaste event occur when input on the SIP keyboard is done.
      var elem = event.srcElement;
      setTimeout(function() {
        var config = elem.config,
            doc, keyEvent;
        if (elem.value !== config.oldText) {
          doc = elem.ownerDocument;
          triggerEvent(elem, 'keypress', {keyCode: 13});
        }
      }, 0);
      return true;
    },
    func: {
      textNumBytes: function(text) {
        var numBytes = 0,
            len, i, charCode;
        for (i = 0, len = text.length; i < len; i++) {
          charCode = text.charCodeAt(i); // charCode is returned in UNICODE
          if ((charCode >= 0x00   && charCode <= 0xFF) ||   // latin-1
              (charCode >= 0xFF65 && charCode <= 0xFF9F)) { // hankaku katakana
            numBytes += 1;
          }
          else {
            numBytes += 2;
          }
        }
        return numBytes;
      },
      filter: function(keyCode, text, config) {
        var func = this,
            result = true;
        if (func.textNumBytes(text) > config.maxLen - 1) {
          result = false;
        }
        else if (typeof config.filter === 'function') {
          result = config.filter.apply(this, [keyCode]);
        }
        return result;
      },
      validate: function(text, config) {
        var func = this,
            result = text,
            numBytes;
        if (typeof config.validate === 'function') {
          result = config.validate.apply(this, [text]);
        }
        // String length should be checked after calling config.validate,
        // because config.validate may modify string.
        if (typeof result === "string") {
          numBytes = func.textNumBytes(result);
          if (numBytes > config.maxLen) {
            result = new Error("rLC");
          }
          else if (numBytes < config.minLen) {
            result = new Error("rLuC");
          }
        }
        return result;
      }
    }
  },

  checkbox: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
      elem.setAlertMessage = type.setAlertMessage;
      elem.config = config;
      addEventHandler(elem, "click", type.onclick);
      addEventHandler(elem, "keypress", type.onkeypress);
    },
    refresh: function(checked, disabled) {
      var elem = this;
      elem.checked = checked;
      elem.disabled = disabled;
    },
    onclick: function(event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument),
          config = elem.config;
      if (typeof config.alertMessage === 'function' &&
        (config.dispAlertChecked === undefined || elem.checked === config.dispAlertChecked)) {
        config.alertMessage();
      }
      VTRNRequest(frame, { request: elem.id + ".clicked", value: elem.checked }).send();
    },
    onkeypress: function(event) {
      var elem = event.srcElement;
      if (event.keyCode === 13) {
        elem.click();
      }
    },
    setAlertMessage: function (message, dispAlertChecked) {
      var elem = this,
          config = elem.config;
      config.alertMessage = function() {alertMessage(message);};
      config.dispAlertChecked = dispAlertChecked;
    }
  },

  label: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
    },
    refresh: function(text, color, disabled, isHTML) {
      var elem = this;
      if (isHTML) {
        elem.innerHTML = text;
      }
      else {
        elem.innerText = text;
      }
      if (typeof color === "string") {
        elem.style.color = (color.charAt(0) === "#") ? color : colorTable[color];
      }
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
    }
  },

  labelType: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
    },
    refresh: function(image, name, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          img = doc.getElementById(elem.id + ".image"),
          span = doc.getElementById(elem.id + ".name");
      span.innerText = name;
      img.style.backgroundImage = format('url(images/%s)', image);
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
    }
  },

  labelToolName: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
    },
    refresh: function(image, name, trained) {
      var elem = this,
          doc = elem.ownerDocument,
          img = doc.getElementById(elem.id + ".image"),
          text = img.nextSibling,
          ins = doc.getElementById(elem.id + ".trained");
      if (ins) {
        if (trained) {
          replaceClass(ins, "vsbttn-not-trained", "vsbttn-trained");
        }
        else {
          replaceClass(ins, "vsbttn-trained", "vsbttn-not-trained");
        }
      }
      img.src = "images/" + image;
      text.nodeValue = name;
    }
  },

  thumbnail: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
      elem.getSource = type.getSource;
    },
    refresh: function(src, text) {
      var elem = this,
          frame = getDefaultView(elem.ownerDocument),
          img = frame.document.getElementById(elem.id + ".image"),
          textNode;
      if (src !== null) {
        img.src = src;
      }
      refreshText(elem, (typeof text === 'string') ? text : '');
      turnOnOffClass(img, "hide", (src === null));
    },
    getSource: function() {
      var elem = this,
          frame = getDefaultView(elem.ownerDocument),
          img = frame.document.getElementById(elem.id + ".image");
      return img.src;
    }
  },

  interactiveButton: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      addEventHandler(elem, "click", type.onclick);
      elem.config = config;
      elem.refresh = type.refresh;
    },
    refresh: function(disabled) {
      var elem = this;
      elem.disabled = disabled;
      turnOnOffClass(elem, 'disabled', disabled);
    },
    onclick: function(event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument);
      VTRNRequest(frame, { request: elem.id + ".clicked" }).send();
    }
  },

  treeview: {
    init: function(doc, id, config) {
      var root = doc.getElementById(id),
          type = this;
      config.expanded = {};
      root.config = config;
      var methods = [
        'refresh',
        'getSelectedText',
        'getSelectedProps',
        'getSelectedNode',
        'openNode',
        'closeNode'
      ];
      for (var i = 0, len = methods.length; i < len; i++) {
        root[methods[i]] = type[methods[i]];
      }
      addEventHandler(root, "click", type.onclick);
    },
    refresh: function(json, selected, disabled) {

      function cleanJSON(json) {
        var children = json.children,
            newChildren = [],
            child;
        for (var i = 0, len = children.length; i < len; i++) {
          child = children[i];
          if (child !== undefined) {
            newChildren.push(child);
            cleanJSON(child);
          }
        }
        json.children = newChildren;
      }

      function buildExpanded(expanded, json) {
        function buildExpandedRecurse(oldExpanded, json, newExpanded) {
          var data = json.data,
              children = json.children,
              value = data.value,
              added = false;
          for (var i = 0, len = children.length; i < len; i++) {
            added |= buildExpandedRecurse(oldExpanded, children[i], newExpanded);
          }
          if (oldExpanded[value] === undefined) added = true;
          newExpanded[value] = added ? true : oldExpanded[value];

          return added;
        }
        var newExpanded = [];
        buildExpandedRecurse(expanded, json, newExpanded);
        return newExpanded;
      }

      function nodeHTML(json, selected, expanded, last) {
        var data = json.data,
            children = json.children,
            numChildren = children.length,
            liClass = data.className,
            icon = null,
            value = data.value,
            attr, type, html;

        if (!(/\b(vstree-leaf|vstree-open|vstree-closed)\b/).test(liClass)) {
          liClass += (numChildren === 0) ? ' vstree-leaf'
                   : (expanded[value])   ? ' vstree-open'
                   :                       ' vstree-closed';
        }

        attr = (typeof data.attr === 'string' && data.attr !== "") ? (' data-attr="' + data.attr + '"') : "";

        if (last) liClass += ' vstree-last';
        if (value === selected) data.className += ' vstree-selected';
        html = [
          '<li class="',
          liClass,
          '" id="',
          value,
          '"',
          attr,
          '><ins class="vstree-mark">&nbsp;</ins><a class="',
          data.className,
          '" href="javascript:void(0);"><ins style="background-image: url(',
          data.icon,
          ');" class="vstree-icon">&nbsp;</ins>',
          data.text
        ];
        if (/\b(vstree-trained)\b/.test(liClass)) icon = "vsbttn-trained";
        if (/\b(vstree-not-trained)\b/.test(liClass)) icon = "vsbttn-not-trained";
        if (icon !== null) {
          html.push(format('<ins class="vstree-check-icon %s">&nbsp;</ins>', icon));
        }
        html.push('</a>');
        if (numChildren > 0) {
          html.push('<ul>');
          for (var i = 0; i < numChildren; i++) {
            html.push(nodeHTML(children[i], selected, expanded, (i == numChildren - 1) ? true : false));
          }
          html.push('</ul>');
        }
        html.push('</li>');
        return html.join('');
      }

      var root = this;
      var htmls = [];
      if (json !== null) {
        if (json.length === 0) {
          root.config.expanded = [];
        }
        else {
          removeLastUndefined(json);
          for (var i = 0, len = json.length; i < len; i++) {
            cleanJSON(json[i]);
            root.config.expanded = buildExpanded(root.config.expanded, json[i]);
            htmls.push([
              '<ul>',
              nodeHTML(json[i], selected, root.config.expanded, (i === len - 1)),
              '</ul>'
            ].join(''));
          }
        }
        root.innerHTML = htmls.join('');
      }
      root.disabled = disabled;
      turnOnOffClass(root, 'disabled', disabled);
      scrollTo(root, findDescendant(root, 'a', 'vstree-selected'));
    },
    onclick: function(event) {
      var target = event.srcElement,
          root = findAncestor(target, 'div', 'vstree'),
          config = root.config,
          frame = getDefaultView(target.ownerDocument),
          value, props;
      if (root.disabled) return false;

      if (target.tagName === 'INS' &&
          (hasClass(target, 'vstree-icon') ||
           hasClass(target, 'vstree-check-icon'))) {
        target = target.parentNode;
      }

      if (target.tagName === 'A') {
        if (!hasClass(target, 'vstree-selected')) {
          addClassExclusively(root, target, 'vstree-selected');
          props = root.getSelectedProps();
          if (props !== null) {
            setTimeout(function() {
              if (typeof config.onclick === 'function') {
                config.onclick(root, props);
              }
              else {
                VTRNRequest(frame, { request: root.id + ".clicked", value: props.value }).send();
              }
            }, 0);
          }
        }
        event.returnValue = false; // prevent default action
      }
      else if (target.tagName === 'INS' && hasClass(target, 'vstree-mark')) {
        target = target.parentNode;
        if (hasClass(target, 'vstree-open')) {
          root.closeNode(target);
        }
        else if (hasClass(target, 'vstree-closed')) {
          root.openNode(target);
        }
      }
      return false;
    },
    getSelectedNode: function() {
      var root = this;
      return findDescendant(root, 'a', 'vstree-selected');
    },
    getSelectedProps: function() {
      var root = this,
          selected = root.getSelectedNode(),
          node;
      if (selected === null) return null;
      node = selected.parentNode;
      return {
        // text: getText(selected), // This line is time-consuming.
        value: node.id,
        attr: node.getAttribute('data-attr')
      };
    },
    getSelectedText: function() {
      var root = this,
          props = root.getSelectedProps();
      return (props !== null) ? props.value : "";
    },
    openNode: function(node) {
      var root = this,
          frame = getDefaultView(node.ownerDocument),
          text = node.id;
      replaceClass(node, 'vstree-closed', 'vstree-open');
      root.config.expanded[text] = true;
      VTRNRequest(frame, { request: root.id + ".open", value: text }).send();
    },
    closeNode: function(node) {
      var root = this,
          frame = getDefaultView(node.ownerDocument),
          text = node.id;
      replaceClass(node, 'vstree-open', 'vstree-closed');
      root.config.expanded[text] = false;
      VTRNRequest(frame, { request: root.id + ".close", value: text }).send();
    }
  },
  treeSelect: {
    init: function(doc, id, config) {
      var root = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;
      config.expanded = {};
      config.handleKeys = null;
      root.config = config;
      var methods = [
        'refresh',
        'getValue',
        'getSelectedProps',
        'getSelectedNode',
        'scrollToSelected',
        'selectNode',
        'selectClosedNode',
        'openNode',
        'closeNode',
        'handleKeys'
      ];
      for (var i = 0, len = methods.length; i < len; i++) {
        root[methods[i]] = type[methods[i]];
      }
      root.delayedSelectNode = debounce(function(nextSelected) {
        root.selectNode(nextSelected);
      }, 200);
      addEventHandler(frame, "load", function() {
        KeyEvent.addHandler(function(event) { return root.handleKeys(event); }, frame, false);
      });
      addEventHandler(root, "click", type.onclick);
    },
    refresh: function(json, selected, disabled) {

      function cleanJSON(json) {
        var children = json.children,
            newChildren = [],
            child;
        for (var i = 0, len = children.length; i < len; i++) {
          child = children[i];
          if (child !== undefined) {
            newChildren.push(child);
            cleanJSON(child);
          }
        }
        json.children = newChildren;
      }

      function buildExpanded(expanded, json) {
        function buildExpandedRecurse(oldExpanded, json, newExpanded) {
          var data = json.data,
              children = json.children,
              value = data.value,
              added = false;
          for (var i = 0, len = children.length; i < len; i++) {
            added |= buildExpandedRecurse(oldExpanded, children[i], newExpanded);
          }
          if (oldExpanded[value] === undefined) added = true;
          newExpanded[value] = added ? true : oldExpanded[value];

          return added;
        }
        var newExpanded = [];
        buildExpandedRecurse(expanded, json, newExpanded);
        return newExpanded;
      }

      function nodeHTML(json, selected, expanded, last) {
        var data = json.data,
            children = json.children,
            numChildren = children.length,
            liClass = data.className,
            value = data.value,
            tagArrow, tagIcon,
            attr, type, html;

        if (!(/\b(tree-select-leaf|tree-select-open|tree-select-closed)\b/).test(liClass)) {
          liClass += (numChildren === 0) ? ' tree-select-leaf'
                   : (expanded[value])   ? ' tree-select-open'
                   :                       ' tree-select-closed';
        }

        attr = (typeof data.attr === 'string' && data.attr !== "") ? (' data-attr="' + data.attr + '"') : "";
        tagArrow = (numChildren === 0) ? '' : '<ins class="tree-select-arrow"></ins>';
        tagIcon = data.icon ? format('<ins style="background-image: url(%s);" class="tree-select-icon"></ins>', data.icon) : '';

        if (last) liClass += ' tree-select-last';
        if (value === selected && numChildren === 0) data.className += ' tree-select-selected';
        html = [
          '<li class="',
          liClass,
          '" id="',
          value,
          '"',
          attr,
          '><a class="tree-select-node ',
          data.className,
          '" href="javascript:void(0);" tabindex="-1">',
          tagArrow,
          tagIcon,
          data.text,
          '</a>'
        ];
        if (numChildren > 0) {
          html.push('<ul>');
          for (var i = 0; i < numChildren; i++) {
            html.push(nodeHTML(children[i], selected, expanded, (i == numChildren - 1) ? true : false));
          }
          html.push('</ul>');
        }
        html.push('</li>');
        return html.join('');
      }

      var root = this,
          htmls = [];
      if (json !== null) {
        if (json.length === 0) {
          root.config.expanded = [];
        }
        else {
          removeLastUndefined(json);
          for (var i = 0, len = json.length; i < len; i++) {
            cleanJSON(json[i]);
            root.config.expanded = buildExpanded(root.config.expanded, json[i]);
            htmls.push([
              '<ul>',
              nodeHTML(json[i], selected, root.config.expanded, (i === len - 1)),
              '</ul>'
            ].join(''));
          }
        }
        root.innerHTML = htmls.join('');
      }
      root.disabled = disabled;
      turnOnOffClass(root, 'disabled', disabled);
      root.scrollToSelected();
      root.selectClosedNode(root.getSelectedNode());
    },
    selectNode: function(target) {
      var root = this,
          config = root.config,
          frame = getDefaultView(target.ownerDocument),
          props;
      addClassExclusively(root, target, 'tree-select-selected');
      root.selectClosedNode(target);
      props = root.getSelectedProps();
      if (props !== null) {
        window.setTimeout(function() {
          if (typeof config.onclick === 'function') {
            config.onclick(root, props);
          }
          else {
            VTRNRequest(frame, { request: root.id + ".clicked", value: props.value }).send();
          }
        }, 0);
      }
    },
    selectClosedNode: function(target) {
      var root = this,
          closedNode;
      closedNode = findLastAncestor(target, 'li', 'tree-select-closed');
      if (closedNode !== null) {
        addClassExclusively(root, closedNode, 'tree-select-closed-selected');
      }
      else {
        closedNode= findDescendant(root, 'li', 'tree-select-closed-selected');
        if (closedNode !== null) {
          removeClass(closedNode, 'tree-select-closed-selected');
        }
      }
    },
    onclick: function(event) {
      var target = event.srcElement,
          doc = target.ownerDocument,
          root = findAncestor(target, 'div', 'tree-select'),
          config = root.config,
          frame = getDefaultView(doc),
          tagName = target.tagName,
          className = target.className,
          li, value, props;
      if (root.disabled) return false;
      if (tagName === 'INS' &&
          (className === 'tree-select-icon' ||
           className === 'tree-select-arrow')) {
        target = target.parentNode;
        tagName = target.tagName;
        className = target.className;
      }

      if (tagName === 'A') {
        li = target.parentNode;
        if (hasClass(li, 'tree-select-leaf')) {
          if (!hasClass(target, 'tree-select-selected')) {
            root.selectNode(target);
          }
        }
        else if (hasClass(li, 'tree-select-open')) {
          root.closeNode(li);
        }
        else if (hasClass(li, 'tree-select-closed')) {
          root.openNode(li);
        }
        event.returnValue = false; // prevent default action
      }
      return false;
    },
    getSelectedNode: function() {
      var root = this;
      return findDescendant(root, 'a', 'tree-select-selected');
    },
    getSelectedProps: function() {
      var root = this,
          selected = root.getSelectedNode(),
          node;
      if (selected === null) return null;
      node = selected.parentNode;
      return {
        value: node.id,
        attr: node.getAttribute('data-attr')
      };
    },
    getValue: function() {
      var root = this,
          props = root.getSelectedProps();
      return (props !== null) ? props.value : "";
    },
    openNode: function(node) {
      var root = findAncestor(node, 'div', 'tree-select'),
          frame = getDefaultView(node.ownerDocument),
          text = node.id;
      replaceClass(node, 'tree-select-closed', 'tree-select-open');
      root.selectClosedNode(root.getSelectedNode());
      root.config.expanded[text] = true;
      VTRNRequest(frame, { request: root.id + ".open", value: text }).send();
    },
    closeNode: function(node) {
      var root = findAncestor(node, 'div', 'tree-select'),
          frame = getDefaultView(node.ownerDocument),
          text = node.id;
      replaceClass(node, 'tree-select-open', 'tree-select-closed');
      root.selectClosedNode(root.getSelectedNode());
      root.config.expanded[text] = false;
      VTRNRequest(frame, { request: root.id + ".close", value: text }).send();
    },
    handleKeys: function(event) {
      var root = this,
          doc = root.ownerDocument,
          config = root.config,
          currSelected = root.getSelectedNode(),
          liSelected, currNode,
          dist = 0,
          idxSelected = -1,
          idxNext, leafNodes, openNodes, closedNode, nextSelected, numLeaves;

      if (root.offsetHeight === 0) return true;
      if (currSelected === null) return true;

      liSelected = currSelected.parentNode;

      switch (event.keyCode) {
      case 37: // left arrow
        currNode = findLastAncestor(currSelected, 'li', 'tree-select-closed');
        if (currNode !== null) {
          root.openNode(currNode);
          return false;
        }
        break;
      case 39: // right arrow
        currNode = findAncestor(liSelected, 'li', 'tree-select-open');
        if (currNode !== null) {
          root.closeNode(currNode);
          return false;
        }
        break;
      }

      dist = keyEventToDistance(event);
      if (dist === 0) return true;

      leafNodes = findDescendants(root, 'li', 'tree-select-leaf');
      openNodes = [];
      numLeaves = leafNodes.length;
      for (var i = 0; i < numLeaves; i++) {
        closedNode = findAncestor(leafNodes[i], 'li', 'tree-select-closed');
        if (closedNode === null ||
            leafNodes[i] === liSelected ||
            (dist > 0 && leafNodes[i].previousSibling === null) ||
            (dist < 0 && leafNodes[i].nextSibling === null)) {
          openNodes.push(leafNodes[i]);
        }
      }
      numLeaves = openNodes.length;
      if (numLeaves === 0) return true;

      if (!UIFComponents.global.isIEMobile && event.keyCode === 9) { // tab key is ignored on PC
        return true;
      }

      if (dist > 0 && liSelected === openNodes[numLeaves - 1]) {
        idxNext = 0;
      }
      else if (dist < 0 && liSelected === openNodes[0]) {
        idxNext = numLeaves - 1;
      }
      else {
        for (i = 0; i < numLeaves; i++) {
          if (openNodes[i] === liSelected) {
            idxSelected = i;
          }
        }
        if (idxSelected < 0) return true;

        idxNext = idxSelected + dist;

        idxNext = Math.max(idxNext, 0);
        idxNext = Math.min(idxNext, numLeaves - 1);
      }
      nextSelected = firstElementNode(openNodes[idxNext]);
      addClassExclusively(root, nextSelected, 'tree-select-selected');
      root.delayedSelectNode(nextSelected);
      root.scrollToSelected();
      return false;
    },
    scrollToSelected: function() {
      var root = this,
          config = root.config,
          selected = root.getSelectedNode();
      if (selected === null) return;
      scrollTo(root.parentNode, selected, 0);
    }
  },
  listview: {
    init: function(doc, id, config) {
      var root = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;
      root.config = {
        sortKey: 0,
        sortType: 'asc',
        handleKeys: null,
        keyHandlers: [],
        timeoutId: null
      };
      root.refresh = type.refresh;
      root.sortRows = type.sortRows;
      root.addRows = type.addRows;
      root.refreshTable = type.refreshTable;
      root.scrollToSelected = type.scrollToSelected;
      root.getSelectedValue = type.getSelectedValue;
      root.selectRow = type.selectRow;
      root.sortArrayRows = type.sortArrayRows;
      root.handleKeys = type.handleKeys;
      root.addKeyHandler = type.addKeyHandler;
      addEventHandler(root, "click", type.onclick);

      // IE11 does not suppurt CSS expression and position sticky.
      if (getIEVersion(window.navigator.userAgent) > 7) {
        addEventHandler(root.parentNode, "scroll", function(event) {
          var target = event.srcElement,
              root = findDescendant(target, 'div', 'vslist'),
              table = firstElementNode(root),
              thead = firstElementNode(table),
              tr = firstElementNode(thead),
              value = target.scrollTop + 'px',
              td;
          for (td = firstElementNode(tr); td !== null; td = nextElementNode(td)) {
            td.style.top = value;
            td.style.position = 'relative';
          }
          return false;
        });
      }

      if (!UIFComponents.global.isIEMobile &&
          "dblclick" in config && config.dblclick === "true") {
        addEventHandler(root, "dblclick", type.ondblclick);
      }

      if ("focus" in config && config.focus === "false") {
        root.config.focus = false;
        addEventHandler(frame, "load", function() {
          KeyEvent.addHandler(function(event) { return root.handleKeys(event, false); }, frame, false);
        });
      }
      else {
        root.config.focus = true;
        addEventHandler(root, "focus", type.onfocus);
        addEventHandler(root, "blur", type.onblur);
      }
    },
    refresh: function(json, selected, disabled) {
      var root = this,
          config = root.config,
          sortKey = config.sortKey,
          sortType = config.sortType,
          table = firstElementNode(root),
          thead = firstElementNode(table),
          numCols = json.head ? json.head.length - 1 : firstElementNode(thead).children.length,
          innerHead = ('head' in json) ? theadHTML(json.head, sortKey, sortType) : null,
          innerBody = ('body' in json) ? tbodyHTML(json.body, sortKey, sortType, numCols) : null,
          tbody, tr;

      turnOnOffClass(root, 'vslist-categorized', (json.body && json.body[0] && json.body[0].category));

      root.refreshTable(innerHead, innerBody);

      table = firstElementNode(root);
      thead = firstElementNode(table);
      tbody = nextElementNode(thead);

      tr = firstElementNode(thead);
      if (tr && firstElementNode(tr)) {
        addClass(firstElementNode(tr), 'first');
      }
      if (selected !== null) {
        for (tr = firstElementNode(tbody); tr !== null; tr = nextElementNode(tr)) {
          if (firstElementNode(tr) !== null && getText(firstElementNode(tr)) === selected) {
            addClassExclusively(tbody, tr, 'vslist-selected');
            break;
          }
        }
      }
      root.scrollToSelected();

      if (table.disabled !== disabled) {
        table.disabled = disabled;
        turnOnOffClass(table, 'disabled', disabled);
      }

      function theadHTML(json, sortKey, sortType) {
        var html = [],
            classes;
        html.push('<tr>');
        for (var i = 0, len = json.length; i < len; i++) {
          if (json[i] === undefined) break;
          classes = [];
          if (i === sortKey) classes.push('vslist-sort-' + sortType);
          html.push('<th');
          if (classes.length > 0) html.push(' class="' + classes.join(' ') + '"');
          html.push('>');
          html.push(json[i]);
          html.push('</th>');
        }
        html.push('</tr>');
        return html.join('');
      }

      function tbodyRowHTML(json, sortKey, sortType) {
        var arrayRows = [],
            row, cell, className, value, cells, html, key;
        for (var i = 0, numRows = json.length; i < numRows; i++) {
          row = json[i];
          if (row === undefined) break;

          className = row.className === undefined ? '' : ' class="' + row.className + '"';
          value = row.value === undefined ? '' : ' data-value="' + row.value + '"';
          cells = row.cells;

          html = [];
          html.push('<tr' + className + value + '>');
          for (var j = 0, numCells = cells.length; j < numCells; j++) {
            cell = cells[j];
            if (cell === undefined) break;

            if (typeof cell === "object") {
              html.push('<td');
              if ('className' in cell) {
                html.push(format(' class="%s"', cell.className));
              }
              if ('key' in cell) {
                html.push(format(' data-value="%s"', cell.key));
              }
              if ('bgcolor' in cell) {
                html.push(format(' style="background-color: %s;"', cell.bgcolor));
              }
              if ('title' in cell) {
                html.push(format(' title="%s"', cell.title));
              }
              html.push('>');
              if ('image' in cell) {
                html.push('<img class="vslist-img" src="images/');
                html.push(cell.image);
                html.push('" align="absmiddle">');
              }
              html.push(cell.text);
              html.push('</td>');
            }
            else {
              html.push('<td>');
              html.push(cell);
              html.push('</td>');
            }
          }
          html.push('</tr>');

          key = cells[sortKey];
          if (typeof key === 'object') {
            key = ('key' in key) ? key.key : key.text;
          }
          arrayRows.push({ key: key, node: html.join('') });
        }
        return root.sortArrayRows(arrayRows, sortType);
      }
      function tbodyHTML(json, sortKey, sortType, numCols) {
        var category, className, html;

        if (json.length == 0) return '';

        if (json[0].category) {
          html = [];
          for (var i = 0, numCategorys = json.length; i < numCategorys; i++) {
            category = json[i];
            if (category === undefined) break;

            if (category.category) {
              className = (category.className === undefined) ? '' : category.className;
              html.push(format('<tr class="vslist-category %s">', className));
              html.push(format('<td colspan="%s">', numCols));
              html.push(format('<div class="vslist-category-underline">%s</div>', category.text));
              html.push('</td></tr>');
              html.push(tbodyRowHTML(category.rows, sortKey, sortType));
            }
          }
          return html.join('');
        }
        else {
          return tbodyRowHTML(json, sortKey, sortType);
        }
      }
    },
    addRows: function(json) {
      var root = this,
          doc = root.ownerDocument,
          table = firstElementNode(root),
          thead = firstElementNode(table),
          tbody = nextElementNode(thead),
          tr, td,
          row, cell, className, value, cells, html, key;
      for (var i = 0, numRows = json.length; i < numRows; i++) {
        row = json[i];
        if (row === undefined) break;

        cells = row.cells;

        tr = doc.createElement('tr');
        if (row.className !== undefined) tr.className = row.className;
        if (row.value !== undefined) {
          tr.setAttribute('data-value', row.value);
        }

        for (var j = 0, numCells = cells.length; j < numCells; j++) {
          cell = cells[j];
          if (cell === undefined) break;

          td = doc.createElement('td');
          if (typeof cell === "object") {
            if ('image' in cell) {
              td.src = 'images/' + cell.image;
            }
            td.align = 'absmiddle';
            td.innerText = cell.text;
            if ('className' in cell) {
              td.className = cell.className;
            }
            if ('key' in cell) {
              td.setAttribute('data-value', cell.key);
            }
            if ('bgcolor' in cell) {
              td.style.backgroundColor = cell.bgcolor;
            }
          }
          else {
            td.innerText = cell;
          }
          tr.appendChild(td);
        }
        tbody.appendChild(tr);
      }
      root.sortRows();
    },
    sortRows: function() {
      var root = this,
          config = root.config,
          table = firstElementNode(root),
          thead = firstElementNode(table),
          tbody = nextElementNode(thead),
          firstRow = firstElementNode(tbody),
          arrayRows, html, tr, innerBody;

      if (firstRow === null) return;

      function getKey(cell) {
        var key = cell.getAttribute('data-value');
        if (!key) key = getText(cell);
        return key;
      }
      if (hasClass(firstRow, 'vslist-category')) {
        html = [];
        tr = firstRow;
        while (tr !== null) {
          arrayRows = [];
          html.push(tr.outerHTML);
          for (tr = nextElementNode(tr); tr !== null && !hasClass(tr, 'vslist-category'); tr = nextElementNode(tr)) {
            arrayRows.push({ key: getKey(tr.children[config.sortKey]), node: tr.outerHTML });
          }
          html.push(root.sortArrayRows(arrayRows, config.sortType));
        }
        innerBody = html.join('');
      }
      else {
        arrayRows = [];
        for (tr = firstRow; tr !== null; tr = nextElementNode(tr)) {
          arrayRows.push({ key: getKey(tr.children[config.sortKey]), node: tr.outerHTML });
        }
        innerBody = root.sortArrayRows(arrayRows, config.sortType);
      }
      root.refreshTable(null, innerBody);
    },
    refreshTable: function(innerHead, innerBody) {
      var root = this,
          oldHTML = root.innerHTML,
          newHTML = oldHTML;

      if (innerHead !== null) {
        newHTML = newHTML.replace(/(<thead[^>]*>)[^\0]*?(<\/thead>)/i, '$1' + innerHead + '$2');
      }

      if (innerBody !== null) {
        newHTML = newHTML.replace(/(<tbody[^>]*>)[^\0]*?(<\/tbody>)/i, '$1' + innerBody + '$2');
      }

      if (oldHTML !== newHTML) {
        newHTML = newHTML.replace(/style="top: *\d+px"/ig, ''); // style top is automatically added to tr and th tag because of css expression.
        root.innerHTML = newHTML;
      }
    },
    sortArrayRows: function(arrayRows, sortType) {
      function sortAsc(a, b) {
        var keyA = a.key,
            keyB = b.key,
            diff;
        if (keyA === keyB) return 0;

        diff = keyA - keyB;
        if (!isNaN(diff)) return diff;

        return (keyA < keyB) ? -1 : 1;
      }

      function sortDesc(a, b) {
        return -1 * sortAsc(a, b);
      }

      var arrayHTML = [],
          i, len, key, funcSort, row;

      funcSort = sortType === "desc" ? sortDesc : sortAsc;

      for (i = 0, len = arrayRows.length; i < len; i++) {
        row = arrayRows[i];
        key = row.key;
        if ((/^[-+]?\d*,\d+$/).test(key)) row.key = key.replace(/,/, ".");
      }

      arrayRows.sort(funcSort);

      for (i = 0, len = arrayRows.length; i < len; i++) {
        arrayHTML.push(arrayRows[i].node);
      }

      return arrayHTML.join('');
    },
    scrollToSelected: function() {
      var root = this,
          config = root.config,
          container = root.parentNode,
          table = firstElementNode(root),
          thead = firstElementNode(table),
          tbody = nextElementNode(thead),
          selected = findDescendant(tbody, 'tr', 'vslist-selected');
      if (config.focus) {
        root.tabIndex = (firstElementNode(tbody) === null) ? -1 : 0; // enable tab stop if selected element exists
      }
      if (selected === null) return;
      scrollTo(container, selected, thead.offsetHeight);
    },
    getSelectedValue: function() {
      var root = this,
          table = firstElementNode(root),
          thead = firstElementNode(table),
          tbody = nextElementNode(thead),
          selected = findDescendant(tbody, 'tr', 'vslist-selected'),
          value;
      if (selected === null) return "";
      value = selected.getAttribute('data-value');
      if (value === null || value === '') value = getText(firstElementNode(selected));
      return value;
    },
    selectRow: function(row, timeout) {
      var root = this,
          frame = getDefaultView(root.ownerDocument),
          config = root.config,
          tbody = row.parentNode,
          value;

      addClassExclusively(tbody, row, 'vslist-selected');
      root.scrollToSelected();

      if (config.timeoutId !== null) {
        frame.clearTimeout(config.timeoutId);
      }

      value = row.getAttribute('data-value');
      if (value === null || value === '') value = getText(firstElementNode(row));

      config.timeoutId = frame.setTimeout(function() {
        if (isFrameExist(frame)) { // Check whether the frame still exists.
          VTRNRequest(frame, { request: root.id + ".clicked", value: value }).send();
        }
        else {
          if (config.handleKeys !== null) {
            KeyEvent.removeHandler(config.handleKeys);
            config.handleKeys = null;
          }
        }
        config.timeoutId = null;
      }, timeout);
    },
    ondblclick: function(event) { // for PC
      var target = event.srcElement,
          root, frame, tr, tbody, value;

      if (target.tagName === 'IMG') {
        target = target.parentNode;
      }
      if (target.tagName === 'TD') {
        tr = target.parentNode;
        tbody = tr.parentNode;
        root = findAncestor(tbody, 'div', 'vslist');
        frame = getDefaultView(root.ownerDocument);
        value = tr.getAttribute('data-value');
        if (value === null || value === '') value = getText(firstElementNode(tr));
        VTRNRequest(frame, { request: root.id + ".dblclicked", value: value }).send();
        return false;
      }
      return true;
    },
    onclick: function(event) {
      var target = event.srcElement,
          root = findAncestor(target, 'div', 'vslist'),
          config = root.config,
          tr, sortType, sortKey;

      switch (target.tagName) {
      case 'TH':
        sortType = hasClass(target, "vslist-sort-asc") ? "desc" : "asc";
        sortKey = target.cellIndex;
        tr = target.parentNode;

        removeClass(tr.children[config.sortKey], "vslist-sort-" + config.sortType);
        addClass(target, "vslist-sort-" + sortType);

        config.sortKey = sortKey;
        config.sortType = sortType;

        root.sortRows();
        root.scrollToSelected();
        return false;

      case 'IMG':
      case 'TD':
        if (target.tagName === 'IMG') {
          target = target.parentNode;
        }
        tr = target.parentNode;
        if (hasClass(tr, 'vslist-category')) return false;
        root.selectRow(tr, 0);
        // don't use focus() method, because listivew is scrolled to top from the side effect of the method.
        try {
          if (root.setActive) {
            root.setActive();
          }
          else {
            root.focus();
          }
        } catch (e) {}
        return false;

      default:
        return true;
      }
    },
    addKeyHandler: function(handler) {
      var root = this,
          keyHandlers = root.config.keyHandlers;
      keyHandlers.push(handler);
    },
    handleKeys: function(event, focus) {
      var root = this,
          keyHandlers = root.config.keyHandlers,
          dist = 0,
          direction,
          table = firstElementNode(root),
          thead = firstElementNode(table),
          tbody = nextElementNode(thead),
          currSelected, nextSelected, notHandled;

      currSelected = findDescendant(tbody, 'tr', 'vslist-selected');

      switch (event.keyCode) {
      case 13: /* Enter */
        if (currSelected === null && firstElementNode(tbody) !== null) {
          root.selectRow(firstElementNode(tbody), 0);
        }
        break;
      case 36: /* Home */
        if (currSelected === firstElementNode(tbody)) return true;
        dist = -tbody.childNodes.length;
        break;
      case 35: /* End */
        if (currSelected === tbody.lastChild) return true;
        dist = tbody.childNodes.length;
        break;
      default:
        dist = keyEventToDistance(event);
        break;
      }

      if (dist === 0) {
        for (var i = 0, len = keyHandlers.length; i < len; i++) {
          notHandled = keyHandlers[i](event);
          if (!notHandled) return false;
        }
        return true;
      }

      if (currSelected === null) return true;

      if (focus &&
          event.keyCode === 9 &&
          ((dist > 0 && currSelected === tbody.lastChild) ||
           (dist < 0 && currSelected === firstElementNode(tbody)))) {
        // if current selected row is last one, move focus to another element.
        return true;
      }

      nextSelected = getNextNode(tbody, currSelected, dist, true);
      direction = dist / Math.abs(dist);
      while (hasClass(nextSelected, "vslist-category")) {
        nextSelected = getNextNode(tbody, nextSelected, direction, true);
        if (nextSelected === currSelected) return true;
      }
      if (nextSelected !== null) {
        root.selectRow(nextSelected, 300);
      }
      return false;
    },
    onfocus: function(event) {
      var root = event.srcElement,
          frame = getDefaultView(root.ownerDocument),
          config = root.config;

      if (config.handleKeys !== null) return true;

      config.handleKeys = function(event) { return root.handleKeys(event, true); };
      KeyEvent.addHandler(config.handleKeys, frame, false);
      root.scrollToSelected();

      return false;
    },
    onblur: function(event) {
      var root = event.srcElement,
          config = root.config;

      if (config.handleKeys === null) return true;

      KeyEvent.removeHandler(config.handleKeys);
      config.handleKeys = null;

      return false;
    }
  },
  tab: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.config = config;
      elem.select = type.select;
      if (!("onclick" in config)) {
        addEventHandler(elem, "click", type.onclick);
      }
      addEventHandler(elem, "keypress", type.onkeypress);
    },
    select: function() {
      var elem = this,
          doc = elem.ownerDocument,
          value = elem.config.value,
          page, style;
      page = doc.getElementById(value);
      if (page !== null && !hasClass(page, 'tab-page-selected')) {
        style = page.style;
        style.display = 'block'; // Without this line, tab page is not displayed properly on IE9.
        addClassExclusively(page.parentNode, page, 'tab-page-selected');
        style.display = '';
      }
      addClassExclusively(elem.parentNode, elem, 'tab-selected');
    },
    onclick: function(event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument);
      if (elem.tagName === "INS" || elem.tagName === "IMG") {
        elem = elem.parentNode;
      }
      if (elem.tagName === "LI") {
        elem.select();
        elem.blur();
        setTimeout(function() {
          VTRNRequest(frame, { request: elem.id + ".clicked", value: elem.config.value }).send();
        }, 50);
      }
    },
    onkeypress: function(event) {
      var elem = event.srcElement;
      if (event.keyCode === 13) {
        elem.click();
      }
    }
  },
  tabbar: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
      elem.show = type.show;
    },
    refresh: function(value, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          tabs = findDescendants(elem, "li", "tab"),
          selected, i, len, width, count = 0;
      for (i = 0, len = tabs.length; i < len; i++) {
        tabs[i].disabled = disabled;
        turnOnOffClass(tabs[i], 'disabled', disabled);
        if (tabs[i].config.value === value) {
          selected = tabs[i];
        }
        if (!tabs[i].config.width) {
          count++;
        }
      }
      if (selected !== undefined) {
        selected.select();
      }
      if (count > 0) {
        width = isModernBrowser ? format("calc(100% / %s)", count) : format("%s%", (100.0 - 1) / count);
        for (i = 0, len = tabs.length; i < len; i++) {
          if (!tabs[i].config.width) {
            tabs[i].style.width = width;
          }
        }
      }
    },
    show: function (targetId, show) {
      var elem = this,
          doc = elem.ownerDocument,
          targetElem = doc.getElementById(targetId);
      turnOnOffClass(targetElem, "hide", !show);
      targetElem.config.width = show ? undefined : "0px";
      elem.refresh("", false);
    }
  },
  complexExposure: {
    init: function(doc, id, config) { /* nop */ },
    text: {
      confirmClearAEParam: "O_nM۰n]mH\n\nOKHMAHOdC",
      confirmClearMEParam: "O_nMhn]m?\n\nOKHMAHOdC",
      confirmTrainAEWindow: "z]m۰nϰC\n\nOKH]mAHϥΩTwnC",
      txtOutOfRange: "",
      autoMode: "۰",
      hdrMode: "HDR"
    }
  },
  handleResize: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this,
          words, parts,
          elem1, elem2, value1, value2;
      words = config.elem1.split(' ');
      config.elem1 = {id: words[0], part: words[1]};
      if (typeof words[2] == 'string') {
        config.elemExtra = {id: words[2], index: 1};
      }

      words = config.elem2.split(' ');
      config.elem2 = {id: words[0], part: words[1]};
      if (typeof words[2] == 'string') {
        config.elemExtra = {id: words[2], index: 2};
      }

      function equalParts(parts1, parts2) {
        return ((parts1[0] === parts2[0] && parts1[1] === parts2[1]) ||
                (parts1[0] === parts2[1] && parts1[1] === parts2[0]));
      }

      parts = [config.elem1.part, config.elem2.part];
      if      (equalParts(parts, ['top', 'height'])) {
        config.posKey = 'clientY';
        config.minus = false;
      }
      else if (equalParts(parts, ['bottom', 'height'])) {
        config.posKey = 'clientY';
        config.minus = true;
      }
      else if (equalParts(parts, ['right', 'width'])) {
        config.posKey = 'clientX';
        config.minus = true;
      }
      else if (equalParts(parts, ['left', 'width'])) {
        config.posKey = 'clientX';
        config.minus = false;
      }
      else {
        alert(format('[handleResize] id="%s" invalid parts', id));
        return;
      }

      config.limitKey = (config.posKey == 'clientY') ? 'offsetHeight' : 'offsetWidth';

      if (Cookie) {
        config.cookieName = frame.webpage + ":%s:handleResize";

        elem1 = doc.getElementById(config.elem1.id);
        elem2 = doc.getElementById(config.elem2.id);

        value1 = Cookie.get(format(config.cookieName, elem1.id));
        value2 = Cookie.get(format(config.cookieName, elem2.id));

        if (value1 !== null && value2 !== null) {
          elem1.style[config.elem1.part] = value1;
          elem2.style[config.elem2.part] = value2;
        }
      }

      elem.config = config;

      if (isTablet()) {
        addEventHandler(elem, "touchstart", type.onmousedown);
      }
      else {
        addEventHandler(elem, "mousedown", type.onmousedown);
      }
    },
    onmousedown: function(event) {
      var elem = event.srcElement,
          config = elem.config,
          doc = elem.ownerDocument,
          onmousemove, onmouseup, calcDiff,
          startParams, elem1, elem2, value1, value2;

      if (!hasClass(elem, 'handle')) return true;

      var getPosition = function (event) {
        return isTablet() ? event.touches[0][config.posKey] : event[config.posKey];
      };

      startParams = { pos: getPosition(event) };

      elem1 = doc.getElementById(config.elem1.id);
      elem2 = doc.getElementById(config.elem2.id);

      value1 = getCurrentStyle(elem1)[config.elem1.part];
      value2 = getCurrentStyle(elem2)[config.elem2.part];

      startParams.limit1 = elem1[config.limitKey];
      startParams.limit2 = elem2[config.limitKey];
      startParams.limitExtra = (typeof config.elemExtra === 'object') ? doc.getElementById(config.elemExtra.id)[config.limitKey] : null;

      calcDiff = function(event) {
        var diff = getPosition(event) - startParams.pos;

        var valid = function(startParam, index, diff) {
          var part = config['elem' + index].part,
              margin = 20,
              wh = startParam + diff * ((part == 'width' || part == 'height') ? 1 : -1);
          return (wh > margin);
        };

        var validElem = function(index, diff) {
          return valid(startParams['limit' + index], index, diff);
        };

        var validExtraElem = function(diff) {
          if (startParams.limitExtra === null) return true;
          return valid(startParams.limitExtra, config.elemExtra.index, diff);
        };

        if (diff !== 0) {
          if (config.minus) diff *= -1;
          if (validElem(1, diff) && validElem(2, diff) && validExtraElem(diff)) {
            return diff;
          }
        }
        return 0;
      };

      if (value1.match(/%$/)) {
        startParams.value1 = parseFloat(value1);
        startParams.value2 = parseFloat(value2);
        startParams.parentSize = elem1.offsetParent[config.limitKey];
        onmousemove = function(event) {
          var diff = calcDiff(event);
          if (diff !== 0) {
            var diffPercent = diff / startParams.parentSize * 100;
            if (Math.abs(diffPercent) > 1.0) {
              elem1.style[config.elem1.part] = Math.min(99, Math.max(1, startParams.value1 + diffPercent)) + '%';
              elem2.style[config.elem2.part] = Math.min(99, Math.max(1, startParams.value2 + diffPercent)) + '%';
            }
          }
          return stopPropagation(event);
        };
      }
      else {
        startParams.value1 = Math.round(parseFloat(value1));
        startParams.value2 = Math.round(parseFloat(value2));
        onmousemove = function(event) {
          var diff = calcDiff(event);
          if (diff !== 0) {
            elem1.style[config.elem1.part] = (startParams.value1 + diff) + 'px';
            elem2.style[config.elem2.part] = (startParams.value2 + diff) + 'px';
          }
          return stopPropagation(event);
        };
      }

      var defaultView = getDefaultView(doc),
          docDataSetup = defaultView.document,
          target = isModernBrowser ? docDataSetup : elem;
      onmouseup = function(event) {
        removeEventHandler(target, isTablet() ? "touchmove" : "mousemove", onmousemove);
        removeEventHandler(elem, isTablet() ? "touchend" : "mouseup", onmouseup);
        if (doc !== document) {
          removeEventHandler(document, isTablet() ? "touchendoutside" : "mouseout", onmouseout);
        }
        restoreGlobalMouseEvents(elem, defaultView);
        if (Cookie) {
          var expires = new Date();
          expires.setFullYear(expires.getFullYear() + 1);

          Cookie.store(format(config.cookieName, elem1.id), elem1.style[config.elem1.part], expires);
          Cookie.store(format(config.cookieName, elem2.id), elem2.style[config.elem2.part], expires);
        }
        return false;
      };

      var onmouseout = function(event) {
        var isTopFrame = (doc === document);
        if (isTopFrame && event.srcElement.tagName !== 'HTML') return false;
        // console.log(format("mouseout '%s' '%s'", event.srcElement.tagName, event.srcElement.id));
        onmouseup(event);
        return false;
      };

      addEventHandler(target, isTablet() ? "touchmove" : "mousemove", onmousemove);
      addEventHandler(elem, isTablet() ? "touchend" : "mouseup", onmouseup);
      if (doc !== document) {
        addEventHandler(document, isTablet() ? "touchendoutside" : "mouseout", onmouseout);
      }
      preventGlobalMouseEvents(elem, defaultView);

      return stopPropagation(event);
    }
  },
  funcKeys: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this,
          div, funcKey,
          btnUpDown = doc.getElementById(elem.id + ".updown");

      elem.refresh = type.refresh;
      elem.handleFuncKeys = type.handleFuncKeys;
      KeyEvent.addHandler(function(event) {
        return elem.handleFuncKeys(event);
      }, frame, true);
      if (!UIFComponents.global.isIEMobile) {
        elem.changeNumRows = type.changeNumRows;
        if (findDescendants(elem, 'div', 'func-key-page').length == 2) {
          UIFComponents.global.hasTwoFuncKeyPages = true;
        }
        else if (UIFComponents.global.hasTwoFuncKeyPages && !isCRXMode()) {
          // append dummy funcKeyPage so that the onresize event handler works properly.
          div = doc.createElement('div');
          div.className = 'func-key-page dummy';
          for (var i = 0; i < 5; i++) {
            funcKey = doc.createElement('div');
            addClasses(funcKey, 'func-key disabled');
            div.appendChild(funcKey);
          }
          elem.insertBefore(div, firstElementNode(elem));
        }
        addEventHandler(frame, "load", function (event) {
          elem.changeNumRows();
        });
        addEventHandler(frame, "resize", function (event) {
          elem.changeNumRows();
        });
      }
      if (btnUpDown !== null) {
        addEventHandler(btnUpDown, "click", type.funcKeysUpDown);
      }
      addBodyClass(frame.document.body);
      if (getFrame('frmDataSetup') !== null &&
          getFrame('frmDataSetup').document &&
          hasClass(getFrame('frmDataSetup').document.body, 'func-key-down') &&
          !hasClass(btnUpDown.parentElement, 'func-key-popup')) {
        addClass(btnUpDown.ownerDocument.body, 'func-key-down');
      }
    },
    handleFuncKeys: function(event) {
      var elem = this,
          doc = elem.ownerDocument,
          index = event.keyCode - 48,
          funcKey = null,
          textbox, select, count, fkNext, offset;

      if (!event.ctrlKey || index < 0 || index > 10) return true;

      if (index === 0) index = 10;
      count = 0;
      for (var page = firstElementNode(elem); page !== null && funcKey === null; page = nextElementNode(page)) {
        if (!hasClass(page, "hide")) {
          if (index === 6) { // check if fkNext exists
            fkNext = doc.getElementById(page.id + '.fkNext');
            if (fkNext && !hasClass(fkNext, "hide")) {
              fkNext.click();
              return false;
            }
          }
          count += 5;
          if (index <= count) {
            offset = doc.getElementById(page.id + '.fkPrev') ? 1 : 0;
            funcKey = page.children[(index - 1) % 5 + offset];
          }
        }
      }
      if (funcKey === null || funcKey === undefined) return true;

      if (!hasClass(funcKey, 'disabled')) {
        addClass(funcKey, "clicked");
        textbox = UIFComponents.global.selectedTextbox;
        if (textbox !== null) {
          try {
            textbox.blur(); // fire onblur event for text box
            textbox.focus();
          } catch(e) {}
        }
        select = UIFComponents.select.global.openedElement;
        if (select !== null) {
          try {
            select.click();
          } catch(e) {}
        }
        setTimeout(function() { // wait onblur event finish
          funcKey.click();
        }, 0);
      }
      return false;
    },
    changeNumRows: function() {
      var elem = this,
          doc = elem.ownerDocument,
          body = doc.body,
          page1 = firstElementNode(elem),
          page2 = nextElementNode(page1),
          doubleRowMode, doubleRow,
          elemWidth, pageWidth, page1Width, page2Width;
      if (hasClass(body, 'crxmode')) return;
      elemWidth = elem.clientWidth;
      page1Width = page1.scrollWidth;
      page2Width = (page2 === null || hasClass(page2, 'func-key-updown')) ? 0 : page2.scrollWidth;
      doubleRow = (page2 !== null && !hasClass(page2, 'func-key-updown') && ((page1Width + page2Width) > elemWidth));
      doubleRowMode = hasClass(body, 'double-row');
      if (doubleRow && !doubleRowMode) {
        addClass(body, 'double-row');
      }
      else if (!doubleRow && doubleRowMode) {
        removeClass(body, 'double-row');
      }
      pageWidth = page1Width;
      if (!doubleRow) pageWidth += page2Width;
      elem.style.paddingLeft = ((pageWidth >= elemWidth) ? 0 : ((elemWidth - pageWidth) / 2)) + 'px';
    },
    refresh: function() {
      var funcKeys = this,
          doc = funcKeys.ownerDocument,
          body = doc.body;

      turnOnOffClass(body, 'func-key-down', (getFrame('frmDataSetup') !== null && hasClass(getFrame('frmDataSetup').document.body, 'func-key-down')));
    },
    funcKeysUpDown: function() {
      var btnUpDown = this,
          doc = btnUpDown.ownerDocument,
          body = doc.body,
          isFuncUp = hasClass(body, 'func-key-down');

      turnOnOffClass(body, 'func-key-down', !isFuncUp);
      if (getFrame('frmDataSetup') !== null && findDescendant(getFrame('frmDataSetup').document, 'div', 'funckeys-frame') !== null) {
        turnOnOffClass(getFrame('frmDataSetup').document.body, 'func-key-down', !isFuncUp);
      }
    }
  },
  funcKeyPage: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.closeSelects = type.closeSelects;
      if (!UIFComponents.global.isIEMobile) {
        removeClass(elem, "hide");
      }
    },
    closeSelects: function() {
      var elem = this,
          pages = [],
          funcKeys, node, i, numPages;

      if (UIFComponents.global.isIEMobile) {
        pages.push(elem);
      }
      else { // On PC, function keys on the other page must be closed.
        funcKeys = elem.parentNode;
        for (node = firstElementNode(funcKeys); node !== null; node = nextElementNode(node)) {
          if (hasClass(node, "func-key-page") && !hasClass(node, "dummy")) {
            pages.push(node);
          }
        }
      }

      for (i = 0, numPages = pages.length; i < numPages; i++) {
        for (node = firstElementNode(pages[i]); node !== null; node = nextElementNode(node)) {
          if (hasClass(node, "func-key")) {
            node.closeSelect();
          }
        }
      }
    }
  },
  funcKey: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this,
          iconPullup = doc.getElementById(elem.id + ".pullup"),
          funcSelect;
      config.handleKeys = null;
      config.holdMode = false;
      elem.config = config;
      elem.refresh = type.refresh;
      elem.getSelect = type.getSelect;
      elem.initSelect = type.initSelect;
      elem.openSelect = type.openSelect;
      elem.closeSelect = type.closeSelect;
      elem.handleSelectKeys = type.handleSelectKeys;
      elem.getFuncKeyLabel = type.getFuncKeyLabel;
      elem.setHoldMode = type.setHoldMode;
      elem.setWidth = type.setWidth;
      elem.ontouch = type.ontouch;
      addEventHandler(elem, "click", type.onclick);
      if (!UIFComponents.global.isIEMobile) {
        if (isTablet()) {
          addEventHandler(elem, "touchstart", type.onmousedown);
          addEventHandler(elem, "touchend", type.onmouseup);
        }
        else {
          addEventHandler(elem, "mousedown", type.onmousedown);
          addEventHandler(elem, "mouseup", type.onmouseup);
        }
        addEventHandler(elem, "mouseout", type.onmouseout);
      }
      funcSelect = elem.getSelect();
      if (funcSelect !== null && iconPullup !== null) {
        removeClass(iconPullup, 'hide');
      }
      elem.initSelect();
      if (config.page === undefined) {
        config.page = frame.webpage;
      }
      if (config.name === undefined) {
        addClass(elem, 'disabled');
        if (isCRXMode()) {
          addClass(elem, 'hide');
        }
      }
      else if (isCRXMode()) {
        addClass(elem, 'show');
        elem.setWidth();
      }
    },
    refresh: function(params, options, disabled, onclick) {
      var elem = this,
          doc = elem.ownerDocument,
          divLabel = findDescendant(elem, 'div', 'func-key-lower'),
          iconPullup = doc.getElementById(elem.id + ".pullup"),
          config = elem.config,
          img = null,
          funcKeys, textNode, funcSelect,
          html, option, div, ol, propDisabled, className, hide, i, len;

      elem.closeSelect();

      if ('label' in params) {
        textNode = getTextNode(divLabel);
        if (textNode === null) {
          textNode = doc.createTextNode(params.label);
          divLabel.appendChild(textNode);
        }
        else {
          textNode.nodeValue = params.label;
        }
      }
      if ('name' in params) config.name = params.name;
      if ('page' in params) config.page = params.page;
      elem.style.backgroundColor = ('color' in params && params.color in colorTable) ? colorTable[params.color]: '';

      // if color is member of colorTable, color is used as className.
      className = ('color' in params && !(params.color in colorTable)) ? params.color : '';
      if (typeof config.className === 'string' && config.className !== '') {
        removeClass(elem, config.className);
      }
      if (className !== '') {
        addClass(elem, className);
      }
      config.className = className;

      img = doc.getElementById(elem.id + ".image");
      if ('sprite' in params || 'image' in params) {
        if (params.sprite === '' || params.image === '') {
          if (img !== null) {
            elem.removeChild(img.parentNode);
            img = null;
          }
        }
        else {
          function setImage(img, params) {
            if ('sprite' in params) {
              img.className = 'func-key-sprite ' + params.sprite;
            }
            else {
              img.className = 'func-key-image';
              img.style.backgroundImage = 'url(images/' + params.image + ')';
            }
          }

          if (img === null) {
            div = doc.createElement('div');
            div.className = 'func-key-upper';
            img = doc.createElement('ins');
            img.id = elem.id + '.image';
            setImage(img, params);
            div.appendChild(img);
            elem.insertBefore(div, firstElementNode(elem));
          }
          else {
            setImage(img, params);
          }
        }
      }

      if (options === null) {
        funcSelect = elem.getSelect();
        if (funcSelect !== null) {
          divLabel.removeChild(funcSelect);
        }
        if (iconPullup !== null) {
          addClass(iconPullup, 'hide');
        }
      }
      else {
        if (options.length > 0) {
          html = [];
          ol = doc.createElement('ol');
          ol.className = 'func-select hide';
          for (i = 0, len = options.length; i < len; i++) {
            option = options[i];
            if (option !== undefined) {
              propDisabled = option[2] ? ' disabled="true" class="disabled"' : '';
              html.push(format('<li data-value="%s"%s><a href="javascript:void(0);">%s</a></li>', option[0], propDisabled, option[1]));
            }
          }
          ol.innerHTML = html.join('');

          funcSelect = elem.getSelect();
          if (funcSelect === null) {
            divLabel.appendChild(ol);
          }
          else {
            divLabel.replaceChild(ol, funcSelect);
          }
          elem.initSelect();
          if (iconPullup !== null) {
            removeClass(iconPullup, 'hide');
          }
        }
      }

      hide = false;
      if (typeof config.name !== "string" || config.name === '') {
        disabled = true;
        hide = true;
      }
      turnOnOffClass(elem, 'disabled', disabled);

      if (onclick !== undefined) {
        config.onclick = onclick;
      }

      if (isCRXMode()) {
        turnOnOffClass(elem, 'hide', hide);
        turnOnOffClass(elem, 'show', !hide);
        elem.setWidth(); // inefficient because setWidth should not be performed for each funcKey
      }
    },
    setWidth: function() { // this function should be defined in funcKeys
      var elem = this,
          funcKeys = findAncestor(elem, "div", "func-keys"),
          enableItems = findDescendants(funcKeys, "div", "show"),
          downWidth = hasClass(funcKeys, "func-key-popup") ? 0 : 20;
      for (var i = 0, len = enableItems.length; i < len; i++) {
        enableItems[i].style.width = format("calc((100% - %spx) / %s - %spx)", downWidth, len, 6);
      }
    },
    getSelect: function() {
      var elem = this;
      return findDescendant(elem, "ol", "func-select");
    },
    initSelect: function() {
      var elem = this,
          funcSelect = elem.getSelect(),
          child;
      if (funcSelect !== null) {
        for (var node = firstElementNode(funcSelect), i = 1; node !== null; node = nextElementNode(node), i++) {
          child = node.firstChild;
          child.innerText = i + " " + child.innerText;
          addEventHandler(child, "focus", UIFComponents.funcKey.onfocus);
        }
      }
    },
    openSelect: function() {
      var elem = this,
          config = elem.config,
          frame = getDefaultView(elem.ownerDocument),
          funcSelect = elem.getSelect(),
          divLabel = findDescendant(elem, 'div', 'func-key-lower'),
          textNode;
      if (funcSelect === null) return;

      if (hasClass(funcSelect, "hide")) {
        textNode = getTextNode(divLabel);
        if (textNode !== null) {
          textNode.nodeValue = textNode.nodeValue.replace(/[\[\]]/g, "|");
        }
        removeClass(funcSelect, "hide");
        addClass(elem, "opened");

        if (config.handleKeys !== null) {
          KeyEvent.removeHandler(config.handleKeys);
        }
        config.handleKeys = function(event) { return elem.handleSelectKeys(event); };
        KeyEvent.addHandler(config.handleKeys, frame, false);
      }
    },
    closeSelect: function() {
      var elem = this,
          config = elem.config,
          funcSelect = elem.getSelect(),
          divLabel = findDescendant(elem, 'div', 'func-key-lower'),
          textNode;
      if (funcSelect === null) return;

      if (!hasClass(funcSelect, "hide")) {
        textNode = getTextNode(divLabel);
        if (textNode !== null) {
          textNode.nodeValue = textNode.nodeValue.replace(/\|([^\|]+)\|/, "[$1]");
        }
        addClass(funcSelect, "hide");
        removeClass(elem, "opened");

        if (config.handleKeys !== null) {
          KeyEvent.removeHandler(config.handleKeys);
          config.handleKeys = null;
        }
      }
    },
    handleSelectKeys: function(event) {
      var elem = this,
          funcSelect = elem.getSelect(),
          keyCode = event.keyCode,
          keyOneCode = 49,
          index, currSelected, nextSelected, dist, direction;

      switch (keyCode) {
      case 13: // enter key
        currSelected = findDescendant(elem, "li", "selected");
        if (currSelected !== null) {
          currSelected.click();
        }
        return false;

      case 27: // prev
        elem.click();
        return false;

      default:
        dist = keyEventToDistance(event);
        if (dist !== 0) {
          currSelected = findDescendant(elem, "li", "selected");
          if (currSelected !== null) {
            nextSelected = getNextNode(funcSelect, currSelected, dist, true);
            if (nextSelected !== null) {
              direction = dist / Math.abs(dist);
              while (nextSelected.disabled) {
                nextSelected = getNextNode(funcSelect, nextSelected, direction, true);
                if (nextSelected === currSelected) return false;
              }
              addClassExclusively(funcSelect, nextSelected, "selected");
              return false;
            }
          }
        }
        else {
          if (!event.ctrlKey && keyCode >= keyOneCode - 1 && keyCode < keyOneCode + 9) { // number keys
            index = keyCode - keyOneCode;
            if (index === -1) index += 10;
            nextSelected = funcSelect.children[index];
            if (nextSelected !== null && nextSelected !== undefined) {
              nextSelected.click();
              return false;
            }
          }
        }
      }
      return true;
    },
    getFuncKeyLabel: function() {
      var elem = this,
          divLabel = findDescendant(elem, 'div', 'func-key-lower'),
          textNode, label;
      textNode = getTextNode(divLabel);
          if (textNode === null) return null;
      label = textNode.nodeValue.replace(/\s+$/, "");
      return (label === "") ? null : encodeURIComponentLocal(label);
    },
    onclick: function(event) {
      var elem = event.srcElement,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          funcKey, funcSelect, config, type, label;

      switch (elem.tagName) {
      case "DIV":
      case "INS":
      case "SPAN":
        funcKey = findAncestor(elem, 'div', 'func-key');
        if (hasClass(funcKey, 'disabled')) return false;

        config = funcKey.config;
        if (config.holdMode) return false;

        funcSelect = funcKey.getSelect();
        if (funcSelect === null) {
          funcKey.parentNode.closeSelects();
          label = funcKey.getFuncKeyLabel();
          if (label !== null) {
            if (config.onclick !== undefined && config.onclick !== null) {
              config.onclick('clicked', config.page, config.name, label);
            }
            else {
              VTRNRequest(frame, { webpage: config.page, request: config.name + ".clicked", label: label}).send();
            }
          }
        }
        else {
          if (!hasClass(funcSelect, "hide")) {
            funcKey.closeSelect();
            type = "resizeend";
          }
          else {
            for (var option = firstElementNode(funcSelect); option !== null; option = nextElementNode(option)) {
              if (!option.disabled) break;
            }
            if (option !== null) {
              addClassExclusively(funcSelect, option, "selected");
            }
            funcKey.parentNode.closeSelects();
            funcKey.openSelect();
            type = "resizestart";
          }
          triggerEvent(funcKey, type);
        }
        setTimeout(function() { try { removeClass(funcKey, "clicked"); } catch(e) {} }, 100);
        break;

      case "A":
      case "LI":
        if (elem.tagName === "A") {
          elem = elem.parentNode;
        }
        if (hasClass(elem, 'disabled')) return false;

        funcSelect = findAncestor(elem, "ol", "func-select");
        addClassExclusively(funcSelect, elem, "selected");

        setTimeout(function() {
          funcKey = findAncestor(elem, "div", "func-key");
          funcKey.closeSelect();
          triggerEvent(funcKey, 'resizeend');
          config = funcKey.config;
          label = funcKey.getFuncKeyLabel();
          if (label !== null) {
            if (config.onclick !== undefined && config.onclick !== null) {
              config.onclick('selected', config.page, config.name, elem.getAttribute('data-value'), label);
            }
            else {
              VTRNRequest(frame, { webpage: config.page, request: config.name + ".selected", value: elem.getAttribute('data-value'), label: label }).send();
            }
          }
        }, 100);
        break;
      }
      return false;
    },
    setHoldMode: function(holdMode, pageEnd) {
      var elem = this,
          config = elem.config;
      config.holdMode = holdMode;
      config.pageEnd = pageEnd;
    },
    ontouch: function(isStart) {
      var elem = this,
          config = elem.config,
          frame, label, page, action, params;

      if (hasClass(elem, 'disabled')) return false;
      turnOnOffClass(elem, "clicked", isStart);

      if (config.holdMode) {
        frame = getDefaultView(elem.ownerDocument);
        label = elem.getFuncKeyLabel();
        page = isStart ? config.page : config.pageEnd;
        action = isStart ? 'touchstart' : 'touchend';
        params = { webpage: page, request: [config.name, action].join('.'), label: label };
        if (!isStart) {
          params["fc"] = SFVTRN_function_codes.HCFC_SFVTRN_CALLBACK_C;
        }
        VTRNRequest(frame, params).send();
        if (!isStart) {
          frame.setTimeout(function() {
            if (config.onclick !== undefined && config.onclick !== null) {
              config.onclick('clicked', config.page, config.name, label);
            }
            else {
              VTRNRequest(frame, { webpage: config.page, request: config.name + ".clicked", label: label}).send();
            }
          }, 100);
        }
      }
      return false;
    },
    onmousedown: function(event) {
      var elem = event.srcElement,
          funcKey = findAncestor(elem, 'div', 'func-key');
      return funcKey.ontouch(true);
    },
    onmouseup: function(event) {
      var elem = event.srcElement,
          funcKey = findAncestor(elem, 'div', 'func-key');
      return funcKey.ontouch(false);
    },
    onmouseout: function(event) {
      var elem = event.srcElement,
          funcKey = findAncestor(elem, 'div', 'func-key');
      if (hasClass(funcKey, 'disabled')) return false;
      removeClass(funcKey, "clicked");
      return false;
    },
    onfocus: function(event) {
      var elem = event.srcElement;
      elem.blur(); /* remove annoying dotted line */
      return false;
    }
  },
  thumbnailGrid: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this,
          child, obj;
      config.numImages = 0;
      if (!("mode" in config)) {
        config.mode = 'check';
        config.checked = 'vsbttn-mark-ok';
        config.unchecked = 'vsbttn-mark-ng';
      }
      config.headerHeight = (config.mode === "radio") ? 54 : 0;
      config.minWidth = (config.mode === "radio") ? 145 : 0;
      config.optionNodes = [];
      while (elem.firstChild) {
        child = elem.removeChild(elem.firstChild);
        if (child.nodeType !== 3) {
          obj = {
            className: child.className,
            text: child.innerText,
            value: parseInt(child.getAttribute('data-value'), 10),
            header: child.getAttribute('data-header'),
            overlay: (child.getAttribute('data-overlay') === 'true')
          };
          config.optionNodes.push(obj);
        }
      }
      elem.innerHTML = "";
      elem.config = config;
      elem.refresh = type.refresh;
      elem.refreshOne = type.refreshOne;
      elem.thumbHTML = type.thumbHTML;
      addEventHandler(elem, "click", type.onclick);
      elem.notifySize = type.notifySize;
      elem.checkButton = type.checkButton;
      elem.selectRadio = type.selectRadio;
      addEventHandler(frame, "resize", debounce(function(event) {
        elem.notifySize('resized');
      }, 200));
      elem.handleKeys = type.handleKeys;
      addEventHandler(frame, "load", function() {
        KeyEvent.addHandler(function(event) {
          return elem.handleKeys(event);
        }, frame, false);
      });
      elem.notifySize('initialized');
    },
    refresh: function(margin, options, url, imageWidth, selected, disabled) {
      var elem = this,
          config = elem.config,
          borderWidth = 2,
          numThumbnails, html, i,
          sumWidth;
      sumWidth = 0;
      html = [];

      removeLastUndefined(options);
      numThumbnails = options.length;

      if (config.layout === 'horizontal') {
        for (i = 0; i < numThumbnails; i++) {
          sumWidth += options[i].width * options[i].zoom + margin;
        }
        sumWidth += margin;
        elem.style.width = sumWidth + 'px';
      }
      for (i = 0; i < numThumbnails; i++) {
        html.push(elem.thumbHTML(margin, options[i], url, imageWidth, selected));
      }
      elem.innerHTML = html.join('');
    },
    refreshOne: function(margin, option, url, selected) {
      var elem = this,
          doc = elem.ownerDocument,
          config = elem.config,
          zoom = option.zoom || 1,
          width, height,
          divThumb, imgThumb, divDummy, divOverlay, divInner,
          button, checked;

      var findThumb = function(elem, index) {
        var divThumb;
        for (divThumb = firstElementNode(elem); divThumb !== null; divThumb = nextElementNode(divThumb)) {
          if (parseInt(divThumb.getAttribute('data-value'), 10) === index) {
            return divThumb;
          }
        }
        return null;
      };

      divThumb = findThumb(elem, option.index);
      if (divThumb === null) return;

      divOverlay = findDescendant(divThumb, "div", "thumbnail-grid-ov");

      switch (config.mode) {
      case 'check':
        button = findDescendant(divThumb, 'ins', 'thumbnail-button');
        elem.checkButton(button, option.check);
        break;
      case 'radio':
        // not implemented yet
        break;
      }
      imgThumb = findDescendant(divThumb, 'img', 'thumbnail-grid-img');
      divInner = findDescendant(divThumb, 'div', 'thumbnail-grid-inner');
      if (imgThumb === null || divInner === null) return;

      imgThumb.onload = function() {
        var imgThumb = this;
        width = option.width * zoom;
        height = option.height * zoom;
        imgThumb.style.left   = format('-%spx', option.y * zoom);
        imgThumb.style.top    = format('-%spx', option.x * zoom);
        imgThumb.style.width  = format('%spx', width);
        divThumb.style.width  = format('%spx', width);
        divThumb.style.height = format('%spx', height + config.headerHeight);
        divInner.style.width  = format('%spx', width);
        divInner.style.height = format('%spx', height);
        imgThumb.onload = null;
      };
      imgThumb.src = url;
    },
    thumbHTML: function(margin, option, url, imageWidth, selected) {
      var elem = this,
          config = elem.config,
          border = 2,
          overlay = false,
          buttonClass,
          html, zoom, indexText, header,
          data, className, value, text, i, len,
          width, height, margin2, selectedOption = {};
      html = [];
      zoom = option.zoom || 1;
      width = option.width * zoom;
      height = option.height * zoom;
      margin2 = margin - border * 2;

      header = "";
      if (config.mode === 'radio') {
        for (i = 0, len = config.optionNodes.length; i < len; i++) {
          data = config.optionNodes[i];
          if (option.selected === data.value) {
            if (data.header) header = data.header;
            overlay = data.overlay;
            break;
          }
        }
      }

      if (option.header) header = option.header;

      html.push(format('<div class="thumbnail-grid %s %s', config.mode, header));
      if (selected === option.index) {
        html.push(' thumbnail-grid-selected');
      }
      html.push(format('" data-value="%s" ', option.index));
      html.push(format('style="width: %spx; height: %spx; margin-left: %spx; margin-top: %spx; border-width: %spx;">',
                       width, height + config.headerHeight, margin2, margin2, border));
      html.push(format('<div class="thumbnail-header" style="height: %spx;">', config.headerHeight));
      indexText = (option.indexText) ? option.indexText : option.index + 1;
      html.push(format('<span class="thumbnail-index">%s</span><br>', indexText));
      switch (config.mode) {
      case 'check':
        buttonClass = (option.check === undefined) ? 'hide' : (option.check ? config.checked : config.unchecked);
        overlay = (buttonClass === config.unchecked);

        html.push(format('<ins class="thumbnail-button thumbnail-button-upper %s"></ins>', buttonClass));
        break;
      case 'radio':
        for (i = 0, len = config.optionNodes.length; i < len; i++) {
          data = config.optionNodes[i];
          className = data.className;
          if (option.selected === data.value) className += " selected";
          text = (option.radio && option.radio[i]) ? option.radio[i] : data.text;
          html.push(format('<ins class="thumbnail-option %s" data-value="%s">%s</ins>', className, data.value, text));
        }
        break;
      }
      html.push('</div>');
      html.push(format('<div class="thumbnail-grid-inner" style="width: %spx; height: %spx;">', width, height));
      html.push(format('<img class="thumbnail-grid-img" src="%s" style="left: -%spx; top: -%spx; width: %spx;"></img>',
                       url, option.y * zoom, option.x * zoom, imageWidth * zoom));
      html.push(format('<div class="thumbnail-grid-ov %s"></div>', overlay ? "" : "hide"));
      if (option.text) html.push(format('<div class="thumbnail-grid-status">%s</div>', option.text.replace(/\n/g, '<br>')));
      html.push('</div>');
      html.push('</div>');
      return html.join('');
    },
    onclick: function(event) {
      var target = event.srcElement,
          doc = target.ownerDocument,
          frame = getDefaultView(doc),
          value, index,
          root, grid, config, checked;
      switch (target.tagName) {
      case "INS":
        grid = findAncestor(target, "div", "thumbnail-grid");
        root = grid.parentNode;
        config = root.config;

        index = parseInt(grid.getAttribute('data-value'), 10);

        switch (config.mode) {
        case 'check':
          checked = hasClass(target, config.checked);
          root.checkButton(target, !checked);
          VTRNRequest(frame, { request: root.id + ".checked", type: index, value: !checked }).send();
          break;
        case 'radio':
          value = root.selectRadio(target);
          VTRNRequest(frame, { request: root.id + ".radioclicked", type: index, value: value }).send();
          break;
        }
        break;
      case "IMG":
      case "DIV":
        grid = findAncestor(target, "div", "thumbnail-grid");
        if (grid !== null) {
          root = grid.parentNode;
          if (findDescendant(root, 'div', 'thumbnail-grid-selected') !== null) {
            addClassExclusively(root, grid, "thumbnail-grid-selected");
          }
          VTRNRequest(frame, { request: root.id + ".clicked", type: parseInt(grid.getAttribute('data-value'), 10) }).send();
        }
        break;
      }
    },
    checkButton: function(button, checked) {
      var root = this,
          grid = findAncestor(button, "div", "thumbnail-grid"),
          config = root.config,
          divOverlay = findDescendant(grid, "div", "thumbnail-grid-ov");
      turnOnOffClass(button, config.checked, checked);
      turnOnOffClass(button, config.unchecked, !checked);
      turnOnOffClass(divOverlay, 'hide', !hasClass(button, config.unchecked));
    },
    selectRadio: function(target) {
      var root = this,
          grid = findAncestor(target, "div", "thumbnail-grid"),
          config = root.config,
          overlay = false,
          value, i, len, data, header,
          divOverlay = findDescendant(grid, "div", "thumbnail-grid-ov");
      value = parseInt(target.getAttribute('data-value'), 10);
      for (i = 0, len = config.optionNodes.length; i < len; i++) {
        data = config.optionNodes[i];
        header = data.header;
        if (data.value == value) {
          overlay = data.overlay;
          if (header) addClass(grid, header);
        }
        else {
          if (header) removeClass(grid, header);
        }
      }
      addClassExclusively(target.parentNode, target, "selected");
      turnOnOffClass(divOverlay, 'hide', !overlay);
      return value;
    },
    notifySize: function(requestName) {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          div = elem.parentNode,
          config = elem.config;
      if (elem === null) return;
      VTRNRequest(frame, { request: elem.id + '.' + requestName,
                           value: format('%sx%s:%s:%s', div.clientWidth, div.clientHeight, config.headerHeight, config.minWidth) }).send();
    },
    handleKeys: function(event) {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          currThumb, nextThumb;
      switch (event.keyCode) {
      case 37: // left arrow
      case 39: // right arrow
        currThumb = findDescendant(elem, 'div', 'thumbnail-grid-selected');
        if (currThumb !== null) {
          nextThumb = currThumb[event.keyCode === 37 ? 'previousSibling' : 'nextSibling'];
          if (nextThumb !== null) {
            addClassExclusively(elem, nextThumb, "thumbnail-grid-selected");
            VTRNRequest(frame, { request: elem.id + ".selected", type: parseInt(nextThumb.getAttribute('data-value'), 10) }).send();
            return false;
          }
        }
        break;
      }
      return true;
    }
  },
  imageViewer: {
    global: {
      cacheId: 0
    },
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this,
          textNode;
      if (!("interval" in config)) {
        config.interval = 100;
      }
      config.timeoutId = null;
      config.cancelInvoke = false;
      elem.config = config;
      elem.refresh = type.refresh;
      elem.alignVertically = type.alignVertically;
      elem.showText = type.showText;
      elem.scrollToPos = type.scrollToPos;
      elem.invoke = type.invoke;
      elem.pinch = type.pinch;
      elem.cancelRefresh = type.cancelRefresh;
      // Without the following line, scroll bar is shown unexpectedly.
      textNode = getTextNode(doc.getElementById(elem.id + ".div"));
      if (textNode !== null) {
        textNode.nodeValue = "";
      }
      addEventHandler(frame, "resize", function (event) {
        elem.alignVertically();
      });
      if ("pinch" in config && config.pinch === "true") {
        addEventHandler(frame, "load", function() {
          regPinchEvent(elem.parentNode, function() { elem.pinch(true); }, function() { elem.pinch(false); });
        });
      }
      VTRNRequest(frame, { request: elem.id + '.initialized', value: format('%sx%s', elem.parentNode.clientWidth, elem.parentNode.clientHeight) }).send();
    },
    refresh: function(url, width, height, option, invokeNext) {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          config = elem.config,
          global = UIFComponents.imageViewer.global,
          div = doc.getElementById(elem.id + '.div'),
          img = doc.getElementById(elem.id + '.img');
      if (config.timeoutId !== null) {
        frame.clearTimeout(config.timeoutId);
        config.timeoutId = null;
      }
      if (config.cancelInvoke) {
        config.cancelInvoke = false;
        if (invokeNext) return;
      }
      if (url === null) {
        div.style.width = 0;
        div.style.height = 0;
      }
      else {
        img.onload = function() {
          var img = this,
              doc = img.ownerDocument;
          // img.style.width = width + 'px';
          // img.style.height = height + 'px';
          div.style.width = width + 'px';
          div.style.height = height + 'px';
          elem.style.width = width + 'px';
          elem.style.height = height + 'px';
          if (typeof option.scroll === 'object') {
            elem.scrollToPos(option.scroll.x, option.scroll.y);
          }
          if (typeof option.text === 'object') {
            elem.showText(option.text.text, option.text.className, option.text.overlay);
          }
          else {
            elem.showText('', '', false);
          }
          if (config.cancelInvoke) {
            config.cancelInvoke = false;
          }
          else if (invokeNext) {
            elem.invoke();
          }
          elem.alignVertically();
          img.onload = null;
        };
        img.src = format('%s?nocache=1&id=%s', url, global.cacheId);
        global.cacheId = 1 - global.cacheId;
      }
    },
    alignVertically: function() {
      var elem = this;
      elem.style.marginTop = (elem.offsetHeight < elem.parentNode.offsetHeight) ? parseInt((elem.parentNode.offsetHeight - elem.offsetHeight), 10) / 2 + "px" : "0";
    },
    showText: function(text, className, overlay) {
      var elem = this,
          doc = elem.ownerDocument,
          divOverlay = doc.getElementById(elem.id + '.overlay'),
          divText = doc.getElementById(elem.id + '.text'),
          hide;
      divText.innerText = text;
      divText.className = ''; // Clear class
      hide = (text === '') ? true : false;
      if (className === '') {
        className = 'image-viewer-text';
      }
      addClass(divText, className);
      turnOnOffClass(divText, 'hide', hide);
      turnOnOffClass(divOverlay, 'hide', !overlay);
    },
    scrollToPos: function(x, y) {
      var elem = this;
      elem.scrollTop = x - elem.clientHeight / 2;
      elem.scrollLeft = y - elem.clientWidth / 2;
    },
    invoke: function() {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          config = elem.config;
      if (config.timeoutId !== null) {
        frame.clearTimeout(config.timeoutId);
      }
      config.timeoutId = frame.setTimeout(function() {
        try { VTRNRequest(frame, {request: elem.id + ".invoked"}).send(); } catch(e) {}
        config.timeoutId = null;
      }, config.interval);
    },
    pinch: function(pinchin) {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc);
      VTRNRequest(frame, {request: elem.id + (pinchin ? ".pinchin" : ".pinchout")}).send();
    },
    cancelRefresh: function() {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          config = elem.config,
          img = doc.getElementById(elem.id + '.img');
      if (config.timeoutId !== null) { // timeout handler has not been fired yet
        frame.clearTimeout(config.timeoutId);
        config.timeoutId = null;
      }
      else {
        config.cancelInvoke = true;
      }
    }
  },
  imageIllust: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
    },
    refresh: function(image) {
      var elem = this;
      if (image === null || image === '') {
        elem.style.width = 0;
        elem.style.height = 0;
      }
      else {
        elem.src = format('images/%s', image);
        elem.style.width = 'auto';
        elem.style.height = 'auto';
      }
    }
  },
  progressBar: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      if (!("interval" in config)) {
        config.interval = 500;
      }
      config.timeoutId = null;
      elem.config = config;
      elem.invoke = type.invoke;
      elem.refresh = type.refresh;
    },
    invoke: function() {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          config = elem.config;
      config.timeoutId = frame.setTimeout(function() {
        SFVTRNRequestCallback(frame, {request: elem.id + ".invoked"}).send();
        config.timeoutId = null;
      }, config.interval);
    },
    refresh: function(parcent, invokeNext) {
      var elem = this,
          doc = elem.ownerDocument,
          frame = getDefaultView(doc),
          bar = doc.getElementById(elem.id + '.bar'),
          config = elem.config;
      parcent = Math.min(1.0, parcent);
      bar.style.width = (parcent * 100) + '%';
      if (config.timeoutId != null) {
        frame.clearTimeout(config.timeoutId);
      }
      if (invokeNext) {
        elem.invoke();
      }
    }
  },
  listSelect: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;
      if (config.horizontal === "true") {
        config.horizontal = true;
        config.widthAdjusted = false;
      }
      else {
        if ("horizontal" in config) {
          alert(format('[listSelect] invalid horizontal value "%s"', config.horizontal));
        }
        config.horizontal = false;
      }
      elem.config = config;
      elem.refresh = type.refresh;
      elem.setWidth = type.setWidth;
      elem.getValue = type.getValue;
      addEventHandler(elem, "click", type.onclick);
      addEventHandler(elem, "keypress", type.onkeypress);
      if (config.horizontal) {
        addEventHandler(frame, "load", function() {
          elem.setWidth();
        });
        addEventHandler(frame, "resize", function(event) {
          elem.setWidth();
        });
      }
    },
    refresh: function(options, selected, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          ul = firstElementNode(elem),
          config = elem.config,
          html = [],
          selectedOption = null,
          i, len, li, ins, marks;
      if (options === null) {
        for (li = firstElementNode(ul); li !== null; li = nextElementNode(li)) {
          if (li.getAttribute('data-value') === selected || parseInt(li.getAttribute('data-value'), 10) === selected) {
            addClassExclusively(ul, li, 'selected');
            ins = findDescendant(li, 'ins', 'list-select-mark');
            if (ins !== null) {
              replaceClassExclusively(ul, ins, 'vsbttn-mark-off', 'vsbttn-mark-on');
            }
            break;
          }
        }
      }
      else {
        removeLastUndefined(options);
        for (i = 0, len = options.length; i < len; i++) {
          html.push(format('<li class="list-select-option %s" data-value="%s" tabindex="0"><div class="list-select-option-left"><ins class="list-select-mark %s"></ins></div><div class="list-select-option-right">%s</div></li>',
                           options[i].value === selected ? 'selected' : '', options[i].value,
                           options[i].value === selected ? 'vsbttn-mark-on' : 'vsbttn-mark-off', options[i].text));
        }
        ul.innerHTML = html.join('');
        config.widthAdjusted = true;
      }
      if (config.horizontal && !config.widthAdjusted) {
        elem.setWidth();
      }
      if (elem.disabled !== disabled) {
        elem.disabled = disabled;
        turnOnOffClass(elem, 'disabled', disabled);
      }
    },
    setWidth: function() {
      var elem = this,
          config = elem.config,
          ul = firstElementNode(elem),
          liArray = findDescendants(elem, 'li', 'list-select-option'),
          offset = 4, // this value depends on margin-left-width
          width, i, len;
      if (liArray.length == 0 || ul.clientWidth == 0) return;
      width = Math.floor(ul.clientWidth / liArray.length);
      for (i = 0, len = liArray.length - 1; i < len; i++) {
        liArray[i].style.width = (width - offset) + 'px';
      }
      liArray[len].style.width = (ul.clientWidth - (width * len) - offset) + 'px';
      config.widthAdjusted = true;
    },
    getValue: function() {
      var elem = this,
          ul = firstElementNode(elem),
          liSelected = findDescendant(elem, 'li', 'selected'),
          value = null;
      if (liSelected != null) {
        value = liSelected.getAttribute('data-value');
      }
      return value;
    },
    onclick: function(event) {
      var target = event.srcElement,
          doc = target.ownerDocument,
          frame = getDefaultView(doc),
          li, ul, root, ins;
      switch (target.tagName) {
      case "INS":
        li = target.parentNode.parentNode;
        break;
      case "DIV":
        li = target.parentNode;
        break;
      case "LI":
        li = target;
        break;
      case "SPAN":
        li = target.parentNode;
        break;
      default:
        return true;
      }
      ul = li.parentNode;
      root = ul.parentNode;

      if (root.disabled) return true;

      if (!hasClass(li, 'selected')) {
        addClassExclusively(ul, li, 'selected');
        ins = findDescendant(li, 'ins', 'list-select-mark');
        if (ins !== null) {
          replaceClassExclusively(ul, ins, 'vsbttn-mark-off', 'vsbttn-mark-on');
        }
        var dataVal = li.getAttribute('data-value');
        frame.setTimeout(function() {
          VTRNRequest(frame, { request: root.id + ".changed", value: dataVal }).send();
        }, 100);
        return false;
      }
      return true;
    },
    onkeypress: function(event) {
      var elem = event.srcElement;
      if (event.keyCode === 13) {
        elem.click();
      }
    }
  },
  funcKeyType: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id);
      UIFComponents.funcKey.init(doc, id, config);
      if (!UIFComponents.global.isIEMobile) {
        elem.refresh({ label: "", name: "", sprite: "" }, null, true);
      }
    }
  },
  funcKeyNext: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          image = doc.getElementById(elem.id + '.image'),
          root = findAncestor(elem, 'div', 'func-keys'),
          pages = findDescendants(root, 'div', 'func-key-page'),
          type = this;
      UIFComponents.funcKey.init(doc, id, config);
      addEventHandler(elem, 'click', type.onclick);
      if (pages.length <= 1) {
        elem.disabled = true;
        addClass(image, 'hide', true);
      }
    },
    onclick: function(event) {
      var elem = event.srcElement,
          root = findAncestor(elem, 'div', 'func-keys'),
          page = findAncestor(elem, 'div', 'func-key-page');
      if (elem.disabled) return false;
      if (!hasClass(elem, 'func-key-next')) {
        elem = findAncestor(elem, 'div', 'func-key-next');
      }
      if (!hasClass(elem, "hide")) {
        page.closeSelects();
        addClassExclusively(root, page, "hide");
      }
      return false;
    }
  },
  funcKeysGuideStep: {
    init: function(doc, id, config) {
      if (isiPendant()) {
        UIFComponents.funcKeys.init(doc, id, config);
      }
    }
  },
  funcKeysVisData: {
    init: function(doc, id, config) {
      var frame = getDefaultView(doc);
      UIFComponents.funcKeys.init(doc, id, config);
      KeyEvent.addHandler(function(event) {
        if (event.keyCode === 27) { // prev
          doc.getElementById("F5").click();
          return false;
        }
        return true;
      }, frame);
    }
  },
  funcKeysConfirm: {
    init: function(doc, id, config) {
      var frame = getDefaultView(doc);
      UIFComponents.funcKeys.init(doc, id, config);
      KeyEvent.addHandler(function(event) {
        if (event.keyCode === 27) { // prev
          doc.getElementById("F5").click();
          return false;
        }
        return true;
      }, frame);
    }
  },
  wizardBar: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;
      elem.config = config;
      config.steps = [];
      config.selectedIndex = 0;
      elem.refresh = type.refresh;
      elem.adjustWidth = type.adjustWidth;
      elem.getStepsInfo = type.getStepsInfo;
      elem.canSelect = type.canSelect;
      elem.select = type.select;
      addEventHandler(elem, "click", type.onclick);
      addEventHandler(frame, "resize", debounce(function(event) {
        elem.adjustWidth();
      }, 200));
    },
    refresh: function(steps, selected, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          ul = firstElementNode(elem),
          config = elem.config,
          html = [],
          classes,
          sumWidth,
          marginLeft = 0,
          marginRight = 0,
          selectedIndex = 0,
          li, i, len, attr;
      removeLastUndefined(steps);
      for (i = 0, len = steps.length; i < len; i++) {
        classes = [];
        if (steps[i].className) classes.push(steps[i].className);
        if (steps[i].value === selected) {
          classes.push('selected');
          selectedIndex = i;
        }
        if (steps[i].disabled || disabled) classes.push('disabled');
        html.push(format('<li class="wizard-bar-step %s" data-value="%s" %s %s>',
                         classes.join(' '),
                         steps[i].value,
                         (steps[i].disabled || disabled) ? 'disabled' : '',
                         (typeof steps[i].attr === 'string') ? format('data-attr="%s"', steps[i].attr) : ''));
        html.push(format('<div class="wizard-bar-step-icon">'));
        html.push(format('<span class="wizard-bar-step-index">%s</span>', i + 1));
        html.push(format('<ins class="wizard-bar-step-icon-ins %s"></ins>',
                         steps[i].icon));
        html.push(format('</div>'));
        html.push(format('<span class="wizard-bar-step-label">%s</span>',
                         steps[i].text));
        html.push(format('<ins class="wizard-bar-step-trained vsbttn-%s"></ins>', (steps[i].className === 'trained') ? 'trained' : 'not-trained'));
        html.push(format('<ins class="wizard-bar-step-arrow vcstep-arrow %s"></ins>',
                         (i === 0) ? 'hide' : ''));
        html.push(format('</li>'));
      }
      ul.innerHTML = html.join('');
      sumWidth = 0;
      li = firstElementNode(ul);
      if (li) {
        marginLeft = parseInt(getCurrentStyle(li).marginLeft, 10);
        marginRight = parseInt(getCurrentStyle(li).marginRight, 10);
        for (; li !== null; li = nextElementNode(li)) {
          sumWidth += li.offsetWidth + marginLeft + marginRight;
        }
      }
      config.steps = steps;
      config.selectedIndex = selectedIndex;
      ul.style.width = sumWidth + 'px';
      elem.adjustWidth();
    },
    adjustWidth: function() {
      var elem = this,
          ul = firstElementNode(elem),
          elemWidth, ulWidth;
      elemWidth = elem.clientWidth;
      ulWidth = ul.scrollWidth;
      ul.style.left = ((ulWidth >= elemWidth) ? 0 : ((elemWidth - ulWidth) / 2)) + 'px';
    },
    getStepsInfo: function() {
      var elem = this,
          config = elem.config;
      return {
        numSteps: config.steps.length,
        selectedIndex: config.selectedIndex
      };
    },
    canSelect: function(index) {
      var elem = this,
          stepElems = findDescendants(elem, 'li', 'wizard-bar-step');
      return stepElems[index] && !hasClass(stepElems[index], 'disabled');
    },
    select: function(index) {
      var elem = this,
          stepElems = findDescendants(elem, 'li', 'wizard-bar-step');
      if (stepElems[index]) {
        stepElems[index].click();
      }
    },
    onclick: function(event) {
      var elem = event.srcElement,
          frame = getDefaultView(elem.ownerDocument),
          root = findAncestor(elem, 'div', 'wizard-bar'),
          stepElems = findDescendants(root, 'li', 'wizard-bar-step'),
          config = root.config;

      if (elem.tagName === "UL") return true;
      if (elem.tagName === "DIV" && hasClass(elem, 'wizard-bar')) return true;
      if (elem.tagName === "INS" && hasClass(elem, 'wizard-bar-step-arrow')) return true;
      if (elem.tagName === "DIV" || elem.tagName === "SPAN" || elem.tagName === "INS") {
        elem = findAncestor(elem, 'li', 'wizard-bar-step');
      }
      if (elem.tagName === "LI" && !hasClass(elem, 'disabled') && !hasClass(elem, 'selected')) {
        addClassExclusively(root, elem, 'selected');
        for (var i = 0, len = stepElems.length; i < len; i++) {
          if (stepElems[i] === elem) {
            config.selectedIndex = i;
            break;
          }
        }
        if (config.onclick !== undefined && config.onclick !== null) {
          config.onclick(root, elem.getAttribute('data-value'), elem.getAttribute('data-attr'));
        }
        else {
          frame.setTimeout(function() {
            VTRNRequest(frame, { request: root.id + ".selected", value: elem.getAttribute('data-value') }).send();
          }, 50);
        }
        return false;
      }
      return true;
    }
  },
  wizardSteps: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
      elem.getSelectedText = type.getSelectedText;
    },
    refresh: function(selected) {
      var elem = this,
          li, i;
      for (i = 0, li = firstElementNode(elem); li !== null; i++, li = nextElementNode(li)) {
        // Cannot use addClassExclusively(), because it will change substeps property.
        turnOnOffClass(li, 'selected', (i === selected));
      }
    },
    getSelectedText: function() {
      var elem = this,
          li;
      for (li = firstElementNode(elem); li !== null; li = nextElementNode(li)) {
        if (hasClass(li, 'selected')) {
          return getTextNode(firstElementNode(li)).nodeValue;
        }
      }
      return "";
    }
  },
  buttonToggleSidebar: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      config.onclick = true; // dummy property to avoid onclick being set.
      UIFComponents.buttonText.init(doc, id, config);
      addEventHandler(elem, "click", type.onclick);
    },
    onclick: function (event) {
      var elem = event.srcElement,
          body = elem.ownerDocument.body;
      if (hasClass(body, "sidebar-close")) {
        removeClass(body, "sidebar-close");
        elem.refresh("<", null, false);
      }
      else {
        addClass(body, "sidebar-close");
        elem.refresh(">", null, false);
      }
    }
  },
  complexRefDataInfo: {
    init: function(doc, id, config) { /* nop */ },
    text: {
      confirmDelete: function(index) {
        return format("O_RѦҼƾ%sH", index);
      },
      confirmSetRefData: function(isTrained, isMulti) {
        var msg = '';
        var strSet = isTrained ? "wܧ" : "]w";
        if (isMulti) {
          msg += format("ϥοXG]wѦҦmC \n", strSet);
        }
        if (isTrained) {
          msg += "pGܧѦҦmAsоɨϥΦHʧ@C\n\n";
        }
        strSet = isTrained ? "ܧ" : "]w";
        msg = msg + format("@UOKH%sѦҦmC", strSet);
        if (isMulti) {
          msg += "\n\nYQϥοܥ~GAХѵGM椤ܾAGC";
        }
        return msg;
      },
      msgNoValidResult: function(refdataModelID) {
        return format("SID%sGC\nпܾAѦҼƾکζiT{AH즹ID%sGC", refdataModelID, refdataModelID);
      },
      msgInvalidResult: function(refdataModelID, resultModelID) {
        return format("ܵGIDO%sAӷeѦҼƾڪID%sC\nпܫID%sGAοܫID%sѦҼƾڡC\n", resultModelID, refdataModelID, refdataModelID, resultModelID);
      }
    }
  },
  complex3DRefDataInfo: {
    init: function(doc, id, config) { /* nop */ },
    text: {
      txtRefPositionSet: "]w",
      txtRefPositionNotSet: "]w",
      txtRefPositionNotUse: "ϥ",
      txtConfirmSetRefPos: "pGܧѦҦmAsоɨϥΦHʧ@C\n\n@UOKH]wѦҦmC"
    }
  },
  tabResults: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          body = doc.body;
      addEventHandler(elem, "click", function(event) {
        var tabResultsDown = findDescendant(elem, "div", "tab-results-down"),
            middle;
        if (hasClass(body, 'result-mid-size')) {
          middle = cumulativeOffsetLeft(tabResultsDown);
          if (event.clientX < middle) {
            replaceClass(body, 'result-mid-size', 'result-max-size');
          }
          else {
            removeClass(body, 'result-mid-size');
          }
        }
        else if (hasClass(body, 'result-max-size')) {
          replaceClass(body, 'result-max-size', 'result-mid-size');
        }
        else {
          addClass(body, 'result-mid-size');
        }
        return false;
      });
      addEventHandler(elem, "keypress", function(event) {
        if (hasClass(body, 'result-mid-size')) {
          removeClass(body, 'result-mid-size');
        }
        else if (hasClass(body, 'result-max-size')) {
          replaceClass(body, 'result-max-size', 'result-mid-size');
        }
        else {
          addClass(body, 'result-mid-size');
        }
        return false;
      });
    }
  },
  accordion: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this,
          openMode;
      elem.config = config;
      openMode = parseStrToBoolean(config.openMode);
      elem.setOpenMode = type.setOpenMode;
      addEventHandler(elem, "click", type.onclick);
      elem.setOpenMode(openMode);
    },
    onclick: function(event) {
      var target = findAncestor(event.srcElement, "div", "accordion-header");
      if (hasClass(event.srcElement, "accordion-header")) {
        return true;
      }
      if (hasClass(event.srcElement.offsetParent, "accordion-help")) {
        return true;
      }
      target.setOpenMode(!target.config.openMode);
      return false;
    },
    setOpenMode: function(openMode) {
      var elem = this;
      var hideElem = findDescendant(elem.parentNode, "div", "accordion-style");
      var img = findDescendant(elem, "div", "accordion-img");
      if (openMode) {
        if (hasClass(img, "close")) {
          replaceClass(img, "close", "open");
        }
        else {
          addClass(img, "open");
        }
        removeClass(hideElem, "hide");
      }
      else {
        if (hasClass(img, "open")) {
          replaceClass(img, "open", "close");
        }
        else {
          addClass(img, "close");
        }
        addClass(hideElem, "hide");
      }
      elem.config.openMode = openMode;
    }
  },
  accordionButton: {
    init: function (doc, id, config) {
      var elem = doc.getElementById(id),
          type = this,
          button = doc.getElementById(id + ".button");

      elem.config = config;
      elem.showElem = type.showElem;
      setAfterInit(button, function(button) {
        button.config.onclick = type.onclick;
      });
      elem.showElem(doc, id, false);
    },
    onclick: function(type, page, id, button) {
      var elem = findAncestor(button, "td", "accordion-cell"),
          doc = elem.ownerDocument,
          hasClassOpen = hasClass(button, 'accordion-open');

      turnOnOffClass(button, 'accordion-open', !hasClassOpen);
      elem.showElem(elem.ownerDocument, elem.id, !hasClassOpen);
      if (!hasClassOpen) {
        doc.scrollingElement.scrollTop = cumulativeOffsetTop(elem);
      }
    },
    showElem: function(root, targetClass, show) {
      var targetElems = findDescendants(root, '*', targetClass);

      for (var i = 0; i < targetElems.length; i++) {
        turnOnOffClass(targetElems[i], 'accordion-hide', !show);
      }
    }
  },
  guideSteps: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id);
      var type = this;
      var frame = getDefaultView(doc);
      elem.config = config;
      elem.config.feedByBtn = parseStrToBoolean(elem.config.feedByBtn);
      elem.refresh = type.refresh;
      elem.updateTotal = type.updateTotal;
      elem.topLiScroll = type.topLiScroll;
      elem.isVisible = type.isVisible;
      elem.showHideButtons = type.showHideButtons;
      elem.selectStep = type.selectStep;
      elem.feedStep = type.feedStep;
      elem.jumpFirstLastPage = type.jumpFirstLastPage;
      elem.setCallback = type.setCallback;
      elem.getSelectedValue = type.getSelectedValue;
      elem.getSelectedText = type.getSelectedText;
      elem.setLineHeight = type.setLineHeight;
      elem.setScrollAreaHeight = type.setScrollAreaHeight;
      elem.setButtonWidth = type.setButtonWidth;
      elem.getShownFirstValue = type.getShownFirstValue;
      elem.refreshCompletedMark = type.refreshCompletedMark;
      elem.getValueFromId = type.getValueFromId;
      elem.getOptionProperty = type.getOptionProperty;
      elem.refreshSelectedStep = type.refreshSelectedStep;
      elem.scrollToSelected = type.scrollToSelected;

      addEventHandler(elem, "click", type.onclick);

      if (config.width !== undefined) {
        elem.style.width = config.width;
      }

      if (config.feedByBtn) {
        elem.config.timeoutId = null;
        addEventHandler(elem, "mousedown", type.onmousedown);
      }
      else{
        addClass(elem, "guide-steps-scroll");
        if (config.height !== undefined) {
          elem.style.height = config.height;
        }
      }

      addEventHandler(frame, "resize", function(event) {
        elem.setScrollAreaHeight();
      });
    },
    getValueFromId: function(idValue) {
      var str = idValue.split(".")[1];
      return parseInt(str, 10);
    },
    getOptionProperty: function(option) {
      var elem = this;
      var paragraphLabelElem = findDescendant(option, "span", "guide-steps-paragraph");
      var menueElem = findDescendant(option, "span", "guide-steps-menu");
      var menueLabelElem = firstElementNode(menueElem);
      var paragraphStr;
      var menueStr;
      var value = elem.getValueFromId(option.id);
      paragraphStr = paragraphLabelElem.innerText.replace(/^ *\n */, '').replace(/ *\n *$/, '');
      menueStr = menueLabelElem.innerText.replace(/^ *\n */, '').replace(/ *\n *$/, '');

      var props = {
        value: value,
        paragraph: paragraphStr,
        text: menueStr
      };
      return props;
    },
    refresh: function(obj, selected, topval, height) {
      var elem = this;
      var config = elem.config;
      var ul = findDescendant(elem, "ul", "guide-steps-items");
      var guideNum;
      var isAllRefresh = false;
      var lis;
      var i;
      var range = [];
      var props;
      var TOTAL_STEPS_AREA = 36;

      function isValueExist(options, checkValue) {
        for (var i = 0; i < options.length; i++) {
          if (options[i].value == checkValue) {
            return true;
          }
        }
        return false;
      }

      function getShowRange(options, topval, isAllRefresh, selected) {
        var NUM_OF_BUTTON = 5;
        var firstIndex;
        var lastIndex;
        var curShowFirstValue;
        var i;

        if (!config.feedByBtn) {
          return null;
        }

        if ((options.length !== 0) && (options.length < NUM_OF_BUTTON)) {
          firstIndex = 0;
          lastIndex = options.length - 1;
        }
        else {
          if (topval === null) {
            if (isAllRefresh) {
              topval = selected;
            }
            else {
              curShowFirstValue = elem.getShownFirstValue();
              if((selected < curShowFirstValue) || (selected > curShowFirstValue + (NUM_OF_BUTTON - 1))) {
                //not visible
                topval = selected;
              }
              else {
                //visible
                topval = elem.getSelectedValue();
              }
            }
          }

          for (i = 0; i < options.length; i++) {
            if (options[i].value == topval) {
              firstIndex = i;
              break;
            }
          }

          if (firstIndex === undefined) {
            firstIndex = 0;
          }

          lastIndex = firstIndex + (NUM_OF_BUTTON - 1);
          if (!options[lastIndex]) {
            //show last page
            firstIndex = options.length - NUM_OF_BUTTON;
            lastIndex = options.length - 1;
          }
        }

        var range = {
          first: firstIndex,
          last: lastIndex
        };

        return range;
      }

      function buildHTML(obj, guideNum, selected, range) {
        var html = [];
        var row = [];
        var classes;
        var headLi;
        var paragraph;
        var menu;
        var menuButton;
        var i;

        for (i = 0; i < guideNum; i++) {
          if(!obj[i].className) {
            obj[i].className = "";
          }
          classes = obj[i].className;
          if (parseInt(obj[i].value, 10) === selected) {
            classes += " guide-steps-item-selected";
          }

          if (i === (guideNum - 1)) {
            classes += " guide-steps-item-last";
          }

          if (config.feedByBtn && (i < range.first) || (i > range.last)) {
            classes += " hide";
          }

          if (obj[i].disabled) {
            classes += " disabled";
          }

          headLi = '<li id="' + elem.id + "." + obj[i].value + '" class="guide-steps-item' + classes + '">';

          if (!obj[i].classNameParagraph) {
            obj[i].classNameParagraph = "";
          }
          paragraph = '<span class="guide-steps-paragraph ' + obj[i].classNameParagraph + '">' + obj[i].paragraph + '</span>';

          if (!obj[i].classNameMenu) {
            obj[i].classNameMenu = "";
          }
          menu = '<span class="guide-steps-menu ' + obj[i].classNameMenu + '"><label>' + obj[i].text + '</label></span>';

          if (!obj[i].classNameMenuButton) {
            obj[i].classNameMenuButton = "";
          }
          menuButton = '<div class="guide-steps-button ' + obj[i].classNameMenuButton + '">';

          row.push(headLi);
          row.push(menuButton);
          row.push(paragraph);
          row.push(menu);
          row.push('<span class="uifcomponent-step-complete"></span></div>');
          row.push('<ins class="guide-steps-arrow"></ins>');
          row.push('</li>');
        }
        html.push(row.join(''));
        return html.join('');
      }

      if ((height > TOTAL_STEPS_AREA) && !config.feedByBtn) {
        elem.style.height = height + "px";
      }

      if((obj === null) || (obj === undefined)) {
        obj = [];
        lis = findDescendants(ul, "li", "guide-steps-item");

        for (i = 0; i < lis.length; i++) {
          props = elem.getOptionProperty(lis[i]);
          obj.push(props);
        }
      }
      else {
        isAllRefresh = true;
      }

      removeLastUndefined(obj);

      if((selected === null) || (selected === undefined) || (!isValueExist(obj, selected))) {
        selected = elem.getSelectedValue();
        if (selected === null && obj[0]) {
          selected = obj[0].value;
        }
      }
      selected = parseInt(selected, 10);

      if((topval === null) || (topval === undefined) || (!isValueExist(obj, topval))) {
        topval = null;
      }

      guideNum = obj.length;

      if (config.feedByBtn) {
        range = getShowRange(obj, topval, isAllRefresh, selected);
      }

      if(isAllRefresh) {
        ul.innerHTML = buildHTML(obj, guideNum, selected, range);

        elem.setScrollAreaHeight();
        elem.setLineHeight();
        elem.updateTotal();
        if (config.feedByBtn) {
          elem.showHideButtons();
        }
        else {
          elem.setButtonWidth();
          if (topval !== null) {
            elem.topLiScroll(topval);
          }
          else {
            if (!elem.isVisible(selected)) {
              elem.topLiScroll(selected);
            }
          }
        }
      }
      else {
        if ((height > TOTAL_STEPS_AREA) && !config.feedByBtn) {
          elem.setScrollAreaHeight();
        }
        elem.refreshSelectedStep(selected, range, topval);
      }
      elem.scrollToSelected();
    },
    scrollToSelected: function() {
      var root = this,
          scrollArea = findDescendant(root, 'div', "guide-steps-scrollarea"),
          selected = findDescendant(root, 'li', "guide-steps-item-selected");
      if (selected === null) return;
      if (isCRXMode()) {
        scrollToHorizontally(scrollArea, selected, 0);
      }
    },
    setLineHeight: function() {
      var elem = this;
      var menus = findDescendants(elem, "span", "guide-steps-menu");
      var LINE_HEIGT_MULTI_LINE = 1.5;
      var BUTTON_HEIGHT = 60;
      var paragraph;
      var label;
      var marginTop;

      for (var i = 0; i < menus.length; i++) {
        label = firstElementNode(menus[i]);
        if (!isCRXMode() && label.offsetHeight > BUTTON_HEIGHT) {
          //multi line
          menus[i].style.lineHeight = LINE_HEIGT_MULTI_LINE + "em";
          paragraph = prevElementNode(menus[i]);
          paragraph.style.verticalAlign = "top";
          marginTop = (BUTTON_HEIGHT - menus[i].clientHeight) / 2;
          menus[i].style.marginTop = marginTop + "px";
        }
      }
    },
    setScrollAreaHeight: function() {
      //if window heigh expand, scrollarea height is (elem height) - (total step heith).
      var elem = this;
      var scrollArea;
      var totalStepArea;
      var scrollAreaHeight;

      if (!hasClass(elem, "guide-steps-scroll")){
        return;
      }

      //modern browzer use calc().
      if (!isModernBrowser) {
        scrollArea = findDescendant(elem, "div", "guide-steps-scrollarea");
        totalStepArea = findDescendant(elem, "div", "guide-steps-otherwis-bottom");

        scrollAreaHeight = elem.clientHeight - totalStepArea.clientHeight;
        if (scrollAreaHeight < 0) {
          return;
        }
        scrollArea.style.height = scrollAreaHeight + 'px';
      }
    },
    setButtonWidth: function() {
      var elem = this;
      var ul;
      var scrollArea;
      var UL_LEFT_RIGHT_MARGIN = 20;
      var scrollbarWidth;
      var width;

      if (!hasClass(elem, "guide-steps-scroll")){
        return;
      }

      if (getIEVersion(window.navigator.userAgent) === 7) {
        //if do not set width, button width resize small on click.

        scrollArea = findDescendant(elem, "div", "guide-steps-scrollarea");
        ul = findDescendant(elem, 'ul', 'guide-steps-items');

        if (scrollArea.scrollHeight > scrollArea.clientHeight) {
          scrollbarWidth = 18; //exist scroll bar
        }
        else {
          scrollbarWidth = 0;
        }
        width = elem.clientWidth - scrollbarWidth - UL_LEFT_RIGHT_MARGIN;
        if(width < 0) {
          return;
        }
        ul.style.width = elem.clientWidth - scrollbarWidth - UL_LEFT_RIGHT_MARGIN + 'px';
      }
      else {
        return;
      }
    },
    updateTotal: function() {
      var elem = this;
      var doc = elem.ownerDocument;
      var totalElem = doc.getElementById(elem.id + ".total");
      var stepNum = findDescendants(elem, "li", "guide-steps-item").length;
      totalElem.innerText = stepNum;
    },
    topLiScroll: function(value) {
      var elem = this;
      var doc = elem.ownerDocument;
      var topLi = doc.getElementById(elem.id + "." + value);
      var scrollArea = findDescendant(elem, "div", "guide-steps-scrollarea");
      if (scrollArea && topLi) {
        scrollArea.scrollTop = topLi.offsetTop;
      }
    },
    isVisible: function(value) {
      var elem = this;
      var config = elem.config;
      var doc = elem.ownerDocument;
      var li = doc.getElementById(elem.id + "." + value);
      var BUTTON_HEIGHT = 60;
      var target;
      var scrollArea;
      var curPosScrollTop;
      var curPosscrollBtm;
      var targetTop;
      var targetBtm;
      var margin;
      var offsetparentMarginTop;
      var steps;

      if (li === null) {
        return false;
      }

      if (config.feedByBtn) {
        if (hasClass(li, "hide")) {
          return false;
        }
        else {
          return true;
        }
      }
      else {
        target = findDescendant(li, "div", "guide-steps-button");
        scrollArea = findDescendant(elem, "div", "guide-steps-scrollarea");
        curPosScrollTop = scrollArea.scrollTop;
        curPosscrollBtm = curPosScrollTop + scrollArea.clientHeight;
        margin = Math.round(BUTTON_HEIGHT * 0.9);

        steps = findDescendant(elem, "ul", "guide-steps-items");
        offsetparentMarginTop = steps.offsetTop;

        targetTop = target.offsetTop + offsetparentMarginTop;
        targetBtm = targetTop + BUTTON_HEIGHT;

        if((curPosscrollBtm >= (targetTop + margin)) && (curPosScrollTop <= (targetBtm - margin))) {
            return true;
        } else {
            return false;
        }
      }
    },
    showHideButtons: function() {
      var elem = this;
      var doc = elem.ownerDocument;
      var prevBtn = doc.getElementById(elem.id + ".prev");
      var nextBtn = doc.getElementById(elem.id + ".next");
      var items = findDescendants(elem, "li", "guide-steps-item");
      var DEFAULT_VIEW_NUM = 5;
      var dispItems = [];

      if (items.length <= DEFAULT_VIEW_NUM) {
        addClass(prevBtn, "hide");
        addClass(nextBtn, "hide");
        return;
      }

      for (var i = 0; i < items.length; i++) {
        if (!(hasClass(items[i], "hide"))) {
          dispItems.push(items[i]);
        }
      }
      if (items[0] === dispItems[0]) {
        addClass(prevBtn, "hide");
        removeClass(nextBtn, "hide");
      } else if (items[items.length - 1] === dispItems[dispItems.length - 1]) {
        addClass(nextBtn, "hide");
        removeClass(prevBtn, "hide");
      } else {
        if (hasClass(prevBtn, "hide")) {
          removeClass(prevBtn, "hide");
        }
        if (hasClass(nextBtn, "hide")) {
          removeClass(nextBtn, "hide");
        }
      }
    },
    onclick: function(event) {
      var target = event.srcElement;
      var elem = findAncestor(target, 'div', 'guide-steps');

      if ( (hasClass(target, "guide-steps-button") && !hasClass(target, "guide-steps-page-button")) || ((target.tagName === "SPAN") && (target.parentNode.className !== "guide-steps-total")) || (target.tagName === "LABEL")) {
        elem.selectStep(target);
      } else if (hasClass(target, "guide-steps-page-button") || (target.className === "uifcomponent-btn-dec1") || (target.className === "uifcomponent-btn-inc1")) {
        elem.feedStep(target);
      }
    },
    onmousedown: function(event) {
      var target = event.srcElement;
      var elem = findAncestor(target, 'div', 'guide-steps');

      if (hasClass(target, "guide-steps-page-button") || (target.className === "uifcomponent-btn-dec1") || (target.className === "uifcomponent-btn-inc1")) {
        elem.jumpFirstLastPage(target);
      }
    },
    selectStep: function(target) {
      var elem = this;
      var doc = elem.ownerDocument;
      var frame = getDefaultView(doc);
      var config = elem.config;
      var li = findAncestor(target, 'li', 'guide-steps-item');
      var newValue = elem.getValueFromId(li.id);
      var oldValue = elem.getSelectedValue();

      if (hasClass(li, "disabled")) {
        return;
      }
      addClassExclusively(elem, li, "guide-steps-item-selected");

      if (oldValue === newValue) {
        return;
      }

      if (typeof config.callback === 'function') {
        config.callback(elem.id, "clicked", newValue);
      } else {
        VTRNRequest(frame, {request: elem.id + ".clicked", value: newValue}).send();
      }
    },
    feedStep: function(target) {
      var elem = this;
      var doc = elem.ownerDocument;
      var button = target;
      var dispItems = [];
      var items;
      var nextView;

      if (elem.config.timeoutId !== null) {
        clearTimeout(elem.config.timeoutId);
        elem.config.timeoutId = null;
      }
      items = findDescendants(elem, "li", "guide-steps-item");
      if (target.tagName === 'INS') {
        button = target.parentNode;
      }
      for (var i = 0; i < items.length; i++) {
        if (!(hasClass(items[i], "hide"))) {
          dispItems.push(items[i]);
        }
      }
      if (button === doc.getElementById(elem.id + ".prev")) {
        nextView = dispItems[0].previousSibling;
        addClass(dispItems[dispItems.length - 1], "hide");
      } else if (button === doc.getElementById(elem.id + ".next")) {
        nextView = dispItems[dispItems.length - 1].nextSibling;
        addClass(dispItems[0], "hide");
      }
      removeClass(nextView, "hide");
      elem.showHideButtons();
    },
    jumpFirstLastPage: function(target) {
      var elem = this;
      var doc = elem.ownerDocument;
      var button = target;
      var nextViews = [];
      var DEFAULT_VIEW_NUM = 5;
      var items, i;

      elem.config.timeoutId = setTimeout(function(){
        items = findDescendants(elem, "li", "guide-steps-item");
        if (target.tagName === 'INS') {
          button = target.parentNode;
        }
        if (button === doc.getElementById(elem.id + ".prev")) {
          for (i = 0; i < DEFAULT_VIEW_NUM; i++) {
            nextViews.push(items[i]);
          }
        } else if (button === doc.getElementById(elem.id + ".next")) {
          for (i = (items.length - DEFAULT_VIEW_NUM); i < items.length; i++) {
            nextViews.push(items[i]);
          }
        }
        for (i = 0; i < items.length; i++) {
          if (!(hasClass(items[i], "hide"))) {
            addClass(items[i], "hide");
          }
        }
        for (i = 0; i < nextViews.length; i++) {
          removeClass(nextViews[i], "hide");
        }
        elem.showHideButtons();
        elem.config.timeoutId = null;
      }, 500);
    },
    getSelectedValue: function() {
      var elem = this;
      var selected;

      selected = findDescendant(elem, 'li', "guide-steps-item-selected");
      if (selected === null) {
        return null;
      }
      return elem.getValueFromId(selected.id);
    },
    getSelectedText: function() {
      var elem = this,
          selected = findDescendant(elem, 'li', "guide-steps-item-selected"),
          paragraph, menu, text = "";
      if (selected === null) return "";
      paragraph = findDescendant(selected, 'span', "guide-steps-paragraph");
      menu = findDescendant(selected, 'span', "guide-steps-menu");
      if (paragraph !== null) text += paragraph.innerText;
      if (menu !== null) text += ' ' + menu.innerText;
      return text;
    },
    getShownFirstValue: function() {
      var elem = this;
      var options;
      var i;
      var len;

      options = findDescendants(elem, 'li', "guide-steps-item");
      if (options === null) {
        return null;
      }

      for (i = 0, len = options.length; i < len; i++) {
        if (!hasClass(options[i], "hide")) {
          break;
        }
      }

      if (i >= len) {
        return null;
      }

      return elem.getValueFromId(options[i].id);
    },
    setCallback: function(callback) {
      var elem = this;
      elem.config.callback = callback;
    },
    refreshCompletedMark: function(value, isCompleted) {
      var elem = this;
      var targetId = elem.id + "." + value;
      var doc = elem.ownerDocument;
      var targetButton = doc.getElementById(targetId);

      if (null === targetButton) {
        return;
      }
      turnOnOffClass(targetButton, 'guide-steps-item-completed', isCompleted);
    },
    refreshSelectedStep: function(selected, range, topval) {
      var elem = this;
      var config = elem.config;
      var targetId = elem.id + "." + selected;
      var doc = elem.ownerDocument;
      var targetButton = doc.getElementById(targetId);
      var ul;
      var li;
      var checkIndex;

      if (null === targetButton) {
        return;
      }
      elem.selectStep(targetButton);

      if (config.feedByBtn) {
        ul = findDescendant(elem, "ul", "guide-steps-items");

        for (checkIndex = 0, li = firstElementNode(ul); checkIndex < ul.childNodes.length && li !== null; checkIndex++, li = nextElementNode(li)) {
          turnOnOffClass(li, 'hide', (checkIndex < range.first) || (checkIndex > range.last));
        }
        elem.showHideButtons();
      }
      else {
        if (topval !== null) {
          elem.topLiScroll(topval);
        }
        else {
          if (!elem.isVisible(selected)) {
            elem.topLiScroll(selected);
          }
        }
      }
    }
  },
  slider: {
    init: function (doc, id, config) {
      var elem = doc.getElementById(id),
          type = this,
          invalidRange = doc.getElementById(id + ".invalidRange"),
          validRange = doc.getElementById(id + ".validRange"),
          minHandle = doc.getElementById(id + ".minHandle"),
          maxHandle = doc.getElementById(id + ".maxHandle");

      config.func = type.func;
      elem.config = config;
      elem.refresh = type.refresh;
      elem.setStep = type.setStep;
      elem.setOnChange = type.setOnChange;
      elem.setOnInput = type.setOnInput;
      elem.scrollId = null;
      elem.isScrolling = false;
      elem.config.decimals = parseFloat(config.decimals);

      if (minHandle !== null) {
        addEventHandler(minHandle, isTablet() ? "touchmove" : "drag", type.onmousemove);
        addEventHandler(minHandle, isTablet() ? "touchstart" : "dragstart", type.onmousedown);
        addEventHandler(minHandle, isTablet() ? "touchend" : "dragend", type.onmouseup);
      }
      addEventHandler(maxHandle, isTablet() ? "touchmove" : "drag", type.onmousemove);
      addEventHandler(maxHandle, isTablet() ? "touchstart" : "dragstart", type.onmousedown);
      addEventHandler(maxHandle, isTablet() ? "touchend" : "dragend", type.onmouseup);
      addEventHandler(invalidRange, "mousedown", type.onclick);
      addEventHandler(validRange, "mousedown", type.onclick);
      addEventHandler(doc, "scroll", type.onscroll(id));
    },
    refresh: function (curLow, curHigh, min, max, disabled) {
      var elem = this,
          config = elem.config,
          doc = elem.ownerDocument,
          maxHandle = doc.getElementById(elem.id + ".maxHandle"),
          range = doc.getElementById(elem.id + ".validRange");

      function getRatio(value) {
        return (value - config.min) / (config.max - config.min);
      }
      elem.disabled = disabled;
      config.min = parseFloat(min);
      config.max = parseFloat(max);
      config.high = parseFloat(curHigh);
      maxHandle.style.left = getRatio(config.high) * 100 + '%';

      if (!config.twoHandles) {
        range.style.width = maxHandle.style.left;
      }
      else {
        var minHandle = doc.getElementById(elem.id + ".minHandle");

        config.low = parseFloat(curLow);
        minHandle.style.left = getRatio(config.low) * 100 + '%';
        range.style.left = minHandle.style.left;
        range.style.width = (getRatio(config.high) - getRatio(config.low)) * 100 + '%';
      }
    },
    onmouseup: function (event) {
      var elem = event.currentTarget,
          slider = elem.parentNode.parentNode,
          config = slider.config,
          isLowHandle = (elem.id === slider.id + ".minHandle");

      if (slider.isScrolling || slider.disabled) return;
      removeClass(elem, "dragged");
      if (config.onchange) {
        config.onchange(isLowHandle, isLowHandle ? config.low : config.high);
      }
    },
    onmousedown: function (event) {
      var elem = event.currentTarget,
          slider = elem.parentNode.parentNode;

      if (slider.isScrolling || slider.disabled) return;
      addClass(elem, "dragged");
      if (!isTablet()) {
        event.dataTransfer.setDragImage(document.createElement('div'), 0, 0);
      }
      else {
        event.preventDefault();
      }
    },
    onmousemove: function (event) {
      var elem = event.currentTarget,
          slider = elem.parentNode.parentNode,
          posX = (isTablet() ? event.touches[0].clientX : event.clientX);

      if (slider.isScrolling || slider.disabled || posX === 0) return;
      slider.config.func.updateSlider(slider, posX, elem.id);
    },
    onclick: function (event) {
      var elem = event.currentTarget,
          slider = elem.parentNode,
          config = slider.config,
          oldConfigHigh = config.high;

      if (slider.isScrolling || slider.disabled) return;
      config.func.updateSlider(slider, event.clientX, elem.id);
      if (config.onchange) {
        var isLowHandle = (oldConfigHigh === config.high);
        config.onchange(isLowHandle, isLowHandle ? config.low : config.high);
      }
    },
    onscroll: function (id) {
      return function (_event) {
        var elem = this.getElementById(id);
        elem.isScrolling = true;
        clearTimeout(elem.scrollId);
        elem.scrollId = setTimeout(function () {
          elem.isScrolling = false;
        }, 500);
      };
    },
    setStep: function (step) {
      var elem = this,
          stepLength = String(step).split('.');

      elem.config.decimals = (stepLength[1]) ? stepLength[1].length : -(stepLength[0].length - 1);
    },
    setOnChange: function (onchange) {
      var elem = this;
      elem.config.onchange = onchange;
    },
    setOnInput: function (oninput) {
      var elem = this;
      elem.config.oninput = oninput;
    },
    func: {
      updateSlider: function (slider, position, elemId) {
        var config = slider.config,
            min = config.min,
            max = config.max,
            width = slider.offsetWidth,
            left = slider.offsetLeft,
            HANDLE_WIDTH = 18,
            value = round(((position - left - HANDLE_WIDTH / 2) / (width - HANDLE_WIDTH) * (max - min)) + min),
            isLowHandle;

        function round(value) {
          return Math.round(value * shift(config.decimals)) * shift(-config.decimals);
        }
        function shift(dec) {
          return Math.pow(10, dec);
        }
        if (!config.twoHandles) {
          value = Math.max(min, Math.min(value, max));
          slider.refresh(null, value, min, max, slider.disabled);
        }
        else {
          if (elemId === slider.id + ".minHandle" || elemId === slider.id + ".maxHandle") {
            isLowHandle = (elemId === slider.id + ".minHandle");
          }
          else {
            isLowHandle = (Math.abs(config.low - value) < Math.abs(config.high - value) && elemId === slider.id + ".validRange" ||
                           config.low > value && elemId === slider.id + ".invalidRange");
          }
          if (isLowHandle) {
            config.low = Math.max(min, Math.min(value, config.high));
          }
          else {
            config.high = Math.max(config.low, Math.min(value, max));
          }
          slider.refresh(config.low, config.high, min, max, slider.disabled);
        }
        if (config.oninput) {
          config.oninput(value);
        }
      }
    }
  },
  complexDofZoneCRX: {
    init: function (doc, id, _config) {
      var elem = doc.getElementById(id),
          frame = getDefaultView(doc),
          type = this;

      elem.refresh = type.refresh;
      addEventHandler(frame, "load", function () {
        var slider = doc.getElementById(id + ".slider");
        slider.setOnChange(function (isLowHandle, value) {
          var text = doc.getElementById(id + (isLowHandle ? ".txtMinimum" : ".txtMaximum"));

          text.setValue(value);
        });
      });
    },
    refresh: function (dofEnabled, _nominal, low, high, min, max, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          txtMin = doc.getElementById(elem.id + ".txtMinimum"),
          slider = doc.getElementById(elem.id + ".slider");

      slider.refresh(txtMin.convert(low), txtMin.convert(high), txtMin.convert(min), txtMin.convert(max), disabled);
      turnOnOffClass(elem, "slider-single", !dofEnabled);
    }
  },
  toggleSwitch: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          btnElm = doc.getElementById(id + ".btnOn"),
          frame = getDefaultView(doc),
          type = this;
      elem.refresh = type.refresh;
      elem.config = config;
      if (config.page === undefined) {
        config.page = frame.webpage;
      }
      addEventHandler(btnElm, "click", type.onclick);
      addEventHandler(btnElm, "keypress", type.onkeypress);
    },
    refresh: function(checked, disabled) {
      var elem = this,
          doc = elem.ownerDocument,
          btnOn = doc.getElementById(elem.id + ".btnOn");
      elem.disabled = disabled;
      btnOn.disabled = disabled;
      btnOn.checked = checked;
    },
    onclick: function(event) {
      var btnOn = event.srcElement,
          elem = btnOn.parentNode,
          frame = getDefaultView(elem.ownerDocument),
          config = elem.config;
      VTRNRequest(frame, { webpage: config.page, request: elem.id + ".clicked", value: btnOn.checked }).send();
    },
    onkeypress: function(event) {
      var elem = event.srcElement;
      if (event.keyCode === 13) {
        elem.click();
      }
    }
  },
  toolBoxCRX: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id);
      var btnOpenToolBox = doc.getElementById(elem.id);

      addEventHandler(btnOpenToolBox, "click", this.onclick);
    },
    onclick: function(event) {
      var elem = event.srcElement ? event.srcElement : this,
          id = elem.id.split("."),
          doc = elem.ownerDocument,
          pane = doc.getElementById(id[0] + ".pane");

      turnOnOffClass(pane, "hide", !hasClass(pane, "hide"));
    }
  },
  formLine: {
    init: function(doc, id, config) {
      var elem = doc.getElementById(id),
          type = this;
      elem.refresh = type.refresh;
      elem.config = config;
    },
    refresh: function(trained, image, help, disabled) {
      var elem1 = this,
          doc = elem1.ownerDocument,
          id = elem1.id,
          elem2 = doc.getElementById(id + ".help");
      turnOnOffClass(elem1, 'disabled', disabled);
      turnOnOffClass(elem2, 'disabled', disabled);
      turnOnOffClass(elem1, 'not-trained', !trained);
      turnOnOffClass(elem2, 'not-trained', !trained);
      if (image) {
        var elem3 = doc.getElementById(id + ".illust");
        elem3.src = format("images/%s", image);
      }
      if (help) {
        var elem4 = findDescendant(elem2, 'td', 'form-line-help');
        elem4.innerHTML = help;
      }
    }
  }
};

UIFComponents.selectVisData       = UIFComponents.select;
UIFComponents.selectVisTool       = UIFComponents.select;
UIFComponents.selectInputImage    = UIFComponents.select;
UIFComponents.selectDisplayImage  = UIFComponents.select;
UIFComponents.selectLimitCheck    = UIFComponents.select;
UIFComponents.selectMeasValue     = UIFComponents.select;
UIFComponents.selectZoom          = UIFComponents.select;
UIFComponents.labelWindow         = UIFComponents.label;
UIFComponents.interactiveWindow   = UIFComponents.interactiveButton;
UIFComponents.interactiveMask     = UIFComponents.interactiveButton;
UIFComponents.interactiveLine     = UIFComponents.interactiveButton;
UIFComponents.interactivePoint    = UIFComponents.interactiveButton;
UIFComponents.interactiveSegmline = UIFComponents.interactiveButton;
UIFComponents.interactiveCircle   = UIFComponents.interactiveButton;
UIFComponents.buttonNext          = UIFComponents.buttonText;
UIFComponents.buttonPrev          = UIFComponents.buttonText;
UIFComponents.funcKeysGuide       = UIFComponents.funcKeys;

(function() {
  var userAgent = window.navigator.userAgent;
  var isIEMobile = (typeof userAgent === "string" && userAgent.indexOf("IEMobile") >= 0) ? true : false;
  // var isIEMobile = true;  // See shtmlib.c to debug iPendant pages on PC.
  UIFComponents.global.isIEMobile = isIEMobile;
  unloadEvent = isIEMobile ? "unload" : "pagehide";
})();

/** Return true if script is executed on the iPendant. */
function isiPendant() {
  return UIFComponents.global.isIEMobile;
}

/** Return true if script is executed on the tablet. */
function isTablet() {
  return (window.ontouchstart === null);
}

function isCRXMode() {
  return !(typeof vtop.globalReqParams === "undefined" || vtop.globalReqParams.appType !== 7);
}

function isWebView() {
  var userAgent = window.navigator.userAgent.toLowerCase();
  var iswebview = (typeof userAgent === "string" && userAgent.indexOf("android") >= 0 && userAgent.indexOf("wv") >= 0) ? true : false;
  return iswebview;
}

/** Return true if script is executed on the iRProgrammer. */
function isiRProgrammer() {
  return top === null ? false : typeof top.g_irprog == "undefined" ? false : top.g_irprog;
}

/** Initialize UIF Components. This function is only called by code embeded by embeduifcomponents.pl */
function initComponents(doc, type, id, config) {
  var vuc = UIFComponents[type];
  if (vuc !== undefined) {
    vuc.init(doc, id, config);
    var elem = doc.getElementById(id);
    if (elem !== null && Array.isArray(elem.afterInits)) {
      for (var i = 0, len = elem.afterInits.length; i < len; i++) {
        if (typeof elem.afterInits[i] === 'function') {
          elem.afterInits[i](elem);
        }
      }
    }
  }
}
if (!Array.isArray) {
  Array.isArray = function(value) {
    return Object.prototype.toString.call(value) === '[object Array]';
  };
}
function setAfterInit(elem, afterInit) {
  if (!elem.afterInits) {
    elem.afterInits = [];
  }
  elem.afterInits.push(afterInit);
}

function getBrowserType() {
  var userAgent = window.navigator.userAgent.toLowerCase();
  if (userAgent !== undefined && userAgent !== null) {
    if(userAgent.indexOf('msie') != -1 ||
       userAgent.indexOf('trident') != -1) {
      var version = getIEVersion(window.navigator.userAgent);
      var type = format('Internet Explorer %s', version);
      if (userAgent.match(/\swin64;/)) {
        type += " 64bit";
      }
      return type;
      }
    else if(userAgent.indexOf('edg') != -1) { //Edge contains string "chrome" in its userAgent. So check before chrome.
      return 'Edge';
    }
    else if(userAgent.indexOf('samsungbrowser') != -1) {//Samsung Internet contains string "chrome" in its userAgent. So check before chrome.
      return 'Samsung Internet';
    }
    else if(userAgent.indexOf('opera') != -1 ||  userAgent.indexOf('mms') != -1) {//Opera contains string "chrome" in its userAgent. So check before chrome.
      return 'Opera';
    }
    else if(userAgent.indexOf('android') != -1 && userAgent.indexOf('wv') != -1) {//TabletTPAndroidApp contains string "chrome" in its userAgent. So check before chrome.
      return 'TabletTPAndroidApp';
    }
    else if(userAgent.indexOf('chrome') != -1) {
      return 'Chrome';
    }
    else if(userAgent.indexOf('crios') != -1) {
      return 'iOSChrome';
    }
    else if(userAgent.indexOf('safari') != -1) {
      return 'Safari';
    }
    else if(userAgent.indexOf('firefox') != -1) {
      return 'Firefox';
    }
    else {
      return 'Unknown Browser';
    }
  }
  else {
    return 'Unknown Browser';
  }
}

function getChromeVersion() {
  var useragent = /Chrome\/([\d]+)/.exec(window.navigator.userAgent);
  return useragent === null ? -1 : parseInt(useragent[1], 10);
}

function regPinchEvent(regObj, pinchInFunc, pinchOutFunc) {
  var pinchStart = function(e) {
    var touches = e.touches;

    if (touches.length > 1) {
      e.preventDefault();
      addEventHandler(this, "touchmove", pinchMove);
      addEventHandler(this, "touchend", pinchEnd);
      addEventHandler(this, "touchendoutside", pinchEnd);
      this.eventParam = getDistance(touches);
    }

    function pinchMove(e) {
      var changedTouches = e.changedTouches;

      e.preventDefault();
      if (changedTouches.length > 1) {
        var distance = getDistance(changedTouches);
        if (distance / this.eventParam > 2) {
          removeEventHandler(this, "touchmove", pinchMove);
          removeEventHandler(this, "touchend", pinchEnd);
          removeEventHandler(this, "touchendoutside", pinchEnd);
          pinchOutFunc();
        } else if (distance / this.eventParam < 0.5) {
          removeEventHandler(this, "touchmove", pinchMove);
          removeEventHandler(this, "touchend", pinchEnd);
          removeEventHandler(this, "touchendoutside", pinchEnd);
          pinchInFunc();
        }
      }
    }

    function pinchEnd(e) {
      removeEventHandler(this, "touchmove", pinchMove);
      removeEventHandler(this, "touchend", pinchEnd);
      removeEventHandler(this, "touchendoutside", pinchEnd);
    }

    function getDistance(position) {
      return Math.sqrt(Math.pow(position[1].pageX - position[0].pageX, 2) + Math.pow(position[1].pageY - position[0].pageY, 2));
    }
  };
  addEventHandler(regObj, "touchstart", pinchStart);
}

function inputFocusSlideForm(elem, slide) {
  var elementYPos = window.pageYOffset + elem.getBoundingClientRect().top + elem.ownerDocument.defaultView.frameElement.getBoundingClientRect().top;
  var keyboardHeight = 300;
  if (isiRProgrammer() && !top.irprogapi.getSlideScreenSide()) return;
  if (slide && (window.innerHeight - keyboardHeight) > elementYPos) return;
  if (slide) {
    vtop.document.body.style.bottom = keyboardHeight + "px" ;
    vtop.document.body.style.position = "relative";
  }
  else {
    vtop.document.body.style.bottom = "";
    vtop.document.body.style.position = "";
  }
}

function isIpc() {
  return UIFComponents.global.isStandalone;
}
