// import from vis_advlib.js
/*global advlib*/
const advlibf = advlib.funcs;
const advlibv = advlib.vars;

const POS_COMMENT = "VISION FIND POS";

const globalData = {
  deviceInfo: null,
  camDataTrained: false,
  visProcTrained: false,
  visProcExist: false,
  prgNameCnt: 0,
  numVisProcs: 0,
  deviceType: advlibv.TTY_CSCX,
  visProgList: {},
  trainedCamDataList: []
};

const OFFSET = 0;

const lsArg = {
  option:        new advlibf.InstArgString(""),
  version:       new advlibf.InstArgInt(3),
  vpName:        new advlibf.InstArgString(""),
  vreg:          new advlibf.InstArgInt(1),
  reg:           new advlibf.InstArgInt(advlibv.REG_NOT_SELECTED),
  deviceName:    new advlibf.InstArgString(""),
  position: {
    data:        new advlibf.InstArgPos(advlibv.POS_KIND_POSNUM, 0),
    trained:     new advlibf.InstArgInt(advlibv.POS_NOT_TRAINED)
  },
  moveType:      new advlibf.InstArgInt(advlibv.POS_MOVE_LINE),
  posSpeed:      new advlibf.InstArgInt(200),
  enableSnapPos: new advlibf.InstArgBool(1),
  camDataName:   new advlibf.InstArgString(""),
  stopTime:      new advlibf.InstArgFloat(0.0)
};

const instArgs = new advlibf.InstArgs([
  lsArg.option,
  lsArg.version,
  lsArg.vpName,
  lsArg.vreg,
  lsArg.reg,
  lsArg.deviceName,
  lsArg.position.data,
  lsArg.position.trained,
  lsArg.moveType,
  lsArg.posSpeed,
  lsArg.enableSnapPos,
  lsArg.camDataName,
  lsArg.stopTime
]);

const ihmif = top.IHMIComponents.cf;

async function getAllInformation() {
  const deviceName = lsArg.deviceName.text;

  const resAllCamData = await advlibf.getCamData({ trained_only: false }, deviceName);
  const resTrainedCamData = await advlibf.getCamData({ trained_only: true }, deviceName);
  const allCamData = resAllCamData.data_names;
  const trainedCamData = resTrainedCamData.data_names;

  if (!allCamData.find(dataName => dataName === lsArg.camDataName.text)) {
    lsArg.camDataName.text = "";
  }

  const notTrainedCamData = allCamData.filter(dataName => !trainedCamData.includes(dataName));
  const sortedAllCamData = trainedCamData.concat(notTrainedCamData);

  if (sortedAllCamData.length > 0) {
    if (lsArg.camDataName.text === "") {
      lsArg.camDataName.text = sortedAllCamData[0];
    }
  }
  else {
    lsArg.vpName.text = "";
    lsArg.position.trained.value = advlibv.POS_NOT_TRAINED;
  }

  const resDeviceInfo = await advlibf.promiseRequest({ request: "get_deviceinfo", device_name: deviceName, type: globalData.deviceType });
  globalData.deviceInfo = resDeviceInfo;

  const resVisProcs = await advlibf.promiseRequest({ request: "get_dataprops", category: advlibv.IID_VISIONPROCESS, type: resDeviceInfo.visproc_type });
  const propsVisProcs = resVisProcs.properties.filter(props => props.offset_type === OFFSET);
  globalData.visProgList = propsVisProcs;

  const visProcExist = propsVisProcs.find(props => props.name === lsArg.vpName.text);
  if (visProcExist && visProcExist.camera_name === deviceName) {
    globalData.visProcTrained = visProcExist.is_trained;
    if (lsArg.camDataName.text !== visProcExist.camdata_name) {
      lsArg.camDataName.text = visProcExist.camdata_name;
    }
  }
  globalData.visProcExist = visProcExist;

  const optionsNotTrainedCamData = advlibf.createUntrainedOptions(notTrainedCamData);
  const optionsAllCamData = trainedCamData.concat(optionsNotTrainedCamData);
  document.getElementById("selCameraData").refresh(optionsAllCamData, lsArg.camDataName.text, false);
  globalData.camDataTrained = (trainedCamData.indexOf(lsArg.camDataName.text) >= 0);
  globalData.trainedCamDataList = trainedCamData;

  const nameOptions = createVisProgOptions(propsVisProcs);
  document.getElementById("selVisProc").refresh(nameOptions, lsArg.vpName.text, lsArg.vpName.text, false);
  globalData.numVisProcs = nameOptions.length;

  const regOptions = await advlibf.createRegOptions();
  document.getElementById('selVRIndex').refresh(regOptions.vreg, lsArg.vreg.value, null, false);
  document.getElementById('selRIndex').refresh(regOptions.nreg, lsArg.reg.value, null, false);
}

// eslint-disable-next-line no-unused-vars
function dispAdvInstData(argStr) {
  const success = setFirstArg(argStr);
  if (!success) return false;

  getAllInformation()
    .catch(status => advlibf.popupAlert(status))
    .finally(() => {
      advlibf.initPositionComponent("robotPos", lsArg.position.data.number, lsArg.position.data.kind, callBackPosition, function () {
        refreshAll();
        advlibf.setInitLsArg(instArgs.text);
        advlibf.showVisionRuntime(globalData.deviceType, lsArg.deviceName.value);
      });
    });
  
  return true;
}

function setFirstArg(argStr) {
  if (argStr.length === 0) {
    return false;
  }
  instArgs.text = argStr;
  lsArg.version.value = 3;
  return true;
}

function callBackPosition(id, operation, posNum, posData) {
  const posInfo = advlibf.getPosInformation(id, operation, posNum);

  if (posData.status === advlibv.POS_STATUS_NORMAL) {
    advlibf.setPosComment(posInfo, POS_COMMENT);
  }

  if (posInfo.trained) {
    lsArg.position.trained.value = advlibv.POS_TRAINED;
  }
  else if (lsArg.position.data.kind !== posInfo.kind ||
    lsArg.position.data.number !== posInfo.number) {
    lsArg.position.trained.value = posData.status !== advlibv.POS_STATUS_NORMAL ? advlibv.POS_TRAINED : advlibv.POS_NOT_TRAINED;
  }
  lsArg.position.data.kind = posInfo.kind;
  lsArg.position.data.number = posInfo.number;
  refreshAll();
  setLsArg();
}

function refreshAll() {
  let hide, elemTraining, notTrained;
  const trained = [];
  trained[0] = globalData.camDataTrained;
  advlibf.turnOnOffTrained("divCameraSetup", trained[0]);

  trained[1] = (lsArg.vpName.text !== '' && lsArg.reg.value !== -1 && globalData.visProcTrained);
  advlibf.turnOnOffTrained("divDetectionSetup", trained[1]);

  trained[2] = ((lsArg.position.trained.value === advlibv.POS_TRAINED || !lsArg.enableSnapPos.value) && globalData.visProcTrained);
  advlibf.turnOnOffTrained("divSnapPosition", trained[2]);
  advlibf.turnOnOffTrained("divOffsetMotion", trained[2]);

  const isAccordionPosOpen = ihmif.hasClass(document.getElementById('accordionPos'), "position-folding-bg-desc");

  if (!trained[0]) {
    elemTraining = "divCameraSetup";
  }
  else if (!trained[1]) {
    elemTraining = "divDetectionSetup";
  }
  else if (!trained[2]) {
    elemTraining = "divSnapPosition";
  }
  else {
    elemTraining = "divOffsetMotion";
  }
  ihmif.addClassExclusively(document.getElementById("divContent"), document.getElementById(elemTraining), 'training');

  hide = trained[0] || lsArg.camDataName.text !== "";
  ihmif.turnOnOffClass(document.getElementById("helpCameraSetup"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("btnCreateCamData"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("divAccCamData"), 'hide', !hide);
  ihmif.turnOnOffClass(document.getElementById("divCameraData"), 'hide', !hide);

  document.getElementById('btnCreateCamData').setRequiredMark(true);

  notTrained = !globalData.camDataTrained;
  document.getElementById('btnOpenCamData').setRequiredMark(notTrained);
  document.getElementById('btnOpenCamData2').setRequiredMark(notTrained);

  const isAccordionCamDataOpen = !ihmif.hasClass(document.getElementById('accordionCamData'), "position-folding-bg-asc");
  hide = (!trained[0] && lsArg.camDataName.text === "") || isAccordionCamDataOpen;
  ihmif.turnOnOffClass(document.getElementById("btnOpenCamData"), 'hide', hide);

  hide = (!trained[0] || globalData.visProcTrained || globalData.numVisProcs !== 0);
  ihmif.turnOnOffClass(document.getElementById("helpDetectionSetup"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("btnCreateVisProc"), 'hide', hide);

  document.getElementById('btnCreateVisProc').setRequiredMark(true);

  notTrained = !globalData.visProcTrained && lsArg.vpName.text !== "";
  document.getElementById('btnOpenVisProc').setRequiredMark(notTrained);

  notTrained = lsArg.vpName.text === "";
  document.getElementById('selVisProc').setRequiredMark(notTrained);

  notTrained = lsArg.reg.value === advlibv.REG_NOT_SELECTED;
  document.getElementById('selRIndex').setRequiredMark(notTrained);

  hide = (!trained[0] && lsArg.vpName.text === "") || (!globalData.visProcTrained && globalData.numVisProcs === 0);
  ihmif.turnOnOffClass(document.getElementById("divDetectionItems"), 'hide', hide);

  hide = (!trained[0] || !trained[1] || !globalData.visProcTrained || !lsArg.enableSnapPos.value);
  ihmif.turnOnOffClass(document.getElementById("robotPosAcc"), 'hide', hide);

  hide = (!trained[0] || !trained[1] || !globalData.visProcTrained ||
    ihmif.hasClass(document.getElementById("accordionPos"), 'position-folding-bg-desc') || !lsArg.enableSnapPos.value);
  ihmif.turnOnOffClass(document.getElementById("helpBtnTeach"), 'hide', hide);

  document.getElementById('txtStopTime').refresh(lsArg.stopTime.text, "0.000", "100.000", false);
  const posData = document.getElementById('robotPos').getPosInfoCurrentKind();
  document.getElementById('btnTeach').setRequiredMark(!lsArg.position.trained.value);
  document.getElementById('btnTeach').refresh(posData.status !== advlibv.POS_STATUS_NORMAL, undefined);
  
  hide = !trained[1];
  ihmif.turnOnOffClass(document.getElementById("divPositionArea"), 'hide', hide);

  hide = (!(trained[0] && trained[1] && !trained[2] && globalData.visProcTrained));
  ihmif.turnOnOffClass(document.getElementById("helpSnapPosition"), 'hide', hide);

  hide = (!trained[0] || !trained[1] || !trained[2] || !globalData.visProcTrained);
  ihmif.turnOnOffClass(document.getElementById("helpOffsetMove"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("helpOffsetMoveLink"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("cameraSetupTitle"), 'bold', hide);
  ihmif.turnOnOffClass(document.getElementById("detectionTitle"), 'bold', hide);
  ihmif.turnOnOffClass(document.getElementById("snapPositionTitle"), 'bold', hide);

  hide = lsArg.moveType.value === advlibv.POS_MOVE_LINE;
  ihmif.turnOnOffClass(document.getElementById("speedTextBoxArea1"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("joint_unit"), 'hide', hide);

  hide = !hide;
  ihmif.turnOnOffClass(document.getElementById("speedTextBoxArea0"), 'hide', hide);
  ihmif.turnOnOffClass(document.getElementById("line_unit"), 'hide', hide);

  hide = !ihmif.hasClass(document.getElementById("helpBtnTeach"), "hide");
  ihmif.turnOnOffClass(document.getElementById("divSnapPosMove"), "hide", hide);

  document.getElementById("tglVisPosMoveCheck").refresh(lsArg.enableSnapPos.value);
  hide = !isAccordionPosOpen || !lsArg.enableSnapPos.value;
  ihmif.turnOnOffClass(document.getElementById("accordionPosOpen"), 'hide', hide);

  document.getElementById("selMoveType").refresh([], lsArg.moveType.value, null, false);
  if (lsArg.moveType.value === advlibv.POS_MOVE_LINE) {
    document.getElementById('txtSpeedLine').refresh(lsArg.posSpeed.value, "1", "3000", false);
  }
  else {
    document.getElementById('txtSpeedJoint').refresh(lsArg.posSpeed.value, "0", "100", false);
  }
  document.getElementById("btnOpenVisProc").refresh(null, null, null, null, (!globalData.visProcExist || lsArg.vpName.text === ""));
  document.getElementById("btnCreateVisProc2").refresh(null, null, null, null, !globalData.camDataTrained);

  ihmif.removeClass(document.body, "hidden");
}

function setLsArg() {
  parent.setInstructionParam(instArgs.text);
}

function selectMoveType(_id, _type, value) {
  lsArg.moveType.text = value;
  lsArg.posSpeed.text = (lsArg.moveType.value === advlibv.POS_MOVE_LINE) ? 200 : 100;
  refreshAll();
  setLsArg();
}
function selectSpeed(_id, _type, value) {
  lsArg.posSpeed.text = value;
  setLsArg();
}

function selectVisReg(_id, _type, value) {
  lsArg.vpName.text = document.getElementById('selVisProc').getValue();
  lsArg.vreg.text = value;
  lsArg.reg.text = document.getElementById('selRIndex').getValue();
  setLsArg();
}
function selectReg(_id, _type, value) {
  lsArg.vpName.text = document.getElementById('selVisProc').getValue();
  lsArg.vreg.text = document.getElementById('selVRIndex').getValue();
  lsArg.reg.text = value;
  refreshAll();
  setLsArg();
}
function selectVisProg(_id, _type, value) {
  lsArg.vpName.text = value;
  lsArg.vreg.text = document.getElementById('selVRIndex').getValue();
  lsArg.reg.text = document.getElementById('selRIndex').getValue();
  lsArg.position.trained.value = advlibv.POS_NOT_TRAINED;
  globalData.visProcExist = globalData.visProgList.find(props => props.name === lsArg.vpName.text);
  if (globalData.visProcExist) {
    globalData.visProcTrained = globalData.visProcExist.is_trained;
  }
  refreshAll();
  setLsArg();
}

async function createVisData(dataName, camName, deviceInfo) {// create new vision program
  lsArg.vpName.text = dataName.toUpperCase();
  advlibf.createVisData(dataName, camName, deviceInfo)
    .then(() => {
      globalData.prgNameCnt = 0;
      lsArg.position.trained.value = advlibv.POS_NOT_TRAINED;
      setLsArg();
      advlibf.jumpVisionPage(dataName);
    })
    .catch(status => {
      if (advlibv.DAT_E_EXISTS.test(status)) {
        dataName = dataName.replace(/_\d+$/, "");
        globalData.prgNameCnt++;
        createVisData(`${dataName}_${globalData.prgNameCnt}`, camName, deviceInfo);
      }
      else {
        advlibf.popupAlert(status);
      }
    });
}

function btnCreateCamData(_id, _type, _value) {
  const dataName = advlibf.getDataName("CAM_", lsArg.deviceName.text).toUpperCase();
  const prgNameCnt = 0;
  advlibf.tryCreateCamData(dataName, globalData.deviceInfo, prgNameCnt, (dataName) => {
    lsArg.camDataName.text = dataName;
    lsArg.vpName.text = "";
    setLsArg();
    advlibf.jumpVisionPage(dataName);
  });
}
function btnCreateVisData(_id, _type, _value) {
  const dataName = advlibf.getDataName("VP_", lsArg.deviceName.text);
  createVisData(dataName, lsArg.camDataName.text, globalData.deviceInfo);
}
function openVisProg(_id, _type, _value) {
  const prgName = document.getElementById("selVisProc").getValue();
  if (prgName === "") {
    advlibf.popupAlert("Please select program.");
    return;
  }
  advlibf.jumpVisionPage(prgName);
}
function openCamData(_id, _type, _value) {
  setLsArg();
  advlibf.jumpVisionPage(lsArg.camDataName.text);
}
function camAccordion(id, _action) {
  advlibf.accordionOpenClose(id, '');
  refreshAll();
}
function selectCameraData(_id, _type, value) {
  lsArg.camDataName.text = value;
  globalData.camDataTrained = globalData.trainedCamDataList.find(name => name === lsArg.camDataName.text) !== undefined;
  lsArg.vpName.text = "";
  globalData.visProcExist = false;
  globalData.visProcTrained = false;
  const nameOptions = createVisProgOptions(globalData.visProgList);
  document.getElementById("selVisProc").refresh(nameOptions, lsArg.vpName.text, lsArg.vpName.text, false);
  globalData.numVisProcs = nameOptions.length;
  refreshAll();
  setLsArg();
}
function createVisProgOptions(visProgList) {
  const optionsVisProcs = visProgList.filter(props => props.camdata_name === lsArg.camDataName.text);
  const trainedData = optionsVisProcs.filter(props => props.is_trained).map(props => props.name);
  const untrainedData = optionsVisProcs.filter(props => !props.is_trained).map(props => props.name);
  const untrainedOptions = advlibf.createUntrainedOptions(untrainedData);
  return trainedData.concat(untrainedOptions);
}
function inputStopTime(_id, _type, value) {
  lsArg.stopTime.text = value;
  refreshAll();
  setLsArg();
}
function toggleSnapPos(_id, _operation, checked) {
  lsArg.enableSnapPos.value = checked;
  refreshAll();
  setLsArg();
}
// eslint-disable-next-line no-unused-vars
function openHelp() {
  advlibf.openHelp(window, `${ advlibv.HELP_PATH }/find_hlp_motion.htm`);
}
function snapPosAccordion(id, _action) {
  advlibf.accordionOpenClose(id, 'helpBtnTeach');
  refreshAll();
}

window.onload = function () {
  document.getElementById('btnCreateCamData').setCallback(btnCreateCamData);
  document.getElementById('btnOpenCamData').setCallback(openCamData);
  document.getElementById('accordionCamData').setCallback(camAccordion);
  document.getElementById('selCameraData').setCallback(selectCameraData);
  document.getElementById('btnCreateCamData2').setCallback(btnCreateCamData);
  document.getElementById('btnOpenCamData2').setCallback(openCamData);
  document.getElementById('btnCreateVisProc').setCallback(btnCreateVisData);
  document.getElementById('btnOpenVisProc').setCallback(openVisProg);
  document.getElementById('btnCreateVisProc2').setCallback(btnCreateVisData);
  document.getElementById('selVisProc').setCallback(selectVisProg);
  document.getElementById('selVRIndex').setCallback(selectVisReg);
  document.getElementById('selRIndex').setCallback(selectReg);
  document.getElementById('selMoveType').setCallback(selectMoveType);
  document.getElementById('txtSpeedLine').setCallback(selectSpeed);
  document.getElementById('txtSpeedJoint').setCallback(selectSpeed);
  document.getElementById('txtStopTime').setCallback(inputStopTime);
  document.getElementById('tglVisPosMoveCheck').setCallback(toggleSnapPos);
  document.getElementById('accordionOutput').setCallback((id, _action) => advlibf.accordionOpenClose(id, ''));
  document.getElementById('btnTeach').setCallback((_id, _action) => advlibf.pushTouchUp('robotPos'));
  document.getElementById('accordionPos').setCallback(snapPosAccordion);
};
