const advlib = {
  vars: null,
  funcs: null
};

(function () {
  const ihmic = top.IHMIComponents;
  const ihmif = ihmic.cf;
  const editor = top.home;
  const irpapi = top.irprogapi;
  const editorAPI = top.home.editorAPI.funcs;

  advlib.vars = {
    TTY_CSCX: 153,
    TTY_CD3C: 179,
    TTY_VPSS: 181,
    TTY_VP2S: 4,
    TTY_CCGP: 8,

    IID_VISIONPROCESS: 6,
    IID_CAMERADATA:    93,

    GAZE_LINE: 4,

    DAT_E_EXISTS: /CVIS-100/,

    HELP_PATH: '/frh/vision/crxvision',

    POS_KIND_POSNUM:        ihmic.position.posDef.POSKIND_NUM,
    POS_KIND_POSREG:        ihmic.position.posDef.POSKIND_REG,
    POS_KIND_MODE_SELECTED: ihmic.position.posDef.POSKIND_SEL,

    REG_NOT_SELECTED: -1,
    POS_NOT_TRAINED:   0,
    POS_TRAINED:       1,
    POS_MOVE_LINE:     0,
    POS_STATUS_NORMAL: 0
  };

  const advlibv = advlib.vars;
  const POS_KIND_POSNUM = advlibv.POS_KIND_POSNUM;
  const POS_KIND_POSREG = advlibv.POS_KIND_POSREG;

  class InstArg {
    constructor(value) {
      this.value = value;
    }
    set argText(argText) {
      this.value = argText;
    }
    get argText() {
      return this.value.toString();
    }
    set text(text) {
      this.argText = text;
    }
    get text() {
      return this.argText;
    }
  }
  class InstArgBool extends InstArg {
    set argText(argText) {
      this.value = (parseInt(argText, 10) === 1);
    }
    get argText() {
      const value = this.value ? 1 : 0;
      return value.toString(10);
    }
  }
  class InstArgInt extends InstArg {
    set argText(argText) {
      const text = argText.replace(/(\(|\))/g, ""); // FIXME: What is the purpose of this line?
      this.text = text;
    }
    set text(text) {
      this.value = parseInt(text, 10);
    }
    get argText() {
      return this.value.toString(10);
    }
    get text() {
      return this.argText;
    }
  }
  class InstArgFloat extends InstArg {
    set argText(argText) {
      const text = argText.replace(/(\(|\))/g, ""); // FIXME: What is the purpose of this line?
      this.text = text;
    }
    set text(text) {
      this.value = parseFloat(text);
    }
    get argText() {
      return this.value.toString(10);
    }
    get text() {
      return this.argText;
    }
  }
  class InstArgString extends InstArg {
    set argText(argText) {
      let text = argText.match(/^'(.*)'$/)[1];
      if (text === '...') {
        text = '';
      }
      this.text = text;
    }
    set text(text) {
      this.value = text;
    }
    get argText() {
      return `'${this.text}'`;
    }
    get text() {
      return this.value;
    }
  }
  class InstArgPos extends InstArg {
    constructor(kind, number) {
      super(number);
      this.kind = kind;
      this.number = number;
    }
    set argText(argText) {
      const matched = argText.match(/\[(\d*|\.{3})[\]:]/)[1];
      this.kind = argText.indexOf("PR") === 0 ? POS_KIND_POSREG : POS_KIND_POSNUM;
      this.number = matched === "..." ? advlibv.POS_NOT_TRAINED : parseInt(matched, 10);
    }
    get argText() {
      const posHead = (this.kind === POS_KIND_POSNUM) ? "P" : "PR";
      return `${posHead}[${this.number}]`;
    }
  }
  class InstArgs {
    constructor(argsArray) {
      this.args = argsArray;
    }
    set text(argsText) {
      const argTexts = argsText.split(",");
      this.args.forEach((instArg, i) => {
        if (typeof (argTexts[i]) !== "undefined") {
          instArg.argText = argTexts[i];
        }
      });
    }
    get text() {
      const argTexts = this.args.map((instArg) => instArg.argText);
      return argTexts.join(',');
    }
  }

  function getResponseJson(response) {
    eval(`var data =${response.firstChild.textContent}`);
    // eslint-disable-next-line no-undef
    return data;
  }
  function promiseRequest(request) {
    return new Promise((resolve, reject) => {
      window.iHMIReqParams = { path: "/softpart/sfvrgr" };
      // eslint-disable-next-line new-cap
      ihmif.IUIFRequest(window, request).send((response) => {
        const res = getResponseJson(response);
        if (res.status !== "") {
          reject(res.status);
        }
        else {
          resolve(res);
        }
      });
    });
  }
  function popupAlert(status) {
    ihmif.alertMessage(status, "G[", null, editor, null);
  }
  function validateVisionDataName(dataName) {
    return dataName.replace(/[\s:\-/]+/g, '_');
  }
  function accordionOpenClose(changeId, hiddenId) {
    const hasClassDesc = ihmif.hasClass(document.getElementById(changeId), 'position-folding-bg-desc');

    ihmif.turnOnOffClass(document.getElementById(`${changeId}Open`), 'hide', hasClassDesc);
    ihmif.replaceClass(document.getElementById(changeId),
                       hasClassDesc ? 'position-folding-bg-desc' : 'position-folding-bg-asc',
                       hasClassDesc ? 'position-folding-bg-asc' : 'position-folding-bg-desc');
    if (hiddenId !== '') ihmif.turnOnOffClass(document.getElementById(hiddenId), 'hide', !hasClassDesc);
  }
  async function getDevices(deviceType) {
    function flatten(tree, array) {
      tree.devices.forEach(device => {
        array.push(device);
        flatten(device, array);
      });
      return array;
    }
    const devices = [];
    const deviceData = await promiseRequest({ request: "get_devices", type: deviceType });
    flatten(deviceData, devices);
    return devices;
  }
  async function createDeviceOptions(deviceType) {
    const devices = await getDevices(deviceType);
    return devices.filter(device => device.type === deviceType).map(device => device.name);
  }
  async function createRegOptions() {
    const createRegArray = (comments) => {
      return comments.map((comment, index) => [`${index + 1}: ${comment}`, index + 1]);
    };
    const resRegInfo = await promiseRequest({ request: "get_reginfo" });

    return {
      nreg: createRegArray(resRegInfo.nregs),
      vreg: createRegArray(resRegInfo.vregs)
    };
  }
  async function createCamData(dataName, deviceInfo, setVisParams) {
    const createVisRequest = { request: "create_visdata", data_name: dataName, type: deviceInfo.camdata_type, cam_protocol: deviceInfo.cam_protocol, port_num: deviceInfo.port_num, cam_type: deviceInfo.cam_type, img_height: deviceInfo.img_height, img_width: deviceInfo.img_width, vt_spacing: deviceInfo.vt_spacing, aspect_ratio: deviceInfo.aspect_ratio },
          setVisRequest = { request: "set_visdata", data_name: dataName, use_hdr: true, led_type: 36, led_intensity: 1 };

    if (deviceInfo.camdata_type === advlibv.TTY_CD3C) {
      createVisRequest.projector_id = 0;
      createVisRequest.port2 = 0;
      createVisRequest.use_hdr = 1;
    }
    if (setVisParams) {
      Object.assign(setVisRequest, setVisParams);
    }

    await promiseRequest(createVisRequest);
    await promiseRequest(setVisRequest);
  }
  function tryCreateCamData(dataName, deviceInfo, prgNameCnt, callBackCreateCamData) {// create new cam program
    createCamData(dataName, deviceInfo)
      .then(() => {
        callBackCreateCamData(dataName);
      })
      .catch(status => {
        if (advlibv.DAT_E_EXISTS.test(status)) {
          dataName = dataName.replace(/_\d+$/, "");
          prgNameCnt++;
          tryCreateCamData(`${dataName}_${prgNameCnt}`, deviceInfo, prgNameCnt, callBackCreateCamData);
        }
        else {
          popupAlert(status);
        }
      });
  }
  function createJumpCamData(dataName, deviceInfo, setVisParams) {
    return createCamData(dataName, deviceInfo, setVisParams)
      .then(() => jumpVisionPage(dataName))
      .catch(status => {
        if (advlibv.DAT_E_EXISTS.test(status)) {
          jumpVisionPage(dataName);
        }
        else {
          popupAlert(status);
        }
      });
  }
  function createVisData(dataName, camName, deviceInfo, params) {// create new vision program
    const request = { request: "create_visdata", data_name: dataName, type: deviceInfo.visproc_type, camera_name: camName, ofs_type: 0, ofs_frm_num: 0, set_ofs_frm_method: 1, use_hdr: true };
    if (params) {
      Object.assign(request, params);
    }
    if (request.type === advlibv.TTY_VPSS) {
      request.min_depth = -4000;
      request.max_depth = 4000;
      request.scale_enable = true;
      request.aspect_enable = true;
    }
    return promiseRequest(request);
  }
  function getDataName(prefix, deviceName) {
    const camName = validateVisionDataName(deviceName);
    return prefix + camName;
  }
  function setIRPGlobal(key, value) {
    if (typeof top.VisionGlobal === 'undefined') {
      top.VisionGlobal = {};
    }
    top.VisionGlobal[key] = value;
  }
  function jumpVisionPage(dataName) {
    setIRPGlobal('dataName', dataName);
    const props = { value: "/softpart/genlink?&current=browser&amp;current=/frh/vision/vsvtrn.stm?_screen_id=10;_focus_flag=1;_customval=fromfind" }; // cannot use '&' in 'current'
    top.treemod.nodeOnClick(null, props);
    editor.instructionFrameHide();
  }

  function openHelp(frame, helpPage, custom) {
    const customObj = {
      header: "",
      designpattern: "mouse",
      callerWindowObj: frame,
      width: "80%",
      height: "80%",
    };

    Object.assign(customObj, custom);

    ihmif.appendPopupFrm(helpPage, null, frame.parent, customObj);
  }

  function turnOnOffTrained(id, trained) {
    const elem = document.getElementById(id);
    if (trained) {
      ihmif.replaceClass(elem, 'not-trained', 'trained');
    }
    else {
      ihmif.replaceClass(elem, 'trained', 'not-trained');
    }
  }

  function showVisionRuntime(deviceType, deviceName) {
    editor.instructionFrameDisp(`/frh/vision/visionliveframe.stm?${[deviceType, ihmif.encodeURIComponentLocal(deviceName), "livemode"].join('&')}`);
  }

  function pushTouchUp(id, _action) {
    document.getElementById(`${id}.touchup`).click();
  }

  function initPositionComponent(id, posNum, posKind, callback, initCallback, initArgsObj) {
    const initCompleteArgs = {
      elmId:     id,
      posNumber: posNum,
      posKind:   posKind
    };

    const initArgs = {
      initCompleteCallback: initCallback,
      initCompleteArgs:     initCompleteArgs,
      disableComment:       false,
      posMode:              advlibv.POS_KIND_MODE_SELECTED,
      posKind:              posKind,
      number:               posNum
    };

    Object.assign(initArgs, initArgsObj);
    const elem = document.getElementById(id);
    elem.refresh(initArgs);
    elem.setCallback(callback);
  }
  function setPosComment(posInfo, posComment) {
    const elem = posInfo.elem;
    switch (posInfo.kind) {
      case advlibv.POS_KIND_POSNUM: {
        const posData = elem.getPosition(posInfo.number);
        if (posData.comment === "") {
          posData.comment = posComment;
          elem.postPosition(posData);
        }
        break;
      }
      case advlibv.POS_KIND_POSREG: {
        const writeData = JSON.parse(JSON.stringify(elem.config.posRegRecord));
        if (writeData.comment === "") {
          writeData.comment = posComment;
          writeData.rep = top.POS_REP_NONE;
          writeData.chgCmnt = true;
          elem.savePosRegister(writeData, `${posInfo.id}.cmnttxt`); // Save the PosReg record
        }
        break;
      }
      default:
        break;
    }
  }
  function getPosInformation(id, operation, posNum) {
    const posTrained = (operation === "touchup" ||
                        operation === "selposnum" ||
                        operation === "new"),
          elem = document.getElementById(id),
          posKind = elem.getCurrentPosKind();
    const posInformation = {
      id:      id,
      trained: posTrained,
      elem:    elem,
      kind:    posKind,
      number:  posNum
    };
    return posInformation;
  }
  function getCamData(customObj, deviceName) {
    const reqGetCamData = { request: "get_datanames", category: advlibv.IID_CAMERADATA, camera_name: deviceName };
    return promiseRequest(Object.assign(customObj, reqGetCamData));
  }
  function confirmMessage(popupMessage, id, callbackList, customOption) {
    const customObj = {
      selectBtn: {
        1: { label: null },
        2: { label: null },
        3: { label: null },
        4: { label: null },
        5: { label: null }
      },
      isHTML: true
    };
    callbackList.forEach(function (element, index) {
      customObj.selectBtn[index + 1].label = element.label;
    });
    Object.assign(customObj, customOption);
    ihmif.confirmMessage(window.webpage, popupMessage, id, null, null, top.home.window, label => {
      const matched = label.match(/btn(\d+)/);
      if (matched !== null) { // Not processing when a 'X'button is pressed.
        const index = parseInt(matched[1], 10) - 1;
        if (typeof callbackList[index].callback === 'function') callbackList[index].callback();
      }
      if (typeof callbackList[0].finallyCallback === 'function') callbackList[0].finallyCallback();
    }, null, customObj);
  }
  async function createPosRegOptions() {
    let posRegMax = irpapi.getRegMaxNum(irpapi.REG_TYPE_POS);
    if (posRegMax === null) {
      await promiseSetPosRegMax();
      posRegMax = irpapi.getRegMaxNum(irpapi.REG_TYPE_POS);
    }
    const group = irpapi.getCurrentGroupNum();
    const posRegComment = await promiseGetPosReg(group, 1, posRegMax);
    return Object.values(posRegComment).map((values, index) => [`${ index + 1 }: ${ values.comment }`, index + 1]);
  }
  function promiseGetPosReg(group, startNum, posRegMax) {
    return new Promise((resolve) => {
      irpapi.getPosRegValue(group, startNum, posRegMax, response => {
        resolve(response);
      });
    });
  }
  function promiseSetPosRegMax() {
    return new Promise((resolve) => {
      irpapi.setRegMaxNum(response => {
        resolve(response);
      });
    });
  }
  function initPositionData(tppName, posNum, posKind) {
    promiseRequest({ request: "init_position", tpp_name: tppName, pos_num: posNum, pos_kind: posKind });
  }
  async function isPosDataInit(posRegNum) {
    const group = irpapi.getCurrentGroupNum();
    const tempPosregValue = await promiseGetPosReg(group, posRegNum, 1);
    return Object.keys(tempPosregValue[Object.keys(tempPosregValue)[0]]).length !== 1;
  }
  function createUntrainedOptions(untrainedDataArray) {
    return untrainedDataArray.map(name => [name, name, '/frh/vision/images/vsbttn_not_set2.png']);
  }
  //Update tp program without registering undoPoint
  function setInitLsArg(params) {
    const lineNum = parent.instructionGetCurrentLineNum();
    editorAPI.setAdinstArg(lineNum, params);
  }

  advlib.funcs = {
    InstArgInt:             InstArgInt,
    InstArgString:          InstArgString,
    InstArgFloat:           InstArgFloat,
    InstArgPos:             InstArgPos,
    InstArgBool:            InstArgBool,
    InstArgs:               InstArgs,
    getResponseJson:        getResponseJson,
    promiseRequest:         promiseRequest,
    popupAlert:             popupAlert,
    accordionOpenClose:     accordionOpenClose,
    getDevices:             getDevices,
    createDeviceOptions:    createDeviceOptions,
    createRegOptions:       createRegOptions,
    createCamData:          createCamData,
    tryCreateCamData:       tryCreateCamData,
    createJumpCamData:      createJumpCamData,
    createVisData:          createVisData,
    getDataName:            getDataName,
    jumpVisionPage:         jumpVisionPage,
    openHelp:               openHelp,
    turnOnOffTrained:       turnOnOffTrained,
    showVisionRuntime:      showVisionRuntime,
    pushTouchUp:            pushTouchUp,
    initPositionComponent:  initPositionComponent,
    setPosComment:          setPosComment,
    getPosInformation:      getPosInformation,
    getCamData:             getCamData,
    confirmMessage:         confirmMessage,
    createPosRegOptions:    createPosRegOptions,
    promiseGetPosReg:       promiseGetPosReg,
    initPositionData:       initPositionData,
    isPosDataInit:          isPosDataInit,
    createUntrainedOptions: createUntrainedOptions,
    setInitLsArg:           setInitLsArg
  };
})();
