/* ESLint setting*/
/* global editorAPI Promise */

(function(){
  // const
  var STTCHWLD_VERSION = '1';

  var WP_CONST = 1;
  var WP_REGI = 2;

  var SEL_OPTLIST_SPEED_UNI = [
    // ['%',        '0'],
    ['mm/sec',   '1'],
    ['cm/min',   '2'],
    ['inch/min', '3'],
    ['deg/sec',  '4'],
    ['sec',      '5'],
    ['msec',     '6']
  ];
  
  function spf(str){
    var i = 0;
    var args = arguments;
    return str.replace(/%s/g, () => args[++i]);
  }

  var insertPos = undefined;
  // eslint-disable-next-line no-unused-vars
  var langResr = {
    'inst_sttch_start'   : '޼ -INST_ARC_STITCH_START(%s,%s,[%s],[%s],%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)',
    'inst_sttch_end'     : '޼ -INST_ARC_STITCH_END(%s,%s,[%s],[%s],%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)',
    'inst_weld_start'    : ' [%s] %s  ֳ¶[%s,%s]',
    'inst_weld_end'      : ' [%s] %s  ֳµ[%s,%s]',
    'inst_weld_end_wid'  : ' [%s] %s  ֳµ[%s,%s,WID:0]',
    'inst_move_approach' : ' [%s] %s ׶100',
    'inst_comment'       : '!Stitch_Weld',
    'inst_prm_regi'      : 'ڼ',
    'inst_prm_pos'       : '',
    'inst_prm_wldspd'    : 'ֳ¿'
  };

  // eslint-disable-next-line no-unused-vars
  function cPosData(posNum, comment, group, uf, ut, conf, rep, cart, joint, ext){
    this.posNumber = posNum;
    this.comment = comment;
    this.group = group;
    this.uf = uf; this.ut = ut;
    this.conf = conf;
    this.rep = rep;
    // ini
    this.cart = {};
    this.joint = {};
    this.ext = {};

    switch (rep) {
      case 2: // cart
        this.cart.X = cart.X;
        this.cart.Y = cart.Y;
        this.cart.Z = cart.Z;
        this.cart.W = cart.W;
        this.cart.P = cart.P;
        this.cart.R = cart.R;
        break;
      case 6: // cart+ext
        this.cart.X = cart.X;
        this.cart.Y = cart.Y;
        this.cart.Z = cart.Z;
        this.cart.W = cart.W;
        this.cart.P = cart.P;
        this.cart.R = cart.R;
        this.ext.E1 = ('E1' in ext) ? ext.E1 : undefined;
        this.ext.E2 = ('E2' in ext) ? ext.E2 : undefined;
        this.ext.E3 = ('E3' in ext) ? ext.E3 : undefined;
        break;
      default:  // join
        break;
    }
  }

  function asyncSetTpOrder(insertPos, orderArray, posDataObj){
    return new Promise(function(resolve, reject){
      function wrapperCb(status, numInsrtOrder, numEditPos){
        if (status == 0) {
          resolve({status, numInsrtOrder, numEditPos});
        } else {
          reject({status, numInsrtOrder, numEditPos});
        }
      }
      top.home.editorAPI.funcs.setTpOrder(insertPos, orderArray, posDataObj, wrapperCb);
    });
  }

  function icnDroptCallBack(editorArgObj){
    insertPos = editorArgObj.line;

    showSttchwldWizard();
    return false;
  }

  function showSttchwldWizard(){
    var wizardPath = '/frh/inst/sttchwld/sttchwld_wizard.stm';
    var customizeObj = {};

    customizeObj.appendCbArg = {};
    customizeObj.popupPos = 1;
    top.IHMIComponents.cf.appendWizardFrm(wizardPath, wizardCloseCallback, window, customizeObj);
  }

  async function wizardCloseCallback(argObj){
    if (('closeTrigger' in argObj == false) || (argObj.closeTrigger !== 'comp')) {
      return;
    }

    var appParam = argObj.appParam;
    var numPos = appParam.numWld * 3 + 1; // appParam.numWld * 2 + appParam.numWld - 1 + 2;
    var posNumList = genPosNumList(numPos);

    var prgLineList = genProgLineList(posNumList, appParam);
    var posDataList = genPosDataList(posNumList, appParam);

    // package and pos data delpoy
    await asyncSetTpOrder(insertPos, prgLineList, posDataList);
  }

  function genPosNumList(numPos){
    var regexpPos = new RegExp(langResr.inst_prm_pos + '\\[(?<posNum>\\d+)\\]');
    var posNumList = [];
    var posNumStr = '';
    for (var idx = 0; idx < numPos; idx++) {
      posNumStr += spf('%s[N],', langResr.inst_prm_pos);
    }
    posNumStr = posNumStr.substring(0, posNumStr.length - 1);
    var uniqPosNumStr = top.home.editorAPI.funcs.getPosNumber(posNumStr);

    for (var itm of uniqPosNumStr.split(',')) {
      var match = itm.match(regexpPos);
      if (match != undefined) {
        posNumList.push(match.groups.posNum);
      }
    }

    return posNumList;
  }

  function genPosDataList(posNumList, appParam){
    var stPos = appParam.stPos;
    var endPos = appParam.endPos;
    var totLen = appParam.totLen;
    var numWld = appParam.numWld;
    var lenWld = appParam.lenWld;
    var wldPtch = appParam.wldPtch;
    var aprHght = appParam.aprHght;

    var posIdx = 0;
    var posDataList = [];
    // calc unit vector(x, y, z)
    var lenX = endPos.cart.X - stPos.cart.X;
    var lenY = endPos.cart.Y - stPos.cart.Y;
    var lenZ = endPos.cart.Z - stPos.cart.Z;
    var uniVec = Math.sqrt(Math.pow(lenX, 2) + Math.pow(lenY, 2) + Math.pow(lenZ, 2));
    var uniCart = {X: lenX / uniVec, Y: lenY / uniVec, Z: lenZ / uniVec, W: stPos.w, P: stPos.p, R: stPos.r};
    var uniEpos = new cPosData(undefined, undefined, 1, stPos.uf, stPos.ut, stPos.conf, stPos.rep, uniCart, undefined, stPos.ext);

    var lenEposVec = multiEposVec(uniEpos, lenWld);
    var lastEposVec = multiEposVec(uniEpos, totLen - wldPtch * (numWld - 1));
    var aprOfstEposVec = calcAprOfstVec(stPos);
    var aprHghtEposVec = multiEposVec(aprOfstEposVec, aprHght);

    var ptchEposVec = multiEposVec(uniEpos, 0);
    var stEpos = addEposVec(stPos, ptchEposVec);
    for (var cnt = 1; cnt <= numWld; cnt++) {
      var endEpos = (wldPtch * (cnt - 1) + lenWld <= totLen) ? addEposVec(stEpos, lenEposVec) : addEposVec(stEpos, lastEposVec);
      stEpos.posNumber = posNumList[posIdx++];
      stEpos.comment = spf('%s%s_Weld_Start', cnt, getOrdinal(cnt));
      endEpos.posNumber = posNumList[posIdx++];
      endEpos.comment = spf('%s%s_Weld_End', cnt, getOrdinal(cnt));
      posDataList.push(stEpos);
      posDataList.push(endEpos);

      if (cnt <= numWld - 1) {
        // push apr pos;
        ptchEposVec = multiEposVec(uniEpos, wldPtch * cnt);
        stEpos = addEposVec(stPos, ptchEposVec);

        var midEpos = multiEposVec(addEposVec(stEpos, endEpos), 0.5);
        midEpos = addEposVec(midEpos, aprHghtEposVec);
        midEpos.posNumber = posNumList[posIdx++];
        midEpos.comment = 'Approach';
        posDataList.push(midEpos);
      }
    }

    // push stPos, endPos
    posDataList.push(new cPosData(posNumList[posIdx++], '', stPos.group, stPos.uf, stPos.ut, stPos.conf, stPos.rep, stPos.cart, undefined, stPos.ext));
    posDataList.push(new cPosData(posNumList[posIdx++], '', endPos.group, endPos.uf, endPos.ut, endPos.conf, endPos.rep, endPos.cart, undefined, stPos.ext));

    return posDataList;
  }
  function getOrdinal(num){
    var ORDINAL = {1: 'st', 2: 'nd', 3: 'rd'};
    var cnt = num % 100;

    if (10 <= cnt && cnt <= 20) return 'th';

    cnt = cnt % 10;
    return (cnt in ORDINAL) ? ORDINAL[cnt] : 'th';
  }

  function addEposVec(cPosA, cPosB){
    var cart = {
      X : cPosA.cart.X + cPosB.cart.X, Y : cPosA.cart.Y + cPosB.cart.Y, Z : cPosA.cart.Z + cPosB.cart.Z,
      W : cPosA.cart.W,                P : cPosA.cart.P,                R : cPosA.cart.R
    };
    return new cPosData(
      undefined, undefined,
      cPosA.group, cPosA.uf, cPosA.ut, cPosA.conf, cPosA.rep, cart, undefined, cPosA.ext
    );
  }
  // eslint-disable-next-line no-unused-vars
  function subEposVec(cPosA, cPosB){
    var cart = {
      X : cPosA.cart.X - cPosB.cart.X, Y : cPosA.cart.Y - cPosB.cart.Y, Z : cPosA.cart.Z - cPosB.cart.Z,
      W : cPosA.cart.W,                P : cPosA.cart.P,                R : cPosA.cart.R
    };
    return new cPosData(
      undefined, undefined,
      cPosA.uf, cPosA.ut, cPosA.conf, cPosA.conf, cPosA.rep, cart, undefined, cPosA.ext
    );
  }
  function multiEposVec(epos, mult){
    var cart = {
      X : epos.cart.X * mult, Y : epos.cart.Y * mult, Z : epos.cart.Z * mult,
      W : epos.cart.W,        P : epos.cart.P,        R : epos.cart.R
    };
    return new cPosData(
      undefined, undefined,
      epos.group, epos.uf, epos.ut, epos.conf, epos.rep, cart, undefined, epos.ext
    );
  }
  function calcAprOfstVec(epos){
    var vecZ = [0, 0, 1];
    var cosW = Math.cos(epos.cart.W * Math.PI / 180);
    var sinW = Math.sin(epos.cart.W * Math.PI / 180);
    var cosP = Math.cos(epos.cart.P * Math.PI / 180);
    var sinP = Math.sin(epos.cart.P * Math.PI / 180);
    var cosR = Math.cos(epos.cart.R * Math.PI / 180);
    var sinR = Math.sin(epos.cart.R * Math.PI / 180);
    // rotate w
    vecZ = [
      vecZ[0],
      vecZ[1] * cosW - vecZ[2] * sinW,
      vecZ[1] * sinW + vecZ[2] * cosW
    ];
    // rotate p
    vecZ = [
      vecZ[0] * cosP + vecZ[2] * sinP,
      vecZ[1],
      - vecZ[0] * sinP + vecZ[2] * cosP
    ];
    // rotate r
    vecZ = [
      vecZ[0] * cosR - vecZ[1] * sinR,
      vecZ[0] * sinR + vecZ[1] * cosR,
      vecZ[2]
    ];
    var cart = {X: vecZ[0], Y: vecZ[1], Z: vecZ[2], W: epos.cart.W, P: epos.cart.P, R: epos.cart.R};
    return new cPosData(
      undefined, undefined,
      epos.group, epos.uf, epos.ut, epos.conf, epos.rep, cart, undefined, epos.ext
    );
  }

  function genProgLineList(posNumList, appParam){
    function cnvNumObj2Str(obj){
      var resp;
      switch (obj.type) {
        case WP_CONST:
          resp = obj.val.toString();
          break;
        case WP_REGI:
          resp = spf('%s[%s]', langResr.inst_prm_regi, obj.val.toString());
          break;
      }
      return resp;
    }

    var numWld = appParam.numWld;
    var aprSpdVal = appParam.aprSpdVal;
    var aprSpdUni = appParam.aprSpdUni;
    var posIdx = 0;
    var prgLineList = [];

    //
    var strWldStrt = langResr.inst_weld_start;
    var strWldEnd = (top.home.g_sysval['$AWSCFG.$WELD_ID_ENA'].value) ? langResr.inst_weld_end_wid : langResr.inst_weld_end;
    var strUsePrv = (appParam.usePrevPrm) ? '1' : '0';

    // 
    var strSpdUni = SEL_OPTLIST_SPEED_UNI.find((itm) => itm[1] == aprSpdUni);'mm/sec';
    var strSpd = spf('%s%s', aprSpdVal, (strSpdUni !== undefined) ? strSpdUni[0] : 'mm/sec');
    var strStWpNum = cnvNumObj2Str(appParam.stWpNum);
    var strStWsNum = cnvNumObj2Str(appParam.stWsNum);
    var strEndWpNum = cnvNumObj2Str(appParam.endWpNum);
    var strEndWsNum = cnvNumObj2Str(appParam.endWsNum);

    // push comment
    prgLineList.push(langResr.inst_comment);
    for (var idx = 0; idx < numWld; idx++) {
      // push weld start
      prgLineList.push(spf(strWldStrt, posNumList[posIdx++], strSpd, strStWpNum, strStWsNum));
      // push weld end
      prgLineList.push(spf(strWldEnd, posNumList[posIdx++], langResr.inst_prm_wldspd, strEndWpNum, strEndWsNum));
      if (idx < numWld - 1) {
        // push move approach pos
        prgLineList.push(spf(langResr.inst_move_approach, posNumList[posIdx++], strSpd));
      }
    }

    // push inst stitch weld icon
    prgLineList.splice(0, 0, spf(langResr.inst_sttch_start,
      STTCHWLD_VERSION, strUsePrv, posNumList[posNumList.length - 2], posNumList[posNumList.length - 1], appParam.teachMethod, appParam.totLen.toFixed(3), appParam.numWld, appParam.lenWld.toFixed(3), appParam.wldPtch.toFixed(3), appParam.wldSpac.toFixed(3),
      appParam.aprSpdVal.toFixed(1), appParam.aprSpdUni, appParam.aprHght.toString(), strStWpNum, strStWsNum, strEndWpNum, strEndWsNum
    ));
    prgLineList.push(spf(langResr.inst_sttch_end,
      STTCHWLD_VERSION, strUsePrv, posNumList[posNumList.length - 2], posNumList[posNumList.length - 1], appParam.teachMethod, appParam.totLen.toFixed(3), appParam.numWld, appParam.lenWld.toFixed(3), appParam.wldPtch.toFixed(3), appParam.wldSpac.toFixed(3),
      appParam.aprSpdVal.toFixed(1), appParam.aprSpdUni, appParam.aprHght.toString(), strStWpNum, strStWsNum, strEndWpNum, strEndWsNum
    ));

    return prgLineList;
  }

  editorAPI.funcs.setDropCallBack('-inst_arc_stitch_start', icnDroptCallBack);
}());