var vpcArray = {
	scheduleNo: "",
	delNoticeRunFlg: false,
};
// var ALMDLG_SYST382 = {ID: 15, CODE: 17};
var ALMDLG_SYST382 = {ID: 24, CODE: 382};
top.setAlmDlg(ALMDLG_SYST382.ID, ALMDLG_SYST382.CODE, "/frh/inst/varpayloadcomp/almpop.stm");
(function() {
	/*
	=========================================================================
	@function name     : delCallBack
	@argument[lineNum] : Program Line Number
	@argument[arg]     : Program Argument
	@description       : Event when deleting an instruction
	@return            : none
	=========================================================================
	*/
	function delCallBack(lineNum, arg) {
		var timer_adinst = null;
		/* If there are multiple delete notice callback processes, wait for completion*/
		if (vpcArray.delNoticeRunFlg == true) {
			timer_adinst = setTimeout(function () {
				delCallBack(lineNum, arg);
			}, 100);
		}
		else {
			clearTimeout(timer_adinst);
			timer_adinst = null;
			var splitArg = arg[0].split(",");
			for(var i = 0; i < splitArg.length; i++) {
				splitArg[i] =  Number(splitArg[i].replace(/[^0-9]/g, ''));
			}
			/*If there are multiple notifications, a flag to wait for the next process */
			vpcArray.delNoticeRunFlg = true;
			/*Pop-up is not displayed when there is no free number*/
			if(splitArg[0] == "0") {
				initializeFlg();
				return
			}
			vpcArray.scheduleNo = splitArg[0];
			deletePopUp();
		}
	}
	/*
	=========================================================================
	@function name : deletePopUp
	@argument      : none
	@description   : 
	@return        : none
	=========================================================================
	*/
	function deletePopUp() {
		var id = "sampleId";
		var message = "[Numero scheda"+vpcArray.scheduleNo+"]"+"<br>"+"<span style='font-size: 20px;'>"+"Si desidera eliminare i dati di compensazione?"+"Se la stessa scheda  configurata altrove, i dati comuni verranno eliminati."+"Se si effettua una nuova registrazione con lo stesso indice, i nuovi dati di correzione verranno utilizzati anche nelle altre registrazioni corrispondenti all'indice selezionato."+"</span>";
		var customizeObj = {};
		customizeObj.selectBtn = {
			1 : {label: "OK"},
			2 : {label: "Cancel"},
		};
		customizeObj.popupFrmAddClass = "varPayloadPopup";
		customizeObj.isHTML  = true;
		top.IHMIComponents.cf.confirmMessage("ihmieditor" , message, id, undefined, null, top, deletePopUpCallback, null, customizeObj);
	}
	// confirm OK/Cansel callback
	function deletePopUpCallback(id, operation) {
		switch(id) {
		case 'btn1':
			var status = "complete";
			var cbArgs = {};
			editorSetScheduleData(vpcArray.scheduleNo, null, cbArgs);
			//It is not necessary to clear the argument of the TP program because it is deleted.
			break;
		case 'btn2':
			initializeFlg();
			break;
		default:
			initializeFlg();
			break;
		}
	}
	editorAPI.funcs.setDeleteCallBack("-INST_FCMPSTRT", delCallBack);
	/*
	=========================================================================
	@function name : setScheduleData
	@argument      : ScheduleNo, callback, arg
	@description   : global -> XML ->postdata
	@return        : none
	=========================================================================
	*/
	function editorSetScheduleData(ScheduleNo, callback, arg) {
		var frameXml = "";
		var karel_name="CRDATA"+ScheduleNo;
		frameXml += '<?xml version="1.0" encoding="Shift_JIS"?>\r';
		frameXml += '<XMLVAR>\r<PROG name="'+ karel_name +'">\r';
		frameXml += '<VAR name="MODE">-2147483648</VAR>\r';//4byte Integer
		frameXml += '<VAR name="NUMREC">0</VAR>\r';//4byte Integer
		frameXml += '<VAR name="NUMAVG">0</VAR>\r';//4byte Integer
		frameXml += '</PROG>\r</XMLVAR>';

		// Create File
		var fileXvr = top.irprogapi.inner.createBlob(frameXml);
		var cbArgs = {};
		cbArgs.cbFunc = callback;
		cbArgs.cbObj = arg;
		top.postXHR('ihmiSysVal.xvr', fileXvr, editorSetScheduleDataCallback, cbArgs); // io
	}
	/*
	 =========================================================================
	 @function name : editorSetScheduleDataCallback
	 @argument      : 
	 @description   : 
	 @return        : none
	 =========================================================================
	*/
	function editorSetScheduleDataCallback(status,  cbArgs) {
		initializeFlg();
	}
	/*
	 =========================================================================
	 @function name : initializeFlg
	 @argument      : 
	 @description   : 
	 @return        : none
	 =========================================================================
	*/
	function initializeFlg() {
		vpcArray.delNoticeRunFlg = false;
	}
})();


