/*
 *  This material is the joint property of FANUC America Corporation and
 *  FANUC LTD Japan, and must be returned to either FANUC America Corporation
 *  or FANUC LTD Japan immediately upon request.  This material and
 *  the information illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without the
 *  prior written consent of both FANUC America Corporation and FANUC LTD Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2017
 *           FANUC America Corporation
 *           FANUC LTD Japan
 *  +
 *  Module: util.js
 *  
 *  Description:
 *    Utility routines.
 *
 *  Author: Judy Evans
 *          FANUC America Corporation
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  18-SEP-2017 EVANSJA pr50432 - Move common javascript to util.js
 *  09-MAR-2018 GRASSCM pr50779 - Support for Execution Control
 *  17-MAY-2019 GRASSCM pr51562 - Begin moving pipe buffer format routine
 *  02-FEB-2023 LEESY   pr53750 - Scale DLGTILE size for DCS 2D VIEWS 
 *  -
*/


// from cgop.h
// CtlType
var GMCT_LABEL     =  0;
var GMCT_EDBOX     =  1;
var GMCT_TGLMP     =  2;
var GMCT_OSBTN     =  3;
var GMCT_TGBTN     =  4;
var GMCT_MULTI     =  5;
var GMCT_ATCHG     =  6;
var GMCT_MNCHG     =  7;
var GMCT_BTCHG     =  8;
var GMCT_EXECUTION =  9;
var GMCT_HELP      = 10;
var GMCT_COMBOBOX  = 11;
var MAX_CTRL_SUM   = 12;

// from grobot.h
// Constants for execution control
var MAX_TIDS_CONN = 3;
var PANE_FLAG_CLICK_EVENTS_C = 2;        // click events enabled
var PANE_FLAG_CHANGE_EVENTS_C = 4;       // change events enabled
var PANE_FLAG_FOCUS_EVENTS_C = 8;        // focus events enabled
var PANE_FLAG_IGNORE_KEYS_EVENTS_C = 16; // ifnore keys events enabled

// CGDatatype Property definition
var CGRSTYPE_FIX      = 100;
var CGRSTYPE_REG      = 101;
var CGRSTYPE_SYSVAR   = 102;
var CGRSTYPE_KARELVAR = 103;
var CGRSTYPE_DICTELE  = 104;
var CGRSTYPE_POSREG   = 105;
var CGRSTYPE_KARELPOS = 106;
var CGRSTYPE_CURPOS   = 107;
var CGRSTYPE_TFRAME   = 108;
var CGRSTYPE_JFRAME   = 109;
var CGRSTYPE_UFRAME   = 110;
var CGRSTYPE_TPPOS    = 111;
var CGRSTYPE_STRREG   = 112;

var CGRSTYPE_DI      = 1;
var CGRSTYPE_DO      = 2;
var CGRSTYPE_AI      = 3;
var CGRSTYPE_AO      = 4;
var CGRSTYPE_PI      = 6;
var CGRSTYPE_PO      = 7;
var CGRSTYPE_RI      = 8;
var CGRSTYPE_RO      = 9;
var CGRSTYPE_SI      = 11;
var CGRSTYPE_SO      = 12;
var CGRSTYPE_TPIN    = 14;
var CGRSTYPE_TPOUT   = 15;
var CGRSTYPE_WI      = 16;
var CGRSTYPE_WO      = 17;
var CGRSTYPE_GI      = 18;
var CGRSTYPE_GO      = 19;
var CGRSTYPE_UI      = 20;
var CGRSTYPE_UO      = 21;
var CGRSTYPE_LDI     = 22;
var CGRSTYPE_LDO     = 23;
var CGRSTYPE_LAI     = 24;
var CGRSTYPE_LAO     = 25;
var CGRSTYPE_WSI     = 26;
var CGRSTYPE_WSO     = 27;
var CGRSTYPE_MIB     = 28;
var CGRSTYPE_MIN     = 29;
var CGRSTYPE_FLAG    = 35;
var CGRSTYPE_MARKER  = 36;

var VALUEMIN_C             = -3.402823564E+38;
var VALUEMAX_C             = 3.402823564E+38;

// from wave.h
var kWave_ColorWhite = "#FFFFFF";
var kWave_ColorLightGray = "#C0C0C0";
var kWave_ColorGray = "#808080";

// Private functions (same as avutil.c)

// Returns the relative URL.
function avutil_getRelativeURL(urlstr, data) {

  if (urlstr.indexOf("http:") >= 0) {
    // Use URL string as is
    return urlstr;
  }
  if (urlstr.charAt(0) == '/') {
    // Use URL string with 
    return window.location.protocol.replace(/\:/g,'')  + '://' + window.location.host + urlstr;
  }
  var off = window.location.href.lastIndexOf("/");
  return window.location.href.substr(0, off+1) + urlstr;

} // avutil_getRelativeURL

// Takes the MS decimal color in zsx_color and reverses it (BGR -> RGB).
function translateColor(colorStr) {
    var colorNum = Number(colorStr);
    var colorHexStr = (0x1000000 + colorNum).toString(16).slice(1);
    return '#' + colorHexStr.substr(4, 2) + colorHexStr.substr(2, 2) + colorHexStr.substr(0, 2);

} // translateColor

// Set the background and foreground color.
function SetColors(data) {

  data.$this.css("background-color", data.BackColor);
  data.$this.css("color", data.ForeColor);

} // SetColors

// Set the font.
function SetFont(data) {

  if (undefined == data.TrueFont) {
    data.TrueFont = "1";
  }
  if (undefined == data.FontSize) {
    data.FontSize = "14";
  }
  if ((undefined == data.FontName) || (data.FontName == "")) {
    // Default font name is localized
    data.FontName = top.getDefFont();
  }
  data.$this.css("font-family", data.FontName);

  if ((data.TrueFont == "") || (data.TrueFont == "0")) {
    // Map "NetFront" pt size to TrueFont pt size
    var fsize = parseInt(data.FontSize);
    // Turn on bold for the larger fonts
    if (fsize > 24) {
      data.FontBold = "1";
    }
    if (fsize <= 15) {
      fsize = 9;
    }
    else if (fsize <= 17) {
      fsize = 11;
    }
    else if (fsize <= 23) {
      fsize = 13;
    }
    else if (fsize <= 31) {
      fsize = 17;
    }
    else {
      fsize = 22;
    }
    data.FontSize = fsize;
  }
  data.$this.css("font-size", data.FontSize + "pt");

  if ((undefined != data.FontBold) && (data.FontBold != "") && (data.FontBold != "0")) {
    data.$this.css("font-weight", "bold");
  }
  if ((undefined != data.FontItalic) && (data.FontItalic != "") && (data.FontItalic != "0")) {
    data.$this.css("font-style", "italic");
  }

} // SetFont

// Set common parameters
function SetCommonParams(data) {
  data.myFrameName = window.name;
  data.myPageName = window.location.pathname;
  data.InvisibleColor = data.$this.css("background-color");
  data.TextColor = data.$this.css("color");
  if (undefined == top.g_echo) {
    data.IsEcho = false;
  }
  else {
    data.IsEcho = top.g_echo;
  }
  if (window.name == 'third') {
    data.fDeviceId = 2;
  }
  else if (window.name == 'dual') {
    data.fDeviceId = 1;
  }
  else {
    data.fDeviceId = 0;
  }
  data.IsDialog = false;
  if (undefined != data.dlgWidth) {
    // DLGTILE parameters take precedence
    if ((data.dlgWidth != "0") && (data.dlgHeight != "0")) {
      data.IsDialog = true;
      if (data.dlgWidth == "634") {	
        //This is the DCS 2D VIEWS dialog box
        var width = top.$("#mainfrm").width();
        var height = top.$("#mainfrm").height() - (top.$("#statbar").height() / 2);			
        data.width = width.toString();
        data.height = height.toString();
      }
      else {		  
        data.width = data.dlgWidth;
        data.height = data.dlgHeight;
      }
      if (data.dlgDeviceId != "-1") {
        data.fDeviceId = parseInt(data.dlgDeviceId);
      }
      if (data.dlgTaskIdx != "-1") {
        data.fTaskIdx = parseInt(data.dlgTaskIdx);
      }
    }
  }
} // SetCommonParams

// Pipe data format to javascript array
function FixPipe(buffer) {
  var lineData = null;
  if (buffer.length > 0) {
    // Replace single quote with double quote
    buffer = buffer.replace(/'/g, '"');

    // Remove whitespace before and after equal sign
    buffer = buffer.replace(/\s*=\s*/g, '=');

    lineData = buffer.match(/(?:[^\s"]+|"[^"]*")+/g);
  }
  return lineData;
} // FixPipe
