// Warning: treeview.js is included in all trees, not just iRProgrammer's tree */
// Any special code for iRProgrammer's tree should check that this is correct window */
var
iRProg_tree = ((top.g_irprog) && (undefined != window.parent.tree_resize));

/** make string replaced %s in fmt with arguments */
function format(fmt) {
  var i = 0;
  var args = arguments;
  return fmt.replace(/%s/g, function (word) { i++; return args[i]; });
}

/**
 * Return a function which is invoked after it stops bein called.
 * @param {Function} func Function to check the condition is met.
 * @param {Number} time Time interval.
 */
function debounce(func, time) {
  var timeoutId = null,
    context, args;
  var delayedFunc = function () {
    timeoutId = null;
    func.apply(context, args);
  };
  return function () {
    context = this;
    args = arguments;
    clearTimeout(timeoutId);
    timeoutId = setTimeout(delayedFunc, time);
  };
}

/**
 * get the amount of movement from key event.
 * @param {Event} event key event
 * @return {Number} distance
 */
function keyEventToDistance(event) {
  var dist;
  switch (event.keyCode) {
    case 9: // up and down arrow keys
      dist = event.shiftKey ? -1 : 1;
      break;
    case 33: // shift + up
      dist = -5;
      break;
    case 34: // shift + down
      dist = 5;
      break;
    case 38: // keyboard up or shift-up
      dist = event.shiftKey ? -5 : -1;
      break;
    case 40: // keyboard down or shift-down
      dist = event.shiftKey ? 5 : 1;
      break;
    default:
      dist = 0;
      break;
  }
  return dist;
}

/**
 * attachEvent is supported in IE only
 * addEventHandler is supported in compliant browsers
 */
function addEventHandler(target, event, handler) {
  if (target.attachEvent) {
    target.attachEvent('on' + event, handler);
  }
  else {
    target.addEventListener(event, handler);
  }
}

/**
 *  defaultView is supported in compiant browsers
 *  parentWindow is supported in IE only
 */
function getDefaultView(doc) {
  if (doc.parentWindow === undefined) {
    /** defaultView is supported in compliant browsers */
    return doc.defaultView;
  }
  else {
    /** parentWindow is supported in IE only*/
    return doc.parentWindow;
  }
}

function removeLastUndefined(array) {
  if (array[array.length - 1] === undefined) {
    array.pop();
  }
}

/**
 * Calculate disatance between specified element top and window top.
 * @param {HTMLElement} elem DOM object.
 */
function cumulativeOffsetTop(elem) {
  var offset = 0;
  do {
    offset += elem.offsetTop;
    elem = elem.offsetParent;
  } while (elem);
  return offset;
}

/**
 * Scroll an area object to make a target object visible.
 * @param {HTMLElement} area DOM object containing one element that defines scroll area.
 * @param {HTMLElement} target DOM object containing one element to which area is scrolled.
 * @param {Number} [offset=0] Offset value used when positions of scrollable object and visible area object does not match.
 */
function scrollTo(area, target, offset) {
  if (offset === undefined) offset = 0;

  var areaTop = area.scrollTop + offset,
    areaHeight = area.offsetHeight - offset,
    targetTop, targetHeight;
  if (target == null) {
    targetTop = 0 - cumulativeOffsetTop(area);
    targetHeight = 0;
  }
  else {
    targetTop = cumulativeOffsetTop(target) - cumulativeOffsetTop(area);
    targetHeight = target.offsetHeight;
  }

  if (areaTop > targetTop) {
    area.scrollTop = targetTop - offset;
  }
  else if (areaTop + areaHeight < targetTop + targetHeight) {
    area.scrollTop = targetTop + targetHeight - areaHeight - offset;
  }
}

/**
 * Find first descendant tagName and className of which meet specified value under the specified element.
 * @param {HTMLElement} elem Parent element. Under this element descendant is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findDescendant(elem, tagName, className) {
  var candidates = elem.getElementsByTagName(tagName.toUpperCase());
  className = ' ' + className + ' ';
  for (var i = 0, len = candidates.length; i < len; i++) {
    if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
      return candidates[i];
    }
  }
  return null;
}

/**
 * Find all descendants tagName and className of which meet specified value under the specified element.
 * @param {HTMLElement} elem Parent element. Under this element descendant is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findDescendants(root, tagName, className) {
  var candidates = root.getElementsByTagName(tagName.toUpperCase());
  var selected = [];
  className = ' ' + className + ' ';
  for (var i = 0, len = candidates.length; i < len; i++) {
    if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
      selected.push(candidates[i]);
    }
  }
  return selected;
}


/**
 * Find first ancester tagName and className of which meet specified value.
 * @param {HTMLElement} elem Child element. From this elements ancester is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findAncestor(elem, tagName, className) {
  var top = elem.ownerDocument;
  tagName = tagName.toUpperCase();
  className = ' ' + className + ' ';
  for (var candidate = elem; candidate !== top; candidate = candidate.parentNode) {
    if (candidate.tagName === tagName && (' ' + candidate.className + ' ').indexOf(className) >= 0) {
      return candidate;
    }
  }
  return null;
}

/**
 * Find last ancester tagName and className of which meet specified value.
 * @param {HTMLElement} elem Child element. From this elements ancester is searched.
 * @param {String} tagName tag name of required elements.
 * @param {String} className class name to be included in that of the required elements.
 */
function findLastAncestor(elem, tagName, className) {
  var lastAncestor = null,
    ancestor = elem;
  while (ancestor !== null) {
    ancestor = findAncestor(ancestor.parentNode, tagName, className);
    if (ancestor !== null) {
      lastAncestor = ancestor;
    }
  }
  return lastAncestor;
}

/**
 * Add the new class name to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} className class name to be added to the element.
 */
function addClass(elem, className) {
  var oldClass = elem.className,
    newClass;
  if (!hasClass(elem, className)) {
    newClass = oldClass + ' ' + className;
    newClass = newClass.replace(/^\s+/, '')
      .replace(/\s+$/, '');
    if (oldClass !== newClass) {
      elem.className = newClass;
    }
  }
}

/**
 * Remove the class name from the specified element.
 * @param {HTMLElement} elem element from which the class name is removed.
 * @param {String} className class name to be removed from the element.
 */
function removeClass(elem, className) {
  var oldClass = elem.className,
    newClass;
  newClass = (' ' + oldClass + ' ').replace(' ' + className + ' ', ' ')
    .replace(/^\s+/, '')
    .replace(/\s+$/, '');
  if (oldClass !== newClass) {
    elem.className = newClass;
  }
}

/**
 * Add new class names to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} classNames class name to be added to the element.
 */
function addClasses(elem, classNames) {
  var oldClass = elem.className,
    dummyElement = { className: oldClass },
    classes;
  classNames = classNames.replace(/^\s+/, '')
    .replace(/\s+$/, '');
  classes = classNames.split(/\s+/);
  for (var i = 0, len = classes.length; i < len; i++) {
    addClass(dummyElement, classes[i]);
  }
  if (dummyElement.className !== oldClass) {
    elem.className = dummyElement.className;
  }
}

/**
 * Remove new class names to the specified element.
 * @param {HTMLElement} elem element to which new class name is removeed.
 * @param {String} classNames class name to be removeed to the element.
 */
function removeClasses(elem, classNames) {
  var oldClass = elem.className,
    dummyElement = { className: oldClass },
    classes;
  classNames = classNames.replace(/^\s+/, '')
    .replace(/\s+$/, '');
  classes = classNames.split(/\s+/);
  for (var i = 0, len = classes.length; i < len; i++) {
    removeClass(dummyElement, classes[i]);
  }
  if (dummyElement.className !== oldClass) {
    elem.className = dummyElement.className;
  }
}

/**
 * Replace the class name of the specified element.
 * @param {HTMLElement} elem element from which the class name is removed.
 * @param {String} oldClass class name to be removed from the element.
 * @param {String} newClass class name to be added from the element.
 */
function replaceClass(elem, oldClass, newClass) {
  var oldClasses = elem.className,
    newClasses;
  newClasses = (' ' + oldClasses + ' ').replace(' ' + oldClass + ' ', ' ' + newClass + ' ')
    .replace(/^\s+/, '')
    .replace(/\s+$/, '');
  if (oldClasses !== newClasses) {
    elem.className = newClasses;
  }
}

/**
 * Check if the specified element has the class name.
 * @param {HTMLElement} elem element to be checed.
 * @param {String} className class name.
 * @return {Boolean} return true if the element has the class name.
 */
function hasClass(elem, className) {
  return ((' ' + elem.className + ' ').indexOf(' ' + className + ' ') >= 0) ? true : false;
}

/**
 * Add or remove the class name to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} className class name to be added to the element.
 * @param {Boolean} on if true the class name is added, otherwise removed.
 */
function turnOnOffClass(elem, className, on) {
  if (on) {
    addClass(elem, className);
  }
  else {
    removeClass(elem, className);
  }
}

/**
 * Add or remove the class name to the specified element.
 * @param {HTMLElement} elem element to which new class name is added.
 * @param {String} classNames class name to be added to the element.
 * @param {Boolean} on if true the class name is added, otherwise removed.
 */
function turnOnOffClasses(elem, classNames, on) {
  if (on) {
    addClasses(elem, classNames);
  }
  else {
    removeClasses(elem, classNames);
  }
}

/**
 * Add the class name to the specified element and remove the class name from the other descendants.
 * @param {HTMLElement} root root element from which descendants are found.
 * @param {HTMLElement} elem element to be added the class name.
 * @param {String} className class name.
 */
var nextNodeElem = ""; // It is used to not update the menu by screen transition other than prim.
function addClassExclusively(root, elem, className) {
  nextNodeElem = "";
  var tagName = elem.tagName,
    candidates = findDescendants(root, tagName, className);
  if (top.treemod.primScreenId != null) { // Except when loading
    var selStat = top.getMyFrameId();
    if (selStat != "prim") {
      nextNodeElem = elem.parentElement;
      return;
    }
  }
  for (var i = 0, len = candidates.length; i < len; i++) {
    removeClass(candidates[i], className);
  }
  if(iRProg_tree){
    var newSelectNode = findSelectNode(root, elem);
    for (var i = 0, len = newSelectNode.length; i < len; i++) {
      addClass(newSelectNode[i], className);
    }
  } else {
    addClass(elem, className);
  }
}

/**
 * Replace the class name of the specified element and revert the class name for the other descendants.
 * @param {HTMLElement} root root element from which descendants are found.
 * @param {HTMLElement} elem element from which the class name is removed.
 * @param {String} oldClass class name to be removed from the element.
 * @param {String} newClass class name to be added from the element.
 */
function replaceClassExclusively(root, elem, oldClass, newClass) {
  var tagName = elem.tagName,
    candidates = findDescendants(root, tagName, newClass);
  for (var i = 0, len = candidates.length; i < len; i++) {
    replaceClass(candidates[i], newClass, oldClass);
  }
  replaceClass(elem, oldClass, newClass);
}

/** Handle key event */
var KeyEvent = {
  handlers: [],
  addHandler: function (handler, frame, preventAfter) {
    var that = this;
    if (preventAfter) handler.preventAfter = true;
    if (frame) {
      handler.frameName = frame.webpage;
      addEventHandler(frame, "pagehide", function () {
        that.removeHandler(handler);
      });
    }
    this.handlers.push(handler);
  },
  popHandler: function () {
    this.handlers.pop();
  },
  addHandlers: function (handlers) {
    Array.prototype.push.apply(this.handlers, handlers);
  },
  removeHandlers: function (frame) {
    var oldHandlers = this.handlers,
      newHandlers = [],
      removedHandlers = [],
      frameName = frame.webpage,
      handler;
    for (var i = 0, len = oldHandlers.length; i < len; i++) {
      handler = oldHandlers[i];
      ((handler.frameName === frameName) ? removedHandlers : newHandlers).push(handler);
    }
    this.handlers = newHandlers;

    return removedHandlers;
  },
  removeHandler: function (handler) {
    var oldHandlers = this.handlers,
      newHandlers = [];
    for (var i = 0, len = oldHandlers.length; i < len; i++) {
      if (oldHandlers[i] !== handler) {
        newHandlers.push(oldHandlers[i]);
      }
    }
    this.handlers = newHandlers;
  },
  handle: function (event) {
    var handlers = KeyEvent.handlers,
      notHandled = true,
      handler;

    if (event.keyCode === 17) return notHandled;
    //    var message = [top.format("key:%s ctrl:%s shift:%s", event.keyCode, event.ctrlKey, event.shiftKey)];

    for (var i = handlers.length - 1; i >= 0 && notHandled; i--) {
      handler = handlers[i];
      notHandled = handler(event);
      //      message.push(top.format("%s: notHandled: %s", i, notHandled));
      if (handler.preventAfter) break;
    }
    //    if (window.console !== undefined) console.log(message.join("\n"));
    //    alert(message.join("\n"));
    return notHandled;
  },
  attachHandlers: function (frame) {
    addEventHandler(frame.document, "keydown", this.handle);
  }
};

var UIFComponents = {
  global: {
    isIEMobile: false
  },
  treeSelect: {
    init: function (doc, id, config) {
      var root = doc.getElementById(id),
        frame = getDefaultView(doc),
        type = this;
      config.expanded = {};
      config.handleKeys = null;
      root.config = config;
      var methods = [
        'refresh',
        'getValue',
        'getSelectedProps',
        'getSelectedNode',
        'scrollToSelected',
        'selectNode',
        'selectClosedNode',
        'openNode',
        'openNodeAncestor',
        'closeNode',
        'handleKeys'
      ];
      for (var i = 0, len = methods.length; i < len; i++) {
        root[methods[i]] = type[methods[i]];
      }
      root.delayedSelectNode = debounce(function (nextSelected) {
        root.selectNode(nextSelected);
      }, 200);
      addEventHandler(frame, "load", function () {
        KeyEvent.addHandler(function (event) { return root.handleKeys(event); }, frame, false);
      });
      addEventHandler(root, "click", type.onclick);

    },
    refresh: function (json, selected, disabled) {

      function cleanJSON(json) {
        var children = json.children,
          newChildren = [],
          child;
        for (var i = 0, len = children.length; i < len; i++) {
          child = children[i];
          if (child !== undefined) {
            newChildren.push(child);
            cleanJSON(child);
          }
        }
        json.children = newChildren;
      }

      function buildExpanded(expanded, json) {
        function buildExpandedRecurse(oldExpanded, json, newExpanded) {
          var data = json.data,
            children = json.children,
            value = data.value || "",
            added = false;
          for (var i = 0, len = children.length; i < len; i++) {
            added |= buildExpandedRecurse(oldExpanded, children[i], newExpanded);
          }
          if (oldExpanded[value] === undefined) added = true;
          newExpanded[value] = added ? true : oldExpanded[value];

          return added;
        }
        var newExpanded = [];
        buildExpandedRecurse(expanded, json, newExpanded);
        return newExpanded;
      }

      var selectUrl = selected.replace(/\^/g, '&');
      function nodeHTML(json, selected, expanded, last) {
        var data = json.data,
          children = json.children,
          numChildren = children.length,
          liClass = data.className || "",
          value = data.value || "",
          tagArrow, tagIcon,
          attr, type, html;

        if (!(/\b(tree-select-leaf|tree-select-open|tree-select-closed)\b/).test(liClass)) {
          liClass += (numChildren === 0) ? ' tree-select-leaf'
            : (expanded[value]) ? ' tree-select-open'
              : ' tree-select-closed';
        }

        attr = (typeof data.attr === 'string' && data.attr !== "") ? (' attr="' + data.attr + '"') : "";
        tagArrow = (numChildren === 0) ? '' : '<ins class="tree-select-arrow"></ins>';
        tagIcon = data.icon ? format('<ins style="background-image: url(%s);" class="tree-select-icon"></ins>', data.icon) : '';

        if (last) liClass += ' tree-select-last';
        if (!data.className) data.className = "";
        if (value === selectUrl && numChildren === 0) data.className += ' tree-select-selected';
        var nodeText = data.text;
        if(iRProg_tree) nodeText = '<span class="section-name">' + nodeText + '</span>';
        html = [
          '<li class="',
          liClass,
          '" id="',
          value,
          '"',
          attr,
          '><a class="tree-select-node ',
          data.className,
          '" href="javascript:void(0);" tabindex="-1">',
          tagArrow,
          tagIcon,
          nodeText,
          '</a>'
        ];
        if (numChildren > 0) {
          html.push('<ul>');
          for (var i = 0; i < numChildren; i++) {
            html.push(nodeHTML(children[i], selected, expanded, (i == numChildren - 1) ? true : false));
          }
          html.push('</ul>');
        }
        html.push('</li>');
        return html.join('');
      }

      var root = this,
        htmls = [];
      if (json.length === 0) {
        root.config.expanded = [];
      }
      else {
        removeLastUndefined(json);
        for (var i = 0, len = json.length; i < len; i++) {
          cleanJSON(json[i]);
          root.config.expanded = buildExpanded(root.config.expanded, json[i]);
          htmls.push([
            '<ul>',
            nodeHTML(json[i], selected, root.config.expanded, (i === len - 1)),
            '</ul>'
          ].join(''));
        }
      }
      root.innerHTML = htmls.join('');
      root.disabled = disabled;
      root.scrollToSelected();
      root.selectClosedNode(root.getSelectedNode());
    },
    selectNode: function (target) {
      if(iRProg_tree && (target === null ||
        target.className.indexOf('tree-select-disabled') >= 0)) {
        return;
      }
      var root = this,
        config = root.config,
        frame = getDefaultView(target.ownerDocument),
        props;

      addClassExclusively(root, target, 'tree-select-selected');
      root.selectClosedNode(target);
      props = root.getSelectedProps();
      if (props !== null) {
        window.setTimeout(function () {
          if (typeof config.onclick === 'function') {
            config.onclick(root, props);
          }
          else {
            //VTRNRequest(frame, { request: root.id + ".clicked", value: props.value }).send();
          }
        }, 0);
      }
    },
    selectClosedNode: function (target) {
      var root = this,
        closedNode;
      closedNode = findLastAncestor(target, 'li', 'tree-select-closed');
      if (closedNode !== null) {
        addClassExclusively(root, closedNode, 'tree-select-closed-selected');
      }
      else {
        closedNode = findDescendant(root, 'li', 'tree-select-closed-selected');
        if (closedNode !== null) {
          removeClass(closedNode, 'tree-select-closed-selected');
        }
      }
    },
    onclick: function (event) {
      var target = event.srcElement;
      if (target == undefined) {
        target = event.target;
      }
      var doc = target.ownerDocument,
        root = findAncestor(target, 'div', 'tree-select'),
        config = root.config,
        frame = getDefaultView(doc),
        tagName = target.tagName,
        className = target.className,
        li, value, props;
      if ((tagName === 'SPAN' && className === 'section-name') ||  // for iRProgrammer
          (tagName === 'INS' && className === 'tree-select-arrow tree-highlight-arrow') ||  // for iRProgrammer
          (tagName === 'INS' && (className === 'tree-select-icon' || className === 'tree-select-arrow'))) {
        target = target.parentNode;
        tagName = target.tagName;
        className = target.className;
      }
      if (tagName === 'A') {
        li = target.parentNode;
        if (hasClass(li, 'tree-select-leaf')) {
          // JAE pr50891 - Reselect node to support multiple panes
          //if (!hasClass(target, 'tree-select-selected')) {
          if (iRProg_tree && top.isExistCB()) {
            try {
              top.screenTrans[top.getMyFrameId()].transProc = root.selectNode; //Processing after the instruction from the prim.
              top.screenTrans[top.getMyFrameId()].arg = target.parentElement.id;
              top.screenTrans[top.getMyFrameId()].cb(target.parentElement.id);
            } catch (e) {
              top.screenTrans[top.getMyFrameId()].cb = undefined;
              root.selectNode(target);
              console.log(e);
            }
          } else {
            root.selectNode(target);
          }
          //}
          if (iRProg_tree) {
            // FSI 20181003 Hide tree
            if (!($('#treebtn', parent.document).css('display') == 'none')) {
              top.document.activeElement.blur();
            }
          }
        }
        else if (hasClass(li, 'tree-select-open')) {
          root.closeNode(li);
          if (iRProg_tree) {
            // FSI 20181003 Resize tree and Change open arrow to close arrow
            // FSI 20181004 Call the function that focuses the tree button
            if (!($('#treebtn', parent.document).css('display') == 'none')) {
              window.parent.tree_resize();
              // top.colorchange_closearrow();
              top.treebtn.focus_treemod();
            }
          }
        }
        else if (hasClass(li, 'tree-select-closed')) {
          root.openNode(li);
          if (iRProg_tree) {
            // FSI 20181003 Resize tree and Change close arrow to open arrow
            // FSI 20181004 Call the function that focuses the tree button
            if (!($('#treebtn', parent.document).css('display') == 'none')) {
              window.parent.tree_resize();
              // top.colorchange_openarrow();
              top.treebtn.focus_treemod();
            }
          }
        }
        event.returnValue = false; // prevent default action
      }
      //if (iRProg_tree) {
        // FSI 20181003 Change touch flag
        // top.change_touchflg();
      //}
      return false;
    },
    getSelectedNode: function () {
      var root = this;
      return findDescendant(root, 'a', 'tree-select-selected');
    },
    getSelectedProps: function () {
      var node;
      if (nextNodeElem != "") { // For dual and third
        node = nextNodeElem;
      } else { // For prim
        var root = this,
        selected = root.getSelectedNode();
        if (selected === null) return null;
        node = selected.parentNode;
      }
      return {
        value: node.id,
        attr: node.attr
      };
    },

    getValue: function () {
      var root = this,
        props = root.getSelectedProps();
      return (props !== null) ? props.value : "";
    },
    openNode: function (node) {
      var root = findAncestor(node, 'div', 'tree-select'),
        frame = getDefaultView(node.ownerDocument),
        text = node.id;
      replaceClass(node, 'tree-select-closed', 'tree-select-open');
      root.selectClosedNode(root.getSelectedNode());
      root.config.expanded[text] = true;
      //VTRNRequest(frame, { request: root.id + ".open", value: text }).send();
    },
    // pr50771 iRProgrammer should remember last screen
    // Open all the parent nodes
    openNodeAncestor: function (node) {
      var root = findAncestor(node, 'div', 'tree-select'),
        frame = getDefaultView(node.ownerDocument),
        text = node.id;
      while (node !== null) {
        if (hasClass(node, 'tree-select-closed')) {
          replaceClass(node, 'tree-select-closed', 'tree-select-open');
        }
        node = node.parentNode;
      }
      root.selectClosedNode(root.getSelectedNode());
      root.config.expanded[text] = true;
    },
    closeNode: function (node) {
      var root = findAncestor(node, 'div', 'tree-select'),
        frame = getDefaultView(node.ownerDocument),
        text = node.id;
      replaceClass(node, 'tree-select-open', 'tree-select-closed');
      root.selectClosedNode(root.getSelectedNode());
      root.config.expanded[text] = false;
      //VTRNRequest(frame, { request: root.id + ".close", value: text }).send();
    },
    handleKeys: function (event) {
      var root = this,
        doc = root.ownerDocument,
        config = root.config,
        currSelected = root.getSelectedNode(),
        liSelected, currNode,
        dist = 0,
        idxSelected = -1,
        idxNext, leafNodes, openNodes, closedNode, nextSelected, numLeaves;

      if (root.offsetHeight === 0) return true;
      if (currSelected === null) return true;

      liSelected = currSelected.parentNode;

      switch (event.keyCode) {
        case 39: // right arrow, open closed node
          currNode = findLastAncestor(currSelected, 'li', 'tree-select-closed');
          if (currNode !== null) {
            root.openNode(currNode);
            return false;
          }
          break;
        case 37: // left arrow, close opened node
          currNode = findAncestor(liSelected, 'li', 'tree-select-open');
          if (currNode !== null) {
            root.closeNode(currNode);
            return false;
          }
          break;
        case 8: // backspace
          event.preventDefault();
          return false;
      }

      dist = keyEventToDistance(event);
      if (dist === 0) return true;

      leafNodes = findDescendants(root, 'li', 'tree-select-leaf');
      openNodes = [];
      numLeaves = leafNodes.length;
      for (var i = 0; i < numLeaves; i++) {
        closedNode = findAncestor(leafNodes[i], 'li', 'tree-select-closed');
        if (closedNode === null ||
          leafNodes[i] === liSelected ||
          (dist > 0 && leafNodes[i].previousSibling === null) ||
          (dist < 0 && leafNodes[i].nextSibling === null)) {
          openNodes.push(leafNodes[i]);
        }
      }
      numLeaves = openNodes.length;
      if (numLeaves === 0) return true;

      if (!UIFComponents.global.isIEMobile && event.keyCode === 9) { // tab key is ignored on PC
        return true;
      }

      if (dist > 0 && liSelected === openNodes[numLeaves - 1]) {
        idxNext = 0;
      }
      else if (dist < 0 && liSelected === openNodes[0]) {
        idxNext = numLeaves - 1;
      }
      else {
        for (i = 0; i < numLeaves; i++) {
          if (openNodes[i] === liSelected) {
            idxSelected = i;
          }
        }
        if (idxSelected < 0) return true;

        idxNext = idxSelected + dist;

        idxNext = Math.max(idxNext, 0);
        idxNext = Math.min(idxNext, numLeaves - 1);
      }
      nextSelected = openNodes[idxNext].firstChild;
      addClassExclusively(root, nextSelected, 'tree-select-selected');
      root.delayedSelectNode(nextSelected);
      root.scrollToSelected();
      return false;
    },
    scrollToSelected: function () {
      var root = this,
        config = root.config,
        selected = root.getSelectedNode();
      if (selected === null) return;
      scrollTo(root.parentNode, selected, 0);
    }
  }
};

if (iRProg_tree) {
  // Hide tree menu
  $(function () {
    top.treemod.onblur = function (e) {

      setTimeout(function () {
        var actvId = top.document.activeElement.id;
        if (!($('#treebtn', parent.document).css('display') == 'none') && !(actvId == 'treebtn') && !(actvId == 'treemod')) {
          top.treebtn.hide_treemenu();
        }
      }, 300);

    };
  });

  // Hide tree menu for iPad
  $(document).on('click', function (e) {
    if (($(e.target).closest('.tree-select-node').length) &&
        (!$(e.target).closest('.tree-select-closed').length)) {
      setTimeout(function () {
        var actvId = top.document.activeElement.id;
        if (!($('#treebtn', parent.document).css('display') == 'none') && !(actvId == 'treebtn')) {
          top.treebtn.hide_treemenu();
        }
      }, 200);
    }
  });
}  // only if iRProg_tree
