// Constants
var JOG_COORD = "$JCR_GRP[1].$JOG_COORD";
var SHIFTKEY = "R-shift";
var B_COLOR_OFF = "#67727E";
var B_COLOR_ON = "#036EB7";
var OVR = {
  SLOW: 0,
  MEDIUM: 1,
  FAST: 2,
  FINGER: 3,
  UNSELECTED: 4 };

var MODE_ID = "f4_1";
var SLOW_VALUE = 3;
var MEDIUM_VALUE = 50;
var FAST_VALUE = 100;

var DEFALT_FRAME_WIDTH = 1028; //document.body.clientWidth; (IE default size)
var DEFALT_FRAME_HEIGHT = 552; //document.body.clientHieght; (IE default size)

var IMAGE_CHILDREN_NUM = 4;
var SINGLE = 1;
var MAX_GROUP = 8;

// Vars
var TPEnable = false;     // true if TP is enabled
var waitReset = false;     // wait until reset is over
// see ovr enum
var currOvr = OVR.UNSELECTED;  // eslint-disable-line no-unused-vars
var groupNumber = 1;
var numOfGroup = 1;

/* change group button start */
var systemValueNumRobAxs = new Array(MAX_GROUP);
var systemValueNumAxes = new Array(MAX_GROUP);
/* change group button end */

var JOGMODE = {
  J123: 0,
  J456: 1,
  LRIOUD: 2,
  XYZ_Rotate: 3,
  EX123: 4,
  HARDKEY: 5 };

var MODE4D = {
  PAN: 2,
  ROTATE: 3,
  ZOOM: 4,
  X_Y: 5,
  Y_Z: 6,
  X_Z: 7 };

// Keys used to toggle between rotational and directional modes
var posXkey;
var negXkey;
var posYkey;
var negYkey;

// Y variables
var yNegOn = false; // Negative direction key on or off
var yPosOn = false; // Positive direction key on or off

// X variables
var xNegOn = 0;     // Negative direction key on or off (-J1)
var xPosOn = 0;     // Positive direction key on or off  (+J1)

var ovrSlowElem;
var ovrMediumElem;
var ovrFastElem;
var changeGroupElem;
var yAreaElem;
var xTopElem;
var xMiddleElem;
var xBottomElem;
var jog4dElem;
var op4dElem;
var ctrlAreaElem;
var hardkeyElem;
var curposWorldElem;
var curposJointElem;

var yCircle1Elem;
//var yUp1Elem;
//var yDown1Elem;

var yCircle2Elem;
//var yUp2Elem;
//var yDown2Elem;

var xCircle1Elem;
//var xPos1Elem;
//var xNeg1Elem;

var xCircle2Elem;
//var xPos2Elem;
//var xNeg2Elem;

var xCircle3Elem;
//var xPos3Elem;
//var xNeg3Elem;

var curState = {
  touch: false,
  move: false,
  targetId: "", };

var IMAGE_NUM = {
  OFF: 0,
  ON: 1,
  UP: 2,
  DOWN: 3,
  POS: 2,
  NEG: 3, };


var curElem;
/*
var timer;
var timerOn = false;
*/

function unloadFunc(){
  // Stop PMON monitors for var
  top.rpcmc_stopVarMonitor(SYSNAME_C, JOG_COORD);

  // Stop PMON monitor for the I/O port.
  top.rpcmc_stopIOMonitor(tpin_type_c, tp_enbl_c);

  // Detach handler for IOBooleanEvent.
  top.jQuery.iolis.unbind("IOBooleanEvent", TPEnableEvent);

  $('#watchAlarm').unbind('led'); // unbind LED On/Off
}

function onloadFunc(){ // eslint-disable-line no-unused-vars
  ovrSlowElem = document.getElementById("over_slow");
  ovrMediumElem = document.getElementById("over_medium");
  ovrFastElem = document.getElementById("over_fast");
  changeGroupElem = document.getElementById("change_group").firstElementChild;
  yAreaElem = document.getElementById("y_view_area");
  xTopElem = document.getElementById("x_view_top");
  xMiddleElem = document.getElementById("x_view_middle");
  xBottomElem = document.getElementById("x_view_bottom");
  op4dElem = document.getElementById("op4d");
  ctrlAreaElem = document.getElementById("control_area");
  hardkeyElem = document.getElementById("hardkey_area");
  jog4dElem = document.getElementById("jog4d");
  if (disp_flg == false) {
    curposWorldElem = document.getElementById("curpos_world");
    curposJointElem = document.getElementById("curpos_joint");
  }

  yCircle1Elem = document.getElementById("move_on_y1_circle");
  //yUp1Elem = document.getElementById("move_on_y1_up");
  //yDown1Elem = document.getElementById("move_on_y1_down");

  yCircle2Elem = document.getElementById("move_on_y2_circle");
  //yUp2Elem = document.getElementById("move_on_y2_up");
  //yDown2Elem = document.getElementById("move_on_y2_down");

  xCircle1Elem = document.getElementById("move_on_x1_circle");
  //xPos1Elem = document.getElementById("move_on_x1_pos");
  //xNeg1Elem = document.getElementById("move_on_x1_neg");

  xCircle2Elem = document.getElementById("move_on_x2_circle");
  //xPos2Elem = document.getElementById("move_on_x2_pos");
  //xNeg2Elem = document.getElementById("move_on_x2_neg");

  xCircle3Elem = document.getElementById("move_on_x3_circle");
  //xPos3Elem = document.getElementById("move_on_x3_pos");
  //xNeg3Elem = document.getElementById("move_on_x3_neg");

  ovrSlowElem.style.backgroundColor = B_COLOR_OFF;
  ovrMediumElem.style.backgroundColor = B_COLOR_OFF;
  ovrFastElem.style.backgroundColor = B_COLOR_OFF;

  addEventHandler(document, "touchcancel", workEnd);
  addEventHandler(document, "touchstart", doubleTouchFunc);
  addEventHandler(document.body, "mouseleave", workEnd);

  addEventHandler(window, "pagehide", unloadFunc);
  addEventHandler(ovrSlowElem, "click", ovrSlowClick);
  addEventHandler(ovrMediumElem, "click", ovrMediumClick);
  addEventHandler(ovrFastElem, "click", ovrFastClick);

  addEventHandler(changeGroupElem, "click", changeGroupClick);

  addEventHandler(document, "touchend", workEnd);
  addEventHandler(document, "mouseup", workEnd);

  addEventHandler(yCircle1Elem, "touchstart", circleDownFunc);
  addEventHandler(yCircle1Elem, "mousedown", circleDownFunc);
  addEventHandler(yCircle2Elem, "touchstart", circleDownFunc);
  addEventHandler(yCircle2Elem, "mousedown", circleDownFunc);
  addEventHandler(xCircle1Elem, "touchstart", circleDownFunc);
  addEventHandler(xCircle1Elem, "mousedown", circleDownFunc);
  addEventHandler(xCircle2Elem, "touchstart", circleDownFunc);
  addEventHandler(xCircle2Elem, "mousedown", circleDownFunc);
  addEventHandler(xCircle3Elem, "touchstart", circleDownFunc);
  addEventHandler(xCircle3Elem, "mousedown", circleDownFunc);

  addEventHandler(document, "touchmove", watchArea);
  addEventHandler(document, "mousemove", watchArea);
  $('#watchAlarm').bind('led', {ledindex:1, ledtext:'Fault', ledoff:'lime', ledon:'red'}, ledFunc);

  getSystemValueNumAxes();

  if (top.initial == undefined) {
    top.initial = true;
    top.g_currJogMode = JOGMODE.LRIOUD;

    if (numOfGroup <= 1) {
      document.getElementById("change_group").style.display = "none";
    }
  } else if (top.initial == true) {
    changeTabs();
    UpdateAppearance();
  }

  change4dMode(MODE4D.PAN);

  // Check JITP was used
  if (top.sendKey == undefined) {
    alert("Please use HMI Remote iPendant -> Jogging iPendant (JITP) to log in to robot");
    document.location.href = "/";
    return;
  }

//  updateWindow(); //font size Change by Window Size

  UpdateJogMode();

  // Start PMON monitors for $JCR_GRP[1].$JOG_COORD
  top.rpcmc_startVarMonitor(SYSNAME_C, JOG_COORD, 250);

  // Attach handler for IOBooleanEvent.
  top.jQuery.iolis.bind("IOBooleanEvent", null, TPEnableEvent);

  // Start PMON monitor for the I/O port.
  top.rpcmc_startIOMonitor(tpin_type_c, tp_enbl_c);

  //Set default override button
  defaultOvrBtn();
}


function callBackNumRobAxs(prgName, varName, typeCode, valStr, arg1, arg2) {// eslint-disable-line no-unused-vars
  systemValueNumRobAxs[arg1.grp-1] = parseInt(valStr, 10);
}

function callBackNumAxes(prgName, varName, typeCode, valStr, arg1, arg2) {// eslint-disable-line no-unused-vars
  systemValueNumAxes[arg1.grp-1] = parseInt(valStr, 10);
}

function getSystemValueNumAxes() {
  var callParamNumRobAxs;
  var callParamNumAxes;
  var numRobAxs;
  var numAxes;

  var groupNumberIndex = 1;

  while (groupNumberIndex <= numOfGroup) {
    callParamNumRobAxs = {};
    callParamNumAxes = {};

    numRobAxs = "$SCR_GRP[" + groupNumberIndex + "].$NUM_ROB_AXS";
    numAxes = "$SCR_GRP[" + groupNumberIndex + "].$NUM_AXES";

    callParamNumRobAxs.grp = groupNumberIndex;
    top.rpcmc_getVar(SYSNAME_C, numRobAxs, callBackNumRobAxs, callParamNumRobAxs);

    callParamNumAxes.grp = groupNumberIndex;
    top.rpcmc_getVar(SYSNAME_C, numAxes, callBackNumAxes, callParamNumAxes);
    groupNumberIndex ++;
  }
}

/*
function continuationSend(){
  if (curElem.parentNode.id == curState.targetId) {
    if ((curElem.id.indexOf("move_on") > -1) && (curElem.id.indexOf("circle") == -1)) {
      sendPosNegKeys(curElem.id);
      return;
    }
  }
  areLeaveFunc();
}
*/

function ledFunc(event, io_type, io_index, io_value){
  if ((io_type == tpout_type_c) && (io_index == 1)) {
    if (io_value == 1) {
      $(".tpreset").addClass("tpreset_led");
    } else {
      if ($(".tpreset").hasClass("tpreset_led")) {
        $(".tpreset").removeClass("tpreset_led");
      }
    }
  }
}

function doubleTouchFunc(event){
  if (event.touches.length == SINGLE) {
    return;
  } else {
    if (top.g_currJogMode == JOGMODE.LRIOUD) {
      changeImage("y_view_inout", IMAGE_NUM.OFF);
      changeImage("y_view_updown", IMAGE_NUM.OFF);
      changeImage("x_view_top", IMAGE_NUM.OFF);
    } else {
      changeImage("x_view_top", IMAGE_NUM.OFF);
      changeImage("x_view_middle", IMAGE_NUM.OFF);
      changeImage("x_view_bottom", IMAGE_NUM.OFF);
    }
  }
  workEnd();//Single Finger Touch Only
}

function watchArea(event){
  event.preventDefault();
  if (!curState.touch) {
    return false;
  }

  var e = event || window.event;
  var curX;
  var curY;

  if (event.type.indexOf("touch") == 0) {
    curX = e.touches[0].clientX;
    curY = e.touches[0].clientY;
  } else if (event.type.indexOf("mouse") == 0) {
    curX = e.clientX;
    curY = e.clientY;
  }

  curElem = document.elementFromPoint(curX, curY);

  if (curState.move) {
    if ((curElem.id.indexOf("move_on") > -1) && (curElem.id.indexOf("circle") == -1)) {
      return false;
    } else {
      areLeaveFunc();
    }
  }

  if (curElem.parentNode.id != curState.targetId) {
    return false;
  }

  sendPosNegKeys(curElem.id);

  /*
  if (!timerOn) {
    timerOn = true;
    timer = setInterval(continuationSend ,500);
  }
  */
}

function circleDownFunc(event){
  //for before IE10
  if (event.preventDefault) {
    event.preventDefault();
  } else {
    event.returnValue = false;
  }
  if (waitReset == true) {
    return;
  }
  if (enableTP(0)) {
    return;
  }

  var e = event || window.event;
  var targetId;

  // For before IE10
  if (!e.currentTarget) {
    targetId = e.srcElement.parentNode.id;
  } else {
    targetId = e.currentTarget.parentNode.id;
  }

  UpdateJogMode();

  curState.touch = true;
  curState.targetId = targetId;
  keysSet(targetId);
  areLeaveFunc();
  top.sendKey(SHIFTKEY, 1);
}

function keysSet(id){
  switch (top.g_currJogMode) {
    case JOGMODE.LRIOUD:
      if (id == "y_view_inout") {
        posYkey = "-J3";
        negYkey = "+J3";
      } else if (id == "y_view_updown") {
        posYkey = "+J2";
        negYkey = "-J2";
      }
      posXkey = "+J1";
      negXkey = "-J1";
      break;
    case JOGMODE.J123:
      if (id == "x_view_top") {
        posXkey = "+J1";
        negXkey = "-J1";
      } else if (id == "x_view_middle") {
        posXkey = "+J2";
        negXkey = "-J2";
      } else if (id == "x_view_bottom") {
        posXkey = "+J3";
        negXkey = "-J3";
      }
      break;
    case JOGMODE.J456:
      if (id == "x_view_top") {
        posXkey = "+J4";
        negXkey = "-J4";
      } else if (id == "x_view_middle") {
        posXkey = "+J5";
        negXkey = "-J5";
      } else if (id == "x_view_bottom") {
        posXkey = "+J6";
        negXkey = "-J6";
      }
      break;
    case JOGMODE.XYZ_Rotate:
      if (id == "x_view_top") {
        posXkey = "+J4";
        negXkey = "-J4";
      } else if (id == "x_view_middle") {
        posXkey = "+J5";
        negXkey = "-J5";
      } else if (id == "x_view_bottom") {
        posXkey = "+J6";
        negXkey = "-J6";
      }
      break;
    case JOGMODE.EX123:
      if (id == "x_view_top") {
        posXkey = "+J1";
        negXkey = "-J1";
      } else if (id == "x_view_middle") {
        posXkey = "+J2";
        negXkey = "-J2";
      } else if (id == "x_view_bottom") {
        posXkey = "+J3";
        negXkey = "-J3";
      }
      break;
    default:
      break;
  }
}

function sendPosNegKeys(id){
  switch (id) {
    case "move_on_y1_up":
    case "move_on_y2_up":
        if (!curState.move) {
          curState.move = true;
          yPosOn = true;
          changeImage(curState.targetId, IMAGE_NUM.UP);
        }
        top.sendKey(posYkey, 1);
      break;
    case "move_on_y1_down":
    case "move_on_y2_down":
        if (!curState.move) {
          curState.move = true;
          yNegOn = true;
          changeImage(curState.targetId, IMAGE_NUM.DOWN);
        }
        top.sendKey(negYkey, 1);
      break;
    case "move_on_x1_pos":
    case "move_on_x2_pos":
    case "move_on_x3_pos":
      if (!curState.move) {
        curState.move = true;
        xPosOn = true;
        changeImage(curState.targetId, IMAGE_NUM.POS);
      }
      top.sendKey(posXkey, 1);
      break;
    case "move_on_x1_neg":
    case "move_on_x2_neg":
    case "move_on_x3_neg":
      if (!curState.move) {
        curState.move = true;
        xNegOn = true;
        changeImage(curState.targetId, IMAGE_NUM.NEG);
      }
      top.sendKey(negXkey, 1);
      break;
    default:
      break;
  }
}

function areLeaveFunc(){
  /*
  if (timerOn) {
    timerOn = false;
    clearInterval(timer);
  }
  */
  if (curState.targetId.indexOf("y_view") > -1) {
    clearY();
  } else if (curState.targetId.indexOf("x_view") > -1) {
    clearX();
  }
  changeImage(curState.targetId, IMAGE_NUM.ON);
  return;
}

function workEnd(){
  if (curState.touch) {
    /*
    if (timerOn) {
      timerOn = false;
      clearInterval(timer);
    }
    */
    curState.touch = false;
    clearX();
    clearY();
    top.sendKey(SHIFTKEY, 0);
    changeImage(curState.targetId, IMAGE_NUM.OFF);
    curState.targetId = "";
  }
}

function ovrSlowClick(){
  top.rpcmc_setVar(SYSNAME_C, "$MCR.$GENOVERRIDE", 3);
  currOvr = OVR.SLOW;
  ovrSlowElem.style.backgroundColor = B_COLOR_ON;
  ovrMediumElem.style.backgroundColor = B_COLOR_OFF;
  ovrFastElem.style.backgroundColor = B_COLOR_OFF;
  return false;
}

function ovrMediumClick(){
  top.rpcmc_setVar(SYSNAME_C, "$MCR.$GENOVERRIDE", 50);
  currOvr = OVR.MEDIUM;
  ovrSlowElem.style.backgroundColor = B_COLOR_OFF;
  ovrMediumElem.style.backgroundColor = B_COLOR_ON;
  ovrFastElem.style.backgroundColor = B_COLOR_OFF;
  return false;
}

function ovrFastClick(){
  top.rpcmc_setVar(SYSNAME_C, "$MCR.$GENOVERRIDE", 100);
  currOvr = OVR.FAST;
  ovrSlowElem.style.backgroundColor = B_COLOR_OFF;
  ovrMediumElem.style.backgroundColor = B_COLOR_OFF;
  ovrFastElem.style.backgroundColor = B_COLOR_ON;
  return false;
}

function changeGroupClick(){

  //save groupNumber
  if (numOfGroup > 1) {

    changeGroupElem.className = 'change_group select';
    setTimeout(function(){
      changeGroupElem.className = 'change_group';
    },150);

    if (top.g_currJogMode === JOGMODE.EX123) {
      //onece
      top.sendKey("Group", 1);
      top.sendKey("Group", 0);
    }
    else {
      if (systemValueNumRobAxs[groupNumber-1] === systemValueNumAxes[groupNumber-1]) {
        //Main Group Only
        top.sendKey("Group", 1);
        top.sendKey("Group", 0);
     }
     else {
      //Main Group + Sub Group
      //twice
      top.sendKey("Group", 1);
      top.sendKey("Group", 0);

      top.sendKey("Group", 1);
      top.sendKey("Group", 0);
      }
    }
  }

  return false;
}

function changeTabs(){
  switch (top.g_currJogMode) {
    case JOGMODE.J123:
      document.getElementById("tabgrp_1_3").click();
      break;
    case JOGMODE.J456:
      document.getElementById("tabgrp_1_4").click();
      break;
    case JOGMODE.LRIOUD:
      document.getElementById("tabgrp_1_1").click();
      break;
    case JOGMODE.XYZ_Rotate:
      document.getElementById("tabgrp_1_2").click();
      break;
    case JOGMODE.EX123:
      document.getElementById("tabgrp_1_5").click();
      break;
    case JOGMODE.HARDKEY:
      document.getElementById("tabgrp_next").click();
      document.getElementById("tabgrp_2_1").click();
      break;
    default:
      break;
  }
}

function defaultOvrBtn(){
  switch (sliderValue) {
    case SLOW_VALUE:
      ovrSlowElem.click();
      break;
    case MEDIUM_VALUE:
      ovrMediumElem.click();
      break;
    case FAST_VALUE:
      ovrFastElem.click();
      break;
    default:
      break;
  }
  return false;
}

function UpdateAppearance(){

  if (numOfGroup <= 1) {
    document.getElementById("change_group").style.display = "none";
  }

  switch (top.g_currJogMode) {
    case JOGMODE.LRIOUD:
      hideHardKey();
      yAreaElem.style.display = "block";
      removeClasses(xTopElem, 'x_view_top');
      addClasses(xTopElem, 'x_view_only');
      xMiddleElem.style.display = "none";
      xBottomElem.style.display = "none";
      document.getElementById("x_image1_1").className = 'sprite-jogwidth2 sprite-gridrl_off';
      document.getElementById("x_image1_2").className = 'sprite-jogwidth1 sprite-gridrl_on';
      document.getElementById("x_image1_3").className = 'sprite-jogwidth4 sprite-gridrl_pos_on';
      document.getElementById("x_image1_4").className = 'sprite-jogwidth3 sprite-gridrl_neg_on';
      if (disp_flg == false) {
        curposWorldElem.style.display = "block";
        curposJointElem.style.display = "none";
      }
      break;
    case JOGMODE.J123:
      hideHardKey();
      showXviews();
      document.getElementById("x_image1_1").className = 'sprite-jogwidth2 sprite-j1_off';
      document.getElementById("x_image1_2").className = 'sprite-jogwidth1 sprite-j1_on';
      document.getElementById("x_image1_3").className = 'sprite-jogwidth4 sprite-j1_pos_on';
      document.getElementById("x_image1_4").className = 'sprite-jogwidth3 sprite-j1_neg_on';

      document.getElementById("x_image2_1").className = 'sprite-jogwidth2 sprite-j2_off';
      document.getElementById("x_image2_2").className = 'sprite-jogwidth1 sprite-j2_on';
      document.getElementById("x_image2_3").className = 'sprite-jogwidth4 sprite-j2_pos_on';
      document.getElementById("x_image2_4").className = 'sprite-jogwidth3 sprite-j2_neg_on';

      document.getElementById("x_image3_1").className = 'sprite-jogwidth2 sprite-j3_off';
      document.getElementById("x_image3_2").className = 'sprite-jogwidth1 sprite-j3_on';
      document.getElementById("x_image3_3").className = 'sprite-jogwidth4 sprite-j3_pos_on';
      document.getElementById("x_image3_4").className = 'sprite-jogwidth3 sprite-j3_neg_on';
      if (disp_flg == false) {
        curposWorldElem.style.display = "none";
        curposJointElem.style.display = "block";
      }
      break;
    case JOGMODE.J456:
      hideHardKey();
      showXviews();
      document.getElementById("x_image1_1").className = 'sprite-jogwidth2 sprite-j4_off';
      document.getElementById("x_image1_2").className = 'sprite-jogwidth1 sprite-j4_on';
      document.getElementById("x_image1_3").className = 'sprite-jogwidth4 sprite-j4_pos_on';
      document.getElementById("x_image1_4").className = 'sprite-jogwidth3 sprite-j4_neg_on';

      document.getElementById("x_image2_1").className = 'sprite-jogwidth2 sprite-j5_off';
      document.getElementById("x_image2_2").className = 'sprite-jogwidth1 sprite-j5_on';
      document.getElementById("x_image2_3").className = 'sprite-jogwidth4 sprite-j5_pos_on';
      document.getElementById("x_image2_4").className = 'sprite-jogwidth3 sprite-j5_neg_on';

      document.getElementById("x_image3_1").className = 'sprite-jogwidth2 sprite-j6_off';
      document.getElementById("x_image3_2").className = 'sprite-jogwidth1 sprite-j6_on';
      document.getElementById("x_image3_3").className = 'sprite-jogwidth4 sprite-j6_pos_on';
      document.getElementById("x_image3_4").className = 'sprite-jogwidth3 sprite-j6_neg_on';
      if (disp_flg == false) {
        curposWorldElem.style.display = "none";
        curposJointElem.style.display = "block";
      }
      break;
    case JOGMODE.XYZ_Rotate:
      hideHardKey();
      showXviews();
      document.getElementById("x_image1_1").className = 'sprite-jogwidth2 sprite-w_off';
      document.getElementById("x_image1_2").className = 'sprite-jogwidth1 sprite-w_on';
      document.getElementById("x_image1_3").className = 'sprite-jogwidth4 sprite-w_pos_on';
      document.getElementById("x_image1_4").className = 'sprite-jogwidth3 sprite-w_neg_on';

      document.getElementById("x_image2_1").className = 'sprite-jogwidth2 sprite-p_off';
      document.getElementById("x_image2_2").className = 'sprite-jogwidth1 sprite-p_on';
      document.getElementById("x_image2_3").className = 'sprite-jogwidth4 sprite-p_pos_on';
      document.getElementById("x_image2_4").className = 'sprite-jogwidth3 sprite-p_neg_on';

      document.getElementById("x_image3_1").className = 'sprite-jogwidth2 sprite-r_off';
      document.getElementById("x_image3_2").className = 'sprite-jogwidth1 sprite-r_on';
      document.getElementById("x_image3_3").className = 'sprite-jogwidth4 sprite-r_pos_on';
      document.getElementById("x_image3_4").className = 'sprite-jogwidth3 sprite-r_neg_on';
      if (disp_flg == false) {
        curposWorldElem.style.display = "block";
        curposJointElem.style.display = "none";
      }
      break;
    case JOGMODE.EX123:
      hideHardKey();
      showXviews();
      document.getElementById("x_image1_1").className = 'sprite-jogwidth2 sprite-ex1_off';
      document.getElementById("x_image1_2").className = 'sprite-jogwidth1 sprite-ex1_on';
      document.getElementById("x_image1_3").className = 'sprite-jogwidth4 sprite-ex1_pos_on';
      document.getElementById("x_image1_4").className = 'sprite-jogwidth3 sprite-ex1_neg_on';

      document.getElementById("x_image2_1").className = 'sprite-jogwidth2 sprite-ex2_off';
      document.getElementById("x_image2_2").className = 'sprite-jogwidth1 sprite-ex2_on';
      document.getElementById("x_image2_3").className = 'sprite-jogwidth4 sprite-ex2_pos_on';
      document.getElementById("x_image2_4").className = 'sprite-jogwidth3 sprite-ex2_neg_on';

      document.getElementById("x_image3_1").className = 'sprite-jogwidth2 sprite-ex3_off';
      document.getElementById("x_image3_2").className = 'sprite-jogwidth1 sprite-ex3_on';
      document.getElementById("x_image3_3").className = 'sprite-jogwidth4 sprite-ex3_pos_on';
      document.getElementById("x_image3_4").className = 'sprite-jogwidth3 sprite-ex3_neg_on';
      if (disp_flg == false) {
        curposWorldElem.style.display = "none";
        curposJointElem.style.display = "block";
      }
      break;
    case JOGMODE.HARDKEY:
      if (jog4dElem != null) {
        removeClasses(jog4dElem, 'view4d_style');
        addClasses(jog4dElem, 'view4d_hardkey');
        op4dElem.style.display = "block";
      }
      ctrlAreaElem.style.display = "none";
      hardkeyElem.style.display = "block";
      updateWindow();
      break;
    default:
      break;
  }
}

function hideHardKey(){
  if (jog4dElem != null){
    removeClasses(jog4dElem, 'view4d_hardkey');
    addClasses(jog4dElem, 'view4d_style');
    op4dElem.style.display = "none";
  }
  ctrlAreaElem.style.display = "block";
  hardkeyElem.style.display = "none";
}

function showXviews(){
  yAreaElem.style.display = "none";
  removeClasses(xTopElem, 'x_view_only');
  addClasses(xTopElem, 'x_view_top');
  xMiddleElem.style.display = "block";
  xBottomElem.style.display = "block";
}

function UpdateJogMode(){

  top.rpcmc_setVar(SYSNAME_C, "$JCR_GRP[" + groupNumber + "].$JOG_WRSTJNT", 0);
  var strParamJogSubGrp = "$JCR_GRP[" + groupNumber + "].$JOG_SUBGRP";
  var strParamJogCoord = "$JCR_GRP[grp].$JOG_COORD";

  switch (top.g_currJogMode) {
    case JOGMODE.LRIOUD:
      top.rpcmc_setVar(SYSNAME_C, strParamJogCoord, 1);
      top.rpcmc_setVar(SYSNAME_C, strParamJogSubGrp, 0);
      break;
    case JOGMODE.J123:
      top.rpcmc_setVar(SYSNAME_C, strParamJogCoord, 0);
      top.rpcmc_setVar(SYSNAME_C, strParamJogSubGrp, 0);
      break;
    case JOGMODE.J456:
      top.rpcmc_setVar(SYSNAME_C, strParamJogCoord, 0);
      top.rpcmc_setVar(SYSNAME_C, strParamJogSubGrp, 0);
      break;
    case JOGMODE.XYZ_Rotate:
      top.rpcmc_setVar(SYSNAME_C, strParamJogCoord, 1);
      top.rpcmc_setVar(SYSNAME_C, strParamJogSubGrp, 0);
      break;
    case JOGMODE.EX123:
      top.rpcmc_setVar(SYSNAME_C, strParamJogCoord, 0);
      top.rpcmc_setVar(SYSNAME_C, strParamJogSubGrp, 1);
      break;
    case JOGMODE.HARDKEY:
      width = input.clientWidth / 2;
      sliderMagnificationJog = slider.clientWidth / 101;
      set_value();
      top.rpcmc_setVar(SYSNAME_C, strParamJogSubGrp, 0);
      break;
    default:
      break;
  }
} // UpdateJogMode

function sendStop(isXOpe){
  if (isXOpe) {
    if (xNegOn) {
      top.sendKey(negXkey, 0);
      xNegOn = false;
      curState.move = false;
    }

    if (xPosOn) {
      top.sendKey(posXkey, 0);
      xPosOn = false;
      curState.move = false;
    }
  }
  else {
    if (yNegOn) {
      top.sendKey(negYkey, 0);
      yNegOn = false;
      curState.move = false;
    }

    if (yPosOn) {
      top.sendKey(posYkey, 0);
      yPosOn = false;
      curState.move = false;
    }
  }
} // sendStop

function clearX(){
  // Turning off keys
  sendStop(true);
} //clearX

function clearY(){
  // Turning off keys
  sendStop(false);
} // clearY

function TPEnableEvent(event, io_type, io_index, io_value){
  if ((io_type == tpin_type_c) && (io_index == tp_enbl_c)) {
    // We have a match.
    if (io_value == 0) {
      TPEnable = false;
    }
    else {
      TPEnable = true;
    }
  }
} // TPEnableEvent

function enableTP(state){
  if (!TPEnable) {
    if (state == 0) {
      // Press HOLD first to avoid jerking to a stop
      top.sendKey("Hold", 1);  // Hold happens on the press
      setTimeout(function() { enableTP(1); }, 250);
    }
    else if (state == 1) {
      // Release HOLD, enable the TP, and press RESET
      // After 1 second, release RESET
      top.sendKey("Hold", 0);
      if (typeof(top.cgtpfrm) != "undefined") {
        top.cgtpfrm.statbar.ToggleEnable();
      }
      else {
        top.statbar.ToggleEnable();
      }
      top.sendKey("Reset", 1);
      waitReset = true;
      setTimeout(sendReset, 1000);  // Reset happens on the release
    }
    return true;
  }
  return false;
} // enableTP

function disableTP(){ // eslint-disable-line no-unused-vars
  if (TPEnable) {
    if (typeof(top.cgtpfrm) != "undefined") {
      top.cgtpfrm.statbar.ToggleEnable();
    }
    else {
      top.statbar.ToggleEnable();
    }
    top.sendKey("Reset", 1);
    waitReset = true;
    setTimeout(sendReset, 1000);  // Reset happens on the release
    return true;
  }
  return false;
} // disableTP

function sendReset(){
  top.sendKey("Reset", 0);
  waitReset = false;
} // sendReset

function update_4dmode(val){
  var mode4d_zoom = document.getElementById("mode4d_zoom");
  var mode4d_pan = document.getElementById("mode4d_pan");
  var mode4d_rot = document.getElementById("mode4d_rot");
  var mode4d_xy = document.getElementById("mode4d_xy");
  var mode4d_yz = document.getElementById("mode4d_yz");
  var mode4d_xz = document.getElementById("mode4d_xz");
  switch (val) {
    case MODE4D.ZOOM:
      mode4d_zoom.className = 'rbutton4d select';
      mode4d_pan.className = 'rbutton4d';
      mode4d_rot.className = 'rbutton4d';
      mode4d_xy.className = 'rbutton4d';
      mode4d_yz.className = 'rbutton4d';
      mode4d_xz.className = 'rbutton4d';
      document.getElementById("tpglint4").className = 'button_op4d select';
      document.getElementById("tpglint3").className = 'button_op4d';
      document.getElementById("tpglint2").className = 'button_op4d';
      break;
    case MODE4D.PAN:
      mode4d_pan.className = 'rbutton4d select';
      mode4d_zoom.className = 'rbutton4d';
      mode4d_rot.className = 'rbutton4d';
      mode4d_xy.className = 'rbutton4d';
      mode4d_yz.className = 'rbutton4d';
      mode4d_xz.className = 'rbutton4d';
      document.getElementById("tpglint2").className = 'button_op4d select';
      document.getElementById("tpglint4").className = 'button_op4d';
      document.getElementById("tpglint3").className = 'button_op4d';
      break;
    case MODE4D.ROTATE:
      mode4d_rot.className = 'rbutton4d select';
      mode4d_zoom.className = 'rbutton4d';
      mode4d_pan.className = 'rbutton4d';
      mode4d_xy.className = 'rbutton4d';
      mode4d_yz.className = 'rbutton4d';
      mode4d_xz.className = 'rbutton4d';
      document.getElementById("tpglint3").className = 'button_op4d select';
      document.getElementById("tpglint4").className = 'button_op4d';
      document.getElementById("tpglint2").className = 'button_op4d';
      break;
    case MODE4D.X_Y:
      mode4d_xy.className = 'rbutton4d select';
      setTimeout(function(){
        mode4d_xy.className = 'rbutton4d';
      },150);
      break;
    case MODE4D.Y_Z:
      mode4d_yz.className = 'rbutton4d select';
      setTimeout(function(){
        mode4d_yz.className = 'rbutton4d';
      },150);
      break;
    case MODE4D.X_Z:
      mode4d_xz.className = 'rbutton4d select';
      setTimeout(function(){
        mode4d_xz.className = 'rbutton4d';
      },150);
      break;
    default:
      break;
  }
} // update_4dmode

function changeImage(id, child){
  if (id == "") {
    return false;
  }
  var elem = document.getElementById(id);
  for (var i = 0; i < IMAGE_CHILDREN_NUM; i++) {
    elem.children[i].style.display = "none";
    if (i == child) {
      elem.children[child].style.display = "block";
    }
  }
} // changeImage

function change4dMode(mode){   // (in)  mode
  if (!g_task_id) {
    return;
  }

  // Send ovr to controller
  var xmlHttp = new XMLHttpRequest();
  var sendMsg = function(){
    xmlHttp.onreadystatechange = function(){
      if (this.readyState == 4) {
        if (((200 <= this.status) && (this.status < 300)) || (this.status == 304)) {
          var json = JSON.parse(this.responseText);
          xmlHttp.abort();

          if (undefined != json.FANUC.RPC) {
            update_4dmode(mode);
            if (json.FANUC.RPC[0].status != 0) {
              top.rpcmc_rprintf("[touchjog] SET_FORM " + MODE_ID + " failed, status "
              + json.FANUC.RPC[0].status);
            }
          } else {
            top.rpcmc_rprintf("[touchjog] unexpected reply " + JSON.stringify(json));
          }
        } else {
          xmlHttp.abort();
          window.setTimeout(sendMsg, 100);
        }
      }
    };

    xmlHttp.open("GET", '/COMET/rpc?func=SET_FORM' +
                        '&task_id=' + g_task_id +
                        '&id=' + MODE_ID +
                        '&value=' + mode, true);
    xmlHttp.setRequestHeader("If-Modified-Since", "Thu, 01 Jun 1970 00:00:00 GMT");
    xmlHttp.send(null);
  };
  sendMsg();

} // change4dMode

function updateWindow(){ // eslint-disable-line no-unused-vars
  var screenWidth = DEFALT_FRAME_WIDTH;
  var screenHeight = DEFALT_FRAME_HEIGHT;

  var sW = 0;
  var sH = 0;
  var wPer = 100;
  var hPer = 100;
  var updatePer = 0;

  sW = document.body.clientWidth;
  sH = document.body.clientHeight;

  if (sW != screenWidth) {
    wPer = sW / screenWidth * 100;
  }

  if (sH != screenHeight) {
    hPer = sH / screenHeight * 100;
  }

  if (wPer > hPer) {
    updatePer = hPer;
  } else {
    updatePer = wPer;
  }

  var fontSize = updatePer + '%';
  var items = [{ className: "rbutton4d", lblClassName: "rbutton4d_text" },
               { className: "rbutton_over", lblClassName: "rbutton_over_text" },
               { className: "span_notify_label", lblClassName: null },
               { className: "button_frames", lblClassName: "label_text" }, // hard key area
               { className: "button", lblClassName: "label_text" }, // hard key area
               { className: "box", lblClassName: null }]; // hard key area

  var item;
  for (var i=0; i<items.length; i++){
    item = document.getElementsByClassName(items[i].className);
    for(var j=0; j < item.length; j++){
      item[j].style.fontSize = fontSize;
      if (items[i].lblClassName !== null) {
        adjust_button_label(item[j], fontSize, items[i].lblClassName);
      }
    }
  }
  AdjustmentNotifyLabel();
} // updateWindow

//If it does not fit on one line, reduce the font size.
function adjust_button_label(target, fontSize, lblClassName) {
  var labelElem = tj_findDescendant(target, "div", lblClassName);
  var saveLabel;
  var labelHeight;
  var labelOneCharHeight;
  var isOver = false;
  var MIN_FONT_SIZE = 20; // In Chrome, there is a limit to how small the font size can be reduced.
  var orgFontSize = parseInt(fontSize, 10);
  var adjustFontSize = orgFontSize;
  if (labelElem === null) {
    return;
  }
  labelHeight = labelElem.offsetHeight;
  if (labelHeight <= 0) {
    return;
  }
  saveLabel = labelElem.innerText;
  labelElem.innerText = saveLabel.charAt(0); // one char
  labelOneCharHeight = labelElem.offsetHeight;
  labelElem.innerText = saveLabel; //restore
  isOver = (labelOneCharHeight < labelHeight);
  while (isOver && (MIN_FONT_SIZE < adjustFontSize)) {
    adjustFontSize = adjustFontSize - 1;
    target.style.fontSize = adjustFontSize + '%';
    labelHeight = labelElem.offsetHeight;
    isOver = (labelOneCharHeight < labelHeight);
  }
}

function tj_findDescendant (elem, tagName, className) {
  var candidates = elem.getElementsByTagName(tagName.toUpperCase());
  className = ' ' + className + ' ';
  for (var i = 0, len = candidates.length; i < len; i++) {
    if ((' ' + candidates[i].className + ' ').indexOf(className) >= 0) {
      return candidates[i];
    }
  }
  return null;
}

function AdjustmentNotifyLabel(){
  var spanLabel = document.getElementById("spanNotifyLabel");
  if (spanLabel) {
    var divLabel = document.getElementById("divNotify");
    var divPad = ((divLabel.clientHeight - spanLabel.clientHeight) / 2) / divLabel.clientHeight;
    divPad = Math.floor(divPad * 100);
    spanLabel.style.top = divPad + "%";
  }
}

/* eslint-disable */
var ALLOWED = [
  /(?:^[\x09\x0A\x0C\x0D\x20]+)|(?:[\x09\x0A\x0C\x0D\x20]+$)/g, //For use in tabMenu.oncklick.
  /[\x09\x0A\x0C\x0D\x20]+/, //For use in tabMenu.oncklick.
  /(^\s+)|(\s+$)/g //For use in tabMenu.oncklick.
];
/* eslint-disable */

function addClasses(elem, classNames){
  var oldClass = elem.className;
  var dummyElement = {className: oldClass};
  var classes;
  classNames = classNames.replace(/^\s+/, '')
                         .replace(/\s+$/, '');
  classes = classNames.split(/\s+/);
  for (var i = 0, len = classes.length; i < len; i++) {
    addClass(dummyElement, classes[i]);
  }
  if (dummyElement.className !== oldClass) {
    elem.className = dummyElement.className;
  }
}

function removeClasses(elem, classNames){
  var oldClass = elem.className;
  var dummyElement = {className: oldClass};
  var classes;
  classNames = classNames.replace(/^\s+/, '')
                         .replace(/\s+$/, '');
  classes = classNames.split(/\s+/);
  for (var i = 0, len = classes.length; i < len; i++) {
    removeClass(dummyElement, classes[i]);
  }
  if (dummyElement.className !== oldClass) {
    elem.className = dummyElement.className;
  }
}

//for not IE
function elemSet(event, element){
  var elem = element;
  if (elem == undefined) {
     elem = event.target;
  }
  return elem;
}

var UIFComponents = {
  tabMenu: {
    init: function(doc, id){
      var type = this;
      var groupName = id;
      var tbObj = doc.getElementsByTagName("td");
      var checkGroupId = new RegExp(groupName + "_[0-9]+");
      var tdElem;
      var parentNum;
      var childNum;
      var classNames;
      var prevElem;
      var nextElem;
      var maxPage;

      for (var i = 0; i < tbObj.length; i++) {
        if (tbObj[i].id.match(checkGroupId)) {
          tdElem = doc.getElementById(tbObj[i].id);
          parentNum = parseInt(tdElem.id.replace(groupName + "_", ""), 10);
          childNum = parseInt(tdElem.id.replace(groupName + "_" + parentNum + "_", ""), 10);
          classNames = tdElem.children[0].className;
          addEventHandler(tdElem, "click", type.onclickTab);
          //Not empty tabs
          if (classNames.indexOf("empty") == -1) {
            // Depending on the type of tab, to change the style-sheet to attach.
            if (childNum == 1) {
              addEventHandler(tdElem.children[0], "focus", type.onfocusFirst);
              addEventHandler(tdElem.children[0], "blur", type.onblurFirst);
            } else if (childNum == 5) {
              addEventHandler(tdElem.children[0], "focus", type.onfocusLast);
              addEventHandler(tdElem.children[0], "blur", type.onblurLast);
            } else {
              addEventHandler(tdElem.children[0], "focus", type.onfocus);
              addEventHandler(tdElem.children[0], "blur", type.onblur);
            }
          }
          tdElem.groupName = groupName;
          maxPage = parentNum;
        }
      }
      if (maxPage == 2) {
        nextElem = doc.getElementById(groupName + "_next");
        nextElem.groupName = groupName;
        addEventHandler(nextElem, "click", type.onclickAllow);
        addEventHandler(nextElem.children[0], "focus", type.onfocusSolo);
        addEventHandler(nextElem.children[0].children[0], "focus", type.onfocusSolo);
        addEventHandler(nextElem.children[0], "blur", type.onblurSolo);
        addEventHandler(nextElem.children[0].children[0], "blur", type.onblurSolo);
      } else if (maxPage >= 3) {
        prevElem = doc.getElementById(groupName + "_prev");
        nextElem = doc.getElementById(groupName + "_next");
        prevElem.groupName = groupName;
        nextElem.groupName = groupName;
        addEventHandler(prevElem, "click", type.onclickAllow);
        addEventHandler(nextElem, "click", type.onclickAllow);
        addEventHandler(prevElem.children[0], "focus", type.onfocusPrev);
        addEventHandler(prevElem.children[0], "blur", type.onblurPrev);
        addEventHandler(nextElem.children[0], "focus", type.onfocusNext);
        addEventHandler(nextElem.children[0], "blur", type.onblurNext);
      }
    },
    onclickTab: function(event){
      var elem = event.srcElement;

      elem = elemSet(event, elem);

      var doc = elem.ownerDocument;
      var root = elem.parentNode;
      var tdObj = doc.getElementsByTagName("td");
      var selectTab;
      var groupName;
      var selectClassName;
      var checkGroupId;
      var className;
      var delClassName;
      var newClass;

      // It is countermeasure that click between table.
      if (!root.id) {
        root = elem;
      }

      selectTab = doc.getElementById(root.id);
      groupName = root.groupName;

      /*
        Delete tab, chage page, change line and space in top and bottom characters.
        Create array that characters separation array how class-name was divided space.
      */
      selectClassName = selectTab.children[0].className.replace(ALLOWED[0], "").split(ALLOWED[1]);

      for (var i = 0; i < selectClassName.length; i++) {
        if ((selectClassName[i] == "c-tab__btn--empty") || (selectClassName[i] == "c-tab__btn--selected")) {
          return false;
        }
      }

      switch (root.getAttribute('name')) {
        case "lrioud":
          top.g_currJogMode = JOGMODE.LRIOUD;
          break;
        case "rotate":
          top.g_currJogMode = JOGMODE.XYZ_Rotate;
          break;
        case "j123":
          top.g_currJogMode = JOGMODE.J123;
          break;
        case "j456":
          top.g_currJogMode = JOGMODE.J456;
          break;
        case "ex123":
          top.g_currJogMode = JOGMODE.EX123;
          break;
        case "hardkey":
          top.g_currJogMode = JOGMODE.HARDKEY;
          break;
        default:
          break;
      }

      checkGroupId = new RegExp(groupName + "_[0-9]+");
      for (i = 0; i < tdObj.length; i++) {
        if (tdObj[i].id.match(checkGroupId)) {
          className = tdObj[i].children[0].className.replace(ALLOWED[0], "").split(ALLOWED[1]);
          for (var s = 0; s < className.length; s++) {
            if (className[s] == "c-tab__btn--empty") {
              continue;
            }
            delClassName = className;
            if (className[s] == "c-tab__btn--selected") {
              delClassName.splice(s, 1);
              newClass = "";
              for (var z = 0; z < delClassName.length; z++) {
                newClass += " " + delClassName[z];
              }
              //except space.
              tdObj[i].children[0].className = newClass.replace(ALLOWED[2], "");

              selectClassName.push("c-tab__btn--selected");
              newClass = "";
              for (var zn = 0; zn < selectClassName.length; zn++) {
                newClass += " " + selectClassName[zn];
              }
              selectTab.children[0].className = newClass;
              UpdateAppearance();
              UpdateJogMode();
              return true;
            }
          }
        }
      }
    },
    onclickAllow: function(event){
      var elem = event.srcElement;

      elem = elemSet(event, elem);

      var doc = elem.ownerDocument;
      var root = elem.parentNode;
      var tdObj = doc.getElementsByTagName("td");
      var array = [];
      var min = -1;
      var max = -1;
      var disp = -1;
      var groupName;
      var allowBtnId;
      var allowBtnType;
      var checkGroupId;
      var idNum;
      var tbMove;

      //click sprite picture
      if(elem.groupName) {
        root = elem;
      } else if (root.groupName == undefined) {
        root = root.parentNode;
      }

      groupName = root.groupName;
      allowBtnId = root.id;
      allowBtnType = allowBtnId.replace(groupName + "_", "");
      checkGroupId = new RegExp(groupName + "_[0-9]+");

      for (var i = 0; i < tdObj.length; i++) {
        if (tdObj[i].id.match(checkGroupId)) {
          idNum = parseInt(tdObj[i].id.replace(groupName + "_", ""), 10);
          if (min == -1) {
            min = idNum;
          }
          if (tdObj[i].style.display == "" && disp == -1) {
            disp = idNum;
          }
          max = idNum;
          array.push(tdObj[i]);
        }
      }

      tbMove = 0;

      if (allowBtnType == "next") {
        tbMove = disp + 1;
      } else {
        tbMove = disp -1;
      }
      if (tbMove > max) {
        tbMove = min;
      } else if (tbMove < min) {
        tbMove = max;
      }

      for (i = 0; i < array.length; i++) {
        if (array[i].id.match(groupName + "_" + tbMove + ".*")) {
          array[i].style.display = "";
        } else {
          array[i].style.display = "none";
        }
      }
      return false;
    },
    onfocusFirst: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      addClasses(elem, "c-tab__btn--focus_first");
    },
    onblurFirst: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      removeClasses(elem, "c-tab__btn--focus_first");
    },
    onfocus: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      addClasses(elem, "c-tab__btn--focus");
    },
    onblur: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      removeClasses(elem, "c-tab__btn--focus");
    },
    onfocusLast: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      if (nohard_flg == true) {
        addClasses(elem, "c-tab__btn--focus_last_nohard");
      } else {
        addClasses(elem, "c-tab__btn--focus_last");
      }
    },
    onblurLast: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      if (nohard_flg == true) {
        removeClasses(elem, "c-tab__btn--focus_last_nohard");
      } else {
        removeClasses(elem, "c-tab__btn--focus_last");
      }
    },
    onfocusSolo: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      if (elem.parentNode.groupName == undefined) {
        elem = elem.parentNode;
      }
      addClasses(elem, "c-tab__btn--focus_solo");
    },
    onblurSolo: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      if (elem.parentNode.groupName == undefined) {
        elem = elem.parentNode;
      }
      removeClasses(elem, "c-tab__btn--focus_solo");
    },
    onfocusNext: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      addClasses(elem, "c-tab__btn--focus_next");
    },
    onblurNext: function(event){
      var elem = event.srcElement;
      elem = elemSet(event, elem);
      removeClasses(elem, "c-tab__btn--focus_next");
    }
  }
};

function initComponents(doc, type, id, config){ // eslint-disable-line no-unused-vars
  var vuc = UIFComponents[type];
  if (vuc !== undefined) vuc.init(doc, id, config);
}
