/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 */

var ADSTATICON_PATH = "FRH:STATUSBAR\\";

function getStatIcon() {
  $.getJSON("/COMET/rpc?func=GTFILIST&path_name=" + ADSTATICON_PATH, function(json) {
    if (json.FANUC.RPC != undefined) {
      json.FANUC.RPC[0].status = json.FANUC.RPC[0].status.toLowerCase();
      var status = json.FANUC.RPC[0].status
      var str = json.FANUC.RPC[0].value;
      getStatIconCB(status, ADSTATICON_PATH, str);
    } else {
      rpcmc_rprintf("[rpcmc] unexpected reply " + JSON.stringify(json));
    }
  });
} // get_filelist

function getStatIconCB(status, path, liststr){
  var tmpArray = [];
  //"0x2a0014" empty directory
  //"0x2000a"  nonexistent directory
  if (0x0 == status) { // Normal acquisition
    // Folder contents list
    tmpArray = liststr.split(",");
    for (var i = 0; i < tmpArray.length && liststr != ""; i++) {
      if (tmpArray[i].trim() == "" || typeof tmpArray[i].trim() == "undefined") {
        continue;
      }
      // Find xml files.
      if (tmpArray[i].trim().toLowerCase().indexOf('.xml') != -1) {
        var ajaxPath = "/"+path.replace("\\","/").replace(":","/");
        getStatIconXml(tmpArray[i].trim(), ajaxPath);
      }
    }
  }
}

function getStatIconXml(xmlName, path){
  $.ajax({
    url: path+xmlName,
    type: 'GET',
    async: false,
    cache: false,
    dataType: 'xml',
    success: function (xml) {
      var instNodeTree = $(xml).find('statusbar');
      if(instNodeTree.length == 0){
        console.log(xmlName + " does not have <statusbar>.")
        return false;
      }

      var statIcons = $(instNodeTree[0]).find('icon');
      if (statIcons.length >= 1) {
        var $statIconFrm;
        var statIconHtm = '';
        for (i = 0; i < statIcons.length; i++) {
          if (typeof statIcons[i].textContent != "undefined" && statIcons[i].textContent != "") {
            statIconHtm = statIcons[i].textContent;
            $statIconFrm = $('<iframe>', { 'id': 'statIcon_' + statIconHtm.slice(0, -4), 'class': 'addStatIcon', 'src': path + statIconHtm, 'width': '45', 'height': '45', 'scrolling': 'no' });
            $("#addIconsArea").append($statIconFrm);
            if($("#addIconsArea").css('display') == 'none'){
              $("#addIconsArea").css('display', 'inline-flex');
            }
          }
        }
        if (statIconHtm != '') {
          var statIconFrmElm = document.getElementById('statIcon_' + statIconHtm.slice(0, -4));
          statIconFrmElm.contentWindow.addEventListener('load', function () {
            for (i = 0; i < $('.addStatIcon').length; i++) {
              $('.addStatIcon').contents().find('body').css({
                'overflow': 'hidden'
              });
            }
          });
        }
      }
    },
    error: function(xhr, textStatus, errorThrown) {
      console.log(xhr);
      console.log(textStatus);
      console.log(errorThrown);
    }
  });
}