/**********************************************************************
 * Link LED (sop_linkled.js)
 * common script (set charset="UTF-8")
 * Created: 2018/11/20 FSI (Porting from pceditor_main)
 * Modified:
 */

// Use jQuery
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
*/

// The following script is necessary
// jQuery.led.js
// The following object is necessary
// jQuery.iolis (define at top)

// The following tags are required in the HTML file.
// Ex)
// 	<span id="watchAlarm"></span>
//	<span id="watchExec"></span>

var linkStatusLED = (function() {
	// === Internal variables ===
	var linkAlarmTagId = '';	// Alarm link tag ID in HTML
	var callbackLinkAlarm;	// Callback function of Alarm event.
	var resetBtnId = '';	// Reset button ID
	var linkRunTagId = '';	// Run link tag ID in HTML
	var callbackLinkRun;	// Callback function of Run event.

	// === Internal functions ===
	// Link reset button and alarm LED.
	/*
	 * linkAlarmId : Tag ID to associate with the alarm LED (<div id='xxx'>)
	 * linkAlarmBtnId : Button ID to associate with the reset button
	 * linkAlarmCallback : Callback at the fault LED status change.
	 */
	function l_initLinkAlarmLED(linkAlarmId, linkAlarmBtnId, linkAlarmCallback) {
		linkAlarmTagId = '#' + linkAlarmId;
		callbackLinkAlarm = linkAlarmCallback;
		resetBtnId = '#' + linkAlarmBtnId;
		$(linkAlarmTagId).bind('led', { ledindex: 1, ledtext: 'Fault', ledoff: 'lime', ledon: 'red' },
		// Event procedure of Alarm LED
		function(event, io_type, io_index, io_value) {
			if ((io_type == tpout_type_c) && (io_index == 1)) {
				if (io_value == 1) {
					callbackLinkAlarm(true);	// set alarm status.
					// $(resetBtnId).css({'background-color': 'rgb(230, 0, 18)', 'color': '#ffffff', 'cursor': 'pointer'});
				} else {
					callbackLinkAlarm(false);	// clear alarm status.
					$(resetBtnId).css({'background-color': '', 'color': '', 'cursor': 'default'});
				}
			}
		});
		$(linkAlarmTagId).hide();
	}
	// Link run button and run LED.
	/*
	 * linkRunId : Tag ID to associate with the run LED (<div id='xxx')
	 * linkRunCallback : Callback at the run LED status change.
	 */
	function l_initLinkRunLED(linkRunId, linkRunCallback) {
		linkRunTagId = '#' + linkRunId;
		callbackLinkRun = linkRunCallback;
		$(linkRunTagId).bind('led', { ledindex: 5, ledtext: 'Run', ledoff: 'yellow', ledon: 'lime' },
		// Event procedure of Run LED
		function(event, io_type, io_index, io_value) {
			if ((io_type == tpout_type_c) && (io_index == 5)) {
				if (io_value == 1) {
					callbackLinkRun(true);
				} else {
					callbackLinkRun(false);
				}
			}
		});
		$(linkRunTagId).hide();
	}
	// Reset Alarm status.
	function l_resetAlarmStatus() {
		top.rpcmc_sendKeyCode(reset_c);
		setTimeout(function() {}, 500);
	}
	// unbind LED On/Off
	function l_unloadLinkLED() {
		if (linkAlarmTagId.length > 0) {
			$(linkAlarmTagId).unbind('led');
		}
		if (linkRunTagId.length > 0) {
			$(linkRunTagId).unbind('led');	// unbind LED On/Off
		}
	}
	return {
		// Function to expose to the outside
		initLinkAlarm : l_initLinkAlarmLED,
		initLinkRun : l_initLinkRunLED,
		resetAlarmStatus : l_resetAlarmStatus,
		unloadLinkLED : l_unloadLinkLED
	}	// return;
})();

// Event unload.
$(window).on('unload', function(evt) {
	linkStatusLED.unloadLinkLED();
});
