/**********************************************************************
 * operatorpanel
 * lang control script
 * Created: 2018/11/16 FSI
 */

//var DBGDUMP = 5; //debug level
var resources = [];
var currentLang = null;


function initResource() {
    var lang = getCurrentLanguage()
    $.getJSON('softpanel/lang/sop_' + lang + '.jsn', function (data) {
        resources = data;
        initEachWindowResource();
    });
}

/**
 * Get lang_suffix from system variable
 */
function setCurrentLanguage(callback) {
    top.rpcmc_getVar(top.SYSNAME_C, '$DICT_CONFIG.$LANG_SUFFIX', currentLanguageCallback, callback);
}

/**
 * Current Language Callback
 * (IN) progname...SYSNAME_C,NUMREG_C
 *      varname...System Variable Name
 *      typecode...Type Code(Not Used)
 *      value...Return Value
 *      callback...CallBack(callbackarg1)
 *      cbarg2...callbackarg2(Not Used)
 */
function currentLanguageCallback(progname, varname, typecode, value, callback, cbarg2) {
    var tempLang = '';
    tempLang = value.slice(0);
    currentLang = tempLang;
    if (currentLang == 'kn') {
        currentLang = 'jp';
    } else if (currentLang != 'jp' && currentLang != 'eg' && currentLang != 'ch') {
        currentLang = 'eg';
    }
    console.log("Current Language:" + currentLang);
    callback();
}

/**
 * Get Current Language
 */
function getCurrentLanguage() {
    return currentLang;
}


/* === Resource matching table (for fixed contents) === */
/* (Generate contents resource are defined in each place.) */

var resourceEachButton = [
    // resource.
    { 'id': 'focusbar_font', 'append': 'no', 'resId': 'title' },
    { 'id': 'program_name_font', 'append': 'no', 'resId': 'programnamefont' },
    { 'id': 'program_numdig_font', 'append': 'no', 'resId': 'programnumdigfont' },
    { 'id': 'program_status_font', 'append': 'no', 'resId': 'programstatusfont' },
    { 'id': 'reset_btn_font', 'append': 'no', 'resId': 'resetbtnfont' },
    { 'id': 'config_remote_btn_font', 'append': 'no', 'resId': 'configremotebtnfont' },
    { 'id': 'config_local_btn_font', 'append': 'no', 'resId': 'configlocalbtnfont' },
    { 'id': 'cycle_start_btn_font', 'append': 'no', 'resId': 'cyclestartbtnfont' },
    { 'id': 'cycle_hold_btn_font', 'append': 'no', 'resId': 'cycleholdbtnfont' },
    { 'id': 'cycle_stop_btn_font', 'append': 'no', 'resId': 'cyclestopbtnfont' }
];

// Language Resource Initialize. (except toolbar)
function initEachWindowResource() {
    for (var i = 0; i < resourceEachButton.length; i++) {
        var rmt = resourceEachButton[i];
        var idStr = '#' + rmt.id;
        var resourceText = resources[rmt.resId];
        if (rmt.append == 'before') { // Message append to already existed text.
            resourceText = resourceText + $(idStr).html(); //	append text
        } else if (rmt.append == 'after') {
            resourceText = $(idStr).html() + resourceText; //	append text
        }
        $(idStr).html(resourceText);
    }
};