/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2011
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.tpk.js
 *  
 *  Description:
 *    TP Key plugin
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  01-JAN-2011 EVANSJA Initial version.
 *  -
*/

;(function($) {

  //  Usage
  // $('#f1').tpk({ key_code: f1_c, key_code_s: f1_s_c, tptext: 'F1', key_class: 'tpbutton_fkey' });
  //

  $.fn.tpk = function(settings) {
    $(this).bind('tpk', settings, function() { });
  };

  var tpk = $.event.special.tpk = {
    // tpk plugin defaults
    key_code: 0,
    key_code_s: 0,
    key_code_i: 0,
    key_class: 'tpbutton',
    tptext: '',
    tpimage: '',
    $this: null,

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({
        key_code: tpk.key_code,
        key_code_s: tpk.key_code_s,
        key_code_i: tpk.key_code_i,
        key_class: tpk.key_class,
        tptext: tpk.tptext,
        tpimage: tpk.tpimage,
        $this: $(this)
      }, handleObj.data || {});

      // Create button inside the element.
      var data = handleObj.data;
      data.$this.html('<button type="button" class="' + data.key_class + '">' + data.tptext + '</button>');
      if (data.tpimage != '') {
        $('button', data.$this).css('background-image', 'url("' + data.tpimage + '")');
        $('button', data.$this).css('background-position', 'center');
      }

      // Attach handler to button for click event.
      $('button', data.$this).click(function(event) {
        event.preventDefault();
        if (data.key_code > 0) {
          // Send key to controller.
          var key;
          if ($('button', '#shift').hasClass('tpshifted') || $('button', '#shift').hasClass('tpshifted_large')) {
            key = data.key_code_s;
          }
          else if ($('button', '#icon').hasClass('tpiconed')) {
            if (data.key_code_i > 0) {
              key = data.key_code_i;
            }
            else {
              key = data.key_code;
            }
          }
          else {
            key = data.key_code;
          }
          if (key > 255) {
            // Support 2 byte key codes
            top.rpcmc_tpextreq2(0, tp_focuspanel_c, key);
          }
          else {
            top.rpcmc_sendKeyCode(key);
          }
        }
        if ($('button', data.$this).hasClass('tpshift')) {
          $('button', data.$this).removeClass('tpshift');
          $('button', data.$this).addClass('tpshifted');
        }
        else if ($('button', data.$this).hasClass('tpshifted')) {
          $('button', data.$this).removeClass('tpshifted');
          $('button', data.$this).addClass('tpshift');
        }
        else if ($('button', data.$this).hasClass('tpicon')) {
          $('button', data.$this).removeClass('tpicon');
          $('button', data.$this).addClass('tpiconed');
        }
        else if ($('button', data.$this).hasClass('tpiconed')) {
          $('button', data.$this).removeClass('tpiconed');
          $('button', data.$this).addClass('tpicon');
        }
      }); // click event
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({
        key_code: tpk.key_code,
        key_code_s: tpk.key_code_s,
        key_code_i: tpk.key_code_i,
        key_class: tpk.key_class,
        tptext: tpk.tptext,
        tpimage: tpk.tpimage,
        $this: $(this)
      }, handleObj.data || {});

      // Detach all handlers for the button
      var data = handleObj.data;
      $('button', data.$this).unbind();

    } // remove
  };

})(jQuery);
