/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2014
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.tpin.js
 *  
 *  Description:
 *    Hardkey plugin which sets TPIN
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  06-JUN-2014 EVANSJA Implement Teach Pendant keys using Comm Web Server.
 *  -
*/

//  Top web page must contain the following
//  <!--#include file=frh:\jcgtp\tpin.hdr -->
//
//  Usage
//  $('#j1p').tpin({ key_name: '+J1', tptext: '+X<br>(J1)', key_class: 'tpjog' });
//

; (function ($) {

  $.fn.tpin = function (settings) {
    $(this).bind('tpin', settings, function () { });
  };

  var touch_x;
  var touch_y;
  var delta_x;
  var delta_y;

  var tpin = $.event.special.tpin = {
    // tpin plugin defaults
    key_name: '',
    key_class: 'tpbutton',
    key_value: 0,
    tptext: '',
    tpimage: '',
    $this: null,

    // Called each time an element does bind
    add: function (handleObj) {
      handleObj.data = $.extend({
        key_name: tpin.key_name,
        key_class: tpin.key_class,
        key_value: tpin.key_value,
        tptext: tpin.tptext,
        tpimage: tpin.tpimage,
        $this: $(this)
      }, handleObj.data || {});

      // Create button inside the element.
      var data = handleObj.data;
      data.$this.html('<button type="button" class="' + data.key_class + '">' + data.tptext + '</button>');
      if (data.tpimage != '') {
        $('button', data.$this).css('background-image', 'url("' + data.tpimage + '")');
        $('button', data.$this).css('background-position', 'center');
      }

      // Attach handler to button for click event.
      $('button', data.$this).click(function (event) {
        //rpcmc_rprintf('click');
        event.preventDefault();
        doClick(data);
      }); // click event

      // Attach handler to button for touchstart event.
      $('button', data.$this).bind('touchstart mousedown', function (event) {
        event.preventDefault();
        if (event.type == 'touchstart') {
          touch_x = event.originalEvent.touches[0].pageX;
          touch_y = event.originalEvent.touches[0].pageY;
          doClick(data);
        }
        //rpcmc_rprintf('touchstart ' + touch_x + ',' + touch_y);
        doPress(data);
      }); // touchstart event

      // Attach handler to button for touchend event.
      $('button', data.$this).bind('touchend mouseup', function (event) {
        //rpcmc_rprintf('touchend');
        event.preventDefault();
        doRelease(data);
      }); // touchend event

      // Attach handler to button for touchmove event.
      $('button', data.$this).bind('touchmove', function (event) {
        delta_x = event.originalEvent.touches[0].pageX;
        delta_y = event.originalEvent.touches[0].pageY;
        //rpcmc_rprintf('touchmove ' + delta_x + ',' + delta_y);
        if ((Math.abs(delta_x - touch_x) > 15) ||
          (Math.abs(delta_y - touch_y) > 15)) {
          event.preventDefault();
          doRelease(data);
        }
      }); // touchmove event

      // Attach handler to button for mouseout event.
      $('button', data.$this).mouseout(function (event) {
        //rpcmc_rprintf('mouseout');
        event.preventDefault();
        doRelease(data);
      }); // mouseup event

    }, // add

    // Called each time an element removes bind
    remove: function (handleObj) {
      handleObj.data = $.extend({
        key_name: tpin.key_name,
        key_class: tpin.key_class,
        key_value: tpin.key_value,
        tptext: tpin.tptext,
        tpimage: tpin.tpimage,
        $this: $(this)
      }, handleObj.data || {});

      // Release the key.
      var data = handleObj.data;
      if (data.key_value) {
        data.key_value = 0;
        if ($('button', data.$this).hasClass('tpenabled')) {
          // Before turning off Enable, we should release Deadman.
          // sendKey will send Enable off after a timer
          if (!(top.g_irprog && top.wait_key_open)) {
            // If the keysheet of iRProgrammer is switching, passed through.
            top.sendKey('Deadman-L', data.key_value);
          }
        }
        else {
          top.sendKey(data.key_name, data.key_value);
        }
      }

      // Detach all handlers for the button
      $('button', data.$this).unbind();

    } // remove
  };

  // Private functions
  // Button Click
  function doClick(data) {
    if ($('button', data.$this).hasClass('tpicon')) {
      $('button', data.$this).removeClass('tpicon');
      $('button', data.$this).addClass('tpiconed');
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpiconed')) {
      $('button', data.$this).removeClass('tpiconed');
      $('button', data.$this).addClass('tpicon');
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpshift')) {
      $('button', data.$this).removeClass('tpshift');
      $('button', data.$this).addClass('tpshifted');
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpshifted')) {
      $('button', data.$this).removeClass('tpshifted');
      $('button', data.$this).addClass('tpshift');
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpenable')) {
      $('button', data.$this).removeClass('tpenable');
      $('button', data.$this).addClass('tpenabled');
      $('button', data.$this).css('background-image', 'url("tpenon.gif")');
      // FSI 20181015
      if (data.tpimage == 'off_switch.png') {
        $('button', data.$this).css('background-image', 'url("on_switch.png")');
      } else {
        $('button', data.$this).css('background-image', 'url("tpenon.gif")');
      }
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
      // sendKey will press Deadman, after turning on Enable
      if (top.g_irprog) {
        // Prevent tp-button bashing.
        $("#tpen").css({ "pointer-events": "none" });
        setTimeout(function () {
          $("#tpen").css({ "pointer-events": "auto" });
        }, 500);
      }
    }
    else if ($('button', data.$this).hasClass('tpenabled')) {
      $('button', data.$this).removeClass('tpenabled');
      $('button', data.$this).addClass('tpenable');
      $('button', data.$this).css('background-image', 'url("tpenoff.gif")');
      // FSI 20181015
      if (data.tpimage == 'on_switch.png') {
        $('button', data.$this).css('background-image', 'url("off_switch.png")');
      } else {
        $('button', data.$this).css('background-image', 'url("tpenoff.gif")');
      }
      // Before turning off Enable, we should release Deadman.
      // sendKey will send Enable off after a timer
      data.key_value = 0;
      top.sendKey('Deadman-L', data.key_value);
      if (top.g_irprog) {
        // Prevent tp-button bashing.
        $("#tpen").css({ "pointer-events": "none" });
        setTimeout(function () {
          $("#tpen").css({ "pointer-events": "auto" });
        }, 500);
      }
    }
  } // doClick

  // Button Press
  function doPress(data) {
    if ($('button', data.$this).hasClass('tpmotion')) {
      $('button', data.$this).removeClass('tpmotion');
      $('button', data.$this).addClass('tpmotiondown');
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tphold')) {
      $('button', data.$this).removeClass('tphold');
      $('button', data.$this).addClass('tpholddown');
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpreset')) {
      $('button', data.$this).removeClass('tpreset');
      $('button', data.$this).addClass('tpresetdown');
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpjog')) {
      $('button', data.$this).removeClass('tpjog');
      $('button', data.$this).addClass('tpjogdown');
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpbutton')) {
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpbutton_fkey')) {	
      data.key_value = 1;
      top.sendKey(data.key_name, data.key_value);
    }
  } // doPress

  // Button Release
  function doRelease(data) {
    if ($('button', data.$this).hasClass('tpmotiondown')) {
      $('button', data.$this).removeClass('tpmotiondown');
      $('button', data.$this).addClass('tpmotion');
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpholddown')) {
      $('button', data.$this).removeClass('tpholddown');
      $('button', data.$this).addClass('tphold');
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpresetdown')) {
      $('button', data.$this).removeClass('tpresetdown');
      $('button', data.$this).addClass('tpreset');
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpjogdown')) {
      $('button', data.$this).removeClass('tpjogdown');
      $('button', data.$this).addClass('tpjog');
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpbutton')) {
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }
    else if ($('button', data.$this).hasClass('tpbutton_fkey')) {
      data.key_value = 0;
      top.sendKey(data.key_name, data.key_value);
    }   
  } // doRelease

})(jQuery);
