/*
 *  This material is the joint property of FANUC Robotics America  and
 *  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
 *  America or FANUC LTD Japan immediately upon request.  This material  and
 *  the  information  illustrated or contained herein may not be reproduced,
 *  copied, used, or transmitted in whole or in part in any way without  the
 *  prior written consent of both FANUC Robotics America and FANUC LTD
 *  Japan.
 *  
 *           All Rights Reserved
 *           Copyright (C)   2011
 *           FANUC Robotics America
 *           FANUC LTD Japan
 * 
 *  +
 *  Module: jquery.ovr.js
 *  
 *  Description:
 *    Override plugin
 *
 *  Author: Judy Evans
 *          FANUC Robotics America
 *          3900 W. Hamlin Road
 *          Rochester Hills, Michigan    48309-3253
 *  
 *  Modification history:
 *  01-JAN-2011 EVANSJA Initial version.
 *  04-JAN-2017 EVANSJA Change design.
 *  20-APR-2017 T.OKAMOTO Add ZeroOvrd Case. 0% is displayed as the override when $mcr.$ovr_zero = TRUE.
 *  19-JAN-2018 EVANSJA All monitors should be in upper case to avoid duplicates.
 *  12-NOV-2018 EVANSJA pr51132c.  Use top.srvap_getString since srvap.js has been moved to top web page.
 *  -
*/

;(function($) {

//	Use these properties to customize settings...
//	$.event.special.led.var1 = '$mcr.$genoverride';
//	$.event.special.led.var2 = '$mcr.$jog_fine';
//	$.event.special.led.var3 = '$mcr.$jog_v_fine';
// 
//  Usage, using defaults
//  $('#ovr1').ovr();
//
//  Usage, specify parameters
//  $('#ovr1').ovr({ var1: '$mcr.$genoverride',
//                   var2: '$mcr.$jog_fine',
//                   var3: '$mcr.$jog_v_fine' });
//
//
$.fn.ovr = function(settings) {
    $(this).bind('ovr', settings, function() { });
  };

  var SYSNAME_C = "*SYSTEM*";
  var ovr = $.event.special.ovr = {
    // Override plugin defaults
    var1: '$MCR.$GENOVERRIDE',
    var2: '$MCR.$JOG_FINE',
    var3: '$MCR.$JOG_V_FINE',
    var4: '$MCR.$OVR_ZERO',
    var1_value: 0,
    var2_value: 'FALSE',
    var3_value: 'FALSE',
    var4_value: 'FALSE',
    $this: null,

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({
        var1: ovr.var1,
        var2: ovr.var2,
        var3: ovr.var3,
        var4: ovr.var4,
        var1_value: ovr.var1_value,
        var2_value: ovr.var2_value,
        var3_value: ovr.var3_value,
        var4_value: ovr.var4_value,
        $this: $(this)
      }, handleObj.data || {});

      var data = handleObj.data;
      data.$this.css("font-family", top.getDefFont());

      // Create divs inside the element.
      data.$this.html('<div id="ovr1" /><div id="ovr2" />');

      if (top.jQuery.varlis) {

        // Attach handler for VarEvent.
        top.jQuery.varlis.bind('VarEvent', data, HandleVarEvent);

        // Attach handler for SetLangEvent.
        top.jQuery.dictlis.bind('SetLangEvent', data, HandleDictEvent);

        // Start PMON monitors for vars.
        top.rpcmc_startVarMonitor(SYSNAME_C, data.var1, 20);
        top.rpcmc_startVarMonitor(SYSNAME_C, data.var2, 20);
        top.rpcmc_startVarMonitor(SYSNAME_C, data.var3, 20);
        top.rpcmc_startVarMonitor(SYSNAME_C, data.var4, 20);
      }
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({
        var1: ovr.var1,
        var2: ovr.var2,
        var3: ovr.var3,
        var4: ovr.var4,
        var1_value: ovr.var1_value,
        var2_value: ovr.var2_value,
        var3_value: ovr.var3_value,
        var4_value: ovr.var4_value,
        $this: $(this)
      }, handleObj.data || {});

      var data = handleObj.data;
      if (top.jQuery.varlis) {
        // Stop PMON monitors for vars.
        top.rpcmc_stopVarMonitor(SYSNAME_C, data.var1);
        top.rpcmc_stopVarMonitor(SYSNAME_C, data.var2);
        top.rpcmc_stopVarMonitor(SYSNAME_C, data.var3);
        top.rpcmc_stopVarMonitor(SYSNAME_C, data.var4);

        // Detach handler for VarEvent.
        top.jQuery.varlis.unbind('VarEvent', HandleVarEvent);

        // Detach handler for SetLangEvent.
        top.jQuery.dictlis.unbind('SetLangEvent', HandleDictEvent);
      }
    } // remove
  };

  // Private functions

  function HandleVarEvent(event, prog_name, var_name, type_code, value) {
    var data = event.data || event;
    var repaint = false;
    if (var_name == data.var1) {
      data.var1_value = value;
      repaint = true;
    }
    else if (var_name == data.var4) {
      data.var4_value = value;
      repaint = true;
    }
    else if (var_name == data.var2) {
      data.var2_value = value;
      repaint = true;
    }
    else if (var_name == data.var3) {
      data.var3_value = value;
      repaint = true;
    }
    if (repaint) {
      if (data.var4_value == 'TRUE') {
        ZeroOvr(data);
      }
      else if (data.var2_value == 'TRUE') {
        JogFine(data);
      }
      else if (data.var3_value == 'TRUE') {
        JogVFine(data);
      }
      else {
        ChangeValue(data);
      }
    }
  } // HandleVarEvent

  function ChangeValue(data) {
    $('#ovr1', data.$this).removeClass('ovr1_text');
    $('#ovr1', data.$this).addClass('ovr1_value');
    $('#ovr1', data.$this).html(data.var1_value);
    $('#ovr2', data.$this).html('%');
  } // ChangeValue

  function JogFine(data) {
    // Display localized version of FINE
    $('#ovr1', data.$this).removeClass('ovr1_value');
    $('#ovr1', data.$this).addClass('ovr1_text');
    $('#ovr1', data.$this).html(top.srvap_getString('FINE'));
    $('#ovr2', data.$this).html('');
  } // JogFine

  function JogVFine(data) {
    // Display localized version of VFINE
    $('#ovr1', data.$this).removeClass('ovr1_value');
    $('#ovr1', data.$this).addClass('ovr1_text');
    $('#ovr1', data.$this).html(top.srvap_getString('VFINE'));
    $('#ovr2', data.$this).html('');
  } // JogVFine

  function ZeroOvr(data) {
    // Display 0% OVRD
    $('#ovr1', data.$this).removeClass('ovr1_text');
    $('#ovr1', data.$this).addClass('ovr1_value');
    $('#ovr1', data.$this).html(0);
    $('#ovr2', data.$this).html('%');
  } // ZeroOvr

  function HandleDictEvent(event) {
    var data = event.data || event;
    // Change the font-family
    data.$this.css("font-family", top.getDefFont());

    // Change the text.
    if (data.var2_value == 'TRUE') {
      JogFine(data);
    }
    else if (data.var3_value == 'TRUE') {
      JogVFine(data);
    }
  } // HandleDictEvent

})(jQuery);
