/*
*  This material is the joint property of FANUC Robotics America  and
*  FANUC  LTD  Japan,  and  must be returned to either FANUC Robotics 
*  America or FANUC LTD Japan immediately upon request.  This material  and
*  the  information  illustrated or contained herein may not be reproduced,
*  copied, used, or transmitted in whole or in part in any way without  the
*  prior written consent of both FANUC Robotics America and FANUC LTD
*  Japan.
*  
*           All Rights Reserved
*           Copyright (C)   2011
*           FANUC Robotics America
*           FANUC LTD Japan
* 
*  +
*  Module: jquery.cmd.js
*  
*  Description:
*    Command button plugin
*
*  Author: Genevieve Flaspohler
*          FANUC Robotics America
*          3900 W. Hamlin Road
*          Rochester Hills, Michigan    48309-3253
*  
*  Modification history:
*  20-JUN-2014 FLASPOGE Initial version.
*  -
*/

; (function($) {

  //	Use these properties to customize settings...
  //	$.event.special.cmd.cmdtype = tpout_type_c;
  //  $.event.special.cmd.cmdindex: 7;
  //  cmdonimg: '/frh/jcgtp/lglmp_on.gif', //Defaults to Green LED
  //  cmdoffimg: '/frh/jcgtp/lglmp_of.gif'
  // 
  //  No callback function, using defaults
  //  $('#cmd6').cmd();
  //
  //  No callback functions, specify parameters
  //  $('#cmd6').cmd({ cmdtype: tpout_type_c,
  //                   cmdindex: 5,
  //                   cmdonimg: '/frh/jcgtp/lglmp_on.gif',
  //                   cmdoffimg: '/frh/jcgtp/lglmp_of.gif'
  //                   cmdfunc: 'start',
  //                   cmdstring: '/SMONDO/RUNPC%20RUNPRG', });
  //
  //  Callback function, using defaults
  //  $('#cmd6').bind('cmd', function(event, io_type, io_index, io_value) {});
  //
  //  Callback functions, specify parameters
  //  $('#cmd6').bind('cmd', { cmdtype: tpout_type_c,
  //                           cmdindex: 5,
  //  $('#cmd6').cmd({ cmdtype: tpout_type_c,
  //                   cmdindex: 5,
  //                   cmdonimg: '/frh/jcgtp/lglmp_on.gif', //Defaults to Green LED
  //                   cmdoffimg: '/frh/jcgtp/lglmp_of.gif'
  //                   cmdfunc: 'start',
  //                   cmdstring: '/SMONDO/RUNPC%20RUNPRG',
  //                   function(event, io_type, io_index, io_value) {});
  //

  $.fn.cmd = function(settings) {
    $(this).bind('cmd', settings,
      function(event, io_type, io_index, io_value) { });
  };

  $.ajaxSetup({
    // Disable caching of AJAX responses */
    cache: false

  });

  var cmd = $.event.special.cmd = {
    // cmd plugin defaults
    cmdtype: tpout_type_c,
    cmdindex: 5,
    cmdonimg: '/frh/jcgtp/lglmp_on.gif', //Defaults to Green LED
    cmdoffimg: '/frh/jcgtp/lglmp_of.gif',
    cmdfunc: 'start',
    cmdstring: '/SMONDO/RUNPC%20RUNPRG',
    $this: null,

    // Called each time an element does bind
    add: function(handleObj) {
      handleObj.data = $.extend({
        cmdtype: cmd.cmdtype,
        cmdindex: cmd.cmdindex,
        cmdonimg: cmd.cmdonimg,
        cmdoffimg: cmd.cmdoffimg,
        cmdfunc: cmd.cmdfunc,
        cmdstring: cmd.cmdstring,
        $this: $(this)
      }, handleObj.data || {});

      // Create img and text inside the element.
      var data = handleObj.data;
      CMDOffState(data);

      $(this).click(function() {
        $.getJSON(data.cmdstring, function(json) {});
        return false;
      });

      if (data.cmdtype) {
        if (top.jQuery.iolis) {
          // Attach handler for IOBooleanEvent.
          top.jQuery.iolis.bind('IOBooleanEvent', data, HandleIOEvent);

          // Start PMON monitor for the I/O port.
          top.rpcmc_startIOMonitor(data.cmdtype, data.cmdindex);
        }
      }
    }, // add

    // Called each time an element removes bind
    remove: function(handleObj) {
      handleObj.data = $.extend({
        cmdtype: cmd.cmdtype,
        cmdindex: cmd.cmdindex,
        cmdonimg: cmd.cmdonimg,
        cmdoffimg: cmd.cmdoffimg,
        cmdfunc: cmd.cmdfunc,
        cmdstring: cmd.cmdstring,
        $this: $(this)
      }, handleObj.data || {});

      var data = handleObj.data;
      if (data.cmdtype) {
        if (top.jQuery.iolis) {
          // Stop PMON monitor for the I/O port.
          top.rpcmc_stopIOMonitor(data.cmdtype, data.cmdindex);

          // Detach handler for IOBooleanEvent.
          top.jQuery.iolis.unbind('IOBooleanEvent', HandleIOEvent);
        }
      }
    } // remove
  };

  // Private functions
  function CMDOffState(data) {
    if (data.cmdoffimg != '') {
      var off = '<img src="' + data.cmdoffimg + '" />';
      data.$this.html(off);
    }
  } // LEDOffState

  function CMDOnState(data) {
    if (data.cmdonimg != '') {
      var on = '<img src="' + data.cmdonimg + '" />';
      data.$this.html(on);
    }
  } // LEDOnState

  function HandleIOEvent(event, io_type, io_index, io_value) {
    var data = event.data || event;
    if ((io_type == data.cmdtype) && (io_index == data.cmdindex)) {
      // We have a match.
      if (io_value == 0) {
        if (data.cmdfunc == 'start') {
          CMDOffState(data);
        }
        else { //If cmdfunc == 'stop'
          CMDOnState(data);
        }
      }
      else {
        if (data.cmdfunc == 'start') {
          CMDOnState(data);
        }
        else { //If cmdfunc == 'stop'
          CMDOffState(data);
        }
      }
      // Trigger a callback for the element.
      data.$this.triggerHandler('cmd', [io_type, io_index, io_value]);
    }
  } // HandleIOEvent
  //it was here

})(jQuery);